# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._inputs import *

__all__ = ['HybridAksClusterArgs', 'HybridAksCluster']

@pulumi.input_type
class HybridAksClusterArgs:
    def __init__(__self__, *,
                 associated_network_ids: pulumi.Input[Sequence[pulumi.Input[str]]],
                 control_plane_count: pulumi.Input[float],
                 extended_location: pulumi.Input['ExtendedLocationArgs'],
                 hybrid_aks_provisioned_cluster_id: pulumi.Input[str],
                 resource_group_name: pulumi.Input[str],
                 worker_count: pulumi.Input[float],
                 hybrid_aks_cluster_name: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a HybridAksCluster resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] associated_network_ids: The list of resource IDs for the workload networks associated with the Hybrid AKS cluster. It can be any of l2Networks, l3Networks, or trunkedNetworks resources. This field will also contain one cloudServicesNetwork and one defaultCniNetwork.
        :param pulumi.Input[float] control_plane_count: The number of control plane node VMs.
        :param pulumi.Input['ExtendedLocationArgs'] extended_location: The extended location of the cluster associated with the resource.
        :param pulumi.Input[str] hybrid_aks_provisioned_cluster_id: The resource ID of the Hybrid AKS cluster that this additional information is for.
        :param pulumi.Input[str] resource_group_name: The name of the resource group. The name is case insensitive.
        :param pulumi.Input[float] worker_count: The number of worker node VMs.
        :param pulumi.Input[str] hybrid_aks_cluster_name: The name of the Hybrid AKS cluster.
        :param pulumi.Input[str] location: The geo-location where the resource lives
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Resource tags.
        """
        pulumi.set(__self__, "associated_network_ids", associated_network_ids)
        pulumi.set(__self__, "control_plane_count", control_plane_count)
        pulumi.set(__self__, "extended_location", extended_location)
        pulumi.set(__self__, "hybrid_aks_provisioned_cluster_id", hybrid_aks_provisioned_cluster_id)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "worker_count", worker_count)
        if hybrid_aks_cluster_name is not None:
            pulumi.set(__self__, "hybrid_aks_cluster_name", hybrid_aks_cluster_name)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="associatedNetworkIds")
    def associated_network_ids(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The list of resource IDs for the workload networks associated with the Hybrid AKS cluster. It can be any of l2Networks, l3Networks, or trunkedNetworks resources. This field will also contain one cloudServicesNetwork and one defaultCniNetwork.
        """
        return pulumi.get(self, "associated_network_ids")

    @associated_network_ids.setter
    def associated_network_ids(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "associated_network_ids", value)

    @property
    @pulumi.getter(name="controlPlaneCount")
    def control_plane_count(self) -> pulumi.Input[float]:
        """
        The number of control plane node VMs.
        """
        return pulumi.get(self, "control_plane_count")

    @control_plane_count.setter
    def control_plane_count(self, value: pulumi.Input[float]):
        pulumi.set(self, "control_plane_count", value)

    @property
    @pulumi.getter(name="extendedLocation")
    def extended_location(self) -> pulumi.Input['ExtendedLocationArgs']:
        """
        The extended location of the cluster associated with the resource.
        """
        return pulumi.get(self, "extended_location")

    @extended_location.setter
    def extended_location(self, value: pulumi.Input['ExtendedLocationArgs']):
        pulumi.set(self, "extended_location", value)

    @property
    @pulumi.getter(name="hybridAksProvisionedClusterId")
    def hybrid_aks_provisioned_cluster_id(self) -> pulumi.Input[str]:
        """
        The resource ID of the Hybrid AKS cluster that this additional information is for.
        """
        return pulumi.get(self, "hybrid_aks_provisioned_cluster_id")

    @hybrid_aks_provisioned_cluster_id.setter
    def hybrid_aks_provisioned_cluster_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "hybrid_aks_provisioned_cluster_id", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[str]:
        """
        The name of the resource group. The name is case insensitive.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="workerCount")
    def worker_count(self) -> pulumi.Input[float]:
        """
        The number of worker node VMs.
        """
        return pulumi.get(self, "worker_count")

    @worker_count.setter
    def worker_count(self, value: pulumi.Input[float]):
        pulumi.set(self, "worker_count", value)

    @property
    @pulumi.getter(name="hybridAksClusterName")
    def hybrid_aks_cluster_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Hybrid AKS cluster.
        """
        return pulumi.get(self, "hybrid_aks_cluster_name")

    @hybrid_aks_cluster_name.setter
    def hybrid_aks_cluster_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hybrid_aks_cluster_name", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        The geo-location where the resource lives
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


class HybridAksCluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 associated_network_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 control_plane_count: Optional[pulumi.Input[float]] = None,
                 extended_location: Optional[pulumi.Input[pulumi.InputType['ExtendedLocationArgs']]] = None,
                 hybrid_aks_cluster_name: Optional[pulumi.Input[str]] = None,
                 hybrid_aks_provisioned_cluster_id: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 worker_count: Optional[pulumi.Input[float]] = None,
                 __props__=None):
        """
        The details are specific to the Network Cloud use of the Hybrid AKS cluster.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] associated_network_ids: The list of resource IDs for the workload networks associated with the Hybrid AKS cluster. It can be any of l2Networks, l3Networks, or trunkedNetworks resources. This field will also contain one cloudServicesNetwork and one defaultCniNetwork.
        :param pulumi.Input[float] control_plane_count: The number of control plane node VMs.
        :param pulumi.Input[pulumi.InputType['ExtendedLocationArgs']] extended_location: The extended location of the cluster associated with the resource.
        :param pulumi.Input[str] hybrid_aks_cluster_name: The name of the Hybrid AKS cluster.
        :param pulumi.Input[str] hybrid_aks_provisioned_cluster_id: The resource ID of the Hybrid AKS cluster that this additional information is for.
        :param pulumi.Input[str] location: The geo-location where the resource lives
        :param pulumi.Input[str] resource_group_name: The name of the resource group. The name is case insensitive.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Resource tags.
        :param pulumi.Input[float] worker_count: The number of worker node VMs.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: HybridAksClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The details are specific to the Network Cloud use of the Hybrid AKS cluster.

        :param str resource_name: The name of the resource.
        :param HybridAksClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(HybridAksClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 associated_network_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 control_plane_count: Optional[pulumi.Input[float]] = None,
                 extended_location: Optional[pulumi.Input[pulumi.InputType['ExtendedLocationArgs']]] = None,
                 hybrid_aks_cluster_name: Optional[pulumi.Input[str]] = None,
                 hybrid_aks_provisioned_cluster_id: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 worker_count: Optional[pulumi.Input[float]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = HybridAksClusterArgs.__new__(HybridAksClusterArgs)

            if associated_network_ids is None and not opts.urn:
                raise TypeError("Missing required property 'associated_network_ids'")
            __props__.__dict__["associated_network_ids"] = associated_network_ids
            if control_plane_count is None and not opts.urn:
                raise TypeError("Missing required property 'control_plane_count'")
            __props__.__dict__["control_plane_count"] = control_plane_count
            if extended_location is None and not opts.urn:
                raise TypeError("Missing required property 'extended_location'")
            __props__.__dict__["extended_location"] = extended_location
            __props__.__dict__["hybrid_aks_cluster_name"] = hybrid_aks_cluster_name
            if hybrid_aks_provisioned_cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'hybrid_aks_provisioned_cluster_id'")
            __props__.__dict__["hybrid_aks_provisioned_cluster_id"] = hybrid_aks_provisioned_cluster_id
            __props__.__dict__["location"] = location
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["tags"] = tags
            if worker_count is None and not opts.urn:
                raise TypeError("Missing required property 'worker_count'")
            __props__.__dict__["worker_count"] = worker_count
            __props__.__dict__["cloud_services_network_id"] = None
            __props__.__dict__["cluster_id"] = None
            __props__.__dict__["control_plane_nodes"] = None
            __props__.__dict__["default_cni_network_id"] = None
            __props__.__dict__["detailed_status"] = None
            __props__.__dict__["detailed_status_message"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["provisioning_state"] = None
            __props__.__dict__["system_data"] = None
            __props__.__dict__["type"] = None
            __props__.__dict__["volumes"] = None
            __props__.__dict__["worker_nodes"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="azure-native:networkcloud:HybridAksCluster")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(HybridAksCluster, __self__).__init__(
            'azure-native:networkcloud/v20221212preview:HybridAksCluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'HybridAksCluster':
        """
        Get an existing HybridAksCluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = HybridAksClusterArgs.__new__(HybridAksClusterArgs)

        __props__.__dict__["associated_network_ids"] = None
        __props__.__dict__["cloud_services_network_id"] = None
        __props__.__dict__["cluster_id"] = None
        __props__.__dict__["control_plane_count"] = None
        __props__.__dict__["control_plane_nodes"] = None
        __props__.__dict__["default_cni_network_id"] = None
        __props__.__dict__["detailed_status"] = None
        __props__.__dict__["detailed_status_message"] = None
        __props__.__dict__["extended_location"] = None
        __props__.__dict__["hybrid_aks_provisioned_cluster_id"] = None
        __props__.__dict__["location"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["provisioning_state"] = None
        __props__.__dict__["system_data"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["type"] = None
        __props__.__dict__["volumes"] = None
        __props__.__dict__["worker_count"] = None
        __props__.__dict__["worker_nodes"] = None
        return HybridAksCluster(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="associatedNetworkIds")
    def associated_network_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        The list of resource IDs for the workload networks associated with the Hybrid AKS cluster. It can be any of l2Networks, l3Networks, or trunkedNetworks resources. This field will also contain one cloudServicesNetwork and one defaultCniNetwork.
        """
        return pulumi.get(self, "associated_network_ids")

    @property
    @pulumi.getter(name="cloudServicesNetworkId")
    def cloud_services_network_id(self) -> pulumi.Output[str]:
        """
        The resource ID of the associated cloud services network.
        """
        return pulumi.get(self, "cloud_services_network_id")

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Output[str]:
        """
        The resource ID of the Network Cloud cluster hosting the Hybrid AKS cluster.
        """
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter(name="controlPlaneCount")
    def control_plane_count(self) -> pulumi.Output[float]:
        """
        The number of control plane node VMs.
        """
        return pulumi.get(self, "control_plane_count")

    @property
    @pulumi.getter(name="controlPlaneNodes")
    def control_plane_nodes(self) -> pulumi.Output[Sequence['outputs.NodeConfigurationResponse']]:
        """
        The list of node configurations detailing associated VMs that are part of the control plane nodes of this Hybrid AKS cluster.
        """
        return pulumi.get(self, "control_plane_nodes")

    @property
    @pulumi.getter(name="defaultCniNetworkId")
    def default_cni_network_id(self) -> pulumi.Output[str]:
        """
        The resource ID of the associated default CNI network.
        """
        return pulumi.get(self, "default_cni_network_id")

    @property
    @pulumi.getter(name="detailedStatus")
    def detailed_status(self) -> pulumi.Output[str]:
        """
        The more detailed status of this Hybrid AKS cluster.
        """
        return pulumi.get(self, "detailed_status")

    @property
    @pulumi.getter(name="detailedStatusMessage")
    def detailed_status_message(self) -> pulumi.Output[str]:
        """
        The descriptive message about the current detailed status.
        """
        return pulumi.get(self, "detailed_status_message")

    @property
    @pulumi.getter(name="extendedLocation")
    def extended_location(self) -> pulumi.Output['outputs.ExtendedLocationResponse']:
        """
        The extended location of the cluster associated with the resource.
        """
        return pulumi.get(self, "extended_location")

    @property
    @pulumi.getter(name="hybridAksProvisionedClusterId")
    def hybrid_aks_provisioned_cluster_id(self) -> pulumi.Output[str]:
        """
        The resource ID of the Hybrid AKS cluster that this additional information is for.
        """
        return pulumi.get(self, "hybrid_aks_provisioned_cluster_id")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        """
        The geo-location where the resource lives
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> pulumi.Output[str]:
        """
        The provisioning state of the Hybrid AKS cluster resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="systemData")
    def system_data(self) -> pulumi.Output['outputs.SystemDataResponse']:
        """
        Azure Resource Manager metadata containing createdBy and modifiedBy information.
        """
        return pulumi.get(self, "system_data")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def volumes(self) -> pulumi.Output[Sequence[str]]:
        """
        The resource IDs of volumes that are attached to the Hybrid AKS cluster.
        """
        return pulumi.get(self, "volumes")

    @property
    @pulumi.getter(name="workerCount")
    def worker_count(self) -> pulumi.Output[float]:
        """
        The number of worker node VMs.
        """
        return pulumi.get(self, "worker_count")

    @property
    @pulumi.getter(name="workerNodes")
    def worker_nodes(self) -> pulumi.Output[Sequence['outputs.NodeConfigurationResponse']]:
        """
        The list of node configurations detailing associated VMs that are part of the worker nodes of this Hybrid AKS cluster.
        """
        return pulumi.get(self, "worker_nodes")

