# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'ApplicationPackageReferenceArgs',
    'AutoScaleSettingsArgs',
    'AutoStorageBasePropertiesArgs',
    'AutoUserSpecificationArgs',
    'AzureBlobFileSystemConfigurationArgs',
    'AzureFileShareConfigurationArgs',
    'CIFSMountConfigurationArgs',
    'CertificateReferenceArgs',
    'CloudServiceConfigurationArgs',
    'ContainerConfigurationArgs',
    'ContainerRegistryArgs',
    'DataDiskArgs',
    'DeploymentConfigurationArgs',
    'DiskEncryptionConfigurationArgs',
    'EncryptionPropertiesArgs',
    'EnvironmentSettingArgs',
    'FixedScaleSettingsArgs',
    'ImageReferenceArgs',
    'InboundNatPoolArgs',
    'KeyVaultPropertiesArgs',
    'KeyVaultReferenceArgs',
    'LinuxUserConfigurationArgs',
    'MetadataItemArgs',
    'MountConfigurationArgs',
    'NFSMountConfigurationArgs',
    'NetworkConfigurationArgs',
    'NetworkSecurityGroupRuleArgs',
    'PoolEndpointConfigurationArgs',
    'PublicIPAddressConfigurationArgs',
    'ResourceFileArgs',
    'ScaleSettingsArgs',
    'StartTaskArgs',
    'TaskContainerSettingsArgs',
    'TaskSchedulingPolicyArgs',
    'UserAccountArgs',
    'UserIdentityArgs',
    'VirtualMachineConfigurationArgs',
    'WindowsConfigurationArgs',
    'WindowsUserConfigurationArgs',
]

@pulumi.input_type
class ApplicationPackageReferenceArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[str],
                 version: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] version: If this is omitted, and no default version is specified for this application, the request fails with the error code InvalidApplicationPackageReferences. If you are calling the REST API directly, the HTTP status code is 409.
        """
        pulumi.set(__self__, "id", id)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        If this is omitted, and no default version is specified for this application, the request fails with the error code InvalidApplicationPackageReferences. If you are calling the REST API directly, the HTTP status code is 409.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class AutoScaleSettingsArgs:
    def __init__(__self__, *,
                 formula: pulumi.Input[str],
                 evaluation_interval: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] evaluation_interval: If omitted, the default value is 15 minutes (PT15M).
        """
        pulumi.set(__self__, "formula", formula)
        if evaluation_interval is not None:
            pulumi.set(__self__, "evaluation_interval", evaluation_interval)

    @property
    @pulumi.getter
    def formula(self) -> pulumi.Input[str]:
        return pulumi.get(self, "formula")

    @formula.setter
    def formula(self, value: pulumi.Input[str]):
        pulumi.set(self, "formula", value)

    @property
    @pulumi.getter(name="evaluationInterval")
    def evaluation_interval(self) -> Optional[pulumi.Input[str]]:
        """
        If omitted, the default value is 15 minutes (PT15M).
        """
        return pulumi.get(self, "evaluation_interval")

    @evaluation_interval.setter
    def evaluation_interval(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "evaluation_interval", value)


@pulumi.input_type
class AutoStorageBasePropertiesArgs:
    def __init__(__self__, *,
                 storage_account_id: pulumi.Input[str]):
        """
        The properties related to the auto-storage account.
        :param pulumi.Input[str] storage_account_id: The resource ID of the storage account to be used for auto-storage account.
        """
        pulumi.set(__self__, "storage_account_id", storage_account_id)

    @property
    @pulumi.getter(name="storageAccountId")
    def storage_account_id(self) -> pulumi.Input[str]:
        """
        The resource ID of the storage account to be used for auto-storage account.
        """
        return pulumi.get(self, "storage_account_id")

    @storage_account_id.setter
    def storage_account_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "storage_account_id", value)


@pulumi.input_type
class AutoUserSpecificationArgs:
    def __init__(__self__, *,
                 elevation_level: Optional[pulumi.Input['ElevationLevel']] = None,
                 scope: Optional[pulumi.Input['AutoUserScope']] = None):
        """
        :param pulumi.Input['ElevationLevel'] elevation_level: The default value is nonAdmin.
        :param pulumi.Input['AutoUserScope'] scope: The default value is Pool. If the pool is running Windows a value of Task should be specified if stricter isolation between tasks is required. For example, if the task mutates the registry in a way which could impact other tasks, or if certificates have been specified on the pool which should not be accessible by normal tasks but should be accessible by start tasks.
        """
        if elevation_level is not None:
            pulumi.set(__self__, "elevation_level", elevation_level)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)

    @property
    @pulumi.getter(name="elevationLevel")
    def elevation_level(self) -> Optional[pulumi.Input['ElevationLevel']]:
        """
        The default value is nonAdmin.
        """
        return pulumi.get(self, "elevation_level")

    @elevation_level.setter
    def elevation_level(self, value: Optional[pulumi.Input['ElevationLevel']]):
        pulumi.set(self, "elevation_level", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input['AutoUserScope']]:
        """
        The default value is Pool. If the pool is running Windows a value of Task should be specified if stricter isolation between tasks is required. For example, if the task mutates the registry in a way which could impact other tasks, or if certificates have been specified on the pool which should not be accessible by normal tasks but should be accessible by start tasks.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input['AutoUserScope']]):
        pulumi.set(self, "scope", value)


@pulumi.input_type
class AzureBlobFileSystemConfigurationArgs:
    def __init__(__self__, *,
                 account_name: pulumi.Input[str],
                 container_name: pulumi.Input[str],
                 relative_mount_path: pulumi.Input[str],
                 account_key: Optional[pulumi.Input[str]] = None,
                 blobfuse_options: Optional[pulumi.Input[str]] = None,
                 sas_key: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] relative_mount_path: All file systems are mounted relative to the Batch mounts directory, accessible via the AZ_BATCH_NODE_MOUNTS_DIR environment variable.
        :param pulumi.Input[str] account_key: This property is mutually exclusive with sasKey and one must be specified.
        :param pulumi.Input[str] blobfuse_options: These are 'net use' options in Windows and 'mount' options in Linux.
        :param pulumi.Input[str] sas_key: This property is mutually exclusive with accountKey and one must be specified.
        """
        pulumi.set(__self__, "account_name", account_name)
        pulumi.set(__self__, "container_name", container_name)
        pulumi.set(__self__, "relative_mount_path", relative_mount_path)
        if account_key is not None:
            pulumi.set(__self__, "account_key", account_key)
        if blobfuse_options is not None:
            pulumi.set(__self__, "blobfuse_options", blobfuse_options)
        if sas_key is not None:
            pulumi.set(__self__, "sas_key", sas_key)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> pulumi.Input[str]:
        return pulumi.get(self, "account_name")

    @account_name.setter
    def account_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "account_name", value)

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> pulumi.Input[str]:
        return pulumi.get(self, "container_name")

    @container_name.setter
    def container_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "container_name", value)

    @property
    @pulumi.getter(name="relativeMountPath")
    def relative_mount_path(self) -> pulumi.Input[str]:
        """
        All file systems are mounted relative to the Batch mounts directory, accessible via the AZ_BATCH_NODE_MOUNTS_DIR environment variable.
        """
        return pulumi.get(self, "relative_mount_path")

    @relative_mount_path.setter
    def relative_mount_path(self, value: pulumi.Input[str]):
        pulumi.set(self, "relative_mount_path", value)

    @property
    @pulumi.getter(name="accountKey")
    def account_key(self) -> Optional[pulumi.Input[str]]:
        """
        This property is mutually exclusive with sasKey and one must be specified.
        """
        return pulumi.get(self, "account_key")

    @account_key.setter
    def account_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_key", value)

    @property
    @pulumi.getter(name="blobfuseOptions")
    def blobfuse_options(self) -> Optional[pulumi.Input[str]]:
        """
        These are 'net use' options in Windows and 'mount' options in Linux.
        """
        return pulumi.get(self, "blobfuse_options")

    @blobfuse_options.setter
    def blobfuse_options(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "blobfuse_options", value)

    @property
    @pulumi.getter(name="sasKey")
    def sas_key(self) -> Optional[pulumi.Input[str]]:
        """
        This property is mutually exclusive with accountKey and one must be specified.
        """
        return pulumi.get(self, "sas_key")

    @sas_key.setter
    def sas_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sas_key", value)


@pulumi.input_type
class AzureFileShareConfigurationArgs:
    def __init__(__self__, *,
                 account_key: pulumi.Input[str],
                 account_name: pulumi.Input[str],
                 azure_file_url: pulumi.Input[str],
                 relative_mount_path: pulumi.Input[str],
                 mount_options: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] azure_file_url: This is of the form 'https://{account}.file.core.windows.net/'.
        :param pulumi.Input[str] relative_mount_path: All file systems are mounted relative to the Batch mounts directory, accessible via the AZ_BATCH_NODE_MOUNTS_DIR environment variable.
        :param pulumi.Input[str] mount_options: These are 'net use' options in Windows and 'mount' options in Linux.
        """
        pulumi.set(__self__, "account_key", account_key)
        pulumi.set(__self__, "account_name", account_name)
        pulumi.set(__self__, "azure_file_url", azure_file_url)
        pulumi.set(__self__, "relative_mount_path", relative_mount_path)
        if mount_options is not None:
            pulumi.set(__self__, "mount_options", mount_options)

    @property
    @pulumi.getter(name="accountKey")
    def account_key(self) -> pulumi.Input[str]:
        return pulumi.get(self, "account_key")

    @account_key.setter
    def account_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "account_key", value)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> pulumi.Input[str]:
        return pulumi.get(self, "account_name")

    @account_name.setter
    def account_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "account_name", value)

    @property
    @pulumi.getter(name="azureFileUrl")
    def azure_file_url(self) -> pulumi.Input[str]:
        """
        This is of the form 'https://{account}.file.core.windows.net/'.
        """
        return pulumi.get(self, "azure_file_url")

    @azure_file_url.setter
    def azure_file_url(self, value: pulumi.Input[str]):
        pulumi.set(self, "azure_file_url", value)

    @property
    @pulumi.getter(name="relativeMountPath")
    def relative_mount_path(self) -> pulumi.Input[str]:
        """
        All file systems are mounted relative to the Batch mounts directory, accessible via the AZ_BATCH_NODE_MOUNTS_DIR environment variable.
        """
        return pulumi.get(self, "relative_mount_path")

    @relative_mount_path.setter
    def relative_mount_path(self, value: pulumi.Input[str]):
        pulumi.set(self, "relative_mount_path", value)

    @property
    @pulumi.getter(name="mountOptions")
    def mount_options(self) -> Optional[pulumi.Input[str]]:
        """
        These are 'net use' options in Windows and 'mount' options in Linux.
        """
        return pulumi.get(self, "mount_options")

    @mount_options.setter
    def mount_options(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mount_options", value)


@pulumi.input_type
class CIFSMountConfigurationArgs:
    def __init__(__self__, *,
                 password: pulumi.Input[str],
                 relative_mount_path: pulumi.Input[str],
                 source: pulumi.Input[str],
                 username: pulumi.Input[str],
                 mount_options: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] relative_mount_path: All file systems are mounted relative to the Batch mounts directory, accessible via the AZ_BATCH_NODE_MOUNTS_DIR environment variable.
        :param pulumi.Input[str] mount_options: These are 'net use' options in Windows and 'mount' options in Linux.
        """
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "relative_mount_path", relative_mount_path)
        pulumi.set(__self__, "source", source)
        pulumi.set(__self__, "username", username)
        if mount_options is not None:
            pulumi.set(__self__, "mount_options", mount_options)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input[str]:
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[str]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="relativeMountPath")
    def relative_mount_path(self) -> pulumi.Input[str]:
        """
        All file systems are mounted relative to the Batch mounts directory, accessible via the AZ_BATCH_NODE_MOUNTS_DIR environment variable.
        """
        return pulumi.get(self, "relative_mount_path")

    @relative_mount_path.setter
    def relative_mount_path(self, value: pulumi.Input[str]):
        pulumi.set(self, "relative_mount_path", value)

    @property
    @pulumi.getter
    def source(self) -> pulumi.Input[str]:
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: pulumi.Input[str]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter
    def username(self) -> pulumi.Input[str]:
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[str]):
        pulumi.set(self, "username", value)

    @property
    @pulumi.getter(name="mountOptions")
    def mount_options(self) -> Optional[pulumi.Input[str]]:
        """
        These are 'net use' options in Windows and 'mount' options in Linux.
        """
        return pulumi.get(self, "mount_options")

    @mount_options.setter
    def mount_options(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mount_options", value)


@pulumi.input_type
class CertificateReferenceArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[str],
                 store_location: Optional[pulumi.Input['CertificateStoreLocation']] = None,
                 store_name: Optional[pulumi.Input[str]] = None,
                 visibility: Optional[pulumi.Input[Sequence[pulumi.Input['CertificateVisibility']]]] = None):
        """
        :param pulumi.Input['CertificateStoreLocation'] store_location: The default value is currentUser. This property is applicable only for pools configured with Windows nodes (that is, created with cloudServiceConfiguration, or with virtualMachineConfiguration using a Windows image reference). For Linux compute nodes, the certificates are stored in a directory inside the task working directory and an environment variable AZ_BATCH_CERTIFICATES_DIR is supplied to the task to query for this location. For certificates with visibility of 'remoteUser', a 'certs' directory is created in the user's home directory (e.g., /home/{user-name}/certs) and certificates are placed in that directory.
        :param pulumi.Input[str] store_name: This property is applicable only for pools configured with Windows nodes (that is, created with cloudServiceConfiguration, or with virtualMachineConfiguration using a Windows image reference). Common store names include: My, Root, CA, Trust, Disallowed, TrustedPeople, TrustedPublisher, AuthRoot, AddressBook, but any custom store name can also be used. The default value is My.
        """
        pulumi.set(__self__, "id", id)
        if store_location is not None:
            pulumi.set(__self__, "store_location", store_location)
        if store_name is not None:
            pulumi.set(__self__, "store_name", store_name)
        if visibility is not None:
            pulumi.set(__self__, "visibility", visibility)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="storeLocation")
    def store_location(self) -> Optional[pulumi.Input['CertificateStoreLocation']]:
        """
        The default value is currentUser. This property is applicable only for pools configured with Windows nodes (that is, created with cloudServiceConfiguration, or with virtualMachineConfiguration using a Windows image reference). For Linux compute nodes, the certificates are stored in a directory inside the task working directory and an environment variable AZ_BATCH_CERTIFICATES_DIR is supplied to the task to query for this location. For certificates with visibility of 'remoteUser', a 'certs' directory is created in the user's home directory (e.g., /home/{user-name}/certs) and certificates are placed in that directory.
        """
        return pulumi.get(self, "store_location")

    @store_location.setter
    def store_location(self, value: Optional[pulumi.Input['CertificateStoreLocation']]):
        pulumi.set(self, "store_location", value)

    @property
    @pulumi.getter(name="storeName")
    def store_name(self) -> Optional[pulumi.Input[str]]:
        """
        This property is applicable only for pools configured with Windows nodes (that is, created with cloudServiceConfiguration, or with virtualMachineConfiguration using a Windows image reference). Common store names include: My, Root, CA, Trust, Disallowed, TrustedPeople, TrustedPublisher, AuthRoot, AddressBook, but any custom store name can also be used. The default value is My.
        """
        return pulumi.get(self, "store_name")

    @store_name.setter
    def store_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "store_name", value)

    @property
    @pulumi.getter
    def visibility(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CertificateVisibility']]]]:
        return pulumi.get(self, "visibility")

    @visibility.setter
    def visibility(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CertificateVisibility']]]]):
        pulumi.set(self, "visibility", value)


@pulumi.input_type
class CloudServiceConfigurationArgs:
    def __init__(__self__, *,
                 os_family: pulumi.Input[str],
                 os_version: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] os_family: Possible values are: 2 - OS Family 2, equivalent to Windows Server 2008 R2 SP1. 3 - OS Family 3, equivalent to Windows Server 2012. 4 - OS Family 4, equivalent to Windows Server 2012 R2. 5 - OS Family 5, equivalent to Windows Server 2016. 6 - OS Family 6, equivalent to Windows Server 2019. For more information, see Azure Guest OS Releases (https://azure.microsoft.com/documentation/articles/cloud-services-guestos-update-matrix/#releases).
        :param pulumi.Input[str] os_version: The default value is * which specifies the latest operating system version for the specified OS family.
        """
        pulumi.set(__self__, "os_family", os_family)
        if os_version is not None:
            pulumi.set(__self__, "os_version", os_version)

    @property
    @pulumi.getter(name="osFamily")
    def os_family(self) -> pulumi.Input[str]:
        """
        Possible values are: 2 - OS Family 2, equivalent to Windows Server 2008 R2 SP1. 3 - OS Family 3, equivalent to Windows Server 2012. 4 - OS Family 4, equivalent to Windows Server 2012 R2. 5 - OS Family 5, equivalent to Windows Server 2016. 6 - OS Family 6, equivalent to Windows Server 2019. For more information, see Azure Guest OS Releases (https://azure.microsoft.com/documentation/articles/cloud-services-guestos-update-matrix/#releases).
        """
        return pulumi.get(self, "os_family")

    @os_family.setter
    def os_family(self, value: pulumi.Input[str]):
        pulumi.set(self, "os_family", value)

    @property
    @pulumi.getter(name="osVersion")
    def os_version(self) -> Optional[pulumi.Input[str]]:
        """
        The default value is * which specifies the latest operating system version for the specified OS family.
        """
        return pulumi.get(self, "os_version")

    @os_version.setter
    def os_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "os_version", value)


@pulumi.input_type
class ContainerConfigurationArgs:
    def __init__(__self__, *,
                 type: pulumi.Input['ContainerType'],
                 container_image_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 container_registries: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerRegistryArgs']]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] container_image_names: This is the full image reference, as would be specified to "docker pull". An image will be sourced from the default Docker registry unless the image is fully qualified with an alternative registry.
        :param pulumi.Input[Sequence[pulumi.Input['ContainerRegistryArgs']]] container_registries: If any images must be downloaded from a private registry which requires credentials, then those credentials must be provided here.
        """
        pulumi.set(__self__, "type", type)
        if container_image_names is not None:
            pulumi.set(__self__, "container_image_names", container_image_names)
        if container_registries is not None:
            pulumi.set(__self__, "container_registries", container_registries)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input['ContainerType']:
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input['ContainerType']):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="containerImageNames")
    def container_image_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        This is the full image reference, as would be specified to "docker pull". An image will be sourced from the default Docker registry unless the image is fully qualified with an alternative registry.
        """
        return pulumi.get(self, "container_image_names")

    @container_image_names.setter
    def container_image_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "container_image_names", value)

    @property
    @pulumi.getter(name="containerRegistries")
    def container_registries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerRegistryArgs']]]]:
        """
        If any images must be downloaded from a private registry which requires credentials, then those credentials must be provided here.
        """
        return pulumi.get(self, "container_registries")

    @container_registries.setter
    def container_registries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerRegistryArgs']]]]):
        pulumi.set(self, "container_registries", value)


@pulumi.input_type
class ContainerRegistryArgs:
    def __init__(__self__, *,
                 password: pulumi.Input[str],
                 user_name: pulumi.Input[str],
                 registry_server: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] registry_server: If omitted, the default is "docker.io".
        """
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "user_name", user_name)
        if registry_server is not None:
            pulumi.set(__self__, "registry_server", registry_server)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input[str]:
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[str]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> pulumi.Input[str]:
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "user_name", value)

    @property
    @pulumi.getter(name="registryServer")
    def registry_server(self) -> Optional[pulumi.Input[str]]:
        """
        If omitted, the default is "docker.io".
        """
        return pulumi.get(self, "registry_server")

    @registry_server.setter
    def registry_server(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "registry_server", value)


@pulumi.input_type
class DataDiskArgs:
    def __init__(__self__, *,
                 disk_size_gb: pulumi.Input[int],
                 lun: pulumi.Input[int],
                 caching: Optional[pulumi.Input['CachingType']] = None,
                 storage_account_type: Optional[pulumi.Input['StorageAccountType']] = None):
        """
        Settings which will be used by the data disks associated to Compute Nodes in the Pool. When using attached data disks, you need to mount and format the disks from within a VM to use them.
        :param pulumi.Input[int] lun: The lun is used to uniquely identify each data disk. If attaching multiple disks, each should have a distinct lun.
        :param pulumi.Input['CachingType'] caching: Values are:
               
                none - The caching mode for the disk is not enabled.
                readOnly - The caching mode for the disk is read only.
                readWrite - The caching mode for the disk is read and write.
               
                The default value for caching is none. For information about the caching options see: https://blogs.msdn.microsoft.com/windowsazurestorage/2012/06/27/exploring-windows-azure-drives-disks-and-images/.
        :param pulumi.Input['StorageAccountType'] storage_account_type: If omitted, the default is "Standard_LRS". Values are:
               
                Standard_LRS - The data disk should use standard locally redundant storage.
                Premium_LRS - The data disk should use premium locally redundant storage.
        """
        pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        pulumi.set(__self__, "lun", lun)
        if caching is not None:
            pulumi.set(__self__, "caching", caching)
        if storage_account_type is not None:
            pulumi.set(__self__, "storage_account_type", storage_account_type)

    @property
    @pulumi.getter(name="diskSizeGB")
    def disk_size_gb(self) -> pulumi.Input[int]:
        return pulumi.get(self, "disk_size_gb")

    @disk_size_gb.setter
    def disk_size_gb(self, value: pulumi.Input[int]):
        pulumi.set(self, "disk_size_gb", value)

    @property
    @pulumi.getter
    def lun(self) -> pulumi.Input[int]:
        """
        The lun is used to uniquely identify each data disk. If attaching multiple disks, each should have a distinct lun.
        """
        return pulumi.get(self, "lun")

    @lun.setter
    def lun(self, value: pulumi.Input[int]):
        pulumi.set(self, "lun", value)

    @property
    @pulumi.getter
    def caching(self) -> Optional[pulumi.Input['CachingType']]:
        """
        Values are:

         none - The caching mode for the disk is not enabled.
         readOnly - The caching mode for the disk is read only.
         readWrite - The caching mode for the disk is read and write.

         The default value for caching is none. For information about the caching options see: https://blogs.msdn.microsoft.com/windowsazurestorage/2012/06/27/exploring-windows-azure-drives-disks-and-images/.
        """
        return pulumi.get(self, "caching")

    @caching.setter
    def caching(self, value: Optional[pulumi.Input['CachingType']]):
        pulumi.set(self, "caching", value)

    @property
    @pulumi.getter(name="storageAccountType")
    def storage_account_type(self) -> Optional[pulumi.Input['StorageAccountType']]:
        """
        If omitted, the default is "Standard_LRS". Values are:

         Standard_LRS - The data disk should use standard locally redundant storage.
         Premium_LRS - The data disk should use premium locally redundant storage.
        """
        return pulumi.get(self, "storage_account_type")

    @storage_account_type.setter
    def storage_account_type(self, value: Optional[pulumi.Input['StorageAccountType']]):
        pulumi.set(self, "storage_account_type", value)


@pulumi.input_type
class DeploymentConfigurationArgs:
    def __init__(__self__, *,
                 cloud_service_configuration: Optional[pulumi.Input['CloudServiceConfigurationArgs']] = None,
                 virtual_machine_configuration: Optional[pulumi.Input['VirtualMachineConfigurationArgs']] = None):
        """
        :param pulumi.Input['CloudServiceConfigurationArgs'] cloud_service_configuration: This property and virtualMachineConfiguration are mutually exclusive and one of the properties must be specified. This property cannot be specified if the Batch account was created with its poolAllocationMode property set to 'UserSubscription'.
        :param pulumi.Input['VirtualMachineConfigurationArgs'] virtual_machine_configuration: This property and cloudServiceConfiguration are mutually exclusive and one of the properties must be specified.
        """
        if cloud_service_configuration is not None:
            pulumi.set(__self__, "cloud_service_configuration", cloud_service_configuration)
        if virtual_machine_configuration is not None:
            pulumi.set(__self__, "virtual_machine_configuration", virtual_machine_configuration)

    @property
    @pulumi.getter(name="cloudServiceConfiguration")
    def cloud_service_configuration(self) -> Optional[pulumi.Input['CloudServiceConfigurationArgs']]:
        """
        This property and virtualMachineConfiguration are mutually exclusive and one of the properties must be specified. This property cannot be specified if the Batch account was created with its poolAllocationMode property set to 'UserSubscription'.
        """
        return pulumi.get(self, "cloud_service_configuration")

    @cloud_service_configuration.setter
    def cloud_service_configuration(self, value: Optional[pulumi.Input['CloudServiceConfigurationArgs']]):
        pulumi.set(self, "cloud_service_configuration", value)

    @property
    @pulumi.getter(name="virtualMachineConfiguration")
    def virtual_machine_configuration(self) -> Optional[pulumi.Input['VirtualMachineConfigurationArgs']]:
        """
        This property and cloudServiceConfiguration are mutually exclusive and one of the properties must be specified.
        """
        return pulumi.get(self, "virtual_machine_configuration")

    @virtual_machine_configuration.setter
    def virtual_machine_configuration(self, value: Optional[pulumi.Input['VirtualMachineConfigurationArgs']]):
        pulumi.set(self, "virtual_machine_configuration", value)


@pulumi.input_type
class DiskEncryptionConfigurationArgs:
    def __init__(__self__, *,
                 targets: Optional[pulumi.Input[Sequence[pulumi.Input['DiskEncryptionTarget']]]] = None):
        """
        The disk encryption configuration applied on compute nodes in the pool. Disk encryption configuration is not supported on Linux pool created with Virtual Machine Image or Shared Image Gallery Image.
        :param pulumi.Input[Sequence[pulumi.Input['DiskEncryptionTarget']]] targets: On Linux pool, only "TemporaryDisk" is supported; on Windows pool, "OsDisk" and "TemporaryDisk" must be specified.
        """
        if targets is not None:
            pulumi.set(__self__, "targets", targets)

    @property
    @pulumi.getter
    def targets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DiskEncryptionTarget']]]]:
        """
        On Linux pool, only "TemporaryDisk" is supported; on Windows pool, "OsDisk" and "TemporaryDisk" must be specified.
        """
        return pulumi.get(self, "targets")

    @targets.setter
    def targets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DiskEncryptionTarget']]]]):
        pulumi.set(self, "targets", value)


@pulumi.input_type
class EncryptionPropertiesArgs:
    def __init__(__self__, *,
                 key_source: Optional[pulumi.Input['KeySource']] = None,
                 key_vault_properties: Optional[pulumi.Input['KeyVaultPropertiesArgs']] = None):
        """
        :param pulumi.Input['KeySource'] key_source: Type of the key source.
        :param pulumi.Input['KeyVaultPropertiesArgs'] key_vault_properties: Additional details when using Microsoft.KeyVault
        """
        if key_source is not None:
            pulumi.set(__self__, "key_source", key_source)
        if key_vault_properties is not None:
            pulumi.set(__self__, "key_vault_properties", key_vault_properties)

    @property
    @pulumi.getter(name="keySource")
    def key_source(self) -> Optional[pulumi.Input['KeySource']]:
        """
        Type of the key source.
        """
        return pulumi.get(self, "key_source")

    @key_source.setter
    def key_source(self, value: Optional[pulumi.Input['KeySource']]):
        pulumi.set(self, "key_source", value)

    @property
    @pulumi.getter(name="keyVaultProperties")
    def key_vault_properties(self) -> Optional[pulumi.Input['KeyVaultPropertiesArgs']]:
        """
        Additional details when using Microsoft.KeyVault
        """
        return pulumi.get(self, "key_vault_properties")

    @key_vault_properties.setter
    def key_vault_properties(self, value: Optional[pulumi.Input['KeyVaultPropertiesArgs']]):
        pulumi.set(self, "key_vault_properties", value)


@pulumi.input_type
class EnvironmentSettingArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 value: Optional[pulumi.Input[str]] = None):
        pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class FixedScaleSettingsArgs:
    def __init__(__self__, *,
                 node_deallocation_option: Optional[pulumi.Input['ComputeNodeDeallocationOption']] = None,
                 resize_timeout: Optional[pulumi.Input[str]] = None,
                 target_dedicated_nodes: Optional[pulumi.Input[int]] = None,
                 target_low_priority_nodes: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input['ComputeNodeDeallocationOption'] node_deallocation_option: If omitted, the default value is Requeue.
        :param pulumi.Input[str] resize_timeout: The default value is 15 minutes. Timeout values use ISO 8601 format. For example, use PT10M for 10 minutes. The minimum value is 5 minutes. If you specify a value less than 5 minutes, the Batch service rejects the request with an error; if you are calling the REST API directly, the HTTP status code is 400 (Bad Request).
        :param pulumi.Input[int] target_dedicated_nodes: At least one of targetDedicatedNodes, targetLowPriorityNodes must be set.
        :param pulumi.Input[int] target_low_priority_nodes: At least one of targetDedicatedNodes, targetLowPriorityNodes must be set.
        """
        if node_deallocation_option is not None:
            pulumi.set(__self__, "node_deallocation_option", node_deallocation_option)
        if resize_timeout is not None:
            pulumi.set(__self__, "resize_timeout", resize_timeout)
        if target_dedicated_nodes is not None:
            pulumi.set(__self__, "target_dedicated_nodes", target_dedicated_nodes)
        if target_low_priority_nodes is not None:
            pulumi.set(__self__, "target_low_priority_nodes", target_low_priority_nodes)

    @property
    @pulumi.getter(name="nodeDeallocationOption")
    def node_deallocation_option(self) -> Optional[pulumi.Input['ComputeNodeDeallocationOption']]:
        """
        If omitted, the default value is Requeue.
        """
        return pulumi.get(self, "node_deallocation_option")

    @node_deallocation_option.setter
    def node_deallocation_option(self, value: Optional[pulumi.Input['ComputeNodeDeallocationOption']]):
        pulumi.set(self, "node_deallocation_option", value)

    @property
    @pulumi.getter(name="resizeTimeout")
    def resize_timeout(self) -> Optional[pulumi.Input[str]]:
        """
        The default value is 15 minutes. Timeout values use ISO 8601 format. For example, use PT10M for 10 minutes. The minimum value is 5 minutes. If you specify a value less than 5 minutes, the Batch service rejects the request with an error; if you are calling the REST API directly, the HTTP status code is 400 (Bad Request).
        """
        return pulumi.get(self, "resize_timeout")

    @resize_timeout.setter
    def resize_timeout(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resize_timeout", value)

    @property
    @pulumi.getter(name="targetDedicatedNodes")
    def target_dedicated_nodes(self) -> Optional[pulumi.Input[int]]:
        """
        At least one of targetDedicatedNodes, targetLowPriorityNodes must be set.
        """
        return pulumi.get(self, "target_dedicated_nodes")

    @target_dedicated_nodes.setter
    def target_dedicated_nodes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "target_dedicated_nodes", value)

    @property
    @pulumi.getter(name="targetLowPriorityNodes")
    def target_low_priority_nodes(self) -> Optional[pulumi.Input[int]]:
        """
        At least one of targetDedicatedNodes, targetLowPriorityNodes must be set.
        """
        return pulumi.get(self, "target_low_priority_nodes")

    @target_low_priority_nodes.setter
    def target_low_priority_nodes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "target_low_priority_nodes", value)


@pulumi.input_type
class ImageReferenceArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None,
                 offer: Optional[pulumi.Input[str]] = None,
                 publisher: Optional[pulumi.Input[str]] = None,
                 sku: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] id: This property is mutually exclusive with other properties. The Shared Image Gallery image must have replicas in the same region as the Azure Batch account. For information about the firewall settings for the Batch node agent to communicate with the Batch service see https://docs.microsoft.com/en-us/azure/batch/batch-api-basics#virtual-network-vnet-and-firewall-configuration.
        :param pulumi.Input[str] offer: For example, UbuntuServer or WindowsServer.
        :param pulumi.Input[str] publisher: For example, Canonical or MicrosoftWindowsServer.
        :param pulumi.Input[str] sku: For example, 18.04-LTS or 2019-Datacenter.
        :param pulumi.Input[str] version: A value of 'latest' can be specified to select the latest version of an image. If omitted, the default is 'latest'.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if offer is not None:
            pulumi.set(__self__, "offer", offer)
        if publisher is not None:
            pulumi.set(__self__, "publisher", publisher)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        This property is mutually exclusive with other properties. The Shared Image Gallery image must have replicas in the same region as the Azure Batch account. For information about the firewall settings for the Batch node agent to communicate with the Batch service see https://docs.microsoft.com/en-us/azure/batch/batch-api-basics#virtual-network-vnet-and-firewall-configuration.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def offer(self) -> Optional[pulumi.Input[str]]:
        """
        For example, UbuntuServer or WindowsServer.
        """
        return pulumi.get(self, "offer")

    @offer.setter
    def offer(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "offer", value)

    @property
    @pulumi.getter
    def publisher(self) -> Optional[pulumi.Input[str]]:
        """
        For example, Canonical or MicrosoftWindowsServer.
        """
        return pulumi.get(self, "publisher")

    @publisher.setter
    def publisher(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "publisher", value)

    @property
    @pulumi.getter
    def sku(self) -> Optional[pulumi.Input[str]]:
        """
        For example, 18.04-LTS or 2019-Datacenter.
        """
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sku", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        A value of 'latest' can be specified to select the latest version of an image. If omitted, the default is 'latest'.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class InboundNatPoolArgs:
    def __init__(__self__, *,
                 backend_port: pulumi.Input[int],
                 frontend_port_range_end: pulumi.Input[int],
                 frontend_port_range_start: pulumi.Input[int],
                 name: pulumi.Input[str],
                 protocol: pulumi.Input['InboundEndpointProtocol'],
                 network_security_group_rules: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkSecurityGroupRuleArgs']]]] = None):
        """
        :param pulumi.Input[int] backend_port: This must be unique within a Batch pool. Acceptable values are between 1 and 65535 except for 22, 3389, 29876 and 29877 as these are reserved. If any reserved values are provided the request fails with HTTP status code 400.
        :param pulumi.Input[int] frontend_port_range_end: Acceptable values range between 1 and 65534 except ports from 50000 to 55000 which are reserved by the Batch service. All ranges within a pool must be distinct and cannot overlap. If any reserved or overlapping values are provided the request fails with HTTP status code 400.
        :param pulumi.Input[int] frontend_port_range_start: Acceptable values range between 1 and 65534 except ports from 50000 to 55000 which are reserved. All ranges within a pool must be distinct and cannot overlap. If any reserved or overlapping values are provided the request fails with HTTP status code 400.
        :param pulumi.Input[str] name: The name must be unique within a Batch pool, can contain letters, numbers, underscores, periods, and hyphens. Names must start with a letter or number, must end with a letter, number, or underscore, and cannot exceed 77 characters.  If any invalid values are provided the request fails with HTTP status code 400.
        :param pulumi.Input[Sequence[pulumi.Input['NetworkSecurityGroupRuleArgs']]] network_security_group_rules: The maximum number of rules that can be specified across all the endpoints on a Batch pool is 25. If no network security group rules are specified, a default rule will be created to allow inbound access to the specified backendPort. If the maximum number of network security group rules is exceeded the request fails with HTTP status code 400.
        """
        pulumi.set(__self__, "backend_port", backend_port)
        pulumi.set(__self__, "frontend_port_range_end", frontend_port_range_end)
        pulumi.set(__self__, "frontend_port_range_start", frontend_port_range_start)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "protocol", protocol)
        if network_security_group_rules is not None:
            pulumi.set(__self__, "network_security_group_rules", network_security_group_rules)

    @property
    @pulumi.getter(name="backendPort")
    def backend_port(self) -> pulumi.Input[int]:
        """
        This must be unique within a Batch pool. Acceptable values are between 1 and 65535 except for 22, 3389, 29876 and 29877 as these are reserved. If any reserved values are provided the request fails with HTTP status code 400.
        """
        return pulumi.get(self, "backend_port")

    @backend_port.setter
    def backend_port(self, value: pulumi.Input[int]):
        pulumi.set(self, "backend_port", value)

    @property
    @pulumi.getter(name="frontendPortRangeEnd")
    def frontend_port_range_end(self) -> pulumi.Input[int]:
        """
        Acceptable values range between 1 and 65534 except ports from 50000 to 55000 which are reserved by the Batch service. All ranges within a pool must be distinct and cannot overlap. If any reserved or overlapping values are provided the request fails with HTTP status code 400.
        """
        return pulumi.get(self, "frontend_port_range_end")

    @frontend_port_range_end.setter
    def frontend_port_range_end(self, value: pulumi.Input[int]):
        pulumi.set(self, "frontend_port_range_end", value)

    @property
    @pulumi.getter(name="frontendPortRangeStart")
    def frontend_port_range_start(self) -> pulumi.Input[int]:
        """
        Acceptable values range between 1 and 65534 except ports from 50000 to 55000 which are reserved. All ranges within a pool must be distinct and cannot overlap. If any reserved or overlapping values are provided the request fails with HTTP status code 400.
        """
        return pulumi.get(self, "frontend_port_range_start")

    @frontend_port_range_start.setter
    def frontend_port_range_start(self, value: pulumi.Input[int]):
        pulumi.set(self, "frontend_port_range_start", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name must be unique within a Batch pool, can contain letters, numbers, underscores, periods, and hyphens. Names must start with a letter or number, must end with a letter, number, or underscore, and cannot exceed 77 characters.  If any invalid values are provided the request fails with HTTP status code 400.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Input['InboundEndpointProtocol']:
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input['InboundEndpointProtocol']):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="networkSecurityGroupRules")
    def network_security_group_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkSecurityGroupRuleArgs']]]]:
        """
        The maximum number of rules that can be specified across all the endpoints on a Batch pool is 25. If no network security group rules are specified, a default rule will be created to allow inbound access to the specified backendPort. If the maximum number of network security group rules is exceeded the request fails with HTTP status code 400.
        """
        return pulumi.get(self, "network_security_group_rules")

    @network_security_group_rules.setter
    def network_security_group_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkSecurityGroupRuleArgs']]]]):
        pulumi.set(self, "network_security_group_rules", value)


@pulumi.input_type
class KeyVaultPropertiesArgs:
    def __init__(__self__, *,
                 key_identifier: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] key_identifier: Full path to the versioned secret. Example https://mykeyvault.vault.azure.net/keys/testkey/6e34a81fef704045975661e297a4c053
        """
        if key_identifier is not None:
            pulumi.set(__self__, "key_identifier", key_identifier)

    @property
    @pulumi.getter(name="keyIdentifier")
    def key_identifier(self) -> Optional[pulumi.Input[str]]:
        """
        Full path to the versioned secret. Example https://mykeyvault.vault.azure.net/keys/testkey/6e34a81fef704045975661e297a4c053
        """
        return pulumi.get(self, "key_identifier")

    @key_identifier.setter
    def key_identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_identifier", value)


@pulumi.input_type
class KeyVaultReferenceArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[str],
                 url: pulumi.Input[str]):
        """
        Identifies the Azure key vault associated with a Batch account.
        :param pulumi.Input[str] id: The resource ID of the Azure key vault associated with the Batch account.
        :param pulumi.Input[str] url: The URL of the Azure key vault associated with the Batch account.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[str]:
        """
        The resource ID of the Azure key vault associated with the Batch account.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def url(self) -> pulumi.Input[str]:
        """
        The URL of the Azure key vault associated with the Batch account.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: pulumi.Input[str]):
        pulumi.set(self, "url", value)


@pulumi.input_type
class LinuxUserConfigurationArgs:
    def __init__(__self__, *,
                 gid: Optional[pulumi.Input[int]] = None,
                 ssh_private_key: Optional[pulumi.Input[str]] = None,
                 uid: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] gid: The uid and gid properties must be specified together or not at all. If not specified the underlying operating system picks the gid.
        :param pulumi.Input[str] ssh_private_key: The private key must not be password protected. The private key is used to automatically configure asymmetric-key based authentication for SSH between nodes in a Linux pool when the pool's enableInterNodeCommunication property is true (it is ignored if enableInterNodeCommunication is false). It does this by placing the key pair into the user's .ssh directory. If not specified, password-less SSH is not configured between nodes (no modification of the user's .ssh directory is done).
        :param pulumi.Input[int] uid: The uid and gid properties must be specified together or not at all. If not specified the underlying operating system picks the uid.
        """
        if gid is not None:
            pulumi.set(__self__, "gid", gid)
        if ssh_private_key is not None:
            pulumi.set(__self__, "ssh_private_key", ssh_private_key)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)

    @property
    @pulumi.getter
    def gid(self) -> Optional[pulumi.Input[int]]:
        """
        The uid and gid properties must be specified together or not at all. If not specified the underlying operating system picks the gid.
        """
        return pulumi.get(self, "gid")

    @gid.setter
    def gid(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "gid", value)

    @property
    @pulumi.getter(name="sshPrivateKey")
    def ssh_private_key(self) -> Optional[pulumi.Input[str]]:
        """
        The private key must not be password protected. The private key is used to automatically configure asymmetric-key based authentication for SSH between nodes in a Linux pool when the pool's enableInterNodeCommunication property is true (it is ignored if enableInterNodeCommunication is false). It does this by placing the key pair into the user's .ssh directory. If not specified, password-less SSH is not configured between nodes (no modification of the user's .ssh directory is done).
        """
        return pulumi.get(self, "ssh_private_key")

    @ssh_private_key.setter
    def ssh_private_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssh_private_key", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[int]]:
        """
        The uid and gid properties must be specified together or not at all. If not specified the underlying operating system picks the uid.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "uid", value)


@pulumi.input_type
class MetadataItemArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        The Batch service does not assign any meaning to this metadata; it is solely for the use of user code.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class MountConfigurationArgs:
    def __init__(__self__, *,
                 azure_blob_file_system_configuration: Optional[pulumi.Input['AzureBlobFileSystemConfigurationArgs']] = None,
                 azure_file_share_configuration: Optional[pulumi.Input['AzureFileShareConfigurationArgs']] = None,
                 cifs_mount_configuration: Optional[pulumi.Input['CIFSMountConfigurationArgs']] = None,
                 nfs_mount_configuration: Optional[pulumi.Input['NFSMountConfigurationArgs']] = None):
        """
        :param pulumi.Input['AzureBlobFileSystemConfigurationArgs'] azure_blob_file_system_configuration: This property is mutually exclusive with all other properties.
        :param pulumi.Input['AzureFileShareConfigurationArgs'] azure_file_share_configuration: This property is mutually exclusive with all other properties.
        :param pulumi.Input['CIFSMountConfigurationArgs'] cifs_mount_configuration: This property is mutually exclusive with all other properties.
        :param pulumi.Input['NFSMountConfigurationArgs'] nfs_mount_configuration: This property is mutually exclusive with all other properties.
        """
        if azure_blob_file_system_configuration is not None:
            pulumi.set(__self__, "azure_blob_file_system_configuration", azure_blob_file_system_configuration)
        if azure_file_share_configuration is not None:
            pulumi.set(__self__, "azure_file_share_configuration", azure_file_share_configuration)
        if cifs_mount_configuration is not None:
            pulumi.set(__self__, "cifs_mount_configuration", cifs_mount_configuration)
        if nfs_mount_configuration is not None:
            pulumi.set(__self__, "nfs_mount_configuration", nfs_mount_configuration)

    @property
    @pulumi.getter(name="azureBlobFileSystemConfiguration")
    def azure_blob_file_system_configuration(self) -> Optional[pulumi.Input['AzureBlobFileSystemConfigurationArgs']]:
        """
        This property is mutually exclusive with all other properties.
        """
        return pulumi.get(self, "azure_blob_file_system_configuration")

    @azure_blob_file_system_configuration.setter
    def azure_blob_file_system_configuration(self, value: Optional[pulumi.Input['AzureBlobFileSystemConfigurationArgs']]):
        pulumi.set(self, "azure_blob_file_system_configuration", value)

    @property
    @pulumi.getter(name="azureFileShareConfiguration")
    def azure_file_share_configuration(self) -> Optional[pulumi.Input['AzureFileShareConfigurationArgs']]:
        """
        This property is mutually exclusive with all other properties.
        """
        return pulumi.get(self, "azure_file_share_configuration")

    @azure_file_share_configuration.setter
    def azure_file_share_configuration(self, value: Optional[pulumi.Input['AzureFileShareConfigurationArgs']]):
        pulumi.set(self, "azure_file_share_configuration", value)

    @property
    @pulumi.getter(name="cifsMountConfiguration")
    def cifs_mount_configuration(self) -> Optional[pulumi.Input['CIFSMountConfigurationArgs']]:
        """
        This property is mutually exclusive with all other properties.
        """
        return pulumi.get(self, "cifs_mount_configuration")

    @cifs_mount_configuration.setter
    def cifs_mount_configuration(self, value: Optional[pulumi.Input['CIFSMountConfigurationArgs']]):
        pulumi.set(self, "cifs_mount_configuration", value)

    @property
    @pulumi.getter(name="nfsMountConfiguration")
    def nfs_mount_configuration(self) -> Optional[pulumi.Input['NFSMountConfigurationArgs']]:
        """
        This property is mutually exclusive with all other properties.
        """
        return pulumi.get(self, "nfs_mount_configuration")

    @nfs_mount_configuration.setter
    def nfs_mount_configuration(self, value: Optional[pulumi.Input['NFSMountConfigurationArgs']]):
        pulumi.set(self, "nfs_mount_configuration", value)


@pulumi.input_type
class NFSMountConfigurationArgs:
    def __init__(__self__, *,
                 relative_mount_path: pulumi.Input[str],
                 source: pulumi.Input[str],
                 mount_options: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] relative_mount_path: All file systems are mounted relative to the Batch mounts directory, accessible via the AZ_BATCH_NODE_MOUNTS_DIR environment variable.
        :param pulumi.Input[str] mount_options: These are 'net use' options in Windows and 'mount' options in Linux.
        """
        pulumi.set(__self__, "relative_mount_path", relative_mount_path)
        pulumi.set(__self__, "source", source)
        if mount_options is not None:
            pulumi.set(__self__, "mount_options", mount_options)

    @property
    @pulumi.getter(name="relativeMountPath")
    def relative_mount_path(self) -> pulumi.Input[str]:
        """
        All file systems are mounted relative to the Batch mounts directory, accessible via the AZ_BATCH_NODE_MOUNTS_DIR environment variable.
        """
        return pulumi.get(self, "relative_mount_path")

    @relative_mount_path.setter
    def relative_mount_path(self, value: pulumi.Input[str]):
        pulumi.set(self, "relative_mount_path", value)

    @property
    @pulumi.getter
    def source(self) -> pulumi.Input[str]:
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: pulumi.Input[str]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter(name="mountOptions")
    def mount_options(self) -> Optional[pulumi.Input[str]]:
        """
        These are 'net use' options in Windows and 'mount' options in Linux.
        """
        return pulumi.get(self, "mount_options")

    @mount_options.setter
    def mount_options(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mount_options", value)


@pulumi.input_type
class NetworkConfigurationArgs:
    def __init__(__self__, *,
                 endpoint_configuration: Optional[pulumi.Input['PoolEndpointConfigurationArgs']] = None,
                 public_ip_address_configuration: Optional[pulumi.Input['PublicIPAddressConfigurationArgs']] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None):
        """
        The network configuration for a pool.
        :param pulumi.Input['PoolEndpointConfigurationArgs'] endpoint_configuration: Pool endpoint configuration is only supported on pools with the virtualMachineConfiguration property.
        :param pulumi.Input['PublicIPAddressConfigurationArgs'] public_ip_address_configuration: This property is only supported on Pools with the virtualMachineConfiguration property.
        :param pulumi.Input[str] subnet_id: The virtual network must be in the same region and subscription as the Azure Batch account. The specified subnet should have enough free IP addresses to accommodate the number of nodes in the pool. If the subnet doesn't have enough free IP addresses, the pool will partially allocate compute nodes and a resize error will occur. The 'MicrosoftAzureBatch' service principal must have the 'Classic Virtual Machine Contributor' Role-Based Access Control (RBAC) role for the specified VNet. The specified subnet must allow communication from the Azure Batch service to be able to schedule tasks on the compute nodes. This can be verified by checking if the specified VNet has any associated Network Security Groups (NSG). If communication to the compute nodes in the specified subnet is denied by an NSG, then the Batch service will set the state of the compute nodes to unusable. If the specified VNet has any associated Network Security Groups (NSG), then a few reserved system ports must be enabled for inbound communication. For pools created with a virtual machine configuration, enable ports 29876 and 29877, as well as port 22 for Linux and port 3389 for Windows. For pools created with a cloud service configuration, enable ports 10100, 20100, and 30100. Also enable outbound connections to Azure Storage on port 443. For cloudServiceConfiguration pools, only 'classic' VNETs are supported. For more details see: https://docs.microsoft.com/en-us/azure/batch/batch-api-basics#virtual-network-vnet-and-firewall-configuration
        """
        if endpoint_configuration is not None:
            pulumi.set(__self__, "endpoint_configuration", endpoint_configuration)
        if public_ip_address_configuration is not None:
            pulumi.set(__self__, "public_ip_address_configuration", public_ip_address_configuration)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)

    @property
    @pulumi.getter(name="endpointConfiguration")
    def endpoint_configuration(self) -> Optional[pulumi.Input['PoolEndpointConfigurationArgs']]:
        """
        Pool endpoint configuration is only supported on pools with the virtualMachineConfiguration property.
        """
        return pulumi.get(self, "endpoint_configuration")

    @endpoint_configuration.setter
    def endpoint_configuration(self, value: Optional[pulumi.Input['PoolEndpointConfigurationArgs']]):
        pulumi.set(self, "endpoint_configuration", value)

    @property
    @pulumi.getter(name="publicIPAddressConfiguration")
    def public_ip_address_configuration(self) -> Optional[pulumi.Input['PublicIPAddressConfigurationArgs']]:
        """
        This property is only supported on Pools with the virtualMachineConfiguration property.
        """
        return pulumi.get(self, "public_ip_address_configuration")

    @public_ip_address_configuration.setter
    def public_ip_address_configuration(self, value: Optional[pulumi.Input['PublicIPAddressConfigurationArgs']]):
        pulumi.set(self, "public_ip_address_configuration", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        The virtual network must be in the same region and subscription as the Azure Batch account. The specified subnet should have enough free IP addresses to accommodate the number of nodes in the pool. If the subnet doesn't have enough free IP addresses, the pool will partially allocate compute nodes and a resize error will occur. The 'MicrosoftAzureBatch' service principal must have the 'Classic Virtual Machine Contributor' Role-Based Access Control (RBAC) role for the specified VNet. The specified subnet must allow communication from the Azure Batch service to be able to schedule tasks on the compute nodes. This can be verified by checking if the specified VNet has any associated Network Security Groups (NSG). If communication to the compute nodes in the specified subnet is denied by an NSG, then the Batch service will set the state of the compute nodes to unusable. If the specified VNet has any associated Network Security Groups (NSG), then a few reserved system ports must be enabled for inbound communication. For pools created with a virtual machine configuration, enable ports 29876 and 29877, as well as port 22 for Linux and port 3389 for Windows. For pools created with a cloud service configuration, enable ports 10100, 20100, and 30100. Also enable outbound connections to Azure Storage on port 443. For cloudServiceConfiguration pools, only 'classic' VNETs are supported. For more details see: https://docs.microsoft.com/en-us/azure/batch/batch-api-basics#virtual-network-vnet-and-firewall-configuration
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)


@pulumi.input_type
class NetworkSecurityGroupRuleArgs:
    def __init__(__self__, *,
                 access: pulumi.Input['NetworkSecurityGroupRuleAccess'],
                 priority: pulumi.Input[int],
                 source_address_prefix: pulumi.Input[str],
                 source_port_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[int] priority: Priorities within a pool must be unique and are evaluated in order of priority. The lower the number the higher the priority. For example, rules could be specified with order numbers of 150, 250, and 350. The rule with the order number of 150 takes precedence over the rule that has an order of 250. Allowed priorities are 150 to 4096. If any reserved or duplicate values are provided the request fails with HTTP status code 400.
        :param pulumi.Input[str] source_address_prefix: Valid values are a single IP address (i.e. 10.10.10.10), IP subnet (i.e. 192.168.1.0/24), default tag, or * (for all addresses).  If any other values are provided the request fails with HTTP status code 400.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] source_port_ranges: Valid values are '*' (for all ports 0 - 65535) or arrays of ports or port ranges (i.e. 100-200). The ports should in the range of 0 to 65535 and the port ranges or ports can't overlap. If any other values are provided the request fails with HTTP status code 400. Default value will be *.
        """
        pulumi.set(__self__, "access", access)
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "source_address_prefix", source_address_prefix)
        if source_port_ranges is not None:
            pulumi.set(__self__, "source_port_ranges", source_port_ranges)

    @property
    @pulumi.getter
    def access(self) -> pulumi.Input['NetworkSecurityGroupRuleAccess']:
        return pulumi.get(self, "access")

    @access.setter
    def access(self, value: pulumi.Input['NetworkSecurityGroupRuleAccess']):
        pulumi.set(self, "access", value)

    @property
    @pulumi.getter
    def priority(self) -> pulumi.Input[int]:
        """
        Priorities within a pool must be unique and are evaluated in order of priority. The lower the number the higher the priority. For example, rules could be specified with order numbers of 150, 250, and 350. The rule with the order number of 150 takes precedence over the rule that has an order of 250. Allowed priorities are 150 to 4096. If any reserved or duplicate values are provided the request fails with HTTP status code 400.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: pulumi.Input[int]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter(name="sourceAddressPrefix")
    def source_address_prefix(self) -> pulumi.Input[str]:
        """
        Valid values are a single IP address (i.e. 10.10.10.10), IP subnet (i.e. 192.168.1.0/24), default tag, or * (for all addresses).  If any other values are provided the request fails with HTTP status code 400.
        """
        return pulumi.get(self, "source_address_prefix")

    @source_address_prefix.setter
    def source_address_prefix(self, value: pulumi.Input[str]):
        pulumi.set(self, "source_address_prefix", value)

    @property
    @pulumi.getter(name="sourcePortRanges")
    def source_port_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Valid values are '*' (for all ports 0 - 65535) or arrays of ports or port ranges (i.e. 100-200). The ports should in the range of 0 to 65535 and the port ranges or ports can't overlap. If any other values are provided the request fails with HTTP status code 400. Default value will be *.
        """
        return pulumi.get(self, "source_port_ranges")

    @source_port_ranges.setter
    def source_port_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "source_port_ranges", value)


@pulumi.input_type
class PoolEndpointConfigurationArgs:
    def __init__(__self__, *,
                 inbound_nat_pools: pulumi.Input[Sequence[pulumi.Input['InboundNatPoolArgs']]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input['InboundNatPoolArgs']]] inbound_nat_pools: The maximum number of inbound NAT pools per Batch pool is 5. If the maximum number of inbound NAT pools is exceeded the request fails with HTTP status code 400.
        """
        pulumi.set(__self__, "inbound_nat_pools", inbound_nat_pools)

    @property
    @pulumi.getter(name="inboundNatPools")
    def inbound_nat_pools(self) -> pulumi.Input[Sequence[pulumi.Input['InboundNatPoolArgs']]]:
        """
        The maximum number of inbound NAT pools per Batch pool is 5. If the maximum number of inbound NAT pools is exceeded the request fails with HTTP status code 400.
        """
        return pulumi.get(self, "inbound_nat_pools")

    @inbound_nat_pools.setter
    def inbound_nat_pools(self, value: pulumi.Input[Sequence[pulumi.Input['InboundNatPoolArgs']]]):
        pulumi.set(self, "inbound_nat_pools", value)


@pulumi.input_type
class PublicIPAddressConfigurationArgs:
    def __init__(__self__, *,
                 ip_address_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 provision: Optional[pulumi.Input['IPAddressProvisioningType']] = None):
        """
        The public IP Address configuration of the networking configuration of a Pool.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ip_address_ids: The number of IPs specified here limits the maximum size of the Pool - 50 dedicated nodes or 20 low-priority nodes can be allocated for each public IP. For example, a pool needing 150 dedicated VMs would need at least 3 public IPs specified. Each element of this collection is of the form: /subscriptions/{subscription}/resourceGroups/{group}/providers/Microsoft.Network/publicIPAddresses/{ip}.
        :param pulumi.Input['IPAddressProvisioningType'] provision: The default value is BatchManaged
        """
        if ip_address_ids is not None:
            pulumi.set(__self__, "ip_address_ids", ip_address_ids)
        if provision is not None:
            pulumi.set(__self__, "provision", provision)

    @property
    @pulumi.getter(name="ipAddressIds")
    def ip_address_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The number of IPs specified here limits the maximum size of the Pool - 50 dedicated nodes or 20 low-priority nodes can be allocated for each public IP. For example, a pool needing 150 dedicated VMs would need at least 3 public IPs specified. Each element of this collection is of the form: /subscriptions/{subscription}/resourceGroups/{group}/providers/Microsoft.Network/publicIPAddresses/{ip}.
        """
        return pulumi.get(self, "ip_address_ids")

    @ip_address_ids.setter
    def ip_address_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ip_address_ids", value)

    @property
    @pulumi.getter
    def provision(self) -> Optional[pulumi.Input['IPAddressProvisioningType']]:
        """
        The default value is BatchManaged
        """
        return pulumi.get(self, "provision")

    @provision.setter
    def provision(self, value: Optional[pulumi.Input['IPAddressProvisioningType']]):
        pulumi.set(self, "provision", value)


@pulumi.input_type
class ResourceFileArgs:
    def __init__(__self__, *,
                 auto_storage_container_name: Optional[pulumi.Input[str]] = None,
                 blob_prefix: Optional[pulumi.Input[str]] = None,
                 file_mode: Optional[pulumi.Input[str]] = None,
                 file_path: Optional[pulumi.Input[str]] = None,
                 http_url: Optional[pulumi.Input[str]] = None,
                 storage_container_url: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] auto_storage_container_name: The autoStorageContainerName, storageContainerUrl and httpUrl properties are mutually exclusive and one of them must be specified.
        :param pulumi.Input[str] blob_prefix: The property is valid only when autoStorageContainerName or storageContainerUrl is used. This prefix can be a partial filename or a subdirectory. If a prefix is not specified, all the files in the container will be downloaded.
        :param pulumi.Input[str] file_mode: This property applies only to files being downloaded to Linux compute nodes. It will be ignored if it is specified for a resourceFile which will be downloaded to a Windows node. If this property is not specified for a Linux node, then a default value of 0770 is applied to the file.
        :param pulumi.Input[str] file_path: If the httpUrl property is specified, the filePath is required and describes the path which the file will be downloaded to, including the filename. Otherwise, if the autoStorageContainerName or storageContainerUrl property is specified, filePath is optional and is the directory to download the files to. In the case where filePath is used as a directory, any directory structure already associated with the input data will be retained in full and appended to the specified filePath directory. The specified relative path cannot break out of the task's working directory (for example by using '..').
        :param pulumi.Input[str] http_url: The autoStorageContainerName, storageContainerUrl and httpUrl properties are mutually exclusive and one of them must be specified. If the URL is Azure Blob Storage, it must be readable using anonymous access; that is, the Batch service does not present any credentials when downloading the blob. There are two ways to get such a URL for a blob in Azure storage: include a Shared Access Signature (SAS) granting read permissions on the blob, or set the ACL for the blob or its container to allow public access.
        :param pulumi.Input[str] storage_container_url: The autoStorageContainerName, storageContainerUrl and httpUrl properties are mutually exclusive and one of them must be specified. This URL must be readable and listable using anonymous access; that is, the Batch service does not present any credentials when downloading the blob. There are two ways to get such a URL for a blob in Azure storage: include a Shared Access Signature (SAS) granting read and list permissions on the blob, or set the ACL for the blob or its container to allow public access.
        """
        if auto_storage_container_name is not None:
            pulumi.set(__self__, "auto_storage_container_name", auto_storage_container_name)
        if blob_prefix is not None:
            pulumi.set(__self__, "blob_prefix", blob_prefix)
        if file_mode is not None:
            pulumi.set(__self__, "file_mode", file_mode)
        if file_path is not None:
            pulumi.set(__self__, "file_path", file_path)
        if http_url is not None:
            pulumi.set(__self__, "http_url", http_url)
        if storage_container_url is not None:
            pulumi.set(__self__, "storage_container_url", storage_container_url)

    @property
    @pulumi.getter(name="autoStorageContainerName")
    def auto_storage_container_name(self) -> Optional[pulumi.Input[str]]:
        """
        The autoStorageContainerName, storageContainerUrl and httpUrl properties are mutually exclusive and one of them must be specified.
        """
        return pulumi.get(self, "auto_storage_container_name")

    @auto_storage_container_name.setter
    def auto_storage_container_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auto_storage_container_name", value)

    @property
    @pulumi.getter(name="blobPrefix")
    def blob_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        The property is valid only when autoStorageContainerName or storageContainerUrl is used. This prefix can be a partial filename or a subdirectory. If a prefix is not specified, all the files in the container will be downloaded.
        """
        return pulumi.get(self, "blob_prefix")

    @blob_prefix.setter
    def blob_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "blob_prefix", value)

    @property
    @pulumi.getter(name="fileMode")
    def file_mode(self) -> Optional[pulumi.Input[str]]:
        """
        This property applies only to files being downloaded to Linux compute nodes. It will be ignored if it is specified for a resourceFile which will be downloaded to a Windows node. If this property is not specified for a Linux node, then a default value of 0770 is applied to the file.
        """
        return pulumi.get(self, "file_mode")

    @file_mode.setter
    def file_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "file_mode", value)

    @property
    @pulumi.getter(name="filePath")
    def file_path(self) -> Optional[pulumi.Input[str]]:
        """
        If the httpUrl property is specified, the filePath is required and describes the path which the file will be downloaded to, including the filename. Otherwise, if the autoStorageContainerName or storageContainerUrl property is specified, filePath is optional and is the directory to download the files to. In the case where filePath is used as a directory, any directory structure already associated with the input data will be retained in full and appended to the specified filePath directory. The specified relative path cannot break out of the task's working directory (for example by using '..').
        """
        return pulumi.get(self, "file_path")

    @file_path.setter
    def file_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "file_path", value)

    @property
    @pulumi.getter(name="httpUrl")
    def http_url(self) -> Optional[pulumi.Input[str]]:
        """
        The autoStorageContainerName, storageContainerUrl and httpUrl properties are mutually exclusive and one of them must be specified. If the URL is Azure Blob Storage, it must be readable using anonymous access; that is, the Batch service does not present any credentials when downloading the blob. There are two ways to get such a URL for a blob in Azure storage: include a Shared Access Signature (SAS) granting read permissions on the blob, or set the ACL for the blob or its container to allow public access.
        """
        return pulumi.get(self, "http_url")

    @http_url.setter
    def http_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "http_url", value)

    @property
    @pulumi.getter(name="storageContainerUrl")
    def storage_container_url(self) -> Optional[pulumi.Input[str]]:
        """
        The autoStorageContainerName, storageContainerUrl and httpUrl properties are mutually exclusive and one of them must be specified. This URL must be readable and listable using anonymous access; that is, the Batch service does not present any credentials when downloading the blob. There are two ways to get such a URL for a blob in Azure storage: include a Shared Access Signature (SAS) granting read and list permissions on the blob, or set the ACL for the blob or its container to allow public access.
        """
        return pulumi.get(self, "storage_container_url")

    @storage_container_url.setter
    def storage_container_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_container_url", value)


@pulumi.input_type
class ScaleSettingsArgs:
    def __init__(__self__, *,
                 auto_scale: Optional[pulumi.Input['AutoScaleSettingsArgs']] = None,
                 fixed_scale: Optional[pulumi.Input['FixedScaleSettingsArgs']] = None):
        """
        Defines the desired size of the pool. This can either be 'fixedScale' where the requested targetDedicatedNodes is specified, or 'autoScale' which defines a formula which is periodically reevaluated. If this property is not specified, the pool will have a fixed scale with 0 targetDedicatedNodes.
        :param pulumi.Input['AutoScaleSettingsArgs'] auto_scale: This property and fixedScale are mutually exclusive and one of the properties must be specified.
        :param pulumi.Input['FixedScaleSettingsArgs'] fixed_scale: This property and autoScale are mutually exclusive and one of the properties must be specified.
        """
        if auto_scale is not None:
            pulumi.set(__self__, "auto_scale", auto_scale)
        if fixed_scale is not None:
            pulumi.set(__self__, "fixed_scale", fixed_scale)

    @property
    @pulumi.getter(name="autoScale")
    def auto_scale(self) -> Optional[pulumi.Input['AutoScaleSettingsArgs']]:
        """
        This property and fixedScale are mutually exclusive and one of the properties must be specified.
        """
        return pulumi.get(self, "auto_scale")

    @auto_scale.setter
    def auto_scale(self, value: Optional[pulumi.Input['AutoScaleSettingsArgs']]):
        pulumi.set(self, "auto_scale", value)

    @property
    @pulumi.getter(name="fixedScale")
    def fixed_scale(self) -> Optional[pulumi.Input['FixedScaleSettingsArgs']]:
        """
        This property and autoScale are mutually exclusive and one of the properties must be specified.
        """
        return pulumi.get(self, "fixed_scale")

    @fixed_scale.setter
    def fixed_scale(self, value: Optional[pulumi.Input['FixedScaleSettingsArgs']]):
        pulumi.set(self, "fixed_scale", value)


@pulumi.input_type
class StartTaskArgs:
    def __init__(__self__, *,
                 command_line: Optional[pulumi.Input[str]] = None,
                 container_settings: Optional[pulumi.Input['TaskContainerSettingsArgs']] = None,
                 environment_settings: Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentSettingArgs']]]] = None,
                 max_task_retry_count: Optional[pulumi.Input[int]] = None,
                 resource_files: Optional[pulumi.Input[Sequence[pulumi.Input['ResourceFileArgs']]]] = None,
                 user_identity: Optional[pulumi.Input['UserIdentityArgs']] = None,
                 wait_for_success: Optional[pulumi.Input[bool]] = None):
        """
        In some cases the start task may be re-run even though the node was not rebooted. Due to this, start tasks should be idempotent and exit gracefully if the setup they're performing has already been done. Special care should be taken to avoid start tasks which create breakaway process or install/launch services from the start task working directory, as this will block Batch from being able to re-run the start task.
        :param pulumi.Input[str] command_line: The command line does not run under a shell, and therefore cannot take advantage of shell features such as environment variable expansion. If you want to take advantage of such features, you should invoke the shell in the command line, for example using "cmd /c MyCommand" in Windows or "/bin/sh -c MyCommand" in Linux. Required if any other properties of the startTask are specified.
        :param pulumi.Input['TaskContainerSettingsArgs'] container_settings: When this is specified, all directories recursively below the AZ_BATCH_NODE_ROOT_DIR (the root of Azure Batch directories on the node) are mapped into the container, all task environment variables are mapped into the container, and the task command line is executed in the container.
        :param pulumi.Input[int] max_task_retry_count: The Batch service retries a task if its exit code is nonzero. Note that this value specifically controls the number of retries. The Batch service will try the task once, and may then retry up to this limit. For example, if the maximum retry count is 3, Batch tries the task up to 4 times (one initial try and 3 retries). If the maximum retry count is 0, the Batch service does not retry the task. If the maximum retry count is -1, the Batch service retries the task without limit.
        :param pulumi.Input['UserIdentityArgs'] user_identity: If omitted, the task runs as a non-administrative user unique to the task.
        :param pulumi.Input[bool] wait_for_success: If true and the start task fails on a compute node, the Batch service retries the start task up to its maximum retry count (maxTaskRetryCount). If the task has still not completed successfully after all retries, then the Batch service marks the compute node unusable, and will not schedule tasks to it. This condition can be detected via the node state and scheduling error detail. If false, the Batch service will not wait for the start task to complete. In this case, other tasks can start executing on the compute node while the start task is still running; and even if the start task fails, new tasks will continue to be scheduled on the node. The default is true.
        """
        if command_line is not None:
            pulumi.set(__self__, "command_line", command_line)
        if container_settings is not None:
            pulumi.set(__self__, "container_settings", container_settings)
        if environment_settings is not None:
            pulumi.set(__self__, "environment_settings", environment_settings)
        if max_task_retry_count is not None:
            pulumi.set(__self__, "max_task_retry_count", max_task_retry_count)
        if resource_files is not None:
            pulumi.set(__self__, "resource_files", resource_files)
        if user_identity is not None:
            pulumi.set(__self__, "user_identity", user_identity)
        if wait_for_success is not None:
            pulumi.set(__self__, "wait_for_success", wait_for_success)

    @property
    @pulumi.getter(name="commandLine")
    def command_line(self) -> Optional[pulumi.Input[str]]:
        """
        The command line does not run under a shell, and therefore cannot take advantage of shell features such as environment variable expansion. If you want to take advantage of such features, you should invoke the shell in the command line, for example using "cmd /c MyCommand" in Windows or "/bin/sh -c MyCommand" in Linux. Required if any other properties of the startTask are specified.
        """
        return pulumi.get(self, "command_line")

    @command_line.setter
    def command_line(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "command_line", value)

    @property
    @pulumi.getter(name="containerSettings")
    def container_settings(self) -> Optional[pulumi.Input['TaskContainerSettingsArgs']]:
        """
        When this is specified, all directories recursively below the AZ_BATCH_NODE_ROOT_DIR (the root of Azure Batch directories on the node) are mapped into the container, all task environment variables are mapped into the container, and the task command line is executed in the container.
        """
        return pulumi.get(self, "container_settings")

    @container_settings.setter
    def container_settings(self, value: Optional[pulumi.Input['TaskContainerSettingsArgs']]):
        pulumi.set(self, "container_settings", value)

    @property
    @pulumi.getter(name="environmentSettings")
    def environment_settings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentSettingArgs']]]]:
        return pulumi.get(self, "environment_settings")

    @environment_settings.setter
    def environment_settings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentSettingArgs']]]]):
        pulumi.set(self, "environment_settings", value)

    @property
    @pulumi.getter(name="maxTaskRetryCount")
    def max_task_retry_count(self) -> Optional[pulumi.Input[int]]:
        """
        The Batch service retries a task if its exit code is nonzero. Note that this value specifically controls the number of retries. The Batch service will try the task once, and may then retry up to this limit. For example, if the maximum retry count is 3, Batch tries the task up to 4 times (one initial try and 3 retries). If the maximum retry count is 0, the Batch service does not retry the task. If the maximum retry count is -1, the Batch service retries the task without limit.
        """
        return pulumi.get(self, "max_task_retry_count")

    @max_task_retry_count.setter
    def max_task_retry_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_task_retry_count", value)

    @property
    @pulumi.getter(name="resourceFiles")
    def resource_files(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ResourceFileArgs']]]]:
        return pulumi.get(self, "resource_files")

    @resource_files.setter
    def resource_files(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ResourceFileArgs']]]]):
        pulumi.set(self, "resource_files", value)

    @property
    @pulumi.getter(name="userIdentity")
    def user_identity(self) -> Optional[pulumi.Input['UserIdentityArgs']]:
        """
        If omitted, the task runs as a non-administrative user unique to the task.
        """
        return pulumi.get(self, "user_identity")

    @user_identity.setter
    def user_identity(self, value: Optional[pulumi.Input['UserIdentityArgs']]):
        pulumi.set(self, "user_identity", value)

    @property
    @pulumi.getter(name="waitForSuccess")
    def wait_for_success(self) -> Optional[pulumi.Input[bool]]:
        """
        If true and the start task fails on a compute node, the Batch service retries the start task up to its maximum retry count (maxTaskRetryCount). If the task has still not completed successfully after all retries, then the Batch service marks the compute node unusable, and will not schedule tasks to it. This condition can be detected via the node state and scheduling error detail. If false, the Batch service will not wait for the start task to complete. In this case, other tasks can start executing on the compute node while the start task is still running; and even if the start task fails, new tasks will continue to be scheduled on the node. The default is true.
        """
        return pulumi.get(self, "wait_for_success")

    @wait_for_success.setter
    def wait_for_success(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "wait_for_success", value)


@pulumi.input_type
class TaskContainerSettingsArgs:
    def __init__(__self__, *,
                 image_name: pulumi.Input[str],
                 container_run_options: Optional[pulumi.Input[str]] = None,
                 registry: Optional[pulumi.Input['ContainerRegistryArgs']] = None,
                 working_directory: Optional[pulumi.Input['ContainerWorkingDirectory']] = None):
        """
        :param pulumi.Input[str] image_name: This is the full image reference, as would be specified to "docker pull". If no tag is provided as part of the image name, the tag ":latest" is used as a default.
        :param pulumi.Input[str] container_run_options: These additional options are supplied as arguments to the "docker create" command, in addition to those controlled by the Batch Service.
        :param pulumi.Input['ContainerRegistryArgs'] registry: This setting can be omitted if was already provided at pool creation.
        """
        pulumi.set(__self__, "image_name", image_name)
        if container_run_options is not None:
            pulumi.set(__self__, "container_run_options", container_run_options)
        if registry is not None:
            pulumi.set(__self__, "registry", registry)
        if working_directory is not None:
            pulumi.set(__self__, "working_directory", working_directory)

    @property
    @pulumi.getter(name="imageName")
    def image_name(self) -> pulumi.Input[str]:
        """
        This is the full image reference, as would be specified to "docker pull". If no tag is provided as part of the image name, the tag ":latest" is used as a default.
        """
        return pulumi.get(self, "image_name")

    @image_name.setter
    def image_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "image_name", value)

    @property
    @pulumi.getter(name="containerRunOptions")
    def container_run_options(self) -> Optional[pulumi.Input[str]]:
        """
        These additional options are supplied as arguments to the "docker create" command, in addition to those controlled by the Batch Service.
        """
        return pulumi.get(self, "container_run_options")

    @container_run_options.setter
    def container_run_options(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "container_run_options", value)

    @property
    @pulumi.getter
    def registry(self) -> Optional[pulumi.Input['ContainerRegistryArgs']]:
        """
        This setting can be omitted if was already provided at pool creation.
        """
        return pulumi.get(self, "registry")

    @registry.setter
    def registry(self, value: Optional[pulumi.Input['ContainerRegistryArgs']]):
        pulumi.set(self, "registry", value)

    @property
    @pulumi.getter(name="workingDirectory")
    def working_directory(self) -> Optional[pulumi.Input['ContainerWorkingDirectory']]:
        return pulumi.get(self, "working_directory")

    @working_directory.setter
    def working_directory(self, value: Optional[pulumi.Input['ContainerWorkingDirectory']]):
        pulumi.set(self, "working_directory", value)


@pulumi.input_type
class TaskSchedulingPolicyArgs:
    def __init__(__self__, *,
                 node_fill_type: pulumi.Input['ComputeNodeFillType']):
        pulumi.set(__self__, "node_fill_type", node_fill_type)

    @property
    @pulumi.getter(name="nodeFillType")
    def node_fill_type(self) -> pulumi.Input['ComputeNodeFillType']:
        return pulumi.get(self, "node_fill_type")

    @node_fill_type.setter
    def node_fill_type(self, value: pulumi.Input['ComputeNodeFillType']):
        pulumi.set(self, "node_fill_type", value)


@pulumi.input_type
class UserAccountArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 password: pulumi.Input[str],
                 elevation_level: Optional[pulumi.Input['ElevationLevel']] = None,
                 linux_user_configuration: Optional[pulumi.Input['LinuxUserConfigurationArgs']] = None,
                 windows_user_configuration: Optional[pulumi.Input['WindowsUserConfigurationArgs']] = None):
        """
        :param pulumi.Input['ElevationLevel'] elevation_level: nonAdmin - The auto user is a standard user without elevated access. admin - The auto user is a user with elevated access and operates with full Administrator permissions. The default value is nonAdmin.
        :param pulumi.Input['LinuxUserConfigurationArgs'] linux_user_configuration: This property is ignored if specified on a Windows pool. If not specified, the user is created with the default options.
        :param pulumi.Input['WindowsUserConfigurationArgs'] windows_user_configuration: This property can only be specified if the user is on a Windows pool. If not specified and on a Windows pool, the user is created with the default options.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "password", password)
        if elevation_level is not None:
            pulumi.set(__self__, "elevation_level", elevation_level)
        if linux_user_configuration is not None:
            pulumi.set(__self__, "linux_user_configuration", linux_user_configuration)
        if windows_user_configuration is not None:
            pulumi.set(__self__, "windows_user_configuration", windows_user_configuration)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input[str]:
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[str]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="elevationLevel")
    def elevation_level(self) -> Optional[pulumi.Input['ElevationLevel']]:
        """
        nonAdmin - The auto user is a standard user without elevated access. admin - The auto user is a user with elevated access and operates with full Administrator permissions. The default value is nonAdmin.
        """
        return pulumi.get(self, "elevation_level")

    @elevation_level.setter
    def elevation_level(self, value: Optional[pulumi.Input['ElevationLevel']]):
        pulumi.set(self, "elevation_level", value)

    @property
    @pulumi.getter(name="linuxUserConfiguration")
    def linux_user_configuration(self) -> Optional[pulumi.Input['LinuxUserConfigurationArgs']]:
        """
        This property is ignored if specified on a Windows pool. If not specified, the user is created with the default options.
        """
        return pulumi.get(self, "linux_user_configuration")

    @linux_user_configuration.setter
    def linux_user_configuration(self, value: Optional[pulumi.Input['LinuxUserConfigurationArgs']]):
        pulumi.set(self, "linux_user_configuration", value)

    @property
    @pulumi.getter(name="windowsUserConfiguration")
    def windows_user_configuration(self) -> Optional[pulumi.Input['WindowsUserConfigurationArgs']]:
        """
        This property can only be specified if the user is on a Windows pool. If not specified and on a Windows pool, the user is created with the default options.
        """
        return pulumi.get(self, "windows_user_configuration")

    @windows_user_configuration.setter
    def windows_user_configuration(self, value: Optional[pulumi.Input['WindowsUserConfigurationArgs']]):
        pulumi.set(self, "windows_user_configuration", value)


@pulumi.input_type
class UserIdentityArgs:
    def __init__(__self__, *,
                 auto_user: Optional[pulumi.Input['AutoUserSpecificationArgs']] = None,
                 user_name: Optional[pulumi.Input[str]] = None):
        """
        Specify either the userName or autoUser property, but not both.
        :param pulumi.Input['AutoUserSpecificationArgs'] auto_user: The userName and autoUser properties are mutually exclusive; you must specify one but not both.
        :param pulumi.Input[str] user_name: The userName and autoUser properties are mutually exclusive; you must specify one but not both.
        """
        if auto_user is not None:
            pulumi.set(__self__, "auto_user", auto_user)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter(name="autoUser")
    def auto_user(self) -> Optional[pulumi.Input['AutoUserSpecificationArgs']]:
        """
        The userName and autoUser properties are mutually exclusive; you must specify one but not both.
        """
        return pulumi.get(self, "auto_user")

    @auto_user.setter
    def auto_user(self, value: Optional[pulumi.Input['AutoUserSpecificationArgs']]):
        pulumi.set(self, "auto_user", value)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[pulumi.Input[str]]:
        """
        The userName and autoUser properties are mutually exclusive; you must specify one but not both.
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_name", value)


@pulumi.input_type
class VirtualMachineConfigurationArgs:
    def __init__(__self__, *,
                 image_reference: pulumi.Input['ImageReferenceArgs'],
                 node_agent_sku_id: pulumi.Input[str],
                 container_configuration: Optional[pulumi.Input['ContainerConfigurationArgs']] = None,
                 data_disks: Optional[pulumi.Input[Sequence[pulumi.Input['DataDiskArgs']]]] = None,
                 disk_encryption_configuration: Optional[pulumi.Input['DiskEncryptionConfigurationArgs']] = None,
                 license_type: Optional[pulumi.Input[str]] = None,
                 windows_configuration: Optional[pulumi.Input['WindowsConfigurationArgs']] = None):
        """
        :param pulumi.Input[str] node_agent_sku_id: The Batch node agent is a program that runs on each node in the pool, and provides the command-and-control interface between the node and the Batch service. There are different implementations of the node agent, known as SKUs, for different operating systems. You must specify a node agent SKU which matches the selected image reference. To get the list of supported node agent SKUs along with their list of verified image references, see the 'List supported node agent SKUs' operation.
        :param pulumi.Input['ContainerConfigurationArgs'] container_configuration: If specified, setup is performed on each node in the pool to allow tasks to run in containers. All regular tasks and job manager tasks run on this pool must specify the containerSettings property, and all other tasks may specify it.
        :param pulumi.Input[Sequence[pulumi.Input['DataDiskArgs']]] data_disks: This property must be specified if the compute nodes in the pool need to have empty data disks attached to them.
        :param pulumi.Input['DiskEncryptionConfigurationArgs'] disk_encryption_configuration: If specified, encryption is performed on each node in the pool during node provisioning.
        :param pulumi.Input[str] license_type: This only applies to images that contain the Windows operating system, and should only be used when you hold valid on-premises licenses for the nodes which will be deployed. If omitted, no on-premises licensing discount is applied. Values are:
               
                Windows_Server - The on-premises license is for Windows Server.
                Windows_Client - The on-premises license is for Windows Client.
        :param pulumi.Input['WindowsConfigurationArgs'] windows_configuration: This property must not be specified if the imageReference specifies a Linux OS image.
        """
        pulumi.set(__self__, "image_reference", image_reference)
        pulumi.set(__self__, "node_agent_sku_id", node_agent_sku_id)
        if container_configuration is not None:
            pulumi.set(__self__, "container_configuration", container_configuration)
        if data_disks is not None:
            pulumi.set(__self__, "data_disks", data_disks)
        if disk_encryption_configuration is not None:
            pulumi.set(__self__, "disk_encryption_configuration", disk_encryption_configuration)
        if license_type is not None:
            pulumi.set(__self__, "license_type", license_type)
        if windows_configuration is not None:
            pulumi.set(__self__, "windows_configuration", windows_configuration)

    @property
    @pulumi.getter(name="imageReference")
    def image_reference(self) -> pulumi.Input['ImageReferenceArgs']:
        return pulumi.get(self, "image_reference")

    @image_reference.setter
    def image_reference(self, value: pulumi.Input['ImageReferenceArgs']):
        pulumi.set(self, "image_reference", value)

    @property
    @pulumi.getter(name="nodeAgentSkuId")
    def node_agent_sku_id(self) -> pulumi.Input[str]:
        """
        The Batch node agent is a program that runs on each node in the pool, and provides the command-and-control interface between the node and the Batch service. There are different implementations of the node agent, known as SKUs, for different operating systems. You must specify a node agent SKU which matches the selected image reference. To get the list of supported node agent SKUs along with their list of verified image references, see the 'List supported node agent SKUs' operation.
        """
        return pulumi.get(self, "node_agent_sku_id")

    @node_agent_sku_id.setter
    def node_agent_sku_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "node_agent_sku_id", value)

    @property
    @pulumi.getter(name="containerConfiguration")
    def container_configuration(self) -> Optional[pulumi.Input['ContainerConfigurationArgs']]:
        """
        If specified, setup is performed on each node in the pool to allow tasks to run in containers. All regular tasks and job manager tasks run on this pool must specify the containerSettings property, and all other tasks may specify it.
        """
        return pulumi.get(self, "container_configuration")

    @container_configuration.setter
    def container_configuration(self, value: Optional[pulumi.Input['ContainerConfigurationArgs']]):
        pulumi.set(self, "container_configuration", value)

    @property
    @pulumi.getter(name="dataDisks")
    def data_disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DataDiskArgs']]]]:
        """
        This property must be specified if the compute nodes in the pool need to have empty data disks attached to them.
        """
        return pulumi.get(self, "data_disks")

    @data_disks.setter
    def data_disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DataDiskArgs']]]]):
        pulumi.set(self, "data_disks", value)

    @property
    @pulumi.getter(name="diskEncryptionConfiguration")
    def disk_encryption_configuration(self) -> Optional[pulumi.Input['DiskEncryptionConfigurationArgs']]:
        """
        If specified, encryption is performed on each node in the pool during node provisioning.
        """
        return pulumi.get(self, "disk_encryption_configuration")

    @disk_encryption_configuration.setter
    def disk_encryption_configuration(self, value: Optional[pulumi.Input['DiskEncryptionConfigurationArgs']]):
        pulumi.set(self, "disk_encryption_configuration", value)

    @property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> Optional[pulumi.Input[str]]:
        """
        This only applies to images that contain the Windows operating system, and should only be used when you hold valid on-premises licenses for the nodes which will be deployed. If omitted, no on-premises licensing discount is applied. Values are:

         Windows_Server - The on-premises license is for Windows Server.
         Windows_Client - The on-premises license is for Windows Client.
        """
        return pulumi.get(self, "license_type")

    @license_type.setter
    def license_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "license_type", value)

    @property
    @pulumi.getter(name="windowsConfiguration")
    def windows_configuration(self) -> Optional[pulumi.Input['WindowsConfigurationArgs']]:
        """
        This property must not be specified if the imageReference specifies a Linux OS image.
        """
        return pulumi.get(self, "windows_configuration")

    @windows_configuration.setter
    def windows_configuration(self, value: Optional[pulumi.Input['WindowsConfigurationArgs']]):
        pulumi.set(self, "windows_configuration", value)


@pulumi.input_type
class WindowsConfigurationArgs:
    def __init__(__self__, *,
                 enable_automatic_updates: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[bool] enable_automatic_updates: If omitted, the default value is true.
        """
        if enable_automatic_updates is not None:
            pulumi.set(__self__, "enable_automatic_updates", enable_automatic_updates)

    @property
    @pulumi.getter(name="enableAutomaticUpdates")
    def enable_automatic_updates(self) -> Optional[pulumi.Input[bool]]:
        """
        If omitted, the default value is true.
        """
        return pulumi.get(self, "enable_automatic_updates")

    @enable_automatic_updates.setter
    def enable_automatic_updates(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_automatic_updates", value)


@pulumi.input_type
class WindowsUserConfigurationArgs:
    def __init__(__self__, *,
                 login_mode: Optional[pulumi.Input['LoginMode']] = None):
        """
        :param pulumi.Input['LoginMode'] login_mode: Specifies login mode for the user. The default value for VirtualMachineConfiguration pools is interactive mode and for CloudServiceConfiguration pools is batch mode.
        """
        if login_mode is not None:
            pulumi.set(__self__, "login_mode", login_mode)

    @property
    @pulumi.getter(name="loginMode")
    def login_mode(self) -> Optional[pulumi.Input['LoginMode']]:
        """
        Specifies login mode for the user. The default value for VirtualMachineConfiguration pools is interactive mode and for CloudServiceConfiguration pools is batch mode.
        """
        return pulumi.get(self, "login_mode")

    @login_mode.setter
    def login_mode(self, value: Optional[pulumi.Input['LoginMode']]):
        pulumi.set(self, "login_mode", value)


