# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetFarmBeatsModelResult',
    'AwaitableGetFarmBeatsModelResult',
    'get_farm_beats_model',
    'get_farm_beats_model_output',
]

@pulumi.output_type
class GetFarmBeatsModelResult:
    """
    FarmBeats ARM Resource.
    """
    def __init__(__self__, id=None, identity=None, instance_uri=None, location=None, name=None, private_endpoint_connections=None, provisioning_state=None, public_network_access=None, sensor_integration=None, system_data=None, tags=None, type=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identity and not isinstance(identity, dict):
            raise TypeError("Expected argument 'identity' to be a dict")
        pulumi.set(__self__, "identity", identity)
        if instance_uri and not isinstance(instance_uri, str):
            raise TypeError("Expected argument 'instance_uri' to be a str")
        pulumi.set(__self__, "instance_uri", instance_uri)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if private_endpoint_connections and not isinstance(private_endpoint_connections, dict):
            raise TypeError("Expected argument 'private_endpoint_connections' to be a dict")
        pulumi.set(__self__, "private_endpoint_connections", private_endpoint_connections)
        if provisioning_state and not isinstance(provisioning_state, str):
            raise TypeError("Expected argument 'provisioning_state' to be a str")
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if public_network_access and not isinstance(public_network_access, str):
            raise TypeError("Expected argument 'public_network_access' to be a str")
        pulumi.set(__self__, "public_network_access", public_network_access)
        if sensor_integration and not isinstance(sensor_integration, dict):
            raise TypeError("Expected argument 'sensor_integration' to be a dict")
        pulumi.set(__self__, "sensor_integration", sensor_integration)
        if system_data and not isinstance(system_data, dict):
            raise TypeError("Expected argument 'system_data' to be a dict")
        pulumi.set(__self__, "system_data", system_data)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def identity(self) -> Optional['outputs.IdentityResponse']:
        """
        Identity for the resource.
        """
        return pulumi.get(self, "identity")

    @property
    @pulumi.getter(name="instanceUri")
    def instance_uri(self) -> str:
        """
        Uri of the FarmBeats instance.
        """
        return pulumi.get(self, "instance_uri")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        The geo-location where the resource lives
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="privateEndpointConnections")
    def private_endpoint_connections(self) -> 'outputs.PrivateEndpointConnectionResponse':
        """
        The private endpoint connection resource.
        """
        return pulumi.get(self, "private_endpoint_connections")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        FarmBeats instance provisioning state.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="publicNetworkAccess")
    def public_network_access(self) -> Optional[str]:
        """
        Property to allow or block public traffic for an Azure FarmBeats resource.
        """
        return pulumi.get(self, "public_network_access")

    @property
    @pulumi.getter(name="sensorIntegration")
    def sensor_integration(self) -> Optional['outputs.SensorIntegrationResponse']:
        """
        Sensor integration request model.
        """
        return pulumi.get(self, "sensor_integration")

    @property
    @pulumi.getter(name="systemData")
    def system_data(self) -> 'outputs.SystemDataResponse':
        """
        Azure Resource Manager metadata containing createdBy and modifiedBy information.
        """
        return pulumi.get(self, "system_data")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
        """
        return pulumi.get(self, "type")


class AwaitableGetFarmBeatsModelResult(GetFarmBeatsModelResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFarmBeatsModelResult(
            id=self.id,
            identity=self.identity,
            instance_uri=self.instance_uri,
            location=self.location,
            name=self.name,
            private_endpoint_connections=self.private_endpoint_connections,
            provisioning_state=self.provisioning_state,
            public_network_access=self.public_network_access,
            sensor_integration=self.sensor_integration,
            system_data=self.system_data,
            tags=self.tags,
            type=self.type)


def get_farm_beats_model(farm_beats_resource_name: Optional[str] = None,
                         resource_group_name: Optional[str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFarmBeatsModelResult:
    """
    Get FarmBeats resource.


    :param str farm_beats_resource_name: FarmBeats resource name.
    :param str resource_group_name: The name of the resource group. The name is case insensitive.
    """
    __args__ = dict()
    __args__['farmBeatsResourceName'] = farm_beats_resource_name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure-native:agfoodplatform/v20210901preview:getFarmBeatsModel', __args__, opts=opts, typ=GetFarmBeatsModelResult).value

    return AwaitableGetFarmBeatsModelResult(
        id=__ret__.id,
        identity=__ret__.identity,
        instance_uri=__ret__.instance_uri,
        location=__ret__.location,
        name=__ret__.name,
        private_endpoint_connections=__ret__.private_endpoint_connections,
        provisioning_state=__ret__.provisioning_state,
        public_network_access=__ret__.public_network_access,
        sensor_integration=__ret__.sensor_integration,
        system_data=__ret__.system_data,
        tags=__ret__.tags,
        type=__ret__.type)


@_utilities.lift_output_func(get_farm_beats_model)
def get_farm_beats_model_output(farm_beats_resource_name: Optional[pulumi.Input[str]] = None,
                                resource_group_name: Optional[pulumi.Input[str]] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetFarmBeatsModelResult]:
    """
    Get FarmBeats resource.


    :param str farm_beats_resource_name: FarmBeats resource name.
    :param str resource_group_name: The name of the resource group. The name is case insensitive.
    """
    ...
