# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetAlertsSuppressionRuleResult',
    'AwaitableGetAlertsSuppressionRuleResult',
    'get_alerts_suppression_rule',
    'get_alerts_suppression_rule_output',
]

@pulumi.output_type
class GetAlertsSuppressionRuleResult:
    """
    Describes the suppression rule
    """
    def __init__(__self__, alert_type=None, comment=None, expiration_date_utc=None, id=None, last_modified_utc=None, name=None, reason=None, state=None, suppression_alerts_scope=None, type=None):
        if alert_type and not isinstance(alert_type, str):
            raise TypeError("Expected argument 'alert_type' to be a str")
        pulumi.set(__self__, "alert_type", alert_type)
        if comment and not isinstance(comment, str):
            raise TypeError("Expected argument 'comment' to be a str")
        pulumi.set(__self__, "comment", comment)
        if expiration_date_utc and not isinstance(expiration_date_utc, str):
            raise TypeError("Expected argument 'expiration_date_utc' to be a str")
        pulumi.set(__self__, "expiration_date_utc", expiration_date_utc)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if last_modified_utc and not isinstance(last_modified_utc, str):
            raise TypeError("Expected argument 'last_modified_utc' to be a str")
        pulumi.set(__self__, "last_modified_utc", last_modified_utc)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if reason and not isinstance(reason, str):
            raise TypeError("Expected argument 'reason' to be a str")
        pulumi.set(__self__, "reason", reason)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if suppression_alerts_scope and not isinstance(suppression_alerts_scope, dict):
            raise TypeError("Expected argument 'suppression_alerts_scope' to be a dict")
        pulumi.set(__self__, "suppression_alerts_scope", suppression_alerts_scope)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="alertType")
    def alert_type(self) -> str:
        """
        Type of the alert to automatically suppress. For all alert types, use '*'
        """
        return pulumi.get(self, "alert_type")

    @property
    @pulumi.getter
    def comment(self) -> Optional[str]:
        """
        Any comment regarding the rule
        """
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter(name="expirationDateUtc")
    def expiration_date_utc(self) -> Optional[str]:
        """
        Expiration date of the rule, if value is not provided or provided as null this field will default to the maximum allowed expiration date.
        """
        return pulumi.get(self, "expiration_date_utc")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Resource Id
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lastModifiedUtc")
    def last_modified_utc(self) -> str:
        """
        The last time this rule was modified
        """
        return pulumi.get(self, "last_modified_utc")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Resource name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def reason(self) -> str:
        """
        The reason for dismissing the alert
        """
        return pulumi.get(self, "reason")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Possible states of the rule
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="suppressionAlertsScope")
    def suppression_alerts_scope(self) -> Optional['outputs.SuppressionAlertsScopeResponse']:
        """
        The suppression conditions
        """
        return pulumi.get(self, "suppression_alerts_scope")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Resource type
        """
        return pulumi.get(self, "type")


class AwaitableGetAlertsSuppressionRuleResult(GetAlertsSuppressionRuleResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAlertsSuppressionRuleResult(
            alert_type=self.alert_type,
            comment=self.comment,
            expiration_date_utc=self.expiration_date_utc,
            id=self.id,
            last_modified_utc=self.last_modified_utc,
            name=self.name,
            reason=self.reason,
            state=self.state,
            suppression_alerts_scope=self.suppression_alerts_scope,
            type=self.type)


def get_alerts_suppression_rule(alerts_suppression_rule_name: Optional[str] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAlertsSuppressionRuleResult:
    """
    Get dismiss rule, with name: {alertsSuppressionRuleName}, for the given subscription


    :param str alerts_suppression_rule_name: The unique name of the suppression alert rule
    """
    __args__ = dict()
    __args__['alertsSuppressionRuleName'] = alerts_suppression_rule_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure-native:security/v20190101preview:getAlertsSuppressionRule', __args__, opts=opts, typ=GetAlertsSuppressionRuleResult).value

    return AwaitableGetAlertsSuppressionRuleResult(
        alert_type=__ret__.alert_type,
        comment=__ret__.comment,
        expiration_date_utc=__ret__.expiration_date_utc,
        id=__ret__.id,
        last_modified_utc=__ret__.last_modified_utc,
        name=__ret__.name,
        reason=__ret__.reason,
        state=__ret__.state,
        suppression_alerts_scope=__ret__.suppression_alerts_scope,
        type=__ret__.type)


@_utilities.lift_output_func(get_alerts_suppression_rule)
def get_alerts_suppression_rule_output(alerts_suppression_rule_name: Optional[pulumi.Input[str]] = None,
                                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAlertsSuppressionRuleResult]:
    """
    Get dismiss rule, with name: {alertsSuppressionRuleName}, for the given subscription


    :param str alerts_suppression_rule_name: The unique name of the suppression alert rule
    """
    ...
