# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetConsoleResult',
    'AwaitableGetConsoleResult',
    'get_console',
    'get_console_output',
]

@pulumi.output_type
class GetConsoleResult:
    def __init__(__self__, detailed_status=None, detailed_status_message=None, enabled=None, expiration=None, extended_location=None, id=None, location=None, name=None, private_link_service_id=None, provisioning_state=None, ssh_public_key=None, system_data=None, tags=None, type=None, virtual_machine_access_id=None):
        if detailed_status and not isinstance(detailed_status, str):
            raise TypeError("Expected argument 'detailed_status' to be a str")
        pulumi.set(__self__, "detailed_status", detailed_status)
        if detailed_status_message and not isinstance(detailed_status_message, str):
            raise TypeError("Expected argument 'detailed_status_message' to be a str")
        pulumi.set(__self__, "detailed_status_message", detailed_status_message)
        if enabled and not isinstance(enabled, str):
            raise TypeError("Expected argument 'enabled' to be a str")
        pulumi.set(__self__, "enabled", enabled)
        if expiration and not isinstance(expiration, str):
            raise TypeError("Expected argument 'expiration' to be a str")
        pulumi.set(__self__, "expiration", expiration)
        if extended_location and not isinstance(extended_location, dict):
            raise TypeError("Expected argument 'extended_location' to be a dict")
        pulumi.set(__self__, "extended_location", extended_location)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if private_link_service_id and not isinstance(private_link_service_id, str):
            raise TypeError("Expected argument 'private_link_service_id' to be a str")
        pulumi.set(__self__, "private_link_service_id", private_link_service_id)
        if provisioning_state and not isinstance(provisioning_state, str):
            raise TypeError("Expected argument 'provisioning_state' to be a str")
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if ssh_public_key and not isinstance(ssh_public_key, dict):
            raise TypeError("Expected argument 'ssh_public_key' to be a dict")
        pulumi.set(__self__, "ssh_public_key", ssh_public_key)
        if system_data and not isinstance(system_data, dict):
            raise TypeError("Expected argument 'system_data' to be a dict")
        pulumi.set(__self__, "system_data", system_data)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if virtual_machine_access_id and not isinstance(virtual_machine_access_id, str):
            raise TypeError("Expected argument 'virtual_machine_access_id' to be a str")
        pulumi.set(__self__, "virtual_machine_access_id", virtual_machine_access_id)

    @property
    @pulumi.getter(name="detailedStatus")
    def detailed_status(self) -> str:
        """
        The more detailed status of the console.
        """
        return pulumi.get(self, "detailed_status")

    @property
    @pulumi.getter(name="detailedStatusMessage")
    def detailed_status_message(self) -> str:
        """
        The descriptive message about the current detailed status.
        """
        return pulumi.get(self, "detailed_status_message")

    @property
    @pulumi.getter
    def enabled(self) -> str:
        """
        The indicator of whether the console access is enabled.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def expiration(self) -> Optional[str]:
        """
        The date and time after which the key will be disallowed access.
        """
        return pulumi.get(self, "expiration")

    @property
    @pulumi.getter(name="extendedLocation")
    def extended_location(self) -> 'outputs.ExtendedLocationResponse':
        """
        The extended location of the cluster manager associated with the cluster this virtual machine is created on.
        """
        return pulumi.get(self, "extended_location")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        The geo-location where the resource lives
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="privateLinkServiceId")
    def private_link_service_id(self) -> str:
        """
        The resource ID of the private link service that is used to provide virtual machine console access.
        """
        return pulumi.get(self, "private_link_service_id")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the virtual machine console.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="sshPublicKey")
    def ssh_public_key(self) -> 'outputs.SshPublicKeyResponse':
        """
        The SSH public key that will be provisioned for user access. The user is expected to have the corresponding SSH private key for logging in.
        """
        return pulumi.get(self, "ssh_public_key")

    @property
    @pulumi.getter(name="systemData")
    def system_data(self) -> 'outputs.SystemDataResponse':
        """
        Azure Resource Manager metadata containing createdBy and modifiedBy information.
        """
        return pulumi.get(self, "system_data")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="virtualMachineAccessId")
    def virtual_machine_access_id(self) -> str:
        """
        The unique identifier for the virtual machine that is used to access the console.
        """
        return pulumi.get(self, "virtual_machine_access_id")


class AwaitableGetConsoleResult(GetConsoleResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetConsoleResult(
            detailed_status=self.detailed_status,
            detailed_status_message=self.detailed_status_message,
            enabled=self.enabled,
            expiration=self.expiration,
            extended_location=self.extended_location,
            id=self.id,
            location=self.location,
            name=self.name,
            private_link_service_id=self.private_link_service_id,
            provisioning_state=self.provisioning_state,
            ssh_public_key=self.ssh_public_key,
            system_data=self.system_data,
            tags=self.tags,
            type=self.type,
            virtual_machine_access_id=self.virtual_machine_access_id)


def get_console(console_name: Optional[str] = None,
                resource_group_name: Optional[str] = None,
                virtual_machine_name: Optional[str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetConsoleResult:
    """
    Get properties of the provided virtual machine console.
    API Version: 2022-12-12-preview.


    :param str console_name: The name of the virtual machine console.
    :param str resource_group_name: The name of the resource group. The name is case insensitive.
    :param str virtual_machine_name: The name of the virtual machine.
    """
    __args__ = dict()
    __args__['consoleName'] = console_name
    __args__['resourceGroupName'] = resource_group_name
    __args__['virtualMachineName'] = virtual_machine_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure-native:networkcloud:getConsole', __args__, opts=opts, typ=GetConsoleResult).value

    return AwaitableGetConsoleResult(
        detailed_status=__ret__.detailed_status,
        detailed_status_message=__ret__.detailed_status_message,
        enabled=__ret__.enabled,
        expiration=__ret__.expiration,
        extended_location=__ret__.extended_location,
        id=__ret__.id,
        location=__ret__.location,
        name=__ret__.name,
        private_link_service_id=__ret__.private_link_service_id,
        provisioning_state=__ret__.provisioning_state,
        ssh_public_key=__ret__.ssh_public_key,
        system_data=__ret__.system_data,
        tags=__ret__.tags,
        type=__ret__.type,
        virtual_machine_access_id=__ret__.virtual_machine_access_id)


@_utilities.lift_output_func(get_console)
def get_console_output(console_name: Optional[pulumi.Input[str]] = None,
                       resource_group_name: Optional[pulumi.Input[str]] = None,
                       virtual_machine_name: Optional[pulumi.Input[str]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetConsoleResult]:
    """
    Get properties of the provided virtual machine console.
    API Version: 2022-12-12-preview.


    :param str console_name: The name of the virtual machine console.
    :param str resource_group_name: The name of the resource group. The name is case insensitive.
    :param str virtual_machine_name: The name of the virtual machine.
    """
    ...
