# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AkamaiAccessControlResponse',
    'AkamaiSignatureHeaderAuthenticationKeyResponse',
    'ArmStreamingEndpointCurrentSkuResponse',
    'CrossSiteAccessPoliciesResponse',
    'HlsResponse',
    'IPAccessControlResponse',
    'IPRangeResponse',
    'LiveEventEncodingResponse',
    'LiveEventEndpointResponse',
    'LiveEventIngestInterruptionResponse',
    'LiveEventIngestionResponse',
    'LiveEventInputAccessControlResponse',
    'LiveEventInputResponse',
    'LiveEventInputTrackSelectionResponse',
    'LiveEventOutputTranscriptionTrackResponse',
    'LiveEventPreviewAccessControlResponse',
    'LiveEventPreviewResponse',
    'LiveEventStatusResponse',
    'LiveEventStreamEventDataResponse',
    'LiveEventStreamEventResponse',
    'LiveEventTimedMetadataEndpointResponse',
    'LiveEventTrackEventDataResponse',
    'LiveEventTrackEventResponse',
    'LiveEventTrackStatusResponse',
    'LiveEventTranscriptionResponse',
    'StreamingEndpointAccessControlResponse',
    'SystemDataResponse',
]

@pulumi.output_type
class AkamaiAccessControlResponse(dict):
    """
    Akamai access control
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "akamaiSignatureHeaderAuthenticationKeyList":
            suggest = "akamai_signature_header_authentication_key_list"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AkamaiAccessControlResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AkamaiAccessControlResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AkamaiAccessControlResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 akamai_signature_header_authentication_key_list: Optional[Sequence['outputs.AkamaiSignatureHeaderAuthenticationKeyResponse']] = None):
        """
        Akamai access control
        :param Sequence['AkamaiSignatureHeaderAuthenticationKeyResponse'] akamai_signature_header_authentication_key_list: authentication key list
        """
        if akamai_signature_header_authentication_key_list is not None:
            pulumi.set(__self__, "akamai_signature_header_authentication_key_list", akamai_signature_header_authentication_key_list)

    @property
    @pulumi.getter(name="akamaiSignatureHeaderAuthenticationKeyList")
    def akamai_signature_header_authentication_key_list(self) -> Optional[Sequence['outputs.AkamaiSignatureHeaderAuthenticationKeyResponse']]:
        """
        authentication key list
        """
        return pulumi.get(self, "akamai_signature_header_authentication_key_list")


@pulumi.output_type
class AkamaiSignatureHeaderAuthenticationKeyResponse(dict):
    """
    Akamai Signature Header authentication key.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "base64Key":
            suggest = "base64_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AkamaiSignatureHeaderAuthenticationKeyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AkamaiSignatureHeaderAuthenticationKeyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AkamaiSignatureHeaderAuthenticationKeyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 base64_key: Optional[str] = None,
                 expiration: Optional[str] = None,
                 identifier: Optional[str] = None):
        """
        Akamai Signature Header authentication key.
        :param str base64_key: authentication key
        :param str expiration: The expiration time of the authentication key.
        :param str identifier: identifier of the key
        """
        if base64_key is not None:
            pulumi.set(__self__, "base64_key", base64_key)
        if expiration is not None:
            pulumi.set(__self__, "expiration", expiration)
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)

    @property
    @pulumi.getter(name="base64Key")
    def base64_key(self) -> Optional[str]:
        """
        authentication key
        """
        return pulumi.get(self, "base64_key")

    @property
    @pulumi.getter
    def expiration(self) -> Optional[str]:
        """
        The expiration time of the authentication key.
        """
        return pulumi.get(self, "expiration")

    @property
    @pulumi.getter
    def identifier(self) -> Optional[str]:
        """
        identifier of the key
        """
        return pulumi.get(self, "identifier")


@pulumi.output_type
class ArmStreamingEndpointCurrentSkuResponse(dict):
    """
    The streaming endpoint current sku.
    """
    def __init__(__self__, *,
                 name: str,
                 capacity: Optional[int] = None):
        """
        The streaming endpoint current sku.
        :param str name: The streaming endpoint sku name.
        :param int capacity: The streaming endpoint sku capacity.
        """
        pulumi.set(__self__, "name", name)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The streaming endpoint sku name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def capacity(self) -> Optional[int]:
        """
        The streaming endpoint sku capacity.
        """
        return pulumi.get(self, "capacity")


@pulumi.output_type
class CrossSiteAccessPoliciesResponse(dict):
    """
    The client access policy.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientAccessPolicy":
            suggest = "client_access_policy"
        elif key == "crossDomainPolicy":
            suggest = "cross_domain_policy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CrossSiteAccessPoliciesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CrossSiteAccessPoliciesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CrossSiteAccessPoliciesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_access_policy: Optional[str] = None,
                 cross_domain_policy: Optional[str] = None):
        """
        The client access policy.
        :param str client_access_policy: The content of clientaccesspolicy.xml used by Silverlight.
        :param str cross_domain_policy: The content of crossdomain.xml used by Silverlight.
        """
        if client_access_policy is not None:
            pulumi.set(__self__, "client_access_policy", client_access_policy)
        if cross_domain_policy is not None:
            pulumi.set(__self__, "cross_domain_policy", cross_domain_policy)

    @property
    @pulumi.getter(name="clientAccessPolicy")
    def client_access_policy(self) -> Optional[str]:
        """
        The content of clientaccesspolicy.xml used by Silverlight.
        """
        return pulumi.get(self, "client_access_policy")

    @property
    @pulumi.getter(name="crossDomainPolicy")
    def cross_domain_policy(self) -> Optional[str]:
        """
        The content of crossdomain.xml used by Silverlight.
        """
        return pulumi.get(self, "cross_domain_policy")


@pulumi.output_type
class HlsResponse(dict):
    """
    HTTP Live Streaming (HLS) packing setting for the live output.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fragmentsPerTsSegment":
            suggest = "fragments_per_ts_segment"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HlsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HlsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HlsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fragments_per_ts_segment: Optional[int] = None):
        """
        HTTP Live Streaming (HLS) packing setting for the live output.
        :param int fragments_per_ts_segment: The number of fragments in an HTTP Live Streaming (HLS) TS segment in the output of the live event. This value does not affect the packing ratio for HLS CMAF output.
        """
        if fragments_per_ts_segment is not None:
            pulumi.set(__self__, "fragments_per_ts_segment", fragments_per_ts_segment)

    @property
    @pulumi.getter(name="fragmentsPerTsSegment")
    def fragments_per_ts_segment(self) -> Optional[int]:
        """
        The number of fragments in an HTTP Live Streaming (HLS) TS segment in the output of the live event. This value does not affect the packing ratio for HLS CMAF output.
        """
        return pulumi.get(self, "fragments_per_ts_segment")


@pulumi.output_type
class IPAccessControlResponse(dict):
    """
    The IP access control.
    """
    def __init__(__self__, *,
                 allow: Optional[Sequence['outputs.IPRangeResponse']] = None):
        """
        The IP access control.
        :param Sequence['IPRangeResponse'] allow: The IP allow list.
        """
        if allow is not None:
            pulumi.set(__self__, "allow", allow)

    @property
    @pulumi.getter
    def allow(self) -> Optional[Sequence['outputs.IPRangeResponse']]:
        """
        The IP allow list.
        """
        return pulumi.get(self, "allow")


@pulumi.output_type
class IPRangeResponse(dict):
    """
    The IP address range in the CIDR scheme.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "subnetPrefixLength":
            suggest = "subnet_prefix_length"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IPRangeResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IPRangeResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IPRangeResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: Optional[str] = None,
                 name: Optional[str] = None,
                 subnet_prefix_length: Optional[int] = None):
        """
        The IP address range in the CIDR scheme.
        :param str address: The IP address.
        :param str name: The friendly name for the IP address range.
        :param int subnet_prefix_length: The subnet mask prefix length (see CIDR notation).
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if subnet_prefix_length is not None:
            pulumi.set(__self__, "subnet_prefix_length", subnet_prefix_length)

    @property
    @pulumi.getter
    def address(self) -> Optional[str]:
        """
        The IP address.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The friendly name for the IP address range.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="subnetPrefixLength")
    def subnet_prefix_length(self) -> Optional[int]:
        """
        The subnet mask prefix length (see CIDR notation).
        """
        return pulumi.get(self, "subnet_prefix_length")


@pulumi.output_type
class LiveEventEncodingResponse(dict):
    """
    Specifies the live event type and optional encoding settings for encoding live events.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "encodingType":
            suggest = "encoding_type"
        elif key == "keyFrameInterval":
            suggest = "key_frame_interval"
        elif key == "presetName":
            suggest = "preset_name"
        elif key == "stretchMode":
            suggest = "stretch_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LiveEventEncodingResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LiveEventEncodingResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LiveEventEncodingResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 encoding_type: Optional[str] = None,
                 key_frame_interval: Optional[str] = None,
                 preset_name: Optional[str] = None,
                 stretch_mode: Optional[str] = None):
        """
        Specifies the live event type and optional encoding settings for encoding live events.
        :param str encoding_type: Live event type. When encodingType is set to PassthroughBasic or PassthroughStandard, the service simply passes through the incoming video and audio layer(s) to the output. When encodingType is set to Standard or Premium1080p, a live encoder transcodes the incoming stream into multiple bitrates or layers. See https://go.microsoft.com/fwlink/?linkid=2095101 for more information. This property cannot be modified after the live event is created.
        :param str key_frame_interval: Use an ISO 8601 time value between 0.5 to 20 seconds to specify the output fragment length for the video and audio tracks of an encoding live event. For example, use PT2S to indicate 2 seconds. For the video track it also defines the key frame interval, or the length of a GoP (group of pictures).   If this value is not set for an encoding live event, the fragment duration defaults to 2 seconds. The value cannot be set for pass-through live events.
        :param str preset_name: The optional encoding preset name, used when encodingType is not None. This value is specified at creation time and cannot be updated. If the encodingType is set to Standard, then the default preset name is ‘Default720p’. Else if the encodingType is set to Premium1080p, the default preset is ‘Default1080p’.
        :param str stretch_mode: Specifies how the input video will be resized to fit the desired output resolution(s). Default is None
        """
        if encoding_type is not None:
            pulumi.set(__self__, "encoding_type", encoding_type)
        if key_frame_interval is not None:
            pulumi.set(__self__, "key_frame_interval", key_frame_interval)
        if preset_name is not None:
            pulumi.set(__self__, "preset_name", preset_name)
        if stretch_mode is not None:
            pulumi.set(__self__, "stretch_mode", stretch_mode)

    @property
    @pulumi.getter(name="encodingType")
    def encoding_type(self) -> Optional[str]:
        """
        Live event type. When encodingType is set to PassthroughBasic or PassthroughStandard, the service simply passes through the incoming video and audio layer(s) to the output. When encodingType is set to Standard or Premium1080p, a live encoder transcodes the incoming stream into multiple bitrates or layers. See https://go.microsoft.com/fwlink/?linkid=2095101 for more information. This property cannot be modified after the live event is created.
        """
        return pulumi.get(self, "encoding_type")

    @property
    @pulumi.getter(name="keyFrameInterval")
    def key_frame_interval(self) -> Optional[str]:
        """
        Use an ISO 8601 time value between 0.5 to 20 seconds to specify the output fragment length for the video and audio tracks of an encoding live event. For example, use PT2S to indicate 2 seconds. For the video track it also defines the key frame interval, or the length of a GoP (group of pictures).   If this value is not set for an encoding live event, the fragment duration defaults to 2 seconds. The value cannot be set for pass-through live events.
        """
        return pulumi.get(self, "key_frame_interval")

    @property
    @pulumi.getter(name="presetName")
    def preset_name(self) -> Optional[str]:
        """
        The optional encoding preset name, used when encodingType is not None. This value is specified at creation time and cannot be updated. If the encodingType is set to Standard, then the default preset name is ‘Default720p’. Else if the encodingType is set to Premium1080p, the default preset is ‘Default1080p’.
        """
        return pulumi.get(self, "preset_name")

    @property
    @pulumi.getter(name="stretchMode")
    def stretch_mode(self) -> Optional[str]:
        """
        Specifies how the input video will be resized to fit the desired output resolution(s). Default is None
        """
        return pulumi.get(self, "stretch_mode")


@pulumi.output_type
class LiveEventEndpointResponse(dict):
    """
    The live event endpoint.
    """
    def __init__(__self__, *,
                 protocol: Optional[str] = None,
                 url: Optional[str] = None):
        """
        The live event endpoint.
        :param str protocol: The endpoint protocol.
        :param str url: The endpoint URL.
        """
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[str]:
        """
        The endpoint protocol.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter
    def url(self) -> Optional[str]:
        """
        The endpoint URL.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class LiveEventIngestInterruptionResponse(dict):
    """
    The live event ingest interruption data.
    """
    def __init__(__self__, *,
                 begin: Optional[str] = None,
                 duration: Optional[str] = None,
                 end: Optional[str] = None,
                 reason: Optional[str] = None):
        """
        The live event ingest interruption data.
        :param str begin: UTC time of interruption start, encoder disconnected.
        :param str duration: Duration of interruption in ISO 8601 time. For example, use PT1H30M to indicate 1 hour and 30 minutes.
        :param str end: UTC time of interruption end, encoder re-connected.
        :param str reason: Interruption reason.
        """
        if begin is not None:
            pulumi.set(__self__, "begin", begin)
        if duration is not None:
            pulumi.set(__self__, "duration", duration)
        if end is not None:
            pulumi.set(__self__, "end", end)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)

    @property
    @pulumi.getter
    def begin(self) -> Optional[str]:
        """
        UTC time of interruption start, encoder disconnected.
        """
        return pulumi.get(self, "begin")

    @property
    @pulumi.getter
    def duration(self) -> Optional[str]:
        """
        Duration of interruption in ISO 8601 time. For example, use PT1H30M to indicate 1 hour and 30 minutes.
        """
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter
    def end(self) -> Optional[str]:
        """
        UTC time of interruption end, encoder re-connected.
        """
        return pulumi.get(self, "end")

    @property
    @pulumi.getter
    def reason(self) -> Optional[str]:
        """
        Interruption reason.
        """
        return pulumi.get(self, "reason")


@pulumi.output_type
class LiveEventIngestionResponse(dict):
    """
    The live event ingestion telemetry data.
    """
    def __init__(__self__, *,
                 begin: Optional[str] = None,
                 end: Optional[str] = None,
                 end_reason: Optional[str] = None,
                 ingest_interruptions: Optional[Sequence['outputs.LiveEventIngestInterruptionResponse']] = None,
                 stream_name: Optional[str] = None):
        """
        The live event ingestion telemetry data.
        :param str begin: Ingestion begin time in UTC.
        :param str end: Ingestion end time in UTC. Empty if it's not stopped yet.
        :param str end_reason: Reason why ingestion stops. Empty if it's not stopped yet. E.g) Service Stopped. No Ingestion.
        :param Sequence['LiveEventIngestInterruptionResponse'] ingest_interruptions: IngestInterruption entry list.
        :param str stream_name: Ingestion stream name.
        """
        if begin is not None:
            pulumi.set(__self__, "begin", begin)
        if end is not None:
            pulumi.set(__self__, "end", end)
        if end_reason is not None:
            pulumi.set(__self__, "end_reason", end_reason)
        if ingest_interruptions is not None:
            pulumi.set(__self__, "ingest_interruptions", ingest_interruptions)
        if stream_name is not None:
            pulumi.set(__self__, "stream_name", stream_name)

    @property
    @pulumi.getter
    def begin(self) -> Optional[str]:
        """
        Ingestion begin time in UTC.
        """
        return pulumi.get(self, "begin")

    @property
    @pulumi.getter
    def end(self) -> Optional[str]:
        """
        Ingestion end time in UTC. Empty if it's not stopped yet.
        """
        return pulumi.get(self, "end")

    @property
    @pulumi.getter(name="endReason")
    def end_reason(self) -> Optional[str]:
        """
        Reason why ingestion stops. Empty if it's not stopped yet. E.g) Service Stopped. No Ingestion.
        """
        return pulumi.get(self, "end_reason")

    @property
    @pulumi.getter(name="ingestInterruptions")
    def ingest_interruptions(self) -> Optional[Sequence['outputs.LiveEventIngestInterruptionResponse']]:
        """
        IngestInterruption entry list.
        """
        return pulumi.get(self, "ingest_interruptions")

    @property
    @pulumi.getter(name="streamName")
    def stream_name(self) -> Optional[str]:
        """
        Ingestion stream name.
        """
        return pulumi.get(self, "stream_name")


@pulumi.output_type
class LiveEventInputAccessControlResponse(dict):
    """
    The IP access control for live event input.
    """
    def __init__(__self__, *,
                 ip: Optional['outputs.IPAccessControlResponse'] = None):
        """
        The IP access control for live event input.
        :param 'IPAccessControlResponse' ip: The IP access control properties.
        """
        if ip is not None:
            pulumi.set(__self__, "ip", ip)

    @property
    @pulumi.getter
    def ip(self) -> Optional['outputs.IPAccessControlResponse']:
        """
        The IP access control properties.
        """
        return pulumi.get(self, "ip")


@pulumi.output_type
class LiveEventInputResponse(dict):
    """
    The live event input.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "streamingProtocol":
            suggest = "streaming_protocol"
        elif key == "accessControl":
            suggest = "access_control"
        elif key == "accessToken":
            suggest = "access_token"
        elif key == "keyFrameIntervalDuration":
            suggest = "key_frame_interval_duration"
        elif key == "timedMetadataEndpoints":
            suggest = "timed_metadata_endpoints"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LiveEventInputResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LiveEventInputResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LiveEventInputResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 streaming_protocol: str,
                 access_control: Optional['outputs.LiveEventInputAccessControlResponse'] = None,
                 access_token: Optional[str] = None,
                 endpoints: Optional[Sequence['outputs.LiveEventEndpointResponse']] = None,
                 key_frame_interval_duration: Optional[str] = None,
                 timed_metadata_endpoints: Optional[Sequence['outputs.LiveEventTimedMetadataEndpointResponse']] = None):
        """
        The live event input.
        :param str streaming_protocol: The input protocol for the live event. This is specified at creation time and cannot be updated.
        :param 'LiveEventInputAccessControlResponse' access_control: Access control for live event input.
        :param str access_token: A UUID in string form to uniquely identify the stream. This can be specified at creation time but cannot be updated. If omitted, the service will generate a unique value.
        :param Sequence['LiveEventEndpointResponse'] endpoints: The input endpoints for the live event.
        :param str key_frame_interval_duration: ISO 8601 time duration of the key frame interval duration of the input. This value sets the EXT-X-TARGETDURATION property in the HLS output. For example, use PT2S to indicate 2 seconds. Leave the value empty for encoding live events.
        :param Sequence['LiveEventTimedMetadataEndpointResponse'] timed_metadata_endpoints: The metadata endpoints for the live event.
        """
        pulumi.set(__self__, "streaming_protocol", streaming_protocol)
        if access_control is not None:
            pulumi.set(__self__, "access_control", access_control)
        if access_token is not None:
            pulumi.set(__self__, "access_token", access_token)
        if endpoints is not None:
            pulumi.set(__self__, "endpoints", endpoints)
        if key_frame_interval_duration is not None:
            pulumi.set(__self__, "key_frame_interval_duration", key_frame_interval_duration)
        if timed_metadata_endpoints is not None:
            pulumi.set(__self__, "timed_metadata_endpoints", timed_metadata_endpoints)

    @property
    @pulumi.getter(name="streamingProtocol")
    def streaming_protocol(self) -> str:
        """
        The input protocol for the live event. This is specified at creation time and cannot be updated.
        """
        return pulumi.get(self, "streaming_protocol")

    @property
    @pulumi.getter(name="accessControl")
    def access_control(self) -> Optional['outputs.LiveEventInputAccessControlResponse']:
        """
        Access control for live event input.
        """
        return pulumi.get(self, "access_control")

    @property
    @pulumi.getter(name="accessToken")
    def access_token(self) -> Optional[str]:
        """
        A UUID in string form to uniquely identify the stream. This can be specified at creation time but cannot be updated. If omitted, the service will generate a unique value.
        """
        return pulumi.get(self, "access_token")

    @property
    @pulumi.getter
    def endpoints(self) -> Optional[Sequence['outputs.LiveEventEndpointResponse']]:
        """
        The input endpoints for the live event.
        """
        return pulumi.get(self, "endpoints")

    @property
    @pulumi.getter(name="keyFrameIntervalDuration")
    def key_frame_interval_duration(self) -> Optional[str]:
        """
        ISO 8601 time duration of the key frame interval duration of the input. This value sets the EXT-X-TARGETDURATION property in the HLS output. For example, use PT2S to indicate 2 seconds. Leave the value empty for encoding live events.
        """
        return pulumi.get(self, "key_frame_interval_duration")

    @property
    @pulumi.getter(name="timedMetadataEndpoints")
    def timed_metadata_endpoints(self) -> Optional[Sequence['outputs.LiveEventTimedMetadataEndpointResponse']]:
        """
        The metadata endpoints for the live event.
        """
        return pulumi.get(self, "timed_metadata_endpoints")


@pulumi.output_type
class LiveEventInputTrackSelectionResponse(dict):
    """
    A track selection condition. This property is reserved for future use, any value set on this property will be ignored.
    """
    def __init__(__self__, *,
                 operation: Optional[str] = None,
                 property: Optional[str] = None,
                 value: Optional[str] = None):
        """
        A track selection condition. This property is reserved for future use, any value set on this property will be ignored.
        :param str operation: Comparing operation. This property is reserved for future use, any value set on this property will be ignored.
        :param str property: Property name to select. This property is reserved for future use, any value set on this property will be ignored.
        :param str value: Property value to select. This property is reserved for future use, any value set on this property will be ignored.
        """
        if operation is not None:
            pulumi.set(__self__, "operation", operation)
        if property is not None:
            pulumi.set(__self__, "property", property)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def operation(self) -> Optional[str]:
        """
        Comparing operation. This property is reserved for future use, any value set on this property will be ignored.
        """
        return pulumi.get(self, "operation")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        Property value to select. This property is reserved for future use, any value set on this property will be ignored.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter
    def property(self) -> Optional[str]:
        """
        Property name to select. This property is reserved for future use, any value set on this property will be ignored.
        """
        return pulumi.get(self, "property")


@pulumi.output_type
class LiveEventOutputTranscriptionTrackResponse(dict):
    """
    Describes a transcription track in the output of a live event, generated using speech-to-text transcription. This property is reserved for future use, any value set on this property will be ignored.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "trackName":
            suggest = "track_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LiveEventOutputTranscriptionTrackResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LiveEventOutputTranscriptionTrackResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LiveEventOutputTranscriptionTrackResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 track_name: str):
        """
        Describes a transcription track in the output of a live event, generated using speech-to-text transcription. This property is reserved for future use, any value set on this property will be ignored.
        :param str track_name: The output track name. This property is reserved for future use, any value set on this property will be ignored.
        """
        pulumi.set(__self__, "track_name", track_name)

    @property
    @pulumi.getter(name="trackName")
    def track_name(self) -> str:
        """
        The output track name. This property is reserved for future use, any value set on this property will be ignored.
        """
        return pulumi.get(self, "track_name")


@pulumi.output_type
class LiveEventPreviewAccessControlResponse(dict):
    """
    The IP access control for the live event preview endpoint.
    """
    def __init__(__self__, *,
                 ip: Optional['outputs.IPAccessControlResponse'] = None):
        """
        The IP access control for the live event preview endpoint.
        :param 'IPAccessControlResponse' ip: The IP access control properties.
        """
        if ip is not None:
            pulumi.set(__self__, "ip", ip)

    @property
    @pulumi.getter
    def ip(self) -> Optional['outputs.IPAccessControlResponse']:
        """
        The IP access control properties.
        """
        return pulumi.get(self, "ip")


@pulumi.output_type
class LiveEventPreviewResponse(dict):
    """
    Live event preview settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessControl":
            suggest = "access_control"
        elif key == "alternativeMediaId":
            suggest = "alternative_media_id"
        elif key == "previewLocator":
            suggest = "preview_locator"
        elif key == "streamingPolicyName":
            suggest = "streaming_policy_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LiveEventPreviewResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LiveEventPreviewResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LiveEventPreviewResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_control: Optional['outputs.LiveEventPreviewAccessControlResponse'] = None,
                 alternative_media_id: Optional[str] = None,
                 endpoints: Optional[Sequence['outputs.LiveEventEndpointResponse']] = None,
                 preview_locator: Optional[str] = None,
                 streaming_policy_name: Optional[str] = None):
        """
        Live event preview settings.
        :param 'LiveEventPreviewAccessControlResponse' access_control: The access control for live event preview.
        :param str alternative_media_id: An alternative media identifier associated with the streaming locator created for the preview. This value is specified at creation time and cannot be updated. The identifier can be used in the CustomLicenseAcquisitionUrlTemplate or the CustomKeyAcquisitionUrlTemplate of the StreamingPolicy specified in the StreamingPolicyName field.
        :param Sequence['LiveEventEndpointResponse'] endpoints: The endpoints for preview. Do not share the preview URL with the live event audience.
        :param str preview_locator: The identifier of the preview locator in Guid format. Specifying this at creation time allows the caller to know the preview locator url before the event is created. If omitted, the service will generate a random identifier. This value cannot be updated once the live event is created.
        :param str streaming_policy_name: The name of streaming policy used for the live event preview. This value is specified at creation time and cannot be updated.
        """
        if access_control is not None:
            pulumi.set(__self__, "access_control", access_control)
        if alternative_media_id is not None:
            pulumi.set(__self__, "alternative_media_id", alternative_media_id)
        if endpoints is not None:
            pulumi.set(__self__, "endpoints", endpoints)
        if preview_locator is not None:
            pulumi.set(__self__, "preview_locator", preview_locator)
        if streaming_policy_name is not None:
            pulumi.set(__self__, "streaming_policy_name", streaming_policy_name)

    @property
    @pulumi.getter(name="accessControl")
    def access_control(self) -> Optional['outputs.LiveEventPreviewAccessControlResponse']:
        """
        The access control for live event preview.
        """
        return pulumi.get(self, "access_control")

    @property
    @pulumi.getter(name="alternativeMediaId")
    def alternative_media_id(self) -> Optional[str]:
        """
        An alternative media identifier associated with the streaming locator created for the preview. This value is specified at creation time and cannot be updated. The identifier can be used in the CustomLicenseAcquisitionUrlTemplate or the CustomKeyAcquisitionUrlTemplate of the StreamingPolicy specified in the StreamingPolicyName field.
        """
        return pulumi.get(self, "alternative_media_id")

    @property
    @pulumi.getter
    def endpoints(self) -> Optional[Sequence['outputs.LiveEventEndpointResponse']]:
        """
        The endpoints for preview. Do not share the preview URL with the live event audience.
        """
        return pulumi.get(self, "endpoints")

    @property
    @pulumi.getter(name="previewLocator")
    def preview_locator(self) -> Optional[str]:
        """
        The identifier of the preview locator in Guid format. Specifying this at creation time allows the caller to know the preview locator url before the event is created. If omitted, the service will generate a random identifier. This value cannot be updated once the live event is created.
        """
        return pulumi.get(self, "preview_locator")

    @property
    @pulumi.getter(name="streamingPolicyName")
    def streaming_policy_name(self) -> Optional[str]:
        """
        The name of streaming policy used for the live event preview. This value is specified at creation time and cannot be updated.
        """
        return pulumi.get(self, "streaming_policy_name")


@pulumi.output_type
class LiveEventStatusResponse(dict):
    """
    The live event status.
    """
    def __init__(__self__, *,
                 health_descriptions: Optional[Sequence[str]] = None,
                 health_status: Optional[str] = None,
                 ingestion: Optional['outputs.LiveEventIngestionResponse'] = None,
                 last_updated_time: Optional[str] = None,
                 state: Optional[str] = None,
                 track_status: Optional[Sequence['outputs.LiveEventTrackStatusResponse']] = None):
        """
        The live event status.
        :param Sequence[str] health_descriptions: List of strings justifying the health status.
        :param str health_status: Health status of last 20 seconds.
        :param 'LiveEventIngestionResponse' ingestion: Live event ingestion entry.
        :param str last_updated_time: Last updated UTC time of this status.
        :param str state: Current state of the live event. See https://go.microsoft.com/fwlink/?linkid=2139012 for more information.
        :param Sequence['LiveEventTrackStatusResponse'] track_status: Track entry list.
        """
        if health_descriptions is not None:
            pulumi.set(__self__, "health_descriptions", health_descriptions)
        if health_status is not None:
            pulumi.set(__self__, "health_status", health_status)
        if ingestion is not None:
            pulumi.set(__self__, "ingestion", ingestion)
        if last_updated_time is not None:
            pulumi.set(__self__, "last_updated_time", last_updated_time)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if track_status is not None:
            pulumi.set(__self__, "track_status", track_status)

    @property
    @pulumi.getter(name="healthDescriptions")
    def health_descriptions(self) -> Optional[Sequence[str]]:
        """
        List of strings justifying the health status.
        """
        return pulumi.get(self, "health_descriptions")

    @property
    @pulumi.getter(name="healthStatus")
    def health_status(self) -> Optional[str]:
        """
        Health status of last 20 seconds.
        """
        return pulumi.get(self, "health_status")

    @property
    @pulumi.getter
    def ingestion(self) -> Optional['outputs.LiveEventIngestionResponse']:
        """
        Live event ingestion entry.
        """
        return pulumi.get(self, "ingestion")

    @property
    @pulumi.getter(name="lastUpdatedTime")
    def last_updated_time(self) -> Optional[str]:
        """
        Last updated UTC time of this status.
        """
        return pulumi.get(self, "last_updated_time")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        Current state of the live event. See https://go.microsoft.com/fwlink/?linkid=2139012 for more information.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="trackStatus")
    def track_status(self) -> Optional[Sequence['outputs.LiveEventTrackStatusResponse']]:
        """
        Track entry list.
        """
        return pulumi.get(self, "track_status")


@pulumi.output_type
class LiveEventStreamEventDataResponse(dict):
    """
    The live event stream event data.
    """
    def __init__(__self__, *,
                 bitrate: Optional[float] = None,
                 current_fragment_timestamp: Optional[str] = None,
                 discontinuity_gap: Optional[float] = None,
                 duration: Optional[str] = None,
                 fragment_drop_reason: Optional[str] = None,
                 fragment_one_duration: Optional[str] = None,
                 fragment_one_timestamp: Optional[str] = None,
                 fragment_two_duration: Optional[str] = None,
                 fragment_two_timestamp: Optional[str] = None,
                 max_time: Optional[str] = None,
                 max_time_media_type: Optional[str] = None,
                 media_timestamp: Optional[str] = None,
                 media_type: Optional[str] = None,
                 min_time: Optional[str] = None,
                 min_time_media_type: Optional[str] = None,
                 previous_fragment_duration: Optional[str] = None,
                 previous_fragment_timestamp: Optional[str] = None,
                 remote_ip: Optional[str] = None,
                 remote_port: Optional[str] = None,
                 resolution: Optional[str] = None,
                 result_code: Optional[str] = None,
                 result_message: Optional[str] = None,
                 stream_id: Optional[str] = None,
                 stream_name: Optional[str] = None,
                 timescale: Optional[str] = None,
                 timescale_of_max_time: Optional[str] = None,
                 timescale_of_min_time: Optional[str] = None,
                 track_id: Optional[int] = None,
                 track_name: Optional[str] = None):
        """
        The live event stream event data.
        :param float bitrate: Bitrate of the track.
        :param str current_fragment_timestamp: Current fragment timestamp in timescale.
        :param float discontinuity_gap: Length of the discontinuity gap in timescale.
        :param str duration: Fragment duration.
        :param str fragment_drop_reason: Reason the fragment was dropped.
        :param str fragment_one_duration: Duration of first fragment used to make a comparison, in timescale.
        :param str fragment_one_timestamp: Timestamp of first fragment used to make a comparison, in timescale.
        :param str fragment_two_duration: Duration of second fragment used to make a comparison, in timescale.
        :param str fragment_two_timestamp: Timestamp of second fragment used to make a comparison, in timescale.
        :param str max_time: The larger timestamp of the two fragments compared.
        :param str max_time_media_type: The media type of the larger timestamp of two fragments compared.
        :param str media_timestamp: Fragment timestamp in timescale.
        :param str media_type: Type of the track.
        :param str min_time: The smaller timestamp of the two fragments compared.
        :param str min_time_media_type: The media type of the smaller timestamp of two fragments compared.
        :param str previous_fragment_duration: Previous fragment duration in timescale.
        :param str previous_fragment_timestamp: Previous fragment timestamp in timescale.
        :param str remote_ip: Truncated IP of the encoder.
        :param str remote_port: Port of the encoder.
        :param str resolution: Width x Height for video, null otherwise.
        :param str result_code: Result code.
        :param str result_message: Result message.
        :param str stream_id: Stream ID in the format "trackName_bitrate"
        :param str stream_name: Identifier of the stream or connection. Encoder or customer is responsible to add this ID in the ingest URL.
        :param str timescale: Timescale in which timestamps are expressed.
        :param str timescale_of_max_time: Timescale of the fragment with the larger timestamp.
        :param str timescale_of_min_time: Timescale of the fragment with the smaller timestamp.
        :param int track_id: Track index.
        :param str track_name: Name of the track. 
        """
        if bitrate is not None:
            pulumi.set(__self__, "bitrate", bitrate)
        if current_fragment_timestamp is not None:
            pulumi.set(__self__, "current_fragment_timestamp", current_fragment_timestamp)
        if discontinuity_gap is not None:
            pulumi.set(__self__, "discontinuity_gap", discontinuity_gap)
        if duration is not None:
            pulumi.set(__self__, "duration", duration)
        if fragment_drop_reason is not None:
            pulumi.set(__self__, "fragment_drop_reason", fragment_drop_reason)
        if fragment_one_duration is not None:
            pulumi.set(__self__, "fragment_one_duration", fragment_one_duration)
        if fragment_one_timestamp is not None:
            pulumi.set(__self__, "fragment_one_timestamp", fragment_one_timestamp)
        if fragment_two_duration is not None:
            pulumi.set(__self__, "fragment_two_duration", fragment_two_duration)
        if fragment_two_timestamp is not None:
            pulumi.set(__self__, "fragment_two_timestamp", fragment_two_timestamp)
        if max_time is not None:
            pulumi.set(__self__, "max_time", max_time)
        if max_time_media_type is not None:
            pulumi.set(__self__, "max_time_media_type", max_time_media_type)
        if media_timestamp is not None:
            pulumi.set(__self__, "media_timestamp", media_timestamp)
        if media_type is not None:
            pulumi.set(__self__, "media_type", media_type)
        if min_time is not None:
            pulumi.set(__self__, "min_time", min_time)
        if min_time_media_type is not None:
            pulumi.set(__self__, "min_time_media_type", min_time_media_type)
        if previous_fragment_duration is not None:
            pulumi.set(__self__, "previous_fragment_duration", previous_fragment_duration)
        if previous_fragment_timestamp is not None:
            pulumi.set(__self__, "previous_fragment_timestamp", previous_fragment_timestamp)
        if remote_ip is not None:
            pulumi.set(__self__, "remote_ip", remote_ip)
        if remote_port is not None:
            pulumi.set(__self__, "remote_port", remote_port)
        if resolution is not None:
            pulumi.set(__self__, "resolution", resolution)
        if result_code is not None:
            pulumi.set(__self__, "result_code", result_code)
        if result_message is not None:
            pulumi.set(__self__, "result_message", result_message)
        if stream_id is not None:
            pulumi.set(__self__, "stream_id", stream_id)
        if stream_name is not None:
            pulumi.set(__self__, "stream_name", stream_name)
        if timescale is not None:
            pulumi.set(__self__, "timescale", timescale)
        if timescale_of_max_time is not None:
            pulumi.set(__self__, "timescale_of_max_time", timescale_of_max_time)
        if timescale_of_min_time is not None:
            pulumi.set(__self__, "timescale_of_min_time", timescale_of_min_time)
        if track_id is not None:
            pulumi.set(__self__, "track_id", track_id)
        if track_name is not None:
            pulumi.set(__self__, "track_name", track_name)

    @property
    @pulumi.getter
    def bitrate(self) -> Optional[float]:
        """
        Bitrate of the track.
        """
        return pulumi.get(self, "bitrate")

    @property
    @pulumi.getter(name="currentFragmentTimestamp")
    def current_fragment_timestamp(self) -> Optional[str]:
        """
        Current fragment timestamp in timescale.
        """
        return pulumi.get(self, "current_fragment_timestamp")

    @property
    @pulumi.getter(name="discontinuityGap")
    def discontinuity_gap(self) -> Optional[float]:
        """
        Length of the discontinuity gap in timescale.
        """
        return pulumi.get(self, "discontinuity_gap")

    @property
    @pulumi.getter
    def duration(self) -> Optional[str]:
        """
        Fragment duration.
        """
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter(name="fragmentDropReason")
    def fragment_drop_reason(self) -> Optional[str]:
        """
        Reason the fragment was dropped.
        """
        return pulumi.get(self, "fragment_drop_reason")

    @property
    @pulumi.getter(name="fragmentOneDuration")
    def fragment_one_duration(self) -> Optional[str]:
        """
        Duration of first fragment used to make a comparison, in timescale.
        """
        return pulumi.get(self, "fragment_one_duration")

    @property
    @pulumi.getter(name="fragmentOneTimestamp")
    def fragment_one_timestamp(self) -> Optional[str]:
        """
        Timestamp of first fragment used to make a comparison, in timescale.
        """
        return pulumi.get(self, "fragment_one_timestamp")

    @property
    @pulumi.getter(name="fragmentTwoDuration")
    def fragment_two_duration(self) -> Optional[str]:
        """
        Duration of second fragment used to make a comparison, in timescale.
        """
        return pulumi.get(self, "fragment_two_duration")

    @property
    @pulumi.getter(name="fragmentTwoTimestamp")
    def fragment_two_timestamp(self) -> Optional[str]:
        """
        Timestamp of second fragment used to make a comparison, in timescale.
        """
        return pulumi.get(self, "fragment_two_timestamp")

    @property
    @pulumi.getter(name="maxTime")
    def max_time(self) -> Optional[str]:
        """
        The larger timestamp of the two fragments compared.
        """
        return pulumi.get(self, "max_time")

    @property
    @pulumi.getter(name="maxTimeMediaType")
    def max_time_media_type(self) -> Optional[str]:
        """
        The media type of the larger timestamp of two fragments compared.
        """
        return pulumi.get(self, "max_time_media_type")

    @property
    @pulumi.getter(name="mediaTimestamp")
    def media_timestamp(self) -> Optional[str]:
        """
        Fragment timestamp in timescale.
        """
        return pulumi.get(self, "media_timestamp")

    @property
    @pulumi.getter(name="mediaType")
    def media_type(self) -> Optional[str]:
        """
        Type of the track.
        """
        return pulumi.get(self, "media_type")

    @property
    @pulumi.getter(name="minTime")
    def min_time(self) -> Optional[str]:
        """
        The smaller timestamp of the two fragments compared.
        """
        return pulumi.get(self, "min_time")

    @property
    @pulumi.getter(name="minTimeMediaType")
    def min_time_media_type(self) -> Optional[str]:
        """
        The media type of the smaller timestamp of two fragments compared.
        """
        return pulumi.get(self, "min_time_media_type")

    @property
    @pulumi.getter(name="previousFragmentDuration")
    def previous_fragment_duration(self) -> Optional[str]:
        """
        Previous fragment duration in timescale.
        """
        return pulumi.get(self, "previous_fragment_duration")

    @property
    @pulumi.getter(name="previousFragmentTimestamp")
    def previous_fragment_timestamp(self) -> Optional[str]:
        """
        Previous fragment timestamp in timescale.
        """
        return pulumi.get(self, "previous_fragment_timestamp")

    @property
    @pulumi.getter(name="remoteIp")
    def remote_ip(self) -> Optional[str]:
        """
        Truncated IP of the encoder.
        """
        return pulumi.get(self, "remote_ip")

    @property
    @pulumi.getter(name="remotePort")
    def remote_port(self) -> Optional[str]:
        """
        Port of the encoder.
        """
        return pulumi.get(self, "remote_port")

    @property
    @pulumi.getter
    def resolution(self) -> Optional[str]:
        """
        Width x Height for video, null otherwise.
        """
        return pulumi.get(self, "resolution")

    @property
    @pulumi.getter(name="resultCode")
    def result_code(self) -> Optional[str]:
        """
        Result code.
        """
        return pulumi.get(self, "result_code")

    @property
    @pulumi.getter(name="resultMessage")
    def result_message(self) -> Optional[str]:
        """
        Result message.
        """
        return pulumi.get(self, "result_message")

    @property
    @pulumi.getter(name="streamId")
    def stream_id(self) -> Optional[str]:
        """
        Stream ID in the format "trackName_bitrate"
        """
        return pulumi.get(self, "stream_id")

    @property
    @pulumi.getter(name="streamName")
    def stream_name(self) -> Optional[str]:
        """
        Identifier of the stream or connection. Encoder or customer is responsible to add this ID in the ingest URL.
        """
        return pulumi.get(self, "stream_name")

    @property
    @pulumi.getter
    def timescale(self) -> Optional[str]:
        """
        Timescale in which timestamps are expressed.
        """
        return pulumi.get(self, "timescale")

    @property
    @pulumi.getter(name="timescaleOfMaxTime")
    def timescale_of_max_time(self) -> Optional[str]:
        """
        Timescale of the fragment with the larger timestamp.
        """
        return pulumi.get(self, "timescale_of_max_time")

    @property
    @pulumi.getter(name="timescaleOfMinTime")
    def timescale_of_min_time(self) -> Optional[str]:
        """
        Timescale of the fragment with the smaller timestamp.
        """
        return pulumi.get(self, "timescale_of_min_time")

    @property
    @pulumi.getter(name="trackId")
    def track_id(self) -> Optional[int]:
        """
        Track index.
        """
        return pulumi.get(self, "track_id")

    @property
    @pulumi.getter(name="trackName")
    def track_name(self) -> Optional[str]:
        """
        Name of the track. 
        """
        return pulumi.get(self, "track_name")


@pulumi.output_type
class LiveEventStreamEventResponse(dict):
    """
    The live event stream event.
    """
    def __init__(__self__, *,
                 data: Optional['outputs.LiveEventStreamEventDataResponse'] = None,
                 event_level: Optional[str] = None,
                 event_time: Optional[str] = None,
                 event_type: Optional[str] = None):
        """
        The live event stream event.
        :param 'LiveEventStreamEventDataResponse' data: Event data based on event type.
        :param str event_level: Event level.
        :param str event_time: The time event raised.
        :param str event_type: The type of the stream event. Format: StreamEvent/{eventType}
        """
        if data is not None:
            pulumi.set(__self__, "data", data)
        if event_level is not None:
            pulumi.set(__self__, "event_level", event_level)
        if event_time is not None:
            pulumi.set(__self__, "event_time", event_time)
        if event_type is not None:
            pulumi.set(__self__, "event_type", event_type)

    @property
    @pulumi.getter
    def data(self) -> Optional['outputs.LiveEventStreamEventDataResponse']:
        """
        Event data based on event type.
        """
        return pulumi.get(self, "data")

    @property
    @pulumi.getter(name="eventLevel")
    def event_level(self) -> Optional[str]:
        """
        Event level.
        """
        return pulumi.get(self, "event_level")

    @property
    @pulumi.getter(name="eventTime")
    def event_time(self) -> Optional[str]:
        """
        The time event raised.
        """
        return pulumi.get(self, "event_time")

    @property
    @pulumi.getter(name="eventType")
    def event_type(self) -> Optional[str]:
        """
        The type of the stream event. Format: StreamEvent/{eventType}
        """
        return pulumi.get(self, "event_type")


@pulumi.output_type
class LiveEventTimedMetadataEndpointResponse(dict):
    """
    The live event metadata insertion endpoint.
    """
    def __init__(__self__, *,
                 url: Optional[str] = None):
        """
        The live event metadata insertion endpoint.
        :param str url: The metadata endpoint URL.
        """
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def url(self) -> Optional[str]:
        """
        The metadata endpoint URL.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class LiveEventTrackEventDataResponse(dict):
    """
    The live event track ingest heart beat event data.
    """
    def __init__(__self__, *,
                 bitrate: Optional[float] = None,
                 discontinuity_count: Optional[float] = None,
                 healthy: Optional[bool] = None,
                 incoming_bitrate: Optional[float] = None,
                 ingest_drift_value: Optional[str] = None,
                 last_fragment_arrival_time: Optional[str] = None,
                 last_timestamp: Optional[str] = None,
                 nonincreasing_count: Optional[float] = None,
                 overlap_count: Optional[float] = None,
                 state: Optional[str] = None,
                 timescale: Optional[str] = None,
                 track_name: Optional[str] = None,
                 track_type: Optional[str] = None,
                 transcription_language: Optional[str] = None,
                 transcription_state: Optional[str] = None,
                 unexpected_bitrate: Optional[bool] = None):
        """
        The live event track ingest heart beat event data.
        :param float bitrate: Bitrate of the track.
        :param float discontinuity_count: Number of discontinuities detected in the last 20 seconds.
        :param bool healthy: Indicates whether ingest is healthy.
        :param float incoming_bitrate: Calculated bitrate based on data chunks coming from encoder.
        :param str ingest_drift_value: Indicates the speed of delay, in seconds-per-minute, of the incoming audio or video data during the last minute. The value is greater than zero if data is arriving to the live event slower than expected in the last minute; zero if data arrived with no delay; and "n/a" if no audio or video data was received. For example, if you have a contribution encoder sending in live content, and it is slowing down due to processing issues, or network latency, it may be only able to deliver a total of 58 seconds of audio or video in a one-minute period. This would be reported as two seconds-per-minute of drift. If the encoder is able to catch up and send all 60 seconds or more of data every minute, you will see this value reported as 0. If there was a disconnection or discontinuity from the encoder, this value may still display as 0, as it does not account for breaks in the data - only data that is delayed in timestamps.
        :param str last_fragment_arrival_time: The last timestamp in UTC that a fragment arrived at the ingest endpoint.
        :param str last_timestamp: Latest timestamp received for a track in last 20 seconds.
        :param float nonincreasing_count: Number of data chunks with timestamps in the past that were received in last 20 seconds.
        :param float overlap_count: Number of data chunks that had overlapped timestamps in last 20 seconds.
        :param str state: State of the live event.
        :param str timescale: Timescale in which timestamps are expressed.
        :param str track_name: Name of the track.
        :param str track_type: Type of the track.
        :param str transcription_language: The language code (in BCP-47 format) of the transcription language. For example, "de-de" indicates German (Germany). The value is empty for the video track heartbeats, or when live transcription is turned off.
        :param str transcription_state: This value is "On" for audio track heartbeats if live transcription is turned on, otherwise you will see an empty string. This state is only applicable to track type of "audio" for Live transcription. All other tracks will have an empty value.
        :param bool unexpected_bitrate: If expected and actual bitrates differ by more than allowed limit in last 20 seconds.
        """
        if bitrate is not None:
            pulumi.set(__self__, "bitrate", bitrate)
        if discontinuity_count is not None:
            pulumi.set(__self__, "discontinuity_count", discontinuity_count)
        if healthy is not None:
            pulumi.set(__self__, "healthy", healthy)
        if incoming_bitrate is not None:
            pulumi.set(__self__, "incoming_bitrate", incoming_bitrate)
        if ingest_drift_value is not None:
            pulumi.set(__self__, "ingest_drift_value", ingest_drift_value)
        if last_fragment_arrival_time is not None:
            pulumi.set(__self__, "last_fragment_arrival_time", last_fragment_arrival_time)
        if last_timestamp is not None:
            pulumi.set(__self__, "last_timestamp", last_timestamp)
        if nonincreasing_count is not None:
            pulumi.set(__self__, "nonincreasing_count", nonincreasing_count)
        if overlap_count is not None:
            pulumi.set(__self__, "overlap_count", overlap_count)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if timescale is not None:
            pulumi.set(__self__, "timescale", timescale)
        if track_name is not None:
            pulumi.set(__self__, "track_name", track_name)
        if track_type is not None:
            pulumi.set(__self__, "track_type", track_type)
        if transcription_language is not None:
            pulumi.set(__self__, "transcription_language", transcription_language)
        if transcription_state is not None:
            pulumi.set(__self__, "transcription_state", transcription_state)
        if unexpected_bitrate is not None:
            pulumi.set(__self__, "unexpected_bitrate", unexpected_bitrate)

    @property
    @pulumi.getter
    def bitrate(self) -> Optional[float]:
        """
        Bitrate of the track.
        """
        return pulumi.get(self, "bitrate")

    @property
    @pulumi.getter(name="discontinuityCount")
    def discontinuity_count(self) -> Optional[float]:
        """
        Number of discontinuities detected in the last 20 seconds.
        """
        return pulumi.get(self, "discontinuity_count")

    @property
    @pulumi.getter
    def healthy(self) -> Optional[bool]:
        """
        Indicates whether ingest is healthy.
        """
        return pulumi.get(self, "healthy")

    @property
    @pulumi.getter(name="incomingBitrate")
    def incoming_bitrate(self) -> Optional[float]:
        """
        Calculated bitrate based on data chunks coming from encoder.
        """
        return pulumi.get(self, "incoming_bitrate")

    @property
    @pulumi.getter(name="ingestDriftValue")
    def ingest_drift_value(self) -> Optional[str]:
        """
        Indicates the speed of delay, in seconds-per-minute, of the incoming audio or video data during the last minute. The value is greater than zero if data is arriving to the live event slower than expected in the last minute; zero if data arrived with no delay; and "n/a" if no audio or video data was received. For example, if you have a contribution encoder sending in live content, and it is slowing down due to processing issues, or network latency, it may be only able to deliver a total of 58 seconds of audio or video in a one-minute period. This would be reported as two seconds-per-minute of drift. If the encoder is able to catch up and send all 60 seconds or more of data every minute, you will see this value reported as 0. If there was a disconnection or discontinuity from the encoder, this value may still display as 0, as it does not account for breaks in the data - only data that is delayed in timestamps.
        """
        return pulumi.get(self, "ingest_drift_value")

    @property
    @pulumi.getter(name="lastFragmentArrivalTime")
    def last_fragment_arrival_time(self) -> Optional[str]:
        """
        The last timestamp in UTC that a fragment arrived at the ingest endpoint.
        """
        return pulumi.get(self, "last_fragment_arrival_time")

    @property
    @pulumi.getter(name="lastTimestamp")
    def last_timestamp(self) -> Optional[str]:
        """
        Latest timestamp received for a track in last 20 seconds.
        """
        return pulumi.get(self, "last_timestamp")

    @property
    @pulumi.getter(name="nonincreasingCount")
    def nonincreasing_count(self) -> Optional[float]:
        """
        Number of data chunks with timestamps in the past that were received in last 20 seconds.
        """
        return pulumi.get(self, "nonincreasing_count")

    @property
    @pulumi.getter(name="overlapCount")
    def overlap_count(self) -> Optional[float]:
        """
        Number of data chunks that had overlapped timestamps in last 20 seconds.
        """
        return pulumi.get(self, "overlap_count")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        State of the live event.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def timescale(self) -> Optional[str]:
        """
        Timescale in which timestamps are expressed.
        """
        return pulumi.get(self, "timescale")

    @property
    @pulumi.getter(name="trackName")
    def track_name(self) -> Optional[str]:
        """
        Name of the track.
        """
        return pulumi.get(self, "track_name")

    @property
    @pulumi.getter(name="trackType")
    def track_type(self) -> Optional[str]:
        """
        Type of the track.
        """
        return pulumi.get(self, "track_type")

    @property
    @pulumi.getter(name="transcriptionLanguage")
    def transcription_language(self) -> Optional[str]:
        """
        The language code (in BCP-47 format) of the transcription language. For example, "de-de" indicates German (Germany). The value is empty for the video track heartbeats, or when live transcription is turned off.
        """
        return pulumi.get(self, "transcription_language")

    @property
    @pulumi.getter(name="transcriptionState")
    def transcription_state(self) -> Optional[str]:
        """
        This value is "On" for audio track heartbeats if live transcription is turned on, otherwise you will see an empty string. This state is only applicable to track type of "audio" for Live transcription. All other tracks will have an empty value.
        """
        return pulumi.get(self, "transcription_state")

    @property
    @pulumi.getter(name="unexpectedBitrate")
    def unexpected_bitrate(self) -> Optional[bool]:
        """
        If expected and actual bitrates differ by more than allowed limit in last 20 seconds.
        """
        return pulumi.get(self, "unexpected_bitrate")


@pulumi.output_type
class LiveEventTrackEventResponse(dict):
    """
    The live event track event.
    """
    def __init__(__self__, *,
                 data: Optional['outputs.LiveEventTrackEventDataResponse'] = None,
                 event_time: Optional[str] = None,
                 event_type: Optional[str] = None):
        """
        The live event track event.
        :param 'LiveEventTrackEventDataResponse' data: Event data.
        :param str event_time: The time event raised.
        :param str event_type: The type of the track event.
        """
        if data is not None:
            pulumi.set(__self__, "data", data)
        if event_time is not None:
            pulumi.set(__self__, "event_time", event_time)
        if event_type is not None:
            pulumi.set(__self__, "event_type", event_type)

    @property
    @pulumi.getter
    def data(self) -> Optional['outputs.LiveEventTrackEventDataResponse']:
        """
        Event data.
        """
        return pulumi.get(self, "data")

    @property
    @pulumi.getter(name="eventTime")
    def event_time(self) -> Optional[str]:
        """
        The time event raised.
        """
        return pulumi.get(self, "event_time")

    @property
    @pulumi.getter(name="eventType")
    def event_type(self) -> Optional[str]:
        """
        The type of the track event.
        """
        return pulumi.get(self, "event_type")


@pulumi.output_type
class LiveEventTrackStatusResponse(dict):
    """
    The live event track status.
    """
    def __init__(__self__, *,
                 expected_bitrate: Optional[float] = None,
                 incoming_bitrate: Optional[float] = None,
                 ingest_drift: Optional[str] = None,
                 request_received: Optional[float] = None,
                 request_succeeded: Optional[float] = None,
                 track_id: Optional[str] = None):
        """
        The live event track status.
        :param float expected_bitrate: Expected bitrate for this track.
        :param float incoming_bitrate: Average incoming bitrate for last 20 seconds when live event is running.
        :param str ingest_drift: Current ingest drift value in seconds for last 1 minute.
        :param float request_received: Total number of timed metadata request received.
        :param float request_succeeded: Total number of successful timed metadata request received.
        :param str track_id: Track Id.
        """
        if expected_bitrate is not None:
            pulumi.set(__self__, "expected_bitrate", expected_bitrate)
        if incoming_bitrate is not None:
            pulumi.set(__self__, "incoming_bitrate", incoming_bitrate)
        if ingest_drift is not None:
            pulumi.set(__self__, "ingest_drift", ingest_drift)
        if request_received is not None:
            pulumi.set(__self__, "request_received", request_received)
        if request_succeeded is not None:
            pulumi.set(__self__, "request_succeeded", request_succeeded)
        if track_id is not None:
            pulumi.set(__self__, "track_id", track_id)

    @property
    @pulumi.getter(name="expectedBitrate")
    def expected_bitrate(self) -> Optional[float]:
        """
        Expected bitrate for this track.
        """
        return pulumi.get(self, "expected_bitrate")

    @property
    @pulumi.getter(name="incomingBitrate")
    def incoming_bitrate(self) -> Optional[float]:
        """
        Average incoming bitrate for last 20 seconds when live event is running.
        """
        return pulumi.get(self, "incoming_bitrate")

    @property
    @pulumi.getter(name="ingestDrift")
    def ingest_drift(self) -> Optional[str]:
        """
        Current ingest drift value in seconds for last 1 minute.
        """
        return pulumi.get(self, "ingest_drift")

    @property
    @pulumi.getter(name="requestReceived")
    def request_received(self) -> Optional[float]:
        """
        Total number of timed metadata request received.
        """
        return pulumi.get(self, "request_received")

    @property
    @pulumi.getter(name="requestSucceeded")
    def request_succeeded(self) -> Optional[float]:
        """
        Total number of successful timed metadata request received.
        """
        return pulumi.get(self, "request_succeeded")

    @property
    @pulumi.getter(name="trackId")
    def track_id(self) -> Optional[str]:
        """
        Track Id.
        """
        return pulumi.get(self, "track_id")


@pulumi.output_type
class LiveEventTranscriptionResponse(dict):
    """
    Describes the transcription tracks in the output of a live event, generated using speech-to-text transcription. This property is reserved for future use, any value set on this property will be ignored.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "inputTrackSelection":
            suggest = "input_track_selection"
        elif key == "outputTranscriptionTrack":
            suggest = "output_transcription_track"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LiveEventTranscriptionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LiveEventTranscriptionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LiveEventTranscriptionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 input_track_selection: Optional[Sequence['outputs.LiveEventInputTrackSelectionResponse']] = None,
                 language: Optional[str] = None,
                 output_transcription_track: Optional['outputs.LiveEventOutputTranscriptionTrackResponse'] = None):
        """
        Describes the transcription tracks in the output of a live event, generated using speech-to-text transcription. This property is reserved for future use, any value set on this property will be ignored.
        :param Sequence['LiveEventInputTrackSelectionResponse'] input_track_selection: Provides a mechanism to select the audio track in the input live feed, to which speech-to-text transcription is applied. This property is reserved for future use, any value set on this property will be ignored.
        :param str language: Specifies the language (locale) to be used for speech-to-text transcription – it should match the spoken language in the audio track. The value should be in BCP-47 format (e.g: 'en-US'). See https://go.microsoft.com/fwlink/?linkid=2133742 for more information about the live transcription feature and the list of supported languages.
        :param 'LiveEventOutputTranscriptionTrackResponse' output_transcription_track: Describes a transcription track in the output of a live event, generated using speech-to-text transcription. This property is reserved for future use, any value set on this property will be ignored.
        """
        if input_track_selection is not None:
            pulumi.set(__self__, "input_track_selection", input_track_selection)
        if language is not None:
            pulumi.set(__self__, "language", language)
        if output_transcription_track is not None:
            pulumi.set(__self__, "output_transcription_track", output_transcription_track)

    @property
    @pulumi.getter(name="inputTrackSelection")
    def input_track_selection(self) -> Optional[Sequence['outputs.LiveEventInputTrackSelectionResponse']]:
        """
        Provides a mechanism to select the audio track in the input live feed, to which speech-to-text transcription is applied. This property is reserved for future use, any value set on this property will be ignored.
        """
        return pulumi.get(self, "input_track_selection")

    @property
    @pulumi.getter
    def language(self) -> Optional[str]:
        """
        Specifies the language (locale) to be used for speech-to-text transcription – it should match the spoken language in the audio track. The value should be in BCP-47 format (e.g: 'en-US'). See https://go.microsoft.com/fwlink/?linkid=2133742 for more information about the live transcription feature and the list of supported languages.
        """
        return pulumi.get(self, "language")

    @property
    @pulumi.getter(name="outputTranscriptionTrack")
    def output_transcription_track(self) -> Optional['outputs.LiveEventOutputTranscriptionTrackResponse']:
        """
        Describes a transcription track in the output of a live event, generated using speech-to-text transcription. This property is reserved for future use, any value set on this property will be ignored.
        """
        return pulumi.get(self, "output_transcription_track")


@pulumi.output_type
class StreamingEndpointAccessControlResponse(dict):
    """
    Streaming endpoint access control definition.
    """
    def __init__(__self__, *,
                 akamai: Optional['outputs.AkamaiAccessControlResponse'] = None,
                 ip: Optional['outputs.IPAccessControlResponse'] = None):
        """
        Streaming endpoint access control definition.
        :param 'AkamaiAccessControlResponse' akamai: The access control of Akamai
        :param 'IPAccessControlResponse' ip: The IP access control of the streaming endpoint.
        """
        if akamai is not None:
            pulumi.set(__self__, "akamai", akamai)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)

    @property
    @pulumi.getter
    def akamai(self) -> Optional['outputs.AkamaiAccessControlResponse']:
        """
        The access control of Akamai
        """
        return pulumi.get(self, "akamai")

    @property
    @pulumi.getter
    def ip(self) -> Optional['outputs.IPAccessControlResponse']:
        """
        The IP access control of the streaming endpoint.
        """
        return pulumi.get(self, "ip")


@pulumi.output_type
class SystemDataResponse(dict):
    """
    Metadata pertaining to creation and last modification of the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "createdBy":
            suggest = "created_by"
        elif key == "createdByType":
            suggest = "created_by_type"
        elif key == "lastModifiedAt":
            suggest = "last_modified_at"
        elif key == "lastModifiedBy":
            suggest = "last_modified_by"
        elif key == "lastModifiedByType":
            suggest = "last_modified_by_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SystemDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: Optional[str] = None,
                 created_by: Optional[str] = None,
                 created_by_type: Optional[str] = None,
                 last_modified_at: Optional[str] = None,
                 last_modified_by: Optional[str] = None,
                 last_modified_by_type: Optional[str] = None):
        """
        Metadata pertaining to creation and last modification of the resource.
        :param str created_at: The timestamp of resource creation (UTC).
        :param str created_by: The identity that created the resource.
        :param str created_by_type: The type of identity that created the resource.
        :param str last_modified_at: The timestamp of resource last modification (UTC)
        :param str last_modified_by: The identity that last modified the resource.
        :param str last_modified_by_type: The type of identity that last modified the resource.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_by_type is not None:
            pulumi.set(__self__, "created_by_type", created_by_type)
        if last_modified_at is not None:
            pulumi.set(__self__, "last_modified_at", last_modified_at)
        if last_modified_by is not None:
            pulumi.set(__self__, "last_modified_by", last_modified_by)
        if last_modified_by_type is not None:
            pulumi.set(__self__, "last_modified_by_type", last_modified_by_type)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The timestamp of resource creation (UTC).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[str]:
        """
        The identity that created the resource.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="createdByType")
    def created_by_type(self) -> Optional[str]:
        """
        The type of identity that created the resource.
        """
        return pulumi.get(self, "created_by_type")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> Optional[str]:
        """
        The timestamp of resource last modification (UTC)
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> Optional[str]:
        """
        The identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by")

    @property
    @pulumi.getter(name="lastModifiedByType")
    def last_modified_by_type(self) -> Optional[str]:
        """
        The type of identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by_type")


