# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetActivityLogAlertResult',
    'AwaitableGetActivityLogAlertResult',
    'get_activity_log_alert',
    'get_activity_log_alert_output',
]

@pulumi.output_type
class GetActivityLogAlertResult:
    """
    An Activity Log Alert rule resource.
    """
    def __init__(__self__, actions=None, condition=None, description=None, enabled=None, id=None, location=None, name=None, scopes=None, tags=None, tenant_scope=None, type=None):
        if actions and not isinstance(actions, dict):
            raise TypeError("Expected argument 'actions' to be a dict")
        pulumi.set(__self__, "actions", actions)
        if condition and not isinstance(condition, dict):
            raise TypeError("Expected argument 'condition' to be a dict")
        pulumi.set(__self__, "condition", condition)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if enabled and not isinstance(enabled, bool):
            raise TypeError("Expected argument 'enabled' to be a bool")
        pulumi.set(__self__, "enabled", enabled)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if scopes and not isinstance(scopes, list):
            raise TypeError("Expected argument 'scopes' to be a list")
        pulumi.set(__self__, "scopes", scopes)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if tenant_scope and not isinstance(tenant_scope, str):
            raise TypeError("Expected argument 'tenant_scope' to be a str")
        pulumi.set(__self__, "tenant_scope", tenant_scope)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def actions(self) -> 'outputs.ActionListResponse':
        """
        The actions that will activate when the condition is met.
        """
        return pulumi.get(self, "actions")

    @property
    @pulumi.getter
    def condition(self) -> 'outputs.AlertRuleAllOfConditionResponse':
        """
        The condition that will cause this alert to activate.
        """
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A description of this Activity Log Alert rule.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Indicates whether this Activity Log Alert rule is enabled. If an Activity Log Alert rule is not enabled, then none of its actions will be activated.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The resource Id.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        The location of the resource. Since Azure Activity Log Alerts is a global service, the location of the rules should always be 'global'.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def scopes(self) -> Optional[Sequence[str]]:
        """
        A list of resource IDs that will be used as prefixes. The alert will only apply to Activity Log events with resource IDs that fall under one of these prefixes. This list must include at least one item.
        """
        return pulumi.get(self, "scopes")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        The tags of the resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tenantScope")
    def tenant_scope(self) -> Optional[str]:
        """
        The tenant GUID. Must be provided for tenant-level and management group events rules.
        """
        return pulumi.get(self, "tenant_scope")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the resource.
        """
        return pulumi.get(self, "type")


class AwaitableGetActivityLogAlertResult(GetActivityLogAlertResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetActivityLogAlertResult(
            actions=self.actions,
            condition=self.condition,
            description=self.description,
            enabled=self.enabled,
            id=self.id,
            location=self.location,
            name=self.name,
            scopes=self.scopes,
            tags=self.tags,
            tenant_scope=self.tenant_scope,
            type=self.type)


def get_activity_log_alert(activity_log_alert_name: Optional[str] = None,
                           resource_group_name: Optional[str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetActivityLogAlertResult:
    """
    Get an Activity Log Alert rule.


    :param str activity_log_alert_name: The name of the Activity Log Alert rule.
    :param str resource_group_name: The name of the resource group. The name is case insensitive.
    """
    __args__ = dict()
    __args__['activityLogAlertName'] = activity_log_alert_name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure-native:insights/v20230101preview:getActivityLogAlert', __args__, opts=opts, typ=GetActivityLogAlertResult).value

    return AwaitableGetActivityLogAlertResult(
        actions=__ret__.actions,
        condition=__ret__.condition,
        description=__ret__.description,
        enabled=__ret__.enabled,
        id=__ret__.id,
        location=__ret__.location,
        name=__ret__.name,
        scopes=__ret__.scopes,
        tags=__ret__.tags,
        tenant_scope=__ret__.tenant_scope,
        type=__ret__.type)


@_utilities.lift_output_func(get_activity_log_alert)
def get_activity_log_alert_output(activity_log_alert_name: Optional[pulumi.Input[str]] = None,
                                  resource_group_name: Optional[pulumi.Input[str]] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetActivityLogAlertResult]:
    """
    Get an Activity Log Alert rule.


    :param str activity_log_alert_name: The name of the Activity Log Alert rule.
    :param str resource_group_name: The name of the resource group. The name is case insensitive.
    """
    ...
