# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._inputs import *

__all__ = ['LabArgs', 'Lab']

@pulumi.input_type
class LabArgs:
    def __init__(__self__, *,
                 billing_account_name: pulumi.Input[str],
                 billing_profile_name: pulumi.Input[str],
                 budget_per_student: pulumi.Input['AmountArgs'],
                 description: pulumi.Input[str],
                 display_name: pulumi.Input[str],
                 expiration_date: pulumi.Input[str],
                 invoice_section_name: pulumi.Input[str],
                 currency: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[float]] = None):
        """
        The set of arguments for constructing a Lab resource.
        :param pulumi.Input[str] billing_account_name: The ID that uniquely identifies a billing account.
        :param pulumi.Input[str] billing_profile_name: The ID that uniquely identifies a billing profile.
        :param pulumi.Input['AmountArgs'] budget_per_student: Default monetary cap for each student in this lab
        :param pulumi.Input[str] description: Detail description of this lab
        :param pulumi.Input[str] display_name: Lab Display Name
        :param pulumi.Input[str] expiration_date: Default expiration date for each student in this lab
        :param pulumi.Input[str] invoice_section_name: The ID that uniquely identifies an invoice section.
        :param pulumi.Input[str] currency: The type of currency being used for the value.
        :param pulumi.Input[float] value: Amount value.
        """
        pulumi.set(__self__, "billing_account_name", billing_account_name)
        pulumi.set(__self__, "billing_profile_name", billing_profile_name)
        pulumi.set(__self__, "budget_per_student", budget_per_student)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "expiration_date", expiration_date)
        pulumi.set(__self__, "invoice_section_name", invoice_section_name)
        if currency is not None:
            pulumi.set(__self__, "currency", currency)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="billingAccountName")
    def billing_account_name(self) -> pulumi.Input[str]:
        """
        The ID that uniquely identifies a billing account.
        """
        return pulumi.get(self, "billing_account_name")

    @billing_account_name.setter
    def billing_account_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "billing_account_name", value)

    @property
    @pulumi.getter(name="billingProfileName")
    def billing_profile_name(self) -> pulumi.Input[str]:
        """
        The ID that uniquely identifies a billing profile.
        """
        return pulumi.get(self, "billing_profile_name")

    @billing_profile_name.setter
    def billing_profile_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "billing_profile_name", value)

    @property
    @pulumi.getter(name="budgetPerStudent")
    def budget_per_student(self) -> pulumi.Input['AmountArgs']:
        """
        Default monetary cap for each student in this lab
        """
        return pulumi.get(self, "budget_per_student")

    @budget_per_student.setter
    def budget_per_student(self, value: pulumi.Input['AmountArgs']):
        pulumi.set(self, "budget_per_student", value)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Input[str]:
        """
        Detail description of this lab
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[str]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[str]:
        """
        Lab Display Name
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="expirationDate")
    def expiration_date(self) -> pulumi.Input[str]:
        """
        Default expiration date for each student in this lab
        """
        return pulumi.get(self, "expiration_date")

    @expiration_date.setter
    def expiration_date(self, value: pulumi.Input[str]):
        pulumi.set(self, "expiration_date", value)

    @property
    @pulumi.getter(name="invoiceSectionName")
    def invoice_section_name(self) -> pulumi.Input[str]:
        """
        The ID that uniquely identifies an invoice section.
        """
        return pulumi.get(self, "invoice_section_name")

    @invoice_section_name.setter
    def invoice_section_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "invoice_section_name", value)

    @property
    @pulumi.getter
    def currency(self) -> Optional[pulumi.Input[str]]:
        """
        The type of currency being used for the value.
        """
        return pulumi.get(self, "currency")

    @currency.setter
    def currency(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "currency", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[float]]:
        """
        Amount value.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "value", value)


class Lab(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 billing_account_name: Optional[pulumi.Input[str]] = None,
                 billing_profile_name: Optional[pulumi.Input[str]] = None,
                 budget_per_student: Optional[pulumi.Input[pulumi.InputType['AmountArgs']]] = None,
                 currency: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 expiration_date: Optional[pulumi.Input[str]] = None,
                 invoice_section_name: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[float]] = None,
                 __props__=None):
        """
        Lab details.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] billing_account_name: The ID that uniquely identifies a billing account.
        :param pulumi.Input[str] billing_profile_name: The ID that uniquely identifies a billing profile.
        :param pulumi.Input[pulumi.InputType['AmountArgs']] budget_per_student: Default monetary cap for each student in this lab
        :param pulumi.Input[str] currency: The type of currency being used for the value.
        :param pulumi.Input[str] description: Detail description of this lab
        :param pulumi.Input[str] display_name: Lab Display Name
        :param pulumi.Input[str] expiration_date: Default expiration date for each student in this lab
        :param pulumi.Input[str] invoice_section_name: The ID that uniquely identifies an invoice section.
        :param pulumi.Input[float] value: Amount value.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LabArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Lab details.

        :param str resource_name: The name of the resource.
        :param LabArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LabArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 billing_account_name: Optional[pulumi.Input[str]] = None,
                 billing_profile_name: Optional[pulumi.Input[str]] = None,
                 budget_per_student: Optional[pulumi.Input[pulumi.InputType['AmountArgs']]] = None,
                 currency: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 expiration_date: Optional[pulumi.Input[str]] = None,
                 invoice_section_name: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[float]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LabArgs.__new__(LabArgs)

            if billing_account_name is None and not opts.urn:
                raise TypeError("Missing required property 'billing_account_name'")
            __props__.__dict__["billing_account_name"] = billing_account_name
            if billing_profile_name is None and not opts.urn:
                raise TypeError("Missing required property 'billing_profile_name'")
            __props__.__dict__["billing_profile_name"] = billing_profile_name
            if budget_per_student is None and not opts.urn:
                raise TypeError("Missing required property 'budget_per_student'")
            __props__.__dict__["budget_per_student"] = budget_per_student
            __props__.__dict__["currency"] = currency
            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            if expiration_date is None and not opts.urn:
                raise TypeError("Missing required property 'expiration_date'")
            __props__.__dict__["expiration_date"] = expiration_date
            if invoice_section_name is None and not opts.urn:
                raise TypeError("Missing required property 'invoice_section_name'")
            __props__.__dict__["invoice_section_name"] = invoice_section_name
            __props__.__dict__["value"] = value
            __props__.__dict__["effective_date"] = None
            __props__.__dict__["invitation_code"] = None
            __props__.__dict__["max_student_count"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["system_data"] = None
            __props__.__dict__["type"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="azure-native:education:Lab")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(Lab, __self__).__init__(
            'azure-native:education/v20211201preview:Lab',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Lab':
        """
        Get an existing Lab resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = LabArgs.__new__(LabArgs)

        __props__.__dict__["budget_per_student"] = None
        __props__.__dict__["currency"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["display_name"] = None
        __props__.__dict__["effective_date"] = None
        __props__.__dict__["expiration_date"] = None
        __props__.__dict__["invitation_code"] = None
        __props__.__dict__["max_student_count"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["status"] = None
        __props__.__dict__["system_data"] = None
        __props__.__dict__["type"] = None
        __props__.__dict__["value"] = None
        return Lab(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="budgetPerStudent")
    def budget_per_student(self) -> pulumi.Output['outputs.AmountResponse']:
        """
        Default monetary cap for each student in this lab
        """
        return pulumi.get(self, "budget_per_student")

    @property
    @pulumi.getter
    def currency(self) -> pulumi.Output[Optional[str]]:
        """
        The type of currency being used for the value.
        """
        return pulumi.get(self, "currency")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        Detail description of this lab
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        Lab Display Name
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="effectiveDate")
    def effective_date(self) -> pulumi.Output[str]:
        """
        Lab creation date
        """
        return pulumi.get(self, "effective_date")

    @property
    @pulumi.getter(name="expirationDate")
    def expiration_date(self) -> pulumi.Output[str]:
        """
        Default expiration date for each student in this lab
        """
        return pulumi.get(self, "expiration_date")

    @property
    @pulumi.getter(name="invitationCode")
    def invitation_code(self) -> pulumi.Output[str]:
        """
        invitation code for redeemable lab
        """
        return pulumi.get(self, "invitation_code")

    @property
    @pulumi.getter(name="maxStudentCount")
    def max_student_count(self) -> pulumi.Output[float]:
        """
        the total number of students that can be accepted to the lab.
        """
        return pulumi.get(self, "max_student_count")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of this lab
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="systemData")
    def system_data(self) -> pulumi.Output['outputs.SystemDataResponse']:
        """
        Azure Resource Manager metadata containing createdBy and modifiedBy information.
        """
        return pulumi.get(self, "system_data")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> pulumi.Output[Optional[float]]:
        """
        Amount value.
        """
        return pulumi.get(self, "value")

