# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ClusterArgs', 'Cluster']

@pulumi.input_type
class ClusterArgs:
    def __init__(__self__, *,
                 resource_group_name: pulumi.Input[str],
                 administrator_login_password: Optional[pulumi.Input[str]] = None,
                 citus_version: Optional[pulumi.Input[str]] = None,
                 cluster_name: Optional[pulumi.Input[str]] = None,
                 coordinator_enable_public_ip_access: Optional[pulumi.Input[bool]] = None,
                 coordinator_server_edition: Optional[pulumi.Input[str]] = None,
                 coordinator_storage_quota_in_mb: Optional[pulumi.Input[float]] = None,
                 coordinator_v_cores: Optional[pulumi.Input[float]] = None,
                 enable_ha: Optional[pulumi.Input[bool]] = None,
                 enable_shards_on_coordinator: Optional[pulumi.Input[bool]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 maintenance_window: Optional[pulumi.Input['MaintenanceWindowArgs']] = None,
                 node_count: Optional[pulumi.Input[float]] = None,
                 node_enable_public_ip_access: Optional[pulumi.Input[bool]] = None,
                 node_server_edition: Optional[pulumi.Input[str]] = None,
                 node_storage_quota_in_mb: Optional[pulumi.Input[float]] = None,
                 node_v_cores: Optional[pulumi.Input[float]] = None,
                 point_in_time_utc: Optional[pulumi.Input[str]] = None,
                 postgresql_version: Optional[pulumi.Input[str]] = None,
                 preferred_primary_zone: Optional[pulumi.Input[str]] = None,
                 source_location: Optional[pulumi.Input[str]] = None,
                 source_resource_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a Cluster resource.
        :param pulumi.Input[str] resource_group_name: The name of the resource group. The name is case insensitive.
        :param pulumi.Input[str] administrator_login_password: The password of the administrator login. Required for creation.
        :param pulumi.Input[str] citus_version: The Citus extension version on all cluster servers.
        :param pulumi.Input[str] cluster_name: The name of the cluster.
        :param pulumi.Input[bool] coordinator_enable_public_ip_access: If public access is enabled on coordinator.
        :param pulumi.Input[str] coordinator_server_edition: The edition of a coordinator server (default: GeneralPurpose). Required for creation.
        :param pulumi.Input[float] coordinator_storage_quota_in_mb: The storage of a server in MB. Required for creation. See https://learn.microsoft.com/azure/cosmos-db/postgresql/resources-compute for more information.
        :param pulumi.Input[float] coordinator_v_cores: The vCores count of a server (max: 96). Required for creation. See https://learn.microsoft.com/azure/cosmos-db/postgresql/resources-compute for more information.
        :param pulumi.Input[bool] enable_ha: If high availability (HA) is enabled or not for the cluster.
        :param pulumi.Input[bool] enable_shards_on_coordinator: If shards on coordinator is enabled or not for the cluster.
        :param pulumi.Input[str] location: The geo-location where the resource lives
        :param pulumi.Input['MaintenanceWindowArgs'] maintenance_window: Maintenance window of a cluster.
        :param pulumi.Input[float] node_count: Worker node count of the cluster. When node count is 0, it represents a single node configuration with the ability to create distributed tables on that node. 2 or more worker nodes represent multi-node configuration. Node count value cannot be 1. Required for creation.
        :param pulumi.Input[bool] node_enable_public_ip_access: If public access is enabled on worker nodes.
        :param pulumi.Input[str] node_server_edition: The edition of a node server (default: MemoryOptimized).
        :param pulumi.Input[float] node_storage_quota_in_mb: The storage in MB on each worker node. See https://learn.microsoft.com/azure/cosmos-db/postgresql/resources-compute for more information.
        :param pulumi.Input[float] node_v_cores: The compute in vCores on each worker node (max: 104). See https://learn.microsoft.com/azure/cosmos-db/postgresql/resources-compute for more information.
        :param pulumi.Input[str] point_in_time_utc: Date and time in UTC (ISO8601 format) for cluster restore.
        :param pulumi.Input[str] postgresql_version: The major PostgreSQL version on all cluster servers.
        :param pulumi.Input[str] preferred_primary_zone: Preferred primary availability zone (AZ) for all cluster servers.
        :param pulumi.Input[str] source_location: The Azure region of source cluster for read replica clusters.
        :param pulumi.Input[str] source_resource_id: The resource id of source cluster for read replica clusters.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Resource tags.
        """
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if administrator_login_password is not None:
            pulumi.set(__self__, "administrator_login_password", administrator_login_password)
        if citus_version is not None:
            pulumi.set(__self__, "citus_version", citus_version)
        if cluster_name is not None:
            pulumi.set(__self__, "cluster_name", cluster_name)
        if coordinator_enable_public_ip_access is not None:
            pulumi.set(__self__, "coordinator_enable_public_ip_access", coordinator_enable_public_ip_access)
        if coordinator_server_edition is not None:
            pulumi.set(__self__, "coordinator_server_edition", coordinator_server_edition)
        if coordinator_storage_quota_in_mb is not None:
            pulumi.set(__self__, "coordinator_storage_quota_in_mb", coordinator_storage_quota_in_mb)
        if coordinator_v_cores is not None:
            pulumi.set(__self__, "coordinator_v_cores", coordinator_v_cores)
        if enable_ha is not None:
            pulumi.set(__self__, "enable_ha", enable_ha)
        if enable_shards_on_coordinator is not None:
            pulumi.set(__self__, "enable_shards_on_coordinator", enable_shards_on_coordinator)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if maintenance_window is not None:
            pulumi.set(__self__, "maintenance_window", maintenance_window)
        if node_count is not None:
            pulumi.set(__self__, "node_count", node_count)
        if node_enable_public_ip_access is not None:
            pulumi.set(__self__, "node_enable_public_ip_access", node_enable_public_ip_access)
        if node_server_edition is not None:
            pulumi.set(__self__, "node_server_edition", node_server_edition)
        if node_storage_quota_in_mb is not None:
            pulumi.set(__self__, "node_storage_quota_in_mb", node_storage_quota_in_mb)
        if node_v_cores is not None:
            pulumi.set(__self__, "node_v_cores", node_v_cores)
        if point_in_time_utc is not None:
            pulumi.set(__self__, "point_in_time_utc", point_in_time_utc)
        if postgresql_version is not None:
            pulumi.set(__self__, "postgresql_version", postgresql_version)
        if preferred_primary_zone is not None:
            pulumi.set(__self__, "preferred_primary_zone", preferred_primary_zone)
        if source_location is not None:
            pulumi.set(__self__, "source_location", source_location)
        if source_resource_id is not None:
            pulumi.set(__self__, "source_resource_id", source_resource_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[str]:
        """
        The name of the resource group. The name is case insensitive.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="administratorLoginPassword")
    def administrator_login_password(self) -> Optional[pulumi.Input[str]]:
        """
        The password of the administrator login. Required for creation.
        """
        return pulumi.get(self, "administrator_login_password")

    @administrator_login_password.setter
    def administrator_login_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "administrator_login_password", value)

    @property
    @pulumi.getter(name="citusVersion")
    def citus_version(self) -> Optional[pulumi.Input[str]]:
        """
        The Citus extension version on all cluster servers.
        """
        return pulumi.get(self, "citus_version")

    @citus_version.setter
    def citus_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "citus_version", value)

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the cluster.
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_name", value)

    @property
    @pulumi.getter(name="coordinatorEnablePublicIpAccess")
    def coordinator_enable_public_ip_access(self) -> Optional[pulumi.Input[bool]]:
        """
        If public access is enabled on coordinator.
        """
        return pulumi.get(self, "coordinator_enable_public_ip_access")

    @coordinator_enable_public_ip_access.setter
    def coordinator_enable_public_ip_access(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "coordinator_enable_public_ip_access", value)

    @property
    @pulumi.getter(name="coordinatorServerEdition")
    def coordinator_server_edition(self) -> Optional[pulumi.Input[str]]:
        """
        The edition of a coordinator server (default: GeneralPurpose). Required for creation.
        """
        return pulumi.get(self, "coordinator_server_edition")

    @coordinator_server_edition.setter
    def coordinator_server_edition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "coordinator_server_edition", value)

    @property
    @pulumi.getter(name="coordinatorStorageQuotaInMb")
    def coordinator_storage_quota_in_mb(self) -> Optional[pulumi.Input[float]]:
        """
        The storage of a server in MB. Required for creation. See https://learn.microsoft.com/azure/cosmos-db/postgresql/resources-compute for more information.
        """
        return pulumi.get(self, "coordinator_storage_quota_in_mb")

    @coordinator_storage_quota_in_mb.setter
    def coordinator_storage_quota_in_mb(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "coordinator_storage_quota_in_mb", value)

    @property
    @pulumi.getter(name="coordinatorVCores")
    def coordinator_v_cores(self) -> Optional[pulumi.Input[float]]:
        """
        The vCores count of a server (max: 96). Required for creation. See https://learn.microsoft.com/azure/cosmos-db/postgresql/resources-compute for more information.
        """
        return pulumi.get(self, "coordinator_v_cores")

    @coordinator_v_cores.setter
    def coordinator_v_cores(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "coordinator_v_cores", value)

    @property
    @pulumi.getter(name="enableHa")
    def enable_ha(self) -> Optional[pulumi.Input[bool]]:
        """
        If high availability (HA) is enabled or not for the cluster.
        """
        return pulumi.get(self, "enable_ha")

    @enable_ha.setter
    def enable_ha(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_ha", value)

    @property
    @pulumi.getter(name="enableShardsOnCoordinator")
    def enable_shards_on_coordinator(self) -> Optional[pulumi.Input[bool]]:
        """
        If shards on coordinator is enabled or not for the cluster.
        """
        return pulumi.get(self, "enable_shards_on_coordinator")

    @enable_shards_on_coordinator.setter
    def enable_shards_on_coordinator(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_shards_on_coordinator", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        The geo-location where the resource lives
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> Optional[pulumi.Input['MaintenanceWindowArgs']]:
        """
        Maintenance window of a cluster.
        """
        return pulumi.get(self, "maintenance_window")

    @maintenance_window.setter
    def maintenance_window(self, value: Optional[pulumi.Input['MaintenanceWindowArgs']]):
        pulumi.set(self, "maintenance_window", value)

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> Optional[pulumi.Input[float]]:
        """
        Worker node count of the cluster. When node count is 0, it represents a single node configuration with the ability to create distributed tables on that node. 2 or more worker nodes represent multi-node configuration. Node count value cannot be 1. Required for creation.
        """
        return pulumi.get(self, "node_count")

    @node_count.setter
    def node_count(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "node_count", value)

    @property
    @pulumi.getter(name="nodeEnablePublicIpAccess")
    def node_enable_public_ip_access(self) -> Optional[pulumi.Input[bool]]:
        """
        If public access is enabled on worker nodes.
        """
        return pulumi.get(self, "node_enable_public_ip_access")

    @node_enable_public_ip_access.setter
    def node_enable_public_ip_access(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "node_enable_public_ip_access", value)

    @property
    @pulumi.getter(name="nodeServerEdition")
    def node_server_edition(self) -> Optional[pulumi.Input[str]]:
        """
        The edition of a node server (default: MemoryOptimized).
        """
        return pulumi.get(self, "node_server_edition")

    @node_server_edition.setter
    def node_server_edition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_server_edition", value)

    @property
    @pulumi.getter(name="nodeStorageQuotaInMb")
    def node_storage_quota_in_mb(self) -> Optional[pulumi.Input[float]]:
        """
        The storage in MB on each worker node. See https://learn.microsoft.com/azure/cosmos-db/postgresql/resources-compute for more information.
        """
        return pulumi.get(self, "node_storage_quota_in_mb")

    @node_storage_quota_in_mb.setter
    def node_storage_quota_in_mb(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "node_storage_quota_in_mb", value)

    @property
    @pulumi.getter(name="nodeVCores")
    def node_v_cores(self) -> Optional[pulumi.Input[float]]:
        """
        The compute in vCores on each worker node (max: 104). See https://learn.microsoft.com/azure/cosmos-db/postgresql/resources-compute for more information.
        """
        return pulumi.get(self, "node_v_cores")

    @node_v_cores.setter
    def node_v_cores(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "node_v_cores", value)

    @property
    @pulumi.getter(name="pointInTimeUTC")
    def point_in_time_utc(self) -> Optional[pulumi.Input[str]]:
        """
        Date and time in UTC (ISO8601 format) for cluster restore.
        """
        return pulumi.get(self, "point_in_time_utc")

    @point_in_time_utc.setter
    def point_in_time_utc(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "point_in_time_utc", value)

    @property
    @pulumi.getter(name="postgresqlVersion")
    def postgresql_version(self) -> Optional[pulumi.Input[str]]:
        """
        The major PostgreSQL version on all cluster servers.
        """
        return pulumi.get(self, "postgresql_version")

    @postgresql_version.setter
    def postgresql_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "postgresql_version", value)

    @property
    @pulumi.getter(name="preferredPrimaryZone")
    def preferred_primary_zone(self) -> Optional[pulumi.Input[str]]:
        """
        Preferred primary availability zone (AZ) for all cluster servers.
        """
        return pulumi.get(self, "preferred_primary_zone")

    @preferred_primary_zone.setter
    def preferred_primary_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "preferred_primary_zone", value)

    @property
    @pulumi.getter(name="sourceLocation")
    def source_location(self) -> Optional[pulumi.Input[str]]:
        """
        The Azure region of source cluster for read replica clusters.
        """
        return pulumi.get(self, "source_location")

    @source_location.setter
    def source_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_location", value)

    @property
    @pulumi.getter(name="sourceResourceId")
    def source_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        The resource id of source cluster for read replica clusters.
        """
        return pulumi.get(self, "source_resource_id")

    @source_resource_id.setter
    def source_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_resource_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


class Cluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 administrator_login_password: Optional[pulumi.Input[str]] = None,
                 citus_version: Optional[pulumi.Input[str]] = None,
                 cluster_name: Optional[pulumi.Input[str]] = None,
                 coordinator_enable_public_ip_access: Optional[pulumi.Input[bool]] = None,
                 coordinator_server_edition: Optional[pulumi.Input[str]] = None,
                 coordinator_storage_quota_in_mb: Optional[pulumi.Input[float]] = None,
                 coordinator_v_cores: Optional[pulumi.Input[float]] = None,
                 enable_ha: Optional[pulumi.Input[bool]] = None,
                 enable_shards_on_coordinator: Optional[pulumi.Input[bool]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 maintenance_window: Optional[pulumi.Input[pulumi.InputType['MaintenanceWindowArgs']]] = None,
                 node_count: Optional[pulumi.Input[float]] = None,
                 node_enable_public_ip_access: Optional[pulumi.Input[bool]] = None,
                 node_server_edition: Optional[pulumi.Input[str]] = None,
                 node_storage_quota_in_mb: Optional[pulumi.Input[float]] = None,
                 node_v_cores: Optional[pulumi.Input[float]] = None,
                 point_in_time_utc: Optional[pulumi.Input[str]] = None,
                 postgresql_version: Optional[pulumi.Input[str]] = None,
                 preferred_primary_zone: Optional[pulumi.Input[str]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 source_location: Optional[pulumi.Input[str]] = None,
                 source_resource_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Represents a cluster.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] administrator_login_password: The password of the administrator login. Required for creation.
        :param pulumi.Input[str] citus_version: The Citus extension version on all cluster servers.
        :param pulumi.Input[str] cluster_name: The name of the cluster.
        :param pulumi.Input[bool] coordinator_enable_public_ip_access: If public access is enabled on coordinator.
        :param pulumi.Input[str] coordinator_server_edition: The edition of a coordinator server (default: GeneralPurpose). Required for creation.
        :param pulumi.Input[float] coordinator_storage_quota_in_mb: The storage of a server in MB. Required for creation. See https://learn.microsoft.com/azure/cosmos-db/postgresql/resources-compute for more information.
        :param pulumi.Input[float] coordinator_v_cores: The vCores count of a server (max: 96). Required for creation. See https://learn.microsoft.com/azure/cosmos-db/postgresql/resources-compute for more information.
        :param pulumi.Input[bool] enable_ha: If high availability (HA) is enabled or not for the cluster.
        :param pulumi.Input[bool] enable_shards_on_coordinator: If shards on coordinator is enabled or not for the cluster.
        :param pulumi.Input[str] location: The geo-location where the resource lives
        :param pulumi.Input[pulumi.InputType['MaintenanceWindowArgs']] maintenance_window: Maintenance window of a cluster.
        :param pulumi.Input[float] node_count: Worker node count of the cluster. When node count is 0, it represents a single node configuration with the ability to create distributed tables on that node. 2 or more worker nodes represent multi-node configuration. Node count value cannot be 1. Required for creation.
        :param pulumi.Input[bool] node_enable_public_ip_access: If public access is enabled on worker nodes.
        :param pulumi.Input[str] node_server_edition: The edition of a node server (default: MemoryOptimized).
        :param pulumi.Input[float] node_storage_quota_in_mb: The storage in MB on each worker node. See https://learn.microsoft.com/azure/cosmos-db/postgresql/resources-compute for more information.
        :param pulumi.Input[float] node_v_cores: The compute in vCores on each worker node (max: 104). See https://learn.microsoft.com/azure/cosmos-db/postgresql/resources-compute for more information.
        :param pulumi.Input[str] point_in_time_utc: Date and time in UTC (ISO8601 format) for cluster restore.
        :param pulumi.Input[str] postgresql_version: The major PostgreSQL version on all cluster servers.
        :param pulumi.Input[str] preferred_primary_zone: Preferred primary availability zone (AZ) for all cluster servers.
        :param pulumi.Input[str] resource_group_name: The name of the resource group. The name is case insensitive.
        :param pulumi.Input[str] source_location: The Azure region of source cluster for read replica clusters.
        :param pulumi.Input[str] source_resource_id: The resource id of source cluster for read replica clusters.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Resource tags.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Represents a cluster.

        :param str resource_name: The name of the resource.
        :param ClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 administrator_login_password: Optional[pulumi.Input[str]] = None,
                 citus_version: Optional[pulumi.Input[str]] = None,
                 cluster_name: Optional[pulumi.Input[str]] = None,
                 coordinator_enable_public_ip_access: Optional[pulumi.Input[bool]] = None,
                 coordinator_server_edition: Optional[pulumi.Input[str]] = None,
                 coordinator_storage_quota_in_mb: Optional[pulumi.Input[float]] = None,
                 coordinator_v_cores: Optional[pulumi.Input[float]] = None,
                 enable_ha: Optional[pulumi.Input[bool]] = None,
                 enable_shards_on_coordinator: Optional[pulumi.Input[bool]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 maintenance_window: Optional[pulumi.Input[pulumi.InputType['MaintenanceWindowArgs']]] = None,
                 node_count: Optional[pulumi.Input[float]] = None,
                 node_enable_public_ip_access: Optional[pulumi.Input[bool]] = None,
                 node_server_edition: Optional[pulumi.Input[str]] = None,
                 node_storage_quota_in_mb: Optional[pulumi.Input[float]] = None,
                 node_v_cores: Optional[pulumi.Input[float]] = None,
                 point_in_time_utc: Optional[pulumi.Input[str]] = None,
                 postgresql_version: Optional[pulumi.Input[str]] = None,
                 preferred_primary_zone: Optional[pulumi.Input[str]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 source_location: Optional[pulumi.Input[str]] = None,
                 source_resource_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClusterArgs.__new__(ClusterArgs)

            __props__.__dict__["administrator_login_password"] = administrator_login_password
            __props__.__dict__["citus_version"] = citus_version
            __props__.__dict__["cluster_name"] = cluster_name
            __props__.__dict__["coordinator_enable_public_ip_access"] = coordinator_enable_public_ip_access
            __props__.__dict__["coordinator_server_edition"] = coordinator_server_edition
            __props__.__dict__["coordinator_storage_quota_in_mb"] = coordinator_storage_quota_in_mb
            __props__.__dict__["coordinator_v_cores"] = coordinator_v_cores
            __props__.__dict__["enable_ha"] = enable_ha
            __props__.__dict__["enable_shards_on_coordinator"] = enable_shards_on_coordinator
            __props__.__dict__["location"] = location
            __props__.__dict__["maintenance_window"] = maintenance_window
            __props__.__dict__["node_count"] = node_count
            __props__.__dict__["node_enable_public_ip_access"] = node_enable_public_ip_access
            __props__.__dict__["node_server_edition"] = node_server_edition
            __props__.__dict__["node_storage_quota_in_mb"] = node_storage_quota_in_mb
            __props__.__dict__["node_v_cores"] = node_v_cores
            __props__.__dict__["point_in_time_utc"] = point_in_time_utc
            __props__.__dict__["postgresql_version"] = postgresql_version
            __props__.__dict__["preferred_primary_zone"] = preferred_primary_zone
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["source_location"] = source_location
            __props__.__dict__["source_resource_id"] = source_resource_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["administrator_login"] = None
            __props__.__dict__["earliest_restore_time"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["private_endpoint_connections"] = None
            __props__.__dict__["provisioning_state"] = None
            __props__.__dict__["read_replicas"] = None
            __props__.__dict__["server_names"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_data"] = None
            __props__.__dict__["type"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="azure-native:dbforpostgresql/v20201005privatepreview:Cluster")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(Cluster, __self__).__init__(
            'azure-native:dbforpostgresql/v20221108:Cluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Cluster':
        """
        Get an existing Cluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ClusterArgs.__new__(ClusterArgs)

        __props__.__dict__["administrator_login"] = None
        __props__.__dict__["citus_version"] = None
        __props__.__dict__["coordinator_enable_public_ip_access"] = None
        __props__.__dict__["coordinator_server_edition"] = None
        __props__.__dict__["coordinator_storage_quota_in_mb"] = None
        __props__.__dict__["coordinator_v_cores"] = None
        __props__.__dict__["earliest_restore_time"] = None
        __props__.__dict__["enable_ha"] = None
        __props__.__dict__["enable_shards_on_coordinator"] = None
        __props__.__dict__["location"] = None
        __props__.__dict__["maintenance_window"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["node_count"] = None
        __props__.__dict__["node_enable_public_ip_access"] = None
        __props__.__dict__["node_server_edition"] = None
        __props__.__dict__["node_storage_quota_in_mb"] = None
        __props__.__dict__["node_v_cores"] = None
        __props__.__dict__["point_in_time_utc"] = None
        __props__.__dict__["postgresql_version"] = None
        __props__.__dict__["preferred_primary_zone"] = None
        __props__.__dict__["private_endpoint_connections"] = None
        __props__.__dict__["provisioning_state"] = None
        __props__.__dict__["read_replicas"] = None
        __props__.__dict__["server_names"] = None
        __props__.__dict__["source_location"] = None
        __props__.__dict__["source_resource_id"] = None
        __props__.__dict__["state"] = None
        __props__.__dict__["system_data"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["type"] = None
        return Cluster(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="administratorLogin")
    def administrator_login(self) -> pulumi.Output[str]:
        """
        The administrator's login name of the servers in the cluster.
        """
        return pulumi.get(self, "administrator_login")

    @property
    @pulumi.getter(name="citusVersion")
    def citus_version(self) -> pulumi.Output[Optional[str]]:
        """
        The Citus extension version on all cluster servers.
        """
        return pulumi.get(self, "citus_version")

    @property
    @pulumi.getter(name="coordinatorEnablePublicIpAccess")
    def coordinator_enable_public_ip_access(self) -> pulumi.Output[Optional[bool]]:
        """
        If public access is enabled on coordinator.
        """
        return pulumi.get(self, "coordinator_enable_public_ip_access")

    @property
    @pulumi.getter(name="coordinatorServerEdition")
    def coordinator_server_edition(self) -> pulumi.Output[Optional[str]]:
        """
        The edition of a coordinator server (default: GeneralPurpose). Required for creation.
        """
        return pulumi.get(self, "coordinator_server_edition")

    @property
    @pulumi.getter(name="coordinatorStorageQuotaInMb")
    def coordinator_storage_quota_in_mb(self) -> pulumi.Output[Optional[float]]:
        """
        The storage of a server in MB. Required for creation. See https://learn.microsoft.com/azure/cosmos-db/postgresql/resources-compute for more information.
        """
        return pulumi.get(self, "coordinator_storage_quota_in_mb")

    @property
    @pulumi.getter(name="coordinatorVCores")
    def coordinator_v_cores(self) -> pulumi.Output[Optional[float]]:
        """
        The vCores count of a server (max: 96). Required for creation. See https://learn.microsoft.com/azure/cosmos-db/postgresql/resources-compute for more information.
        """
        return pulumi.get(self, "coordinator_v_cores")

    @property
    @pulumi.getter(name="earliestRestoreTime")
    def earliest_restore_time(self) -> pulumi.Output[str]:
        """
        The earliest restore point time (ISO8601 format) for the cluster.
        """
        return pulumi.get(self, "earliest_restore_time")

    @property
    @pulumi.getter(name="enableHa")
    def enable_ha(self) -> pulumi.Output[Optional[bool]]:
        """
        If high availability (HA) is enabled or not for the cluster.
        """
        return pulumi.get(self, "enable_ha")

    @property
    @pulumi.getter(name="enableShardsOnCoordinator")
    def enable_shards_on_coordinator(self) -> pulumi.Output[Optional[bool]]:
        """
        If shards on coordinator is enabled or not for the cluster.
        """
        return pulumi.get(self, "enable_shards_on_coordinator")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        """
        The geo-location where the resource lives
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> pulumi.Output[Optional['outputs.MaintenanceWindowResponse']]:
        """
        Maintenance window of a cluster.
        """
        return pulumi.get(self, "maintenance_window")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> pulumi.Output[Optional[float]]:
        """
        Worker node count of the cluster. When node count is 0, it represents a single node configuration with the ability to create distributed tables on that node. 2 or more worker nodes represent multi-node configuration. Node count value cannot be 1. Required for creation.
        """
        return pulumi.get(self, "node_count")

    @property
    @pulumi.getter(name="nodeEnablePublicIpAccess")
    def node_enable_public_ip_access(self) -> pulumi.Output[Optional[bool]]:
        """
        If public access is enabled on worker nodes.
        """
        return pulumi.get(self, "node_enable_public_ip_access")

    @property
    @pulumi.getter(name="nodeServerEdition")
    def node_server_edition(self) -> pulumi.Output[Optional[str]]:
        """
        The edition of a node server (default: MemoryOptimized).
        """
        return pulumi.get(self, "node_server_edition")

    @property
    @pulumi.getter(name="nodeStorageQuotaInMb")
    def node_storage_quota_in_mb(self) -> pulumi.Output[Optional[float]]:
        """
        The storage in MB on each worker node. See https://learn.microsoft.com/azure/cosmos-db/postgresql/resources-compute for more information.
        """
        return pulumi.get(self, "node_storage_quota_in_mb")

    @property
    @pulumi.getter(name="nodeVCores")
    def node_v_cores(self) -> pulumi.Output[Optional[float]]:
        """
        The compute in vCores on each worker node (max: 104). See https://learn.microsoft.com/azure/cosmos-db/postgresql/resources-compute for more information.
        """
        return pulumi.get(self, "node_v_cores")

    @property
    @pulumi.getter(name="pointInTimeUTC")
    def point_in_time_utc(self) -> pulumi.Output[Optional[str]]:
        """
        Date and time in UTC (ISO8601 format) for cluster restore.
        """
        return pulumi.get(self, "point_in_time_utc")

    @property
    @pulumi.getter(name="postgresqlVersion")
    def postgresql_version(self) -> pulumi.Output[Optional[str]]:
        """
        The major PostgreSQL version on all cluster servers.
        """
        return pulumi.get(self, "postgresql_version")

    @property
    @pulumi.getter(name="preferredPrimaryZone")
    def preferred_primary_zone(self) -> pulumi.Output[Optional[str]]:
        """
        Preferred primary availability zone (AZ) for all cluster servers.
        """
        return pulumi.get(self, "preferred_primary_zone")

    @property
    @pulumi.getter(name="privateEndpointConnections")
    def private_endpoint_connections(self) -> pulumi.Output[Sequence['outputs.SimplePrivateEndpointConnectionResponse']]:
        """
        The private endpoint connections for a cluster.
        """
        return pulumi.get(self, "private_endpoint_connections")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> pulumi.Output[str]:
        """
        Provisioning state of the cluster
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="readReplicas")
    def read_replicas(self) -> pulumi.Output[Sequence[str]]:
        """
        The array of read replica clusters.
        """
        return pulumi.get(self, "read_replicas")

    @property
    @pulumi.getter(name="serverNames")
    def server_names(self) -> pulumi.Output[Sequence['outputs.ServerNameItemResponse']]:
        """
        The list of server names in the cluster
        """
        return pulumi.get(self, "server_names")

    @property
    @pulumi.getter(name="sourceLocation")
    def source_location(self) -> pulumi.Output[Optional[str]]:
        """
        The Azure region of source cluster for read replica clusters.
        """
        return pulumi.get(self, "source_location")

    @property
    @pulumi.getter(name="sourceResourceId")
    def source_resource_id(self) -> pulumi.Output[Optional[str]]:
        """
        The resource id of source cluster for read replica clusters.
        """
        return pulumi.get(self, "source_resource_id")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        A state of a cluster/server that is visible to user.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemData")
    def system_data(self) -> pulumi.Output['outputs.SystemDataResponse']:
        """
        Azure Resource Manager metadata containing createdBy and modifiedBy information.
        """
        return pulumi.get(self, "system_data")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
        """
        return pulumi.get(self, "type")

