# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'AllowedAudiencesValidationArgs',
    'AllowedPrincipalsArgs',
    'AppLogsConfigurationArgs',
    'AppRegistrationArgs',
    'AppleRegistrationArgs',
    'AppleArgs',
    'AuthPlatformArgs',
    'AzureActiveDirectoryLoginArgs',
    'AzureActiveDirectoryRegistrationArgs',
    'AzureActiveDirectoryValidationArgs',
    'AzureActiveDirectoryArgs',
    'AzureCredentialsArgs',
    'AzureFilePropertiesArgs',
    'AzureStaticWebAppsRegistrationArgs',
    'AzureStaticWebAppsArgs',
    'CertificatePropertiesArgs',
    'ClientRegistrationArgs',
    'ConfigurationArgs',
    'ConnectedEnvironmentStoragePropertiesArgs',
    'ContainerAppProbeHttpGetArgs',
    'ContainerAppProbeHttpHeadersArgs',
    'ContainerAppProbeTcpSocketArgs',
    'ContainerAppProbeArgs',
    'ContainerResourcesArgs',
    'ContainerArgs',
    'CookieExpirationArgs',
    'CorsPolicyArgs',
    'CustomDomainConfigurationArgs',
    'CustomDomainArgs',
    'CustomOpenIdConnectProviderArgs',
    'CustomScaleRuleArgs',
    'DaprMetadataArgs',
    'DaprArgs',
    'DefaultAuthorizationPolicyArgs',
    'EnvironmentSkuPropertiesArgs',
    'EnvironmentVarArgs',
    'ExtendedLocationArgs',
    'FacebookArgs',
    'ForwardProxyArgs',
    'GitHubArgs',
    'GithubActionConfigurationArgs',
    'GlobalValidationArgs',
    'GoogleArgs',
    'HttpScaleRuleArgs',
    'HttpSettingsRoutesArgs',
    'HttpSettingsArgs',
    'IdentityProvidersArgs',
    'IngressArgs',
    'InitContainerArgs',
    'IpSecurityRestrictionRuleArgs',
    'JwtClaimChecksArgs',
    'LogAnalyticsConfigurationArgs',
    'LoginRoutesArgs',
    'LoginScopesArgs',
    'LoginArgs',
    'ManagedEnvironmentOutboundSettingsArgs',
    'ManagedEnvironmentStoragePropertiesArgs',
    'ManagedServiceIdentityArgs',
    'NonceArgs',
    'OpenIdConnectClientCredentialArgs',
    'OpenIdConnectConfigArgs',
    'OpenIdConnectLoginArgs',
    'OpenIdConnectRegistrationArgs',
    'QueueScaleRuleArgs',
    'RegistryCredentialsArgs',
    'RegistryInfoArgs',
    'ScaleRuleAuthArgs',
    'ScaleRuleArgs',
    'ScaleArgs',
    'SecretArgs',
    'TcpScaleRuleArgs',
    'TemplateArgs',
    'TrafficWeightArgs',
    'TwitterRegistrationArgs',
    'TwitterArgs',
    'VnetConfigurationArgs',
    'VolumeMountArgs',
    'VolumeArgs',
    'WorkloadProfileArgs',
]

@pulumi.input_type
class AllowedAudiencesValidationArgs:
    def __init__(__self__, *,
                 allowed_audiences: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The configuration settings of the Allowed Audiences validation flow.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_audiences: The configuration settings of the allowed list of audiences from which to validate the JWT token.
        """
        if allowed_audiences is not None:
            pulumi.set(__self__, "allowed_audiences", allowed_audiences)

    @property
    @pulumi.getter(name="allowedAudiences")
    def allowed_audiences(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The configuration settings of the allowed list of audiences from which to validate the JWT token.
        """
        return pulumi.get(self, "allowed_audiences")

    @allowed_audiences.setter
    def allowed_audiences(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_audiences", value)


@pulumi.input_type
class AllowedPrincipalsArgs:
    def __init__(__self__, *,
                 groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 identities: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The configuration settings of the Azure Active Directory allowed principals.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] groups: The list of the allowed groups.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] identities: The list of the allowed identities.
        """
        if groups is not None:
            pulumi.set(__self__, "groups", groups)
        if identities is not None:
            pulumi.set(__self__, "identities", identities)

    @property
    @pulumi.getter
    def groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of the allowed groups.
        """
        return pulumi.get(self, "groups")

    @groups.setter
    def groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "groups", value)

    @property
    @pulumi.getter
    def identities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of the allowed identities.
        """
        return pulumi.get(self, "identities")

    @identities.setter
    def identities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "identities", value)


@pulumi.input_type
class AppLogsConfigurationArgs:
    def __init__(__self__, *,
                 destination: Optional[pulumi.Input[str]] = None,
                 log_analytics_configuration: Optional[pulumi.Input['LogAnalyticsConfigurationArgs']] = None):
        """
        Configuration of application logs
        :param pulumi.Input[str] destination: Logs destination
        :param pulumi.Input['LogAnalyticsConfigurationArgs'] log_analytics_configuration: Log Analytics configuration
        """
        if destination is not None:
            pulumi.set(__self__, "destination", destination)
        if log_analytics_configuration is not None:
            pulumi.set(__self__, "log_analytics_configuration", log_analytics_configuration)

    @property
    @pulumi.getter
    def destination(self) -> Optional[pulumi.Input[str]]:
        """
        Logs destination
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination", value)

    @property
    @pulumi.getter(name="logAnalyticsConfiguration")
    def log_analytics_configuration(self) -> Optional[pulumi.Input['LogAnalyticsConfigurationArgs']]:
        """
        Log Analytics configuration
        """
        return pulumi.get(self, "log_analytics_configuration")

    @log_analytics_configuration.setter
    def log_analytics_configuration(self, value: Optional[pulumi.Input['LogAnalyticsConfigurationArgs']]):
        pulumi.set(self, "log_analytics_configuration", value)


@pulumi.input_type
class AppRegistrationArgs:
    def __init__(__self__, *,
                 app_id: Optional[pulumi.Input[str]] = None,
                 app_secret_setting_name: Optional[pulumi.Input[str]] = None):
        """
        The configuration settings of the app registration for providers that have app ids and app secrets
        :param pulumi.Input[str] app_id: The App ID of the app used for login.
        :param pulumi.Input[str] app_secret_setting_name: The app setting name that contains the app secret.
        """
        if app_id is not None:
            pulumi.set(__self__, "app_id", app_id)
        if app_secret_setting_name is not None:
            pulumi.set(__self__, "app_secret_setting_name", app_secret_setting_name)

    @property
    @pulumi.getter(name="appId")
    def app_id(self) -> Optional[pulumi.Input[str]]:
        """
        The App ID of the app used for login.
        """
        return pulumi.get(self, "app_id")

    @app_id.setter
    def app_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_id", value)

    @property
    @pulumi.getter(name="appSecretSettingName")
    def app_secret_setting_name(self) -> Optional[pulumi.Input[str]]:
        """
        The app setting name that contains the app secret.
        """
        return pulumi.get(self, "app_secret_setting_name")

    @app_secret_setting_name.setter
    def app_secret_setting_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_secret_setting_name", value)


@pulumi.input_type
class AppleRegistrationArgs:
    def __init__(__self__, *,
                 client_id: Optional[pulumi.Input[str]] = None,
                 client_secret_setting_name: Optional[pulumi.Input[str]] = None):
        """
        The configuration settings of the registration for the Apple provider
        :param pulumi.Input[str] client_id: The Client ID of the app used for login.
        :param pulumi.Input[str] client_secret_setting_name: The app setting name that contains the client secret.
        """
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret_setting_name is not None:
            pulumi.set(__self__, "client_secret_setting_name", client_secret_setting_name)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Client ID of the app used for login.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="clientSecretSettingName")
    def client_secret_setting_name(self) -> Optional[pulumi.Input[str]]:
        """
        The app setting name that contains the client secret.
        """
        return pulumi.get(self, "client_secret_setting_name")

    @client_secret_setting_name.setter
    def client_secret_setting_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_secret_setting_name", value)


@pulumi.input_type
class AppleArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 login: Optional[pulumi.Input['LoginScopesArgs']] = None,
                 registration: Optional[pulumi.Input['AppleRegistrationArgs']] = None):
        """
        The configuration settings of the Apple provider.
        :param pulumi.Input[bool] enabled: <code>false</code> if the Apple provider should not be enabled despite the set registration; otherwise, <code>true</code>.
        :param pulumi.Input['LoginScopesArgs'] login: The configuration settings of the login flow.
        :param pulumi.Input['AppleRegistrationArgs'] registration: The configuration settings of the Apple registration.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if login is not None:
            pulumi.set(__self__, "login", login)
        if registration is not None:
            pulumi.set(__self__, "registration", registration)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        <code>false</code> if the Apple provider should not be enabled despite the set registration; otherwise, <code>true</code>.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def login(self) -> Optional[pulumi.Input['LoginScopesArgs']]:
        """
        The configuration settings of the login flow.
        """
        return pulumi.get(self, "login")

    @login.setter
    def login(self, value: Optional[pulumi.Input['LoginScopesArgs']]):
        pulumi.set(self, "login", value)

    @property
    @pulumi.getter
    def registration(self) -> Optional[pulumi.Input['AppleRegistrationArgs']]:
        """
        The configuration settings of the Apple registration.
        """
        return pulumi.get(self, "registration")

    @registration.setter
    def registration(self, value: Optional[pulumi.Input['AppleRegistrationArgs']]):
        pulumi.set(self, "registration", value)


@pulumi.input_type
class AuthPlatformArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 runtime_version: Optional[pulumi.Input[str]] = None):
        """
        The configuration settings of the platform of ContainerApp Service Authentication/Authorization.
        :param pulumi.Input[bool] enabled: <code>true</code> if the Authentication / Authorization feature is enabled for the current app; otherwise, <code>false</code>.
        :param pulumi.Input[str] runtime_version: The RuntimeVersion of the Authentication / Authorization feature in use for the current app.
               The setting in this value can control the behavior of certain features in the Authentication / Authorization module.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if runtime_version is not None:
            pulumi.set(__self__, "runtime_version", runtime_version)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        <code>true</code> if the Authentication / Authorization feature is enabled for the current app; otherwise, <code>false</code>.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="runtimeVersion")
    def runtime_version(self) -> Optional[pulumi.Input[str]]:
        """
        The RuntimeVersion of the Authentication / Authorization feature in use for the current app.
        The setting in this value can control the behavior of certain features in the Authentication / Authorization module.
        """
        return pulumi.get(self, "runtime_version")

    @runtime_version.setter
    def runtime_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "runtime_version", value)


@pulumi.input_type
class AzureActiveDirectoryLoginArgs:
    def __init__(__self__, *,
                 disable_www_authenticate: Optional[pulumi.Input[bool]] = None,
                 login_parameters: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The configuration settings of the Azure Active Directory login flow.
        :param pulumi.Input[bool] disable_www_authenticate: <code>true</code> if the www-authenticate provider should be omitted from the request; otherwise, <code>false</code>.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] login_parameters: Login parameters to send to the OpenID Connect authorization endpoint when
               a user logs in. Each parameter must be in the form "key=value".
        """
        if disable_www_authenticate is not None:
            pulumi.set(__self__, "disable_www_authenticate", disable_www_authenticate)
        if login_parameters is not None:
            pulumi.set(__self__, "login_parameters", login_parameters)

    @property
    @pulumi.getter(name="disableWWWAuthenticate")
    def disable_www_authenticate(self) -> Optional[pulumi.Input[bool]]:
        """
        <code>true</code> if the www-authenticate provider should be omitted from the request; otherwise, <code>false</code>.
        """
        return pulumi.get(self, "disable_www_authenticate")

    @disable_www_authenticate.setter
    def disable_www_authenticate(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_www_authenticate", value)

    @property
    @pulumi.getter(name="loginParameters")
    def login_parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Login parameters to send to the OpenID Connect authorization endpoint when
        a user logs in. Each parameter must be in the form "key=value".
        """
        return pulumi.get(self, "login_parameters")

    @login_parameters.setter
    def login_parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "login_parameters", value)


@pulumi.input_type
class AzureActiveDirectoryRegistrationArgs:
    def __init__(__self__, *,
                 client_id: Optional[pulumi.Input[str]] = None,
                 client_secret_certificate_issuer: Optional[pulumi.Input[str]] = None,
                 client_secret_certificate_subject_alternative_name: Optional[pulumi.Input[str]] = None,
                 client_secret_certificate_thumbprint: Optional[pulumi.Input[str]] = None,
                 client_secret_setting_name: Optional[pulumi.Input[str]] = None,
                 open_id_issuer: Optional[pulumi.Input[str]] = None):
        """
        The configuration settings of the Azure Active Directory app registration.
        :param pulumi.Input[str] client_id: The Client ID of this relying party application, known as the client_id.
               This setting is required for enabling OpenID Connection authentication with Azure Active Directory or 
               other 3rd party OpenID Connect providers.
               More information on OpenID Connect: http://openid.net/specs/openid-connect-core-1_0.html
        :param pulumi.Input[str] client_secret_certificate_issuer: An alternative to the client secret thumbprint, that is the issuer of a certificate used for signing purposes. This property acts as
               a replacement for the Client Secret Certificate Thumbprint. It is also optional.
        :param pulumi.Input[str] client_secret_certificate_subject_alternative_name: An alternative to the client secret thumbprint, that is the subject alternative name of a certificate used for signing purposes. This property acts as
               a replacement for the Client Secret Certificate Thumbprint. It is also optional.
        :param pulumi.Input[str] client_secret_certificate_thumbprint: An alternative to the client secret, that is the thumbprint of a certificate used for signing purposes. This property acts as
               a replacement for the Client Secret. It is also optional.
        :param pulumi.Input[str] client_secret_setting_name: The app setting name that contains the client secret of the relying party application.
        :param pulumi.Input[str] open_id_issuer: The OpenID Connect Issuer URI that represents the entity which issues access tokens for this application.
               When using Azure Active Directory, this value is the URI of the directory tenant, e.g. https://login.microsoftonline.com/v2.0/{tenant-guid}/.
               This URI is a case-sensitive identifier for the token issuer.
               More information on OpenID Connect Discovery: http://openid.net/specs/openid-connect-discovery-1_0.html
        """
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret_certificate_issuer is not None:
            pulumi.set(__self__, "client_secret_certificate_issuer", client_secret_certificate_issuer)
        if client_secret_certificate_subject_alternative_name is not None:
            pulumi.set(__self__, "client_secret_certificate_subject_alternative_name", client_secret_certificate_subject_alternative_name)
        if client_secret_certificate_thumbprint is not None:
            pulumi.set(__self__, "client_secret_certificate_thumbprint", client_secret_certificate_thumbprint)
        if client_secret_setting_name is not None:
            pulumi.set(__self__, "client_secret_setting_name", client_secret_setting_name)
        if open_id_issuer is not None:
            pulumi.set(__self__, "open_id_issuer", open_id_issuer)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Client ID of this relying party application, known as the client_id.
        This setting is required for enabling OpenID Connection authentication with Azure Active Directory or 
        other 3rd party OpenID Connect providers.
        More information on OpenID Connect: http://openid.net/specs/openid-connect-core-1_0.html
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="clientSecretCertificateIssuer")
    def client_secret_certificate_issuer(self) -> Optional[pulumi.Input[str]]:
        """
        An alternative to the client secret thumbprint, that is the issuer of a certificate used for signing purposes. This property acts as
        a replacement for the Client Secret Certificate Thumbprint. It is also optional.
        """
        return pulumi.get(self, "client_secret_certificate_issuer")

    @client_secret_certificate_issuer.setter
    def client_secret_certificate_issuer(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_secret_certificate_issuer", value)

    @property
    @pulumi.getter(name="clientSecretCertificateSubjectAlternativeName")
    def client_secret_certificate_subject_alternative_name(self) -> Optional[pulumi.Input[str]]:
        """
        An alternative to the client secret thumbprint, that is the subject alternative name of a certificate used for signing purposes. This property acts as
        a replacement for the Client Secret Certificate Thumbprint. It is also optional.
        """
        return pulumi.get(self, "client_secret_certificate_subject_alternative_name")

    @client_secret_certificate_subject_alternative_name.setter
    def client_secret_certificate_subject_alternative_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_secret_certificate_subject_alternative_name", value)

    @property
    @pulumi.getter(name="clientSecretCertificateThumbprint")
    def client_secret_certificate_thumbprint(self) -> Optional[pulumi.Input[str]]:
        """
        An alternative to the client secret, that is the thumbprint of a certificate used for signing purposes. This property acts as
        a replacement for the Client Secret. It is also optional.
        """
        return pulumi.get(self, "client_secret_certificate_thumbprint")

    @client_secret_certificate_thumbprint.setter
    def client_secret_certificate_thumbprint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_secret_certificate_thumbprint", value)

    @property
    @pulumi.getter(name="clientSecretSettingName")
    def client_secret_setting_name(self) -> Optional[pulumi.Input[str]]:
        """
        The app setting name that contains the client secret of the relying party application.
        """
        return pulumi.get(self, "client_secret_setting_name")

    @client_secret_setting_name.setter
    def client_secret_setting_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_secret_setting_name", value)

    @property
    @pulumi.getter(name="openIdIssuer")
    def open_id_issuer(self) -> Optional[pulumi.Input[str]]:
        """
        The OpenID Connect Issuer URI that represents the entity which issues access tokens for this application.
        When using Azure Active Directory, this value is the URI of the directory tenant, e.g. https://login.microsoftonline.com/v2.0/{tenant-guid}/.
        This URI is a case-sensitive identifier for the token issuer.
        More information on OpenID Connect Discovery: http://openid.net/specs/openid-connect-discovery-1_0.html
        """
        return pulumi.get(self, "open_id_issuer")

    @open_id_issuer.setter
    def open_id_issuer(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "open_id_issuer", value)


@pulumi.input_type
class AzureActiveDirectoryValidationArgs:
    def __init__(__self__, *,
                 allowed_audiences: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 default_authorization_policy: Optional[pulumi.Input['DefaultAuthorizationPolicyArgs']] = None,
                 jwt_claim_checks: Optional[pulumi.Input['JwtClaimChecksArgs']] = None):
        """
        The configuration settings of the Azure Active Directory token validation flow.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_audiences: The list of audiences that can make successful authentication/authorization requests.
        :param pulumi.Input['DefaultAuthorizationPolicyArgs'] default_authorization_policy: The configuration settings of the default authorization policy.
        :param pulumi.Input['JwtClaimChecksArgs'] jwt_claim_checks: The configuration settings of the checks that should be made while validating the JWT Claims.
        """
        if allowed_audiences is not None:
            pulumi.set(__self__, "allowed_audiences", allowed_audiences)
        if default_authorization_policy is not None:
            pulumi.set(__self__, "default_authorization_policy", default_authorization_policy)
        if jwt_claim_checks is not None:
            pulumi.set(__self__, "jwt_claim_checks", jwt_claim_checks)

    @property
    @pulumi.getter(name="allowedAudiences")
    def allowed_audiences(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of audiences that can make successful authentication/authorization requests.
        """
        return pulumi.get(self, "allowed_audiences")

    @allowed_audiences.setter
    def allowed_audiences(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_audiences", value)

    @property
    @pulumi.getter(name="defaultAuthorizationPolicy")
    def default_authorization_policy(self) -> Optional[pulumi.Input['DefaultAuthorizationPolicyArgs']]:
        """
        The configuration settings of the default authorization policy.
        """
        return pulumi.get(self, "default_authorization_policy")

    @default_authorization_policy.setter
    def default_authorization_policy(self, value: Optional[pulumi.Input['DefaultAuthorizationPolicyArgs']]):
        pulumi.set(self, "default_authorization_policy", value)

    @property
    @pulumi.getter(name="jwtClaimChecks")
    def jwt_claim_checks(self) -> Optional[pulumi.Input['JwtClaimChecksArgs']]:
        """
        The configuration settings of the checks that should be made while validating the JWT Claims.
        """
        return pulumi.get(self, "jwt_claim_checks")

    @jwt_claim_checks.setter
    def jwt_claim_checks(self, value: Optional[pulumi.Input['JwtClaimChecksArgs']]):
        pulumi.set(self, "jwt_claim_checks", value)


@pulumi.input_type
class AzureActiveDirectoryArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 is_auto_provisioned: Optional[pulumi.Input[bool]] = None,
                 login: Optional[pulumi.Input['AzureActiveDirectoryLoginArgs']] = None,
                 registration: Optional[pulumi.Input['AzureActiveDirectoryRegistrationArgs']] = None,
                 validation: Optional[pulumi.Input['AzureActiveDirectoryValidationArgs']] = None):
        """
        The configuration settings of the Azure Active directory provider.
        :param pulumi.Input[bool] enabled: <code>false</code> if the Azure Active Directory provider should not be enabled despite the set registration; otherwise, <code>true</code>.
        :param pulumi.Input[bool] is_auto_provisioned: Gets a value indicating whether the Azure AD configuration was auto-provisioned using 1st party tooling.
               This is an internal flag primarily intended to support the Azure Management Portal. Users should not
               read or write to this property.
        :param pulumi.Input['AzureActiveDirectoryLoginArgs'] login: The configuration settings of the Azure Active Directory login flow.
        :param pulumi.Input['AzureActiveDirectoryRegistrationArgs'] registration: The configuration settings of the Azure Active Directory app registration.
        :param pulumi.Input['AzureActiveDirectoryValidationArgs'] validation: The configuration settings of the Azure Active Directory token validation flow.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if is_auto_provisioned is not None:
            pulumi.set(__self__, "is_auto_provisioned", is_auto_provisioned)
        if login is not None:
            pulumi.set(__self__, "login", login)
        if registration is not None:
            pulumi.set(__self__, "registration", registration)
        if validation is not None:
            pulumi.set(__self__, "validation", validation)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        <code>false</code> if the Azure Active Directory provider should not be enabled despite the set registration; otherwise, <code>true</code>.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="isAutoProvisioned")
    def is_auto_provisioned(self) -> Optional[pulumi.Input[bool]]:
        """
        Gets a value indicating whether the Azure AD configuration was auto-provisioned using 1st party tooling.
        This is an internal flag primarily intended to support the Azure Management Portal. Users should not
        read or write to this property.
        """
        return pulumi.get(self, "is_auto_provisioned")

    @is_auto_provisioned.setter
    def is_auto_provisioned(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_auto_provisioned", value)

    @property
    @pulumi.getter
    def login(self) -> Optional[pulumi.Input['AzureActiveDirectoryLoginArgs']]:
        """
        The configuration settings of the Azure Active Directory login flow.
        """
        return pulumi.get(self, "login")

    @login.setter
    def login(self, value: Optional[pulumi.Input['AzureActiveDirectoryLoginArgs']]):
        pulumi.set(self, "login", value)

    @property
    @pulumi.getter
    def registration(self) -> Optional[pulumi.Input['AzureActiveDirectoryRegistrationArgs']]:
        """
        The configuration settings of the Azure Active Directory app registration.
        """
        return pulumi.get(self, "registration")

    @registration.setter
    def registration(self, value: Optional[pulumi.Input['AzureActiveDirectoryRegistrationArgs']]):
        pulumi.set(self, "registration", value)

    @property
    @pulumi.getter
    def validation(self) -> Optional[pulumi.Input['AzureActiveDirectoryValidationArgs']]:
        """
        The configuration settings of the Azure Active Directory token validation flow.
        """
        return pulumi.get(self, "validation")

    @validation.setter
    def validation(self, value: Optional[pulumi.Input['AzureActiveDirectoryValidationArgs']]):
        pulumi.set(self, "validation", value)


@pulumi.input_type
class AzureCredentialsArgs:
    def __init__(__self__, *,
                 client_id: Optional[pulumi.Input[str]] = None,
                 client_secret: Optional[pulumi.Input[str]] = None,
                 subscription_id: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None):
        """
        Container App credentials.
        :param pulumi.Input[str] client_id: Client Id.
        :param pulumi.Input[str] client_secret: Client Secret.
        :param pulumi.Input[str] subscription_id: Subscription Id.
        :param pulumi.Input[str] tenant_id: Tenant Id.
        """
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if subscription_id is not None:
            pulumi.set(__self__, "subscription_id", subscription_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[str]]:
        """
        Client Id.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[pulumi.Input[str]]:
        """
        Client Secret.
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_secret", value)

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> Optional[pulumi.Input[str]]:
        """
        Subscription Id.
        """
        return pulumi.get(self, "subscription_id")

    @subscription_id.setter
    def subscription_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subscription_id", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        Tenant Id.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)


@pulumi.input_type
class AzureFilePropertiesArgs:
    def __init__(__self__, *,
                 access_mode: Optional[pulumi.Input[Union[str, 'AccessMode']]] = None,
                 account_key: Optional[pulumi.Input[str]] = None,
                 account_name: Optional[pulumi.Input[str]] = None,
                 share_name: Optional[pulumi.Input[str]] = None):
        """
        Azure File Properties.
        :param pulumi.Input[Union[str, 'AccessMode']] access_mode: Access mode for storage
        :param pulumi.Input[str] account_key: Storage account key for azure file.
        :param pulumi.Input[str] account_name: Storage account name for azure file.
        :param pulumi.Input[str] share_name: Azure file share name.
        """
        if access_mode is not None:
            pulumi.set(__self__, "access_mode", access_mode)
        if account_key is not None:
            pulumi.set(__self__, "account_key", account_key)
        if account_name is not None:
            pulumi.set(__self__, "account_name", account_name)
        if share_name is not None:
            pulumi.set(__self__, "share_name", share_name)

    @property
    @pulumi.getter(name="accessMode")
    def access_mode(self) -> Optional[pulumi.Input[Union[str, 'AccessMode']]]:
        """
        Access mode for storage
        """
        return pulumi.get(self, "access_mode")

    @access_mode.setter
    def access_mode(self, value: Optional[pulumi.Input[Union[str, 'AccessMode']]]):
        pulumi.set(self, "access_mode", value)

    @property
    @pulumi.getter(name="accountKey")
    def account_key(self) -> Optional[pulumi.Input[str]]:
        """
        Storage account key for azure file.
        """
        return pulumi.get(self, "account_key")

    @account_key.setter
    def account_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_key", value)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> Optional[pulumi.Input[str]]:
        """
        Storage account name for azure file.
        """
        return pulumi.get(self, "account_name")

    @account_name.setter
    def account_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_name", value)

    @property
    @pulumi.getter(name="shareName")
    def share_name(self) -> Optional[pulumi.Input[str]]:
        """
        Azure file share name.
        """
        return pulumi.get(self, "share_name")

    @share_name.setter
    def share_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "share_name", value)


@pulumi.input_type
class AzureStaticWebAppsRegistrationArgs:
    def __init__(__self__, *,
                 client_id: Optional[pulumi.Input[str]] = None):
        """
        The configuration settings of the registration for the Azure Static Web Apps provider
        :param pulumi.Input[str] client_id: The Client ID of the app used for login.
        """
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Client ID of the app used for login.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_id", value)


@pulumi.input_type
class AzureStaticWebAppsArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 registration: Optional[pulumi.Input['AzureStaticWebAppsRegistrationArgs']] = None):
        """
        The configuration settings of the Azure Static Web Apps provider.
        :param pulumi.Input[bool] enabled: <code>false</code> if the Azure Static Web Apps provider should not be enabled despite the set registration; otherwise, <code>true</code>.
        :param pulumi.Input['AzureStaticWebAppsRegistrationArgs'] registration: The configuration settings of the Azure Static Web Apps registration.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if registration is not None:
            pulumi.set(__self__, "registration", registration)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        <code>false</code> if the Azure Static Web Apps provider should not be enabled despite the set registration; otherwise, <code>true</code>.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def registration(self) -> Optional[pulumi.Input['AzureStaticWebAppsRegistrationArgs']]:
        """
        The configuration settings of the Azure Static Web Apps registration.
        """
        return pulumi.get(self, "registration")

    @registration.setter
    def registration(self, value: Optional[pulumi.Input['AzureStaticWebAppsRegistrationArgs']]):
        pulumi.set(self, "registration", value)


@pulumi.input_type
class CertificatePropertiesArgs:
    def __init__(__self__, *,
                 password: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        Certificate resource specific properties
        :param pulumi.Input[str] password: Certificate password.
        :param pulumi.Input[str] value: PFX or PEM blob
        """
        if password is not None:
            pulumi.set(__self__, "password", password)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        Certificate password.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        PFX or PEM blob
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class ClientRegistrationArgs:
    def __init__(__self__, *,
                 client_id: Optional[pulumi.Input[str]] = None,
                 client_secret_setting_name: Optional[pulumi.Input[str]] = None):
        """
        The configuration settings of the app registration for providers that have client ids and client secrets
        :param pulumi.Input[str] client_id: The Client ID of the app used for login.
        :param pulumi.Input[str] client_secret_setting_name: The app setting name that contains the client secret.
        """
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret_setting_name is not None:
            pulumi.set(__self__, "client_secret_setting_name", client_secret_setting_name)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Client ID of the app used for login.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="clientSecretSettingName")
    def client_secret_setting_name(self) -> Optional[pulumi.Input[str]]:
        """
        The app setting name that contains the client secret.
        """
        return pulumi.get(self, "client_secret_setting_name")

    @client_secret_setting_name.setter
    def client_secret_setting_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_secret_setting_name", value)


@pulumi.input_type
class ConfigurationArgs:
    def __init__(__self__, *,
                 active_revisions_mode: Optional[pulumi.Input[Union[str, 'ActiveRevisionsMode']]] = None,
                 dapr: Optional[pulumi.Input['DaprArgs']] = None,
                 ingress: Optional[pulumi.Input['IngressArgs']] = None,
                 max_inactive_revisions: Optional[pulumi.Input[int]] = None,
                 registries: Optional[pulumi.Input[Sequence[pulumi.Input['RegistryCredentialsArgs']]]] = None,
                 secrets: Optional[pulumi.Input[Sequence[pulumi.Input['SecretArgs']]]] = None):
        """
        Non versioned Container App configuration properties that define the mutable settings of a Container app
        :param pulumi.Input[Union[str, 'ActiveRevisionsMode']] active_revisions_mode: ActiveRevisionsMode controls how active revisions are handled for the Container app:
               <list><item>Multiple: multiple revisions can be active.</item><item>Single: Only one revision can be active at a time. Revision weights can not be used in this mode. If no value if provided, this is the default.</item></list>
        :param pulumi.Input['DaprArgs'] dapr: Dapr configuration for the Container App.
        :param pulumi.Input['IngressArgs'] ingress: Ingress configurations.
        :param pulumi.Input[int] max_inactive_revisions: Optional. Max inactive revisions a Container App can have.
        :param pulumi.Input[Sequence[pulumi.Input['RegistryCredentialsArgs']]] registries: Collection of private container registry credentials for containers used by the Container app
        :param pulumi.Input[Sequence[pulumi.Input['SecretArgs']]] secrets: Collection of secrets used by a Container app
        """
        if active_revisions_mode is None:
            active_revisions_mode = 'Single'
        if active_revisions_mode is not None:
            pulumi.set(__self__, "active_revisions_mode", active_revisions_mode)
        if dapr is not None:
            pulumi.set(__self__, "dapr", dapr)
        if ingress is not None:
            pulumi.set(__self__, "ingress", ingress)
        if max_inactive_revisions is not None:
            pulumi.set(__self__, "max_inactive_revisions", max_inactive_revisions)
        if registries is not None:
            pulumi.set(__self__, "registries", registries)
        if secrets is not None:
            pulumi.set(__self__, "secrets", secrets)

    @property
    @pulumi.getter(name="activeRevisionsMode")
    def active_revisions_mode(self) -> Optional[pulumi.Input[Union[str, 'ActiveRevisionsMode']]]:
        """
        ActiveRevisionsMode controls how active revisions are handled for the Container app:
        <list><item>Multiple: multiple revisions can be active.</item><item>Single: Only one revision can be active at a time. Revision weights can not be used in this mode. If no value if provided, this is the default.</item></list>
        """
        return pulumi.get(self, "active_revisions_mode")

    @active_revisions_mode.setter
    def active_revisions_mode(self, value: Optional[pulumi.Input[Union[str, 'ActiveRevisionsMode']]]):
        pulumi.set(self, "active_revisions_mode", value)

    @property
    @pulumi.getter
    def dapr(self) -> Optional[pulumi.Input['DaprArgs']]:
        """
        Dapr configuration for the Container App.
        """
        return pulumi.get(self, "dapr")

    @dapr.setter
    def dapr(self, value: Optional[pulumi.Input['DaprArgs']]):
        pulumi.set(self, "dapr", value)

    @property
    @pulumi.getter
    def ingress(self) -> Optional[pulumi.Input['IngressArgs']]:
        """
        Ingress configurations.
        """
        return pulumi.get(self, "ingress")

    @ingress.setter
    def ingress(self, value: Optional[pulumi.Input['IngressArgs']]):
        pulumi.set(self, "ingress", value)

    @property
    @pulumi.getter(name="maxInactiveRevisions")
    def max_inactive_revisions(self) -> Optional[pulumi.Input[int]]:
        """
        Optional. Max inactive revisions a Container App can have.
        """
        return pulumi.get(self, "max_inactive_revisions")

    @max_inactive_revisions.setter
    def max_inactive_revisions(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_inactive_revisions", value)

    @property
    @pulumi.getter
    def registries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RegistryCredentialsArgs']]]]:
        """
        Collection of private container registry credentials for containers used by the Container app
        """
        return pulumi.get(self, "registries")

    @registries.setter
    def registries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RegistryCredentialsArgs']]]]):
        pulumi.set(self, "registries", value)

    @property
    @pulumi.getter
    def secrets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecretArgs']]]]:
        """
        Collection of secrets used by a Container app
        """
        return pulumi.get(self, "secrets")

    @secrets.setter
    def secrets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecretArgs']]]]):
        pulumi.set(self, "secrets", value)


@pulumi.input_type
class ConnectedEnvironmentStoragePropertiesArgs:
    def __init__(__self__, *,
                 azure_file: Optional[pulumi.Input['AzureFilePropertiesArgs']] = None):
        """
        Storage properties
        :param pulumi.Input['AzureFilePropertiesArgs'] azure_file: Azure file properties
        """
        if azure_file is not None:
            pulumi.set(__self__, "azure_file", azure_file)

    @property
    @pulumi.getter(name="azureFile")
    def azure_file(self) -> Optional[pulumi.Input['AzureFilePropertiesArgs']]:
        """
        Azure file properties
        """
        return pulumi.get(self, "azure_file")

    @azure_file.setter
    def azure_file(self, value: Optional[pulumi.Input['AzureFilePropertiesArgs']]):
        pulumi.set(self, "azure_file", value)


@pulumi.input_type
class ContainerAppProbeHttpGetArgs:
    def __init__(__self__, *,
                 port: pulumi.Input[int],
                 host: Optional[pulumi.Input[str]] = None,
                 http_headers: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerAppProbeHttpHeadersArgs']]]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 scheme: Optional[pulumi.Input[Union[str, 'Scheme']]] = None):
        """
        HTTPGet specifies the http request to perform.
        :param pulumi.Input[int] port: Name or number of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
        :param pulumi.Input[str] host: Host name to connect to, defaults to the pod IP. You probably want to set "Host" in httpHeaders instead.
        :param pulumi.Input[Sequence[pulumi.Input['ContainerAppProbeHttpHeadersArgs']]] http_headers: Custom headers to set in the request. HTTP allows repeated headers.
        :param pulumi.Input[str] path: Path to access on the HTTP server.
        :param pulumi.Input[Union[str, 'Scheme']] scheme: Scheme to use for connecting to the host. Defaults to HTTP.
        """
        pulumi.set(__self__, "port", port)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if http_headers is not None:
            pulumi.set(__self__, "http_headers", http_headers)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if scheme is not None:
            pulumi.set(__self__, "scheme", scheme)

    @property
    @pulumi.getter
    def port(self) -> pulumi.Input[int]:
        """
        Name or number of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[int]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[str]]:
        """
        Host name to connect to, defaults to the pod IP. You probably want to set "Host" in httpHeaders instead.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host", value)

    @property
    @pulumi.getter(name="httpHeaders")
    def http_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerAppProbeHttpHeadersArgs']]]]:
        """
        Custom headers to set in the request. HTTP allows repeated headers.
        """
        return pulumi.get(self, "http_headers")

    @http_headers.setter
    def http_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerAppProbeHttpHeadersArgs']]]]):
        pulumi.set(self, "http_headers", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        Path to access on the HTTP server.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def scheme(self) -> Optional[pulumi.Input[Union[str, 'Scheme']]]:
        """
        Scheme to use for connecting to the host. Defaults to HTTP.
        """
        return pulumi.get(self, "scheme")

    @scheme.setter
    def scheme(self, value: Optional[pulumi.Input[Union[str, 'Scheme']]]):
        pulumi.set(self, "scheme", value)


@pulumi.input_type
class ContainerAppProbeHttpHeadersArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        HTTPHeader describes a custom header to be used in HTTP probes
        :param pulumi.Input[str] name: The header field name
        :param pulumi.Input[str] value: The header field value
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The header field name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        The header field value
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class ContainerAppProbeTcpSocketArgs:
    def __init__(__self__, *,
                 port: pulumi.Input[int],
                 host: Optional[pulumi.Input[str]] = None):
        """
        TCPSocket specifies an action involving a TCP port. TCP hooks not yet supported.
        :param pulumi.Input[int] port: Number or name of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
        :param pulumi.Input[str] host: Optional: Host name to connect to, defaults to the pod IP.
        """
        pulumi.set(__self__, "port", port)
        if host is not None:
            pulumi.set(__self__, "host", host)

    @property
    @pulumi.getter
    def port(self) -> pulumi.Input[int]:
        """
        Number or name of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[int]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[str]]:
        """
        Optional: Host name to connect to, defaults to the pod IP.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host", value)


@pulumi.input_type
class ContainerAppProbeArgs:
    def __init__(__self__, *,
                 failure_threshold: Optional[pulumi.Input[int]] = None,
                 http_get: Optional[pulumi.Input['ContainerAppProbeHttpGetArgs']] = None,
                 initial_delay_seconds: Optional[pulumi.Input[int]] = None,
                 period_seconds: Optional[pulumi.Input[int]] = None,
                 success_threshold: Optional[pulumi.Input[int]] = None,
                 tcp_socket: Optional[pulumi.Input['ContainerAppProbeTcpSocketArgs']] = None,
                 termination_grace_period_seconds: Optional[pulumi.Input[float]] = None,
                 timeout_seconds: Optional[pulumi.Input[int]] = None,
                 type: Optional[pulumi.Input[Union[str, 'Type']]] = None):
        """
        Probe describes a health check to be performed against a container to determine whether it is alive or ready to receive traffic.
        :param pulumi.Input[int] failure_threshold: Minimum consecutive failures for the probe to be considered failed after having succeeded. Defaults to 3. Minimum value is 1. Maximum value is 10.
        :param pulumi.Input['ContainerAppProbeHttpGetArgs'] http_get: HTTPGet specifies the http request to perform.
        :param pulumi.Input[int] initial_delay_seconds: Number of seconds after the container has started before liveness probes are initiated. Minimum value is 1. Maximum value is 60.
        :param pulumi.Input[int] period_seconds: How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1. Maximum value is 240.
        :param pulumi.Input[int] success_threshold: Minimum consecutive successes for the probe to be considered successful after having failed. Defaults to 1. Must be 1 for liveness and startup. Minimum value is 1. Maximum value is 10.
        :param pulumi.Input['ContainerAppProbeTcpSocketArgs'] tcp_socket: TCPSocket specifies an action involving a TCP port. TCP hooks not yet supported.
        :param pulumi.Input[float] termination_grace_period_seconds: Optional duration in seconds the pod needs to terminate gracefully upon probe failure. The grace period is the duration in seconds after the processes running in the pod are sent a termination signal and the time when the processes are forcibly halted with a kill signal. Set this value longer than the expected cleanup time for your process. If this value is nil, the pod's terminationGracePeriodSeconds will be used. Otherwise, this value overrides the value provided by the pod spec. Value must be non-negative integer. The value zero indicates stop immediately via the kill signal (no opportunity to shut down). This is an alpha field and requires enabling ProbeTerminationGracePeriod feature gate. Maximum value is 3600 seconds (1 hour)
        :param pulumi.Input[int] timeout_seconds: Number of seconds after which the probe times out. Defaults to 1 second. Minimum value is 1. Maximum value is 240.
        :param pulumi.Input[Union[str, 'Type']] type: The type of probe.
        """
        if failure_threshold is not None:
            pulumi.set(__self__, "failure_threshold", failure_threshold)
        if http_get is not None:
            pulumi.set(__self__, "http_get", http_get)
        if initial_delay_seconds is not None:
            pulumi.set(__self__, "initial_delay_seconds", initial_delay_seconds)
        if period_seconds is not None:
            pulumi.set(__self__, "period_seconds", period_seconds)
        if success_threshold is not None:
            pulumi.set(__self__, "success_threshold", success_threshold)
        if tcp_socket is not None:
            pulumi.set(__self__, "tcp_socket", tcp_socket)
        if termination_grace_period_seconds is not None:
            pulumi.set(__self__, "termination_grace_period_seconds", termination_grace_period_seconds)
        if timeout_seconds is not None:
            pulumi.set(__self__, "timeout_seconds", timeout_seconds)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="failureThreshold")
    def failure_threshold(self) -> Optional[pulumi.Input[int]]:
        """
        Minimum consecutive failures for the probe to be considered failed after having succeeded. Defaults to 3. Minimum value is 1. Maximum value is 10.
        """
        return pulumi.get(self, "failure_threshold")

    @failure_threshold.setter
    def failure_threshold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "failure_threshold", value)

    @property
    @pulumi.getter(name="httpGet")
    def http_get(self) -> Optional[pulumi.Input['ContainerAppProbeHttpGetArgs']]:
        """
        HTTPGet specifies the http request to perform.
        """
        return pulumi.get(self, "http_get")

    @http_get.setter
    def http_get(self, value: Optional[pulumi.Input['ContainerAppProbeHttpGetArgs']]):
        pulumi.set(self, "http_get", value)

    @property
    @pulumi.getter(name="initialDelaySeconds")
    def initial_delay_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        Number of seconds after the container has started before liveness probes are initiated. Minimum value is 1. Maximum value is 60.
        """
        return pulumi.get(self, "initial_delay_seconds")

    @initial_delay_seconds.setter
    def initial_delay_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "initial_delay_seconds", value)

    @property
    @pulumi.getter(name="periodSeconds")
    def period_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1. Maximum value is 240.
        """
        return pulumi.get(self, "period_seconds")

    @period_seconds.setter
    def period_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period_seconds", value)

    @property
    @pulumi.getter(name="successThreshold")
    def success_threshold(self) -> Optional[pulumi.Input[int]]:
        """
        Minimum consecutive successes for the probe to be considered successful after having failed. Defaults to 1. Must be 1 for liveness and startup. Minimum value is 1. Maximum value is 10.
        """
        return pulumi.get(self, "success_threshold")

    @success_threshold.setter
    def success_threshold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "success_threshold", value)

    @property
    @pulumi.getter(name="tcpSocket")
    def tcp_socket(self) -> Optional[pulumi.Input['ContainerAppProbeTcpSocketArgs']]:
        """
        TCPSocket specifies an action involving a TCP port. TCP hooks not yet supported.
        """
        return pulumi.get(self, "tcp_socket")

    @tcp_socket.setter
    def tcp_socket(self, value: Optional[pulumi.Input['ContainerAppProbeTcpSocketArgs']]):
        pulumi.set(self, "tcp_socket", value)

    @property
    @pulumi.getter(name="terminationGracePeriodSeconds")
    def termination_grace_period_seconds(self) -> Optional[pulumi.Input[float]]:
        """
        Optional duration in seconds the pod needs to terminate gracefully upon probe failure. The grace period is the duration in seconds after the processes running in the pod are sent a termination signal and the time when the processes are forcibly halted with a kill signal. Set this value longer than the expected cleanup time for your process. If this value is nil, the pod's terminationGracePeriodSeconds will be used. Otherwise, this value overrides the value provided by the pod spec. Value must be non-negative integer. The value zero indicates stop immediately via the kill signal (no opportunity to shut down). This is an alpha field and requires enabling ProbeTerminationGracePeriod feature gate. Maximum value is 3600 seconds (1 hour)
        """
        return pulumi.get(self, "termination_grace_period_seconds")

    @termination_grace_period_seconds.setter
    def termination_grace_period_seconds(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "termination_grace_period_seconds", value)

    @property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        Number of seconds after which the probe times out. Defaults to 1 second. Minimum value is 1. Maximum value is 240.
        """
        return pulumi.get(self, "timeout_seconds")

    @timeout_seconds.setter
    def timeout_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout_seconds", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[Union[str, 'Type']]]:
        """
        The type of probe.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[Union[str, 'Type']]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class ContainerResourcesArgs:
    def __init__(__self__, *,
                 cpu: Optional[pulumi.Input[float]] = None,
                 memory: Optional[pulumi.Input[str]] = None):
        """
        Container App container resource requirements.
        :param pulumi.Input[float] cpu: Required CPU in cores, e.g. 0.5
        :param pulumi.Input[str] memory: Required memory, e.g. "250Mb"
        """
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if memory is not None:
            pulumi.set(__self__, "memory", memory)

    @property
    @pulumi.getter
    def cpu(self) -> Optional[pulumi.Input[float]]:
        """
        Required CPU in cores, e.g. 0.5
        """
        return pulumi.get(self, "cpu")

    @cpu.setter
    def cpu(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "cpu", value)

    @property
    @pulumi.getter
    def memory(self) -> Optional[pulumi.Input[str]]:
        """
        Required memory, e.g. "250Mb"
        """
        return pulumi.get(self, "memory")

    @memory.setter
    def memory(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "memory", value)


@pulumi.input_type
class ContainerArgs:
    def __init__(__self__, *,
                 args: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 command: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 env: Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentVarArgs']]]] = None,
                 image: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 probes: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerAppProbeArgs']]]] = None,
                 resources: Optional[pulumi.Input['ContainerResourcesArgs']] = None,
                 volume_mounts: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeMountArgs']]]] = None):
        """
        Container App container definition
        :param pulumi.Input[Sequence[pulumi.Input[str]]] args: Container start command arguments.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] command: Container start command.
        :param pulumi.Input[Sequence[pulumi.Input['EnvironmentVarArgs']]] env: Container environment variables.
        :param pulumi.Input[str] image: Container image tag.
        :param pulumi.Input[str] name: Custom container name.
        :param pulumi.Input[Sequence[pulumi.Input['ContainerAppProbeArgs']]] probes: List of probes for the container.
        :param pulumi.Input['ContainerResourcesArgs'] resources: Container resource requirements.
        :param pulumi.Input[Sequence[pulumi.Input['VolumeMountArgs']]] volume_mounts: Container volume mounts.
        """
        if args is not None:
            pulumi.set(__self__, "args", args)
        if command is not None:
            pulumi.set(__self__, "command", command)
        if env is not None:
            pulumi.set(__self__, "env", env)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if probes is not None:
            pulumi.set(__self__, "probes", probes)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)
        if volume_mounts is not None:
            pulumi.set(__self__, "volume_mounts", volume_mounts)

    @property
    @pulumi.getter
    def args(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Container start command arguments.
        """
        return pulumi.get(self, "args")

    @args.setter
    def args(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "args", value)

    @property
    @pulumi.getter
    def command(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Container start command.
        """
        return pulumi.get(self, "command")

    @command.setter
    def command(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "command", value)

    @property
    @pulumi.getter
    def env(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentVarArgs']]]]:
        """
        Container environment variables.
        """
        return pulumi.get(self, "env")

    @env.setter
    def env(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentVarArgs']]]]):
        pulumi.set(self, "env", value)

    @property
    @pulumi.getter
    def image(self) -> Optional[pulumi.Input[str]]:
        """
        Container image tag.
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Custom container name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def probes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerAppProbeArgs']]]]:
        """
        List of probes for the container.
        """
        return pulumi.get(self, "probes")

    @probes.setter
    def probes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerAppProbeArgs']]]]):
        pulumi.set(self, "probes", value)

    @property
    @pulumi.getter
    def resources(self) -> Optional[pulumi.Input['ContainerResourcesArgs']]:
        """
        Container resource requirements.
        """
        return pulumi.get(self, "resources")

    @resources.setter
    def resources(self, value: Optional[pulumi.Input['ContainerResourcesArgs']]):
        pulumi.set(self, "resources", value)

    @property
    @pulumi.getter(name="volumeMounts")
    def volume_mounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VolumeMountArgs']]]]:
        """
        Container volume mounts.
        """
        return pulumi.get(self, "volume_mounts")

    @volume_mounts.setter
    def volume_mounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeMountArgs']]]]):
        pulumi.set(self, "volume_mounts", value)


@pulumi.input_type
class CookieExpirationArgs:
    def __init__(__self__, *,
                 convention: Optional[pulumi.Input['CookieExpirationConvention']] = None,
                 time_to_expiration: Optional[pulumi.Input[str]] = None):
        """
        The configuration settings of the session cookie's expiration.
        :param pulumi.Input['CookieExpirationConvention'] convention: The convention used when determining the session cookie's expiration.
        :param pulumi.Input[str] time_to_expiration: The time after the request is made when the session cookie should expire.
        """
        if convention is not None:
            pulumi.set(__self__, "convention", convention)
        if time_to_expiration is not None:
            pulumi.set(__self__, "time_to_expiration", time_to_expiration)

    @property
    @pulumi.getter
    def convention(self) -> Optional[pulumi.Input['CookieExpirationConvention']]:
        """
        The convention used when determining the session cookie's expiration.
        """
        return pulumi.get(self, "convention")

    @convention.setter
    def convention(self, value: Optional[pulumi.Input['CookieExpirationConvention']]):
        pulumi.set(self, "convention", value)

    @property
    @pulumi.getter(name="timeToExpiration")
    def time_to_expiration(self) -> Optional[pulumi.Input[str]]:
        """
        The time after the request is made when the session cookie should expire.
        """
        return pulumi.get(self, "time_to_expiration")

    @time_to_expiration.setter
    def time_to_expiration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_to_expiration", value)


@pulumi.input_type
class CorsPolicyArgs:
    def __init__(__self__, *,
                 allowed_origins: pulumi.Input[Sequence[pulumi.Input[str]]],
                 allow_credentials: Optional[pulumi.Input[bool]] = None,
                 allowed_headers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 allowed_methods: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 expose_headers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 max_age: Optional[pulumi.Input[int]] = None):
        """
        Cross-Origin-Resource-Sharing policy
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_origins: allowed origins
        :param pulumi.Input[bool] allow_credentials: allow credential or not
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_headers: allowed HTTP headers
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_methods: allowed HTTP methods
        :param pulumi.Input[Sequence[pulumi.Input[str]]] expose_headers: expose HTTP headers 
        :param pulumi.Input[int] max_age: max time client can cache the result
        """
        pulumi.set(__self__, "allowed_origins", allowed_origins)
        if allow_credentials is not None:
            pulumi.set(__self__, "allow_credentials", allow_credentials)
        if allowed_headers is not None:
            pulumi.set(__self__, "allowed_headers", allowed_headers)
        if allowed_methods is not None:
            pulumi.set(__self__, "allowed_methods", allowed_methods)
        if expose_headers is not None:
            pulumi.set(__self__, "expose_headers", expose_headers)
        if max_age is not None:
            pulumi.set(__self__, "max_age", max_age)

    @property
    @pulumi.getter(name="allowedOrigins")
    def allowed_origins(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        allowed origins
        """
        return pulumi.get(self, "allowed_origins")

    @allowed_origins.setter
    def allowed_origins(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "allowed_origins", value)

    @property
    @pulumi.getter(name="allowCredentials")
    def allow_credentials(self) -> Optional[pulumi.Input[bool]]:
        """
        allow credential or not
        """
        return pulumi.get(self, "allow_credentials")

    @allow_credentials.setter
    def allow_credentials(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_credentials", value)

    @property
    @pulumi.getter(name="allowedHeaders")
    def allowed_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        allowed HTTP headers
        """
        return pulumi.get(self, "allowed_headers")

    @allowed_headers.setter
    def allowed_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_headers", value)

    @property
    @pulumi.getter(name="allowedMethods")
    def allowed_methods(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        allowed HTTP methods
        """
        return pulumi.get(self, "allowed_methods")

    @allowed_methods.setter
    def allowed_methods(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_methods", value)

    @property
    @pulumi.getter(name="exposeHeaders")
    def expose_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        expose HTTP headers 
        """
        return pulumi.get(self, "expose_headers")

    @expose_headers.setter
    def expose_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "expose_headers", value)

    @property
    @pulumi.getter(name="maxAge")
    def max_age(self) -> Optional[pulumi.Input[int]]:
        """
        max time client can cache the result
        """
        return pulumi.get(self, "max_age")

    @max_age.setter
    def max_age(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_age", value)


@pulumi.input_type
class CustomDomainConfigurationArgs:
    def __init__(__self__, *,
                 certificate_password: Optional[pulumi.Input[str]] = None,
                 certificate_value: Optional[pulumi.Input[str]] = None,
                 dns_suffix: Optional[pulumi.Input[str]] = None):
        """
        Configuration properties for apps environment custom domain
        :param pulumi.Input[str] certificate_password: Certificate password
        :param pulumi.Input[str] certificate_value: PFX or PEM blob
        :param pulumi.Input[str] dns_suffix: Dns suffix for the environment domain
        """
        if certificate_password is not None:
            pulumi.set(__self__, "certificate_password", certificate_password)
        if certificate_value is not None:
            pulumi.set(__self__, "certificate_value", certificate_value)
        if dns_suffix is not None:
            pulumi.set(__self__, "dns_suffix", dns_suffix)

    @property
    @pulumi.getter(name="certificatePassword")
    def certificate_password(self) -> Optional[pulumi.Input[str]]:
        """
        Certificate password
        """
        return pulumi.get(self, "certificate_password")

    @certificate_password.setter
    def certificate_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_password", value)

    @property
    @pulumi.getter(name="certificateValue")
    def certificate_value(self) -> Optional[pulumi.Input[str]]:
        """
        PFX or PEM blob
        """
        return pulumi.get(self, "certificate_value")

    @certificate_value.setter
    def certificate_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_value", value)

    @property
    @pulumi.getter(name="dnsSuffix")
    def dns_suffix(self) -> Optional[pulumi.Input[str]]:
        """
        Dns suffix for the environment domain
        """
        return pulumi.get(self, "dns_suffix")

    @dns_suffix.setter
    def dns_suffix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dns_suffix", value)


@pulumi.input_type
class CustomDomainArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 binding_type: Optional[pulumi.Input[Union[str, 'BindingType']]] = None,
                 certificate_id: Optional[pulumi.Input[str]] = None):
        """
        Custom Domain of a Container App
        :param pulumi.Input[str] name: Hostname.
        :param pulumi.Input[Union[str, 'BindingType']] binding_type: Custom Domain binding type.
        :param pulumi.Input[str] certificate_id: Resource Id of the Certificate to be bound to this hostname.
        """
        pulumi.set(__self__, "name", name)
        if binding_type is not None:
            pulumi.set(__self__, "binding_type", binding_type)
        if certificate_id is not None:
            pulumi.set(__self__, "certificate_id", certificate_id)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Hostname.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="bindingType")
    def binding_type(self) -> Optional[pulumi.Input[Union[str, 'BindingType']]]:
        """
        Custom Domain binding type.
        """
        return pulumi.get(self, "binding_type")

    @binding_type.setter
    def binding_type(self, value: Optional[pulumi.Input[Union[str, 'BindingType']]]):
        pulumi.set(self, "binding_type", value)

    @property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource Id of the Certificate to be bound to this hostname.
        """
        return pulumi.get(self, "certificate_id")

    @certificate_id.setter
    def certificate_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_id", value)


@pulumi.input_type
class CustomOpenIdConnectProviderArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 login: Optional[pulumi.Input['OpenIdConnectLoginArgs']] = None,
                 registration: Optional[pulumi.Input['OpenIdConnectRegistrationArgs']] = None):
        """
        The configuration settings of the custom Open ID Connect provider.
        :param pulumi.Input[bool] enabled: <code>false</code> if the custom Open ID provider provider should not be enabled; otherwise, <code>true</code>.
        :param pulumi.Input['OpenIdConnectLoginArgs'] login: The configuration settings of the login flow of the custom Open ID Connect provider.
        :param pulumi.Input['OpenIdConnectRegistrationArgs'] registration: The configuration settings of the app registration for the custom Open ID Connect provider.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if login is not None:
            pulumi.set(__self__, "login", login)
        if registration is not None:
            pulumi.set(__self__, "registration", registration)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        <code>false</code> if the custom Open ID provider provider should not be enabled; otherwise, <code>true</code>.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def login(self) -> Optional[pulumi.Input['OpenIdConnectLoginArgs']]:
        """
        The configuration settings of the login flow of the custom Open ID Connect provider.
        """
        return pulumi.get(self, "login")

    @login.setter
    def login(self, value: Optional[pulumi.Input['OpenIdConnectLoginArgs']]):
        pulumi.set(self, "login", value)

    @property
    @pulumi.getter
    def registration(self) -> Optional[pulumi.Input['OpenIdConnectRegistrationArgs']]:
        """
        The configuration settings of the app registration for the custom Open ID Connect provider.
        """
        return pulumi.get(self, "registration")

    @registration.setter
    def registration(self, value: Optional[pulumi.Input['OpenIdConnectRegistrationArgs']]):
        pulumi.set(self, "registration", value)


@pulumi.input_type
class CustomScaleRuleArgs:
    def __init__(__self__, *,
                 auth: Optional[pulumi.Input[Sequence[pulumi.Input['ScaleRuleAuthArgs']]]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        Container App container Custom scaling rule.
        :param pulumi.Input[Sequence[pulumi.Input['ScaleRuleAuthArgs']]] auth: Authentication secrets for the custom scale rule.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] metadata: Metadata properties to describe custom scale rule.
        :param pulumi.Input[str] type: Type of the custom scale rule
               eg: azure-servicebus, redis etc.
        """
        if auth is not None:
            pulumi.set(__self__, "auth", auth)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def auth(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ScaleRuleAuthArgs']]]]:
        """
        Authentication secrets for the custom scale rule.
        """
        return pulumi.get(self, "auth")

    @auth.setter
    def auth(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ScaleRuleAuthArgs']]]]):
        pulumi.set(self, "auth", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Metadata properties to describe custom scale rule.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of the custom scale rule
        eg: azure-servicebus, redis etc.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class DaprMetadataArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 secret_ref: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        Dapr component metadata.
        :param pulumi.Input[str] name: Metadata property name.
        :param pulumi.Input[str] secret_ref: Name of the Dapr Component secret from which to pull the metadata property value.
        :param pulumi.Input[str] value: Metadata property value.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if secret_ref is not None:
            pulumi.set(__self__, "secret_ref", secret_ref)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Metadata property name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="secretRef")
    def secret_ref(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the Dapr Component secret from which to pull the metadata property value.
        """
        return pulumi.get(self, "secret_ref")

    @secret_ref.setter
    def secret_ref(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret_ref", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        Metadata property value.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class DaprArgs:
    def __init__(__self__, *,
                 app_id: Optional[pulumi.Input[str]] = None,
                 app_port: Optional[pulumi.Input[int]] = None,
                 app_protocol: Optional[pulumi.Input[Union[str, 'AppProtocol']]] = None,
                 enable_api_logging: Optional[pulumi.Input[bool]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 http_max_request_size: Optional[pulumi.Input[int]] = None,
                 http_read_buffer_size: Optional[pulumi.Input[int]] = None,
                 log_level: Optional[pulumi.Input[Union[str, 'LogLevel']]] = None):
        """
        Container App Dapr configuration.
        :param pulumi.Input[str] app_id: Dapr application identifier
        :param pulumi.Input[int] app_port: Tells Dapr which port your application is listening on
        :param pulumi.Input[Union[str, 'AppProtocol']] app_protocol: Tells Dapr which protocol your application is using. Valid options are http and grpc. Default is http
        :param pulumi.Input[bool] enable_api_logging: Enables API logging for the Dapr sidecar
        :param pulumi.Input[bool] enabled: Boolean indicating if the Dapr side car is enabled
        :param pulumi.Input[int] http_max_request_size: Increasing max size of request body http and grpc servers parameter in MB to handle uploading of big files. Default is 4 MB.
        :param pulumi.Input[int] http_read_buffer_size: Dapr max size of http header read buffer in KB to handle when sending multi-KB headers. Default is 65KB.
        :param pulumi.Input[Union[str, 'LogLevel']] log_level: Sets the log level for the Dapr sidecar. Allowed values are debug, info, warn, error. Default is info.
        """
        if app_id is not None:
            pulumi.set(__self__, "app_id", app_id)
        if app_port is not None:
            pulumi.set(__self__, "app_port", app_port)
        if app_protocol is None:
            app_protocol = 'http'
        if app_protocol is not None:
            pulumi.set(__self__, "app_protocol", app_protocol)
        if enable_api_logging is not None:
            pulumi.set(__self__, "enable_api_logging", enable_api_logging)
        if enabled is None:
            enabled = False
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if http_max_request_size is not None:
            pulumi.set(__self__, "http_max_request_size", http_max_request_size)
        if http_read_buffer_size is not None:
            pulumi.set(__self__, "http_read_buffer_size", http_read_buffer_size)
        if log_level is not None:
            pulumi.set(__self__, "log_level", log_level)

    @property
    @pulumi.getter(name="appId")
    def app_id(self) -> Optional[pulumi.Input[str]]:
        """
        Dapr application identifier
        """
        return pulumi.get(self, "app_id")

    @app_id.setter
    def app_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_id", value)

    @property
    @pulumi.getter(name="appPort")
    def app_port(self) -> Optional[pulumi.Input[int]]:
        """
        Tells Dapr which port your application is listening on
        """
        return pulumi.get(self, "app_port")

    @app_port.setter
    def app_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "app_port", value)

    @property
    @pulumi.getter(name="appProtocol")
    def app_protocol(self) -> Optional[pulumi.Input[Union[str, 'AppProtocol']]]:
        """
        Tells Dapr which protocol your application is using. Valid options are http and grpc. Default is http
        """
        return pulumi.get(self, "app_protocol")

    @app_protocol.setter
    def app_protocol(self, value: Optional[pulumi.Input[Union[str, 'AppProtocol']]]):
        pulumi.set(self, "app_protocol", value)

    @property
    @pulumi.getter(name="enableApiLogging")
    def enable_api_logging(self) -> Optional[pulumi.Input[bool]]:
        """
        Enables API logging for the Dapr sidecar
        """
        return pulumi.get(self, "enable_api_logging")

    @enable_api_logging.setter
    def enable_api_logging(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_api_logging", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean indicating if the Dapr side car is enabled
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="httpMaxRequestSize")
    def http_max_request_size(self) -> Optional[pulumi.Input[int]]:
        """
        Increasing max size of request body http and grpc servers parameter in MB to handle uploading of big files. Default is 4 MB.
        """
        return pulumi.get(self, "http_max_request_size")

    @http_max_request_size.setter
    def http_max_request_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "http_max_request_size", value)

    @property
    @pulumi.getter(name="httpReadBufferSize")
    def http_read_buffer_size(self) -> Optional[pulumi.Input[int]]:
        """
        Dapr max size of http header read buffer in KB to handle when sending multi-KB headers. Default is 65KB.
        """
        return pulumi.get(self, "http_read_buffer_size")

    @http_read_buffer_size.setter
    def http_read_buffer_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "http_read_buffer_size", value)

    @property
    @pulumi.getter(name="logLevel")
    def log_level(self) -> Optional[pulumi.Input[Union[str, 'LogLevel']]]:
        """
        Sets the log level for the Dapr sidecar. Allowed values are debug, info, warn, error. Default is info.
        """
        return pulumi.get(self, "log_level")

    @log_level.setter
    def log_level(self, value: Optional[pulumi.Input[Union[str, 'LogLevel']]]):
        pulumi.set(self, "log_level", value)


@pulumi.input_type
class DefaultAuthorizationPolicyArgs:
    def __init__(__self__, *,
                 allowed_applications: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 allowed_principals: Optional[pulumi.Input['AllowedPrincipalsArgs']] = None):
        """
        The configuration settings of the Azure Active Directory default authorization policy.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_applications: The configuration settings of the Azure Active Directory allowed applications.
        :param pulumi.Input['AllowedPrincipalsArgs'] allowed_principals: The configuration settings of the Azure Active Directory allowed principals.
        """
        if allowed_applications is not None:
            pulumi.set(__self__, "allowed_applications", allowed_applications)
        if allowed_principals is not None:
            pulumi.set(__self__, "allowed_principals", allowed_principals)

    @property
    @pulumi.getter(name="allowedApplications")
    def allowed_applications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The configuration settings of the Azure Active Directory allowed applications.
        """
        return pulumi.get(self, "allowed_applications")

    @allowed_applications.setter
    def allowed_applications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_applications", value)

    @property
    @pulumi.getter(name="allowedPrincipals")
    def allowed_principals(self) -> Optional[pulumi.Input['AllowedPrincipalsArgs']]:
        """
        The configuration settings of the Azure Active Directory allowed principals.
        """
        return pulumi.get(self, "allowed_principals")

    @allowed_principals.setter
    def allowed_principals(self, value: Optional[pulumi.Input['AllowedPrincipalsArgs']]):
        pulumi.set(self, "allowed_principals", value)


@pulumi.input_type
class EnvironmentSkuPropertiesArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[Union[str, 'SkuName']]):
        """
        Managed Environment resource SKU properties.
        :param pulumi.Input[Union[str, 'SkuName']] name: Name of the Sku.
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[Union[str, 'SkuName']]:
        """
        Name of the Sku.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[Union[str, 'SkuName']]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class EnvironmentVarArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 secret_ref: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        Container App container environment variable.
        :param pulumi.Input[str] name: Environment variable name.
        :param pulumi.Input[str] secret_ref: Name of the Container App secret from which to pull the environment variable value.
        :param pulumi.Input[str] value: Non-secret environment variable value.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if secret_ref is not None:
            pulumi.set(__self__, "secret_ref", secret_ref)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Environment variable name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="secretRef")
    def secret_ref(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the Container App secret from which to pull the environment variable value.
        """
        return pulumi.get(self, "secret_ref")

    @secret_ref.setter
    def secret_ref(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret_ref", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        Non-secret environment variable value.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class ExtendedLocationArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[Union[str, 'ExtendedLocationTypes']]] = None):
        """
        The complex type of the extended location.
        :param pulumi.Input[str] name: The name of the extended location.
        :param pulumi.Input[Union[str, 'ExtendedLocationTypes']] type: The type of the extended location.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the extended location.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[Union[str, 'ExtendedLocationTypes']]]:
        """
        The type of the extended location.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[Union[str, 'ExtendedLocationTypes']]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class FacebookArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 graph_api_version: Optional[pulumi.Input[str]] = None,
                 login: Optional[pulumi.Input['LoginScopesArgs']] = None,
                 registration: Optional[pulumi.Input['AppRegistrationArgs']] = None):
        """
        The configuration settings of the Facebook provider.
        :param pulumi.Input[bool] enabled: <code>false</code> if the Facebook provider should not be enabled despite the set registration; otherwise, <code>true</code>.
        :param pulumi.Input[str] graph_api_version: The version of the Facebook api to be used while logging in.
        :param pulumi.Input['LoginScopesArgs'] login: The configuration settings of the login flow.
        :param pulumi.Input['AppRegistrationArgs'] registration: The configuration settings of the app registration for the Facebook provider.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if graph_api_version is not None:
            pulumi.set(__self__, "graph_api_version", graph_api_version)
        if login is not None:
            pulumi.set(__self__, "login", login)
        if registration is not None:
            pulumi.set(__self__, "registration", registration)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        <code>false</code> if the Facebook provider should not be enabled despite the set registration; otherwise, <code>true</code>.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="graphApiVersion")
    def graph_api_version(self) -> Optional[pulumi.Input[str]]:
        """
        The version of the Facebook api to be used while logging in.
        """
        return pulumi.get(self, "graph_api_version")

    @graph_api_version.setter
    def graph_api_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "graph_api_version", value)

    @property
    @pulumi.getter
    def login(self) -> Optional[pulumi.Input['LoginScopesArgs']]:
        """
        The configuration settings of the login flow.
        """
        return pulumi.get(self, "login")

    @login.setter
    def login(self, value: Optional[pulumi.Input['LoginScopesArgs']]):
        pulumi.set(self, "login", value)

    @property
    @pulumi.getter
    def registration(self) -> Optional[pulumi.Input['AppRegistrationArgs']]:
        """
        The configuration settings of the app registration for the Facebook provider.
        """
        return pulumi.get(self, "registration")

    @registration.setter
    def registration(self, value: Optional[pulumi.Input['AppRegistrationArgs']]):
        pulumi.set(self, "registration", value)


@pulumi.input_type
class ForwardProxyArgs:
    def __init__(__self__, *,
                 convention: Optional[pulumi.Input['ForwardProxyConvention']] = None,
                 custom_host_header_name: Optional[pulumi.Input[str]] = None,
                 custom_proto_header_name: Optional[pulumi.Input[str]] = None):
        """
        The configuration settings of a forward proxy used to make the requests.
        :param pulumi.Input['ForwardProxyConvention'] convention: The convention used to determine the url of the request made.
        :param pulumi.Input[str] custom_host_header_name: The name of the header containing the host of the request.
        :param pulumi.Input[str] custom_proto_header_name: The name of the header containing the scheme of the request.
        """
        if convention is not None:
            pulumi.set(__self__, "convention", convention)
        if custom_host_header_name is not None:
            pulumi.set(__self__, "custom_host_header_name", custom_host_header_name)
        if custom_proto_header_name is not None:
            pulumi.set(__self__, "custom_proto_header_name", custom_proto_header_name)

    @property
    @pulumi.getter
    def convention(self) -> Optional[pulumi.Input['ForwardProxyConvention']]:
        """
        The convention used to determine the url of the request made.
        """
        return pulumi.get(self, "convention")

    @convention.setter
    def convention(self, value: Optional[pulumi.Input['ForwardProxyConvention']]):
        pulumi.set(self, "convention", value)

    @property
    @pulumi.getter(name="customHostHeaderName")
    def custom_host_header_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the header containing the host of the request.
        """
        return pulumi.get(self, "custom_host_header_name")

    @custom_host_header_name.setter
    def custom_host_header_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_host_header_name", value)

    @property
    @pulumi.getter(name="customProtoHeaderName")
    def custom_proto_header_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the header containing the scheme of the request.
        """
        return pulumi.get(self, "custom_proto_header_name")

    @custom_proto_header_name.setter
    def custom_proto_header_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_proto_header_name", value)


@pulumi.input_type
class GitHubArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 login: Optional[pulumi.Input['LoginScopesArgs']] = None,
                 registration: Optional[pulumi.Input['ClientRegistrationArgs']] = None):
        """
        The configuration settings of the GitHub provider.
        :param pulumi.Input[bool] enabled: <code>false</code> if the GitHub provider should not be enabled despite the set registration; otherwise, <code>true</code>.
        :param pulumi.Input['LoginScopesArgs'] login: The configuration settings of the login flow.
        :param pulumi.Input['ClientRegistrationArgs'] registration: The configuration settings of the app registration for the GitHub provider.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if login is not None:
            pulumi.set(__self__, "login", login)
        if registration is not None:
            pulumi.set(__self__, "registration", registration)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        <code>false</code> if the GitHub provider should not be enabled despite the set registration; otherwise, <code>true</code>.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def login(self) -> Optional[pulumi.Input['LoginScopesArgs']]:
        """
        The configuration settings of the login flow.
        """
        return pulumi.get(self, "login")

    @login.setter
    def login(self, value: Optional[pulumi.Input['LoginScopesArgs']]):
        pulumi.set(self, "login", value)

    @property
    @pulumi.getter
    def registration(self) -> Optional[pulumi.Input['ClientRegistrationArgs']]:
        """
        The configuration settings of the app registration for the GitHub provider.
        """
        return pulumi.get(self, "registration")

    @registration.setter
    def registration(self, value: Optional[pulumi.Input['ClientRegistrationArgs']]):
        pulumi.set(self, "registration", value)


@pulumi.input_type
class GithubActionConfigurationArgs:
    def __init__(__self__, *,
                 azure_credentials: Optional[pulumi.Input['AzureCredentialsArgs']] = None,
                 context_path: Optional[pulumi.Input[str]] = None,
                 image: Optional[pulumi.Input[str]] = None,
                 os: Optional[pulumi.Input[str]] = None,
                 publish_type: Optional[pulumi.Input[str]] = None,
                 registry_info: Optional[pulumi.Input['RegistryInfoArgs']] = None,
                 runtime_stack: Optional[pulumi.Input[str]] = None,
                 runtime_version: Optional[pulumi.Input[str]] = None):
        """
        Configuration properties that define the mutable settings of a Container App SourceControl
        :param pulumi.Input['AzureCredentialsArgs'] azure_credentials: AzureCredentials configurations.
        :param pulumi.Input[str] context_path: Context path
        :param pulumi.Input[str] image: Image name
        :param pulumi.Input[str] os: Operation system
        :param pulumi.Input[str] publish_type: Code or Image
        :param pulumi.Input['RegistryInfoArgs'] registry_info: Registry configurations.
        :param pulumi.Input[str] runtime_stack: Runtime stack
        :param pulumi.Input[str] runtime_version: Runtime version
        """
        if azure_credentials is not None:
            pulumi.set(__self__, "azure_credentials", azure_credentials)
        if context_path is not None:
            pulumi.set(__self__, "context_path", context_path)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if os is not None:
            pulumi.set(__self__, "os", os)
        if publish_type is not None:
            pulumi.set(__self__, "publish_type", publish_type)
        if registry_info is not None:
            pulumi.set(__self__, "registry_info", registry_info)
        if runtime_stack is not None:
            pulumi.set(__self__, "runtime_stack", runtime_stack)
        if runtime_version is not None:
            pulumi.set(__self__, "runtime_version", runtime_version)

    @property
    @pulumi.getter(name="azureCredentials")
    def azure_credentials(self) -> Optional[pulumi.Input['AzureCredentialsArgs']]:
        """
        AzureCredentials configurations.
        """
        return pulumi.get(self, "azure_credentials")

    @azure_credentials.setter
    def azure_credentials(self, value: Optional[pulumi.Input['AzureCredentialsArgs']]):
        pulumi.set(self, "azure_credentials", value)

    @property
    @pulumi.getter(name="contextPath")
    def context_path(self) -> Optional[pulumi.Input[str]]:
        """
        Context path
        """
        return pulumi.get(self, "context_path")

    @context_path.setter
    def context_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "context_path", value)

    @property
    @pulumi.getter
    def image(self) -> Optional[pulumi.Input[str]]:
        """
        Image name
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image", value)

    @property
    @pulumi.getter
    def os(self) -> Optional[pulumi.Input[str]]:
        """
        Operation system
        """
        return pulumi.get(self, "os")

    @os.setter
    def os(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "os", value)

    @property
    @pulumi.getter(name="publishType")
    def publish_type(self) -> Optional[pulumi.Input[str]]:
        """
        Code or Image
        """
        return pulumi.get(self, "publish_type")

    @publish_type.setter
    def publish_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "publish_type", value)

    @property
    @pulumi.getter(name="registryInfo")
    def registry_info(self) -> Optional[pulumi.Input['RegistryInfoArgs']]:
        """
        Registry configurations.
        """
        return pulumi.get(self, "registry_info")

    @registry_info.setter
    def registry_info(self, value: Optional[pulumi.Input['RegistryInfoArgs']]):
        pulumi.set(self, "registry_info", value)

    @property
    @pulumi.getter(name="runtimeStack")
    def runtime_stack(self) -> Optional[pulumi.Input[str]]:
        """
        Runtime stack
        """
        return pulumi.get(self, "runtime_stack")

    @runtime_stack.setter
    def runtime_stack(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "runtime_stack", value)

    @property
    @pulumi.getter(name="runtimeVersion")
    def runtime_version(self) -> Optional[pulumi.Input[str]]:
        """
        Runtime version
        """
        return pulumi.get(self, "runtime_version")

    @runtime_version.setter
    def runtime_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "runtime_version", value)


@pulumi.input_type
class GlobalValidationArgs:
    def __init__(__self__, *,
                 excluded_paths: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 redirect_to_provider: Optional[pulumi.Input[str]] = None,
                 unauthenticated_client_action: Optional[pulumi.Input['UnauthenticatedClientActionV2']] = None):
        """
        The configuration settings that determines the validation flow of users using ContainerApp Service Authentication/Authorization.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] excluded_paths: The paths for which unauthenticated flow would not be redirected to the login page.
        :param pulumi.Input[str] redirect_to_provider: The default authentication provider to use when multiple providers are configured.
               This setting is only needed if multiple providers are configured and the unauthenticated client
               action is set to "RedirectToLoginPage".
        :param pulumi.Input['UnauthenticatedClientActionV2'] unauthenticated_client_action: The action to take when an unauthenticated client attempts to access the app.
        """
        if excluded_paths is not None:
            pulumi.set(__self__, "excluded_paths", excluded_paths)
        if redirect_to_provider is not None:
            pulumi.set(__self__, "redirect_to_provider", redirect_to_provider)
        if unauthenticated_client_action is not None:
            pulumi.set(__self__, "unauthenticated_client_action", unauthenticated_client_action)

    @property
    @pulumi.getter(name="excludedPaths")
    def excluded_paths(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The paths for which unauthenticated flow would not be redirected to the login page.
        """
        return pulumi.get(self, "excluded_paths")

    @excluded_paths.setter
    def excluded_paths(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "excluded_paths", value)

    @property
    @pulumi.getter(name="redirectToProvider")
    def redirect_to_provider(self) -> Optional[pulumi.Input[str]]:
        """
        The default authentication provider to use when multiple providers are configured.
        This setting is only needed if multiple providers are configured and the unauthenticated client
        action is set to "RedirectToLoginPage".
        """
        return pulumi.get(self, "redirect_to_provider")

    @redirect_to_provider.setter
    def redirect_to_provider(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "redirect_to_provider", value)

    @property
    @pulumi.getter(name="unauthenticatedClientAction")
    def unauthenticated_client_action(self) -> Optional[pulumi.Input['UnauthenticatedClientActionV2']]:
        """
        The action to take when an unauthenticated client attempts to access the app.
        """
        return pulumi.get(self, "unauthenticated_client_action")

    @unauthenticated_client_action.setter
    def unauthenticated_client_action(self, value: Optional[pulumi.Input['UnauthenticatedClientActionV2']]):
        pulumi.set(self, "unauthenticated_client_action", value)


@pulumi.input_type
class GoogleArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 login: Optional[pulumi.Input['LoginScopesArgs']] = None,
                 registration: Optional[pulumi.Input['ClientRegistrationArgs']] = None,
                 validation: Optional[pulumi.Input['AllowedAudiencesValidationArgs']] = None):
        """
        The configuration settings of the Google provider.
        :param pulumi.Input[bool] enabled: <code>false</code> if the Google provider should not be enabled despite the set registration; otherwise, <code>true</code>.
        :param pulumi.Input['LoginScopesArgs'] login: The configuration settings of the login flow.
        :param pulumi.Input['ClientRegistrationArgs'] registration: The configuration settings of the app registration for the Google provider.
        :param pulumi.Input['AllowedAudiencesValidationArgs'] validation: The configuration settings of the Azure Active Directory token validation flow.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if login is not None:
            pulumi.set(__self__, "login", login)
        if registration is not None:
            pulumi.set(__self__, "registration", registration)
        if validation is not None:
            pulumi.set(__self__, "validation", validation)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        <code>false</code> if the Google provider should not be enabled despite the set registration; otherwise, <code>true</code>.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def login(self) -> Optional[pulumi.Input['LoginScopesArgs']]:
        """
        The configuration settings of the login flow.
        """
        return pulumi.get(self, "login")

    @login.setter
    def login(self, value: Optional[pulumi.Input['LoginScopesArgs']]):
        pulumi.set(self, "login", value)

    @property
    @pulumi.getter
    def registration(self) -> Optional[pulumi.Input['ClientRegistrationArgs']]:
        """
        The configuration settings of the app registration for the Google provider.
        """
        return pulumi.get(self, "registration")

    @registration.setter
    def registration(self, value: Optional[pulumi.Input['ClientRegistrationArgs']]):
        pulumi.set(self, "registration", value)

    @property
    @pulumi.getter
    def validation(self) -> Optional[pulumi.Input['AllowedAudiencesValidationArgs']]:
        """
        The configuration settings of the Azure Active Directory token validation flow.
        """
        return pulumi.get(self, "validation")

    @validation.setter
    def validation(self, value: Optional[pulumi.Input['AllowedAudiencesValidationArgs']]):
        pulumi.set(self, "validation", value)


@pulumi.input_type
class HttpScaleRuleArgs:
    def __init__(__self__, *,
                 auth: Optional[pulumi.Input[Sequence[pulumi.Input['ScaleRuleAuthArgs']]]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Container App container Http scaling rule.
        :param pulumi.Input[Sequence[pulumi.Input['ScaleRuleAuthArgs']]] auth: Authentication secrets for the custom scale rule.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] metadata: Metadata properties to describe http scale rule.
        """
        if auth is not None:
            pulumi.set(__self__, "auth", auth)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)

    @property
    @pulumi.getter
    def auth(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ScaleRuleAuthArgs']]]]:
        """
        Authentication secrets for the custom scale rule.
        """
        return pulumi.get(self, "auth")

    @auth.setter
    def auth(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ScaleRuleAuthArgs']]]]):
        pulumi.set(self, "auth", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Metadata properties to describe http scale rule.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "metadata", value)


@pulumi.input_type
class HttpSettingsRoutesArgs:
    def __init__(__self__, *,
                 api_prefix: Optional[pulumi.Input[str]] = None):
        """
        The configuration settings of the paths HTTP requests.
        :param pulumi.Input[str] api_prefix: The prefix that should precede all the authentication/authorization paths.
        """
        if api_prefix is not None:
            pulumi.set(__self__, "api_prefix", api_prefix)

    @property
    @pulumi.getter(name="apiPrefix")
    def api_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        The prefix that should precede all the authentication/authorization paths.
        """
        return pulumi.get(self, "api_prefix")

    @api_prefix.setter
    def api_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "api_prefix", value)


@pulumi.input_type
class HttpSettingsArgs:
    def __init__(__self__, *,
                 forward_proxy: Optional[pulumi.Input['ForwardProxyArgs']] = None,
                 require_https: Optional[pulumi.Input[bool]] = None,
                 routes: Optional[pulumi.Input['HttpSettingsRoutesArgs']] = None):
        """
        The configuration settings of the HTTP requests for authentication and authorization requests made against ContainerApp Service Authentication/Authorization.
        :param pulumi.Input['ForwardProxyArgs'] forward_proxy: The configuration settings of a forward proxy used to make the requests.
        :param pulumi.Input[bool] require_https: <code>false</code> if the authentication/authorization responses not having the HTTPS scheme are permissible; otherwise, <code>true</code>.
        :param pulumi.Input['HttpSettingsRoutesArgs'] routes: The configuration settings of the paths HTTP requests.
        """
        if forward_proxy is not None:
            pulumi.set(__self__, "forward_proxy", forward_proxy)
        if require_https is not None:
            pulumi.set(__self__, "require_https", require_https)
        if routes is not None:
            pulumi.set(__self__, "routes", routes)

    @property
    @pulumi.getter(name="forwardProxy")
    def forward_proxy(self) -> Optional[pulumi.Input['ForwardProxyArgs']]:
        """
        The configuration settings of a forward proxy used to make the requests.
        """
        return pulumi.get(self, "forward_proxy")

    @forward_proxy.setter
    def forward_proxy(self, value: Optional[pulumi.Input['ForwardProxyArgs']]):
        pulumi.set(self, "forward_proxy", value)

    @property
    @pulumi.getter(name="requireHttps")
    def require_https(self) -> Optional[pulumi.Input[bool]]:
        """
        <code>false</code> if the authentication/authorization responses not having the HTTPS scheme are permissible; otherwise, <code>true</code>.
        """
        return pulumi.get(self, "require_https")

    @require_https.setter
    def require_https(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "require_https", value)

    @property
    @pulumi.getter
    def routes(self) -> Optional[pulumi.Input['HttpSettingsRoutesArgs']]:
        """
        The configuration settings of the paths HTTP requests.
        """
        return pulumi.get(self, "routes")

    @routes.setter
    def routes(self, value: Optional[pulumi.Input['HttpSettingsRoutesArgs']]):
        pulumi.set(self, "routes", value)


@pulumi.input_type
class IdentityProvidersArgs:
    def __init__(__self__, *,
                 apple: Optional[pulumi.Input['AppleArgs']] = None,
                 azure_active_directory: Optional[pulumi.Input['AzureActiveDirectoryArgs']] = None,
                 azure_static_web_apps: Optional[pulumi.Input['AzureStaticWebAppsArgs']] = None,
                 custom_open_id_connect_providers: Optional[pulumi.Input[Mapping[str, pulumi.Input['CustomOpenIdConnectProviderArgs']]]] = None,
                 facebook: Optional[pulumi.Input['FacebookArgs']] = None,
                 git_hub: Optional[pulumi.Input['GitHubArgs']] = None,
                 google: Optional[pulumi.Input['GoogleArgs']] = None,
                 twitter: Optional[pulumi.Input['TwitterArgs']] = None):
        """
        The configuration settings of each of the identity providers used to configure ContainerApp Service Authentication/Authorization.
        :param pulumi.Input['AppleArgs'] apple: The configuration settings of the Apple provider.
        :param pulumi.Input['AzureActiveDirectoryArgs'] azure_active_directory: The configuration settings of the Azure Active directory provider.
        :param pulumi.Input['AzureStaticWebAppsArgs'] azure_static_web_apps: The configuration settings of the Azure Static Web Apps provider.
        :param pulumi.Input[Mapping[str, pulumi.Input['CustomOpenIdConnectProviderArgs']]] custom_open_id_connect_providers: The map of the name of the alias of each custom Open ID Connect provider to the
               configuration settings of the custom Open ID Connect provider.
        :param pulumi.Input['FacebookArgs'] facebook: The configuration settings of the Facebook provider.
        :param pulumi.Input['GitHubArgs'] git_hub: The configuration settings of the GitHub provider.
        :param pulumi.Input['GoogleArgs'] google: The configuration settings of the Google provider.
        :param pulumi.Input['TwitterArgs'] twitter: The configuration settings of the Twitter provider.
        """
        if apple is not None:
            pulumi.set(__self__, "apple", apple)
        if azure_active_directory is not None:
            pulumi.set(__self__, "azure_active_directory", azure_active_directory)
        if azure_static_web_apps is not None:
            pulumi.set(__self__, "azure_static_web_apps", azure_static_web_apps)
        if custom_open_id_connect_providers is not None:
            pulumi.set(__self__, "custom_open_id_connect_providers", custom_open_id_connect_providers)
        if facebook is not None:
            pulumi.set(__self__, "facebook", facebook)
        if git_hub is not None:
            pulumi.set(__self__, "git_hub", git_hub)
        if google is not None:
            pulumi.set(__self__, "google", google)
        if twitter is not None:
            pulumi.set(__self__, "twitter", twitter)

    @property
    @pulumi.getter
    def apple(self) -> Optional[pulumi.Input['AppleArgs']]:
        """
        The configuration settings of the Apple provider.
        """
        return pulumi.get(self, "apple")

    @apple.setter
    def apple(self, value: Optional[pulumi.Input['AppleArgs']]):
        pulumi.set(self, "apple", value)

    @property
    @pulumi.getter(name="azureActiveDirectory")
    def azure_active_directory(self) -> Optional[pulumi.Input['AzureActiveDirectoryArgs']]:
        """
        The configuration settings of the Azure Active directory provider.
        """
        return pulumi.get(self, "azure_active_directory")

    @azure_active_directory.setter
    def azure_active_directory(self, value: Optional[pulumi.Input['AzureActiveDirectoryArgs']]):
        pulumi.set(self, "azure_active_directory", value)

    @property
    @pulumi.getter(name="azureStaticWebApps")
    def azure_static_web_apps(self) -> Optional[pulumi.Input['AzureStaticWebAppsArgs']]:
        """
        The configuration settings of the Azure Static Web Apps provider.
        """
        return pulumi.get(self, "azure_static_web_apps")

    @azure_static_web_apps.setter
    def azure_static_web_apps(self, value: Optional[pulumi.Input['AzureStaticWebAppsArgs']]):
        pulumi.set(self, "azure_static_web_apps", value)

    @property
    @pulumi.getter(name="customOpenIdConnectProviders")
    def custom_open_id_connect_providers(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['CustomOpenIdConnectProviderArgs']]]]:
        """
        The map of the name of the alias of each custom Open ID Connect provider to the
        configuration settings of the custom Open ID Connect provider.
        """
        return pulumi.get(self, "custom_open_id_connect_providers")

    @custom_open_id_connect_providers.setter
    def custom_open_id_connect_providers(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['CustomOpenIdConnectProviderArgs']]]]):
        pulumi.set(self, "custom_open_id_connect_providers", value)

    @property
    @pulumi.getter
    def facebook(self) -> Optional[pulumi.Input['FacebookArgs']]:
        """
        The configuration settings of the Facebook provider.
        """
        return pulumi.get(self, "facebook")

    @facebook.setter
    def facebook(self, value: Optional[pulumi.Input['FacebookArgs']]):
        pulumi.set(self, "facebook", value)

    @property
    @pulumi.getter(name="gitHub")
    def git_hub(self) -> Optional[pulumi.Input['GitHubArgs']]:
        """
        The configuration settings of the GitHub provider.
        """
        return pulumi.get(self, "git_hub")

    @git_hub.setter
    def git_hub(self, value: Optional[pulumi.Input['GitHubArgs']]):
        pulumi.set(self, "git_hub", value)

    @property
    @pulumi.getter
    def google(self) -> Optional[pulumi.Input['GoogleArgs']]:
        """
        The configuration settings of the Google provider.
        """
        return pulumi.get(self, "google")

    @google.setter
    def google(self, value: Optional[pulumi.Input['GoogleArgs']]):
        pulumi.set(self, "google", value)

    @property
    @pulumi.getter
    def twitter(self) -> Optional[pulumi.Input['TwitterArgs']]:
        """
        The configuration settings of the Twitter provider.
        """
        return pulumi.get(self, "twitter")

    @twitter.setter
    def twitter(self, value: Optional[pulumi.Input['TwitterArgs']]):
        pulumi.set(self, "twitter", value)


@pulumi.input_type
class IngressArgs:
    def __init__(__self__, *,
                 allow_insecure: Optional[pulumi.Input[bool]] = None,
                 client_certificate_mode: Optional[pulumi.Input[Union[str, 'IngressClientCertificateMode']]] = None,
                 cors_policy: Optional[pulumi.Input['CorsPolicyArgs']] = None,
                 custom_domains: Optional[pulumi.Input[Sequence[pulumi.Input['CustomDomainArgs']]]] = None,
                 exposed_port: Optional[pulumi.Input[int]] = None,
                 external: Optional[pulumi.Input[bool]] = None,
                 ip_security_restrictions: Optional[pulumi.Input[Sequence[pulumi.Input['IpSecurityRestrictionRuleArgs']]]] = None,
                 target_port: Optional[pulumi.Input[int]] = None,
                 traffic: Optional[pulumi.Input[Sequence[pulumi.Input['TrafficWeightArgs']]]] = None,
                 transport: Optional[pulumi.Input[Union[str, 'IngressTransportMethod']]] = None):
        """
        Container App Ingress configuration.
        :param pulumi.Input[bool] allow_insecure: Bool indicating if HTTP connections to is allowed. If set to false HTTP connections are automatically redirected to HTTPS connections
        :param pulumi.Input[Union[str, 'IngressClientCertificateMode']] client_certificate_mode: Client certificate mode for mTLS authentication. Ignore indicates server drops client certificate on forwarding. Accept indicates server forwards client certificate but does not require a client certificate. Require indicates server requires a client certificate.
        :param pulumi.Input['CorsPolicyArgs'] cors_policy: CORS policy for container app
        :param pulumi.Input[Sequence[pulumi.Input['CustomDomainArgs']]] custom_domains: custom domain bindings for Container Apps' hostnames.
        :param pulumi.Input[int] exposed_port: Exposed Port in containers for TCP traffic from ingress
        :param pulumi.Input[bool] external: Bool indicating if app exposes an external http endpoint
        :param pulumi.Input[Sequence[pulumi.Input['IpSecurityRestrictionRuleArgs']]] ip_security_restrictions: Rules to restrict incoming IP address.
        :param pulumi.Input[int] target_port: Target Port in containers for traffic from ingress
        :param pulumi.Input[Sequence[pulumi.Input['TrafficWeightArgs']]] traffic: Traffic weights for app's revisions
        :param pulumi.Input[Union[str, 'IngressTransportMethod']] transport: Ingress transport protocol
        """
        if allow_insecure is None:
            allow_insecure = False
        if allow_insecure is not None:
            pulumi.set(__self__, "allow_insecure", allow_insecure)
        if client_certificate_mode is not None:
            pulumi.set(__self__, "client_certificate_mode", client_certificate_mode)
        if cors_policy is not None:
            pulumi.set(__self__, "cors_policy", cors_policy)
        if custom_domains is not None:
            pulumi.set(__self__, "custom_domains", custom_domains)
        if exposed_port is not None:
            pulumi.set(__self__, "exposed_port", exposed_port)
        if external is None:
            external = False
        if external is not None:
            pulumi.set(__self__, "external", external)
        if ip_security_restrictions is not None:
            pulumi.set(__self__, "ip_security_restrictions", ip_security_restrictions)
        if target_port is not None:
            pulumi.set(__self__, "target_port", target_port)
        if traffic is not None:
            pulumi.set(__self__, "traffic", traffic)
        if transport is None:
            transport = 'auto'
        if transport is not None:
            pulumi.set(__self__, "transport", transport)

    @property
    @pulumi.getter(name="allowInsecure")
    def allow_insecure(self) -> Optional[pulumi.Input[bool]]:
        """
        Bool indicating if HTTP connections to is allowed. If set to false HTTP connections are automatically redirected to HTTPS connections
        """
        return pulumi.get(self, "allow_insecure")

    @allow_insecure.setter
    def allow_insecure(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_insecure", value)

    @property
    @pulumi.getter(name="clientCertificateMode")
    def client_certificate_mode(self) -> Optional[pulumi.Input[Union[str, 'IngressClientCertificateMode']]]:
        """
        Client certificate mode for mTLS authentication. Ignore indicates server drops client certificate on forwarding. Accept indicates server forwards client certificate but does not require a client certificate. Require indicates server requires a client certificate.
        """
        return pulumi.get(self, "client_certificate_mode")

    @client_certificate_mode.setter
    def client_certificate_mode(self, value: Optional[pulumi.Input[Union[str, 'IngressClientCertificateMode']]]):
        pulumi.set(self, "client_certificate_mode", value)

    @property
    @pulumi.getter(name="corsPolicy")
    def cors_policy(self) -> Optional[pulumi.Input['CorsPolicyArgs']]:
        """
        CORS policy for container app
        """
        return pulumi.get(self, "cors_policy")

    @cors_policy.setter
    def cors_policy(self, value: Optional[pulumi.Input['CorsPolicyArgs']]):
        pulumi.set(self, "cors_policy", value)

    @property
    @pulumi.getter(name="customDomains")
    def custom_domains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CustomDomainArgs']]]]:
        """
        custom domain bindings for Container Apps' hostnames.
        """
        return pulumi.get(self, "custom_domains")

    @custom_domains.setter
    def custom_domains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CustomDomainArgs']]]]):
        pulumi.set(self, "custom_domains", value)

    @property
    @pulumi.getter(name="exposedPort")
    def exposed_port(self) -> Optional[pulumi.Input[int]]:
        """
        Exposed Port in containers for TCP traffic from ingress
        """
        return pulumi.get(self, "exposed_port")

    @exposed_port.setter
    def exposed_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "exposed_port", value)

    @property
    @pulumi.getter
    def external(self) -> Optional[pulumi.Input[bool]]:
        """
        Bool indicating if app exposes an external http endpoint
        """
        return pulumi.get(self, "external")

    @external.setter
    def external(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "external", value)

    @property
    @pulumi.getter(name="ipSecurityRestrictions")
    def ip_security_restrictions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IpSecurityRestrictionRuleArgs']]]]:
        """
        Rules to restrict incoming IP address.
        """
        return pulumi.get(self, "ip_security_restrictions")

    @ip_security_restrictions.setter
    def ip_security_restrictions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IpSecurityRestrictionRuleArgs']]]]):
        pulumi.set(self, "ip_security_restrictions", value)

    @property
    @pulumi.getter(name="targetPort")
    def target_port(self) -> Optional[pulumi.Input[int]]:
        """
        Target Port in containers for traffic from ingress
        """
        return pulumi.get(self, "target_port")

    @target_port.setter
    def target_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "target_port", value)

    @property
    @pulumi.getter
    def traffic(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TrafficWeightArgs']]]]:
        """
        Traffic weights for app's revisions
        """
        return pulumi.get(self, "traffic")

    @traffic.setter
    def traffic(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TrafficWeightArgs']]]]):
        pulumi.set(self, "traffic", value)

    @property
    @pulumi.getter
    def transport(self) -> Optional[pulumi.Input[Union[str, 'IngressTransportMethod']]]:
        """
        Ingress transport protocol
        """
        return pulumi.get(self, "transport")

    @transport.setter
    def transport(self, value: Optional[pulumi.Input[Union[str, 'IngressTransportMethod']]]):
        pulumi.set(self, "transport", value)


@pulumi.input_type
class InitContainerArgs:
    def __init__(__self__, *,
                 args: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 command: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 env: Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentVarArgs']]]] = None,
                 image: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 resources: Optional[pulumi.Input['ContainerResourcesArgs']] = None,
                 volume_mounts: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeMountArgs']]]] = None):
        """
        Container App init container definition
        :param pulumi.Input[Sequence[pulumi.Input[str]]] args: Container start command arguments.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] command: Container start command.
        :param pulumi.Input[Sequence[pulumi.Input['EnvironmentVarArgs']]] env: Container environment variables.
        :param pulumi.Input[str] image: Container image tag.
        :param pulumi.Input[str] name: Custom container name.
        :param pulumi.Input['ContainerResourcesArgs'] resources: Container resource requirements.
        :param pulumi.Input[Sequence[pulumi.Input['VolumeMountArgs']]] volume_mounts: Container volume mounts.
        """
        if args is not None:
            pulumi.set(__self__, "args", args)
        if command is not None:
            pulumi.set(__self__, "command", command)
        if env is not None:
            pulumi.set(__self__, "env", env)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)
        if volume_mounts is not None:
            pulumi.set(__self__, "volume_mounts", volume_mounts)

    @property
    @pulumi.getter
    def args(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Container start command arguments.
        """
        return pulumi.get(self, "args")

    @args.setter
    def args(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "args", value)

    @property
    @pulumi.getter
    def command(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Container start command.
        """
        return pulumi.get(self, "command")

    @command.setter
    def command(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "command", value)

    @property
    @pulumi.getter
    def env(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentVarArgs']]]]:
        """
        Container environment variables.
        """
        return pulumi.get(self, "env")

    @env.setter
    def env(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentVarArgs']]]]):
        pulumi.set(self, "env", value)

    @property
    @pulumi.getter
    def image(self) -> Optional[pulumi.Input[str]]:
        """
        Container image tag.
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Custom container name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def resources(self) -> Optional[pulumi.Input['ContainerResourcesArgs']]:
        """
        Container resource requirements.
        """
        return pulumi.get(self, "resources")

    @resources.setter
    def resources(self, value: Optional[pulumi.Input['ContainerResourcesArgs']]):
        pulumi.set(self, "resources", value)

    @property
    @pulumi.getter(name="volumeMounts")
    def volume_mounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VolumeMountArgs']]]]:
        """
        Container volume mounts.
        """
        return pulumi.get(self, "volume_mounts")

    @volume_mounts.setter
    def volume_mounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeMountArgs']]]]):
        pulumi.set(self, "volume_mounts", value)


@pulumi.input_type
class IpSecurityRestrictionRuleArgs:
    def __init__(__self__, *,
                 action: pulumi.Input[Union[str, 'Action']],
                 ip_address_range: pulumi.Input[str],
                 name: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None):
        """
        Rule to restrict incoming IP address.
        :param pulumi.Input[Union[str, 'Action']] action: Allow or Deny rules to determine for incoming IP. Note: Rules can only consist of ALL Allow or ALL Deny
        :param pulumi.Input[str] ip_address_range: CIDR notation to match incoming IP address
        :param pulumi.Input[str] name: Name for the IP restriction rule.
        :param pulumi.Input[str] description: Describe the IP restriction rule that is being sent to the container-app. This is an optional field.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "ip_address_range", ip_address_range)
        pulumi.set(__self__, "name", name)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Input[Union[str, 'Action']]:
        """
        Allow or Deny rules to determine for incoming IP. Note: Rules can only consist of ALL Allow or ALL Deny
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input[Union[str, 'Action']]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter(name="ipAddressRange")
    def ip_address_range(self) -> pulumi.Input[str]:
        """
        CIDR notation to match incoming IP address
        """
        return pulumi.get(self, "ip_address_range")

    @ip_address_range.setter
    def ip_address_range(self, value: pulumi.Input[str]):
        pulumi.set(self, "ip_address_range", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Name for the IP restriction rule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Describe the IP restriction rule that is being sent to the container-app. This is an optional field.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class JwtClaimChecksArgs:
    def __init__(__self__, *,
                 allowed_client_applications: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 allowed_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The configuration settings of the checks that should be made while validating the JWT Claims.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_client_applications: The list of the allowed client applications.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_groups: The list of the allowed groups.
        """
        if allowed_client_applications is not None:
            pulumi.set(__self__, "allowed_client_applications", allowed_client_applications)
        if allowed_groups is not None:
            pulumi.set(__self__, "allowed_groups", allowed_groups)

    @property
    @pulumi.getter(name="allowedClientApplications")
    def allowed_client_applications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of the allowed client applications.
        """
        return pulumi.get(self, "allowed_client_applications")

    @allowed_client_applications.setter
    def allowed_client_applications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_client_applications", value)

    @property
    @pulumi.getter(name="allowedGroups")
    def allowed_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of the allowed groups.
        """
        return pulumi.get(self, "allowed_groups")

    @allowed_groups.setter
    def allowed_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_groups", value)


@pulumi.input_type
class LogAnalyticsConfigurationArgs:
    def __init__(__self__, *,
                 customer_id: Optional[pulumi.Input[str]] = None,
                 shared_key: Optional[pulumi.Input[str]] = None):
        """
        Log analytics configuration
        :param pulumi.Input[str] customer_id: Log analytics customer id
        :param pulumi.Input[str] shared_key: Log analytics customer key
        """
        if customer_id is not None:
            pulumi.set(__self__, "customer_id", customer_id)
        if shared_key is not None:
            pulumi.set(__self__, "shared_key", shared_key)

    @property
    @pulumi.getter(name="customerId")
    def customer_id(self) -> Optional[pulumi.Input[str]]:
        """
        Log analytics customer id
        """
        return pulumi.get(self, "customer_id")

    @customer_id.setter
    def customer_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "customer_id", value)

    @property
    @pulumi.getter(name="sharedKey")
    def shared_key(self) -> Optional[pulumi.Input[str]]:
        """
        Log analytics customer key
        """
        return pulumi.get(self, "shared_key")

    @shared_key.setter
    def shared_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "shared_key", value)


@pulumi.input_type
class LoginRoutesArgs:
    def __init__(__self__, *,
                 logout_endpoint: Optional[pulumi.Input[str]] = None):
        """
        The routes that specify the endpoints used for login and logout requests.
        :param pulumi.Input[str] logout_endpoint: The endpoint at which a logout request should be made.
        """
        if logout_endpoint is not None:
            pulumi.set(__self__, "logout_endpoint", logout_endpoint)

    @property
    @pulumi.getter(name="logoutEndpoint")
    def logout_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        The endpoint at which a logout request should be made.
        """
        return pulumi.get(self, "logout_endpoint")

    @logout_endpoint.setter
    def logout_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "logout_endpoint", value)


@pulumi.input_type
class LoginScopesArgs:
    def __init__(__self__, *,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The configuration settings of the login flow, including the scopes that should be requested.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] scopes: A list of the scopes that should be requested while authenticating.
        """
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)

    @property
    @pulumi.getter
    def scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of the scopes that should be requested while authenticating.
        """
        return pulumi.get(self, "scopes")

    @scopes.setter
    def scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "scopes", value)


@pulumi.input_type
class LoginArgs:
    def __init__(__self__, *,
                 allowed_external_redirect_urls: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 cookie_expiration: Optional[pulumi.Input['CookieExpirationArgs']] = None,
                 nonce: Optional[pulumi.Input['NonceArgs']] = None,
                 preserve_url_fragments_for_logins: Optional[pulumi.Input[bool]] = None,
                 routes: Optional[pulumi.Input['LoginRoutesArgs']] = None):
        """
        The configuration settings of the login flow of users using ContainerApp Service Authentication/Authorization.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_external_redirect_urls: External URLs that can be redirected to as part of logging in or logging out of the app. Note that the query string part of the URL is ignored.
               This is an advanced setting typically only needed by Windows Store application backends.
               Note that URLs within the current domain are always implicitly allowed.
        :param pulumi.Input['CookieExpirationArgs'] cookie_expiration: The configuration settings of the session cookie's expiration.
        :param pulumi.Input['NonceArgs'] nonce: The configuration settings of the nonce used in the login flow.
        :param pulumi.Input[bool] preserve_url_fragments_for_logins: <code>true</code> if the fragments from the request are preserved after the login request is made; otherwise, <code>false</code>.
        :param pulumi.Input['LoginRoutesArgs'] routes: The routes that specify the endpoints used for login and logout requests.
        """
        if allowed_external_redirect_urls is not None:
            pulumi.set(__self__, "allowed_external_redirect_urls", allowed_external_redirect_urls)
        if cookie_expiration is not None:
            pulumi.set(__self__, "cookie_expiration", cookie_expiration)
        if nonce is not None:
            pulumi.set(__self__, "nonce", nonce)
        if preserve_url_fragments_for_logins is not None:
            pulumi.set(__self__, "preserve_url_fragments_for_logins", preserve_url_fragments_for_logins)
        if routes is not None:
            pulumi.set(__self__, "routes", routes)

    @property
    @pulumi.getter(name="allowedExternalRedirectUrls")
    def allowed_external_redirect_urls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        External URLs that can be redirected to as part of logging in or logging out of the app. Note that the query string part of the URL is ignored.
        This is an advanced setting typically only needed by Windows Store application backends.
        Note that URLs within the current domain are always implicitly allowed.
        """
        return pulumi.get(self, "allowed_external_redirect_urls")

    @allowed_external_redirect_urls.setter
    def allowed_external_redirect_urls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_external_redirect_urls", value)

    @property
    @pulumi.getter(name="cookieExpiration")
    def cookie_expiration(self) -> Optional[pulumi.Input['CookieExpirationArgs']]:
        """
        The configuration settings of the session cookie's expiration.
        """
        return pulumi.get(self, "cookie_expiration")

    @cookie_expiration.setter
    def cookie_expiration(self, value: Optional[pulumi.Input['CookieExpirationArgs']]):
        pulumi.set(self, "cookie_expiration", value)

    @property
    @pulumi.getter
    def nonce(self) -> Optional[pulumi.Input['NonceArgs']]:
        """
        The configuration settings of the nonce used in the login flow.
        """
        return pulumi.get(self, "nonce")

    @nonce.setter
    def nonce(self, value: Optional[pulumi.Input['NonceArgs']]):
        pulumi.set(self, "nonce", value)

    @property
    @pulumi.getter(name="preserveUrlFragmentsForLogins")
    def preserve_url_fragments_for_logins(self) -> Optional[pulumi.Input[bool]]:
        """
        <code>true</code> if the fragments from the request are preserved after the login request is made; otherwise, <code>false</code>.
        """
        return pulumi.get(self, "preserve_url_fragments_for_logins")

    @preserve_url_fragments_for_logins.setter
    def preserve_url_fragments_for_logins(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "preserve_url_fragments_for_logins", value)

    @property
    @pulumi.getter
    def routes(self) -> Optional[pulumi.Input['LoginRoutesArgs']]:
        """
        The routes that specify the endpoints used for login and logout requests.
        """
        return pulumi.get(self, "routes")

    @routes.setter
    def routes(self, value: Optional[pulumi.Input['LoginRoutesArgs']]):
        pulumi.set(self, "routes", value)


@pulumi.input_type
class ManagedEnvironmentOutboundSettingsArgs:
    def __init__(__self__, *,
                 out_bound_type: Optional[pulumi.Input[Union[str, 'ManagedEnvironmentOutBoundType']]] = None,
                 virtual_network_appliance_ip: Optional[pulumi.Input[str]] = None):
        """
        Configuration used to control the Environment Egress outbound traffic
        :param pulumi.Input[Union[str, 'ManagedEnvironmentOutBoundType']] out_bound_type: Outbound type for the cluster
        :param pulumi.Input[str] virtual_network_appliance_ip: Virtual Appliance IP used as the Egress controller for the Environment
        """
        if out_bound_type is not None:
            pulumi.set(__self__, "out_bound_type", out_bound_type)
        if virtual_network_appliance_ip is not None:
            pulumi.set(__self__, "virtual_network_appliance_ip", virtual_network_appliance_ip)

    @property
    @pulumi.getter(name="outBoundType")
    def out_bound_type(self) -> Optional[pulumi.Input[Union[str, 'ManagedEnvironmentOutBoundType']]]:
        """
        Outbound type for the cluster
        """
        return pulumi.get(self, "out_bound_type")

    @out_bound_type.setter
    def out_bound_type(self, value: Optional[pulumi.Input[Union[str, 'ManagedEnvironmentOutBoundType']]]):
        pulumi.set(self, "out_bound_type", value)

    @property
    @pulumi.getter(name="virtualNetworkApplianceIp")
    def virtual_network_appliance_ip(self) -> Optional[pulumi.Input[str]]:
        """
        Virtual Appliance IP used as the Egress controller for the Environment
        """
        return pulumi.get(self, "virtual_network_appliance_ip")

    @virtual_network_appliance_ip.setter
    def virtual_network_appliance_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "virtual_network_appliance_ip", value)


@pulumi.input_type
class ManagedEnvironmentStoragePropertiesArgs:
    def __init__(__self__, *,
                 azure_file: Optional[pulumi.Input['AzureFilePropertiesArgs']] = None):
        """
        Storage properties
        :param pulumi.Input['AzureFilePropertiesArgs'] azure_file: Azure file properties
        """
        if azure_file is not None:
            pulumi.set(__self__, "azure_file", azure_file)

    @property
    @pulumi.getter(name="azureFile")
    def azure_file(self) -> Optional[pulumi.Input['AzureFilePropertiesArgs']]:
        """
        Azure file properties
        """
        return pulumi.get(self, "azure_file")

    @azure_file.setter
    def azure_file(self, value: Optional[pulumi.Input['AzureFilePropertiesArgs']]):
        pulumi.set(self, "azure_file", value)


@pulumi.input_type
class ManagedServiceIdentityArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[Union[str, 'ManagedServiceIdentityType']],
                 user_assigned_identities: Optional[pulumi.Input[Mapping[str, Any]]] = None):
        """
        Managed service identity (system assigned and/or user assigned identities)
        :param pulumi.Input[Union[str, 'ManagedServiceIdentityType']] type: Type of managed service identity (where both SystemAssigned and UserAssigned types are allowed).
        :param pulumi.Input[Mapping[str, Any]] user_assigned_identities: The set of user assigned identities associated with the resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}. The dictionary values can be empty objects ({}) in requests.
        """
        pulumi.set(__self__, "type", type)
        if user_assigned_identities is not None:
            pulumi.set(__self__, "user_assigned_identities", user_assigned_identities)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[Union[str, 'ManagedServiceIdentityType']]:
        """
        Type of managed service identity (where both SystemAssigned and UserAssigned types are allowed).
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[Union[str, 'ManagedServiceIdentityType']]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="userAssignedIdentities")
    def user_assigned_identities(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        The set of user assigned identities associated with the resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}. The dictionary values can be empty objects ({}) in requests.
        """
        return pulumi.get(self, "user_assigned_identities")

    @user_assigned_identities.setter
    def user_assigned_identities(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "user_assigned_identities", value)


@pulumi.input_type
class NonceArgs:
    def __init__(__self__, *,
                 nonce_expiration_interval: Optional[pulumi.Input[str]] = None,
                 validate_nonce: Optional[pulumi.Input[bool]] = None):
        """
        The configuration settings of the nonce used in the login flow.
        :param pulumi.Input[str] nonce_expiration_interval: The time after the request is made when the nonce should expire.
        :param pulumi.Input[bool] validate_nonce: <code>false</code> if the nonce should not be validated while completing the login flow; otherwise, <code>true</code>.
        """
        if nonce_expiration_interval is not None:
            pulumi.set(__self__, "nonce_expiration_interval", nonce_expiration_interval)
        if validate_nonce is not None:
            pulumi.set(__self__, "validate_nonce", validate_nonce)

    @property
    @pulumi.getter(name="nonceExpirationInterval")
    def nonce_expiration_interval(self) -> Optional[pulumi.Input[str]]:
        """
        The time after the request is made when the nonce should expire.
        """
        return pulumi.get(self, "nonce_expiration_interval")

    @nonce_expiration_interval.setter
    def nonce_expiration_interval(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "nonce_expiration_interval", value)

    @property
    @pulumi.getter(name="validateNonce")
    def validate_nonce(self) -> Optional[pulumi.Input[bool]]:
        """
        <code>false</code> if the nonce should not be validated while completing the login flow; otherwise, <code>true</code>.
        """
        return pulumi.get(self, "validate_nonce")

    @validate_nonce.setter
    def validate_nonce(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "validate_nonce", value)


@pulumi.input_type
class OpenIdConnectClientCredentialArgs:
    def __init__(__self__, *,
                 client_secret_setting_name: Optional[pulumi.Input[str]] = None,
                 method: Optional[pulumi.Input['ClientCredentialMethod']] = None):
        """
        The authentication client credentials of the custom Open ID Connect provider.
        :param pulumi.Input[str] client_secret_setting_name: The app setting that contains the client secret for the custom Open ID Connect provider.
        :param pulumi.Input['ClientCredentialMethod'] method: The method that should be used to authenticate the user.
        """
        if client_secret_setting_name is not None:
            pulumi.set(__self__, "client_secret_setting_name", client_secret_setting_name)
        if method is not None:
            pulumi.set(__self__, "method", method)

    @property
    @pulumi.getter(name="clientSecretSettingName")
    def client_secret_setting_name(self) -> Optional[pulumi.Input[str]]:
        """
        The app setting that contains the client secret for the custom Open ID Connect provider.
        """
        return pulumi.get(self, "client_secret_setting_name")

    @client_secret_setting_name.setter
    def client_secret_setting_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_secret_setting_name", value)

    @property
    @pulumi.getter
    def method(self) -> Optional[pulumi.Input['ClientCredentialMethod']]:
        """
        The method that should be used to authenticate the user.
        """
        return pulumi.get(self, "method")

    @method.setter
    def method(self, value: Optional[pulumi.Input['ClientCredentialMethod']]):
        pulumi.set(self, "method", value)


@pulumi.input_type
class OpenIdConnectConfigArgs:
    def __init__(__self__, *,
                 authorization_endpoint: Optional[pulumi.Input[str]] = None,
                 certification_uri: Optional[pulumi.Input[str]] = None,
                 issuer: Optional[pulumi.Input[str]] = None,
                 token_endpoint: Optional[pulumi.Input[str]] = None,
                 well_known_open_id_configuration: Optional[pulumi.Input[str]] = None):
        """
        The configuration settings of the endpoints used for the custom Open ID Connect provider.
        :param pulumi.Input[str] authorization_endpoint: The endpoint to be used to make an authorization request.
        :param pulumi.Input[str] certification_uri: The endpoint that provides the keys necessary to validate the token.
        :param pulumi.Input[str] issuer: The endpoint that issues the token.
        :param pulumi.Input[str] token_endpoint: The endpoint to be used to request a token.
        :param pulumi.Input[str] well_known_open_id_configuration: The endpoint that contains all the configuration endpoints for the provider.
        """
        if authorization_endpoint is not None:
            pulumi.set(__self__, "authorization_endpoint", authorization_endpoint)
        if certification_uri is not None:
            pulumi.set(__self__, "certification_uri", certification_uri)
        if issuer is not None:
            pulumi.set(__self__, "issuer", issuer)
        if token_endpoint is not None:
            pulumi.set(__self__, "token_endpoint", token_endpoint)
        if well_known_open_id_configuration is not None:
            pulumi.set(__self__, "well_known_open_id_configuration", well_known_open_id_configuration)

    @property
    @pulumi.getter(name="authorizationEndpoint")
    def authorization_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        The endpoint to be used to make an authorization request.
        """
        return pulumi.get(self, "authorization_endpoint")

    @authorization_endpoint.setter
    def authorization_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authorization_endpoint", value)

    @property
    @pulumi.getter(name="certificationUri")
    def certification_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The endpoint that provides the keys necessary to validate the token.
        """
        return pulumi.get(self, "certification_uri")

    @certification_uri.setter
    def certification_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certification_uri", value)

    @property
    @pulumi.getter
    def issuer(self) -> Optional[pulumi.Input[str]]:
        """
        The endpoint that issues the token.
        """
        return pulumi.get(self, "issuer")

    @issuer.setter
    def issuer(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "issuer", value)

    @property
    @pulumi.getter(name="tokenEndpoint")
    def token_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        The endpoint to be used to request a token.
        """
        return pulumi.get(self, "token_endpoint")

    @token_endpoint.setter
    def token_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "token_endpoint", value)

    @property
    @pulumi.getter(name="wellKnownOpenIdConfiguration")
    def well_known_open_id_configuration(self) -> Optional[pulumi.Input[str]]:
        """
        The endpoint that contains all the configuration endpoints for the provider.
        """
        return pulumi.get(self, "well_known_open_id_configuration")

    @well_known_open_id_configuration.setter
    def well_known_open_id_configuration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "well_known_open_id_configuration", value)


@pulumi.input_type
class OpenIdConnectLoginArgs:
    def __init__(__self__, *,
                 name_claim_type: Optional[pulumi.Input[str]] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The configuration settings of the login flow of the custom Open ID Connect provider.
        :param pulumi.Input[str] name_claim_type: The name of the claim that contains the users name.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] scopes: A list of the scopes that should be requested while authenticating.
        """
        if name_claim_type is not None:
            pulumi.set(__self__, "name_claim_type", name_claim_type)
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)

    @property
    @pulumi.getter(name="nameClaimType")
    def name_claim_type(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the claim that contains the users name.
        """
        return pulumi.get(self, "name_claim_type")

    @name_claim_type.setter
    def name_claim_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name_claim_type", value)

    @property
    @pulumi.getter
    def scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of the scopes that should be requested while authenticating.
        """
        return pulumi.get(self, "scopes")

    @scopes.setter
    def scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "scopes", value)


@pulumi.input_type
class OpenIdConnectRegistrationArgs:
    def __init__(__self__, *,
                 client_credential: Optional[pulumi.Input['OpenIdConnectClientCredentialArgs']] = None,
                 client_id: Optional[pulumi.Input[str]] = None,
                 open_id_connect_configuration: Optional[pulumi.Input['OpenIdConnectConfigArgs']] = None):
        """
        The configuration settings of the app registration for the custom Open ID Connect provider.
        :param pulumi.Input['OpenIdConnectClientCredentialArgs'] client_credential: The authentication credentials of the custom Open ID Connect provider.
        :param pulumi.Input[str] client_id: The client id of the custom Open ID Connect provider.
        :param pulumi.Input['OpenIdConnectConfigArgs'] open_id_connect_configuration: The configuration settings of the endpoints used for the custom Open ID Connect provider.
        """
        if client_credential is not None:
            pulumi.set(__self__, "client_credential", client_credential)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if open_id_connect_configuration is not None:
            pulumi.set(__self__, "open_id_connect_configuration", open_id_connect_configuration)

    @property
    @pulumi.getter(name="clientCredential")
    def client_credential(self) -> Optional[pulumi.Input['OpenIdConnectClientCredentialArgs']]:
        """
        The authentication credentials of the custom Open ID Connect provider.
        """
        return pulumi.get(self, "client_credential")

    @client_credential.setter
    def client_credential(self, value: Optional[pulumi.Input['OpenIdConnectClientCredentialArgs']]):
        pulumi.set(self, "client_credential", value)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[str]]:
        """
        The client id of the custom Open ID Connect provider.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="openIdConnectConfiguration")
    def open_id_connect_configuration(self) -> Optional[pulumi.Input['OpenIdConnectConfigArgs']]:
        """
        The configuration settings of the endpoints used for the custom Open ID Connect provider.
        """
        return pulumi.get(self, "open_id_connect_configuration")

    @open_id_connect_configuration.setter
    def open_id_connect_configuration(self, value: Optional[pulumi.Input['OpenIdConnectConfigArgs']]):
        pulumi.set(self, "open_id_connect_configuration", value)


@pulumi.input_type
class QueueScaleRuleArgs:
    def __init__(__self__, *,
                 auth: Optional[pulumi.Input[Sequence[pulumi.Input['ScaleRuleAuthArgs']]]] = None,
                 queue_length: Optional[pulumi.Input[int]] = None,
                 queue_name: Optional[pulumi.Input[str]] = None):
        """
        Container App container Azure Queue based scaling rule.
        :param pulumi.Input[Sequence[pulumi.Input['ScaleRuleAuthArgs']]] auth: Authentication secrets for the queue scale rule.
        :param pulumi.Input[int] queue_length: Queue length.
        :param pulumi.Input[str] queue_name: Queue name.
        """
        if auth is not None:
            pulumi.set(__self__, "auth", auth)
        if queue_length is not None:
            pulumi.set(__self__, "queue_length", queue_length)
        if queue_name is not None:
            pulumi.set(__self__, "queue_name", queue_name)

    @property
    @pulumi.getter
    def auth(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ScaleRuleAuthArgs']]]]:
        """
        Authentication secrets for the queue scale rule.
        """
        return pulumi.get(self, "auth")

    @auth.setter
    def auth(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ScaleRuleAuthArgs']]]]):
        pulumi.set(self, "auth", value)

    @property
    @pulumi.getter(name="queueLength")
    def queue_length(self) -> Optional[pulumi.Input[int]]:
        """
        Queue length.
        """
        return pulumi.get(self, "queue_length")

    @queue_length.setter
    def queue_length(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "queue_length", value)

    @property
    @pulumi.getter(name="queueName")
    def queue_name(self) -> Optional[pulumi.Input[str]]:
        """
        Queue name.
        """
        return pulumi.get(self, "queue_name")

    @queue_name.setter
    def queue_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "queue_name", value)


@pulumi.input_type
class RegistryCredentialsArgs:
    def __init__(__self__, *,
                 identity: Optional[pulumi.Input[str]] = None,
                 password_secret_ref: Optional[pulumi.Input[str]] = None,
                 server: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None):
        """
        Container App Private Registry
        :param pulumi.Input[str] identity: A Managed Identity to use to authenticate with Azure Container Registry. For user-assigned identities, use the full user-assigned identity Resource ID. For system-assigned identities, use 'system'
        :param pulumi.Input[str] password_secret_ref: The name of the Secret that contains the registry login password
        :param pulumi.Input[str] server: Container Registry Server
        :param pulumi.Input[str] username: Container Registry Username
        """
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if password_secret_ref is not None:
            pulumi.set(__self__, "password_secret_ref", password_secret_ref)
        if server is not None:
            pulumi.set(__self__, "server", server)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input[str]]:
        """
        A Managed Identity to use to authenticate with Azure Container Registry. For user-assigned identities, use the full user-assigned identity Resource ID. For system-assigned identities, use 'system'
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "identity", value)

    @property
    @pulumi.getter(name="passwordSecretRef")
    def password_secret_ref(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Secret that contains the registry login password
        """
        return pulumi.get(self, "password_secret_ref")

    @password_secret_ref.setter
    def password_secret_ref(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password_secret_ref", value)

    @property
    @pulumi.getter
    def server(self) -> Optional[pulumi.Input[str]]:
        """
        Container Registry Server
        """
        return pulumi.get(self, "server")

    @server.setter
    def server(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        Container Registry Username
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class RegistryInfoArgs:
    def __init__(__self__, *,
                 registry_password: Optional[pulumi.Input[str]] = None,
                 registry_url: Optional[pulumi.Input[str]] = None,
                 registry_user_name: Optional[pulumi.Input[str]] = None):
        """
        Container App registry information.
        :param pulumi.Input[str] registry_password: registry secret.
        :param pulumi.Input[str] registry_url: registry server Url.
        :param pulumi.Input[str] registry_user_name: registry username.
        """
        if registry_password is not None:
            pulumi.set(__self__, "registry_password", registry_password)
        if registry_url is not None:
            pulumi.set(__self__, "registry_url", registry_url)
        if registry_user_name is not None:
            pulumi.set(__self__, "registry_user_name", registry_user_name)

    @property
    @pulumi.getter(name="registryPassword")
    def registry_password(self) -> Optional[pulumi.Input[str]]:
        """
        registry secret.
        """
        return pulumi.get(self, "registry_password")

    @registry_password.setter
    def registry_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "registry_password", value)

    @property
    @pulumi.getter(name="registryUrl")
    def registry_url(self) -> Optional[pulumi.Input[str]]:
        """
        registry server Url.
        """
        return pulumi.get(self, "registry_url")

    @registry_url.setter
    def registry_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "registry_url", value)

    @property
    @pulumi.getter(name="registryUserName")
    def registry_user_name(self) -> Optional[pulumi.Input[str]]:
        """
        registry username.
        """
        return pulumi.get(self, "registry_user_name")

    @registry_user_name.setter
    def registry_user_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "registry_user_name", value)


@pulumi.input_type
class ScaleRuleAuthArgs:
    def __init__(__self__, *,
                 secret_ref: Optional[pulumi.Input[str]] = None,
                 trigger_parameter: Optional[pulumi.Input[str]] = None):
        """
        Auth Secrets for Container App Scale Rule
        :param pulumi.Input[str] secret_ref: Name of the Container App secret from which to pull the auth params.
        :param pulumi.Input[str] trigger_parameter: Trigger Parameter that uses the secret
        """
        if secret_ref is not None:
            pulumi.set(__self__, "secret_ref", secret_ref)
        if trigger_parameter is not None:
            pulumi.set(__self__, "trigger_parameter", trigger_parameter)

    @property
    @pulumi.getter(name="secretRef")
    def secret_ref(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the Container App secret from which to pull the auth params.
        """
        return pulumi.get(self, "secret_ref")

    @secret_ref.setter
    def secret_ref(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret_ref", value)

    @property
    @pulumi.getter(name="triggerParameter")
    def trigger_parameter(self) -> Optional[pulumi.Input[str]]:
        """
        Trigger Parameter that uses the secret
        """
        return pulumi.get(self, "trigger_parameter")

    @trigger_parameter.setter
    def trigger_parameter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "trigger_parameter", value)


@pulumi.input_type
class ScaleRuleArgs:
    def __init__(__self__, *,
                 azure_queue: Optional[pulumi.Input['QueueScaleRuleArgs']] = None,
                 custom: Optional[pulumi.Input['CustomScaleRuleArgs']] = None,
                 http: Optional[pulumi.Input['HttpScaleRuleArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tcp: Optional[pulumi.Input['TcpScaleRuleArgs']] = None):
        """
        Container App container scaling rule.
        :param pulumi.Input['QueueScaleRuleArgs'] azure_queue: Azure Queue based scaling.
        :param pulumi.Input['CustomScaleRuleArgs'] custom: Custom scale rule.
        :param pulumi.Input['HttpScaleRuleArgs'] http: HTTP requests based scaling.
        :param pulumi.Input[str] name: Scale Rule Name
        :param pulumi.Input['TcpScaleRuleArgs'] tcp: Tcp requests based scaling.
        """
        if azure_queue is not None:
            pulumi.set(__self__, "azure_queue", azure_queue)
        if custom is not None:
            pulumi.set(__self__, "custom", custom)
        if http is not None:
            pulumi.set(__self__, "http", http)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tcp is not None:
            pulumi.set(__self__, "tcp", tcp)

    @property
    @pulumi.getter(name="azureQueue")
    def azure_queue(self) -> Optional[pulumi.Input['QueueScaleRuleArgs']]:
        """
        Azure Queue based scaling.
        """
        return pulumi.get(self, "azure_queue")

    @azure_queue.setter
    def azure_queue(self, value: Optional[pulumi.Input['QueueScaleRuleArgs']]):
        pulumi.set(self, "azure_queue", value)

    @property
    @pulumi.getter
    def custom(self) -> Optional[pulumi.Input['CustomScaleRuleArgs']]:
        """
        Custom scale rule.
        """
        return pulumi.get(self, "custom")

    @custom.setter
    def custom(self, value: Optional[pulumi.Input['CustomScaleRuleArgs']]):
        pulumi.set(self, "custom", value)

    @property
    @pulumi.getter
    def http(self) -> Optional[pulumi.Input['HttpScaleRuleArgs']]:
        """
        HTTP requests based scaling.
        """
        return pulumi.get(self, "http")

    @http.setter
    def http(self, value: Optional[pulumi.Input['HttpScaleRuleArgs']]):
        pulumi.set(self, "http", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Scale Rule Name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tcp(self) -> Optional[pulumi.Input['TcpScaleRuleArgs']]:
        """
        Tcp requests based scaling.
        """
        return pulumi.get(self, "tcp")

    @tcp.setter
    def tcp(self, value: Optional[pulumi.Input['TcpScaleRuleArgs']]):
        pulumi.set(self, "tcp", value)


@pulumi.input_type
class ScaleArgs:
    def __init__(__self__, *,
                 max_replicas: Optional[pulumi.Input[int]] = None,
                 min_replicas: Optional[pulumi.Input[int]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['ScaleRuleArgs']]]] = None):
        """
        Container App scaling configurations.
        :param pulumi.Input[int] max_replicas: Optional. Maximum number of container replicas. Defaults to 10 if not set.
        :param pulumi.Input[int] min_replicas: Optional. Minimum number of container replicas.
        :param pulumi.Input[Sequence[pulumi.Input['ScaleRuleArgs']]] rules: Scaling rules.
        """
        if max_replicas is None:
            max_replicas = 10
        if max_replicas is not None:
            pulumi.set(__self__, "max_replicas", max_replicas)
        if min_replicas is not None:
            pulumi.set(__self__, "min_replicas", min_replicas)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter(name="maxReplicas")
    def max_replicas(self) -> Optional[pulumi.Input[int]]:
        """
        Optional. Maximum number of container replicas. Defaults to 10 if not set.
        """
        return pulumi.get(self, "max_replicas")

    @max_replicas.setter
    def max_replicas(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_replicas", value)

    @property
    @pulumi.getter(name="minReplicas")
    def min_replicas(self) -> Optional[pulumi.Input[int]]:
        """
        Optional. Minimum number of container replicas.
        """
        return pulumi.get(self, "min_replicas")

    @min_replicas.setter
    def min_replicas(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_replicas", value)

    @property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ScaleRuleArgs']]]]:
        """
        Scaling rules.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ScaleRuleArgs']]]]):
        pulumi.set(self, "rules", value)


@pulumi.input_type
class SecretArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        Secret definition.
        :param pulumi.Input[str] name: Secret Name.
        :param pulumi.Input[str] value: Secret Value.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Secret Name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        Secret Value.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class TcpScaleRuleArgs:
    def __init__(__self__, *,
                 auth: Optional[pulumi.Input[Sequence[pulumi.Input['ScaleRuleAuthArgs']]]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Container App container Tcp scaling rule.
        :param pulumi.Input[Sequence[pulumi.Input['ScaleRuleAuthArgs']]] auth: Authentication secrets for the tcp scale rule.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] metadata: Metadata properties to describe tcp scale rule.
        """
        if auth is not None:
            pulumi.set(__self__, "auth", auth)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)

    @property
    @pulumi.getter
    def auth(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ScaleRuleAuthArgs']]]]:
        """
        Authentication secrets for the tcp scale rule.
        """
        return pulumi.get(self, "auth")

    @auth.setter
    def auth(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ScaleRuleAuthArgs']]]]):
        pulumi.set(self, "auth", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Metadata properties to describe tcp scale rule.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "metadata", value)


@pulumi.input_type
class TemplateArgs:
    def __init__(__self__, *,
                 containers: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerArgs']]]] = None,
                 init_containers: Optional[pulumi.Input[Sequence[pulumi.Input['InitContainerArgs']]]] = None,
                 revision_suffix: Optional[pulumi.Input[str]] = None,
                 scale: Optional[pulumi.Input['ScaleArgs']] = None,
                 volumes: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeArgs']]]] = None):
        """
        Container App versioned application definition.
        Defines the desired state of an immutable revision.
        Any changes to this section Will result in a new revision being created
        :param pulumi.Input[Sequence[pulumi.Input['ContainerArgs']]] containers: List of container definitions for the Container App.
        :param pulumi.Input[Sequence[pulumi.Input['InitContainerArgs']]] init_containers: List of specialized containers that run before app containers.
        :param pulumi.Input[str] revision_suffix: User friendly suffix that is appended to the revision name
        :param pulumi.Input['ScaleArgs'] scale: Scaling properties for the Container App.
        :param pulumi.Input[Sequence[pulumi.Input['VolumeArgs']]] volumes: List of volume definitions for the Container App.
        """
        if containers is not None:
            pulumi.set(__self__, "containers", containers)
        if init_containers is not None:
            pulumi.set(__self__, "init_containers", init_containers)
        if revision_suffix is not None:
            pulumi.set(__self__, "revision_suffix", revision_suffix)
        if scale is not None:
            pulumi.set(__self__, "scale", scale)
        if volumes is not None:
            pulumi.set(__self__, "volumes", volumes)

    @property
    @pulumi.getter
    def containers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerArgs']]]]:
        """
        List of container definitions for the Container App.
        """
        return pulumi.get(self, "containers")

    @containers.setter
    def containers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerArgs']]]]):
        pulumi.set(self, "containers", value)

    @property
    @pulumi.getter(name="initContainers")
    def init_containers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InitContainerArgs']]]]:
        """
        List of specialized containers that run before app containers.
        """
        return pulumi.get(self, "init_containers")

    @init_containers.setter
    def init_containers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InitContainerArgs']]]]):
        pulumi.set(self, "init_containers", value)

    @property
    @pulumi.getter(name="revisionSuffix")
    def revision_suffix(self) -> Optional[pulumi.Input[str]]:
        """
        User friendly suffix that is appended to the revision name
        """
        return pulumi.get(self, "revision_suffix")

    @revision_suffix.setter
    def revision_suffix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "revision_suffix", value)

    @property
    @pulumi.getter
    def scale(self) -> Optional[pulumi.Input['ScaleArgs']]:
        """
        Scaling properties for the Container App.
        """
        return pulumi.get(self, "scale")

    @scale.setter
    def scale(self, value: Optional[pulumi.Input['ScaleArgs']]):
        pulumi.set(self, "scale", value)

    @property
    @pulumi.getter
    def volumes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VolumeArgs']]]]:
        """
        List of volume definitions for the Container App.
        """
        return pulumi.get(self, "volumes")

    @volumes.setter
    def volumes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeArgs']]]]):
        pulumi.set(self, "volumes", value)


@pulumi.input_type
class TrafficWeightArgs:
    def __init__(__self__, *,
                 label: Optional[pulumi.Input[str]] = None,
                 latest_revision: Optional[pulumi.Input[bool]] = None,
                 revision_name: Optional[pulumi.Input[str]] = None,
                 weight: Optional[pulumi.Input[int]] = None):
        """
        Traffic weight assigned to a revision
        :param pulumi.Input[str] label: Associates a traffic label with a revision
        :param pulumi.Input[bool] latest_revision: Indicates that the traffic weight belongs to a latest stable revision
        :param pulumi.Input[str] revision_name: Name of a revision
        :param pulumi.Input[int] weight: Traffic weight assigned to a revision
        """
        if label is not None:
            pulumi.set(__self__, "label", label)
        if latest_revision is None:
            latest_revision = False
        if latest_revision is not None:
            pulumi.set(__self__, "latest_revision", latest_revision)
        if revision_name is not None:
            pulumi.set(__self__, "revision_name", revision_name)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[str]]:
        """
        Associates a traffic label with a revision
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter(name="latestRevision")
    def latest_revision(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates that the traffic weight belongs to a latest stable revision
        """
        return pulumi.get(self, "latest_revision")

    @latest_revision.setter
    def latest_revision(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "latest_revision", value)

    @property
    @pulumi.getter(name="revisionName")
    def revision_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of a revision
        """
        return pulumi.get(self, "revision_name")

    @revision_name.setter
    def revision_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "revision_name", value)

    @property
    @pulumi.getter
    def weight(self) -> Optional[pulumi.Input[int]]:
        """
        Traffic weight assigned to a revision
        """
        return pulumi.get(self, "weight")

    @weight.setter
    def weight(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "weight", value)


@pulumi.input_type
class TwitterRegistrationArgs:
    def __init__(__self__, *,
                 consumer_key: Optional[pulumi.Input[str]] = None,
                 consumer_secret_setting_name: Optional[pulumi.Input[str]] = None):
        """
        The configuration settings of the app registration for the Twitter provider.
        :param pulumi.Input[str] consumer_key: The OAuth 1.0a consumer key of the Twitter application used for sign-in.
               This setting is required for enabling Twitter Sign-In.
               Twitter Sign-In documentation: https://dev.twitter.com/web/sign-in
        :param pulumi.Input[str] consumer_secret_setting_name: The app setting name that contains the OAuth 1.0a consumer secret of the Twitter
               application used for sign-in.
        """
        if consumer_key is not None:
            pulumi.set(__self__, "consumer_key", consumer_key)
        if consumer_secret_setting_name is not None:
            pulumi.set(__self__, "consumer_secret_setting_name", consumer_secret_setting_name)

    @property
    @pulumi.getter(name="consumerKey")
    def consumer_key(self) -> Optional[pulumi.Input[str]]:
        """
        The OAuth 1.0a consumer key of the Twitter application used for sign-in.
        This setting is required for enabling Twitter Sign-In.
        Twitter Sign-In documentation: https://dev.twitter.com/web/sign-in
        """
        return pulumi.get(self, "consumer_key")

    @consumer_key.setter
    def consumer_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "consumer_key", value)

    @property
    @pulumi.getter(name="consumerSecretSettingName")
    def consumer_secret_setting_name(self) -> Optional[pulumi.Input[str]]:
        """
        The app setting name that contains the OAuth 1.0a consumer secret of the Twitter
        application used for sign-in.
        """
        return pulumi.get(self, "consumer_secret_setting_name")

    @consumer_secret_setting_name.setter
    def consumer_secret_setting_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "consumer_secret_setting_name", value)


@pulumi.input_type
class TwitterArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 registration: Optional[pulumi.Input['TwitterRegistrationArgs']] = None):
        """
        The configuration settings of the Twitter provider.
        :param pulumi.Input[bool] enabled: <code>false</code> if the Twitter provider should not be enabled despite the set registration; otherwise, <code>true</code>.
        :param pulumi.Input['TwitterRegistrationArgs'] registration: The configuration settings of the app registration for the Twitter provider.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if registration is not None:
            pulumi.set(__self__, "registration", registration)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        <code>false</code> if the Twitter provider should not be enabled despite the set registration; otherwise, <code>true</code>.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def registration(self) -> Optional[pulumi.Input['TwitterRegistrationArgs']]:
        """
        The configuration settings of the app registration for the Twitter provider.
        """
        return pulumi.get(self, "registration")

    @registration.setter
    def registration(self, value: Optional[pulumi.Input['TwitterRegistrationArgs']]):
        pulumi.set(self, "registration", value)


@pulumi.input_type
class VnetConfigurationArgs:
    def __init__(__self__, *,
                 docker_bridge_cidr: Optional[pulumi.Input[str]] = None,
                 infrastructure_subnet_id: Optional[pulumi.Input[str]] = None,
                 internal: Optional[pulumi.Input[bool]] = None,
                 outbound_settings: Optional[pulumi.Input['ManagedEnvironmentOutboundSettingsArgs']] = None,
                 platform_reserved_cidr: Optional[pulumi.Input[str]] = None,
                 platform_reserved_dns_ip: Optional[pulumi.Input[str]] = None,
                 runtime_subnet_id: Optional[pulumi.Input[str]] = None):
        """
        Configuration properties for apps environment to join a Virtual Network
        :param pulumi.Input[str] docker_bridge_cidr: CIDR notation IP range assigned to the Docker bridge, network. Must not overlap with any other provided IP ranges.
        :param pulumi.Input[str] infrastructure_subnet_id: Resource ID of a subnet for infrastructure components. This subnet must be in the same VNET as the subnet defined in runtimeSubnetId. Must not overlap with any other provided IP ranges.
        :param pulumi.Input[bool] internal: Boolean indicating the environment only has an internal load balancer. These environments do not have a public static IP resource. They must provide runtimeSubnetId and infrastructureSubnetId if enabling this property
        :param pulumi.Input['ManagedEnvironmentOutboundSettingsArgs'] outbound_settings: Configuration used to control the Environment Egress outbound traffic
        :param pulumi.Input[str] platform_reserved_cidr: IP range in CIDR notation that can be reserved for environment infrastructure IP addresses. Must not overlap with any other provided IP ranges.
        :param pulumi.Input[str] platform_reserved_dns_ip:  An IP address from the IP range defined by platformReservedCidr that will be reserved for the internal DNS server.
        :param pulumi.Input[str] runtime_subnet_id: This field is deprecated and not used. If you wish to provide your own subnet that Container App containers are injected into, then you should leverage the infrastructureSubnetId.
        """
        if docker_bridge_cidr is not None:
            pulumi.set(__self__, "docker_bridge_cidr", docker_bridge_cidr)
        if infrastructure_subnet_id is not None:
            pulumi.set(__self__, "infrastructure_subnet_id", infrastructure_subnet_id)
        if internal is not None:
            pulumi.set(__self__, "internal", internal)
        if outbound_settings is not None:
            pulumi.set(__self__, "outbound_settings", outbound_settings)
        if platform_reserved_cidr is not None:
            pulumi.set(__self__, "platform_reserved_cidr", platform_reserved_cidr)
        if platform_reserved_dns_ip is not None:
            pulumi.set(__self__, "platform_reserved_dns_ip", platform_reserved_dns_ip)
        if runtime_subnet_id is not None:
            pulumi.set(__self__, "runtime_subnet_id", runtime_subnet_id)

    @property
    @pulumi.getter(name="dockerBridgeCidr")
    def docker_bridge_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        CIDR notation IP range assigned to the Docker bridge, network. Must not overlap with any other provided IP ranges.
        """
        return pulumi.get(self, "docker_bridge_cidr")

    @docker_bridge_cidr.setter
    def docker_bridge_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "docker_bridge_cidr", value)

    @property
    @pulumi.getter(name="infrastructureSubnetId")
    def infrastructure_subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ID of a subnet for infrastructure components. This subnet must be in the same VNET as the subnet defined in runtimeSubnetId. Must not overlap with any other provided IP ranges.
        """
        return pulumi.get(self, "infrastructure_subnet_id")

    @infrastructure_subnet_id.setter
    def infrastructure_subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "infrastructure_subnet_id", value)

    @property
    @pulumi.getter
    def internal(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean indicating the environment only has an internal load balancer. These environments do not have a public static IP resource. They must provide runtimeSubnetId and infrastructureSubnetId if enabling this property
        """
        return pulumi.get(self, "internal")

    @internal.setter
    def internal(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "internal", value)

    @property
    @pulumi.getter(name="outboundSettings")
    def outbound_settings(self) -> Optional[pulumi.Input['ManagedEnvironmentOutboundSettingsArgs']]:
        """
        Configuration used to control the Environment Egress outbound traffic
        """
        return pulumi.get(self, "outbound_settings")

    @outbound_settings.setter
    def outbound_settings(self, value: Optional[pulumi.Input['ManagedEnvironmentOutboundSettingsArgs']]):
        pulumi.set(self, "outbound_settings", value)

    @property
    @pulumi.getter(name="platformReservedCidr")
    def platform_reserved_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        IP range in CIDR notation that can be reserved for environment infrastructure IP addresses. Must not overlap with any other provided IP ranges.
        """
        return pulumi.get(self, "platform_reserved_cidr")

    @platform_reserved_cidr.setter
    def platform_reserved_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "platform_reserved_cidr", value)

    @property
    @pulumi.getter(name="platformReservedDnsIP")
    def platform_reserved_dns_ip(self) -> Optional[pulumi.Input[str]]:
        """
         An IP address from the IP range defined by platformReservedCidr that will be reserved for the internal DNS server.
        """
        return pulumi.get(self, "platform_reserved_dns_ip")

    @platform_reserved_dns_ip.setter
    def platform_reserved_dns_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "platform_reserved_dns_ip", value)

    @property
    @pulumi.getter(name="runtimeSubnetId")
    def runtime_subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        This field is deprecated and not used. If you wish to provide your own subnet that Container App containers are injected into, then you should leverage the infrastructureSubnetId.
        """
        return pulumi.get(self, "runtime_subnet_id")

    @runtime_subnet_id.setter
    def runtime_subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "runtime_subnet_id", value)


@pulumi.input_type
class VolumeMountArgs:
    def __init__(__self__, *,
                 mount_path: Optional[pulumi.Input[str]] = None,
                 volume_name: Optional[pulumi.Input[str]] = None):
        """
        Volume mount for the Container App.
        :param pulumi.Input[str] mount_path: Path within the container at which the volume should be mounted.Must not contain ':'.
        :param pulumi.Input[str] volume_name: This must match the Name of a Volume.
        """
        if mount_path is not None:
            pulumi.set(__self__, "mount_path", mount_path)
        if volume_name is not None:
            pulumi.set(__self__, "volume_name", volume_name)

    @property
    @pulumi.getter(name="mountPath")
    def mount_path(self) -> Optional[pulumi.Input[str]]:
        """
        Path within the container at which the volume should be mounted.Must not contain ':'.
        """
        return pulumi.get(self, "mount_path")

    @mount_path.setter
    def mount_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mount_path", value)

    @property
    @pulumi.getter(name="volumeName")
    def volume_name(self) -> Optional[pulumi.Input[str]]:
        """
        This must match the Name of a Volume.
        """
        return pulumi.get(self, "volume_name")

    @volume_name.setter
    def volume_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "volume_name", value)


@pulumi.input_type
class VolumeArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 storage_name: Optional[pulumi.Input[str]] = None,
                 storage_type: Optional[pulumi.Input[Union[str, 'StorageType']]] = None):
        """
        Volume definitions for the Container App.
        :param pulumi.Input[str] name: Volume name.
        :param pulumi.Input[str] storage_name: Name of storage resource. No need to provide for EmptyDir.
        :param pulumi.Input[Union[str, 'StorageType']] storage_type: Storage type for the volume. If not provided, use EmptyDir.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if storage_name is not None:
            pulumi.set(__self__, "storage_name", storage_name)
        if storage_type is not None:
            pulumi.set(__self__, "storage_type", storage_type)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Volume name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="storageName")
    def storage_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of storage resource. No need to provide for EmptyDir.
        """
        return pulumi.get(self, "storage_name")

    @storage_name.setter
    def storage_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_name", value)

    @property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> Optional[pulumi.Input[Union[str, 'StorageType']]]:
        """
        Storage type for the volume. If not provided, use EmptyDir.
        """
        return pulumi.get(self, "storage_type")

    @storage_type.setter
    def storage_type(self, value: Optional[pulumi.Input[Union[str, 'StorageType']]]):
        pulumi.set(self, "storage_type", value)


@pulumi.input_type
class WorkloadProfileArgs:
    def __init__(__self__, *,
                 maximum_count: pulumi.Input[int],
                 minimum_count: pulumi.Input[int],
                 workload_profile_type: pulumi.Input[str]):
        """
        Workload profile to scope container app execution.
        :param pulumi.Input[int] maximum_count: The maximum capacity.
        :param pulumi.Input[int] minimum_count: The minimum capacity.
        :param pulumi.Input[str] workload_profile_type: Workload profile type for the workloads to run on.
        """
        pulumi.set(__self__, "maximum_count", maximum_count)
        pulumi.set(__self__, "minimum_count", minimum_count)
        pulumi.set(__self__, "workload_profile_type", workload_profile_type)

    @property
    @pulumi.getter(name="maximumCount")
    def maximum_count(self) -> pulumi.Input[int]:
        """
        The maximum capacity.
        """
        return pulumi.get(self, "maximum_count")

    @maximum_count.setter
    def maximum_count(self, value: pulumi.Input[int]):
        pulumi.set(self, "maximum_count", value)

    @property
    @pulumi.getter(name="minimumCount")
    def minimum_count(self) -> pulumi.Input[int]:
        """
        The minimum capacity.
        """
        return pulumi.get(self, "minimum_count")

    @minimum_count.setter
    def minimum_count(self, value: pulumi.Input[int]):
        pulumi.set(self, "minimum_count", value)

    @property
    @pulumi.getter(name="workloadProfileType")
    def workload_profile_type(self) -> pulumi.Input[str]:
        """
        Workload profile type for the workloads to run on.
        """
        return pulumi.get(self, "workload_profile_type")

    @workload_profile_type.setter
    def workload_profile_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "workload_profile_type", value)


