# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities

__all__ = [
    'PrometheusRuleGroupActionArgs',
    'PrometheusRuleResolveConfigurationArgs',
    'PrometheusRuleArgs',
]

@pulumi.input_type
class PrometheusRuleGroupActionArgs:
    def __init__(__self__, *,
                 action_group_id: Optional[pulumi.Input[str]] = None,
                 action_properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        An alert action. Only relevant for alerts.
        :param pulumi.Input[str] action_group_id: The resource id of the action group to use.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] action_properties: The properties of an action group object.
        """
        if action_group_id is not None:
            pulumi.set(__self__, "action_group_id", action_group_id)
        if action_properties is not None:
            pulumi.set(__self__, "action_properties", action_properties)

    @property
    @pulumi.getter(name="actionGroupId")
    def action_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The resource id of the action group to use.
        """
        return pulumi.get(self, "action_group_id")

    @action_group_id.setter
    def action_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "action_group_id", value)

    @property
    @pulumi.getter(name="actionProperties")
    def action_properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The properties of an action group object.
        """
        return pulumi.get(self, "action_properties")

    @action_properties.setter
    def action_properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "action_properties", value)


@pulumi.input_type
class PrometheusRuleResolveConfigurationArgs:
    def __init__(__self__, *,
                 auto_resolved: Optional[pulumi.Input[bool]] = None,
                 time_to_resolve: Optional[pulumi.Input[str]] = None):
        """
        Specifies the Prometheus alert rule configuration.
        :param pulumi.Input[bool] auto_resolved: Enable alert auto-resolution.
        :param pulumi.Input[str] time_to_resolve: Alert auto-resolution timeout.
        """
        if auto_resolved is not None:
            pulumi.set(__self__, "auto_resolved", auto_resolved)
        if time_to_resolve is not None:
            pulumi.set(__self__, "time_to_resolve", time_to_resolve)

    @property
    @pulumi.getter(name="autoResolved")
    def auto_resolved(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable alert auto-resolution.
        """
        return pulumi.get(self, "auto_resolved")

    @auto_resolved.setter
    def auto_resolved(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_resolved", value)

    @property
    @pulumi.getter(name="timeToResolve")
    def time_to_resolve(self) -> Optional[pulumi.Input[str]]:
        """
        Alert auto-resolution timeout.
        """
        return pulumi.get(self, "time_to_resolve")

    @time_to_resolve.setter
    def time_to_resolve(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_to_resolve", value)


@pulumi.input_type
class PrometheusRuleArgs:
    def __init__(__self__, *,
                 expression: pulumi.Input[str],
                 actions: Optional[pulumi.Input[Sequence[pulumi.Input['PrometheusRuleGroupActionArgs']]]] = None,
                 alert: Optional[pulumi.Input[str]] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 for_: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 record: Optional[pulumi.Input[str]] = None,
                 resolve_configuration: Optional[pulumi.Input['PrometheusRuleResolveConfigurationArgs']] = None,
                 severity: Optional[pulumi.Input[int]] = None):
        """
        An Azure Prometheus alerting or recording rule.
        :param pulumi.Input[str] expression: The PromQL expression to evaluate. https://prometheus.io/docs/prometheus/latest/querying/basics/. Evaluated periodically as given by 'interval', and the result recorded as a new set of time series with the metric name as given by 'record'.
        :param pulumi.Input[Sequence[pulumi.Input['PrometheusRuleGroupActionArgs']]] actions: Actions that are performed when the alert rule becomes active, and when an alert condition is resolved.
        :param pulumi.Input[str] alert: Alert rule name.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] annotations: The annotations clause specifies a set of informational labels that can be used to store longer additional information such as alert descriptions or runbook links. The annotation values can be templated.
        :param pulumi.Input[bool] enabled: Enable/disable rule.
        :param pulumi.Input[str] for_: The amount of time alert must be active before firing.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels to add or overwrite before storing the result.
        :param pulumi.Input[str] record: Recorded metrics name.
        :param pulumi.Input['PrometheusRuleResolveConfigurationArgs'] resolve_configuration: Defines the configuration for resolving fired alerts. Only relevant for alerts.
        :param pulumi.Input[int] severity: The severity of the alerts fired by the rule. Must be between 0 and 4.
        """
        pulumi.set(__self__, "expression", expression)
        if actions is not None:
            pulumi.set(__self__, "actions", actions)
        if alert is not None:
            pulumi.set(__self__, "alert", alert)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if for_ is not None:
            pulumi.set(__self__, "for_", for_)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if record is not None:
            pulumi.set(__self__, "record", record)
        if resolve_configuration is not None:
            pulumi.set(__self__, "resolve_configuration", resolve_configuration)
        if severity is not None:
            pulumi.set(__self__, "severity", severity)

    @property
    @pulumi.getter
    def expression(self) -> pulumi.Input[str]:
        """
        The PromQL expression to evaluate. https://prometheus.io/docs/prometheus/latest/querying/basics/. Evaluated periodically as given by 'interval', and the result recorded as a new set of time series with the metric name as given by 'record'.
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: pulumi.Input[str]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter
    def actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PrometheusRuleGroupActionArgs']]]]:
        """
        Actions that are performed when the alert rule becomes active, and when an alert condition is resolved.
        """
        return pulumi.get(self, "actions")

    @actions.setter
    def actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PrometheusRuleGroupActionArgs']]]]):
        pulumi.set(self, "actions", value)

    @property
    @pulumi.getter
    def alert(self) -> Optional[pulumi.Input[str]]:
        """
        Alert rule name.
        """
        return pulumi.get(self, "alert")

    @alert.setter
    def alert(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "alert", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The annotations clause specifies a set of informational labels that can be used to store longer additional information such as alert descriptions or runbook links. The annotation values can be templated.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable/disable rule.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="for")
    def for_(self) -> Optional[pulumi.Input[str]]:
        """
        The amount of time alert must be active before firing.
        """
        return pulumi.get(self, "for_")

    @for_.setter
    def for_(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "for_", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Labels to add or overwrite before storing the result.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def record(self) -> Optional[pulumi.Input[str]]:
        """
        Recorded metrics name.
        """
        return pulumi.get(self, "record")

    @record.setter
    def record(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "record", value)

    @property
    @pulumi.getter(name="resolveConfiguration")
    def resolve_configuration(self) -> Optional[pulumi.Input['PrometheusRuleResolveConfigurationArgs']]:
        """
        Defines the configuration for resolving fired alerts. Only relevant for alerts.
        """
        return pulumi.get(self, "resolve_configuration")

    @resolve_configuration.setter
    def resolve_configuration(self, value: Optional[pulumi.Input['PrometheusRuleResolveConfigurationArgs']]):
        pulumi.set(self, "resolve_configuration", value)

    @property
    @pulumi.getter
    def severity(self) -> Optional[pulumi.Input[int]]:
        """
        The severity of the alerts fired by the rule. Must be between 0 and 4.
        """
        return pulumi.get(self, "severity")

    @severity.setter
    def severity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "severity", value)


