# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'ArmRoleReceiverArgs',
    'AutomationRunbookReceiverArgs',
    'AzureAppPushReceiverArgs',
    'AzureFunctionReceiverArgs',
    'ColumnDefinitionArgs',
    'DataCollectionEndpointNetworkAclsArgs',
    'DataCollectionEndpointResourceIdentityArgs',
    'DataCollectionRuleDataSourcesArgs',
    'DataCollectionRuleDestinationsArgs',
    'DataCollectionRuleResourceIdentityArgs',
    'DataFlowArgs',
    'DataImportSourcesEventHubArgs',
    'DataSourcesSpecDataImportsArgs',
    'DestinationsSpecAzureMonitorMetricsArgs',
    'EmailReceiverArgs',
    'EventHubDestinationArgs',
    'EventHubDirectDestinationArgs',
    'EventHubReceiverArgs',
    'ExtensionDataSourceArgs',
    'IisLogsDataSourceArgs',
    'ItsmReceiverArgs',
    'LogAnalyticsDestinationArgs',
    'LogFileSettingsTextArgs',
    'LogFilesDataSourceSettingsArgs',
    'LogFilesDataSourceArgs',
    'LogicAppReceiverArgs',
    'MonitoringAccountDestinationArgs',
    'PerfCounterDataSourceArgs',
    'PlatformTelemetryDataSourceArgs',
    'PrometheusForwarderDataSourceArgs',
    'SmsReceiverArgs',
    'StorageBlobDestinationArgs',
    'StorageTableDestinationArgs',
    'StreamDeclarationArgs',
    'SyslogDataSourceArgs',
    'VoiceReceiverArgs',
    'WebhookReceiverArgs',
    'WindowsEventLogDataSourceArgs',
    'WindowsFirewallLogsDataSourceArgs',
]

@pulumi.input_type
class ArmRoleReceiverArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 role_id: pulumi.Input[str],
                 use_common_alert_schema: Optional[pulumi.Input[bool]] = None):
        """
        An arm role receiver.
        :param pulumi.Input[str] name: The name of the arm role receiver. Names must be unique across all receivers within an action group.
        :param pulumi.Input[str] role_id: The arm role id.
        :param pulumi.Input[bool] use_common_alert_schema: Indicates whether to use common alert schema.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "role_id", role_id)
        if use_common_alert_schema is None:
            use_common_alert_schema = False
        if use_common_alert_schema is not None:
            pulumi.set(__self__, "use_common_alert_schema", use_common_alert_schema)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the arm role receiver. Names must be unique across all receivers within an action group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="roleId")
    def role_id(self) -> pulumi.Input[str]:
        """
        The arm role id.
        """
        return pulumi.get(self, "role_id")

    @role_id.setter
    def role_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "role_id", value)

    @property
    @pulumi.getter(name="useCommonAlertSchema")
    def use_common_alert_schema(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether to use common alert schema.
        """
        return pulumi.get(self, "use_common_alert_schema")

    @use_common_alert_schema.setter
    def use_common_alert_schema(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_common_alert_schema", value)


@pulumi.input_type
class AutomationRunbookReceiverArgs:
    def __init__(__self__, *,
                 automation_account_id: pulumi.Input[str],
                 is_global_runbook: pulumi.Input[bool],
                 runbook_name: pulumi.Input[str],
                 webhook_resource_id: pulumi.Input[str],
                 name: Optional[pulumi.Input[str]] = None,
                 service_uri: Optional[pulumi.Input[str]] = None,
                 use_common_alert_schema: Optional[pulumi.Input[bool]] = None):
        """
        The Azure Automation Runbook notification receiver.
        :param pulumi.Input[str] automation_account_id: The Azure automation account Id which holds this runbook and authenticate to Azure resource.
        :param pulumi.Input[bool] is_global_runbook: Indicates whether this instance is global runbook.
        :param pulumi.Input[str] runbook_name: The name for this runbook.
        :param pulumi.Input[str] webhook_resource_id: The resource id for webhook linked to this runbook.
        :param pulumi.Input[str] name: Indicates name of the webhook.
        :param pulumi.Input[str] service_uri: The URI where webhooks should be sent.
        :param pulumi.Input[bool] use_common_alert_schema: Indicates whether to use common alert schema.
        """
        pulumi.set(__self__, "automation_account_id", automation_account_id)
        pulumi.set(__self__, "is_global_runbook", is_global_runbook)
        pulumi.set(__self__, "runbook_name", runbook_name)
        pulumi.set(__self__, "webhook_resource_id", webhook_resource_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if service_uri is not None:
            pulumi.set(__self__, "service_uri", service_uri)
        if use_common_alert_schema is None:
            use_common_alert_schema = False
        if use_common_alert_schema is not None:
            pulumi.set(__self__, "use_common_alert_schema", use_common_alert_schema)

    @property
    @pulumi.getter(name="automationAccountId")
    def automation_account_id(self) -> pulumi.Input[str]:
        """
        The Azure automation account Id which holds this runbook and authenticate to Azure resource.
        """
        return pulumi.get(self, "automation_account_id")

    @automation_account_id.setter
    def automation_account_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "automation_account_id", value)

    @property
    @pulumi.getter(name="isGlobalRunbook")
    def is_global_runbook(self) -> pulumi.Input[bool]:
        """
        Indicates whether this instance is global runbook.
        """
        return pulumi.get(self, "is_global_runbook")

    @is_global_runbook.setter
    def is_global_runbook(self, value: pulumi.Input[bool]):
        pulumi.set(self, "is_global_runbook", value)

    @property
    @pulumi.getter(name="runbookName")
    def runbook_name(self) -> pulumi.Input[str]:
        """
        The name for this runbook.
        """
        return pulumi.get(self, "runbook_name")

    @runbook_name.setter
    def runbook_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "runbook_name", value)

    @property
    @pulumi.getter(name="webhookResourceId")
    def webhook_resource_id(self) -> pulumi.Input[str]:
        """
        The resource id for webhook linked to this runbook.
        """
        return pulumi.get(self, "webhook_resource_id")

    @webhook_resource_id.setter
    def webhook_resource_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "webhook_resource_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates name of the webhook.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="serviceUri")
    def service_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The URI where webhooks should be sent.
        """
        return pulumi.get(self, "service_uri")

    @service_uri.setter
    def service_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_uri", value)

    @property
    @pulumi.getter(name="useCommonAlertSchema")
    def use_common_alert_schema(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether to use common alert schema.
        """
        return pulumi.get(self, "use_common_alert_schema")

    @use_common_alert_schema.setter
    def use_common_alert_schema(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_common_alert_schema", value)


@pulumi.input_type
class AzureAppPushReceiverArgs:
    def __init__(__self__, *,
                 email_address: pulumi.Input[str],
                 name: pulumi.Input[str]):
        """
        The Azure mobile App push notification receiver.
        :param pulumi.Input[str] email_address: The email address registered for the Azure mobile app.
        :param pulumi.Input[str] name: The name of the Azure mobile app push receiver. Names must be unique across all receivers within an action group.
        """
        pulumi.set(__self__, "email_address", email_address)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="emailAddress")
    def email_address(self) -> pulumi.Input[str]:
        """
        The email address registered for the Azure mobile app.
        """
        return pulumi.get(self, "email_address")

    @email_address.setter
    def email_address(self, value: pulumi.Input[str]):
        pulumi.set(self, "email_address", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the Azure mobile app push receiver. Names must be unique across all receivers within an action group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class AzureFunctionReceiverArgs:
    def __init__(__self__, *,
                 function_app_resource_id: pulumi.Input[str],
                 function_name: pulumi.Input[str],
                 http_trigger_url: pulumi.Input[str],
                 name: pulumi.Input[str],
                 use_common_alert_schema: Optional[pulumi.Input[bool]] = None):
        """
        An azure function receiver.
        :param pulumi.Input[str] function_app_resource_id: The azure resource id of the function app.
        :param pulumi.Input[str] function_name: The function name in the function app.
        :param pulumi.Input[str] http_trigger_url: The http trigger url where http request sent to.
        :param pulumi.Input[str] name: The name of the azure function receiver. Names must be unique across all receivers within an action group.
        :param pulumi.Input[bool] use_common_alert_schema: Indicates whether to use common alert schema.
        """
        pulumi.set(__self__, "function_app_resource_id", function_app_resource_id)
        pulumi.set(__self__, "function_name", function_name)
        pulumi.set(__self__, "http_trigger_url", http_trigger_url)
        pulumi.set(__self__, "name", name)
        if use_common_alert_schema is None:
            use_common_alert_schema = False
        if use_common_alert_schema is not None:
            pulumi.set(__self__, "use_common_alert_schema", use_common_alert_schema)

    @property
    @pulumi.getter(name="functionAppResourceId")
    def function_app_resource_id(self) -> pulumi.Input[str]:
        """
        The azure resource id of the function app.
        """
        return pulumi.get(self, "function_app_resource_id")

    @function_app_resource_id.setter
    def function_app_resource_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "function_app_resource_id", value)

    @property
    @pulumi.getter(name="functionName")
    def function_name(self) -> pulumi.Input[str]:
        """
        The function name in the function app.
        """
        return pulumi.get(self, "function_name")

    @function_name.setter
    def function_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "function_name", value)

    @property
    @pulumi.getter(name="httpTriggerUrl")
    def http_trigger_url(self) -> pulumi.Input[str]:
        """
        The http trigger url where http request sent to.
        """
        return pulumi.get(self, "http_trigger_url")

    @http_trigger_url.setter
    def http_trigger_url(self, value: pulumi.Input[str]):
        pulumi.set(self, "http_trigger_url", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the azure function receiver. Names must be unique across all receivers within an action group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="useCommonAlertSchema")
    def use_common_alert_schema(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether to use common alert schema.
        """
        return pulumi.get(self, "use_common_alert_schema")

    @use_common_alert_schema.setter
    def use_common_alert_schema(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_common_alert_schema", value)


@pulumi.input_type
class ColumnDefinitionArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[Union[str, 'KnownColumnDefinitionType']]] = None):
        """
        Definition of custom data column.
        :param pulumi.Input[str] name: The name of the column.
        :param pulumi.Input[Union[str, 'KnownColumnDefinitionType']] type: The type of the column data.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the column.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[Union[str, 'KnownColumnDefinitionType']]]:
        """
        The type of the column data.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[Union[str, 'KnownColumnDefinitionType']]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class DataCollectionEndpointNetworkAclsArgs:
    def __init__(__self__, *,
                 public_network_access: Optional[pulumi.Input[Union[str, 'KnownPublicNetworkAccessOptions']]] = None):
        """
        Network access control rules for the endpoints.
        :param pulumi.Input[Union[str, 'KnownPublicNetworkAccessOptions']] public_network_access: The configuration to set whether network access from public internet to the endpoints are allowed.
        """
        if public_network_access is not None:
            pulumi.set(__self__, "public_network_access", public_network_access)

    @property
    @pulumi.getter(name="publicNetworkAccess")
    def public_network_access(self) -> Optional[pulumi.Input[Union[str, 'KnownPublicNetworkAccessOptions']]]:
        """
        The configuration to set whether network access from public internet to the endpoints are allowed.
        """
        return pulumi.get(self, "public_network_access")

    @public_network_access.setter
    def public_network_access(self, value: Optional[pulumi.Input[Union[str, 'KnownPublicNetworkAccessOptions']]]):
        pulumi.set(self, "public_network_access", value)


@pulumi.input_type
class DataCollectionEndpointResourceIdentityArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[Union[str, 'ManagedServiceIdentityType']],
                 user_assigned_identities: Optional[pulumi.Input[Mapping[str, Any]]] = None):
        """
        Managed service identity of the resource.
        :param pulumi.Input[Union[str, 'ManagedServiceIdentityType']] type: Type of managed service identity (where both SystemAssigned and UserAssigned types are allowed).
        :param pulumi.Input[Mapping[str, Any]] user_assigned_identities: The set of user assigned identities associated with the resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}. The dictionary values can be empty objects ({}) in requests.
        """
        pulumi.set(__self__, "type", type)
        if user_assigned_identities is not None:
            pulumi.set(__self__, "user_assigned_identities", user_assigned_identities)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[Union[str, 'ManagedServiceIdentityType']]:
        """
        Type of managed service identity (where both SystemAssigned and UserAssigned types are allowed).
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[Union[str, 'ManagedServiceIdentityType']]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="userAssignedIdentities")
    def user_assigned_identities(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        The set of user assigned identities associated with the resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}. The dictionary values can be empty objects ({}) in requests.
        """
        return pulumi.get(self, "user_assigned_identities")

    @user_assigned_identities.setter
    def user_assigned_identities(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "user_assigned_identities", value)


@pulumi.input_type
class DataCollectionRuleDataSourcesArgs:
    def __init__(__self__, *,
                 data_imports: Optional[pulumi.Input['DataSourcesSpecDataImportsArgs']] = None,
                 extensions: Optional[pulumi.Input[Sequence[pulumi.Input['ExtensionDataSourceArgs']]]] = None,
                 iis_logs: Optional[pulumi.Input[Sequence[pulumi.Input['IisLogsDataSourceArgs']]]] = None,
                 log_files: Optional[pulumi.Input[Sequence[pulumi.Input['LogFilesDataSourceArgs']]]] = None,
                 performance_counters: Optional[pulumi.Input[Sequence[pulumi.Input['PerfCounterDataSourceArgs']]]] = None,
                 platform_telemetry: Optional[pulumi.Input[Sequence[pulumi.Input['PlatformTelemetryDataSourceArgs']]]] = None,
                 prometheus_forwarder: Optional[pulumi.Input[Sequence[pulumi.Input['PrometheusForwarderDataSourceArgs']]]] = None,
                 syslog: Optional[pulumi.Input[Sequence[pulumi.Input['SyslogDataSourceArgs']]]] = None,
                 windows_event_logs: Optional[pulumi.Input[Sequence[pulumi.Input['WindowsEventLogDataSourceArgs']]]] = None,
                 windows_firewall_logs: Optional[pulumi.Input[Sequence[pulumi.Input['WindowsFirewallLogsDataSourceArgs']]]] = None):
        """
        The specification of data sources. 
        This property is optional and can be omitted if the rule is meant to be used via direct calls to the provisioned endpoint.
        :param pulumi.Input['DataSourcesSpecDataImportsArgs'] data_imports: Specifications of pull based data sources
        :param pulumi.Input[Sequence[pulumi.Input['ExtensionDataSourceArgs']]] extensions: The list of Azure VM extension data source configurations.
        :param pulumi.Input[Sequence[pulumi.Input['IisLogsDataSourceArgs']]] iis_logs: The list of IIS logs source configurations.
        :param pulumi.Input[Sequence[pulumi.Input['LogFilesDataSourceArgs']]] log_files: The list of Log files source configurations.
        :param pulumi.Input[Sequence[pulumi.Input['PerfCounterDataSourceArgs']]] performance_counters: The list of performance counter data source configurations.
        :param pulumi.Input[Sequence[pulumi.Input['PlatformTelemetryDataSourceArgs']]] platform_telemetry: The list of platform telemetry configurations
        :param pulumi.Input[Sequence[pulumi.Input['PrometheusForwarderDataSourceArgs']]] prometheus_forwarder: The list of Prometheus forwarder data source configurations.
        :param pulumi.Input[Sequence[pulumi.Input['SyslogDataSourceArgs']]] syslog: The list of Syslog data source configurations.
        :param pulumi.Input[Sequence[pulumi.Input['WindowsEventLogDataSourceArgs']]] windows_event_logs: The list of Windows Event Log data source configurations.
        :param pulumi.Input[Sequence[pulumi.Input['WindowsFirewallLogsDataSourceArgs']]] windows_firewall_logs: The list of Windows Firewall logs source configurations.
        """
        if data_imports is not None:
            pulumi.set(__self__, "data_imports", data_imports)
        if extensions is not None:
            pulumi.set(__self__, "extensions", extensions)
        if iis_logs is not None:
            pulumi.set(__self__, "iis_logs", iis_logs)
        if log_files is not None:
            pulumi.set(__self__, "log_files", log_files)
        if performance_counters is not None:
            pulumi.set(__self__, "performance_counters", performance_counters)
        if platform_telemetry is not None:
            pulumi.set(__self__, "platform_telemetry", platform_telemetry)
        if prometheus_forwarder is not None:
            pulumi.set(__self__, "prometheus_forwarder", prometheus_forwarder)
        if syslog is not None:
            pulumi.set(__self__, "syslog", syslog)
        if windows_event_logs is not None:
            pulumi.set(__self__, "windows_event_logs", windows_event_logs)
        if windows_firewall_logs is not None:
            pulumi.set(__self__, "windows_firewall_logs", windows_firewall_logs)

    @property
    @pulumi.getter(name="dataImports")
    def data_imports(self) -> Optional[pulumi.Input['DataSourcesSpecDataImportsArgs']]:
        """
        Specifications of pull based data sources
        """
        return pulumi.get(self, "data_imports")

    @data_imports.setter
    def data_imports(self, value: Optional[pulumi.Input['DataSourcesSpecDataImportsArgs']]):
        pulumi.set(self, "data_imports", value)

    @property
    @pulumi.getter
    def extensions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ExtensionDataSourceArgs']]]]:
        """
        The list of Azure VM extension data source configurations.
        """
        return pulumi.get(self, "extensions")

    @extensions.setter
    def extensions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ExtensionDataSourceArgs']]]]):
        pulumi.set(self, "extensions", value)

    @property
    @pulumi.getter(name="iisLogs")
    def iis_logs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IisLogsDataSourceArgs']]]]:
        """
        The list of IIS logs source configurations.
        """
        return pulumi.get(self, "iis_logs")

    @iis_logs.setter
    def iis_logs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IisLogsDataSourceArgs']]]]):
        pulumi.set(self, "iis_logs", value)

    @property
    @pulumi.getter(name="logFiles")
    def log_files(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LogFilesDataSourceArgs']]]]:
        """
        The list of Log files source configurations.
        """
        return pulumi.get(self, "log_files")

    @log_files.setter
    def log_files(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LogFilesDataSourceArgs']]]]):
        pulumi.set(self, "log_files", value)

    @property
    @pulumi.getter(name="performanceCounters")
    def performance_counters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PerfCounterDataSourceArgs']]]]:
        """
        The list of performance counter data source configurations.
        """
        return pulumi.get(self, "performance_counters")

    @performance_counters.setter
    def performance_counters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PerfCounterDataSourceArgs']]]]):
        pulumi.set(self, "performance_counters", value)

    @property
    @pulumi.getter(name="platformTelemetry")
    def platform_telemetry(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PlatformTelemetryDataSourceArgs']]]]:
        """
        The list of platform telemetry configurations
        """
        return pulumi.get(self, "platform_telemetry")

    @platform_telemetry.setter
    def platform_telemetry(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PlatformTelemetryDataSourceArgs']]]]):
        pulumi.set(self, "platform_telemetry", value)

    @property
    @pulumi.getter(name="prometheusForwarder")
    def prometheus_forwarder(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PrometheusForwarderDataSourceArgs']]]]:
        """
        The list of Prometheus forwarder data source configurations.
        """
        return pulumi.get(self, "prometheus_forwarder")

    @prometheus_forwarder.setter
    def prometheus_forwarder(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PrometheusForwarderDataSourceArgs']]]]):
        pulumi.set(self, "prometheus_forwarder", value)

    @property
    @pulumi.getter
    def syslog(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SyslogDataSourceArgs']]]]:
        """
        The list of Syslog data source configurations.
        """
        return pulumi.get(self, "syslog")

    @syslog.setter
    def syslog(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SyslogDataSourceArgs']]]]):
        pulumi.set(self, "syslog", value)

    @property
    @pulumi.getter(name="windowsEventLogs")
    def windows_event_logs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WindowsEventLogDataSourceArgs']]]]:
        """
        The list of Windows Event Log data source configurations.
        """
        return pulumi.get(self, "windows_event_logs")

    @windows_event_logs.setter
    def windows_event_logs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WindowsEventLogDataSourceArgs']]]]):
        pulumi.set(self, "windows_event_logs", value)

    @property
    @pulumi.getter(name="windowsFirewallLogs")
    def windows_firewall_logs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WindowsFirewallLogsDataSourceArgs']]]]:
        """
        The list of Windows Firewall logs source configurations.
        """
        return pulumi.get(self, "windows_firewall_logs")

    @windows_firewall_logs.setter
    def windows_firewall_logs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WindowsFirewallLogsDataSourceArgs']]]]):
        pulumi.set(self, "windows_firewall_logs", value)


@pulumi.input_type
class DataCollectionRuleDestinationsArgs:
    def __init__(__self__, *,
                 azure_monitor_metrics: Optional[pulumi.Input['DestinationsSpecAzureMonitorMetricsArgs']] = None,
                 event_hubs: Optional[pulumi.Input[Sequence[pulumi.Input['EventHubDestinationArgs']]]] = None,
                 event_hubs_direct: Optional[pulumi.Input[Sequence[pulumi.Input['EventHubDirectDestinationArgs']]]] = None,
                 log_analytics: Optional[pulumi.Input[Sequence[pulumi.Input['LogAnalyticsDestinationArgs']]]] = None,
                 monitoring_accounts: Optional[pulumi.Input[Sequence[pulumi.Input['MonitoringAccountDestinationArgs']]]] = None,
                 storage_accounts: Optional[pulumi.Input[Sequence[pulumi.Input['StorageBlobDestinationArgs']]]] = None,
                 storage_blobs_direct: Optional[pulumi.Input[Sequence[pulumi.Input['StorageBlobDestinationArgs']]]] = None,
                 storage_tables_direct: Optional[pulumi.Input[Sequence[pulumi.Input['StorageTableDestinationArgs']]]] = None):
        """
        The specification of destinations.
        :param pulumi.Input['DestinationsSpecAzureMonitorMetricsArgs'] azure_monitor_metrics: Azure Monitor Metrics destination.
        :param pulumi.Input[Sequence[pulumi.Input['EventHubDestinationArgs']]] event_hubs: List of Event Hubs destinations.
        :param pulumi.Input[Sequence[pulumi.Input['EventHubDirectDestinationArgs']]] event_hubs_direct: List of Event Hubs Direct destinations.
        :param pulumi.Input[Sequence[pulumi.Input['LogAnalyticsDestinationArgs']]] log_analytics: List of Log Analytics destinations.
        :param pulumi.Input[Sequence[pulumi.Input['MonitoringAccountDestinationArgs']]] monitoring_accounts: List of monitoring account destinations.
        :param pulumi.Input[Sequence[pulumi.Input['StorageBlobDestinationArgs']]] storage_accounts: List of storage accounts destinations.
        :param pulumi.Input[Sequence[pulumi.Input['StorageBlobDestinationArgs']]] storage_blobs_direct: List of Storage Blob Direct destinations. To be used only for sending data directly to store from the agent.
        :param pulumi.Input[Sequence[pulumi.Input['StorageTableDestinationArgs']]] storage_tables_direct: List of Storage Table Direct destinations.
        """
        if azure_monitor_metrics is not None:
            pulumi.set(__self__, "azure_monitor_metrics", azure_monitor_metrics)
        if event_hubs is not None:
            pulumi.set(__self__, "event_hubs", event_hubs)
        if event_hubs_direct is not None:
            pulumi.set(__self__, "event_hubs_direct", event_hubs_direct)
        if log_analytics is not None:
            pulumi.set(__self__, "log_analytics", log_analytics)
        if monitoring_accounts is not None:
            pulumi.set(__self__, "monitoring_accounts", monitoring_accounts)
        if storage_accounts is not None:
            pulumi.set(__self__, "storage_accounts", storage_accounts)
        if storage_blobs_direct is not None:
            pulumi.set(__self__, "storage_blobs_direct", storage_blobs_direct)
        if storage_tables_direct is not None:
            pulumi.set(__self__, "storage_tables_direct", storage_tables_direct)

    @property
    @pulumi.getter(name="azureMonitorMetrics")
    def azure_monitor_metrics(self) -> Optional[pulumi.Input['DestinationsSpecAzureMonitorMetricsArgs']]:
        """
        Azure Monitor Metrics destination.
        """
        return pulumi.get(self, "azure_monitor_metrics")

    @azure_monitor_metrics.setter
    def azure_monitor_metrics(self, value: Optional[pulumi.Input['DestinationsSpecAzureMonitorMetricsArgs']]):
        pulumi.set(self, "azure_monitor_metrics", value)

    @property
    @pulumi.getter(name="eventHubs")
    def event_hubs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EventHubDestinationArgs']]]]:
        """
        List of Event Hubs destinations.
        """
        return pulumi.get(self, "event_hubs")

    @event_hubs.setter
    def event_hubs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EventHubDestinationArgs']]]]):
        pulumi.set(self, "event_hubs", value)

    @property
    @pulumi.getter(name="eventHubsDirect")
    def event_hubs_direct(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EventHubDirectDestinationArgs']]]]:
        """
        List of Event Hubs Direct destinations.
        """
        return pulumi.get(self, "event_hubs_direct")

    @event_hubs_direct.setter
    def event_hubs_direct(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EventHubDirectDestinationArgs']]]]):
        pulumi.set(self, "event_hubs_direct", value)

    @property
    @pulumi.getter(name="logAnalytics")
    def log_analytics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LogAnalyticsDestinationArgs']]]]:
        """
        List of Log Analytics destinations.
        """
        return pulumi.get(self, "log_analytics")

    @log_analytics.setter
    def log_analytics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LogAnalyticsDestinationArgs']]]]):
        pulumi.set(self, "log_analytics", value)

    @property
    @pulumi.getter(name="monitoringAccounts")
    def monitoring_accounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MonitoringAccountDestinationArgs']]]]:
        """
        List of monitoring account destinations.
        """
        return pulumi.get(self, "monitoring_accounts")

    @monitoring_accounts.setter
    def monitoring_accounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MonitoringAccountDestinationArgs']]]]):
        pulumi.set(self, "monitoring_accounts", value)

    @property
    @pulumi.getter(name="storageAccounts")
    def storage_accounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StorageBlobDestinationArgs']]]]:
        """
        List of storage accounts destinations.
        """
        return pulumi.get(self, "storage_accounts")

    @storage_accounts.setter
    def storage_accounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StorageBlobDestinationArgs']]]]):
        pulumi.set(self, "storage_accounts", value)

    @property
    @pulumi.getter(name="storageBlobsDirect")
    def storage_blobs_direct(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StorageBlobDestinationArgs']]]]:
        """
        List of Storage Blob Direct destinations. To be used only for sending data directly to store from the agent.
        """
        return pulumi.get(self, "storage_blobs_direct")

    @storage_blobs_direct.setter
    def storage_blobs_direct(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StorageBlobDestinationArgs']]]]):
        pulumi.set(self, "storage_blobs_direct", value)

    @property
    @pulumi.getter(name="storageTablesDirect")
    def storage_tables_direct(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StorageTableDestinationArgs']]]]:
        """
        List of Storage Table Direct destinations.
        """
        return pulumi.get(self, "storage_tables_direct")

    @storage_tables_direct.setter
    def storage_tables_direct(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StorageTableDestinationArgs']]]]):
        pulumi.set(self, "storage_tables_direct", value)


@pulumi.input_type
class DataCollectionRuleResourceIdentityArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[Union[str, 'ManagedServiceIdentityType']],
                 user_assigned_identities: Optional[pulumi.Input[Mapping[str, Any]]] = None):
        """
        Managed service identity of the resource.
        :param pulumi.Input[Union[str, 'ManagedServiceIdentityType']] type: Type of managed service identity (where both SystemAssigned and UserAssigned types are allowed).
        :param pulumi.Input[Mapping[str, Any]] user_assigned_identities: The set of user assigned identities associated with the resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}. The dictionary values can be empty objects ({}) in requests.
        """
        pulumi.set(__self__, "type", type)
        if user_assigned_identities is not None:
            pulumi.set(__self__, "user_assigned_identities", user_assigned_identities)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[Union[str, 'ManagedServiceIdentityType']]:
        """
        Type of managed service identity (where both SystemAssigned and UserAssigned types are allowed).
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[Union[str, 'ManagedServiceIdentityType']]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="userAssignedIdentities")
    def user_assigned_identities(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        The set of user assigned identities associated with the resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}. The dictionary values can be empty objects ({}) in requests.
        """
        return pulumi.get(self, "user_assigned_identities")

    @user_assigned_identities.setter
    def user_assigned_identities(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "user_assigned_identities", value)


@pulumi.input_type
class DataFlowArgs:
    def __init__(__self__, *,
                 built_in_transform: Optional[pulumi.Input[str]] = None,
                 destinations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 output_stream: Optional[pulumi.Input[str]] = None,
                 streams: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'KnownDataFlowStreams']]]]] = None,
                 transform_kql: Optional[pulumi.Input[str]] = None):
        """
        Definition of which streams are sent to which destinations.
        :param pulumi.Input[str] built_in_transform: The builtIn transform to transform stream data
        :param pulumi.Input[Sequence[pulumi.Input[str]]] destinations: List of destinations for this data flow.
        :param pulumi.Input[str] output_stream: The output stream of the transform. Only required if the transform changes data to a different stream.
        :param pulumi.Input[Sequence[pulumi.Input[Union[str, 'KnownDataFlowStreams']]]] streams: List of streams for this data flow.
        :param pulumi.Input[str] transform_kql: The KQL query to transform stream data.
        """
        if built_in_transform is not None:
            pulumi.set(__self__, "built_in_transform", built_in_transform)
        if destinations is not None:
            pulumi.set(__self__, "destinations", destinations)
        if output_stream is not None:
            pulumi.set(__self__, "output_stream", output_stream)
        if streams is not None:
            pulumi.set(__self__, "streams", streams)
        if transform_kql is not None:
            pulumi.set(__self__, "transform_kql", transform_kql)

    @property
    @pulumi.getter(name="builtInTransform")
    def built_in_transform(self) -> Optional[pulumi.Input[str]]:
        """
        The builtIn transform to transform stream data
        """
        return pulumi.get(self, "built_in_transform")

    @built_in_transform.setter
    def built_in_transform(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "built_in_transform", value)

    @property
    @pulumi.getter
    def destinations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of destinations for this data flow.
        """
        return pulumi.get(self, "destinations")

    @destinations.setter
    def destinations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "destinations", value)

    @property
    @pulumi.getter(name="outputStream")
    def output_stream(self) -> Optional[pulumi.Input[str]]:
        """
        The output stream of the transform. Only required if the transform changes data to a different stream.
        """
        return pulumi.get(self, "output_stream")

    @output_stream.setter
    def output_stream(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "output_stream", value)

    @property
    @pulumi.getter
    def streams(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'KnownDataFlowStreams']]]]]:
        """
        List of streams for this data flow.
        """
        return pulumi.get(self, "streams")

    @streams.setter
    def streams(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'KnownDataFlowStreams']]]]]):
        pulumi.set(self, "streams", value)

    @property
    @pulumi.getter(name="transformKql")
    def transform_kql(self) -> Optional[pulumi.Input[str]]:
        """
        The KQL query to transform stream data.
        """
        return pulumi.get(self, "transform_kql")

    @transform_kql.setter
    def transform_kql(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "transform_kql", value)


@pulumi.input_type
class DataImportSourcesEventHubArgs:
    def __init__(__self__, *,
                 consumer_group: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 stream: Optional[pulumi.Input[str]] = None):
        """
        Definition of Event Hub configuration.
        :param pulumi.Input[str] consumer_group: Event Hub consumer group name
        :param pulumi.Input[str] name: A friendly name for the data source. 
               This name should be unique across all data sources (regardless of type) within the data collection rule.
        :param pulumi.Input[str] stream: The stream to collect from EventHub
        """
        if consumer_group is not None:
            pulumi.set(__self__, "consumer_group", consumer_group)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if stream is not None:
            pulumi.set(__self__, "stream", stream)

    @property
    @pulumi.getter(name="consumerGroup")
    def consumer_group(self) -> Optional[pulumi.Input[str]]:
        """
        Event Hub consumer group name
        """
        return pulumi.get(self, "consumer_group")

    @consumer_group.setter
    def consumer_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "consumer_group", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A friendly name for the data source. 
        This name should be unique across all data sources (regardless of type) within the data collection rule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def stream(self) -> Optional[pulumi.Input[str]]:
        """
        The stream to collect from EventHub
        """
        return pulumi.get(self, "stream")

    @stream.setter
    def stream(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "stream", value)


@pulumi.input_type
class DataSourcesSpecDataImportsArgs:
    def __init__(__self__, *,
                 event_hub: Optional[pulumi.Input['DataImportSourcesEventHubArgs']] = None):
        """
        Specifications of pull based data sources
        :param pulumi.Input['DataImportSourcesEventHubArgs'] event_hub: Definition of Event Hub configuration.
        """
        if event_hub is not None:
            pulumi.set(__self__, "event_hub", event_hub)

    @property
    @pulumi.getter(name="eventHub")
    def event_hub(self) -> Optional[pulumi.Input['DataImportSourcesEventHubArgs']]:
        """
        Definition of Event Hub configuration.
        """
        return pulumi.get(self, "event_hub")

    @event_hub.setter
    def event_hub(self, value: Optional[pulumi.Input['DataImportSourcesEventHubArgs']]):
        pulumi.set(self, "event_hub", value)


@pulumi.input_type
class DestinationsSpecAzureMonitorMetricsArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None):
        """
        Azure Monitor Metrics destination.
        :param pulumi.Input[str] name: A friendly name for the destination. 
               This name should be unique across all destinations (regardless of type) within the data collection rule.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A friendly name for the destination. 
        This name should be unique across all destinations (regardless of type) within the data collection rule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class EmailReceiverArgs:
    def __init__(__self__, *,
                 email_address: pulumi.Input[str],
                 name: pulumi.Input[str],
                 use_common_alert_schema: Optional[pulumi.Input[bool]] = None):
        """
        An email receiver.
        :param pulumi.Input[str] email_address: The email address of this receiver.
        :param pulumi.Input[str] name: The name of the email receiver. Names must be unique across all receivers within an action group.
        :param pulumi.Input[bool] use_common_alert_schema: Indicates whether to use common alert schema.
        """
        pulumi.set(__self__, "email_address", email_address)
        pulumi.set(__self__, "name", name)
        if use_common_alert_schema is None:
            use_common_alert_schema = False
        if use_common_alert_schema is not None:
            pulumi.set(__self__, "use_common_alert_schema", use_common_alert_schema)

    @property
    @pulumi.getter(name="emailAddress")
    def email_address(self) -> pulumi.Input[str]:
        """
        The email address of this receiver.
        """
        return pulumi.get(self, "email_address")

    @email_address.setter
    def email_address(self, value: pulumi.Input[str]):
        pulumi.set(self, "email_address", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the email receiver. Names must be unique across all receivers within an action group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="useCommonAlertSchema")
    def use_common_alert_schema(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether to use common alert schema.
        """
        return pulumi.get(self, "use_common_alert_schema")

    @use_common_alert_schema.setter
    def use_common_alert_schema(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_common_alert_schema", value)


@pulumi.input_type
class EventHubDestinationArgs:
    def __init__(__self__, *,
                 event_hub_resource_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] event_hub_resource_id: The resource ID of the event hub.
        :param pulumi.Input[str] name: A friendly name for the destination. 
               This name should be unique across all destinations (regardless of type) within the data collection rule.
        """
        if event_hub_resource_id is not None:
            pulumi.set(__self__, "event_hub_resource_id", event_hub_resource_id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="eventHubResourceId")
    def event_hub_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        The resource ID of the event hub.
        """
        return pulumi.get(self, "event_hub_resource_id")

    @event_hub_resource_id.setter
    def event_hub_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "event_hub_resource_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A friendly name for the destination. 
        This name should be unique across all destinations (regardless of type) within the data collection rule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class EventHubDirectDestinationArgs:
    def __init__(__self__, *,
                 event_hub_resource_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] event_hub_resource_id: The resource ID of the event hub.
        :param pulumi.Input[str] name: A friendly name for the destination. 
               This name should be unique across all destinations (regardless of type) within the data collection rule.
        """
        if event_hub_resource_id is not None:
            pulumi.set(__self__, "event_hub_resource_id", event_hub_resource_id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="eventHubResourceId")
    def event_hub_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        The resource ID of the event hub.
        """
        return pulumi.get(self, "event_hub_resource_id")

    @event_hub_resource_id.setter
    def event_hub_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "event_hub_resource_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A friendly name for the destination. 
        This name should be unique across all destinations (regardless of type) within the data collection rule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class EventHubReceiverArgs:
    def __init__(__self__, *,
                 event_hub_name: pulumi.Input[str],
                 event_hub_name_space: pulumi.Input[str],
                 name: pulumi.Input[str],
                 subscription_id: pulumi.Input[str],
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 use_common_alert_schema: Optional[pulumi.Input[bool]] = None):
        """
        An Event hub receiver.
        :param pulumi.Input[str] event_hub_name: The name of the specific Event Hub queue
        :param pulumi.Input[str] event_hub_name_space: The Event Hub namespace
        :param pulumi.Input[str] name: The name of the Event hub receiver. Names must be unique across all receivers within an action group.
        :param pulumi.Input[str] subscription_id: The Id for the subscription containing this event hub
        :param pulumi.Input[str] tenant_id: The tenant Id for the subscription containing this event hub
        :param pulumi.Input[bool] use_common_alert_schema: Indicates whether to use common alert schema.
        """
        pulumi.set(__self__, "event_hub_name", event_hub_name)
        pulumi.set(__self__, "event_hub_name_space", event_hub_name_space)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "subscription_id", subscription_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if use_common_alert_schema is None:
            use_common_alert_schema = False
        if use_common_alert_schema is not None:
            pulumi.set(__self__, "use_common_alert_schema", use_common_alert_schema)

    @property
    @pulumi.getter(name="eventHubName")
    def event_hub_name(self) -> pulumi.Input[str]:
        """
        The name of the specific Event Hub queue
        """
        return pulumi.get(self, "event_hub_name")

    @event_hub_name.setter
    def event_hub_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "event_hub_name", value)

    @property
    @pulumi.getter(name="eventHubNameSpace")
    def event_hub_name_space(self) -> pulumi.Input[str]:
        """
        The Event Hub namespace
        """
        return pulumi.get(self, "event_hub_name_space")

    @event_hub_name_space.setter
    def event_hub_name_space(self, value: pulumi.Input[str]):
        pulumi.set(self, "event_hub_name_space", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the Event hub receiver. Names must be unique across all receivers within an action group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> pulumi.Input[str]:
        """
        The Id for the subscription containing this event hub
        """
        return pulumi.get(self, "subscription_id")

    @subscription_id.setter
    def subscription_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "subscription_id", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The tenant Id for the subscription containing this event hub
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="useCommonAlertSchema")
    def use_common_alert_schema(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether to use common alert schema.
        """
        return pulumi.get(self, "use_common_alert_schema")

    @use_common_alert_schema.setter
    def use_common_alert_schema(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_common_alert_schema", value)


@pulumi.input_type
class ExtensionDataSourceArgs:
    def __init__(__self__, *,
                 extension_name: pulumi.Input[str],
                 extension_settings: Optional[Any] = None,
                 input_data_sources: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 streams: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'KnownExtensionDataSourceStreams']]]]] = None):
        """
        Definition of which data will be collected from a separate VM extension that integrates with the Azure Monitor Agent.
        Collected from either Windows and Linux machines, depending on which extension is defined.
        :param pulumi.Input[str] extension_name: The name of the VM extension.
        :param Any extension_settings: The extension settings. The format is specific for particular extension.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] input_data_sources: The list of data sources this extension needs data from.
        :param pulumi.Input[str] name: A friendly name for the data source. 
               This name should be unique across all data sources (regardless of type) within the data collection rule.
        :param pulumi.Input[Sequence[pulumi.Input[Union[str, 'KnownExtensionDataSourceStreams']]]] streams: List of streams that this data source will be sent to.
               A stream indicates what schema will be used for this data and usually what table in Log Analytics the data will be sent to.
        """
        pulumi.set(__self__, "extension_name", extension_name)
        if extension_settings is not None:
            pulumi.set(__self__, "extension_settings", extension_settings)
        if input_data_sources is not None:
            pulumi.set(__self__, "input_data_sources", input_data_sources)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if streams is not None:
            pulumi.set(__self__, "streams", streams)

    @property
    @pulumi.getter(name="extensionName")
    def extension_name(self) -> pulumi.Input[str]:
        """
        The name of the VM extension.
        """
        return pulumi.get(self, "extension_name")

    @extension_name.setter
    def extension_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "extension_name", value)

    @property
    @pulumi.getter(name="extensionSettings")
    def extension_settings(self) -> Optional[Any]:
        """
        The extension settings. The format is specific for particular extension.
        """
        return pulumi.get(self, "extension_settings")

    @extension_settings.setter
    def extension_settings(self, value: Optional[Any]):
        pulumi.set(self, "extension_settings", value)

    @property
    @pulumi.getter(name="inputDataSources")
    def input_data_sources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of data sources this extension needs data from.
        """
        return pulumi.get(self, "input_data_sources")

    @input_data_sources.setter
    def input_data_sources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "input_data_sources", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A friendly name for the data source. 
        This name should be unique across all data sources (regardless of type) within the data collection rule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def streams(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'KnownExtensionDataSourceStreams']]]]]:
        """
        List of streams that this data source will be sent to.
        A stream indicates what schema will be used for this data and usually what table in Log Analytics the data will be sent to.
        """
        return pulumi.get(self, "streams")

    @streams.setter
    def streams(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'KnownExtensionDataSourceStreams']]]]]):
        pulumi.set(self, "streams", value)


@pulumi.input_type
class IisLogsDataSourceArgs:
    def __init__(__self__, *,
                 streams: pulumi.Input[Sequence[pulumi.Input[str]]],
                 log_directories: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        Enables IIS logs to be collected by this data collection rule.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] streams: IIS streams
        :param pulumi.Input[Sequence[pulumi.Input[str]]] log_directories: Absolute paths file location
        :param pulumi.Input[str] name: A friendly name for the data source. 
               This name should be unique across all data sources (regardless of type) within the data collection rule.
        """
        pulumi.set(__self__, "streams", streams)
        if log_directories is not None:
            pulumi.set(__self__, "log_directories", log_directories)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def streams(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        IIS streams
        """
        return pulumi.get(self, "streams")

    @streams.setter
    def streams(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "streams", value)

    @property
    @pulumi.getter(name="logDirectories")
    def log_directories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Absolute paths file location
        """
        return pulumi.get(self, "log_directories")

    @log_directories.setter
    def log_directories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "log_directories", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A friendly name for the data source. 
        This name should be unique across all data sources (regardless of type) within the data collection rule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class ItsmReceiverArgs:
    def __init__(__self__, *,
                 connection_id: pulumi.Input[str],
                 name: pulumi.Input[str],
                 region: pulumi.Input[str],
                 ticket_configuration: pulumi.Input[str],
                 workspace_id: pulumi.Input[str]):
        """
        An Itsm receiver.
        :param pulumi.Input[str] connection_id: Unique identification of ITSM connection among multiple defined in above workspace.
        :param pulumi.Input[str] name: The name of the Itsm receiver. Names must be unique across all receivers within an action group.
        :param pulumi.Input[str] region: Region in which workspace resides. Supported values:'centralindia','japaneast','southeastasia','australiasoutheast','uksouth','westcentralus','canadacentral','eastus','westeurope'
        :param pulumi.Input[str] ticket_configuration: JSON blob for the configurations of the ITSM action. CreateMultipleWorkItems option will be part of this blob as well.
        :param pulumi.Input[str] workspace_id: OMS LA instance identifier.
        """
        pulumi.set(__self__, "connection_id", connection_id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "ticket_configuration", ticket_configuration)
        pulumi.set(__self__, "workspace_id", workspace_id)

    @property
    @pulumi.getter(name="connectionId")
    def connection_id(self) -> pulumi.Input[str]:
        """
        Unique identification of ITSM connection among multiple defined in above workspace.
        """
        return pulumi.get(self, "connection_id")

    @connection_id.setter
    def connection_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "connection_id", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the Itsm receiver. Names must be unique across all receivers within an action group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> pulumi.Input[str]:
        """
        Region in which workspace resides. Supported values:'centralindia','japaneast','southeastasia','australiasoutheast','uksouth','westcentralus','canadacentral','eastus','westeurope'
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[str]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="ticketConfiguration")
    def ticket_configuration(self) -> pulumi.Input[str]:
        """
        JSON blob for the configurations of the ITSM action. CreateMultipleWorkItems option will be part of this blob as well.
        """
        return pulumi.get(self, "ticket_configuration")

    @ticket_configuration.setter
    def ticket_configuration(self, value: pulumi.Input[str]):
        pulumi.set(self, "ticket_configuration", value)

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Input[str]:
        """
        OMS LA instance identifier.
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "workspace_id", value)


@pulumi.input_type
class LogAnalyticsDestinationArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 workspace_resource_id: Optional[pulumi.Input[str]] = None):
        """
        Log Analytics destination.
        :param pulumi.Input[str] name: A friendly name for the destination. 
               This name should be unique across all destinations (regardless of type) within the data collection rule.
        :param pulumi.Input[str] workspace_resource_id: The resource ID of the Log Analytics workspace.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if workspace_resource_id is not None:
            pulumi.set(__self__, "workspace_resource_id", workspace_resource_id)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A friendly name for the destination. 
        This name should be unique across all destinations (regardless of type) within the data collection rule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="workspaceResourceId")
    def workspace_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        The resource ID of the Log Analytics workspace.
        """
        return pulumi.get(self, "workspace_resource_id")

    @workspace_resource_id.setter
    def workspace_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "workspace_resource_id", value)


@pulumi.input_type
class LogFileSettingsTextArgs:
    def __init__(__self__, *,
                 record_start_timestamp_format: pulumi.Input[Union[str, 'KnownLogFileTextSettingsRecordStartTimestampFormat']]):
        """
        Text settings
        :param pulumi.Input[Union[str, 'KnownLogFileTextSettingsRecordStartTimestampFormat']] record_start_timestamp_format: One of the supported timestamp formats
        """
        pulumi.set(__self__, "record_start_timestamp_format", record_start_timestamp_format)

    @property
    @pulumi.getter(name="recordStartTimestampFormat")
    def record_start_timestamp_format(self) -> pulumi.Input[Union[str, 'KnownLogFileTextSettingsRecordStartTimestampFormat']]:
        """
        One of the supported timestamp formats
        """
        return pulumi.get(self, "record_start_timestamp_format")

    @record_start_timestamp_format.setter
    def record_start_timestamp_format(self, value: pulumi.Input[Union[str, 'KnownLogFileTextSettingsRecordStartTimestampFormat']]):
        pulumi.set(self, "record_start_timestamp_format", value)


@pulumi.input_type
class LogFilesDataSourceSettingsArgs:
    def __init__(__self__, *,
                 text: Optional[pulumi.Input['LogFileSettingsTextArgs']] = None):
        """
        The log files specific settings.
        :param pulumi.Input['LogFileSettingsTextArgs'] text: Text settings
        """
        if text is not None:
            pulumi.set(__self__, "text", text)

    @property
    @pulumi.getter
    def text(self) -> Optional[pulumi.Input['LogFileSettingsTextArgs']]:
        """
        Text settings
        """
        return pulumi.get(self, "text")

    @text.setter
    def text(self, value: Optional[pulumi.Input['LogFileSettingsTextArgs']]):
        pulumi.set(self, "text", value)


@pulumi.input_type
class LogFilesDataSourceArgs:
    def __init__(__self__, *,
                 file_patterns: pulumi.Input[Sequence[pulumi.Input[str]]],
                 format: pulumi.Input[Union[str, 'KnownLogFilesDataSourceFormat']],
                 streams: pulumi.Input[Sequence[pulumi.Input[str]]],
                 name: Optional[pulumi.Input[str]] = None,
                 settings: Optional[pulumi.Input['LogFilesDataSourceSettingsArgs']] = None):
        """
        Definition of which custom log files will be collected by this data collection rule
        :param pulumi.Input[Sequence[pulumi.Input[str]]] file_patterns: File Patterns where the log files are located
        :param pulumi.Input[Union[str, 'KnownLogFilesDataSourceFormat']] format: The data format of the log files
        :param pulumi.Input[Sequence[pulumi.Input[str]]] streams: List of streams that this data source will be sent to.
               A stream indicates what schema will be used for this data source
        :param pulumi.Input[str] name: A friendly name for the data source. 
               This name should be unique across all data sources (regardless of type) within the data collection rule.
        :param pulumi.Input['LogFilesDataSourceSettingsArgs'] settings: The log files specific settings.
        """
        pulumi.set(__self__, "file_patterns", file_patterns)
        pulumi.set(__self__, "format", format)
        pulumi.set(__self__, "streams", streams)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)

    @property
    @pulumi.getter(name="filePatterns")
    def file_patterns(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        File Patterns where the log files are located
        """
        return pulumi.get(self, "file_patterns")

    @file_patterns.setter
    def file_patterns(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "file_patterns", value)

    @property
    @pulumi.getter
    def format(self) -> pulumi.Input[Union[str, 'KnownLogFilesDataSourceFormat']]:
        """
        The data format of the log files
        """
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: pulumi.Input[Union[str, 'KnownLogFilesDataSourceFormat']]):
        pulumi.set(self, "format", value)

    @property
    @pulumi.getter
    def streams(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        List of streams that this data source will be sent to.
        A stream indicates what schema will be used for this data source
        """
        return pulumi.get(self, "streams")

    @streams.setter
    def streams(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "streams", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A friendly name for the data source. 
        This name should be unique across all data sources (regardless of type) within the data collection rule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def settings(self) -> Optional[pulumi.Input['LogFilesDataSourceSettingsArgs']]:
        """
        The log files specific settings.
        """
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: Optional[pulumi.Input['LogFilesDataSourceSettingsArgs']]):
        pulumi.set(self, "settings", value)


@pulumi.input_type
class LogicAppReceiverArgs:
    def __init__(__self__, *,
                 callback_url: pulumi.Input[str],
                 name: pulumi.Input[str],
                 resource_id: pulumi.Input[str],
                 use_common_alert_schema: Optional[pulumi.Input[bool]] = None):
        """
        A logic app receiver.
        :param pulumi.Input[str] callback_url: The callback url where http request sent to.
        :param pulumi.Input[str] name: The name of the logic app receiver. Names must be unique across all receivers within an action group.
        :param pulumi.Input[str] resource_id: The azure resource id of the logic app receiver.
        :param pulumi.Input[bool] use_common_alert_schema: Indicates whether to use common alert schema.
        """
        pulumi.set(__self__, "callback_url", callback_url)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "resource_id", resource_id)
        if use_common_alert_schema is None:
            use_common_alert_schema = False
        if use_common_alert_schema is not None:
            pulumi.set(__self__, "use_common_alert_schema", use_common_alert_schema)

    @property
    @pulumi.getter(name="callbackUrl")
    def callback_url(self) -> pulumi.Input[str]:
        """
        The callback url where http request sent to.
        """
        return pulumi.get(self, "callback_url")

    @callback_url.setter
    def callback_url(self, value: pulumi.Input[str]):
        pulumi.set(self, "callback_url", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the logic app receiver. Names must be unique across all receivers within an action group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> pulumi.Input[str]:
        """
        The azure resource id of the logic app receiver.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_id", value)

    @property
    @pulumi.getter(name="useCommonAlertSchema")
    def use_common_alert_schema(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether to use common alert schema.
        """
        return pulumi.get(self, "use_common_alert_schema")

    @use_common_alert_schema.setter
    def use_common_alert_schema(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_common_alert_schema", value)


@pulumi.input_type
class MonitoringAccountDestinationArgs:
    def __init__(__self__, *,
                 account_resource_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        Monitoring account destination.
        :param pulumi.Input[str] account_resource_id: The resource ID of the monitoring account.
        :param pulumi.Input[str] name: A friendly name for the destination. 
               This name should be unique across all destinations (regardless of type) within the data collection rule.
        """
        if account_resource_id is not None:
            pulumi.set(__self__, "account_resource_id", account_resource_id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="accountResourceId")
    def account_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        The resource ID of the monitoring account.
        """
        return pulumi.get(self, "account_resource_id")

    @account_resource_id.setter
    def account_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_resource_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A friendly name for the destination. 
        This name should be unique across all destinations (regardless of type) within the data collection rule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class PerfCounterDataSourceArgs:
    def __init__(__self__, *,
                 counter_specifiers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 sampling_frequency_in_seconds: Optional[pulumi.Input[int]] = None,
                 streams: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'KnownPerfCounterDataSourceStreams']]]]] = None):
        """
        Definition of which performance counters will be collected and how they will be collected by this data collection rule.
        Collected from both Windows and Linux machines where the counter is present.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] counter_specifiers: A list of specifier names of the performance counters you want to collect.
               Use a wildcard (*) to collect a counter for all instances.
               To get a list of performance counters on Windows, run the command 'typeperf'.
        :param pulumi.Input[str] name: A friendly name for the data source. 
               This name should be unique across all data sources (regardless of type) within the data collection rule.
        :param pulumi.Input[int] sampling_frequency_in_seconds: The number of seconds between consecutive counter measurements (samples).
        :param pulumi.Input[Sequence[pulumi.Input[Union[str, 'KnownPerfCounterDataSourceStreams']]]] streams: List of streams that this data source will be sent to.
               A stream indicates what schema will be used for this data and usually what table in Log Analytics the data will be sent to.
        """
        if counter_specifiers is not None:
            pulumi.set(__self__, "counter_specifiers", counter_specifiers)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if sampling_frequency_in_seconds is not None:
            pulumi.set(__self__, "sampling_frequency_in_seconds", sampling_frequency_in_seconds)
        if streams is not None:
            pulumi.set(__self__, "streams", streams)

    @property
    @pulumi.getter(name="counterSpecifiers")
    def counter_specifiers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of specifier names of the performance counters you want to collect.
        Use a wildcard (*) to collect a counter for all instances.
        To get a list of performance counters on Windows, run the command 'typeperf'.
        """
        return pulumi.get(self, "counter_specifiers")

    @counter_specifiers.setter
    def counter_specifiers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "counter_specifiers", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A friendly name for the data source. 
        This name should be unique across all data sources (regardless of type) within the data collection rule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="samplingFrequencyInSeconds")
    def sampling_frequency_in_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        The number of seconds between consecutive counter measurements (samples).
        """
        return pulumi.get(self, "sampling_frequency_in_seconds")

    @sampling_frequency_in_seconds.setter
    def sampling_frequency_in_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "sampling_frequency_in_seconds", value)

    @property
    @pulumi.getter
    def streams(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'KnownPerfCounterDataSourceStreams']]]]]:
        """
        List of streams that this data source will be sent to.
        A stream indicates what schema will be used for this data and usually what table in Log Analytics the data will be sent to.
        """
        return pulumi.get(self, "streams")

    @streams.setter
    def streams(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'KnownPerfCounterDataSourceStreams']]]]]):
        pulumi.set(self, "streams", value)


@pulumi.input_type
class PlatformTelemetryDataSourceArgs:
    def __init__(__self__, *,
                 streams: pulumi.Input[Sequence[pulumi.Input[str]]],
                 name: Optional[pulumi.Input[str]] = None):
        """
        Definition of platform telemetry data source configuration
        :param pulumi.Input[Sequence[pulumi.Input[str]]] streams: List of platform telemetry streams to collect
        :param pulumi.Input[str] name: A friendly name for the data source. 
               This name should be unique across all data sources (regardless of type) within the data collection rule.
        """
        pulumi.set(__self__, "streams", streams)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def streams(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        List of platform telemetry streams to collect
        """
        return pulumi.get(self, "streams")

    @streams.setter
    def streams(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "streams", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A friendly name for the data source. 
        This name should be unique across all data sources (regardless of type) within the data collection rule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class PrometheusForwarderDataSourceArgs:
    def __init__(__self__, *,
                 label_include_filter: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 streams: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'KnownPrometheusForwarderDataSourceStreams']]]]] = None):
        """
        Definition of Prometheus metrics forwarding configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] label_include_filter: The list of label inclusion filters in the form of label "name-value" pairs.
               Currently only one label is supported: 'microsoft_metrics_include_label'.
               Label values are matched case-insensitively.
        :param pulumi.Input[str] name: A friendly name for the data source. 
               This name should be unique across all data sources (regardless of type) within the data collection rule.
        :param pulumi.Input[Sequence[pulumi.Input[Union[str, 'KnownPrometheusForwarderDataSourceStreams']]]] streams: List of streams that this data source will be sent to.
        """
        if label_include_filter is not None:
            pulumi.set(__self__, "label_include_filter", label_include_filter)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if streams is not None:
            pulumi.set(__self__, "streams", streams)

    @property
    @pulumi.getter(name="labelIncludeFilter")
    def label_include_filter(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The list of label inclusion filters in the form of label "name-value" pairs.
        Currently only one label is supported: 'microsoft_metrics_include_label'.
        Label values are matched case-insensitively.
        """
        return pulumi.get(self, "label_include_filter")

    @label_include_filter.setter
    def label_include_filter(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "label_include_filter", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A friendly name for the data source. 
        This name should be unique across all data sources (regardless of type) within the data collection rule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def streams(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'KnownPrometheusForwarderDataSourceStreams']]]]]:
        """
        List of streams that this data source will be sent to.
        """
        return pulumi.get(self, "streams")

    @streams.setter
    def streams(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'KnownPrometheusForwarderDataSourceStreams']]]]]):
        pulumi.set(self, "streams", value)


@pulumi.input_type
class SmsReceiverArgs:
    def __init__(__self__, *,
                 country_code: pulumi.Input[str],
                 name: pulumi.Input[str],
                 phone_number: pulumi.Input[str]):
        """
        An SMS receiver.
        :param pulumi.Input[str] country_code: The country code of the SMS receiver.
        :param pulumi.Input[str] name: The name of the SMS receiver. Names must be unique across all receivers within an action group.
        :param pulumi.Input[str] phone_number: The phone number of the SMS receiver.
        """
        pulumi.set(__self__, "country_code", country_code)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "phone_number", phone_number)

    @property
    @pulumi.getter(name="countryCode")
    def country_code(self) -> pulumi.Input[str]:
        """
        The country code of the SMS receiver.
        """
        return pulumi.get(self, "country_code")

    @country_code.setter
    def country_code(self, value: pulumi.Input[str]):
        pulumi.set(self, "country_code", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the SMS receiver. Names must be unique across all receivers within an action group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="phoneNumber")
    def phone_number(self) -> pulumi.Input[str]:
        """
        The phone number of the SMS receiver.
        """
        return pulumi.get(self, "phone_number")

    @phone_number.setter
    def phone_number(self, value: pulumi.Input[str]):
        pulumi.set(self, "phone_number", value)


@pulumi.input_type
class StorageBlobDestinationArgs:
    def __init__(__self__, *,
                 container_name: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 storage_account_resource_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] container_name: The container name of the Storage Blob.
        :param pulumi.Input[str] name: A friendly name for the destination. 
               This name should be unique across all destinations (regardless of type) within the data collection rule.
        :param pulumi.Input[str] storage_account_resource_id: The resource ID of the storage account.
        """
        if container_name is not None:
            pulumi.set(__self__, "container_name", container_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if storage_account_resource_id is not None:
            pulumi.set(__self__, "storage_account_resource_id", storage_account_resource_id)

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> Optional[pulumi.Input[str]]:
        """
        The container name of the Storage Blob.
        """
        return pulumi.get(self, "container_name")

    @container_name.setter
    def container_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "container_name", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A friendly name for the destination. 
        This name should be unique across all destinations (regardless of type) within the data collection rule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="storageAccountResourceId")
    def storage_account_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        The resource ID of the storage account.
        """
        return pulumi.get(self, "storage_account_resource_id")

    @storage_account_resource_id.setter
    def storage_account_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_account_resource_id", value)


@pulumi.input_type
class StorageTableDestinationArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 storage_account_resource_id: Optional[pulumi.Input[str]] = None,
                 table_name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] name: A friendly name for the destination. 
               This name should be unique across all destinations (regardless of type) within the data collection rule.
        :param pulumi.Input[str] storage_account_resource_id: The resource ID of the storage account.
        :param pulumi.Input[str] table_name: The name of the Storage Table.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if storage_account_resource_id is not None:
            pulumi.set(__self__, "storage_account_resource_id", storage_account_resource_id)
        if table_name is not None:
            pulumi.set(__self__, "table_name", table_name)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A friendly name for the destination. 
        This name should be unique across all destinations (regardless of type) within the data collection rule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="storageAccountResourceId")
    def storage_account_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        The resource ID of the storage account.
        """
        return pulumi.get(self, "storage_account_resource_id")

    @storage_account_resource_id.setter
    def storage_account_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_account_resource_id", value)

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Storage Table.
        """
        return pulumi.get(self, "table_name")

    @table_name.setter
    def table_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "table_name", value)


@pulumi.input_type
class StreamDeclarationArgs:
    def __init__(__self__, *,
                 columns: Optional[pulumi.Input[Sequence[pulumi.Input['ColumnDefinitionArgs']]]] = None):
        """
        Declaration of a custom stream.
        :param pulumi.Input[Sequence[pulumi.Input['ColumnDefinitionArgs']]] columns: List of columns used by data in this stream.
        """
        if columns is not None:
            pulumi.set(__self__, "columns", columns)

    @property
    @pulumi.getter
    def columns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ColumnDefinitionArgs']]]]:
        """
        List of columns used by data in this stream.
        """
        return pulumi.get(self, "columns")

    @columns.setter
    def columns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ColumnDefinitionArgs']]]]):
        pulumi.set(self, "columns", value)


@pulumi.input_type
class SyslogDataSourceArgs:
    def __init__(__self__, *,
                 facility_names: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'KnownSyslogDataSourceFacilityNames']]]]] = None,
                 log_levels: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'KnownSyslogDataSourceLogLevels']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 streams: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'KnownSyslogDataSourceStreams']]]]] = None):
        """
        Definition of which syslog data will be collected and how it will be collected.
        Only collected from Linux machines.
        :param pulumi.Input[Sequence[pulumi.Input[Union[str, 'KnownSyslogDataSourceFacilityNames']]]] facility_names: The list of facility names.
        :param pulumi.Input[Sequence[pulumi.Input[Union[str, 'KnownSyslogDataSourceLogLevels']]]] log_levels: The log levels to collect.
        :param pulumi.Input[str] name: A friendly name for the data source. 
               This name should be unique across all data sources (regardless of type) within the data collection rule.
        :param pulumi.Input[Sequence[pulumi.Input[Union[str, 'KnownSyslogDataSourceStreams']]]] streams: List of streams that this data source will be sent to.
               A stream indicates what schema will be used for this data and usually what table in Log Analytics the data will be sent to.
        """
        if facility_names is not None:
            pulumi.set(__self__, "facility_names", facility_names)
        if log_levels is not None:
            pulumi.set(__self__, "log_levels", log_levels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if streams is not None:
            pulumi.set(__self__, "streams", streams)

    @property
    @pulumi.getter(name="facilityNames")
    def facility_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'KnownSyslogDataSourceFacilityNames']]]]]:
        """
        The list of facility names.
        """
        return pulumi.get(self, "facility_names")

    @facility_names.setter
    def facility_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'KnownSyslogDataSourceFacilityNames']]]]]):
        pulumi.set(self, "facility_names", value)

    @property
    @pulumi.getter(name="logLevels")
    def log_levels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'KnownSyslogDataSourceLogLevels']]]]]:
        """
        The log levels to collect.
        """
        return pulumi.get(self, "log_levels")

    @log_levels.setter
    def log_levels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'KnownSyslogDataSourceLogLevels']]]]]):
        pulumi.set(self, "log_levels", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A friendly name for the data source. 
        This name should be unique across all data sources (regardless of type) within the data collection rule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def streams(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'KnownSyslogDataSourceStreams']]]]]:
        """
        List of streams that this data source will be sent to.
        A stream indicates what schema will be used for this data and usually what table in Log Analytics the data will be sent to.
        """
        return pulumi.get(self, "streams")

    @streams.setter
    def streams(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'KnownSyslogDataSourceStreams']]]]]):
        pulumi.set(self, "streams", value)


@pulumi.input_type
class VoiceReceiverArgs:
    def __init__(__self__, *,
                 country_code: pulumi.Input[str],
                 name: pulumi.Input[str],
                 phone_number: pulumi.Input[str]):
        """
        A voice receiver.
        :param pulumi.Input[str] country_code: The country code of the voice receiver.
        :param pulumi.Input[str] name: The name of the voice receiver. Names must be unique across all receivers within an action group.
        :param pulumi.Input[str] phone_number: The phone number of the voice receiver.
        """
        pulumi.set(__self__, "country_code", country_code)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "phone_number", phone_number)

    @property
    @pulumi.getter(name="countryCode")
    def country_code(self) -> pulumi.Input[str]:
        """
        The country code of the voice receiver.
        """
        return pulumi.get(self, "country_code")

    @country_code.setter
    def country_code(self, value: pulumi.Input[str]):
        pulumi.set(self, "country_code", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the voice receiver. Names must be unique across all receivers within an action group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="phoneNumber")
    def phone_number(self) -> pulumi.Input[str]:
        """
        The phone number of the voice receiver.
        """
        return pulumi.get(self, "phone_number")

    @phone_number.setter
    def phone_number(self, value: pulumi.Input[str]):
        pulumi.set(self, "phone_number", value)


@pulumi.input_type
class WebhookReceiverArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 service_uri: pulumi.Input[str],
                 identifier_uri: Optional[pulumi.Input[str]] = None,
                 object_id: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 use_aad_auth: Optional[pulumi.Input[bool]] = None,
                 use_common_alert_schema: Optional[pulumi.Input[bool]] = None):
        """
        A webhook receiver.
        :param pulumi.Input[str] name: The name of the webhook receiver. Names must be unique across all receivers within an action group.
        :param pulumi.Input[str] service_uri: The URI where webhooks should be sent.
        :param pulumi.Input[str] identifier_uri: Indicates the identifier uri for aad auth.
        :param pulumi.Input[str] object_id: Indicates the webhook app object Id for aad auth.
        :param pulumi.Input[str] tenant_id: Indicates the tenant id for aad auth.
        :param pulumi.Input[bool] use_aad_auth: Indicates whether or not use AAD authentication.
        :param pulumi.Input[bool] use_common_alert_schema: Indicates whether to use common alert schema.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "service_uri", service_uri)
        if identifier_uri is not None:
            pulumi.set(__self__, "identifier_uri", identifier_uri)
        if object_id is not None:
            pulumi.set(__self__, "object_id", object_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if use_aad_auth is None:
            use_aad_auth = False
        if use_aad_auth is not None:
            pulumi.set(__self__, "use_aad_auth", use_aad_auth)
        if use_common_alert_schema is None:
            use_common_alert_schema = False
        if use_common_alert_schema is not None:
            pulumi.set(__self__, "use_common_alert_schema", use_common_alert_schema)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the webhook receiver. Names must be unique across all receivers within an action group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="serviceUri")
    def service_uri(self) -> pulumi.Input[str]:
        """
        The URI where webhooks should be sent.
        """
        return pulumi.get(self, "service_uri")

    @service_uri.setter
    def service_uri(self, value: pulumi.Input[str]):
        pulumi.set(self, "service_uri", value)

    @property
    @pulumi.getter(name="identifierUri")
    def identifier_uri(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates the identifier uri for aad auth.
        """
        return pulumi.get(self, "identifier_uri")

    @identifier_uri.setter
    def identifier_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "identifier_uri", value)

    @property
    @pulumi.getter(name="objectId")
    def object_id(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates the webhook app object Id for aad auth.
        """
        return pulumi.get(self, "object_id")

    @object_id.setter
    def object_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "object_id", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates the tenant id for aad auth.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="useAadAuth")
    def use_aad_auth(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether or not use AAD authentication.
        """
        return pulumi.get(self, "use_aad_auth")

    @use_aad_auth.setter
    def use_aad_auth(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_aad_auth", value)

    @property
    @pulumi.getter(name="useCommonAlertSchema")
    def use_common_alert_schema(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether to use common alert schema.
        """
        return pulumi.get(self, "use_common_alert_schema")

    @use_common_alert_schema.setter
    def use_common_alert_schema(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_common_alert_schema", value)


@pulumi.input_type
class WindowsEventLogDataSourceArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 streams: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'KnownWindowsEventLogDataSourceStreams']]]]] = None,
                 x_path_queries: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Definition of which Windows Event Log events will be collected and how they will be collected.
        Only collected from Windows machines.
        :param pulumi.Input[str] name: A friendly name for the data source. 
               This name should be unique across all data sources (regardless of type) within the data collection rule.
        :param pulumi.Input[Sequence[pulumi.Input[Union[str, 'KnownWindowsEventLogDataSourceStreams']]]] streams: List of streams that this data source will be sent to.
               A stream indicates what schema will be used for this data and usually what table in Log Analytics the data will be sent to.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] x_path_queries: A list of Windows Event Log queries in XPATH format.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if streams is not None:
            pulumi.set(__self__, "streams", streams)
        if x_path_queries is not None:
            pulumi.set(__self__, "x_path_queries", x_path_queries)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A friendly name for the data source. 
        This name should be unique across all data sources (regardless of type) within the data collection rule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def streams(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'KnownWindowsEventLogDataSourceStreams']]]]]:
        """
        List of streams that this data source will be sent to.
        A stream indicates what schema will be used for this data and usually what table in Log Analytics the data will be sent to.
        """
        return pulumi.get(self, "streams")

    @streams.setter
    def streams(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'KnownWindowsEventLogDataSourceStreams']]]]]):
        pulumi.set(self, "streams", value)

    @property
    @pulumi.getter(name="xPathQueries")
    def x_path_queries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of Windows Event Log queries in XPATH format.
        """
        return pulumi.get(self, "x_path_queries")

    @x_path_queries.setter
    def x_path_queries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "x_path_queries", value)


@pulumi.input_type
class WindowsFirewallLogsDataSourceArgs:
    def __init__(__self__, *,
                 streams: pulumi.Input[Sequence[pulumi.Input[str]]],
                 name: Optional[pulumi.Input[str]] = None):
        """
        Enables Firewall logs to be collected by this data collection rule.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] streams: Firewall logs streams
        :param pulumi.Input[str] name: A friendly name for the data source. 
               This name should be unique across all data sources (regardless of type) within the data collection rule.
        """
        pulumi.set(__self__, "streams", streams)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def streams(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Firewall logs streams
        """
        return pulumi.get(self, "streams")

    @streams.setter
    def streams(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "streams", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A friendly name for the data source. 
        This name should be unique across all data sources (regardless of type) within the data collection rule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


