# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from ._enums import *

__all__ = [
    'AsymmetricEncryptedSecretArgs',
    'BandwidthScheduleArgs',
    'ManagerIntrinsicSettingsArgs',
    'ManagerSkuArgs',
    'ScheduleRecurrenceArgs',
    'TimeArgs',
]

@pulumi.input_type
class AsymmetricEncryptedSecretArgs:
    def __init__(__self__, *,
                 encryption_algorithm: pulumi.Input['EncryptionAlgorithm'],
                 value: pulumi.Input[str],
                 encryption_cert_thumbprint: Optional[pulumi.Input[str]] = None):
        """
        Represent the secrets intended for encryption with asymmetric key pair.
        :param pulumi.Input['EncryptionAlgorithm'] encryption_algorithm: The algorithm used to encrypt "Value".
        :param pulumi.Input[str] value: The value of the secret.
        :param pulumi.Input[str] encryption_cert_thumbprint: Thumbprint certificate that was used to encrypt "Value". If the value in unencrypted, it will be null.
        """
        pulumi.set(__self__, "encryption_algorithm", encryption_algorithm)
        pulumi.set(__self__, "value", value)
        if encryption_cert_thumbprint is not None:
            pulumi.set(__self__, "encryption_cert_thumbprint", encryption_cert_thumbprint)

    @property
    @pulumi.getter(name="encryptionAlgorithm")
    def encryption_algorithm(self) -> pulumi.Input['EncryptionAlgorithm']:
        """
        The algorithm used to encrypt "Value".
        """
        return pulumi.get(self, "encryption_algorithm")

    @encryption_algorithm.setter
    def encryption_algorithm(self, value: pulumi.Input['EncryptionAlgorithm']):
        pulumi.set(self, "encryption_algorithm", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        The value of the secret.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter(name="encryptionCertThumbprint")
    def encryption_cert_thumbprint(self) -> Optional[pulumi.Input[str]]:
        """
        Thumbprint certificate that was used to encrypt "Value". If the value in unencrypted, it will be null.
        """
        return pulumi.get(self, "encryption_cert_thumbprint")

    @encryption_cert_thumbprint.setter
    def encryption_cert_thumbprint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "encryption_cert_thumbprint", value)


@pulumi.input_type
class BandwidthScheduleArgs:
    def __init__(__self__, *,
                 days: pulumi.Input[Sequence[pulumi.Input['DayOfWeek']]],
                 rate_in_mbps: pulumi.Input[int],
                 start: pulumi.Input['TimeArgs'],
                 stop: pulumi.Input['TimeArgs']):
        """
        The schedule for bandwidth setting.
        :param pulumi.Input[Sequence[pulumi.Input['DayOfWeek']]] days: The days of the week when this schedule is applicable.
        :param pulumi.Input[int] rate_in_mbps: The rate in Mbps.
        :param pulumi.Input['TimeArgs'] start: The start time of the schedule.
        :param pulumi.Input['TimeArgs'] stop: The stop time of the schedule.
        """
        pulumi.set(__self__, "days", days)
        pulumi.set(__self__, "rate_in_mbps", rate_in_mbps)
        pulumi.set(__self__, "start", start)
        pulumi.set(__self__, "stop", stop)

    @property
    @pulumi.getter
    def days(self) -> pulumi.Input[Sequence[pulumi.Input['DayOfWeek']]]:
        """
        The days of the week when this schedule is applicable.
        """
        return pulumi.get(self, "days")

    @days.setter
    def days(self, value: pulumi.Input[Sequence[pulumi.Input['DayOfWeek']]]):
        pulumi.set(self, "days", value)

    @property
    @pulumi.getter(name="rateInMbps")
    def rate_in_mbps(self) -> pulumi.Input[int]:
        """
        The rate in Mbps.
        """
        return pulumi.get(self, "rate_in_mbps")

    @rate_in_mbps.setter
    def rate_in_mbps(self, value: pulumi.Input[int]):
        pulumi.set(self, "rate_in_mbps", value)

    @property
    @pulumi.getter
    def start(self) -> pulumi.Input['TimeArgs']:
        """
        The start time of the schedule.
        """
        return pulumi.get(self, "start")

    @start.setter
    def start(self, value: pulumi.Input['TimeArgs']):
        pulumi.set(self, "start", value)

    @property
    @pulumi.getter
    def stop(self) -> pulumi.Input['TimeArgs']:
        """
        The stop time of the schedule.
        """
        return pulumi.get(self, "stop")

    @stop.setter
    def stop(self, value: pulumi.Input['TimeArgs']):
        pulumi.set(self, "stop", value)


@pulumi.input_type
class ManagerIntrinsicSettingsArgs:
    def __init__(__self__, *,
                 type: pulumi.Input['ManagerType']):
        """
        Intrinsic settings which refers to the type of the StorSimple Manager.
        :param pulumi.Input['ManagerType'] type: The type of StorSimple Manager.
        """
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input['ManagerType']:
        """
        The type of StorSimple Manager.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input['ManagerType']):
        pulumi.set(self, "type", value)


@pulumi.input_type
class ManagerSkuArgs:
    def __init__(__self__, *,
                 name: pulumi.Input['ManagerSkuType']):
        """
        The Sku.
        :param pulumi.Input['ManagerSkuType'] name: Refers to the sku name which should be "Standard"
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input['ManagerSkuType']:
        """
        Refers to the sku name which should be "Standard"
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input['ManagerSkuType']):
        pulumi.set(self, "name", value)


@pulumi.input_type
class ScheduleRecurrenceArgs:
    def __init__(__self__, *,
                 recurrence_type: pulumi.Input['RecurrenceType'],
                 recurrence_value: pulumi.Input[int],
                 weekly_days_list: Optional[pulumi.Input[Sequence[pulumi.Input['DayOfWeek']]]] = None):
        """
        The schedule recurrence.
        :param pulumi.Input['RecurrenceType'] recurrence_type: The recurrence type.
        :param pulumi.Input[int] recurrence_value: The recurrence value.
        :param pulumi.Input[Sequence[pulumi.Input['DayOfWeek']]] weekly_days_list: The week days list. Applicable only for schedules of recurrence type 'weekly'.
        """
        pulumi.set(__self__, "recurrence_type", recurrence_type)
        pulumi.set(__self__, "recurrence_value", recurrence_value)
        if weekly_days_list is not None:
            pulumi.set(__self__, "weekly_days_list", weekly_days_list)

    @property
    @pulumi.getter(name="recurrenceType")
    def recurrence_type(self) -> pulumi.Input['RecurrenceType']:
        """
        The recurrence type.
        """
        return pulumi.get(self, "recurrence_type")

    @recurrence_type.setter
    def recurrence_type(self, value: pulumi.Input['RecurrenceType']):
        pulumi.set(self, "recurrence_type", value)

    @property
    @pulumi.getter(name="recurrenceValue")
    def recurrence_value(self) -> pulumi.Input[int]:
        """
        The recurrence value.
        """
        return pulumi.get(self, "recurrence_value")

    @recurrence_value.setter
    def recurrence_value(self, value: pulumi.Input[int]):
        pulumi.set(self, "recurrence_value", value)

    @property
    @pulumi.getter(name="weeklyDaysList")
    def weekly_days_list(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DayOfWeek']]]]:
        """
        The week days list. Applicable only for schedules of recurrence type 'weekly'.
        """
        return pulumi.get(self, "weekly_days_list")

    @weekly_days_list.setter
    def weekly_days_list(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DayOfWeek']]]]):
        pulumi.set(self, "weekly_days_list", value)


@pulumi.input_type
class TimeArgs:
    def __init__(__self__, *,
                 hours: pulumi.Input[int],
                 minutes: pulumi.Input[int],
                 seconds: pulumi.Input[int]):
        """
        The time.
        :param pulumi.Input[int] hours: The hour.
        :param pulumi.Input[int] minutes: The minute.
        :param pulumi.Input[int] seconds: The second.
        """
        pulumi.set(__self__, "hours", hours)
        pulumi.set(__self__, "minutes", minutes)
        pulumi.set(__self__, "seconds", seconds)

    @property
    @pulumi.getter
    def hours(self) -> pulumi.Input[int]:
        """
        The hour.
        """
        return pulumi.get(self, "hours")

    @hours.setter
    def hours(self, value: pulumi.Input[int]):
        pulumi.set(self, "hours", value)

    @property
    @pulumi.getter
    def minutes(self) -> pulumi.Input[int]:
        """
        The minute.
        """
        return pulumi.get(self, "minutes")

    @minutes.setter
    def minutes(self, value: pulumi.Input[int]):
        pulumi.set(self, "minutes", value)

    @property
    @pulumi.getter
    def seconds(self) -> pulumi.Input[int]:
        """
        The second.
        """
        return pulumi.get(self, "seconds")

    @seconds.setter
    def seconds(self, value: pulumi.Input[int]):
        pulumi.set(self, "seconds", value)


