# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'AS2AcknowledgementConnectionSettingsArgs',
    'AS2AgreementContentArgs',
    'AS2EnvelopeSettingsArgs',
    'AS2ErrorSettingsArgs',
    'AS2MdnSettingsArgs',
    'AS2MessageConnectionSettingsArgs',
    'AS2OneWayAgreementArgs',
    'AS2ProtocolSettingsArgs',
    'AS2SecuritySettingsArgs',
    'AS2ValidationSettingsArgs',
    'AgreementContentArgs',
    'AssemblyPropertiesArgs',
    'B2BPartnerContentArgs',
    'BatchConfigurationPropertiesArgs',
    'BatchReleaseCriteriaArgs',
    'BusinessIdentityArgs',
    'ContentLinkArgs',
    'EdifactAcknowledgementSettingsArgs',
    'EdifactAgreementContentArgs',
    'EdifactDelimiterOverrideArgs',
    'EdifactEnvelopeOverrideArgs',
    'EdifactEnvelopeSettingsArgs',
    'EdifactFramingSettingsArgs',
    'EdifactMessageFilterArgs',
    'EdifactMessageIdentifierArgs',
    'EdifactOneWayAgreementArgs',
    'EdifactProcessingSettingsArgs',
    'EdifactProtocolSettingsArgs',
    'EdifactSchemaReferenceArgs',
    'EdifactValidationOverrideArgs',
    'EdifactValidationSettingsArgs',
    'FlowAccessControlConfigurationPolicyArgs',
    'FlowAccessControlConfigurationArgs',
    'FlowEndpointsConfigurationArgs',
    'FlowEndpointsArgs',
    'IntegrationAccountMapPropertiesParametersSchemaArgs',
    'IntegrationAccountSkuArgs',
    'IntegrationServiceEnvironmenEncryptionConfigurationArgs',
    'IntegrationServiceEnvironmenEncryptionKeyReferenceArgs',
    'IntegrationServiceEnvironmentAccessEndpointArgs',
    'IntegrationServiceEnvironmentManagedApiDeploymentParametersArgs',
    'IntegrationServiceEnvironmentPropertiesArgs',
    'IntegrationServiceEnvironmentSkuArgs',
    'IpAddressRangeArgs',
    'IpAddressArgs',
    'KeyVaultKeyReferenceKeyVaultArgs',
    'KeyVaultKeyReferenceArgs',
    'KeyVaultReference',
    'ManagedServiceIdentityArgs',
    'NetworkConfigurationArgs',
    'OpenAuthenticationAccessPoliciesArgs',
    'OpenAuthenticationAccessPolicyArgs',
    'OpenAuthenticationPolicyClaimArgs',
    'PartnerContentArgs',
    'RecurrenceScheduleOccurrenceArgs',
    'RecurrenceScheduleArgs',
    'ResourceReferenceArgs',
    'WorkflowParameterArgs',
    'WorkflowTriggerRecurrenceArgs',
    'X12AcknowledgementSettingsArgs',
    'X12AgreementContentArgs',
    'X12DelimiterOverridesArgs',
    'X12EnvelopeOverrideArgs',
    'X12EnvelopeSettingsArgs',
    'X12FramingSettingsArgs',
    'X12MessageFilterArgs',
    'X12MessageIdentifierArgs',
    'X12OneWayAgreementArgs',
    'X12ProcessingSettingsArgs',
    'X12ProtocolSettingsArgs',
    'X12SchemaReferenceArgs',
    'X12SecuritySettingsArgs',
    'X12ValidationOverrideArgs',
    'X12ValidationSettingsArgs',
]

@pulumi.input_type
class AS2AcknowledgementConnectionSettingsArgs:
    def __init__(__self__, *,
                 ignore_certificate_name_mismatch: pulumi.Input[bool],
                 keep_http_connection_alive: pulumi.Input[bool],
                 support_http_status_code_continue: pulumi.Input[bool],
                 unfold_http_headers: pulumi.Input[bool]):
        """
        The AS2 agreement acknowledgement connection settings.
        :param pulumi.Input[bool] ignore_certificate_name_mismatch: Indicates whether to ignore mismatch in certificate name.
        :param pulumi.Input[bool] keep_http_connection_alive: Indicates whether to keep the connection alive.
        :param pulumi.Input[bool] support_http_status_code_continue: Indicates whether to support HTTP status code 'CONTINUE'.
        :param pulumi.Input[bool] unfold_http_headers: Indicates whether to unfold the HTTP headers.
        """
        pulumi.set(__self__, "ignore_certificate_name_mismatch", ignore_certificate_name_mismatch)
        pulumi.set(__self__, "keep_http_connection_alive", keep_http_connection_alive)
        pulumi.set(__self__, "support_http_status_code_continue", support_http_status_code_continue)
        pulumi.set(__self__, "unfold_http_headers", unfold_http_headers)

    @property
    @pulumi.getter(name="ignoreCertificateNameMismatch")
    def ignore_certificate_name_mismatch(self) -> pulumi.Input[bool]:
        """
        Indicates whether to ignore mismatch in certificate name.
        """
        return pulumi.get(self, "ignore_certificate_name_mismatch")

    @ignore_certificate_name_mismatch.setter
    def ignore_certificate_name_mismatch(self, value: pulumi.Input[bool]):
        pulumi.set(self, "ignore_certificate_name_mismatch", value)

    @property
    @pulumi.getter(name="keepHttpConnectionAlive")
    def keep_http_connection_alive(self) -> pulumi.Input[bool]:
        """
        Indicates whether to keep the connection alive.
        """
        return pulumi.get(self, "keep_http_connection_alive")

    @keep_http_connection_alive.setter
    def keep_http_connection_alive(self, value: pulumi.Input[bool]):
        pulumi.set(self, "keep_http_connection_alive", value)

    @property
    @pulumi.getter(name="supportHttpStatusCodeContinue")
    def support_http_status_code_continue(self) -> pulumi.Input[bool]:
        """
        Indicates whether to support HTTP status code 'CONTINUE'.
        """
        return pulumi.get(self, "support_http_status_code_continue")

    @support_http_status_code_continue.setter
    def support_http_status_code_continue(self, value: pulumi.Input[bool]):
        pulumi.set(self, "support_http_status_code_continue", value)

    @property
    @pulumi.getter(name="unfoldHttpHeaders")
    def unfold_http_headers(self) -> pulumi.Input[bool]:
        """
        Indicates whether to unfold the HTTP headers.
        """
        return pulumi.get(self, "unfold_http_headers")

    @unfold_http_headers.setter
    def unfold_http_headers(self, value: pulumi.Input[bool]):
        pulumi.set(self, "unfold_http_headers", value)


@pulumi.input_type
class AS2AgreementContentArgs:
    def __init__(__self__, *,
                 receive_agreement: pulumi.Input['AS2OneWayAgreementArgs'],
                 send_agreement: pulumi.Input['AS2OneWayAgreementArgs']):
        """
        The integration account AS2 agreement content.
        :param pulumi.Input['AS2OneWayAgreementArgs'] receive_agreement: The AS2 one-way receive agreement.
        :param pulumi.Input['AS2OneWayAgreementArgs'] send_agreement: The AS2 one-way send agreement.
        """
        pulumi.set(__self__, "receive_agreement", receive_agreement)
        pulumi.set(__self__, "send_agreement", send_agreement)

    @property
    @pulumi.getter(name="receiveAgreement")
    def receive_agreement(self) -> pulumi.Input['AS2OneWayAgreementArgs']:
        """
        The AS2 one-way receive agreement.
        """
        return pulumi.get(self, "receive_agreement")

    @receive_agreement.setter
    def receive_agreement(self, value: pulumi.Input['AS2OneWayAgreementArgs']):
        pulumi.set(self, "receive_agreement", value)

    @property
    @pulumi.getter(name="sendAgreement")
    def send_agreement(self) -> pulumi.Input['AS2OneWayAgreementArgs']:
        """
        The AS2 one-way send agreement.
        """
        return pulumi.get(self, "send_agreement")

    @send_agreement.setter
    def send_agreement(self, value: pulumi.Input['AS2OneWayAgreementArgs']):
        pulumi.set(self, "send_agreement", value)


@pulumi.input_type
class AS2EnvelopeSettingsArgs:
    def __init__(__self__, *,
                 autogenerate_file_name: pulumi.Input[bool],
                 file_name_template: pulumi.Input[str],
                 message_content_type: pulumi.Input[str],
                 suspend_message_on_file_name_generation_error: pulumi.Input[bool],
                 transmit_file_name_in_mime_header: pulumi.Input[bool]):
        """
        The AS2 agreement envelope settings.
        :param pulumi.Input[bool] autogenerate_file_name: The value indicating whether to auto generate file name.
        :param pulumi.Input[str] file_name_template: The template for file name.
        :param pulumi.Input[str] message_content_type: The message content type.
        :param pulumi.Input[bool] suspend_message_on_file_name_generation_error: The value indicating whether to suspend message on file name generation error.
        :param pulumi.Input[bool] transmit_file_name_in_mime_header: The value indicating whether to transmit file name in mime header.
        """
        pulumi.set(__self__, "autogenerate_file_name", autogenerate_file_name)
        pulumi.set(__self__, "file_name_template", file_name_template)
        pulumi.set(__self__, "message_content_type", message_content_type)
        pulumi.set(__self__, "suspend_message_on_file_name_generation_error", suspend_message_on_file_name_generation_error)
        pulumi.set(__self__, "transmit_file_name_in_mime_header", transmit_file_name_in_mime_header)

    @property
    @pulumi.getter(name="autogenerateFileName")
    def autogenerate_file_name(self) -> pulumi.Input[bool]:
        """
        The value indicating whether to auto generate file name.
        """
        return pulumi.get(self, "autogenerate_file_name")

    @autogenerate_file_name.setter
    def autogenerate_file_name(self, value: pulumi.Input[bool]):
        pulumi.set(self, "autogenerate_file_name", value)

    @property
    @pulumi.getter(name="fileNameTemplate")
    def file_name_template(self) -> pulumi.Input[str]:
        """
        The template for file name.
        """
        return pulumi.get(self, "file_name_template")

    @file_name_template.setter
    def file_name_template(self, value: pulumi.Input[str]):
        pulumi.set(self, "file_name_template", value)

    @property
    @pulumi.getter(name="messageContentType")
    def message_content_type(self) -> pulumi.Input[str]:
        """
        The message content type.
        """
        return pulumi.get(self, "message_content_type")

    @message_content_type.setter
    def message_content_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "message_content_type", value)

    @property
    @pulumi.getter(name="suspendMessageOnFileNameGenerationError")
    def suspend_message_on_file_name_generation_error(self) -> pulumi.Input[bool]:
        """
        The value indicating whether to suspend message on file name generation error.
        """
        return pulumi.get(self, "suspend_message_on_file_name_generation_error")

    @suspend_message_on_file_name_generation_error.setter
    def suspend_message_on_file_name_generation_error(self, value: pulumi.Input[bool]):
        pulumi.set(self, "suspend_message_on_file_name_generation_error", value)

    @property
    @pulumi.getter(name="transmitFileNameInMimeHeader")
    def transmit_file_name_in_mime_header(self) -> pulumi.Input[bool]:
        """
        The value indicating whether to transmit file name in mime header.
        """
        return pulumi.get(self, "transmit_file_name_in_mime_header")

    @transmit_file_name_in_mime_header.setter
    def transmit_file_name_in_mime_header(self, value: pulumi.Input[bool]):
        pulumi.set(self, "transmit_file_name_in_mime_header", value)


@pulumi.input_type
class AS2ErrorSettingsArgs:
    def __init__(__self__, *,
                 resend_if_mdn_not_received: pulumi.Input[bool],
                 suspend_duplicate_message: pulumi.Input[bool]):
        """
        The AS2 agreement error settings.
        :param pulumi.Input[bool] resend_if_mdn_not_received: The value indicating whether to resend message If MDN is not received.
        :param pulumi.Input[bool] suspend_duplicate_message: The value indicating whether to suspend duplicate message.
        """
        pulumi.set(__self__, "resend_if_mdn_not_received", resend_if_mdn_not_received)
        pulumi.set(__self__, "suspend_duplicate_message", suspend_duplicate_message)

    @property
    @pulumi.getter(name="resendIfMDNNotReceived")
    def resend_if_mdn_not_received(self) -> pulumi.Input[bool]:
        """
        The value indicating whether to resend message If MDN is not received.
        """
        return pulumi.get(self, "resend_if_mdn_not_received")

    @resend_if_mdn_not_received.setter
    def resend_if_mdn_not_received(self, value: pulumi.Input[bool]):
        pulumi.set(self, "resend_if_mdn_not_received", value)

    @property
    @pulumi.getter(name="suspendDuplicateMessage")
    def suspend_duplicate_message(self) -> pulumi.Input[bool]:
        """
        The value indicating whether to suspend duplicate message.
        """
        return pulumi.get(self, "suspend_duplicate_message")

    @suspend_duplicate_message.setter
    def suspend_duplicate_message(self, value: pulumi.Input[bool]):
        pulumi.set(self, "suspend_duplicate_message", value)


@pulumi.input_type
class AS2MdnSettingsArgs:
    def __init__(__self__, *,
                 mic_hashing_algorithm: pulumi.Input[Union[str, 'HashingAlgorithm']],
                 need_mdn: pulumi.Input[bool],
                 send_inbound_mdn_to_message_box: pulumi.Input[bool],
                 send_mdnasynchronously: pulumi.Input[bool],
                 sign_mdn: pulumi.Input[bool],
                 sign_outbound_mdn_if_optional: pulumi.Input[bool],
                 disposition_notification_to: Optional[pulumi.Input[str]] = None,
                 mdn_text: Optional[pulumi.Input[str]] = None,
                 receipt_delivery_url: Optional[pulumi.Input[str]] = None):
        """
        The AS2 agreement mdn settings.
        :param pulumi.Input[Union[str, 'HashingAlgorithm']] mic_hashing_algorithm: The signing or hashing algorithm.
        :param pulumi.Input[bool] need_mdn: The value indicating whether to send or request a MDN.
        :param pulumi.Input[bool] send_inbound_mdn_to_message_box: The value indicating whether to send inbound MDN to message box.
        :param pulumi.Input[bool] send_mdnasynchronously: The value indicating whether to send the asynchronous MDN.
        :param pulumi.Input[bool] sign_mdn: The value indicating whether the MDN needs to be signed or not.
        :param pulumi.Input[bool] sign_outbound_mdn_if_optional: The value indicating whether to sign the outbound MDN if optional.
        :param pulumi.Input[str] disposition_notification_to: The disposition notification to header value.
        :param pulumi.Input[str] mdn_text: The MDN text.
        :param pulumi.Input[str] receipt_delivery_url: The receipt delivery URL.
        """
        pulumi.set(__self__, "mic_hashing_algorithm", mic_hashing_algorithm)
        pulumi.set(__self__, "need_mdn", need_mdn)
        pulumi.set(__self__, "send_inbound_mdn_to_message_box", send_inbound_mdn_to_message_box)
        pulumi.set(__self__, "send_mdnasynchronously", send_mdnasynchronously)
        pulumi.set(__self__, "sign_mdn", sign_mdn)
        pulumi.set(__self__, "sign_outbound_mdn_if_optional", sign_outbound_mdn_if_optional)
        if disposition_notification_to is not None:
            pulumi.set(__self__, "disposition_notification_to", disposition_notification_to)
        if mdn_text is not None:
            pulumi.set(__self__, "mdn_text", mdn_text)
        if receipt_delivery_url is not None:
            pulumi.set(__self__, "receipt_delivery_url", receipt_delivery_url)

    @property
    @pulumi.getter(name="micHashingAlgorithm")
    def mic_hashing_algorithm(self) -> pulumi.Input[Union[str, 'HashingAlgorithm']]:
        """
        The signing or hashing algorithm.
        """
        return pulumi.get(self, "mic_hashing_algorithm")

    @mic_hashing_algorithm.setter
    def mic_hashing_algorithm(self, value: pulumi.Input[Union[str, 'HashingAlgorithm']]):
        pulumi.set(self, "mic_hashing_algorithm", value)

    @property
    @pulumi.getter(name="needMDN")
    def need_mdn(self) -> pulumi.Input[bool]:
        """
        The value indicating whether to send or request a MDN.
        """
        return pulumi.get(self, "need_mdn")

    @need_mdn.setter
    def need_mdn(self, value: pulumi.Input[bool]):
        pulumi.set(self, "need_mdn", value)

    @property
    @pulumi.getter(name="sendInboundMDNToMessageBox")
    def send_inbound_mdn_to_message_box(self) -> pulumi.Input[bool]:
        """
        The value indicating whether to send inbound MDN to message box.
        """
        return pulumi.get(self, "send_inbound_mdn_to_message_box")

    @send_inbound_mdn_to_message_box.setter
    def send_inbound_mdn_to_message_box(self, value: pulumi.Input[bool]):
        pulumi.set(self, "send_inbound_mdn_to_message_box", value)

    @property
    @pulumi.getter(name="sendMDNAsynchronously")
    def send_mdnasynchronously(self) -> pulumi.Input[bool]:
        """
        The value indicating whether to send the asynchronous MDN.
        """
        return pulumi.get(self, "send_mdnasynchronously")

    @send_mdnasynchronously.setter
    def send_mdnasynchronously(self, value: pulumi.Input[bool]):
        pulumi.set(self, "send_mdnasynchronously", value)

    @property
    @pulumi.getter(name="signMDN")
    def sign_mdn(self) -> pulumi.Input[bool]:
        """
        The value indicating whether the MDN needs to be signed or not.
        """
        return pulumi.get(self, "sign_mdn")

    @sign_mdn.setter
    def sign_mdn(self, value: pulumi.Input[bool]):
        pulumi.set(self, "sign_mdn", value)

    @property
    @pulumi.getter(name="signOutboundMDNIfOptional")
    def sign_outbound_mdn_if_optional(self) -> pulumi.Input[bool]:
        """
        The value indicating whether to sign the outbound MDN if optional.
        """
        return pulumi.get(self, "sign_outbound_mdn_if_optional")

    @sign_outbound_mdn_if_optional.setter
    def sign_outbound_mdn_if_optional(self, value: pulumi.Input[bool]):
        pulumi.set(self, "sign_outbound_mdn_if_optional", value)

    @property
    @pulumi.getter(name="dispositionNotificationTo")
    def disposition_notification_to(self) -> Optional[pulumi.Input[str]]:
        """
        The disposition notification to header value.
        """
        return pulumi.get(self, "disposition_notification_to")

    @disposition_notification_to.setter
    def disposition_notification_to(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "disposition_notification_to", value)

    @property
    @pulumi.getter(name="mdnText")
    def mdn_text(self) -> Optional[pulumi.Input[str]]:
        """
        The MDN text.
        """
        return pulumi.get(self, "mdn_text")

    @mdn_text.setter
    def mdn_text(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mdn_text", value)

    @property
    @pulumi.getter(name="receiptDeliveryUrl")
    def receipt_delivery_url(self) -> Optional[pulumi.Input[str]]:
        """
        The receipt delivery URL.
        """
        return pulumi.get(self, "receipt_delivery_url")

    @receipt_delivery_url.setter
    def receipt_delivery_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "receipt_delivery_url", value)


@pulumi.input_type
class AS2MessageConnectionSettingsArgs:
    def __init__(__self__, *,
                 ignore_certificate_name_mismatch: pulumi.Input[bool],
                 keep_http_connection_alive: pulumi.Input[bool],
                 support_http_status_code_continue: pulumi.Input[bool],
                 unfold_http_headers: pulumi.Input[bool]):
        """
        The AS2 agreement message connection settings.
        :param pulumi.Input[bool] ignore_certificate_name_mismatch: The value indicating whether to ignore mismatch in certificate name.
        :param pulumi.Input[bool] keep_http_connection_alive: The value indicating whether to keep the connection alive.
        :param pulumi.Input[bool] support_http_status_code_continue: The value indicating whether to support HTTP status code 'CONTINUE'.
        :param pulumi.Input[bool] unfold_http_headers: The value indicating whether to unfold the HTTP headers.
        """
        pulumi.set(__self__, "ignore_certificate_name_mismatch", ignore_certificate_name_mismatch)
        pulumi.set(__self__, "keep_http_connection_alive", keep_http_connection_alive)
        pulumi.set(__self__, "support_http_status_code_continue", support_http_status_code_continue)
        pulumi.set(__self__, "unfold_http_headers", unfold_http_headers)

    @property
    @pulumi.getter(name="ignoreCertificateNameMismatch")
    def ignore_certificate_name_mismatch(self) -> pulumi.Input[bool]:
        """
        The value indicating whether to ignore mismatch in certificate name.
        """
        return pulumi.get(self, "ignore_certificate_name_mismatch")

    @ignore_certificate_name_mismatch.setter
    def ignore_certificate_name_mismatch(self, value: pulumi.Input[bool]):
        pulumi.set(self, "ignore_certificate_name_mismatch", value)

    @property
    @pulumi.getter(name="keepHttpConnectionAlive")
    def keep_http_connection_alive(self) -> pulumi.Input[bool]:
        """
        The value indicating whether to keep the connection alive.
        """
        return pulumi.get(self, "keep_http_connection_alive")

    @keep_http_connection_alive.setter
    def keep_http_connection_alive(self, value: pulumi.Input[bool]):
        pulumi.set(self, "keep_http_connection_alive", value)

    @property
    @pulumi.getter(name="supportHttpStatusCodeContinue")
    def support_http_status_code_continue(self) -> pulumi.Input[bool]:
        """
        The value indicating whether to support HTTP status code 'CONTINUE'.
        """
        return pulumi.get(self, "support_http_status_code_continue")

    @support_http_status_code_continue.setter
    def support_http_status_code_continue(self, value: pulumi.Input[bool]):
        pulumi.set(self, "support_http_status_code_continue", value)

    @property
    @pulumi.getter(name="unfoldHttpHeaders")
    def unfold_http_headers(self) -> pulumi.Input[bool]:
        """
        The value indicating whether to unfold the HTTP headers.
        """
        return pulumi.get(self, "unfold_http_headers")

    @unfold_http_headers.setter
    def unfold_http_headers(self, value: pulumi.Input[bool]):
        pulumi.set(self, "unfold_http_headers", value)


@pulumi.input_type
class AS2OneWayAgreementArgs:
    def __init__(__self__, *,
                 protocol_settings: pulumi.Input['AS2ProtocolSettingsArgs'],
                 receiver_business_identity: pulumi.Input['BusinessIdentityArgs'],
                 sender_business_identity: pulumi.Input['BusinessIdentityArgs']):
        """
        The integration account AS2 one-way agreement.
        :param pulumi.Input['AS2ProtocolSettingsArgs'] protocol_settings: The AS2 protocol settings.
        :param pulumi.Input['BusinessIdentityArgs'] receiver_business_identity: The receiver business identity
        :param pulumi.Input['BusinessIdentityArgs'] sender_business_identity: The sender business identity
        """
        pulumi.set(__self__, "protocol_settings", protocol_settings)
        pulumi.set(__self__, "receiver_business_identity", receiver_business_identity)
        pulumi.set(__self__, "sender_business_identity", sender_business_identity)

    @property
    @pulumi.getter(name="protocolSettings")
    def protocol_settings(self) -> pulumi.Input['AS2ProtocolSettingsArgs']:
        """
        The AS2 protocol settings.
        """
        return pulumi.get(self, "protocol_settings")

    @protocol_settings.setter
    def protocol_settings(self, value: pulumi.Input['AS2ProtocolSettingsArgs']):
        pulumi.set(self, "protocol_settings", value)

    @property
    @pulumi.getter(name="receiverBusinessIdentity")
    def receiver_business_identity(self) -> pulumi.Input['BusinessIdentityArgs']:
        """
        The receiver business identity
        """
        return pulumi.get(self, "receiver_business_identity")

    @receiver_business_identity.setter
    def receiver_business_identity(self, value: pulumi.Input['BusinessIdentityArgs']):
        pulumi.set(self, "receiver_business_identity", value)

    @property
    @pulumi.getter(name="senderBusinessIdentity")
    def sender_business_identity(self) -> pulumi.Input['BusinessIdentityArgs']:
        """
        The sender business identity
        """
        return pulumi.get(self, "sender_business_identity")

    @sender_business_identity.setter
    def sender_business_identity(self, value: pulumi.Input['BusinessIdentityArgs']):
        pulumi.set(self, "sender_business_identity", value)


@pulumi.input_type
class AS2ProtocolSettingsArgs:
    def __init__(__self__, *,
                 acknowledgement_connection_settings: pulumi.Input['AS2AcknowledgementConnectionSettingsArgs'],
                 envelope_settings: pulumi.Input['AS2EnvelopeSettingsArgs'],
                 error_settings: pulumi.Input['AS2ErrorSettingsArgs'],
                 mdn_settings: pulumi.Input['AS2MdnSettingsArgs'],
                 message_connection_settings: pulumi.Input['AS2MessageConnectionSettingsArgs'],
                 security_settings: pulumi.Input['AS2SecuritySettingsArgs'],
                 validation_settings: pulumi.Input['AS2ValidationSettingsArgs']):
        """
        The AS2 agreement protocol settings.
        :param pulumi.Input['AS2AcknowledgementConnectionSettingsArgs'] acknowledgement_connection_settings: The acknowledgement connection settings.
        :param pulumi.Input['AS2EnvelopeSettingsArgs'] envelope_settings: The envelope settings.
        :param pulumi.Input['AS2ErrorSettingsArgs'] error_settings: The error settings.
        :param pulumi.Input['AS2MdnSettingsArgs'] mdn_settings: The MDN settings.
        :param pulumi.Input['AS2MessageConnectionSettingsArgs'] message_connection_settings: The message connection settings.
        :param pulumi.Input['AS2SecuritySettingsArgs'] security_settings: The security settings.
        :param pulumi.Input['AS2ValidationSettingsArgs'] validation_settings: The validation settings.
        """
        pulumi.set(__self__, "acknowledgement_connection_settings", acknowledgement_connection_settings)
        pulumi.set(__self__, "envelope_settings", envelope_settings)
        pulumi.set(__self__, "error_settings", error_settings)
        pulumi.set(__self__, "mdn_settings", mdn_settings)
        pulumi.set(__self__, "message_connection_settings", message_connection_settings)
        pulumi.set(__self__, "security_settings", security_settings)
        pulumi.set(__self__, "validation_settings", validation_settings)

    @property
    @pulumi.getter(name="acknowledgementConnectionSettings")
    def acknowledgement_connection_settings(self) -> pulumi.Input['AS2AcknowledgementConnectionSettingsArgs']:
        """
        The acknowledgement connection settings.
        """
        return pulumi.get(self, "acknowledgement_connection_settings")

    @acknowledgement_connection_settings.setter
    def acknowledgement_connection_settings(self, value: pulumi.Input['AS2AcknowledgementConnectionSettingsArgs']):
        pulumi.set(self, "acknowledgement_connection_settings", value)

    @property
    @pulumi.getter(name="envelopeSettings")
    def envelope_settings(self) -> pulumi.Input['AS2EnvelopeSettingsArgs']:
        """
        The envelope settings.
        """
        return pulumi.get(self, "envelope_settings")

    @envelope_settings.setter
    def envelope_settings(self, value: pulumi.Input['AS2EnvelopeSettingsArgs']):
        pulumi.set(self, "envelope_settings", value)

    @property
    @pulumi.getter(name="errorSettings")
    def error_settings(self) -> pulumi.Input['AS2ErrorSettingsArgs']:
        """
        The error settings.
        """
        return pulumi.get(self, "error_settings")

    @error_settings.setter
    def error_settings(self, value: pulumi.Input['AS2ErrorSettingsArgs']):
        pulumi.set(self, "error_settings", value)

    @property
    @pulumi.getter(name="mdnSettings")
    def mdn_settings(self) -> pulumi.Input['AS2MdnSettingsArgs']:
        """
        The MDN settings.
        """
        return pulumi.get(self, "mdn_settings")

    @mdn_settings.setter
    def mdn_settings(self, value: pulumi.Input['AS2MdnSettingsArgs']):
        pulumi.set(self, "mdn_settings", value)

    @property
    @pulumi.getter(name="messageConnectionSettings")
    def message_connection_settings(self) -> pulumi.Input['AS2MessageConnectionSettingsArgs']:
        """
        The message connection settings.
        """
        return pulumi.get(self, "message_connection_settings")

    @message_connection_settings.setter
    def message_connection_settings(self, value: pulumi.Input['AS2MessageConnectionSettingsArgs']):
        pulumi.set(self, "message_connection_settings", value)

    @property
    @pulumi.getter(name="securitySettings")
    def security_settings(self) -> pulumi.Input['AS2SecuritySettingsArgs']:
        """
        The security settings.
        """
        return pulumi.get(self, "security_settings")

    @security_settings.setter
    def security_settings(self, value: pulumi.Input['AS2SecuritySettingsArgs']):
        pulumi.set(self, "security_settings", value)

    @property
    @pulumi.getter(name="validationSettings")
    def validation_settings(self) -> pulumi.Input['AS2ValidationSettingsArgs']:
        """
        The validation settings.
        """
        return pulumi.get(self, "validation_settings")

    @validation_settings.setter
    def validation_settings(self, value: pulumi.Input['AS2ValidationSettingsArgs']):
        pulumi.set(self, "validation_settings", value)


@pulumi.input_type
class AS2SecuritySettingsArgs:
    def __init__(__self__, *,
                 enable_nrr_for_inbound_decoded_messages: pulumi.Input[bool],
                 enable_nrr_for_inbound_encoded_messages: pulumi.Input[bool],
                 enable_nrr_for_inbound_mdn: pulumi.Input[bool],
                 enable_nrr_for_outbound_decoded_messages: pulumi.Input[bool],
                 enable_nrr_for_outbound_encoded_messages: pulumi.Input[bool],
                 enable_nrr_for_outbound_mdn: pulumi.Input[bool],
                 override_group_signing_certificate: pulumi.Input[bool],
                 encryption_certificate_name: Optional[pulumi.Input[str]] = None,
                 sha2_algorithm_format: Optional[pulumi.Input[str]] = None,
                 signing_certificate_name: Optional[pulumi.Input[str]] = None):
        """
        The AS2 agreement security settings.
        :param pulumi.Input[bool] enable_nrr_for_inbound_decoded_messages: The value indicating whether to enable NRR for inbound decoded messages.
        :param pulumi.Input[bool] enable_nrr_for_inbound_encoded_messages: The value indicating whether to enable NRR for inbound encoded messages.
        :param pulumi.Input[bool] enable_nrr_for_inbound_mdn: The value indicating whether to enable NRR for inbound MDN.
        :param pulumi.Input[bool] enable_nrr_for_outbound_decoded_messages: The value indicating whether to enable NRR for outbound decoded messages.
        :param pulumi.Input[bool] enable_nrr_for_outbound_encoded_messages: The value indicating whether to enable NRR for outbound encoded messages.
        :param pulumi.Input[bool] enable_nrr_for_outbound_mdn: The value indicating whether to enable NRR for outbound MDN.
        :param pulumi.Input[bool] override_group_signing_certificate: The value indicating whether to send or request a MDN.
        :param pulumi.Input[str] encryption_certificate_name: The name of the encryption certificate.
        :param pulumi.Input[str] sha2_algorithm_format: The Sha2 algorithm format. Valid values are Sha2, ShaHashSize, ShaHyphenHashSize, Sha2UnderscoreHashSize.
        :param pulumi.Input[str] signing_certificate_name: The name of the signing certificate.
        """
        pulumi.set(__self__, "enable_nrr_for_inbound_decoded_messages", enable_nrr_for_inbound_decoded_messages)
        pulumi.set(__self__, "enable_nrr_for_inbound_encoded_messages", enable_nrr_for_inbound_encoded_messages)
        pulumi.set(__self__, "enable_nrr_for_inbound_mdn", enable_nrr_for_inbound_mdn)
        pulumi.set(__self__, "enable_nrr_for_outbound_decoded_messages", enable_nrr_for_outbound_decoded_messages)
        pulumi.set(__self__, "enable_nrr_for_outbound_encoded_messages", enable_nrr_for_outbound_encoded_messages)
        pulumi.set(__self__, "enable_nrr_for_outbound_mdn", enable_nrr_for_outbound_mdn)
        pulumi.set(__self__, "override_group_signing_certificate", override_group_signing_certificate)
        if encryption_certificate_name is not None:
            pulumi.set(__self__, "encryption_certificate_name", encryption_certificate_name)
        if sha2_algorithm_format is not None:
            pulumi.set(__self__, "sha2_algorithm_format", sha2_algorithm_format)
        if signing_certificate_name is not None:
            pulumi.set(__self__, "signing_certificate_name", signing_certificate_name)

    @property
    @pulumi.getter(name="enableNRRForInboundDecodedMessages")
    def enable_nrr_for_inbound_decoded_messages(self) -> pulumi.Input[bool]:
        """
        The value indicating whether to enable NRR for inbound decoded messages.
        """
        return pulumi.get(self, "enable_nrr_for_inbound_decoded_messages")

    @enable_nrr_for_inbound_decoded_messages.setter
    def enable_nrr_for_inbound_decoded_messages(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enable_nrr_for_inbound_decoded_messages", value)

    @property
    @pulumi.getter(name="enableNRRForInboundEncodedMessages")
    def enable_nrr_for_inbound_encoded_messages(self) -> pulumi.Input[bool]:
        """
        The value indicating whether to enable NRR for inbound encoded messages.
        """
        return pulumi.get(self, "enable_nrr_for_inbound_encoded_messages")

    @enable_nrr_for_inbound_encoded_messages.setter
    def enable_nrr_for_inbound_encoded_messages(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enable_nrr_for_inbound_encoded_messages", value)

    @property
    @pulumi.getter(name="enableNRRForInboundMDN")
    def enable_nrr_for_inbound_mdn(self) -> pulumi.Input[bool]:
        """
        The value indicating whether to enable NRR for inbound MDN.
        """
        return pulumi.get(self, "enable_nrr_for_inbound_mdn")

    @enable_nrr_for_inbound_mdn.setter
    def enable_nrr_for_inbound_mdn(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enable_nrr_for_inbound_mdn", value)

    @property
    @pulumi.getter(name="enableNRRForOutboundDecodedMessages")
    def enable_nrr_for_outbound_decoded_messages(self) -> pulumi.Input[bool]:
        """
        The value indicating whether to enable NRR for outbound decoded messages.
        """
        return pulumi.get(self, "enable_nrr_for_outbound_decoded_messages")

    @enable_nrr_for_outbound_decoded_messages.setter
    def enable_nrr_for_outbound_decoded_messages(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enable_nrr_for_outbound_decoded_messages", value)

    @property
    @pulumi.getter(name="enableNRRForOutboundEncodedMessages")
    def enable_nrr_for_outbound_encoded_messages(self) -> pulumi.Input[bool]:
        """
        The value indicating whether to enable NRR for outbound encoded messages.
        """
        return pulumi.get(self, "enable_nrr_for_outbound_encoded_messages")

    @enable_nrr_for_outbound_encoded_messages.setter
    def enable_nrr_for_outbound_encoded_messages(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enable_nrr_for_outbound_encoded_messages", value)

    @property
    @pulumi.getter(name="enableNRRForOutboundMDN")
    def enable_nrr_for_outbound_mdn(self) -> pulumi.Input[bool]:
        """
        The value indicating whether to enable NRR for outbound MDN.
        """
        return pulumi.get(self, "enable_nrr_for_outbound_mdn")

    @enable_nrr_for_outbound_mdn.setter
    def enable_nrr_for_outbound_mdn(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enable_nrr_for_outbound_mdn", value)

    @property
    @pulumi.getter(name="overrideGroupSigningCertificate")
    def override_group_signing_certificate(self) -> pulumi.Input[bool]:
        """
        The value indicating whether to send or request a MDN.
        """
        return pulumi.get(self, "override_group_signing_certificate")

    @override_group_signing_certificate.setter
    def override_group_signing_certificate(self, value: pulumi.Input[bool]):
        pulumi.set(self, "override_group_signing_certificate", value)

    @property
    @pulumi.getter(name="encryptionCertificateName")
    def encryption_certificate_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the encryption certificate.
        """
        return pulumi.get(self, "encryption_certificate_name")

    @encryption_certificate_name.setter
    def encryption_certificate_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "encryption_certificate_name", value)

    @property
    @pulumi.getter(name="sha2AlgorithmFormat")
    def sha2_algorithm_format(self) -> Optional[pulumi.Input[str]]:
        """
        The Sha2 algorithm format. Valid values are Sha2, ShaHashSize, ShaHyphenHashSize, Sha2UnderscoreHashSize.
        """
        return pulumi.get(self, "sha2_algorithm_format")

    @sha2_algorithm_format.setter
    def sha2_algorithm_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sha2_algorithm_format", value)

    @property
    @pulumi.getter(name="signingCertificateName")
    def signing_certificate_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the signing certificate.
        """
        return pulumi.get(self, "signing_certificate_name")

    @signing_certificate_name.setter
    def signing_certificate_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "signing_certificate_name", value)


@pulumi.input_type
class AS2ValidationSettingsArgs:
    def __init__(__self__, *,
                 check_certificate_revocation_list_on_receive: pulumi.Input[bool],
                 check_certificate_revocation_list_on_send: pulumi.Input[bool],
                 check_duplicate_message: pulumi.Input[bool],
                 compress_message: pulumi.Input[bool],
                 encrypt_message: pulumi.Input[bool],
                 encryption_algorithm: pulumi.Input[Union[str, 'EncryptionAlgorithm']],
                 interchange_duplicates_validity_days: pulumi.Input[int],
                 override_message_properties: pulumi.Input[bool],
                 sign_message: pulumi.Input[bool],
                 signing_algorithm: Optional[pulumi.Input[Union[str, 'SigningAlgorithm']]] = None):
        """
        The AS2 agreement validation settings.
        :param pulumi.Input[bool] check_certificate_revocation_list_on_receive: The value indicating whether to check for certificate revocation list on receive.
        :param pulumi.Input[bool] check_certificate_revocation_list_on_send: The value indicating whether to check for certificate revocation list on send.
        :param pulumi.Input[bool] check_duplicate_message: The value indicating whether to check for duplicate message.
        :param pulumi.Input[bool] compress_message: The value indicating whether the message has to be compressed.
        :param pulumi.Input[bool] encrypt_message: The value indicating whether the message has to be encrypted.
        :param pulumi.Input[Union[str, 'EncryptionAlgorithm']] encryption_algorithm: The encryption algorithm.
        :param pulumi.Input[int] interchange_duplicates_validity_days: The number of days to look back for duplicate interchange.
        :param pulumi.Input[bool] override_message_properties: The value indicating whether to override incoming message properties with those in agreement.
        :param pulumi.Input[bool] sign_message: The value indicating whether the message has to be signed.
        :param pulumi.Input[Union[str, 'SigningAlgorithm']] signing_algorithm: The signing algorithm.
        """
        pulumi.set(__self__, "check_certificate_revocation_list_on_receive", check_certificate_revocation_list_on_receive)
        pulumi.set(__self__, "check_certificate_revocation_list_on_send", check_certificate_revocation_list_on_send)
        pulumi.set(__self__, "check_duplicate_message", check_duplicate_message)
        pulumi.set(__self__, "compress_message", compress_message)
        pulumi.set(__self__, "encrypt_message", encrypt_message)
        pulumi.set(__self__, "encryption_algorithm", encryption_algorithm)
        pulumi.set(__self__, "interchange_duplicates_validity_days", interchange_duplicates_validity_days)
        pulumi.set(__self__, "override_message_properties", override_message_properties)
        pulumi.set(__self__, "sign_message", sign_message)
        if signing_algorithm is not None:
            pulumi.set(__self__, "signing_algorithm", signing_algorithm)

    @property
    @pulumi.getter(name="checkCertificateRevocationListOnReceive")
    def check_certificate_revocation_list_on_receive(self) -> pulumi.Input[bool]:
        """
        The value indicating whether to check for certificate revocation list on receive.
        """
        return pulumi.get(self, "check_certificate_revocation_list_on_receive")

    @check_certificate_revocation_list_on_receive.setter
    def check_certificate_revocation_list_on_receive(self, value: pulumi.Input[bool]):
        pulumi.set(self, "check_certificate_revocation_list_on_receive", value)

    @property
    @pulumi.getter(name="checkCertificateRevocationListOnSend")
    def check_certificate_revocation_list_on_send(self) -> pulumi.Input[bool]:
        """
        The value indicating whether to check for certificate revocation list on send.
        """
        return pulumi.get(self, "check_certificate_revocation_list_on_send")

    @check_certificate_revocation_list_on_send.setter
    def check_certificate_revocation_list_on_send(self, value: pulumi.Input[bool]):
        pulumi.set(self, "check_certificate_revocation_list_on_send", value)

    @property
    @pulumi.getter(name="checkDuplicateMessage")
    def check_duplicate_message(self) -> pulumi.Input[bool]:
        """
        The value indicating whether to check for duplicate message.
        """
        return pulumi.get(self, "check_duplicate_message")

    @check_duplicate_message.setter
    def check_duplicate_message(self, value: pulumi.Input[bool]):
        pulumi.set(self, "check_duplicate_message", value)

    @property
    @pulumi.getter(name="compressMessage")
    def compress_message(self) -> pulumi.Input[bool]:
        """
        The value indicating whether the message has to be compressed.
        """
        return pulumi.get(self, "compress_message")

    @compress_message.setter
    def compress_message(self, value: pulumi.Input[bool]):
        pulumi.set(self, "compress_message", value)

    @property
    @pulumi.getter(name="encryptMessage")
    def encrypt_message(self) -> pulumi.Input[bool]:
        """
        The value indicating whether the message has to be encrypted.
        """
        return pulumi.get(self, "encrypt_message")

    @encrypt_message.setter
    def encrypt_message(self, value: pulumi.Input[bool]):
        pulumi.set(self, "encrypt_message", value)

    @property
    @pulumi.getter(name="encryptionAlgorithm")
    def encryption_algorithm(self) -> pulumi.Input[Union[str, 'EncryptionAlgorithm']]:
        """
        The encryption algorithm.
        """
        return pulumi.get(self, "encryption_algorithm")

    @encryption_algorithm.setter
    def encryption_algorithm(self, value: pulumi.Input[Union[str, 'EncryptionAlgorithm']]):
        pulumi.set(self, "encryption_algorithm", value)

    @property
    @pulumi.getter(name="interchangeDuplicatesValidityDays")
    def interchange_duplicates_validity_days(self) -> pulumi.Input[int]:
        """
        The number of days to look back for duplicate interchange.
        """
        return pulumi.get(self, "interchange_duplicates_validity_days")

    @interchange_duplicates_validity_days.setter
    def interchange_duplicates_validity_days(self, value: pulumi.Input[int]):
        pulumi.set(self, "interchange_duplicates_validity_days", value)

    @property
    @pulumi.getter(name="overrideMessageProperties")
    def override_message_properties(self) -> pulumi.Input[bool]:
        """
        The value indicating whether to override incoming message properties with those in agreement.
        """
        return pulumi.get(self, "override_message_properties")

    @override_message_properties.setter
    def override_message_properties(self, value: pulumi.Input[bool]):
        pulumi.set(self, "override_message_properties", value)

    @property
    @pulumi.getter(name="signMessage")
    def sign_message(self) -> pulumi.Input[bool]:
        """
        The value indicating whether the message has to be signed.
        """
        return pulumi.get(self, "sign_message")

    @sign_message.setter
    def sign_message(self, value: pulumi.Input[bool]):
        pulumi.set(self, "sign_message", value)

    @property
    @pulumi.getter(name="signingAlgorithm")
    def signing_algorithm(self) -> Optional[pulumi.Input[Union[str, 'SigningAlgorithm']]]:
        """
        The signing algorithm.
        """
        return pulumi.get(self, "signing_algorithm")

    @signing_algorithm.setter
    def signing_algorithm(self, value: Optional[pulumi.Input[Union[str, 'SigningAlgorithm']]]):
        pulumi.set(self, "signing_algorithm", value)


@pulumi.input_type
class AgreementContentArgs:
    def __init__(__self__, *,
                 a_s2: Optional[pulumi.Input['AS2AgreementContentArgs']] = None,
                 edifact: Optional[pulumi.Input['EdifactAgreementContentArgs']] = None,
                 x12: Optional[pulumi.Input['X12AgreementContentArgs']] = None):
        """
        The integration account agreement content.
        :param pulumi.Input['AS2AgreementContentArgs'] a_s2: The AS2 agreement content.
        :param pulumi.Input['EdifactAgreementContentArgs'] edifact: The EDIFACT agreement content.
        :param pulumi.Input['X12AgreementContentArgs'] x12: The X12 agreement content.
        """
        if a_s2 is not None:
            pulumi.set(__self__, "a_s2", a_s2)
        if edifact is not None:
            pulumi.set(__self__, "edifact", edifact)
        if x12 is not None:
            pulumi.set(__self__, "x12", x12)

    @property
    @pulumi.getter(name="aS2")
    def a_s2(self) -> Optional[pulumi.Input['AS2AgreementContentArgs']]:
        """
        The AS2 agreement content.
        """
        return pulumi.get(self, "a_s2")

    @a_s2.setter
    def a_s2(self, value: Optional[pulumi.Input['AS2AgreementContentArgs']]):
        pulumi.set(self, "a_s2", value)

    @property
    @pulumi.getter
    def edifact(self) -> Optional[pulumi.Input['EdifactAgreementContentArgs']]:
        """
        The EDIFACT agreement content.
        """
        return pulumi.get(self, "edifact")

    @edifact.setter
    def edifact(self, value: Optional[pulumi.Input['EdifactAgreementContentArgs']]):
        pulumi.set(self, "edifact", value)

    @property
    @pulumi.getter
    def x12(self) -> Optional[pulumi.Input['X12AgreementContentArgs']]:
        """
        The X12 agreement content.
        """
        return pulumi.get(self, "x12")

    @x12.setter
    def x12(self, value: Optional[pulumi.Input['X12AgreementContentArgs']]):
        pulumi.set(self, "x12", value)


@pulumi.input_type
class AssemblyPropertiesArgs:
    def __init__(__self__, *,
                 assembly_name: pulumi.Input[str],
                 assembly_culture: Optional[pulumi.Input[str]] = None,
                 assembly_public_key_token: Optional[pulumi.Input[str]] = None,
                 assembly_version: Optional[pulumi.Input[str]] = None,
                 changed_time: Optional[pulumi.Input[str]] = None,
                 content: Optional[Any] = None,
                 content_link: Optional[pulumi.Input['ContentLinkArgs']] = None,
                 content_type: Optional[pulumi.Input[str]] = None,
                 created_time: Optional[pulumi.Input[str]] = None,
                 metadata: Optional[Any] = None):
        """
        The assembly properties definition.
        :param pulumi.Input[str] assembly_name: The assembly name.
        :param pulumi.Input[str] assembly_culture: The assembly culture.
        :param pulumi.Input[str] assembly_public_key_token: The assembly public key token.
        :param pulumi.Input[str] assembly_version: The assembly version.
        :param pulumi.Input[str] changed_time: The artifact changed time.
        :param pulumi.Input['ContentLinkArgs'] content_link: The content link.
        :param pulumi.Input[str] content_type: The content type.
        :param pulumi.Input[str] created_time: The artifact creation time.
        """
        pulumi.set(__self__, "assembly_name", assembly_name)
        if assembly_culture is not None:
            pulumi.set(__self__, "assembly_culture", assembly_culture)
        if assembly_public_key_token is not None:
            pulumi.set(__self__, "assembly_public_key_token", assembly_public_key_token)
        if assembly_version is not None:
            pulumi.set(__self__, "assembly_version", assembly_version)
        if changed_time is not None:
            pulumi.set(__self__, "changed_time", changed_time)
        if content is not None:
            pulumi.set(__self__, "content", content)
        if content_link is not None:
            pulumi.set(__self__, "content_link", content_link)
        if content_type is not None:
            pulumi.set(__self__, "content_type", content_type)
        if created_time is not None:
            pulumi.set(__self__, "created_time", created_time)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)

    @property
    @pulumi.getter(name="assemblyName")
    def assembly_name(self) -> pulumi.Input[str]:
        """
        The assembly name.
        """
        return pulumi.get(self, "assembly_name")

    @assembly_name.setter
    def assembly_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "assembly_name", value)

    @property
    @pulumi.getter(name="assemblyCulture")
    def assembly_culture(self) -> Optional[pulumi.Input[str]]:
        """
        The assembly culture.
        """
        return pulumi.get(self, "assembly_culture")

    @assembly_culture.setter
    def assembly_culture(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "assembly_culture", value)

    @property
    @pulumi.getter(name="assemblyPublicKeyToken")
    def assembly_public_key_token(self) -> Optional[pulumi.Input[str]]:
        """
        The assembly public key token.
        """
        return pulumi.get(self, "assembly_public_key_token")

    @assembly_public_key_token.setter
    def assembly_public_key_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "assembly_public_key_token", value)

    @property
    @pulumi.getter(name="assemblyVersion")
    def assembly_version(self) -> Optional[pulumi.Input[str]]:
        """
        The assembly version.
        """
        return pulumi.get(self, "assembly_version")

    @assembly_version.setter
    def assembly_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "assembly_version", value)

    @property
    @pulumi.getter(name="changedTime")
    def changed_time(self) -> Optional[pulumi.Input[str]]:
        """
        The artifact changed time.
        """
        return pulumi.get(self, "changed_time")

    @changed_time.setter
    def changed_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "changed_time", value)

    @property
    @pulumi.getter
    def content(self) -> Optional[Any]:
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: Optional[Any]):
        pulumi.set(self, "content", value)

    @property
    @pulumi.getter(name="contentLink")
    def content_link(self) -> Optional[pulumi.Input['ContentLinkArgs']]:
        """
        The content link.
        """
        return pulumi.get(self, "content_link")

    @content_link.setter
    def content_link(self, value: Optional[pulumi.Input['ContentLinkArgs']]):
        pulumi.set(self, "content_link", value)

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> Optional[pulumi.Input[str]]:
        """
        The content type.
        """
        return pulumi.get(self, "content_type")

    @content_type.setter
    def content_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "content_type", value)

    @property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> Optional[pulumi.Input[str]]:
        """
        The artifact creation time.
        """
        return pulumi.get(self, "created_time")

    @created_time.setter
    def created_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_time", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[Any]:
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[Any]):
        pulumi.set(self, "metadata", value)


@pulumi.input_type
class B2BPartnerContentArgs:
    def __init__(__self__, *,
                 business_identities: Optional[pulumi.Input[Sequence[pulumi.Input['BusinessIdentityArgs']]]] = None):
        """
        The B2B partner content.
        :param pulumi.Input[Sequence[pulumi.Input['BusinessIdentityArgs']]] business_identities: The list of partner business identities.
        """
        if business_identities is not None:
            pulumi.set(__self__, "business_identities", business_identities)

    @property
    @pulumi.getter(name="businessIdentities")
    def business_identities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BusinessIdentityArgs']]]]:
        """
        The list of partner business identities.
        """
        return pulumi.get(self, "business_identities")

    @business_identities.setter
    def business_identities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BusinessIdentityArgs']]]]):
        pulumi.set(self, "business_identities", value)


@pulumi.input_type
class BatchConfigurationPropertiesArgs:
    def __init__(__self__, *,
                 batch_group_name: pulumi.Input[str],
                 release_criteria: pulumi.Input['BatchReleaseCriteriaArgs'],
                 changed_time: Optional[pulumi.Input[str]] = None,
                 created_time: Optional[pulumi.Input[str]] = None,
                 metadata: Optional[Any] = None):
        """
        The batch configuration properties definition.
        :param pulumi.Input[str] batch_group_name: The name of the batch group.
        :param pulumi.Input['BatchReleaseCriteriaArgs'] release_criteria: The batch release criteria.
        :param pulumi.Input[str] changed_time: The artifact changed time.
        :param pulumi.Input[str] created_time: The artifact creation time.
        """
        pulumi.set(__self__, "batch_group_name", batch_group_name)
        pulumi.set(__self__, "release_criteria", release_criteria)
        if changed_time is not None:
            pulumi.set(__self__, "changed_time", changed_time)
        if created_time is not None:
            pulumi.set(__self__, "created_time", created_time)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)

    @property
    @pulumi.getter(name="batchGroupName")
    def batch_group_name(self) -> pulumi.Input[str]:
        """
        The name of the batch group.
        """
        return pulumi.get(self, "batch_group_name")

    @batch_group_name.setter
    def batch_group_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "batch_group_name", value)

    @property
    @pulumi.getter(name="releaseCriteria")
    def release_criteria(self) -> pulumi.Input['BatchReleaseCriteriaArgs']:
        """
        The batch release criteria.
        """
        return pulumi.get(self, "release_criteria")

    @release_criteria.setter
    def release_criteria(self, value: pulumi.Input['BatchReleaseCriteriaArgs']):
        pulumi.set(self, "release_criteria", value)

    @property
    @pulumi.getter(name="changedTime")
    def changed_time(self) -> Optional[pulumi.Input[str]]:
        """
        The artifact changed time.
        """
        return pulumi.get(self, "changed_time")

    @changed_time.setter
    def changed_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "changed_time", value)

    @property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> Optional[pulumi.Input[str]]:
        """
        The artifact creation time.
        """
        return pulumi.get(self, "created_time")

    @created_time.setter
    def created_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_time", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[Any]:
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[Any]):
        pulumi.set(self, "metadata", value)


@pulumi.input_type
class BatchReleaseCriteriaArgs:
    def __init__(__self__, *,
                 batch_size: Optional[pulumi.Input[int]] = None,
                 message_count: Optional[pulumi.Input[int]] = None,
                 recurrence: Optional[pulumi.Input['WorkflowTriggerRecurrenceArgs']] = None):
        """
        The batch release criteria.
        :param pulumi.Input[int] batch_size: The batch size in bytes.
        :param pulumi.Input[int] message_count: The message count.
        :param pulumi.Input['WorkflowTriggerRecurrenceArgs'] recurrence: The recurrence.
        """
        if batch_size is not None:
            pulumi.set(__self__, "batch_size", batch_size)
        if message_count is not None:
            pulumi.set(__self__, "message_count", message_count)
        if recurrence is not None:
            pulumi.set(__self__, "recurrence", recurrence)

    @property
    @pulumi.getter(name="batchSize")
    def batch_size(self) -> Optional[pulumi.Input[int]]:
        """
        The batch size in bytes.
        """
        return pulumi.get(self, "batch_size")

    @batch_size.setter
    def batch_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "batch_size", value)

    @property
    @pulumi.getter(name="messageCount")
    def message_count(self) -> Optional[pulumi.Input[int]]:
        """
        The message count.
        """
        return pulumi.get(self, "message_count")

    @message_count.setter
    def message_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "message_count", value)

    @property
    @pulumi.getter
    def recurrence(self) -> Optional[pulumi.Input['WorkflowTriggerRecurrenceArgs']]:
        """
        The recurrence.
        """
        return pulumi.get(self, "recurrence")

    @recurrence.setter
    def recurrence(self, value: Optional[pulumi.Input['WorkflowTriggerRecurrenceArgs']]):
        pulumi.set(self, "recurrence", value)


@pulumi.input_type
class BusinessIdentityArgs:
    def __init__(__self__, *,
                 qualifier: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        The integration account partner's business identity.
        :param pulumi.Input[str] qualifier: The business identity qualifier e.g. as2identity, ZZ, ZZZ, 31, 32
        :param pulumi.Input[str] value: The user defined business identity value.
        """
        pulumi.set(__self__, "qualifier", qualifier)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def qualifier(self) -> pulumi.Input[str]:
        """
        The business identity qualifier e.g. as2identity, ZZ, ZZZ, 31, 32
        """
        return pulumi.get(self, "qualifier")

    @qualifier.setter
    def qualifier(self, value: pulumi.Input[str]):
        pulumi.set(self, "qualifier", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        The user defined business identity value.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class ContentLinkArgs:
    def __init__(__self__, *,
                 uri: Optional[pulumi.Input[str]] = None):
        """
        The content link.
        :param pulumi.Input[str] uri: The content link URI.
        """
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def uri(self) -> Optional[pulumi.Input[str]]:
        """
        The content link URI.
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uri", value)


@pulumi.input_type
class EdifactAcknowledgementSettingsArgs:
    def __init__(__self__, *,
                 acknowledgement_control_number_lower_bound: pulumi.Input[int],
                 acknowledgement_control_number_upper_bound: pulumi.Input[int],
                 batch_functional_acknowledgements: pulumi.Input[bool],
                 batch_technical_acknowledgements: pulumi.Input[bool],
                 need_functional_acknowledgement: pulumi.Input[bool],
                 need_loop_for_valid_messages: pulumi.Input[bool],
                 need_technical_acknowledgement: pulumi.Input[bool],
                 rollover_acknowledgement_control_number: pulumi.Input[bool],
                 send_synchronous_acknowledgement: pulumi.Input[bool],
                 acknowledgement_control_number_prefix: Optional[pulumi.Input[str]] = None,
                 acknowledgement_control_number_suffix: Optional[pulumi.Input[str]] = None):
        """
        The Edifact agreement acknowledgement settings.
        :param pulumi.Input[int] acknowledgement_control_number_lower_bound: The acknowledgement control number lower bound.
        :param pulumi.Input[int] acknowledgement_control_number_upper_bound: The acknowledgement control number upper bound.
        :param pulumi.Input[bool] batch_functional_acknowledgements: The value indicating whether to batch functional acknowledgements.
        :param pulumi.Input[bool] batch_technical_acknowledgements: The value indicating whether to batch the technical acknowledgements.
        :param pulumi.Input[bool] need_functional_acknowledgement: The value indicating whether functional acknowledgement is needed.
        :param pulumi.Input[bool] need_loop_for_valid_messages: The value indicating whether a loop is needed for valid messages.
        :param pulumi.Input[bool] need_technical_acknowledgement: The value indicating whether technical acknowledgement is needed.
        :param pulumi.Input[bool] rollover_acknowledgement_control_number: The value indicating whether to rollover acknowledgement control number.
        :param pulumi.Input[bool] send_synchronous_acknowledgement: The value indicating whether to send synchronous acknowledgement.
        :param pulumi.Input[str] acknowledgement_control_number_prefix: The acknowledgement control number prefix.
        :param pulumi.Input[str] acknowledgement_control_number_suffix: The acknowledgement control number suffix.
        """
        pulumi.set(__self__, "acknowledgement_control_number_lower_bound", acknowledgement_control_number_lower_bound)
        pulumi.set(__self__, "acknowledgement_control_number_upper_bound", acknowledgement_control_number_upper_bound)
        pulumi.set(__self__, "batch_functional_acknowledgements", batch_functional_acknowledgements)
        pulumi.set(__self__, "batch_technical_acknowledgements", batch_technical_acknowledgements)
        pulumi.set(__self__, "need_functional_acknowledgement", need_functional_acknowledgement)
        pulumi.set(__self__, "need_loop_for_valid_messages", need_loop_for_valid_messages)
        pulumi.set(__self__, "need_technical_acknowledgement", need_technical_acknowledgement)
        pulumi.set(__self__, "rollover_acknowledgement_control_number", rollover_acknowledgement_control_number)
        pulumi.set(__self__, "send_synchronous_acknowledgement", send_synchronous_acknowledgement)
        if acknowledgement_control_number_prefix is not None:
            pulumi.set(__self__, "acknowledgement_control_number_prefix", acknowledgement_control_number_prefix)
        if acknowledgement_control_number_suffix is not None:
            pulumi.set(__self__, "acknowledgement_control_number_suffix", acknowledgement_control_number_suffix)

    @property
    @pulumi.getter(name="acknowledgementControlNumberLowerBound")
    def acknowledgement_control_number_lower_bound(self) -> pulumi.Input[int]:
        """
        The acknowledgement control number lower bound.
        """
        return pulumi.get(self, "acknowledgement_control_number_lower_bound")

    @acknowledgement_control_number_lower_bound.setter
    def acknowledgement_control_number_lower_bound(self, value: pulumi.Input[int]):
        pulumi.set(self, "acknowledgement_control_number_lower_bound", value)

    @property
    @pulumi.getter(name="acknowledgementControlNumberUpperBound")
    def acknowledgement_control_number_upper_bound(self) -> pulumi.Input[int]:
        """
        The acknowledgement control number upper bound.
        """
        return pulumi.get(self, "acknowledgement_control_number_upper_bound")

    @acknowledgement_control_number_upper_bound.setter
    def acknowledgement_control_number_upper_bound(self, value: pulumi.Input[int]):
        pulumi.set(self, "acknowledgement_control_number_upper_bound", value)

    @property
    @pulumi.getter(name="batchFunctionalAcknowledgements")
    def batch_functional_acknowledgements(self) -> pulumi.Input[bool]:
        """
        The value indicating whether to batch functional acknowledgements.
        """
        return pulumi.get(self, "batch_functional_acknowledgements")

    @batch_functional_acknowledgements.setter
    def batch_functional_acknowledgements(self, value: pulumi.Input[bool]):
        pulumi.set(self, "batch_functional_acknowledgements", value)

    @property
    @pulumi.getter(name="batchTechnicalAcknowledgements")
    def batch_technical_acknowledgements(self) -> pulumi.Input[bool]:
        """
        The value indicating whether to batch the technical acknowledgements.
        """
        return pulumi.get(self, "batch_technical_acknowledgements")

    @batch_technical_acknowledgements.setter
    def batch_technical_acknowledgements(self, value: pulumi.Input[bool]):
        pulumi.set(self, "batch_technical_acknowledgements", value)

    @property
    @pulumi.getter(name="needFunctionalAcknowledgement")
    def need_functional_acknowledgement(self) -> pulumi.Input[bool]:
        """
        The value indicating whether functional acknowledgement is needed.
        """
        return pulumi.get(self, "need_functional_acknowledgement")

    @need_functional_acknowledgement.setter
    def need_functional_acknowledgement(self, value: pulumi.Input[bool]):
        pulumi.set(self, "need_functional_acknowledgement", value)

    @property
    @pulumi.getter(name="needLoopForValidMessages")
    def need_loop_for_valid_messages(self) -> pulumi.Input[bool]:
        """
        The value indicating whether a loop is needed for valid messages.
        """
        return pulumi.get(self, "need_loop_for_valid_messages")

    @need_loop_for_valid_messages.setter
    def need_loop_for_valid_messages(self, value: pulumi.Input[bool]):
        pulumi.set(self, "need_loop_for_valid_messages", value)

    @property
    @pulumi.getter(name="needTechnicalAcknowledgement")
    def need_technical_acknowledgement(self) -> pulumi.Input[bool]:
        """
        The value indicating whether technical acknowledgement is needed.
        """
        return pulumi.get(self, "need_technical_acknowledgement")

    @need_technical_acknowledgement.setter
    def need_technical_acknowledgement(self, value: pulumi.Input[bool]):
        pulumi.set(self, "need_technical_acknowledgement", value)

    @property
    @pulumi.getter(name="rolloverAcknowledgementControlNumber")
    def rollover_acknowledgement_control_number(self) -> pulumi.Input[bool]:
        """
        The value indicating whether to rollover acknowledgement control number.
        """
        return pulumi.get(self, "rollover_acknowledgement_control_number")

    @rollover_acknowledgement_control_number.setter
    def rollover_acknowledgement_control_number(self, value: pulumi.Input[bool]):
        pulumi.set(self, "rollover_acknowledgement_control_number", value)

    @property
    @pulumi.getter(name="sendSynchronousAcknowledgement")
    def send_synchronous_acknowledgement(self) -> pulumi.Input[bool]:
        """
        The value indicating whether to send synchronous acknowledgement.
        """
        return pulumi.get(self, "send_synchronous_acknowledgement")

    @send_synchronous_acknowledgement.setter
    def send_synchronous_acknowledgement(self, value: pulumi.Input[bool]):
        pulumi.set(self, "send_synchronous_acknowledgement", value)

    @property
    @pulumi.getter(name="acknowledgementControlNumberPrefix")
    def acknowledgement_control_number_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        The acknowledgement control number prefix.
        """
        return pulumi.get(self, "acknowledgement_control_number_prefix")

    @acknowledgement_control_number_prefix.setter
    def acknowledgement_control_number_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "acknowledgement_control_number_prefix", value)

    @property
    @pulumi.getter(name="acknowledgementControlNumberSuffix")
    def acknowledgement_control_number_suffix(self) -> Optional[pulumi.Input[str]]:
        """
        The acknowledgement control number suffix.
        """
        return pulumi.get(self, "acknowledgement_control_number_suffix")

    @acknowledgement_control_number_suffix.setter
    def acknowledgement_control_number_suffix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "acknowledgement_control_number_suffix", value)


@pulumi.input_type
class EdifactAgreementContentArgs:
    def __init__(__self__, *,
                 receive_agreement: pulumi.Input['EdifactOneWayAgreementArgs'],
                 send_agreement: pulumi.Input['EdifactOneWayAgreementArgs']):
        """
        The Edifact agreement content.
        :param pulumi.Input['EdifactOneWayAgreementArgs'] receive_agreement: The EDIFACT one-way receive agreement.
        :param pulumi.Input['EdifactOneWayAgreementArgs'] send_agreement: The EDIFACT one-way send agreement.
        """
        pulumi.set(__self__, "receive_agreement", receive_agreement)
        pulumi.set(__self__, "send_agreement", send_agreement)

    @property
    @pulumi.getter(name="receiveAgreement")
    def receive_agreement(self) -> pulumi.Input['EdifactOneWayAgreementArgs']:
        """
        The EDIFACT one-way receive agreement.
        """
        return pulumi.get(self, "receive_agreement")

    @receive_agreement.setter
    def receive_agreement(self, value: pulumi.Input['EdifactOneWayAgreementArgs']):
        pulumi.set(self, "receive_agreement", value)

    @property
    @pulumi.getter(name="sendAgreement")
    def send_agreement(self) -> pulumi.Input['EdifactOneWayAgreementArgs']:
        """
        The EDIFACT one-way send agreement.
        """
        return pulumi.get(self, "send_agreement")

    @send_agreement.setter
    def send_agreement(self, value: pulumi.Input['EdifactOneWayAgreementArgs']):
        pulumi.set(self, "send_agreement", value)


@pulumi.input_type
class EdifactDelimiterOverrideArgs:
    def __init__(__self__, *,
                 component_separator: pulumi.Input[int],
                 data_element_separator: pulumi.Input[int],
                 decimal_point_indicator: pulumi.Input['EdifactDecimalIndicator'],
                 release_indicator: pulumi.Input[int],
                 repetition_separator: pulumi.Input[int],
                 segment_terminator: pulumi.Input[int],
                 segment_terminator_suffix: pulumi.Input['SegmentTerminatorSuffix'],
                 message_association_assigned_code: Optional[pulumi.Input[str]] = None,
                 message_id: Optional[pulumi.Input[str]] = None,
                 message_release: Optional[pulumi.Input[str]] = None,
                 message_version: Optional[pulumi.Input[str]] = None,
                 target_namespace: Optional[pulumi.Input[str]] = None):
        """
        The Edifact delimiter override settings.
        :param pulumi.Input[int] component_separator: The component separator.
        :param pulumi.Input[int] data_element_separator: The data element separator.
        :param pulumi.Input['EdifactDecimalIndicator'] decimal_point_indicator: The decimal point indicator.
        :param pulumi.Input[int] release_indicator: The release indicator.
        :param pulumi.Input[int] repetition_separator: The repetition separator.
        :param pulumi.Input[int] segment_terminator: The segment terminator.
        :param pulumi.Input['SegmentTerminatorSuffix'] segment_terminator_suffix: The segment terminator suffix.
        :param pulumi.Input[str] message_association_assigned_code: The message association assigned code.
        :param pulumi.Input[str] message_id: The message id.
        :param pulumi.Input[str] message_release: The message release.
        :param pulumi.Input[str] message_version: The message version.
        :param pulumi.Input[str] target_namespace: The target namespace on which this delimiter settings has to be applied.
        """
        pulumi.set(__self__, "component_separator", component_separator)
        pulumi.set(__self__, "data_element_separator", data_element_separator)
        pulumi.set(__self__, "decimal_point_indicator", decimal_point_indicator)
        pulumi.set(__self__, "release_indicator", release_indicator)
        pulumi.set(__self__, "repetition_separator", repetition_separator)
        pulumi.set(__self__, "segment_terminator", segment_terminator)
        pulumi.set(__self__, "segment_terminator_suffix", segment_terminator_suffix)
        if message_association_assigned_code is not None:
            pulumi.set(__self__, "message_association_assigned_code", message_association_assigned_code)
        if message_id is not None:
            pulumi.set(__self__, "message_id", message_id)
        if message_release is not None:
            pulumi.set(__self__, "message_release", message_release)
        if message_version is not None:
            pulumi.set(__self__, "message_version", message_version)
        if target_namespace is not None:
            pulumi.set(__self__, "target_namespace", target_namespace)

    @property
    @pulumi.getter(name="componentSeparator")
    def component_separator(self) -> pulumi.Input[int]:
        """
        The component separator.
        """
        return pulumi.get(self, "component_separator")

    @component_separator.setter
    def component_separator(self, value: pulumi.Input[int]):
        pulumi.set(self, "component_separator", value)

    @property
    @pulumi.getter(name="dataElementSeparator")
    def data_element_separator(self) -> pulumi.Input[int]:
        """
        The data element separator.
        """
        return pulumi.get(self, "data_element_separator")

    @data_element_separator.setter
    def data_element_separator(self, value: pulumi.Input[int]):
        pulumi.set(self, "data_element_separator", value)

    @property
    @pulumi.getter(name="decimalPointIndicator")
    def decimal_point_indicator(self) -> pulumi.Input['EdifactDecimalIndicator']:
        """
        The decimal point indicator.
        """
        return pulumi.get(self, "decimal_point_indicator")

    @decimal_point_indicator.setter
    def decimal_point_indicator(self, value: pulumi.Input['EdifactDecimalIndicator']):
        pulumi.set(self, "decimal_point_indicator", value)

    @property
    @pulumi.getter(name="releaseIndicator")
    def release_indicator(self) -> pulumi.Input[int]:
        """
        The release indicator.
        """
        return pulumi.get(self, "release_indicator")

    @release_indicator.setter
    def release_indicator(self, value: pulumi.Input[int]):
        pulumi.set(self, "release_indicator", value)

    @property
    @pulumi.getter(name="repetitionSeparator")
    def repetition_separator(self) -> pulumi.Input[int]:
        """
        The repetition separator.
        """
        return pulumi.get(self, "repetition_separator")

    @repetition_separator.setter
    def repetition_separator(self, value: pulumi.Input[int]):
        pulumi.set(self, "repetition_separator", value)

    @property
    @pulumi.getter(name="segmentTerminator")
    def segment_terminator(self) -> pulumi.Input[int]:
        """
        The segment terminator.
        """
        return pulumi.get(self, "segment_terminator")

    @segment_terminator.setter
    def segment_terminator(self, value: pulumi.Input[int]):
        pulumi.set(self, "segment_terminator", value)

    @property
    @pulumi.getter(name="segmentTerminatorSuffix")
    def segment_terminator_suffix(self) -> pulumi.Input['SegmentTerminatorSuffix']:
        """
        The segment terminator suffix.
        """
        return pulumi.get(self, "segment_terminator_suffix")

    @segment_terminator_suffix.setter
    def segment_terminator_suffix(self, value: pulumi.Input['SegmentTerminatorSuffix']):
        pulumi.set(self, "segment_terminator_suffix", value)

    @property
    @pulumi.getter(name="messageAssociationAssignedCode")
    def message_association_assigned_code(self) -> Optional[pulumi.Input[str]]:
        """
        The message association assigned code.
        """
        return pulumi.get(self, "message_association_assigned_code")

    @message_association_assigned_code.setter
    def message_association_assigned_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message_association_assigned_code", value)

    @property
    @pulumi.getter(name="messageId")
    def message_id(self) -> Optional[pulumi.Input[str]]:
        """
        The message id.
        """
        return pulumi.get(self, "message_id")

    @message_id.setter
    def message_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message_id", value)

    @property
    @pulumi.getter(name="messageRelease")
    def message_release(self) -> Optional[pulumi.Input[str]]:
        """
        The message release.
        """
        return pulumi.get(self, "message_release")

    @message_release.setter
    def message_release(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message_release", value)

    @property
    @pulumi.getter(name="messageVersion")
    def message_version(self) -> Optional[pulumi.Input[str]]:
        """
        The message version.
        """
        return pulumi.get(self, "message_version")

    @message_version.setter
    def message_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message_version", value)

    @property
    @pulumi.getter(name="targetNamespace")
    def target_namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The target namespace on which this delimiter settings has to be applied.
        """
        return pulumi.get(self, "target_namespace")

    @target_namespace.setter
    def target_namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_namespace", value)


@pulumi.input_type
class EdifactEnvelopeOverrideArgs:
    def __init__(__self__, *,
                 application_password: Optional[pulumi.Input[str]] = None,
                 association_assigned_code: Optional[pulumi.Input[str]] = None,
                 controlling_agency_code: Optional[pulumi.Input[str]] = None,
                 functional_group_id: Optional[pulumi.Input[str]] = None,
                 group_header_message_release: Optional[pulumi.Input[str]] = None,
                 group_header_message_version: Optional[pulumi.Input[str]] = None,
                 message_association_assigned_code: Optional[pulumi.Input[str]] = None,
                 message_id: Optional[pulumi.Input[str]] = None,
                 message_release: Optional[pulumi.Input[str]] = None,
                 message_version: Optional[pulumi.Input[str]] = None,
                 receiver_application_id: Optional[pulumi.Input[str]] = None,
                 receiver_application_qualifier: Optional[pulumi.Input[str]] = None,
                 sender_application_id: Optional[pulumi.Input[str]] = None,
                 sender_application_qualifier: Optional[pulumi.Input[str]] = None,
                 target_namespace: Optional[pulumi.Input[str]] = None):
        """
        The Edifact envelope override settings.
        :param pulumi.Input[str] application_password: The application password.
        :param pulumi.Input[str] association_assigned_code: The association assigned code.
        :param pulumi.Input[str] controlling_agency_code: The controlling agency code.
        :param pulumi.Input[str] functional_group_id: The functional group id.
        :param pulumi.Input[str] group_header_message_release: The group header message release.
        :param pulumi.Input[str] group_header_message_version: The group header message version.
        :param pulumi.Input[str] message_association_assigned_code: The message association assigned code.
        :param pulumi.Input[str] message_id: The message id on which this envelope settings has to be applied.
        :param pulumi.Input[str] message_release: The message release version on which this envelope settings has to be applied.
        :param pulumi.Input[str] message_version: The message version on which this envelope settings has to be applied.
        :param pulumi.Input[str] receiver_application_id: The receiver application id.
        :param pulumi.Input[str] receiver_application_qualifier: The receiver application qualifier.
        :param pulumi.Input[str] sender_application_id: The sender application id.
        :param pulumi.Input[str] sender_application_qualifier: The sender application qualifier.
        :param pulumi.Input[str] target_namespace: The target namespace on which this envelope settings has to be applied.
        """
        if application_password is not None:
            pulumi.set(__self__, "application_password", application_password)
        if association_assigned_code is not None:
            pulumi.set(__self__, "association_assigned_code", association_assigned_code)
        if controlling_agency_code is not None:
            pulumi.set(__self__, "controlling_agency_code", controlling_agency_code)
        if functional_group_id is not None:
            pulumi.set(__self__, "functional_group_id", functional_group_id)
        if group_header_message_release is not None:
            pulumi.set(__self__, "group_header_message_release", group_header_message_release)
        if group_header_message_version is not None:
            pulumi.set(__self__, "group_header_message_version", group_header_message_version)
        if message_association_assigned_code is not None:
            pulumi.set(__self__, "message_association_assigned_code", message_association_assigned_code)
        if message_id is not None:
            pulumi.set(__self__, "message_id", message_id)
        if message_release is not None:
            pulumi.set(__self__, "message_release", message_release)
        if message_version is not None:
            pulumi.set(__self__, "message_version", message_version)
        if receiver_application_id is not None:
            pulumi.set(__self__, "receiver_application_id", receiver_application_id)
        if receiver_application_qualifier is not None:
            pulumi.set(__self__, "receiver_application_qualifier", receiver_application_qualifier)
        if sender_application_id is not None:
            pulumi.set(__self__, "sender_application_id", sender_application_id)
        if sender_application_qualifier is not None:
            pulumi.set(__self__, "sender_application_qualifier", sender_application_qualifier)
        if target_namespace is not None:
            pulumi.set(__self__, "target_namespace", target_namespace)

    @property
    @pulumi.getter(name="applicationPassword")
    def application_password(self) -> Optional[pulumi.Input[str]]:
        """
        The application password.
        """
        return pulumi.get(self, "application_password")

    @application_password.setter
    def application_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "application_password", value)

    @property
    @pulumi.getter(name="associationAssignedCode")
    def association_assigned_code(self) -> Optional[pulumi.Input[str]]:
        """
        The association assigned code.
        """
        return pulumi.get(self, "association_assigned_code")

    @association_assigned_code.setter
    def association_assigned_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "association_assigned_code", value)

    @property
    @pulumi.getter(name="controllingAgencyCode")
    def controlling_agency_code(self) -> Optional[pulumi.Input[str]]:
        """
        The controlling agency code.
        """
        return pulumi.get(self, "controlling_agency_code")

    @controlling_agency_code.setter
    def controlling_agency_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "controlling_agency_code", value)

    @property
    @pulumi.getter(name="functionalGroupId")
    def functional_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The functional group id.
        """
        return pulumi.get(self, "functional_group_id")

    @functional_group_id.setter
    def functional_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "functional_group_id", value)

    @property
    @pulumi.getter(name="groupHeaderMessageRelease")
    def group_header_message_release(self) -> Optional[pulumi.Input[str]]:
        """
        The group header message release.
        """
        return pulumi.get(self, "group_header_message_release")

    @group_header_message_release.setter
    def group_header_message_release(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group_header_message_release", value)

    @property
    @pulumi.getter(name="groupHeaderMessageVersion")
    def group_header_message_version(self) -> Optional[pulumi.Input[str]]:
        """
        The group header message version.
        """
        return pulumi.get(self, "group_header_message_version")

    @group_header_message_version.setter
    def group_header_message_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group_header_message_version", value)

    @property
    @pulumi.getter(name="messageAssociationAssignedCode")
    def message_association_assigned_code(self) -> Optional[pulumi.Input[str]]:
        """
        The message association assigned code.
        """
        return pulumi.get(self, "message_association_assigned_code")

    @message_association_assigned_code.setter
    def message_association_assigned_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message_association_assigned_code", value)

    @property
    @pulumi.getter(name="messageId")
    def message_id(self) -> Optional[pulumi.Input[str]]:
        """
        The message id on which this envelope settings has to be applied.
        """
        return pulumi.get(self, "message_id")

    @message_id.setter
    def message_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message_id", value)

    @property
    @pulumi.getter(name="messageRelease")
    def message_release(self) -> Optional[pulumi.Input[str]]:
        """
        The message release version on which this envelope settings has to be applied.
        """
        return pulumi.get(self, "message_release")

    @message_release.setter
    def message_release(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message_release", value)

    @property
    @pulumi.getter(name="messageVersion")
    def message_version(self) -> Optional[pulumi.Input[str]]:
        """
        The message version on which this envelope settings has to be applied.
        """
        return pulumi.get(self, "message_version")

    @message_version.setter
    def message_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message_version", value)

    @property
    @pulumi.getter(name="receiverApplicationId")
    def receiver_application_id(self) -> Optional[pulumi.Input[str]]:
        """
        The receiver application id.
        """
        return pulumi.get(self, "receiver_application_id")

    @receiver_application_id.setter
    def receiver_application_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "receiver_application_id", value)

    @property
    @pulumi.getter(name="receiverApplicationQualifier")
    def receiver_application_qualifier(self) -> Optional[pulumi.Input[str]]:
        """
        The receiver application qualifier.
        """
        return pulumi.get(self, "receiver_application_qualifier")

    @receiver_application_qualifier.setter
    def receiver_application_qualifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "receiver_application_qualifier", value)

    @property
    @pulumi.getter(name="senderApplicationId")
    def sender_application_id(self) -> Optional[pulumi.Input[str]]:
        """
        The sender application id.
        """
        return pulumi.get(self, "sender_application_id")

    @sender_application_id.setter
    def sender_application_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sender_application_id", value)

    @property
    @pulumi.getter(name="senderApplicationQualifier")
    def sender_application_qualifier(self) -> Optional[pulumi.Input[str]]:
        """
        The sender application qualifier.
        """
        return pulumi.get(self, "sender_application_qualifier")

    @sender_application_qualifier.setter
    def sender_application_qualifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sender_application_qualifier", value)

    @property
    @pulumi.getter(name="targetNamespace")
    def target_namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The target namespace on which this envelope settings has to be applied.
        """
        return pulumi.get(self, "target_namespace")

    @target_namespace.setter
    def target_namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_namespace", value)


@pulumi.input_type
class EdifactEnvelopeSettingsArgs:
    def __init__(__self__, *,
                 apply_delimiter_string_advice: pulumi.Input[bool],
                 create_grouping_segments: pulumi.Input[bool],
                 enable_default_group_headers: pulumi.Input[bool],
                 group_control_number_lower_bound: pulumi.Input[float],
                 group_control_number_upper_bound: pulumi.Input[float],
                 interchange_control_number_lower_bound: pulumi.Input[float],
                 interchange_control_number_upper_bound: pulumi.Input[float],
                 is_test_interchange: pulumi.Input[bool],
                 overwrite_existing_transaction_set_control_number: pulumi.Input[bool],
                 rollover_group_control_number: pulumi.Input[bool],
                 rollover_interchange_control_number: pulumi.Input[bool],
                 rollover_transaction_set_control_number: pulumi.Input[bool],
                 transaction_set_control_number_lower_bound: pulumi.Input[float],
                 transaction_set_control_number_upper_bound: pulumi.Input[float],
                 application_reference_id: Optional[pulumi.Input[str]] = None,
                 communication_agreement_id: Optional[pulumi.Input[str]] = None,
                 functional_group_id: Optional[pulumi.Input[str]] = None,
                 group_application_password: Optional[pulumi.Input[str]] = None,
                 group_application_receiver_id: Optional[pulumi.Input[str]] = None,
                 group_application_receiver_qualifier: Optional[pulumi.Input[str]] = None,
                 group_application_sender_id: Optional[pulumi.Input[str]] = None,
                 group_application_sender_qualifier: Optional[pulumi.Input[str]] = None,
                 group_association_assigned_code: Optional[pulumi.Input[str]] = None,
                 group_control_number_prefix: Optional[pulumi.Input[str]] = None,
                 group_control_number_suffix: Optional[pulumi.Input[str]] = None,
                 group_controlling_agency_code: Optional[pulumi.Input[str]] = None,
                 group_message_release: Optional[pulumi.Input[str]] = None,
                 group_message_version: Optional[pulumi.Input[str]] = None,
                 interchange_control_number_prefix: Optional[pulumi.Input[str]] = None,
                 interchange_control_number_suffix: Optional[pulumi.Input[str]] = None,
                 processing_priority_code: Optional[pulumi.Input[str]] = None,
                 receiver_internal_identification: Optional[pulumi.Input[str]] = None,
                 receiver_internal_sub_identification: Optional[pulumi.Input[str]] = None,
                 receiver_reverse_routing_address: Optional[pulumi.Input[str]] = None,
                 recipient_reference_password_qualifier: Optional[pulumi.Input[str]] = None,
                 recipient_reference_password_value: Optional[pulumi.Input[str]] = None,
                 sender_internal_identification: Optional[pulumi.Input[str]] = None,
                 sender_internal_sub_identification: Optional[pulumi.Input[str]] = None,
                 sender_reverse_routing_address: Optional[pulumi.Input[str]] = None,
                 transaction_set_control_number_prefix: Optional[pulumi.Input[str]] = None,
                 transaction_set_control_number_suffix: Optional[pulumi.Input[str]] = None):
        """
        The Edifact agreement envelope settings.
        :param pulumi.Input[bool] apply_delimiter_string_advice: The value indicating whether to apply delimiter string advice.
        :param pulumi.Input[bool] create_grouping_segments: The value indicating whether to create grouping segments.
        :param pulumi.Input[bool] enable_default_group_headers: The value indicating whether to enable default group headers.
        :param pulumi.Input[float] group_control_number_lower_bound: The group control number lower bound.
        :param pulumi.Input[float] group_control_number_upper_bound: The group control number upper bound.
        :param pulumi.Input[float] interchange_control_number_lower_bound: The interchange control number lower bound.
        :param pulumi.Input[float] interchange_control_number_upper_bound: The interchange control number upper bound.
        :param pulumi.Input[bool] is_test_interchange: The value indicating whether the message is a test interchange.
        :param pulumi.Input[bool] overwrite_existing_transaction_set_control_number: The value indicating whether to overwrite existing transaction set control number.
        :param pulumi.Input[bool] rollover_group_control_number: The value indicating whether to rollover group control number.
        :param pulumi.Input[bool] rollover_interchange_control_number: The value indicating whether to rollover interchange control number.
        :param pulumi.Input[bool] rollover_transaction_set_control_number: The value indicating whether to rollover transaction set control number.
        :param pulumi.Input[float] transaction_set_control_number_lower_bound: The transaction set control number lower bound.
        :param pulumi.Input[float] transaction_set_control_number_upper_bound: The transaction set control number upper bound.
        :param pulumi.Input[str] application_reference_id: The application reference id.
        :param pulumi.Input[str] communication_agreement_id: The communication agreement id.
        :param pulumi.Input[str] functional_group_id: The functional group id.
        :param pulumi.Input[str] group_application_password: The group application password.
        :param pulumi.Input[str] group_application_receiver_id: The group application receiver id.
        :param pulumi.Input[str] group_application_receiver_qualifier: The group application receiver qualifier.
        :param pulumi.Input[str] group_application_sender_id: The group application sender id.
        :param pulumi.Input[str] group_application_sender_qualifier: The group application sender qualifier.
        :param pulumi.Input[str] group_association_assigned_code: The group association assigned code.
        :param pulumi.Input[str] group_control_number_prefix: The group control number prefix.
        :param pulumi.Input[str] group_control_number_suffix: The group control number suffix.
        :param pulumi.Input[str] group_controlling_agency_code: The group controlling agency code.
        :param pulumi.Input[str] group_message_release: The group message release.
        :param pulumi.Input[str] group_message_version: The group message version.
        :param pulumi.Input[str] interchange_control_number_prefix: The interchange control number prefix.
        :param pulumi.Input[str] interchange_control_number_suffix: The interchange control number suffix.
        :param pulumi.Input[str] processing_priority_code: The processing priority code.
        :param pulumi.Input[str] receiver_internal_identification: The receiver internal identification.
        :param pulumi.Input[str] receiver_internal_sub_identification: The receiver internal sub identification.
        :param pulumi.Input[str] receiver_reverse_routing_address: The receiver reverse routing address.
        :param pulumi.Input[str] recipient_reference_password_qualifier: The recipient reference password qualifier.
        :param pulumi.Input[str] recipient_reference_password_value: The recipient reference password value.
        :param pulumi.Input[str] sender_internal_identification: The sender internal identification.
        :param pulumi.Input[str] sender_internal_sub_identification: The sender internal sub identification.
        :param pulumi.Input[str] sender_reverse_routing_address: The sender reverse routing address.
        :param pulumi.Input[str] transaction_set_control_number_prefix: The transaction set control number prefix.
        :param pulumi.Input[str] transaction_set_control_number_suffix: The transaction set control number suffix.
        """
        pulumi.set(__self__, "apply_delimiter_string_advice", apply_delimiter_string_advice)
        pulumi.set(__self__, "create_grouping_segments", create_grouping_segments)
        pulumi.set(__self__, "enable_default_group_headers", enable_default_group_headers)
        pulumi.set(__self__, "group_control_number_lower_bound", group_control_number_lower_bound)
        pulumi.set(__self__, "group_control_number_upper_bound", group_control_number_upper_bound)
        pulumi.set(__self__, "interchange_control_number_lower_bound", interchange_control_number_lower_bound)
        pulumi.set(__self__, "interchange_control_number_upper_bound", interchange_control_number_upper_bound)
        pulumi.set(__self__, "is_test_interchange", is_test_interchange)
        pulumi.set(__self__, "overwrite_existing_transaction_set_control_number", overwrite_existing_transaction_set_control_number)
        pulumi.set(__self__, "rollover_group_control_number", rollover_group_control_number)
        pulumi.set(__self__, "rollover_interchange_control_number", rollover_interchange_control_number)
        pulumi.set(__self__, "rollover_transaction_set_control_number", rollover_transaction_set_control_number)
        pulumi.set(__self__, "transaction_set_control_number_lower_bound", transaction_set_control_number_lower_bound)
        pulumi.set(__self__, "transaction_set_control_number_upper_bound", transaction_set_control_number_upper_bound)
        if application_reference_id is not None:
            pulumi.set(__self__, "application_reference_id", application_reference_id)
        if communication_agreement_id is not None:
            pulumi.set(__self__, "communication_agreement_id", communication_agreement_id)
        if functional_group_id is not None:
            pulumi.set(__self__, "functional_group_id", functional_group_id)
        if group_application_password is not None:
            pulumi.set(__self__, "group_application_password", group_application_password)
        if group_application_receiver_id is not None:
            pulumi.set(__self__, "group_application_receiver_id", group_application_receiver_id)
        if group_application_receiver_qualifier is not None:
            pulumi.set(__self__, "group_application_receiver_qualifier", group_application_receiver_qualifier)
        if group_application_sender_id is not None:
            pulumi.set(__self__, "group_application_sender_id", group_application_sender_id)
        if group_application_sender_qualifier is not None:
            pulumi.set(__self__, "group_application_sender_qualifier", group_application_sender_qualifier)
        if group_association_assigned_code is not None:
            pulumi.set(__self__, "group_association_assigned_code", group_association_assigned_code)
        if group_control_number_prefix is not None:
            pulumi.set(__self__, "group_control_number_prefix", group_control_number_prefix)
        if group_control_number_suffix is not None:
            pulumi.set(__self__, "group_control_number_suffix", group_control_number_suffix)
        if group_controlling_agency_code is not None:
            pulumi.set(__self__, "group_controlling_agency_code", group_controlling_agency_code)
        if group_message_release is not None:
            pulumi.set(__self__, "group_message_release", group_message_release)
        if group_message_version is not None:
            pulumi.set(__self__, "group_message_version", group_message_version)
        if interchange_control_number_prefix is not None:
            pulumi.set(__self__, "interchange_control_number_prefix", interchange_control_number_prefix)
        if interchange_control_number_suffix is not None:
            pulumi.set(__self__, "interchange_control_number_suffix", interchange_control_number_suffix)
        if processing_priority_code is not None:
            pulumi.set(__self__, "processing_priority_code", processing_priority_code)
        if receiver_internal_identification is not None:
            pulumi.set(__self__, "receiver_internal_identification", receiver_internal_identification)
        if receiver_internal_sub_identification is not None:
            pulumi.set(__self__, "receiver_internal_sub_identification", receiver_internal_sub_identification)
        if receiver_reverse_routing_address is not None:
            pulumi.set(__self__, "receiver_reverse_routing_address", receiver_reverse_routing_address)
        if recipient_reference_password_qualifier is not None:
            pulumi.set(__self__, "recipient_reference_password_qualifier", recipient_reference_password_qualifier)
        if recipient_reference_password_value is not None:
            pulumi.set(__self__, "recipient_reference_password_value", recipient_reference_password_value)
        if sender_internal_identification is not None:
            pulumi.set(__self__, "sender_internal_identification", sender_internal_identification)
        if sender_internal_sub_identification is not None:
            pulumi.set(__self__, "sender_internal_sub_identification", sender_internal_sub_identification)
        if sender_reverse_routing_address is not None:
            pulumi.set(__self__, "sender_reverse_routing_address", sender_reverse_routing_address)
        if transaction_set_control_number_prefix is not None:
            pulumi.set(__self__, "transaction_set_control_number_prefix", transaction_set_control_number_prefix)
        if transaction_set_control_number_suffix is not None:
            pulumi.set(__self__, "transaction_set_control_number_suffix", transaction_set_control_number_suffix)

    @property
    @pulumi.getter(name="applyDelimiterStringAdvice")
    def apply_delimiter_string_advice(self) -> pulumi.Input[bool]:
        """
        The value indicating whether to apply delimiter string advice.
        """
        return pulumi.get(self, "apply_delimiter_string_advice")

    @apply_delimiter_string_advice.setter
    def apply_delimiter_string_advice(self, value: pulumi.Input[bool]):
        pulumi.set(self, "apply_delimiter_string_advice", value)

    @property
    @pulumi.getter(name="createGroupingSegments")
    def create_grouping_segments(self) -> pulumi.Input[bool]:
        """
        The value indicating whether to create grouping segments.
        """
        return pulumi.get(self, "create_grouping_segments")

    @create_grouping_segments.setter
    def create_grouping_segments(self, value: pulumi.Input[bool]):
        pulumi.set(self, "create_grouping_segments", value)

    @property
    @pulumi.getter(name="enableDefaultGroupHeaders")
    def enable_default_group_headers(self) -> pulumi.Input[bool]:
        """
        The value indicating whether to enable default group headers.
        """
        return pulumi.get(self, "enable_default_group_headers")

    @enable_default_group_headers.setter
    def enable_default_group_headers(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enable_default_group_headers", value)

    @property
    @pulumi.getter(name="groupControlNumberLowerBound")
    def group_control_number_lower_bound(self) -> pulumi.Input[float]:
        """
        The group control number lower bound.
        """
        return pulumi.get(self, "group_control_number_lower_bound")

    @group_control_number_lower_bound.setter
    def group_control_number_lower_bound(self, value: pulumi.Input[float]):
        pulumi.set(self, "group_control_number_lower_bound", value)

    @property
    @pulumi.getter(name="groupControlNumberUpperBound")
    def group_control_number_upper_bound(self) -> pulumi.Input[float]:
        """
        The group control number upper bound.
        """
        return pulumi.get(self, "group_control_number_upper_bound")

    @group_control_number_upper_bound.setter
    def group_control_number_upper_bound(self, value: pulumi.Input[float]):
        pulumi.set(self, "group_control_number_upper_bound", value)

    @property
    @pulumi.getter(name="interchangeControlNumberLowerBound")
    def interchange_control_number_lower_bound(self) -> pulumi.Input[float]:
        """
        The interchange control number lower bound.
        """
        return pulumi.get(self, "interchange_control_number_lower_bound")

    @interchange_control_number_lower_bound.setter
    def interchange_control_number_lower_bound(self, value: pulumi.Input[float]):
        pulumi.set(self, "interchange_control_number_lower_bound", value)

    @property
    @pulumi.getter(name="interchangeControlNumberUpperBound")
    def interchange_control_number_upper_bound(self) -> pulumi.Input[float]:
        """
        The interchange control number upper bound.
        """
        return pulumi.get(self, "interchange_control_number_upper_bound")

    @interchange_control_number_upper_bound.setter
    def interchange_control_number_upper_bound(self, value: pulumi.Input[float]):
        pulumi.set(self, "interchange_control_number_upper_bound", value)

    @property
    @pulumi.getter(name="isTestInterchange")
    def is_test_interchange(self) -> pulumi.Input[bool]:
        """
        The value indicating whether the message is a test interchange.
        """
        return pulumi.get(self, "is_test_interchange")

    @is_test_interchange.setter
    def is_test_interchange(self, value: pulumi.Input[bool]):
        pulumi.set(self, "is_test_interchange", value)

    @property
    @pulumi.getter(name="overwriteExistingTransactionSetControlNumber")
    def overwrite_existing_transaction_set_control_number(self) -> pulumi.Input[bool]:
        """
        The value indicating whether to overwrite existing transaction set control number.
        """
        return pulumi.get(self, "overwrite_existing_transaction_set_control_number")

    @overwrite_existing_transaction_set_control_number.setter
    def overwrite_existing_transaction_set_control_number(self, value: pulumi.Input[bool]):
        pulumi.set(self, "overwrite_existing_transaction_set_control_number", value)

    @property
    @pulumi.getter(name="rolloverGroupControlNumber")
    def rollover_group_control_number(self) -> pulumi.Input[bool]:
        """
        The value indicating whether to rollover group control number.
        """
        return pulumi.get(self, "rollover_group_control_number")

    @rollover_group_control_number.setter
    def rollover_group_control_number(self, value: pulumi.Input[bool]):
        pulumi.set(self, "rollover_group_control_number", value)

    @property
    @pulumi.getter(name="rolloverInterchangeControlNumber")
    def rollover_interchange_control_number(self) -> pulumi.Input[bool]:
        """
        The value indicating whether to rollover interchange control number.
        """
        return pulumi.get(self, "rollover_interchange_control_number")

    @rollover_interchange_control_number.setter
    def rollover_interchange_control_number(self, value: pulumi.Input[bool]):
        pulumi.set(self, "rollover_interchange_control_number", value)

    @property
    @pulumi.getter(name="rolloverTransactionSetControlNumber")
    def rollover_transaction_set_control_number(self) -> pulumi.Input[bool]:
        """
        The value indicating whether to rollover transaction set control number.
        """
        return pulumi.get(self, "rollover_transaction_set_control_number")

    @rollover_transaction_set_control_number.setter
    def rollover_transaction_set_control_number(self, value: pulumi.Input[bool]):
        pulumi.set(self, "rollover_transaction_set_control_number", value)

    @property
    @pulumi.getter(name="transactionSetControlNumberLowerBound")
    def transaction_set_control_number_lower_bound(self) -> pulumi.Input[float]:
        """
        The transaction set control number lower bound.
        """
        return pulumi.get(self, "transaction_set_control_number_lower_bound")

    @transaction_set_control_number_lower_bound.setter
    def transaction_set_control_number_lower_bound(self, value: pulumi.Input[float]):
        pulumi.set(self, "transaction_set_control_number_lower_bound", value)

    @property
    @pulumi.getter(name="transactionSetControlNumberUpperBound")
    def transaction_set_control_number_upper_bound(self) -> pulumi.Input[float]:
        """
        The transaction set control number upper bound.
        """
        return pulumi.get(self, "transaction_set_control_number_upper_bound")

    @transaction_set_control_number_upper_bound.setter
    def transaction_set_control_number_upper_bound(self, value: pulumi.Input[float]):
        pulumi.set(self, "transaction_set_control_number_upper_bound", value)

    @property
    @pulumi.getter(name="applicationReferenceId")
    def application_reference_id(self) -> Optional[pulumi.Input[str]]:
        """
        The application reference id.
        """
        return pulumi.get(self, "application_reference_id")

    @application_reference_id.setter
    def application_reference_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "application_reference_id", value)

    @property
    @pulumi.getter(name="communicationAgreementId")
    def communication_agreement_id(self) -> Optional[pulumi.Input[str]]:
        """
        The communication agreement id.
        """
        return pulumi.get(self, "communication_agreement_id")

    @communication_agreement_id.setter
    def communication_agreement_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "communication_agreement_id", value)

    @property
    @pulumi.getter(name="functionalGroupId")
    def functional_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The functional group id.
        """
        return pulumi.get(self, "functional_group_id")

    @functional_group_id.setter
    def functional_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "functional_group_id", value)

    @property
    @pulumi.getter(name="groupApplicationPassword")
    def group_application_password(self) -> Optional[pulumi.Input[str]]:
        """
        The group application password.
        """
        return pulumi.get(self, "group_application_password")

    @group_application_password.setter
    def group_application_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group_application_password", value)

    @property
    @pulumi.getter(name="groupApplicationReceiverId")
    def group_application_receiver_id(self) -> Optional[pulumi.Input[str]]:
        """
        The group application receiver id.
        """
        return pulumi.get(self, "group_application_receiver_id")

    @group_application_receiver_id.setter
    def group_application_receiver_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group_application_receiver_id", value)

    @property
    @pulumi.getter(name="groupApplicationReceiverQualifier")
    def group_application_receiver_qualifier(self) -> Optional[pulumi.Input[str]]:
        """
        The group application receiver qualifier.
        """
        return pulumi.get(self, "group_application_receiver_qualifier")

    @group_application_receiver_qualifier.setter
    def group_application_receiver_qualifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group_application_receiver_qualifier", value)

    @property
    @pulumi.getter(name="groupApplicationSenderId")
    def group_application_sender_id(self) -> Optional[pulumi.Input[str]]:
        """
        The group application sender id.
        """
        return pulumi.get(self, "group_application_sender_id")

    @group_application_sender_id.setter
    def group_application_sender_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group_application_sender_id", value)

    @property
    @pulumi.getter(name="groupApplicationSenderQualifier")
    def group_application_sender_qualifier(self) -> Optional[pulumi.Input[str]]:
        """
        The group application sender qualifier.
        """
        return pulumi.get(self, "group_application_sender_qualifier")

    @group_application_sender_qualifier.setter
    def group_application_sender_qualifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group_application_sender_qualifier", value)

    @property
    @pulumi.getter(name="groupAssociationAssignedCode")
    def group_association_assigned_code(self) -> Optional[pulumi.Input[str]]:
        """
        The group association assigned code.
        """
        return pulumi.get(self, "group_association_assigned_code")

    @group_association_assigned_code.setter
    def group_association_assigned_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group_association_assigned_code", value)

    @property
    @pulumi.getter(name="groupControlNumberPrefix")
    def group_control_number_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        The group control number prefix.
        """
        return pulumi.get(self, "group_control_number_prefix")

    @group_control_number_prefix.setter
    def group_control_number_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group_control_number_prefix", value)

    @property
    @pulumi.getter(name="groupControlNumberSuffix")
    def group_control_number_suffix(self) -> Optional[pulumi.Input[str]]:
        """
        The group control number suffix.
        """
        return pulumi.get(self, "group_control_number_suffix")

    @group_control_number_suffix.setter
    def group_control_number_suffix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group_control_number_suffix", value)

    @property
    @pulumi.getter(name="groupControllingAgencyCode")
    def group_controlling_agency_code(self) -> Optional[pulumi.Input[str]]:
        """
        The group controlling agency code.
        """
        return pulumi.get(self, "group_controlling_agency_code")

    @group_controlling_agency_code.setter
    def group_controlling_agency_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group_controlling_agency_code", value)

    @property
    @pulumi.getter(name="groupMessageRelease")
    def group_message_release(self) -> Optional[pulumi.Input[str]]:
        """
        The group message release.
        """
        return pulumi.get(self, "group_message_release")

    @group_message_release.setter
    def group_message_release(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group_message_release", value)

    @property
    @pulumi.getter(name="groupMessageVersion")
    def group_message_version(self) -> Optional[pulumi.Input[str]]:
        """
        The group message version.
        """
        return pulumi.get(self, "group_message_version")

    @group_message_version.setter
    def group_message_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group_message_version", value)

    @property
    @pulumi.getter(name="interchangeControlNumberPrefix")
    def interchange_control_number_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        The interchange control number prefix.
        """
        return pulumi.get(self, "interchange_control_number_prefix")

    @interchange_control_number_prefix.setter
    def interchange_control_number_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "interchange_control_number_prefix", value)

    @property
    @pulumi.getter(name="interchangeControlNumberSuffix")
    def interchange_control_number_suffix(self) -> Optional[pulumi.Input[str]]:
        """
        The interchange control number suffix.
        """
        return pulumi.get(self, "interchange_control_number_suffix")

    @interchange_control_number_suffix.setter
    def interchange_control_number_suffix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "interchange_control_number_suffix", value)

    @property
    @pulumi.getter(name="processingPriorityCode")
    def processing_priority_code(self) -> Optional[pulumi.Input[str]]:
        """
        The processing priority code.
        """
        return pulumi.get(self, "processing_priority_code")

    @processing_priority_code.setter
    def processing_priority_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "processing_priority_code", value)

    @property
    @pulumi.getter(name="receiverInternalIdentification")
    def receiver_internal_identification(self) -> Optional[pulumi.Input[str]]:
        """
        The receiver internal identification.
        """
        return pulumi.get(self, "receiver_internal_identification")

    @receiver_internal_identification.setter
    def receiver_internal_identification(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "receiver_internal_identification", value)

    @property
    @pulumi.getter(name="receiverInternalSubIdentification")
    def receiver_internal_sub_identification(self) -> Optional[pulumi.Input[str]]:
        """
        The receiver internal sub identification.
        """
        return pulumi.get(self, "receiver_internal_sub_identification")

    @receiver_internal_sub_identification.setter
    def receiver_internal_sub_identification(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "receiver_internal_sub_identification", value)

    @property
    @pulumi.getter(name="receiverReverseRoutingAddress")
    def receiver_reverse_routing_address(self) -> Optional[pulumi.Input[str]]:
        """
        The receiver reverse routing address.
        """
        return pulumi.get(self, "receiver_reverse_routing_address")

    @receiver_reverse_routing_address.setter
    def receiver_reverse_routing_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "receiver_reverse_routing_address", value)

    @property
    @pulumi.getter(name="recipientReferencePasswordQualifier")
    def recipient_reference_password_qualifier(self) -> Optional[pulumi.Input[str]]:
        """
        The recipient reference password qualifier.
        """
        return pulumi.get(self, "recipient_reference_password_qualifier")

    @recipient_reference_password_qualifier.setter
    def recipient_reference_password_qualifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "recipient_reference_password_qualifier", value)

    @property
    @pulumi.getter(name="recipientReferencePasswordValue")
    def recipient_reference_password_value(self) -> Optional[pulumi.Input[str]]:
        """
        The recipient reference password value.
        """
        return pulumi.get(self, "recipient_reference_password_value")

    @recipient_reference_password_value.setter
    def recipient_reference_password_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "recipient_reference_password_value", value)

    @property
    @pulumi.getter(name="senderInternalIdentification")
    def sender_internal_identification(self) -> Optional[pulumi.Input[str]]:
        """
        The sender internal identification.
        """
        return pulumi.get(self, "sender_internal_identification")

    @sender_internal_identification.setter
    def sender_internal_identification(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sender_internal_identification", value)

    @property
    @pulumi.getter(name="senderInternalSubIdentification")
    def sender_internal_sub_identification(self) -> Optional[pulumi.Input[str]]:
        """
        The sender internal sub identification.
        """
        return pulumi.get(self, "sender_internal_sub_identification")

    @sender_internal_sub_identification.setter
    def sender_internal_sub_identification(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sender_internal_sub_identification", value)

    @property
    @pulumi.getter(name="senderReverseRoutingAddress")
    def sender_reverse_routing_address(self) -> Optional[pulumi.Input[str]]:
        """
        The sender reverse routing address.
        """
        return pulumi.get(self, "sender_reverse_routing_address")

    @sender_reverse_routing_address.setter
    def sender_reverse_routing_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sender_reverse_routing_address", value)

    @property
    @pulumi.getter(name="transactionSetControlNumberPrefix")
    def transaction_set_control_number_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        The transaction set control number prefix.
        """
        return pulumi.get(self, "transaction_set_control_number_prefix")

    @transaction_set_control_number_prefix.setter
    def transaction_set_control_number_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "transaction_set_control_number_prefix", value)

    @property
    @pulumi.getter(name="transactionSetControlNumberSuffix")
    def transaction_set_control_number_suffix(self) -> Optional[pulumi.Input[str]]:
        """
        The transaction set control number suffix.
        """
        return pulumi.get(self, "transaction_set_control_number_suffix")

    @transaction_set_control_number_suffix.setter
    def transaction_set_control_number_suffix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "transaction_set_control_number_suffix", value)


@pulumi.input_type
class EdifactFramingSettingsArgs:
    def __init__(__self__, *,
                 character_set: pulumi.Input[Union[str, 'EdifactCharacterSet']],
                 component_separator: pulumi.Input[int],
                 data_element_separator: pulumi.Input[int],
                 decimal_point_indicator: pulumi.Input['EdifactDecimalIndicator'],
                 protocol_version: pulumi.Input[int],
                 release_indicator: pulumi.Input[int],
                 repetition_separator: pulumi.Input[int],
                 segment_terminator: pulumi.Input[int],
                 segment_terminator_suffix: pulumi.Input['SegmentTerminatorSuffix'],
                 character_encoding: Optional[pulumi.Input[str]] = None,
                 service_code_list_directory_version: Optional[pulumi.Input[str]] = None):
        """
        The Edifact agreement framing settings.
        :param pulumi.Input[Union[str, 'EdifactCharacterSet']] character_set: The EDIFACT frame setting characterSet.
        :param pulumi.Input[int] component_separator: The component separator.
        :param pulumi.Input[int] data_element_separator: The data element separator.
        :param pulumi.Input['EdifactDecimalIndicator'] decimal_point_indicator: The EDIFACT frame setting decimal indicator.
        :param pulumi.Input[int] protocol_version: The protocol version.
        :param pulumi.Input[int] release_indicator: The release indicator.
        :param pulumi.Input[int] repetition_separator: The repetition separator.
        :param pulumi.Input[int] segment_terminator: The segment terminator.
        :param pulumi.Input['SegmentTerminatorSuffix'] segment_terminator_suffix: The EDIFACT frame setting segment terminator suffix.
        :param pulumi.Input[str] character_encoding: The character encoding.
        :param pulumi.Input[str] service_code_list_directory_version: The service code list directory version.
        """
        pulumi.set(__self__, "character_set", character_set)
        pulumi.set(__self__, "component_separator", component_separator)
        pulumi.set(__self__, "data_element_separator", data_element_separator)
        pulumi.set(__self__, "decimal_point_indicator", decimal_point_indicator)
        pulumi.set(__self__, "protocol_version", protocol_version)
        pulumi.set(__self__, "release_indicator", release_indicator)
        pulumi.set(__self__, "repetition_separator", repetition_separator)
        pulumi.set(__self__, "segment_terminator", segment_terminator)
        pulumi.set(__self__, "segment_terminator_suffix", segment_terminator_suffix)
        if character_encoding is not None:
            pulumi.set(__self__, "character_encoding", character_encoding)
        if service_code_list_directory_version is not None:
            pulumi.set(__self__, "service_code_list_directory_version", service_code_list_directory_version)

    @property
    @pulumi.getter(name="characterSet")
    def character_set(self) -> pulumi.Input[Union[str, 'EdifactCharacterSet']]:
        """
        The EDIFACT frame setting characterSet.
        """
        return pulumi.get(self, "character_set")

    @character_set.setter
    def character_set(self, value: pulumi.Input[Union[str, 'EdifactCharacterSet']]):
        pulumi.set(self, "character_set", value)

    @property
    @pulumi.getter(name="componentSeparator")
    def component_separator(self) -> pulumi.Input[int]:
        """
        The component separator.
        """
        return pulumi.get(self, "component_separator")

    @component_separator.setter
    def component_separator(self, value: pulumi.Input[int]):
        pulumi.set(self, "component_separator", value)

    @property
    @pulumi.getter(name="dataElementSeparator")
    def data_element_separator(self) -> pulumi.Input[int]:
        """
        The data element separator.
        """
        return pulumi.get(self, "data_element_separator")

    @data_element_separator.setter
    def data_element_separator(self, value: pulumi.Input[int]):
        pulumi.set(self, "data_element_separator", value)

    @property
    @pulumi.getter(name="decimalPointIndicator")
    def decimal_point_indicator(self) -> pulumi.Input['EdifactDecimalIndicator']:
        """
        The EDIFACT frame setting decimal indicator.
        """
        return pulumi.get(self, "decimal_point_indicator")

    @decimal_point_indicator.setter
    def decimal_point_indicator(self, value: pulumi.Input['EdifactDecimalIndicator']):
        pulumi.set(self, "decimal_point_indicator", value)

    @property
    @pulumi.getter(name="protocolVersion")
    def protocol_version(self) -> pulumi.Input[int]:
        """
        The protocol version.
        """
        return pulumi.get(self, "protocol_version")

    @protocol_version.setter
    def protocol_version(self, value: pulumi.Input[int]):
        pulumi.set(self, "protocol_version", value)

    @property
    @pulumi.getter(name="releaseIndicator")
    def release_indicator(self) -> pulumi.Input[int]:
        """
        The release indicator.
        """
        return pulumi.get(self, "release_indicator")

    @release_indicator.setter
    def release_indicator(self, value: pulumi.Input[int]):
        pulumi.set(self, "release_indicator", value)

    @property
    @pulumi.getter(name="repetitionSeparator")
    def repetition_separator(self) -> pulumi.Input[int]:
        """
        The repetition separator.
        """
        return pulumi.get(self, "repetition_separator")

    @repetition_separator.setter
    def repetition_separator(self, value: pulumi.Input[int]):
        pulumi.set(self, "repetition_separator", value)

    @property
    @pulumi.getter(name="segmentTerminator")
    def segment_terminator(self) -> pulumi.Input[int]:
        """
        The segment terminator.
        """
        return pulumi.get(self, "segment_terminator")

    @segment_terminator.setter
    def segment_terminator(self, value: pulumi.Input[int]):
        pulumi.set(self, "segment_terminator", value)

    @property
    @pulumi.getter(name="segmentTerminatorSuffix")
    def segment_terminator_suffix(self) -> pulumi.Input['SegmentTerminatorSuffix']:
        """
        The EDIFACT frame setting segment terminator suffix.
        """
        return pulumi.get(self, "segment_terminator_suffix")

    @segment_terminator_suffix.setter
    def segment_terminator_suffix(self, value: pulumi.Input['SegmentTerminatorSuffix']):
        pulumi.set(self, "segment_terminator_suffix", value)

    @property
    @pulumi.getter(name="characterEncoding")
    def character_encoding(self) -> Optional[pulumi.Input[str]]:
        """
        The character encoding.
        """
        return pulumi.get(self, "character_encoding")

    @character_encoding.setter
    def character_encoding(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "character_encoding", value)

    @property
    @pulumi.getter(name="serviceCodeListDirectoryVersion")
    def service_code_list_directory_version(self) -> Optional[pulumi.Input[str]]:
        """
        The service code list directory version.
        """
        return pulumi.get(self, "service_code_list_directory_version")

    @service_code_list_directory_version.setter
    def service_code_list_directory_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_code_list_directory_version", value)


@pulumi.input_type
class EdifactMessageFilterArgs:
    def __init__(__self__, *,
                 message_filter_type: pulumi.Input[Union[str, 'MessageFilterType']]):
        """
        The Edifact message filter for odata query.
        :param pulumi.Input[Union[str, 'MessageFilterType']] message_filter_type: The message filter type.
        """
        pulumi.set(__self__, "message_filter_type", message_filter_type)

    @property
    @pulumi.getter(name="messageFilterType")
    def message_filter_type(self) -> pulumi.Input[Union[str, 'MessageFilterType']]:
        """
        The message filter type.
        """
        return pulumi.get(self, "message_filter_type")

    @message_filter_type.setter
    def message_filter_type(self, value: pulumi.Input[Union[str, 'MessageFilterType']]):
        pulumi.set(self, "message_filter_type", value)


@pulumi.input_type
class EdifactMessageIdentifierArgs:
    def __init__(__self__, *,
                 message_id: pulumi.Input[str]):
        """
        The Edifact message identifier.
        :param pulumi.Input[str] message_id: The message id on which this envelope settings has to be applied.
        """
        pulumi.set(__self__, "message_id", message_id)

    @property
    @pulumi.getter(name="messageId")
    def message_id(self) -> pulumi.Input[str]:
        """
        The message id on which this envelope settings has to be applied.
        """
        return pulumi.get(self, "message_id")

    @message_id.setter
    def message_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "message_id", value)


@pulumi.input_type
class EdifactOneWayAgreementArgs:
    def __init__(__self__, *,
                 protocol_settings: pulumi.Input['EdifactProtocolSettingsArgs'],
                 receiver_business_identity: pulumi.Input['BusinessIdentityArgs'],
                 sender_business_identity: pulumi.Input['BusinessIdentityArgs']):
        """
        The Edifact one way agreement.
        :param pulumi.Input['EdifactProtocolSettingsArgs'] protocol_settings: The EDIFACT protocol settings.
        :param pulumi.Input['BusinessIdentityArgs'] receiver_business_identity: The receiver business identity
        :param pulumi.Input['BusinessIdentityArgs'] sender_business_identity: The sender business identity
        """
        pulumi.set(__self__, "protocol_settings", protocol_settings)
        pulumi.set(__self__, "receiver_business_identity", receiver_business_identity)
        pulumi.set(__self__, "sender_business_identity", sender_business_identity)

    @property
    @pulumi.getter(name="protocolSettings")
    def protocol_settings(self) -> pulumi.Input['EdifactProtocolSettingsArgs']:
        """
        The EDIFACT protocol settings.
        """
        return pulumi.get(self, "protocol_settings")

    @protocol_settings.setter
    def protocol_settings(self, value: pulumi.Input['EdifactProtocolSettingsArgs']):
        pulumi.set(self, "protocol_settings", value)

    @property
    @pulumi.getter(name="receiverBusinessIdentity")
    def receiver_business_identity(self) -> pulumi.Input['BusinessIdentityArgs']:
        """
        The receiver business identity
        """
        return pulumi.get(self, "receiver_business_identity")

    @receiver_business_identity.setter
    def receiver_business_identity(self, value: pulumi.Input['BusinessIdentityArgs']):
        pulumi.set(self, "receiver_business_identity", value)

    @property
    @pulumi.getter(name="senderBusinessIdentity")
    def sender_business_identity(self) -> pulumi.Input['BusinessIdentityArgs']:
        """
        The sender business identity
        """
        return pulumi.get(self, "sender_business_identity")

    @sender_business_identity.setter
    def sender_business_identity(self, value: pulumi.Input['BusinessIdentityArgs']):
        pulumi.set(self, "sender_business_identity", value)


@pulumi.input_type
class EdifactProcessingSettingsArgs:
    def __init__(__self__, *,
                 create_empty_xml_tags_for_trailing_separators: pulumi.Input[bool],
                 mask_security_info: pulumi.Input[bool],
                 preserve_interchange: pulumi.Input[bool],
                 suspend_interchange_on_error: pulumi.Input[bool],
                 use_dot_as_decimal_separator: pulumi.Input[bool]):
        """
        The Edifact agreement protocol settings.
        :param pulumi.Input[bool] create_empty_xml_tags_for_trailing_separators: The value indicating whether to create empty xml tags for trailing separators.
        :param pulumi.Input[bool] mask_security_info: The value indicating whether to mask security information.
        :param pulumi.Input[bool] preserve_interchange: The value indicating whether to preserve interchange.
        :param pulumi.Input[bool] suspend_interchange_on_error: The value indicating whether to suspend interchange on error.
        :param pulumi.Input[bool] use_dot_as_decimal_separator: The value indicating whether to use dot as decimal separator.
        """
        pulumi.set(__self__, "create_empty_xml_tags_for_trailing_separators", create_empty_xml_tags_for_trailing_separators)
        pulumi.set(__self__, "mask_security_info", mask_security_info)
        pulumi.set(__self__, "preserve_interchange", preserve_interchange)
        pulumi.set(__self__, "suspend_interchange_on_error", suspend_interchange_on_error)
        pulumi.set(__self__, "use_dot_as_decimal_separator", use_dot_as_decimal_separator)

    @property
    @pulumi.getter(name="createEmptyXmlTagsForTrailingSeparators")
    def create_empty_xml_tags_for_trailing_separators(self) -> pulumi.Input[bool]:
        """
        The value indicating whether to create empty xml tags for trailing separators.
        """
        return pulumi.get(self, "create_empty_xml_tags_for_trailing_separators")

    @create_empty_xml_tags_for_trailing_separators.setter
    def create_empty_xml_tags_for_trailing_separators(self, value: pulumi.Input[bool]):
        pulumi.set(self, "create_empty_xml_tags_for_trailing_separators", value)

    @property
    @pulumi.getter(name="maskSecurityInfo")
    def mask_security_info(self) -> pulumi.Input[bool]:
        """
        The value indicating whether to mask security information.
        """
        return pulumi.get(self, "mask_security_info")

    @mask_security_info.setter
    def mask_security_info(self, value: pulumi.Input[bool]):
        pulumi.set(self, "mask_security_info", value)

    @property
    @pulumi.getter(name="preserveInterchange")
    def preserve_interchange(self) -> pulumi.Input[bool]:
        """
        The value indicating whether to preserve interchange.
        """
        return pulumi.get(self, "preserve_interchange")

    @preserve_interchange.setter
    def preserve_interchange(self, value: pulumi.Input[bool]):
        pulumi.set(self, "preserve_interchange", value)

    @property
    @pulumi.getter(name="suspendInterchangeOnError")
    def suspend_interchange_on_error(self) -> pulumi.Input[bool]:
        """
        The value indicating whether to suspend interchange on error.
        """
        return pulumi.get(self, "suspend_interchange_on_error")

    @suspend_interchange_on_error.setter
    def suspend_interchange_on_error(self, value: pulumi.Input[bool]):
        pulumi.set(self, "suspend_interchange_on_error", value)

    @property
    @pulumi.getter(name="useDotAsDecimalSeparator")
    def use_dot_as_decimal_separator(self) -> pulumi.Input[bool]:
        """
        The value indicating whether to use dot as decimal separator.
        """
        return pulumi.get(self, "use_dot_as_decimal_separator")

    @use_dot_as_decimal_separator.setter
    def use_dot_as_decimal_separator(self, value: pulumi.Input[bool]):
        pulumi.set(self, "use_dot_as_decimal_separator", value)


@pulumi.input_type
class EdifactProtocolSettingsArgs:
    def __init__(__self__, *,
                 acknowledgement_settings: pulumi.Input['EdifactAcknowledgementSettingsArgs'],
                 envelope_settings: pulumi.Input['EdifactEnvelopeSettingsArgs'],
                 framing_settings: pulumi.Input['EdifactFramingSettingsArgs'],
                 message_filter: pulumi.Input['EdifactMessageFilterArgs'],
                 processing_settings: pulumi.Input['EdifactProcessingSettingsArgs'],
                 schema_references: pulumi.Input[Sequence[pulumi.Input['EdifactSchemaReferenceArgs']]],
                 validation_settings: pulumi.Input['EdifactValidationSettingsArgs'],
                 edifact_delimiter_overrides: Optional[pulumi.Input[Sequence[pulumi.Input['EdifactDelimiterOverrideArgs']]]] = None,
                 envelope_overrides: Optional[pulumi.Input[Sequence[pulumi.Input['EdifactEnvelopeOverrideArgs']]]] = None,
                 message_filter_list: Optional[pulumi.Input[Sequence[pulumi.Input['EdifactMessageIdentifierArgs']]]] = None,
                 validation_overrides: Optional[pulumi.Input[Sequence[pulumi.Input['EdifactValidationOverrideArgs']]]] = None):
        """
        The Edifact agreement protocol settings.
        :param pulumi.Input['EdifactAcknowledgementSettingsArgs'] acknowledgement_settings: The EDIFACT acknowledgement settings.
        :param pulumi.Input['EdifactEnvelopeSettingsArgs'] envelope_settings: The EDIFACT envelope settings.
        :param pulumi.Input['EdifactFramingSettingsArgs'] framing_settings: The EDIFACT framing settings.
        :param pulumi.Input['EdifactMessageFilterArgs'] message_filter: The EDIFACT message filter.
        :param pulumi.Input['EdifactProcessingSettingsArgs'] processing_settings: The EDIFACT processing Settings.
        :param pulumi.Input[Sequence[pulumi.Input['EdifactSchemaReferenceArgs']]] schema_references: The EDIFACT schema references.
        :param pulumi.Input['EdifactValidationSettingsArgs'] validation_settings: The EDIFACT validation settings.
        :param pulumi.Input[Sequence[pulumi.Input['EdifactDelimiterOverrideArgs']]] edifact_delimiter_overrides: The EDIFACT delimiter override settings.
        :param pulumi.Input[Sequence[pulumi.Input['EdifactEnvelopeOverrideArgs']]] envelope_overrides: The EDIFACT envelope override settings.
        :param pulumi.Input[Sequence[pulumi.Input['EdifactMessageIdentifierArgs']]] message_filter_list: The EDIFACT message filter list.
        :param pulumi.Input[Sequence[pulumi.Input['EdifactValidationOverrideArgs']]] validation_overrides: The EDIFACT validation override settings.
        """
        pulumi.set(__self__, "acknowledgement_settings", acknowledgement_settings)
        pulumi.set(__self__, "envelope_settings", envelope_settings)
        pulumi.set(__self__, "framing_settings", framing_settings)
        pulumi.set(__self__, "message_filter", message_filter)
        pulumi.set(__self__, "processing_settings", processing_settings)
        pulumi.set(__self__, "schema_references", schema_references)
        pulumi.set(__self__, "validation_settings", validation_settings)
        if edifact_delimiter_overrides is not None:
            pulumi.set(__self__, "edifact_delimiter_overrides", edifact_delimiter_overrides)
        if envelope_overrides is not None:
            pulumi.set(__self__, "envelope_overrides", envelope_overrides)
        if message_filter_list is not None:
            pulumi.set(__self__, "message_filter_list", message_filter_list)
        if validation_overrides is not None:
            pulumi.set(__self__, "validation_overrides", validation_overrides)

    @property
    @pulumi.getter(name="acknowledgementSettings")
    def acknowledgement_settings(self) -> pulumi.Input['EdifactAcknowledgementSettingsArgs']:
        """
        The EDIFACT acknowledgement settings.
        """
        return pulumi.get(self, "acknowledgement_settings")

    @acknowledgement_settings.setter
    def acknowledgement_settings(self, value: pulumi.Input['EdifactAcknowledgementSettingsArgs']):
        pulumi.set(self, "acknowledgement_settings", value)

    @property
    @pulumi.getter(name="envelopeSettings")
    def envelope_settings(self) -> pulumi.Input['EdifactEnvelopeSettingsArgs']:
        """
        The EDIFACT envelope settings.
        """
        return pulumi.get(self, "envelope_settings")

    @envelope_settings.setter
    def envelope_settings(self, value: pulumi.Input['EdifactEnvelopeSettingsArgs']):
        pulumi.set(self, "envelope_settings", value)

    @property
    @pulumi.getter(name="framingSettings")
    def framing_settings(self) -> pulumi.Input['EdifactFramingSettingsArgs']:
        """
        The EDIFACT framing settings.
        """
        return pulumi.get(self, "framing_settings")

    @framing_settings.setter
    def framing_settings(self, value: pulumi.Input['EdifactFramingSettingsArgs']):
        pulumi.set(self, "framing_settings", value)

    @property
    @pulumi.getter(name="messageFilter")
    def message_filter(self) -> pulumi.Input['EdifactMessageFilterArgs']:
        """
        The EDIFACT message filter.
        """
        return pulumi.get(self, "message_filter")

    @message_filter.setter
    def message_filter(self, value: pulumi.Input['EdifactMessageFilterArgs']):
        pulumi.set(self, "message_filter", value)

    @property
    @pulumi.getter(name="processingSettings")
    def processing_settings(self) -> pulumi.Input['EdifactProcessingSettingsArgs']:
        """
        The EDIFACT processing Settings.
        """
        return pulumi.get(self, "processing_settings")

    @processing_settings.setter
    def processing_settings(self, value: pulumi.Input['EdifactProcessingSettingsArgs']):
        pulumi.set(self, "processing_settings", value)

    @property
    @pulumi.getter(name="schemaReferences")
    def schema_references(self) -> pulumi.Input[Sequence[pulumi.Input['EdifactSchemaReferenceArgs']]]:
        """
        The EDIFACT schema references.
        """
        return pulumi.get(self, "schema_references")

    @schema_references.setter
    def schema_references(self, value: pulumi.Input[Sequence[pulumi.Input['EdifactSchemaReferenceArgs']]]):
        pulumi.set(self, "schema_references", value)

    @property
    @pulumi.getter(name="validationSettings")
    def validation_settings(self) -> pulumi.Input['EdifactValidationSettingsArgs']:
        """
        The EDIFACT validation settings.
        """
        return pulumi.get(self, "validation_settings")

    @validation_settings.setter
    def validation_settings(self, value: pulumi.Input['EdifactValidationSettingsArgs']):
        pulumi.set(self, "validation_settings", value)

    @property
    @pulumi.getter(name="edifactDelimiterOverrides")
    def edifact_delimiter_overrides(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EdifactDelimiterOverrideArgs']]]]:
        """
        The EDIFACT delimiter override settings.
        """
        return pulumi.get(self, "edifact_delimiter_overrides")

    @edifact_delimiter_overrides.setter
    def edifact_delimiter_overrides(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EdifactDelimiterOverrideArgs']]]]):
        pulumi.set(self, "edifact_delimiter_overrides", value)

    @property
    @pulumi.getter(name="envelopeOverrides")
    def envelope_overrides(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EdifactEnvelopeOverrideArgs']]]]:
        """
        The EDIFACT envelope override settings.
        """
        return pulumi.get(self, "envelope_overrides")

    @envelope_overrides.setter
    def envelope_overrides(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EdifactEnvelopeOverrideArgs']]]]):
        pulumi.set(self, "envelope_overrides", value)

    @property
    @pulumi.getter(name="messageFilterList")
    def message_filter_list(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EdifactMessageIdentifierArgs']]]]:
        """
        The EDIFACT message filter list.
        """
        return pulumi.get(self, "message_filter_list")

    @message_filter_list.setter
    def message_filter_list(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EdifactMessageIdentifierArgs']]]]):
        pulumi.set(self, "message_filter_list", value)

    @property
    @pulumi.getter(name="validationOverrides")
    def validation_overrides(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EdifactValidationOverrideArgs']]]]:
        """
        The EDIFACT validation override settings.
        """
        return pulumi.get(self, "validation_overrides")

    @validation_overrides.setter
    def validation_overrides(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EdifactValidationOverrideArgs']]]]):
        pulumi.set(self, "validation_overrides", value)


@pulumi.input_type
class EdifactSchemaReferenceArgs:
    def __init__(__self__, *,
                 message_id: pulumi.Input[str],
                 message_release: pulumi.Input[str],
                 message_version: pulumi.Input[str],
                 schema_name: pulumi.Input[str],
                 association_assigned_code: Optional[pulumi.Input[str]] = None,
                 sender_application_id: Optional[pulumi.Input[str]] = None,
                 sender_application_qualifier: Optional[pulumi.Input[str]] = None):
        """
        The Edifact schema reference.
        :param pulumi.Input[str] message_id: The message id.
        :param pulumi.Input[str] message_release: The message release version.
        :param pulumi.Input[str] message_version: The message version.
        :param pulumi.Input[str] schema_name: The schema name.
        :param pulumi.Input[str] association_assigned_code: The association assigned code.
        :param pulumi.Input[str] sender_application_id: The sender application id.
        :param pulumi.Input[str] sender_application_qualifier: The sender application qualifier.
        """
        pulumi.set(__self__, "message_id", message_id)
        pulumi.set(__self__, "message_release", message_release)
        pulumi.set(__self__, "message_version", message_version)
        pulumi.set(__self__, "schema_name", schema_name)
        if association_assigned_code is not None:
            pulumi.set(__self__, "association_assigned_code", association_assigned_code)
        if sender_application_id is not None:
            pulumi.set(__self__, "sender_application_id", sender_application_id)
        if sender_application_qualifier is not None:
            pulumi.set(__self__, "sender_application_qualifier", sender_application_qualifier)

    @property
    @pulumi.getter(name="messageId")
    def message_id(self) -> pulumi.Input[str]:
        """
        The message id.
        """
        return pulumi.get(self, "message_id")

    @message_id.setter
    def message_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "message_id", value)

    @property
    @pulumi.getter(name="messageRelease")
    def message_release(self) -> pulumi.Input[str]:
        """
        The message release version.
        """
        return pulumi.get(self, "message_release")

    @message_release.setter
    def message_release(self, value: pulumi.Input[str]):
        pulumi.set(self, "message_release", value)

    @property
    @pulumi.getter(name="messageVersion")
    def message_version(self) -> pulumi.Input[str]:
        """
        The message version.
        """
        return pulumi.get(self, "message_version")

    @message_version.setter
    def message_version(self, value: pulumi.Input[str]):
        pulumi.set(self, "message_version", value)

    @property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> pulumi.Input[str]:
        """
        The schema name.
        """
        return pulumi.get(self, "schema_name")

    @schema_name.setter
    def schema_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "schema_name", value)

    @property
    @pulumi.getter(name="associationAssignedCode")
    def association_assigned_code(self) -> Optional[pulumi.Input[str]]:
        """
        The association assigned code.
        """
        return pulumi.get(self, "association_assigned_code")

    @association_assigned_code.setter
    def association_assigned_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "association_assigned_code", value)

    @property
    @pulumi.getter(name="senderApplicationId")
    def sender_application_id(self) -> Optional[pulumi.Input[str]]:
        """
        The sender application id.
        """
        return pulumi.get(self, "sender_application_id")

    @sender_application_id.setter
    def sender_application_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sender_application_id", value)

    @property
    @pulumi.getter(name="senderApplicationQualifier")
    def sender_application_qualifier(self) -> Optional[pulumi.Input[str]]:
        """
        The sender application qualifier.
        """
        return pulumi.get(self, "sender_application_qualifier")

    @sender_application_qualifier.setter
    def sender_application_qualifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sender_application_qualifier", value)


@pulumi.input_type
class EdifactValidationOverrideArgs:
    def __init__(__self__, *,
                 allow_leading_and_trailing_spaces_and_zeroes: pulumi.Input[bool],
                 enforce_character_set: pulumi.Input[bool],
                 message_id: pulumi.Input[str],
                 trailing_separator_policy: pulumi.Input[Union[str, 'TrailingSeparatorPolicy']],
                 trim_leading_and_trailing_spaces_and_zeroes: pulumi.Input[bool],
                 validate_edi_types: pulumi.Input[bool],
                 validate_xsd_types: pulumi.Input[bool]):
        """
        The Edifact validation override settings.
        :param pulumi.Input[bool] allow_leading_and_trailing_spaces_and_zeroes: The value indicating whether to allow leading and trailing spaces and zeroes.
        :param pulumi.Input[bool] enforce_character_set: The value indicating whether to validate character Set.
        :param pulumi.Input[str] message_id: The message id on which the validation settings has to be applied.
        :param pulumi.Input[Union[str, 'TrailingSeparatorPolicy']] trailing_separator_policy: The trailing separator policy.
        :param pulumi.Input[bool] trim_leading_and_trailing_spaces_and_zeroes: The value indicating whether to trim leading and trailing spaces and zeroes.
        :param pulumi.Input[bool] validate_edi_types: The value indicating whether to validate EDI types.
        :param pulumi.Input[bool] validate_xsd_types: The value indicating whether to validate XSD types.
        """
        pulumi.set(__self__, "allow_leading_and_trailing_spaces_and_zeroes", allow_leading_and_trailing_spaces_and_zeroes)
        pulumi.set(__self__, "enforce_character_set", enforce_character_set)
        pulumi.set(__self__, "message_id", message_id)
        pulumi.set(__self__, "trailing_separator_policy", trailing_separator_policy)
        pulumi.set(__self__, "trim_leading_and_trailing_spaces_and_zeroes", trim_leading_and_trailing_spaces_and_zeroes)
        pulumi.set(__self__, "validate_edi_types", validate_edi_types)
        pulumi.set(__self__, "validate_xsd_types", validate_xsd_types)

    @property
    @pulumi.getter(name="allowLeadingAndTrailingSpacesAndZeroes")
    def allow_leading_and_trailing_spaces_and_zeroes(self) -> pulumi.Input[bool]:
        """
        The value indicating whether to allow leading and trailing spaces and zeroes.
        """
        return pulumi.get(self, "allow_leading_and_trailing_spaces_and_zeroes")

    @allow_leading_and_trailing_spaces_and_zeroes.setter
    def allow_leading_and_trailing_spaces_and_zeroes(self, value: pulumi.Input[bool]):
        pulumi.set(self, "allow_leading_and_trailing_spaces_and_zeroes", value)

    @property
    @pulumi.getter(name="enforceCharacterSet")
    def enforce_character_set(self) -> pulumi.Input[bool]:
        """
        The value indicating whether to validate character Set.
        """
        return pulumi.get(self, "enforce_character_set")

    @enforce_character_set.setter
    def enforce_character_set(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enforce_character_set", value)

    @property
    @pulumi.getter(name="messageId")
    def message_id(self) -> pulumi.Input[str]:
        """
        The message id on which the validation settings has to be applied.
        """
        return pulumi.get(self, "message_id")

    @message_id.setter
    def message_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "message_id", value)

    @property
    @pulumi.getter(name="trailingSeparatorPolicy")
    def trailing_separator_policy(self) -> pulumi.Input[Union[str, 'TrailingSeparatorPolicy']]:
        """
        The trailing separator policy.
        """
        return pulumi.get(self, "trailing_separator_policy")

    @trailing_separator_policy.setter
    def trailing_separator_policy(self, value: pulumi.Input[Union[str, 'TrailingSeparatorPolicy']]):
        pulumi.set(self, "trailing_separator_policy", value)

    @property
    @pulumi.getter(name="trimLeadingAndTrailingSpacesAndZeroes")
    def trim_leading_and_trailing_spaces_and_zeroes(self) -> pulumi.Input[bool]:
        """
        The value indicating whether to trim leading and trailing spaces and zeroes.
        """
        return pulumi.get(self, "trim_leading_and_trailing_spaces_and_zeroes")

    @trim_leading_and_trailing_spaces_and_zeroes.setter
    def trim_leading_and_trailing_spaces_and_zeroes(self, value: pulumi.Input[bool]):
        pulumi.set(self, "trim_leading_and_trailing_spaces_and_zeroes", value)

    @property
    @pulumi.getter(name="validateEDITypes")
    def validate_edi_types(self) -> pulumi.Input[bool]:
        """
        The value indicating whether to validate EDI types.
        """
        return pulumi.get(self, "validate_edi_types")

    @validate_edi_types.setter
    def validate_edi_types(self, value: pulumi.Input[bool]):
        pulumi.set(self, "validate_edi_types", value)

    @property
    @pulumi.getter(name="validateXSDTypes")
    def validate_xsd_types(self) -> pulumi.Input[bool]:
        """
        The value indicating whether to validate XSD types.
        """
        return pulumi.get(self, "validate_xsd_types")

    @validate_xsd_types.setter
    def validate_xsd_types(self, value: pulumi.Input[bool]):
        pulumi.set(self, "validate_xsd_types", value)


@pulumi.input_type
class EdifactValidationSettingsArgs:
    def __init__(__self__, *,
                 allow_leading_and_trailing_spaces_and_zeroes: pulumi.Input[bool],
                 check_duplicate_group_control_number: pulumi.Input[bool],
                 check_duplicate_interchange_control_number: pulumi.Input[bool],
                 check_duplicate_transaction_set_control_number: pulumi.Input[bool],
                 interchange_control_number_validity_days: pulumi.Input[int],
                 trailing_separator_policy: pulumi.Input[Union[str, 'TrailingSeparatorPolicy']],
                 trim_leading_and_trailing_spaces_and_zeroes: pulumi.Input[bool],
                 validate_character_set: pulumi.Input[bool],
                 validate_edi_types: pulumi.Input[bool],
                 validate_xsd_types: pulumi.Input[bool]):
        """
        The Edifact agreement validation settings.
        :param pulumi.Input[bool] allow_leading_and_trailing_spaces_and_zeroes: The value indicating whether to allow leading and trailing spaces and zeroes.
        :param pulumi.Input[bool] check_duplicate_group_control_number: The value indicating whether to check for duplicate group control number.
        :param pulumi.Input[bool] check_duplicate_interchange_control_number: The value indicating whether to check for duplicate interchange control number.
        :param pulumi.Input[bool] check_duplicate_transaction_set_control_number: The value indicating whether to check for duplicate transaction set control number.
        :param pulumi.Input[int] interchange_control_number_validity_days: The validity period of interchange control number.
        :param pulumi.Input[Union[str, 'TrailingSeparatorPolicy']] trailing_separator_policy: The trailing separator policy.
        :param pulumi.Input[bool] trim_leading_and_trailing_spaces_and_zeroes: The value indicating whether to trim leading and trailing spaces and zeroes.
        :param pulumi.Input[bool] validate_character_set: The value indicating whether to validate character set in the message.
        :param pulumi.Input[bool] validate_edi_types: The value indicating whether to Whether to validate EDI types.
        :param pulumi.Input[bool] validate_xsd_types: The value indicating whether to Whether to validate XSD types.
        """
        pulumi.set(__self__, "allow_leading_and_trailing_spaces_and_zeroes", allow_leading_and_trailing_spaces_and_zeroes)
        pulumi.set(__self__, "check_duplicate_group_control_number", check_duplicate_group_control_number)
        pulumi.set(__self__, "check_duplicate_interchange_control_number", check_duplicate_interchange_control_number)
        pulumi.set(__self__, "check_duplicate_transaction_set_control_number", check_duplicate_transaction_set_control_number)
        pulumi.set(__self__, "interchange_control_number_validity_days", interchange_control_number_validity_days)
        pulumi.set(__self__, "trailing_separator_policy", trailing_separator_policy)
        pulumi.set(__self__, "trim_leading_and_trailing_spaces_and_zeroes", trim_leading_and_trailing_spaces_and_zeroes)
        pulumi.set(__self__, "validate_character_set", validate_character_set)
        pulumi.set(__self__, "validate_edi_types", validate_edi_types)
        pulumi.set(__self__, "validate_xsd_types", validate_xsd_types)

    @property
    @pulumi.getter(name="allowLeadingAndTrailingSpacesAndZeroes")
    def allow_leading_and_trailing_spaces_and_zeroes(self) -> pulumi.Input[bool]:
        """
        The value indicating whether to allow leading and trailing spaces and zeroes.
        """
        return pulumi.get(self, "allow_leading_and_trailing_spaces_and_zeroes")

    @allow_leading_and_trailing_spaces_and_zeroes.setter
    def allow_leading_and_trailing_spaces_and_zeroes(self, value: pulumi.Input[bool]):
        pulumi.set(self, "allow_leading_and_trailing_spaces_and_zeroes", value)

    @property
    @pulumi.getter(name="checkDuplicateGroupControlNumber")
    def check_duplicate_group_control_number(self) -> pulumi.Input[bool]:
        """
        The value indicating whether to check for duplicate group control number.
        """
        return pulumi.get(self, "check_duplicate_group_control_number")

    @check_duplicate_group_control_number.setter
    def check_duplicate_group_control_number(self, value: pulumi.Input[bool]):
        pulumi.set(self, "check_duplicate_group_control_number", value)

    @property
    @pulumi.getter(name="checkDuplicateInterchangeControlNumber")
    def check_duplicate_interchange_control_number(self) -> pulumi.Input[bool]:
        """
        The value indicating whether to check for duplicate interchange control number.
        """
        return pulumi.get(self, "check_duplicate_interchange_control_number")

    @check_duplicate_interchange_control_number.setter
    def check_duplicate_interchange_control_number(self, value: pulumi.Input[bool]):
        pulumi.set(self, "check_duplicate_interchange_control_number", value)

    @property
    @pulumi.getter(name="checkDuplicateTransactionSetControlNumber")
    def check_duplicate_transaction_set_control_number(self) -> pulumi.Input[bool]:
        """
        The value indicating whether to check for duplicate transaction set control number.
        """
        return pulumi.get(self, "check_duplicate_transaction_set_control_number")

    @check_duplicate_transaction_set_control_number.setter
    def check_duplicate_transaction_set_control_number(self, value: pulumi.Input[bool]):
        pulumi.set(self, "check_duplicate_transaction_set_control_number", value)

    @property
    @pulumi.getter(name="interchangeControlNumberValidityDays")
    def interchange_control_number_validity_days(self) -> pulumi.Input[int]:
        """
        The validity period of interchange control number.
        """
        return pulumi.get(self, "interchange_control_number_validity_days")

    @interchange_control_number_validity_days.setter
    def interchange_control_number_validity_days(self, value: pulumi.Input[int]):
        pulumi.set(self, "interchange_control_number_validity_days", value)

    @property
    @pulumi.getter(name="trailingSeparatorPolicy")
    def trailing_separator_policy(self) -> pulumi.Input[Union[str, 'TrailingSeparatorPolicy']]:
        """
        The trailing separator policy.
        """
        return pulumi.get(self, "trailing_separator_policy")

    @trailing_separator_policy.setter
    def trailing_separator_policy(self, value: pulumi.Input[Union[str, 'TrailingSeparatorPolicy']]):
        pulumi.set(self, "trailing_separator_policy", value)

    @property
    @pulumi.getter(name="trimLeadingAndTrailingSpacesAndZeroes")
    def trim_leading_and_trailing_spaces_and_zeroes(self) -> pulumi.Input[bool]:
        """
        The value indicating whether to trim leading and trailing spaces and zeroes.
        """
        return pulumi.get(self, "trim_leading_and_trailing_spaces_and_zeroes")

    @trim_leading_and_trailing_spaces_and_zeroes.setter
    def trim_leading_and_trailing_spaces_and_zeroes(self, value: pulumi.Input[bool]):
        pulumi.set(self, "trim_leading_and_trailing_spaces_and_zeroes", value)

    @property
    @pulumi.getter(name="validateCharacterSet")
    def validate_character_set(self) -> pulumi.Input[bool]:
        """
        The value indicating whether to validate character set in the message.
        """
        return pulumi.get(self, "validate_character_set")

    @validate_character_set.setter
    def validate_character_set(self, value: pulumi.Input[bool]):
        pulumi.set(self, "validate_character_set", value)

    @property
    @pulumi.getter(name="validateEDITypes")
    def validate_edi_types(self) -> pulumi.Input[bool]:
        """
        The value indicating whether to Whether to validate EDI types.
        """
        return pulumi.get(self, "validate_edi_types")

    @validate_edi_types.setter
    def validate_edi_types(self, value: pulumi.Input[bool]):
        pulumi.set(self, "validate_edi_types", value)

    @property
    @pulumi.getter(name="validateXSDTypes")
    def validate_xsd_types(self) -> pulumi.Input[bool]:
        """
        The value indicating whether to Whether to validate XSD types.
        """
        return pulumi.get(self, "validate_xsd_types")

    @validate_xsd_types.setter
    def validate_xsd_types(self, value: pulumi.Input[bool]):
        pulumi.set(self, "validate_xsd_types", value)


@pulumi.input_type
class FlowAccessControlConfigurationPolicyArgs:
    def __init__(__self__, *,
                 allowed_caller_ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input['IpAddressRangeArgs']]]] = None,
                 open_authentication_policies: Optional[pulumi.Input['OpenAuthenticationAccessPoliciesArgs']] = None):
        """
        The access control configuration policy.
        :param pulumi.Input[Sequence[pulumi.Input['IpAddressRangeArgs']]] allowed_caller_ip_addresses: The allowed caller IP address ranges.
        :param pulumi.Input['OpenAuthenticationAccessPoliciesArgs'] open_authentication_policies: The authentication policies for workflow.
        """
        if allowed_caller_ip_addresses is not None:
            pulumi.set(__self__, "allowed_caller_ip_addresses", allowed_caller_ip_addresses)
        if open_authentication_policies is not None:
            pulumi.set(__self__, "open_authentication_policies", open_authentication_policies)

    @property
    @pulumi.getter(name="allowedCallerIpAddresses")
    def allowed_caller_ip_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IpAddressRangeArgs']]]]:
        """
        The allowed caller IP address ranges.
        """
        return pulumi.get(self, "allowed_caller_ip_addresses")

    @allowed_caller_ip_addresses.setter
    def allowed_caller_ip_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IpAddressRangeArgs']]]]):
        pulumi.set(self, "allowed_caller_ip_addresses", value)

    @property
    @pulumi.getter(name="openAuthenticationPolicies")
    def open_authentication_policies(self) -> Optional[pulumi.Input['OpenAuthenticationAccessPoliciesArgs']]:
        """
        The authentication policies for workflow.
        """
        return pulumi.get(self, "open_authentication_policies")

    @open_authentication_policies.setter
    def open_authentication_policies(self, value: Optional[pulumi.Input['OpenAuthenticationAccessPoliciesArgs']]):
        pulumi.set(self, "open_authentication_policies", value)


@pulumi.input_type
class FlowAccessControlConfigurationArgs:
    def __init__(__self__, *,
                 actions: Optional[pulumi.Input['FlowAccessControlConfigurationPolicyArgs']] = None,
                 contents: Optional[pulumi.Input['FlowAccessControlConfigurationPolicyArgs']] = None,
                 triggers: Optional[pulumi.Input['FlowAccessControlConfigurationPolicyArgs']] = None,
                 workflow_management: Optional[pulumi.Input['FlowAccessControlConfigurationPolicyArgs']] = None):
        """
        The access control configuration.
        :param pulumi.Input['FlowAccessControlConfigurationPolicyArgs'] actions: The access control configuration for workflow actions.
        :param pulumi.Input['FlowAccessControlConfigurationPolicyArgs'] contents: The access control configuration for accessing workflow run contents.
        :param pulumi.Input['FlowAccessControlConfigurationPolicyArgs'] triggers: The access control configuration for invoking workflow triggers.
        :param pulumi.Input['FlowAccessControlConfigurationPolicyArgs'] workflow_management: The access control configuration for workflow management.
        """
        if actions is not None:
            pulumi.set(__self__, "actions", actions)
        if contents is not None:
            pulumi.set(__self__, "contents", contents)
        if triggers is not None:
            pulumi.set(__self__, "triggers", triggers)
        if workflow_management is not None:
            pulumi.set(__self__, "workflow_management", workflow_management)

    @property
    @pulumi.getter
    def actions(self) -> Optional[pulumi.Input['FlowAccessControlConfigurationPolicyArgs']]:
        """
        The access control configuration for workflow actions.
        """
        return pulumi.get(self, "actions")

    @actions.setter
    def actions(self, value: Optional[pulumi.Input['FlowAccessControlConfigurationPolicyArgs']]):
        pulumi.set(self, "actions", value)

    @property
    @pulumi.getter
    def contents(self) -> Optional[pulumi.Input['FlowAccessControlConfigurationPolicyArgs']]:
        """
        The access control configuration for accessing workflow run contents.
        """
        return pulumi.get(self, "contents")

    @contents.setter
    def contents(self, value: Optional[pulumi.Input['FlowAccessControlConfigurationPolicyArgs']]):
        pulumi.set(self, "contents", value)

    @property
    @pulumi.getter
    def triggers(self) -> Optional[pulumi.Input['FlowAccessControlConfigurationPolicyArgs']]:
        """
        The access control configuration for invoking workflow triggers.
        """
        return pulumi.get(self, "triggers")

    @triggers.setter
    def triggers(self, value: Optional[pulumi.Input['FlowAccessControlConfigurationPolicyArgs']]):
        pulumi.set(self, "triggers", value)

    @property
    @pulumi.getter(name="workflowManagement")
    def workflow_management(self) -> Optional[pulumi.Input['FlowAccessControlConfigurationPolicyArgs']]:
        """
        The access control configuration for workflow management.
        """
        return pulumi.get(self, "workflow_management")

    @workflow_management.setter
    def workflow_management(self, value: Optional[pulumi.Input['FlowAccessControlConfigurationPolicyArgs']]):
        pulumi.set(self, "workflow_management", value)


@pulumi.input_type
class FlowEndpointsConfigurationArgs:
    def __init__(__self__, *,
                 connector: Optional[pulumi.Input['FlowEndpointsArgs']] = None,
                 workflow: Optional[pulumi.Input['FlowEndpointsArgs']] = None):
        """
        The endpoints configuration.
        :param pulumi.Input['FlowEndpointsArgs'] connector: The connector endpoints.
        :param pulumi.Input['FlowEndpointsArgs'] workflow: The workflow endpoints.
        """
        if connector is not None:
            pulumi.set(__self__, "connector", connector)
        if workflow is not None:
            pulumi.set(__self__, "workflow", workflow)

    @property
    @pulumi.getter
    def connector(self) -> Optional[pulumi.Input['FlowEndpointsArgs']]:
        """
        The connector endpoints.
        """
        return pulumi.get(self, "connector")

    @connector.setter
    def connector(self, value: Optional[pulumi.Input['FlowEndpointsArgs']]):
        pulumi.set(self, "connector", value)

    @property
    @pulumi.getter
    def workflow(self) -> Optional[pulumi.Input['FlowEndpointsArgs']]:
        """
        The workflow endpoints.
        """
        return pulumi.get(self, "workflow")

    @workflow.setter
    def workflow(self, value: Optional[pulumi.Input['FlowEndpointsArgs']]):
        pulumi.set(self, "workflow", value)


@pulumi.input_type
class FlowEndpointsArgs:
    def __init__(__self__, *,
                 access_endpoint_ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input['IpAddressArgs']]]] = None,
                 outgoing_ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input['IpAddressArgs']]]] = None):
        """
        The flow endpoints configuration.
        :param pulumi.Input[Sequence[pulumi.Input['IpAddressArgs']]] access_endpoint_ip_addresses: The access endpoint ip address.
        :param pulumi.Input[Sequence[pulumi.Input['IpAddressArgs']]] outgoing_ip_addresses: The outgoing ip address.
        """
        if access_endpoint_ip_addresses is not None:
            pulumi.set(__self__, "access_endpoint_ip_addresses", access_endpoint_ip_addresses)
        if outgoing_ip_addresses is not None:
            pulumi.set(__self__, "outgoing_ip_addresses", outgoing_ip_addresses)

    @property
    @pulumi.getter(name="accessEndpointIpAddresses")
    def access_endpoint_ip_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IpAddressArgs']]]]:
        """
        The access endpoint ip address.
        """
        return pulumi.get(self, "access_endpoint_ip_addresses")

    @access_endpoint_ip_addresses.setter
    def access_endpoint_ip_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IpAddressArgs']]]]):
        pulumi.set(self, "access_endpoint_ip_addresses", value)

    @property
    @pulumi.getter(name="outgoingIpAddresses")
    def outgoing_ip_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IpAddressArgs']]]]:
        """
        The outgoing ip address.
        """
        return pulumi.get(self, "outgoing_ip_addresses")

    @outgoing_ip_addresses.setter
    def outgoing_ip_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IpAddressArgs']]]]):
        pulumi.set(self, "outgoing_ip_addresses", value)


@pulumi.input_type
class IntegrationAccountMapPropertiesParametersSchemaArgs:
    def __init__(__self__, *,
                 ref: Optional[pulumi.Input[str]] = None):
        """
        The parameters schema of integration account map.
        :param pulumi.Input[str] ref: The reference name.
        """
        if ref is not None:
            pulumi.set(__self__, "ref", ref)

    @property
    @pulumi.getter
    def ref(self) -> Optional[pulumi.Input[str]]:
        """
        The reference name.
        """
        return pulumi.get(self, "ref")

    @ref.setter
    def ref(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ref", value)


@pulumi.input_type
class IntegrationAccountSkuArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[Union[str, 'IntegrationAccountSkuName']]):
        """
        The integration account sku.
        :param pulumi.Input[Union[str, 'IntegrationAccountSkuName']] name: The sku name.
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[Union[str, 'IntegrationAccountSkuName']]:
        """
        The sku name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[Union[str, 'IntegrationAccountSkuName']]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class IntegrationServiceEnvironmenEncryptionConfigurationArgs:
    def __init__(__self__, *,
                 encryption_key_reference: Optional[pulumi.Input['IntegrationServiceEnvironmenEncryptionKeyReferenceArgs']] = None):
        """
        The encryption configuration for the integration service environment.
        :param pulumi.Input['IntegrationServiceEnvironmenEncryptionKeyReferenceArgs'] encryption_key_reference: The encryption key reference.
        """
        if encryption_key_reference is not None:
            pulumi.set(__self__, "encryption_key_reference", encryption_key_reference)

    @property
    @pulumi.getter(name="encryptionKeyReference")
    def encryption_key_reference(self) -> Optional[pulumi.Input['IntegrationServiceEnvironmenEncryptionKeyReferenceArgs']]:
        """
        The encryption key reference.
        """
        return pulumi.get(self, "encryption_key_reference")

    @encryption_key_reference.setter
    def encryption_key_reference(self, value: Optional[pulumi.Input['IntegrationServiceEnvironmenEncryptionKeyReferenceArgs']]):
        pulumi.set(self, "encryption_key_reference", value)


@pulumi.input_type
class IntegrationServiceEnvironmenEncryptionKeyReferenceArgs:
    def __init__(__self__, *,
                 key_name: Optional[pulumi.Input[str]] = None,
                 key_vault: Optional[pulumi.Input['ResourceReferenceArgs']] = None,
                 key_version: Optional[pulumi.Input[str]] = None):
        """
        The encryption key details for the integration service environment.
        :param pulumi.Input[str] key_name: Gets the key name in the Key Vault.
        :param pulumi.Input['ResourceReferenceArgs'] key_vault: The key vault reference.
        :param pulumi.Input[str] key_version: Gets the version of the key specified in the keyName property.
        """
        if key_name is not None:
            pulumi.set(__self__, "key_name", key_name)
        if key_vault is not None:
            pulumi.set(__self__, "key_vault", key_vault)
        if key_version is not None:
            pulumi.set(__self__, "key_version", key_version)

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> Optional[pulumi.Input[str]]:
        """
        Gets the key name in the Key Vault.
        """
        return pulumi.get(self, "key_name")

    @key_name.setter
    def key_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_name", value)

    @property
    @pulumi.getter(name="keyVault")
    def key_vault(self) -> Optional[pulumi.Input['ResourceReferenceArgs']]:
        """
        The key vault reference.
        """
        return pulumi.get(self, "key_vault")

    @key_vault.setter
    def key_vault(self, value: Optional[pulumi.Input['ResourceReferenceArgs']]):
        pulumi.set(self, "key_vault", value)

    @property
    @pulumi.getter(name="keyVersion")
    def key_version(self) -> Optional[pulumi.Input[str]]:
        """
        Gets the version of the key specified in the keyName property.
        """
        return pulumi.get(self, "key_version")

    @key_version.setter
    def key_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_version", value)


@pulumi.input_type
class IntegrationServiceEnvironmentAccessEndpointArgs:
    def __init__(__self__, *,
                 type: Optional[pulumi.Input[Union[str, 'IntegrationServiceEnvironmentAccessEndpointType']]] = None):
        """
        The integration service environment access endpoint.
        :param pulumi.Input[Union[str, 'IntegrationServiceEnvironmentAccessEndpointType']] type: The access endpoint type.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[Union[str, 'IntegrationServiceEnvironmentAccessEndpointType']]]:
        """
        The access endpoint type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[Union[str, 'IntegrationServiceEnvironmentAccessEndpointType']]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class IntegrationServiceEnvironmentManagedApiDeploymentParametersArgs:
    def __init__(__self__, *,
                 content_link_definition: Optional[pulumi.Input['ContentLinkArgs']] = None):
        """
        The integration service environment managed api deployment parameters.
        :param pulumi.Input['ContentLinkArgs'] content_link_definition: The integration service environment managed api content link for deployment.
        """
        if content_link_definition is not None:
            pulumi.set(__self__, "content_link_definition", content_link_definition)

    @property
    @pulumi.getter(name="contentLinkDefinition")
    def content_link_definition(self) -> Optional[pulumi.Input['ContentLinkArgs']]:
        """
        The integration service environment managed api content link for deployment.
        """
        return pulumi.get(self, "content_link_definition")

    @content_link_definition.setter
    def content_link_definition(self, value: Optional[pulumi.Input['ContentLinkArgs']]):
        pulumi.set(self, "content_link_definition", value)


@pulumi.input_type
class IntegrationServiceEnvironmentPropertiesArgs:
    def __init__(__self__, *,
                 encryption_configuration: Optional[pulumi.Input['IntegrationServiceEnvironmenEncryptionConfigurationArgs']] = None,
                 endpoints_configuration: Optional[pulumi.Input['FlowEndpointsConfigurationArgs']] = None,
                 integration_service_environment_id: Optional[pulumi.Input[str]] = None,
                 network_configuration: Optional[pulumi.Input['NetworkConfigurationArgs']] = None,
                 provisioning_state: Optional[pulumi.Input[Union[str, 'WorkflowProvisioningState']]] = None,
                 state: Optional[pulumi.Input[Union[str, 'WorkflowState']]] = None):
        """
        The integration service environment properties.
        :param pulumi.Input['IntegrationServiceEnvironmenEncryptionConfigurationArgs'] encryption_configuration: The encryption configuration.
        :param pulumi.Input['FlowEndpointsConfigurationArgs'] endpoints_configuration: The endpoints configuration.
        :param pulumi.Input[str] integration_service_environment_id: Gets the tracking id.
        :param pulumi.Input['NetworkConfigurationArgs'] network_configuration: The network configuration.
        :param pulumi.Input[Union[str, 'WorkflowProvisioningState']] provisioning_state: The provisioning state.
        :param pulumi.Input[Union[str, 'WorkflowState']] state: The integration service environment state.
        """
        if encryption_configuration is not None:
            pulumi.set(__self__, "encryption_configuration", encryption_configuration)
        if endpoints_configuration is not None:
            pulumi.set(__self__, "endpoints_configuration", endpoints_configuration)
        if integration_service_environment_id is not None:
            pulumi.set(__self__, "integration_service_environment_id", integration_service_environment_id)
        if network_configuration is not None:
            pulumi.set(__self__, "network_configuration", network_configuration)
        if provisioning_state is not None:
            pulumi.set(__self__, "provisioning_state", provisioning_state)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="encryptionConfiguration")
    def encryption_configuration(self) -> Optional[pulumi.Input['IntegrationServiceEnvironmenEncryptionConfigurationArgs']]:
        """
        The encryption configuration.
        """
        return pulumi.get(self, "encryption_configuration")

    @encryption_configuration.setter
    def encryption_configuration(self, value: Optional[pulumi.Input['IntegrationServiceEnvironmenEncryptionConfigurationArgs']]):
        pulumi.set(self, "encryption_configuration", value)

    @property
    @pulumi.getter(name="endpointsConfiguration")
    def endpoints_configuration(self) -> Optional[pulumi.Input['FlowEndpointsConfigurationArgs']]:
        """
        The endpoints configuration.
        """
        return pulumi.get(self, "endpoints_configuration")

    @endpoints_configuration.setter
    def endpoints_configuration(self, value: Optional[pulumi.Input['FlowEndpointsConfigurationArgs']]):
        pulumi.set(self, "endpoints_configuration", value)

    @property
    @pulumi.getter(name="integrationServiceEnvironmentId")
    def integration_service_environment_id(self) -> Optional[pulumi.Input[str]]:
        """
        Gets the tracking id.
        """
        return pulumi.get(self, "integration_service_environment_id")

    @integration_service_environment_id.setter
    def integration_service_environment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "integration_service_environment_id", value)

    @property
    @pulumi.getter(name="networkConfiguration")
    def network_configuration(self) -> Optional[pulumi.Input['NetworkConfigurationArgs']]:
        """
        The network configuration.
        """
        return pulumi.get(self, "network_configuration")

    @network_configuration.setter
    def network_configuration(self, value: Optional[pulumi.Input['NetworkConfigurationArgs']]):
        pulumi.set(self, "network_configuration", value)

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> Optional[pulumi.Input[Union[str, 'WorkflowProvisioningState']]]:
        """
        The provisioning state.
        """
        return pulumi.get(self, "provisioning_state")

    @provisioning_state.setter
    def provisioning_state(self, value: Optional[pulumi.Input[Union[str, 'WorkflowProvisioningState']]]):
        pulumi.set(self, "provisioning_state", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[Union[str, 'WorkflowState']]]:
        """
        The integration service environment state.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[Union[str, 'WorkflowState']]]):
        pulumi.set(self, "state", value)


@pulumi.input_type
class IntegrationServiceEnvironmentSkuArgs:
    def __init__(__self__, *,
                 capacity: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[Union[str, 'IntegrationServiceEnvironmentSkuName']]] = None):
        """
        The integration service environment sku.
        :param pulumi.Input[int] capacity: The sku capacity.
        :param pulumi.Input[Union[str, 'IntegrationServiceEnvironmentSkuName']] name: The sku name.
        """
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def capacity(self) -> Optional[pulumi.Input[int]]:
        """
        The sku capacity.
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "capacity", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[Union[str, 'IntegrationServiceEnvironmentSkuName']]]:
        """
        The sku name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[Union[str, 'IntegrationServiceEnvironmentSkuName']]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class IpAddressRangeArgs:
    def __init__(__self__, *,
                 address_range: Optional[pulumi.Input[str]] = None):
        """
        The ip address range.
        :param pulumi.Input[str] address_range: The IP address range.
        """
        if address_range is not None:
            pulumi.set(__self__, "address_range", address_range)

    @property
    @pulumi.getter(name="addressRange")
    def address_range(self) -> Optional[pulumi.Input[str]]:
        """
        The IP address range.
        """
        return pulumi.get(self, "address_range")

    @address_range.setter
    def address_range(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address_range", value)


@pulumi.input_type
class IpAddressArgs:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[str]] = None):
        """
        The ip address.
        :param pulumi.Input[str] address: The address.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)

    @property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[str]]:
        """
        The address.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address", value)


@pulumi.input_type
class KeyVaultKeyReferenceKeyVaultArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None):
        """
        The key vault reference.
        :param pulumi.Input[str] id: The resource id.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        The resource id.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class KeyVaultKeyReferenceArgs:
    def __init__(__self__, *,
                 key_name: pulumi.Input[str],
                 key_vault: pulumi.Input['KeyVaultKeyReferenceKeyVaultArgs'],
                 key_version: Optional[pulumi.Input[str]] = None):
        """
        The reference to the key vault key.
        :param pulumi.Input[str] key_name: The private key name in key vault.
        :param pulumi.Input['KeyVaultKeyReferenceKeyVaultArgs'] key_vault: The key vault reference.
        :param pulumi.Input[str] key_version: The private key version in key vault.
        """
        pulumi.set(__self__, "key_name", key_name)
        pulumi.set(__self__, "key_vault", key_vault)
        if key_version is not None:
            pulumi.set(__self__, "key_version", key_version)

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> pulumi.Input[str]:
        """
        The private key name in key vault.
        """
        return pulumi.get(self, "key_name")

    @key_name.setter
    def key_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "key_name", value)

    @property
    @pulumi.getter(name="keyVault")
    def key_vault(self) -> pulumi.Input['KeyVaultKeyReferenceKeyVaultArgs']:
        """
        The key vault reference.
        """
        return pulumi.get(self, "key_vault")

    @key_vault.setter
    def key_vault(self, value: pulumi.Input['KeyVaultKeyReferenceKeyVaultArgs']):
        pulumi.set(self, "key_vault", value)

    @property
    @pulumi.getter(name="keyVersion")
    def key_version(self) -> Optional[pulumi.Input[str]]:
        """
        The private key version in key vault.
        """
        return pulumi.get(self, "key_version")

    @key_version.setter
    def key_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_version", value)


@pulumi.input_type
class KeyVaultReference:
    def __init__(__self__, *,
                 id: Optional[str] = None,
                 name: Optional[str] = None):
        """
        The key vault reference.
        :param str id: The resource id.
        :param str name: The key vault name.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The resource id.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The key vault name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[str]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class ManagedServiceIdentityArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[Union[str, 'ManagedServiceIdentityType']],
                 user_assigned_identities: Optional[pulumi.Input[Mapping[str, Any]]] = None):
        """
        Managed service identity properties.
        :param pulumi.Input[Union[str, 'ManagedServiceIdentityType']] type: Type of managed service identity. The type 'SystemAssigned' includes an implicitly created identity. The type 'None' will remove any identities from the resource.
        :param pulumi.Input[Mapping[str, Any]] user_assigned_identities: The list of user assigned identities associated with the resource. The user identity dictionary key references will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}
        """
        pulumi.set(__self__, "type", type)
        if user_assigned_identities is not None:
            pulumi.set(__self__, "user_assigned_identities", user_assigned_identities)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[Union[str, 'ManagedServiceIdentityType']]:
        """
        Type of managed service identity. The type 'SystemAssigned' includes an implicitly created identity. The type 'None' will remove any identities from the resource.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[Union[str, 'ManagedServiceIdentityType']]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="userAssignedIdentities")
    def user_assigned_identities(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        The list of user assigned identities associated with the resource. The user identity dictionary key references will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}
        """
        return pulumi.get(self, "user_assigned_identities")

    @user_assigned_identities.setter
    def user_assigned_identities(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "user_assigned_identities", value)


@pulumi.input_type
class NetworkConfigurationArgs:
    def __init__(__self__, *,
                 access_endpoint: Optional[pulumi.Input['IntegrationServiceEnvironmentAccessEndpointArgs']] = None,
                 subnets: Optional[pulumi.Input[Sequence[pulumi.Input['ResourceReferenceArgs']]]] = None,
                 virtual_network_address_space: Optional[pulumi.Input[str]] = None):
        """
        The network configuration.
        :param pulumi.Input['IntegrationServiceEnvironmentAccessEndpointArgs'] access_endpoint: The access endpoint.
        :param pulumi.Input[Sequence[pulumi.Input['ResourceReferenceArgs']]] subnets: The subnets.
        :param pulumi.Input[str] virtual_network_address_space: Gets the virtual network address space.
        """
        if access_endpoint is not None:
            pulumi.set(__self__, "access_endpoint", access_endpoint)
        if subnets is not None:
            pulumi.set(__self__, "subnets", subnets)
        if virtual_network_address_space is not None:
            pulumi.set(__self__, "virtual_network_address_space", virtual_network_address_space)

    @property
    @pulumi.getter(name="accessEndpoint")
    def access_endpoint(self) -> Optional[pulumi.Input['IntegrationServiceEnvironmentAccessEndpointArgs']]:
        """
        The access endpoint.
        """
        return pulumi.get(self, "access_endpoint")

    @access_endpoint.setter
    def access_endpoint(self, value: Optional[pulumi.Input['IntegrationServiceEnvironmentAccessEndpointArgs']]):
        pulumi.set(self, "access_endpoint", value)

    @property
    @pulumi.getter
    def subnets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ResourceReferenceArgs']]]]:
        """
        The subnets.
        """
        return pulumi.get(self, "subnets")

    @subnets.setter
    def subnets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ResourceReferenceArgs']]]]):
        pulumi.set(self, "subnets", value)

    @property
    @pulumi.getter(name="virtualNetworkAddressSpace")
    def virtual_network_address_space(self) -> Optional[pulumi.Input[str]]:
        """
        Gets the virtual network address space.
        """
        return pulumi.get(self, "virtual_network_address_space")

    @virtual_network_address_space.setter
    def virtual_network_address_space(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "virtual_network_address_space", value)


@pulumi.input_type
class OpenAuthenticationAccessPoliciesArgs:
    def __init__(__self__, *,
                 policies: Optional[pulumi.Input[Mapping[str, pulumi.Input['OpenAuthenticationAccessPolicyArgs']]]] = None):
        """
        AuthenticationPolicy of type Open.
        :param pulumi.Input[Mapping[str, pulumi.Input['OpenAuthenticationAccessPolicyArgs']]] policies: Open authentication policies.
        """
        if policies is not None:
            pulumi.set(__self__, "policies", policies)

    @property
    @pulumi.getter
    def policies(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['OpenAuthenticationAccessPolicyArgs']]]]:
        """
        Open authentication policies.
        """
        return pulumi.get(self, "policies")

    @policies.setter
    def policies(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['OpenAuthenticationAccessPolicyArgs']]]]):
        pulumi.set(self, "policies", value)


@pulumi.input_type
class OpenAuthenticationAccessPolicyArgs:
    def __init__(__self__, *,
                 claims: Optional[pulumi.Input[Sequence[pulumi.Input['OpenAuthenticationPolicyClaimArgs']]]] = None,
                 type: Optional[pulumi.Input[Union[str, 'OpenAuthenticationProviderType']]] = None):
        """
        Open authentication access policy defined by user.
        :param pulumi.Input[Sequence[pulumi.Input['OpenAuthenticationPolicyClaimArgs']]] claims: The access policy claims.
        :param pulumi.Input[Union[str, 'OpenAuthenticationProviderType']] type: Type of provider for OAuth.
        """
        if claims is not None:
            pulumi.set(__self__, "claims", claims)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def claims(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OpenAuthenticationPolicyClaimArgs']]]]:
        """
        The access policy claims.
        """
        return pulumi.get(self, "claims")

    @claims.setter
    def claims(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OpenAuthenticationPolicyClaimArgs']]]]):
        pulumi.set(self, "claims", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[Union[str, 'OpenAuthenticationProviderType']]]:
        """
        Type of provider for OAuth.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[Union[str, 'OpenAuthenticationProviderType']]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class OpenAuthenticationPolicyClaimArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        Open authentication policy claim.
        :param pulumi.Input[str] name: The name of the claim.
        :param pulumi.Input[str] value: The value of the claim.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the claim.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        The value of the claim.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class PartnerContentArgs:
    def __init__(__self__, *,
                 b2b: Optional[pulumi.Input['B2BPartnerContentArgs']] = None):
        """
        The integration account partner content.
        :param pulumi.Input['B2BPartnerContentArgs'] b2b: The B2B partner content.
        """
        if b2b is not None:
            pulumi.set(__self__, "b2b", b2b)

    @property
    @pulumi.getter
    def b2b(self) -> Optional[pulumi.Input['B2BPartnerContentArgs']]:
        """
        The B2B partner content.
        """
        return pulumi.get(self, "b2b")

    @b2b.setter
    def b2b(self, value: Optional[pulumi.Input['B2BPartnerContentArgs']]):
        pulumi.set(self, "b2b", value)


@pulumi.input_type
class RecurrenceScheduleOccurrenceArgs:
    def __init__(__self__, *,
                 day: Optional[pulumi.Input['DayOfWeek']] = None,
                 occurrence: Optional[pulumi.Input[int]] = None):
        """
        The recurrence schedule occurrence.
        :param pulumi.Input['DayOfWeek'] day: The day of the week.
        :param pulumi.Input[int] occurrence: The occurrence.
        """
        if day is not None:
            pulumi.set(__self__, "day", day)
        if occurrence is not None:
            pulumi.set(__self__, "occurrence", occurrence)

    @property
    @pulumi.getter
    def day(self) -> Optional[pulumi.Input['DayOfWeek']]:
        """
        The day of the week.
        """
        return pulumi.get(self, "day")

    @day.setter
    def day(self, value: Optional[pulumi.Input['DayOfWeek']]):
        pulumi.set(self, "day", value)

    @property
    @pulumi.getter
    def occurrence(self) -> Optional[pulumi.Input[int]]:
        """
        The occurrence.
        """
        return pulumi.get(self, "occurrence")

    @occurrence.setter
    def occurrence(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "occurrence", value)


@pulumi.input_type
class RecurrenceScheduleArgs:
    def __init__(__self__, *,
                 hours: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 minutes: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 month_days: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 monthly_occurrences: Optional[pulumi.Input[Sequence[pulumi.Input['RecurrenceScheduleOccurrenceArgs']]]] = None,
                 week_days: Optional[pulumi.Input[Sequence[pulumi.Input['DaysOfWeek']]]] = None):
        """
        The recurrence schedule.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] hours: The hours.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] minutes: The minutes.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] month_days: The month days.
        :param pulumi.Input[Sequence[pulumi.Input['RecurrenceScheduleOccurrenceArgs']]] monthly_occurrences: The monthly occurrences.
        :param pulumi.Input[Sequence[pulumi.Input['DaysOfWeek']]] week_days: The days of the week.
        """
        if hours is not None:
            pulumi.set(__self__, "hours", hours)
        if minutes is not None:
            pulumi.set(__self__, "minutes", minutes)
        if month_days is not None:
            pulumi.set(__self__, "month_days", month_days)
        if monthly_occurrences is not None:
            pulumi.set(__self__, "monthly_occurrences", monthly_occurrences)
        if week_days is not None:
            pulumi.set(__self__, "week_days", week_days)

    @property
    @pulumi.getter
    def hours(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        The hours.
        """
        return pulumi.get(self, "hours")

    @hours.setter
    def hours(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "hours", value)

    @property
    @pulumi.getter
    def minutes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        The minutes.
        """
        return pulumi.get(self, "minutes")

    @minutes.setter
    def minutes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "minutes", value)

    @property
    @pulumi.getter(name="monthDays")
    def month_days(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        The month days.
        """
        return pulumi.get(self, "month_days")

    @month_days.setter
    def month_days(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "month_days", value)

    @property
    @pulumi.getter(name="monthlyOccurrences")
    def monthly_occurrences(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RecurrenceScheduleOccurrenceArgs']]]]:
        """
        The monthly occurrences.
        """
        return pulumi.get(self, "monthly_occurrences")

    @monthly_occurrences.setter
    def monthly_occurrences(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RecurrenceScheduleOccurrenceArgs']]]]):
        pulumi.set(self, "monthly_occurrences", value)

    @property
    @pulumi.getter(name="weekDays")
    def week_days(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DaysOfWeek']]]]:
        """
        The days of the week.
        """
        return pulumi.get(self, "week_days")

    @week_days.setter
    def week_days(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DaysOfWeek']]]]):
        pulumi.set(self, "week_days", value)


@pulumi.input_type
class ResourceReferenceArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None):
        """
        The resource reference.
        :param pulumi.Input[str] id: The resource id.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        The resource id.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class WorkflowParameterArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 metadata: Optional[Any] = None,
                 type: Optional[pulumi.Input[Union[str, 'ParameterType']]] = None,
                 value: Optional[Any] = None):
        """
        The workflow parameters.
        :param pulumi.Input[str] description: The description.
        :param Any metadata: The metadata.
        :param pulumi.Input[Union[str, 'ParameterType']] type: The type.
        :param Any value: The value.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[Any]:
        """
        The metadata.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[Any]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[Union[str, 'ParameterType']]]:
        """
        The type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[Union[str, 'ParameterType']]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[Any]:
        """
        The value.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[Any]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class WorkflowTriggerRecurrenceArgs:
    def __init__(__self__, *,
                 end_time: Optional[pulumi.Input[str]] = None,
                 frequency: Optional[pulumi.Input[Union[str, 'RecurrenceFrequency']]] = None,
                 interval: Optional[pulumi.Input[int]] = None,
                 schedule: Optional[pulumi.Input['RecurrenceScheduleArgs']] = None,
                 start_time: Optional[pulumi.Input[str]] = None,
                 time_zone: Optional[pulumi.Input[str]] = None):
        """
        The workflow trigger recurrence.
        :param pulumi.Input[str] end_time: The end time.
        :param pulumi.Input[Union[str, 'RecurrenceFrequency']] frequency: The frequency.
        :param pulumi.Input[int] interval: The interval.
        :param pulumi.Input['RecurrenceScheduleArgs'] schedule: The recurrence schedule.
        :param pulumi.Input[str] start_time: The start time.
        :param pulumi.Input[str] time_zone: The time zone.
        """
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if frequency is not None:
            pulumi.set(__self__, "frequency", frequency)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[pulumi.Input[str]]:
        """
        The end time.
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "end_time", value)

    @property
    @pulumi.getter
    def frequency(self) -> Optional[pulumi.Input[Union[str, 'RecurrenceFrequency']]]:
        """
        The frequency.
        """
        return pulumi.get(self, "frequency")

    @frequency.setter
    def frequency(self, value: Optional[pulumi.Input[Union[str, 'RecurrenceFrequency']]]):
        pulumi.set(self, "frequency", value)

    @property
    @pulumi.getter
    def interval(self) -> Optional[pulumi.Input[int]]:
        """
        The interval.
        """
        return pulumi.get(self, "interval")

    @interval.setter
    def interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "interval", value)

    @property
    @pulumi.getter
    def schedule(self) -> Optional[pulumi.Input['RecurrenceScheduleArgs']]:
        """
        The recurrence schedule.
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: Optional[pulumi.Input['RecurrenceScheduleArgs']]):
        pulumi.set(self, "schedule", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[str]]:
        """
        The start time.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_time", value)

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[str]]:
        """
        The time zone.
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_zone", value)


@pulumi.input_type
class X12AcknowledgementSettingsArgs:
    def __init__(__self__, *,
                 acknowledgement_control_number_lower_bound: pulumi.Input[int],
                 acknowledgement_control_number_upper_bound: pulumi.Input[int],
                 batch_functional_acknowledgements: pulumi.Input[bool],
                 batch_implementation_acknowledgements: pulumi.Input[bool],
                 batch_technical_acknowledgements: pulumi.Input[bool],
                 need_functional_acknowledgement: pulumi.Input[bool],
                 need_implementation_acknowledgement: pulumi.Input[bool],
                 need_loop_for_valid_messages: pulumi.Input[bool],
                 need_technical_acknowledgement: pulumi.Input[bool],
                 rollover_acknowledgement_control_number: pulumi.Input[bool],
                 send_synchronous_acknowledgement: pulumi.Input[bool],
                 acknowledgement_control_number_prefix: Optional[pulumi.Input[str]] = None,
                 acknowledgement_control_number_suffix: Optional[pulumi.Input[str]] = None,
                 functional_acknowledgement_version: Optional[pulumi.Input[str]] = None,
                 implementation_acknowledgement_version: Optional[pulumi.Input[str]] = None):
        """
        The X12 agreement acknowledgement settings.
        :param pulumi.Input[int] acknowledgement_control_number_lower_bound: The acknowledgement control number lower bound.
        :param pulumi.Input[int] acknowledgement_control_number_upper_bound: The acknowledgement control number upper bound.
        :param pulumi.Input[bool] batch_functional_acknowledgements: The value indicating whether to batch functional acknowledgements.
        :param pulumi.Input[bool] batch_implementation_acknowledgements: The value indicating whether to batch implementation acknowledgements.
        :param pulumi.Input[bool] batch_technical_acknowledgements: The value indicating whether to batch the technical acknowledgements.
        :param pulumi.Input[bool] need_functional_acknowledgement: The value indicating whether functional acknowledgement is needed.
        :param pulumi.Input[bool] need_implementation_acknowledgement: The value indicating whether implementation acknowledgement is needed.
        :param pulumi.Input[bool] need_loop_for_valid_messages: The value indicating whether a loop is needed for valid messages.
        :param pulumi.Input[bool] need_technical_acknowledgement: The value indicating whether technical acknowledgement is needed.
        :param pulumi.Input[bool] rollover_acknowledgement_control_number: The value indicating whether to rollover acknowledgement control number.
        :param pulumi.Input[bool] send_synchronous_acknowledgement: The value indicating whether to send synchronous acknowledgement.
        :param pulumi.Input[str] acknowledgement_control_number_prefix: The acknowledgement control number prefix.
        :param pulumi.Input[str] acknowledgement_control_number_suffix: The acknowledgement control number suffix.
        :param pulumi.Input[str] functional_acknowledgement_version: The functional acknowledgement version.
        :param pulumi.Input[str] implementation_acknowledgement_version: The implementation acknowledgement version.
        """
        pulumi.set(__self__, "acknowledgement_control_number_lower_bound", acknowledgement_control_number_lower_bound)
        pulumi.set(__self__, "acknowledgement_control_number_upper_bound", acknowledgement_control_number_upper_bound)
        pulumi.set(__self__, "batch_functional_acknowledgements", batch_functional_acknowledgements)
        pulumi.set(__self__, "batch_implementation_acknowledgements", batch_implementation_acknowledgements)
        pulumi.set(__self__, "batch_technical_acknowledgements", batch_technical_acknowledgements)
        pulumi.set(__self__, "need_functional_acknowledgement", need_functional_acknowledgement)
        pulumi.set(__self__, "need_implementation_acknowledgement", need_implementation_acknowledgement)
        pulumi.set(__self__, "need_loop_for_valid_messages", need_loop_for_valid_messages)
        pulumi.set(__self__, "need_technical_acknowledgement", need_technical_acknowledgement)
        pulumi.set(__self__, "rollover_acknowledgement_control_number", rollover_acknowledgement_control_number)
        pulumi.set(__self__, "send_synchronous_acknowledgement", send_synchronous_acknowledgement)
        if acknowledgement_control_number_prefix is not None:
            pulumi.set(__self__, "acknowledgement_control_number_prefix", acknowledgement_control_number_prefix)
        if acknowledgement_control_number_suffix is not None:
            pulumi.set(__self__, "acknowledgement_control_number_suffix", acknowledgement_control_number_suffix)
        if functional_acknowledgement_version is not None:
            pulumi.set(__self__, "functional_acknowledgement_version", functional_acknowledgement_version)
        if implementation_acknowledgement_version is not None:
            pulumi.set(__self__, "implementation_acknowledgement_version", implementation_acknowledgement_version)

    @property
    @pulumi.getter(name="acknowledgementControlNumberLowerBound")
    def acknowledgement_control_number_lower_bound(self) -> pulumi.Input[int]:
        """
        The acknowledgement control number lower bound.
        """
        return pulumi.get(self, "acknowledgement_control_number_lower_bound")

    @acknowledgement_control_number_lower_bound.setter
    def acknowledgement_control_number_lower_bound(self, value: pulumi.Input[int]):
        pulumi.set(self, "acknowledgement_control_number_lower_bound", value)

    @property
    @pulumi.getter(name="acknowledgementControlNumberUpperBound")
    def acknowledgement_control_number_upper_bound(self) -> pulumi.Input[int]:
        """
        The acknowledgement control number upper bound.
        """
        return pulumi.get(self, "acknowledgement_control_number_upper_bound")

    @acknowledgement_control_number_upper_bound.setter
    def acknowledgement_control_number_upper_bound(self, value: pulumi.Input[int]):
        pulumi.set(self, "acknowledgement_control_number_upper_bound", value)

    @property
    @pulumi.getter(name="batchFunctionalAcknowledgements")
    def batch_functional_acknowledgements(self) -> pulumi.Input[bool]:
        """
        The value indicating whether to batch functional acknowledgements.
        """
        return pulumi.get(self, "batch_functional_acknowledgements")

    @batch_functional_acknowledgements.setter
    def batch_functional_acknowledgements(self, value: pulumi.Input[bool]):
        pulumi.set(self, "batch_functional_acknowledgements", value)

    @property
    @pulumi.getter(name="batchImplementationAcknowledgements")
    def batch_implementation_acknowledgements(self) -> pulumi.Input[bool]:
        """
        The value indicating whether to batch implementation acknowledgements.
        """
        return pulumi.get(self, "batch_implementation_acknowledgements")

    @batch_implementation_acknowledgements.setter
    def batch_implementation_acknowledgements(self, value: pulumi.Input[bool]):
        pulumi.set(self, "batch_implementation_acknowledgements", value)

    @property
    @pulumi.getter(name="batchTechnicalAcknowledgements")
    def batch_technical_acknowledgements(self) -> pulumi.Input[bool]:
        """
        The value indicating whether to batch the technical acknowledgements.
        """
        return pulumi.get(self, "batch_technical_acknowledgements")

    @batch_technical_acknowledgements.setter
    def batch_technical_acknowledgements(self, value: pulumi.Input[bool]):
        pulumi.set(self, "batch_technical_acknowledgements", value)

    @property
    @pulumi.getter(name="needFunctionalAcknowledgement")
    def need_functional_acknowledgement(self) -> pulumi.Input[bool]:
        """
        The value indicating whether functional acknowledgement is needed.
        """
        return pulumi.get(self, "need_functional_acknowledgement")

    @need_functional_acknowledgement.setter
    def need_functional_acknowledgement(self, value: pulumi.Input[bool]):
        pulumi.set(self, "need_functional_acknowledgement", value)

    @property
    @pulumi.getter(name="needImplementationAcknowledgement")
    def need_implementation_acknowledgement(self) -> pulumi.Input[bool]:
        """
        The value indicating whether implementation acknowledgement is needed.
        """
        return pulumi.get(self, "need_implementation_acknowledgement")

    @need_implementation_acknowledgement.setter
    def need_implementation_acknowledgement(self, value: pulumi.Input[bool]):
        pulumi.set(self, "need_implementation_acknowledgement", value)

    @property
    @pulumi.getter(name="needLoopForValidMessages")
    def need_loop_for_valid_messages(self) -> pulumi.Input[bool]:
        """
        The value indicating whether a loop is needed for valid messages.
        """
        return pulumi.get(self, "need_loop_for_valid_messages")

    @need_loop_for_valid_messages.setter
    def need_loop_for_valid_messages(self, value: pulumi.Input[bool]):
        pulumi.set(self, "need_loop_for_valid_messages", value)

    @property
    @pulumi.getter(name="needTechnicalAcknowledgement")
    def need_technical_acknowledgement(self) -> pulumi.Input[bool]:
        """
        The value indicating whether technical acknowledgement is needed.
        """
        return pulumi.get(self, "need_technical_acknowledgement")

    @need_technical_acknowledgement.setter
    def need_technical_acknowledgement(self, value: pulumi.Input[bool]):
        pulumi.set(self, "need_technical_acknowledgement", value)

    @property
    @pulumi.getter(name="rolloverAcknowledgementControlNumber")
    def rollover_acknowledgement_control_number(self) -> pulumi.Input[bool]:
        """
        The value indicating whether to rollover acknowledgement control number.
        """
        return pulumi.get(self, "rollover_acknowledgement_control_number")

    @rollover_acknowledgement_control_number.setter
    def rollover_acknowledgement_control_number(self, value: pulumi.Input[bool]):
        pulumi.set(self, "rollover_acknowledgement_control_number", value)

    @property
    @pulumi.getter(name="sendSynchronousAcknowledgement")
    def send_synchronous_acknowledgement(self) -> pulumi.Input[bool]:
        """
        The value indicating whether to send synchronous acknowledgement.
        """
        return pulumi.get(self, "send_synchronous_acknowledgement")

    @send_synchronous_acknowledgement.setter
    def send_synchronous_acknowledgement(self, value: pulumi.Input[bool]):
        pulumi.set(self, "send_synchronous_acknowledgement", value)

    @property
    @pulumi.getter(name="acknowledgementControlNumberPrefix")
    def acknowledgement_control_number_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        The acknowledgement control number prefix.
        """
        return pulumi.get(self, "acknowledgement_control_number_prefix")

    @acknowledgement_control_number_prefix.setter
    def acknowledgement_control_number_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "acknowledgement_control_number_prefix", value)

    @property
    @pulumi.getter(name="acknowledgementControlNumberSuffix")
    def acknowledgement_control_number_suffix(self) -> Optional[pulumi.Input[str]]:
        """
        The acknowledgement control number suffix.
        """
        return pulumi.get(self, "acknowledgement_control_number_suffix")

    @acknowledgement_control_number_suffix.setter
    def acknowledgement_control_number_suffix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "acknowledgement_control_number_suffix", value)

    @property
    @pulumi.getter(name="functionalAcknowledgementVersion")
    def functional_acknowledgement_version(self) -> Optional[pulumi.Input[str]]:
        """
        The functional acknowledgement version.
        """
        return pulumi.get(self, "functional_acknowledgement_version")

    @functional_acknowledgement_version.setter
    def functional_acknowledgement_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "functional_acknowledgement_version", value)

    @property
    @pulumi.getter(name="implementationAcknowledgementVersion")
    def implementation_acknowledgement_version(self) -> Optional[pulumi.Input[str]]:
        """
        The implementation acknowledgement version.
        """
        return pulumi.get(self, "implementation_acknowledgement_version")

    @implementation_acknowledgement_version.setter
    def implementation_acknowledgement_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "implementation_acknowledgement_version", value)


@pulumi.input_type
class X12AgreementContentArgs:
    def __init__(__self__, *,
                 receive_agreement: pulumi.Input['X12OneWayAgreementArgs'],
                 send_agreement: pulumi.Input['X12OneWayAgreementArgs']):
        """
        The X12 agreement content.
        :param pulumi.Input['X12OneWayAgreementArgs'] receive_agreement: The X12 one-way receive agreement.
        :param pulumi.Input['X12OneWayAgreementArgs'] send_agreement: The X12 one-way send agreement.
        """
        pulumi.set(__self__, "receive_agreement", receive_agreement)
        pulumi.set(__self__, "send_agreement", send_agreement)

    @property
    @pulumi.getter(name="receiveAgreement")
    def receive_agreement(self) -> pulumi.Input['X12OneWayAgreementArgs']:
        """
        The X12 one-way receive agreement.
        """
        return pulumi.get(self, "receive_agreement")

    @receive_agreement.setter
    def receive_agreement(self, value: pulumi.Input['X12OneWayAgreementArgs']):
        pulumi.set(self, "receive_agreement", value)

    @property
    @pulumi.getter(name="sendAgreement")
    def send_agreement(self) -> pulumi.Input['X12OneWayAgreementArgs']:
        """
        The X12 one-way send agreement.
        """
        return pulumi.get(self, "send_agreement")

    @send_agreement.setter
    def send_agreement(self, value: pulumi.Input['X12OneWayAgreementArgs']):
        pulumi.set(self, "send_agreement", value)


@pulumi.input_type
class X12DelimiterOverridesArgs:
    def __init__(__self__, *,
                 component_separator: pulumi.Input[int],
                 data_element_separator: pulumi.Input[int],
                 replace_character: pulumi.Input[int],
                 replace_separators_in_payload: pulumi.Input[bool],
                 segment_terminator: pulumi.Input[int],
                 segment_terminator_suffix: pulumi.Input['SegmentTerminatorSuffix'],
                 message_id: Optional[pulumi.Input[str]] = None,
                 protocol_version: Optional[pulumi.Input[str]] = None,
                 target_namespace: Optional[pulumi.Input[str]] = None):
        """
        The X12 delimiter override settings.
        :param pulumi.Input[int] component_separator: The component separator.
        :param pulumi.Input[int] data_element_separator: The data element separator.
        :param pulumi.Input[int] replace_character: The replacement character.
        :param pulumi.Input[bool] replace_separators_in_payload: The value indicating whether to replace separators in payload.
        :param pulumi.Input[int] segment_terminator: The segment terminator.
        :param pulumi.Input['SegmentTerminatorSuffix'] segment_terminator_suffix: The segment terminator suffix.
        :param pulumi.Input[str] message_id: The message id.
        :param pulumi.Input[str] protocol_version: The protocol version.
        :param pulumi.Input[str] target_namespace: The target namespace on which this delimiter settings has to be applied.
        """
        pulumi.set(__self__, "component_separator", component_separator)
        pulumi.set(__self__, "data_element_separator", data_element_separator)
        pulumi.set(__self__, "replace_character", replace_character)
        pulumi.set(__self__, "replace_separators_in_payload", replace_separators_in_payload)
        pulumi.set(__self__, "segment_terminator", segment_terminator)
        pulumi.set(__self__, "segment_terminator_suffix", segment_terminator_suffix)
        if message_id is not None:
            pulumi.set(__self__, "message_id", message_id)
        if protocol_version is not None:
            pulumi.set(__self__, "protocol_version", protocol_version)
        if target_namespace is not None:
            pulumi.set(__self__, "target_namespace", target_namespace)

    @property
    @pulumi.getter(name="componentSeparator")
    def component_separator(self) -> pulumi.Input[int]:
        """
        The component separator.
        """
        return pulumi.get(self, "component_separator")

    @component_separator.setter
    def component_separator(self, value: pulumi.Input[int]):
        pulumi.set(self, "component_separator", value)

    @property
    @pulumi.getter(name="dataElementSeparator")
    def data_element_separator(self) -> pulumi.Input[int]:
        """
        The data element separator.
        """
        return pulumi.get(self, "data_element_separator")

    @data_element_separator.setter
    def data_element_separator(self, value: pulumi.Input[int]):
        pulumi.set(self, "data_element_separator", value)

    @property
    @pulumi.getter(name="replaceCharacter")
    def replace_character(self) -> pulumi.Input[int]:
        """
        The replacement character.
        """
        return pulumi.get(self, "replace_character")

    @replace_character.setter
    def replace_character(self, value: pulumi.Input[int]):
        pulumi.set(self, "replace_character", value)

    @property
    @pulumi.getter(name="replaceSeparatorsInPayload")
    def replace_separators_in_payload(self) -> pulumi.Input[bool]:
        """
        The value indicating whether to replace separators in payload.
        """
        return pulumi.get(self, "replace_separators_in_payload")

    @replace_separators_in_payload.setter
    def replace_separators_in_payload(self, value: pulumi.Input[bool]):
        pulumi.set(self, "replace_separators_in_payload", value)

    @property
    @pulumi.getter(name="segmentTerminator")
    def segment_terminator(self) -> pulumi.Input[int]:
        """
        The segment terminator.
        """
        return pulumi.get(self, "segment_terminator")

    @segment_terminator.setter
    def segment_terminator(self, value: pulumi.Input[int]):
        pulumi.set(self, "segment_terminator", value)

    @property
    @pulumi.getter(name="segmentTerminatorSuffix")
    def segment_terminator_suffix(self) -> pulumi.Input['SegmentTerminatorSuffix']:
        """
        The segment terminator suffix.
        """
        return pulumi.get(self, "segment_terminator_suffix")

    @segment_terminator_suffix.setter
    def segment_terminator_suffix(self, value: pulumi.Input['SegmentTerminatorSuffix']):
        pulumi.set(self, "segment_terminator_suffix", value)

    @property
    @pulumi.getter(name="messageId")
    def message_id(self) -> Optional[pulumi.Input[str]]:
        """
        The message id.
        """
        return pulumi.get(self, "message_id")

    @message_id.setter
    def message_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message_id", value)

    @property
    @pulumi.getter(name="protocolVersion")
    def protocol_version(self) -> Optional[pulumi.Input[str]]:
        """
        The protocol version.
        """
        return pulumi.get(self, "protocol_version")

    @protocol_version.setter
    def protocol_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol_version", value)

    @property
    @pulumi.getter(name="targetNamespace")
    def target_namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The target namespace on which this delimiter settings has to be applied.
        """
        return pulumi.get(self, "target_namespace")

    @target_namespace.setter
    def target_namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_namespace", value)


@pulumi.input_type
class X12EnvelopeOverrideArgs:
    def __init__(__self__, *,
                 date_format: pulumi.Input[Union[str, 'X12DateFormat']],
                 header_version: pulumi.Input[str],
                 message_id: pulumi.Input[str],
                 protocol_version: pulumi.Input[str],
                 receiver_application_id: pulumi.Input[str],
                 responsible_agency_code: pulumi.Input[str],
                 sender_application_id: pulumi.Input[str],
                 target_namespace: pulumi.Input[str],
                 time_format: pulumi.Input[Union[str, 'X12TimeFormat']],
                 functional_identifier_code: Optional[pulumi.Input[str]] = None):
        """
        The X12 envelope override settings.
        :param pulumi.Input[Union[str, 'X12DateFormat']] date_format: The date format.
        :param pulumi.Input[str] header_version: The header version.
        :param pulumi.Input[str] message_id: The message id on which this envelope settings has to be applied.
        :param pulumi.Input[str] protocol_version: The protocol version on which this envelope settings has to be applied.
        :param pulumi.Input[str] receiver_application_id: The receiver application id.
        :param pulumi.Input[str] responsible_agency_code: The responsible agency code.
        :param pulumi.Input[str] sender_application_id: The sender application id.
        :param pulumi.Input[str] target_namespace: The target namespace on which this envelope settings has to be applied.
        :param pulumi.Input[Union[str, 'X12TimeFormat']] time_format: The time format.
        :param pulumi.Input[str] functional_identifier_code: The functional identifier code.
        """
        pulumi.set(__self__, "date_format", date_format)
        pulumi.set(__self__, "header_version", header_version)
        pulumi.set(__self__, "message_id", message_id)
        pulumi.set(__self__, "protocol_version", protocol_version)
        pulumi.set(__self__, "receiver_application_id", receiver_application_id)
        pulumi.set(__self__, "responsible_agency_code", responsible_agency_code)
        pulumi.set(__self__, "sender_application_id", sender_application_id)
        pulumi.set(__self__, "target_namespace", target_namespace)
        pulumi.set(__self__, "time_format", time_format)
        if functional_identifier_code is not None:
            pulumi.set(__self__, "functional_identifier_code", functional_identifier_code)

    @property
    @pulumi.getter(name="dateFormat")
    def date_format(self) -> pulumi.Input[Union[str, 'X12DateFormat']]:
        """
        The date format.
        """
        return pulumi.get(self, "date_format")

    @date_format.setter
    def date_format(self, value: pulumi.Input[Union[str, 'X12DateFormat']]):
        pulumi.set(self, "date_format", value)

    @property
    @pulumi.getter(name="headerVersion")
    def header_version(self) -> pulumi.Input[str]:
        """
        The header version.
        """
        return pulumi.get(self, "header_version")

    @header_version.setter
    def header_version(self, value: pulumi.Input[str]):
        pulumi.set(self, "header_version", value)

    @property
    @pulumi.getter(name="messageId")
    def message_id(self) -> pulumi.Input[str]:
        """
        The message id on which this envelope settings has to be applied.
        """
        return pulumi.get(self, "message_id")

    @message_id.setter
    def message_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "message_id", value)

    @property
    @pulumi.getter(name="protocolVersion")
    def protocol_version(self) -> pulumi.Input[str]:
        """
        The protocol version on which this envelope settings has to be applied.
        """
        return pulumi.get(self, "protocol_version")

    @protocol_version.setter
    def protocol_version(self, value: pulumi.Input[str]):
        pulumi.set(self, "protocol_version", value)

    @property
    @pulumi.getter(name="receiverApplicationId")
    def receiver_application_id(self) -> pulumi.Input[str]:
        """
        The receiver application id.
        """
        return pulumi.get(self, "receiver_application_id")

    @receiver_application_id.setter
    def receiver_application_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "receiver_application_id", value)

    @property
    @pulumi.getter(name="responsibleAgencyCode")
    def responsible_agency_code(self) -> pulumi.Input[str]:
        """
        The responsible agency code.
        """
        return pulumi.get(self, "responsible_agency_code")

    @responsible_agency_code.setter
    def responsible_agency_code(self, value: pulumi.Input[str]):
        pulumi.set(self, "responsible_agency_code", value)

    @property
    @pulumi.getter(name="senderApplicationId")
    def sender_application_id(self) -> pulumi.Input[str]:
        """
        The sender application id.
        """
        return pulumi.get(self, "sender_application_id")

    @sender_application_id.setter
    def sender_application_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "sender_application_id", value)

    @property
    @pulumi.getter(name="targetNamespace")
    def target_namespace(self) -> pulumi.Input[str]:
        """
        The target namespace on which this envelope settings has to be applied.
        """
        return pulumi.get(self, "target_namespace")

    @target_namespace.setter
    def target_namespace(self, value: pulumi.Input[str]):
        pulumi.set(self, "target_namespace", value)

    @property
    @pulumi.getter(name="timeFormat")
    def time_format(self) -> pulumi.Input[Union[str, 'X12TimeFormat']]:
        """
        The time format.
        """
        return pulumi.get(self, "time_format")

    @time_format.setter
    def time_format(self, value: pulumi.Input[Union[str, 'X12TimeFormat']]):
        pulumi.set(self, "time_format", value)

    @property
    @pulumi.getter(name="functionalIdentifierCode")
    def functional_identifier_code(self) -> Optional[pulumi.Input[str]]:
        """
        The functional identifier code.
        """
        return pulumi.get(self, "functional_identifier_code")

    @functional_identifier_code.setter
    def functional_identifier_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "functional_identifier_code", value)


@pulumi.input_type
class X12EnvelopeSettingsArgs:
    def __init__(__self__, *,
                 control_standards_id: pulumi.Input[int],
                 control_version_number: pulumi.Input[str],
                 enable_default_group_headers: pulumi.Input[bool],
                 group_control_number_lower_bound: pulumi.Input[int],
                 group_control_number_upper_bound: pulumi.Input[int],
                 group_header_agency_code: pulumi.Input[str],
                 group_header_date_format: pulumi.Input[Union[str, 'X12DateFormat']],
                 group_header_time_format: pulumi.Input[Union[str, 'X12TimeFormat']],
                 group_header_version: pulumi.Input[str],
                 interchange_control_number_lower_bound: pulumi.Input[int],
                 interchange_control_number_upper_bound: pulumi.Input[int],
                 overwrite_existing_transaction_set_control_number: pulumi.Input[bool],
                 receiver_application_id: pulumi.Input[str],
                 rollover_group_control_number: pulumi.Input[bool],
                 rollover_interchange_control_number: pulumi.Input[bool],
                 rollover_transaction_set_control_number: pulumi.Input[bool],
                 sender_application_id: pulumi.Input[str],
                 transaction_set_control_number_lower_bound: pulumi.Input[int],
                 transaction_set_control_number_upper_bound: pulumi.Input[int],
                 usage_indicator: pulumi.Input[Union[str, 'UsageIndicator']],
                 use_control_standards_id_as_repetition_character: pulumi.Input[bool],
                 functional_group_id: Optional[pulumi.Input[str]] = None,
                 transaction_set_control_number_prefix: Optional[pulumi.Input[str]] = None,
                 transaction_set_control_number_suffix: Optional[pulumi.Input[str]] = None):
        """
        The X12 agreement envelope settings.
        :param pulumi.Input[int] control_standards_id: The controls standards id.
        :param pulumi.Input[str] control_version_number: The control version number.
        :param pulumi.Input[bool] enable_default_group_headers: The value indicating whether to enable default group headers.
        :param pulumi.Input[int] group_control_number_lower_bound: The group control number lower bound.
        :param pulumi.Input[int] group_control_number_upper_bound: The group control number upper bound.
        :param pulumi.Input[str] group_header_agency_code: The group header agency code.
        :param pulumi.Input[Union[str, 'X12DateFormat']] group_header_date_format: The group header date format.
        :param pulumi.Input[Union[str, 'X12TimeFormat']] group_header_time_format: The group header time format.
        :param pulumi.Input[str] group_header_version: The group header version.
        :param pulumi.Input[int] interchange_control_number_lower_bound: The interchange  control number lower bound.
        :param pulumi.Input[int] interchange_control_number_upper_bound: The interchange  control number upper bound.
        :param pulumi.Input[bool] overwrite_existing_transaction_set_control_number: The value indicating whether to overwrite existing transaction set control number.
        :param pulumi.Input[str] receiver_application_id: The receiver application id.
        :param pulumi.Input[bool] rollover_group_control_number: The value indicating whether to rollover group control number.
        :param pulumi.Input[bool] rollover_interchange_control_number: The value indicating whether to rollover interchange control number.
        :param pulumi.Input[bool] rollover_transaction_set_control_number: The value indicating whether to rollover transaction set control number.
        :param pulumi.Input[str] sender_application_id: The sender application id.
        :param pulumi.Input[int] transaction_set_control_number_lower_bound: The transaction set control number lower bound.
        :param pulumi.Input[int] transaction_set_control_number_upper_bound: The transaction set control number upper bound.
        :param pulumi.Input[Union[str, 'UsageIndicator']] usage_indicator: The usage indicator.
        :param pulumi.Input[bool] use_control_standards_id_as_repetition_character: The value indicating whether to use control standards id as repetition character.
        :param pulumi.Input[str] functional_group_id: The functional group id.
        :param pulumi.Input[str] transaction_set_control_number_prefix: The transaction set control number prefix.
        :param pulumi.Input[str] transaction_set_control_number_suffix: The transaction set control number suffix.
        """
        pulumi.set(__self__, "control_standards_id", control_standards_id)
        pulumi.set(__self__, "control_version_number", control_version_number)
        pulumi.set(__self__, "enable_default_group_headers", enable_default_group_headers)
        pulumi.set(__self__, "group_control_number_lower_bound", group_control_number_lower_bound)
        pulumi.set(__self__, "group_control_number_upper_bound", group_control_number_upper_bound)
        pulumi.set(__self__, "group_header_agency_code", group_header_agency_code)
        pulumi.set(__self__, "group_header_date_format", group_header_date_format)
        pulumi.set(__self__, "group_header_time_format", group_header_time_format)
        pulumi.set(__self__, "group_header_version", group_header_version)
        pulumi.set(__self__, "interchange_control_number_lower_bound", interchange_control_number_lower_bound)
        pulumi.set(__self__, "interchange_control_number_upper_bound", interchange_control_number_upper_bound)
        pulumi.set(__self__, "overwrite_existing_transaction_set_control_number", overwrite_existing_transaction_set_control_number)
        pulumi.set(__self__, "receiver_application_id", receiver_application_id)
        pulumi.set(__self__, "rollover_group_control_number", rollover_group_control_number)
        pulumi.set(__self__, "rollover_interchange_control_number", rollover_interchange_control_number)
        pulumi.set(__self__, "rollover_transaction_set_control_number", rollover_transaction_set_control_number)
        pulumi.set(__self__, "sender_application_id", sender_application_id)
        pulumi.set(__self__, "transaction_set_control_number_lower_bound", transaction_set_control_number_lower_bound)
        pulumi.set(__self__, "transaction_set_control_number_upper_bound", transaction_set_control_number_upper_bound)
        pulumi.set(__self__, "usage_indicator", usage_indicator)
        pulumi.set(__self__, "use_control_standards_id_as_repetition_character", use_control_standards_id_as_repetition_character)
        if functional_group_id is not None:
            pulumi.set(__self__, "functional_group_id", functional_group_id)
        if transaction_set_control_number_prefix is not None:
            pulumi.set(__self__, "transaction_set_control_number_prefix", transaction_set_control_number_prefix)
        if transaction_set_control_number_suffix is not None:
            pulumi.set(__self__, "transaction_set_control_number_suffix", transaction_set_control_number_suffix)

    @property
    @pulumi.getter(name="controlStandardsId")
    def control_standards_id(self) -> pulumi.Input[int]:
        """
        The controls standards id.
        """
        return pulumi.get(self, "control_standards_id")

    @control_standards_id.setter
    def control_standards_id(self, value: pulumi.Input[int]):
        pulumi.set(self, "control_standards_id", value)

    @property
    @pulumi.getter(name="controlVersionNumber")
    def control_version_number(self) -> pulumi.Input[str]:
        """
        The control version number.
        """
        return pulumi.get(self, "control_version_number")

    @control_version_number.setter
    def control_version_number(self, value: pulumi.Input[str]):
        pulumi.set(self, "control_version_number", value)

    @property
    @pulumi.getter(name="enableDefaultGroupHeaders")
    def enable_default_group_headers(self) -> pulumi.Input[bool]:
        """
        The value indicating whether to enable default group headers.
        """
        return pulumi.get(self, "enable_default_group_headers")

    @enable_default_group_headers.setter
    def enable_default_group_headers(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enable_default_group_headers", value)

    @property
    @pulumi.getter(name="groupControlNumberLowerBound")
    def group_control_number_lower_bound(self) -> pulumi.Input[int]:
        """
        The group control number lower bound.
        """
        return pulumi.get(self, "group_control_number_lower_bound")

    @group_control_number_lower_bound.setter
    def group_control_number_lower_bound(self, value: pulumi.Input[int]):
        pulumi.set(self, "group_control_number_lower_bound", value)

    @property
    @pulumi.getter(name="groupControlNumberUpperBound")
    def group_control_number_upper_bound(self) -> pulumi.Input[int]:
        """
        The group control number upper bound.
        """
        return pulumi.get(self, "group_control_number_upper_bound")

    @group_control_number_upper_bound.setter
    def group_control_number_upper_bound(self, value: pulumi.Input[int]):
        pulumi.set(self, "group_control_number_upper_bound", value)

    @property
    @pulumi.getter(name="groupHeaderAgencyCode")
    def group_header_agency_code(self) -> pulumi.Input[str]:
        """
        The group header agency code.
        """
        return pulumi.get(self, "group_header_agency_code")

    @group_header_agency_code.setter
    def group_header_agency_code(self, value: pulumi.Input[str]):
        pulumi.set(self, "group_header_agency_code", value)

    @property
    @pulumi.getter(name="groupHeaderDateFormat")
    def group_header_date_format(self) -> pulumi.Input[Union[str, 'X12DateFormat']]:
        """
        The group header date format.
        """
        return pulumi.get(self, "group_header_date_format")

    @group_header_date_format.setter
    def group_header_date_format(self, value: pulumi.Input[Union[str, 'X12DateFormat']]):
        pulumi.set(self, "group_header_date_format", value)

    @property
    @pulumi.getter(name="groupHeaderTimeFormat")
    def group_header_time_format(self) -> pulumi.Input[Union[str, 'X12TimeFormat']]:
        """
        The group header time format.
        """
        return pulumi.get(self, "group_header_time_format")

    @group_header_time_format.setter
    def group_header_time_format(self, value: pulumi.Input[Union[str, 'X12TimeFormat']]):
        pulumi.set(self, "group_header_time_format", value)

    @property
    @pulumi.getter(name="groupHeaderVersion")
    def group_header_version(self) -> pulumi.Input[str]:
        """
        The group header version.
        """
        return pulumi.get(self, "group_header_version")

    @group_header_version.setter
    def group_header_version(self, value: pulumi.Input[str]):
        pulumi.set(self, "group_header_version", value)

    @property
    @pulumi.getter(name="interchangeControlNumberLowerBound")
    def interchange_control_number_lower_bound(self) -> pulumi.Input[int]:
        """
        The interchange  control number lower bound.
        """
        return pulumi.get(self, "interchange_control_number_lower_bound")

    @interchange_control_number_lower_bound.setter
    def interchange_control_number_lower_bound(self, value: pulumi.Input[int]):
        pulumi.set(self, "interchange_control_number_lower_bound", value)

    @property
    @pulumi.getter(name="interchangeControlNumberUpperBound")
    def interchange_control_number_upper_bound(self) -> pulumi.Input[int]:
        """
        The interchange  control number upper bound.
        """
        return pulumi.get(self, "interchange_control_number_upper_bound")

    @interchange_control_number_upper_bound.setter
    def interchange_control_number_upper_bound(self, value: pulumi.Input[int]):
        pulumi.set(self, "interchange_control_number_upper_bound", value)

    @property
    @pulumi.getter(name="overwriteExistingTransactionSetControlNumber")
    def overwrite_existing_transaction_set_control_number(self) -> pulumi.Input[bool]:
        """
        The value indicating whether to overwrite existing transaction set control number.
        """
        return pulumi.get(self, "overwrite_existing_transaction_set_control_number")

    @overwrite_existing_transaction_set_control_number.setter
    def overwrite_existing_transaction_set_control_number(self, value: pulumi.Input[bool]):
        pulumi.set(self, "overwrite_existing_transaction_set_control_number", value)

    @property
    @pulumi.getter(name="receiverApplicationId")
    def receiver_application_id(self) -> pulumi.Input[str]:
        """
        The receiver application id.
        """
        return pulumi.get(self, "receiver_application_id")

    @receiver_application_id.setter
    def receiver_application_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "receiver_application_id", value)

    @property
    @pulumi.getter(name="rolloverGroupControlNumber")
    def rollover_group_control_number(self) -> pulumi.Input[bool]:
        """
        The value indicating whether to rollover group control number.
        """
        return pulumi.get(self, "rollover_group_control_number")

    @rollover_group_control_number.setter
    def rollover_group_control_number(self, value: pulumi.Input[bool]):
        pulumi.set(self, "rollover_group_control_number", value)

    @property
    @pulumi.getter(name="rolloverInterchangeControlNumber")
    def rollover_interchange_control_number(self) -> pulumi.Input[bool]:
        """
        The value indicating whether to rollover interchange control number.
        """
        return pulumi.get(self, "rollover_interchange_control_number")

    @rollover_interchange_control_number.setter
    def rollover_interchange_control_number(self, value: pulumi.Input[bool]):
        pulumi.set(self, "rollover_interchange_control_number", value)

    @property
    @pulumi.getter(name="rolloverTransactionSetControlNumber")
    def rollover_transaction_set_control_number(self) -> pulumi.Input[bool]:
        """
        The value indicating whether to rollover transaction set control number.
        """
        return pulumi.get(self, "rollover_transaction_set_control_number")

    @rollover_transaction_set_control_number.setter
    def rollover_transaction_set_control_number(self, value: pulumi.Input[bool]):
        pulumi.set(self, "rollover_transaction_set_control_number", value)

    @property
    @pulumi.getter(name="senderApplicationId")
    def sender_application_id(self) -> pulumi.Input[str]:
        """
        The sender application id.
        """
        return pulumi.get(self, "sender_application_id")

    @sender_application_id.setter
    def sender_application_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "sender_application_id", value)

    @property
    @pulumi.getter(name="transactionSetControlNumberLowerBound")
    def transaction_set_control_number_lower_bound(self) -> pulumi.Input[int]:
        """
        The transaction set control number lower bound.
        """
        return pulumi.get(self, "transaction_set_control_number_lower_bound")

    @transaction_set_control_number_lower_bound.setter
    def transaction_set_control_number_lower_bound(self, value: pulumi.Input[int]):
        pulumi.set(self, "transaction_set_control_number_lower_bound", value)

    @property
    @pulumi.getter(name="transactionSetControlNumberUpperBound")
    def transaction_set_control_number_upper_bound(self) -> pulumi.Input[int]:
        """
        The transaction set control number upper bound.
        """
        return pulumi.get(self, "transaction_set_control_number_upper_bound")

    @transaction_set_control_number_upper_bound.setter
    def transaction_set_control_number_upper_bound(self, value: pulumi.Input[int]):
        pulumi.set(self, "transaction_set_control_number_upper_bound", value)

    @property
    @pulumi.getter(name="usageIndicator")
    def usage_indicator(self) -> pulumi.Input[Union[str, 'UsageIndicator']]:
        """
        The usage indicator.
        """
        return pulumi.get(self, "usage_indicator")

    @usage_indicator.setter
    def usage_indicator(self, value: pulumi.Input[Union[str, 'UsageIndicator']]):
        pulumi.set(self, "usage_indicator", value)

    @property
    @pulumi.getter(name="useControlStandardsIdAsRepetitionCharacter")
    def use_control_standards_id_as_repetition_character(self) -> pulumi.Input[bool]:
        """
        The value indicating whether to use control standards id as repetition character.
        """
        return pulumi.get(self, "use_control_standards_id_as_repetition_character")

    @use_control_standards_id_as_repetition_character.setter
    def use_control_standards_id_as_repetition_character(self, value: pulumi.Input[bool]):
        pulumi.set(self, "use_control_standards_id_as_repetition_character", value)

    @property
    @pulumi.getter(name="functionalGroupId")
    def functional_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The functional group id.
        """
        return pulumi.get(self, "functional_group_id")

    @functional_group_id.setter
    def functional_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "functional_group_id", value)

    @property
    @pulumi.getter(name="transactionSetControlNumberPrefix")
    def transaction_set_control_number_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        The transaction set control number prefix.
        """
        return pulumi.get(self, "transaction_set_control_number_prefix")

    @transaction_set_control_number_prefix.setter
    def transaction_set_control_number_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "transaction_set_control_number_prefix", value)

    @property
    @pulumi.getter(name="transactionSetControlNumberSuffix")
    def transaction_set_control_number_suffix(self) -> Optional[pulumi.Input[str]]:
        """
        The transaction set control number suffix.
        """
        return pulumi.get(self, "transaction_set_control_number_suffix")

    @transaction_set_control_number_suffix.setter
    def transaction_set_control_number_suffix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "transaction_set_control_number_suffix", value)


@pulumi.input_type
class X12FramingSettingsArgs:
    def __init__(__self__, *,
                 character_set: pulumi.Input[Union[str, 'X12CharacterSet']],
                 component_separator: pulumi.Input[int],
                 data_element_separator: pulumi.Input[int],
                 replace_character: pulumi.Input[int],
                 replace_separators_in_payload: pulumi.Input[bool],
                 segment_terminator: pulumi.Input[int],
                 segment_terminator_suffix: pulumi.Input['SegmentTerminatorSuffix']):
        """
        The X12 agreement framing settings.
        :param pulumi.Input[Union[str, 'X12CharacterSet']] character_set: The X12 character set.
        :param pulumi.Input[int] component_separator: The component separator.
        :param pulumi.Input[int] data_element_separator: The data element separator.
        :param pulumi.Input[int] replace_character: The replacement character.
        :param pulumi.Input[bool] replace_separators_in_payload: The value indicating whether to replace separators in payload.
        :param pulumi.Input[int] segment_terminator: The segment terminator.
        :param pulumi.Input['SegmentTerminatorSuffix'] segment_terminator_suffix: The segment terminator suffix.
        """
        pulumi.set(__self__, "character_set", character_set)
        pulumi.set(__self__, "component_separator", component_separator)
        pulumi.set(__self__, "data_element_separator", data_element_separator)
        pulumi.set(__self__, "replace_character", replace_character)
        pulumi.set(__self__, "replace_separators_in_payload", replace_separators_in_payload)
        pulumi.set(__self__, "segment_terminator", segment_terminator)
        pulumi.set(__self__, "segment_terminator_suffix", segment_terminator_suffix)

    @property
    @pulumi.getter(name="characterSet")
    def character_set(self) -> pulumi.Input[Union[str, 'X12CharacterSet']]:
        """
        The X12 character set.
        """
        return pulumi.get(self, "character_set")

    @character_set.setter
    def character_set(self, value: pulumi.Input[Union[str, 'X12CharacterSet']]):
        pulumi.set(self, "character_set", value)

    @property
    @pulumi.getter(name="componentSeparator")
    def component_separator(self) -> pulumi.Input[int]:
        """
        The component separator.
        """
        return pulumi.get(self, "component_separator")

    @component_separator.setter
    def component_separator(self, value: pulumi.Input[int]):
        pulumi.set(self, "component_separator", value)

    @property
    @pulumi.getter(name="dataElementSeparator")
    def data_element_separator(self) -> pulumi.Input[int]:
        """
        The data element separator.
        """
        return pulumi.get(self, "data_element_separator")

    @data_element_separator.setter
    def data_element_separator(self, value: pulumi.Input[int]):
        pulumi.set(self, "data_element_separator", value)

    @property
    @pulumi.getter(name="replaceCharacter")
    def replace_character(self) -> pulumi.Input[int]:
        """
        The replacement character.
        """
        return pulumi.get(self, "replace_character")

    @replace_character.setter
    def replace_character(self, value: pulumi.Input[int]):
        pulumi.set(self, "replace_character", value)

    @property
    @pulumi.getter(name="replaceSeparatorsInPayload")
    def replace_separators_in_payload(self) -> pulumi.Input[bool]:
        """
        The value indicating whether to replace separators in payload.
        """
        return pulumi.get(self, "replace_separators_in_payload")

    @replace_separators_in_payload.setter
    def replace_separators_in_payload(self, value: pulumi.Input[bool]):
        pulumi.set(self, "replace_separators_in_payload", value)

    @property
    @pulumi.getter(name="segmentTerminator")
    def segment_terminator(self) -> pulumi.Input[int]:
        """
        The segment terminator.
        """
        return pulumi.get(self, "segment_terminator")

    @segment_terminator.setter
    def segment_terminator(self, value: pulumi.Input[int]):
        pulumi.set(self, "segment_terminator", value)

    @property
    @pulumi.getter(name="segmentTerminatorSuffix")
    def segment_terminator_suffix(self) -> pulumi.Input['SegmentTerminatorSuffix']:
        """
        The segment terminator suffix.
        """
        return pulumi.get(self, "segment_terminator_suffix")

    @segment_terminator_suffix.setter
    def segment_terminator_suffix(self, value: pulumi.Input['SegmentTerminatorSuffix']):
        pulumi.set(self, "segment_terminator_suffix", value)


@pulumi.input_type
class X12MessageFilterArgs:
    def __init__(__self__, *,
                 message_filter_type: pulumi.Input[Union[str, 'MessageFilterType']]):
        """
        The X12 message filter for odata query.
        :param pulumi.Input[Union[str, 'MessageFilterType']] message_filter_type: The message filter type.
        """
        pulumi.set(__self__, "message_filter_type", message_filter_type)

    @property
    @pulumi.getter(name="messageFilterType")
    def message_filter_type(self) -> pulumi.Input[Union[str, 'MessageFilterType']]:
        """
        The message filter type.
        """
        return pulumi.get(self, "message_filter_type")

    @message_filter_type.setter
    def message_filter_type(self, value: pulumi.Input[Union[str, 'MessageFilterType']]):
        pulumi.set(self, "message_filter_type", value)


@pulumi.input_type
class X12MessageIdentifierArgs:
    def __init__(__self__, *,
                 message_id: pulumi.Input[str]):
        """
        The X12 message identifier.
        :param pulumi.Input[str] message_id: The message id.
        """
        pulumi.set(__self__, "message_id", message_id)

    @property
    @pulumi.getter(name="messageId")
    def message_id(self) -> pulumi.Input[str]:
        """
        The message id.
        """
        return pulumi.get(self, "message_id")

    @message_id.setter
    def message_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "message_id", value)


@pulumi.input_type
class X12OneWayAgreementArgs:
    def __init__(__self__, *,
                 protocol_settings: pulumi.Input['X12ProtocolSettingsArgs'],
                 receiver_business_identity: pulumi.Input['BusinessIdentityArgs'],
                 sender_business_identity: pulumi.Input['BusinessIdentityArgs']):
        """
        The X12 one-way agreement.
        :param pulumi.Input['X12ProtocolSettingsArgs'] protocol_settings: The X12 protocol settings.
        :param pulumi.Input['BusinessIdentityArgs'] receiver_business_identity: The receiver business identity
        :param pulumi.Input['BusinessIdentityArgs'] sender_business_identity: The sender business identity
        """
        pulumi.set(__self__, "protocol_settings", protocol_settings)
        pulumi.set(__self__, "receiver_business_identity", receiver_business_identity)
        pulumi.set(__self__, "sender_business_identity", sender_business_identity)

    @property
    @pulumi.getter(name="protocolSettings")
    def protocol_settings(self) -> pulumi.Input['X12ProtocolSettingsArgs']:
        """
        The X12 protocol settings.
        """
        return pulumi.get(self, "protocol_settings")

    @protocol_settings.setter
    def protocol_settings(self, value: pulumi.Input['X12ProtocolSettingsArgs']):
        pulumi.set(self, "protocol_settings", value)

    @property
    @pulumi.getter(name="receiverBusinessIdentity")
    def receiver_business_identity(self) -> pulumi.Input['BusinessIdentityArgs']:
        """
        The receiver business identity
        """
        return pulumi.get(self, "receiver_business_identity")

    @receiver_business_identity.setter
    def receiver_business_identity(self, value: pulumi.Input['BusinessIdentityArgs']):
        pulumi.set(self, "receiver_business_identity", value)

    @property
    @pulumi.getter(name="senderBusinessIdentity")
    def sender_business_identity(self) -> pulumi.Input['BusinessIdentityArgs']:
        """
        The sender business identity
        """
        return pulumi.get(self, "sender_business_identity")

    @sender_business_identity.setter
    def sender_business_identity(self, value: pulumi.Input['BusinessIdentityArgs']):
        pulumi.set(self, "sender_business_identity", value)


@pulumi.input_type
class X12ProcessingSettingsArgs:
    def __init__(__self__, *,
                 convert_implied_decimal: pulumi.Input[bool],
                 create_empty_xml_tags_for_trailing_separators: pulumi.Input[bool],
                 mask_security_info: pulumi.Input[bool],
                 preserve_interchange: pulumi.Input[bool],
                 suspend_interchange_on_error: pulumi.Input[bool],
                 use_dot_as_decimal_separator: pulumi.Input[bool]):
        """
        The X12 processing settings.
        :param pulumi.Input[bool] convert_implied_decimal: The value indicating whether to convert numerical type to implied decimal.
        :param pulumi.Input[bool] create_empty_xml_tags_for_trailing_separators: The value indicating whether to create empty xml tags for trailing separators.
        :param pulumi.Input[bool] mask_security_info: The value indicating whether to mask security information.
        :param pulumi.Input[bool] preserve_interchange: The value indicating whether to preserve interchange.
        :param pulumi.Input[bool] suspend_interchange_on_error: The value indicating whether to suspend interchange on error.
        :param pulumi.Input[bool] use_dot_as_decimal_separator: The value indicating whether to use dot as decimal separator.
        """
        pulumi.set(__self__, "convert_implied_decimal", convert_implied_decimal)
        pulumi.set(__self__, "create_empty_xml_tags_for_trailing_separators", create_empty_xml_tags_for_trailing_separators)
        pulumi.set(__self__, "mask_security_info", mask_security_info)
        pulumi.set(__self__, "preserve_interchange", preserve_interchange)
        pulumi.set(__self__, "suspend_interchange_on_error", suspend_interchange_on_error)
        pulumi.set(__self__, "use_dot_as_decimal_separator", use_dot_as_decimal_separator)

    @property
    @pulumi.getter(name="convertImpliedDecimal")
    def convert_implied_decimal(self) -> pulumi.Input[bool]:
        """
        The value indicating whether to convert numerical type to implied decimal.
        """
        return pulumi.get(self, "convert_implied_decimal")

    @convert_implied_decimal.setter
    def convert_implied_decimal(self, value: pulumi.Input[bool]):
        pulumi.set(self, "convert_implied_decimal", value)

    @property
    @pulumi.getter(name="createEmptyXmlTagsForTrailingSeparators")
    def create_empty_xml_tags_for_trailing_separators(self) -> pulumi.Input[bool]:
        """
        The value indicating whether to create empty xml tags for trailing separators.
        """
        return pulumi.get(self, "create_empty_xml_tags_for_trailing_separators")

    @create_empty_xml_tags_for_trailing_separators.setter
    def create_empty_xml_tags_for_trailing_separators(self, value: pulumi.Input[bool]):
        pulumi.set(self, "create_empty_xml_tags_for_trailing_separators", value)

    @property
    @pulumi.getter(name="maskSecurityInfo")
    def mask_security_info(self) -> pulumi.Input[bool]:
        """
        The value indicating whether to mask security information.
        """
        return pulumi.get(self, "mask_security_info")

    @mask_security_info.setter
    def mask_security_info(self, value: pulumi.Input[bool]):
        pulumi.set(self, "mask_security_info", value)

    @property
    @pulumi.getter(name="preserveInterchange")
    def preserve_interchange(self) -> pulumi.Input[bool]:
        """
        The value indicating whether to preserve interchange.
        """
        return pulumi.get(self, "preserve_interchange")

    @preserve_interchange.setter
    def preserve_interchange(self, value: pulumi.Input[bool]):
        pulumi.set(self, "preserve_interchange", value)

    @property
    @pulumi.getter(name="suspendInterchangeOnError")
    def suspend_interchange_on_error(self) -> pulumi.Input[bool]:
        """
        The value indicating whether to suspend interchange on error.
        """
        return pulumi.get(self, "suspend_interchange_on_error")

    @suspend_interchange_on_error.setter
    def suspend_interchange_on_error(self, value: pulumi.Input[bool]):
        pulumi.set(self, "suspend_interchange_on_error", value)

    @property
    @pulumi.getter(name="useDotAsDecimalSeparator")
    def use_dot_as_decimal_separator(self) -> pulumi.Input[bool]:
        """
        The value indicating whether to use dot as decimal separator.
        """
        return pulumi.get(self, "use_dot_as_decimal_separator")

    @use_dot_as_decimal_separator.setter
    def use_dot_as_decimal_separator(self, value: pulumi.Input[bool]):
        pulumi.set(self, "use_dot_as_decimal_separator", value)


@pulumi.input_type
class X12ProtocolSettingsArgs:
    def __init__(__self__, *,
                 acknowledgement_settings: pulumi.Input['X12AcknowledgementSettingsArgs'],
                 envelope_settings: pulumi.Input['X12EnvelopeSettingsArgs'],
                 framing_settings: pulumi.Input['X12FramingSettingsArgs'],
                 message_filter: pulumi.Input['X12MessageFilterArgs'],
                 processing_settings: pulumi.Input['X12ProcessingSettingsArgs'],
                 schema_references: pulumi.Input[Sequence[pulumi.Input['X12SchemaReferenceArgs']]],
                 security_settings: pulumi.Input['X12SecuritySettingsArgs'],
                 validation_settings: pulumi.Input['X12ValidationSettingsArgs'],
                 envelope_overrides: Optional[pulumi.Input[Sequence[pulumi.Input['X12EnvelopeOverrideArgs']]]] = None,
                 message_filter_list: Optional[pulumi.Input[Sequence[pulumi.Input['X12MessageIdentifierArgs']]]] = None,
                 validation_overrides: Optional[pulumi.Input[Sequence[pulumi.Input['X12ValidationOverrideArgs']]]] = None,
                 x12_delimiter_overrides: Optional[pulumi.Input[Sequence[pulumi.Input['X12DelimiterOverridesArgs']]]] = None):
        """
        The X12 agreement protocol settings.
        :param pulumi.Input['X12AcknowledgementSettingsArgs'] acknowledgement_settings: The X12 acknowledgment settings.
        :param pulumi.Input['X12EnvelopeSettingsArgs'] envelope_settings: The X12 envelope settings.
        :param pulumi.Input['X12FramingSettingsArgs'] framing_settings: The X12 framing settings.
        :param pulumi.Input['X12MessageFilterArgs'] message_filter: The X12 message filter.
        :param pulumi.Input['X12ProcessingSettingsArgs'] processing_settings: The X12 processing settings.
        :param pulumi.Input[Sequence[pulumi.Input['X12SchemaReferenceArgs']]] schema_references: The X12 schema references.
        :param pulumi.Input['X12SecuritySettingsArgs'] security_settings: The X12 security settings.
        :param pulumi.Input['X12ValidationSettingsArgs'] validation_settings: The X12 validation settings.
        :param pulumi.Input[Sequence[pulumi.Input['X12EnvelopeOverrideArgs']]] envelope_overrides: The X12 envelope override settings.
        :param pulumi.Input[Sequence[pulumi.Input['X12MessageIdentifierArgs']]] message_filter_list: The X12 message filter list.
        :param pulumi.Input[Sequence[pulumi.Input['X12ValidationOverrideArgs']]] validation_overrides: The X12 validation override settings.
        :param pulumi.Input[Sequence[pulumi.Input['X12DelimiterOverridesArgs']]] x12_delimiter_overrides: The X12 delimiter override settings.
        """
        pulumi.set(__self__, "acknowledgement_settings", acknowledgement_settings)
        pulumi.set(__self__, "envelope_settings", envelope_settings)
        pulumi.set(__self__, "framing_settings", framing_settings)
        pulumi.set(__self__, "message_filter", message_filter)
        pulumi.set(__self__, "processing_settings", processing_settings)
        pulumi.set(__self__, "schema_references", schema_references)
        pulumi.set(__self__, "security_settings", security_settings)
        pulumi.set(__self__, "validation_settings", validation_settings)
        if envelope_overrides is not None:
            pulumi.set(__self__, "envelope_overrides", envelope_overrides)
        if message_filter_list is not None:
            pulumi.set(__self__, "message_filter_list", message_filter_list)
        if validation_overrides is not None:
            pulumi.set(__self__, "validation_overrides", validation_overrides)
        if x12_delimiter_overrides is not None:
            pulumi.set(__self__, "x12_delimiter_overrides", x12_delimiter_overrides)

    @property
    @pulumi.getter(name="acknowledgementSettings")
    def acknowledgement_settings(self) -> pulumi.Input['X12AcknowledgementSettingsArgs']:
        """
        The X12 acknowledgment settings.
        """
        return pulumi.get(self, "acknowledgement_settings")

    @acknowledgement_settings.setter
    def acknowledgement_settings(self, value: pulumi.Input['X12AcknowledgementSettingsArgs']):
        pulumi.set(self, "acknowledgement_settings", value)

    @property
    @pulumi.getter(name="envelopeSettings")
    def envelope_settings(self) -> pulumi.Input['X12EnvelopeSettingsArgs']:
        """
        The X12 envelope settings.
        """
        return pulumi.get(self, "envelope_settings")

    @envelope_settings.setter
    def envelope_settings(self, value: pulumi.Input['X12EnvelopeSettingsArgs']):
        pulumi.set(self, "envelope_settings", value)

    @property
    @pulumi.getter(name="framingSettings")
    def framing_settings(self) -> pulumi.Input['X12FramingSettingsArgs']:
        """
        The X12 framing settings.
        """
        return pulumi.get(self, "framing_settings")

    @framing_settings.setter
    def framing_settings(self, value: pulumi.Input['X12FramingSettingsArgs']):
        pulumi.set(self, "framing_settings", value)

    @property
    @pulumi.getter(name="messageFilter")
    def message_filter(self) -> pulumi.Input['X12MessageFilterArgs']:
        """
        The X12 message filter.
        """
        return pulumi.get(self, "message_filter")

    @message_filter.setter
    def message_filter(self, value: pulumi.Input['X12MessageFilterArgs']):
        pulumi.set(self, "message_filter", value)

    @property
    @pulumi.getter(name="processingSettings")
    def processing_settings(self) -> pulumi.Input['X12ProcessingSettingsArgs']:
        """
        The X12 processing settings.
        """
        return pulumi.get(self, "processing_settings")

    @processing_settings.setter
    def processing_settings(self, value: pulumi.Input['X12ProcessingSettingsArgs']):
        pulumi.set(self, "processing_settings", value)

    @property
    @pulumi.getter(name="schemaReferences")
    def schema_references(self) -> pulumi.Input[Sequence[pulumi.Input['X12SchemaReferenceArgs']]]:
        """
        The X12 schema references.
        """
        return pulumi.get(self, "schema_references")

    @schema_references.setter
    def schema_references(self, value: pulumi.Input[Sequence[pulumi.Input['X12SchemaReferenceArgs']]]):
        pulumi.set(self, "schema_references", value)

    @property
    @pulumi.getter(name="securitySettings")
    def security_settings(self) -> pulumi.Input['X12SecuritySettingsArgs']:
        """
        The X12 security settings.
        """
        return pulumi.get(self, "security_settings")

    @security_settings.setter
    def security_settings(self, value: pulumi.Input['X12SecuritySettingsArgs']):
        pulumi.set(self, "security_settings", value)

    @property
    @pulumi.getter(name="validationSettings")
    def validation_settings(self) -> pulumi.Input['X12ValidationSettingsArgs']:
        """
        The X12 validation settings.
        """
        return pulumi.get(self, "validation_settings")

    @validation_settings.setter
    def validation_settings(self, value: pulumi.Input['X12ValidationSettingsArgs']):
        pulumi.set(self, "validation_settings", value)

    @property
    @pulumi.getter(name="envelopeOverrides")
    def envelope_overrides(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['X12EnvelopeOverrideArgs']]]]:
        """
        The X12 envelope override settings.
        """
        return pulumi.get(self, "envelope_overrides")

    @envelope_overrides.setter
    def envelope_overrides(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['X12EnvelopeOverrideArgs']]]]):
        pulumi.set(self, "envelope_overrides", value)

    @property
    @pulumi.getter(name="messageFilterList")
    def message_filter_list(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['X12MessageIdentifierArgs']]]]:
        """
        The X12 message filter list.
        """
        return pulumi.get(self, "message_filter_list")

    @message_filter_list.setter
    def message_filter_list(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['X12MessageIdentifierArgs']]]]):
        pulumi.set(self, "message_filter_list", value)

    @property
    @pulumi.getter(name="validationOverrides")
    def validation_overrides(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['X12ValidationOverrideArgs']]]]:
        """
        The X12 validation override settings.
        """
        return pulumi.get(self, "validation_overrides")

    @validation_overrides.setter
    def validation_overrides(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['X12ValidationOverrideArgs']]]]):
        pulumi.set(self, "validation_overrides", value)

    @property
    @pulumi.getter(name="x12DelimiterOverrides")
    def x12_delimiter_overrides(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['X12DelimiterOverridesArgs']]]]:
        """
        The X12 delimiter override settings.
        """
        return pulumi.get(self, "x12_delimiter_overrides")

    @x12_delimiter_overrides.setter
    def x12_delimiter_overrides(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['X12DelimiterOverridesArgs']]]]):
        pulumi.set(self, "x12_delimiter_overrides", value)


@pulumi.input_type
class X12SchemaReferenceArgs:
    def __init__(__self__, *,
                 message_id: pulumi.Input[str],
                 schema_name: pulumi.Input[str],
                 schema_version: pulumi.Input[str],
                 sender_application_id: Optional[pulumi.Input[str]] = None):
        """
        The X12 schema reference.
        :param pulumi.Input[str] message_id: The message id.
        :param pulumi.Input[str] schema_name: The schema name.
        :param pulumi.Input[str] schema_version: The schema version.
        :param pulumi.Input[str] sender_application_id: The sender application id.
        """
        pulumi.set(__self__, "message_id", message_id)
        pulumi.set(__self__, "schema_name", schema_name)
        pulumi.set(__self__, "schema_version", schema_version)
        if sender_application_id is not None:
            pulumi.set(__self__, "sender_application_id", sender_application_id)

    @property
    @pulumi.getter(name="messageId")
    def message_id(self) -> pulumi.Input[str]:
        """
        The message id.
        """
        return pulumi.get(self, "message_id")

    @message_id.setter
    def message_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "message_id", value)

    @property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> pulumi.Input[str]:
        """
        The schema name.
        """
        return pulumi.get(self, "schema_name")

    @schema_name.setter
    def schema_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "schema_name", value)

    @property
    @pulumi.getter(name="schemaVersion")
    def schema_version(self) -> pulumi.Input[str]:
        """
        The schema version.
        """
        return pulumi.get(self, "schema_version")

    @schema_version.setter
    def schema_version(self, value: pulumi.Input[str]):
        pulumi.set(self, "schema_version", value)

    @property
    @pulumi.getter(name="senderApplicationId")
    def sender_application_id(self) -> Optional[pulumi.Input[str]]:
        """
        The sender application id.
        """
        return pulumi.get(self, "sender_application_id")

    @sender_application_id.setter
    def sender_application_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sender_application_id", value)


@pulumi.input_type
class X12SecuritySettingsArgs:
    def __init__(__self__, *,
                 authorization_qualifier: pulumi.Input[str],
                 security_qualifier: pulumi.Input[str],
                 authorization_value: Optional[pulumi.Input[str]] = None,
                 password_value: Optional[pulumi.Input[str]] = None):
        """
        The X12 agreement security settings.
        :param pulumi.Input[str] authorization_qualifier: The authorization qualifier.
        :param pulumi.Input[str] security_qualifier: The security qualifier.
        :param pulumi.Input[str] authorization_value: The authorization value.
        :param pulumi.Input[str] password_value: The password value.
        """
        pulumi.set(__self__, "authorization_qualifier", authorization_qualifier)
        pulumi.set(__self__, "security_qualifier", security_qualifier)
        if authorization_value is not None:
            pulumi.set(__self__, "authorization_value", authorization_value)
        if password_value is not None:
            pulumi.set(__self__, "password_value", password_value)

    @property
    @pulumi.getter(name="authorizationQualifier")
    def authorization_qualifier(self) -> pulumi.Input[str]:
        """
        The authorization qualifier.
        """
        return pulumi.get(self, "authorization_qualifier")

    @authorization_qualifier.setter
    def authorization_qualifier(self, value: pulumi.Input[str]):
        pulumi.set(self, "authorization_qualifier", value)

    @property
    @pulumi.getter(name="securityQualifier")
    def security_qualifier(self) -> pulumi.Input[str]:
        """
        The security qualifier.
        """
        return pulumi.get(self, "security_qualifier")

    @security_qualifier.setter
    def security_qualifier(self, value: pulumi.Input[str]):
        pulumi.set(self, "security_qualifier", value)

    @property
    @pulumi.getter(name="authorizationValue")
    def authorization_value(self) -> Optional[pulumi.Input[str]]:
        """
        The authorization value.
        """
        return pulumi.get(self, "authorization_value")

    @authorization_value.setter
    def authorization_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authorization_value", value)

    @property
    @pulumi.getter(name="passwordValue")
    def password_value(self) -> Optional[pulumi.Input[str]]:
        """
        The password value.
        """
        return pulumi.get(self, "password_value")

    @password_value.setter
    def password_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password_value", value)


@pulumi.input_type
class X12ValidationOverrideArgs:
    def __init__(__self__, *,
                 allow_leading_and_trailing_spaces_and_zeroes: pulumi.Input[bool],
                 message_id: pulumi.Input[str],
                 trailing_separator_policy: pulumi.Input[Union[str, 'TrailingSeparatorPolicy']],
                 trim_leading_and_trailing_spaces_and_zeroes: pulumi.Input[bool],
                 validate_character_set: pulumi.Input[bool],
                 validate_edi_types: pulumi.Input[bool],
                 validate_xsd_types: pulumi.Input[bool]):
        """
        The X12 validation override settings.
        :param pulumi.Input[bool] allow_leading_and_trailing_spaces_and_zeroes: The value indicating whether to allow leading and trailing spaces and zeroes.
        :param pulumi.Input[str] message_id: The message id on which the validation settings has to be applied.
        :param pulumi.Input[Union[str, 'TrailingSeparatorPolicy']] trailing_separator_policy: The trailing separator policy.
        :param pulumi.Input[bool] trim_leading_and_trailing_spaces_and_zeroes: The value indicating whether to trim leading and trailing spaces and zeroes.
        :param pulumi.Input[bool] validate_character_set: The value indicating whether to validate character Set.
        :param pulumi.Input[bool] validate_edi_types: The value indicating whether to validate EDI types.
        :param pulumi.Input[bool] validate_xsd_types: The value indicating whether to validate XSD types.
        """
        pulumi.set(__self__, "allow_leading_and_trailing_spaces_and_zeroes", allow_leading_and_trailing_spaces_and_zeroes)
        pulumi.set(__self__, "message_id", message_id)
        pulumi.set(__self__, "trailing_separator_policy", trailing_separator_policy)
        pulumi.set(__self__, "trim_leading_and_trailing_spaces_and_zeroes", trim_leading_and_trailing_spaces_and_zeroes)
        pulumi.set(__self__, "validate_character_set", validate_character_set)
        pulumi.set(__self__, "validate_edi_types", validate_edi_types)
        pulumi.set(__self__, "validate_xsd_types", validate_xsd_types)

    @property
    @pulumi.getter(name="allowLeadingAndTrailingSpacesAndZeroes")
    def allow_leading_and_trailing_spaces_and_zeroes(self) -> pulumi.Input[bool]:
        """
        The value indicating whether to allow leading and trailing spaces and zeroes.
        """
        return pulumi.get(self, "allow_leading_and_trailing_spaces_and_zeroes")

    @allow_leading_and_trailing_spaces_and_zeroes.setter
    def allow_leading_and_trailing_spaces_and_zeroes(self, value: pulumi.Input[bool]):
        pulumi.set(self, "allow_leading_and_trailing_spaces_and_zeroes", value)

    @property
    @pulumi.getter(name="messageId")
    def message_id(self) -> pulumi.Input[str]:
        """
        The message id on which the validation settings has to be applied.
        """
        return pulumi.get(self, "message_id")

    @message_id.setter
    def message_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "message_id", value)

    @property
    @pulumi.getter(name="trailingSeparatorPolicy")
    def trailing_separator_policy(self) -> pulumi.Input[Union[str, 'TrailingSeparatorPolicy']]:
        """
        The trailing separator policy.
        """
        return pulumi.get(self, "trailing_separator_policy")

    @trailing_separator_policy.setter
    def trailing_separator_policy(self, value: pulumi.Input[Union[str, 'TrailingSeparatorPolicy']]):
        pulumi.set(self, "trailing_separator_policy", value)

    @property
    @pulumi.getter(name="trimLeadingAndTrailingSpacesAndZeroes")
    def trim_leading_and_trailing_spaces_and_zeroes(self) -> pulumi.Input[bool]:
        """
        The value indicating whether to trim leading and trailing spaces and zeroes.
        """
        return pulumi.get(self, "trim_leading_and_trailing_spaces_and_zeroes")

    @trim_leading_and_trailing_spaces_and_zeroes.setter
    def trim_leading_and_trailing_spaces_and_zeroes(self, value: pulumi.Input[bool]):
        pulumi.set(self, "trim_leading_and_trailing_spaces_and_zeroes", value)

    @property
    @pulumi.getter(name="validateCharacterSet")
    def validate_character_set(self) -> pulumi.Input[bool]:
        """
        The value indicating whether to validate character Set.
        """
        return pulumi.get(self, "validate_character_set")

    @validate_character_set.setter
    def validate_character_set(self, value: pulumi.Input[bool]):
        pulumi.set(self, "validate_character_set", value)

    @property
    @pulumi.getter(name="validateEDITypes")
    def validate_edi_types(self) -> pulumi.Input[bool]:
        """
        The value indicating whether to validate EDI types.
        """
        return pulumi.get(self, "validate_edi_types")

    @validate_edi_types.setter
    def validate_edi_types(self, value: pulumi.Input[bool]):
        pulumi.set(self, "validate_edi_types", value)

    @property
    @pulumi.getter(name="validateXSDTypes")
    def validate_xsd_types(self) -> pulumi.Input[bool]:
        """
        The value indicating whether to validate XSD types.
        """
        return pulumi.get(self, "validate_xsd_types")

    @validate_xsd_types.setter
    def validate_xsd_types(self, value: pulumi.Input[bool]):
        pulumi.set(self, "validate_xsd_types", value)


@pulumi.input_type
class X12ValidationSettingsArgs:
    def __init__(__self__, *,
                 allow_leading_and_trailing_spaces_and_zeroes: pulumi.Input[bool],
                 check_duplicate_group_control_number: pulumi.Input[bool],
                 check_duplicate_interchange_control_number: pulumi.Input[bool],
                 check_duplicate_transaction_set_control_number: pulumi.Input[bool],
                 interchange_control_number_validity_days: pulumi.Input[int],
                 trailing_separator_policy: pulumi.Input[Union[str, 'TrailingSeparatorPolicy']],
                 trim_leading_and_trailing_spaces_and_zeroes: pulumi.Input[bool],
                 validate_character_set: pulumi.Input[bool],
                 validate_edi_types: pulumi.Input[bool],
                 validate_xsd_types: pulumi.Input[bool]):
        """
        The X12 agreement validation settings.
        :param pulumi.Input[bool] allow_leading_and_trailing_spaces_and_zeroes: The value indicating whether to allow leading and trailing spaces and zeroes.
        :param pulumi.Input[bool] check_duplicate_group_control_number: The value indicating whether to check for duplicate group control number.
        :param pulumi.Input[bool] check_duplicate_interchange_control_number: The value indicating whether to check for duplicate interchange control number.
        :param pulumi.Input[bool] check_duplicate_transaction_set_control_number: The value indicating whether to check for duplicate transaction set control number.
        :param pulumi.Input[int] interchange_control_number_validity_days: The validity period of interchange control number.
        :param pulumi.Input[Union[str, 'TrailingSeparatorPolicy']] trailing_separator_policy: The trailing separator policy.
        :param pulumi.Input[bool] trim_leading_and_trailing_spaces_and_zeroes: The value indicating whether to trim leading and trailing spaces and zeroes.
        :param pulumi.Input[bool] validate_character_set: The value indicating whether to validate character set in the message.
        :param pulumi.Input[bool] validate_edi_types: The value indicating whether to Whether to validate EDI types.
        :param pulumi.Input[bool] validate_xsd_types: The value indicating whether to Whether to validate XSD types.
        """
        pulumi.set(__self__, "allow_leading_and_trailing_spaces_and_zeroes", allow_leading_and_trailing_spaces_and_zeroes)
        pulumi.set(__self__, "check_duplicate_group_control_number", check_duplicate_group_control_number)
        pulumi.set(__self__, "check_duplicate_interchange_control_number", check_duplicate_interchange_control_number)
        pulumi.set(__self__, "check_duplicate_transaction_set_control_number", check_duplicate_transaction_set_control_number)
        pulumi.set(__self__, "interchange_control_number_validity_days", interchange_control_number_validity_days)
        pulumi.set(__self__, "trailing_separator_policy", trailing_separator_policy)
        pulumi.set(__self__, "trim_leading_and_trailing_spaces_and_zeroes", trim_leading_and_trailing_spaces_and_zeroes)
        pulumi.set(__self__, "validate_character_set", validate_character_set)
        pulumi.set(__self__, "validate_edi_types", validate_edi_types)
        pulumi.set(__self__, "validate_xsd_types", validate_xsd_types)

    @property
    @pulumi.getter(name="allowLeadingAndTrailingSpacesAndZeroes")
    def allow_leading_and_trailing_spaces_and_zeroes(self) -> pulumi.Input[bool]:
        """
        The value indicating whether to allow leading and trailing spaces and zeroes.
        """
        return pulumi.get(self, "allow_leading_and_trailing_spaces_and_zeroes")

    @allow_leading_and_trailing_spaces_and_zeroes.setter
    def allow_leading_and_trailing_spaces_and_zeroes(self, value: pulumi.Input[bool]):
        pulumi.set(self, "allow_leading_and_trailing_spaces_and_zeroes", value)

    @property
    @pulumi.getter(name="checkDuplicateGroupControlNumber")
    def check_duplicate_group_control_number(self) -> pulumi.Input[bool]:
        """
        The value indicating whether to check for duplicate group control number.
        """
        return pulumi.get(self, "check_duplicate_group_control_number")

    @check_duplicate_group_control_number.setter
    def check_duplicate_group_control_number(self, value: pulumi.Input[bool]):
        pulumi.set(self, "check_duplicate_group_control_number", value)

    @property
    @pulumi.getter(name="checkDuplicateInterchangeControlNumber")
    def check_duplicate_interchange_control_number(self) -> pulumi.Input[bool]:
        """
        The value indicating whether to check for duplicate interchange control number.
        """
        return pulumi.get(self, "check_duplicate_interchange_control_number")

    @check_duplicate_interchange_control_number.setter
    def check_duplicate_interchange_control_number(self, value: pulumi.Input[bool]):
        pulumi.set(self, "check_duplicate_interchange_control_number", value)

    @property
    @pulumi.getter(name="checkDuplicateTransactionSetControlNumber")
    def check_duplicate_transaction_set_control_number(self) -> pulumi.Input[bool]:
        """
        The value indicating whether to check for duplicate transaction set control number.
        """
        return pulumi.get(self, "check_duplicate_transaction_set_control_number")

    @check_duplicate_transaction_set_control_number.setter
    def check_duplicate_transaction_set_control_number(self, value: pulumi.Input[bool]):
        pulumi.set(self, "check_duplicate_transaction_set_control_number", value)

    @property
    @pulumi.getter(name="interchangeControlNumberValidityDays")
    def interchange_control_number_validity_days(self) -> pulumi.Input[int]:
        """
        The validity period of interchange control number.
        """
        return pulumi.get(self, "interchange_control_number_validity_days")

    @interchange_control_number_validity_days.setter
    def interchange_control_number_validity_days(self, value: pulumi.Input[int]):
        pulumi.set(self, "interchange_control_number_validity_days", value)

    @property
    @pulumi.getter(name="trailingSeparatorPolicy")
    def trailing_separator_policy(self) -> pulumi.Input[Union[str, 'TrailingSeparatorPolicy']]:
        """
        The trailing separator policy.
        """
        return pulumi.get(self, "trailing_separator_policy")

    @trailing_separator_policy.setter
    def trailing_separator_policy(self, value: pulumi.Input[Union[str, 'TrailingSeparatorPolicy']]):
        pulumi.set(self, "trailing_separator_policy", value)

    @property
    @pulumi.getter(name="trimLeadingAndTrailingSpacesAndZeroes")
    def trim_leading_and_trailing_spaces_and_zeroes(self) -> pulumi.Input[bool]:
        """
        The value indicating whether to trim leading and trailing spaces and zeroes.
        """
        return pulumi.get(self, "trim_leading_and_trailing_spaces_and_zeroes")

    @trim_leading_and_trailing_spaces_and_zeroes.setter
    def trim_leading_and_trailing_spaces_and_zeroes(self, value: pulumi.Input[bool]):
        pulumi.set(self, "trim_leading_and_trailing_spaces_and_zeroes", value)

    @property
    @pulumi.getter(name="validateCharacterSet")
    def validate_character_set(self) -> pulumi.Input[bool]:
        """
        The value indicating whether to validate character set in the message.
        """
        return pulumi.get(self, "validate_character_set")

    @validate_character_set.setter
    def validate_character_set(self, value: pulumi.Input[bool]):
        pulumi.set(self, "validate_character_set", value)

    @property
    @pulumi.getter(name="validateEDITypes")
    def validate_edi_types(self) -> pulumi.Input[bool]:
        """
        The value indicating whether to Whether to validate EDI types.
        """
        return pulumi.get(self, "validate_edi_types")

    @validate_edi_types.setter
    def validate_edi_types(self, value: pulumi.Input[bool]):
        pulumi.set(self, "validate_edi_types", value)

    @property
    @pulumi.getter(name="validateXSDTypes")
    def validate_xsd_types(self) -> pulumi.Input[bool]:
        """
        The value indicating whether to Whether to validate XSD types.
        """
        return pulumi.get(self, "validate_xsd_types")

    @validate_xsd_types.setter
    def validate_xsd_types(self, value: pulumi.Input[bool]):
        pulumi.set(self, "validate_xsd_types", value)


