# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities

__all__ = [
    'GetRegistryCredentialsResult',
    'AwaitableGetRegistryCredentialsResult',
    'get_registry_credentials',
    'get_registry_credentials_output',
]

@pulumi.output_type
class GetRegistryCredentialsResult:
    """
    The result of a request to get the administrator login credentials for a container registry.
    """
    def __init__(__self__, password=None, username=None):
        if password and not isinstance(password, str):
            raise TypeError("Expected argument 'password' to be a str")
        pulumi.set(__self__, "password", password)
        if username and not isinstance(username, str):
            raise TypeError("Expected argument 'username' to be a str")
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        The administrator password.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        """
        The administrator username.
        """
        return pulumi.get(self, "username")


class AwaitableGetRegistryCredentialsResult(GetRegistryCredentialsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRegistryCredentialsResult(
            password=self.password,
            username=self.username)


def get_registry_credentials(registry_name: Optional[str] = None,
                             resource_group_name: Optional[str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRegistryCredentialsResult:
    """
    Gets the administrator login credentials for the specified container registry.


    :param str registry_name: The name of the container registry.
    :param str resource_group_name: The name of the resource group to which the container registry belongs.
    """
    __args__ = dict()
    __args__['registryName'] = registry_name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure-native:containerregistry/v20160627preview:getRegistryCredentials', __args__, opts=opts, typ=GetRegistryCredentialsResult).value

    return AwaitableGetRegistryCredentialsResult(
        password=__ret__.password,
        username=__ret__.username)


@_utilities.lift_output_func(get_registry_credentials)
def get_registry_credentials_output(registry_name: Optional[pulumi.Input[str]] = None,
                                    resource_group_name: Optional[pulumi.Input[str]] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetRegistryCredentialsResult]:
    """
    Gets the administrator login credentials for the specified container registry.


    :param str registry_name: The name of the container registry.
    :param str resource_group_name: The name of the resource group to which the container registry belongs.
    """
    ...
