# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'PrimaryRegionPropertiesResponse',
    'ServiceRegionPropertiesResponse',
    'SystemDataResponse',
]

@pulumi.output_type
class PrimaryRegionPropertiesResponse(dict):
    """
    The configuration used in this region as primary, and other regions as backup.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "operatorAddresses":
            suggest = "operator_addresses"
        elif key == "allowedMediaSourceAddressPrefixes":
            suggest = "allowed_media_source_address_prefixes"
        elif key == "allowedSignalingSourceAddressPrefixes":
            suggest = "allowed_signaling_source_address_prefixes"
        elif key == "esrpAddresses":
            suggest = "esrp_addresses"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrimaryRegionPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrimaryRegionPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrimaryRegionPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 operator_addresses: Sequence[str],
                 allowed_media_source_address_prefixes: Optional[Sequence[str]] = None,
                 allowed_signaling_source_address_prefixes: Optional[Sequence[str]] = None,
                 esrp_addresses: Optional[Sequence[str]] = None):
        """
        The configuration used in this region as primary, and other regions as backup.
        :param Sequence[str] operator_addresses: IP address to use to contact the operator network from this region
        :param Sequence[str] allowed_media_source_address_prefixes: The allowed source IP address or CIDR ranges for media
        :param Sequence[str] allowed_signaling_source_address_prefixes: The allowed source IP address or CIDR ranges for signaling
        :param Sequence[str] esrp_addresses: IP address to use to contact the ESRP from this region
        """
        pulumi.set(__self__, "operator_addresses", operator_addresses)
        if allowed_media_source_address_prefixes is not None:
            pulumi.set(__self__, "allowed_media_source_address_prefixes", allowed_media_source_address_prefixes)
        if allowed_signaling_source_address_prefixes is not None:
            pulumi.set(__self__, "allowed_signaling_source_address_prefixes", allowed_signaling_source_address_prefixes)
        if esrp_addresses is not None:
            pulumi.set(__self__, "esrp_addresses", esrp_addresses)

    @property
    @pulumi.getter(name="operatorAddresses")
    def operator_addresses(self) -> Sequence[str]:
        """
        IP address to use to contact the operator network from this region
        """
        return pulumi.get(self, "operator_addresses")

    @property
    @pulumi.getter(name="allowedMediaSourceAddressPrefixes")
    def allowed_media_source_address_prefixes(self) -> Optional[Sequence[str]]:
        """
        The allowed source IP address or CIDR ranges for media
        """
        return pulumi.get(self, "allowed_media_source_address_prefixes")

    @property
    @pulumi.getter(name="allowedSignalingSourceAddressPrefixes")
    def allowed_signaling_source_address_prefixes(self) -> Optional[Sequence[str]]:
        """
        The allowed source IP address or CIDR ranges for signaling
        """
        return pulumi.get(self, "allowed_signaling_source_address_prefixes")

    @property
    @pulumi.getter(name="esrpAddresses")
    def esrp_addresses(self) -> Optional[Sequence[str]]:
        """
        IP address to use to contact the ESRP from this region
        """
        return pulumi.get(self, "esrp_addresses")


@pulumi.output_type
class ServiceRegionPropertiesResponse(dict):
    """
    The service region configuration needed for Teams Callings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "primaryRegionProperties":
            suggest = "primary_region_properties"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceRegionPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceRegionPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceRegionPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 primary_region_properties: 'outputs.PrimaryRegionPropertiesResponse'):
        """
        The service region configuration needed for Teams Callings.
        :param str name: The name of the region in which the resources needed for Teams Calling will be deployed.
        :param 'PrimaryRegionPropertiesResponse' primary_region_properties: The configuration used in this region as primary, and other regions as backup.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "primary_region_properties", primary_region_properties)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the region in which the resources needed for Teams Calling will be deployed.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="primaryRegionProperties")
    def primary_region_properties(self) -> 'outputs.PrimaryRegionPropertiesResponse':
        """
        The configuration used in this region as primary, and other regions as backup.
        """
        return pulumi.get(self, "primary_region_properties")


@pulumi.output_type
class SystemDataResponse(dict):
    """
    Metadata pertaining to creation and last modification of the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "createdBy":
            suggest = "created_by"
        elif key == "createdByType":
            suggest = "created_by_type"
        elif key == "lastModifiedAt":
            suggest = "last_modified_at"
        elif key == "lastModifiedBy":
            suggest = "last_modified_by"
        elif key == "lastModifiedByType":
            suggest = "last_modified_by_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SystemDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: Optional[str] = None,
                 created_by: Optional[str] = None,
                 created_by_type: Optional[str] = None,
                 last_modified_at: Optional[str] = None,
                 last_modified_by: Optional[str] = None,
                 last_modified_by_type: Optional[str] = None):
        """
        Metadata pertaining to creation and last modification of the resource.
        :param str created_at: The timestamp of resource creation (UTC).
        :param str created_by: The identity that created the resource.
        :param str created_by_type: The type of identity that created the resource.
        :param str last_modified_at: The timestamp of resource last modification (UTC)
        :param str last_modified_by: The identity that last modified the resource.
        :param str last_modified_by_type: The type of identity that last modified the resource.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_by_type is not None:
            pulumi.set(__self__, "created_by_type", created_by_type)
        if last_modified_at is not None:
            pulumi.set(__self__, "last_modified_at", last_modified_at)
        if last_modified_by is not None:
            pulumi.set(__self__, "last_modified_by", last_modified_by)
        if last_modified_by_type is not None:
            pulumi.set(__self__, "last_modified_by_type", last_modified_by_type)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The timestamp of resource creation (UTC).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[str]:
        """
        The identity that created the resource.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="createdByType")
    def created_by_type(self) -> Optional[str]:
        """
        The type of identity that created the resource.
        """
        return pulumi.get(self, "created_by_type")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> Optional[str]:
        """
        The timestamp of resource last modification (UTC)
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> Optional[str]:
        """
        The identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by")

    @property
    @pulumi.getter(name="lastModifiedByType")
    def last_modified_by_type(self) -> Optional[str]:
        """
        The type of identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by_type")


