# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'ArmRoleReceiverResponse',
    'AutomationRunbookReceiverResponse',
    'AzureAppPushReceiverResponse',
    'AzureFunctionReceiverResponse',
    'ColumnDefinitionResponse',
    'DataCollectionEndpointResourceResponseIdentity',
    'DataCollectionEndpointResourceResponseSystemData',
    'DataCollectionEndpointResponseConfigurationAccess',
    'DataCollectionEndpointResponseFailoverConfiguration',
    'DataCollectionEndpointResponseLogsIngestion',
    'DataCollectionEndpointResponseMetadata',
    'DataCollectionEndpointResponseMetricsIngestion',
    'DataCollectionEndpointResponseNetworkAcls',
    'DataCollectionRuleAssociationProxyOnlyResourceResponseSystemData',
    'DataCollectionRuleAssociationResponseMetadata',
    'DataCollectionRuleResourceResponseIdentity',
    'DataCollectionRuleResourceResponseSystemData',
    'DataCollectionRuleResponseDataSources',
    'DataCollectionRuleResponseDestinations',
    'DataCollectionRuleResponseMetadata',
    'DataFlowResponse',
    'DataImportSourcesResponseEventHub',
    'DataSourcesSpecResponseDataImports',
    'DestinationsSpecResponseAzureMonitorMetrics',
    'EmailReceiverResponse',
    'EventHubDestinationResponse',
    'EventHubDirectDestinationResponse',
    'EventHubReceiverResponse',
    'ExtensionDataSourceResponse',
    'IisLogsDataSourceResponse',
    'ItsmReceiverResponse',
    'LocationSpecResponse',
    'LogAnalyticsDestinationResponse',
    'LogFileSettingsResponseText',
    'LogFilesDataSourceResponse',
    'LogFilesDataSourceResponseSettings',
    'LogicAppReceiverResponse',
    'MonitoringAccountDestinationResponse',
    'PerfCounterDataSourceResponse',
    'PlatformTelemetryDataSourceResponse',
    'PrivateLinkScopedResourceResponse',
    'PrometheusForwarderDataSourceResponse',
    'SmsReceiverResponse',
    'StorageBlobDestinationResponse',
    'StorageTableDestinationResponse',
    'StreamDeclarationResponse',
    'SyslogDataSourceResponse',
    'UserAssignedIdentityResponse',
    'VoiceReceiverResponse',
    'WebhookReceiverResponse',
    'WindowsEventLogDataSourceResponse',
    'WindowsFirewallLogsDataSourceResponse',
]

@pulumi.output_type
class ArmRoleReceiverResponse(dict):
    """
    An arm role receiver.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "roleId":
            suggest = "role_id"
        elif key == "useCommonAlertSchema":
            suggest = "use_common_alert_schema"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ArmRoleReceiverResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ArmRoleReceiverResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ArmRoleReceiverResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 role_id: str,
                 use_common_alert_schema: Optional[bool] = None):
        """
        An arm role receiver.
        :param str name: The name of the arm role receiver. Names must be unique across all receivers within an action group.
        :param str role_id: The arm role id.
        :param bool use_common_alert_schema: Indicates whether to use common alert schema.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "role_id", role_id)
        if use_common_alert_schema is None:
            use_common_alert_schema = False
        if use_common_alert_schema is not None:
            pulumi.set(__self__, "use_common_alert_schema", use_common_alert_schema)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the arm role receiver. Names must be unique across all receivers within an action group.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="roleId")
    def role_id(self) -> str:
        """
        The arm role id.
        """
        return pulumi.get(self, "role_id")

    @property
    @pulumi.getter(name="useCommonAlertSchema")
    def use_common_alert_schema(self) -> Optional[bool]:
        """
        Indicates whether to use common alert schema.
        """
        return pulumi.get(self, "use_common_alert_schema")


@pulumi.output_type
class AutomationRunbookReceiverResponse(dict):
    """
    The Azure Automation Runbook notification receiver.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "automationAccountId":
            suggest = "automation_account_id"
        elif key == "isGlobalRunbook":
            suggest = "is_global_runbook"
        elif key == "runbookName":
            suggest = "runbook_name"
        elif key == "webhookResourceId":
            suggest = "webhook_resource_id"
        elif key == "serviceUri":
            suggest = "service_uri"
        elif key == "useCommonAlertSchema":
            suggest = "use_common_alert_schema"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutomationRunbookReceiverResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutomationRunbookReceiverResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutomationRunbookReceiverResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 automation_account_id: str,
                 is_global_runbook: bool,
                 runbook_name: str,
                 webhook_resource_id: str,
                 name: Optional[str] = None,
                 service_uri: Optional[str] = None,
                 use_common_alert_schema: Optional[bool] = None):
        """
        The Azure Automation Runbook notification receiver.
        :param str automation_account_id: The Azure automation account Id which holds this runbook and authenticate to Azure resource.
        :param bool is_global_runbook: Indicates whether this instance is global runbook.
        :param str runbook_name: The name for this runbook.
        :param str webhook_resource_id: The resource id for webhook linked to this runbook.
        :param str name: Indicates name of the webhook.
        :param str service_uri: The URI where webhooks should be sent.
        :param bool use_common_alert_schema: Indicates whether to use common alert schema.
        """
        pulumi.set(__self__, "automation_account_id", automation_account_id)
        pulumi.set(__self__, "is_global_runbook", is_global_runbook)
        pulumi.set(__self__, "runbook_name", runbook_name)
        pulumi.set(__self__, "webhook_resource_id", webhook_resource_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if service_uri is not None:
            pulumi.set(__self__, "service_uri", service_uri)
        if use_common_alert_schema is None:
            use_common_alert_schema = False
        if use_common_alert_schema is not None:
            pulumi.set(__self__, "use_common_alert_schema", use_common_alert_schema)

    @property
    @pulumi.getter(name="automationAccountId")
    def automation_account_id(self) -> str:
        """
        The Azure automation account Id which holds this runbook and authenticate to Azure resource.
        """
        return pulumi.get(self, "automation_account_id")

    @property
    @pulumi.getter(name="isGlobalRunbook")
    def is_global_runbook(self) -> bool:
        """
        Indicates whether this instance is global runbook.
        """
        return pulumi.get(self, "is_global_runbook")

    @property
    @pulumi.getter(name="runbookName")
    def runbook_name(self) -> str:
        """
        The name for this runbook.
        """
        return pulumi.get(self, "runbook_name")

    @property
    @pulumi.getter(name="webhookResourceId")
    def webhook_resource_id(self) -> str:
        """
        The resource id for webhook linked to this runbook.
        """
        return pulumi.get(self, "webhook_resource_id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Indicates name of the webhook.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="serviceUri")
    def service_uri(self) -> Optional[str]:
        """
        The URI where webhooks should be sent.
        """
        return pulumi.get(self, "service_uri")

    @property
    @pulumi.getter(name="useCommonAlertSchema")
    def use_common_alert_schema(self) -> Optional[bool]:
        """
        Indicates whether to use common alert schema.
        """
        return pulumi.get(self, "use_common_alert_schema")


@pulumi.output_type
class AzureAppPushReceiverResponse(dict):
    """
    The Azure mobile App push notification receiver.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "emailAddress":
            suggest = "email_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureAppPushReceiverResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureAppPushReceiverResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureAppPushReceiverResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 email_address: str,
                 name: str):
        """
        The Azure mobile App push notification receiver.
        :param str email_address: The email address registered for the Azure mobile app.
        :param str name: The name of the Azure mobile app push receiver. Names must be unique across all receivers within an action group.
        """
        pulumi.set(__self__, "email_address", email_address)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="emailAddress")
    def email_address(self) -> str:
        """
        The email address registered for the Azure mobile app.
        """
        return pulumi.get(self, "email_address")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the Azure mobile app push receiver. Names must be unique across all receivers within an action group.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class AzureFunctionReceiverResponse(dict):
    """
    An azure function receiver.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "functionAppResourceId":
            suggest = "function_app_resource_id"
        elif key == "functionName":
            suggest = "function_name"
        elif key == "httpTriggerUrl":
            suggest = "http_trigger_url"
        elif key == "useCommonAlertSchema":
            suggest = "use_common_alert_schema"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureFunctionReceiverResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureFunctionReceiverResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureFunctionReceiverResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 function_app_resource_id: str,
                 function_name: str,
                 http_trigger_url: str,
                 name: str,
                 use_common_alert_schema: Optional[bool] = None):
        """
        An azure function receiver.
        :param str function_app_resource_id: The azure resource id of the function app.
        :param str function_name: The function name in the function app.
        :param str http_trigger_url: The http trigger url where http request sent to.
        :param str name: The name of the azure function receiver. Names must be unique across all receivers within an action group.
        :param bool use_common_alert_schema: Indicates whether to use common alert schema.
        """
        pulumi.set(__self__, "function_app_resource_id", function_app_resource_id)
        pulumi.set(__self__, "function_name", function_name)
        pulumi.set(__self__, "http_trigger_url", http_trigger_url)
        pulumi.set(__self__, "name", name)
        if use_common_alert_schema is None:
            use_common_alert_schema = False
        if use_common_alert_schema is not None:
            pulumi.set(__self__, "use_common_alert_schema", use_common_alert_schema)

    @property
    @pulumi.getter(name="functionAppResourceId")
    def function_app_resource_id(self) -> str:
        """
        The azure resource id of the function app.
        """
        return pulumi.get(self, "function_app_resource_id")

    @property
    @pulumi.getter(name="functionName")
    def function_name(self) -> str:
        """
        The function name in the function app.
        """
        return pulumi.get(self, "function_name")

    @property
    @pulumi.getter(name="httpTriggerUrl")
    def http_trigger_url(self) -> str:
        """
        The http trigger url where http request sent to.
        """
        return pulumi.get(self, "http_trigger_url")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the azure function receiver. Names must be unique across all receivers within an action group.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="useCommonAlertSchema")
    def use_common_alert_schema(self) -> Optional[bool]:
        """
        Indicates whether to use common alert schema.
        """
        return pulumi.get(self, "use_common_alert_schema")


@pulumi.output_type
class ColumnDefinitionResponse(dict):
    """
    Definition of custom data column.
    """
    def __init__(__self__, *,
                 name: Optional[str] = None,
                 type: Optional[str] = None):
        """
        Definition of custom data column.
        :param str name: The name of the column.
        :param str type: The type of the column data.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the column.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of the column data.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class DataCollectionEndpointResourceResponseIdentity(dict):
    """
    Managed service identity of the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"
        elif key == "userAssignedIdentities":
            suggest = "user_assigned_identities"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataCollectionEndpointResourceResponseIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataCollectionEndpointResourceResponseIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataCollectionEndpointResourceResponseIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 principal_id: str,
                 tenant_id: str,
                 type: str,
                 user_assigned_identities: Optional[Mapping[str, 'outputs.UserAssignedIdentityResponse']] = None):
        """
        Managed service identity of the resource.
        :param str principal_id: The service principal ID of the system assigned identity. This property will only be provided for a system assigned identity.
        :param str tenant_id: The tenant ID of the system assigned identity. This property will only be provided for a system assigned identity.
        :param str type: Type of managed service identity (where both SystemAssigned and UserAssigned types are allowed).
        :param Mapping[str, 'UserAssignedIdentityResponse'] user_assigned_identities: The set of user assigned identities associated with the resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}. The dictionary values can be empty objects ({}) in requests.
        """
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        pulumi.set(__self__, "type", type)
        if user_assigned_identities is not None:
            pulumi.set(__self__, "user_assigned_identities", user_assigned_identities)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        The service principal ID of the system assigned identity. This property will only be provided for a system assigned identity.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        The tenant ID of the system assigned identity. This property will only be provided for a system assigned identity.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of managed service identity (where both SystemAssigned and UserAssigned types are allowed).
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="userAssignedIdentities")
    def user_assigned_identities(self) -> Optional[Mapping[str, 'outputs.UserAssignedIdentityResponse']]:
        """
        The set of user assigned identities associated with the resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}. The dictionary values can be empty objects ({}) in requests.
        """
        return pulumi.get(self, "user_assigned_identities")


@pulumi.output_type
class DataCollectionEndpointResourceResponseSystemData(dict):
    """
    Metadata pertaining to creation and last modification of the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "createdBy":
            suggest = "created_by"
        elif key == "createdByType":
            suggest = "created_by_type"
        elif key == "lastModifiedAt":
            suggest = "last_modified_at"
        elif key == "lastModifiedBy":
            suggest = "last_modified_by"
        elif key == "lastModifiedByType":
            suggest = "last_modified_by_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataCollectionEndpointResourceResponseSystemData. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataCollectionEndpointResourceResponseSystemData.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataCollectionEndpointResourceResponseSystemData.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: Optional[str] = None,
                 created_by: Optional[str] = None,
                 created_by_type: Optional[str] = None,
                 last_modified_at: Optional[str] = None,
                 last_modified_by: Optional[str] = None,
                 last_modified_by_type: Optional[str] = None):
        """
        Metadata pertaining to creation and last modification of the resource.
        :param str created_at: The timestamp of resource creation (UTC).
        :param str created_by: The identity that created the resource.
        :param str created_by_type: The type of identity that created the resource.
        :param str last_modified_at: The timestamp of resource last modification (UTC)
        :param str last_modified_by: The identity that last modified the resource.
        :param str last_modified_by_type: The type of identity that last modified the resource.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_by_type is not None:
            pulumi.set(__self__, "created_by_type", created_by_type)
        if last_modified_at is not None:
            pulumi.set(__self__, "last_modified_at", last_modified_at)
        if last_modified_by is not None:
            pulumi.set(__self__, "last_modified_by", last_modified_by)
        if last_modified_by_type is not None:
            pulumi.set(__self__, "last_modified_by_type", last_modified_by_type)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The timestamp of resource creation (UTC).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[str]:
        """
        The identity that created the resource.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="createdByType")
    def created_by_type(self) -> Optional[str]:
        """
        The type of identity that created the resource.
        """
        return pulumi.get(self, "created_by_type")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> Optional[str]:
        """
        The timestamp of resource last modification (UTC)
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> Optional[str]:
        """
        The identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by")

    @property
    @pulumi.getter(name="lastModifiedByType")
    def last_modified_by_type(self) -> Optional[str]:
        """
        The type of identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by_type")


@pulumi.output_type
class DataCollectionEndpointResponseConfigurationAccess(dict):
    """
    The endpoint used by clients to access their configuration.
    """
    def __init__(__self__, *,
                 endpoint: str):
        """
        The endpoint used by clients to access their configuration.
        :param str endpoint: The endpoint. This property is READ-ONLY.
        """
        pulumi.set(__self__, "endpoint", endpoint)

    @property
    @pulumi.getter
    def endpoint(self) -> str:
        """
        The endpoint. This property is READ-ONLY.
        """
        return pulumi.get(self, "endpoint")


@pulumi.output_type
class DataCollectionEndpointResponseFailoverConfiguration(dict):
    """
    Failover configuration on this endpoint. This property is READ-ONLY.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "activeLocation":
            suggest = "active_location"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataCollectionEndpointResponseFailoverConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataCollectionEndpointResponseFailoverConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataCollectionEndpointResponseFailoverConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 active_location: Optional[str] = None,
                 locations: Optional[Sequence['outputs.LocationSpecResponse']] = None):
        """
        Failover configuration on this endpoint. This property is READ-ONLY.
        :param str active_location: Active location where data flow will occur.
        :param Sequence['LocationSpecResponse'] locations: Locations that are configured for failover.
        """
        if active_location is not None:
            pulumi.set(__self__, "active_location", active_location)
        if locations is not None:
            pulumi.set(__self__, "locations", locations)

    @property
    @pulumi.getter(name="activeLocation")
    def active_location(self) -> Optional[str]:
        """
        Active location where data flow will occur.
        """
        return pulumi.get(self, "active_location")

    @property
    @pulumi.getter
    def locations(self) -> Optional[Sequence['outputs.LocationSpecResponse']]:
        """
        Locations that are configured for failover.
        """
        return pulumi.get(self, "locations")


@pulumi.output_type
class DataCollectionEndpointResponseLogsIngestion(dict):
    """
    The endpoint used by clients to ingest logs.
    """
    def __init__(__self__, *,
                 endpoint: str):
        """
        The endpoint used by clients to ingest logs.
        :param str endpoint: The endpoint. This property is READ-ONLY.
        """
        pulumi.set(__self__, "endpoint", endpoint)

    @property
    @pulumi.getter
    def endpoint(self) -> str:
        """
        The endpoint. This property is READ-ONLY.
        """
        return pulumi.get(self, "endpoint")


@pulumi.output_type
class DataCollectionEndpointResponseMetadata(dict):
    """
    Metadata for the resource. This property is READ-ONLY.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisionedBy":
            suggest = "provisioned_by"
        elif key == "provisionedByResourceId":
            suggest = "provisioned_by_resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataCollectionEndpointResponseMetadata. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataCollectionEndpointResponseMetadata.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataCollectionEndpointResponseMetadata.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 provisioned_by: str,
                 provisioned_by_resource_id: str):
        """
        Metadata for the resource. This property is READ-ONLY.
        :param str provisioned_by: Azure offering managing this resource on-behalf-of customer.
        :param str provisioned_by_resource_id: Resource Id of azure offering managing this resource on-behalf-of customer.
        """
        pulumi.set(__self__, "provisioned_by", provisioned_by)
        pulumi.set(__self__, "provisioned_by_resource_id", provisioned_by_resource_id)

    @property
    @pulumi.getter(name="provisionedBy")
    def provisioned_by(self) -> str:
        """
        Azure offering managing this resource on-behalf-of customer.
        """
        return pulumi.get(self, "provisioned_by")

    @property
    @pulumi.getter(name="provisionedByResourceId")
    def provisioned_by_resource_id(self) -> str:
        """
        Resource Id of azure offering managing this resource on-behalf-of customer.
        """
        return pulumi.get(self, "provisioned_by_resource_id")


@pulumi.output_type
class DataCollectionEndpointResponseMetricsIngestion(dict):
    """
    The endpoint used by clients to ingest metrics.
    """
    def __init__(__self__, *,
                 endpoint: str):
        """
        The endpoint used by clients to ingest metrics.
        :param str endpoint: The endpoint. This property is READ-ONLY.
        """
        pulumi.set(__self__, "endpoint", endpoint)

    @property
    @pulumi.getter
    def endpoint(self) -> str:
        """
        The endpoint. This property is READ-ONLY.
        """
        return pulumi.get(self, "endpoint")


@pulumi.output_type
class DataCollectionEndpointResponseNetworkAcls(dict):
    """
    Network access control rules for the endpoints.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "publicNetworkAccess":
            suggest = "public_network_access"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataCollectionEndpointResponseNetworkAcls. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataCollectionEndpointResponseNetworkAcls.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataCollectionEndpointResponseNetworkAcls.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 public_network_access: Optional[str] = None):
        """
        Network access control rules for the endpoints.
        :param str public_network_access: The configuration to set whether network access from public internet to the endpoints are allowed.
        """
        if public_network_access is not None:
            pulumi.set(__self__, "public_network_access", public_network_access)

    @property
    @pulumi.getter(name="publicNetworkAccess")
    def public_network_access(self) -> Optional[str]:
        """
        The configuration to set whether network access from public internet to the endpoints are allowed.
        """
        return pulumi.get(self, "public_network_access")


@pulumi.output_type
class DataCollectionRuleAssociationProxyOnlyResourceResponseSystemData(dict):
    """
    Metadata pertaining to creation and last modification of the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "createdBy":
            suggest = "created_by"
        elif key == "createdByType":
            suggest = "created_by_type"
        elif key == "lastModifiedAt":
            suggest = "last_modified_at"
        elif key == "lastModifiedBy":
            suggest = "last_modified_by"
        elif key == "lastModifiedByType":
            suggest = "last_modified_by_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataCollectionRuleAssociationProxyOnlyResourceResponseSystemData. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataCollectionRuleAssociationProxyOnlyResourceResponseSystemData.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataCollectionRuleAssociationProxyOnlyResourceResponseSystemData.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: Optional[str] = None,
                 created_by: Optional[str] = None,
                 created_by_type: Optional[str] = None,
                 last_modified_at: Optional[str] = None,
                 last_modified_by: Optional[str] = None,
                 last_modified_by_type: Optional[str] = None):
        """
        Metadata pertaining to creation and last modification of the resource.
        :param str created_at: The timestamp of resource creation (UTC).
        :param str created_by: The identity that created the resource.
        :param str created_by_type: The type of identity that created the resource.
        :param str last_modified_at: The timestamp of resource last modification (UTC)
        :param str last_modified_by: The identity that last modified the resource.
        :param str last_modified_by_type: The type of identity that last modified the resource.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_by_type is not None:
            pulumi.set(__self__, "created_by_type", created_by_type)
        if last_modified_at is not None:
            pulumi.set(__self__, "last_modified_at", last_modified_at)
        if last_modified_by is not None:
            pulumi.set(__self__, "last_modified_by", last_modified_by)
        if last_modified_by_type is not None:
            pulumi.set(__self__, "last_modified_by_type", last_modified_by_type)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The timestamp of resource creation (UTC).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[str]:
        """
        The identity that created the resource.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="createdByType")
    def created_by_type(self) -> Optional[str]:
        """
        The type of identity that created the resource.
        """
        return pulumi.get(self, "created_by_type")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> Optional[str]:
        """
        The timestamp of resource last modification (UTC)
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> Optional[str]:
        """
        The identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by")

    @property
    @pulumi.getter(name="lastModifiedByType")
    def last_modified_by_type(self) -> Optional[str]:
        """
        The type of identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by_type")


@pulumi.output_type
class DataCollectionRuleAssociationResponseMetadata(dict):
    """
    Metadata about the resource
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisionedBy":
            suggest = "provisioned_by"
        elif key == "provisionedByResourceId":
            suggest = "provisioned_by_resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataCollectionRuleAssociationResponseMetadata. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataCollectionRuleAssociationResponseMetadata.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataCollectionRuleAssociationResponseMetadata.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 provisioned_by: str,
                 provisioned_by_resource_id: str):
        """
        Metadata about the resource
        :param str provisioned_by: Azure offering managing this resource on-behalf-of customer.
        :param str provisioned_by_resource_id: Resource Id of azure offering managing this resource on-behalf-of customer.
        """
        pulumi.set(__self__, "provisioned_by", provisioned_by)
        pulumi.set(__self__, "provisioned_by_resource_id", provisioned_by_resource_id)

    @property
    @pulumi.getter(name="provisionedBy")
    def provisioned_by(self) -> str:
        """
        Azure offering managing this resource on-behalf-of customer.
        """
        return pulumi.get(self, "provisioned_by")

    @property
    @pulumi.getter(name="provisionedByResourceId")
    def provisioned_by_resource_id(self) -> str:
        """
        Resource Id of azure offering managing this resource on-behalf-of customer.
        """
        return pulumi.get(self, "provisioned_by_resource_id")


@pulumi.output_type
class DataCollectionRuleResourceResponseIdentity(dict):
    """
    Managed service identity of the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"
        elif key == "userAssignedIdentities":
            suggest = "user_assigned_identities"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataCollectionRuleResourceResponseIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataCollectionRuleResourceResponseIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataCollectionRuleResourceResponseIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 principal_id: str,
                 tenant_id: str,
                 type: str,
                 user_assigned_identities: Optional[Mapping[str, 'outputs.UserAssignedIdentityResponse']] = None):
        """
        Managed service identity of the resource.
        :param str principal_id: The service principal ID of the system assigned identity. This property will only be provided for a system assigned identity.
        :param str tenant_id: The tenant ID of the system assigned identity. This property will only be provided for a system assigned identity.
        :param str type: Type of managed service identity (where both SystemAssigned and UserAssigned types are allowed).
        :param Mapping[str, 'UserAssignedIdentityResponse'] user_assigned_identities: The set of user assigned identities associated with the resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}. The dictionary values can be empty objects ({}) in requests.
        """
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        pulumi.set(__self__, "type", type)
        if user_assigned_identities is not None:
            pulumi.set(__self__, "user_assigned_identities", user_assigned_identities)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        The service principal ID of the system assigned identity. This property will only be provided for a system assigned identity.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        The tenant ID of the system assigned identity. This property will only be provided for a system assigned identity.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of managed service identity (where both SystemAssigned and UserAssigned types are allowed).
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="userAssignedIdentities")
    def user_assigned_identities(self) -> Optional[Mapping[str, 'outputs.UserAssignedIdentityResponse']]:
        """
        The set of user assigned identities associated with the resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}. The dictionary values can be empty objects ({}) in requests.
        """
        return pulumi.get(self, "user_assigned_identities")


@pulumi.output_type
class DataCollectionRuleResourceResponseSystemData(dict):
    """
    Metadata pertaining to creation and last modification of the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "createdBy":
            suggest = "created_by"
        elif key == "createdByType":
            suggest = "created_by_type"
        elif key == "lastModifiedAt":
            suggest = "last_modified_at"
        elif key == "lastModifiedBy":
            suggest = "last_modified_by"
        elif key == "lastModifiedByType":
            suggest = "last_modified_by_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataCollectionRuleResourceResponseSystemData. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataCollectionRuleResourceResponseSystemData.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataCollectionRuleResourceResponseSystemData.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: Optional[str] = None,
                 created_by: Optional[str] = None,
                 created_by_type: Optional[str] = None,
                 last_modified_at: Optional[str] = None,
                 last_modified_by: Optional[str] = None,
                 last_modified_by_type: Optional[str] = None):
        """
        Metadata pertaining to creation and last modification of the resource.
        :param str created_at: The timestamp of resource creation (UTC).
        :param str created_by: The identity that created the resource.
        :param str created_by_type: The type of identity that created the resource.
        :param str last_modified_at: The timestamp of resource last modification (UTC)
        :param str last_modified_by: The identity that last modified the resource.
        :param str last_modified_by_type: The type of identity that last modified the resource.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_by_type is not None:
            pulumi.set(__self__, "created_by_type", created_by_type)
        if last_modified_at is not None:
            pulumi.set(__self__, "last_modified_at", last_modified_at)
        if last_modified_by is not None:
            pulumi.set(__self__, "last_modified_by", last_modified_by)
        if last_modified_by_type is not None:
            pulumi.set(__self__, "last_modified_by_type", last_modified_by_type)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The timestamp of resource creation (UTC).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[str]:
        """
        The identity that created the resource.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="createdByType")
    def created_by_type(self) -> Optional[str]:
        """
        The type of identity that created the resource.
        """
        return pulumi.get(self, "created_by_type")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> Optional[str]:
        """
        The timestamp of resource last modification (UTC)
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> Optional[str]:
        """
        The identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by")

    @property
    @pulumi.getter(name="lastModifiedByType")
    def last_modified_by_type(self) -> Optional[str]:
        """
        The type of identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by_type")


@pulumi.output_type
class DataCollectionRuleResponseDataSources(dict):
    """
    The specification of data sources. 
    This property is optional and can be omitted if the rule is meant to be used via direct calls to the provisioned endpoint.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataImports":
            suggest = "data_imports"
        elif key == "iisLogs":
            suggest = "iis_logs"
        elif key == "logFiles":
            suggest = "log_files"
        elif key == "performanceCounters":
            suggest = "performance_counters"
        elif key == "platformTelemetry":
            suggest = "platform_telemetry"
        elif key == "prometheusForwarder":
            suggest = "prometheus_forwarder"
        elif key == "windowsEventLogs":
            suggest = "windows_event_logs"
        elif key == "windowsFirewallLogs":
            suggest = "windows_firewall_logs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataCollectionRuleResponseDataSources. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataCollectionRuleResponseDataSources.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataCollectionRuleResponseDataSources.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_imports: Optional['outputs.DataSourcesSpecResponseDataImports'] = None,
                 extensions: Optional[Sequence['outputs.ExtensionDataSourceResponse']] = None,
                 iis_logs: Optional[Sequence['outputs.IisLogsDataSourceResponse']] = None,
                 log_files: Optional[Sequence['outputs.LogFilesDataSourceResponse']] = None,
                 performance_counters: Optional[Sequence['outputs.PerfCounterDataSourceResponse']] = None,
                 platform_telemetry: Optional[Sequence['outputs.PlatformTelemetryDataSourceResponse']] = None,
                 prometheus_forwarder: Optional[Sequence['outputs.PrometheusForwarderDataSourceResponse']] = None,
                 syslog: Optional[Sequence['outputs.SyslogDataSourceResponse']] = None,
                 windows_event_logs: Optional[Sequence['outputs.WindowsEventLogDataSourceResponse']] = None,
                 windows_firewall_logs: Optional[Sequence['outputs.WindowsFirewallLogsDataSourceResponse']] = None):
        """
        The specification of data sources. 
        This property is optional and can be omitted if the rule is meant to be used via direct calls to the provisioned endpoint.
        :param 'DataSourcesSpecResponseDataImports' data_imports: Specifications of pull based data sources
        :param Sequence['ExtensionDataSourceResponse'] extensions: The list of Azure VM extension data source configurations.
        :param Sequence['IisLogsDataSourceResponse'] iis_logs: The list of IIS logs source configurations.
        :param Sequence['LogFilesDataSourceResponse'] log_files: The list of Log files source configurations.
        :param Sequence['PerfCounterDataSourceResponse'] performance_counters: The list of performance counter data source configurations.
        :param Sequence['PlatformTelemetryDataSourceResponse'] platform_telemetry: The list of platform telemetry configurations
        :param Sequence['PrometheusForwarderDataSourceResponse'] prometheus_forwarder: The list of Prometheus forwarder data source configurations.
        :param Sequence['SyslogDataSourceResponse'] syslog: The list of Syslog data source configurations.
        :param Sequence['WindowsEventLogDataSourceResponse'] windows_event_logs: The list of Windows Event Log data source configurations.
        :param Sequence['WindowsFirewallLogsDataSourceResponse'] windows_firewall_logs: The list of Windows Firewall logs source configurations.
        """
        if data_imports is not None:
            pulumi.set(__self__, "data_imports", data_imports)
        if extensions is not None:
            pulumi.set(__self__, "extensions", extensions)
        if iis_logs is not None:
            pulumi.set(__self__, "iis_logs", iis_logs)
        if log_files is not None:
            pulumi.set(__self__, "log_files", log_files)
        if performance_counters is not None:
            pulumi.set(__self__, "performance_counters", performance_counters)
        if platform_telemetry is not None:
            pulumi.set(__self__, "platform_telemetry", platform_telemetry)
        if prometheus_forwarder is not None:
            pulumi.set(__self__, "prometheus_forwarder", prometheus_forwarder)
        if syslog is not None:
            pulumi.set(__self__, "syslog", syslog)
        if windows_event_logs is not None:
            pulumi.set(__self__, "windows_event_logs", windows_event_logs)
        if windows_firewall_logs is not None:
            pulumi.set(__self__, "windows_firewall_logs", windows_firewall_logs)

    @property
    @pulumi.getter(name="dataImports")
    def data_imports(self) -> Optional['outputs.DataSourcesSpecResponseDataImports']:
        """
        Specifications of pull based data sources
        """
        return pulumi.get(self, "data_imports")

    @property
    @pulumi.getter
    def extensions(self) -> Optional[Sequence['outputs.ExtensionDataSourceResponse']]:
        """
        The list of Azure VM extension data source configurations.
        """
        return pulumi.get(self, "extensions")

    @property
    @pulumi.getter(name="iisLogs")
    def iis_logs(self) -> Optional[Sequence['outputs.IisLogsDataSourceResponse']]:
        """
        The list of IIS logs source configurations.
        """
        return pulumi.get(self, "iis_logs")

    @property
    @pulumi.getter(name="logFiles")
    def log_files(self) -> Optional[Sequence['outputs.LogFilesDataSourceResponse']]:
        """
        The list of Log files source configurations.
        """
        return pulumi.get(self, "log_files")

    @property
    @pulumi.getter(name="performanceCounters")
    def performance_counters(self) -> Optional[Sequence['outputs.PerfCounterDataSourceResponse']]:
        """
        The list of performance counter data source configurations.
        """
        return pulumi.get(self, "performance_counters")

    @property
    @pulumi.getter(name="platformTelemetry")
    def platform_telemetry(self) -> Optional[Sequence['outputs.PlatformTelemetryDataSourceResponse']]:
        """
        The list of platform telemetry configurations
        """
        return pulumi.get(self, "platform_telemetry")

    @property
    @pulumi.getter(name="prometheusForwarder")
    def prometheus_forwarder(self) -> Optional[Sequence['outputs.PrometheusForwarderDataSourceResponse']]:
        """
        The list of Prometheus forwarder data source configurations.
        """
        return pulumi.get(self, "prometheus_forwarder")

    @property
    @pulumi.getter
    def syslog(self) -> Optional[Sequence['outputs.SyslogDataSourceResponse']]:
        """
        The list of Syslog data source configurations.
        """
        return pulumi.get(self, "syslog")

    @property
    @pulumi.getter(name="windowsEventLogs")
    def windows_event_logs(self) -> Optional[Sequence['outputs.WindowsEventLogDataSourceResponse']]:
        """
        The list of Windows Event Log data source configurations.
        """
        return pulumi.get(self, "windows_event_logs")

    @property
    @pulumi.getter(name="windowsFirewallLogs")
    def windows_firewall_logs(self) -> Optional[Sequence['outputs.WindowsFirewallLogsDataSourceResponse']]:
        """
        The list of Windows Firewall logs source configurations.
        """
        return pulumi.get(self, "windows_firewall_logs")


@pulumi.output_type
class DataCollectionRuleResponseDestinations(dict):
    """
    The specification of destinations.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "azureMonitorMetrics":
            suggest = "azure_monitor_metrics"
        elif key == "eventHubs":
            suggest = "event_hubs"
        elif key == "eventHubsDirect":
            suggest = "event_hubs_direct"
        elif key == "logAnalytics":
            suggest = "log_analytics"
        elif key == "monitoringAccounts":
            suggest = "monitoring_accounts"
        elif key == "storageAccounts":
            suggest = "storage_accounts"
        elif key == "storageBlobsDirect":
            suggest = "storage_blobs_direct"
        elif key == "storageTablesDirect":
            suggest = "storage_tables_direct"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataCollectionRuleResponseDestinations. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataCollectionRuleResponseDestinations.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataCollectionRuleResponseDestinations.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 azure_monitor_metrics: Optional['outputs.DestinationsSpecResponseAzureMonitorMetrics'] = None,
                 event_hubs: Optional[Sequence['outputs.EventHubDestinationResponse']] = None,
                 event_hubs_direct: Optional[Sequence['outputs.EventHubDirectDestinationResponse']] = None,
                 log_analytics: Optional[Sequence['outputs.LogAnalyticsDestinationResponse']] = None,
                 monitoring_accounts: Optional[Sequence['outputs.MonitoringAccountDestinationResponse']] = None,
                 storage_accounts: Optional[Sequence['outputs.StorageBlobDestinationResponse']] = None,
                 storage_blobs_direct: Optional[Sequence['outputs.StorageBlobDestinationResponse']] = None,
                 storage_tables_direct: Optional[Sequence['outputs.StorageTableDestinationResponse']] = None):
        """
        The specification of destinations.
        :param 'DestinationsSpecResponseAzureMonitorMetrics' azure_monitor_metrics: Azure Monitor Metrics destination.
        :param Sequence['EventHubDestinationResponse'] event_hubs: List of Event Hubs destinations.
        :param Sequence['EventHubDirectDestinationResponse'] event_hubs_direct: List of Event Hubs Direct destinations.
        :param Sequence['LogAnalyticsDestinationResponse'] log_analytics: List of Log Analytics destinations.
        :param Sequence['MonitoringAccountDestinationResponse'] monitoring_accounts: List of monitoring account destinations.
        :param Sequence['StorageBlobDestinationResponse'] storage_accounts: List of storage accounts destinations.
        :param Sequence['StorageBlobDestinationResponse'] storage_blobs_direct: List of Storage Blob Direct destinations. To be used only for sending data directly to store from the agent.
        :param Sequence['StorageTableDestinationResponse'] storage_tables_direct: List of Storage Table Direct destinations.
        """
        if azure_monitor_metrics is not None:
            pulumi.set(__self__, "azure_monitor_metrics", azure_monitor_metrics)
        if event_hubs is not None:
            pulumi.set(__self__, "event_hubs", event_hubs)
        if event_hubs_direct is not None:
            pulumi.set(__self__, "event_hubs_direct", event_hubs_direct)
        if log_analytics is not None:
            pulumi.set(__self__, "log_analytics", log_analytics)
        if monitoring_accounts is not None:
            pulumi.set(__self__, "monitoring_accounts", monitoring_accounts)
        if storage_accounts is not None:
            pulumi.set(__self__, "storage_accounts", storage_accounts)
        if storage_blobs_direct is not None:
            pulumi.set(__self__, "storage_blobs_direct", storage_blobs_direct)
        if storage_tables_direct is not None:
            pulumi.set(__self__, "storage_tables_direct", storage_tables_direct)

    @property
    @pulumi.getter(name="azureMonitorMetrics")
    def azure_monitor_metrics(self) -> Optional['outputs.DestinationsSpecResponseAzureMonitorMetrics']:
        """
        Azure Monitor Metrics destination.
        """
        return pulumi.get(self, "azure_monitor_metrics")

    @property
    @pulumi.getter(name="eventHubs")
    def event_hubs(self) -> Optional[Sequence['outputs.EventHubDestinationResponse']]:
        """
        List of Event Hubs destinations.
        """
        return pulumi.get(self, "event_hubs")

    @property
    @pulumi.getter(name="eventHubsDirect")
    def event_hubs_direct(self) -> Optional[Sequence['outputs.EventHubDirectDestinationResponse']]:
        """
        List of Event Hubs Direct destinations.
        """
        return pulumi.get(self, "event_hubs_direct")

    @property
    @pulumi.getter(name="logAnalytics")
    def log_analytics(self) -> Optional[Sequence['outputs.LogAnalyticsDestinationResponse']]:
        """
        List of Log Analytics destinations.
        """
        return pulumi.get(self, "log_analytics")

    @property
    @pulumi.getter(name="monitoringAccounts")
    def monitoring_accounts(self) -> Optional[Sequence['outputs.MonitoringAccountDestinationResponse']]:
        """
        List of monitoring account destinations.
        """
        return pulumi.get(self, "monitoring_accounts")

    @property
    @pulumi.getter(name="storageAccounts")
    def storage_accounts(self) -> Optional[Sequence['outputs.StorageBlobDestinationResponse']]:
        """
        List of storage accounts destinations.
        """
        return pulumi.get(self, "storage_accounts")

    @property
    @pulumi.getter(name="storageBlobsDirect")
    def storage_blobs_direct(self) -> Optional[Sequence['outputs.StorageBlobDestinationResponse']]:
        """
        List of Storage Blob Direct destinations. To be used only for sending data directly to store from the agent.
        """
        return pulumi.get(self, "storage_blobs_direct")

    @property
    @pulumi.getter(name="storageTablesDirect")
    def storage_tables_direct(self) -> Optional[Sequence['outputs.StorageTableDestinationResponse']]:
        """
        List of Storage Table Direct destinations.
        """
        return pulumi.get(self, "storage_tables_direct")


@pulumi.output_type
class DataCollectionRuleResponseMetadata(dict):
    """
    Metadata about the resource
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisionedBy":
            suggest = "provisioned_by"
        elif key == "provisionedByResourceId":
            suggest = "provisioned_by_resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataCollectionRuleResponseMetadata. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataCollectionRuleResponseMetadata.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataCollectionRuleResponseMetadata.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 provisioned_by: str,
                 provisioned_by_resource_id: str):
        """
        Metadata about the resource
        :param str provisioned_by: Azure offering managing this resource on-behalf-of customer.
        :param str provisioned_by_resource_id: Resource Id of azure offering managing this resource on-behalf-of customer.
        """
        pulumi.set(__self__, "provisioned_by", provisioned_by)
        pulumi.set(__self__, "provisioned_by_resource_id", provisioned_by_resource_id)

    @property
    @pulumi.getter(name="provisionedBy")
    def provisioned_by(self) -> str:
        """
        Azure offering managing this resource on-behalf-of customer.
        """
        return pulumi.get(self, "provisioned_by")

    @property
    @pulumi.getter(name="provisionedByResourceId")
    def provisioned_by_resource_id(self) -> str:
        """
        Resource Id of azure offering managing this resource on-behalf-of customer.
        """
        return pulumi.get(self, "provisioned_by_resource_id")


@pulumi.output_type
class DataFlowResponse(dict):
    """
    Definition of which streams are sent to which destinations.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "builtInTransform":
            suggest = "built_in_transform"
        elif key == "outputStream":
            suggest = "output_stream"
        elif key == "transformKql":
            suggest = "transform_kql"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataFlowResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataFlowResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataFlowResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 built_in_transform: Optional[str] = None,
                 destinations: Optional[Sequence[str]] = None,
                 output_stream: Optional[str] = None,
                 streams: Optional[Sequence[str]] = None,
                 transform_kql: Optional[str] = None):
        """
        Definition of which streams are sent to which destinations.
        :param str built_in_transform: The builtIn transform to transform stream data
        :param Sequence[str] destinations: List of destinations for this data flow.
        :param str output_stream: The output stream of the transform. Only required if the transform changes data to a different stream.
        :param Sequence[str] streams: List of streams for this data flow.
        :param str transform_kql: The KQL query to transform stream data.
        """
        if built_in_transform is not None:
            pulumi.set(__self__, "built_in_transform", built_in_transform)
        if destinations is not None:
            pulumi.set(__self__, "destinations", destinations)
        if output_stream is not None:
            pulumi.set(__self__, "output_stream", output_stream)
        if streams is not None:
            pulumi.set(__self__, "streams", streams)
        if transform_kql is not None:
            pulumi.set(__self__, "transform_kql", transform_kql)

    @property
    @pulumi.getter(name="builtInTransform")
    def built_in_transform(self) -> Optional[str]:
        """
        The builtIn transform to transform stream data
        """
        return pulumi.get(self, "built_in_transform")

    @property
    @pulumi.getter
    def destinations(self) -> Optional[Sequence[str]]:
        """
        List of destinations for this data flow.
        """
        return pulumi.get(self, "destinations")

    @property
    @pulumi.getter(name="outputStream")
    def output_stream(self) -> Optional[str]:
        """
        The output stream of the transform. Only required if the transform changes data to a different stream.
        """
        return pulumi.get(self, "output_stream")

    @property
    @pulumi.getter
    def streams(self) -> Optional[Sequence[str]]:
        """
        List of streams for this data flow.
        """
        return pulumi.get(self, "streams")

    @property
    @pulumi.getter(name="transformKql")
    def transform_kql(self) -> Optional[str]:
        """
        The KQL query to transform stream data.
        """
        return pulumi.get(self, "transform_kql")


@pulumi.output_type
class DataImportSourcesResponseEventHub(dict):
    """
    Definition of Event Hub configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "consumerGroup":
            suggest = "consumer_group"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataImportSourcesResponseEventHub. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataImportSourcesResponseEventHub.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataImportSourcesResponseEventHub.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 consumer_group: Optional[str] = None,
                 name: Optional[str] = None,
                 stream: Optional[str] = None):
        """
        Definition of Event Hub configuration.
        :param str consumer_group: Event Hub consumer group name
        :param str name: A friendly name for the data source. 
               This name should be unique across all data sources (regardless of type) within the data collection rule.
        :param str stream: The stream to collect from EventHub
        """
        if consumer_group is not None:
            pulumi.set(__self__, "consumer_group", consumer_group)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if stream is not None:
            pulumi.set(__self__, "stream", stream)

    @property
    @pulumi.getter(name="consumerGroup")
    def consumer_group(self) -> Optional[str]:
        """
        Event Hub consumer group name
        """
        return pulumi.get(self, "consumer_group")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        A friendly name for the data source. 
        This name should be unique across all data sources (regardless of type) within the data collection rule.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def stream(self) -> Optional[str]:
        """
        The stream to collect from EventHub
        """
        return pulumi.get(self, "stream")


@pulumi.output_type
class DataSourcesSpecResponseDataImports(dict):
    """
    Specifications of pull based data sources
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "eventHub":
            suggest = "event_hub"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourcesSpecResponseDataImports. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourcesSpecResponseDataImports.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourcesSpecResponseDataImports.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 event_hub: Optional['outputs.DataImportSourcesResponseEventHub'] = None):
        """
        Specifications of pull based data sources
        :param 'DataImportSourcesResponseEventHub' event_hub: Definition of Event Hub configuration.
        """
        if event_hub is not None:
            pulumi.set(__self__, "event_hub", event_hub)

    @property
    @pulumi.getter(name="eventHub")
    def event_hub(self) -> Optional['outputs.DataImportSourcesResponseEventHub']:
        """
        Definition of Event Hub configuration.
        """
        return pulumi.get(self, "event_hub")


@pulumi.output_type
class DestinationsSpecResponseAzureMonitorMetrics(dict):
    """
    Azure Monitor Metrics destination.
    """
    def __init__(__self__, *,
                 name: Optional[str] = None):
        """
        Azure Monitor Metrics destination.
        :param str name: A friendly name for the destination. 
               This name should be unique across all destinations (regardless of type) within the data collection rule.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        A friendly name for the destination. 
        This name should be unique across all destinations (regardless of type) within the data collection rule.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class EmailReceiverResponse(dict):
    """
    An email receiver.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "emailAddress":
            suggest = "email_address"
        elif key == "useCommonAlertSchema":
            suggest = "use_common_alert_schema"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EmailReceiverResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EmailReceiverResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EmailReceiverResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 email_address: str,
                 name: str,
                 status: str,
                 use_common_alert_schema: Optional[bool] = None):
        """
        An email receiver.
        :param str email_address: The email address of this receiver.
        :param str name: The name of the email receiver. Names must be unique across all receivers within an action group.
        :param str status: The receiver status of the e-mail.
        :param bool use_common_alert_schema: Indicates whether to use common alert schema.
        """
        pulumi.set(__self__, "email_address", email_address)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "status", status)
        if use_common_alert_schema is None:
            use_common_alert_schema = False
        if use_common_alert_schema is not None:
            pulumi.set(__self__, "use_common_alert_schema", use_common_alert_schema)

    @property
    @pulumi.getter(name="emailAddress")
    def email_address(self) -> str:
        """
        The email address of this receiver.
        """
        return pulumi.get(self, "email_address")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the email receiver. Names must be unique across all receivers within an action group.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The receiver status of the e-mail.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="useCommonAlertSchema")
    def use_common_alert_schema(self) -> Optional[bool]:
        """
        Indicates whether to use common alert schema.
        """
        return pulumi.get(self, "use_common_alert_schema")


@pulumi.output_type
class EventHubDestinationResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "eventHubResourceId":
            suggest = "event_hub_resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventHubDestinationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventHubDestinationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventHubDestinationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 event_hub_resource_id: Optional[str] = None,
                 name: Optional[str] = None):
        """
        :param str event_hub_resource_id: The resource ID of the event hub.
        :param str name: A friendly name for the destination. 
               This name should be unique across all destinations (regardless of type) within the data collection rule.
        """
        if event_hub_resource_id is not None:
            pulumi.set(__self__, "event_hub_resource_id", event_hub_resource_id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="eventHubResourceId")
    def event_hub_resource_id(self) -> Optional[str]:
        """
        The resource ID of the event hub.
        """
        return pulumi.get(self, "event_hub_resource_id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        A friendly name for the destination. 
        This name should be unique across all destinations (regardless of type) within the data collection rule.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class EventHubDirectDestinationResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "eventHubResourceId":
            suggest = "event_hub_resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventHubDirectDestinationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventHubDirectDestinationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventHubDirectDestinationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 event_hub_resource_id: Optional[str] = None,
                 name: Optional[str] = None):
        """
        :param str event_hub_resource_id: The resource ID of the event hub.
        :param str name: A friendly name for the destination. 
               This name should be unique across all destinations (regardless of type) within the data collection rule.
        """
        if event_hub_resource_id is not None:
            pulumi.set(__self__, "event_hub_resource_id", event_hub_resource_id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="eventHubResourceId")
    def event_hub_resource_id(self) -> Optional[str]:
        """
        The resource ID of the event hub.
        """
        return pulumi.get(self, "event_hub_resource_id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        A friendly name for the destination. 
        This name should be unique across all destinations (regardless of type) within the data collection rule.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class EventHubReceiverResponse(dict):
    """
    An Event hub receiver.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "eventHubName":
            suggest = "event_hub_name"
        elif key == "eventHubNameSpace":
            suggest = "event_hub_name_space"
        elif key == "subscriptionId":
            suggest = "subscription_id"
        elif key == "tenantId":
            suggest = "tenant_id"
        elif key == "useCommonAlertSchema":
            suggest = "use_common_alert_schema"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventHubReceiverResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventHubReceiverResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventHubReceiverResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 event_hub_name: str,
                 event_hub_name_space: str,
                 name: str,
                 subscription_id: str,
                 tenant_id: Optional[str] = None,
                 use_common_alert_schema: Optional[bool] = None):
        """
        An Event hub receiver.
        :param str event_hub_name: The name of the specific Event Hub queue
        :param str event_hub_name_space: The Event Hub namespace
        :param str name: The name of the Event hub receiver. Names must be unique across all receivers within an action group.
        :param str subscription_id: The Id for the subscription containing this event hub
        :param str tenant_id: The tenant Id for the subscription containing this event hub
        :param bool use_common_alert_schema: Indicates whether to use common alert schema.
        """
        pulumi.set(__self__, "event_hub_name", event_hub_name)
        pulumi.set(__self__, "event_hub_name_space", event_hub_name_space)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "subscription_id", subscription_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if use_common_alert_schema is None:
            use_common_alert_schema = False
        if use_common_alert_schema is not None:
            pulumi.set(__self__, "use_common_alert_schema", use_common_alert_schema)

    @property
    @pulumi.getter(name="eventHubName")
    def event_hub_name(self) -> str:
        """
        The name of the specific Event Hub queue
        """
        return pulumi.get(self, "event_hub_name")

    @property
    @pulumi.getter(name="eventHubNameSpace")
    def event_hub_name_space(self) -> str:
        """
        The Event Hub namespace
        """
        return pulumi.get(self, "event_hub_name_space")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the Event hub receiver. Names must be unique across all receivers within an action group.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> str:
        """
        The Id for the subscription containing this event hub
        """
        return pulumi.get(self, "subscription_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[str]:
        """
        The tenant Id for the subscription containing this event hub
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter(name="useCommonAlertSchema")
    def use_common_alert_schema(self) -> Optional[bool]:
        """
        Indicates whether to use common alert schema.
        """
        return pulumi.get(self, "use_common_alert_schema")


@pulumi.output_type
class ExtensionDataSourceResponse(dict):
    """
    Definition of which data will be collected from a separate VM extension that integrates with the Azure Monitor Agent.
    Collected from either Windows and Linux machines, depending on which extension is defined.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "extensionName":
            suggest = "extension_name"
        elif key == "extensionSettings":
            suggest = "extension_settings"
        elif key == "inputDataSources":
            suggest = "input_data_sources"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExtensionDataSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExtensionDataSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExtensionDataSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 extension_name: str,
                 extension_settings: Optional[Any] = None,
                 input_data_sources: Optional[Sequence[str]] = None,
                 name: Optional[str] = None,
                 streams: Optional[Sequence[str]] = None):
        """
        Definition of which data will be collected from a separate VM extension that integrates with the Azure Monitor Agent.
        Collected from either Windows and Linux machines, depending on which extension is defined.
        :param str extension_name: The name of the VM extension.
        :param Any extension_settings: The extension settings. The format is specific for particular extension.
        :param Sequence[str] input_data_sources: The list of data sources this extension needs data from.
        :param str name: A friendly name for the data source. 
               This name should be unique across all data sources (regardless of type) within the data collection rule.
        :param Sequence[str] streams: List of streams that this data source will be sent to.
               A stream indicates what schema will be used for this data and usually what table in Log Analytics the data will be sent to.
        """
        pulumi.set(__self__, "extension_name", extension_name)
        if extension_settings is not None:
            pulumi.set(__self__, "extension_settings", extension_settings)
        if input_data_sources is not None:
            pulumi.set(__self__, "input_data_sources", input_data_sources)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if streams is not None:
            pulumi.set(__self__, "streams", streams)

    @property
    @pulumi.getter(name="extensionName")
    def extension_name(self) -> str:
        """
        The name of the VM extension.
        """
        return pulumi.get(self, "extension_name")

    @property
    @pulumi.getter(name="extensionSettings")
    def extension_settings(self) -> Optional[Any]:
        """
        The extension settings. The format is specific for particular extension.
        """
        return pulumi.get(self, "extension_settings")

    @property
    @pulumi.getter(name="inputDataSources")
    def input_data_sources(self) -> Optional[Sequence[str]]:
        """
        The list of data sources this extension needs data from.
        """
        return pulumi.get(self, "input_data_sources")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        A friendly name for the data source. 
        This name should be unique across all data sources (regardless of type) within the data collection rule.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def streams(self) -> Optional[Sequence[str]]:
        """
        List of streams that this data source will be sent to.
        A stream indicates what schema will be used for this data and usually what table in Log Analytics the data will be sent to.
        """
        return pulumi.get(self, "streams")


@pulumi.output_type
class IisLogsDataSourceResponse(dict):
    """
    Enables IIS logs to be collected by this data collection rule.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logDirectories":
            suggest = "log_directories"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IisLogsDataSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IisLogsDataSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IisLogsDataSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 streams: Sequence[str],
                 log_directories: Optional[Sequence[str]] = None,
                 name: Optional[str] = None):
        """
        Enables IIS logs to be collected by this data collection rule.
        :param Sequence[str] streams: IIS streams
        :param Sequence[str] log_directories: Absolute paths file location
        :param str name: A friendly name for the data source. 
               This name should be unique across all data sources (regardless of type) within the data collection rule.
        """
        pulumi.set(__self__, "streams", streams)
        if log_directories is not None:
            pulumi.set(__self__, "log_directories", log_directories)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def streams(self) -> Sequence[str]:
        """
        IIS streams
        """
        return pulumi.get(self, "streams")

    @property
    @pulumi.getter(name="logDirectories")
    def log_directories(self) -> Optional[Sequence[str]]:
        """
        Absolute paths file location
        """
        return pulumi.get(self, "log_directories")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        A friendly name for the data source. 
        This name should be unique across all data sources (regardless of type) within the data collection rule.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class ItsmReceiverResponse(dict):
    """
    An Itsm receiver.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectionId":
            suggest = "connection_id"
        elif key == "ticketConfiguration":
            suggest = "ticket_configuration"
        elif key == "workspaceId":
            suggest = "workspace_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ItsmReceiverResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ItsmReceiverResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ItsmReceiverResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connection_id: str,
                 name: str,
                 region: str,
                 ticket_configuration: str,
                 workspace_id: str):
        """
        An Itsm receiver.
        :param str connection_id: Unique identification of ITSM connection among multiple defined in above workspace.
        :param str name: The name of the Itsm receiver. Names must be unique across all receivers within an action group.
        :param str region: Region in which workspace resides. Supported values:'centralindia','japaneast','southeastasia','australiasoutheast','uksouth','westcentralus','canadacentral','eastus','westeurope'
        :param str ticket_configuration: JSON blob for the configurations of the ITSM action. CreateMultipleWorkItems option will be part of this blob as well.
        :param str workspace_id: OMS LA instance identifier.
        """
        pulumi.set(__self__, "connection_id", connection_id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "ticket_configuration", ticket_configuration)
        pulumi.set(__self__, "workspace_id", workspace_id)

    @property
    @pulumi.getter(name="connectionId")
    def connection_id(self) -> str:
        """
        Unique identification of ITSM connection among multiple defined in above workspace.
        """
        return pulumi.get(self, "connection_id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the Itsm receiver. Names must be unique across all receivers within an action group.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        Region in which workspace resides. Supported values:'centralindia','japaneast','southeastasia','australiasoutheast','uksouth','westcentralus','canadacentral','eastus','westeurope'
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="ticketConfiguration")
    def ticket_configuration(self) -> str:
        """
        JSON blob for the configurations of the ITSM action. CreateMultipleWorkItems option will be part of this blob as well.
        """
        return pulumi.get(self, "ticket_configuration")

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> str:
        """
        OMS LA instance identifier.
        """
        return pulumi.get(self, "workspace_id")


@pulumi.output_type
class LocationSpecResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningStatus":
            suggest = "provisioning_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LocationSpecResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LocationSpecResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LocationSpecResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 location: Optional[str] = None,
                 provisioning_status: Optional[str] = None):
        """
        :param str location: Name of location.
        :param str provisioning_status: The resource provisioning state in this location.
        """
        if location is not None:
            pulumi.set(__self__, "location", location)
        if provisioning_status is not None:
            pulumi.set(__self__, "provisioning_status", provisioning_status)

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        Name of location.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="provisioningStatus")
    def provisioning_status(self) -> Optional[str]:
        """
        The resource provisioning state in this location.
        """
        return pulumi.get(self, "provisioning_status")


@pulumi.output_type
class LogAnalyticsDestinationResponse(dict):
    """
    Log Analytics destination.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "workspaceId":
            suggest = "workspace_id"
        elif key == "workspaceResourceId":
            suggest = "workspace_resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LogAnalyticsDestinationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LogAnalyticsDestinationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LogAnalyticsDestinationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 workspace_id: str,
                 name: Optional[str] = None,
                 workspace_resource_id: Optional[str] = None):
        """
        Log Analytics destination.
        :param str workspace_id: The Customer ID of the Log Analytics workspace.
        :param str name: A friendly name for the destination. 
               This name should be unique across all destinations (regardless of type) within the data collection rule.
        :param str workspace_resource_id: The resource ID of the Log Analytics workspace.
        """
        pulumi.set(__self__, "workspace_id", workspace_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if workspace_resource_id is not None:
            pulumi.set(__self__, "workspace_resource_id", workspace_resource_id)

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> str:
        """
        The Customer ID of the Log Analytics workspace.
        """
        return pulumi.get(self, "workspace_id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        A friendly name for the destination. 
        This name should be unique across all destinations (regardless of type) within the data collection rule.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="workspaceResourceId")
    def workspace_resource_id(self) -> Optional[str]:
        """
        The resource ID of the Log Analytics workspace.
        """
        return pulumi.get(self, "workspace_resource_id")


@pulumi.output_type
class LogFileSettingsResponseText(dict):
    """
    Text settings
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "recordStartTimestampFormat":
            suggest = "record_start_timestamp_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LogFileSettingsResponseText. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LogFileSettingsResponseText.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LogFileSettingsResponseText.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 record_start_timestamp_format: str):
        """
        Text settings
        :param str record_start_timestamp_format: One of the supported timestamp formats
        """
        pulumi.set(__self__, "record_start_timestamp_format", record_start_timestamp_format)

    @property
    @pulumi.getter(name="recordStartTimestampFormat")
    def record_start_timestamp_format(self) -> str:
        """
        One of the supported timestamp formats
        """
        return pulumi.get(self, "record_start_timestamp_format")


@pulumi.output_type
class LogFilesDataSourceResponse(dict):
    """
    Definition of which custom log files will be collected by this data collection rule
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "filePatterns":
            suggest = "file_patterns"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LogFilesDataSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LogFilesDataSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LogFilesDataSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 file_patterns: Sequence[str],
                 format: str,
                 streams: Sequence[str],
                 name: Optional[str] = None,
                 settings: Optional['outputs.LogFilesDataSourceResponseSettings'] = None):
        """
        Definition of which custom log files will be collected by this data collection rule
        :param Sequence[str] file_patterns: File Patterns where the log files are located
        :param str format: The data format of the log files
        :param Sequence[str] streams: List of streams that this data source will be sent to.
               A stream indicates what schema will be used for this data source
        :param str name: A friendly name for the data source. 
               This name should be unique across all data sources (regardless of type) within the data collection rule.
        :param 'LogFilesDataSourceResponseSettings' settings: The log files specific settings.
        """
        pulumi.set(__self__, "file_patterns", file_patterns)
        pulumi.set(__self__, "format", format)
        pulumi.set(__self__, "streams", streams)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)

    @property
    @pulumi.getter(name="filePatterns")
    def file_patterns(self) -> Sequence[str]:
        """
        File Patterns where the log files are located
        """
        return pulumi.get(self, "file_patterns")

    @property
    @pulumi.getter
    def format(self) -> str:
        """
        The data format of the log files
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter
    def streams(self) -> Sequence[str]:
        """
        List of streams that this data source will be sent to.
        A stream indicates what schema will be used for this data source
        """
        return pulumi.get(self, "streams")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        A friendly name for the data source. 
        This name should be unique across all data sources (regardless of type) within the data collection rule.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def settings(self) -> Optional['outputs.LogFilesDataSourceResponseSettings']:
        """
        The log files specific settings.
        """
        return pulumi.get(self, "settings")


@pulumi.output_type
class LogFilesDataSourceResponseSettings(dict):
    """
    The log files specific settings.
    """
    def __init__(__self__, *,
                 text: Optional['outputs.LogFileSettingsResponseText'] = None):
        """
        The log files specific settings.
        :param 'LogFileSettingsResponseText' text: Text settings
        """
        if text is not None:
            pulumi.set(__self__, "text", text)

    @property
    @pulumi.getter
    def text(self) -> Optional['outputs.LogFileSettingsResponseText']:
        """
        Text settings
        """
        return pulumi.get(self, "text")


@pulumi.output_type
class LogicAppReceiverResponse(dict):
    """
    A logic app receiver.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "callbackUrl":
            suggest = "callback_url"
        elif key == "resourceId":
            suggest = "resource_id"
        elif key == "useCommonAlertSchema":
            suggest = "use_common_alert_schema"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LogicAppReceiverResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LogicAppReceiverResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LogicAppReceiverResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 callback_url: str,
                 name: str,
                 resource_id: str,
                 use_common_alert_schema: Optional[bool] = None):
        """
        A logic app receiver.
        :param str callback_url: The callback url where http request sent to.
        :param str name: The name of the logic app receiver. Names must be unique across all receivers within an action group.
        :param str resource_id: The azure resource id of the logic app receiver.
        :param bool use_common_alert_schema: Indicates whether to use common alert schema.
        """
        pulumi.set(__self__, "callback_url", callback_url)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "resource_id", resource_id)
        if use_common_alert_schema is None:
            use_common_alert_schema = False
        if use_common_alert_schema is not None:
            pulumi.set(__self__, "use_common_alert_schema", use_common_alert_schema)

    @property
    @pulumi.getter(name="callbackUrl")
    def callback_url(self) -> str:
        """
        The callback url where http request sent to.
        """
        return pulumi.get(self, "callback_url")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the logic app receiver. Names must be unique across all receivers within an action group.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> str:
        """
        The azure resource id of the logic app receiver.
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter(name="useCommonAlertSchema")
    def use_common_alert_schema(self) -> Optional[bool]:
        """
        Indicates whether to use common alert schema.
        """
        return pulumi.get(self, "use_common_alert_schema")


@pulumi.output_type
class MonitoringAccountDestinationResponse(dict):
    """
    Monitoring account destination.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accountId":
            suggest = "account_id"
        elif key == "accountResourceId":
            suggest = "account_resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MonitoringAccountDestinationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MonitoringAccountDestinationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MonitoringAccountDestinationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 account_id: str,
                 account_resource_id: Optional[str] = None,
                 name: Optional[str] = None):
        """
        Monitoring account destination.
        :param str account_id: The immutable ID  of the account.
        :param str account_resource_id: The resource ID of the monitoring account.
        :param str name: A friendly name for the destination. 
               This name should be unique across all destinations (regardless of type) within the data collection rule.
        """
        pulumi.set(__self__, "account_id", account_id)
        if account_resource_id is not None:
            pulumi.set(__self__, "account_resource_id", account_resource_id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> str:
        """
        The immutable ID  of the account.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="accountResourceId")
    def account_resource_id(self) -> Optional[str]:
        """
        The resource ID of the monitoring account.
        """
        return pulumi.get(self, "account_resource_id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        A friendly name for the destination. 
        This name should be unique across all destinations (regardless of type) within the data collection rule.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class PerfCounterDataSourceResponse(dict):
    """
    Definition of which performance counters will be collected and how they will be collected by this data collection rule.
    Collected from both Windows and Linux machines where the counter is present.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "counterSpecifiers":
            suggest = "counter_specifiers"
        elif key == "samplingFrequencyInSeconds":
            suggest = "sampling_frequency_in_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PerfCounterDataSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PerfCounterDataSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PerfCounterDataSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 counter_specifiers: Optional[Sequence[str]] = None,
                 name: Optional[str] = None,
                 sampling_frequency_in_seconds: Optional[int] = None,
                 streams: Optional[Sequence[str]] = None):
        """
        Definition of which performance counters will be collected and how they will be collected by this data collection rule.
        Collected from both Windows and Linux machines where the counter is present.
        :param Sequence[str] counter_specifiers: A list of specifier names of the performance counters you want to collect.
               Use a wildcard (*) to collect a counter for all instances.
               To get a list of performance counters on Windows, run the command 'typeperf'.
        :param str name: A friendly name for the data source. 
               This name should be unique across all data sources (regardless of type) within the data collection rule.
        :param int sampling_frequency_in_seconds: The number of seconds between consecutive counter measurements (samples).
        :param Sequence[str] streams: List of streams that this data source will be sent to.
               A stream indicates what schema will be used for this data and usually what table in Log Analytics the data will be sent to.
        """
        if counter_specifiers is not None:
            pulumi.set(__self__, "counter_specifiers", counter_specifiers)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if sampling_frequency_in_seconds is not None:
            pulumi.set(__self__, "sampling_frequency_in_seconds", sampling_frequency_in_seconds)
        if streams is not None:
            pulumi.set(__self__, "streams", streams)

    @property
    @pulumi.getter(name="counterSpecifiers")
    def counter_specifiers(self) -> Optional[Sequence[str]]:
        """
        A list of specifier names of the performance counters you want to collect.
        Use a wildcard (*) to collect a counter for all instances.
        To get a list of performance counters on Windows, run the command 'typeperf'.
        """
        return pulumi.get(self, "counter_specifiers")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        A friendly name for the data source. 
        This name should be unique across all data sources (regardless of type) within the data collection rule.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="samplingFrequencyInSeconds")
    def sampling_frequency_in_seconds(self) -> Optional[int]:
        """
        The number of seconds between consecutive counter measurements (samples).
        """
        return pulumi.get(self, "sampling_frequency_in_seconds")

    @property
    @pulumi.getter
    def streams(self) -> Optional[Sequence[str]]:
        """
        List of streams that this data source will be sent to.
        A stream indicates what schema will be used for this data and usually what table in Log Analytics the data will be sent to.
        """
        return pulumi.get(self, "streams")


@pulumi.output_type
class PlatformTelemetryDataSourceResponse(dict):
    """
    Definition of platform telemetry data source configuration
    """
    def __init__(__self__, *,
                 streams: Sequence[str],
                 name: Optional[str] = None):
        """
        Definition of platform telemetry data source configuration
        :param Sequence[str] streams: List of platform telemetry streams to collect
        :param str name: A friendly name for the data source. 
               This name should be unique across all data sources (regardless of type) within the data collection rule.
        """
        pulumi.set(__self__, "streams", streams)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def streams(self) -> Sequence[str]:
        """
        List of platform telemetry streams to collect
        """
        return pulumi.get(self, "streams")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        A friendly name for the data source. 
        This name should be unique across all data sources (regardless of type) within the data collection rule.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class PrivateLinkScopedResourceResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceId":
            suggest = "resource_id"
        elif key == "scopeId":
            suggest = "scope_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateLinkScopedResourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateLinkScopedResourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateLinkScopedResourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_id: Optional[str] = None,
                 scope_id: Optional[str] = None):
        """
        :param str resource_id: The resourceId of the Azure Monitor Private Link Scope Scoped Resource through which this DCE is associated with a Azure Monitor Private Link Scope.
        :param str scope_id: The immutableId of the Azure Monitor Private Link Scope Resource to which the association is.
        """
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)
        if scope_id is not None:
            pulumi.set(__self__, "scope_id", scope_id)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[str]:
        """
        The resourceId of the Azure Monitor Private Link Scope Scoped Resource through which this DCE is associated with a Azure Monitor Private Link Scope.
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter(name="scopeId")
    def scope_id(self) -> Optional[str]:
        """
        The immutableId of the Azure Monitor Private Link Scope Resource to which the association is.
        """
        return pulumi.get(self, "scope_id")


@pulumi.output_type
class PrometheusForwarderDataSourceResponse(dict):
    """
    Definition of Prometheus metrics forwarding configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "labelIncludeFilter":
            suggest = "label_include_filter"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrometheusForwarderDataSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrometheusForwarderDataSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrometheusForwarderDataSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 label_include_filter: Optional[Mapping[str, str]] = None,
                 name: Optional[str] = None,
                 streams: Optional[Sequence[str]] = None):
        """
        Definition of Prometheus metrics forwarding configuration.
        :param Mapping[str, str] label_include_filter: The list of label inclusion filters in the form of label "name-value" pairs.
               Currently only one label is supported: 'microsoft_metrics_include_label'.
               Label values are matched case-insensitively.
        :param str name: A friendly name for the data source. 
               This name should be unique across all data sources (regardless of type) within the data collection rule.
        :param Sequence[str] streams: List of streams that this data source will be sent to.
        """
        if label_include_filter is not None:
            pulumi.set(__self__, "label_include_filter", label_include_filter)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if streams is not None:
            pulumi.set(__self__, "streams", streams)

    @property
    @pulumi.getter(name="labelIncludeFilter")
    def label_include_filter(self) -> Optional[Mapping[str, str]]:
        """
        The list of label inclusion filters in the form of label "name-value" pairs.
        Currently only one label is supported: 'microsoft_metrics_include_label'.
        Label values are matched case-insensitively.
        """
        return pulumi.get(self, "label_include_filter")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        A friendly name for the data source. 
        This name should be unique across all data sources (regardless of type) within the data collection rule.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def streams(self) -> Optional[Sequence[str]]:
        """
        List of streams that this data source will be sent to.
        """
        return pulumi.get(self, "streams")


@pulumi.output_type
class SmsReceiverResponse(dict):
    """
    An SMS receiver.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "countryCode":
            suggest = "country_code"
        elif key == "phoneNumber":
            suggest = "phone_number"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SmsReceiverResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SmsReceiverResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SmsReceiverResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 country_code: str,
                 name: str,
                 phone_number: str,
                 status: str):
        """
        An SMS receiver.
        :param str country_code: The country code of the SMS receiver.
        :param str name: The name of the SMS receiver. Names must be unique across all receivers within an action group.
        :param str phone_number: The phone number of the SMS receiver.
        :param str status: The status of the receiver.
        """
        pulumi.set(__self__, "country_code", country_code)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "phone_number", phone_number)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="countryCode")
    def country_code(self) -> str:
        """
        The country code of the SMS receiver.
        """
        return pulumi.get(self, "country_code")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the SMS receiver. Names must be unique across all receivers within an action group.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="phoneNumber")
    def phone_number(self) -> str:
        """
        The phone number of the SMS receiver.
        """
        return pulumi.get(self, "phone_number")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the receiver.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class StorageBlobDestinationResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerName":
            suggest = "container_name"
        elif key == "storageAccountResourceId":
            suggest = "storage_account_resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StorageBlobDestinationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StorageBlobDestinationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StorageBlobDestinationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_name: Optional[str] = None,
                 name: Optional[str] = None,
                 storage_account_resource_id: Optional[str] = None):
        """
        :param str container_name: The container name of the Storage Blob.
        :param str name: A friendly name for the destination. 
               This name should be unique across all destinations (regardless of type) within the data collection rule.
        :param str storage_account_resource_id: The resource ID of the storage account.
        """
        if container_name is not None:
            pulumi.set(__self__, "container_name", container_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if storage_account_resource_id is not None:
            pulumi.set(__self__, "storage_account_resource_id", storage_account_resource_id)

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> Optional[str]:
        """
        The container name of the Storage Blob.
        """
        return pulumi.get(self, "container_name")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        A friendly name for the destination. 
        This name should be unique across all destinations (regardless of type) within the data collection rule.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="storageAccountResourceId")
    def storage_account_resource_id(self) -> Optional[str]:
        """
        The resource ID of the storage account.
        """
        return pulumi.get(self, "storage_account_resource_id")


@pulumi.output_type
class StorageTableDestinationResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storageAccountResourceId":
            suggest = "storage_account_resource_id"
        elif key == "tableName":
            suggest = "table_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StorageTableDestinationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StorageTableDestinationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StorageTableDestinationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: Optional[str] = None,
                 storage_account_resource_id: Optional[str] = None,
                 table_name: Optional[str] = None):
        """
        :param str name: A friendly name for the destination. 
               This name should be unique across all destinations (regardless of type) within the data collection rule.
        :param str storage_account_resource_id: The resource ID of the storage account.
        :param str table_name: The name of the Storage Table.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if storage_account_resource_id is not None:
            pulumi.set(__self__, "storage_account_resource_id", storage_account_resource_id)
        if table_name is not None:
            pulumi.set(__self__, "table_name", table_name)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        A friendly name for the destination. 
        This name should be unique across all destinations (regardless of type) within the data collection rule.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="storageAccountResourceId")
    def storage_account_resource_id(self) -> Optional[str]:
        """
        The resource ID of the storage account.
        """
        return pulumi.get(self, "storage_account_resource_id")

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> Optional[str]:
        """
        The name of the Storage Table.
        """
        return pulumi.get(self, "table_name")


@pulumi.output_type
class StreamDeclarationResponse(dict):
    """
    Declaration of a custom stream.
    """
    def __init__(__self__, *,
                 columns: Optional[Sequence['outputs.ColumnDefinitionResponse']] = None):
        """
        Declaration of a custom stream.
        :param Sequence['ColumnDefinitionResponse'] columns: List of columns used by data in this stream.
        """
        if columns is not None:
            pulumi.set(__self__, "columns", columns)

    @property
    @pulumi.getter
    def columns(self) -> Optional[Sequence['outputs.ColumnDefinitionResponse']]:
        """
        List of columns used by data in this stream.
        """
        return pulumi.get(self, "columns")


@pulumi.output_type
class SyslogDataSourceResponse(dict):
    """
    Definition of which syslog data will be collected and how it will be collected.
    Only collected from Linux machines.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "facilityNames":
            suggest = "facility_names"
        elif key == "logLevels":
            suggest = "log_levels"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SyslogDataSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SyslogDataSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SyslogDataSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 facility_names: Optional[Sequence[str]] = None,
                 log_levels: Optional[Sequence[str]] = None,
                 name: Optional[str] = None,
                 streams: Optional[Sequence[str]] = None):
        """
        Definition of which syslog data will be collected and how it will be collected.
        Only collected from Linux machines.
        :param Sequence[str] facility_names: The list of facility names.
        :param Sequence[str] log_levels: The log levels to collect.
        :param str name: A friendly name for the data source. 
               This name should be unique across all data sources (regardless of type) within the data collection rule.
        :param Sequence[str] streams: List of streams that this data source will be sent to.
               A stream indicates what schema will be used for this data and usually what table in Log Analytics the data will be sent to.
        """
        if facility_names is not None:
            pulumi.set(__self__, "facility_names", facility_names)
        if log_levels is not None:
            pulumi.set(__self__, "log_levels", log_levels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if streams is not None:
            pulumi.set(__self__, "streams", streams)

    @property
    @pulumi.getter(name="facilityNames")
    def facility_names(self) -> Optional[Sequence[str]]:
        """
        The list of facility names.
        """
        return pulumi.get(self, "facility_names")

    @property
    @pulumi.getter(name="logLevels")
    def log_levels(self) -> Optional[Sequence[str]]:
        """
        The log levels to collect.
        """
        return pulumi.get(self, "log_levels")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        A friendly name for the data source. 
        This name should be unique across all data sources (regardless of type) within the data collection rule.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def streams(self) -> Optional[Sequence[str]]:
        """
        List of streams that this data source will be sent to.
        A stream indicates what schema will be used for this data and usually what table in Log Analytics the data will be sent to.
        """
        return pulumi.get(self, "streams")


@pulumi.output_type
class UserAssignedIdentityResponse(dict):
    """
    User assigned identity properties
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "principalId":
            suggest = "principal_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserAssignedIdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserAssignedIdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserAssignedIdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: str,
                 principal_id: str):
        """
        User assigned identity properties
        :param str client_id: The client ID of the assigned identity.
        :param str principal_id: The principal ID of the assigned identity.
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "principal_id", principal_id)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> str:
        """
        The client ID of the assigned identity.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        The principal ID of the assigned identity.
        """
        return pulumi.get(self, "principal_id")


@pulumi.output_type
class VoiceReceiverResponse(dict):
    """
    A voice receiver.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "countryCode":
            suggest = "country_code"
        elif key == "phoneNumber":
            suggest = "phone_number"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VoiceReceiverResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VoiceReceiverResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VoiceReceiverResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 country_code: str,
                 name: str,
                 phone_number: str):
        """
        A voice receiver.
        :param str country_code: The country code of the voice receiver.
        :param str name: The name of the voice receiver. Names must be unique across all receivers within an action group.
        :param str phone_number: The phone number of the voice receiver.
        """
        pulumi.set(__self__, "country_code", country_code)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "phone_number", phone_number)

    @property
    @pulumi.getter(name="countryCode")
    def country_code(self) -> str:
        """
        The country code of the voice receiver.
        """
        return pulumi.get(self, "country_code")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the voice receiver. Names must be unique across all receivers within an action group.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="phoneNumber")
    def phone_number(self) -> str:
        """
        The phone number of the voice receiver.
        """
        return pulumi.get(self, "phone_number")


@pulumi.output_type
class WebhookReceiverResponse(dict):
    """
    A webhook receiver.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serviceUri":
            suggest = "service_uri"
        elif key == "identifierUri":
            suggest = "identifier_uri"
        elif key == "objectId":
            suggest = "object_id"
        elif key == "tenantId":
            suggest = "tenant_id"
        elif key == "useAadAuth":
            suggest = "use_aad_auth"
        elif key == "useCommonAlertSchema":
            suggest = "use_common_alert_schema"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebhookReceiverResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebhookReceiverResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebhookReceiverResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 service_uri: str,
                 identifier_uri: Optional[str] = None,
                 object_id: Optional[str] = None,
                 tenant_id: Optional[str] = None,
                 use_aad_auth: Optional[bool] = None,
                 use_common_alert_schema: Optional[bool] = None):
        """
        A webhook receiver.
        :param str name: The name of the webhook receiver. Names must be unique across all receivers within an action group.
        :param str service_uri: The URI where webhooks should be sent.
        :param str identifier_uri: Indicates the identifier uri for aad auth.
        :param str object_id: Indicates the webhook app object Id for aad auth.
        :param str tenant_id: Indicates the tenant id for aad auth.
        :param bool use_aad_auth: Indicates whether or not use AAD authentication.
        :param bool use_common_alert_schema: Indicates whether to use common alert schema.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "service_uri", service_uri)
        if identifier_uri is not None:
            pulumi.set(__self__, "identifier_uri", identifier_uri)
        if object_id is not None:
            pulumi.set(__self__, "object_id", object_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if use_aad_auth is None:
            use_aad_auth = False
        if use_aad_auth is not None:
            pulumi.set(__self__, "use_aad_auth", use_aad_auth)
        if use_common_alert_schema is None:
            use_common_alert_schema = False
        if use_common_alert_schema is not None:
            pulumi.set(__self__, "use_common_alert_schema", use_common_alert_schema)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the webhook receiver. Names must be unique across all receivers within an action group.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="serviceUri")
    def service_uri(self) -> str:
        """
        The URI where webhooks should be sent.
        """
        return pulumi.get(self, "service_uri")

    @property
    @pulumi.getter(name="identifierUri")
    def identifier_uri(self) -> Optional[str]:
        """
        Indicates the identifier uri for aad auth.
        """
        return pulumi.get(self, "identifier_uri")

    @property
    @pulumi.getter(name="objectId")
    def object_id(self) -> Optional[str]:
        """
        Indicates the webhook app object Id for aad auth.
        """
        return pulumi.get(self, "object_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[str]:
        """
        Indicates the tenant id for aad auth.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter(name="useAadAuth")
    def use_aad_auth(self) -> Optional[bool]:
        """
        Indicates whether or not use AAD authentication.
        """
        return pulumi.get(self, "use_aad_auth")

    @property
    @pulumi.getter(name="useCommonAlertSchema")
    def use_common_alert_schema(self) -> Optional[bool]:
        """
        Indicates whether to use common alert schema.
        """
        return pulumi.get(self, "use_common_alert_schema")


@pulumi.output_type
class WindowsEventLogDataSourceResponse(dict):
    """
    Definition of which Windows Event Log events will be collected and how they will be collected.
    Only collected from Windows machines.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "xPathQueries":
            suggest = "x_path_queries"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WindowsEventLogDataSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WindowsEventLogDataSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WindowsEventLogDataSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: Optional[str] = None,
                 streams: Optional[Sequence[str]] = None,
                 x_path_queries: Optional[Sequence[str]] = None):
        """
        Definition of which Windows Event Log events will be collected and how they will be collected.
        Only collected from Windows machines.
        :param str name: A friendly name for the data source. 
               This name should be unique across all data sources (regardless of type) within the data collection rule.
        :param Sequence[str] streams: List of streams that this data source will be sent to.
               A stream indicates what schema will be used for this data and usually what table in Log Analytics the data will be sent to.
        :param Sequence[str] x_path_queries: A list of Windows Event Log queries in XPATH format.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if streams is not None:
            pulumi.set(__self__, "streams", streams)
        if x_path_queries is not None:
            pulumi.set(__self__, "x_path_queries", x_path_queries)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        A friendly name for the data source. 
        This name should be unique across all data sources (regardless of type) within the data collection rule.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def streams(self) -> Optional[Sequence[str]]:
        """
        List of streams that this data source will be sent to.
        A stream indicates what schema will be used for this data and usually what table in Log Analytics the data will be sent to.
        """
        return pulumi.get(self, "streams")

    @property
    @pulumi.getter(name="xPathQueries")
    def x_path_queries(self) -> Optional[Sequence[str]]:
        """
        A list of Windows Event Log queries in XPATH format.
        """
        return pulumi.get(self, "x_path_queries")


@pulumi.output_type
class WindowsFirewallLogsDataSourceResponse(dict):
    """
    Enables Firewall logs to be collected by this data collection rule.
    """
    def __init__(__self__, *,
                 streams: Sequence[str],
                 name: Optional[str] = None):
        """
        Enables Firewall logs to be collected by this data collection rule.
        :param Sequence[str] streams: Firewall logs streams
        :param str name: A friendly name for the data source. 
               This name should be unique across all data sources (regardless of type) within the data collection rule.
        """
        pulumi.set(__self__, "streams", streams)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def streams(self) -> Sequence[str]:
        """
        Firewall logs streams
        """
        return pulumi.get(self, "streams")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        A friendly name for the data source. 
        This name should be unique across all data sources (regardless of type) within the data collection rule.
        """
        return pulumi.get(self, "name")


