# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'ArcConnectivityPropertiesArgs',
    'ClusterDesiredPropertiesArgs',
    'SoftwareAssurancePropertiesArgs',
    'StepArgs',
    'UpdatePrerequisiteArgs',
]

@pulumi.input_type
class ArcConnectivityPropertiesArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None):
        """
        Connectivity related configuration required by arc server.
        :param pulumi.Input[bool] enabled: True indicates ARC connectivity is enabled
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        True indicates ARC connectivity is enabled
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)


@pulumi.input_type
class ClusterDesiredPropertiesArgs:
    def __init__(__self__, *,
                 diagnostic_level: Optional[pulumi.Input[Union[str, 'DiagnosticLevel']]] = None,
                 windows_server_subscription: Optional[pulumi.Input[Union[str, 'WindowsServerSubscription']]] = None):
        """
        Desired properties of the cluster.
        :param pulumi.Input[Union[str, 'DiagnosticLevel']] diagnostic_level: Desired level of diagnostic data emitted by the cluster.
        :param pulumi.Input[Union[str, 'WindowsServerSubscription']] windows_server_subscription: Desired state of Windows Server Subscription.
        """
        if diagnostic_level is not None:
            pulumi.set(__self__, "diagnostic_level", diagnostic_level)
        if windows_server_subscription is not None:
            pulumi.set(__self__, "windows_server_subscription", windows_server_subscription)

    @property
    @pulumi.getter(name="diagnosticLevel")
    def diagnostic_level(self) -> Optional[pulumi.Input[Union[str, 'DiagnosticLevel']]]:
        """
        Desired level of diagnostic data emitted by the cluster.
        """
        return pulumi.get(self, "diagnostic_level")

    @diagnostic_level.setter
    def diagnostic_level(self, value: Optional[pulumi.Input[Union[str, 'DiagnosticLevel']]]):
        pulumi.set(self, "diagnostic_level", value)

    @property
    @pulumi.getter(name="windowsServerSubscription")
    def windows_server_subscription(self) -> Optional[pulumi.Input[Union[str, 'WindowsServerSubscription']]]:
        """
        Desired state of Windows Server Subscription.
        """
        return pulumi.get(self, "windows_server_subscription")

    @windows_server_subscription.setter
    def windows_server_subscription(self, value: Optional[pulumi.Input[Union[str, 'WindowsServerSubscription']]]):
        pulumi.set(self, "windows_server_subscription", value)


@pulumi.input_type
class SoftwareAssurancePropertiesArgs:
    def __init__(__self__, *,
                 software_assurance_intent: Optional[pulumi.Input[Union[str, 'SoftwareAssuranceIntent']]] = None,
                 software_assurance_status: Optional[pulumi.Input[Union[str, 'SoftwareAssuranceStatus']]] = None):
        """
        Software Assurance properties of the cluster.
        :param pulumi.Input[Union[str, 'SoftwareAssuranceIntent']] software_assurance_intent: Customer Intent for Software Assurance Benefit.
        :param pulumi.Input[Union[str, 'SoftwareAssuranceStatus']] software_assurance_status: Status of the Software Assurance for the cluster.
        """
        if software_assurance_intent is not None:
            pulumi.set(__self__, "software_assurance_intent", software_assurance_intent)
        if software_assurance_status is not None:
            pulumi.set(__self__, "software_assurance_status", software_assurance_status)

    @property
    @pulumi.getter(name="softwareAssuranceIntent")
    def software_assurance_intent(self) -> Optional[pulumi.Input[Union[str, 'SoftwareAssuranceIntent']]]:
        """
        Customer Intent for Software Assurance Benefit.
        """
        return pulumi.get(self, "software_assurance_intent")

    @software_assurance_intent.setter
    def software_assurance_intent(self, value: Optional[pulumi.Input[Union[str, 'SoftwareAssuranceIntent']]]):
        pulumi.set(self, "software_assurance_intent", value)

    @property
    @pulumi.getter(name="softwareAssuranceStatus")
    def software_assurance_status(self) -> Optional[pulumi.Input[Union[str, 'SoftwareAssuranceStatus']]]:
        """
        Status of the Software Assurance for the cluster.
        """
        return pulumi.get(self, "software_assurance_status")

    @software_assurance_status.setter
    def software_assurance_status(self, value: Optional[pulumi.Input[Union[str, 'SoftwareAssuranceStatus']]]):
        pulumi.set(self, "software_assurance_status", value)


@pulumi.input_type
class StepArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 end_time_utc: Optional[pulumi.Input[str]] = None,
                 error_message: Optional[pulumi.Input[str]] = None,
                 last_updated_time_utc: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 start_time_utc: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 steps: Optional[pulumi.Input[Sequence[pulumi.Input['StepArgs']]]] = None):
        """
        Progress representation of the update run steps.
        :param pulumi.Input[str] description: More detailed description of the step.
        :param pulumi.Input[str] end_time_utc: When the step reached a terminal state.
        :param pulumi.Input[str] error_message: Error message, specified if the step is in a failed state.
        :param pulumi.Input[str] last_updated_time_utc: Completion time of this step or the last completed sub-step.
        :param pulumi.Input[str] name: Name of the step.
        :param pulumi.Input[str] start_time_utc: When the step started, or empty if it has not started executing.
        :param pulumi.Input[str] status: Status of the step, bubbled up from the ECE action plan for installation attempts. Values are: 'Success', 'Error', 'InProgress', and 'Unknown status'.
        :param pulumi.Input[Sequence[pulumi.Input['StepArgs']]] steps: Recursive model for child steps of this step.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if end_time_utc is not None:
            pulumi.set(__self__, "end_time_utc", end_time_utc)
        if error_message is not None:
            pulumi.set(__self__, "error_message", error_message)
        if last_updated_time_utc is not None:
            pulumi.set(__self__, "last_updated_time_utc", last_updated_time_utc)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if start_time_utc is not None:
            pulumi.set(__self__, "start_time_utc", start_time_utc)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if steps is not None:
            pulumi.set(__self__, "steps", steps)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        More detailed description of the step.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="endTimeUtc")
    def end_time_utc(self) -> Optional[pulumi.Input[str]]:
        """
        When the step reached a terminal state.
        """
        return pulumi.get(self, "end_time_utc")

    @end_time_utc.setter
    def end_time_utc(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "end_time_utc", value)

    @property
    @pulumi.getter(name="errorMessage")
    def error_message(self) -> Optional[pulumi.Input[str]]:
        """
        Error message, specified if the step is in a failed state.
        """
        return pulumi.get(self, "error_message")

    @error_message.setter
    def error_message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "error_message", value)

    @property
    @pulumi.getter(name="lastUpdatedTimeUtc")
    def last_updated_time_utc(self) -> Optional[pulumi.Input[str]]:
        """
        Completion time of this step or the last completed sub-step.
        """
        return pulumi.get(self, "last_updated_time_utc")

    @last_updated_time_utc.setter
    def last_updated_time_utc(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_updated_time_utc", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the step.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="startTimeUtc")
    def start_time_utc(self) -> Optional[pulumi.Input[str]]:
        """
        When the step started, or empty if it has not started executing.
        """
        return pulumi.get(self, "start_time_utc")

    @start_time_utc.setter
    def start_time_utc(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_time_utc", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of the step, bubbled up from the ECE action plan for installation attempts. Values are: 'Success', 'Error', 'InProgress', and 'Unknown status'.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def steps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StepArgs']]]]:
        """
        Recursive model for child steps of this step.
        """
        return pulumi.get(self, "steps")

    @steps.setter
    def steps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StepArgs']]]]):
        pulumi.set(self, "steps", value)


@pulumi.input_type
class UpdatePrerequisiteArgs:
    def __init__(__self__, *,
                 package_name: Optional[pulumi.Input[str]] = None,
                 update_type: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        If update State is HasPrerequisite, this property contains an array of objects describing prerequisite updates before installing this update. Otherwise, it is empty.
        :param pulumi.Input[str] package_name: Friendly name of the prerequisite.
        :param pulumi.Input[str] update_type: Updatable component type.
        :param pulumi.Input[str] version: Version of the prerequisite.
        """
        if package_name is not None:
            pulumi.set(__self__, "package_name", package_name)
        if update_type is not None:
            pulumi.set(__self__, "update_type", update_type)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="packageName")
    def package_name(self) -> Optional[pulumi.Input[str]]:
        """
        Friendly name of the prerequisite.
        """
        return pulumi.get(self, "package_name")

    @package_name.setter
    def package_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "package_name", value)

    @property
    @pulumi.getter(name="updateType")
    def update_type(self) -> Optional[pulumi.Input[str]]:
        """
        Updatable component type.
        """
        return pulumi.get(self, "update_type")

    @update_type.setter
    def update_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "update_type", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        Version of the prerequisite.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


