# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetAssociationsInterfaceResult',
    'AwaitableGetAssociationsInterfaceResult',
    'get_associations_interface',
    'get_associations_interface_output',
]

@pulumi.output_type
class GetAssociationsInterfaceResult:
    """
    Association Subresource of Traffic Controller
    """
    def __init__(__self__, association_type=None, id=None, location=None, name=None, provisioning_state=None, subnet=None, system_data=None, tags=None, type=None):
        if association_type and not isinstance(association_type, str):
            raise TypeError("Expected argument 'association_type' to be a str")
        pulumi.set(__self__, "association_type", association_type)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if provisioning_state and not isinstance(provisioning_state, str):
            raise TypeError("Expected argument 'provisioning_state' to be a str")
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if subnet and not isinstance(subnet, dict):
            raise TypeError("Expected argument 'subnet' to be a dict")
        pulumi.set(__self__, "subnet", subnet)
        if system_data and not isinstance(system_data, dict):
            raise TypeError("Expected argument 'system_data' to be a dict")
        pulumi.set(__self__, "system_data", system_data)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="associationType")
    def association_type(self) -> str:
        """
        Association Type
        """
        return pulumi.get(self, "association_type")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        The geo-location where the resource lives
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        Provisioning State
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def subnet(self) -> Optional['outputs.AssociationSubnetResponse']:
        """
        Association Subnet
        """
        return pulumi.get(self, "subnet")

    @property
    @pulumi.getter(name="systemData")
    def system_data(self) -> 'outputs.SystemDataResponse':
        """
        Azure Resource Manager metadata containing createdBy and modifiedBy information.
        """
        return pulumi.get(self, "system_data")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
        """
        return pulumi.get(self, "type")


class AwaitableGetAssociationsInterfaceResult(GetAssociationsInterfaceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAssociationsInterfaceResult(
            association_type=self.association_type,
            id=self.id,
            location=self.location,
            name=self.name,
            provisioning_state=self.provisioning_state,
            subnet=self.subnet,
            system_data=self.system_data,
            tags=self.tags,
            type=self.type)


def get_associations_interface(association_name: Optional[str] = None,
                               resource_group_name: Optional[str] = None,
                               traffic_controller_name: Optional[str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAssociationsInterfaceResult:
    """
    Get a Traffic Controller Association


    :param str association_name: Name of Association
    :param str resource_group_name: The name of the resource group. The name is case insensitive.
    :param str traffic_controller_name: traffic controller name for path
    """
    __args__ = dict()
    __args__['associationName'] = association_name
    __args__['resourceGroupName'] = resource_group_name
    __args__['trafficControllerName'] = traffic_controller_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure-native:servicenetworking/v20221001preview:getAssociationsInterface', __args__, opts=opts, typ=GetAssociationsInterfaceResult).value

    return AwaitableGetAssociationsInterfaceResult(
        association_type=__ret__.association_type,
        id=__ret__.id,
        location=__ret__.location,
        name=__ret__.name,
        provisioning_state=__ret__.provisioning_state,
        subnet=__ret__.subnet,
        system_data=__ret__.system_data,
        tags=__ret__.tags,
        type=__ret__.type)


@_utilities.lift_output_func(get_associations_interface)
def get_associations_interface_output(association_name: Optional[pulumi.Input[str]] = None,
                                      resource_group_name: Optional[pulumi.Input[str]] = None,
                                      traffic_controller_name: Optional[pulumi.Input[str]] = None,
                                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAssociationsInterfaceResult]:
    """
    Get a Traffic Controller Association


    :param str association_name: Name of Association
    :param str resource_group_name: The name of the resource group. The name is case insensitive.
    :param str traffic_controller_name: traffic controller name for path
    """
    ...
