# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'AKSSchemaPropertiesArgs',
    'AKSArgs',
    'AccessKeyAuthTypeWorkspaceConnectionPropertiesArgs',
    'AccountKeyDatastoreCredentialsArgs',
    'AccountKeyDatastoreSecretsArgs',
    'AcrDetailsArgs',
    'AksNetworkingConfigurationArgs',
    'AllNodesArgs',
    'AmlComputePropertiesArgs',
    'AmlComputeArgs',
    'AmlTokenArgs',
    'ArmResourceIdArgs',
    'AssignedUserArgs',
    'AutoForecastHorizonArgs',
    'AutoMLJobArgs',
    'AutoNCrossValidationsArgs',
    'AutoPausePropertiesArgs',
    'AutoScalePropertiesArgs',
    'AutoSeasonalityArgs',
    'AutoTargetLagsArgs',
    'AutoTargetRollingWindowSizeArgs',
    'AutologgerSettingsArgs',
    'AzureBlobDatastoreArgs',
    'AzureDataLakeGen1DatastoreArgs',
    'AzureDataLakeGen2DatastoreArgs',
    'AzureFileDatastoreArgs',
    'BanditPolicyArgs',
    'BatchDeploymentArgs',
    'BatchEndpointDefaultsArgs',
    'BatchEndpointArgs',
    'BatchRetrySettingsArgs',
    'BayesianSamplingAlgorithmArgs',
    'BindOptionsArgs',
    'BuildContextArgs',
    'CertificateDatastoreCredentialsArgs',
    'CertificateDatastoreSecretsArgs',
    'ClassificationTrainingSettingsArgs',
    'ClassificationArgs',
    'CodeConfigurationArgs',
    'CodeContainerArgs',
    'CodeVersionArgs',
    'ColumnTransformerArgs',
    'CommandJobLimitsArgs',
    'CommandJobArgs',
    'ComponentContainerArgs',
    'ComponentVersionArgs',
    'ComputeInstanceAutologgerSettingsArgs',
    'ComputeInstancePropertiesArgs',
    'ComputeInstanceSshSettingsArgs',
    'ComputeInstanceArgs',
    'ComputeRuntimeDtoArgs',
    'ComputeSchedulesArgs',
    'ComputeStartStopScheduleArgs',
    'ContainerResourceRequirementsArgs',
    'ContainerResourceSettingsArgs',
    'CosmosDbSettingsArgs',
    'CronTriggerArgs',
    'CustomForecastHorizonArgs',
    'CustomModelJobInputArgs',
    'CustomModelJobOutputArgs',
    'CustomNCrossValidationsArgs',
    'CustomSeasonalityArgs',
    'CustomServiceArgs',
    'CustomTargetLagsArgs',
    'CustomTargetRollingWindowSizeArgs',
    'DataContainerArgs',
    'DataFactoryArgs',
    'DataLakeAnalyticsSchemaPropertiesArgs',
    'DataLakeAnalyticsArgs',
    'DataPathAssetReferenceArgs',
    'DatabricksPropertiesArgs',
    'DatabricksArgs',
    'DefaultScaleSettingsArgs',
    'DeploymentResourceConfigurationArgs',
    'DockerArgs',
    'EncryptionKeyVaultPropertiesArgs',
    'EncryptionPropertyArgs',
    'EndpointAuthKeysArgs',
    'EndpointScheduleActionArgs',
    'EndpointArgs',
    'EnvironmentContainerArgs',
    'EnvironmentVariableArgs',
    'EnvironmentVersionArgs',
    'FeatureStoreSettingsArgs',
    'FlavorDataArgs',
    'ForecastingSettingsArgs',
    'ForecastingTrainingSettingsArgs',
    'ForecastingArgs',
    'GridSamplingAlgorithmArgs',
    'HDInsightPropertiesArgs',
    'HDInsightArgs',
    'HdfsDatastoreArgs',
    'IdAssetReferenceArgs',
    'IdentityForCmkArgs',
    'ImageClassificationMultilabelArgs',
    'ImageClassificationArgs',
    'ImageInstanceSegmentationArgs',
    'ImageLimitSettingsArgs',
    'ImageModelDistributionSettingsClassificationArgs',
    'ImageModelDistributionSettingsObjectDetectionArgs',
    'ImageModelSettingsClassificationArgs',
    'ImageModelSettingsObjectDetectionArgs',
    'ImageObjectDetectionArgs',
    'ImageSweepSettingsArgs',
    'ImageArgs',
    'InferenceContainerPropertiesArgs',
    'InstanceTypeSchemaResourcesArgs',
    'InstanceTypeSchemaArgs',
    'JobResourceConfigurationArgs',
    'JobScheduleActionArgs',
    'JobServiceArgs',
    'KerberosKeytabCredentialsArgs',
    'KerberosKeytabSecretsArgs',
    'KerberosPasswordCredentialsArgs',
    'KerberosPasswordSecretsArgs',
    'KubernetesOnlineDeploymentArgs',
    'KubernetesPropertiesArgs',
    'KubernetesArgs',
    'LabelCategoryArgs',
    'LabelClassArgs',
    'LabelingDataConfigurationArgs',
    'LabelingJobImagePropertiesArgs',
    'LabelingJobInstructionsArgs',
    'LabelingJobTextPropertiesArgs',
    'LabelingJobArgs',
    'LiteralJobInputArgs',
    'MLAssistConfigurationDisabledArgs',
    'MLAssistConfigurationEnabledArgs',
    'MLFlowModelJobInputArgs',
    'MLFlowModelJobOutputArgs',
    'MLTableDataArgs',
    'MLTableJobInputArgs',
    'MLTableJobOutputArgs',
    'ManagedIdentityAuthTypeWorkspaceConnectionPropertiesArgs',
    'ManagedIdentityArgs',
    'ManagedOnlineDeploymentArgs',
    'ManagedServiceIdentityArgs',
    'MedianStoppingPolicyArgs',
    'ModelContainerArgs',
    'ModelVersionArgs',
    'MpiArgs',
    'NlpFixedParametersArgs',
    'NlpParameterSubspaceArgs',
    'NlpSweepSettingsArgs',
    'NlpVerticalFeaturizationSettingsArgs',
    'NlpVerticalLimitSettingsArgs',
    'NoneAuthTypeWorkspaceConnectionPropertiesArgs',
    'NoneDatastoreCredentialsArgs',
    'ObjectiveArgs',
    'OnlineEndpointArgs',
    'OnlineRequestSettingsArgs',
    'OutputPathAssetReferenceArgs',
    'PATAuthTypeWorkspaceConnectionPropertiesArgs',
    'PersonalComputeInstanceSettingsArgs',
    'PipelineJobArgs',
    'PrivateLinkServiceConnectionStateArgs',
    'ProbeSettingsArgs',
    'PyTorchArgs',
    'RandomSamplingAlgorithmArgs',
    'RecurrenceScheduleArgs',
    'RecurrenceTriggerArgs',
    'RegistryRegionArmDetailsArgs',
    'RegistryArgs',
    'RegressionTrainingSettingsArgs',
    'RegressionArgs',
    'ResourceIdArgs',
    'RouteArgs',
    'SASAuthTypeWorkspaceConnectionPropertiesArgs',
    'SasDatastoreCredentialsArgs',
    'SasDatastoreSecretsArgs',
    'ScaleSettingsArgs',
    'ScheduleBaseArgs',
    'ScheduleArgs',
    'ScriptReferenceArgs',
    'ScriptsToExecuteArgs',
    'ServiceManagedResourcesSettingsArgs',
    'ServicePrincipalAuthTypeWorkspaceConnectionPropertiesArgs',
    'ServicePrincipalDatastoreCredentialsArgs',
    'ServicePrincipalDatastoreSecretsArgs',
    'SetupScriptsArgs',
    'SharedPrivateLinkResourceArgs',
    'SkuArgs',
    'SparkJobPythonEntryArgs',
    'SparkJobScalaEntryArgs',
    'SparkJobArgs',
    'SparkResourceConfigurationArgs',
    'SslConfigurationArgs',
    'StackEnsembleSettingsArgs',
    'StorageAccountDetailsArgs',
    'SweepJobLimitsArgs',
    'SweepJobArgs',
    'SynapseSparkPropertiesArgs',
    'SynapseSparkArgs',
    'SystemCreatedAcrAccountArgs',
    'SystemCreatedStorageAccountArgs',
    'TableFixedParametersArgs',
    'TableParameterSubspaceArgs',
    'TableSweepSettingsArgs',
    'TableVerticalFeaturizationSettingsArgs',
    'TableVerticalLimitSettingsArgs',
    'TargetUtilizationScaleSettingsArgs',
    'TensorFlowArgs',
    'TextClassificationMultilabelArgs',
    'TextClassificationArgs',
    'TextNerArgs',
    'TmpfsOptionsArgs',
    'TrialComponentArgs',
    'TritonModelJobInputArgs',
    'TritonModelJobOutputArgs',
    'TruncationSelectionPolicyArgs',
    'UriFileDataVersionArgs',
    'UriFileJobInputArgs',
    'UriFileJobOutputArgs',
    'UriFolderDataVersionArgs',
    'UriFolderJobInputArgs',
    'UriFolderJobOutputArgs',
    'UserAccountCredentialsArgs',
    'UserCreatedAcrAccountArgs',
    'UserCreatedStorageAccountArgs',
    'UserIdentityArgs',
    'UsernamePasswordAuthTypeWorkspaceConnectionPropertiesArgs',
    'VirtualMachineImageArgs',
    'VirtualMachineSchemaPropertiesArgs',
    'VirtualMachineSshCredentialsArgs',
    'VirtualMachineArgs',
    'VolumeDefinitionArgs',
    'VolumeOptionsArgs',
    'WorkspaceConnectionAccessKeyArgs',
    'WorkspaceConnectionManagedIdentityArgs',
    'WorkspaceConnectionPersonalAccessTokenArgs',
    'WorkspaceConnectionServicePrincipalArgs',
    'WorkspaceConnectionSharedAccessSignatureArgs',
    'WorkspaceConnectionUsernamePasswordArgs',
]

@pulumi.input_type
class AKSSchemaPropertiesArgs:
    def __init__(__self__, *,
                 agent_count: Optional[pulumi.Input[int]] = None,
                 agent_vm_size: Optional[pulumi.Input[str]] = None,
                 aks_networking_configuration: Optional[pulumi.Input['AksNetworkingConfigurationArgs']] = None,
                 cluster_fqdn: Optional[pulumi.Input[str]] = None,
                 cluster_purpose: Optional[pulumi.Input[Union[str, 'ClusterPurpose']]] = None,
                 load_balancer_subnet: Optional[pulumi.Input[str]] = None,
                 load_balancer_type: Optional[pulumi.Input[Union[str, 'LoadBalancerType']]] = None,
                 ssl_configuration: Optional[pulumi.Input['SslConfigurationArgs']] = None):
        """
        AKS properties
        :param pulumi.Input[int] agent_count: Number of agents
        :param pulumi.Input[str] agent_vm_size: Agent virtual machine size
        :param pulumi.Input['AksNetworkingConfigurationArgs'] aks_networking_configuration: AKS networking configuration for vnet
        :param pulumi.Input[str] cluster_fqdn: Cluster full qualified domain name
        :param pulumi.Input[Union[str, 'ClusterPurpose']] cluster_purpose: Intended usage of the cluster
        :param pulumi.Input[str] load_balancer_subnet: Load Balancer Subnet
        :param pulumi.Input[Union[str, 'LoadBalancerType']] load_balancer_type: Load Balancer Type
        :param pulumi.Input['SslConfigurationArgs'] ssl_configuration: SSL configuration
        """
        if agent_count is not None:
            pulumi.set(__self__, "agent_count", agent_count)
        if agent_vm_size is not None:
            pulumi.set(__self__, "agent_vm_size", agent_vm_size)
        if aks_networking_configuration is not None:
            pulumi.set(__self__, "aks_networking_configuration", aks_networking_configuration)
        if cluster_fqdn is not None:
            pulumi.set(__self__, "cluster_fqdn", cluster_fqdn)
        if cluster_purpose is None:
            cluster_purpose = 'FastProd'
        if cluster_purpose is not None:
            pulumi.set(__self__, "cluster_purpose", cluster_purpose)
        if load_balancer_subnet is not None:
            pulumi.set(__self__, "load_balancer_subnet", load_balancer_subnet)
        if load_balancer_type is None:
            load_balancer_type = 'PublicIp'
        if load_balancer_type is not None:
            pulumi.set(__self__, "load_balancer_type", load_balancer_type)
        if ssl_configuration is not None:
            pulumi.set(__self__, "ssl_configuration", ssl_configuration)

    @property
    @pulumi.getter(name="agentCount")
    def agent_count(self) -> Optional[pulumi.Input[int]]:
        """
        Number of agents
        """
        return pulumi.get(self, "agent_count")

    @agent_count.setter
    def agent_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "agent_count", value)

    @property
    @pulumi.getter(name="agentVmSize")
    def agent_vm_size(self) -> Optional[pulumi.Input[str]]:
        """
        Agent virtual machine size
        """
        return pulumi.get(self, "agent_vm_size")

    @agent_vm_size.setter
    def agent_vm_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "agent_vm_size", value)

    @property
    @pulumi.getter(name="aksNetworkingConfiguration")
    def aks_networking_configuration(self) -> Optional[pulumi.Input['AksNetworkingConfigurationArgs']]:
        """
        AKS networking configuration for vnet
        """
        return pulumi.get(self, "aks_networking_configuration")

    @aks_networking_configuration.setter
    def aks_networking_configuration(self, value: Optional[pulumi.Input['AksNetworkingConfigurationArgs']]):
        pulumi.set(self, "aks_networking_configuration", value)

    @property
    @pulumi.getter(name="clusterFqdn")
    def cluster_fqdn(self) -> Optional[pulumi.Input[str]]:
        """
        Cluster full qualified domain name
        """
        return pulumi.get(self, "cluster_fqdn")

    @cluster_fqdn.setter
    def cluster_fqdn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_fqdn", value)

    @property
    @pulumi.getter(name="clusterPurpose")
    def cluster_purpose(self) -> Optional[pulumi.Input[Union[str, 'ClusterPurpose']]]:
        """
        Intended usage of the cluster
        """
        return pulumi.get(self, "cluster_purpose")

    @cluster_purpose.setter
    def cluster_purpose(self, value: Optional[pulumi.Input[Union[str, 'ClusterPurpose']]]):
        pulumi.set(self, "cluster_purpose", value)

    @property
    @pulumi.getter(name="loadBalancerSubnet")
    def load_balancer_subnet(self) -> Optional[pulumi.Input[str]]:
        """
        Load Balancer Subnet
        """
        return pulumi.get(self, "load_balancer_subnet")

    @load_balancer_subnet.setter
    def load_balancer_subnet(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "load_balancer_subnet", value)

    @property
    @pulumi.getter(name="loadBalancerType")
    def load_balancer_type(self) -> Optional[pulumi.Input[Union[str, 'LoadBalancerType']]]:
        """
        Load Balancer Type
        """
        return pulumi.get(self, "load_balancer_type")

    @load_balancer_type.setter
    def load_balancer_type(self, value: Optional[pulumi.Input[Union[str, 'LoadBalancerType']]]):
        pulumi.set(self, "load_balancer_type", value)

    @property
    @pulumi.getter(name="sslConfiguration")
    def ssl_configuration(self) -> Optional[pulumi.Input['SslConfigurationArgs']]:
        """
        SSL configuration
        """
        return pulumi.get(self, "ssl_configuration")

    @ssl_configuration.setter
    def ssl_configuration(self, value: Optional[pulumi.Input['SslConfigurationArgs']]):
        pulumi.set(self, "ssl_configuration", value)


@pulumi.input_type
class AKSArgs:
    def __init__(__self__, *,
                 compute_type: pulumi.Input[str],
                 compute_location: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disable_local_auth: Optional[pulumi.Input[bool]] = None,
                 properties: Optional[pulumi.Input['AKSSchemaPropertiesArgs']] = None,
                 resource_id: Optional[pulumi.Input[str]] = None):
        """
        A Machine Learning compute based on AKS.
        :param pulumi.Input[str] compute_type: The type of compute
               Expected value is 'AKS'.
        :param pulumi.Input[str] compute_location: Location for the underlying compute
        :param pulumi.Input[str] description: The description of the Machine Learning compute.
        :param pulumi.Input[bool] disable_local_auth: Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
        :param pulumi.Input['AKSSchemaPropertiesArgs'] properties: AKS properties
        :param pulumi.Input[str] resource_id: ARM resource id of the underlying compute
        """
        pulumi.set(__self__, "compute_type", 'AKS')
        if compute_location is not None:
            pulumi.set(__self__, "compute_location", compute_location)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_local_auth is not None:
            pulumi.set(__self__, "disable_local_auth", disable_local_auth)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="computeType")
    def compute_type(self) -> pulumi.Input[str]:
        """
        The type of compute
        Expected value is 'AKS'.
        """
        return pulumi.get(self, "compute_type")

    @compute_type.setter
    def compute_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "compute_type", value)

    @property
    @pulumi.getter(name="computeLocation")
    def compute_location(self) -> Optional[pulumi.Input[str]]:
        """
        Location for the underlying compute
        """
        return pulumi.get(self, "compute_location")

    @compute_location.setter
    def compute_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compute_location", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the Machine Learning compute.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="disableLocalAuth")
    def disable_local_auth(self) -> Optional[pulumi.Input[bool]]:
        """
        Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
        """
        return pulumi.get(self, "disable_local_auth")

    @disable_local_auth.setter
    def disable_local_auth(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_local_auth", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input['AKSSchemaPropertiesArgs']]:
        """
        AKS properties
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input['AKSSchemaPropertiesArgs']]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM resource id of the underlying compute
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_id", value)


@pulumi.input_type
class AccessKeyAuthTypeWorkspaceConnectionPropertiesArgs:
    def __init__(__self__, *,
                 auth_type: pulumi.Input[str],
                 category: Optional[pulumi.Input[Union[str, 'ConnectionCategory']]] = None,
                 credentials: Optional[pulumi.Input['WorkspaceConnectionAccessKeyArgs']] = None,
                 target: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None,
                 value_format: Optional[pulumi.Input[Union[str, 'ValueFormat']]] = None):
        """
        :param pulumi.Input[str] auth_type: Authentication type of the connection target
               Expected value is 'AccessKey'.
        :param pulumi.Input[Union[str, 'ConnectionCategory']] category: Category of the connection
        :param pulumi.Input[str] value: Value details of the workspace connection.
        :param pulumi.Input[Union[str, 'ValueFormat']] value_format: format for the workspace connection value
        """
        pulumi.set(__self__, "auth_type", 'AccessKey')
        if category is not None:
            pulumi.set(__self__, "category", category)
        if credentials is not None:
            pulumi.set(__self__, "credentials", credentials)
        if target is not None:
            pulumi.set(__self__, "target", target)
        if value is not None:
            pulumi.set(__self__, "value", value)
        if value_format is not None:
            pulumi.set(__self__, "value_format", value_format)

    @property
    @pulumi.getter(name="authType")
    def auth_type(self) -> pulumi.Input[str]:
        """
        Authentication type of the connection target
        Expected value is 'AccessKey'.
        """
        return pulumi.get(self, "auth_type")

    @auth_type.setter
    def auth_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "auth_type", value)

    @property
    @pulumi.getter
    def category(self) -> Optional[pulumi.Input[Union[str, 'ConnectionCategory']]]:
        """
        Category of the connection
        """
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: Optional[pulumi.Input[Union[str, 'ConnectionCategory']]]):
        pulumi.set(self, "category", value)

    @property
    @pulumi.getter
    def credentials(self) -> Optional[pulumi.Input['WorkspaceConnectionAccessKeyArgs']]:
        return pulumi.get(self, "credentials")

    @credentials.setter
    def credentials(self, value: Optional[pulumi.Input['WorkspaceConnectionAccessKeyArgs']]):
        pulumi.set(self, "credentials", value)

    @property
    @pulumi.getter
    def target(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        Value details of the workspace connection.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter(name="valueFormat")
    def value_format(self) -> Optional[pulumi.Input[Union[str, 'ValueFormat']]]:
        """
        format for the workspace connection value
        """
        return pulumi.get(self, "value_format")

    @value_format.setter
    def value_format(self, value: Optional[pulumi.Input[Union[str, 'ValueFormat']]]):
        pulumi.set(self, "value_format", value)


@pulumi.input_type
class AccountKeyDatastoreCredentialsArgs:
    def __init__(__self__, *,
                 credentials_type: pulumi.Input[str],
                 secrets: pulumi.Input['AccountKeyDatastoreSecretsArgs']):
        """
        Account key datastore credentials configuration.
        :param pulumi.Input[str] credentials_type: Enum to determine the datastore credentials type.
               Expected value is 'AccountKey'.
        :param pulumi.Input['AccountKeyDatastoreSecretsArgs'] secrets: [Required] Storage account secrets.
        """
        pulumi.set(__self__, "credentials_type", 'AccountKey')
        pulumi.set(__self__, "secrets", secrets)

    @property
    @pulumi.getter(name="credentialsType")
    def credentials_type(self) -> pulumi.Input[str]:
        """
        Enum to determine the datastore credentials type.
        Expected value is 'AccountKey'.
        """
        return pulumi.get(self, "credentials_type")

    @credentials_type.setter
    def credentials_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "credentials_type", value)

    @property
    @pulumi.getter
    def secrets(self) -> pulumi.Input['AccountKeyDatastoreSecretsArgs']:
        """
        [Required] Storage account secrets.
        """
        return pulumi.get(self, "secrets")

    @secrets.setter
    def secrets(self, value: pulumi.Input['AccountKeyDatastoreSecretsArgs']):
        pulumi.set(self, "secrets", value)


@pulumi.input_type
class AccountKeyDatastoreSecretsArgs:
    def __init__(__self__, *,
                 secrets_type: pulumi.Input[str],
                 key: Optional[pulumi.Input[str]] = None):
        """
        Datastore account key secrets.
        :param pulumi.Input[str] secrets_type: Enum to determine the datastore secrets type.
               Expected value is 'AccountKey'.
        :param pulumi.Input[str] key: Storage account key.
        """
        pulumi.set(__self__, "secrets_type", 'AccountKey')
        if key is not None:
            pulumi.set(__self__, "key", key)

    @property
    @pulumi.getter(name="secretsType")
    def secrets_type(self) -> pulumi.Input[str]:
        """
        Enum to determine the datastore secrets type.
        Expected value is 'AccountKey'.
        """
        return pulumi.get(self, "secrets_type")

    @secrets_type.setter
    def secrets_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "secrets_type", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        Storage account key.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)


@pulumi.input_type
class AcrDetailsArgs:
    def __init__(__self__, *,
                 system_created_acr_account: Optional[pulumi.Input['SystemCreatedAcrAccountArgs']] = None,
                 user_created_acr_account: Optional[pulumi.Input['UserCreatedAcrAccountArgs']] = None):
        """
        Details of ACR account to be used for the Registry
        """
        if system_created_acr_account is not None:
            pulumi.set(__self__, "system_created_acr_account", system_created_acr_account)
        if user_created_acr_account is not None:
            pulumi.set(__self__, "user_created_acr_account", user_created_acr_account)

    @property
    @pulumi.getter(name="systemCreatedAcrAccount")
    def system_created_acr_account(self) -> Optional[pulumi.Input['SystemCreatedAcrAccountArgs']]:
        return pulumi.get(self, "system_created_acr_account")

    @system_created_acr_account.setter
    def system_created_acr_account(self, value: Optional[pulumi.Input['SystemCreatedAcrAccountArgs']]):
        pulumi.set(self, "system_created_acr_account", value)

    @property
    @pulumi.getter(name="userCreatedAcrAccount")
    def user_created_acr_account(self) -> Optional[pulumi.Input['UserCreatedAcrAccountArgs']]:
        return pulumi.get(self, "user_created_acr_account")

    @user_created_acr_account.setter
    def user_created_acr_account(self, value: Optional[pulumi.Input['UserCreatedAcrAccountArgs']]):
        pulumi.set(self, "user_created_acr_account", value)


@pulumi.input_type
class AksNetworkingConfigurationArgs:
    def __init__(__self__, *,
                 dns_service_ip: Optional[pulumi.Input[str]] = None,
                 docker_bridge_cidr: Optional[pulumi.Input[str]] = None,
                 service_cidr: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None):
        """
        Advance configuration for AKS networking
        :param pulumi.Input[str] dns_service_ip: An IP address assigned to the Kubernetes DNS service. It must be within the Kubernetes service address range specified in serviceCidr.
        :param pulumi.Input[str] docker_bridge_cidr: A CIDR notation IP range assigned to the Docker bridge network. It must not overlap with any Subnet IP ranges or the Kubernetes service address range.
        :param pulumi.Input[str] service_cidr: A CIDR notation IP range from which to assign service cluster IPs. It must not overlap with any Subnet IP ranges.
        :param pulumi.Input[str] subnet_id: Virtual network subnet resource ID the compute nodes belong to
        """
        if dns_service_ip is not None:
            pulumi.set(__self__, "dns_service_ip", dns_service_ip)
        if docker_bridge_cidr is not None:
            pulumi.set(__self__, "docker_bridge_cidr", docker_bridge_cidr)
        if service_cidr is not None:
            pulumi.set(__self__, "service_cidr", service_cidr)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)

    @property
    @pulumi.getter(name="dnsServiceIP")
    def dns_service_ip(self) -> Optional[pulumi.Input[str]]:
        """
        An IP address assigned to the Kubernetes DNS service. It must be within the Kubernetes service address range specified in serviceCidr.
        """
        return pulumi.get(self, "dns_service_ip")

    @dns_service_ip.setter
    def dns_service_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dns_service_ip", value)

    @property
    @pulumi.getter(name="dockerBridgeCidr")
    def docker_bridge_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        A CIDR notation IP range assigned to the Docker bridge network. It must not overlap with any Subnet IP ranges or the Kubernetes service address range.
        """
        return pulumi.get(self, "docker_bridge_cidr")

    @docker_bridge_cidr.setter
    def docker_bridge_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "docker_bridge_cidr", value)

    @property
    @pulumi.getter(name="serviceCidr")
    def service_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        A CIDR notation IP range from which to assign service cluster IPs. It must not overlap with any Subnet IP ranges.
        """
        return pulumi.get(self, "service_cidr")

    @service_cidr.setter
    def service_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_cidr", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        Virtual network subnet resource ID the compute nodes belong to
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)


@pulumi.input_type
class AllNodesArgs:
    def __init__(__self__, *,
                 nodes_value_type: pulumi.Input[str]):
        """
        All nodes means the service will be running on all of the nodes of the job
        :param pulumi.Input[str] nodes_value_type: The enumerated types for the nodes value
               Expected value is 'All'.
        """
        pulumi.set(__self__, "nodes_value_type", 'All')

    @property
    @pulumi.getter(name="nodesValueType")
    def nodes_value_type(self) -> pulumi.Input[str]:
        """
        The enumerated types for the nodes value
        Expected value is 'All'.
        """
        return pulumi.get(self, "nodes_value_type")

    @nodes_value_type.setter
    def nodes_value_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "nodes_value_type", value)


@pulumi.input_type
class AmlComputePropertiesArgs:
    def __init__(__self__, *,
                 enable_node_public_ip: Optional[pulumi.Input[bool]] = None,
                 isolated_network: Optional[pulumi.Input[bool]] = None,
                 os_type: Optional[pulumi.Input[Union[str, 'OsType']]] = None,
                 property_bag: Optional[Any] = None,
                 remote_login_port_public_access: Optional[pulumi.Input[Union[str, 'RemoteLoginPortPublicAccess']]] = None,
                 scale_settings: Optional[pulumi.Input['ScaleSettingsArgs']] = None,
                 subnet: Optional[pulumi.Input['ResourceIdArgs']] = None,
                 user_account_credentials: Optional[pulumi.Input['UserAccountCredentialsArgs']] = None,
                 virtual_machine_image: Optional[pulumi.Input['VirtualMachineImageArgs']] = None,
                 vm_priority: Optional[pulumi.Input[Union[str, 'VmPriority']]] = None,
                 vm_size: Optional[pulumi.Input[str]] = None):
        """
        AML Compute properties
        :param pulumi.Input[bool] enable_node_public_ip: Enable or disable node public IP address provisioning. Possible values are: Possible values are: true - Indicates that the compute nodes will have public IPs provisioned. false - Indicates that the compute nodes will have a private endpoint and no public IPs.
        :param pulumi.Input[bool] isolated_network: Network is isolated or not
        :param pulumi.Input[Union[str, 'OsType']] os_type: Compute OS Type
        :param Any property_bag: A property bag containing additional properties.
        :param pulumi.Input[Union[str, 'RemoteLoginPortPublicAccess']] remote_login_port_public_access: State of the public SSH port. Possible values are: Disabled - Indicates that the public ssh port is closed on all nodes of the cluster. Enabled - Indicates that the public ssh port is open on all nodes of the cluster. NotSpecified - Indicates that the public ssh port is closed on all nodes of the cluster if VNet is defined, else is open all public nodes. It can be default only during cluster creation time, after creation it will be either enabled or disabled.
        :param pulumi.Input['ScaleSettingsArgs'] scale_settings: Scale settings for AML Compute
        :param pulumi.Input['ResourceIdArgs'] subnet: Virtual network subnet resource ID the compute nodes belong to.
        :param pulumi.Input['UserAccountCredentialsArgs'] user_account_credentials: Credentials for an administrator user account that will be created on each compute node.
        :param pulumi.Input['VirtualMachineImageArgs'] virtual_machine_image: Virtual Machine image for AML Compute - windows only
        :param pulumi.Input[Union[str, 'VmPriority']] vm_priority: Virtual Machine priority
        :param pulumi.Input[str] vm_size: Virtual Machine Size
        """
        if enable_node_public_ip is None:
            enable_node_public_ip = True
        if enable_node_public_ip is not None:
            pulumi.set(__self__, "enable_node_public_ip", enable_node_public_ip)
        if isolated_network is not None:
            pulumi.set(__self__, "isolated_network", isolated_network)
        if os_type is None:
            os_type = 'Linux'
        if os_type is not None:
            pulumi.set(__self__, "os_type", os_type)
        if property_bag is not None:
            pulumi.set(__self__, "property_bag", property_bag)
        if remote_login_port_public_access is None:
            remote_login_port_public_access = 'NotSpecified'
        if remote_login_port_public_access is not None:
            pulumi.set(__self__, "remote_login_port_public_access", remote_login_port_public_access)
        if scale_settings is not None:
            pulumi.set(__self__, "scale_settings", scale_settings)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)
        if user_account_credentials is not None:
            pulumi.set(__self__, "user_account_credentials", user_account_credentials)
        if virtual_machine_image is not None:
            pulumi.set(__self__, "virtual_machine_image", virtual_machine_image)
        if vm_priority is not None:
            pulumi.set(__self__, "vm_priority", vm_priority)
        if vm_size is not None:
            pulumi.set(__self__, "vm_size", vm_size)

    @property
    @pulumi.getter(name="enableNodePublicIp")
    def enable_node_public_ip(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable or disable node public IP address provisioning. Possible values are: Possible values are: true - Indicates that the compute nodes will have public IPs provisioned. false - Indicates that the compute nodes will have a private endpoint and no public IPs.
        """
        return pulumi.get(self, "enable_node_public_ip")

    @enable_node_public_ip.setter
    def enable_node_public_ip(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_node_public_ip", value)

    @property
    @pulumi.getter(name="isolatedNetwork")
    def isolated_network(self) -> Optional[pulumi.Input[bool]]:
        """
        Network is isolated or not
        """
        return pulumi.get(self, "isolated_network")

    @isolated_network.setter
    def isolated_network(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "isolated_network", value)

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> Optional[pulumi.Input[Union[str, 'OsType']]]:
        """
        Compute OS Type
        """
        return pulumi.get(self, "os_type")

    @os_type.setter
    def os_type(self, value: Optional[pulumi.Input[Union[str, 'OsType']]]):
        pulumi.set(self, "os_type", value)

    @property
    @pulumi.getter(name="propertyBag")
    def property_bag(self) -> Optional[Any]:
        """
        A property bag containing additional properties.
        """
        return pulumi.get(self, "property_bag")

    @property_bag.setter
    def property_bag(self, value: Optional[Any]):
        pulumi.set(self, "property_bag", value)

    @property
    @pulumi.getter(name="remoteLoginPortPublicAccess")
    def remote_login_port_public_access(self) -> Optional[pulumi.Input[Union[str, 'RemoteLoginPortPublicAccess']]]:
        """
        State of the public SSH port. Possible values are: Disabled - Indicates that the public ssh port is closed on all nodes of the cluster. Enabled - Indicates that the public ssh port is open on all nodes of the cluster. NotSpecified - Indicates that the public ssh port is closed on all nodes of the cluster if VNet is defined, else is open all public nodes. It can be default only during cluster creation time, after creation it will be either enabled or disabled.
        """
        return pulumi.get(self, "remote_login_port_public_access")

    @remote_login_port_public_access.setter
    def remote_login_port_public_access(self, value: Optional[pulumi.Input[Union[str, 'RemoteLoginPortPublicAccess']]]):
        pulumi.set(self, "remote_login_port_public_access", value)

    @property
    @pulumi.getter(name="scaleSettings")
    def scale_settings(self) -> Optional[pulumi.Input['ScaleSettingsArgs']]:
        """
        Scale settings for AML Compute
        """
        return pulumi.get(self, "scale_settings")

    @scale_settings.setter
    def scale_settings(self, value: Optional[pulumi.Input['ScaleSettingsArgs']]):
        pulumi.set(self, "scale_settings", value)

    @property
    @pulumi.getter
    def subnet(self) -> Optional[pulumi.Input['ResourceIdArgs']]:
        """
        Virtual network subnet resource ID the compute nodes belong to.
        """
        return pulumi.get(self, "subnet")

    @subnet.setter
    def subnet(self, value: Optional[pulumi.Input['ResourceIdArgs']]):
        pulumi.set(self, "subnet", value)

    @property
    @pulumi.getter(name="userAccountCredentials")
    def user_account_credentials(self) -> Optional[pulumi.Input['UserAccountCredentialsArgs']]:
        """
        Credentials for an administrator user account that will be created on each compute node.
        """
        return pulumi.get(self, "user_account_credentials")

    @user_account_credentials.setter
    def user_account_credentials(self, value: Optional[pulumi.Input['UserAccountCredentialsArgs']]):
        pulumi.set(self, "user_account_credentials", value)

    @property
    @pulumi.getter(name="virtualMachineImage")
    def virtual_machine_image(self) -> Optional[pulumi.Input['VirtualMachineImageArgs']]:
        """
        Virtual Machine image for AML Compute - windows only
        """
        return pulumi.get(self, "virtual_machine_image")

    @virtual_machine_image.setter
    def virtual_machine_image(self, value: Optional[pulumi.Input['VirtualMachineImageArgs']]):
        pulumi.set(self, "virtual_machine_image", value)

    @property
    @pulumi.getter(name="vmPriority")
    def vm_priority(self) -> Optional[pulumi.Input[Union[str, 'VmPriority']]]:
        """
        Virtual Machine priority
        """
        return pulumi.get(self, "vm_priority")

    @vm_priority.setter
    def vm_priority(self, value: Optional[pulumi.Input[Union[str, 'VmPriority']]]):
        pulumi.set(self, "vm_priority", value)

    @property
    @pulumi.getter(name="vmSize")
    def vm_size(self) -> Optional[pulumi.Input[str]]:
        """
        Virtual Machine Size
        """
        return pulumi.get(self, "vm_size")

    @vm_size.setter
    def vm_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vm_size", value)


@pulumi.input_type
class AmlComputeArgs:
    def __init__(__self__, *,
                 compute_type: pulumi.Input[str],
                 compute_location: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disable_local_auth: Optional[pulumi.Input[bool]] = None,
                 properties: Optional[pulumi.Input['AmlComputePropertiesArgs']] = None,
                 resource_id: Optional[pulumi.Input[str]] = None):
        """
        An Azure Machine Learning compute.
        :param pulumi.Input[str] compute_type: The type of compute
               Expected value is 'AmlCompute'.
        :param pulumi.Input[str] compute_location: Location for the underlying compute
        :param pulumi.Input[str] description: The description of the Machine Learning compute.
        :param pulumi.Input[bool] disable_local_auth: Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
        :param pulumi.Input['AmlComputePropertiesArgs'] properties: Properties of AmlCompute
        :param pulumi.Input[str] resource_id: ARM resource id of the underlying compute
        """
        pulumi.set(__self__, "compute_type", 'AmlCompute')
        if compute_location is not None:
            pulumi.set(__self__, "compute_location", compute_location)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_local_auth is not None:
            pulumi.set(__self__, "disable_local_auth", disable_local_auth)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="computeType")
    def compute_type(self) -> pulumi.Input[str]:
        """
        The type of compute
        Expected value is 'AmlCompute'.
        """
        return pulumi.get(self, "compute_type")

    @compute_type.setter
    def compute_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "compute_type", value)

    @property
    @pulumi.getter(name="computeLocation")
    def compute_location(self) -> Optional[pulumi.Input[str]]:
        """
        Location for the underlying compute
        """
        return pulumi.get(self, "compute_location")

    @compute_location.setter
    def compute_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compute_location", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the Machine Learning compute.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="disableLocalAuth")
    def disable_local_auth(self) -> Optional[pulumi.Input[bool]]:
        """
        Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
        """
        return pulumi.get(self, "disable_local_auth")

    @disable_local_auth.setter
    def disable_local_auth(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_local_auth", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input['AmlComputePropertiesArgs']]:
        """
        Properties of AmlCompute
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input['AmlComputePropertiesArgs']]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM resource id of the underlying compute
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_id", value)


@pulumi.input_type
class AmlTokenArgs:
    def __init__(__self__, *,
                 identity_type: pulumi.Input[str]):
        """
        AML Token identity configuration.
        :param pulumi.Input[str] identity_type: Enum to determine identity framework.
               Expected value is 'AMLToken'.
        """
        pulumi.set(__self__, "identity_type", 'AMLToken')

    @property
    @pulumi.getter(name="identityType")
    def identity_type(self) -> pulumi.Input[str]:
        """
        Enum to determine identity framework.
        Expected value is 'AMLToken'.
        """
        return pulumi.get(self, "identity_type")

    @identity_type.setter
    def identity_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "identity_type", value)


@pulumi.input_type
class ArmResourceIdArgs:
    def __init__(__self__, *,
                 resource_id: Optional[pulumi.Input[str]] = None):
        """
        ARM ResourceId of a resource
        :param pulumi.Input[str] resource_id: Arm ResourceId is in the format "/subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/providers/Microsoft.Storage/storageAccounts/{StorageAccountName}"
               or "/subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{AcrName}"
        """
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        Arm ResourceId is in the format "/subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/providers/Microsoft.Storage/storageAccounts/{StorageAccountName}"
        or "/subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{AcrName}"
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_id", value)


@pulumi.input_type
class AssignedUserArgs:
    def __init__(__self__, *,
                 object_id: pulumi.Input[str],
                 tenant_id: pulumi.Input[str]):
        """
        A user that can be assigned to a compute instance.
        :param pulumi.Input[str] object_id: User’s AAD Object Id.
        :param pulumi.Input[str] tenant_id: User’s AAD Tenant Id.
        """
        pulumi.set(__self__, "object_id", object_id)
        pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="objectId")
    def object_id(self) -> pulumi.Input[str]:
        """
        User’s AAD Object Id.
        """
        return pulumi.get(self, "object_id")

    @object_id.setter
    def object_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "object_id", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        User’s AAD Tenant Id.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)


@pulumi.input_type
class AutoForecastHorizonArgs:
    def __init__(__self__, *,
                 mode: pulumi.Input[str]):
        """
        Forecast horizon determined automatically by system.
        :param pulumi.Input[str] mode: Enum to determine forecast horizon selection mode.
               Expected value is 'Auto'.
        """
        pulumi.set(__self__, "mode", 'Auto')

    @property
    @pulumi.getter
    def mode(self) -> pulumi.Input[str]:
        """
        Enum to determine forecast horizon selection mode.
        Expected value is 'Auto'.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: pulumi.Input[str]):
        pulumi.set(self, "mode", value)


@pulumi.input_type
class AutoMLJobArgs:
    def __init__(__self__, *,
                 job_type: pulumi.Input[str],
                 task_details: pulumi.Input[Union['ClassificationArgs', 'ForecastingArgs', 'ImageClassificationArgs', 'ImageClassificationMultilabelArgs', 'ImageInstanceSegmentationArgs', 'ImageObjectDetectionArgs', 'RegressionArgs', 'TextClassificationArgs', 'TextClassificationMultilabelArgs', 'TextNerArgs']],
                 component_id: Optional[pulumi.Input[str]] = None,
                 compute_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 environment_id: Optional[pulumi.Input[str]] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 experiment_name: Optional[pulumi.Input[str]] = None,
                 identity: Optional[pulumi.Input[Union['AmlTokenArgs', 'ManagedIdentityArgs', 'UserIdentityArgs']]] = None,
                 is_archived: Optional[pulumi.Input[bool]] = None,
                 outputs: Optional[pulumi.Input[Mapping[str, pulumi.Input[Union['CustomModelJobOutputArgs', 'MLFlowModelJobOutputArgs', 'MLTableJobOutputArgs', 'TritonModelJobOutputArgs', 'UriFileJobOutputArgs', 'UriFolderJobOutputArgs']]]]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 resources: Optional[pulumi.Input['JobResourceConfigurationArgs']] = None,
                 services: Optional[pulumi.Input[Mapping[str, pulumi.Input['JobServiceArgs']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        AutoMLJob class.
        Use this class for executing AutoML tasks like Classification/Regression etc.
        See TaskType enum for all the tasks supported.
        :param pulumi.Input[str] job_type: Enum to determine the type of job.
               Expected value is 'AutoML'.
        :param pulumi.Input[Union['ClassificationArgs', 'ForecastingArgs', 'ImageClassificationArgs', 'ImageClassificationMultilabelArgs', 'ImageInstanceSegmentationArgs', 'ImageObjectDetectionArgs', 'RegressionArgs', 'TextClassificationArgs', 'TextClassificationMultilabelArgs', 'TextNerArgs']] task_details: [Required] This represents scenario which can be one of Tables/NLP/Image
        :param pulumi.Input[str] component_id: ARM resource ID of the component resource.
        :param pulumi.Input[str] compute_id: ARM resource ID of the compute resource.
        :param pulumi.Input[str] description: The asset description text.
        :param pulumi.Input[str] display_name: Display name of job.
        :param pulumi.Input[str] environment_id: The ARM resource ID of the Environment specification for the job.
               This is optional value to provide, if not provided, AutoML will default this to Production AutoML curated environment version when running the job.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] environment_variables: Environment variables included in the job.
        :param pulumi.Input[str] experiment_name: The name of the experiment the job belongs to. If not set, the job is placed in the "Default" experiment.
        :param pulumi.Input[Union['AmlTokenArgs', 'ManagedIdentityArgs', 'UserIdentityArgs']] identity: Identity configuration. If set, this should be one of AmlToken, ManagedIdentity, UserIdentity or null.
               Defaults to AmlToken if null.
        :param pulumi.Input[bool] is_archived: Is the asset archived?
        :param pulumi.Input[Mapping[str, pulumi.Input[Union['CustomModelJobOutputArgs', 'MLFlowModelJobOutputArgs', 'MLTableJobOutputArgs', 'TritonModelJobOutputArgs', 'UriFileJobOutputArgs', 'UriFolderJobOutputArgs']]]] outputs: Mapping of output data bindings used in the job.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: The asset property dictionary.
        :param pulumi.Input['JobResourceConfigurationArgs'] resources: Compute Resource configuration for the job.
        :param pulumi.Input[Mapping[str, pulumi.Input['JobServiceArgs']]] services: List of JobEndpoints.
               For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Tag dictionary. Tags can be added, removed, and updated.
        """
        pulumi.set(__self__, "job_type", 'AutoML')
        pulumi.set(__self__, "task_details", task_details)
        if component_id is not None:
            pulumi.set(__self__, "component_id", component_id)
        if compute_id is not None:
            pulumi.set(__self__, "compute_id", compute_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if environment_id is not None:
            pulumi.set(__self__, "environment_id", environment_id)
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if experiment_name is None:
            experiment_name = 'Default'
        if experiment_name is not None:
            pulumi.set(__self__, "experiment_name", experiment_name)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if is_archived is None:
            is_archived = False
        if is_archived is not None:
            pulumi.set(__self__, "is_archived", is_archived)
        if outputs is not None:
            pulumi.set(__self__, "outputs", outputs)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)
        if services is not None:
            pulumi.set(__self__, "services", services)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="jobType")
    def job_type(self) -> pulumi.Input[str]:
        """
        Enum to determine the type of job.
        Expected value is 'AutoML'.
        """
        return pulumi.get(self, "job_type")

    @job_type.setter
    def job_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "job_type", value)

    @property
    @pulumi.getter(name="taskDetails")
    def task_details(self) -> pulumi.Input[Union['ClassificationArgs', 'ForecastingArgs', 'ImageClassificationArgs', 'ImageClassificationMultilabelArgs', 'ImageInstanceSegmentationArgs', 'ImageObjectDetectionArgs', 'RegressionArgs', 'TextClassificationArgs', 'TextClassificationMultilabelArgs', 'TextNerArgs']]:
        """
        [Required] This represents scenario which can be one of Tables/NLP/Image
        """
        return pulumi.get(self, "task_details")

    @task_details.setter
    def task_details(self, value: pulumi.Input[Union['ClassificationArgs', 'ForecastingArgs', 'ImageClassificationArgs', 'ImageClassificationMultilabelArgs', 'ImageInstanceSegmentationArgs', 'ImageObjectDetectionArgs', 'RegressionArgs', 'TextClassificationArgs', 'TextClassificationMultilabelArgs', 'TextNerArgs']]):
        pulumi.set(self, "task_details", value)

    @property
    @pulumi.getter(name="componentId")
    def component_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM resource ID of the component resource.
        """
        return pulumi.get(self, "component_id")

    @component_id.setter
    def component_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "component_id", value)

    @property
    @pulumi.getter(name="computeId")
    def compute_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM resource ID of the compute resource.
        """
        return pulumi.get(self, "compute_id")

    @compute_id.setter
    def compute_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compute_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The asset description text.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        Display name of job.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ARM resource ID of the Environment specification for the job.
        This is optional value to provide, if not provided, AutoML will default this to Production AutoML curated environment version when running the job.
        """
        return pulumi.get(self, "environment_id")

    @environment_id.setter
    def environment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "environment_id", value)

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Environment variables included in the job.
        """
        return pulumi.get(self, "environment_variables")

    @environment_variables.setter
    def environment_variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "environment_variables", value)

    @property
    @pulumi.getter(name="experimentName")
    def experiment_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the experiment the job belongs to. If not set, the job is placed in the "Default" experiment.
        """
        return pulumi.get(self, "experiment_name")

    @experiment_name.setter
    def experiment_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "experiment_name", value)

    @property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input[Union['AmlTokenArgs', 'ManagedIdentityArgs', 'UserIdentityArgs']]]:
        """
        Identity configuration. If set, this should be one of AmlToken, ManagedIdentity, UserIdentity or null.
        Defaults to AmlToken if null.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input[Union['AmlTokenArgs', 'ManagedIdentityArgs', 'UserIdentityArgs']]]):
        pulumi.set(self, "identity", value)

    @property
    @pulumi.getter(name="isArchived")
    def is_archived(self) -> Optional[pulumi.Input[bool]]:
        """
        Is the asset archived?
        """
        return pulumi.get(self, "is_archived")

    @is_archived.setter
    def is_archived(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_archived", value)

    @property
    @pulumi.getter
    def outputs(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[Union['CustomModelJobOutputArgs', 'MLFlowModelJobOutputArgs', 'MLTableJobOutputArgs', 'TritonModelJobOutputArgs', 'UriFileJobOutputArgs', 'UriFolderJobOutputArgs']]]]]:
        """
        Mapping of output data bindings used in the job.
        """
        return pulumi.get(self, "outputs")

    @outputs.setter
    def outputs(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[Union['CustomModelJobOutputArgs', 'MLFlowModelJobOutputArgs', 'MLTableJobOutputArgs', 'TritonModelJobOutputArgs', 'UriFileJobOutputArgs', 'UriFolderJobOutputArgs']]]]]):
        pulumi.set(self, "outputs", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The asset property dictionary.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter
    def resources(self) -> Optional[pulumi.Input['JobResourceConfigurationArgs']]:
        """
        Compute Resource configuration for the job.
        """
        return pulumi.get(self, "resources")

    @resources.setter
    def resources(self, value: Optional[pulumi.Input['JobResourceConfigurationArgs']]):
        pulumi.set(self, "resources", value)

    @property
    @pulumi.getter
    def services(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['JobServiceArgs']]]]:
        """
        List of JobEndpoints.
        For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
        """
        return pulumi.get(self, "services")

    @services.setter
    def services(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['JobServiceArgs']]]]):
        pulumi.set(self, "services", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Tag dictionary. Tags can be added, removed, and updated.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class AutoNCrossValidationsArgs:
    def __init__(__self__, *,
                 mode: pulumi.Input[str]):
        """
        N-Cross validations determined automatically.
        :param pulumi.Input[str] mode: Determines how N-Cross validations value is determined.
               Expected value is 'Auto'.
        """
        pulumi.set(__self__, "mode", 'Auto')

    @property
    @pulumi.getter
    def mode(self) -> pulumi.Input[str]:
        """
        Determines how N-Cross validations value is determined.
        Expected value is 'Auto'.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: pulumi.Input[str]):
        pulumi.set(self, "mode", value)


@pulumi.input_type
class AutoPausePropertiesArgs:
    def __init__(__self__, *,
                 delay_in_minutes: Optional[pulumi.Input[int]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None):
        """
        Auto pause properties
        """
        if delay_in_minutes is not None:
            pulumi.set(__self__, "delay_in_minutes", delay_in_minutes)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter(name="delayInMinutes")
    def delay_in_minutes(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "delay_in_minutes")

    @delay_in_minutes.setter
    def delay_in_minutes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "delay_in_minutes", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)


@pulumi.input_type
class AutoScalePropertiesArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 max_node_count: Optional[pulumi.Input[int]] = None,
                 min_node_count: Optional[pulumi.Input[int]] = None):
        """
        Auto scale properties
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if max_node_count is not None:
            pulumi.set(__self__, "max_node_count", max_node_count)
        if min_node_count is not None:
            pulumi.set(__self__, "min_node_count", min_node_count)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="maxNodeCount")
    def max_node_count(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "max_node_count")

    @max_node_count.setter
    def max_node_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_node_count", value)

    @property
    @pulumi.getter(name="minNodeCount")
    def min_node_count(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "min_node_count")

    @min_node_count.setter
    def min_node_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_node_count", value)


@pulumi.input_type
class AutoSeasonalityArgs:
    def __init__(__self__, *,
                 mode: pulumi.Input[str]):
        """
        :param pulumi.Input[str] mode: Forecasting seasonality mode.
               Expected value is 'Auto'.
        """
        pulumi.set(__self__, "mode", 'Auto')

    @property
    @pulumi.getter
    def mode(self) -> pulumi.Input[str]:
        """
        Forecasting seasonality mode.
        Expected value is 'Auto'.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: pulumi.Input[str]):
        pulumi.set(self, "mode", value)


@pulumi.input_type
class AutoTargetLagsArgs:
    def __init__(__self__, *,
                 mode: pulumi.Input[str]):
        """
        :param pulumi.Input[str] mode: Target lags selection modes.
               Expected value is 'Auto'.
        """
        pulumi.set(__self__, "mode", 'Auto')

    @property
    @pulumi.getter
    def mode(self) -> pulumi.Input[str]:
        """
        Target lags selection modes.
        Expected value is 'Auto'.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: pulumi.Input[str]):
        pulumi.set(self, "mode", value)


@pulumi.input_type
class AutoTargetRollingWindowSizeArgs:
    def __init__(__self__, *,
                 mode: pulumi.Input[str]):
        """
        Target lags rolling window determined automatically.
        :param pulumi.Input[str] mode: Target rolling windows size mode.
               Expected value is 'Auto'.
        """
        pulumi.set(__self__, "mode", 'Auto')

    @property
    @pulumi.getter
    def mode(self) -> pulumi.Input[str]:
        """
        Target rolling windows size mode.
        Expected value is 'Auto'.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: pulumi.Input[str]):
        pulumi.set(self, "mode", value)


@pulumi.input_type
class AutologgerSettingsArgs:
    def __init__(__self__, *,
                 mlflow_autologger: pulumi.Input[Union[str, 'MLFlowAutologgerState']]):
        """
        Settings for Autologger.
        :param pulumi.Input[Union[str, 'MLFlowAutologgerState']] mlflow_autologger: [Required] Indicates whether mlflow autologger is enabled.
        """
        pulumi.set(__self__, "mlflow_autologger", mlflow_autologger)

    @property
    @pulumi.getter(name="mlflowAutologger")
    def mlflow_autologger(self) -> pulumi.Input[Union[str, 'MLFlowAutologgerState']]:
        """
        [Required] Indicates whether mlflow autologger is enabled.
        """
        return pulumi.get(self, "mlflow_autologger")

    @mlflow_autologger.setter
    def mlflow_autologger(self, value: pulumi.Input[Union[str, 'MLFlowAutologgerState']]):
        pulumi.set(self, "mlflow_autologger", value)


@pulumi.input_type
class AzureBlobDatastoreArgs:
    def __init__(__self__, *,
                 credentials: pulumi.Input[Union['AccountKeyDatastoreCredentialsArgs', 'CertificateDatastoreCredentialsArgs', 'KerberosKeytabCredentialsArgs', 'KerberosPasswordCredentialsArgs', 'NoneDatastoreCredentialsArgs', 'SasDatastoreCredentialsArgs', 'ServicePrincipalDatastoreCredentialsArgs']],
                 datastore_type: pulumi.Input[str],
                 account_name: Optional[pulumi.Input[str]] = None,
                 container_name: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 endpoint: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 resource_group: Optional[pulumi.Input[str]] = None,
                 service_data_access_auth_identity: Optional[pulumi.Input[Union[str, 'ServiceDataAccessAuthIdentity']]] = None,
                 subscription_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Azure Blob datastore configuration.
        :param pulumi.Input[Union['AccountKeyDatastoreCredentialsArgs', 'CertificateDatastoreCredentialsArgs', 'KerberosKeytabCredentialsArgs', 'KerberosPasswordCredentialsArgs', 'NoneDatastoreCredentialsArgs', 'SasDatastoreCredentialsArgs', 'ServicePrincipalDatastoreCredentialsArgs']] credentials: [Required] Account credentials.
        :param pulumi.Input[str] datastore_type: Enum to determine the datastore contents type.
               Expected value is 'AzureBlob'.
        :param pulumi.Input[str] account_name: Storage account name.
        :param pulumi.Input[str] container_name: Storage account container name.
        :param pulumi.Input[str] description: The asset description text.
        :param pulumi.Input[str] endpoint: Azure cloud endpoint for the storage account.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: The asset property dictionary.
        :param pulumi.Input[str] protocol: Protocol used to communicate with the storage account.
        :param pulumi.Input[str] resource_group: Azure Resource Group name
        :param pulumi.Input[Union[str, 'ServiceDataAccessAuthIdentity']] service_data_access_auth_identity: Indicates which identity to use to authenticate service data access to customer's storage.
        :param pulumi.Input[str] subscription_id: Azure Subscription Id
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Tag dictionary. Tags can be added, removed, and updated.
        """
        pulumi.set(__self__, "credentials", credentials)
        pulumi.set(__self__, "datastore_type", 'AzureBlob')
        if account_name is not None:
            pulumi.set(__self__, "account_name", account_name)
        if container_name is not None:
            pulumi.set(__self__, "container_name", container_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if resource_group is not None:
            pulumi.set(__self__, "resource_group", resource_group)
        if service_data_access_auth_identity is None:
            service_data_access_auth_identity = 'None'
        if service_data_access_auth_identity is not None:
            pulumi.set(__self__, "service_data_access_auth_identity", service_data_access_auth_identity)
        if subscription_id is not None:
            pulumi.set(__self__, "subscription_id", subscription_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def credentials(self) -> pulumi.Input[Union['AccountKeyDatastoreCredentialsArgs', 'CertificateDatastoreCredentialsArgs', 'KerberosKeytabCredentialsArgs', 'KerberosPasswordCredentialsArgs', 'NoneDatastoreCredentialsArgs', 'SasDatastoreCredentialsArgs', 'ServicePrincipalDatastoreCredentialsArgs']]:
        """
        [Required] Account credentials.
        """
        return pulumi.get(self, "credentials")

    @credentials.setter
    def credentials(self, value: pulumi.Input[Union['AccountKeyDatastoreCredentialsArgs', 'CertificateDatastoreCredentialsArgs', 'KerberosKeytabCredentialsArgs', 'KerberosPasswordCredentialsArgs', 'NoneDatastoreCredentialsArgs', 'SasDatastoreCredentialsArgs', 'ServicePrincipalDatastoreCredentialsArgs']]):
        pulumi.set(self, "credentials", value)

    @property
    @pulumi.getter(name="datastoreType")
    def datastore_type(self) -> pulumi.Input[str]:
        """
        Enum to determine the datastore contents type.
        Expected value is 'AzureBlob'.
        """
        return pulumi.get(self, "datastore_type")

    @datastore_type.setter
    def datastore_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "datastore_type", value)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> Optional[pulumi.Input[str]]:
        """
        Storage account name.
        """
        return pulumi.get(self, "account_name")

    @account_name.setter
    def account_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_name", value)

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> Optional[pulumi.Input[str]]:
        """
        Storage account container name.
        """
        return pulumi.get(self, "container_name")

    @container_name.setter
    def container_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "container_name", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The asset description text.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        Azure cloud endpoint for the storage account.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The asset property dictionary.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        Protocol used to communicate with the storage account.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> Optional[pulumi.Input[str]]:
        """
        Azure Resource Group name
        """
        return pulumi.get(self, "resource_group")

    @resource_group.setter
    def resource_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group", value)

    @property
    @pulumi.getter(name="serviceDataAccessAuthIdentity")
    def service_data_access_auth_identity(self) -> Optional[pulumi.Input[Union[str, 'ServiceDataAccessAuthIdentity']]]:
        """
        Indicates which identity to use to authenticate service data access to customer's storage.
        """
        return pulumi.get(self, "service_data_access_auth_identity")

    @service_data_access_auth_identity.setter
    def service_data_access_auth_identity(self, value: Optional[pulumi.Input[Union[str, 'ServiceDataAccessAuthIdentity']]]):
        pulumi.set(self, "service_data_access_auth_identity", value)

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> Optional[pulumi.Input[str]]:
        """
        Azure Subscription Id
        """
        return pulumi.get(self, "subscription_id")

    @subscription_id.setter
    def subscription_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subscription_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Tag dictionary. Tags can be added, removed, and updated.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class AzureDataLakeGen1DatastoreArgs:
    def __init__(__self__, *,
                 credentials: pulumi.Input[Union['AccountKeyDatastoreCredentialsArgs', 'CertificateDatastoreCredentialsArgs', 'KerberosKeytabCredentialsArgs', 'KerberosPasswordCredentialsArgs', 'NoneDatastoreCredentialsArgs', 'SasDatastoreCredentialsArgs', 'ServicePrincipalDatastoreCredentialsArgs']],
                 datastore_type: pulumi.Input[str],
                 store_name: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 resource_group: Optional[pulumi.Input[str]] = None,
                 service_data_access_auth_identity: Optional[pulumi.Input[Union[str, 'ServiceDataAccessAuthIdentity']]] = None,
                 subscription_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Azure Data Lake Gen1 datastore configuration.
        :param pulumi.Input[Union['AccountKeyDatastoreCredentialsArgs', 'CertificateDatastoreCredentialsArgs', 'KerberosKeytabCredentialsArgs', 'KerberosPasswordCredentialsArgs', 'NoneDatastoreCredentialsArgs', 'SasDatastoreCredentialsArgs', 'ServicePrincipalDatastoreCredentialsArgs']] credentials: [Required] Account credentials.
        :param pulumi.Input[str] datastore_type: Enum to determine the datastore contents type.
               Expected value is 'AzureDataLakeGen1'.
        :param pulumi.Input[str] store_name: [Required] Azure Data Lake store name.
        :param pulumi.Input[str] description: The asset description text.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: The asset property dictionary.
        :param pulumi.Input[str] resource_group: Azure Resource Group name
        :param pulumi.Input[Union[str, 'ServiceDataAccessAuthIdentity']] service_data_access_auth_identity: Indicates which identity to use to authenticate service data access to customer's storage.
        :param pulumi.Input[str] subscription_id: Azure Subscription Id
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Tag dictionary. Tags can be added, removed, and updated.
        """
        pulumi.set(__self__, "credentials", credentials)
        pulumi.set(__self__, "datastore_type", 'AzureDataLakeGen1')
        pulumi.set(__self__, "store_name", store_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if resource_group is not None:
            pulumi.set(__self__, "resource_group", resource_group)
        if service_data_access_auth_identity is None:
            service_data_access_auth_identity = 'None'
        if service_data_access_auth_identity is not None:
            pulumi.set(__self__, "service_data_access_auth_identity", service_data_access_auth_identity)
        if subscription_id is not None:
            pulumi.set(__self__, "subscription_id", subscription_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def credentials(self) -> pulumi.Input[Union['AccountKeyDatastoreCredentialsArgs', 'CertificateDatastoreCredentialsArgs', 'KerberosKeytabCredentialsArgs', 'KerberosPasswordCredentialsArgs', 'NoneDatastoreCredentialsArgs', 'SasDatastoreCredentialsArgs', 'ServicePrincipalDatastoreCredentialsArgs']]:
        """
        [Required] Account credentials.
        """
        return pulumi.get(self, "credentials")

    @credentials.setter
    def credentials(self, value: pulumi.Input[Union['AccountKeyDatastoreCredentialsArgs', 'CertificateDatastoreCredentialsArgs', 'KerberosKeytabCredentialsArgs', 'KerberosPasswordCredentialsArgs', 'NoneDatastoreCredentialsArgs', 'SasDatastoreCredentialsArgs', 'ServicePrincipalDatastoreCredentialsArgs']]):
        pulumi.set(self, "credentials", value)

    @property
    @pulumi.getter(name="datastoreType")
    def datastore_type(self) -> pulumi.Input[str]:
        """
        Enum to determine the datastore contents type.
        Expected value is 'AzureDataLakeGen1'.
        """
        return pulumi.get(self, "datastore_type")

    @datastore_type.setter
    def datastore_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "datastore_type", value)

    @property
    @pulumi.getter(name="storeName")
    def store_name(self) -> pulumi.Input[str]:
        """
        [Required] Azure Data Lake store name.
        """
        return pulumi.get(self, "store_name")

    @store_name.setter
    def store_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "store_name", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The asset description text.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The asset property dictionary.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> Optional[pulumi.Input[str]]:
        """
        Azure Resource Group name
        """
        return pulumi.get(self, "resource_group")

    @resource_group.setter
    def resource_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group", value)

    @property
    @pulumi.getter(name="serviceDataAccessAuthIdentity")
    def service_data_access_auth_identity(self) -> Optional[pulumi.Input[Union[str, 'ServiceDataAccessAuthIdentity']]]:
        """
        Indicates which identity to use to authenticate service data access to customer's storage.
        """
        return pulumi.get(self, "service_data_access_auth_identity")

    @service_data_access_auth_identity.setter
    def service_data_access_auth_identity(self, value: Optional[pulumi.Input[Union[str, 'ServiceDataAccessAuthIdentity']]]):
        pulumi.set(self, "service_data_access_auth_identity", value)

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> Optional[pulumi.Input[str]]:
        """
        Azure Subscription Id
        """
        return pulumi.get(self, "subscription_id")

    @subscription_id.setter
    def subscription_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subscription_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Tag dictionary. Tags can be added, removed, and updated.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class AzureDataLakeGen2DatastoreArgs:
    def __init__(__self__, *,
                 account_name: pulumi.Input[str],
                 credentials: pulumi.Input[Union['AccountKeyDatastoreCredentialsArgs', 'CertificateDatastoreCredentialsArgs', 'KerberosKeytabCredentialsArgs', 'KerberosPasswordCredentialsArgs', 'NoneDatastoreCredentialsArgs', 'SasDatastoreCredentialsArgs', 'ServicePrincipalDatastoreCredentialsArgs']],
                 datastore_type: pulumi.Input[str],
                 filesystem: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 endpoint: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 resource_group: Optional[pulumi.Input[str]] = None,
                 service_data_access_auth_identity: Optional[pulumi.Input[Union[str, 'ServiceDataAccessAuthIdentity']]] = None,
                 subscription_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Azure Data Lake Gen2 datastore configuration.
        :param pulumi.Input[str] account_name: [Required] Storage account name.
        :param pulumi.Input[Union['AccountKeyDatastoreCredentialsArgs', 'CertificateDatastoreCredentialsArgs', 'KerberosKeytabCredentialsArgs', 'KerberosPasswordCredentialsArgs', 'NoneDatastoreCredentialsArgs', 'SasDatastoreCredentialsArgs', 'ServicePrincipalDatastoreCredentialsArgs']] credentials: [Required] Account credentials.
        :param pulumi.Input[str] datastore_type: Enum to determine the datastore contents type.
               Expected value is 'AzureDataLakeGen2'.
        :param pulumi.Input[str] filesystem: [Required] The name of the Data Lake Gen2 filesystem.
        :param pulumi.Input[str] description: The asset description text.
        :param pulumi.Input[str] endpoint: Azure cloud endpoint for the storage account.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: The asset property dictionary.
        :param pulumi.Input[str] protocol: Protocol used to communicate with the storage account.
        :param pulumi.Input[str] resource_group: Azure Resource Group name
        :param pulumi.Input[Union[str, 'ServiceDataAccessAuthIdentity']] service_data_access_auth_identity: Indicates which identity to use to authenticate service data access to customer's storage.
        :param pulumi.Input[str] subscription_id: Azure Subscription Id
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Tag dictionary. Tags can be added, removed, and updated.
        """
        pulumi.set(__self__, "account_name", account_name)
        pulumi.set(__self__, "credentials", credentials)
        pulumi.set(__self__, "datastore_type", 'AzureDataLakeGen2')
        pulumi.set(__self__, "filesystem", filesystem)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if resource_group is not None:
            pulumi.set(__self__, "resource_group", resource_group)
        if service_data_access_auth_identity is None:
            service_data_access_auth_identity = 'None'
        if service_data_access_auth_identity is not None:
            pulumi.set(__self__, "service_data_access_auth_identity", service_data_access_auth_identity)
        if subscription_id is not None:
            pulumi.set(__self__, "subscription_id", subscription_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> pulumi.Input[str]:
        """
        [Required] Storage account name.
        """
        return pulumi.get(self, "account_name")

    @account_name.setter
    def account_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "account_name", value)

    @property
    @pulumi.getter
    def credentials(self) -> pulumi.Input[Union['AccountKeyDatastoreCredentialsArgs', 'CertificateDatastoreCredentialsArgs', 'KerberosKeytabCredentialsArgs', 'KerberosPasswordCredentialsArgs', 'NoneDatastoreCredentialsArgs', 'SasDatastoreCredentialsArgs', 'ServicePrincipalDatastoreCredentialsArgs']]:
        """
        [Required] Account credentials.
        """
        return pulumi.get(self, "credentials")

    @credentials.setter
    def credentials(self, value: pulumi.Input[Union['AccountKeyDatastoreCredentialsArgs', 'CertificateDatastoreCredentialsArgs', 'KerberosKeytabCredentialsArgs', 'KerberosPasswordCredentialsArgs', 'NoneDatastoreCredentialsArgs', 'SasDatastoreCredentialsArgs', 'ServicePrincipalDatastoreCredentialsArgs']]):
        pulumi.set(self, "credentials", value)

    @property
    @pulumi.getter(name="datastoreType")
    def datastore_type(self) -> pulumi.Input[str]:
        """
        Enum to determine the datastore contents type.
        Expected value is 'AzureDataLakeGen2'.
        """
        return pulumi.get(self, "datastore_type")

    @datastore_type.setter
    def datastore_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "datastore_type", value)

    @property
    @pulumi.getter
    def filesystem(self) -> pulumi.Input[str]:
        """
        [Required] The name of the Data Lake Gen2 filesystem.
        """
        return pulumi.get(self, "filesystem")

    @filesystem.setter
    def filesystem(self, value: pulumi.Input[str]):
        pulumi.set(self, "filesystem", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The asset description text.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        Azure cloud endpoint for the storage account.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The asset property dictionary.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        Protocol used to communicate with the storage account.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> Optional[pulumi.Input[str]]:
        """
        Azure Resource Group name
        """
        return pulumi.get(self, "resource_group")

    @resource_group.setter
    def resource_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group", value)

    @property
    @pulumi.getter(name="serviceDataAccessAuthIdentity")
    def service_data_access_auth_identity(self) -> Optional[pulumi.Input[Union[str, 'ServiceDataAccessAuthIdentity']]]:
        """
        Indicates which identity to use to authenticate service data access to customer's storage.
        """
        return pulumi.get(self, "service_data_access_auth_identity")

    @service_data_access_auth_identity.setter
    def service_data_access_auth_identity(self, value: Optional[pulumi.Input[Union[str, 'ServiceDataAccessAuthIdentity']]]):
        pulumi.set(self, "service_data_access_auth_identity", value)

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> Optional[pulumi.Input[str]]:
        """
        Azure Subscription Id
        """
        return pulumi.get(self, "subscription_id")

    @subscription_id.setter
    def subscription_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subscription_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Tag dictionary. Tags can be added, removed, and updated.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class AzureFileDatastoreArgs:
    def __init__(__self__, *,
                 account_name: pulumi.Input[str],
                 credentials: pulumi.Input[Union['AccountKeyDatastoreCredentialsArgs', 'CertificateDatastoreCredentialsArgs', 'KerberosKeytabCredentialsArgs', 'KerberosPasswordCredentialsArgs', 'NoneDatastoreCredentialsArgs', 'SasDatastoreCredentialsArgs', 'ServicePrincipalDatastoreCredentialsArgs']],
                 datastore_type: pulumi.Input[str],
                 file_share_name: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 endpoint: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 resource_group: Optional[pulumi.Input[str]] = None,
                 service_data_access_auth_identity: Optional[pulumi.Input[Union[str, 'ServiceDataAccessAuthIdentity']]] = None,
                 subscription_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Azure File datastore configuration.
        :param pulumi.Input[str] account_name: [Required] Storage account name.
        :param pulumi.Input[Union['AccountKeyDatastoreCredentialsArgs', 'CertificateDatastoreCredentialsArgs', 'KerberosKeytabCredentialsArgs', 'KerberosPasswordCredentialsArgs', 'NoneDatastoreCredentialsArgs', 'SasDatastoreCredentialsArgs', 'ServicePrincipalDatastoreCredentialsArgs']] credentials: [Required] Account credentials.
        :param pulumi.Input[str] datastore_type: Enum to determine the datastore contents type.
               Expected value is 'AzureFile'.
        :param pulumi.Input[str] file_share_name: [Required] The name of the Azure file share that the datastore points to.
        :param pulumi.Input[str] description: The asset description text.
        :param pulumi.Input[str] endpoint: Azure cloud endpoint for the storage account.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: The asset property dictionary.
        :param pulumi.Input[str] protocol: Protocol used to communicate with the storage account.
        :param pulumi.Input[str] resource_group: Azure Resource Group name
        :param pulumi.Input[Union[str, 'ServiceDataAccessAuthIdentity']] service_data_access_auth_identity: Indicates which identity to use to authenticate service data access to customer's storage.
        :param pulumi.Input[str] subscription_id: Azure Subscription Id
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Tag dictionary. Tags can be added, removed, and updated.
        """
        pulumi.set(__self__, "account_name", account_name)
        pulumi.set(__self__, "credentials", credentials)
        pulumi.set(__self__, "datastore_type", 'AzureFile')
        pulumi.set(__self__, "file_share_name", file_share_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if resource_group is not None:
            pulumi.set(__self__, "resource_group", resource_group)
        if service_data_access_auth_identity is None:
            service_data_access_auth_identity = 'None'
        if service_data_access_auth_identity is not None:
            pulumi.set(__self__, "service_data_access_auth_identity", service_data_access_auth_identity)
        if subscription_id is not None:
            pulumi.set(__self__, "subscription_id", subscription_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> pulumi.Input[str]:
        """
        [Required] Storage account name.
        """
        return pulumi.get(self, "account_name")

    @account_name.setter
    def account_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "account_name", value)

    @property
    @pulumi.getter
    def credentials(self) -> pulumi.Input[Union['AccountKeyDatastoreCredentialsArgs', 'CertificateDatastoreCredentialsArgs', 'KerberosKeytabCredentialsArgs', 'KerberosPasswordCredentialsArgs', 'NoneDatastoreCredentialsArgs', 'SasDatastoreCredentialsArgs', 'ServicePrincipalDatastoreCredentialsArgs']]:
        """
        [Required] Account credentials.
        """
        return pulumi.get(self, "credentials")

    @credentials.setter
    def credentials(self, value: pulumi.Input[Union['AccountKeyDatastoreCredentialsArgs', 'CertificateDatastoreCredentialsArgs', 'KerberosKeytabCredentialsArgs', 'KerberosPasswordCredentialsArgs', 'NoneDatastoreCredentialsArgs', 'SasDatastoreCredentialsArgs', 'ServicePrincipalDatastoreCredentialsArgs']]):
        pulumi.set(self, "credentials", value)

    @property
    @pulumi.getter(name="datastoreType")
    def datastore_type(self) -> pulumi.Input[str]:
        """
        Enum to determine the datastore contents type.
        Expected value is 'AzureFile'.
        """
        return pulumi.get(self, "datastore_type")

    @datastore_type.setter
    def datastore_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "datastore_type", value)

    @property
    @pulumi.getter(name="fileShareName")
    def file_share_name(self) -> pulumi.Input[str]:
        """
        [Required] The name of the Azure file share that the datastore points to.
        """
        return pulumi.get(self, "file_share_name")

    @file_share_name.setter
    def file_share_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "file_share_name", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The asset description text.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        Azure cloud endpoint for the storage account.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The asset property dictionary.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        Protocol used to communicate with the storage account.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> Optional[pulumi.Input[str]]:
        """
        Azure Resource Group name
        """
        return pulumi.get(self, "resource_group")

    @resource_group.setter
    def resource_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group", value)

    @property
    @pulumi.getter(name="serviceDataAccessAuthIdentity")
    def service_data_access_auth_identity(self) -> Optional[pulumi.Input[Union[str, 'ServiceDataAccessAuthIdentity']]]:
        """
        Indicates which identity to use to authenticate service data access to customer's storage.
        """
        return pulumi.get(self, "service_data_access_auth_identity")

    @service_data_access_auth_identity.setter
    def service_data_access_auth_identity(self, value: Optional[pulumi.Input[Union[str, 'ServiceDataAccessAuthIdentity']]]):
        pulumi.set(self, "service_data_access_auth_identity", value)

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> Optional[pulumi.Input[str]]:
        """
        Azure Subscription Id
        """
        return pulumi.get(self, "subscription_id")

    @subscription_id.setter
    def subscription_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subscription_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Tag dictionary. Tags can be added, removed, and updated.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class BanditPolicyArgs:
    def __init__(__self__, *,
                 policy_type: pulumi.Input[str],
                 delay_evaluation: Optional[pulumi.Input[int]] = None,
                 evaluation_interval: Optional[pulumi.Input[int]] = None,
                 slack_amount: Optional[pulumi.Input[float]] = None,
                 slack_factor: Optional[pulumi.Input[float]] = None):
        """
        Defines an early termination policy based on slack criteria, and a frequency and delay interval for evaluation
        :param pulumi.Input[str] policy_type: 
               Expected value is 'Bandit'.
        :param pulumi.Input[int] delay_evaluation: Number of intervals by which to delay the first evaluation.
        :param pulumi.Input[int] evaluation_interval: Interval (number of runs) between policy evaluations.
        :param pulumi.Input[float] slack_amount: Absolute distance allowed from the best performing run.
        :param pulumi.Input[float] slack_factor: Ratio of the allowed distance from the best performing run.
        """
        pulumi.set(__self__, "policy_type", 'Bandit')
        if delay_evaluation is None:
            delay_evaluation = 0
        if delay_evaluation is not None:
            pulumi.set(__self__, "delay_evaluation", delay_evaluation)
        if evaluation_interval is None:
            evaluation_interval = 0
        if evaluation_interval is not None:
            pulumi.set(__self__, "evaluation_interval", evaluation_interval)
        if slack_amount is None:
            slack_amount = 0
        if slack_amount is not None:
            pulumi.set(__self__, "slack_amount", slack_amount)
        if slack_factor is None:
            slack_factor = 0
        if slack_factor is not None:
            pulumi.set(__self__, "slack_factor", slack_factor)

    @property
    @pulumi.getter(name="policyType")
    def policy_type(self) -> pulumi.Input[str]:
        """

        Expected value is 'Bandit'.
        """
        return pulumi.get(self, "policy_type")

    @policy_type.setter
    def policy_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "policy_type", value)

    @property
    @pulumi.getter(name="delayEvaluation")
    def delay_evaluation(self) -> Optional[pulumi.Input[int]]:
        """
        Number of intervals by which to delay the first evaluation.
        """
        return pulumi.get(self, "delay_evaluation")

    @delay_evaluation.setter
    def delay_evaluation(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "delay_evaluation", value)

    @property
    @pulumi.getter(name="evaluationInterval")
    def evaluation_interval(self) -> Optional[pulumi.Input[int]]:
        """
        Interval (number of runs) between policy evaluations.
        """
        return pulumi.get(self, "evaluation_interval")

    @evaluation_interval.setter
    def evaluation_interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "evaluation_interval", value)

    @property
    @pulumi.getter(name="slackAmount")
    def slack_amount(self) -> Optional[pulumi.Input[float]]:
        """
        Absolute distance allowed from the best performing run.
        """
        return pulumi.get(self, "slack_amount")

    @slack_amount.setter
    def slack_amount(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "slack_amount", value)

    @property
    @pulumi.getter(name="slackFactor")
    def slack_factor(self) -> Optional[pulumi.Input[float]]:
        """
        Ratio of the allowed distance from the best performing run.
        """
        return pulumi.get(self, "slack_factor")

    @slack_factor.setter
    def slack_factor(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "slack_factor", value)


@pulumi.input_type
class BatchDeploymentArgs:
    def __init__(__self__, *,
                 code_configuration: Optional[pulumi.Input['CodeConfigurationArgs']] = None,
                 compute: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 environment_id: Optional[pulumi.Input[str]] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 error_threshold: Optional[pulumi.Input[int]] = None,
                 logging_level: Optional[pulumi.Input[Union[str, 'BatchLoggingLevel']]] = None,
                 max_concurrency_per_instance: Optional[pulumi.Input[int]] = None,
                 mini_batch_size: Optional[pulumi.Input[float]] = None,
                 model: Optional[pulumi.Input[Union['DataPathAssetReferenceArgs', 'IdAssetReferenceArgs', 'OutputPathAssetReferenceArgs']]] = None,
                 output_action: Optional[pulumi.Input[Union[str, 'BatchOutputAction']]] = None,
                 output_file_name: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 resources: Optional[pulumi.Input['DeploymentResourceConfigurationArgs']] = None,
                 retry_settings: Optional[pulumi.Input['BatchRetrySettingsArgs']] = None):
        """
        Batch inference settings per deployment.
        :param pulumi.Input['CodeConfigurationArgs'] code_configuration: Code configuration for the endpoint deployment.
        :param pulumi.Input[str] compute: Compute target for batch inference operation.
        :param pulumi.Input[str] description: Description of the endpoint deployment.
        :param pulumi.Input[str] environment_id: ARM resource ID of the environment specification for the endpoint deployment.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] environment_variables: Environment variables configuration for the deployment.
        :param pulumi.Input[int] error_threshold: Error threshold, if the error count for the entire input goes above this value,
               the batch inference will be aborted. Range is [-1, int.MaxValue].
               For FileDataset, this value is the count of file failures.
               For TabularDataset, this value is the count of record failures.
               If set to -1 (the lower bound), all failures during batch inference will be ignored.
        :param pulumi.Input[Union[str, 'BatchLoggingLevel']] logging_level: Logging level for batch inference operation.
        :param pulumi.Input[int] max_concurrency_per_instance: Indicates maximum number of parallelism per instance.
        :param pulumi.Input[float] mini_batch_size: Size of the mini-batch passed to each batch invocation.
               For FileDataset, this is the number of files per mini-batch.
               For TabularDataset, this is the size of the records in bytes, per mini-batch.
        :param pulumi.Input[Union['DataPathAssetReferenceArgs', 'IdAssetReferenceArgs', 'OutputPathAssetReferenceArgs']] model: Reference to the model asset for the endpoint deployment.
        :param pulumi.Input[Union[str, 'BatchOutputAction']] output_action: Indicates how the output will be organized.
        :param pulumi.Input[str] output_file_name: Customized output file name for append_row output action.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: Property dictionary. Properties can be added, but not removed or altered.
        :param pulumi.Input['DeploymentResourceConfigurationArgs'] resources: Indicates compute configuration for the job.
               If not provided, will default to the defaults defined in ResourceConfiguration.
        :param pulumi.Input['BatchRetrySettingsArgs'] retry_settings: Retry Settings for the batch inference operation.
               If not provided, will default to the defaults defined in BatchRetrySettings.
        """
        if code_configuration is not None:
            pulumi.set(__self__, "code_configuration", code_configuration)
        if compute is not None:
            pulumi.set(__self__, "compute", compute)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if environment_id is not None:
            pulumi.set(__self__, "environment_id", environment_id)
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if error_threshold is None:
            error_threshold = -1
        if error_threshold is not None:
            pulumi.set(__self__, "error_threshold", error_threshold)
        if logging_level is None:
            logging_level = 'Info'
        if logging_level is not None:
            pulumi.set(__self__, "logging_level", logging_level)
        if max_concurrency_per_instance is None:
            max_concurrency_per_instance = 1
        if max_concurrency_per_instance is not None:
            pulumi.set(__self__, "max_concurrency_per_instance", max_concurrency_per_instance)
        if mini_batch_size is None:
            mini_batch_size = 10
        if mini_batch_size is not None:
            pulumi.set(__self__, "mini_batch_size", mini_batch_size)
        if model is not None:
            pulumi.set(__self__, "model", model)
        if output_action is None:
            output_action = 'AppendRow'
        if output_action is not None:
            pulumi.set(__self__, "output_action", output_action)
        if output_file_name is None:
            output_file_name = 'predictions.csv'
        if output_file_name is not None:
            pulumi.set(__self__, "output_file_name", output_file_name)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)
        if retry_settings is not None:
            pulumi.set(__self__, "retry_settings", retry_settings)

    @property
    @pulumi.getter(name="codeConfiguration")
    def code_configuration(self) -> Optional[pulumi.Input['CodeConfigurationArgs']]:
        """
        Code configuration for the endpoint deployment.
        """
        return pulumi.get(self, "code_configuration")

    @code_configuration.setter
    def code_configuration(self, value: Optional[pulumi.Input['CodeConfigurationArgs']]):
        pulumi.set(self, "code_configuration", value)

    @property
    @pulumi.getter
    def compute(self) -> Optional[pulumi.Input[str]]:
        """
        Compute target for batch inference operation.
        """
        return pulumi.get(self, "compute")

    @compute.setter
    def compute(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compute", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the endpoint deployment.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM resource ID of the environment specification for the endpoint deployment.
        """
        return pulumi.get(self, "environment_id")

    @environment_id.setter
    def environment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "environment_id", value)

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Environment variables configuration for the deployment.
        """
        return pulumi.get(self, "environment_variables")

    @environment_variables.setter
    def environment_variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "environment_variables", value)

    @property
    @pulumi.getter(name="errorThreshold")
    def error_threshold(self) -> Optional[pulumi.Input[int]]:
        """
        Error threshold, if the error count for the entire input goes above this value,
        the batch inference will be aborted. Range is [-1, int.MaxValue].
        For FileDataset, this value is the count of file failures.
        For TabularDataset, this value is the count of record failures.
        If set to -1 (the lower bound), all failures during batch inference will be ignored.
        """
        return pulumi.get(self, "error_threshold")

    @error_threshold.setter
    def error_threshold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "error_threshold", value)

    @property
    @pulumi.getter(name="loggingLevel")
    def logging_level(self) -> Optional[pulumi.Input[Union[str, 'BatchLoggingLevel']]]:
        """
        Logging level for batch inference operation.
        """
        return pulumi.get(self, "logging_level")

    @logging_level.setter
    def logging_level(self, value: Optional[pulumi.Input[Union[str, 'BatchLoggingLevel']]]):
        pulumi.set(self, "logging_level", value)

    @property
    @pulumi.getter(name="maxConcurrencyPerInstance")
    def max_concurrency_per_instance(self) -> Optional[pulumi.Input[int]]:
        """
        Indicates maximum number of parallelism per instance.
        """
        return pulumi.get(self, "max_concurrency_per_instance")

    @max_concurrency_per_instance.setter
    def max_concurrency_per_instance(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_concurrency_per_instance", value)

    @property
    @pulumi.getter(name="miniBatchSize")
    def mini_batch_size(self) -> Optional[pulumi.Input[float]]:
        """
        Size of the mini-batch passed to each batch invocation.
        For FileDataset, this is the number of files per mini-batch.
        For TabularDataset, this is the size of the records in bytes, per mini-batch.
        """
        return pulumi.get(self, "mini_batch_size")

    @mini_batch_size.setter
    def mini_batch_size(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "mini_batch_size", value)

    @property
    @pulumi.getter
    def model(self) -> Optional[pulumi.Input[Union['DataPathAssetReferenceArgs', 'IdAssetReferenceArgs', 'OutputPathAssetReferenceArgs']]]:
        """
        Reference to the model asset for the endpoint deployment.
        """
        return pulumi.get(self, "model")

    @model.setter
    def model(self, value: Optional[pulumi.Input[Union['DataPathAssetReferenceArgs', 'IdAssetReferenceArgs', 'OutputPathAssetReferenceArgs']]]):
        pulumi.set(self, "model", value)

    @property
    @pulumi.getter(name="outputAction")
    def output_action(self) -> Optional[pulumi.Input[Union[str, 'BatchOutputAction']]]:
        """
        Indicates how the output will be organized.
        """
        return pulumi.get(self, "output_action")

    @output_action.setter
    def output_action(self, value: Optional[pulumi.Input[Union[str, 'BatchOutputAction']]]):
        pulumi.set(self, "output_action", value)

    @property
    @pulumi.getter(name="outputFileName")
    def output_file_name(self) -> Optional[pulumi.Input[str]]:
        """
        Customized output file name for append_row output action.
        """
        return pulumi.get(self, "output_file_name")

    @output_file_name.setter
    def output_file_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "output_file_name", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Property dictionary. Properties can be added, but not removed or altered.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter
    def resources(self) -> Optional[pulumi.Input['DeploymentResourceConfigurationArgs']]:
        """
        Indicates compute configuration for the job.
        If not provided, will default to the defaults defined in ResourceConfiguration.
        """
        return pulumi.get(self, "resources")

    @resources.setter
    def resources(self, value: Optional[pulumi.Input['DeploymentResourceConfigurationArgs']]):
        pulumi.set(self, "resources", value)

    @property
    @pulumi.getter(name="retrySettings")
    def retry_settings(self) -> Optional[pulumi.Input['BatchRetrySettingsArgs']]:
        """
        Retry Settings for the batch inference operation.
        If not provided, will default to the defaults defined in BatchRetrySettings.
        """
        return pulumi.get(self, "retry_settings")

    @retry_settings.setter
    def retry_settings(self, value: Optional[pulumi.Input['BatchRetrySettingsArgs']]):
        pulumi.set(self, "retry_settings", value)


@pulumi.input_type
class BatchEndpointDefaultsArgs:
    def __init__(__self__, *,
                 deployment_name: Optional[pulumi.Input[str]] = None):
        """
        Batch endpoint default values
        :param pulumi.Input[str] deployment_name: Name of the deployment that will be default for the endpoint.
               This deployment will end up getting 100% traffic when the endpoint scoring URL is invoked.
        """
        if deployment_name is not None:
            pulumi.set(__self__, "deployment_name", deployment_name)

    @property
    @pulumi.getter(name="deploymentName")
    def deployment_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the deployment that will be default for the endpoint.
        This deployment will end up getting 100% traffic when the endpoint scoring URL is invoked.
        """
        return pulumi.get(self, "deployment_name")

    @deployment_name.setter
    def deployment_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deployment_name", value)


@pulumi.input_type
class BatchEndpointArgs:
    def __init__(__self__, *,
                 auth_mode: pulumi.Input[Union[str, 'EndpointAuthMode']],
                 defaults: Optional[pulumi.Input['BatchEndpointDefaultsArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 keys: Optional[pulumi.Input['EndpointAuthKeysArgs']] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Batch endpoint configuration.
        :param pulumi.Input[Union[str, 'EndpointAuthMode']] auth_mode: [Required] Use 'Key' for key based authentication and 'AMLToken' for Azure Machine Learning token-based authentication. 'Key' doesn't expire but 'AMLToken' does.
        :param pulumi.Input['BatchEndpointDefaultsArgs'] defaults: Default values for Batch Endpoint
        :param pulumi.Input[str] description: Description of the inference endpoint.
        :param pulumi.Input['EndpointAuthKeysArgs'] keys: EndpointAuthKeys to set initially on an Endpoint.
               This property will always be returned as null. AuthKey values must be retrieved using the ListKeys API.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: Property dictionary. Properties can be added, but not removed or altered.
        """
        pulumi.set(__self__, "auth_mode", auth_mode)
        if defaults is not None:
            pulumi.set(__self__, "defaults", defaults)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if keys is not None:
            pulumi.set(__self__, "keys", keys)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter(name="authMode")
    def auth_mode(self) -> pulumi.Input[Union[str, 'EndpointAuthMode']]:
        """
        [Required] Use 'Key' for key based authentication and 'AMLToken' for Azure Machine Learning token-based authentication. 'Key' doesn't expire but 'AMLToken' does.
        """
        return pulumi.get(self, "auth_mode")

    @auth_mode.setter
    def auth_mode(self, value: pulumi.Input[Union[str, 'EndpointAuthMode']]):
        pulumi.set(self, "auth_mode", value)

    @property
    @pulumi.getter
    def defaults(self) -> Optional[pulumi.Input['BatchEndpointDefaultsArgs']]:
        """
        Default values for Batch Endpoint
        """
        return pulumi.get(self, "defaults")

    @defaults.setter
    def defaults(self, value: Optional[pulumi.Input['BatchEndpointDefaultsArgs']]):
        pulumi.set(self, "defaults", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the inference endpoint.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def keys(self) -> Optional[pulumi.Input['EndpointAuthKeysArgs']]:
        """
        EndpointAuthKeys to set initially on an Endpoint.
        This property will always be returned as null. AuthKey values must be retrieved using the ListKeys API.
        """
        return pulumi.get(self, "keys")

    @keys.setter
    def keys(self, value: Optional[pulumi.Input['EndpointAuthKeysArgs']]):
        pulumi.set(self, "keys", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Property dictionary. Properties can be added, but not removed or altered.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "properties", value)


@pulumi.input_type
class BatchRetrySettingsArgs:
    def __init__(__self__, *,
                 max_retries: Optional[pulumi.Input[int]] = None,
                 timeout: Optional[pulumi.Input[str]] = None):
        """
        Retry settings for a batch inference operation.
        :param pulumi.Input[int] max_retries: Maximum retry count for a mini-batch
        :param pulumi.Input[str] timeout: Invocation timeout for a mini-batch, in ISO 8601 format.
        """
        if max_retries is None:
            max_retries = 3
        if max_retries is not None:
            pulumi.set(__self__, "max_retries", max_retries)
        if timeout is None:
            timeout = 'PT30S'
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter(name="maxRetries")
    def max_retries(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum retry count for a mini-batch
        """
        return pulumi.get(self, "max_retries")

    @max_retries.setter
    def max_retries(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_retries", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[str]]:
        """
        Invocation timeout for a mini-batch, in ISO 8601 format.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timeout", value)


@pulumi.input_type
class BayesianSamplingAlgorithmArgs:
    def __init__(__self__, *,
                 sampling_algorithm_type: pulumi.Input[str]):
        """
        Defines a Sampling Algorithm that generates values based on previous values
        :param pulumi.Input[str] sampling_algorithm_type: 
               Expected value is 'Bayesian'.
        """
        pulumi.set(__self__, "sampling_algorithm_type", 'Bayesian')

    @property
    @pulumi.getter(name="samplingAlgorithmType")
    def sampling_algorithm_type(self) -> pulumi.Input[str]:
        """

        Expected value is 'Bayesian'.
        """
        return pulumi.get(self, "sampling_algorithm_type")

    @sampling_algorithm_type.setter
    def sampling_algorithm_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "sampling_algorithm_type", value)


@pulumi.input_type
class BindOptionsArgs:
    def __init__(__self__, *,
                 create_host_path: Optional[pulumi.Input[bool]] = None,
                 propagation: Optional[pulumi.Input[str]] = None,
                 selinux: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[bool] create_host_path: Indicate whether to create host path.
        :param pulumi.Input[str] propagation: Type of Bind Option
        :param pulumi.Input[str] selinux: Mention the selinux options.
        """
        if create_host_path is not None:
            pulumi.set(__self__, "create_host_path", create_host_path)
        if propagation is not None:
            pulumi.set(__self__, "propagation", propagation)
        if selinux is not None:
            pulumi.set(__self__, "selinux", selinux)

    @property
    @pulumi.getter(name="createHostPath")
    def create_host_path(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicate whether to create host path.
        """
        return pulumi.get(self, "create_host_path")

    @create_host_path.setter
    def create_host_path(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "create_host_path", value)

    @property
    @pulumi.getter
    def propagation(self) -> Optional[pulumi.Input[str]]:
        """
        Type of Bind Option
        """
        return pulumi.get(self, "propagation")

    @propagation.setter
    def propagation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "propagation", value)

    @property
    @pulumi.getter
    def selinux(self) -> Optional[pulumi.Input[str]]:
        """
        Mention the selinux options.
        """
        return pulumi.get(self, "selinux")

    @selinux.setter
    def selinux(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "selinux", value)


@pulumi.input_type
class BuildContextArgs:
    def __init__(__self__, *,
                 context_uri: pulumi.Input[str],
                 dockerfile_path: Optional[pulumi.Input[str]] = None):
        """
        Configuration settings for Docker build context
        :param pulumi.Input[str] context_uri: [Required] URI of the Docker build context used to build the image. Supports blob URIs on environment creation and may return blob or Git URIs.
               <seealso href="https://docs.docker.com/engine/reference/commandline/build/#extended-description" />
        :param pulumi.Input[str] dockerfile_path: Path to the Dockerfile in the build context.
               <seealso href="https://docs.docker.com/engine/reference/builder/" />
        """
        pulumi.set(__self__, "context_uri", context_uri)
        if dockerfile_path is None:
            dockerfile_path = 'Dockerfile'
        if dockerfile_path is not None:
            pulumi.set(__self__, "dockerfile_path", dockerfile_path)

    @property
    @pulumi.getter(name="contextUri")
    def context_uri(self) -> pulumi.Input[str]:
        """
        [Required] URI of the Docker build context used to build the image. Supports blob URIs on environment creation and may return blob or Git URIs.
        <seealso href="https://docs.docker.com/engine/reference/commandline/build/#extended-description" />
        """
        return pulumi.get(self, "context_uri")

    @context_uri.setter
    def context_uri(self, value: pulumi.Input[str]):
        pulumi.set(self, "context_uri", value)

    @property
    @pulumi.getter(name="dockerfilePath")
    def dockerfile_path(self) -> Optional[pulumi.Input[str]]:
        """
        Path to the Dockerfile in the build context.
        <seealso href="https://docs.docker.com/engine/reference/builder/" />
        """
        return pulumi.get(self, "dockerfile_path")

    @dockerfile_path.setter
    def dockerfile_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dockerfile_path", value)


@pulumi.input_type
class CertificateDatastoreCredentialsArgs:
    def __init__(__self__, *,
                 client_id: pulumi.Input[str],
                 credentials_type: pulumi.Input[str],
                 secrets: pulumi.Input['CertificateDatastoreSecretsArgs'],
                 tenant_id: pulumi.Input[str],
                 thumbprint: pulumi.Input[str],
                 authority_url: Optional[pulumi.Input[str]] = None,
                 resource_url: Optional[pulumi.Input[str]] = None):
        """
        Certificate datastore credentials configuration.
        :param pulumi.Input[str] client_id: [Required] Service principal client ID.
        :param pulumi.Input[str] credentials_type: Enum to determine the datastore credentials type.
               Expected value is 'Certificate'.
        :param pulumi.Input['CertificateDatastoreSecretsArgs'] secrets: [Required] Service principal secrets.
        :param pulumi.Input[str] tenant_id: [Required] ID of the tenant to which the service principal belongs.
        :param pulumi.Input[str] thumbprint: [Required] Thumbprint of the certificate used for authentication.
        :param pulumi.Input[str] authority_url: Authority URL used for authentication.
        :param pulumi.Input[str] resource_url: Resource the service principal has access to.
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "credentials_type", 'Certificate')
        pulumi.set(__self__, "secrets", secrets)
        pulumi.set(__self__, "tenant_id", tenant_id)
        pulumi.set(__self__, "thumbprint", thumbprint)
        if authority_url is not None:
            pulumi.set(__self__, "authority_url", authority_url)
        if resource_url is not None:
            pulumi.set(__self__, "resource_url", resource_url)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Input[str]:
        """
        [Required] Service principal client ID.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="credentialsType")
    def credentials_type(self) -> pulumi.Input[str]:
        """
        Enum to determine the datastore credentials type.
        Expected value is 'Certificate'.
        """
        return pulumi.get(self, "credentials_type")

    @credentials_type.setter
    def credentials_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "credentials_type", value)

    @property
    @pulumi.getter
    def secrets(self) -> pulumi.Input['CertificateDatastoreSecretsArgs']:
        """
        [Required] Service principal secrets.
        """
        return pulumi.get(self, "secrets")

    @secrets.setter
    def secrets(self, value: pulumi.Input['CertificateDatastoreSecretsArgs']):
        pulumi.set(self, "secrets", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        [Required] ID of the tenant to which the service principal belongs.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter
    def thumbprint(self) -> pulumi.Input[str]:
        """
        [Required] Thumbprint of the certificate used for authentication.
        """
        return pulumi.get(self, "thumbprint")

    @thumbprint.setter
    def thumbprint(self, value: pulumi.Input[str]):
        pulumi.set(self, "thumbprint", value)

    @property
    @pulumi.getter(name="authorityUrl")
    def authority_url(self) -> Optional[pulumi.Input[str]]:
        """
        Authority URL used for authentication.
        """
        return pulumi.get(self, "authority_url")

    @authority_url.setter
    def authority_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authority_url", value)

    @property
    @pulumi.getter(name="resourceUrl")
    def resource_url(self) -> Optional[pulumi.Input[str]]:
        """
        Resource the service principal has access to.
        """
        return pulumi.get(self, "resource_url")

    @resource_url.setter
    def resource_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_url", value)


@pulumi.input_type
class CertificateDatastoreSecretsArgs:
    def __init__(__self__, *,
                 secrets_type: pulumi.Input[str],
                 certificate: Optional[pulumi.Input[str]] = None):
        """
        Datastore certificate secrets.
        :param pulumi.Input[str] secrets_type: Enum to determine the datastore secrets type.
               Expected value is 'Certificate'.
        :param pulumi.Input[str] certificate: Service principal certificate.
        """
        pulumi.set(__self__, "secrets_type", 'Certificate')
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)

    @property
    @pulumi.getter(name="secretsType")
    def secrets_type(self) -> pulumi.Input[str]:
        """
        Enum to determine the datastore secrets type.
        Expected value is 'Certificate'.
        """
        return pulumi.get(self, "secrets_type")

    @secrets_type.setter
    def secrets_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "secrets_type", value)

    @property
    @pulumi.getter
    def certificate(self) -> Optional[pulumi.Input[str]]:
        """
        Service principal certificate.
        """
        return pulumi.get(self, "certificate")

    @certificate.setter
    def certificate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate", value)


@pulumi.input_type
class ClassificationTrainingSettingsArgs:
    def __init__(__self__, *,
                 allowed_training_algorithms: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'ClassificationModels']]]]] = None,
                 blocked_training_algorithms: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'ClassificationModels']]]]] = None,
                 enable_dnn_training: Optional[pulumi.Input[bool]] = None,
                 enable_model_explainability: Optional[pulumi.Input[bool]] = None,
                 enable_onnx_compatible_models: Optional[pulumi.Input[bool]] = None,
                 enable_stack_ensemble: Optional[pulumi.Input[bool]] = None,
                 enable_vote_ensemble: Optional[pulumi.Input[bool]] = None,
                 ensemble_model_download_timeout: Optional[pulumi.Input[str]] = None,
                 stack_ensemble_settings: Optional[pulumi.Input['StackEnsembleSettingsArgs']] = None,
                 training_mode: Optional[pulumi.Input[Union[str, 'TrainingMode']]] = None):
        """
        Classification Training related configuration.
        :param pulumi.Input[Sequence[pulumi.Input[Union[str, 'ClassificationModels']]]] allowed_training_algorithms: Allowed models for classification task.
        :param pulumi.Input[Sequence[pulumi.Input[Union[str, 'ClassificationModels']]]] blocked_training_algorithms: Blocked models for classification task.
        :param pulumi.Input[bool] enable_dnn_training: Enable recommendation of DNN models.
        :param pulumi.Input[bool] enable_model_explainability: Flag to turn on explainability on best model.
        :param pulumi.Input[bool] enable_onnx_compatible_models: Flag for enabling onnx compatible models.
        :param pulumi.Input[bool] enable_stack_ensemble: Enable stack ensemble run.
        :param pulumi.Input[bool] enable_vote_ensemble: Enable voting ensemble run.
        :param pulumi.Input[str] ensemble_model_download_timeout: During VotingEnsemble and StackEnsemble model generation, multiple fitted models from the previous child runs are downloaded.
               Configure this parameter with a higher value than 300 secs, if more time is needed.
        :param pulumi.Input['StackEnsembleSettingsArgs'] stack_ensemble_settings: Stack ensemble settings for stack ensemble run.
        :param pulumi.Input[Union[str, 'TrainingMode']] training_mode: TrainingMode mode - Setting to 'auto' is same as setting it to 'non-distributed' for now, however in the future may result in mixed mode or heuristics based mode selection. Default is 'auto'.
               If 'Distributed' then only distributed featurization is used and distributed algorithms are chosen.
               If 'NonDistributed' then only non distributed algorithms are chosen.
        """
        if allowed_training_algorithms is not None:
            pulumi.set(__self__, "allowed_training_algorithms", allowed_training_algorithms)
        if blocked_training_algorithms is not None:
            pulumi.set(__self__, "blocked_training_algorithms", blocked_training_algorithms)
        if enable_dnn_training is None:
            enable_dnn_training = False
        if enable_dnn_training is not None:
            pulumi.set(__self__, "enable_dnn_training", enable_dnn_training)
        if enable_model_explainability is None:
            enable_model_explainability = True
        if enable_model_explainability is not None:
            pulumi.set(__self__, "enable_model_explainability", enable_model_explainability)
        if enable_onnx_compatible_models is None:
            enable_onnx_compatible_models = False
        if enable_onnx_compatible_models is not None:
            pulumi.set(__self__, "enable_onnx_compatible_models", enable_onnx_compatible_models)
        if enable_stack_ensemble is None:
            enable_stack_ensemble = True
        if enable_stack_ensemble is not None:
            pulumi.set(__self__, "enable_stack_ensemble", enable_stack_ensemble)
        if enable_vote_ensemble is None:
            enable_vote_ensemble = True
        if enable_vote_ensemble is not None:
            pulumi.set(__self__, "enable_vote_ensemble", enable_vote_ensemble)
        if ensemble_model_download_timeout is None:
            ensemble_model_download_timeout = 'PT5M'
        if ensemble_model_download_timeout is not None:
            pulumi.set(__self__, "ensemble_model_download_timeout", ensemble_model_download_timeout)
        if stack_ensemble_settings is not None:
            pulumi.set(__self__, "stack_ensemble_settings", stack_ensemble_settings)
        if training_mode is None:
            training_mode = 'Auto'
        if training_mode is not None:
            pulumi.set(__self__, "training_mode", training_mode)

    @property
    @pulumi.getter(name="allowedTrainingAlgorithms")
    def allowed_training_algorithms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'ClassificationModels']]]]]:
        """
        Allowed models for classification task.
        """
        return pulumi.get(self, "allowed_training_algorithms")

    @allowed_training_algorithms.setter
    def allowed_training_algorithms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'ClassificationModels']]]]]):
        pulumi.set(self, "allowed_training_algorithms", value)

    @property
    @pulumi.getter(name="blockedTrainingAlgorithms")
    def blocked_training_algorithms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'ClassificationModels']]]]]:
        """
        Blocked models for classification task.
        """
        return pulumi.get(self, "blocked_training_algorithms")

    @blocked_training_algorithms.setter
    def blocked_training_algorithms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'ClassificationModels']]]]]):
        pulumi.set(self, "blocked_training_algorithms", value)

    @property
    @pulumi.getter(name="enableDnnTraining")
    def enable_dnn_training(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable recommendation of DNN models.
        """
        return pulumi.get(self, "enable_dnn_training")

    @enable_dnn_training.setter
    def enable_dnn_training(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_dnn_training", value)

    @property
    @pulumi.getter(name="enableModelExplainability")
    def enable_model_explainability(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to turn on explainability on best model.
        """
        return pulumi.get(self, "enable_model_explainability")

    @enable_model_explainability.setter
    def enable_model_explainability(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_model_explainability", value)

    @property
    @pulumi.getter(name="enableOnnxCompatibleModels")
    def enable_onnx_compatible_models(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag for enabling onnx compatible models.
        """
        return pulumi.get(self, "enable_onnx_compatible_models")

    @enable_onnx_compatible_models.setter
    def enable_onnx_compatible_models(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_onnx_compatible_models", value)

    @property
    @pulumi.getter(name="enableStackEnsemble")
    def enable_stack_ensemble(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable stack ensemble run.
        """
        return pulumi.get(self, "enable_stack_ensemble")

    @enable_stack_ensemble.setter
    def enable_stack_ensemble(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_stack_ensemble", value)

    @property
    @pulumi.getter(name="enableVoteEnsemble")
    def enable_vote_ensemble(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable voting ensemble run.
        """
        return pulumi.get(self, "enable_vote_ensemble")

    @enable_vote_ensemble.setter
    def enable_vote_ensemble(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_vote_ensemble", value)

    @property
    @pulumi.getter(name="ensembleModelDownloadTimeout")
    def ensemble_model_download_timeout(self) -> Optional[pulumi.Input[str]]:
        """
        During VotingEnsemble and StackEnsemble model generation, multiple fitted models from the previous child runs are downloaded.
        Configure this parameter with a higher value than 300 secs, if more time is needed.
        """
        return pulumi.get(self, "ensemble_model_download_timeout")

    @ensemble_model_download_timeout.setter
    def ensemble_model_download_timeout(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ensemble_model_download_timeout", value)

    @property
    @pulumi.getter(name="stackEnsembleSettings")
    def stack_ensemble_settings(self) -> Optional[pulumi.Input['StackEnsembleSettingsArgs']]:
        """
        Stack ensemble settings for stack ensemble run.
        """
        return pulumi.get(self, "stack_ensemble_settings")

    @stack_ensemble_settings.setter
    def stack_ensemble_settings(self, value: Optional[pulumi.Input['StackEnsembleSettingsArgs']]):
        pulumi.set(self, "stack_ensemble_settings", value)

    @property
    @pulumi.getter(name="trainingMode")
    def training_mode(self) -> Optional[pulumi.Input[Union[str, 'TrainingMode']]]:
        """
        TrainingMode mode - Setting to 'auto' is same as setting it to 'non-distributed' for now, however in the future may result in mixed mode or heuristics based mode selection. Default is 'auto'.
        If 'Distributed' then only distributed featurization is used and distributed algorithms are chosen.
        If 'NonDistributed' then only non distributed algorithms are chosen.
        """
        return pulumi.get(self, "training_mode")

    @training_mode.setter
    def training_mode(self, value: Optional[pulumi.Input[Union[str, 'TrainingMode']]]):
        pulumi.set(self, "training_mode", value)


@pulumi.input_type
class ClassificationArgs:
    def __init__(__self__, *,
                 task_type: pulumi.Input[str],
                 training_data: pulumi.Input['MLTableJobInputArgs'],
                 cv_split_column_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 featurization_settings: Optional[pulumi.Input['TableVerticalFeaturizationSettingsArgs']] = None,
                 fixed_parameters: Optional[pulumi.Input['TableFixedParametersArgs']] = None,
                 limit_settings: Optional[pulumi.Input['TableVerticalLimitSettingsArgs']] = None,
                 log_verbosity: Optional[pulumi.Input[Union[str, 'LogVerbosity']]] = None,
                 n_cross_validations: Optional[pulumi.Input[Union['AutoNCrossValidationsArgs', 'CustomNCrossValidationsArgs']]] = None,
                 positive_label: Optional[pulumi.Input[str]] = None,
                 primary_metric: Optional[pulumi.Input[Union[str, 'ClassificationPrimaryMetrics']]] = None,
                 search_space: Optional[pulumi.Input[Sequence[pulumi.Input['TableParameterSubspaceArgs']]]] = None,
                 sweep_settings: Optional[pulumi.Input['TableSweepSettingsArgs']] = None,
                 target_column_name: Optional[pulumi.Input[str]] = None,
                 test_data: Optional[pulumi.Input['MLTableJobInputArgs']] = None,
                 test_data_size: Optional[pulumi.Input[float]] = None,
                 training_settings: Optional[pulumi.Input['ClassificationTrainingSettingsArgs']] = None,
                 validation_data: Optional[pulumi.Input['MLTableJobInputArgs']] = None,
                 validation_data_size: Optional[pulumi.Input[float]] = None,
                 weight_column_name: Optional[pulumi.Input[str]] = None):
        """
        Classification task in AutoML Table vertical.
        :param pulumi.Input[str] task_type: AutoMLJob Task type.
               Expected value is 'Classification'.
        :param pulumi.Input['MLTableJobInputArgs'] training_data: [Required] Training data input.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] cv_split_column_names: Columns to use for CVSplit data.
        :param pulumi.Input['TableVerticalFeaturizationSettingsArgs'] featurization_settings: Featurization inputs needed for AutoML job.
        :param pulumi.Input['TableFixedParametersArgs'] fixed_parameters: Model/training parameters that will remain constant throughout training.
        :param pulumi.Input['TableVerticalLimitSettingsArgs'] limit_settings: Execution constraints for AutoMLJob.
        :param pulumi.Input[Union[str, 'LogVerbosity']] log_verbosity: Log verbosity for the job.
        :param pulumi.Input[Union['AutoNCrossValidationsArgs', 'CustomNCrossValidationsArgs']] n_cross_validations: Number of cross validation folds to be applied on training dataset
               when validation dataset is not provided.
        :param pulumi.Input[str] positive_label: Positive label for binary metrics calculation.
        :param pulumi.Input[Union[str, 'ClassificationPrimaryMetrics']] primary_metric: Primary metric for the task.
        :param pulumi.Input[Sequence[pulumi.Input['TableParameterSubspaceArgs']]] search_space: Search space for sampling different combinations of models and their hyperparameters.
        :param pulumi.Input['TableSweepSettingsArgs'] sweep_settings: Settings for model sweeping and hyperparameter tuning.
        :param pulumi.Input[str] target_column_name: Target column name: This is prediction values column.
               Also known as label column name in context of classification tasks.
        :param pulumi.Input['MLTableJobInputArgs'] test_data: Test data input.
        :param pulumi.Input[float] test_data_size: The fraction of test dataset that needs to be set aside for validation purpose.
               Values between (0.0 , 1.0)
               Applied when validation dataset is not provided.
        :param pulumi.Input['ClassificationTrainingSettingsArgs'] training_settings: Inputs for training phase for an AutoML Job.
        :param pulumi.Input['MLTableJobInputArgs'] validation_data: Validation data inputs.
        :param pulumi.Input[float] validation_data_size: The fraction of training dataset that needs to be set aside for validation purpose.
               Values between (0.0 , 1.0)
               Applied when validation dataset is not provided.
        :param pulumi.Input[str] weight_column_name: The name of the sample weight column. Automated ML supports a weighted column as an input, causing rows in the data to be weighted up or down.
        """
        pulumi.set(__self__, "task_type", 'Classification')
        pulumi.set(__self__, "training_data", training_data)
        if cv_split_column_names is not None:
            pulumi.set(__self__, "cv_split_column_names", cv_split_column_names)
        if featurization_settings is not None:
            pulumi.set(__self__, "featurization_settings", featurization_settings)
        if fixed_parameters is not None:
            pulumi.set(__self__, "fixed_parameters", fixed_parameters)
        if limit_settings is not None:
            pulumi.set(__self__, "limit_settings", limit_settings)
        if log_verbosity is None:
            log_verbosity = 'Info'
        if log_verbosity is not None:
            pulumi.set(__self__, "log_verbosity", log_verbosity)
        if n_cross_validations is not None:
            pulumi.set(__self__, "n_cross_validations", n_cross_validations)
        if positive_label is not None:
            pulumi.set(__self__, "positive_label", positive_label)
        if primary_metric is None:
            primary_metric = 'AUCWeighted'
        if primary_metric is not None:
            pulumi.set(__self__, "primary_metric", primary_metric)
        if search_space is not None:
            pulumi.set(__self__, "search_space", search_space)
        if sweep_settings is not None:
            pulumi.set(__self__, "sweep_settings", sweep_settings)
        if target_column_name is not None:
            pulumi.set(__self__, "target_column_name", target_column_name)
        if test_data is not None:
            pulumi.set(__self__, "test_data", test_data)
        if test_data_size is not None:
            pulumi.set(__self__, "test_data_size", test_data_size)
        if training_settings is not None:
            pulumi.set(__self__, "training_settings", training_settings)
        if validation_data is not None:
            pulumi.set(__self__, "validation_data", validation_data)
        if validation_data_size is not None:
            pulumi.set(__self__, "validation_data_size", validation_data_size)
        if weight_column_name is not None:
            pulumi.set(__self__, "weight_column_name", weight_column_name)

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> pulumi.Input[str]:
        """
        AutoMLJob Task type.
        Expected value is 'Classification'.
        """
        return pulumi.get(self, "task_type")

    @task_type.setter
    def task_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "task_type", value)

    @property
    @pulumi.getter(name="trainingData")
    def training_data(self) -> pulumi.Input['MLTableJobInputArgs']:
        """
        [Required] Training data input.
        """
        return pulumi.get(self, "training_data")

    @training_data.setter
    def training_data(self, value: pulumi.Input['MLTableJobInputArgs']):
        pulumi.set(self, "training_data", value)

    @property
    @pulumi.getter(name="cvSplitColumnNames")
    def cv_split_column_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Columns to use for CVSplit data.
        """
        return pulumi.get(self, "cv_split_column_names")

    @cv_split_column_names.setter
    def cv_split_column_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "cv_split_column_names", value)

    @property
    @pulumi.getter(name="featurizationSettings")
    def featurization_settings(self) -> Optional[pulumi.Input['TableVerticalFeaturizationSettingsArgs']]:
        """
        Featurization inputs needed for AutoML job.
        """
        return pulumi.get(self, "featurization_settings")

    @featurization_settings.setter
    def featurization_settings(self, value: Optional[pulumi.Input['TableVerticalFeaturizationSettingsArgs']]):
        pulumi.set(self, "featurization_settings", value)

    @property
    @pulumi.getter(name="fixedParameters")
    def fixed_parameters(self) -> Optional[pulumi.Input['TableFixedParametersArgs']]:
        """
        Model/training parameters that will remain constant throughout training.
        """
        return pulumi.get(self, "fixed_parameters")

    @fixed_parameters.setter
    def fixed_parameters(self, value: Optional[pulumi.Input['TableFixedParametersArgs']]):
        pulumi.set(self, "fixed_parameters", value)

    @property
    @pulumi.getter(name="limitSettings")
    def limit_settings(self) -> Optional[pulumi.Input['TableVerticalLimitSettingsArgs']]:
        """
        Execution constraints for AutoMLJob.
        """
        return pulumi.get(self, "limit_settings")

    @limit_settings.setter
    def limit_settings(self, value: Optional[pulumi.Input['TableVerticalLimitSettingsArgs']]):
        pulumi.set(self, "limit_settings", value)

    @property
    @pulumi.getter(name="logVerbosity")
    def log_verbosity(self) -> Optional[pulumi.Input[Union[str, 'LogVerbosity']]]:
        """
        Log verbosity for the job.
        """
        return pulumi.get(self, "log_verbosity")

    @log_verbosity.setter
    def log_verbosity(self, value: Optional[pulumi.Input[Union[str, 'LogVerbosity']]]):
        pulumi.set(self, "log_verbosity", value)

    @property
    @pulumi.getter(name="nCrossValidations")
    def n_cross_validations(self) -> Optional[pulumi.Input[Union['AutoNCrossValidationsArgs', 'CustomNCrossValidationsArgs']]]:
        """
        Number of cross validation folds to be applied on training dataset
        when validation dataset is not provided.
        """
        return pulumi.get(self, "n_cross_validations")

    @n_cross_validations.setter
    def n_cross_validations(self, value: Optional[pulumi.Input[Union['AutoNCrossValidationsArgs', 'CustomNCrossValidationsArgs']]]):
        pulumi.set(self, "n_cross_validations", value)

    @property
    @pulumi.getter(name="positiveLabel")
    def positive_label(self) -> Optional[pulumi.Input[str]]:
        """
        Positive label for binary metrics calculation.
        """
        return pulumi.get(self, "positive_label")

    @positive_label.setter
    def positive_label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "positive_label", value)

    @property
    @pulumi.getter(name="primaryMetric")
    def primary_metric(self) -> Optional[pulumi.Input[Union[str, 'ClassificationPrimaryMetrics']]]:
        """
        Primary metric for the task.
        """
        return pulumi.get(self, "primary_metric")

    @primary_metric.setter
    def primary_metric(self, value: Optional[pulumi.Input[Union[str, 'ClassificationPrimaryMetrics']]]):
        pulumi.set(self, "primary_metric", value)

    @property
    @pulumi.getter(name="searchSpace")
    def search_space(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TableParameterSubspaceArgs']]]]:
        """
        Search space for sampling different combinations of models and their hyperparameters.
        """
        return pulumi.get(self, "search_space")

    @search_space.setter
    def search_space(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TableParameterSubspaceArgs']]]]):
        pulumi.set(self, "search_space", value)

    @property
    @pulumi.getter(name="sweepSettings")
    def sweep_settings(self) -> Optional[pulumi.Input['TableSweepSettingsArgs']]:
        """
        Settings for model sweeping and hyperparameter tuning.
        """
        return pulumi.get(self, "sweep_settings")

    @sweep_settings.setter
    def sweep_settings(self, value: Optional[pulumi.Input['TableSweepSettingsArgs']]):
        pulumi.set(self, "sweep_settings", value)

    @property
    @pulumi.getter(name="targetColumnName")
    def target_column_name(self) -> Optional[pulumi.Input[str]]:
        """
        Target column name: This is prediction values column.
        Also known as label column name in context of classification tasks.
        """
        return pulumi.get(self, "target_column_name")

    @target_column_name.setter
    def target_column_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_column_name", value)

    @property
    @pulumi.getter(name="testData")
    def test_data(self) -> Optional[pulumi.Input['MLTableJobInputArgs']]:
        """
        Test data input.
        """
        return pulumi.get(self, "test_data")

    @test_data.setter
    def test_data(self, value: Optional[pulumi.Input['MLTableJobInputArgs']]):
        pulumi.set(self, "test_data", value)

    @property
    @pulumi.getter(name="testDataSize")
    def test_data_size(self) -> Optional[pulumi.Input[float]]:
        """
        The fraction of test dataset that needs to be set aside for validation purpose.
        Values between (0.0 , 1.0)
        Applied when validation dataset is not provided.
        """
        return pulumi.get(self, "test_data_size")

    @test_data_size.setter
    def test_data_size(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "test_data_size", value)

    @property
    @pulumi.getter(name="trainingSettings")
    def training_settings(self) -> Optional[pulumi.Input['ClassificationTrainingSettingsArgs']]:
        """
        Inputs for training phase for an AutoML Job.
        """
        return pulumi.get(self, "training_settings")

    @training_settings.setter
    def training_settings(self, value: Optional[pulumi.Input['ClassificationTrainingSettingsArgs']]):
        pulumi.set(self, "training_settings", value)

    @property
    @pulumi.getter(name="validationData")
    def validation_data(self) -> Optional[pulumi.Input['MLTableJobInputArgs']]:
        """
        Validation data inputs.
        """
        return pulumi.get(self, "validation_data")

    @validation_data.setter
    def validation_data(self, value: Optional[pulumi.Input['MLTableJobInputArgs']]):
        pulumi.set(self, "validation_data", value)

    @property
    @pulumi.getter(name="validationDataSize")
    def validation_data_size(self) -> Optional[pulumi.Input[float]]:
        """
        The fraction of training dataset that needs to be set aside for validation purpose.
        Values between (0.0 , 1.0)
        Applied when validation dataset is not provided.
        """
        return pulumi.get(self, "validation_data_size")

    @validation_data_size.setter
    def validation_data_size(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "validation_data_size", value)

    @property
    @pulumi.getter(name="weightColumnName")
    def weight_column_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the sample weight column. Automated ML supports a weighted column as an input, causing rows in the data to be weighted up or down.
        """
        return pulumi.get(self, "weight_column_name")

    @weight_column_name.setter
    def weight_column_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "weight_column_name", value)


@pulumi.input_type
class CodeConfigurationArgs:
    def __init__(__self__, *,
                 scoring_script: pulumi.Input[str],
                 code_id: Optional[pulumi.Input[str]] = None):
        """
        Configuration for a scoring code asset.
        :param pulumi.Input[str] scoring_script: [Required] The script to execute on startup. eg. "score.py"
        :param pulumi.Input[str] code_id: ARM resource ID of the code asset.
        """
        pulumi.set(__self__, "scoring_script", scoring_script)
        if code_id is not None:
            pulumi.set(__self__, "code_id", code_id)

    @property
    @pulumi.getter(name="scoringScript")
    def scoring_script(self) -> pulumi.Input[str]:
        """
        [Required] The script to execute on startup. eg. "score.py"
        """
        return pulumi.get(self, "scoring_script")

    @scoring_script.setter
    def scoring_script(self, value: pulumi.Input[str]):
        pulumi.set(self, "scoring_script", value)

    @property
    @pulumi.getter(name="codeId")
    def code_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM resource ID of the code asset.
        """
        return pulumi.get(self, "code_id")

    @code_id.setter
    def code_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "code_id", value)


@pulumi.input_type
class CodeContainerArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 is_archived: Optional[pulumi.Input[bool]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Container for code asset versions.
        :param pulumi.Input[str] description: The asset description text.
        :param pulumi.Input[bool] is_archived: Is the asset archived?
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: The asset property dictionary.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Tag dictionary. Tags can be added, removed, and updated.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if is_archived is None:
            is_archived = False
        if is_archived is not None:
            pulumi.set(__self__, "is_archived", is_archived)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The asset description text.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="isArchived")
    def is_archived(self) -> Optional[pulumi.Input[bool]]:
        """
        Is the asset archived?
        """
        return pulumi.get(self, "is_archived")

    @is_archived.setter
    def is_archived(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_archived", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The asset property dictionary.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Tag dictionary. Tags can be added, removed, and updated.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class CodeVersionArgs:
    def __init__(__self__, *,
                 code_uri: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 is_anonymous: Optional[pulumi.Input[bool]] = None,
                 is_archived: Optional[pulumi.Input[bool]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Code asset version details.
        :param pulumi.Input[str] code_uri: Uri where code is located
        :param pulumi.Input[str] description: The asset description text.
        :param pulumi.Input[bool] is_anonymous: If the name version are system generated (anonymous registration).
        :param pulumi.Input[bool] is_archived: Is the asset archived?
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: The asset property dictionary.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Tag dictionary. Tags can be added, removed, and updated.
        """
        if code_uri is not None:
            pulumi.set(__self__, "code_uri", code_uri)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if is_anonymous is None:
            is_anonymous = False
        if is_anonymous is not None:
            pulumi.set(__self__, "is_anonymous", is_anonymous)
        if is_archived is None:
            is_archived = False
        if is_archived is not None:
            pulumi.set(__self__, "is_archived", is_archived)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="codeUri")
    def code_uri(self) -> Optional[pulumi.Input[str]]:
        """
        Uri where code is located
        """
        return pulumi.get(self, "code_uri")

    @code_uri.setter
    def code_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "code_uri", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The asset description text.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="isAnonymous")
    def is_anonymous(self) -> Optional[pulumi.Input[bool]]:
        """
        If the name version are system generated (anonymous registration).
        """
        return pulumi.get(self, "is_anonymous")

    @is_anonymous.setter
    def is_anonymous(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_anonymous", value)

    @property
    @pulumi.getter(name="isArchived")
    def is_archived(self) -> Optional[pulumi.Input[bool]]:
        """
        Is the asset archived?
        """
        return pulumi.get(self, "is_archived")

    @is_archived.setter
    def is_archived(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_archived", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The asset property dictionary.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Tag dictionary. Tags can be added, removed, and updated.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class ColumnTransformerArgs:
    def __init__(__self__, *,
                 fields: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 parameters: Optional[Any] = None):
        """
        Column transformer parameters.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] fields: Fields to apply transformer logic on.
        :param Any parameters: Different properties to be passed to transformer.
               Input expected is dictionary of key,value pairs in JSON format.
        """
        if fields is not None:
            pulumi.set(__self__, "fields", fields)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def fields(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Fields to apply transformer logic on.
        """
        return pulumi.get(self, "fields")

    @fields.setter
    def fields(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "fields", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Any]:
        """
        Different properties to be passed to transformer.
        Input expected is dictionary of key,value pairs in JSON format.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[Any]):
        pulumi.set(self, "parameters", value)


@pulumi.input_type
class CommandJobLimitsArgs:
    def __init__(__self__, *,
                 job_limits_type: pulumi.Input[str],
                 timeout: Optional[pulumi.Input[str]] = None):
        """
        Command Job limit class.
        :param pulumi.Input[str] job_limits_type: 
               Expected value is 'Command'.
        :param pulumi.Input[str] timeout: The max run duration in ISO 8601 format, after which the job will be cancelled. Only supports duration with precision as low as Seconds.
        """
        pulumi.set(__self__, "job_limits_type", 'Command')
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter(name="jobLimitsType")
    def job_limits_type(self) -> pulumi.Input[str]:
        """

        Expected value is 'Command'.
        """
        return pulumi.get(self, "job_limits_type")

    @job_limits_type.setter
    def job_limits_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "job_limits_type", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[str]]:
        """
        The max run duration in ISO 8601 format, after which the job will be cancelled. Only supports duration with precision as low as Seconds.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timeout", value)


@pulumi.input_type
class CommandJobArgs:
    def __init__(__self__, *,
                 command: pulumi.Input[str],
                 environment_id: pulumi.Input[str],
                 job_type: pulumi.Input[str],
                 autologger_settings: Optional[pulumi.Input['AutologgerSettingsArgs']] = None,
                 code_id: Optional[pulumi.Input[str]] = None,
                 component_id: Optional[pulumi.Input[str]] = None,
                 compute_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 distribution: Optional[pulumi.Input[Union['MpiArgs', 'PyTorchArgs', 'TensorFlowArgs']]] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 experiment_name: Optional[pulumi.Input[str]] = None,
                 identity: Optional[pulumi.Input[Union['AmlTokenArgs', 'ManagedIdentityArgs', 'UserIdentityArgs']]] = None,
                 inputs: Optional[pulumi.Input[Mapping[str, pulumi.Input[Union['CustomModelJobInputArgs', 'LiteralJobInputArgs', 'MLFlowModelJobInputArgs', 'MLTableJobInputArgs', 'TritonModelJobInputArgs', 'UriFileJobInputArgs', 'UriFolderJobInputArgs']]]]] = None,
                 is_archived: Optional[pulumi.Input[bool]] = None,
                 limits: Optional[pulumi.Input['CommandJobLimitsArgs']] = None,
                 outputs: Optional[pulumi.Input[Mapping[str, pulumi.Input[Union['CustomModelJobOutputArgs', 'MLFlowModelJobOutputArgs', 'MLTableJobOutputArgs', 'TritonModelJobOutputArgs', 'UriFileJobOutputArgs', 'UriFolderJobOutputArgs']]]]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 resources: Optional[pulumi.Input['JobResourceConfigurationArgs']] = None,
                 services: Optional[pulumi.Input[Mapping[str, pulumi.Input['JobServiceArgs']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Command job definition.
        :param pulumi.Input[str] command: [Required] The command to execute on startup of the job. eg. "python train.py"
        :param pulumi.Input[str] environment_id: [Required] The ARM resource ID of the Environment specification for the job.
        :param pulumi.Input[str] job_type: Enum to determine the type of job.
               Expected value is 'Command'.
        :param pulumi.Input['AutologgerSettingsArgs'] autologger_settings: Distribution configuration of the job. If set, this should be one of Mpi, Tensorflow, PyTorch, or null.
        :param pulumi.Input[str] code_id: ARM resource ID of the code asset.
        :param pulumi.Input[str] component_id: ARM resource ID of the component resource.
        :param pulumi.Input[str] compute_id: ARM resource ID of the compute resource.
        :param pulumi.Input[str] description: The asset description text.
        :param pulumi.Input[str] display_name: Display name of job.
        :param pulumi.Input[Union['MpiArgs', 'PyTorchArgs', 'TensorFlowArgs']] distribution: Distribution configuration of the job. If set, this should be one of Mpi, Tensorflow, PyTorch, or null.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] environment_variables: Environment variables included in the job.
        :param pulumi.Input[str] experiment_name: The name of the experiment the job belongs to. If not set, the job is placed in the "Default" experiment.
        :param pulumi.Input[Union['AmlTokenArgs', 'ManagedIdentityArgs', 'UserIdentityArgs']] identity: Identity configuration. If set, this should be one of AmlToken, ManagedIdentity, UserIdentity or null.
               Defaults to AmlToken if null.
        :param pulumi.Input[Mapping[str, pulumi.Input[Union['CustomModelJobInputArgs', 'LiteralJobInputArgs', 'MLFlowModelJobInputArgs', 'MLTableJobInputArgs', 'TritonModelJobInputArgs', 'UriFileJobInputArgs', 'UriFolderJobInputArgs']]]] inputs: Mapping of input data bindings used in the job.
        :param pulumi.Input[bool] is_archived: Is the asset archived?
        :param pulumi.Input['CommandJobLimitsArgs'] limits: Command Job limit.
        :param pulumi.Input[Mapping[str, pulumi.Input[Union['CustomModelJobOutputArgs', 'MLFlowModelJobOutputArgs', 'MLTableJobOutputArgs', 'TritonModelJobOutputArgs', 'UriFileJobOutputArgs', 'UriFolderJobOutputArgs']]]] outputs: Mapping of output data bindings used in the job.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: The asset property dictionary.
        :param pulumi.Input['JobResourceConfigurationArgs'] resources: Compute Resource configuration for the job.
        :param pulumi.Input[Mapping[str, pulumi.Input['JobServiceArgs']]] services: List of JobEndpoints.
               For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Tag dictionary. Tags can be added, removed, and updated.
        """
        pulumi.set(__self__, "command", command)
        pulumi.set(__self__, "environment_id", environment_id)
        pulumi.set(__self__, "job_type", 'Command')
        if autologger_settings is not None:
            pulumi.set(__self__, "autologger_settings", autologger_settings)
        if code_id is not None:
            pulumi.set(__self__, "code_id", code_id)
        if component_id is not None:
            pulumi.set(__self__, "component_id", component_id)
        if compute_id is not None:
            pulumi.set(__self__, "compute_id", compute_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if distribution is not None:
            pulumi.set(__self__, "distribution", distribution)
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if experiment_name is None:
            experiment_name = 'Default'
        if experiment_name is not None:
            pulumi.set(__self__, "experiment_name", experiment_name)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if inputs is not None:
            pulumi.set(__self__, "inputs", inputs)
        if is_archived is None:
            is_archived = False
        if is_archived is not None:
            pulumi.set(__self__, "is_archived", is_archived)
        if limits is not None:
            pulumi.set(__self__, "limits", limits)
        if outputs is not None:
            pulumi.set(__self__, "outputs", outputs)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)
        if services is not None:
            pulumi.set(__self__, "services", services)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def command(self) -> pulumi.Input[str]:
        """
        [Required] The command to execute on startup of the job. eg. "python train.py"
        """
        return pulumi.get(self, "command")

    @command.setter
    def command(self, value: pulumi.Input[str]):
        pulumi.set(self, "command", value)

    @property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> pulumi.Input[str]:
        """
        [Required] The ARM resource ID of the Environment specification for the job.
        """
        return pulumi.get(self, "environment_id")

    @environment_id.setter
    def environment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "environment_id", value)

    @property
    @pulumi.getter(name="jobType")
    def job_type(self) -> pulumi.Input[str]:
        """
        Enum to determine the type of job.
        Expected value is 'Command'.
        """
        return pulumi.get(self, "job_type")

    @job_type.setter
    def job_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "job_type", value)

    @property
    @pulumi.getter(name="autologgerSettings")
    def autologger_settings(self) -> Optional[pulumi.Input['AutologgerSettingsArgs']]:
        """
        Distribution configuration of the job. If set, this should be one of Mpi, Tensorflow, PyTorch, or null.
        """
        return pulumi.get(self, "autologger_settings")

    @autologger_settings.setter
    def autologger_settings(self, value: Optional[pulumi.Input['AutologgerSettingsArgs']]):
        pulumi.set(self, "autologger_settings", value)

    @property
    @pulumi.getter(name="codeId")
    def code_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM resource ID of the code asset.
        """
        return pulumi.get(self, "code_id")

    @code_id.setter
    def code_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "code_id", value)

    @property
    @pulumi.getter(name="componentId")
    def component_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM resource ID of the component resource.
        """
        return pulumi.get(self, "component_id")

    @component_id.setter
    def component_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "component_id", value)

    @property
    @pulumi.getter(name="computeId")
    def compute_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM resource ID of the compute resource.
        """
        return pulumi.get(self, "compute_id")

    @compute_id.setter
    def compute_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compute_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The asset description text.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        Display name of job.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def distribution(self) -> Optional[pulumi.Input[Union['MpiArgs', 'PyTorchArgs', 'TensorFlowArgs']]]:
        """
        Distribution configuration of the job. If set, this should be one of Mpi, Tensorflow, PyTorch, or null.
        """
        return pulumi.get(self, "distribution")

    @distribution.setter
    def distribution(self, value: Optional[pulumi.Input[Union['MpiArgs', 'PyTorchArgs', 'TensorFlowArgs']]]):
        pulumi.set(self, "distribution", value)

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Environment variables included in the job.
        """
        return pulumi.get(self, "environment_variables")

    @environment_variables.setter
    def environment_variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "environment_variables", value)

    @property
    @pulumi.getter(name="experimentName")
    def experiment_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the experiment the job belongs to. If not set, the job is placed in the "Default" experiment.
        """
        return pulumi.get(self, "experiment_name")

    @experiment_name.setter
    def experiment_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "experiment_name", value)

    @property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input[Union['AmlTokenArgs', 'ManagedIdentityArgs', 'UserIdentityArgs']]]:
        """
        Identity configuration. If set, this should be one of AmlToken, ManagedIdentity, UserIdentity or null.
        Defaults to AmlToken if null.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input[Union['AmlTokenArgs', 'ManagedIdentityArgs', 'UserIdentityArgs']]]):
        pulumi.set(self, "identity", value)

    @property
    @pulumi.getter
    def inputs(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[Union['CustomModelJobInputArgs', 'LiteralJobInputArgs', 'MLFlowModelJobInputArgs', 'MLTableJobInputArgs', 'TritonModelJobInputArgs', 'UriFileJobInputArgs', 'UriFolderJobInputArgs']]]]]:
        """
        Mapping of input data bindings used in the job.
        """
        return pulumi.get(self, "inputs")

    @inputs.setter
    def inputs(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[Union['CustomModelJobInputArgs', 'LiteralJobInputArgs', 'MLFlowModelJobInputArgs', 'MLTableJobInputArgs', 'TritonModelJobInputArgs', 'UriFileJobInputArgs', 'UriFolderJobInputArgs']]]]]):
        pulumi.set(self, "inputs", value)

    @property
    @pulumi.getter(name="isArchived")
    def is_archived(self) -> Optional[pulumi.Input[bool]]:
        """
        Is the asset archived?
        """
        return pulumi.get(self, "is_archived")

    @is_archived.setter
    def is_archived(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_archived", value)

    @property
    @pulumi.getter
    def limits(self) -> Optional[pulumi.Input['CommandJobLimitsArgs']]:
        """
        Command Job limit.
        """
        return pulumi.get(self, "limits")

    @limits.setter
    def limits(self, value: Optional[pulumi.Input['CommandJobLimitsArgs']]):
        pulumi.set(self, "limits", value)

    @property
    @pulumi.getter
    def outputs(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[Union['CustomModelJobOutputArgs', 'MLFlowModelJobOutputArgs', 'MLTableJobOutputArgs', 'TritonModelJobOutputArgs', 'UriFileJobOutputArgs', 'UriFolderJobOutputArgs']]]]]:
        """
        Mapping of output data bindings used in the job.
        """
        return pulumi.get(self, "outputs")

    @outputs.setter
    def outputs(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[Union['CustomModelJobOutputArgs', 'MLFlowModelJobOutputArgs', 'MLTableJobOutputArgs', 'TritonModelJobOutputArgs', 'UriFileJobOutputArgs', 'UriFolderJobOutputArgs']]]]]):
        pulumi.set(self, "outputs", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The asset property dictionary.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter
    def resources(self) -> Optional[pulumi.Input['JobResourceConfigurationArgs']]:
        """
        Compute Resource configuration for the job.
        """
        return pulumi.get(self, "resources")

    @resources.setter
    def resources(self, value: Optional[pulumi.Input['JobResourceConfigurationArgs']]):
        pulumi.set(self, "resources", value)

    @property
    @pulumi.getter
    def services(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['JobServiceArgs']]]]:
        """
        List of JobEndpoints.
        For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
        """
        return pulumi.get(self, "services")

    @services.setter
    def services(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['JobServiceArgs']]]]):
        pulumi.set(self, "services", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Tag dictionary. Tags can be added, removed, and updated.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class ComponentContainerArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 is_archived: Optional[pulumi.Input[bool]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Component container definition.
        <see href="https://docs.microsoft.com/en-us/azure/machine-learning/reference-yaml-component-command" />
        :param pulumi.Input[str] description: The asset description text.
        :param pulumi.Input[bool] is_archived: Is the asset archived?
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: The asset property dictionary.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Tag dictionary. Tags can be added, removed, and updated.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if is_archived is None:
            is_archived = False
        if is_archived is not None:
            pulumi.set(__self__, "is_archived", is_archived)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The asset description text.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="isArchived")
    def is_archived(self) -> Optional[pulumi.Input[bool]]:
        """
        Is the asset archived?
        """
        return pulumi.get(self, "is_archived")

    @is_archived.setter
    def is_archived(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_archived", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The asset property dictionary.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Tag dictionary. Tags can be added, removed, and updated.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class ComponentVersionArgs:
    def __init__(__self__, *,
                 component_spec: Optional[Any] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 is_anonymous: Optional[pulumi.Input[bool]] = None,
                 is_archived: Optional[pulumi.Input[bool]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Definition of a component version: defines resources that span component types.
        :param Any component_spec: Defines Component definition details.
               <see href="https://docs.microsoft.com/en-us/azure/machine-learning/reference-yaml-component-command" />
        :param pulumi.Input[str] description: The asset description text.
        :param pulumi.Input[bool] is_anonymous: If the name version are system generated (anonymous registration).
        :param pulumi.Input[bool] is_archived: Is the asset archived?
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: The asset property dictionary.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Tag dictionary. Tags can be added, removed, and updated.
        """
        if component_spec is not None:
            pulumi.set(__self__, "component_spec", component_spec)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if is_anonymous is None:
            is_anonymous = False
        if is_anonymous is not None:
            pulumi.set(__self__, "is_anonymous", is_anonymous)
        if is_archived is None:
            is_archived = False
        if is_archived is not None:
            pulumi.set(__self__, "is_archived", is_archived)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="componentSpec")
    def component_spec(self) -> Optional[Any]:
        """
        Defines Component definition details.
        <see href="https://docs.microsoft.com/en-us/azure/machine-learning/reference-yaml-component-command" />
        """
        return pulumi.get(self, "component_spec")

    @component_spec.setter
    def component_spec(self, value: Optional[Any]):
        pulumi.set(self, "component_spec", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The asset description text.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="isAnonymous")
    def is_anonymous(self) -> Optional[pulumi.Input[bool]]:
        """
        If the name version are system generated (anonymous registration).
        """
        return pulumi.get(self, "is_anonymous")

    @is_anonymous.setter
    def is_anonymous(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_anonymous", value)

    @property
    @pulumi.getter(name="isArchived")
    def is_archived(self) -> Optional[pulumi.Input[bool]]:
        """
        Is the asset archived?
        """
        return pulumi.get(self, "is_archived")

    @is_archived.setter
    def is_archived(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_archived", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The asset property dictionary.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Tag dictionary. Tags can be added, removed, and updated.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class ComputeInstanceAutologgerSettingsArgs:
    def __init__(__self__, *,
                 mlflow_autologger: Optional[pulumi.Input[Union[str, 'MlflowAutologger']]] = None):
        """
        Specifies settings for autologger.
        :param pulumi.Input[Union[str, 'MlflowAutologger']] mlflow_autologger: Indicates whether mlflow autologger is enabled for notebooks.
        """
        if mlflow_autologger is not None:
            pulumi.set(__self__, "mlflow_autologger", mlflow_autologger)

    @property
    @pulumi.getter(name="mlflowAutologger")
    def mlflow_autologger(self) -> Optional[pulumi.Input[Union[str, 'MlflowAutologger']]]:
        """
        Indicates whether mlflow autologger is enabled for notebooks.
        """
        return pulumi.get(self, "mlflow_autologger")

    @mlflow_autologger.setter
    def mlflow_autologger(self, value: Optional[pulumi.Input[Union[str, 'MlflowAutologger']]]):
        pulumi.set(self, "mlflow_autologger", value)


@pulumi.input_type
class ComputeInstancePropertiesArgs:
    def __init__(__self__, *,
                 application_sharing_policy: Optional[pulumi.Input[Union[str, 'ApplicationSharingPolicy']]] = None,
                 autologger_settings: Optional[pulumi.Input['ComputeInstanceAutologgerSettingsArgs']] = None,
                 compute_instance_authorization_type: Optional[pulumi.Input[Union[str, 'ComputeInstanceAuthorizationType']]] = None,
                 custom_services: Optional[pulumi.Input[Sequence[pulumi.Input['CustomServiceArgs']]]] = None,
                 enable_node_public_ip: Optional[pulumi.Input[bool]] = None,
                 idle_time_before_shutdown: Optional[pulumi.Input[str]] = None,
                 personal_compute_instance_settings: Optional[pulumi.Input['PersonalComputeInstanceSettingsArgs']] = None,
                 schedules: Optional[pulumi.Input['ComputeSchedulesArgs']] = None,
                 setup_scripts: Optional[pulumi.Input['SetupScriptsArgs']] = None,
                 ssh_settings: Optional[pulumi.Input['ComputeInstanceSshSettingsArgs']] = None,
                 subnet: Optional[pulumi.Input['ResourceIdArgs']] = None,
                 vm_size: Optional[pulumi.Input[str]] = None):
        """
        Compute Instance properties
        :param pulumi.Input[Union[str, 'ApplicationSharingPolicy']] application_sharing_policy: Policy for sharing applications on this compute instance among users of parent workspace. If Personal, only the creator can access applications on this compute instance. When Shared, any workspace user can access applications on this instance depending on his/her assigned role.
        :param pulumi.Input['ComputeInstanceAutologgerSettingsArgs'] autologger_settings: Specifies settings for autologger.
        :param pulumi.Input[Union[str, 'ComputeInstanceAuthorizationType']] compute_instance_authorization_type: The Compute Instance Authorization type. Available values are personal (default).
        :param pulumi.Input[Sequence[pulumi.Input['CustomServiceArgs']]] custom_services: List of Custom Services added to the compute.
        :param pulumi.Input[bool] enable_node_public_ip: Enable or disable node public IP address provisioning. Possible values are: Possible values are: true - Indicates that the compute nodes will have public IPs provisioned. false - Indicates that the compute nodes will have a private endpoint and no public IPs.
        :param pulumi.Input[str] idle_time_before_shutdown: Stops compute instance after user defined period of inactivity. Time is defined in ISO8601 format. Minimum is 15 min, maximum is 3 days.
        :param pulumi.Input['PersonalComputeInstanceSettingsArgs'] personal_compute_instance_settings: Settings for a personal compute instance.
        :param pulumi.Input['ComputeSchedulesArgs'] schedules: The list of schedules to be applied on the computes.
        :param pulumi.Input['SetupScriptsArgs'] setup_scripts: Details of customized scripts to execute for setting up the cluster.
        :param pulumi.Input['ComputeInstanceSshSettingsArgs'] ssh_settings: Specifies policy and settings for SSH access.
        :param pulumi.Input['ResourceIdArgs'] subnet: Virtual network subnet resource ID the compute nodes belong to.
        :param pulumi.Input[str] vm_size: Virtual Machine Size
        """
        if application_sharing_policy is None:
            application_sharing_policy = 'Shared'
        if application_sharing_policy is not None:
            pulumi.set(__self__, "application_sharing_policy", application_sharing_policy)
        if autologger_settings is not None:
            pulumi.set(__self__, "autologger_settings", autologger_settings)
        if compute_instance_authorization_type is None:
            compute_instance_authorization_type = 'personal'
        if compute_instance_authorization_type is not None:
            pulumi.set(__self__, "compute_instance_authorization_type", compute_instance_authorization_type)
        if custom_services is not None:
            pulumi.set(__self__, "custom_services", custom_services)
        if enable_node_public_ip is not None:
            pulumi.set(__self__, "enable_node_public_ip", enable_node_public_ip)
        if idle_time_before_shutdown is not None:
            pulumi.set(__self__, "idle_time_before_shutdown", idle_time_before_shutdown)
        if personal_compute_instance_settings is not None:
            pulumi.set(__self__, "personal_compute_instance_settings", personal_compute_instance_settings)
        if schedules is not None:
            pulumi.set(__self__, "schedules", schedules)
        if setup_scripts is not None:
            pulumi.set(__self__, "setup_scripts", setup_scripts)
        if ssh_settings is not None:
            pulumi.set(__self__, "ssh_settings", ssh_settings)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)
        if vm_size is not None:
            pulumi.set(__self__, "vm_size", vm_size)

    @property
    @pulumi.getter(name="applicationSharingPolicy")
    def application_sharing_policy(self) -> Optional[pulumi.Input[Union[str, 'ApplicationSharingPolicy']]]:
        """
        Policy for sharing applications on this compute instance among users of parent workspace. If Personal, only the creator can access applications on this compute instance. When Shared, any workspace user can access applications on this instance depending on his/her assigned role.
        """
        return pulumi.get(self, "application_sharing_policy")

    @application_sharing_policy.setter
    def application_sharing_policy(self, value: Optional[pulumi.Input[Union[str, 'ApplicationSharingPolicy']]]):
        pulumi.set(self, "application_sharing_policy", value)

    @property
    @pulumi.getter(name="autologgerSettings")
    def autologger_settings(self) -> Optional[pulumi.Input['ComputeInstanceAutologgerSettingsArgs']]:
        """
        Specifies settings for autologger.
        """
        return pulumi.get(self, "autologger_settings")

    @autologger_settings.setter
    def autologger_settings(self, value: Optional[pulumi.Input['ComputeInstanceAutologgerSettingsArgs']]):
        pulumi.set(self, "autologger_settings", value)

    @property
    @pulumi.getter(name="computeInstanceAuthorizationType")
    def compute_instance_authorization_type(self) -> Optional[pulumi.Input[Union[str, 'ComputeInstanceAuthorizationType']]]:
        """
        The Compute Instance Authorization type. Available values are personal (default).
        """
        return pulumi.get(self, "compute_instance_authorization_type")

    @compute_instance_authorization_type.setter
    def compute_instance_authorization_type(self, value: Optional[pulumi.Input[Union[str, 'ComputeInstanceAuthorizationType']]]):
        pulumi.set(self, "compute_instance_authorization_type", value)

    @property
    @pulumi.getter(name="customServices")
    def custom_services(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CustomServiceArgs']]]]:
        """
        List of Custom Services added to the compute.
        """
        return pulumi.get(self, "custom_services")

    @custom_services.setter
    def custom_services(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CustomServiceArgs']]]]):
        pulumi.set(self, "custom_services", value)

    @property
    @pulumi.getter(name="enableNodePublicIp")
    def enable_node_public_ip(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable or disable node public IP address provisioning. Possible values are: Possible values are: true - Indicates that the compute nodes will have public IPs provisioned. false - Indicates that the compute nodes will have a private endpoint and no public IPs.
        """
        return pulumi.get(self, "enable_node_public_ip")

    @enable_node_public_ip.setter
    def enable_node_public_ip(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_node_public_ip", value)

    @property
    @pulumi.getter(name="idleTimeBeforeShutdown")
    def idle_time_before_shutdown(self) -> Optional[pulumi.Input[str]]:
        """
        Stops compute instance after user defined period of inactivity. Time is defined in ISO8601 format. Minimum is 15 min, maximum is 3 days.
        """
        return pulumi.get(self, "idle_time_before_shutdown")

    @idle_time_before_shutdown.setter
    def idle_time_before_shutdown(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "idle_time_before_shutdown", value)

    @property
    @pulumi.getter(name="personalComputeInstanceSettings")
    def personal_compute_instance_settings(self) -> Optional[pulumi.Input['PersonalComputeInstanceSettingsArgs']]:
        """
        Settings for a personal compute instance.
        """
        return pulumi.get(self, "personal_compute_instance_settings")

    @personal_compute_instance_settings.setter
    def personal_compute_instance_settings(self, value: Optional[pulumi.Input['PersonalComputeInstanceSettingsArgs']]):
        pulumi.set(self, "personal_compute_instance_settings", value)

    @property
    @pulumi.getter
    def schedules(self) -> Optional[pulumi.Input['ComputeSchedulesArgs']]:
        """
        The list of schedules to be applied on the computes.
        """
        return pulumi.get(self, "schedules")

    @schedules.setter
    def schedules(self, value: Optional[pulumi.Input['ComputeSchedulesArgs']]):
        pulumi.set(self, "schedules", value)

    @property
    @pulumi.getter(name="setupScripts")
    def setup_scripts(self) -> Optional[pulumi.Input['SetupScriptsArgs']]:
        """
        Details of customized scripts to execute for setting up the cluster.
        """
        return pulumi.get(self, "setup_scripts")

    @setup_scripts.setter
    def setup_scripts(self, value: Optional[pulumi.Input['SetupScriptsArgs']]):
        pulumi.set(self, "setup_scripts", value)

    @property
    @pulumi.getter(name="sshSettings")
    def ssh_settings(self) -> Optional[pulumi.Input['ComputeInstanceSshSettingsArgs']]:
        """
        Specifies policy and settings for SSH access.
        """
        return pulumi.get(self, "ssh_settings")

    @ssh_settings.setter
    def ssh_settings(self, value: Optional[pulumi.Input['ComputeInstanceSshSettingsArgs']]):
        pulumi.set(self, "ssh_settings", value)

    @property
    @pulumi.getter
    def subnet(self) -> Optional[pulumi.Input['ResourceIdArgs']]:
        """
        Virtual network subnet resource ID the compute nodes belong to.
        """
        return pulumi.get(self, "subnet")

    @subnet.setter
    def subnet(self, value: Optional[pulumi.Input['ResourceIdArgs']]):
        pulumi.set(self, "subnet", value)

    @property
    @pulumi.getter(name="vmSize")
    def vm_size(self) -> Optional[pulumi.Input[str]]:
        """
        Virtual Machine Size
        """
        return pulumi.get(self, "vm_size")

    @vm_size.setter
    def vm_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vm_size", value)


@pulumi.input_type
class ComputeInstanceSshSettingsArgs:
    def __init__(__self__, *,
                 admin_public_key: Optional[pulumi.Input[str]] = None,
                 ssh_public_access: Optional[pulumi.Input[Union[str, 'SshPublicAccess']]] = None):
        """
        Specifies policy and settings for SSH access.
        :param pulumi.Input[str] admin_public_key: Specifies the SSH rsa public key file as a string. Use "ssh-keygen -t rsa -b 2048" to generate your SSH key pairs.
        :param pulumi.Input[Union[str, 'SshPublicAccess']] ssh_public_access: State of the public SSH port. Possible values are: Disabled - Indicates that the public ssh port is closed on this instance. Enabled - Indicates that the public ssh port is open and accessible according to the VNet/subnet policy if applicable.
        """
        if admin_public_key is not None:
            pulumi.set(__self__, "admin_public_key", admin_public_key)
        if ssh_public_access is None:
            ssh_public_access = 'Disabled'
        if ssh_public_access is not None:
            pulumi.set(__self__, "ssh_public_access", ssh_public_access)

    @property
    @pulumi.getter(name="adminPublicKey")
    def admin_public_key(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the SSH rsa public key file as a string. Use "ssh-keygen -t rsa -b 2048" to generate your SSH key pairs.
        """
        return pulumi.get(self, "admin_public_key")

    @admin_public_key.setter
    def admin_public_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "admin_public_key", value)

    @property
    @pulumi.getter(name="sshPublicAccess")
    def ssh_public_access(self) -> Optional[pulumi.Input[Union[str, 'SshPublicAccess']]]:
        """
        State of the public SSH port. Possible values are: Disabled - Indicates that the public ssh port is closed on this instance. Enabled - Indicates that the public ssh port is open and accessible according to the VNet/subnet policy if applicable.
        """
        return pulumi.get(self, "ssh_public_access")

    @ssh_public_access.setter
    def ssh_public_access(self, value: Optional[pulumi.Input[Union[str, 'SshPublicAccess']]]):
        pulumi.set(self, "ssh_public_access", value)


@pulumi.input_type
class ComputeInstanceArgs:
    def __init__(__self__, *,
                 compute_type: pulumi.Input[str],
                 compute_location: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disable_local_auth: Optional[pulumi.Input[bool]] = None,
                 properties: Optional[pulumi.Input['ComputeInstancePropertiesArgs']] = None,
                 resource_id: Optional[pulumi.Input[str]] = None):
        """
        An Azure Machine Learning compute instance.
        :param pulumi.Input[str] compute_type: The type of compute
               Expected value is 'ComputeInstance'.
        :param pulumi.Input[str] compute_location: Location for the underlying compute
        :param pulumi.Input[str] description: The description of the Machine Learning compute.
        :param pulumi.Input[bool] disable_local_auth: Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
        :param pulumi.Input['ComputeInstancePropertiesArgs'] properties: Properties of ComputeInstance
        :param pulumi.Input[str] resource_id: ARM resource id of the underlying compute
        """
        pulumi.set(__self__, "compute_type", 'ComputeInstance')
        if compute_location is not None:
            pulumi.set(__self__, "compute_location", compute_location)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_local_auth is not None:
            pulumi.set(__self__, "disable_local_auth", disable_local_auth)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="computeType")
    def compute_type(self) -> pulumi.Input[str]:
        """
        The type of compute
        Expected value is 'ComputeInstance'.
        """
        return pulumi.get(self, "compute_type")

    @compute_type.setter
    def compute_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "compute_type", value)

    @property
    @pulumi.getter(name="computeLocation")
    def compute_location(self) -> Optional[pulumi.Input[str]]:
        """
        Location for the underlying compute
        """
        return pulumi.get(self, "compute_location")

    @compute_location.setter
    def compute_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compute_location", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the Machine Learning compute.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="disableLocalAuth")
    def disable_local_auth(self) -> Optional[pulumi.Input[bool]]:
        """
        Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
        """
        return pulumi.get(self, "disable_local_auth")

    @disable_local_auth.setter
    def disable_local_auth(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_local_auth", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input['ComputeInstancePropertiesArgs']]:
        """
        Properties of ComputeInstance
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input['ComputeInstancePropertiesArgs']]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM resource id of the underlying compute
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_id", value)


@pulumi.input_type
class ComputeRuntimeDtoArgs:
    def __init__(__self__, *,
                 spark_runtime_version: Optional[pulumi.Input[str]] = None):
        if spark_runtime_version is not None:
            pulumi.set(__self__, "spark_runtime_version", spark_runtime_version)

    @property
    @pulumi.getter(name="sparkRuntimeVersion")
    def spark_runtime_version(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "spark_runtime_version")

    @spark_runtime_version.setter
    def spark_runtime_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "spark_runtime_version", value)


@pulumi.input_type
class ComputeSchedulesArgs:
    def __init__(__self__, *,
                 compute_start_stop: Optional[pulumi.Input[Sequence[pulumi.Input['ComputeStartStopScheduleArgs']]]] = None):
        """
        The list of schedules to be applied on the computes
        :param pulumi.Input[Sequence[pulumi.Input['ComputeStartStopScheduleArgs']]] compute_start_stop: The list of compute start stop schedules to be applied.
        """
        if compute_start_stop is not None:
            pulumi.set(__self__, "compute_start_stop", compute_start_stop)

    @property
    @pulumi.getter(name="computeStartStop")
    def compute_start_stop(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ComputeStartStopScheduleArgs']]]]:
        """
        The list of compute start stop schedules to be applied.
        """
        return pulumi.get(self, "compute_start_stop")

    @compute_start_stop.setter
    def compute_start_stop(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ComputeStartStopScheduleArgs']]]]):
        pulumi.set(self, "compute_start_stop", value)


@pulumi.input_type
class ComputeStartStopScheduleArgs:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input[Union[str, 'ComputePowerAction']]] = None,
                 cron: Optional[pulumi.Input['CronTriggerArgs']] = None,
                 recurrence: Optional[pulumi.Input['RecurrenceTriggerArgs']] = None,
                 schedule: Optional[pulumi.Input['ScheduleBaseArgs']] = None,
                 status: Optional[pulumi.Input[Union[str, 'ScheduleStatus']]] = None,
                 trigger_type: Optional[pulumi.Input[Union[str, 'TriggerType']]] = None):
        """
        Compute start stop schedule properties
        :param pulumi.Input[Union[str, 'ComputePowerAction']] action: [Required] The compute power action.
        :param pulumi.Input['CronTriggerArgs'] cron: Required if triggerType is Cron.
        :param pulumi.Input['RecurrenceTriggerArgs'] recurrence: Required if triggerType is Recurrence.
        :param pulumi.Input['ScheduleBaseArgs'] schedule: [Deprecated] Not used any more.
        :param pulumi.Input[Union[str, 'ScheduleStatus']] status: Is the schedule enabled or disabled?
        :param pulumi.Input[Union[str, 'TriggerType']] trigger_type: [Required] The schedule trigger type.
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if cron is not None:
            pulumi.set(__self__, "cron", cron)
        if recurrence is not None:
            pulumi.set(__self__, "recurrence", recurrence)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if trigger_type is not None:
            pulumi.set(__self__, "trigger_type", trigger_type)

    @property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[Union[str, 'ComputePowerAction']]]:
        """
        [Required] The compute power action.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[Union[str, 'ComputePowerAction']]]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter
    def cron(self) -> Optional[pulumi.Input['CronTriggerArgs']]:
        """
        Required if triggerType is Cron.
        """
        return pulumi.get(self, "cron")

    @cron.setter
    def cron(self, value: Optional[pulumi.Input['CronTriggerArgs']]):
        pulumi.set(self, "cron", value)

    @property
    @pulumi.getter
    def recurrence(self) -> Optional[pulumi.Input['RecurrenceTriggerArgs']]:
        """
        Required if triggerType is Recurrence.
        """
        return pulumi.get(self, "recurrence")

    @recurrence.setter
    def recurrence(self, value: Optional[pulumi.Input['RecurrenceTriggerArgs']]):
        pulumi.set(self, "recurrence", value)

    @property
    @pulumi.getter
    def schedule(self) -> Optional[pulumi.Input['ScheduleBaseArgs']]:
        """
        [Deprecated] Not used any more.
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: Optional[pulumi.Input['ScheduleBaseArgs']]):
        pulumi.set(self, "schedule", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[Union[str, 'ScheduleStatus']]]:
        """
        Is the schedule enabled or disabled?
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[Union[str, 'ScheduleStatus']]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="triggerType")
    def trigger_type(self) -> Optional[pulumi.Input[Union[str, 'TriggerType']]]:
        """
        [Required] The schedule trigger type.
        """
        return pulumi.get(self, "trigger_type")

    @trigger_type.setter
    def trigger_type(self, value: Optional[pulumi.Input[Union[str, 'TriggerType']]]):
        pulumi.set(self, "trigger_type", value)


@pulumi.input_type
class ContainerResourceRequirementsArgs:
    def __init__(__self__, *,
                 container_resource_limits: Optional[pulumi.Input['ContainerResourceSettingsArgs']] = None,
                 container_resource_requests: Optional[pulumi.Input['ContainerResourceSettingsArgs']] = None):
        """
        Resource requirements for each container instance within an online deployment.
        :param pulumi.Input['ContainerResourceSettingsArgs'] container_resource_limits: Container resource limit info:
        :param pulumi.Input['ContainerResourceSettingsArgs'] container_resource_requests: Container resource request info:
        """
        if container_resource_limits is not None:
            pulumi.set(__self__, "container_resource_limits", container_resource_limits)
        if container_resource_requests is not None:
            pulumi.set(__self__, "container_resource_requests", container_resource_requests)

    @property
    @pulumi.getter(name="containerResourceLimits")
    def container_resource_limits(self) -> Optional[pulumi.Input['ContainerResourceSettingsArgs']]:
        """
        Container resource limit info:
        """
        return pulumi.get(self, "container_resource_limits")

    @container_resource_limits.setter
    def container_resource_limits(self, value: Optional[pulumi.Input['ContainerResourceSettingsArgs']]):
        pulumi.set(self, "container_resource_limits", value)

    @property
    @pulumi.getter(name="containerResourceRequests")
    def container_resource_requests(self) -> Optional[pulumi.Input['ContainerResourceSettingsArgs']]:
        """
        Container resource request info:
        """
        return pulumi.get(self, "container_resource_requests")

    @container_resource_requests.setter
    def container_resource_requests(self, value: Optional[pulumi.Input['ContainerResourceSettingsArgs']]):
        pulumi.set(self, "container_resource_requests", value)


@pulumi.input_type
class ContainerResourceSettingsArgs:
    def __init__(__self__, *,
                 cpu: Optional[pulumi.Input[str]] = None,
                 gpu: Optional[pulumi.Input[str]] = None,
                 memory: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] cpu: Number of vCPUs request/limit for container. More info:
               https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/
        :param pulumi.Input[str] gpu: Number of Nvidia GPU cards request/limit for container. More info:
               https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/
        :param pulumi.Input[str] memory: Memory size request/limit for container. More info:
               https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/
        """
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if gpu is not None:
            pulumi.set(__self__, "gpu", gpu)
        if memory is not None:
            pulumi.set(__self__, "memory", memory)

    @property
    @pulumi.getter
    def cpu(self) -> Optional[pulumi.Input[str]]:
        """
        Number of vCPUs request/limit for container. More info:
        https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/
        """
        return pulumi.get(self, "cpu")

    @cpu.setter
    def cpu(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cpu", value)

    @property
    @pulumi.getter
    def gpu(self) -> Optional[pulumi.Input[str]]:
        """
        Number of Nvidia GPU cards request/limit for container. More info:
        https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/
        """
        return pulumi.get(self, "gpu")

    @gpu.setter
    def gpu(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gpu", value)

    @property
    @pulumi.getter
    def memory(self) -> Optional[pulumi.Input[str]]:
        """
        Memory size request/limit for container. More info:
        https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/
        """
        return pulumi.get(self, "memory")

    @memory.setter
    def memory(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "memory", value)


@pulumi.input_type
class CosmosDbSettingsArgs:
    def __init__(__self__, *,
                 collections_throughput: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] collections_throughput: The throughput of the collections in cosmosdb database
        """
        if collections_throughput is not None:
            pulumi.set(__self__, "collections_throughput", collections_throughput)

    @property
    @pulumi.getter(name="collectionsThroughput")
    def collections_throughput(self) -> Optional[pulumi.Input[int]]:
        """
        The throughput of the collections in cosmosdb database
        """
        return pulumi.get(self, "collections_throughput")

    @collections_throughput.setter
    def collections_throughput(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "collections_throughput", value)


@pulumi.input_type
class CronTriggerArgs:
    def __init__(__self__, *,
                 expression: pulumi.Input[str],
                 trigger_type: pulumi.Input[str],
                 end_time: Optional[pulumi.Input[str]] = None,
                 start_time: Optional[pulumi.Input[str]] = None,
                 time_zone: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] expression: [Required] Specifies cron expression of schedule.
               The expression should follow NCronTab format.
        :param pulumi.Input[str] trigger_type: 
               Expected value is 'Cron'.
        :param pulumi.Input[str] end_time: Specifies end time of schedule in ISO 8601, but without a UTC offset. Refer https://en.wikipedia.org/wiki/ISO_8601.
               Recommented format would be "2022-06-01T00:00:01"
               If not present, the schedule will run indefinitely
        :param pulumi.Input[str] start_time: Specifies start time of schedule in ISO 8601 format, but without a UTC offset.
        :param pulumi.Input[str] time_zone: Specifies time zone in which the schedule runs.
               TimeZone should follow Windows time zone format. Refer: https://docs.microsoft.com/en-us/windows-hardware/manufacture/desktop/default-time-zones?view=windows-11
        """
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "trigger_type", 'Cron')
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if time_zone is None:
            time_zone = 'UTC'
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)

    @property
    @pulumi.getter
    def expression(self) -> pulumi.Input[str]:
        """
        [Required] Specifies cron expression of schedule.
        The expression should follow NCronTab format.
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: pulumi.Input[str]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter(name="triggerType")
    def trigger_type(self) -> pulumi.Input[str]:
        """

        Expected value is 'Cron'.
        """
        return pulumi.get(self, "trigger_type")

    @trigger_type.setter
    def trigger_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "trigger_type", value)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies end time of schedule in ISO 8601, but without a UTC offset. Refer https://en.wikipedia.org/wiki/ISO_8601.
        Recommented format would be "2022-06-01T00:00:01"
        If not present, the schedule will run indefinitely
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "end_time", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies start time of schedule in ISO 8601 format, but without a UTC offset.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_time", value)

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies time zone in which the schedule runs.
        TimeZone should follow Windows time zone format. Refer: https://docs.microsoft.com/en-us/windows-hardware/manufacture/desktop/default-time-zones?view=windows-11
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_zone", value)


@pulumi.input_type
class CustomForecastHorizonArgs:
    def __init__(__self__, *,
                 mode: pulumi.Input[str],
                 value: pulumi.Input[int]):
        """
        The desired maximum forecast horizon in units of time-series frequency.
        :param pulumi.Input[str] mode: Enum to determine forecast horizon selection mode.
               Expected value is 'Custom'.
        :param pulumi.Input[int] value: [Required] Forecast horizon value.
        """
        pulumi.set(__self__, "mode", 'Custom')
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def mode(self) -> pulumi.Input[str]:
        """
        Enum to determine forecast horizon selection mode.
        Expected value is 'Custom'.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: pulumi.Input[str]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[int]:
        """
        [Required] Forecast horizon value.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[int]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class CustomModelJobInputArgs:
    def __init__(__self__, *,
                 job_input_type: pulumi.Input[str],
                 uri: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 mode: Optional[pulumi.Input[Union[str, 'InputDeliveryMode']]] = None):
        """
        :param pulumi.Input[str] job_input_type: Enum to determine the Job Input Type.
               Expected value is 'custom_model'.
        :param pulumi.Input[str] uri: [Required] Input Asset URI.
        :param pulumi.Input[str] description: Description for the input.
        :param pulumi.Input[Union[str, 'InputDeliveryMode']] mode: Input Asset Delivery Mode.
        """
        pulumi.set(__self__, "job_input_type", 'custom_model')
        pulumi.set(__self__, "uri", uri)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if mode is None:
            mode = 'ReadOnlyMount'
        if mode is not None:
            pulumi.set(__self__, "mode", mode)

    @property
    @pulumi.getter(name="jobInputType")
    def job_input_type(self) -> pulumi.Input[str]:
        """
        Enum to determine the Job Input Type.
        Expected value is 'custom_model'.
        """
        return pulumi.get(self, "job_input_type")

    @job_input_type.setter
    def job_input_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "job_input_type", value)

    @property
    @pulumi.getter
    def uri(self) -> pulumi.Input[str]:
        """
        [Required] Input Asset URI.
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: pulumi.Input[str]):
        pulumi.set(self, "uri", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description for the input.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[Union[str, 'InputDeliveryMode']]]:
        """
        Input Asset Delivery Mode.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[Union[str, 'InputDeliveryMode']]]):
        pulumi.set(self, "mode", value)


@pulumi.input_type
class CustomModelJobOutputArgs:
    def __init__(__self__, *,
                 job_output_type: pulumi.Input[str],
                 asset_name: Optional[pulumi.Input[str]] = None,
                 asset_version: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 mode: Optional[pulumi.Input[Union[str, 'OutputDeliveryMode']]] = None,
                 uri: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] job_output_type: Enum to determine the Job Output Type.
               Expected value is 'custom_model'.
        :param pulumi.Input[str] asset_name: Output Asset Name.
        :param pulumi.Input[str] asset_version: Output Asset Version.
        :param pulumi.Input[str] description: Description for the output.
        :param pulumi.Input[Union[str, 'OutputDeliveryMode']] mode: Output Asset Delivery Mode.
        :param pulumi.Input[str] uri: Output Asset URI.
        """
        pulumi.set(__self__, "job_output_type", 'custom_model')
        if asset_name is not None:
            pulumi.set(__self__, "asset_name", asset_name)
        if asset_version is not None:
            pulumi.set(__self__, "asset_version", asset_version)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if mode is None:
            mode = 'ReadWriteMount'
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter(name="jobOutputType")
    def job_output_type(self) -> pulumi.Input[str]:
        """
        Enum to determine the Job Output Type.
        Expected value is 'custom_model'.
        """
        return pulumi.get(self, "job_output_type")

    @job_output_type.setter
    def job_output_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "job_output_type", value)

    @property
    @pulumi.getter(name="assetName")
    def asset_name(self) -> Optional[pulumi.Input[str]]:
        """
        Output Asset Name.
        """
        return pulumi.get(self, "asset_name")

    @asset_name.setter
    def asset_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "asset_name", value)

    @property
    @pulumi.getter(name="assetVersion")
    def asset_version(self) -> Optional[pulumi.Input[str]]:
        """
        Output Asset Version.
        """
        return pulumi.get(self, "asset_version")

    @asset_version.setter
    def asset_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "asset_version", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description for the output.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[Union[str, 'OutputDeliveryMode']]]:
        """
        Output Asset Delivery Mode.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[Union[str, 'OutputDeliveryMode']]]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter
    def uri(self) -> Optional[pulumi.Input[str]]:
        """
        Output Asset URI.
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uri", value)


@pulumi.input_type
class CustomNCrossValidationsArgs:
    def __init__(__self__, *,
                 mode: pulumi.Input[str],
                 value: pulumi.Input[int]):
        """
        N-Cross validations are specified by user.
        :param pulumi.Input[str] mode: Determines how N-Cross validations value is determined.
               Expected value is 'Custom'.
        :param pulumi.Input[int] value: [Required] N-Cross validations value.
        """
        pulumi.set(__self__, "mode", 'Custom')
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def mode(self) -> pulumi.Input[str]:
        """
        Determines how N-Cross validations value is determined.
        Expected value is 'Custom'.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: pulumi.Input[str]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[int]:
        """
        [Required] N-Cross validations value.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[int]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class CustomSeasonalityArgs:
    def __init__(__self__, *,
                 mode: pulumi.Input[str],
                 value: pulumi.Input[int]):
        """
        :param pulumi.Input[str] mode: Forecasting seasonality mode.
               Expected value is 'Custom'.
        :param pulumi.Input[int] value: [Required] Seasonality value.
        """
        pulumi.set(__self__, "mode", 'Custom')
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def mode(self) -> pulumi.Input[str]:
        """
        Forecasting seasonality mode.
        Expected value is 'Custom'.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: pulumi.Input[str]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[int]:
        """
        [Required] Seasonality value.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[int]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class CustomServiceArgs:
    def __init__(__self__, *,
                 docker: Optional[pulumi.Input['DockerArgs']] = None,
                 endpoints: Optional[pulumi.Input[Sequence[pulumi.Input['EndpointArgs']]]] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input['EnvironmentVariableArgs']]]] = None,
                 image: Optional[pulumi.Input['ImageArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 volumes: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeDefinitionArgs']]]] = None):
        """
        Specifies the custom service configuration
        :param pulumi.Input['DockerArgs'] docker: Describes the docker settings for the image
        :param pulumi.Input[Sequence[pulumi.Input['EndpointArgs']]] endpoints: Configuring the endpoints for the container
        :param pulumi.Input[Mapping[str, pulumi.Input['EnvironmentVariableArgs']]] environment_variables: Environment Variable for the container
        :param pulumi.Input['ImageArgs'] image: Describes the Image Specifications
        :param pulumi.Input[str] name: Name of the Custom Service
        :param pulumi.Input[Sequence[pulumi.Input['VolumeDefinitionArgs']]] volumes: Configuring the volumes for the container
        """
        if docker is not None:
            pulumi.set(__self__, "docker", docker)
        if endpoints is not None:
            pulumi.set(__self__, "endpoints", endpoints)
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if volumes is not None:
            pulumi.set(__self__, "volumes", volumes)

    @property
    @pulumi.getter
    def docker(self) -> Optional[pulumi.Input['DockerArgs']]:
        """
        Describes the docker settings for the image
        """
        return pulumi.get(self, "docker")

    @docker.setter
    def docker(self, value: Optional[pulumi.Input['DockerArgs']]):
        pulumi.set(self, "docker", value)

    @property
    @pulumi.getter
    def endpoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EndpointArgs']]]]:
        """
        Configuring the endpoints for the container
        """
        return pulumi.get(self, "endpoints")

    @endpoints.setter
    def endpoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EndpointArgs']]]]):
        pulumi.set(self, "endpoints", value)

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['EnvironmentVariableArgs']]]]:
        """
        Environment Variable for the container
        """
        return pulumi.get(self, "environment_variables")

    @environment_variables.setter
    def environment_variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['EnvironmentVariableArgs']]]]):
        pulumi.set(self, "environment_variables", value)

    @property
    @pulumi.getter
    def image(self) -> Optional[pulumi.Input['ImageArgs']]:
        """
        Describes the Image Specifications
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: Optional[pulumi.Input['ImageArgs']]):
        pulumi.set(self, "image", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the Custom Service
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def volumes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VolumeDefinitionArgs']]]]:
        """
        Configuring the volumes for the container
        """
        return pulumi.get(self, "volumes")

    @volumes.setter
    def volumes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeDefinitionArgs']]]]):
        pulumi.set(self, "volumes", value)


@pulumi.input_type
class CustomTargetLagsArgs:
    def __init__(__self__, *,
                 mode: pulumi.Input[str],
                 values: pulumi.Input[Sequence[pulumi.Input[int]]]):
        """
        :param pulumi.Input[str] mode: Target lags selection modes.
               Expected value is 'Custom'.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] values: [Required] Set target lags values.
        """
        pulumi.set(__self__, "mode", 'Custom')
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def mode(self) -> pulumi.Input[str]:
        """
        Target lags selection modes.
        Expected value is 'Custom'.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: pulumi.Input[str]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter
    def values(self) -> pulumi.Input[Sequence[pulumi.Input[int]]]:
        """
        [Required] Set target lags values.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: pulumi.Input[Sequence[pulumi.Input[int]]]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class CustomTargetRollingWindowSizeArgs:
    def __init__(__self__, *,
                 mode: pulumi.Input[str],
                 value: pulumi.Input[int]):
        """
        :param pulumi.Input[str] mode: Target rolling windows size mode.
               Expected value is 'Custom'.
        :param pulumi.Input[int] value: [Required] TargetRollingWindowSize value.
        """
        pulumi.set(__self__, "mode", 'Custom')
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def mode(self) -> pulumi.Input[str]:
        """
        Target rolling windows size mode.
        Expected value is 'Custom'.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: pulumi.Input[str]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[int]:
        """
        [Required] TargetRollingWindowSize value.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[int]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class DataContainerArgs:
    def __init__(__self__, *,
                 data_type: pulumi.Input[Union[str, 'DataType']],
                 description: Optional[pulumi.Input[str]] = None,
                 is_archived: Optional[pulumi.Input[bool]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Container for data asset versions.
        :param pulumi.Input[Union[str, 'DataType']] data_type: [Required] Specifies the type of data.
        :param pulumi.Input[str] description: The asset description text.
        :param pulumi.Input[bool] is_archived: Is the asset archived?
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: The asset property dictionary.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Tag dictionary. Tags can be added, removed, and updated.
        """
        pulumi.set(__self__, "data_type", data_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if is_archived is None:
            is_archived = False
        if is_archived is not None:
            pulumi.set(__self__, "is_archived", is_archived)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="dataType")
    def data_type(self) -> pulumi.Input[Union[str, 'DataType']]:
        """
        [Required] Specifies the type of data.
        """
        return pulumi.get(self, "data_type")

    @data_type.setter
    def data_type(self, value: pulumi.Input[Union[str, 'DataType']]):
        pulumi.set(self, "data_type", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The asset description text.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="isArchived")
    def is_archived(self) -> Optional[pulumi.Input[bool]]:
        """
        Is the asset archived?
        """
        return pulumi.get(self, "is_archived")

    @is_archived.setter
    def is_archived(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_archived", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The asset property dictionary.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Tag dictionary. Tags can be added, removed, and updated.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class DataFactoryArgs:
    def __init__(__self__, *,
                 compute_type: pulumi.Input[str],
                 compute_location: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disable_local_auth: Optional[pulumi.Input[bool]] = None,
                 resource_id: Optional[pulumi.Input[str]] = None):
        """
        A DataFactory compute.
        :param pulumi.Input[str] compute_type: The type of compute
               Expected value is 'DataFactory'.
        :param pulumi.Input[str] compute_location: Location for the underlying compute
        :param pulumi.Input[str] description: The description of the Machine Learning compute.
        :param pulumi.Input[bool] disable_local_auth: Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
        :param pulumi.Input[str] resource_id: ARM resource id of the underlying compute
        """
        pulumi.set(__self__, "compute_type", 'DataFactory')
        if compute_location is not None:
            pulumi.set(__self__, "compute_location", compute_location)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_local_auth is not None:
            pulumi.set(__self__, "disable_local_auth", disable_local_auth)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="computeType")
    def compute_type(self) -> pulumi.Input[str]:
        """
        The type of compute
        Expected value is 'DataFactory'.
        """
        return pulumi.get(self, "compute_type")

    @compute_type.setter
    def compute_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "compute_type", value)

    @property
    @pulumi.getter(name="computeLocation")
    def compute_location(self) -> Optional[pulumi.Input[str]]:
        """
        Location for the underlying compute
        """
        return pulumi.get(self, "compute_location")

    @compute_location.setter
    def compute_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compute_location", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the Machine Learning compute.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="disableLocalAuth")
    def disable_local_auth(self) -> Optional[pulumi.Input[bool]]:
        """
        Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
        """
        return pulumi.get(self, "disable_local_auth")

    @disable_local_auth.setter
    def disable_local_auth(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_local_auth", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM resource id of the underlying compute
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_id", value)


@pulumi.input_type
class DataLakeAnalyticsSchemaPropertiesArgs:
    def __init__(__self__, *,
                 data_lake_store_account_name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] data_lake_store_account_name: DataLake Store Account Name
        """
        if data_lake_store_account_name is not None:
            pulumi.set(__self__, "data_lake_store_account_name", data_lake_store_account_name)

    @property
    @pulumi.getter(name="dataLakeStoreAccountName")
    def data_lake_store_account_name(self) -> Optional[pulumi.Input[str]]:
        """
        DataLake Store Account Name
        """
        return pulumi.get(self, "data_lake_store_account_name")

    @data_lake_store_account_name.setter
    def data_lake_store_account_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_lake_store_account_name", value)


@pulumi.input_type
class DataLakeAnalyticsArgs:
    def __init__(__self__, *,
                 compute_type: pulumi.Input[str],
                 compute_location: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disable_local_auth: Optional[pulumi.Input[bool]] = None,
                 properties: Optional[pulumi.Input['DataLakeAnalyticsSchemaPropertiesArgs']] = None,
                 resource_id: Optional[pulumi.Input[str]] = None):
        """
        A DataLakeAnalytics compute.
        :param pulumi.Input[str] compute_type: The type of compute
               Expected value is 'DataLakeAnalytics'.
        :param pulumi.Input[str] compute_location: Location for the underlying compute
        :param pulumi.Input[str] description: The description of the Machine Learning compute.
        :param pulumi.Input[bool] disable_local_auth: Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
        :param pulumi.Input[str] resource_id: ARM resource id of the underlying compute
        """
        pulumi.set(__self__, "compute_type", 'DataLakeAnalytics')
        if compute_location is not None:
            pulumi.set(__self__, "compute_location", compute_location)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_local_auth is not None:
            pulumi.set(__self__, "disable_local_auth", disable_local_auth)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="computeType")
    def compute_type(self) -> pulumi.Input[str]:
        """
        The type of compute
        Expected value is 'DataLakeAnalytics'.
        """
        return pulumi.get(self, "compute_type")

    @compute_type.setter
    def compute_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "compute_type", value)

    @property
    @pulumi.getter(name="computeLocation")
    def compute_location(self) -> Optional[pulumi.Input[str]]:
        """
        Location for the underlying compute
        """
        return pulumi.get(self, "compute_location")

    @compute_location.setter
    def compute_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compute_location", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the Machine Learning compute.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="disableLocalAuth")
    def disable_local_auth(self) -> Optional[pulumi.Input[bool]]:
        """
        Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
        """
        return pulumi.get(self, "disable_local_auth")

    @disable_local_auth.setter
    def disable_local_auth(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_local_auth", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input['DataLakeAnalyticsSchemaPropertiesArgs']]:
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input['DataLakeAnalyticsSchemaPropertiesArgs']]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM resource id of the underlying compute
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_id", value)


@pulumi.input_type
class DataPathAssetReferenceArgs:
    def __init__(__self__, *,
                 reference_type: pulumi.Input[str],
                 datastore_id: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None):
        """
        Reference to an asset via its path in a datastore.
        :param pulumi.Input[str] reference_type: Enum to determine which reference method to use for an asset.
               Expected value is 'DataPath'.
        :param pulumi.Input[str] datastore_id: ARM resource ID of the datastore where the asset is located.
        :param pulumi.Input[str] path: The path of the file/directory in the datastore.
        """
        pulumi.set(__self__, "reference_type", 'DataPath')
        if datastore_id is not None:
            pulumi.set(__self__, "datastore_id", datastore_id)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter(name="referenceType")
    def reference_type(self) -> pulumi.Input[str]:
        """
        Enum to determine which reference method to use for an asset.
        Expected value is 'DataPath'.
        """
        return pulumi.get(self, "reference_type")

    @reference_type.setter
    def reference_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "reference_type", value)

    @property
    @pulumi.getter(name="datastoreId")
    def datastore_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM resource ID of the datastore where the asset is located.
        """
        return pulumi.get(self, "datastore_id")

    @datastore_id.setter
    def datastore_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "datastore_id", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        The path of the file/directory in the datastore.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)


@pulumi.input_type
class DatabricksPropertiesArgs:
    def __init__(__self__, *,
                 databricks_access_token: Optional[pulumi.Input[str]] = None,
                 workspace_url: Optional[pulumi.Input[str]] = None):
        """
        Properties of Databricks
        :param pulumi.Input[str] databricks_access_token: Databricks access token
        :param pulumi.Input[str] workspace_url: Workspace Url
        """
        if databricks_access_token is not None:
            pulumi.set(__self__, "databricks_access_token", databricks_access_token)
        if workspace_url is not None:
            pulumi.set(__self__, "workspace_url", workspace_url)

    @property
    @pulumi.getter(name="databricksAccessToken")
    def databricks_access_token(self) -> Optional[pulumi.Input[str]]:
        """
        Databricks access token
        """
        return pulumi.get(self, "databricks_access_token")

    @databricks_access_token.setter
    def databricks_access_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "databricks_access_token", value)

    @property
    @pulumi.getter(name="workspaceUrl")
    def workspace_url(self) -> Optional[pulumi.Input[str]]:
        """
        Workspace Url
        """
        return pulumi.get(self, "workspace_url")

    @workspace_url.setter
    def workspace_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "workspace_url", value)


@pulumi.input_type
class DatabricksArgs:
    def __init__(__self__, *,
                 compute_type: pulumi.Input[str],
                 compute_location: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disable_local_auth: Optional[pulumi.Input[bool]] = None,
                 properties: Optional[pulumi.Input['DatabricksPropertiesArgs']] = None,
                 resource_id: Optional[pulumi.Input[str]] = None):
        """
        A DataFactory compute.
        :param pulumi.Input[str] compute_type: The type of compute
               Expected value is 'Databricks'.
        :param pulumi.Input[str] compute_location: Location for the underlying compute
        :param pulumi.Input[str] description: The description of the Machine Learning compute.
        :param pulumi.Input[bool] disable_local_auth: Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
        :param pulumi.Input['DatabricksPropertiesArgs'] properties: Properties of Databricks
        :param pulumi.Input[str] resource_id: ARM resource id of the underlying compute
        """
        pulumi.set(__self__, "compute_type", 'Databricks')
        if compute_location is not None:
            pulumi.set(__self__, "compute_location", compute_location)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_local_auth is not None:
            pulumi.set(__self__, "disable_local_auth", disable_local_auth)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="computeType")
    def compute_type(self) -> pulumi.Input[str]:
        """
        The type of compute
        Expected value is 'Databricks'.
        """
        return pulumi.get(self, "compute_type")

    @compute_type.setter
    def compute_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "compute_type", value)

    @property
    @pulumi.getter(name="computeLocation")
    def compute_location(self) -> Optional[pulumi.Input[str]]:
        """
        Location for the underlying compute
        """
        return pulumi.get(self, "compute_location")

    @compute_location.setter
    def compute_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compute_location", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the Machine Learning compute.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="disableLocalAuth")
    def disable_local_auth(self) -> Optional[pulumi.Input[bool]]:
        """
        Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
        """
        return pulumi.get(self, "disable_local_auth")

    @disable_local_auth.setter
    def disable_local_auth(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_local_auth", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input['DatabricksPropertiesArgs']]:
        """
        Properties of Databricks
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input['DatabricksPropertiesArgs']]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM resource id of the underlying compute
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_id", value)


@pulumi.input_type
class DefaultScaleSettingsArgs:
    def __init__(__self__, *,
                 scale_type: pulumi.Input[str]):
        """
        :param pulumi.Input[str] scale_type: 
               Expected value is 'Default'.
        """
        pulumi.set(__self__, "scale_type", 'Default')

    @property
    @pulumi.getter(name="scaleType")
    def scale_type(self) -> pulumi.Input[str]:
        """

        Expected value is 'Default'.
        """
        return pulumi.get(self, "scale_type")

    @scale_type.setter
    def scale_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "scale_type", value)


@pulumi.input_type
class DeploymentResourceConfigurationArgs:
    def __init__(__self__, *,
                 instance_count: Optional[pulumi.Input[int]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, Any]]] = None):
        """
        :param pulumi.Input[int] instance_count: Optional number of instances or nodes used by the compute target.
        :param pulumi.Input[str] instance_type: Optional type of VM used as supported by the compute target.
        :param pulumi.Input[Mapping[str, Any]] properties: Additional properties bag.
        """
        if instance_count is None:
            instance_count = 1
        if instance_count is not None:
            pulumi.set(__self__, "instance_count", instance_count)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> Optional[pulumi.Input[int]]:
        """
        Optional number of instances or nodes used by the compute target.
        """
        return pulumi.get(self, "instance_count")

    @instance_count.setter
    def instance_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "instance_count", value)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[str]]:
        """
        Optional type of VM used as supported by the compute target.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Additional properties bag.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "properties", value)


@pulumi.input_type
class DockerArgs:
    def __init__(__self__, *,
                 privileged: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[bool] privileged: Indicate whether container shall run in privileged or non-privileged mode.
        """
        if privileged is not None:
            pulumi.set(__self__, "privileged", privileged)

    @property
    @pulumi.getter
    def privileged(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicate whether container shall run in privileged or non-privileged mode.
        """
        return pulumi.get(self, "privileged")

    @privileged.setter
    def privileged(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "privileged", value)


@pulumi.input_type
class EncryptionKeyVaultPropertiesArgs:
    def __init__(__self__, *,
                 key_identifier: pulumi.Input[str],
                 key_vault_arm_id: pulumi.Input[str],
                 identity_client_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] key_identifier: Key vault uri to access the encryption key.
        :param pulumi.Input[str] key_vault_arm_id: The ArmId of the keyVault where the customer owned encryption key is present.
        :param pulumi.Input[str] identity_client_id: For future use - The client id of the identity which will be used to access key vault.
        """
        pulumi.set(__self__, "key_identifier", key_identifier)
        pulumi.set(__self__, "key_vault_arm_id", key_vault_arm_id)
        if identity_client_id is not None:
            pulumi.set(__self__, "identity_client_id", identity_client_id)

    @property
    @pulumi.getter(name="keyIdentifier")
    def key_identifier(self) -> pulumi.Input[str]:
        """
        Key vault uri to access the encryption key.
        """
        return pulumi.get(self, "key_identifier")

    @key_identifier.setter
    def key_identifier(self, value: pulumi.Input[str]):
        pulumi.set(self, "key_identifier", value)

    @property
    @pulumi.getter(name="keyVaultArmId")
    def key_vault_arm_id(self) -> pulumi.Input[str]:
        """
        The ArmId of the keyVault where the customer owned encryption key is present.
        """
        return pulumi.get(self, "key_vault_arm_id")

    @key_vault_arm_id.setter
    def key_vault_arm_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "key_vault_arm_id", value)

    @property
    @pulumi.getter(name="identityClientId")
    def identity_client_id(self) -> Optional[pulumi.Input[str]]:
        """
        For future use - The client id of the identity which will be used to access key vault.
        """
        return pulumi.get(self, "identity_client_id")

    @identity_client_id.setter
    def identity_client_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "identity_client_id", value)


@pulumi.input_type
class EncryptionPropertyArgs:
    def __init__(__self__, *,
                 key_vault_properties: pulumi.Input['EncryptionKeyVaultPropertiesArgs'],
                 status: pulumi.Input[Union[str, 'EncryptionStatus']],
                 identity: Optional[pulumi.Input['IdentityForCmkArgs']] = None):
        """
        :param pulumi.Input['EncryptionKeyVaultPropertiesArgs'] key_vault_properties: Customer Key vault properties.
        :param pulumi.Input[Union[str, 'EncryptionStatus']] status: Indicates whether or not the encryption is enabled for the workspace.
        :param pulumi.Input['IdentityForCmkArgs'] identity: The identity that will be used to access the key vault for encryption at rest.
        """
        pulumi.set(__self__, "key_vault_properties", key_vault_properties)
        pulumi.set(__self__, "status", status)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)

    @property
    @pulumi.getter(name="keyVaultProperties")
    def key_vault_properties(self) -> pulumi.Input['EncryptionKeyVaultPropertiesArgs']:
        """
        Customer Key vault properties.
        """
        return pulumi.get(self, "key_vault_properties")

    @key_vault_properties.setter
    def key_vault_properties(self, value: pulumi.Input['EncryptionKeyVaultPropertiesArgs']):
        pulumi.set(self, "key_vault_properties", value)

    @property
    @pulumi.getter
    def status(self) -> pulumi.Input[Union[str, 'EncryptionStatus']]:
        """
        Indicates whether or not the encryption is enabled for the workspace.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: pulumi.Input[Union[str, 'EncryptionStatus']]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['IdentityForCmkArgs']]:
        """
        The identity that will be used to access the key vault for encryption at rest.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['IdentityForCmkArgs']]):
        pulumi.set(self, "identity", value)


@pulumi.input_type
class EndpointAuthKeysArgs:
    def __init__(__self__, *,
                 primary_key: Optional[pulumi.Input[str]] = None,
                 secondary_key: Optional[pulumi.Input[str]] = None):
        """
        Keys for endpoint authentication.
        :param pulumi.Input[str] primary_key: The primary key.
        :param pulumi.Input[str] secondary_key: The secondary key.
        """
        if primary_key is not None:
            pulumi.set(__self__, "primary_key", primary_key)
        if secondary_key is not None:
            pulumi.set(__self__, "secondary_key", secondary_key)

    @property
    @pulumi.getter(name="primaryKey")
    def primary_key(self) -> Optional[pulumi.Input[str]]:
        """
        The primary key.
        """
        return pulumi.get(self, "primary_key")

    @primary_key.setter
    def primary_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "primary_key", value)

    @property
    @pulumi.getter(name="secondaryKey")
    def secondary_key(self) -> Optional[pulumi.Input[str]]:
        """
        The secondary key.
        """
        return pulumi.get(self, "secondary_key")

    @secondary_key.setter
    def secondary_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secondary_key", value)


@pulumi.input_type
class EndpointScheduleActionArgs:
    def __init__(__self__, *,
                 action_type: pulumi.Input[str],
                 endpoint_invocation_definition: Any):
        """
        :param pulumi.Input[str] action_type: 
               Expected value is 'InvokeBatchEndpoint'.
        :param Any endpoint_invocation_definition: [Required] Defines Schedule action definition details.
               <see href="TBD" />
        """
        pulumi.set(__self__, "action_type", 'InvokeBatchEndpoint')
        pulumi.set(__self__, "endpoint_invocation_definition", endpoint_invocation_definition)

    @property
    @pulumi.getter(name="actionType")
    def action_type(self) -> pulumi.Input[str]:
        """

        Expected value is 'InvokeBatchEndpoint'.
        """
        return pulumi.get(self, "action_type")

    @action_type.setter
    def action_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "action_type", value)

    @property
    @pulumi.getter(name="endpointInvocationDefinition")
    def endpoint_invocation_definition(self) -> Any:
        """
        [Required] Defines Schedule action definition details.
        <see href="TBD" />
        """
        return pulumi.get(self, "endpoint_invocation_definition")

    @endpoint_invocation_definition.setter
    def endpoint_invocation_definition(self, value: Any):
        pulumi.set(self, "endpoint_invocation_definition", value)


@pulumi.input_type
class EndpointArgs:
    def __init__(__self__, *,
                 host_ip: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 protocol: Optional[pulumi.Input[Union[str, 'Protocol']]] = None,
                 published: Optional[pulumi.Input[int]] = None,
                 target: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] host_ip: Host IP over which the application is exposed from the container
        :param pulumi.Input[str] name: Name of the Endpoint
        :param pulumi.Input[Union[str, 'Protocol']] protocol: Protocol over which communication will happen over this endpoint
        :param pulumi.Input[int] published: Port over which the application is exposed from container.
        :param pulumi.Input[int] target: Application port inside the container.
        """
        if host_ip is not None:
            pulumi.set(__self__, "host_ip", host_ip)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if protocol is None:
            protocol = 'tcp'
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if published is not None:
            pulumi.set(__self__, "published", published)
        if target is not None:
            pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter(name="hostIp")
    def host_ip(self) -> Optional[pulumi.Input[str]]:
        """
        Host IP over which the application is exposed from the container
        """
        return pulumi.get(self, "host_ip")

    @host_ip.setter
    def host_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_ip", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the Endpoint
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[Union[str, 'Protocol']]]:
        """
        Protocol over which communication will happen over this endpoint
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[Union[str, 'Protocol']]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter
    def published(self) -> Optional[pulumi.Input[int]]:
        """
        Port over which the application is exposed from container.
        """
        return pulumi.get(self, "published")

    @published.setter
    def published(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "published", value)

    @property
    @pulumi.getter
    def target(self) -> Optional[pulumi.Input[int]]:
        """
        Application port inside the container.
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "target", value)


@pulumi.input_type
class EnvironmentContainerArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 is_archived: Optional[pulumi.Input[bool]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Container for environment specification versions.
        :param pulumi.Input[str] description: The asset description text.
        :param pulumi.Input[bool] is_archived: Is the asset archived?
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: The asset property dictionary.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Tag dictionary. Tags can be added, removed, and updated.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if is_archived is None:
            is_archived = False
        if is_archived is not None:
            pulumi.set(__self__, "is_archived", is_archived)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The asset description text.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="isArchived")
    def is_archived(self) -> Optional[pulumi.Input[bool]]:
        """
        Is the asset archived?
        """
        return pulumi.get(self, "is_archived")

    @is_archived.setter
    def is_archived(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_archived", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The asset property dictionary.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Tag dictionary. Tags can be added, removed, and updated.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class EnvironmentVariableArgs:
    def __init__(__self__, *,
                 type: Optional[pulumi.Input[Union[str, 'EnvironmentVariableType']]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Union[str, 'EnvironmentVariableType']] type: Type of the Environment Variable. Possible values are: local - For local variable
        :param pulumi.Input[str] value: Value of the Environment variable
        """
        if type is None:
            type = 'local'
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[Union[str, 'EnvironmentVariableType']]]:
        """
        Type of the Environment Variable. Possible values are: local - For local variable
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[Union[str, 'EnvironmentVariableType']]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        Value of the Environment variable
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class EnvironmentVersionArgs:
    def __init__(__self__, *,
                 auto_rebuild: Optional[pulumi.Input[Union[str, 'AutoRebuildSetting']]] = None,
                 build: Optional[pulumi.Input['BuildContextArgs']] = None,
                 conda_file: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 image: Optional[pulumi.Input[str]] = None,
                 inference_config: Optional[pulumi.Input['InferenceContainerPropertiesArgs']] = None,
                 is_anonymous: Optional[pulumi.Input[bool]] = None,
                 is_archived: Optional[pulumi.Input[bool]] = None,
                 os_type: Optional[pulumi.Input[Union[str, 'OperatingSystemType']]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Environment version details.
        :param pulumi.Input[Union[str, 'AutoRebuildSetting']] auto_rebuild: Defines if image needs to be rebuilt based on base image changes.
        :param pulumi.Input['BuildContextArgs'] build: Configuration settings for Docker build context.
        :param pulumi.Input[str] conda_file: Standard configuration file used by Conda that lets you install any kind of package, including Python, R, and C/C++ packages.
               <see href="https://repo2docker.readthedocs.io/en/latest/config_files.html#environment-yml-install-a-conda-environment" />
        :param pulumi.Input[str] description: The asset description text.
        :param pulumi.Input[str] image: Name of the image that will be used for the environment.
               <seealso href="https://docs.microsoft.com/en-us/azure/machine-learning/how-to-deploy-custom-docker-image#use-a-custom-base-image" />
        :param pulumi.Input['InferenceContainerPropertiesArgs'] inference_config: Defines configuration specific to inference.
        :param pulumi.Input[bool] is_anonymous: If the name version are system generated (anonymous registration).
        :param pulumi.Input[bool] is_archived: Is the asset archived?
        :param pulumi.Input[Union[str, 'OperatingSystemType']] os_type: The OS type of the environment.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: The asset property dictionary.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Tag dictionary. Tags can be added, removed, and updated.
        """
        if auto_rebuild is None:
            auto_rebuild = 'Disabled'
        if auto_rebuild is not None:
            pulumi.set(__self__, "auto_rebuild", auto_rebuild)
        if build is not None:
            pulumi.set(__self__, "build", build)
        if conda_file is not None:
            pulumi.set(__self__, "conda_file", conda_file)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if inference_config is not None:
            pulumi.set(__self__, "inference_config", inference_config)
        if is_anonymous is None:
            is_anonymous = False
        if is_anonymous is not None:
            pulumi.set(__self__, "is_anonymous", is_anonymous)
        if is_archived is None:
            is_archived = False
        if is_archived is not None:
            pulumi.set(__self__, "is_archived", is_archived)
        if os_type is None:
            os_type = 'Linux'
        if os_type is not None:
            pulumi.set(__self__, "os_type", os_type)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="autoRebuild")
    def auto_rebuild(self) -> Optional[pulumi.Input[Union[str, 'AutoRebuildSetting']]]:
        """
        Defines if image needs to be rebuilt based on base image changes.
        """
        return pulumi.get(self, "auto_rebuild")

    @auto_rebuild.setter
    def auto_rebuild(self, value: Optional[pulumi.Input[Union[str, 'AutoRebuildSetting']]]):
        pulumi.set(self, "auto_rebuild", value)

    @property
    @pulumi.getter
    def build(self) -> Optional[pulumi.Input['BuildContextArgs']]:
        """
        Configuration settings for Docker build context.
        """
        return pulumi.get(self, "build")

    @build.setter
    def build(self, value: Optional[pulumi.Input['BuildContextArgs']]):
        pulumi.set(self, "build", value)

    @property
    @pulumi.getter(name="condaFile")
    def conda_file(self) -> Optional[pulumi.Input[str]]:
        """
        Standard configuration file used by Conda that lets you install any kind of package, including Python, R, and C/C++ packages.
        <see href="https://repo2docker.readthedocs.io/en/latest/config_files.html#environment-yml-install-a-conda-environment" />
        """
        return pulumi.get(self, "conda_file")

    @conda_file.setter
    def conda_file(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "conda_file", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The asset description text.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def image(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the image that will be used for the environment.
        <seealso href="https://docs.microsoft.com/en-us/azure/machine-learning/how-to-deploy-custom-docker-image#use-a-custom-base-image" />
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image", value)

    @property
    @pulumi.getter(name="inferenceConfig")
    def inference_config(self) -> Optional[pulumi.Input['InferenceContainerPropertiesArgs']]:
        """
        Defines configuration specific to inference.
        """
        return pulumi.get(self, "inference_config")

    @inference_config.setter
    def inference_config(self, value: Optional[pulumi.Input['InferenceContainerPropertiesArgs']]):
        pulumi.set(self, "inference_config", value)

    @property
    @pulumi.getter(name="isAnonymous")
    def is_anonymous(self) -> Optional[pulumi.Input[bool]]:
        """
        If the name version are system generated (anonymous registration).
        """
        return pulumi.get(self, "is_anonymous")

    @is_anonymous.setter
    def is_anonymous(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_anonymous", value)

    @property
    @pulumi.getter(name="isArchived")
    def is_archived(self) -> Optional[pulumi.Input[bool]]:
        """
        Is the asset archived?
        """
        return pulumi.get(self, "is_archived")

    @is_archived.setter
    def is_archived(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_archived", value)

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> Optional[pulumi.Input[Union[str, 'OperatingSystemType']]]:
        """
        The OS type of the environment.
        """
        return pulumi.get(self, "os_type")

    @os_type.setter
    def os_type(self, value: Optional[pulumi.Input[Union[str, 'OperatingSystemType']]]):
        pulumi.set(self, "os_type", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The asset property dictionary.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Tag dictionary. Tags can be added, removed, and updated.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class FeatureStoreSettingsArgs:
    def __init__(__self__, *,
                 allow_role_assignments_on_resource_group_level: Optional[pulumi.Input[bool]] = None,
                 compute_runtime: Optional[pulumi.Input['ComputeRuntimeDtoArgs']] = None,
                 offline_store_connection_name: Optional[pulumi.Input[str]] = None,
                 online_store_connection_name: Optional[pulumi.Input[str]] = None):
        if allow_role_assignments_on_resource_group_level is not None:
            pulumi.set(__self__, "allow_role_assignments_on_resource_group_level", allow_role_assignments_on_resource_group_level)
        if compute_runtime is not None:
            pulumi.set(__self__, "compute_runtime", compute_runtime)
        if offline_store_connection_name is not None:
            pulumi.set(__self__, "offline_store_connection_name", offline_store_connection_name)
        if online_store_connection_name is not None:
            pulumi.set(__self__, "online_store_connection_name", online_store_connection_name)

    @property
    @pulumi.getter(name="allowRoleAssignmentsOnResourceGroupLevel")
    def allow_role_assignments_on_resource_group_level(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "allow_role_assignments_on_resource_group_level")

    @allow_role_assignments_on_resource_group_level.setter
    def allow_role_assignments_on_resource_group_level(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_role_assignments_on_resource_group_level", value)

    @property
    @pulumi.getter(name="computeRuntime")
    def compute_runtime(self) -> Optional[pulumi.Input['ComputeRuntimeDtoArgs']]:
        return pulumi.get(self, "compute_runtime")

    @compute_runtime.setter
    def compute_runtime(self, value: Optional[pulumi.Input['ComputeRuntimeDtoArgs']]):
        pulumi.set(self, "compute_runtime", value)

    @property
    @pulumi.getter(name="offlineStoreConnectionName")
    def offline_store_connection_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "offline_store_connection_name")

    @offline_store_connection_name.setter
    def offline_store_connection_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "offline_store_connection_name", value)

    @property
    @pulumi.getter(name="onlineStoreConnectionName")
    def online_store_connection_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "online_store_connection_name")

    @online_store_connection_name.setter
    def online_store_connection_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "online_store_connection_name", value)


@pulumi.input_type
class FlavorDataArgs:
    def __init__(__self__, *,
                 data: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] data: Model flavor-specific data.
        """
        if data is not None:
            pulumi.set(__self__, "data", data)

    @property
    @pulumi.getter
    def data(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Model flavor-specific data.
        """
        return pulumi.get(self, "data")

    @data.setter
    def data(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "data", value)


@pulumi.input_type
class ForecastingSettingsArgs:
    def __init__(__self__, *,
                 country_or_region_for_holidays: Optional[pulumi.Input[str]] = None,
                 cv_step_size: Optional[pulumi.Input[int]] = None,
                 feature_lags: Optional[pulumi.Input[Union[str, 'FeatureLags']]] = None,
                 forecast_horizon: Optional[pulumi.Input[Union['AutoForecastHorizonArgs', 'CustomForecastHorizonArgs']]] = None,
                 frequency: Optional[pulumi.Input[str]] = None,
                 seasonality: Optional[pulumi.Input[Union['AutoSeasonalityArgs', 'CustomSeasonalityArgs']]] = None,
                 short_series_handling_config: Optional[pulumi.Input[Union[str, 'ShortSeriesHandlingConfiguration']]] = None,
                 target_aggregate_function: Optional[pulumi.Input[Union[str, 'TargetAggregationFunction']]] = None,
                 target_lags: Optional[pulumi.Input[Union['AutoTargetLagsArgs', 'CustomTargetLagsArgs']]] = None,
                 target_rolling_window_size: Optional[pulumi.Input[Union['AutoTargetRollingWindowSizeArgs', 'CustomTargetRollingWindowSizeArgs']]] = None,
                 time_column_name: Optional[pulumi.Input[str]] = None,
                 time_series_id_column_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 use_stl: Optional[pulumi.Input[Union[str, 'UseStl']]] = None):
        """
        Forecasting specific parameters.
        :param pulumi.Input[str] country_or_region_for_holidays: Country or region for holidays for forecasting tasks.
               These should be ISO 3166 two-letter country/region codes, for example 'US' or 'GB'.
        :param pulumi.Input[int] cv_step_size: Number of periods between the origin time of one CV fold and the next fold. For
               example, if `CVStepSize` = 3 for daily data, the origin time for each fold will be
               three days apart.
        :param pulumi.Input[Union[str, 'FeatureLags']] feature_lags: Flag for generating lags for the numeric features with 'auto' or null.
        :param pulumi.Input[Union['AutoForecastHorizonArgs', 'CustomForecastHorizonArgs']] forecast_horizon: The desired maximum forecast horizon in units of time-series frequency.
        :param pulumi.Input[str] frequency: When forecasting, this parameter represents the period with which the forecast is desired, for example daily, weekly, yearly, etc. The forecast frequency is dataset frequency by default.
        :param pulumi.Input[Union['AutoSeasonalityArgs', 'CustomSeasonalityArgs']] seasonality: Set time series seasonality as an integer multiple of the series frequency.
               If seasonality is set to 'auto', it will be inferred.
        :param pulumi.Input[Union[str, 'ShortSeriesHandlingConfiguration']] short_series_handling_config: The parameter defining how if AutoML should handle short time series.
        :param pulumi.Input[Union[str, 'TargetAggregationFunction']] target_aggregate_function: The function to be used to aggregate the time series target column to conform to a user specified frequency.
               If the TargetAggregateFunction is set i.e. not 'None', but the freq parameter is not set, the error is raised. The possible target aggregation functions are: "sum", "max", "min" and "mean".
        :param pulumi.Input[Union['AutoTargetLagsArgs', 'CustomTargetLagsArgs']] target_lags: The number of past periods to lag from the target column.
        :param pulumi.Input[Union['AutoTargetRollingWindowSizeArgs', 'CustomTargetRollingWindowSizeArgs']] target_rolling_window_size: The number of past periods used to create a rolling window average of the target column.
        :param pulumi.Input[str] time_column_name: The name of the time column. This parameter is required when forecasting to specify the datetime column in the input data used for building the time series and inferring its frequency.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] time_series_id_column_names: The names of columns used to group a timeseries. It can be used to create multiple series.
               If grain is not defined, the data set is assumed to be one time-series. This parameter is used with task type forecasting.
        :param pulumi.Input[Union[str, 'UseStl']] use_stl: Configure STL Decomposition of the time-series target column.
        """
        if country_or_region_for_holidays is not None:
            pulumi.set(__self__, "country_or_region_for_holidays", country_or_region_for_holidays)
        if cv_step_size is not None:
            pulumi.set(__self__, "cv_step_size", cv_step_size)
        if feature_lags is None:
            feature_lags = 'None'
        if feature_lags is not None:
            pulumi.set(__self__, "feature_lags", feature_lags)
        if forecast_horizon is not None:
            pulumi.set(__self__, "forecast_horizon", forecast_horizon)
        if frequency is not None:
            pulumi.set(__self__, "frequency", frequency)
        if seasonality is not None:
            pulumi.set(__self__, "seasonality", seasonality)
        if short_series_handling_config is None:
            short_series_handling_config = 'Auto'
        if short_series_handling_config is not None:
            pulumi.set(__self__, "short_series_handling_config", short_series_handling_config)
        if target_aggregate_function is None:
            target_aggregate_function = 'None'
        if target_aggregate_function is not None:
            pulumi.set(__self__, "target_aggregate_function", target_aggregate_function)
        if target_lags is not None:
            pulumi.set(__self__, "target_lags", target_lags)
        if target_rolling_window_size is not None:
            pulumi.set(__self__, "target_rolling_window_size", target_rolling_window_size)
        if time_column_name is not None:
            pulumi.set(__self__, "time_column_name", time_column_name)
        if time_series_id_column_names is not None:
            pulumi.set(__self__, "time_series_id_column_names", time_series_id_column_names)
        if use_stl is None:
            use_stl = 'None'
        if use_stl is not None:
            pulumi.set(__self__, "use_stl", use_stl)

    @property
    @pulumi.getter(name="countryOrRegionForHolidays")
    def country_or_region_for_holidays(self) -> Optional[pulumi.Input[str]]:
        """
        Country or region for holidays for forecasting tasks.
        These should be ISO 3166 two-letter country/region codes, for example 'US' or 'GB'.
        """
        return pulumi.get(self, "country_or_region_for_holidays")

    @country_or_region_for_holidays.setter
    def country_or_region_for_holidays(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "country_or_region_for_holidays", value)

    @property
    @pulumi.getter(name="cvStepSize")
    def cv_step_size(self) -> Optional[pulumi.Input[int]]:
        """
        Number of periods between the origin time of one CV fold and the next fold. For
        example, if `CVStepSize` = 3 for daily data, the origin time for each fold will be
        three days apart.
        """
        return pulumi.get(self, "cv_step_size")

    @cv_step_size.setter
    def cv_step_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cv_step_size", value)

    @property
    @pulumi.getter(name="featureLags")
    def feature_lags(self) -> Optional[pulumi.Input[Union[str, 'FeatureLags']]]:
        """
        Flag for generating lags for the numeric features with 'auto' or null.
        """
        return pulumi.get(self, "feature_lags")

    @feature_lags.setter
    def feature_lags(self, value: Optional[pulumi.Input[Union[str, 'FeatureLags']]]):
        pulumi.set(self, "feature_lags", value)

    @property
    @pulumi.getter(name="forecastHorizon")
    def forecast_horizon(self) -> Optional[pulumi.Input[Union['AutoForecastHorizonArgs', 'CustomForecastHorizonArgs']]]:
        """
        The desired maximum forecast horizon in units of time-series frequency.
        """
        return pulumi.get(self, "forecast_horizon")

    @forecast_horizon.setter
    def forecast_horizon(self, value: Optional[pulumi.Input[Union['AutoForecastHorizonArgs', 'CustomForecastHorizonArgs']]]):
        pulumi.set(self, "forecast_horizon", value)

    @property
    @pulumi.getter
    def frequency(self) -> Optional[pulumi.Input[str]]:
        """
        When forecasting, this parameter represents the period with which the forecast is desired, for example daily, weekly, yearly, etc. The forecast frequency is dataset frequency by default.
        """
        return pulumi.get(self, "frequency")

    @frequency.setter
    def frequency(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "frequency", value)

    @property
    @pulumi.getter
    def seasonality(self) -> Optional[pulumi.Input[Union['AutoSeasonalityArgs', 'CustomSeasonalityArgs']]]:
        """
        Set time series seasonality as an integer multiple of the series frequency.
        If seasonality is set to 'auto', it will be inferred.
        """
        return pulumi.get(self, "seasonality")

    @seasonality.setter
    def seasonality(self, value: Optional[pulumi.Input[Union['AutoSeasonalityArgs', 'CustomSeasonalityArgs']]]):
        pulumi.set(self, "seasonality", value)

    @property
    @pulumi.getter(name="shortSeriesHandlingConfig")
    def short_series_handling_config(self) -> Optional[pulumi.Input[Union[str, 'ShortSeriesHandlingConfiguration']]]:
        """
        The parameter defining how if AutoML should handle short time series.
        """
        return pulumi.get(self, "short_series_handling_config")

    @short_series_handling_config.setter
    def short_series_handling_config(self, value: Optional[pulumi.Input[Union[str, 'ShortSeriesHandlingConfiguration']]]):
        pulumi.set(self, "short_series_handling_config", value)

    @property
    @pulumi.getter(name="targetAggregateFunction")
    def target_aggregate_function(self) -> Optional[pulumi.Input[Union[str, 'TargetAggregationFunction']]]:
        """
        The function to be used to aggregate the time series target column to conform to a user specified frequency.
        If the TargetAggregateFunction is set i.e. not 'None', but the freq parameter is not set, the error is raised. The possible target aggregation functions are: "sum", "max", "min" and "mean".
        """
        return pulumi.get(self, "target_aggregate_function")

    @target_aggregate_function.setter
    def target_aggregate_function(self, value: Optional[pulumi.Input[Union[str, 'TargetAggregationFunction']]]):
        pulumi.set(self, "target_aggregate_function", value)

    @property
    @pulumi.getter(name="targetLags")
    def target_lags(self) -> Optional[pulumi.Input[Union['AutoTargetLagsArgs', 'CustomTargetLagsArgs']]]:
        """
        The number of past periods to lag from the target column.
        """
        return pulumi.get(self, "target_lags")

    @target_lags.setter
    def target_lags(self, value: Optional[pulumi.Input[Union['AutoTargetLagsArgs', 'CustomTargetLagsArgs']]]):
        pulumi.set(self, "target_lags", value)

    @property
    @pulumi.getter(name="targetRollingWindowSize")
    def target_rolling_window_size(self) -> Optional[pulumi.Input[Union['AutoTargetRollingWindowSizeArgs', 'CustomTargetRollingWindowSizeArgs']]]:
        """
        The number of past periods used to create a rolling window average of the target column.
        """
        return pulumi.get(self, "target_rolling_window_size")

    @target_rolling_window_size.setter
    def target_rolling_window_size(self, value: Optional[pulumi.Input[Union['AutoTargetRollingWindowSizeArgs', 'CustomTargetRollingWindowSizeArgs']]]):
        pulumi.set(self, "target_rolling_window_size", value)

    @property
    @pulumi.getter(name="timeColumnName")
    def time_column_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the time column. This parameter is required when forecasting to specify the datetime column in the input data used for building the time series and inferring its frequency.
        """
        return pulumi.get(self, "time_column_name")

    @time_column_name.setter
    def time_column_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_column_name", value)

    @property
    @pulumi.getter(name="timeSeriesIdColumnNames")
    def time_series_id_column_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The names of columns used to group a timeseries. It can be used to create multiple series.
        If grain is not defined, the data set is assumed to be one time-series. This parameter is used with task type forecasting.
        """
        return pulumi.get(self, "time_series_id_column_names")

    @time_series_id_column_names.setter
    def time_series_id_column_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "time_series_id_column_names", value)

    @property
    @pulumi.getter(name="useStl")
    def use_stl(self) -> Optional[pulumi.Input[Union[str, 'UseStl']]]:
        """
        Configure STL Decomposition of the time-series target column.
        """
        return pulumi.get(self, "use_stl")

    @use_stl.setter
    def use_stl(self, value: Optional[pulumi.Input[Union[str, 'UseStl']]]):
        pulumi.set(self, "use_stl", value)


@pulumi.input_type
class ForecastingTrainingSettingsArgs:
    def __init__(__self__, *,
                 allowed_training_algorithms: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'ForecastingModels']]]]] = None,
                 blocked_training_algorithms: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'ForecastingModels']]]]] = None,
                 enable_dnn_training: Optional[pulumi.Input[bool]] = None,
                 enable_model_explainability: Optional[pulumi.Input[bool]] = None,
                 enable_onnx_compatible_models: Optional[pulumi.Input[bool]] = None,
                 enable_stack_ensemble: Optional[pulumi.Input[bool]] = None,
                 enable_vote_ensemble: Optional[pulumi.Input[bool]] = None,
                 ensemble_model_download_timeout: Optional[pulumi.Input[str]] = None,
                 stack_ensemble_settings: Optional[pulumi.Input['StackEnsembleSettingsArgs']] = None,
                 training_mode: Optional[pulumi.Input[Union[str, 'TrainingMode']]] = None):
        """
        Forecasting Training related configuration.
        :param pulumi.Input[Sequence[pulumi.Input[Union[str, 'ForecastingModels']]]] allowed_training_algorithms: Allowed models for forecasting task.
        :param pulumi.Input[Sequence[pulumi.Input[Union[str, 'ForecastingModels']]]] blocked_training_algorithms: Blocked models for forecasting task.
        :param pulumi.Input[bool] enable_dnn_training: Enable recommendation of DNN models.
        :param pulumi.Input[bool] enable_model_explainability: Flag to turn on explainability on best model.
        :param pulumi.Input[bool] enable_onnx_compatible_models: Flag for enabling onnx compatible models.
        :param pulumi.Input[bool] enable_stack_ensemble: Enable stack ensemble run.
        :param pulumi.Input[bool] enable_vote_ensemble: Enable voting ensemble run.
        :param pulumi.Input[str] ensemble_model_download_timeout: During VotingEnsemble and StackEnsemble model generation, multiple fitted models from the previous child runs are downloaded.
               Configure this parameter with a higher value than 300 secs, if more time is needed.
        :param pulumi.Input['StackEnsembleSettingsArgs'] stack_ensemble_settings: Stack ensemble settings for stack ensemble run.
        :param pulumi.Input[Union[str, 'TrainingMode']] training_mode: TrainingMode mode - Setting to 'auto' is same as setting it to 'non-distributed' for now, however in the future may result in mixed mode or heuristics based mode selection. Default is 'auto'.
               If 'Distributed' then only distributed featurization is used and distributed algorithms are chosen.
               If 'NonDistributed' then only non distributed algorithms are chosen.
        """
        if allowed_training_algorithms is not None:
            pulumi.set(__self__, "allowed_training_algorithms", allowed_training_algorithms)
        if blocked_training_algorithms is not None:
            pulumi.set(__self__, "blocked_training_algorithms", blocked_training_algorithms)
        if enable_dnn_training is None:
            enable_dnn_training = False
        if enable_dnn_training is not None:
            pulumi.set(__self__, "enable_dnn_training", enable_dnn_training)
        if enable_model_explainability is None:
            enable_model_explainability = True
        if enable_model_explainability is not None:
            pulumi.set(__self__, "enable_model_explainability", enable_model_explainability)
        if enable_onnx_compatible_models is None:
            enable_onnx_compatible_models = False
        if enable_onnx_compatible_models is not None:
            pulumi.set(__self__, "enable_onnx_compatible_models", enable_onnx_compatible_models)
        if enable_stack_ensemble is None:
            enable_stack_ensemble = True
        if enable_stack_ensemble is not None:
            pulumi.set(__self__, "enable_stack_ensemble", enable_stack_ensemble)
        if enable_vote_ensemble is None:
            enable_vote_ensemble = True
        if enable_vote_ensemble is not None:
            pulumi.set(__self__, "enable_vote_ensemble", enable_vote_ensemble)
        if ensemble_model_download_timeout is None:
            ensemble_model_download_timeout = 'PT5M'
        if ensemble_model_download_timeout is not None:
            pulumi.set(__self__, "ensemble_model_download_timeout", ensemble_model_download_timeout)
        if stack_ensemble_settings is not None:
            pulumi.set(__self__, "stack_ensemble_settings", stack_ensemble_settings)
        if training_mode is None:
            training_mode = 'Auto'
        if training_mode is not None:
            pulumi.set(__self__, "training_mode", training_mode)

    @property
    @pulumi.getter(name="allowedTrainingAlgorithms")
    def allowed_training_algorithms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'ForecastingModels']]]]]:
        """
        Allowed models for forecasting task.
        """
        return pulumi.get(self, "allowed_training_algorithms")

    @allowed_training_algorithms.setter
    def allowed_training_algorithms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'ForecastingModels']]]]]):
        pulumi.set(self, "allowed_training_algorithms", value)

    @property
    @pulumi.getter(name="blockedTrainingAlgorithms")
    def blocked_training_algorithms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'ForecastingModels']]]]]:
        """
        Blocked models for forecasting task.
        """
        return pulumi.get(self, "blocked_training_algorithms")

    @blocked_training_algorithms.setter
    def blocked_training_algorithms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'ForecastingModels']]]]]):
        pulumi.set(self, "blocked_training_algorithms", value)

    @property
    @pulumi.getter(name="enableDnnTraining")
    def enable_dnn_training(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable recommendation of DNN models.
        """
        return pulumi.get(self, "enable_dnn_training")

    @enable_dnn_training.setter
    def enable_dnn_training(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_dnn_training", value)

    @property
    @pulumi.getter(name="enableModelExplainability")
    def enable_model_explainability(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to turn on explainability on best model.
        """
        return pulumi.get(self, "enable_model_explainability")

    @enable_model_explainability.setter
    def enable_model_explainability(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_model_explainability", value)

    @property
    @pulumi.getter(name="enableOnnxCompatibleModels")
    def enable_onnx_compatible_models(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag for enabling onnx compatible models.
        """
        return pulumi.get(self, "enable_onnx_compatible_models")

    @enable_onnx_compatible_models.setter
    def enable_onnx_compatible_models(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_onnx_compatible_models", value)

    @property
    @pulumi.getter(name="enableStackEnsemble")
    def enable_stack_ensemble(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable stack ensemble run.
        """
        return pulumi.get(self, "enable_stack_ensemble")

    @enable_stack_ensemble.setter
    def enable_stack_ensemble(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_stack_ensemble", value)

    @property
    @pulumi.getter(name="enableVoteEnsemble")
    def enable_vote_ensemble(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable voting ensemble run.
        """
        return pulumi.get(self, "enable_vote_ensemble")

    @enable_vote_ensemble.setter
    def enable_vote_ensemble(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_vote_ensemble", value)

    @property
    @pulumi.getter(name="ensembleModelDownloadTimeout")
    def ensemble_model_download_timeout(self) -> Optional[pulumi.Input[str]]:
        """
        During VotingEnsemble and StackEnsemble model generation, multiple fitted models from the previous child runs are downloaded.
        Configure this parameter with a higher value than 300 secs, if more time is needed.
        """
        return pulumi.get(self, "ensemble_model_download_timeout")

    @ensemble_model_download_timeout.setter
    def ensemble_model_download_timeout(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ensemble_model_download_timeout", value)

    @property
    @pulumi.getter(name="stackEnsembleSettings")
    def stack_ensemble_settings(self) -> Optional[pulumi.Input['StackEnsembleSettingsArgs']]:
        """
        Stack ensemble settings for stack ensemble run.
        """
        return pulumi.get(self, "stack_ensemble_settings")

    @stack_ensemble_settings.setter
    def stack_ensemble_settings(self, value: Optional[pulumi.Input['StackEnsembleSettingsArgs']]):
        pulumi.set(self, "stack_ensemble_settings", value)

    @property
    @pulumi.getter(name="trainingMode")
    def training_mode(self) -> Optional[pulumi.Input[Union[str, 'TrainingMode']]]:
        """
        TrainingMode mode - Setting to 'auto' is same as setting it to 'non-distributed' for now, however in the future may result in mixed mode or heuristics based mode selection. Default is 'auto'.
        If 'Distributed' then only distributed featurization is used and distributed algorithms are chosen.
        If 'NonDistributed' then only non distributed algorithms are chosen.
        """
        return pulumi.get(self, "training_mode")

    @training_mode.setter
    def training_mode(self, value: Optional[pulumi.Input[Union[str, 'TrainingMode']]]):
        pulumi.set(self, "training_mode", value)


@pulumi.input_type
class ForecastingArgs:
    def __init__(__self__, *,
                 task_type: pulumi.Input[str],
                 training_data: pulumi.Input['MLTableJobInputArgs'],
                 cv_split_column_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 featurization_settings: Optional[pulumi.Input['TableVerticalFeaturizationSettingsArgs']] = None,
                 fixed_parameters: Optional[pulumi.Input['TableFixedParametersArgs']] = None,
                 forecasting_settings: Optional[pulumi.Input['ForecastingSettingsArgs']] = None,
                 limit_settings: Optional[pulumi.Input['TableVerticalLimitSettingsArgs']] = None,
                 log_verbosity: Optional[pulumi.Input[Union[str, 'LogVerbosity']]] = None,
                 n_cross_validations: Optional[pulumi.Input[Union['AutoNCrossValidationsArgs', 'CustomNCrossValidationsArgs']]] = None,
                 primary_metric: Optional[pulumi.Input[Union[str, 'ForecastingPrimaryMetrics']]] = None,
                 search_space: Optional[pulumi.Input[Sequence[pulumi.Input['TableParameterSubspaceArgs']]]] = None,
                 sweep_settings: Optional[pulumi.Input['TableSweepSettingsArgs']] = None,
                 target_column_name: Optional[pulumi.Input[str]] = None,
                 test_data: Optional[pulumi.Input['MLTableJobInputArgs']] = None,
                 test_data_size: Optional[pulumi.Input[float]] = None,
                 training_settings: Optional[pulumi.Input['ForecastingTrainingSettingsArgs']] = None,
                 validation_data: Optional[pulumi.Input['MLTableJobInputArgs']] = None,
                 validation_data_size: Optional[pulumi.Input[float]] = None,
                 weight_column_name: Optional[pulumi.Input[str]] = None):
        """
        Forecasting task in AutoML Table vertical.
        :param pulumi.Input[str] task_type: AutoMLJob Task type.
               Expected value is 'Forecasting'.
        :param pulumi.Input['MLTableJobInputArgs'] training_data: [Required] Training data input.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] cv_split_column_names: Columns to use for CVSplit data.
        :param pulumi.Input['TableVerticalFeaturizationSettingsArgs'] featurization_settings: Featurization inputs needed for AutoML job.
        :param pulumi.Input['TableFixedParametersArgs'] fixed_parameters: Model/training parameters that will remain constant throughout training.
        :param pulumi.Input['ForecastingSettingsArgs'] forecasting_settings: Forecasting task specific inputs.
        :param pulumi.Input['TableVerticalLimitSettingsArgs'] limit_settings: Execution constraints for AutoMLJob.
        :param pulumi.Input[Union[str, 'LogVerbosity']] log_verbosity: Log verbosity for the job.
        :param pulumi.Input[Union['AutoNCrossValidationsArgs', 'CustomNCrossValidationsArgs']] n_cross_validations: Number of cross validation folds to be applied on training dataset
               when validation dataset is not provided.
        :param pulumi.Input[Union[str, 'ForecastingPrimaryMetrics']] primary_metric: Primary metric for forecasting task.
        :param pulumi.Input[Sequence[pulumi.Input['TableParameterSubspaceArgs']]] search_space: Search space for sampling different combinations of models and their hyperparameters.
        :param pulumi.Input['TableSweepSettingsArgs'] sweep_settings: Settings for model sweeping and hyperparameter tuning.
        :param pulumi.Input[str] target_column_name: Target column name: This is prediction values column.
               Also known as label column name in context of classification tasks.
        :param pulumi.Input['MLTableJobInputArgs'] test_data: Test data input.
        :param pulumi.Input[float] test_data_size: The fraction of test dataset that needs to be set aside for validation purpose.
               Values between (0.0 , 1.0)
               Applied when validation dataset is not provided.
        :param pulumi.Input['ForecastingTrainingSettingsArgs'] training_settings: Inputs for training phase for an AutoML Job.
        :param pulumi.Input['MLTableJobInputArgs'] validation_data: Validation data inputs.
        :param pulumi.Input[float] validation_data_size: The fraction of training dataset that needs to be set aside for validation purpose.
               Values between (0.0 , 1.0)
               Applied when validation dataset is not provided.
        :param pulumi.Input[str] weight_column_name: The name of the sample weight column. Automated ML supports a weighted column as an input, causing rows in the data to be weighted up or down.
        """
        pulumi.set(__self__, "task_type", 'Forecasting')
        pulumi.set(__self__, "training_data", training_data)
        if cv_split_column_names is not None:
            pulumi.set(__self__, "cv_split_column_names", cv_split_column_names)
        if featurization_settings is not None:
            pulumi.set(__self__, "featurization_settings", featurization_settings)
        if fixed_parameters is not None:
            pulumi.set(__self__, "fixed_parameters", fixed_parameters)
        if forecasting_settings is not None:
            pulumi.set(__self__, "forecasting_settings", forecasting_settings)
        if limit_settings is not None:
            pulumi.set(__self__, "limit_settings", limit_settings)
        if log_verbosity is None:
            log_verbosity = 'Info'
        if log_verbosity is not None:
            pulumi.set(__self__, "log_verbosity", log_verbosity)
        if n_cross_validations is not None:
            pulumi.set(__self__, "n_cross_validations", n_cross_validations)
        if primary_metric is None:
            primary_metric = 'NormalizedRootMeanSquaredError'
        if primary_metric is not None:
            pulumi.set(__self__, "primary_metric", primary_metric)
        if search_space is not None:
            pulumi.set(__self__, "search_space", search_space)
        if sweep_settings is not None:
            pulumi.set(__self__, "sweep_settings", sweep_settings)
        if target_column_name is not None:
            pulumi.set(__self__, "target_column_name", target_column_name)
        if test_data is not None:
            pulumi.set(__self__, "test_data", test_data)
        if test_data_size is not None:
            pulumi.set(__self__, "test_data_size", test_data_size)
        if training_settings is not None:
            pulumi.set(__self__, "training_settings", training_settings)
        if validation_data is not None:
            pulumi.set(__self__, "validation_data", validation_data)
        if validation_data_size is not None:
            pulumi.set(__self__, "validation_data_size", validation_data_size)
        if weight_column_name is not None:
            pulumi.set(__self__, "weight_column_name", weight_column_name)

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> pulumi.Input[str]:
        """
        AutoMLJob Task type.
        Expected value is 'Forecasting'.
        """
        return pulumi.get(self, "task_type")

    @task_type.setter
    def task_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "task_type", value)

    @property
    @pulumi.getter(name="trainingData")
    def training_data(self) -> pulumi.Input['MLTableJobInputArgs']:
        """
        [Required] Training data input.
        """
        return pulumi.get(self, "training_data")

    @training_data.setter
    def training_data(self, value: pulumi.Input['MLTableJobInputArgs']):
        pulumi.set(self, "training_data", value)

    @property
    @pulumi.getter(name="cvSplitColumnNames")
    def cv_split_column_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Columns to use for CVSplit data.
        """
        return pulumi.get(self, "cv_split_column_names")

    @cv_split_column_names.setter
    def cv_split_column_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "cv_split_column_names", value)

    @property
    @pulumi.getter(name="featurizationSettings")
    def featurization_settings(self) -> Optional[pulumi.Input['TableVerticalFeaturizationSettingsArgs']]:
        """
        Featurization inputs needed for AutoML job.
        """
        return pulumi.get(self, "featurization_settings")

    @featurization_settings.setter
    def featurization_settings(self, value: Optional[pulumi.Input['TableVerticalFeaturizationSettingsArgs']]):
        pulumi.set(self, "featurization_settings", value)

    @property
    @pulumi.getter(name="fixedParameters")
    def fixed_parameters(self) -> Optional[pulumi.Input['TableFixedParametersArgs']]:
        """
        Model/training parameters that will remain constant throughout training.
        """
        return pulumi.get(self, "fixed_parameters")

    @fixed_parameters.setter
    def fixed_parameters(self, value: Optional[pulumi.Input['TableFixedParametersArgs']]):
        pulumi.set(self, "fixed_parameters", value)

    @property
    @pulumi.getter(name="forecastingSettings")
    def forecasting_settings(self) -> Optional[pulumi.Input['ForecastingSettingsArgs']]:
        """
        Forecasting task specific inputs.
        """
        return pulumi.get(self, "forecasting_settings")

    @forecasting_settings.setter
    def forecasting_settings(self, value: Optional[pulumi.Input['ForecastingSettingsArgs']]):
        pulumi.set(self, "forecasting_settings", value)

    @property
    @pulumi.getter(name="limitSettings")
    def limit_settings(self) -> Optional[pulumi.Input['TableVerticalLimitSettingsArgs']]:
        """
        Execution constraints for AutoMLJob.
        """
        return pulumi.get(self, "limit_settings")

    @limit_settings.setter
    def limit_settings(self, value: Optional[pulumi.Input['TableVerticalLimitSettingsArgs']]):
        pulumi.set(self, "limit_settings", value)

    @property
    @pulumi.getter(name="logVerbosity")
    def log_verbosity(self) -> Optional[pulumi.Input[Union[str, 'LogVerbosity']]]:
        """
        Log verbosity for the job.
        """
        return pulumi.get(self, "log_verbosity")

    @log_verbosity.setter
    def log_verbosity(self, value: Optional[pulumi.Input[Union[str, 'LogVerbosity']]]):
        pulumi.set(self, "log_verbosity", value)

    @property
    @pulumi.getter(name="nCrossValidations")
    def n_cross_validations(self) -> Optional[pulumi.Input[Union['AutoNCrossValidationsArgs', 'CustomNCrossValidationsArgs']]]:
        """
        Number of cross validation folds to be applied on training dataset
        when validation dataset is not provided.
        """
        return pulumi.get(self, "n_cross_validations")

    @n_cross_validations.setter
    def n_cross_validations(self, value: Optional[pulumi.Input[Union['AutoNCrossValidationsArgs', 'CustomNCrossValidationsArgs']]]):
        pulumi.set(self, "n_cross_validations", value)

    @property
    @pulumi.getter(name="primaryMetric")
    def primary_metric(self) -> Optional[pulumi.Input[Union[str, 'ForecastingPrimaryMetrics']]]:
        """
        Primary metric for forecasting task.
        """
        return pulumi.get(self, "primary_metric")

    @primary_metric.setter
    def primary_metric(self, value: Optional[pulumi.Input[Union[str, 'ForecastingPrimaryMetrics']]]):
        pulumi.set(self, "primary_metric", value)

    @property
    @pulumi.getter(name="searchSpace")
    def search_space(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TableParameterSubspaceArgs']]]]:
        """
        Search space for sampling different combinations of models and their hyperparameters.
        """
        return pulumi.get(self, "search_space")

    @search_space.setter
    def search_space(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TableParameterSubspaceArgs']]]]):
        pulumi.set(self, "search_space", value)

    @property
    @pulumi.getter(name="sweepSettings")
    def sweep_settings(self) -> Optional[pulumi.Input['TableSweepSettingsArgs']]:
        """
        Settings for model sweeping and hyperparameter tuning.
        """
        return pulumi.get(self, "sweep_settings")

    @sweep_settings.setter
    def sweep_settings(self, value: Optional[pulumi.Input['TableSweepSettingsArgs']]):
        pulumi.set(self, "sweep_settings", value)

    @property
    @pulumi.getter(name="targetColumnName")
    def target_column_name(self) -> Optional[pulumi.Input[str]]:
        """
        Target column name: This is prediction values column.
        Also known as label column name in context of classification tasks.
        """
        return pulumi.get(self, "target_column_name")

    @target_column_name.setter
    def target_column_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_column_name", value)

    @property
    @pulumi.getter(name="testData")
    def test_data(self) -> Optional[pulumi.Input['MLTableJobInputArgs']]:
        """
        Test data input.
        """
        return pulumi.get(self, "test_data")

    @test_data.setter
    def test_data(self, value: Optional[pulumi.Input['MLTableJobInputArgs']]):
        pulumi.set(self, "test_data", value)

    @property
    @pulumi.getter(name="testDataSize")
    def test_data_size(self) -> Optional[pulumi.Input[float]]:
        """
        The fraction of test dataset that needs to be set aside for validation purpose.
        Values between (0.0 , 1.0)
        Applied when validation dataset is not provided.
        """
        return pulumi.get(self, "test_data_size")

    @test_data_size.setter
    def test_data_size(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "test_data_size", value)

    @property
    @pulumi.getter(name="trainingSettings")
    def training_settings(self) -> Optional[pulumi.Input['ForecastingTrainingSettingsArgs']]:
        """
        Inputs for training phase for an AutoML Job.
        """
        return pulumi.get(self, "training_settings")

    @training_settings.setter
    def training_settings(self, value: Optional[pulumi.Input['ForecastingTrainingSettingsArgs']]):
        pulumi.set(self, "training_settings", value)

    @property
    @pulumi.getter(name="validationData")
    def validation_data(self) -> Optional[pulumi.Input['MLTableJobInputArgs']]:
        """
        Validation data inputs.
        """
        return pulumi.get(self, "validation_data")

    @validation_data.setter
    def validation_data(self, value: Optional[pulumi.Input['MLTableJobInputArgs']]):
        pulumi.set(self, "validation_data", value)

    @property
    @pulumi.getter(name="validationDataSize")
    def validation_data_size(self) -> Optional[pulumi.Input[float]]:
        """
        The fraction of training dataset that needs to be set aside for validation purpose.
        Values between (0.0 , 1.0)
        Applied when validation dataset is not provided.
        """
        return pulumi.get(self, "validation_data_size")

    @validation_data_size.setter
    def validation_data_size(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "validation_data_size", value)

    @property
    @pulumi.getter(name="weightColumnName")
    def weight_column_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the sample weight column. Automated ML supports a weighted column as an input, causing rows in the data to be weighted up or down.
        """
        return pulumi.get(self, "weight_column_name")

    @weight_column_name.setter
    def weight_column_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "weight_column_name", value)


@pulumi.input_type
class GridSamplingAlgorithmArgs:
    def __init__(__self__, *,
                 sampling_algorithm_type: pulumi.Input[str]):
        """
        Defines a Sampling Algorithm that exhaustively generates every value combination in the space
        :param pulumi.Input[str] sampling_algorithm_type: 
               Expected value is 'Grid'.
        """
        pulumi.set(__self__, "sampling_algorithm_type", 'Grid')

    @property
    @pulumi.getter(name="samplingAlgorithmType")
    def sampling_algorithm_type(self) -> pulumi.Input[str]:
        """

        Expected value is 'Grid'.
        """
        return pulumi.get(self, "sampling_algorithm_type")

    @sampling_algorithm_type.setter
    def sampling_algorithm_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "sampling_algorithm_type", value)


@pulumi.input_type
class HDInsightPropertiesArgs:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[str]] = None,
                 administrator_account: Optional[pulumi.Input['VirtualMachineSshCredentialsArgs']] = None,
                 ssh_port: Optional[pulumi.Input[int]] = None):
        """
        HDInsight compute properties
        :param pulumi.Input[str] address: Public IP address of the master node of the cluster.
        :param pulumi.Input['VirtualMachineSshCredentialsArgs'] administrator_account: Admin credentials for master node of the cluster
        :param pulumi.Input[int] ssh_port: Port open for ssh connections on the master node of the cluster.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if administrator_account is not None:
            pulumi.set(__self__, "administrator_account", administrator_account)
        if ssh_port is not None:
            pulumi.set(__self__, "ssh_port", ssh_port)

    @property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[str]]:
        """
        Public IP address of the master node of the cluster.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter(name="administratorAccount")
    def administrator_account(self) -> Optional[pulumi.Input['VirtualMachineSshCredentialsArgs']]:
        """
        Admin credentials for master node of the cluster
        """
        return pulumi.get(self, "administrator_account")

    @administrator_account.setter
    def administrator_account(self, value: Optional[pulumi.Input['VirtualMachineSshCredentialsArgs']]):
        pulumi.set(self, "administrator_account", value)

    @property
    @pulumi.getter(name="sshPort")
    def ssh_port(self) -> Optional[pulumi.Input[int]]:
        """
        Port open for ssh connections on the master node of the cluster.
        """
        return pulumi.get(self, "ssh_port")

    @ssh_port.setter
    def ssh_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ssh_port", value)


@pulumi.input_type
class HDInsightArgs:
    def __init__(__self__, *,
                 compute_type: pulumi.Input[str],
                 compute_location: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disable_local_auth: Optional[pulumi.Input[bool]] = None,
                 properties: Optional[pulumi.Input['HDInsightPropertiesArgs']] = None,
                 resource_id: Optional[pulumi.Input[str]] = None):
        """
        A HDInsight compute.
        :param pulumi.Input[str] compute_type: The type of compute
               Expected value is 'HDInsight'.
        :param pulumi.Input[str] compute_location: Location for the underlying compute
        :param pulumi.Input[str] description: The description of the Machine Learning compute.
        :param pulumi.Input[bool] disable_local_auth: Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
        :param pulumi.Input['HDInsightPropertiesArgs'] properties: HDInsight compute properties
        :param pulumi.Input[str] resource_id: ARM resource id of the underlying compute
        """
        pulumi.set(__self__, "compute_type", 'HDInsight')
        if compute_location is not None:
            pulumi.set(__self__, "compute_location", compute_location)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_local_auth is not None:
            pulumi.set(__self__, "disable_local_auth", disable_local_auth)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="computeType")
    def compute_type(self) -> pulumi.Input[str]:
        """
        The type of compute
        Expected value is 'HDInsight'.
        """
        return pulumi.get(self, "compute_type")

    @compute_type.setter
    def compute_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "compute_type", value)

    @property
    @pulumi.getter(name="computeLocation")
    def compute_location(self) -> Optional[pulumi.Input[str]]:
        """
        Location for the underlying compute
        """
        return pulumi.get(self, "compute_location")

    @compute_location.setter
    def compute_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compute_location", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the Machine Learning compute.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="disableLocalAuth")
    def disable_local_auth(self) -> Optional[pulumi.Input[bool]]:
        """
        Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
        """
        return pulumi.get(self, "disable_local_auth")

    @disable_local_auth.setter
    def disable_local_auth(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_local_auth", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input['HDInsightPropertiesArgs']]:
        """
        HDInsight compute properties
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input['HDInsightPropertiesArgs']]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM resource id of the underlying compute
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_id", value)


@pulumi.input_type
class HdfsDatastoreArgs:
    def __init__(__self__, *,
                 credentials: pulumi.Input[Union['AccountKeyDatastoreCredentialsArgs', 'CertificateDatastoreCredentialsArgs', 'KerberosKeytabCredentialsArgs', 'KerberosPasswordCredentialsArgs', 'NoneDatastoreCredentialsArgs', 'SasDatastoreCredentialsArgs', 'ServicePrincipalDatastoreCredentialsArgs']],
                 datastore_type: pulumi.Input[str],
                 name_node_address: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 hdfs_server_certificate: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[Union['AccountKeyDatastoreCredentialsArgs', 'CertificateDatastoreCredentialsArgs', 'KerberosKeytabCredentialsArgs', 'KerberosPasswordCredentialsArgs', 'NoneDatastoreCredentialsArgs', 'SasDatastoreCredentialsArgs', 'ServicePrincipalDatastoreCredentialsArgs']] credentials: [Required] Account credentials.
        :param pulumi.Input[str] datastore_type: Enum to determine the datastore contents type.
               Expected value is 'Hdfs'.
        :param pulumi.Input[str] name_node_address: [Required] IP Address or DNS HostName.
        :param pulumi.Input[str] description: The asset description text.
        :param pulumi.Input[str] hdfs_server_certificate: The TLS cert of the HDFS server. Needs to be a base64 encoded string. Required if "Https" protocol is selected.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: The asset property dictionary.
        :param pulumi.Input[str] protocol: Protocol used to communicate with the storage account (Https/Http).
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Tag dictionary. Tags can be added, removed, and updated.
        """
        pulumi.set(__self__, "credentials", credentials)
        pulumi.set(__self__, "datastore_type", 'Hdfs')
        pulumi.set(__self__, "name_node_address", name_node_address)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if hdfs_server_certificate is not None:
            pulumi.set(__self__, "hdfs_server_certificate", hdfs_server_certificate)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if protocol is None:
            protocol = 'http'
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def credentials(self) -> pulumi.Input[Union['AccountKeyDatastoreCredentialsArgs', 'CertificateDatastoreCredentialsArgs', 'KerberosKeytabCredentialsArgs', 'KerberosPasswordCredentialsArgs', 'NoneDatastoreCredentialsArgs', 'SasDatastoreCredentialsArgs', 'ServicePrincipalDatastoreCredentialsArgs']]:
        """
        [Required] Account credentials.
        """
        return pulumi.get(self, "credentials")

    @credentials.setter
    def credentials(self, value: pulumi.Input[Union['AccountKeyDatastoreCredentialsArgs', 'CertificateDatastoreCredentialsArgs', 'KerberosKeytabCredentialsArgs', 'KerberosPasswordCredentialsArgs', 'NoneDatastoreCredentialsArgs', 'SasDatastoreCredentialsArgs', 'ServicePrincipalDatastoreCredentialsArgs']]):
        pulumi.set(self, "credentials", value)

    @property
    @pulumi.getter(name="datastoreType")
    def datastore_type(self) -> pulumi.Input[str]:
        """
        Enum to determine the datastore contents type.
        Expected value is 'Hdfs'.
        """
        return pulumi.get(self, "datastore_type")

    @datastore_type.setter
    def datastore_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "datastore_type", value)

    @property
    @pulumi.getter(name="nameNodeAddress")
    def name_node_address(self) -> pulumi.Input[str]:
        """
        [Required] IP Address or DNS HostName.
        """
        return pulumi.get(self, "name_node_address")

    @name_node_address.setter
    def name_node_address(self, value: pulumi.Input[str]):
        pulumi.set(self, "name_node_address", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The asset description text.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="hdfsServerCertificate")
    def hdfs_server_certificate(self) -> Optional[pulumi.Input[str]]:
        """
        The TLS cert of the HDFS server. Needs to be a base64 encoded string. Required if "Https" protocol is selected.
        """
        return pulumi.get(self, "hdfs_server_certificate")

    @hdfs_server_certificate.setter
    def hdfs_server_certificate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hdfs_server_certificate", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The asset property dictionary.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        Protocol used to communicate with the storage account (Https/Http).
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Tag dictionary. Tags can be added, removed, and updated.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class IdAssetReferenceArgs:
    def __init__(__self__, *,
                 asset_id: pulumi.Input[str],
                 reference_type: pulumi.Input[str]):
        """
        Reference to an asset via its ARM resource ID.
        :param pulumi.Input[str] asset_id: [Required] ARM resource ID of the asset.
        :param pulumi.Input[str] reference_type: Enum to determine which reference method to use for an asset.
               Expected value is 'Id'.
        """
        pulumi.set(__self__, "asset_id", asset_id)
        pulumi.set(__self__, "reference_type", 'Id')

    @property
    @pulumi.getter(name="assetId")
    def asset_id(self) -> pulumi.Input[str]:
        """
        [Required] ARM resource ID of the asset.
        """
        return pulumi.get(self, "asset_id")

    @asset_id.setter
    def asset_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "asset_id", value)

    @property
    @pulumi.getter(name="referenceType")
    def reference_type(self) -> pulumi.Input[str]:
        """
        Enum to determine which reference method to use for an asset.
        Expected value is 'Id'.
        """
        return pulumi.get(self, "reference_type")

    @reference_type.setter
    def reference_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "reference_type", value)


@pulumi.input_type
class IdentityForCmkArgs:
    def __init__(__self__, *,
                 user_assigned_identity: Optional[pulumi.Input[str]] = None):
        """
        Identity that will be used to access key vault for encryption at rest
        :param pulumi.Input[str] user_assigned_identity: The ArmId of the user assigned identity that will be used to access the customer managed key vault
        """
        if user_assigned_identity is not None:
            pulumi.set(__self__, "user_assigned_identity", user_assigned_identity)

    @property
    @pulumi.getter(name="userAssignedIdentity")
    def user_assigned_identity(self) -> Optional[pulumi.Input[str]]:
        """
        The ArmId of the user assigned identity that will be used to access the customer managed key vault
        """
        return pulumi.get(self, "user_assigned_identity")

    @user_assigned_identity.setter
    def user_assigned_identity(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_assigned_identity", value)


@pulumi.input_type
class ImageClassificationMultilabelArgs:
    def __init__(__self__, *,
                 limit_settings: pulumi.Input['ImageLimitSettingsArgs'],
                 task_type: pulumi.Input[str],
                 training_data: pulumi.Input['MLTableJobInputArgs'],
                 log_verbosity: Optional[pulumi.Input[Union[str, 'LogVerbosity']]] = None,
                 model_settings: Optional[pulumi.Input['ImageModelSettingsClassificationArgs']] = None,
                 primary_metric: Optional[pulumi.Input[Union[str, 'ClassificationMultilabelPrimaryMetrics']]] = None,
                 search_space: Optional[pulumi.Input[Sequence[pulumi.Input['ImageModelDistributionSettingsClassificationArgs']]]] = None,
                 sweep_settings: Optional[pulumi.Input['ImageSweepSettingsArgs']] = None,
                 target_column_name: Optional[pulumi.Input[str]] = None,
                 validation_data: Optional[pulumi.Input['MLTableJobInputArgs']] = None,
                 validation_data_size: Optional[pulumi.Input[float]] = None):
        """
        Image Classification Multilabel. Multi-label image classification is used when an image could have one or more labels
        from a set of labels - e.g. an image could be labeled with both 'cat' and 'dog'.
        :param pulumi.Input['ImageLimitSettingsArgs'] limit_settings: [Required] Limit settings for the AutoML job.
        :param pulumi.Input[str] task_type: AutoMLJob Task type.
               Expected value is 'ImageClassificationMultilabel'.
        :param pulumi.Input['MLTableJobInputArgs'] training_data: [Required] Training data input.
        :param pulumi.Input[Union[str, 'LogVerbosity']] log_verbosity: Log verbosity for the job.
        :param pulumi.Input['ImageModelSettingsClassificationArgs'] model_settings: Settings used for training the model.
        :param pulumi.Input[Union[str, 'ClassificationMultilabelPrimaryMetrics']] primary_metric: Primary metric to optimize for this task.
        :param pulumi.Input[Sequence[pulumi.Input['ImageModelDistributionSettingsClassificationArgs']]] search_space: Search space for sampling different combinations of models and their hyperparameters.
        :param pulumi.Input['ImageSweepSettingsArgs'] sweep_settings: Model sweeping and hyperparameter sweeping related settings.
        :param pulumi.Input[str] target_column_name: Target column name: This is prediction values column.
               Also known as label column name in context of classification tasks.
        :param pulumi.Input['MLTableJobInputArgs'] validation_data: Validation data inputs.
        :param pulumi.Input[float] validation_data_size: The fraction of training dataset that needs to be set aside for validation purpose.
               Values between (0.0 , 1.0)
               Applied when validation dataset is not provided.
        """
        pulumi.set(__self__, "limit_settings", limit_settings)
        pulumi.set(__self__, "task_type", 'ImageClassificationMultilabel')
        pulumi.set(__self__, "training_data", training_data)
        if log_verbosity is None:
            log_verbosity = 'Info'
        if log_verbosity is not None:
            pulumi.set(__self__, "log_verbosity", log_verbosity)
        if model_settings is not None:
            pulumi.set(__self__, "model_settings", model_settings)
        if primary_metric is None:
            primary_metric = 'IOU'
        if primary_metric is not None:
            pulumi.set(__self__, "primary_metric", primary_metric)
        if search_space is not None:
            pulumi.set(__self__, "search_space", search_space)
        if sweep_settings is not None:
            pulumi.set(__self__, "sweep_settings", sweep_settings)
        if target_column_name is not None:
            pulumi.set(__self__, "target_column_name", target_column_name)
        if validation_data is not None:
            pulumi.set(__self__, "validation_data", validation_data)
        if validation_data_size is not None:
            pulumi.set(__self__, "validation_data_size", validation_data_size)

    @property
    @pulumi.getter(name="limitSettings")
    def limit_settings(self) -> pulumi.Input['ImageLimitSettingsArgs']:
        """
        [Required] Limit settings for the AutoML job.
        """
        return pulumi.get(self, "limit_settings")

    @limit_settings.setter
    def limit_settings(self, value: pulumi.Input['ImageLimitSettingsArgs']):
        pulumi.set(self, "limit_settings", value)

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> pulumi.Input[str]:
        """
        AutoMLJob Task type.
        Expected value is 'ImageClassificationMultilabel'.
        """
        return pulumi.get(self, "task_type")

    @task_type.setter
    def task_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "task_type", value)

    @property
    @pulumi.getter(name="trainingData")
    def training_data(self) -> pulumi.Input['MLTableJobInputArgs']:
        """
        [Required] Training data input.
        """
        return pulumi.get(self, "training_data")

    @training_data.setter
    def training_data(self, value: pulumi.Input['MLTableJobInputArgs']):
        pulumi.set(self, "training_data", value)

    @property
    @pulumi.getter(name="logVerbosity")
    def log_verbosity(self) -> Optional[pulumi.Input[Union[str, 'LogVerbosity']]]:
        """
        Log verbosity for the job.
        """
        return pulumi.get(self, "log_verbosity")

    @log_verbosity.setter
    def log_verbosity(self, value: Optional[pulumi.Input[Union[str, 'LogVerbosity']]]):
        pulumi.set(self, "log_verbosity", value)

    @property
    @pulumi.getter(name="modelSettings")
    def model_settings(self) -> Optional[pulumi.Input['ImageModelSettingsClassificationArgs']]:
        """
        Settings used for training the model.
        """
        return pulumi.get(self, "model_settings")

    @model_settings.setter
    def model_settings(self, value: Optional[pulumi.Input['ImageModelSettingsClassificationArgs']]):
        pulumi.set(self, "model_settings", value)

    @property
    @pulumi.getter(name="primaryMetric")
    def primary_metric(self) -> Optional[pulumi.Input[Union[str, 'ClassificationMultilabelPrimaryMetrics']]]:
        """
        Primary metric to optimize for this task.
        """
        return pulumi.get(self, "primary_metric")

    @primary_metric.setter
    def primary_metric(self, value: Optional[pulumi.Input[Union[str, 'ClassificationMultilabelPrimaryMetrics']]]):
        pulumi.set(self, "primary_metric", value)

    @property
    @pulumi.getter(name="searchSpace")
    def search_space(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ImageModelDistributionSettingsClassificationArgs']]]]:
        """
        Search space for sampling different combinations of models and their hyperparameters.
        """
        return pulumi.get(self, "search_space")

    @search_space.setter
    def search_space(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ImageModelDistributionSettingsClassificationArgs']]]]):
        pulumi.set(self, "search_space", value)

    @property
    @pulumi.getter(name="sweepSettings")
    def sweep_settings(self) -> Optional[pulumi.Input['ImageSweepSettingsArgs']]:
        """
        Model sweeping and hyperparameter sweeping related settings.
        """
        return pulumi.get(self, "sweep_settings")

    @sweep_settings.setter
    def sweep_settings(self, value: Optional[pulumi.Input['ImageSweepSettingsArgs']]):
        pulumi.set(self, "sweep_settings", value)

    @property
    @pulumi.getter(name="targetColumnName")
    def target_column_name(self) -> Optional[pulumi.Input[str]]:
        """
        Target column name: This is prediction values column.
        Also known as label column name in context of classification tasks.
        """
        return pulumi.get(self, "target_column_name")

    @target_column_name.setter
    def target_column_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_column_name", value)

    @property
    @pulumi.getter(name="validationData")
    def validation_data(self) -> Optional[pulumi.Input['MLTableJobInputArgs']]:
        """
        Validation data inputs.
        """
        return pulumi.get(self, "validation_data")

    @validation_data.setter
    def validation_data(self, value: Optional[pulumi.Input['MLTableJobInputArgs']]):
        pulumi.set(self, "validation_data", value)

    @property
    @pulumi.getter(name="validationDataSize")
    def validation_data_size(self) -> Optional[pulumi.Input[float]]:
        """
        The fraction of training dataset that needs to be set aside for validation purpose.
        Values between (0.0 , 1.0)
        Applied when validation dataset is not provided.
        """
        return pulumi.get(self, "validation_data_size")

    @validation_data_size.setter
    def validation_data_size(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "validation_data_size", value)


@pulumi.input_type
class ImageClassificationArgs:
    def __init__(__self__, *,
                 limit_settings: pulumi.Input['ImageLimitSettingsArgs'],
                 task_type: pulumi.Input[str],
                 training_data: pulumi.Input['MLTableJobInputArgs'],
                 log_verbosity: Optional[pulumi.Input[Union[str, 'LogVerbosity']]] = None,
                 model_settings: Optional[pulumi.Input['ImageModelSettingsClassificationArgs']] = None,
                 primary_metric: Optional[pulumi.Input[Union[str, 'ClassificationPrimaryMetrics']]] = None,
                 search_space: Optional[pulumi.Input[Sequence[pulumi.Input['ImageModelDistributionSettingsClassificationArgs']]]] = None,
                 sweep_settings: Optional[pulumi.Input['ImageSweepSettingsArgs']] = None,
                 target_column_name: Optional[pulumi.Input[str]] = None,
                 validation_data: Optional[pulumi.Input['MLTableJobInputArgs']] = None,
                 validation_data_size: Optional[pulumi.Input[float]] = None):
        """
        Image Classification. Multi-class image classification is used when an image is classified with only a single label
        from a set of classes - e.g. each image is classified as either an image of a 'cat' or a 'dog' or a 'duck'.
        :param pulumi.Input['ImageLimitSettingsArgs'] limit_settings: [Required] Limit settings for the AutoML job.
        :param pulumi.Input[str] task_type: AutoMLJob Task type.
               Expected value is 'ImageClassification'.
        :param pulumi.Input['MLTableJobInputArgs'] training_data: [Required] Training data input.
        :param pulumi.Input[Union[str, 'LogVerbosity']] log_verbosity: Log verbosity for the job.
        :param pulumi.Input['ImageModelSettingsClassificationArgs'] model_settings: Settings used for training the model.
        :param pulumi.Input[Union[str, 'ClassificationPrimaryMetrics']] primary_metric: Primary metric to optimize for this task.
        :param pulumi.Input[Sequence[pulumi.Input['ImageModelDistributionSettingsClassificationArgs']]] search_space: Search space for sampling different combinations of models and their hyperparameters.
        :param pulumi.Input['ImageSweepSettingsArgs'] sweep_settings: Model sweeping and hyperparameter sweeping related settings.
        :param pulumi.Input[str] target_column_name: Target column name: This is prediction values column.
               Also known as label column name in context of classification tasks.
        :param pulumi.Input['MLTableJobInputArgs'] validation_data: Validation data inputs.
        :param pulumi.Input[float] validation_data_size: The fraction of training dataset that needs to be set aside for validation purpose.
               Values between (0.0 , 1.0)
               Applied when validation dataset is not provided.
        """
        pulumi.set(__self__, "limit_settings", limit_settings)
        pulumi.set(__self__, "task_type", 'ImageClassification')
        pulumi.set(__self__, "training_data", training_data)
        if log_verbosity is None:
            log_verbosity = 'Info'
        if log_verbosity is not None:
            pulumi.set(__self__, "log_verbosity", log_verbosity)
        if model_settings is not None:
            pulumi.set(__self__, "model_settings", model_settings)
        if primary_metric is None:
            primary_metric = 'Accuracy'
        if primary_metric is not None:
            pulumi.set(__self__, "primary_metric", primary_metric)
        if search_space is not None:
            pulumi.set(__self__, "search_space", search_space)
        if sweep_settings is not None:
            pulumi.set(__self__, "sweep_settings", sweep_settings)
        if target_column_name is not None:
            pulumi.set(__self__, "target_column_name", target_column_name)
        if validation_data is not None:
            pulumi.set(__self__, "validation_data", validation_data)
        if validation_data_size is not None:
            pulumi.set(__self__, "validation_data_size", validation_data_size)

    @property
    @pulumi.getter(name="limitSettings")
    def limit_settings(self) -> pulumi.Input['ImageLimitSettingsArgs']:
        """
        [Required] Limit settings for the AutoML job.
        """
        return pulumi.get(self, "limit_settings")

    @limit_settings.setter
    def limit_settings(self, value: pulumi.Input['ImageLimitSettingsArgs']):
        pulumi.set(self, "limit_settings", value)

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> pulumi.Input[str]:
        """
        AutoMLJob Task type.
        Expected value is 'ImageClassification'.
        """
        return pulumi.get(self, "task_type")

    @task_type.setter
    def task_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "task_type", value)

    @property
    @pulumi.getter(name="trainingData")
    def training_data(self) -> pulumi.Input['MLTableJobInputArgs']:
        """
        [Required] Training data input.
        """
        return pulumi.get(self, "training_data")

    @training_data.setter
    def training_data(self, value: pulumi.Input['MLTableJobInputArgs']):
        pulumi.set(self, "training_data", value)

    @property
    @pulumi.getter(name="logVerbosity")
    def log_verbosity(self) -> Optional[pulumi.Input[Union[str, 'LogVerbosity']]]:
        """
        Log verbosity for the job.
        """
        return pulumi.get(self, "log_verbosity")

    @log_verbosity.setter
    def log_verbosity(self, value: Optional[pulumi.Input[Union[str, 'LogVerbosity']]]):
        pulumi.set(self, "log_verbosity", value)

    @property
    @pulumi.getter(name="modelSettings")
    def model_settings(self) -> Optional[pulumi.Input['ImageModelSettingsClassificationArgs']]:
        """
        Settings used for training the model.
        """
        return pulumi.get(self, "model_settings")

    @model_settings.setter
    def model_settings(self, value: Optional[pulumi.Input['ImageModelSettingsClassificationArgs']]):
        pulumi.set(self, "model_settings", value)

    @property
    @pulumi.getter(name="primaryMetric")
    def primary_metric(self) -> Optional[pulumi.Input[Union[str, 'ClassificationPrimaryMetrics']]]:
        """
        Primary metric to optimize for this task.
        """
        return pulumi.get(self, "primary_metric")

    @primary_metric.setter
    def primary_metric(self, value: Optional[pulumi.Input[Union[str, 'ClassificationPrimaryMetrics']]]):
        pulumi.set(self, "primary_metric", value)

    @property
    @pulumi.getter(name="searchSpace")
    def search_space(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ImageModelDistributionSettingsClassificationArgs']]]]:
        """
        Search space for sampling different combinations of models and their hyperparameters.
        """
        return pulumi.get(self, "search_space")

    @search_space.setter
    def search_space(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ImageModelDistributionSettingsClassificationArgs']]]]):
        pulumi.set(self, "search_space", value)

    @property
    @pulumi.getter(name="sweepSettings")
    def sweep_settings(self) -> Optional[pulumi.Input['ImageSweepSettingsArgs']]:
        """
        Model sweeping and hyperparameter sweeping related settings.
        """
        return pulumi.get(self, "sweep_settings")

    @sweep_settings.setter
    def sweep_settings(self, value: Optional[pulumi.Input['ImageSweepSettingsArgs']]):
        pulumi.set(self, "sweep_settings", value)

    @property
    @pulumi.getter(name="targetColumnName")
    def target_column_name(self) -> Optional[pulumi.Input[str]]:
        """
        Target column name: This is prediction values column.
        Also known as label column name in context of classification tasks.
        """
        return pulumi.get(self, "target_column_name")

    @target_column_name.setter
    def target_column_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_column_name", value)

    @property
    @pulumi.getter(name="validationData")
    def validation_data(self) -> Optional[pulumi.Input['MLTableJobInputArgs']]:
        """
        Validation data inputs.
        """
        return pulumi.get(self, "validation_data")

    @validation_data.setter
    def validation_data(self, value: Optional[pulumi.Input['MLTableJobInputArgs']]):
        pulumi.set(self, "validation_data", value)

    @property
    @pulumi.getter(name="validationDataSize")
    def validation_data_size(self) -> Optional[pulumi.Input[float]]:
        """
        The fraction of training dataset that needs to be set aside for validation purpose.
        Values between (0.0 , 1.0)
        Applied when validation dataset is not provided.
        """
        return pulumi.get(self, "validation_data_size")

    @validation_data_size.setter
    def validation_data_size(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "validation_data_size", value)


@pulumi.input_type
class ImageInstanceSegmentationArgs:
    def __init__(__self__, *,
                 limit_settings: pulumi.Input['ImageLimitSettingsArgs'],
                 task_type: pulumi.Input[str],
                 training_data: pulumi.Input['MLTableJobInputArgs'],
                 log_verbosity: Optional[pulumi.Input[Union[str, 'LogVerbosity']]] = None,
                 model_settings: Optional[pulumi.Input['ImageModelSettingsObjectDetectionArgs']] = None,
                 primary_metric: Optional[pulumi.Input[Union[str, 'InstanceSegmentationPrimaryMetrics']]] = None,
                 search_space: Optional[pulumi.Input[Sequence[pulumi.Input['ImageModelDistributionSettingsObjectDetectionArgs']]]] = None,
                 sweep_settings: Optional[pulumi.Input['ImageSweepSettingsArgs']] = None,
                 target_column_name: Optional[pulumi.Input[str]] = None,
                 validation_data: Optional[pulumi.Input['MLTableJobInputArgs']] = None,
                 validation_data_size: Optional[pulumi.Input[float]] = None):
        """
        Image Instance Segmentation. Instance segmentation is used to identify objects in an image at the pixel level,
        drawing a polygon around each object in the image.
        :param pulumi.Input['ImageLimitSettingsArgs'] limit_settings: [Required] Limit settings for the AutoML job.
        :param pulumi.Input[str] task_type: AutoMLJob Task type.
               Expected value is 'ImageInstanceSegmentation'.
        :param pulumi.Input['MLTableJobInputArgs'] training_data: [Required] Training data input.
        :param pulumi.Input[Union[str, 'LogVerbosity']] log_verbosity: Log verbosity for the job.
        :param pulumi.Input['ImageModelSettingsObjectDetectionArgs'] model_settings: Settings used for training the model.
        :param pulumi.Input[Union[str, 'InstanceSegmentationPrimaryMetrics']] primary_metric: Primary metric to optimize for this task.
        :param pulumi.Input[Sequence[pulumi.Input['ImageModelDistributionSettingsObjectDetectionArgs']]] search_space: Search space for sampling different combinations of models and their hyperparameters.
        :param pulumi.Input['ImageSweepSettingsArgs'] sweep_settings: Model sweeping and hyperparameter sweeping related settings.
        :param pulumi.Input[str] target_column_name: Target column name: This is prediction values column.
               Also known as label column name in context of classification tasks.
        :param pulumi.Input['MLTableJobInputArgs'] validation_data: Validation data inputs.
        :param pulumi.Input[float] validation_data_size: The fraction of training dataset that needs to be set aside for validation purpose.
               Values between (0.0 , 1.0)
               Applied when validation dataset is not provided.
        """
        pulumi.set(__self__, "limit_settings", limit_settings)
        pulumi.set(__self__, "task_type", 'ImageInstanceSegmentation')
        pulumi.set(__self__, "training_data", training_data)
        if log_verbosity is None:
            log_verbosity = 'Info'
        if log_verbosity is not None:
            pulumi.set(__self__, "log_verbosity", log_verbosity)
        if model_settings is not None:
            pulumi.set(__self__, "model_settings", model_settings)
        if primary_metric is None:
            primary_metric = 'MeanAveragePrecision'
        if primary_metric is not None:
            pulumi.set(__self__, "primary_metric", primary_metric)
        if search_space is not None:
            pulumi.set(__self__, "search_space", search_space)
        if sweep_settings is not None:
            pulumi.set(__self__, "sweep_settings", sweep_settings)
        if target_column_name is not None:
            pulumi.set(__self__, "target_column_name", target_column_name)
        if validation_data is not None:
            pulumi.set(__self__, "validation_data", validation_data)
        if validation_data_size is not None:
            pulumi.set(__self__, "validation_data_size", validation_data_size)

    @property
    @pulumi.getter(name="limitSettings")
    def limit_settings(self) -> pulumi.Input['ImageLimitSettingsArgs']:
        """
        [Required] Limit settings for the AutoML job.
        """
        return pulumi.get(self, "limit_settings")

    @limit_settings.setter
    def limit_settings(self, value: pulumi.Input['ImageLimitSettingsArgs']):
        pulumi.set(self, "limit_settings", value)

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> pulumi.Input[str]:
        """
        AutoMLJob Task type.
        Expected value is 'ImageInstanceSegmentation'.
        """
        return pulumi.get(self, "task_type")

    @task_type.setter
    def task_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "task_type", value)

    @property
    @pulumi.getter(name="trainingData")
    def training_data(self) -> pulumi.Input['MLTableJobInputArgs']:
        """
        [Required] Training data input.
        """
        return pulumi.get(self, "training_data")

    @training_data.setter
    def training_data(self, value: pulumi.Input['MLTableJobInputArgs']):
        pulumi.set(self, "training_data", value)

    @property
    @pulumi.getter(name="logVerbosity")
    def log_verbosity(self) -> Optional[pulumi.Input[Union[str, 'LogVerbosity']]]:
        """
        Log verbosity for the job.
        """
        return pulumi.get(self, "log_verbosity")

    @log_verbosity.setter
    def log_verbosity(self, value: Optional[pulumi.Input[Union[str, 'LogVerbosity']]]):
        pulumi.set(self, "log_verbosity", value)

    @property
    @pulumi.getter(name="modelSettings")
    def model_settings(self) -> Optional[pulumi.Input['ImageModelSettingsObjectDetectionArgs']]:
        """
        Settings used for training the model.
        """
        return pulumi.get(self, "model_settings")

    @model_settings.setter
    def model_settings(self, value: Optional[pulumi.Input['ImageModelSettingsObjectDetectionArgs']]):
        pulumi.set(self, "model_settings", value)

    @property
    @pulumi.getter(name="primaryMetric")
    def primary_metric(self) -> Optional[pulumi.Input[Union[str, 'InstanceSegmentationPrimaryMetrics']]]:
        """
        Primary metric to optimize for this task.
        """
        return pulumi.get(self, "primary_metric")

    @primary_metric.setter
    def primary_metric(self, value: Optional[pulumi.Input[Union[str, 'InstanceSegmentationPrimaryMetrics']]]):
        pulumi.set(self, "primary_metric", value)

    @property
    @pulumi.getter(name="searchSpace")
    def search_space(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ImageModelDistributionSettingsObjectDetectionArgs']]]]:
        """
        Search space for sampling different combinations of models and their hyperparameters.
        """
        return pulumi.get(self, "search_space")

    @search_space.setter
    def search_space(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ImageModelDistributionSettingsObjectDetectionArgs']]]]):
        pulumi.set(self, "search_space", value)

    @property
    @pulumi.getter(name="sweepSettings")
    def sweep_settings(self) -> Optional[pulumi.Input['ImageSweepSettingsArgs']]:
        """
        Model sweeping and hyperparameter sweeping related settings.
        """
        return pulumi.get(self, "sweep_settings")

    @sweep_settings.setter
    def sweep_settings(self, value: Optional[pulumi.Input['ImageSweepSettingsArgs']]):
        pulumi.set(self, "sweep_settings", value)

    @property
    @pulumi.getter(name="targetColumnName")
    def target_column_name(self) -> Optional[pulumi.Input[str]]:
        """
        Target column name: This is prediction values column.
        Also known as label column name in context of classification tasks.
        """
        return pulumi.get(self, "target_column_name")

    @target_column_name.setter
    def target_column_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_column_name", value)

    @property
    @pulumi.getter(name="validationData")
    def validation_data(self) -> Optional[pulumi.Input['MLTableJobInputArgs']]:
        """
        Validation data inputs.
        """
        return pulumi.get(self, "validation_data")

    @validation_data.setter
    def validation_data(self, value: Optional[pulumi.Input['MLTableJobInputArgs']]):
        pulumi.set(self, "validation_data", value)

    @property
    @pulumi.getter(name="validationDataSize")
    def validation_data_size(self) -> Optional[pulumi.Input[float]]:
        """
        The fraction of training dataset that needs to be set aside for validation purpose.
        Values between (0.0 , 1.0)
        Applied when validation dataset is not provided.
        """
        return pulumi.get(self, "validation_data_size")

    @validation_data_size.setter
    def validation_data_size(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "validation_data_size", value)


@pulumi.input_type
class ImageLimitSettingsArgs:
    def __init__(__self__, *,
                 max_concurrent_trials: Optional[pulumi.Input[int]] = None,
                 max_trials: Optional[pulumi.Input[int]] = None,
                 timeout: Optional[pulumi.Input[str]] = None):
        """
        Limit settings for the AutoML job.
        :param pulumi.Input[int] max_concurrent_trials: Maximum number of concurrent AutoML iterations.
        :param pulumi.Input[int] max_trials: Maximum number of AutoML iterations.
        :param pulumi.Input[str] timeout: AutoML job timeout.
        """
        if max_concurrent_trials is None:
            max_concurrent_trials = 1
        if max_concurrent_trials is not None:
            pulumi.set(__self__, "max_concurrent_trials", max_concurrent_trials)
        if max_trials is None:
            max_trials = 1
        if max_trials is not None:
            pulumi.set(__self__, "max_trials", max_trials)
        if timeout is None:
            timeout = 'P7D'
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter(name="maxConcurrentTrials")
    def max_concurrent_trials(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum number of concurrent AutoML iterations.
        """
        return pulumi.get(self, "max_concurrent_trials")

    @max_concurrent_trials.setter
    def max_concurrent_trials(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_concurrent_trials", value)

    @property
    @pulumi.getter(name="maxTrials")
    def max_trials(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum number of AutoML iterations.
        """
        return pulumi.get(self, "max_trials")

    @max_trials.setter
    def max_trials(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_trials", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[str]]:
        """
        AutoML job timeout.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timeout", value)


@pulumi.input_type
class ImageModelDistributionSettingsClassificationArgs:
    def __init__(__self__, *,
                 ams_gradient: Optional[pulumi.Input[str]] = None,
                 augmentations: Optional[pulumi.Input[str]] = None,
                 beta1: Optional[pulumi.Input[str]] = None,
                 beta2: Optional[pulumi.Input[str]] = None,
                 distributed: Optional[pulumi.Input[str]] = None,
                 early_stopping: Optional[pulumi.Input[str]] = None,
                 early_stopping_delay: Optional[pulumi.Input[str]] = None,
                 early_stopping_patience: Optional[pulumi.Input[str]] = None,
                 enable_onnx_normalization: Optional[pulumi.Input[str]] = None,
                 evaluation_frequency: Optional[pulumi.Input[str]] = None,
                 gradient_accumulation_step: Optional[pulumi.Input[str]] = None,
                 layers_to_freeze: Optional[pulumi.Input[str]] = None,
                 learning_rate: Optional[pulumi.Input[str]] = None,
                 learning_rate_scheduler: Optional[pulumi.Input[str]] = None,
                 model_name: Optional[pulumi.Input[str]] = None,
                 momentum: Optional[pulumi.Input[str]] = None,
                 nesterov: Optional[pulumi.Input[str]] = None,
                 number_of_epochs: Optional[pulumi.Input[str]] = None,
                 number_of_workers: Optional[pulumi.Input[str]] = None,
                 optimizer: Optional[pulumi.Input[str]] = None,
                 random_seed: Optional[pulumi.Input[str]] = None,
                 step_lr_gamma: Optional[pulumi.Input[str]] = None,
                 step_lr_step_size: Optional[pulumi.Input[str]] = None,
                 training_batch_size: Optional[pulumi.Input[str]] = None,
                 training_crop_size: Optional[pulumi.Input[str]] = None,
                 validation_batch_size: Optional[pulumi.Input[str]] = None,
                 validation_crop_size: Optional[pulumi.Input[str]] = None,
                 validation_resize_size: Optional[pulumi.Input[str]] = None,
                 warmup_cosine_lr_cycles: Optional[pulumi.Input[str]] = None,
                 warmup_cosine_lr_warmup_epochs: Optional[pulumi.Input[str]] = None,
                 weight_decay: Optional[pulumi.Input[str]] = None,
                 weighted_loss: Optional[pulumi.Input[str]] = None):
        """
        Distribution expressions to sweep over values of model settings.
        <example>
        Some examples are:
        <code>
        ModelName = "choice('seresnext', 'resnest50')";
        LearningRate = "uniform(0.001, 0.01)";
        LayersToFreeze = "choice(0, 2)";
        </code></example>
        For more details on how to compose distribution expressions please check the documentation:
        https://docs.microsoft.com/en-us/azure/machine-learning/how-to-tune-hyperparameters
        For more information on the available settings please visit the official documentation:
        https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
        :param pulumi.Input[str] ams_gradient: Enable AMSGrad when optimizer is 'adam' or 'adamw'.
        :param pulumi.Input[str] augmentations: Settings for using Augmentations.
        :param pulumi.Input[str] beta1: Value of 'beta1' when optimizer is 'adam' or 'adamw'. Must be a float in the range [0, 1].
        :param pulumi.Input[str] beta2: Value of 'beta2' when optimizer is 'adam' or 'adamw'. Must be a float in the range [0, 1].
        :param pulumi.Input[str] distributed: Whether to use distributer training.
        :param pulumi.Input[str] early_stopping: Enable early stopping logic during training.
        :param pulumi.Input[str] early_stopping_delay: Minimum number of epochs or validation evaluations to wait before primary metric improvement
               is tracked for early stopping. Must be a positive integer.
        :param pulumi.Input[str] early_stopping_patience: Minimum number of epochs or validation evaluations with no primary metric improvement before
               the run is stopped. Must be a positive integer.
        :param pulumi.Input[str] enable_onnx_normalization: Enable normalization when exporting ONNX model.
        :param pulumi.Input[str] evaluation_frequency: Frequency to evaluate validation dataset to get metric scores. Must be a positive integer.
        :param pulumi.Input[str] gradient_accumulation_step: Gradient accumulation means running a configured number of "GradAccumulationStep" steps without
               updating the model weights while accumulating the gradients of those steps, and then using
               the accumulated gradients to compute the weight updates. Must be a positive integer.
        :param pulumi.Input[str] layers_to_freeze: Number of layers to freeze for the model. Must be a positive integer.
               For instance, passing 2 as value for 'seresnext' means
               freezing layer0 and layer1. For a full list of models supported and details on layer freeze, please
               see: https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
        :param pulumi.Input[str] learning_rate: Initial learning rate. Must be a float in the range [0, 1].
        :param pulumi.Input[str] learning_rate_scheduler: Type of learning rate scheduler. Must be 'warmup_cosine' or 'step'.
        :param pulumi.Input[str] model_name: Name of the model to use for training.
               For more information on the available models please visit the official documentation:
               https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
        :param pulumi.Input[str] momentum: Value of momentum when optimizer is 'sgd'. Must be a float in the range [0, 1].
        :param pulumi.Input[str] nesterov: Enable nesterov when optimizer is 'sgd'.
        :param pulumi.Input[str] number_of_epochs: Number of training epochs. Must be a positive integer.
        :param pulumi.Input[str] number_of_workers: Number of data loader workers. Must be a non-negative integer.
        :param pulumi.Input[str] optimizer: Type of optimizer. Must be either 'sgd', 'adam', or 'adamw'.
        :param pulumi.Input[str] random_seed: Random seed to be used when using deterministic training.
        :param pulumi.Input[str] step_lr_gamma: Value of gamma when learning rate scheduler is 'step'. Must be a float in the range [0, 1].
        :param pulumi.Input[str] step_lr_step_size: Value of step size when learning rate scheduler is 'step'. Must be a positive integer.
        :param pulumi.Input[str] training_batch_size: Training batch size. Must be a positive integer.
        :param pulumi.Input[str] training_crop_size: Image crop size that is input to the neural network for the training dataset. Must be a positive integer.
        :param pulumi.Input[str] validation_batch_size: Validation batch size. Must be a positive integer.
        :param pulumi.Input[str] validation_crop_size: Image crop size that is input to the neural network for the validation dataset. Must be a positive integer.
        :param pulumi.Input[str] validation_resize_size: Image size to which to resize before cropping for validation dataset. Must be a positive integer.
        :param pulumi.Input[str] warmup_cosine_lr_cycles: Value of cosine cycle when learning rate scheduler is 'warmup_cosine'. Must be a float in the range [0, 1].
        :param pulumi.Input[str] warmup_cosine_lr_warmup_epochs: Value of warmup epochs when learning rate scheduler is 'warmup_cosine'. Must be a positive integer.
        :param pulumi.Input[str] weight_decay: Value of weight decay when optimizer is 'sgd', 'adam', or 'adamw'. Must be a float in the range[0, 1].
        :param pulumi.Input[str] weighted_loss: Weighted loss. The accepted values are 0 for no weighted loss.
               1 for weighted loss with sqrt.(class_weights). 2 for weighted loss with class_weights. Must be 0 or 1 or 2.
        """
        if ams_gradient is not None:
            pulumi.set(__self__, "ams_gradient", ams_gradient)
        if augmentations is not None:
            pulumi.set(__self__, "augmentations", augmentations)
        if beta1 is not None:
            pulumi.set(__self__, "beta1", beta1)
        if beta2 is not None:
            pulumi.set(__self__, "beta2", beta2)
        if distributed is not None:
            pulumi.set(__self__, "distributed", distributed)
        if early_stopping is not None:
            pulumi.set(__self__, "early_stopping", early_stopping)
        if early_stopping_delay is not None:
            pulumi.set(__self__, "early_stopping_delay", early_stopping_delay)
        if early_stopping_patience is not None:
            pulumi.set(__self__, "early_stopping_patience", early_stopping_patience)
        if enable_onnx_normalization is not None:
            pulumi.set(__self__, "enable_onnx_normalization", enable_onnx_normalization)
        if evaluation_frequency is not None:
            pulumi.set(__self__, "evaluation_frequency", evaluation_frequency)
        if gradient_accumulation_step is not None:
            pulumi.set(__self__, "gradient_accumulation_step", gradient_accumulation_step)
        if layers_to_freeze is not None:
            pulumi.set(__self__, "layers_to_freeze", layers_to_freeze)
        if learning_rate is not None:
            pulumi.set(__self__, "learning_rate", learning_rate)
        if learning_rate_scheduler is not None:
            pulumi.set(__self__, "learning_rate_scheduler", learning_rate_scheduler)
        if model_name is not None:
            pulumi.set(__self__, "model_name", model_name)
        if momentum is not None:
            pulumi.set(__self__, "momentum", momentum)
        if nesterov is not None:
            pulumi.set(__self__, "nesterov", nesterov)
        if number_of_epochs is not None:
            pulumi.set(__self__, "number_of_epochs", number_of_epochs)
        if number_of_workers is not None:
            pulumi.set(__self__, "number_of_workers", number_of_workers)
        if optimizer is not None:
            pulumi.set(__self__, "optimizer", optimizer)
        if random_seed is not None:
            pulumi.set(__self__, "random_seed", random_seed)
        if step_lr_gamma is not None:
            pulumi.set(__self__, "step_lr_gamma", step_lr_gamma)
        if step_lr_step_size is not None:
            pulumi.set(__self__, "step_lr_step_size", step_lr_step_size)
        if training_batch_size is not None:
            pulumi.set(__self__, "training_batch_size", training_batch_size)
        if training_crop_size is not None:
            pulumi.set(__self__, "training_crop_size", training_crop_size)
        if validation_batch_size is not None:
            pulumi.set(__self__, "validation_batch_size", validation_batch_size)
        if validation_crop_size is not None:
            pulumi.set(__self__, "validation_crop_size", validation_crop_size)
        if validation_resize_size is not None:
            pulumi.set(__self__, "validation_resize_size", validation_resize_size)
        if warmup_cosine_lr_cycles is not None:
            pulumi.set(__self__, "warmup_cosine_lr_cycles", warmup_cosine_lr_cycles)
        if warmup_cosine_lr_warmup_epochs is not None:
            pulumi.set(__self__, "warmup_cosine_lr_warmup_epochs", warmup_cosine_lr_warmup_epochs)
        if weight_decay is not None:
            pulumi.set(__self__, "weight_decay", weight_decay)
        if weighted_loss is not None:
            pulumi.set(__self__, "weighted_loss", weighted_loss)

    @property
    @pulumi.getter(name="amsGradient")
    def ams_gradient(self) -> Optional[pulumi.Input[str]]:
        """
        Enable AMSGrad when optimizer is 'adam' or 'adamw'.
        """
        return pulumi.get(self, "ams_gradient")

    @ams_gradient.setter
    def ams_gradient(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ams_gradient", value)

    @property
    @pulumi.getter
    def augmentations(self) -> Optional[pulumi.Input[str]]:
        """
        Settings for using Augmentations.
        """
        return pulumi.get(self, "augmentations")

    @augmentations.setter
    def augmentations(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "augmentations", value)

    @property
    @pulumi.getter
    def beta1(self) -> Optional[pulumi.Input[str]]:
        """
        Value of 'beta1' when optimizer is 'adam' or 'adamw'. Must be a float in the range [0, 1].
        """
        return pulumi.get(self, "beta1")

    @beta1.setter
    def beta1(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "beta1", value)

    @property
    @pulumi.getter
    def beta2(self) -> Optional[pulumi.Input[str]]:
        """
        Value of 'beta2' when optimizer is 'adam' or 'adamw'. Must be a float in the range [0, 1].
        """
        return pulumi.get(self, "beta2")

    @beta2.setter
    def beta2(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "beta2", value)

    @property
    @pulumi.getter
    def distributed(self) -> Optional[pulumi.Input[str]]:
        """
        Whether to use distributer training.
        """
        return pulumi.get(self, "distributed")

    @distributed.setter
    def distributed(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "distributed", value)

    @property
    @pulumi.getter(name="earlyStopping")
    def early_stopping(self) -> Optional[pulumi.Input[str]]:
        """
        Enable early stopping logic during training.
        """
        return pulumi.get(self, "early_stopping")

    @early_stopping.setter
    def early_stopping(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "early_stopping", value)

    @property
    @pulumi.getter(name="earlyStoppingDelay")
    def early_stopping_delay(self) -> Optional[pulumi.Input[str]]:
        """
        Minimum number of epochs or validation evaluations to wait before primary metric improvement
        is tracked for early stopping. Must be a positive integer.
        """
        return pulumi.get(self, "early_stopping_delay")

    @early_stopping_delay.setter
    def early_stopping_delay(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "early_stopping_delay", value)

    @property
    @pulumi.getter(name="earlyStoppingPatience")
    def early_stopping_patience(self) -> Optional[pulumi.Input[str]]:
        """
        Minimum number of epochs or validation evaluations with no primary metric improvement before
        the run is stopped. Must be a positive integer.
        """
        return pulumi.get(self, "early_stopping_patience")

    @early_stopping_patience.setter
    def early_stopping_patience(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "early_stopping_patience", value)

    @property
    @pulumi.getter(name="enableOnnxNormalization")
    def enable_onnx_normalization(self) -> Optional[pulumi.Input[str]]:
        """
        Enable normalization when exporting ONNX model.
        """
        return pulumi.get(self, "enable_onnx_normalization")

    @enable_onnx_normalization.setter
    def enable_onnx_normalization(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enable_onnx_normalization", value)

    @property
    @pulumi.getter(name="evaluationFrequency")
    def evaluation_frequency(self) -> Optional[pulumi.Input[str]]:
        """
        Frequency to evaluate validation dataset to get metric scores. Must be a positive integer.
        """
        return pulumi.get(self, "evaluation_frequency")

    @evaluation_frequency.setter
    def evaluation_frequency(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "evaluation_frequency", value)

    @property
    @pulumi.getter(name="gradientAccumulationStep")
    def gradient_accumulation_step(self) -> Optional[pulumi.Input[str]]:
        """
        Gradient accumulation means running a configured number of "GradAccumulationStep" steps without
        updating the model weights while accumulating the gradients of those steps, and then using
        the accumulated gradients to compute the weight updates. Must be a positive integer.
        """
        return pulumi.get(self, "gradient_accumulation_step")

    @gradient_accumulation_step.setter
    def gradient_accumulation_step(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gradient_accumulation_step", value)

    @property
    @pulumi.getter(name="layersToFreeze")
    def layers_to_freeze(self) -> Optional[pulumi.Input[str]]:
        """
        Number of layers to freeze for the model. Must be a positive integer.
        For instance, passing 2 as value for 'seresnext' means
        freezing layer0 and layer1. For a full list of models supported and details on layer freeze, please
        see: https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
        """
        return pulumi.get(self, "layers_to_freeze")

    @layers_to_freeze.setter
    def layers_to_freeze(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "layers_to_freeze", value)

    @property
    @pulumi.getter(name="learningRate")
    def learning_rate(self) -> Optional[pulumi.Input[str]]:
        """
        Initial learning rate. Must be a float in the range [0, 1].
        """
        return pulumi.get(self, "learning_rate")

    @learning_rate.setter
    def learning_rate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "learning_rate", value)

    @property
    @pulumi.getter(name="learningRateScheduler")
    def learning_rate_scheduler(self) -> Optional[pulumi.Input[str]]:
        """
        Type of learning rate scheduler. Must be 'warmup_cosine' or 'step'.
        """
        return pulumi.get(self, "learning_rate_scheduler")

    @learning_rate_scheduler.setter
    def learning_rate_scheduler(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "learning_rate_scheduler", value)

    @property
    @pulumi.getter(name="modelName")
    def model_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the model to use for training.
        For more information on the available models please visit the official documentation:
        https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
        """
        return pulumi.get(self, "model_name")

    @model_name.setter
    def model_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "model_name", value)

    @property
    @pulumi.getter
    def momentum(self) -> Optional[pulumi.Input[str]]:
        """
        Value of momentum when optimizer is 'sgd'. Must be a float in the range [0, 1].
        """
        return pulumi.get(self, "momentum")

    @momentum.setter
    def momentum(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "momentum", value)

    @property
    @pulumi.getter
    def nesterov(self) -> Optional[pulumi.Input[str]]:
        """
        Enable nesterov when optimizer is 'sgd'.
        """
        return pulumi.get(self, "nesterov")

    @nesterov.setter
    def nesterov(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "nesterov", value)

    @property
    @pulumi.getter(name="numberOfEpochs")
    def number_of_epochs(self) -> Optional[pulumi.Input[str]]:
        """
        Number of training epochs. Must be a positive integer.
        """
        return pulumi.get(self, "number_of_epochs")

    @number_of_epochs.setter
    def number_of_epochs(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "number_of_epochs", value)

    @property
    @pulumi.getter(name="numberOfWorkers")
    def number_of_workers(self) -> Optional[pulumi.Input[str]]:
        """
        Number of data loader workers. Must be a non-negative integer.
        """
        return pulumi.get(self, "number_of_workers")

    @number_of_workers.setter
    def number_of_workers(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "number_of_workers", value)

    @property
    @pulumi.getter
    def optimizer(self) -> Optional[pulumi.Input[str]]:
        """
        Type of optimizer. Must be either 'sgd', 'adam', or 'adamw'.
        """
        return pulumi.get(self, "optimizer")

    @optimizer.setter
    def optimizer(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "optimizer", value)

    @property
    @pulumi.getter(name="randomSeed")
    def random_seed(self) -> Optional[pulumi.Input[str]]:
        """
        Random seed to be used when using deterministic training.
        """
        return pulumi.get(self, "random_seed")

    @random_seed.setter
    def random_seed(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "random_seed", value)

    @property
    @pulumi.getter(name="stepLRGamma")
    def step_lr_gamma(self) -> Optional[pulumi.Input[str]]:
        """
        Value of gamma when learning rate scheduler is 'step'. Must be a float in the range [0, 1].
        """
        return pulumi.get(self, "step_lr_gamma")

    @step_lr_gamma.setter
    def step_lr_gamma(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "step_lr_gamma", value)

    @property
    @pulumi.getter(name="stepLRStepSize")
    def step_lr_step_size(self) -> Optional[pulumi.Input[str]]:
        """
        Value of step size when learning rate scheduler is 'step'. Must be a positive integer.
        """
        return pulumi.get(self, "step_lr_step_size")

    @step_lr_step_size.setter
    def step_lr_step_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "step_lr_step_size", value)

    @property
    @pulumi.getter(name="trainingBatchSize")
    def training_batch_size(self) -> Optional[pulumi.Input[str]]:
        """
        Training batch size. Must be a positive integer.
        """
        return pulumi.get(self, "training_batch_size")

    @training_batch_size.setter
    def training_batch_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "training_batch_size", value)

    @property
    @pulumi.getter(name="trainingCropSize")
    def training_crop_size(self) -> Optional[pulumi.Input[str]]:
        """
        Image crop size that is input to the neural network for the training dataset. Must be a positive integer.
        """
        return pulumi.get(self, "training_crop_size")

    @training_crop_size.setter
    def training_crop_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "training_crop_size", value)

    @property
    @pulumi.getter(name="validationBatchSize")
    def validation_batch_size(self) -> Optional[pulumi.Input[str]]:
        """
        Validation batch size. Must be a positive integer.
        """
        return pulumi.get(self, "validation_batch_size")

    @validation_batch_size.setter
    def validation_batch_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "validation_batch_size", value)

    @property
    @pulumi.getter(name="validationCropSize")
    def validation_crop_size(self) -> Optional[pulumi.Input[str]]:
        """
        Image crop size that is input to the neural network for the validation dataset. Must be a positive integer.
        """
        return pulumi.get(self, "validation_crop_size")

    @validation_crop_size.setter
    def validation_crop_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "validation_crop_size", value)

    @property
    @pulumi.getter(name="validationResizeSize")
    def validation_resize_size(self) -> Optional[pulumi.Input[str]]:
        """
        Image size to which to resize before cropping for validation dataset. Must be a positive integer.
        """
        return pulumi.get(self, "validation_resize_size")

    @validation_resize_size.setter
    def validation_resize_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "validation_resize_size", value)

    @property
    @pulumi.getter(name="warmupCosineLRCycles")
    def warmup_cosine_lr_cycles(self) -> Optional[pulumi.Input[str]]:
        """
        Value of cosine cycle when learning rate scheduler is 'warmup_cosine'. Must be a float in the range [0, 1].
        """
        return pulumi.get(self, "warmup_cosine_lr_cycles")

    @warmup_cosine_lr_cycles.setter
    def warmup_cosine_lr_cycles(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "warmup_cosine_lr_cycles", value)

    @property
    @pulumi.getter(name="warmupCosineLRWarmupEpochs")
    def warmup_cosine_lr_warmup_epochs(self) -> Optional[pulumi.Input[str]]:
        """
        Value of warmup epochs when learning rate scheduler is 'warmup_cosine'. Must be a positive integer.
        """
        return pulumi.get(self, "warmup_cosine_lr_warmup_epochs")

    @warmup_cosine_lr_warmup_epochs.setter
    def warmup_cosine_lr_warmup_epochs(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "warmup_cosine_lr_warmup_epochs", value)

    @property
    @pulumi.getter(name="weightDecay")
    def weight_decay(self) -> Optional[pulumi.Input[str]]:
        """
        Value of weight decay when optimizer is 'sgd', 'adam', or 'adamw'. Must be a float in the range[0, 1].
        """
        return pulumi.get(self, "weight_decay")

    @weight_decay.setter
    def weight_decay(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "weight_decay", value)

    @property
    @pulumi.getter(name="weightedLoss")
    def weighted_loss(self) -> Optional[pulumi.Input[str]]:
        """
        Weighted loss. The accepted values are 0 for no weighted loss.
        1 for weighted loss with sqrt.(class_weights). 2 for weighted loss with class_weights. Must be 0 or 1 or 2.
        """
        return pulumi.get(self, "weighted_loss")

    @weighted_loss.setter
    def weighted_loss(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "weighted_loss", value)


@pulumi.input_type
class ImageModelDistributionSettingsObjectDetectionArgs:
    def __init__(__self__, *,
                 ams_gradient: Optional[pulumi.Input[str]] = None,
                 augmentations: Optional[pulumi.Input[str]] = None,
                 beta1: Optional[pulumi.Input[str]] = None,
                 beta2: Optional[pulumi.Input[str]] = None,
                 box_detections_per_image: Optional[pulumi.Input[str]] = None,
                 box_score_threshold: Optional[pulumi.Input[str]] = None,
                 distributed: Optional[pulumi.Input[str]] = None,
                 early_stopping: Optional[pulumi.Input[str]] = None,
                 early_stopping_delay: Optional[pulumi.Input[str]] = None,
                 early_stopping_patience: Optional[pulumi.Input[str]] = None,
                 enable_onnx_normalization: Optional[pulumi.Input[str]] = None,
                 evaluation_frequency: Optional[pulumi.Input[str]] = None,
                 gradient_accumulation_step: Optional[pulumi.Input[str]] = None,
                 image_size: Optional[pulumi.Input[str]] = None,
                 layers_to_freeze: Optional[pulumi.Input[str]] = None,
                 learning_rate: Optional[pulumi.Input[str]] = None,
                 learning_rate_scheduler: Optional[pulumi.Input[str]] = None,
                 max_size: Optional[pulumi.Input[str]] = None,
                 min_size: Optional[pulumi.Input[str]] = None,
                 model_name: Optional[pulumi.Input[str]] = None,
                 model_size: Optional[pulumi.Input[str]] = None,
                 momentum: Optional[pulumi.Input[str]] = None,
                 multi_scale: Optional[pulumi.Input[str]] = None,
                 nesterov: Optional[pulumi.Input[str]] = None,
                 nms_iou_threshold: Optional[pulumi.Input[str]] = None,
                 number_of_epochs: Optional[pulumi.Input[str]] = None,
                 number_of_workers: Optional[pulumi.Input[str]] = None,
                 optimizer: Optional[pulumi.Input[str]] = None,
                 random_seed: Optional[pulumi.Input[str]] = None,
                 step_lr_gamma: Optional[pulumi.Input[str]] = None,
                 step_lr_step_size: Optional[pulumi.Input[str]] = None,
                 tile_grid_size: Optional[pulumi.Input[str]] = None,
                 tile_overlap_ratio: Optional[pulumi.Input[str]] = None,
                 tile_predictions_nms_threshold: Optional[pulumi.Input[str]] = None,
                 training_batch_size: Optional[pulumi.Input[str]] = None,
                 validation_batch_size: Optional[pulumi.Input[str]] = None,
                 validation_iou_threshold: Optional[pulumi.Input[str]] = None,
                 validation_metric_type: Optional[pulumi.Input[str]] = None,
                 warmup_cosine_lr_cycles: Optional[pulumi.Input[str]] = None,
                 warmup_cosine_lr_warmup_epochs: Optional[pulumi.Input[str]] = None,
                 weight_decay: Optional[pulumi.Input[str]] = None):
        """
        Distribution expressions to sweep over values of model settings.
        <example>
        Some examples are:
        <code>
        ModelName = "choice('seresnext', 'resnest50')";
        LearningRate = "uniform(0.001, 0.01)";
        LayersToFreeze = "choice(0, 2)";
        </code></example>
        For more details on how to compose distribution expressions please check the documentation:
        https://docs.microsoft.com/en-us/azure/machine-learning/how-to-tune-hyperparameters
        For more information on the available settings please visit the official documentation:
        https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
        :param pulumi.Input[str] ams_gradient: Enable AMSGrad when optimizer is 'adam' or 'adamw'.
        :param pulumi.Input[str] augmentations: Settings for using Augmentations.
        :param pulumi.Input[str] beta1: Value of 'beta1' when optimizer is 'adam' or 'adamw'. Must be a float in the range [0, 1].
        :param pulumi.Input[str] beta2: Value of 'beta2' when optimizer is 'adam' or 'adamw'. Must be a float in the range [0, 1].
        :param pulumi.Input[str] box_detections_per_image: Maximum number of detections per image, for all classes. Must be a positive integer.
               Note: This settings is not supported for the 'yolov5' algorithm.
        :param pulumi.Input[str] box_score_threshold: During inference, only return proposals with a classification score greater than
               BoxScoreThreshold. Must be a float in the range[0, 1].
        :param pulumi.Input[str] distributed: Whether to use distributer training.
        :param pulumi.Input[str] early_stopping: Enable early stopping logic during training.
        :param pulumi.Input[str] early_stopping_delay: Minimum number of epochs or validation evaluations to wait before primary metric improvement
               is tracked for early stopping. Must be a positive integer.
        :param pulumi.Input[str] early_stopping_patience: Minimum number of epochs or validation evaluations with no primary metric improvement before
               the run is stopped. Must be a positive integer.
        :param pulumi.Input[str] enable_onnx_normalization: Enable normalization when exporting ONNX model.
        :param pulumi.Input[str] evaluation_frequency: Frequency to evaluate validation dataset to get metric scores. Must be a positive integer.
        :param pulumi.Input[str] gradient_accumulation_step: Gradient accumulation means running a configured number of "GradAccumulationStep" steps without
               updating the model weights while accumulating the gradients of those steps, and then using
               the accumulated gradients to compute the weight updates. Must be a positive integer.
        :param pulumi.Input[str] image_size: Image size for train and validation. Must be a positive integer.
               Note: The training run may get into CUDA OOM if the size is too big.
               Note: This settings is only supported for the 'yolov5' algorithm.
        :param pulumi.Input[str] layers_to_freeze: Number of layers to freeze for the model. Must be a positive integer.
               For instance, passing 2 as value for 'seresnext' means
               freezing layer0 and layer1. For a full list of models supported and details on layer freeze, please
               see: https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
        :param pulumi.Input[str] learning_rate: Initial learning rate. Must be a float in the range [0, 1].
        :param pulumi.Input[str] learning_rate_scheduler: Type of learning rate scheduler. Must be 'warmup_cosine' or 'step'.
        :param pulumi.Input[str] max_size: Maximum size of the image to be rescaled before feeding it to the backbone.
               Must be a positive integer. Note: training run may get into CUDA OOM if the size is too big.
               Note: This settings is not supported for the 'yolov5' algorithm.
        :param pulumi.Input[str] min_size: Minimum size of the image to be rescaled before feeding it to the backbone.
               Must be a positive integer. Note: training run may get into CUDA OOM if the size is too big.
               Note: This settings is not supported for the 'yolov5' algorithm.
        :param pulumi.Input[str] model_name: Name of the model to use for training.
               For more information on the available models please visit the official documentation:
               https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
        :param pulumi.Input[str] model_size: Model size. Must be 'small', 'medium', 'large', or 'xlarge'.
               Note: training run may get into CUDA OOM if the model size is too big.
               Note: This settings is only supported for the 'yolov5' algorithm.
        :param pulumi.Input[str] momentum: Value of momentum when optimizer is 'sgd'. Must be a float in the range [0, 1].
        :param pulumi.Input[str] multi_scale: Enable multi-scale image by varying image size by +/- 50%.
               Note: training run may get into CUDA OOM if no sufficient GPU memory.
               Note: This settings is only supported for the 'yolov5' algorithm.
        :param pulumi.Input[str] nesterov: Enable nesterov when optimizer is 'sgd'.
        :param pulumi.Input[str] nms_iou_threshold: IOU threshold used during inference in NMS post processing. Must be float in the range [0, 1].
        :param pulumi.Input[str] number_of_epochs: Number of training epochs. Must be a positive integer.
        :param pulumi.Input[str] number_of_workers: Number of data loader workers. Must be a non-negative integer.
        :param pulumi.Input[str] optimizer: Type of optimizer. Must be either 'sgd', 'adam', or 'adamw'.
        :param pulumi.Input[str] random_seed: Random seed to be used when using deterministic training.
        :param pulumi.Input[str] step_lr_gamma: Value of gamma when learning rate scheduler is 'step'. Must be a float in the range [0, 1].
        :param pulumi.Input[str] step_lr_step_size: Value of step size when learning rate scheduler is 'step'. Must be a positive integer.
        :param pulumi.Input[str] tile_grid_size: The grid size to use for tiling each image. Note: TileGridSize must not be
               None to enable small object detection logic. A string containing two integers in mxn format.
               Note: This settings is not supported for the 'yolov5' algorithm.
        :param pulumi.Input[str] tile_overlap_ratio: Overlap ratio between adjacent tiles in each dimension. Must be float in the range [0, 1).
               Note: This settings is not supported for the 'yolov5' algorithm.
        :param pulumi.Input[str] tile_predictions_nms_threshold: The IOU threshold to use to perform NMS while merging predictions from tiles and image.
               Used in validation/ inference. Must be float in the range [0, 1].
               Note: This settings is not supported for the 'yolov5' algorithm.
               NMS: Non-maximum suppression
        :param pulumi.Input[str] training_batch_size: Training batch size. Must be a positive integer.
        :param pulumi.Input[str] validation_batch_size: Validation batch size. Must be a positive integer.
        :param pulumi.Input[str] validation_iou_threshold: IOU threshold to use when computing validation metric. Must be float in the range [0, 1].
        :param pulumi.Input[str] validation_metric_type: Metric computation method to use for validation metrics. Must be 'none', 'coco', 'voc', or 'coco_voc'.
        :param pulumi.Input[str] warmup_cosine_lr_cycles: Value of cosine cycle when learning rate scheduler is 'warmup_cosine'. Must be a float in the range [0, 1].
        :param pulumi.Input[str] warmup_cosine_lr_warmup_epochs: Value of warmup epochs when learning rate scheduler is 'warmup_cosine'. Must be a positive integer.
        :param pulumi.Input[str] weight_decay: Value of weight decay when optimizer is 'sgd', 'adam', or 'adamw'. Must be a float in the range[0, 1].
        """
        if ams_gradient is not None:
            pulumi.set(__self__, "ams_gradient", ams_gradient)
        if augmentations is not None:
            pulumi.set(__self__, "augmentations", augmentations)
        if beta1 is not None:
            pulumi.set(__self__, "beta1", beta1)
        if beta2 is not None:
            pulumi.set(__self__, "beta2", beta2)
        if box_detections_per_image is not None:
            pulumi.set(__self__, "box_detections_per_image", box_detections_per_image)
        if box_score_threshold is not None:
            pulumi.set(__self__, "box_score_threshold", box_score_threshold)
        if distributed is not None:
            pulumi.set(__self__, "distributed", distributed)
        if early_stopping is not None:
            pulumi.set(__self__, "early_stopping", early_stopping)
        if early_stopping_delay is not None:
            pulumi.set(__self__, "early_stopping_delay", early_stopping_delay)
        if early_stopping_patience is not None:
            pulumi.set(__self__, "early_stopping_patience", early_stopping_patience)
        if enable_onnx_normalization is not None:
            pulumi.set(__self__, "enable_onnx_normalization", enable_onnx_normalization)
        if evaluation_frequency is not None:
            pulumi.set(__self__, "evaluation_frequency", evaluation_frequency)
        if gradient_accumulation_step is not None:
            pulumi.set(__self__, "gradient_accumulation_step", gradient_accumulation_step)
        if image_size is not None:
            pulumi.set(__self__, "image_size", image_size)
        if layers_to_freeze is not None:
            pulumi.set(__self__, "layers_to_freeze", layers_to_freeze)
        if learning_rate is not None:
            pulumi.set(__self__, "learning_rate", learning_rate)
        if learning_rate_scheduler is not None:
            pulumi.set(__self__, "learning_rate_scheduler", learning_rate_scheduler)
        if max_size is not None:
            pulumi.set(__self__, "max_size", max_size)
        if min_size is not None:
            pulumi.set(__self__, "min_size", min_size)
        if model_name is not None:
            pulumi.set(__self__, "model_name", model_name)
        if model_size is not None:
            pulumi.set(__self__, "model_size", model_size)
        if momentum is not None:
            pulumi.set(__self__, "momentum", momentum)
        if multi_scale is not None:
            pulumi.set(__self__, "multi_scale", multi_scale)
        if nesterov is not None:
            pulumi.set(__self__, "nesterov", nesterov)
        if nms_iou_threshold is not None:
            pulumi.set(__self__, "nms_iou_threshold", nms_iou_threshold)
        if number_of_epochs is not None:
            pulumi.set(__self__, "number_of_epochs", number_of_epochs)
        if number_of_workers is not None:
            pulumi.set(__self__, "number_of_workers", number_of_workers)
        if optimizer is not None:
            pulumi.set(__self__, "optimizer", optimizer)
        if random_seed is not None:
            pulumi.set(__self__, "random_seed", random_seed)
        if step_lr_gamma is not None:
            pulumi.set(__self__, "step_lr_gamma", step_lr_gamma)
        if step_lr_step_size is not None:
            pulumi.set(__self__, "step_lr_step_size", step_lr_step_size)
        if tile_grid_size is not None:
            pulumi.set(__self__, "tile_grid_size", tile_grid_size)
        if tile_overlap_ratio is not None:
            pulumi.set(__self__, "tile_overlap_ratio", tile_overlap_ratio)
        if tile_predictions_nms_threshold is not None:
            pulumi.set(__self__, "tile_predictions_nms_threshold", tile_predictions_nms_threshold)
        if training_batch_size is not None:
            pulumi.set(__self__, "training_batch_size", training_batch_size)
        if validation_batch_size is not None:
            pulumi.set(__self__, "validation_batch_size", validation_batch_size)
        if validation_iou_threshold is not None:
            pulumi.set(__self__, "validation_iou_threshold", validation_iou_threshold)
        if validation_metric_type is not None:
            pulumi.set(__self__, "validation_metric_type", validation_metric_type)
        if warmup_cosine_lr_cycles is not None:
            pulumi.set(__self__, "warmup_cosine_lr_cycles", warmup_cosine_lr_cycles)
        if warmup_cosine_lr_warmup_epochs is not None:
            pulumi.set(__self__, "warmup_cosine_lr_warmup_epochs", warmup_cosine_lr_warmup_epochs)
        if weight_decay is not None:
            pulumi.set(__self__, "weight_decay", weight_decay)

    @property
    @pulumi.getter(name="amsGradient")
    def ams_gradient(self) -> Optional[pulumi.Input[str]]:
        """
        Enable AMSGrad when optimizer is 'adam' or 'adamw'.
        """
        return pulumi.get(self, "ams_gradient")

    @ams_gradient.setter
    def ams_gradient(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ams_gradient", value)

    @property
    @pulumi.getter
    def augmentations(self) -> Optional[pulumi.Input[str]]:
        """
        Settings for using Augmentations.
        """
        return pulumi.get(self, "augmentations")

    @augmentations.setter
    def augmentations(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "augmentations", value)

    @property
    @pulumi.getter
    def beta1(self) -> Optional[pulumi.Input[str]]:
        """
        Value of 'beta1' when optimizer is 'adam' or 'adamw'. Must be a float in the range [0, 1].
        """
        return pulumi.get(self, "beta1")

    @beta1.setter
    def beta1(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "beta1", value)

    @property
    @pulumi.getter
    def beta2(self) -> Optional[pulumi.Input[str]]:
        """
        Value of 'beta2' when optimizer is 'adam' or 'adamw'. Must be a float in the range [0, 1].
        """
        return pulumi.get(self, "beta2")

    @beta2.setter
    def beta2(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "beta2", value)

    @property
    @pulumi.getter(name="boxDetectionsPerImage")
    def box_detections_per_image(self) -> Optional[pulumi.Input[str]]:
        """
        Maximum number of detections per image, for all classes. Must be a positive integer.
        Note: This settings is not supported for the 'yolov5' algorithm.
        """
        return pulumi.get(self, "box_detections_per_image")

    @box_detections_per_image.setter
    def box_detections_per_image(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "box_detections_per_image", value)

    @property
    @pulumi.getter(name="boxScoreThreshold")
    def box_score_threshold(self) -> Optional[pulumi.Input[str]]:
        """
        During inference, only return proposals with a classification score greater than
        BoxScoreThreshold. Must be a float in the range[0, 1].
        """
        return pulumi.get(self, "box_score_threshold")

    @box_score_threshold.setter
    def box_score_threshold(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "box_score_threshold", value)

    @property
    @pulumi.getter
    def distributed(self) -> Optional[pulumi.Input[str]]:
        """
        Whether to use distributer training.
        """
        return pulumi.get(self, "distributed")

    @distributed.setter
    def distributed(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "distributed", value)

    @property
    @pulumi.getter(name="earlyStopping")
    def early_stopping(self) -> Optional[pulumi.Input[str]]:
        """
        Enable early stopping logic during training.
        """
        return pulumi.get(self, "early_stopping")

    @early_stopping.setter
    def early_stopping(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "early_stopping", value)

    @property
    @pulumi.getter(name="earlyStoppingDelay")
    def early_stopping_delay(self) -> Optional[pulumi.Input[str]]:
        """
        Minimum number of epochs or validation evaluations to wait before primary metric improvement
        is tracked for early stopping. Must be a positive integer.
        """
        return pulumi.get(self, "early_stopping_delay")

    @early_stopping_delay.setter
    def early_stopping_delay(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "early_stopping_delay", value)

    @property
    @pulumi.getter(name="earlyStoppingPatience")
    def early_stopping_patience(self) -> Optional[pulumi.Input[str]]:
        """
        Minimum number of epochs or validation evaluations with no primary metric improvement before
        the run is stopped. Must be a positive integer.
        """
        return pulumi.get(self, "early_stopping_patience")

    @early_stopping_patience.setter
    def early_stopping_patience(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "early_stopping_patience", value)

    @property
    @pulumi.getter(name="enableOnnxNormalization")
    def enable_onnx_normalization(self) -> Optional[pulumi.Input[str]]:
        """
        Enable normalization when exporting ONNX model.
        """
        return pulumi.get(self, "enable_onnx_normalization")

    @enable_onnx_normalization.setter
    def enable_onnx_normalization(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enable_onnx_normalization", value)

    @property
    @pulumi.getter(name="evaluationFrequency")
    def evaluation_frequency(self) -> Optional[pulumi.Input[str]]:
        """
        Frequency to evaluate validation dataset to get metric scores. Must be a positive integer.
        """
        return pulumi.get(self, "evaluation_frequency")

    @evaluation_frequency.setter
    def evaluation_frequency(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "evaluation_frequency", value)

    @property
    @pulumi.getter(name="gradientAccumulationStep")
    def gradient_accumulation_step(self) -> Optional[pulumi.Input[str]]:
        """
        Gradient accumulation means running a configured number of "GradAccumulationStep" steps without
        updating the model weights while accumulating the gradients of those steps, and then using
        the accumulated gradients to compute the weight updates. Must be a positive integer.
        """
        return pulumi.get(self, "gradient_accumulation_step")

    @gradient_accumulation_step.setter
    def gradient_accumulation_step(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gradient_accumulation_step", value)

    @property
    @pulumi.getter(name="imageSize")
    def image_size(self) -> Optional[pulumi.Input[str]]:
        """
        Image size for train and validation. Must be a positive integer.
        Note: The training run may get into CUDA OOM if the size is too big.
        Note: This settings is only supported for the 'yolov5' algorithm.
        """
        return pulumi.get(self, "image_size")

    @image_size.setter
    def image_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_size", value)

    @property
    @pulumi.getter(name="layersToFreeze")
    def layers_to_freeze(self) -> Optional[pulumi.Input[str]]:
        """
        Number of layers to freeze for the model. Must be a positive integer.
        For instance, passing 2 as value for 'seresnext' means
        freezing layer0 and layer1. For a full list of models supported and details on layer freeze, please
        see: https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
        """
        return pulumi.get(self, "layers_to_freeze")

    @layers_to_freeze.setter
    def layers_to_freeze(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "layers_to_freeze", value)

    @property
    @pulumi.getter(name="learningRate")
    def learning_rate(self) -> Optional[pulumi.Input[str]]:
        """
        Initial learning rate. Must be a float in the range [0, 1].
        """
        return pulumi.get(self, "learning_rate")

    @learning_rate.setter
    def learning_rate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "learning_rate", value)

    @property
    @pulumi.getter(name="learningRateScheduler")
    def learning_rate_scheduler(self) -> Optional[pulumi.Input[str]]:
        """
        Type of learning rate scheduler. Must be 'warmup_cosine' or 'step'.
        """
        return pulumi.get(self, "learning_rate_scheduler")

    @learning_rate_scheduler.setter
    def learning_rate_scheduler(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "learning_rate_scheduler", value)

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> Optional[pulumi.Input[str]]:
        """
        Maximum size of the image to be rescaled before feeding it to the backbone.
        Must be a positive integer. Note: training run may get into CUDA OOM if the size is too big.
        Note: This settings is not supported for the 'yolov5' algorithm.
        """
        return pulumi.get(self, "max_size")

    @max_size.setter
    def max_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "max_size", value)

    @property
    @pulumi.getter(name="minSize")
    def min_size(self) -> Optional[pulumi.Input[str]]:
        """
        Minimum size of the image to be rescaled before feeding it to the backbone.
        Must be a positive integer. Note: training run may get into CUDA OOM if the size is too big.
        Note: This settings is not supported for the 'yolov5' algorithm.
        """
        return pulumi.get(self, "min_size")

    @min_size.setter
    def min_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "min_size", value)

    @property
    @pulumi.getter(name="modelName")
    def model_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the model to use for training.
        For more information on the available models please visit the official documentation:
        https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
        """
        return pulumi.get(self, "model_name")

    @model_name.setter
    def model_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "model_name", value)

    @property
    @pulumi.getter(name="modelSize")
    def model_size(self) -> Optional[pulumi.Input[str]]:
        """
        Model size. Must be 'small', 'medium', 'large', or 'xlarge'.
        Note: training run may get into CUDA OOM if the model size is too big.
        Note: This settings is only supported for the 'yolov5' algorithm.
        """
        return pulumi.get(self, "model_size")

    @model_size.setter
    def model_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "model_size", value)

    @property
    @pulumi.getter
    def momentum(self) -> Optional[pulumi.Input[str]]:
        """
        Value of momentum when optimizer is 'sgd'. Must be a float in the range [0, 1].
        """
        return pulumi.get(self, "momentum")

    @momentum.setter
    def momentum(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "momentum", value)

    @property
    @pulumi.getter(name="multiScale")
    def multi_scale(self) -> Optional[pulumi.Input[str]]:
        """
        Enable multi-scale image by varying image size by +/- 50%.
        Note: training run may get into CUDA OOM if no sufficient GPU memory.
        Note: This settings is only supported for the 'yolov5' algorithm.
        """
        return pulumi.get(self, "multi_scale")

    @multi_scale.setter
    def multi_scale(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "multi_scale", value)

    @property
    @pulumi.getter
    def nesterov(self) -> Optional[pulumi.Input[str]]:
        """
        Enable nesterov when optimizer is 'sgd'.
        """
        return pulumi.get(self, "nesterov")

    @nesterov.setter
    def nesterov(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "nesterov", value)

    @property
    @pulumi.getter(name="nmsIouThreshold")
    def nms_iou_threshold(self) -> Optional[pulumi.Input[str]]:
        """
        IOU threshold used during inference in NMS post processing. Must be float in the range [0, 1].
        """
        return pulumi.get(self, "nms_iou_threshold")

    @nms_iou_threshold.setter
    def nms_iou_threshold(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "nms_iou_threshold", value)

    @property
    @pulumi.getter(name="numberOfEpochs")
    def number_of_epochs(self) -> Optional[pulumi.Input[str]]:
        """
        Number of training epochs. Must be a positive integer.
        """
        return pulumi.get(self, "number_of_epochs")

    @number_of_epochs.setter
    def number_of_epochs(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "number_of_epochs", value)

    @property
    @pulumi.getter(name="numberOfWorkers")
    def number_of_workers(self) -> Optional[pulumi.Input[str]]:
        """
        Number of data loader workers. Must be a non-negative integer.
        """
        return pulumi.get(self, "number_of_workers")

    @number_of_workers.setter
    def number_of_workers(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "number_of_workers", value)

    @property
    @pulumi.getter
    def optimizer(self) -> Optional[pulumi.Input[str]]:
        """
        Type of optimizer. Must be either 'sgd', 'adam', or 'adamw'.
        """
        return pulumi.get(self, "optimizer")

    @optimizer.setter
    def optimizer(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "optimizer", value)

    @property
    @pulumi.getter(name="randomSeed")
    def random_seed(self) -> Optional[pulumi.Input[str]]:
        """
        Random seed to be used when using deterministic training.
        """
        return pulumi.get(self, "random_seed")

    @random_seed.setter
    def random_seed(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "random_seed", value)

    @property
    @pulumi.getter(name="stepLRGamma")
    def step_lr_gamma(self) -> Optional[pulumi.Input[str]]:
        """
        Value of gamma when learning rate scheduler is 'step'. Must be a float in the range [0, 1].
        """
        return pulumi.get(self, "step_lr_gamma")

    @step_lr_gamma.setter
    def step_lr_gamma(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "step_lr_gamma", value)

    @property
    @pulumi.getter(name="stepLRStepSize")
    def step_lr_step_size(self) -> Optional[pulumi.Input[str]]:
        """
        Value of step size when learning rate scheduler is 'step'. Must be a positive integer.
        """
        return pulumi.get(self, "step_lr_step_size")

    @step_lr_step_size.setter
    def step_lr_step_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "step_lr_step_size", value)

    @property
    @pulumi.getter(name="tileGridSize")
    def tile_grid_size(self) -> Optional[pulumi.Input[str]]:
        """
        The grid size to use for tiling each image. Note: TileGridSize must not be
        None to enable small object detection logic. A string containing two integers in mxn format.
        Note: This settings is not supported for the 'yolov5' algorithm.
        """
        return pulumi.get(self, "tile_grid_size")

    @tile_grid_size.setter
    def tile_grid_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tile_grid_size", value)

    @property
    @pulumi.getter(name="tileOverlapRatio")
    def tile_overlap_ratio(self) -> Optional[pulumi.Input[str]]:
        """
        Overlap ratio between adjacent tiles in each dimension. Must be float in the range [0, 1).
        Note: This settings is not supported for the 'yolov5' algorithm.
        """
        return pulumi.get(self, "tile_overlap_ratio")

    @tile_overlap_ratio.setter
    def tile_overlap_ratio(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tile_overlap_ratio", value)

    @property
    @pulumi.getter(name="tilePredictionsNmsThreshold")
    def tile_predictions_nms_threshold(self) -> Optional[pulumi.Input[str]]:
        """
        The IOU threshold to use to perform NMS while merging predictions from tiles and image.
        Used in validation/ inference. Must be float in the range [0, 1].
        Note: This settings is not supported for the 'yolov5' algorithm.
        NMS: Non-maximum suppression
        """
        return pulumi.get(self, "tile_predictions_nms_threshold")

    @tile_predictions_nms_threshold.setter
    def tile_predictions_nms_threshold(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tile_predictions_nms_threshold", value)

    @property
    @pulumi.getter(name="trainingBatchSize")
    def training_batch_size(self) -> Optional[pulumi.Input[str]]:
        """
        Training batch size. Must be a positive integer.
        """
        return pulumi.get(self, "training_batch_size")

    @training_batch_size.setter
    def training_batch_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "training_batch_size", value)

    @property
    @pulumi.getter(name="validationBatchSize")
    def validation_batch_size(self) -> Optional[pulumi.Input[str]]:
        """
        Validation batch size. Must be a positive integer.
        """
        return pulumi.get(self, "validation_batch_size")

    @validation_batch_size.setter
    def validation_batch_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "validation_batch_size", value)

    @property
    @pulumi.getter(name="validationIouThreshold")
    def validation_iou_threshold(self) -> Optional[pulumi.Input[str]]:
        """
        IOU threshold to use when computing validation metric. Must be float in the range [0, 1].
        """
        return pulumi.get(self, "validation_iou_threshold")

    @validation_iou_threshold.setter
    def validation_iou_threshold(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "validation_iou_threshold", value)

    @property
    @pulumi.getter(name="validationMetricType")
    def validation_metric_type(self) -> Optional[pulumi.Input[str]]:
        """
        Metric computation method to use for validation metrics. Must be 'none', 'coco', 'voc', or 'coco_voc'.
        """
        return pulumi.get(self, "validation_metric_type")

    @validation_metric_type.setter
    def validation_metric_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "validation_metric_type", value)

    @property
    @pulumi.getter(name="warmupCosineLRCycles")
    def warmup_cosine_lr_cycles(self) -> Optional[pulumi.Input[str]]:
        """
        Value of cosine cycle when learning rate scheduler is 'warmup_cosine'. Must be a float in the range [0, 1].
        """
        return pulumi.get(self, "warmup_cosine_lr_cycles")

    @warmup_cosine_lr_cycles.setter
    def warmup_cosine_lr_cycles(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "warmup_cosine_lr_cycles", value)

    @property
    @pulumi.getter(name="warmupCosineLRWarmupEpochs")
    def warmup_cosine_lr_warmup_epochs(self) -> Optional[pulumi.Input[str]]:
        """
        Value of warmup epochs when learning rate scheduler is 'warmup_cosine'. Must be a positive integer.
        """
        return pulumi.get(self, "warmup_cosine_lr_warmup_epochs")

    @warmup_cosine_lr_warmup_epochs.setter
    def warmup_cosine_lr_warmup_epochs(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "warmup_cosine_lr_warmup_epochs", value)

    @property
    @pulumi.getter(name="weightDecay")
    def weight_decay(self) -> Optional[pulumi.Input[str]]:
        """
        Value of weight decay when optimizer is 'sgd', 'adam', or 'adamw'. Must be a float in the range[0, 1].
        """
        return pulumi.get(self, "weight_decay")

    @weight_decay.setter
    def weight_decay(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "weight_decay", value)


@pulumi.input_type
class ImageModelSettingsClassificationArgs:
    def __init__(__self__, *,
                 advanced_settings: Optional[pulumi.Input[str]] = None,
                 ams_gradient: Optional[pulumi.Input[bool]] = None,
                 augmentations: Optional[pulumi.Input[str]] = None,
                 beta1: Optional[pulumi.Input[float]] = None,
                 beta2: Optional[pulumi.Input[float]] = None,
                 checkpoint_frequency: Optional[pulumi.Input[int]] = None,
                 checkpoint_model: Optional[pulumi.Input['MLFlowModelJobInputArgs']] = None,
                 checkpoint_run_id: Optional[pulumi.Input[str]] = None,
                 distributed: Optional[pulumi.Input[bool]] = None,
                 early_stopping: Optional[pulumi.Input[bool]] = None,
                 early_stopping_delay: Optional[pulumi.Input[int]] = None,
                 early_stopping_patience: Optional[pulumi.Input[int]] = None,
                 enable_onnx_normalization: Optional[pulumi.Input[bool]] = None,
                 evaluation_frequency: Optional[pulumi.Input[int]] = None,
                 gradient_accumulation_step: Optional[pulumi.Input[int]] = None,
                 layers_to_freeze: Optional[pulumi.Input[int]] = None,
                 learning_rate: Optional[pulumi.Input[float]] = None,
                 learning_rate_scheduler: Optional[pulumi.Input[Union[str, 'LearningRateScheduler']]] = None,
                 model_name: Optional[pulumi.Input[str]] = None,
                 momentum: Optional[pulumi.Input[float]] = None,
                 nesterov: Optional[pulumi.Input[bool]] = None,
                 number_of_epochs: Optional[pulumi.Input[int]] = None,
                 number_of_workers: Optional[pulumi.Input[int]] = None,
                 optimizer: Optional[pulumi.Input[Union[str, 'StochasticOptimizer']]] = None,
                 random_seed: Optional[pulumi.Input[int]] = None,
                 step_lr_gamma: Optional[pulumi.Input[float]] = None,
                 step_lr_step_size: Optional[pulumi.Input[int]] = None,
                 training_batch_size: Optional[pulumi.Input[int]] = None,
                 training_crop_size: Optional[pulumi.Input[int]] = None,
                 validation_batch_size: Optional[pulumi.Input[int]] = None,
                 validation_crop_size: Optional[pulumi.Input[int]] = None,
                 validation_resize_size: Optional[pulumi.Input[int]] = None,
                 warmup_cosine_lr_cycles: Optional[pulumi.Input[float]] = None,
                 warmup_cosine_lr_warmup_epochs: Optional[pulumi.Input[int]] = None,
                 weight_decay: Optional[pulumi.Input[float]] = None,
                 weighted_loss: Optional[pulumi.Input[int]] = None):
        """
        Settings used for training the model.
        For more information on the available settings please visit the official documentation:
        https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
        :param pulumi.Input[str] advanced_settings: Settings for advanced scenarios.
        :param pulumi.Input[bool] ams_gradient: Enable AMSGrad when optimizer is 'adam' or 'adamw'.
        :param pulumi.Input[str] augmentations: Settings for using Augmentations.
        :param pulumi.Input[float] beta1: Value of 'beta1' when optimizer is 'adam' or 'adamw'. Must be a float in the range [0, 1].
        :param pulumi.Input[float] beta2: Value of 'beta2' when optimizer is 'adam' or 'adamw'. Must be a float in the range [0, 1].
        :param pulumi.Input[int] checkpoint_frequency: Frequency to store model checkpoints. Must be a positive integer.
        :param pulumi.Input['MLFlowModelJobInputArgs'] checkpoint_model: The pretrained checkpoint model for incremental training.
        :param pulumi.Input[str] checkpoint_run_id: The id of a previous run that has a pretrained checkpoint for incremental training.
        :param pulumi.Input[bool] distributed: Whether to use distributed training.
        :param pulumi.Input[bool] early_stopping: Enable early stopping logic during training.
        :param pulumi.Input[int] early_stopping_delay: Minimum number of epochs or validation evaluations to wait before primary metric improvement
               is tracked for early stopping. Must be a positive integer.
        :param pulumi.Input[int] early_stopping_patience: Minimum number of epochs or validation evaluations with no primary metric improvement before
               the run is stopped. Must be a positive integer.
        :param pulumi.Input[bool] enable_onnx_normalization: Enable normalization when exporting ONNX model.
        :param pulumi.Input[int] evaluation_frequency: Frequency to evaluate validation dataset to get metric scores. Must be a positive integer.
        :param pulumi.Input[int] gradient_accumulation_step: Gradient accumulation means running a configured number of "GradAccumulationStep" steps without
               updating the model weights while accumulating the gradients of those steps, and then using
               the accumulated gradients to compute the weight updates. Must be a positive integer.
        :param pulumi.Input[int] layers_to_freeze: Number of layers to freeze for the model. Must be a positive integer.
               For instance, passing 2 as value for 'seresnext' means
               freezing layer0 and layer1. For a full list of models supported and details on layer freeze, please
               see: https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
        :param pulumi.Input[float] learning_rate: Initial learning rate. Must be a float in the range [0, 1].
        :param pulumi.Input[Union[str, 'LearningRateScheduler']] learning_rate_scheduler: Type of learning rate scheduler. Must be 'warmup_cosine' or 'step'.
        :param pulumi.Input[str] model_name: Name of the model to use for training.
               For more information on the available models please visit the official documentation:
               https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
        :param pulumi.Input[float] momentum: Value of momentum when optimizer is 'sgd'. Must be a float in the range [0, 1].
        :param pulumi.Input[bool] nesterov: Enable nesterov when optimizer is 'sgd'.
        :param pulumi.Input[int] number_of_epochs: Number of training epochs. Must be a positive integer.
        :param pulumi.Input[int] number_of_workers: Number of data loader workers. Must be a non-negative integer.
        :param pulumi.Input[Union[str, 'StochasticOptimizer']] optimizer: Type of optimizer.
        :param pulumi.Input[int] random_seed: Random seed to be used when using deterministic training.
        :param pulumi.Input[float] step_lr_gamma: Value of gamma when learning rate scheduler is 'step'. Must be a float in the range [0, 1].
        :param pulumi.Input[int] step_lr_step_size: Value of step size when learning rate scheduler is 'step'. Must be a positive integer.
        :param pulumi.Input[int] training_batch_size: Training batch size. Must be a positive integer.
        :param pulumi.Input[int] training_crop_size: Image crop size that is input to the neural network for the training dataset. Must be a positive integer.
        :param pulumi.Input[int] validation_batch_size: Validation batch size. Must be a positive integer.
        :param pulumi.Input[int] validation_crop_size: Image crop size that is input to the neural network for the validation dataset. Must be a positive integer.
        :param pulumi.Input[int] validation_resize_size: Image size to which to resize before cropping for validation dataset. Must be a positive integer.
        :param pulumi.Input[float] warmup_cosine_lr_cycles: Value of cosine cycle when learning rate scheduler is 'warmup_cosine'. Must be a float in the range [0, 1].
        :param pulumi.Input[int] warmup_cosine_lr_warmup_epochs: Value of warmup epochs when learning rate scheduler is 'warmup_cosine'. Must be a positive integer.
        :param pulumi.Input[float] weight_decay: Value of weight decay when optimizer is 'sgd', 'adam', or 'adamw'. Must be a float in the range[0, 1].
        :param pulumi.Input[int] weighted_loss: Weighted loss. The accepted values are 0 for no weighted loss.
               1 for weighted loss with sqrt.(class_weights). 2 for weighted loss with class_weights. Must be 0 or 1 or 2.
        """
        if advanced_settings is not None:
            pulumi.set(__self__, "advanced_settings", advanced_settings)
        if ams_gradient is not None:
            pulumi.set(__self__, "ams_gradient", ams_gradient)
        if augmentations is not None:
            pulumi.set(__self__, "augmentations", augmentations)
        if beta1 is not None:
            pulumi.set(__self__, "beta1", beta1)
        if beta2 is not None:
            pulumi.set(__self__, "beta2", beta2)
        if checkpoint_frequency is not None:
            pulumi.set(__self__, "checkpoint_frequency", checkpoint_frequency)
        if checkpoint_model is not None:
            pulumi.set(__self__, "checkpoint_model", checkpoint_model)
        if checkpoint_run_id is not None:
            pulumi.set(__self__, "checkpoint_run_id", checkpoint_run_id)
        if distributed is not None:
            pulumi.set(__self__, "distributed", distributed)
        if early_stopping is not None:
            pulumi.set(__self__, "early_stopping", early_stopping)
        if early_stopping_delay is not None:
            pulumi.set(__self__, "early_stopping_delay", early_stopping_delay)
        if early_stopping_patience is not None:
            pulumi.set(__self__, "early_stopping_patience", early_stopping_patience)
        if enable_onnx_normalization is not None:
            pulumi.set(__self__, "enable_onnx_normalization", enable_onnx_normalization)
        if evaluation_frequency is not None:
            pulumi.set(__self__, "evaluation_frequency", evaluation_frequency)
        if gradient_accumulation_step is not None:
            pulumi.set(__self__, "gradient_accumulation_step", gradient_accumulation_step)
        if layers_to_freeze is not None:
            pulumi.set(__self__, "layers_to_freeze", layers_to_freeze)
        if learning_rate is not None:
            pulumi.set(__self__, "learning_rate", learning_rate)
        if learning_rate_scheduler is None:
            learning_rate_scheduler = 'None'
        if learning_rate_scheduler is not None:
            pulumi.set(__self__, "learning_rate_scheduler", learning_rate_scheduler)
        if model_name is not None:
            pulumi.set(__self__, "model_name", model_name)
        if momentum is not None:
            pulumi.set(__self__, "momentum", momentum)
        if nesterov is not None:
            pulumi.set(__self__, "nesterov", nesterov)
        if number_of_epochs is not None:
            pulumi.set(__self__, "number_of_epochs", number_of_epochs)
        if number_of_workers is not None:
            pulumi.set(__self__, "number_of_workers", number_of_workers)
        if optimizer is None:
            optimizer = 'None'
        if optimizer is not None:
            pulumi.set(__self__, "optimizer", optimizer)
        if random_seed is not None:
            pulumi.set(__self__, "random_seed", random_seed)
        if step_lr_gamma is not None:
            pulumi.set(__self__, "step_lr_gamma", step_lr_gamma)
        if step_lr_step_size is not None:
            pulumi.set(__self__, "step_lr_step_size", step_lr_step_size)
        if training_batch_size is not None:
            pulumi.set(__self__, "training_batch_size", training_batch_size)
        if training_crop_size is not None:
            pulumi.set(__self__, "training_crop_size", training_crop_size)
        if validation_batch_size is not None:
            pulumi.set(__self__, "validation_batch_size", validation_batch_size)
        if validation_crop_size is not None:
            pulumi.set(__self__, "validation_crop_size", validation_crop_size)
        if validation_resize_size is not None:
            pulumi.set(__self__, "validation_resize_size", validation_resize_size)
        if warmup_cosine_lr_cycles is not None:
            pulumi.set(__self__, "warmup_cosine_lr_cycles", warmup_cosine_lr_cycles)
        if warmup_cosine_lr_warmup_epochs is not None:
            pulumi.set(__self__, "warmup_cosine_lr_warmup_epochs", warmup_cosine_lr_warmup_epochs)
        if weight_decay is not None:
            pulumi.set(__self__, "weight_decay", weight_decay)
        if weighted_loss is not None:
            pulumi.set(__self__, "weighted_loss", weighted_loss)

    @property
    @pulumi.getter(name="advancedSettings")
    def advanced_settings(self) -> Optional[pulumi.Input[str]]:
        """
        Settings for advanced scenarios.
        """
        return pulumi.get(self, "advanced_settings")

    @advanced_settings.setter
    def advanced_settings(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "advanced_settings", value)

    @property
    @pulumi.getter(name="amsGradient")
    def ams_gradient(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable AMSGrad when optimizer is 'adam' or 'adamw'.
        """
        return pulumi.get(self, "ams_gradient")

    @ams_gradient.setter
    def ams_gradient(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ams_gradient", value)

    @property
    @pulumi.getter
    def augmentations(self) -> Optional[pulumi.Input[str]]:
        """
        Settings for using Augmentations.
        """
        return pulumi.get(self, "augmentations")

    @augmentations.setter
    def augmentations(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "augmentations", value)

    @property
    @pulumi.getter
    def beta1(self) -> Optional[pulumi.Input[float]]:
        """
        Value of 'beta1' when optimizer is 'adam' or 'adamw'. Must be a float in the range [0, 1].
        """
        return pulumi.get(self, "beta1")

    @beta1.setter
    def beta1(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "beta1", value)

    @property
    @pulumi.getter
    def beta2(self) -> Optional[pulumi.Input[float]]:
        """
        Value of 'beta2' when optimizer is 'adam' or 'adamw'. Must be a float in the range [0, 1].
        """
        return pulumi.get(self, "beta2")

    @beta2.setter
    def beta2(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "beta2", value)

    @property
    @pulumi.getter(name="checkpointFrequency")
    def checkpoint_frequency(self) -> Optional[pulumi.Input[int]]:
        """
        Frequency to store model checkpoints. Must be a positive integer.
        """
        return pulumi.get(self, "checkpoint_frequency")

    @checkpoint_frequency.setter
    def checkpoint_frequency(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "checkpoint_frequency", value)

    @property
    @pulumi.getter(name="checkpointModel")
    def checkpoint_model(self) -> Optional[pulumi.Input['MLFlowModelJobInputArgs']]:
        """
        The pretrained checkpoint model for incremental training.
        """
        return pulumi.get(self, "checkpoint_model")

    @checkpoint_model.setter
    def checkpoint_model(self, value: Optional[pulumi.Input['MLFlowModelJobInputArgs']]):
        pulumi.set(self, "checkpoint_model", value)

    @property
    @pulumi.getter(name="checkpointRunId")
    def checkpoint_run_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of a previous run that has a pretrained checkpoint for incremental training.
        """
        return pulumi.get(self, "checkpoint_run_id")

    @checkpoint_run_id.setter
    def checkpoint_run_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "checkpoint_run_id", value)

    @property
    @pulumi.getter
    def distributed(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to use distributed training.
        """
        return pulumi.get(self, "distributed")

    @distributed.setter
    def distributed(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "distributed", value)

    @property
    @pulumi.getter(name="earlyStopping")
    def early_stopping(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable early stopping logic during training.
        """
        return pulumi.get(self, "early_stopping")

    @early_stopping.setter
    def early_stopping(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "early_stopping", value)

    @property
    @pulumi.getter(name="earlyStoppingDelay")
    def early_stopping_delay(self) -> Optional[pulumi.Input[int]]:
        """
        Minimum number of epochs or validation evaluations to wait before primary metric improvement
        is tracked for early stopping. Must be a positive integer.
        """
        return pulumi.get(self, "early_stopping_delay")

    @early_stopping_delay.setter
    def early_stopping_delay(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "early_stopping_delay", value)

    @property
    @pulumi.getter(name="earlyStoppingPatience")
    def early_stopping_patience(self) -> Optional[pulumi.Input[int]]:
        """
        Minimum number of epochs or validation evaluations with no primary metric improvement before
        the run is stopped. Must be a positive integer.
        """
        return pulumi.get(self, "early_stopping_patience")

    @early_stopping_patience.setter
    def early_stopping_patience(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "early_stopping_patience", value)

    @property
    @pulumi.getter(name="enableOnnxNormalization")
    def enable_onnx_normalization(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable normalization when exporting ONNX model.
        """
        return pulumi.get(self, "enable_onnx_normalization")

    @enable_onnx_normalization.setter
    def enable_onnx_normalization(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_onnx_normalization", value)

    @property
    @pulumi.getter(name="evaluationFrequency")
    def evaluation_frequency(self) -> Optional[pulumi.Input[int]]:
        """
        Frequency to evaluate validation dataset to get metric scores. Must be a positive integer.
        """
        return pulumi.get(self, "evaluation_frequency")

    @evaluation_frequency.setter
    def evaluation_frequency(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "evaluation_frequency", value)

    @property
    @pulumi.getter(name="gradientAccumulationStep")
    def gradient_accumulation_step(self) -> Optional[pulumi.Input[int]]:
        """
        Gradient accumulation means running a configured number of "GradAccumulationStep" steps without
        updating the model weights while accumulating the gradients of those steps, and then using
        the accumulated gradients to compute the weight updates. Must be a positive integer.
        """
        return pulumi.get(self, "gradient_accumulation_step")

    @gradient_accumulation_step.setter
    def gradient_accumulation_step(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "gradient_accumulation_step", value)

    @property
    @pulumi.getter(name="layersToFreeze")
    def layers_to_freeze(self) -> Optional[pulumi.Input[int]]:
        """
        Number of layers to freeze for the model. Must be a positive integer.
        For instance, passing 2 as value for 'seresnext' means
        freezing layer0 and layer1. For a full list of models supported and details on layer freeze, please
        see: https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
        """
        return pulumi.get(self, "layers_to_freeze")

    @layers_to_freeze.setter
    def layers_to_freeze(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "layers_to_freeze", value)

    @property
    @pulumi.getter(name="learningRate")
    def learning_rate(self) -> Optional[pulumi.Input[float]]:
        """
        Initial learning rate. Must be a float in the range [0, 1].
        """
        return pulumi.get(self, "learning_rate")

    @learning_rate.setter
    def learning_rate(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "learning_rate", value)

    @property
    @pulumi.getter(name="learningRateScheduler")
    def learning_rate_scheduler(self) -> Optional[pulumi.Input[Union[str, 'LearningRateScheduler']]]:
        """
        Type of learning rate scheduler. Must be 'warmup_cosine' or 'step'.
        """
        return pulumi.get(self, "learning_rate_scheduler")

    @learning_rate_scheduler.setter
    def learning_rate_scheduler(self, value: Optional[pulumi.Input[Union[str, 'LearningRateScheduler']]]):
        pulumi.set(self, "learning_rate_scheduler", value)

    @property
    @pulumi.getter(name="modelName")
    def model_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the model to use for training.
        For more information on the available models please visit the official documentation:
        https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
        """
        return pulumi.get(self, "model_name")

    @model_name.setter
    def model_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "model_name", value)

    @property
    @pulumi.getter
    def momentum(self) -> Optional[pulumi.Input[float]]:
        """
        Value of momentum when optimizer is 'sgd'. Must be a float in the range [0, 1].
        """
        return pulumi.get(self, "momentum")

    @momentum.setter
    def momentum(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "momentum", value)

    @property
    @pulumi.getter
    def nesterov(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable nesterov when optimizer is 'sgd'.
        """
        return pulumi.get(self, "nesterov")

    @nesterov.setter
    def nesterov(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "nesterov", value)

    @property
    @pulumi.getter(name="numberOfEpochs")
    def number_of_epochs(self) -> Optional[pulumi.Input[int]]:
        """
        Number of training epochs. Must be a positive integer.
        """
        return pulumi.get(self, "number_of_epochs")

    @number_of_epochs.setter
    def number_of_epochs(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "number_of_epochs", value)

    @property
    @pulumi.getter(name="numberOfWorkers")
    def number_of_workers(self) -> Optional[pulumi.Input[int]]:
        """
        Number of data loader workers. Must be a non-negative integer.
        """
        return pulumi.get(self, "number_of_workers")

    @number_of_workers.setter
    def number_of_workers(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "number_of_workers", value)

    @property
    @pulumi.getter
    def optimizer(self) -> Optional[pulumi.Input[Union[str, 'StochasticOptimizer']]]:
        """
        Type of optimizer.
        """
        return pulumi.get(self, "optimizer")

    @optimizer.setter
    def optimizer(self, value: Optional[pulumi.Input[Union[str, 'StochasticOptimizer']]]):
        pulumi.set(self, "optimizer", value)

    @property
    @pulumi.getter(name="randomSeed")
    def random_seed(self) -> Optional[pulumi.Input[int]]:
        """
        Random seed to be used when using deterministic training.
        """
        return pulumi.get(self, "random_seed")

    @random_seed.setter
    def random_seed(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "random_seed", value)

    @property
    @pulumi.getter(name="stepLRGamma")
    def step_lr_gamma(self) -> Optional[pulumi.Input[float]]:
        """
        Value of gamma when learning rate scheduler is 'step'. Must be a float in the range [0, 1].
        """
        return pulumi.get(self, "step_lr_gamma")

    @step_lr_gamma.setter
    def step_lr_gamma(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "step_lr_gamma", value)

    @property
    @pulumi.getter(name="stepLRStepSize")
    def step_lr_step_size(self) -> Optional[pulumi.Input[int]]:
        """
        Value of step size when learning rate scheduler is 'step'. Must be a positive integer.
        """
        return pulumi.get(self, "step_lr_step_size")

    @step_lr_step_size.setter
    def step_lr_step_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "step_lr_step_size", value)

    @property
    @pulumi.getter(name="trainingBatchSize")
    def training_batch_size(self) -> Optional[pulumi.Input[int]]:
        """
        Training batch size. Must be a positive integer.
        """
        return pulumi.get(self, "training_batch_size")

    @training_batch_size.setter
    def training_batch_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "training_batch_size", value)

    @property
    @pulumi.getter(name="trainingCropSize")
    def training_crop_size(self) -> Optional[pulumi.Input[int]]:
        """
        Image crop size that is input to the neural network for the training dataset. Must be a positive integer.
        """
        return pulumi.get(self, "training_crop_size")

    @training_crop_size.setter
    def training_crop_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "training_crop_size", value)

    @property
    @pulumi.getter(name="validationBatchSize")
    def validation_batch_size(self) -> Optional[pulumi.Input[int]]:
        """
        Validation batch size. Must be a positive integer.
        """
        return pulumi.get(self, "validation_batch_size")

    @validation_batch_size.setter
    def validation_batch_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "validation_batch_size", value)

    @property
    @pulumi.getter(name="validationCropSize")
    def validation_crop_size(self) -> Optional[pulumi.Input[int]]:
        """
        Image crop size that is input to the neural network for the validation dataset. Must be a positive integer.
        """
        return pulumi.get(self, "validation_crop_size")

    @validation_crop_size.setter
    def validation_crop_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "validation_crop_size", value)

    @property
    @pulumi.getter(name="validationResizeSize")
    def validation_resize_size(self) -> Optional[pulumi.Input[int]]:
        """
        Image size to which to resize before cropping for validation dataset. Must be a positive integer.
        """
        return pulumi.get(self, "validation_resize_size")

    @validation_resize_size.setter
    def validation_resize_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "validation_resize_size", value)

    @property
    @pulumi.getter(name="warmupCosineLRCycles")
    def warmup_cosine_lr_cycles(self) -> Optional[pulumi.Input[float]]:
        """
        Value of cosine cycle when learning rate scheduler is 'warmup_cosine'. Must be a float in the range [0, 1].
        """
        return pulumi.get(self, "warmup_cosine_lr_cycles")

    @warmup_cosine_lr_cycles.setter
    def warmup_cosine_lr_cycles(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "warmup_cosine_lr_cycles", value)

    @property
    @pulumi.getter(name="warmupCosineLRWarmupEpochs")
    def warmup_cosine_lr_warmup_epochs(self) -> Optional[pulumi.Input[int]]:
        """
        Value of warmup epochs when learning rate scheduler is 'warmup_cosine'. Must be a positive integer.
        """
        return pulumi.get(self, "warmup_cosine_lr_warmup_epochs")

    @warmup_cosine_lr_warmup_epochs.setter
    def warmup_cosine_lr_warmup_epochs(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "warmup_cosine_lr_warmup_epochs", value)

    @property
    @pulumi.getter(name="weightDecay")
    def weight_decay(self) -> Optional[pulumi.Input[float]]:
        """
        Value of weight decay when optimizer is 'sgd', 'adam', or 'adamw'. Must be a float in the range[0, 1].
        """
        return pulumi.get(self, "weight_decay")

    @weight_decay.setter
    def weight_decay(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "weight_decay", value)

    @property
    @pulumi.getter(name="weightedLoss")
    def weighted_loss(self) -> Optional[pulumi.Input[int]]:
        """
        Weighted loss. The accepted values are 0 for no weighted loss.
        1 for weighted loss with sqrt.(class_weights). 2 for weighted loss with class_weights. Must be 0 or 1 or 2.
        """
        return pulumi.get(self, "weighted_loss")

    @weighted_loss.setter
    def weighted_loss(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "weighted_loss", value)


@pulumi.input_type
class ImageModelSettingsObjectDetectionArgs:
    def __init__(__self__, *,
                 advanced_settings: Optional[pulumi.Input[str]] = None,
                 ams_gradient: Optional[pulumi.Input[bool]] = None,
                 augmentations: Optional[pulumi.Input[str]] = None,
                 beta1: Optional[pulumi.Input[float]] = None,
                 beta2: Optional[pulumi.Input[float]] = None,
                 box_detections_per_image: Optional[pulumi.Input[int]] = None,
                 box_score_threshold: Optional[pulumi.Input[float]] = None,
                 checkpoint_frequency: Optional[pulumi.Input[int]] = None,
                 checkpoint_model: Optional[pulumi.Input['MLFlowModelJobInputArgs']] = None,
                 checkpoint_run_id: Optional[pulumi.Input[str]] = None,
                 distributed: Optional[pulumi.Input[bool]] = None,
                 early_stopping: Optional[pulumi.Input[bool]] = None,
                 early_stopping_delay: Optional[pulumi.Input[int]] = None,
                 early_stopping_patience: Optional[pulumi.Input[int]] = None,
                 enable_onnx_normalization: Optional[pulumi.Input[bool]] = None,
                 evaluation_frequency: Optional[pulumi.Input[int]] = None,
                 gradient_accumulation_step: Optional[pulumi.Input[int]] = None,
                 image_size: Optional[pulumi.Input[int]] = None,
                 layers_to_freeze: Optional[pulumi.Input[int]] = None,
                 learning_rate: Optional[pulumi.Input[float]] = None,
                 learning_rate_scheduler: Optional[pulumi.Input[Union[str, 'LearningRateScheduler']]] = None,
                 max_size: Optional[pulumi.Input[int]] = None,
                 min_size: Optional[pulumi.Input[int]] = None,
                 model_name: Optional[pulumi.Input[str]] = None,
                 model_size: Optional[pulumi.Input[Union[str, 'ModelSize']]] = None,
                 momentum: Optional[pulumi.Input[float]] = None,
                 multi_scale: Optional[pulumi.Input[bool]] = None,
                 nesterov: Optional[pulumi.Input[bool]] = None,
                 nms_iou_threshold: Optional[pulumi.Input[float]] = None,
                 number_of_epochs: Optional[pulumi.Input[int]] = None,
                 number_of_workers: Optional[pulumi.Input[int]] = None,
                 optimizer: Optional[pulumi.Input[Union[str, 'StochasticOptimizer']]] = None,
                 random_seed: Optional[pulumi.Input[int]] = None,
                 step_lr_gamma: Optional[pulumi.Input[float]] = None,
                 step_lr_step_size: Optional[pulumi.Input[int]] = None,
                 tile_grid_size: Optional[pulumi.Input[str]] = None,
                 tile_overlap_ratio: Optional[pulumi.Input[float]] = None,
                 tile_predictions_nms_threshold: Optional[pulumi.Input[float]] = None,
                 training_batch_size: Optional[pulumi.Input[int]] = None,
                 validation_batch_size: Optional[pulumi.Input[int]] = None,
                 validation_iou_threshold: Optional[pulumi.Input[float]] = None,
                 validation_metric_type: Optional[pulumi.Input[Union[str, 'ValidationMetricType']]] = None,
                 warmup_cosine_lr_cycles: Optional[pulumi.Input[float]] = None,
                 warmup_cosine_lr_warmup_epochs: Optional[pulumi.Input[int]] = None,
                 weight_decay: Optional[pulumi.Input[float]] = None):
        """
        Settings used for training the model.
        For more information on the available settings please visit the official documentation:
        https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
        :param pulumi.Input[str] advanced_settings: Settings for advanced scenarios.
        :param pulumi.Input[bool] ams_gradient: Enable AMSGrad when optimizer is 'adam' or 'adamw'.
        :param pulumi.Input[str] augmentations: Settings for using Augmentations.
        :param pulumi.Input[float] beta1: Value of 'beta1' when optimizer is 'adam' or 'adamw'. Must be a float in the range [0, 1].
        :param pulumi.Input[float] beta2: Value of 'beta2' when optimizer is 'adam' or 'adamw'. Must be a float in the range [0, 1].
        :param pulumi.Input[int] box_detections_per_image: Maximum number of detections per image, for all classes. Must be a positive integer.
               Note: This settings is not supported for the 'yolov5' algorithm.
        :param pulumi.Input[float] box_score_threshold: During inference, only return proposals with a classification score greater than
               BoxScoreThreshold. Must be a float in the range[0, 1].
        :param pulumi.Input[int] checkpoint_frequency: Frequency to store model checkpoints. Must be a positive integer.
        :param pulumi.Input['MLFlowModelJobInputArgs'] checkpoint_model: The pretrained checkpoint model for incremental training.
        :param pulumi.Input[str] checkpoint_run_id: The id of a previous run that has a pretrained checkpoint for incremental training.
        :param pulumi.Input[bool] distributed: Whether to use distributed training.
        :param pulumi.Input[bool] early_stopping: Enable early stopping logic during training.
        :param pulumi.Input[int] early_stopping_delay: Minimum number of epochs or validation evaluations to wait before primary metric improvement
               is tracked for early stopping. Must be a positive integer.
        :param pulumi.Input[int] early_stopping_patience: Minimum number of epochs or validation evaluations with no primary metric improvement before
               the run is stopped. Must be a positive integer.
        :param pulumi.Input[bool] enable_onnx_normalization: Enable normalization when exporting ONNX model.
        :param pulumi.Input[int] evaluation_frequency: Frequency to evaluate validation dataset to get metric scores. Must be a positive integer.
        :param pulumi.Input[int] gradient_accumulation_step: Gradient accumulation means running a configured number of "GradAccumulationStep" steps without
               updating the model weights while accumulating the gradients of those steps, and then using
               the accumulated gradients to compute the weight updates. Must be a positive integer.
        :param pulumi.Input[int] image_size: Image size for train and validation. Must be a positive integer.
               Note: The training run may get into CUDA OOM if the size is too big.
               Note: This settings is only supported for the 'yolov5' algorithm.
        :param pulumi.Input[int] layers_to_freeze: Number of layers to freeze for the model. Must be a positive integer.
               For instance, passing 2 as value for 'seresnext' means
               freezing layer0 and layer1. For a full list of models supported and details on layer freeze, please
               see: https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
        :param pulumi.Input[float] learning_rate: Initial learning rate. Must be a float in the range [0, 1].
        :param pulumi.Input[Union[str, 'LearningRateScheduler']] learning_rate_scheduler: Type of learning rate scheduler. Must be 'warmup_cosine' or 'step'.
        :param pulumi.Input[int] max_size: Maximum size of the image to be rescaled before feeding it to the backbone.
               Must be a positive integer. Note: training run may get into CUDA OOM if the size is too big.
               Note: This settings is not supported for the 'yolov5' algorithm.
        :param pulumi.Input[int] min_size: Minimum size of the image to be rescaled before feeding it to the backbone.
               Must be a positive integer. Note: training run may get into CUDA OOM if the size is too big.
               Note: This settings is not supported for the 'yolov5' algorithm.
        :param pulumi.Input[str] model_name: Name of the model to use for training.
               For more information on the available models please visit the official documentation:
               https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
        :param pulumi.Input[Union[str, 'ModelSize']] model_size: Model size. Must be 'small', 'medium', 'large', or 'xlarge'.
               Note: training run may get into CUDA OOM if the model size is too big.
               Note: This settings is only supported for the 'yolov5' algorithm.
        :param pulumi.Input[float] momentum: Value of momentum when optimizer is 'sgd'. Must be a float in the range [0, 1].
        :param pulumi.Input[bool] multi_scale: Enable multi-scale image by varying image size by +/- 50%.
               Note: training run may get into CUDA OOM if no sufficient GPU memory.
               Note: This settings is only supported for the 'yolov5' algorithm.
        :param pulumi.Input[bool] nesterov: Enable nesterov when optimizer is 'sgd'.
        :param pulumi.Input[float] nms_iou_threshold: IOU threshold used during inference in NMS post processing. Must be a float in the range [0, 1].
        :param pulumi.Input[int] number_of_epochs: Number of training epochs. Must be a positive integer.
        :param pulumi.Input[int] number_of_workers: Number of data loader workers. Must be a non-negative integer.
        :param pulumi.Input[Union[str, 'StochasticOptimizer']] optimizer: Type of optimizer.
        :param pulumi.Input[int] random_seed: Random seed to be used when using deterministic training.
        :param pulumi.Input[float] step_lr_gamma: Value of gamma when learning rate scheduler is 'step'. Must be a float in the range [0, 1].
        :param pulumi.Input[int] step_lr_step_size: Value of step size when learning rate scheduler is 'step'. Must be a positive integer.
        :param pulumi.Input[str] tile_grid_size: The grid size to use for tiling each image. Note: TileGridSize must not be
               None to enable small object detection logic. A string containing two integers in mxn format.
               Note: This settings is not supported for the 'yolov5' algorithm.
        :param pulumi.Input[float] tile_overlap_ratio: Overlap ratio between adjacent tiles in each dimension. Must be float in the range [0, 1).
               Note: This settings is not supported for the 'yolov5' algorithm.
        :param pulumi.Input[float] tile_predictions_nms_threshold: The IOU threshold to use to perform NMS while merging predictions from tiles and image.
               Used in validation/ inference. Must be float in the range [0, 1].
               Note: This settings is not supported for the 'yolov5' algorithm.
        :param pulumi.Input[int] training_batch_size: Training batch size. Must be a positive integer.
        :param pulumi.Input[int] validation_batch_size: Validation batch size. Must be a positive integer.
        :param pulumi.Input[float] validation_iou_threshold: IOU threshold to use when computing validation metric. Must be float in the range [0, 1].
        :param pulumi.Input[Union[str, 'ValidationMetricType']] validation_metric_type: Metric computation method to use for validation metrics.
        :param pulumi.Input[float] warmup_cosine_lr_cycles: Value of cosine cycle when learning rate scheduler is 'warmup_cosine'. Must be a float in the range [0, 1].
        :param pulumi.Input[int] warmup_cosine_lr_warmup_epochs: Value of warmup epochs when learning rate scheduler is 'warmup_cosine'. Must be a positive integer.
        :param pulumi.Input[float] weight_decay: Value of weight decay when optimizer is 'sgd', 'adam', or 'adamw'. Must be a float in the range[0, 1].
        """
        if advanced_settings is not None:
            pulumi.set(__self__, "advanced_settings", advanced_settings)
        if ams_gradient is not None:
            pulumi.set(__self__, "ams_gradient", ams_gradient)
        if augmentations is not None:
            pulumi.set(__self__, "augmentations", augmentations)
        if beta1 is not None:
            pulumi.set(__self__, "beta1", beta1)
        if beta2 is not None:
            pulumi.set(__self__, "beta2", beta2)
        if box_detections_per_image is not None:
            pulumi.set(__self__, "box_detections_per_image", box_detections_per_image)
        if box_score_threshold is not None:
            pulumi.set(__self__, "box_score_threshold", box_score_threshold)
        if checkpoint_frequency is not None:
            pulumi.set(__self__, "checkpoint_frequency", checkpoint_frequency)
        if checkpoint_model is not None:
            pulumi.set(__self__, "checkpoint_model", checkpoint_model)
        if checkpoint_run_id is not None:
            pulumi.set(__self__, "checkpoint_run_id", checkpoint_run_id)
        if distributed is not None:
            pulumi.set(__self__, "distributed", distributed)
        if early_stopping is not None:
            pulumi.set(__self__, "early_stopping", early_stopping)
        if early_stopping_delay is not None:
            pulumi.set(__self__, "early_stopping_delay", early_stopping_delay)
        if early_stopping_patience is not None:
            pulumi.set(__self__, "early_stopping_patience", early_stopping_patience)
        if enable_onnx_normalization is not None:
            pulumi.set(__self__, "enable_onnx_normalization", enable_onnx_normalization)
        if evaluation_frequency is not None:
            pulumi.set(__self__, "evaluation_frequency", evaluation_frequency)
        if gradient_accumulation_step is not None:
            pulumi.set(__self__, "gradient_accumulation_step", gradient_accumulation_step)
        if image_size is not None:
            pulumi.set(__self__, "image_size", image_size)
        if layers_to_freeze is not None:
            pulumi.set(__self__, "layers_to_freeze", layers_to_freeze)
        if learning_rate is not None:
            pulumi.set(__self__, "learning_rate", learning_rate)
        if learning_rate_scheduler is None:
            learning_rate_scheduler = 'None'
        if learning_rate_scheduler is not None:
            pulumi.set(__self__, "learning_rate_scheduler", learning_rate_scheduler)
        if max_size is not None:
            pulumi.set(__self__, "max_size", max_size)
        if min_size is not None:
            pulumi.set(__self__, "min_size", min_size)
        if model_name is not None:
            pulumi.set(__self__, "model_name", model_name)
        if model_size is None:
            model_size = 'None'
        if model_size is not None:
            pulumi.set(__self__, "model_size", model_size)
        if momentum is not None:
            pulumi.set(__self__, "momentum", momentum)
        if multi_scale is not None:
            pulumi.set(__self__, "multi_scale", multi_scale)
        if nesterov is not None:
            pulumi.set(__self__, "nesterov", nesterov)
        if nms_iou_threshold is not None:
            pulumi.set(__self__, "nms_iou_threshold", nms_iou_threshold)
        if number_of_epochs is not None:
            pulumi.set(__self__, "number_of_epochs", number_of_epochs)
        if number_of_workers is not None:
            pulumi.set(__self__, "number_of_workers", number_of_workers)
        if optimizer is None:
            optimizer = 'None'
        if optimizer is not None:
            pulumi.set(__self__, "optimizer", optimizer)
        if random_seed is not None:
            pulumi.set(__self__, "random_seed", random_seed)
        if step_lr_gamma is not None:
            pulumi.set(__self__, "step_lr_gamma", step_lr_gamma)
        if step_lr_step_size is not None:
            pulumi.set(__self__, "step_lr_step_size", step_lr_step_size)
        if tile_grid_size is not None:
            pulumi.set(__self__, "tile_grid_size", tile_grid_size)
        if tile_overlap_ratio is not None:
            pulumi.set(__self__, "tile_overlap_ratio", tile_overlap_ratio)
        if tile_predictions_nms_threshold is not None:
            pulumi.set(__self__, "tile_predictions_nms_threshold", tile_predictions_nms_threshold)
        if training_batch_size is not None:
            pulumi.set(__self__, "training_batch_size", training_batch_size)
        if validation_batch_size is not None:
            pulumi.set(__self__, "validation_batch_size", validation_batch_size)
        if validation_iou_threshold is not None:
            pulumi.set(__self__, "validation_iou_threshold", validation_iou_threshold)
        if validation_metric_type is None:
            validation_metric_type = 'None'
        if validation_metric_type is not None:
            pulumi.set(__self__, "validation_metric_type", validation_metric_type)
        if warmup_cosine_lr_cycles is not None:
            pulumi.set(__self__, "warmup_cosine_lr_cycles", warmup_cosine_lr_cycles)
        if warmup_cosine_lr_warmup_epochs is not None:
            pulumi.set(__self__, "warmup_cosine_lr_warmup_epochs", warmup_cosine_lr_warmup_epochs)
        if weight_decay is not None:
            pulumi.set(__self__, "weight_decay", weight_decay)

    @property
    @pulumi.getter(name="advancedSettings")
    def advanced_settings(self) -> Optional[pulumi.Input[str]]:
        """
        Settings for advanced scenarios.
        """
        return pulumi.get(self, "advanced_settings")

    @advanced_settings.setter
    def advanced_settings(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "advanced_settings", value)

    @property
    @pulumi.getter(name="amsGradient")
    def ams_gradient(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable AMSGrad when optimizer is 'adam' or 'adamw'.
        """
        return pulumi.get(self, "ams_gradient")

    @ams_gradient.setter
    def ams_gradient(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ams_gradient", value)

    @property
    @pulumi.getter
    def augmentations(self) -> Optional[pulumi.Input[str]]:
        """
        Settings for using Augmentations.
        """
        return pulumi.get(self, "augmentations")

    @augmentations.setter
    def augmentations(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "augmentations", value)

    @property
    @pulumi.getter
    def beta1(self) -> Optional[pulumi.Input[float]]:
        """
        Value of 'beta1' when optimizer is 'adam' or 'adamw'. Must be a float in the range [0, 1].
        """
        return pulumi.get(self, "beta1")

    @beta1.setter
    def beta1(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "beta1", value)

    @property
    @pulumi.getter
    def beta2(self) -> Optional[pulumi.Input[float]]:
        """
        Value of 'beta2' when optimizer is 'adam' or 'adamw'. Must be a float in the range [0, 1].
        """
        return pulumi.get(self, "beta2")

    @beta2.setter
    def beta2(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "beta2", value)

    @property
    @pulumi.getter(name="boxDetectionsPerImage")
    def box_detections_per_image(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum number of detections per image, for all classes. Must be a positive integer.
        Note: This settings is not supported for the 'yolov5' algorithm.
        """
        return pulumi.get(self, "box_detections_per_image")

    @box_detections_per_image.setter
    def box_detections_per_image(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "box_detections_per_image", value)

    @property
    @pulumi.getter(name="boxScoreThreshold")
    def box_score_threshold(self) -> Optional[pulumi.Input[float]]:
        """
        During inference, only return proposals with a classification score greater than
        BoxScoreThreshold. Must be a float in the range[0, 1].
        """
        return pulumi.get(self, "box_score_threshold")

    @box_score_threshold.setter
    def box_score_threshold(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "box_score_threshold", value)

    @property
    @pulumi.getter(name="checkpointFrequency")
    def checkpoint_frequency(self) -> Optional[pulumi.Input[int]]:
        """
        Frequency to store model checkpoints. Must be a positive integer.
        """
        return pulumi.get(self, "checkpoint_frequency")

    @checkpoint_frequency.setter
    def checkpoint_frequency(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "checkpoint_frequency", value)

    @property
    @pulumi.getter(name="checkpointModel")
    def checkpoint_model(self) -> Optional[pulumi.Input['MLFlowModelJobInputArgs']]:
        """
        The pretrained checkpoint model for incremental training.
        """
        return pulumi.get(self, "checkpoint_model")

    @checkpoint_model.setter
    def checkpoint_model(self, value: Optional[pulumi.Input['MLFlowModelJobInputArgs']]):
        pulumi.set(self, "checkpoint_model", value)

    @property
    @pulumi.getter(name="checkpointRunId")
    def checkpoint_run_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of a previous run that has a pretrained checkpoint for incremental training.
        """
        return pulumi.get(self, "checkpoint_run_id")

    @checkpoint_run_id.setter
    def checkpoint_run_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "checkpoint_run_id", value)

    @property
    @pulumi.getter
    def distributed(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to use distributed training.
        """
        return pulumi.get(self, "distributed")

    @distributed.setter
    def distributed(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "distributed", value)

    @property
    @pulumi.getter(name="earlyStopping")
    def early_stopping(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable early stopping logic during training.
        """
        return pulumi.get(self, "early_stopping")

    @early_stopping.setter
    def early_stopping(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "early_stopping", value)

    @property
    @pulumi.getter(name="earlyStoppingDelay")
    def early_stopping_delay(self) -> Optional[pulumi.Input[int]]:
        """
        Minimum number of epochs or validation evaluations to wait before primary metric improvement
        is tracked for early stopping. Must be a positive integer.
        """
        return pulumi.get(self, "early_stopping_delay")

    @early_stopping_delay.setter
    def early_stopping_delay(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "early_stopping_delay", value)

    @property
    @pulumi.getter(name="earlyStoppingPatience")
    def early_stopping_patience(self) -> Optional[pulumi.Input[int]]:
        """
        Minimum number of epochs or validation evaluations with no primary metric improvement before
        the run is stopped. Must be a positive integer.
        """
        return pulumi.get(self, "early_stopping_patience")

    @early_stopping_patience.setter
    def early_stopping_patience(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "early_stopping_patience", value)

    @property
    @pulumi.getter(name="enableOnnxNormalization")
    def enable_onnx_normalization(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable normalization when exporting ONNX model.
        """
        return pulumi.get(self, "enable_onnx_normalization")

    @enable_onnx_normalization.setter
    def enable_onnx_normalization(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_onnx_normalization", value)

    @property
    @pulumi.getter(name="evaluationFrequency")
    def evaluation_frequency(self) -> Optional[pulumi.Input[int]]:
        """
        Frequency to evaluate validation dataset to get metric scores. Must be a positive integer.
        """
        return pulumi.get(self, "evaluation_frequency")

    @evaluation_frequency.setter
    def evaluation_frequency(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "evaluation_frequency", value)

    @property
    @pulumi.getter(name="gradientAccumulationStep")
    def gradient_accumulation_step(self) -> Optional[pulumi.Input[int]]:
        """
        Gradient accumulation means running a configured number of "GradAccumulationStep" steps without
        updating the model weights while accumulating the gradients of those steps, and then using
        the accumulated gradients to compute the weight updates. Must be a positive integer.
        """
        return pulumi.get(self, "gradient_accumulation_step")

    @gradient_accumulation_step.setter
    def gradient_accumulation_step(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "gradient_accumulation_step", value)

    @property
    @pulumi.getter(name="imageSize")
    def image_size(self) -> Optional[pulumi.Input[int]]:
        """
        Image size for train and validation. Must be a positive integer.
        Note: The training run may get into CUDA OOM if the size is too big.
        Note: This settings is only supported for the 'yolov5' algorithm.
        """
        return pulumi.get(self, "image_size")

    @image_size.setter
    def image_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "image_size", value)

    @property
    @pulumi.getter(name="layersToFreeze")
    def layers_to_freeze(self) -> Optional[pulumi.Input[int]]:
        """
        Number of layers to freeze for the model. Must be a positive integer.
        For instance, passing 2 as value for 'seresnext' means
        freezing layer0 and layer1. For a full list of models supported and details on layer freeze, please
        see: https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
        """
        return pulumi.get(self, "layers_to_freeze")

    @layers_to_freeze.setter
    def layers_to_freeze(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "layers_to_freeze", value)

    @property
    @pulumi.getter(name="learningRate")
    def learning_rate(self) -> Optional[pulumi.Input[float]]:
        """
        Initial learning rate. Must be a float in the range [0, 1].
        """
        return pulumi.get(self, "learning_rate")

    @learning_rate.setter
    def learning_rate(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "learning_rate", value)

    @property
    @pulumi.getter(name="learningRateScheduler")
    def learning_rate_scheduler(self) -> Optional[pulumi.Input[Union[str, 'LearningRateScheduler']]]:
        """
        Type of learning rate scheduler. Must be 'warmup_cosine' or 'step'.
        """
        return pulumi.get(self, "learning_rate_scheduler")

    @learning_rate_scheduler.setter
    def learning_rate_scheduler(self, value: Optional[pulumi.Input[Union[str, 'LearningRateScheduler']]]):
        pulumi.set(self, "learning_rate_scheduler", value)

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum size of the image to be rescaled before feeding it to the backbone.
        Must be a positive integer. Note: training run may get into CUDA OOM if the size is too big.
        Note: This settings is not supported for the 'yolov5' algorithm.
        """
        return pulumi.get(self, "max_size")

    @max_size.setter
    def max_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_size", value)

    @property
    @pulumi.getter(name="minSize")
    def min_size(self) -> Optional[pulumi.Input[int]]:
        """
        Minimum size of the image to be rescaled before feeding it to the backbone.
        Must be a positive integer. Note: training run may get into CUDA OOM if the size is too big.
        Note: This settings is not supported for the 'yolov5' algorithm.
        """
        return pulumi.get(self, "min_size")

    @min_size.setter
    def min_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_size", value)

    @property
    @pulumi.getter(name="modelName")
    def model_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the model to use for training.
        For more information on the available models please visit the official documentation:
        https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
        """
        return pulumi.get(self, "model_name")

    @model_name.setter
    def model_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "model_name", value)

    @property
    @pulumi.getter(name="modelSize")
    def model_size(self) -> Optional[pulumi.Input[Union[str, 'ModelSize']]]:
        """
        Model size. Must be 'small', 'medium', 'large', or 'xlarge'.
        Note: training run may get into CUDA OOM if the model size is too big.
        Note: This settings is only supported for the 'yolov5' algorithm.
        """
        return pulumi.get(self, "model_size")

    @model_size.setter
    def model_size(self, value: Optional[pulumi.Input[Union[str, 'ModelSize']]]):
        pulumi.set(self, "model_size", value)

    @property
    @pulumi.getter
    def momentum(self) -> Optional[pulumi.Input[float]]:
        """
        Value of momentum when optimizer is 'sgd'. Must be a float in the range [0, 1].
        """
        return pulumi.get(self, "momentum")

    @momentum.setter
    def momentum(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "momentum", value)

    @property
    @pulumi.getter(name="multiScale")
    def multi_scale(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable multi-scale image by varying image size by +/- 50%.
        Note: training run may get into CUDA OOM if no sufficient GPU memory.
        Note: This settings is only supported for the 'yolov5' algorithm.
        """
        return pulumi.get(self, "multi_scale")

    @multi_scale.setter
    def multi_scale(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "multi_scale", value)

    @property
    @pulumi.getter
    def nesterov(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable nesterov when optimizer is 'sgd'.
        """
        return pulumi.get(self, "nesterov")

    @nesterov.setter
    def nesterov(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "nesterov", value)

    @property
    @pulumi.getter(name="nmsIouThreshold")
    def nms_iou_threshold(self) -> Optional[pulumi.Input[float]]:
        """
        IOU threshold used during inference in NMS post processing. Must be a float in the range [0, 1].
        """
        return pulumi.get(self, "nms_iou_threshold")

    @nms_iou_threshold.setter
    def nms_iou_threshold(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "nms_iou_threshold", value)

    @property
    @pulumi.getter(name="numberOfEpochs")
    def number_of_epochs(self) -> Optional[pulumi.Input[int]]:
        """
        Number of training epochs. Must be a positive integer.
        """
        return pulumi.get(self, "number_of_epochs")

    @number_of_epochs.setter
    def number_of_epochs(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "number_of_epochs", value)

    @property
    @pulumi.getter(name="numberOfWorkers")
    def number_of_workers(self) -> Optional[pulumi.Input[int]]:
        """
        Number of data loader workers. Must be a non-negative integer.
        """
        return pulumi.get(self, "number_of_workers")

    @number_of_workers.setter
    def number_of_workers(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "number_of_workers", value)

    @property
    @pulumi.getter
    def optimizer(self) -> Optional[pulumi.Input[Union[str, 'StochasticOptimizer']]]:
        """
        Type of optimizer.
        """
        return pulumi.get(self, "optimizer")

    @optimizer.setter
    def optimizer(self, value: Optional[pulumi.Input[Union[str, 'StochasticOptimizer']]]):
        pulumi.set(self, "optimizer", value)

    @property
    @pulumi.getter(name="randomSeed")
    def random_seed(self) -> Optional[pulumi.Input[int]]:
        """
        Random seed to be used when using deterministic training.
        """
        return pulumi.get(self, "random_seed")

    @random_seed.setter
    def random_seed(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "random_seed", value)

    @property
    @pulumi.getter(name="stepLRGamma")
    def step_lr_gamma(self) -> Optional[pulumi.Input[float]]:
        """
        Value of gamma when learning rate scheduler is 'step'. Must be a float in the range [0, 1].
        """
        return pulumi.get(self, "step_lr_gamma")

    @step_lr_gamma.setter
    def step_lr_gamma(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "step_lr_gamma", value)

    @property
    @pulumi.getter(name="stepLRStepSize")
    def step_lr_step_size(self) -> Optional[pulumi.Input[int]]:
        """
        Value of step size when learning rate scheduler is 'step'. Must be a positive integer.
        """
        return pulumi.get(self, "step_lr_step_size")

    @step_lr_step_size.setter
    def step_lr_step_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "step_lr_step_size", value)

    @property
    @pulumi.getter(name="tileGridSize")
    def tile_grid_size(self) -> Optional[pulumi.Input[str]]:
        """
        The grid size to use for tiling each image. Note: TileGridSize must not be
        None to enable small object detection logic. A string containing two integers in mxn format.
        Note: This settings is not supported for the 'yolov5' algorithm.
        """
        return pulumi.get(self, "tile_grid_size")

    @tile_grid_size.setter
    def tile_grid_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tile_grid_size", value)

    @property
    @pulumi.getter(name="tileOverlapRatio")
    def tile_overlap_ratio(self) -> Optional[pulumi.Input[float]]:
        """
        Overlap ratio between adjacent tiles in each dimension. Must be float in the range [0, 1).
        Note: This settings is not supported for the 'yolov5' algorithm.
        """
        return pulumi.get(self, "tile_overlap_ratio")

    @tile_overlap_ratio.setter
    def tile_overlap_ratio(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "tile_overlap_ratio", value)

    @property
    @pulumi.getter(name="tilePredictionsNmsThreshold")
    def tile_predictions_nms_threshold(self) -> Optional[pulumi.Input[float]]:
        """
        The IOU threshold to use to perform NMS while merging predictions from tiles and image.
        Used in validation/ inference. Must be float in the range [0, 1].
        Note: This settings is not supported for the 'yolov5' algorithm.
        """
        return pulumi.get(self, "tile_predictions_nms_threshold")

    @tile_predictions_nms_threshold.setter
    def tile_predictions_nms_threshold(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "tile_predictions_nms_threshold", value)

    @property
    @pulumi.getter(name="trainingBatchSize")
    def training_batch_size(self) -> Optional[pulumi.Input[int]]:
        """
        Training batch size. Must be a positive integer.
        """
        return pulumi.get(self, "training_batch_size")

    @training_batch_size.setter
    def training_batch_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "training_batch_size", value)

    @property
    @pulumi.getter(name="validationBatchSize")
    def validation_batch_size(self) -> Optional[pulumi.Input[int]]:
        """
        Validation batch size. Must be a positive integer.
        """
        return pulumi.get(self, "validation_batch_size")

    @validation_batch_size.setter
    def validation_batch_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "validation_batch_size", value)

    @property
    @pulumi.getter(name="validationIouThreshold")
    def validation_iou_threshold(self) -> Optional[pulumi.Input[float]]:
        """
        IOU threshold to use when computing validation metric. Must be float in the range [0, 1].
        """
        return pulumi.get(self, "validation_iou_threshold")

    @validation_iou_threshold.setter
    def validation_iou_threshold(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "validation_iou_threshold", value)

    @property
    @pulumi.getter(name="validationMetricType")
    def validation_metric_type(self) -> Optional[pulumi.Input[Union[str, 'ValidationMetricType']]]:
        """
        Metric computation method to use for validation metrics.
        """
        return pulumi.get(self, "validation_metric_type")

    @validation_metric_type.setter
    def validation_metric_type(self, value: Optional[pulumi.Input[Union[str, 'ValidationMetricType']]]):
        pulumi.set(self, "validation_metric_type", value)

    @property
    @pulumi.getter(name="warmupCosineLRCycles")
    def warmup_cosine_lr_cycles(self) -> Optional[pulumi.Input[float]]:
        """
        Value of cosine cycle when learning rate scheduler is 'warmup_cosine'. Must be a float in the range [0, 1].
        """
        return pulumi.get(self, "warmup_cosine_lr_cycles")

    @warmup_cosine_lr_cycles.setter
    def warmup_cosine_lr_cycles(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "warmup_cosine_lr_cycles", value)

    @property
    @pulumi.getter(name="warmupCosineLRWarmupEpochs")
    def warmup_cosine_lr_warmup_epochs(self) -> Optional[pulumi.Input[int]]:
        """
        Value of warmup epochs when learning rate scheduler is 'warmup_cosine'. Must be a positive integer.
        """
        return pulumi.get(self, "warmup_cosine_lr_warmup_epochs")

    @warmup_cosine_lr_warmup_epochs.setter
    def warmup_cosine_lr_warmup_epochs(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "warmup_cosine_lr_warmup_epochs", value)

    @property
    @pulumi.getter(name="weightDecay")
    def weight_decay(self) -> Optional[pulumi.Input[float]]:
        """
        Value of weight decay when optimizer is 'sgd', 'adam', or 'adamw'. Must be a float in the range[0, 1].
        """
        return pulumi.get(self, "weight_decay")

    @weight_decay.setter
    def weight_decay(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "weight_decay", value)


@pulumi.input_type
class ImageObjectDetectionArgs:
    def __init__(__self__, *,
                 limit_settings: pulumi.Input['ImageLimitSettingsArgs'],
                 task_type: pulumi.Input[str],
                 training_data: pulumi.Input['MLTableJobInputArgs'],
                 log_verbosity: Optional[pulumi.Input[Union[str, 'LogVerbosity']]] = None,
                 model_settings: Optional[pulumi.Input['ImageModelSettingsObjectDetectionArgs']] = None,
                 primary_metric: Optional[pulumi.Input[Union[str, 'ObjectDetectionPrimaryMetrics']]] = None,
                 search_space: Optional[pulumi.Input[Sequence[pulumi.Input['ImageModelDistributionSettingsObjectDetectionArgs']]]] = None,
                 sweep_settings: Optional[pulumi.Input['ImageSweepSettingsArgs']] = None,
                 target_column_name: Optional[pulumi.Input[str]] = None,
                 validation_data: Optional[pulumi.Input['MLTableJobInputArgs']] = None,
                 validation_data_size: Optional[pulumi.Input[float]] = None):
        """
        Image Object Detection. Object detection is used to identify objects in an image and locate each object with a
        bounding box e.g. locate all dogs and cats in an image and draw a bounding box around each.
        :param pulumi.Input['ImageLimitSettingsArgs'] limit_settings: [Required] Limit settings for the AutoML job.
        :param pulumi.Input[str] task_type: AutoMLJob Task type.
               Expected value is 'ImageObjectDetection'.
        :param pulumi.Input['MLTableJobInputArgs'] training_data: [Required] Training data input.
        :param pulumi.Input[Union[str, 'LogVerbosity']] log_verbosity: Log verbosity for the job.
        :param pulumi.Input['ImageModelSettingsObjectDetectionArgs'] model_settings: Settings used for training the model.
        :param pulumi.Input[Union[str, 'ObjectDetectionPrimaryMetrics']] primary_metric: Primary metric to optimize for this task.
        :param pulumi.Input[Sequence[pulumi.Input['ImageModelDistributionSettingsObjectDetectionArgs']]] search_space: Search space for sampling different combinations of models and their hyperparameters.
        :param pulumi.Input['ImageSweepSettingsArgs'] sweep_settings: Model sweeping and hyperparameter sweeping related settings.
        :param pulumi.Input[str] target_column_name: Target column name: This is prediction values column.
               Also known as label column name in context of classification tasks.
        :param pulumi.Input['MLTableJobInputArgs'] validation_data: Validation data inputs.
        :param pulumi.Input[float] validation_data_size: The fraction of training dataset that needs to be set aside for validation purpose.
               Values between (0.0 , 1.0)
               Applied when validation dataset is not provided.
        """
        pulumi.set(__self__, "limit_settings", limit_settings)
        pulumi.set(__self__, "task_type", 'ImageObjectDetection')
        pulumi.set(__self__, "training_data", training_data)
        if log_verbosity is None:
            log_verbosity = 'Info'
        if log_verbosity is not None:
            pulumi.set(__self__, "log_verbosity", log_verbosity)
        if model_settings is not None:
            pulumi.set(__self__, "model_settings", model_settings)
        if primary_metric is None:
            primary_metric = 'MeanAveragePrecision'
        if primary_metric is not None:
            pulumi.set(__self__, "primary_metric", primary_metric)
        if search_space is not None:
            pulumi.set(__self__, "search_space", search_space)
        if sweep_settings is not None:
            pulumi.set(__self__, "sweep_settings", sweep_settings)
        if target_column_name is not None:
            pulumi.set(__self__, "target_column_name", target_column_name)
        if validation_data is not None:
            pulumi.set(__self__, "validation_data", validation_data)
        if validation_data_size is not None:
            pulumi.set(__self__, "validation_data_size", validation_data_size)

    @property
    @pulumi.getter(name="limitSettings")
    def limit_settings(self) -> pulumi.Input['ImageLimitSettingsArgs']:
        """
        [Required] Limit settings for the AutoML job.
        """
        return pulumi.get(self, "limit_settings")

    @limit_settings.setter
    def limit_settings(self, value: pulumi.Input['ImageLimitSettingsArgs']):
        pulumi.set(self, "limit_settings", value)

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> pulumi.Input[str]:
        """
        AutoMLJob Task type.
        Expected value is 'ImageObjectDetection'.
        """
        return pulumi.get(self, "task_type")

    @task_type.setter
    def task_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "task_type", value)

    @property
    @pulumi.getter(name="trainingData")
    def training_data(self) -> pulumi.Input['MLTableJobInputArgs']:
        """
        [Required] Training data input.
        """
        return pulumi.get(self, "training_data")

    @training_data.setter
    def training_data(self, value: pulumi.Input['MLTableJobInputArgs']):
        pulumi.set(self, "training_data", value)

    @property
    @pulumi.getter(name="logVerbosity")
    def log_verbosity(self) -> Optional[pulumi.Input[Union[str, 'LogVerbosity']]]:
        """
        Log verbosity for the job.
        """
        return pulumi.get(self, "log_verbosity")

    @log_verbosity.setter
    def log_verbosity(self, value: Optional[pulumi.Input[Union[str, 'LogVerbosity']]]):
        pulumi.set(self, "log_verbosity", value)

    @property
    @pulumi.getter(name="modelSettings")
    def model_settings(self) -> Optional[pulumi.Input['ImageModelSettingsObjectDetectionArgs']]:
        """
        Settings used for training the model.
        """
        return pulumi.get(self, "model_settings")

    @model_settings.setter
    def model_settings(self, value: Optional[pulumi.Input['ImageModelSettingsObjectDetectionArgs']]):
        pulumi.set(self, "model_settings", value)

    @property
    @pulumi.getter(name="primaryMetric")
    def primary_metric(self) -> Optional[pulumi.Input[Union[str, 'ObjectDetectionPrimaryMetrics']]]:
        """
        Primary metric to optimize for this task.
        """
        return pulumi.get(self, "primary_metric")

    @primary_metric.setter
    def primary_metric(self, value: Optional[pulumi.Input[Union[str, 'ObjectDetectionPrimaryMetrics']]]):
        pulumi.set(self, "primary_metric", value)

    @property
    @pulumi.getter(name="searchSpace")
    def search_space(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ImageModelDistributionSettingsObjectDetectionArgs']]]]:
        """
        Search space for sampling different combinations of models and their hyperparameters.
        """
        return pulumi.get(self, "search_space")

    @search_space.setter
    def search_space(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ImageModelDistributionSettingsObjectDetectionArgs']]]]):
        pulumi.set(self, "search_space", value)

    @property
    @pulumi.getter(name="sweepSettings")
    def sweep_settings(self) -> Optional[pulumi.Input['ImageSweepSettingsArgs']]:
        """
        Model sweeping and hyperparameter sweeping related settings.
        """
        return pulumi.get(self, "sweep_settings")

    @sweep_settings.setter
    def sweep_settings(self, value: Optional[pulumi.Input['ImageSweepSettingsArgs']]):
        pulumi.set(self, "sweep_settings", value)

    @property
    @pulumi.getter(name="targetColumnName")
    def target_column_name(self) -> Optional[pulumi.Input[str]]:
        """
        Target column name: This is prediction values column.
        Also known as label column name in context of classification tasks.
        """
        return pulumi.get(self, "target_column_name")

    @target_column_name.setter
    def target_column_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_column_name", value)

    @property
    @pulumi.getter(name="validationData")
    def validation_data(self) -> Optional[pulumi.Input['MLTableJobInputArgs']]:
        """
        Validation data inputs.
        """
        return pulumi.get(self, "validation_data")

    @validation_data.setter
    def validation_data(self, value: Optional[pulumi.Input['MLTableJobInputArgs']]):
        pulumi.set(self, "validation_data", value)

    @property
    @pulumi.getter(name="validationDataSize")
    def validation_data_size(self) -> Optional[pulumi.Input[float]]:
        """
        The fraction of training dataset that needs to be set aside for validation purpose.
        Values between (0.0 , 1.0)
        Applied when validation dataset is not provided.
        """
        return pulumi.get(self, "validation_data_size")

    @validation_data_size.setter
    def validation_data_size(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "validation_data_size", value)


@pulumi.input_type
class ImageSweepSettingsArgs:
    def __init__(__self__, *,
                 sampling_algorithm: pulumi.Input[Union[str, 'SamplingAlgorithmType']],
                 early_termination: Optional[pulumi.Input[Union['BanditPolicyArgs', 'MedianStoppingPolicyArgs', 'TruncationSelectionPolicyArgs']]] = None):
        """
        Model sweeping and hyperparameter sweeping related settings.
        :param pulumi.Input[Union[str, 'SamplingAlgorithmType']] sampling_algorithm: [Required] Type of the hyperparameter sampling algorithms.
        :param pulumi.Input[Union['BanditPolicyArgs', 'MedianStoppingPolicyArgs', 'TruncationSelectionPolicyArgs']] early_termination: Type of early termination policy.
        """
        pulumi.set(__self__, "sampling_algorithm", sampling_algorithm)
        if early_termination is not None:
            pulumi.set(__self__, "early_termination", early_termination)

    @property
    @pulumi.getter(name="samplingAlgorithm")
    def sampling_algorithm(self) -> pulumi.Input[Union[str, 'SamplingAlgorithmType']]:
        """
        [Required] Type of the hyperparameter sampling algorithms.
        """
        return pulumi.get(self, "sampling_algorithm")

    @sampling_algorithm.setter
    def sampling_algorithm(self, value: pulumi.Input[Union[str, 'SamplingAlgorithmType']]):
        pulumi.set(self, "sampling_algorithm", value)

    @property
    @pulumi.getter(name="earlyTermination")
    def early_termination(self) -> Optional[pulumi.Input[Union['BanditPolicyArgs', 'MedianStoppingPolicyArgs', 'TruncationSelectionPolicyArgs']]]:
        """
        Type of early termination policy.
        """
        return pulumi.get(self, "early_termination")

    @early_termination.setter
    def early_termination(self, value: Optional[pulumi.Input[Union['BanditPolicyArgs', 'MedianStoppingPolicyArgs', 'TruncationSelectionPolicyArgs']]]):
        pulumi.set(self, "early_termination", value)


@pulumi.input_type
class ImageArgs:
    def __init__(__self__, *,
                 reference: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[Union[str, 'ImageType']]] = None):
        """
        :param pulumi.Input[str] reference: Image reference URL
        :param pulumi.Input[Union[str, 'ImageType']] type: Type of the image. Possible values are: docker - For docker images. azureml - For AzureML images
        """
        if reference is not None:
            pulumi.set(__self__, "reference", reference)
        if type is None:
            type = 'docker'
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def reference(self) -> Optional[pulumi.Input[str]]:
        """
        Image reference URL
        """
        return pulumi.get(self, "reference")

    @reference.setter
    def reference(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "reference", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[Union[str, 'ImageType']]]:
        """
        Type of the image. Possible values are: docker - For docker images. azureml - For AzureML images
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[Union[str, 'ImageType']]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class InferenceContainerPropertiesArgs:
    def __init__(__self__, *,
                 liveness_route: Optional[pulumi.Input['RouteArgs']] = None,
                 readiness_route: Optional[pulumi.Input['RouteArgs']] = None,
                 scoring_route: Optional[pulumi.Input['RouteArgs']] = None):
        """
        :param pulumi.Input['RouteArgs'] liveness_route: The route to check the liveness of the inference server container.
        :param pulumi.Input['RouteArgs'] readiness_route: The route to check the readiness of the inference server container.
        :param pulumi.Input['RouteArgs'] scoring_route: The port to send the scoring requests to, within the inference server container.
        """
        if liveness_route is not None:
            pulumi.set(__self__, "liveness_route", liveness_route)
        if readiness_route is not None:
            pulumi.set(__self__, "readiness_route", readiness_route)
        if scoring_route is not None:
            pulumi.set(__self__, "scoring_route", scoring_route)

    @property
    @pulumi.getter(name="livenessRoute")
    def liveness_route(self) -> Optional[pulumi.Input['RouteArgs']]:
        """
        The route to check the liveness of the inference server container.
        """
        return pulumi.get(self, "liveness_route")

    @liveness_route.setter
    def liveness_route(self, value: Optional[pulumi.Input['RouteArgs']]):
        pulumi.set(self, "liveness_route", value)

    @property
    @pulumi.getter(name="readinessRoute")
    def readiness_route(self) -> Optional[pulumi.Input['RouteArgs']]:
        """
        The route to check the readiness of the inference server container.
        """
        return pulumi.get(self, "readiness_route")

    @readiness_route.setter
    def readiness_route(self, value: Optional[pulumi.Input['RouteArgs']]):
        pulumi.set(self, "readiness_route", value)

    @property
    @pulumi.getter(name="scoringRoute")
    def scoring_route(self) -> Optional[pulumi.Input['RouteArgs']]:
        """
        The port to send the scoring requests to, within the inference server container.
        """
        return pulumi.get(self, "scoring_route")

    @scoring_route.setter
    def scoring_route(self, value: Optional[pulumi.Input['RouteArgs']]):
        pulumi.set(self, "scoring_route", value)


@pulumi.input_type
class InstanceTypeSchemaResourcesArgs:
    def __init__(__self__, *,
                 limits: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 requests: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Resource requests/limits for this instance type
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] limits: Resource limits for this instance type
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] requests: Resource requests for this instance type
        """
        if limits is not None:
            pulumi.set(__self__, "limits", limits)
        if requests is not None:
            pulumi.set(__self__, "requests", requests)

    @property
    @pulumi.getter
    def limits(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Resource limits for this instance type
        """
        return pulumi.get(self, "limits")

    @limits.setter
    def limits(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "limits", value)

    @property
    @pulumi.getter
    def requests(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Resource requests for this instance type
        """
        return pulumi.get(self, "requests")

    @requests.setter
    def requests(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "requests", value)


@pulumi.input_type
class InstanceTypeSchemaArgs:
    def __init__(__self__, *,
                 node_selector: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 resources: Optional[pulumi.Input['InstanceTypeSchemaResourcesArgs']] = None):
        """
        Instance type schema.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] node_selector: Node Selector
        :param pulumi.Input['InstanceTypeSchemaResourcesArgs'] resources: Resource requests/limits for this instance type
        """
        if node_selector is not None:
            pulumi.set(__self__, "node_selector", node_selector)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)

    @property
    @pulumi.getter(name="nodeSelector")
    def node_selector(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Node Selector
        """
        return pulumi.get(self, "node_selector")

    @node_selector.setter
    def node_selector(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "node_selector", value)

    @property
    @pulumi.getter
    def resources(self) -> Optional[pulumi.Input['InstanceTypeSchemaResourcesArgs']]:
        """
        Resource requests/limits for this instance type
        """
        return pulumi.get(self, "resources")

    @resources.setter
    def resources(self, value: Optional[pulumi.Input['InstanceTypeSchemaResourcesArgs']]):
        pulumi.set(self, "resources", value)


@pulumi.input_type
class JobResourceConfigurationArgs:
    def __init__(__self__, *,
                 docker_args: Optional[pulumi.Input[str]] = None,
                 instance_count: Optional[pulumi.Input[int]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 shm_size: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] docker_args: Extra arguments to pass to the Docker run command. This would override any parameters that have already been set by the system, or in this section. This parameter is only supported for Azure ML compute types.
        :param pulumi.Input[int] instance_count: Optional number of instances or nodes used by the compute target.
        :param pulumi.Input[str] instance_type: Optional type of VM used as supported by the compute target.
        :param pulumi.Input[Mapping[str, Any]] properties: Additional properties bag.
        :param pulumi.Input[str] shm_size: Size of the docker container's shared memory block. This should be in the format of (number)(unit) where number as to be greater than 0 and the unit can be one of b(bytes), k(kilobytes), m(megabytes), or g(gigabytes).
        """
        if docker_args is not None:
            pulumi.set(__self__, "docker_args", docker_args)
        if instance_count is None:
            instance_count = 1
        if instance_count is not None:
            pulumi.set(__self__, "instance_count", instance_count)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if shm_size is None:
            shm_size = '2g'
        if shm_size is not None:
            pulumi.set(__self__, "shm_size", shm_size)

    @property
    @pulumi.getter(name="dockerArgs")
    def docker_args(self) -> Optional[pulumi.Input[str]]:
        """
        Extra arguments to pass to the Docker run command. This would override any parameters that have already been set by the system, or in this section. This parameter is only supported for Azure ML compute types.
        """
        return pulumi.get(self, "docker_args")

    @docker_args.setter
    def docker_args(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "docker_args", value)

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> Optional[pulumi.Input[int]]:
        """
        Optional number of instances or nodes used by the compute target.
        """
        return pulumi.get(self, "instance_count")

    @instance_count.setter
    def instance_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "instance_count", value)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[str]]:
        """
        Optional type of VM used as supported by the compute target.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Additional properties bag.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter(name="shmSize")
    def shm_size(self) -> Optional[pulumi.Input[str]]:
        """
        Size of the docker container's shared memory block. This should be in the format of (number)(unit) where number as to be greater than 0 and the unit can be one of b(bytes), k(kilobytes), m(megabytes), or g(gigabytes).
        """
        return pulumi.get(self, "shm_size")

    @shm_size.setter
    def shm_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "shm_size", value)


@pulumi.input_type
class JobScheduleActionArgs:
    def __init__(__self__, *,
                 action_type: pulumi.Input[str],
                 job_base_properties: pulumi.Input[Union['AutoMLJobArgs', 'CommandJobArgs', 'LabelingJobArgs', 'PipelineJobArgs', 'SparkJobArgs', 'SweepJobArgs']]):
        """
        :param pulumi.Input[str] action_type: 
               Expected value is 'CreateJob'.
        :param pulumi.Input[Union['AutoMLJobArgs', 'CommandJobArgs', 'LabelingJobArgs', 'PipelineJobArgs', 'SparkJobArgs', 'SweepJobArgs']] job_base_properties: [Required] Defines Schedule action definition details.
        """
        pulumi.set(__self__, "action_type", 'CreateJob')
        pulumi.set(__self__, "job_base_properties", job_base_properties)

    @property
    @pulumi.getter(name="actionType")
    def action_type(self) -> pulumi.Input[str]:
        """

        Expected value is 'CreateJob'.
        """
        return pulumi.get(self, "action_type")

    @action_type.setter
    def action_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "action_type", value)

    @property
    @pulumi.getter(name="jobBaseProperties")
    def job_base_properties(self) -> pulumi.Input[Union['AutoMLJobArgs', 'CommandJobArgs', 'LabelingJobArgs', 'PipelineJobArgs', 'SparkJobArgs', 'SweepJobArgs']]:
        """
        [Required] Defines Schedule action definition details.
        """
        return pulumi.get(self, "job_base_properties")

    @job_base_properties.setter
    def job_base_properties(self, value: pulumi.Input[Union['AutoMLJobArgs', 'CommandJobArgs', 'LabelingJobArgs', 'PipelineJobArgs', 'SparkJobArgs', 'SweepJobArgs']]):
        pulumi.set(self, "job_base_properties", value)


@pulumi.input_type
class JobServiceArgs:
    def __init__(__self__, *,
                 endpoint: Optional[pulumi.Input[str]] = None,
                 job_service_type: Optional[pulumi.Input[str]] = None,
                 nodes: Optional[pulumi.Input['AllNodesArgs']] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Job endpoint definition
        :param pulumi.Input[str] endpoint: Url for endpoint.
        :param pulumi.Input[str] job_service_type: Endpoint type.
        :param pulumi.Input['AllNodesArgs'] nodes: Nodes that user would like to start the service on.
               If Nodes is not set or set to null, the service will only be started on leader node.
        :param pulumi.Input[int] port: Port for endpoint set by user.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: Additional properties to set on the endpoint.
        """
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if job_service_type is not None:
            pulumi.set(__self__, "job_service_type", job_service_type)
        if nodes is not None:
            pulumi.set(__self__, "nodes", nodes)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        Url for endpoint.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint", value)

    @property
    @pulumi.getter(name="jobServiceType")
    def job_service_type(self) -> Optional[pulumi.Input[str]]:
        """
        Endpoint type.
        """
        return pulumi.get(self, "job_service_type")

    @job_service_type.setter
    def job_service_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "job_service_type", value)

    @property
    @pulumi.getter
    def nodes(self) -> Optional[pulumi.Input['AllNodesArgs']]:
        """
        Nodes that user would like to start the service on.
        If Nodes is not set or set to null, the service will only be started on leader node.
        """
        return pulumi.get(self, "nodes")

    @nodes.setter
    def nodes(self, value: Optional[pulumi.Input['AllNodesArgs']]):
        pulumi.set(self, "nodes", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        Port for endpoint set by user.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Additional properties to set on the endpoint.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "properties", value)


@pulumi.input_type
class KerberosKeytabCredentialsArgs:
    def __init__(__self__, *,
                 credentials_type: pulumi.Input[str],
                 kerberos_kdc_address: pulumi.Input[str],
                 kerberos_principal: pulumi.Input[str],
                 kerberos_realm: pulumi.Input[str],
                 secrets: pulumi.Input['KerberosKeytabSecretsArgs']):
        """
        :param pulumi.Input[str] credentials_type: Enum to determine the datastore credentials type.
               Expected value is 'KerberosKeytab'.
        :param pulumi.Input[str] kerberos_kdc_address: [Required] IP Address or DNS HostName.
        :param pulumi.Input[str] kerberos_principal: [Required] Kerberos Username
        :param pulumi.Input[str] kerberos_realm: [Required] Domain over which a Kerberos authentication server has the authority to authenticate a user, host or service.
        :param pulumi.Input['KerberosKeytabSecretsArgs'] secrets: [Required] Keytab secrets.
        """
        pulumi.set(__self__, "credentials_type", 'KerberosKeytab')
        pulumi.set(__self__, "kerberos_kdc_address", kerberos_kdc_address)
        pulumi.set(__self__, "kerberos_principal", kerberos_principal)
        pulumi.set(__self__, "kerberos_realm", kerberos_realm)
        pulumi.set(__self__, "secrets", secrets)

    @property
    @pulumi.getter(name="credentialsType")
    def credentials_type(self) -> pulumi.Input[str]:
        """
        Enum to determine the datastore credentials type.
        Expected value is 'KerberosKeytab'.
        """
        return pulumi.get(self, "credentials_type")

    @credentials_type.setter
    def credentials_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "credentials_type", value)

    @property
    @pulumi.getter(name="kerberosKdcAddress")
    def kerberos_kdc_address(self) -> pulumi.Input[str]:
        """
        [Required] IP Address or DNS HostName.
        """
        return pulumi.get(self, "kerberos_kdc_address")

    @kerberos_kdc_address.setter
    def kerberos_kdc_address(self, value: pulumi.Input[str]):
        pulumi.set(self, "kerberos_kdc_address", value)

    @property
    @pulumi.getter(name="kerberosPrincipal")
    def kerberos_principal(self) -> pulumi.Input[str]:
        """
        [Required] Kerberos Username
        """
        return pulumi.get(self, "kerberos_principal")

    @kerberos_principal.setter
    def kerberos_principal(self, value: pulumi.Input[str]):
        pulumi.set(self, "kerberos_principal", value)

    @property
    @pulumi.getter(name="kerberosRealm")
    def kerberos_realm(self) -> pulumi.Input[str]:
        """
        [Required] Domain over which a Kerberos authentication server has the authority to authenticate a user, host or service.
        """
        return pulumi.get(self, "kerberos_realm")

    @kerberos_realm.setter
    def kerberos_realm(self, value: pulumi.Input[str]):
        pulumi.set(self, "kerberos_realm", value)

    @property
    @pulumi.getter
    def secrets(self) -> pulumi.Input['KerberosKeytabSecretsArgs']:
        """
        [Required] Keytab secrets.
        """
        return pulumi.get(self, "secrets")

    @secrets.setter
    def secrets(self, value: pulumi.Input['KerberosKeytabSecretsArgs']):
        pulumi.set(self, "secrets", value)


@pulumi.input_type
class KerberosKeytabSecretsArgs:
    def __init__(__self__, *,
                 secrets_type: pulumi.Input[str],
                 kerberos_keytab: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] secrets_type: Enum to determine the datastore secrets type.
               Expected value is 'KerberosKeytab'.
        :param pulumi.Input[str] kerberos_keytab: Kerberos keytab secret.
        """
        pulumi.set(__self__, "secrets_type", 'KerberosKeytab')
        if kerberos_keytab is not None:
            pulumi.set(__self__, "kerberos_keytab", kerberos_keytab)

    @property
    @pulumi.getter(name="secretsType")
    def secrets_type(self) -> pulumi.Input[str]:
        """
        Enum to determine the datastore secrets type.
        Expected value is 'KerberosKeytab'.
        """
        return pulumi.get(self, "secrets_type")

    @secrets_type.setter
    def secrets_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "secrets_type", value)

    @property
    @pulumi.getter(name="kerberosKeytab")
    def kerberos_keytab(self) -> Optional[pulumi.Input[str]]:
        """
        Kerberos keytab secret.
        """
        return pulumi.get(self, "kerberos_keytab")

    @kerberos_keytab.setter
    def kerberos_keytab(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kerberos_keytab", value)


@pulumi.input_type
class KerberosPasswordCredentialsArgs:
    def __init__(__self__, *,
                 credentials_type: pulumi.Input[str],
                 kerberos_kdc_address: pulumi.Input[str],
                 kerberos_principal: pulumi.Input[str],
                 kerberos_realm: pulumi.Input[str],
                 secrets: pulumi.Input['KerberosPasswordSecretsArgs']):
        """
        :param pulumi.Input[str] credentials_type: Enum to determine the datastore credentials type.
               Expected value is 'KerberosPassword'.
        :param pulumi.Input[str] kerberos_kdc_address: [Required] IP Address or DNS HostName.
        :param pulumi.Input[str] kerberos_principal: [Required] Kerberos Username
        :param pulumi.Input[str] kerberos_realm: [Required] Domain over which a Kerberos authentication server has the authority to authenticate a user, host or service.
        :param pulumi.Input['KerberosPasswordSecretsArgs'] secrets: [Required] Kerberos password secrets.
        """
        pulumi.set(__self__, "credentials_type", 'KerberosPassword')
        pulumi.set(__self__, "kerberos_kdc_address", kerberos_kdc_address)
        pulumi.set(__self__, "kerberos_principal", kerberos_principal)
        pulumi.set(__self__, "kerberos_realm", kerberos_realm)
        pulumi.set(__self__, "secrets", secrets)

    @property
    @pulumi.getter(name="credentialsType")
    def credentials_type(self) -> pulumi.Input[str]:
        """
        Enum to determine the datastore credentials type.
        Expected value is 'KerberosPassword'.
        """
        return pulumi.get(self, "credentials_type")

    @credentials_type.setter
    def credentials_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "credentials_type", value)

    @property
    @pulumi.getter(name="kerberosKdcAddress")
    def kerberos_kdc_address(self) -> pulumi.Input[str]:
        """
        [Required] IP Address or DNS HostName.
        """
        return pulumi.get(self, "kerberos_kdc_address")

    @kerberos_kdc_address.setter
    def kerberos_kdc_address(self, value: pulumi.Input[str]):
        pulumi.set(self, "kerberos_kdc_address", value)

    @property
    @pulumi.getter(name="kerberosPrincipal")
    def kerberos_principal(self) -> pulumi.Input[str]:
        """
        [Required] Kerberos Username
        """
        return pulumi.get(self, "kerberos_principal")

    @kerberos_principal.setter
    def kerberos_principal(self, value: pulumi.Input[str]):
        pulumi.set(self, "kerberos_principal", value)

    @property
    @pulumi.getter(name="kerberosRealm")
    def kerberos_realm(self) -> pulumi.Input[str]:
        """
        [Required] Domain over which a Kerberos authentication server has the authority to authenticate a user, host or service.
        """
        return pulumi.get(self, "kerberos_realm")

    @kerberos_realm.setter
    def kerberos_realm(self, value: pulumi.Input[str]):
        pulumi.set(self, "kerberos_realm", value)

    @property
    @pulumi.getter
    def secrets(self) -> pulumi.Input['KerberosPasswordSecretsArgs']:
        """
        [Required] Kerberos password secrets.
        """
        return pulumi.get(self, "secrets")

    @secrets.setter
    def secrets(self, value: pulumi.Input['KerberosPasswordSecretsArgs']):
        pulumi.set(self, "secrets", value)


@pulumi.input_type
class KerberosPasswordSecretsArgs:
    def __init__(__self__, *,
                 secrets_type: pulumi.Input[str],
                 kerberos_password: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] secrets_type: Enum to determine the datastore secrets type.
               Expected value is 'KerberosPassword'.
        :param pulumi.Input[str] kerberos_password: Kerberos password secret.
        """
        pulumi.set(__self__, "secrets_type", 'KerberosPassword')
        if kerberos_password is not None:
            pulumi.set(__self__, "kerberos_password", kerberos_password)

    @property
    @pulumi.getter(name="secretsType")
    def secrets_type(self) -> pulumi.Input[str]:
        """
        Enum to determine the datastore secrets type.
        Expected value is 'KerberosPassword'.
        """
        return pulumi.get(self, "secrets_type")

    @secrets_type.setter
    def secrets_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "secrets_type", value)

    @property
    @pulumi.getter(name="kerberosPassword")
    def kerberos_password(self) -> Optional[pulumi.Input[str]]:
        """
        Kerberos password secret.
        """
        return pulumi.get(self, "kerberos_password")

    @kerberos_password.setter
    def kerberos_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kerberos_password", value)


@pulumi.input_type
class KubernetesOnlineDeploymentArgs:
    def __init__(__self__, *,
                 endpoint_compute_type: pulumi.Input[str],
                 app_insights_enabled: Optional[pulumi.Input[bool]] = None,
                 code_configuration: Optional[pulumi.Input['CodeConfigurationArgs']] = None,
                 container_resource_requirements: Optional[pulumi.Input['ContainerResourceRequirementsArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 egress_public_network_access: Optional[pulumi.Input[Union[str, 'EgressPublicNetworkAccessType']]] = None,
                 environment_id: Optional[pulumi.Input[str]] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 liveness_probe: Optional[pulumi.Input['ProbeSettingsArgs']] = None,
                 model: Optional[pulumi.Input[str]] = None,
                 model_mount_path: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 readiness_probe: Optional[pulumi.Input['ProbeSettingsArgs']] = None,
                 request_settings: Optional[pulumi.Input['OnlineRequestSettingsArgs']] = None,
                 scale_settings: Optional[pulumi.Input[Union['DefaultScaleSettingsArgs', 'TargetUtilizationScaleSettingsArgs']]] = None):
        """
        Properties specific to a KubernetesOnlineDeployment.
        :param pulumi.Input[str] endpoint_compute_type: Enum to determine endpoint compute type.
               Expected value is 'Kubernetes'.
        :param pulumi.Input[bool] app_insights_enabled: If true, enables Application Insights logging.
        :param pulumi.Input['CodeConfigurationArgs'] code_configuration: Code configuration for the endpoint deployment.
        :param pulumi.Input['ContainerResourceRequirementsArgs'] container_resource_requirements: The resource requirements for the container (cpu and memory).
        :param pulumi.Input[str] description: Description of the endpoint deployment.
        :param pulumi.Input[Union[str, 'EgressPublicNetworkAccessType']] egress_public_network_access: If Enabled, allow egress public network access. If Disabled, this will create secure egress. Default: Enabled.
        :param pulumi.Input[str] environment_id: ARM resource ID of the environment specification for the endpoint deployment.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] environment_variables: Environment variables configuration for the deployment.
        :param pulumi.Input[str] instance_type: Compute instance type.
        :param pulumi.Input['ProbeSettingsArgs'] liveness_probe: Liveness probe monitors the health of the container regularly.
        :param pulumi.Input[str] model: The URI path to the model.
        :param pulumi.Input[str] model_mount_path: The path to mount the model in custom container.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: Property dictionary. Properties can be added, but not removed or altered.
        :param pulumi.Input['ProbeSettingsArgs'] readiness_probe: Readiness probe validates if the container is ready to serve traffic. The properties and defaults are the same as liveness probe.
        :param pulumi.Input['OnlineRequestSettingsArgs'] request_settings: Request settings for the deployment.
        :param pulumi.Input[Union['DefaultScaleSettingsArgs', 'TargetUtilizationScaleSettingsArgs']] scale_settings: Scale settings for the deployment.
               If it is null or not provided,
               it defaults to TargetUtilizationScaleSettings for KubernetesOnlineDeployment
               and to DefaultScaleSettings for ManagedOnlineDeployment.
        """
        pulumi.set(__self__, "endpoint_compute_type", 'Kubernetes')
        if app_insights_enabled is None:
            app_insights_enabled = False
        if app_insights_enabled is not None:
            pulumi.set(__self__, "app_insights_enabled", app_insights_enabled)
        if code_configuration is not None:
            pulumi.set(__self__, "code_configuration", code_configuration)
        if container_resource_requirements is not None:
            pulumi.set(__self__, "container_resource_requirements", container_resource_requirements)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if egress_public_network_access is None:
            egress_public_network_access = 'Enabled'
        if egress_public_network_access is not None:
            pulumi.set(__self__, "egress_public_network_access", egress_public_network_access)
        if environment_id is not None:
            pulumi.set(__self__, "environment_id", environment_id)
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if liveness_probe is not None:
            pulumi.set(__self__, "liveness_probe", liveness_probe)
        if model is not None:
            pulumi.set(__self__, "model", model)
        if model_mount_path is not None:
            pulumi.set(__self__, "model_mount_path", model_mount_path)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if readiness_probe is not None:
            pulumi.set(__self__, "readiness_probe", readiness_probe)
        if request_settings is not None:
            pulumi.set(__self__, "request_settings", request_settings)
        if scale_settings is not None:
            pulumi.set(__self__, "scale_settings", scale_settings)

    @property
    @pulumi.getter(name="endpointComputeType")
    def endpoint_compute_type(self) -> pulumi.Input[str]:
        """
        Enum to determine endpoint compute type.
        Expected value is 'Kubernetes'.
        """
        return pulumi.get(self, "endpoint_compute_type")

    @endpoint_compute_type.setter
    def endpoint_compute_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "endpoint_compute_type", value)

    @property
    @pulumi.getter(name="appInsightsEnabled")
    def app_insights_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, enables Application Insights logging.
        """
        return pulumi.get(self, "app_insights_enabled")

    @app_insights_enabled.setter
    def app_insights_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "app_insights_enabled", value)

    @property
    @pulumi.getter(name="codeConfiguration")
    def code_configuration(self) -> Optional[pulumi.Input['CodeConfigurationArgs']]:
        """
        Code configuration for the endpoint deployment.
        """
        return pulumi.get(self, "code_configuration")

    @code_configuration.setter
    def code_configuration(self, value: Optional[pulumi.Input['CodeConfigurationArgs']]):
        pulumi.set(self, "code_configuration", value)

    @property
    @pulumi.getter(name="containerResourceRequirements")
    def container_resource_requirements(self) -> Optional[pulumi.Input['ContainerResourceRequirementsArgs']]:
        """
        The resource requirements for the container (cpu and memory).
        """
        return pulumi.get(self, "container_resource_requirements")

    @container_resource_requirements.setter
    def container_resource_requirements(self, value: Optional[pulumi.Input['ContainerResourceRequirementsArgs']]):
        pulumi.set(self, "container_resource_requirements", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the endpoint deployment.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="egressPublicNetworkAccess")
    def egress_public_network_access(self) -> Optional[pulumi.Input[Union[str, 'EgressPublicNetworkAccessType']]]:
        """
        If Enabled, allow egress public network access. If Disabled, this will create secure egress. Default: Enabled.
        """
        return pulumi.get(self, "egress_public_network_access")

    @egress_public_network_access.setter
    def egress_public_network_access(self, value: Optional[pulumi.Input[Union[str, 'EgressPublicNetworkAccessType']]]):
        pulumi.set(self, "egress_public_network_access", value)

    @property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM resource ID of the environment specification for the endpoint deployment.
        """
        return pulumi.get(self, "environment_id")

    @environment_id.setter
    def environment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "environment_id", value)

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Environment variables configuration for the deployment.
        """
        return pulumi.get(self, "environment_variables")

    @environment_variables.setter
    def environment_variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "environment_variables", value)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[str]]:
        """
        Compute instance type.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="livenessProbe")
    def liveness_probe(self) -> Optional[pulumi.Input['ProbeSettingsArgs']]:
        """
        Liveness probe monitors the health of the container regularly.
        """
        return pulumi.get(self, "liveness_probe")

    @liveness_probe.setter
    def liveness_probe(self, value: Optional[pulumi.Input['ProbeSettingsArgs']]):
        pulumi.set(self, "liveness_probe", value)

    @property
    @pulumi.getter
    def model(self) -> Optional[pulumi.Input[str]]:
        """
        The URI path to the model.
        """
        return pulumi.get(self, "model")

    @model.setter
    def model(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "model", value)

    @property
    @pulumi.getter(name="modelMountPath")
    def model_mount_path(self) -> Optional[pulumi.Input[str]]:
        """
        The path to mount the model in custom container.
        """
        return pulumi.get(self, "model_mount_path")

    @model_mount_path.setter
    def model_mount_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "model_mount_path", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Property dictionary. Properties can be added, but not removed or altered.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter(name="readinessProbe")
    def readiness_probe(self) -> Optional[pulumi.Input['ProbeSettingsArgs']]:
        """
        Readiness probe validates if the container is ready to serve traffic. The properties and defaults are the same as liveness probe.
        """
        return pulumi.get(self, "readiness_probe")

    @readiness_probe.setter
    def readiness_probe(self, value: Optional[pulumi.Input['ProbeSettingsArgs']]):
        pulumi.set(self, "readiness_probe", value)

    @property
    @pulumi.getter(name="requestSettings")
    def request_settings(self) -> Optional[pulumi.Input['OnlineRequestSettingsArgs']]:
        """
        Request settings for the deployment.
        """
        return pulumi.get(self, "request_settings")

    @request_settings.setter
    def request_settings(self, value: Optional[pulumi.Input['OnlineRequestSettingsArgs']]):
        pulumi.set(self, "request_settings", value)

    @property
    @pulumi.getter(name="scaleSettings")
    def scale_settings(self) -> Optional[pulumi.Input[Union['DefaultScaleSettingsArgs', 'TargetUtilizationScaleSettingsArgs']]]:
        """
        Scale settings for the deployment.
        If it is null or not provided,
        it defaults to TargetUtilizationScaleSettings for KubernetesOnlineDeployment
        and to DefaultScaleSettings for ManagedOnlineDeployment.
        """
        return pulumi.get(self, "scale_settings")

    @scale_settings.setter
    def scale_settings(self, value: Optional[pulumi.Input[Union['DefaultScaleSettingsArgs', 'TargetUtilizationScaleSettingsArgs']]]):
        pulumi.set(self, "scale_settings", value)


@pulumi.input_type
class KubernetesPropertiesArgs:
    def __init__(__self__, *,
                 default_instance_type: Optional[pulumi.Input[str]] = None,
                 extension_instance_release_train: Optional[pulumi.Input[str]] = None,
                 extension_principal_id: Optional[pulumi.Input[str]] = None,
                 instance_types: Optional[pulumi.Input[Mapping[str, pulumi.Input['InstanceTypeSchemaArgs']]]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 relay_connection_string: Optional[pulumi.Input[str]] = None,
                 service_bus_connection_string: Optional[pulumi.Input[str]] = None,
                 vc_name: Optional[pulumi.Input[str]] = None):
        """
        Kubernetes properties
        :param pulumi.Input[str] default_instance_type: Default instance type
        :param pulumi.Input[str] extension_instance_release_train: Extension instance release train.
        :param pulumi.Input[str] extension_principal_id: Extension principal-id.
        :param pulumi.Input[Mapping[str, pulumi.Input['InstanceTypeSchemaArgs']]] instance_types: Instance Type Schema
        :param pulumi.Input[str] namespace: Compute namespace
        :param pulumi.Input[str] relay_connection_string: Relay connection string.
        :param pulumi.Input[str] service_bus_connection_string: ServiceBus connection string.
        :param pulumi.Input[str] vc_name: VC name.
        """
        if default_instance_type is not None:
            pulumi.set(__self__, "default_instance_type", default_instance_type)
        if extension_instance_release_train is not None:
            pulumi.set(__self__, "extension_instance_release_train", extension_instance_release_train)
        if extension_principal_id is not None:
            pulumi.set(__self__, "extension_principal_id", extension_principal_id)
        if instance_types is not None:
            pulumi.set(__self__, "instance_types", instance_types)
        if namespace is None:
            namespace = 'default'
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if relay_connection_string is not None:
            pulumi.set(__self__, "relay_connection_string", relay_connection_string)
        if service_bus_connection_string is not None:
            pulumi.set(__self__, "service_bus_connection_string", service_bus_connection_string)
        if vc_name is not None:
            pulumi.set(__self__, "vc_name", vc_name)

    @property
    @pulumi.getter(name="defaultInstanceType")
    def default_instance_type(self) -> Optional[pulumi.Input[str]]:
        """
        Default instance type
        """
        return pulumi.get(self, "default_instance_type")

    @default_instance_type.setter
    def default_instance_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_instance_type", value)

    @property
    @pulumi.getter(name="extensionInstanceReleaseTrain")
    def extension_instance_release_train(self) -> Optional[pulumi.Input[str]]:
        """
        Extension instance release train.
        """
        return pulumi.get(self, "extension_instance_release_train")

    @extension_instance_release_train.setter
    def extension_instance_release_train(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "extension_instance_release_train", value)

    @property
    @pulumi.getter(name="extensionPrincipalId")
    def extension_principal_id(self) -> Optional[pulumi.Input[str]]:
        """
        Extension principal-id.
        """
        return pulumi.get(self, "extension_principal_id")

    @extension_principal_id.setter
    def extension_principal_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "extension_principal_id", value)

    @property
    @pulumi.getter(name="instanceTypes")
    def instance_types(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['InstanceTypeSchemaArgs']]]]:
        """
        Instance Type Schema
        """
        return pulumi.get(self, "instance_types")

    @instance_types.setter
    def instance_types(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['InstanceTypeSchemaArgs']]]]):
        pulumi.set(self, "instance_types", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        Compute namespace
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="relayConnectionString")
    def relay_connection_string(self) -> Optional[pulumi.Input[str]]:
        """
        Relay connection string.
        """
        return pulumi.get(self, "relay_connection_string")

    @relay_connection_string.setter
    def relay_connection_string(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "relay_connection_string", value)

    @property
    @pulumi.getter(name="serviceBusConnectionString")
    def service_bus_connection_string(self) -> Optional[pulumi.Input[str]]:
        """
        ServiceBus connection string.
        """
        return pulumi.get(self, "service_bus_connection_string")

    @service_bus_connection_string.setter
    def service_bus_connection_string(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_bus_connection_string", value)

    @property
    @pulumi.getter(name="vcName")
    def vc_name(self) -> Optional[pulumi.Input[str]]:
        """
        VC name.
        """
        return pulumi.get(self, "vc_name")

    @vc_name.setter
    def vc_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vc_name", value)


@pulumi.input_type
class KubernetesArgs:
    def __init__(__self__, *,
                 compute_type: pulumi.Input[str],
                 compute_location: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disable_local_auth: Optional[pulumi.Input[bool]] = None,
                 properties: Optional[pulumi.Input['KubernetesPropertiesArgs']] = None,
                 resource_id: Optional[pulumi.Input[str]] = None):
        """
        A Machine Learning compute based on Kubernetes Compute.
        :param pulumi.Input[str] compute_type: The type of compute
               Expected value is 'Kubernetes'.
        :param pulumi.Input[str] compute_location: Location for the underlying compute
        :param pulumi.Input[str] description: The description of the Machine Learning compute.
        :param pulumi.Input[bool] disable_local_auth: Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
        :param pulumi.Input['KubernetesPropertiesArgs'] properties: Properties of Kubernetes
        :param pulumi.Input[str] resource_id: ARM resource id of the underlying compute
        """
        pulumi.set(__self__, "compute_type", 'Kubernetes')
        if compute_location is not None:
            pulumi.set(__self__, "compute_location", compute_location)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_local_auth is not None:
            pulumi.set(__self__, "disable_local_auth", disable_local_auth)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="computeType")
    def compute_type(self) -> pulumi.Input[str]:
        """
        The type of compute
        Expected value is 'Kubernetes'.
        """
        return pulumi.get(self, "compute_type")

    @compute_type.setter
    def compute_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "compute_type", value)

    @property
    @pulumi.getter(name="computeLocation")
    def compute_location(self) -> Optional[pulumi.Input[str]]:
        """
        Location for the underlying compute
        """
        return pulumi.get(self, "compute_location")

    @compute_location.setter
    def compute_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compute_location", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the Machine Learning compute.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="disableLocalAuth")
    def disable_local_auth(self) -> Optional[pulumi.Input[bool]]:
        """
        Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
        """
        return pulumi.get(self, "disable_local_auth")

    @disable_local_auth.setter
    def disable_local_auth(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_local_auth", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input['KubernetesPropertiesArgs']]:
        """
        Properties of Kubernetes
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input['KubernetesPropertiesArgs']]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM resource id of the underlying compute
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_id", value)


@pulumi.input_type
class LabelCategoryArgs:
    def __init__(__self__, *,
                 classes: Optional[pulumi.Input[Mapping[str, pulumi.Input['LabelClassArgs']]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 multi_select: Optional[pulumi.Input[Union[str, 'MultiSelect']]] = None):
        """
        Label category definition
        :param pulumi.Input[Mapping[str, pulumi.Input['LabelClassArgs']]] classes: Dictionary of label classes in this category.
        :param pulumi.Input[str] display_name: Display name of the label category.
        :param pulumi.Input[Union[str, 'MultiSelect']] multi_select: Indicates whether it is allowed to select multiple classes in this category.
        """
        if classes is not None:
            pulumi.set(__self__, "classes", classes)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if multi_select is None:
            multi_select = 'Disabled'
        if multi_select is not None:
            pulumi.set(__self__, "multi_select", multi_select)

    @property
    @pulumi.getter
    def classes(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['LabelClassArgs']]]]:
        """
        Dictionary of label classes in this category.
        """
        return pulumi.get(self, "classes")

    @classes.setter
    def classes(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['LabelClassArgs']]]]):
        pulumi.set(self, "classes", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        Display name of the label category.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="multiSelect")
    def multi_select(self) -> Optional[pulumi.Input[Union[str, 'MultiSelect']]]:
        """
        Indicates whether it is allowed to select multiple classes in this category.
        """
        return pulumi.get(self, "multi_select")

    @multi_select.setter
    def multi_select(self, value: Optional[pulumi.Input[Union[str, 'MultiSelect']]]):
        pulumi.set(self, "multi_select", value)


@pulumi.input_type
class LabelClassArgs:
    def __init__(__self__, *,
                 display_name: Optional[pulumi.Input[str]] = None,
                 subclasses: Optional[pulumi.Input[Mapping[str, pulumi.Input['LabelClassArgs']]]] = None):
        """
        Label class definition
        :param pulumi.Input[str] display_name: Display name of the label class.
        :param pulumi.Input[Mapping[str, pulumi.Input['LabelClassArgs']]] subclasses: Dictionary of subclasses of the label class.
        """
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if subclasses is not None:
            pulumi.set(__self__, "subclasses", subclasses)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        Display name of the label class.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def subclasses(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['LabelClassArgs']]]]:
        """
        Dictionary of subclasses of the label class.
        """
        return pulumi.get(self, "subclasses")

    @subclasses.setter
    def subclasses(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['LabelClassArgs']]]]):
        pulumi.set(self, "subclasses", value)


@pulumi.input_type
class LabelingDataConfigurationArgs:
    def __init__(__self__, *,
                 data_id: Optional[pulumi.Input[str]] = None,
                 incremental_data_refresh: Optional[pulumi.Input[Union[str, 'IncrementalDataRefresh']]] = None):
        """
        Labeling data configuration definition
        :param pulumi.Input[str] data_id: Resource Id of the data asset to perform labeling.
        :param pulumi.Input[Union[str, 'IncrementalDataRefresh']] incremental_data_refresh: Indicates whether to enable incremental data refresh.
        """
        if data_id is not None:
            pulumi.set(__self__, "data_id", data_id)
        if incremental_data_refresh is None:
            incremental_data_refresh = 'Disabled'
        if incremental_data_refresh is not None:
            pulumi.set(__self__, "incremental_data_refresh", incremental_data_refresh)

    @property
    @pulumi.getter(name="dataId")
    def data_id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource Id of the data asset to perform labeling.
        """
        return pulumi.get(self, "data_id")

    @data_id.setter
    def data_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_id", value)

    @property
    @pulumi.getter(name="incrementalDataRefresh")
    def incremental_data_refresh(self) -> Optional[pulumi.Input[Union[str, 'IncrementalDataRefresh']]]:
        """
        Indicates whether to enable incremental data refresh.
        """
        return pulumi.get(self, "incremental_data_refresh")

    @incremental_data_refresh.setter
    def incremental_data_refresh(self, value: Optional[pulumi.Input[Union[str, 'IncrementalDataRefresh']]]):
        pulumi.set(self, "incremental_data_refresh", value)


@pulumi.input_type
class LabelingJobImagePropertiesArgs:
    def __init__(__self__, *,
                 media_type: pulumi.Input[str],
                 annotation_type: Optional[pulumi.Input[Union[str, 'ImageAnnotationType']]] = None):
        """
        Properties of a labeling job for image data
        :param pulumi.Input[str] media_type: Media type of data asset.
               Expected value is 'Image'.
        :param pulumi.Input[Union[str, 'ImageAnnotationType']] annotation_type: Annotation type of image labeling job.
        """
        pulumi.set(__self__, "media_type", 'Image')
        if annotation_type is None:
            annotation_type = 'Classification'
        if annotation_type is not None:
            pulumi.set(__self__, "annotation_type", annotation_type)

    @property
    @pulumi.getter(name="mediaType")
    def media_type(self) -> pulumi.Input[str]:
        """
        Media type of data asset.
        Expected value is 'Image'.
        """
        return pulumi.get(self, "media_type")

    @media_type.setter
    def media_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "media_type", value)

    @property
    @pulumi.getter(name="annotationType")
    def annotation_type(self) -> Optional[pulumi.Input[Union[str, 'ImageAnnotationType']]]:
        """
        Annotation type of image labeling job.
        """
        return pulumi.get(self, "annotation_type")

    @annotation_type.setter
    def annotation_type(self, value: Optional[pulumi.Input[Union[str, 'ImageAnnotationType']]]):
        pulumi.set(self, "annotation_type", value)


@pulumi.input_type
class LabelingJobInstructionsArgs:
    def __init__(__self__, *,
                 uri: Optional[pulumi.Input[str]] = None):
        """
        Instructions for labeling job
        :param pulumi.Input[str] uri: The link to a page with detailed labeling instructions for labelers.
        """
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def uri(self) -> Optional[pulumi.Input[str]]:
        """
        The link to a page with detailed labeling instructions for labelers.
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uri", value)


@pulumi.input_type
class LabelingJobTextPropertiesArgs:
    def __init__(__self__, *,
                 media_type: pulumi.Input[str],
                 annotation_type: Optional[pulumi.Input[Union[str, 'TextAnnotationType']]] = None):
        """
        Properties of a labeling job for text data
        :param pulumi.Input[str] media_type: Media type of data asset.
               Expected value is 'Text'.
        :param pulumi.Input[Union[str, 'TextAnnotationType']] annotation_type: Annotation type of text labeling job.
        """
        pulumi.set(__self__, "media_type", 'Text')
        if annotation_type is None:
            annotation_type = 'Classification'
        if annotation_type is not None:
            pulumi.set(__self__, "annotation_type", annotation_type)

    @property
    @pulumi.getter(name="mediaType")
    def media_type(self) -> pulumi.Input[str]:
        """
        Media type of data asset.
        Expected value is 'Text'.
        """
        return pulumi.get(self, "media_type")

    @media_type.setter
    def media_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "media_type", value)

    @property
    @pulumi.getter(name="annotationType")
    def annotation_type(self) -> Optional[pulumi.Input[Union[str, 'TextAnnotationType']]]:
        """
        Annotation type of text labeling job.
        """
        return pulumi.get(self, "annotation_type")

    @annotation_type.setter
    def annotation_type(self, value: Optional[pulumi.Input[Union[str, 'TextAnnotationType']]]):
        pulumi.set(self, "annotation_type", value)


@pulumi.input_type
class LabelingJobArgs:
    def __init__(__self__, *,
                 job_type: pulumi.Input[str],
                 component_id: Optional[pulumi.Input[str]] = None,
                 compute_id: Optional[pulumi.Input[str]] = None,
                 data_configuration: Optional[pulumi.Input['LabelingDataConfigurationArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 experiment_name: Optional[pulumi.Input[str]] = None,
                 identity: Optional[pulumi.Input[Union['AmlTokenArgs', 'ManagedIdentityArgs', 'UserIdentityArgs']]] = None,
                 is_archived: Optional[pulumi.Input[bool]] = None,
                 job_instructions: Optional[pulumi.Input['LabelingJobInstructionsArgs']] = None,
                 label_categories: Optional[pulumi.Input[Mapping[str, pulumi.Input['LabelCategoryArgs']]]] = None,
                 labeling_job_media_properties: Optional[pulumi.Input[Union['LabelingJobImagePropertiesArgs', 'LabelingJobTextPropertiesArgs']]] = None,
                 ml_assist_configuration: Optional[pulumi.Input[Union['MLAssistConfigurationDisabledArgs', 'MLAssistConfigurationEnabledArgs']]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 services: Optional[pulumi.Input[Mapping[str, pulumi.Input['JobServiceArgs']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Labeling job definition
        :param pulumi.Input[str] job_type: Enum to determine the type of job.
               Expected value is 'Labeling'.
        :param pulumi.Input[str] component_id: ARM resource ID of the component resource.
        :param pulumi.Input[str] compute_id: ARM resource ID of the compute resource.
        :param pulumi.Input['LabelingDataConfigurationArgs'] data_configuration: Configuration of data used in the job.
        :param pulumi.Input[str] description: The asset description text.
        :param pulumi.Input[str] display_name: Display name of job.
        :param pulumi.Input[str] experiment_name: The name of the experiment the job belongs to. If not set, the job is placed in the "Default" experiment.
        :param pulumi.Input[Union['AmlTokenArgs', 'ManagedIdentityArgs', 'UserIdentityArgs']] identity: Identity configuration. If set, this should be one of AmlToken, ManagedIdentity, UserIdentity or null.
               Defaults to AmlToken if null.
        :param pulumi.Input[bool] is_archived: Is the asset archived?
        :param pulumi.Input['LabelingJobInstructionsArgs'] job_instructions: Labeling instructions of the job.
        :param pulumi.Input[Mapping[str, pulumi.Input['LabelCategoryArgs']]] label_categories: Label categories of the job.
        :param pulumi.Input[Union['LabelingJobImagePropertiesArgs', 'LabelingJobTextPropertiesArgs']] labeling_job_media_properties: Media type specific properties in the job.
        :param pulumi.Input[Union['MLAssistConfigurationDisabledArgs', 'MLAssistConfigurationEnabledArgs']] ml_assist_configuration: Configuration of MLAssist feature in the job.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: The asset property dictionary.
        :param pulumi.Input[Mapping[str, pulumi.Input['JobServiceArgs']]] services: List of JobEndpoints.
               For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Tag dictionary. Tags can be added, removed, and updated.
        """
        pulumi.set(__self__, "job_type", 'Labeling')
        if component_id is not None:
            pulumi.set(__self__, "component_id", component_id)
        if compute_id is not None:
            pulumi.set(__self__, "compute_id", compute_id)
        if data_configuration is not None:
            pulumi.set(__self__, "data_configuration", data_configuration)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if experiment_name is None:
            experiment_name = 'Default'
        if experiment_name is not None:
            pulumi.set(__self__, "experiment_name", experiment_name)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if is_archived is None:
            is_archived = False
        if is_archived is not None:
            pulumi.set(__self__, "is_archived", is_archived)
        if job_instructions is not None:
            pulumi.set(__self__, "job_instructions", job_instructions)
        if label_categories is not None:
            pulumi.set(__self__, "label_categories", label_categories)
        if labeling_job_media_properties is not None:
            pulumi.set(__self__, "labeling_job_media_properties", labeling_job_media_properties)
        if ml_assist_configuration is not None:
            pulumi.set(__self__, "ml_assist_configuration", ml_assist_configuration)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if services is not None:
            pulumi.set(__self__, "services", services)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="jobType")
    def job_type(self) -> pulumi.Input[str]:
        """
        Enum to determine the type of job.
        Expected value is 'Labeling'.
        """
        return pulumi.get(self, "job_type")

    @job_type.setter
    def job_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "job_type", value)

    @property
    @pulumi.getter(name="componentId")
    def component_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM resource ID of the component resource.
        """
        return pulumi.get(self, "component_id")

    @component_id.setter
    def component_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "component_id", value)

    @property
    @pulumi.getter(name="computeId")
    def compute_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM resource ID of the compute resource.
        """
        return pulumi.get(self, "compute_id")

    @compute_id.setter
    def compute_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compute_id", value)

    @property
    @pulumi.getter(name="dataConfiguration")
    def data_configuration(self) -> Optional[pulumi.Input['LabelingDataConfigurationArgs']]:
        """
        Configuration of data used in the job.
        """
        return pulumi.get(self, "data_configuration")

    @data_configuration.setter
    def data_configuration(self, value: Optional[pulumi.Input['LabelingDataConfigurationArgs']]):
        pulumi.set(self, "data_configuration", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The asset description text.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        Display name of job.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="experimentName")
    def experiment_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the experiment the job belongs to. If not set, the job is placed in the "Default" experiment.
        """
        return pulumi.get(self, "experiment_name")

    @experiment_name.setter
    def experiment_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "experiment_name", value)

    @property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input[Union['AmlTokenArgs', 'ManagedIdentityArgs', 'UserIdentityArgs']]]:
        """
        Identity configuration. If set, this should be one of AmlToken, ManagedIdentity, UserIdentity or null.
        Defaults to AmlToken if null.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input[Union['AmlTokenArgs', 'ManagedIdentityArgs', 'UserIdentityArgs']]]):
        pulumi.set(self, "identity", value)

    @property
    @pulumi.getter(name="isArchived")
    def is_archived(self) -> Optional[pulumi.Input[bool]]:
        """
        Is the asset archived?
        """
        return pulumi.get(self, "is_archived")

    @is_archived.setter
    def is_archived(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_archived", value)

    @property
    @pulumi.getter(name="jobInstructions")
    def job_instructions(self) -> Optional[pulumi.Input['LabelingJobInstructionsArgs']]:
        """
        Labeling instructions of the job.
        """
        return pulumi.get(self, "job_instructions")

    @job_instructions.setter
    def job_instructions(self, value: Optional[pulumi.Input['LabelingJobInstructionsArgs']]):
        pulumi.set(self, "job_instructions", value)

    @property
    @pulumi.getter(name="labelCategories")
    def label_categories(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['LabelCategoryArgs']]]]:
        """
        Label categories of the job.
        """
        return pulumi.get(self, "label_categories")

    @label_categories.setter
    def label_categories(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['LabelCategoryArgs']]]]):
        pulumi.set(self, "label_categories", value)

    @property
    @pulumi.getter(name="labelingJobMediaProperties")
    def labeling_job_media_properties(self) -> Optional[pulumi.Input[Union['LabelingJobImagePropertiesArgs', 'LabelingJobTextPropertiesArgs']]]:
        """
        Media type specific properties in the job.
        """
        return pulumi.get(self, "labeling_job_media_properties")

    @labeling_job_media_properties.setter
    def labeling_job_media_properties(self, value: Optional[pulumi.Input[Union['LabelingJobImagePropertiesArgs', 'LabelingJobTextPropertiesArgs']]]):
        pulumi.set(self, "labeling_job_media_properties", value)

    @property
    @pulumi.getter(name="mlAssistConfiguration")
    def ml_assist_configuration(self) -> Optional[pulumi.Input[Union['MLAssistConfigurationDisabledArgs', 'MLAssistConfigurationEnabledArgs']]]:
        """
        Configuration of MLAssist feature in the job.
        """
        return pulumi.get(self, "ml_assist_configuration")

    @ml_assist_configuration.setter
    def ml_assist_configuration(self, value: Optional[pulumi.Input[Union['MLAssistConfigurationDisabledArgs', 'MLAssistConfigurationEnabledArgs']]]):
        pulumi.set(self, "ml_assist_configuration", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The asset property dictionary.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter
    def services(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['JobServiceArgs']]]]:
        """
        List of JobEndpoints.
        For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
        """
        return pulumi.get(self, "services")

    @services.setter
    def services(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['JobServiceArgs']]]]):
        pulumi.set(self, "services", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Tag dictionary. Tags can be added, removed, and updated.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class LiteralJobInputArgs:
    def __init__(__self__, *,
                 job_input_type: pulumi.Input[str],
                 value: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None):
        """
        Literal input type.
        :param pulumi.Input[str] job_input_type: Enum to determine the Job Input Type.
               Expected value is 'literal'.
        :param pulumi.Input[str] value: [Required] Literal value for the input.
        :param pulumi.Input[str] description: Description for the input.
        """
        pulumi.set(__self__, "job_input_type", 'literal')
        pulumi.set(__self__, "value", value)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter(name="jobInputType")
    def job_input_type(self) -> pulumi.Input[str]:
        """
        Enum to determine the Job Input Type.
        Expected value is 'literal'.
        """
        return pulumi.get(self, "job_input_type")

    @job_input_type.setter
    def job_input_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "job_input_type", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        [Required] Literal value for the input.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description for the input.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class MLAssistConfigurationDisabledArgs:
    def __init__(__self__, *,
                 ml_assist: pulumi.Input[str]):
        """
        Labeling MLAssist configuration definition when MLAssist is disabled
        :param pulumi.Input[str] ml_assist: 
               Expected value is 'Disabled'.
        """
        pulumi.set(__self__, "ml_assist", 'Disabled')

    @property
    @pulumi.getter(name="mlAssist")
    def ml_assist(self) -> pulumi.Input[str]:
        """

        Expected value is 'Disabled'.
        """
        return pulumi.get(self, "ml_assist")

    @ml_assist.setter
    def ml_assist(self, value: pulumi.Input[str]):
        pulumi.set(self, "ml_assist", value)


@pulumi.input_type
class MLAssistConfigurationEnabledArgs:
    def __init__(__self__, *,
                 inferencing_compute_binding: pulumi.Input[str],
                 ml_assist: pulumi.Input[str],
                 training_compute_binding: pulumi.Input[str]):
        """
        Labeling MLAssist configuration definition when MLAssist is enabled
        :param pulumi.Input[str] inferencing_compute_binding: [Required] AML compute binding used in inferencing.
        :param pulumi.Input[str] ml_assist: 
               Expected value is 'Enabled'.
        :param pulumi.Input[str] training_compute_binding: [Required] AML compute binding used in training.
        """
        pulumi.set(__self__, "inferencing_compute_binding", inferencing_compute_binding)
        pulumi.set(__self__, "ml_assist", 'Enabled')
        pulumi.set(__self__, "training_compute_binding", training_compute_binding)

    @property
    @pulumi.getter(name="inferencingComputeBinding")
    def inferencing_compute_binding(self) -> pulumi.Input[str]:
        """
        [Required] AML compute binding used in inferencing.
        """
        return pulumi.get(self, "inferencing_compute_binding")

    @inferencing_compute_binding.setter
    def inferencing_compute_binding(self, value: pulumi.Input[str]):
        pulumi.set(self, "inferencing_compute_binding", value)

    @property
    @pulumi.getter(name="mlAssist")
    def ml_assist(self) -> pulumi.Input[str]:
        """

        Expected value is 'Enabled'.
        """
        return pulumi.get(self, "ml_assist")

    @ml_assist.setter
    def ml_assist(self, value: pulumi.Input[str]):
        pulumi.set(self, "ml_assist", value)

    @property
    @pulumi.getter(name="trainingComputeBinding")
    def training_compute_binding(self) -> pulumi.Input[str]:
        """
        [Required] AML compute binding used in training.
        """
        return pulumi.get(self, "training_compute_binding")

    @training_compute_binding.setter
    def training_compute_binding(self, value: pulumi.Input[str]):
        pulumi.set(self, "training_compute_binding", value)


@pulumi.input_type
class MLFlowModelJobInputArgs:
    def __init__(__self__, *,
                 job_input_type: pulumi.Input[str],
                 uri: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 mode: Optional[pulumi.Input[Union[str, 'InputDeliveryMode']]] = None):
        """
        :param pulumi.Input[str] job_input_type: Enum to determine the Job Input Type.
               Expected value is 'mlflow_model'.
        :param pulumi.Input[str] uri: [Required] Input Asset URI.
        :param pulumi.Input[str] description: Description for the input.
        :param pulumi.Input[Union[str, 'InputDeliveryMode']] mode: Input Asset Delivery Mode.
        """
        pulumi.set(__self__, "job_input_type", 'mlflow_model')
        pulumi.set(__self__, "uri", uri)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if mode is None:
            mode = 'ReadOnlyMount'
        if mode is not None:
            pulumi.set(__self__, "mode", mode)

    @property
    @pulumi.getter(name="jobInputType")
    def job_input_type(self) -> pulumi.Input[str]:
        """
        Enum to determine the Job Input Type.
        Expected value is 'mlflow_model'.
        """
        return pulumi.get(self, "job_input_type")

    @job_input_type.setter
    def job_input_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "job_input_type", value)

    @property
    @pulumi.getter
    def uri(self) -> pulumi.Input[str]:
        """
        [Required] Input Asset URI.
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: pulumi.Input[str]):
        pulumi.set(self, "uri", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description for the input.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[Union[str, 'InputDeliveryMode']]]:
        """
        Input Asset Delivery Mode.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[Union[str, 'InputDeliveryMode']]]):
        pulumi.set(self, "mode", value)


@pulumi.input_type
class MLFlowModelJobOutputArgs:
    def __init__(__self__, *,
                 job_output_type: pulumi.Input[str],
                 asset_name: Optional[pulumi.Input[str]] = None,
                 asset_version: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 mode: Optional[pulumi.Input[Union[str, 'OutputDeliveryMode']]] = None,
                 uri: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] job_output_type: Enum to determine the Job Output Type.
               Expected value is 'mlflow_model'.
        :param pulumi.Input[str] asset_name: Output Asset Name.
        :param pulumi.Input[str] asset_version: Output Asset Version.
        :param pulumi.Input[str] description: Description for the output.
        :param pulumi.Input[Union[str, 'OutputDeliveryMode']] mode: Output Asset Delivery Mode.
        :param pulumi.Input[str] uri: Output Asset URI.
        """
        pulumi.set(__self__, "job_output_type", 'mlflow_model')
        if asset_name is not None:
            pulumi.set(__self__, "asset_name", asset_name)
        if asset_version is not None:
            pulumi.set(__self__, "asset_version", asset_version)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if mode is None:
            mode = 'ReadWriteMount'
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter(name="jobOutputType")
    def job_output_type(self) -> pulumi.Input[str]:
        """
        Enum to determine the Job Output Type.
        Expected value is 'mlflow_model'.
        """
        return pulumi.get(self, "job_output_type")

    @job_output_type.setter
    def job_output_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "job_output_type", value)

    @property
    @pulumi.getter(name="assetName")
    def asset_name(self) -> Optional[pulumi.Input[str]]:
        """
        Output Asset Name.
        """
        return pulumi.get(self, "asset_name")

    @asset_name.setter
    def asset_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "asset_name", value)

    @property
    @pulumi.getter(name="assetVersion")
    def asset_version(self) -> Optional[pulumi.Input[str]]:
        """
        Output Asset Version.
        """
        return pulumi.get(self, "asset_version")

    @asset_version.setter
    def asset_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "asset_version", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description for the output.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[Union[str, 'OutputDeliveryMode']]]:
        """
        Output Asset Delivery Mode.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[Union[str, 'OutputDeliveryMode']]]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter
    def uri(self) -> Optional[pulumi.Input[str]]:
        """
        Output Asset URI.
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uri", value)


@pulumi.input_type
class MLTableDataArgs:
    def __init__(__self__, *,
                 data_type: pulumi.Input[str],
                 data_uri: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 is_anonymous: Optional[pulumi.Input[bool]] = None,
                 is_archived: Optional[pulumi.Input[bool]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 referenced_uris: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        MLTable data definition
        :param pulumi.Input[str] data_type: Enum to determine the type of data.
               Expected value is 'mltable'.
        :param pulumi.Input[str] data_uri: [Required] Uri of the data. Example: https://go.microsoft.com/fwlink/?linkid=2202330
        :param pulumi.Input[str] description: The asset description text.
        :param pulumi.Input[bool] is_anonymous: If the name version are system generated (anonymous registration).
        :param pulumi.Input[bool] is_archived: Is the asset archived?
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: The asset property dictionary.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] referenced_uris: Uris referenced in the MLTable definition (required for lineage)
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Tag dictionary. Tags can be added, removed, and updated.
        """
        pulumi.set(__self__, "data_type", 'mltable')
        pulumi.set(__self__, "data_uri", data_uri)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if is_anonymous is None:
            is_anonymous = False
        if is_anonymous is not None:
            pulumi.set(__self__, "is_anonymous", is_anonymous)
        if is_archived is None:
            is_archived = False
        if is_archived is not None:
            pulumi.set(__self__, "is_archived", is_archived)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if referenced_uris is not None:
            pulumi.set(__self__, "referenced_uris", referenced_uris)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="dataType")
    def data_type(self) -> pulumi.Input[str]:
        """
        Enum to determine the type of data.
        Expected value is 'mltable'.
        """
        return pulumi.get(self, "data_type")

    @data_type.setter
    def data_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "data_type", value)

    @property
    @pulumi.getter(name="dataUri")
    def data_uri(self) -> pulumi.Input[str]:
        """
        [Required] Uri of the data. Example: https://go.microsoft.com/fwlink/?linkid=2202330
        """
        return pulumi.get(self, "data_uri")

    @data_uri.setter
    def data_uri(self, value: pulumi.Input[str]):
        pulumi.set(self, "data_uri", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The asset description text.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="isAnonymous")
    def is_anonymous(self) -> Optional[pulumi.Input[bool]]:
        """
        If the name version are system generated (anonymous registration).
        """
        return pulumi.get(self, "is_anonymous")

    @is_anonymous.setter
    def is_anonymous(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_anonymous", value)

    @property
    @pulumi.getter(name="isArchived")
    def is_archived(self) -> Optional[pulumi.Input[bool]]:
        """
        Is the asset archived?
        """
        return pulumi.get(self, "is_archived")

    @is_archived.setter
    def is_archived(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_archived", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The asset property dictionary.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter(name="referencedUris")
    def referenced_uris(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Uris referenced in the MLTable definition (required for lineage)
        """
        return pulumi.get(self, "referenced_uris")

    @referenced_uris.setter
    def referenced_uris(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "referenced_uris", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Tag dictionary. Tags can be added, removed, and updated.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class MLTableJobInputArgs:
    def __init__(__self__, *,
                 job_input_type: pulumi.Input[str],
                 uri: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 mode: Optional[pulumi.Input[Union[str, 'InputDeliveryMode']]] = None):
        """
        :param pulumi.Input[str] job_input_type: Enum to determine the Job Input Type.
               Expected value is 'mltable'.
        :param pulumi.Input[str] uri: [Required] Input Asset URI.
        :param pulumi.Input[str] description: Description for the input.
        :param pulumi.Input[Union[str, 'InputDeliveryMode']] mode: Input Asset Delivery Mode.
        """
        pulumi.set(__self__, "job_input_type", 'mltable')
        pulumi.set(__self__, "uri", uri)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if mode is None:
            mode = 'ReadOnlyMount'
        if mode is not None:
            pulumi.set(__self__, "mode", mode)

    @property
    @pulumi.getter(name="jobInputType")
    def job_input_type(self) -> pulumi.Input[str]:
        """
        Enum to determine the Job Input Type.
        Expected value is 'mltable'.
        """
        return pulumi.get(self, "job_input_type")

    @job_input_type.setter
    def job_input_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "job_input_type", value)

    @property
    @pulumi.getter
    def uri(self) -> pulumi.Input[str]:
        """
        [Required] Input Asset URI.
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: pulumi.Input[str]):
        pulumi.set(self, "uri", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description for the input.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[Union[str, 'InputDeliveryMode']]]:
        """
        Input Asset Delivery Mode.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[Union[str, 'InputDeliveryMode']]]):
        pulumi.set(self, "mode", value)


@pulumi.input_type
class MLTableJobOutputArgs:
    def __init__(__self__, *,
                 job_output_type: pulumi.Input[str],
                 asset_name: Optional[pulumi.Input[str]] = None,
                 asset_version: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 mode: Optional[pulumi.Input[Union[str, 'OutputDeliveryMode']]] = None,
                 uri: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] job_output_type: Enum to determine the Job Output Type.
               Expected value is 'mltable'.
        :param pulumi.Input[str] asset_name: Output Asset Name.
        :param pulumi.Input[str] asset_version: Output Asset Version.
        :param pulumi.Input[str] description: Description for the output.
        :param pulumi.Input[Union[str, 'OutputDeliveryMode']] mode: Output Asset Delivery Mode.
        :param pulumi.Input[str] uri: Output Asset URI.
        """
        pulumi.set(__self__, "job_output_type", 'mltable')
        if asset_name is not None:
            pulumi.set(__self__, "asset_name", asset_name)
        if asset_version is not None:
            pulumi.set(__self__, "asset_version", asset_version)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if mode is None:
            mode = 'ReadWriteMount'
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter(name="jobOutputType")
    def job_output_type(self) -> pulumi.Input[str]:
        """
        Enum to determine the Job Output Type.
        Expected value is 'mltable'.
        """
        return pulumi.get(self, "job_output_type")

    @job_output_type.setter
    def job_output_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "job_output_type", value)

    @property
    @pulumi.getter(name="assetName")
    def asset_name(self) -> Optional[pulumi.Input[str]]:
        """
        Output Asset Name.
        """
        return pulumi.get(self, "asset_name")

    @asset_name.setter
    def asset_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "asset_name", value)

    @property
    @pulumi.getter(name="assetVersion")
    def asset_version(self) -> Optional[pulumi.Input[str]]:
        """
        Output Asset Version.
        """
        return pulumi.get(self, "asset_version")

    @asset_version.setter
    def asset_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "asset_version", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description for the output.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[Union[str, 'OutputDeliveryMode']]]:
        """
        Output Asset Delivery Mode.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[Union[str, 'OutputDeliveryMode']]]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter
    def uri(self) -> Optional[pulumi.Input[str]]:
        """
        Output Asset URI.
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uri", value)


@pulumi.input_type
class ManagedIdentityAuthTypeWorkspaceConnectionPropertiesArgs:
    def __init__(__self__, *,
                 auth_type: pulumi.Input[str],
                 category: Optional[pulumi.Input[Union[str, 'ConnectionCategory']]] = None,
                 credentials: Optional[pulumi.Input['WorkspaceConnectionManagedIdentityArgs']] = None,
                 target: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None,
                 value_format: Optional[pulumi.Input[Union[str, 'ValueFormat']]] = None):
        """
        :param pulumi.Input[str] auth_type: Authentication type of the connection target
               Expected value is 'ManagedIdentity'.
        :param pulumi.Input[Union[str, 'ConnectionCategory']] category: Category of the connection
        :param pulumi.Input[str] value: Value details of the workspace connection.
        :param pulumi.Input[Union[str, 'ValueFormat']] value_format: format for the workspace connection value
        """
        pulumi.set(__self__, "auth_type", 'ManagedIdentity')
        if category is not None:
            pulumi.set(__self__, "category", category)
        if credentials is not None:
            pulumi.set(__self__, "credentials", credentials)
        if target is not None:
            pulumi.set(__self__, "target", target)
        if value is not None:
            pulumi.set(__self__, "value", value)
        if value_format is not None:
            pulumi.set(__self__, "value_format", value_format)

    @property
    @pulumi.getter(name="authType")
    def auth_type(self) -> pulumi.Input[str]:
        """
        Authentication type of the connection target
        Expected value is 'ManagedIdentity'.
        """
        return pulumi.get(self, "auth_type")

    @auth_type.setter
    def auth_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "auth_type", value)

    @property
    @pulumi.getter
    def category(self) -> Optional[pulumi.Input[Union[str, 'ConnectionCategory']]]:
        """
        Category of the connection
        """
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: Optional[pulumi.Input[Union[str, 'ConnectionCategory']]]):
        pulumi.set(self, "category", value)

    @property
    @pulumi.getter
    def credentials(self) -> Optional[pulumi.Input['WorkspaceConnectionManagedIdentityArgs']]:
        return pulumi.get(self, "credentials")

    @credentials.setter
    def credentials(self, value: Optional[pulumi.Input['WorkspaceConnectionManagedIdentityArgs']]):
        pulumi.set(self, "credentials", value)

    @property
    @pulumi.getter
    def target(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        Value details of the workspace connection.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter(name="valueFormat")
    def value_format(self) -> Optional[pulumi.Input[Union[str, 'ValueFormat']]]:
        """
        format for the workspace connection value
        """
        return pulumi.get(self, "value_format")

    @value_format.setter
    def value_format(self, value: Optional[pulumi.Input[Union[str, 'ValueFormat']]]):
        pulumi.set(self, "value_format", value)


@pulumi.input_type
class ManagedIdentityArgs:
    def __init__(__self__, *,
                 identity_type: pulumi.Input[str],
                 client_id: Optional[pulumi.Input[str]] = None,
                 object_id: Optional[pulumi.Input[str]] = None,
                 resource_id: Optional[pulumi.Input[str]] = None):
        """
        Managed identity configuration.
        :param pulumi.Input[str] identity_type: Enum to determine identity framework.
               Expected value is 'Managed'.
        :param pulumi.Input[str] client_id: Specifies a user-assigned identity by client ID. For system-assigned, do not set this field.
        :param pulumi.Input[str] object_id: Specifies a user-assigned identity by object ID. For system-assigned, do not set this field.
        :param pulumi.Input[str] resource_id: Specifies a user-assigned identity by ARM resource ID. For system-assigned, do not set this field.
        """
        pulumi.set(__self__, "identity_type", 'Managed')
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if object_id is not None:
            pulumi.set(__self__, "object_id", object_id)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="identityType")
    def identity_type(self) -> pulumi.Input[str]:
        """
        Enum to determine identity framework.
        Expected value is 'Managed'.
        """
        return pulumi.get(self, "identity_type")

    @identity_type.setter
    def identity_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "identity_type", value)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a user-assigned identity by client ID. For system-assigned, do not set this field.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="objectId")
    def object_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a user-assigned identity by object ID. For system-assigned, do not set this field.
        """
        return pulumi.get(self, "object_id")

    @object_id.setter
    def object_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "object_id", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a user-assigned identity by ARM resource ID. For system-assigned, do not set this field.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_id", value)


@pulumi.input_type
class ManagedOnlineDeploymentArgs:
    def __init__(__self__, *,
                 endpoint_compute_type: pulumi.Input[str],
                 app_insights_enabled: Optional[pulumi.Input[bool]] = None,
                 code_configuration: Optional[pulumi.Input['CodeConfigurationArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 egress_public_network_access: Optional[pulumi.Input[Union[str, 'EgressPublicNetworkAccessType']]] = None,
                 environment_id: Optional[pulumi.Input[str]] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 liveness_probe: Optional[pulumi.Input['ProbeSettingsArgs']] = None,
                 model: Optional[pulumi.Input[str]] = None,
                 model_mount_path: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 readiness_probe: Optional[pulumi.Input['ProbeSettingsArgs']] = None,
                 request_settings: Optional[pulumi.Input['OnlineRequestSettingsArgs']] = None,
                 scale_settings: Optional[pulumi.Input[Union['DefaultScaleSettingsArgs', 'TargetUtilizationScaleSettingsArgs']]] = None):
        """
        Properties specific to a ManagedOnlineDeployment.
        :param pulumi.Input[str] endpoint_compute_type: Enum to determine endpoint compute type.
               Expected value is 'Managed'.
        :param pulumi.Input[bool] app_insights_enabled: If true, enables Application Insights logging.
        :param pulumi.Input['CodeConfigurationArgs'] code_configuration: Code configuration for the endpoint deployment.
        :param pulumi.Input[str] description: Description of the endpoint deployment.
        :param pulumi.Input[Union[str, 'EgressPublicNetworkAccessType']] egress_public_network_access: If Enabled, allow egress public network access. If Disabled, this will create secure egress. Default: Enabled.
        :param pulumi.Input[str] environment_id: ARM resource ID of the environment specification for the endpoint deployment.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] environment_variables: Environment variables configuration for the deployment.
        :param pulumi.Input[str] instance_type: Compute instance type.
        :param pulumi.Input['ProbeSettingsArgs'] liveness_probe: Liveness probe monitors the health of the container regularly.
        :param pulumi.Input[str] model: The URI path to the model.
        :param pulumi.Input[str] model_mount_path: The path to mount the model in custom container.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: Property dictionary. Properties can be added, but not removed or altered.
        :param pulumi.Input['ProbeSettingsArgs'] readiness_probe: Readiness probe validates if the container is ready to serve traffic. The properties and defaults are the same as liveness probe.
        :param pulumi.Input['OnlineRequestSettingsArgs'] request_settings: Request settings for the deployment.
        :param pulumi.Input[Union['DefaultScaleSettingsArgs', 'TargetUtilizationScaleSettingsArgs']] scale_settings: Scale settings for the deployment.
               If it is null or not provided,
               it defaults to TargetUtilizationScaleSettings for KubernetesOnlineDeployment
               and to DefaultScaleSettings for ManagedOnlineDeployment.
        """
        pulumi.set(__self__, "endpoint_compute_type", 'Managed')
        if app_insights_enabled is None:
            app_insights_enabled = False
        if app_insights_enabled is not None:
            pulumi.set(__self__, "app_insights_enabled", app_insights_enabled)
        if code_configuration is not None:
            pulumi.set(__self__, "code_configuration", code_configuration)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if egress_public_network_access is None:
            egress_public_network_access = 'Enabled'
        if egress_public_network_access is not None:
            pulumi.set(__self__, "egress_public_network_access", egress_public_network_access)
        if environment_id is not None:
            pulumi.set(__self__, "environment_id", environment_id)
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if liveness_probe is not None:
            pulumi.set(__self__, "liveness_probe", liveness_probe)
        if model is not None:
            pulumi.set(__self__, "model", model)
        if model_mount_path is not None:
            pulumi.set(__self__, "model_mount_path", model_mount_path)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if readiness_probe is not None:
            pulumi.set(__self__, "readiness_probe", readiness_probe)
        if request_settings is not None:
            pulumi.set(__self__, "request_settings", request_settings)
        if scale_settings is not None:
            pulumi.set(__self__, "scale_settings", scale_settings)

    @property
    @pulumi.getter(name="endpointComputeType")
    def endpoint_compute_type(self) -> pulumi.Input[str]:
        """
        Enum to determine endpoint compute type.
        Expected value is 'Managed'.
        """
        return pulumi.get(self, "endpoint_compute_type")

    @endpoint_compute_type.setter
    def endpoint_compute_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "endpoint_compute_type", value)

    @property
    @pulumi.getter(name="appInsightsEnabled")
    def app_insights_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, enables Application Insights logging.
        """
        return pulumi.get(self, "app_insights_enabled")

    @app_insights_enabled.setter
    def app_insights_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "app_insights_enabled", value)

    @property
    @pulumi.getter(name="codeConfiguration")
    def code_configuration(self) -> Optional[pulumi.Input['CodeConfigurationArgs']]:
        """
        Code configuration for the endpoint deployment.
        """
        return pulumi.get(self, "code_configuration")

    @code_configuration.setter
    def code_configuration(self, value: Optional[pulumi.Input['CodeConfigurationArgs']]):
        pulumi.set(self, "code_configuration", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the endpoint deployment.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="egressPublicNetworkAccess")
    def egress_public_network_access(self) -> Optional[pulumi.Input[Union[str, 'EgressPublicNetworkAccessType']]]:
        """
        If Enabled, allow egress public network access. If Disabled, this will create secure egress. Default: Enabled.
        """
        return pulumi.get(self, "egress_public_network_access")

    @egress_public_network_access.setter
    def egress_public_network_access(self, value: Optional[pulumi.Input[Union[str, 'EgressPublicNetworkAccessType']]]):
        pulumi.set(self, "egress_public_network_access", value)

    @property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM resource ID of the environment specification for the endpoint deployment.
        """
        return pulumi.get(self, "environment_id")

    @environment_id.setter
    def environment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "environment_id", value)

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Environment variables configuration for the deployment.
        """
        return pulumi.get(self, "environment_variables")

    @environment_variables.setter
    def environment_variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "environment_variables", value)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[str]]:
        """
        Compute instance type.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="livenessProbe")
    def liveness_probe(self) -> Optional[pulumi.Input['ProbeSettingsArgs']]:
        """
        Liveness probe monitors the health of the container regularly.
        """
        return pulumi.get(self, "liveness_probe")

    @liveness_probe.setter
    def liveness_probe(self, value: Optional[pulumi.Input['ProbeSettingsArgs']]):
        pulumi.set(self, "liveness_probe", value)

    @property
    @pulumi.getter
    def model(self) -> Optional[pulumi.Input[str]]:
        """
        The URI path to the model.
        """
        return pulumi.get(self, "model")

    @model.setter
    def model(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "model", value)

    @property
    @pulumi.getter(name="modelMountPath")
    def model_mount_path(self) -> Optional[pulumi.Input[str]]:
        """
        The path to mount the model in custom container.
        """
        return pulumi.get(self, "model_mount_path")

    @model_mount_path.setter
    def model_mount_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "model_mount_path", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Property dictionary. Properties can be added, but not removed or altered.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter(name="readinessProbe")
    def readiness_probe(self) -> Optional[pulumi.Input['ProbeSettingsArgs']]:
        """
        Readiness probe validates if the container is ready to serve traffic. The properties and defaults are the same as liveness probe.
        """
        return pulumi.get(self, "readiness_probe")

    @readiness_probe.setter
    def readiness_probe(self, value: Optional[pulumi.Input['ProbeSettingsArgs']]):
        pulumi.set(self, "readiness_probe", value)

    @property
    @pulumi.getter(name="requestSettings")
    def request_settings(self) -> Optional[pulumi.Input['OnlineRequestSettingsArgs']]:
        """
        Request settings for the deployment.
        """
        return pulumi.get(self, "request_settings")

    @request_settings.setter
    def request_settings(self, value: Optional[pulumi.Input['OnlineRequestSettingsArgs']]):
        pulumi.set(self, "request_settings", value)

    @property
    @pulumi.getter(name="scaleSettings")
    def scale_settings(self) -> Optional[pulumi.Input[Union['DefaultScaleSettingsArgs', 'TargetUtilizationScaleSettingsArgs']]]:
        """
        Scale settings for the deployment.
        If it is null or not provided,
        it defaults to TargetUtilizationScaleSettings for KubernetesOnlineDeployment
        and to DefaultScaleSettings for ManagedOnlineDeployment.
        """
        return pulumi.get(self, "scale_settings")

    @scale_settings.setter
    def scale_settings(self, value: Optional[pulumi.Input[Union['DefaultScaleSettingsArgs', 'TargetUtilizationScaleSettingsArgs']]]):
        pulumi.set(self, "scale_settings", value)


@pulumi.input_type
class ManagedServiceIdentityArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[Union[str, 'ManagedServiceIdentityType']],
                 user_assigned_identities: Optional[pulumi.Input[Mapping[str, Any]]] = None):
        """
        Managed service identity (system assigned and/or user assigned identities)
        :param pulumi.Input[Union[str, 'ManagedServiceIdentityType']] type: Type of managed service identity (where both SystemAssigned and UserAssigned types are allowed).
        :param pulumi.Input[Mapping[str, Any]] user_assigned_identities: The set of user assigned identities associated with the resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}. The dictionary values can be empty objects ({}) in requests.
        """
        pulumi.set(__self__, "type", type)
        if user_assigned_identities is not None:
            pulumi.set(__self__, "user_assigned_identities", user_assigned_identities)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[Union[str, 'ManagedServiceIdentityType']]:
        """
        Type of managed service identity (where both SystemAssigned and UserAssigned types are allowed).
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[Union[str, 'ManagedServiceIdentityType']]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="userAssignedIdentities")
    def user_assigned_identities(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        The set of user assigned identities associated with the resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}. The dictionary values can be empty objects ({}) in requests.
        """
        return pulumi.get(self, "user_assigned_identities")

    @user_assigned_identities.setter
    def user_assigned_identities(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "user_assigned_identities", value)


@pulumi.input_type
class MedianStoppingPolicyArgs:
    def __init__(__self__, *,
                 policy_type: pulumi.Input[str],
                 delay_evaluation: Optional[pulumi.Input[int]] = None,
                 evaluation_interval: Optional[pulumi.Input[int]] = None):
        """
        Defines an early termination policy based on running averages of the primary metric of all runs
        :param pulumi.Input[str] policy_type: 
               Expected value is 'MedianStopping'.
        :param pulumi.Input[int] delay_evaluation: Number of intervals by which to delay the first evaluation.
        :param pulumi.Input[int] evaluation_interval: Interval (number of runs) between policy evaluations.
        """
        pulumi.set(__self__, "policy_type", 'MedianStopping')
        if delay_evaluation is None:
            delay_evaluation = 0
        if delay_evaluation is not None:
            pulumi.set(__self__, "delay_evaluation", delay_evaluation)
        if evaluation_interval is None:
            evaluation_interval = 0
        if evaluation_interval is not None:
            pulumi.set(__self__, "evaluation_interval", evaluation_interval)

    @property
    @pulumi.getter(name="policyType")
    def policy_type(self) -> pulumi.Input[str]:
        """

        Expected value is 'MedianStopping'.
        """
        return pulumi.get(self, "policy_type")

    @policy_type.setter
    def policy_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "policy_type", value)

    @property
    @pulumi.getter(name="delayEvaluation")
    def delay_evaluation(self) -> Optional[pulumi.Input[int]]:
        """
        Number of intervals by which to delay the first evaluation.
        """
        return pulumi.get(self, "delay_evaluation")

    @delay_evaluation.setter
    def delay_evaluation(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "delay_evaluation", value)

    @property
    @pulumi.getter(name="evaluationInterval")
    def evaluation_interval(self) -> Optional[pulumi.Input[int]]:
        """
        Interval (number of runs) between policy evaluations.
        """
        return pulumi.get(self, "evaluation_interval")

    @evaluation_interval.setter
    def evaluation_interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "evaluation_interval", value)


@pulumi.input_type
class ModelContainerArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 is_archived: Optional[pulumi.Input[bool]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] description: The asset description text.
        :param pulumi.Input[bool] is_archived: Is the asset archived?
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: The asset property dictionary.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Tag dictionary. Tags can be added, removed, and updated.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if is_archived is None:
            is_archived = False
        if is_archived is not None:
            pulumi.set(__self__, "is_archived", is_archived)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The asset description text.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="isArchived")
    def is_archived(self) -> Optional[pulumi.Input[bool]]:
        """
        Is the asset archived?
        """
        return pulumi.get(self, "is_archived")

    @is_archived.setter
    def is_archived(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_archived", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The asset property dictionary.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Tag dictionary. Tags can be added, removed, and updated.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class ModelVersionArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 flavors: Optional[pulumi.Input[Mapping[str, pulumi.Input['FlavorDataArgs']]]] = None,
                 is_anonymous: Optional[pulumi.Input[bool]] = None,
                 is_archived: Optional[pulumi.Input[bool]] = None,
                 job_name: Optional[pulumi.Input[str]] = None,
                 model_type: Optional[pulumi.Input[str]] = None,
                 model_uri: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Model asset version details.
        :param pulumi.Input[str] description: The asset description text.
        :param pulumi.Input[Mapping[str, pulumi.Input['FlavorDataArgs']]] flavors: Mapping of model flavors to their properties.
        :param pulumi.Input[bool] is_anonymous: If the name version are system generated (anonymous registration).
        :param pulumi.Input[bool] is_archived: Is the asset archived?
        :param pulumi.Input[str] job_name: Name of the training job which produced this model
        :param pulumi.Input[str] model_type: The storage format for this entity. Used for NCD.
        :param pulumi.Input[str] model_uri: The URI path to the model contents.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: The asset property dictionary.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Tag dictionary. Tags can be added, removed, and updated.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if flavors is not None:
            pulumi.set(__self__, "flavors", flavors)
        if is_anonymous is None:
            is_anonymous = False
        if is_anonymous is not None:
            pulumi.set(__self__, "is_anonymous", is_anonymous)
        if is_archived is None:
            is_archived = False
        if is_archived is not None:
            pulumi.set(__self__, "is_archived", is_archived)
        if job_name is not None:
            pulumi.set(__self__, "job_name", job_name)
        if model_type is not None:
            pulumi.set(__self__, "model_type", model_type)
        if model_uri is not None:
            pulumi.set(__self__, "model_uri", model_uri)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The asset description text.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def flavors(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['FlavorDataArgs']]]]:
        """
        Mapping of model flavors to their properties.
        """
        return pulumi.get(self, "flavors")

    @flavors.setter
    def flavors(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['FlavorDataArgs']]]]):
        pulumi.set(self, "flavors", value)

    @property
    @pulumi.getter(name="isAnonymous")
    def is_anonymous(self) -> Optional[pulumi.Input[bool]]:
        """
        If the name version are system generated (anonymous registration).
        """
        return pulumi.get(self, "is_anonymous")

    @is_anonymous.setter
    def is_anonymous(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_anonymous", value)

    @property
    @pulumi.getter(name="isArchived")
    def is_archived(self) -> Optional[pulumi.Input[bool]]:
        """
        Is the asset archived?
        """
        return pulumi.get(self, "is_archived")

    @is_archived.setter
    def is_archived(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_archived", value)

    @property
    @pulumi.getter(name="jobName")
    def job_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the training job which produced this model
        """
        return pulumi.get(self, "job_name")

    @job_name.setter
    def job_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "job_name", value)

    @property
    @pulumi.getter(name="modelType")
    def model_type(self) -> Optional[pulumi.Input[str]]:
        """
        The storage format for this entity. Used for NCD.
        """
        return pulumi.get(self, "model_type")

    @model_type.setter
    def model_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "model_type", value)

    @property
    @pulumi.getter(name="modelUri")
    def model_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The URI path to the model contents.
        """
        return pulumi.get(self, "model_uri")

    @model_uri.setter
    def model_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "model_uri", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The asset property dictionary.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Tag dictionary. Tags can be added, removed, and updated.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class MpiArgs:
    def __init__(__self__, *,
                 distribution_type: pulumi.Input[str],
                 process_count_per_instance: Optional[pulumi.Input[int]] = None):
        """
        MPI distribution configuration.
        :param pulumi.Input[str] distribution_type: Enum to determine the job distribution type.
               Expected value is 'Mpi'.
        :param pulumi.Input[int] process_count_per_instance: Number of processes per MPI node.
        """
        pulumi.set(__self__, "distribution_type", 'Mpi')
        if process_count_per_instance is not None:
            pulumi.set(__self__, "process_count_per_instance", process_count_per_instance)

    @property
    @pulumi.getter(name="distributionType")
    def distribution_type(self) -> pulumi.Input[str]:
        """
        Enum to determine the job distribution type.
        Expected value is 'Mpi'.
        """
        return pulumi.get(self, "distribution_type")

    @distribution_type.setter
    def distribution_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "distribution_type", value)

    @property
    @pulumi.getter(name="processCountPerInstance")
    def process_count_per_instance(self) -> Optional[pulumi.Input[int]]:
        """
        Number of processes per MPI node.
        """
        return pulumi.get(self, "process_count_per_instance")

    @process_count_per_instance.setter
    def process_count_per_instance(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "process_count_per_instance", value)


@pulumi.input_type
class NlpFixedParametersArgs:
    def __init__(__self__, *,
                 gradient_accumulation_steps: Optional[pulumi.Input[int]] = None,
                 learning_rate: Optional[pulumi.Input[float]] = None,
                 learning_rate_scheduler: Optional[pulumi.Input[Union[str, 'NlpLearningRateScheduler']]] = None,
                 model_name: Optional[pulumi.Input[str]] = None,
                 number_of_epochs: Optional[pulumi.Input[int]] = None,
                 training_batch_size: Optional[pulumi.Input[int]] = None,
                 validation_batch_size: Optional[pulumi.Input[int]] = None,
                 warmup_ratio: Optional[pulumi.Input[float]] = None,
                 weight_decay: Optional[pulumi.Input[float]] = None):
        """
        Fixed training parameters that won't be swept over during AutoML NLP training.
        :param pulumi.Input[int] gradient_accumulation_steps: Number of steps to accumulate gradients over before running a backward pass.
        :param pulumi.Input[float] learning_rate: The learning rate for the training procedure.
        :param pulumi.Input[Union[str, 'NlpLearningRateScheduler']] learning_rate_scheduler: The type of learning rate schedule to use during the training procedure.
        :param pulumi.Input[str] model_name: The name of the model to train.
        :param pulumi.Input[int] number_of_epochs: Number of training epochs.
        :param pulumi.Input[int] training_batch_size: The batch size for the training procedure.
        :param pulumi.Input[int] validation_batch_size: The batch size to be used during evaluation.
        :param pulumi.Input[float] warmup_ratio: The warmup ratio, used alongside LrSchedulerType.
        :param pulumi.Input[float] weight_decay: The weight decay for the training procedure.
        """
        if gradient_accumulation_steps is not None:
            pulumi.set(__self__, "gradient_accumulation_steps", gradient_accumulation_steps)
        if learning_rate is not None:
            pulumi.set(__self__, "learning_rate", learning_rate)
        if learning_rate_scheduler is None:
            learning_rate_scheduler = 'None'
        if learning_rate_scheduler is not None:
            pulumi.set(__self__, "learning_rate_scheduler", learning_rate_scheduler)
        if model_name is not None:
            pulumi.set(__self__, "model_name", model_name)
        if number_of_epochs is not None:
            pulumi.set(__self__, "number_of_epochs", number_of_epochs)
        if training_batch_size is not None:
            pulumi.set(__self__, "training_batch_size", training_batch_size)
        if validation_batch_size is not None:
            pulumi.set(__self__, "validation_batch_size", validation_batch_size)
        if warmup_ratio is not None:
            pulumi.set(__self__, "warmup_ratio", warmup_ratio)
        if weight_decay is not None:
            pulumi.set(__self__, "weight_decay", weight_decay)

    @property
    @pulumi.getter(name="gradientAccumulationSteps")
    def gradient_accumulation_steps(self) -> Optional[pulumi.Input[int]]:
        """
        Number of steps to accumulate gradients over before running a backward pass.
        """
        return pulumi.get(self, "gradient_accumulation_steps")

    @gradient_accumulation_steps.setter
    def gradient_accumulation_steps(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "gradient_accumulation_steps", value)

    @property
    @pulumi.getter(name="learningRate")
    def learning_rate(self) -> Optional[pulumi.Input[float]]:
        """
        The learning rate for the training procedure.
        """
        return pulumi.get(self, "learning_rate")

    @learning_rate.setter
    def learning_rate(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "learning_rate", value)

    @property
    @pulumi.getter(name="learningRateScheduler")
    def learning_rate_scheduler(self) -> Optional[pulumi.Input[Union[str, 'NlpLearningRateScheduler']]]:
        """
        The type of learning rate schedule to use during the training procedure.
        """
        return pulumi.get(self, "learning_rate_scheduler")

    @learning_rate_scheduler.setter
    def learning_rate_scheduler(self, value: Optional[pulumi.Input[Union[str, 'NlpLearningRateScheduler']]]):
        pulumi.set(self, "learning_rate_scheduler", value)

    @property
    @pulumi.getter(name="modelName")
    def model_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the model to train.
        """
        return pulumi.get(self, "model_name")

    @model_name.setter
    def model_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "model_name", value)

    @property
    @pulumi.getter(name="numberOfEpochs")
    def number_of_epochs(self) -> Optional[pulumi.Input[int]]:
        """
        Number of training epochs.
        """
        return pulumi.get(self, "number_of_epochs")

    @number_of_epochs.setter
    def number_of_epochs(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "number_of_epochs", value)

    @property
    @pulumi.getter(name="trainingBatchSize")
    def training_batch_size(self) -> Optional[pulumi.Input[int]]:
        """
        The batch size for the training procedure.
        """
        return pulumi.get(self, "training_batch_size")

    @training_batch_size.setter
    def training_batch_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "training_batch_size", value)

    @property
    @pulumi.getter(name="validationBatchSize")
    def validation_batch_size(self) -> Optional[pulumi.Input[int]]:
        """
        The batch size to be used during evaluation.
        """
        return pulumi.get(self, "validation_batch_size")

    @validation_batch_size.setter
    def validation_batch_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "validation_batch_size", value)

    @property
    @pulumi.getter(name="warmupRatio")
    def warmup_ratio(self) -> Optional[pulumi.Input[float]]:
        """
        The warmup ratio, used alongside LrSchedulerType.
        """
        return pulumi.get(self, "warmup_ratio")

    @warmup_ratio.setter
    def warmup_ratio(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "warmup_ratio", value)

    @property
    @pulumi.getter(name="weightDecay")
    def weight_decay(self) -> Optional[pulumi.Input[float]]:
        """
        The weight decay for the training procedure.
        """
        return pulumi.get(self, "weight_decay")

    @weight_decay.setter
    def weight_decay(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "weight_decay", value)


@pulumi.input_type
class NlpParameterSubspaceArgs:
    def __init__(__self__, *,
                 gradient_accumulation_steps: Optional[pulumi.Input[str]] = None,
                 learning_rate: Optional[pulumi.Input[str]] = None,
                 learning_rate_scheduler: Optional[pulumi.Input[str]] = None,
                 model_name: Optional[pulumi.Input[str]] = None,
                 number_of_epochs: Optional[pulumi.Input[str]] = None,
                 training_batch_size: Optional[pulumi.Input[str]] = None,
                 validation_batch_size: Optional[pulumi.Input[str]] = None,
                 warmup_ratio: Optional[pulumi.Input[str]] = None,
                 weight_decay: Optional[pulumi.Input[str]] = None):
        """
        Stringified search spaces for each parameter. See below examples.
        :param pulumi.Input[str] gradient_accumulation_steps: Number of steps to accumulate gradients over before running a backward pass.
        :param pulumi.Input[str] learning_rate: The learning rate for the training procedure.
        :param pulumi.Input[str] learning_rate_scheduler: The type of learning rate schedule to use during the training procedure.
        :param pulumi.Input[str] model_name: The name of the model to train.
        :param pulumi.Input[str] number_of_epochs: Number of training epochs.
        :param pulumi.Input[str] training_batch_size: The batch size for the training procedure.
        :param pulumi.Input[str] validation_batch_size: The batch size to be used during evaluation.
        :param pulumi.Input[str] warmup_ratio: The warmup ratio, used alongside LrSchedulerType.
        :param pulumi.Input[str] weight_decay: The weight decay for the training procedure.
        """
        if gradient_accumulation_steps is not None:
            pulumi.set(__self__, "gradient_accumulation_steps", gradient_accumulation_steps)
        if learning_rate is not None:
            pulumi.set(__self__, "learning_rate", learning_rate)
        if learning_rate_scheduler is not None:
            pulumi.set(__self__, "learning_rate_scheduler", learning_rate_scheduler)
        if model_name is not None:
            pulumi.set(__self__, "model_name", model_name)
        if number_of_epochs is not None:
            pulumi.set(__self__, "number_of_epochs", number_of_epochs)
        if training_batch_size is not None:
            pulumi.set(__self__, "training_batch_size", training_batch_size)
        if validation_batch_size is not None:
            pulumi.set(__self__, "validation_batch_size", validation_batch_size)
        if warmup_ratio is not None:
            pulumi.set(__self__, "warmup_ratio", warmup_ratio)
        if weight_decay is not None:
            pulumi.set(__self__, "weight_decay", weight_decay)

    @property
    @pulumi.getter(name="gradientAccumulationSteps")
    def gradient_accumulation_steps(self) -> Optional[pulumi.Input[str]]:
        """
        Number of steps to accumulate gradients over before running a backward pass.
        """
        return pulumi.get(self, "gradient_accumulation_steps")

    @gradient_accumulation_steps.setter
    def gradient_accumulation_steps(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gradient_accumulation_steps", value)

    @property
    @pulumi.getter(name="learningRate")
    def learning_rate(self) -> Optional[pulumi.Input[str]]:
        """
        The learning rate for the training procedure.
        """
        return pulumi.get(self, "learning_rate")

    @learning_rate.setter
    def learning_rate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "learning_rate", value)

    @property
    @pulumi.getter(name="learningRateScheduler")
    def learning_rate_scheduler(self) -> Optional[pulumi.Input[str]]:
        """
        The type of learning rate schedule to use during the training procedure.
        """
        return pulumi.get(self, "learning_rate_scheduler")

    @learning_rate_scheduler.setter
    def learning_rate_scheduler(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "learning_rate_scheduler", value)

    @property
    @pulumi.getter(name="modelName")
    def model_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the model to train.
        """
        return pulumi.get(self, "model_name")

    @model_name.setter
    def model_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "model_name", value)

    @property
    @pulumi.getter(name="numberOfEpochs")
    def number_of_epochs(self) -> Optional[pulumi.Input[str]]:
        """
        Number of training epochs.
        """
        return pulumi.get(self, "number_of_epochs")

    @number_of_epochs.setter
    def number_of_epochs(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "number_of_epochs", value)

    @property
    @pulumi.getter(name="trainingBatchSize")
    def training_batch_size(self) -> Optional[pulumi.Input[str]]:
        """
        The batch size for the training procedure.
        """
        return pulumi.get(self, "training_batch_size")

    @training_batch_size.setter
    def training_batch_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "training_batch_size", value)

    @property
    @pulumi.getter(name="validationBatchSize")
    def validation_batch_size(self) -> Optional[pulumi.Input[str]]:
        """
        The batch size to be used during evaluation.
        """
        return pulumi.get(self, "validation_batch_size")

    @validation_batch_size.setter
    def validation_batch_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "validation_batch_size", value)

    @property
    @pulumi.getter(name="warmupRatio")
    def warmup_ratio(self) -> Optional[pulumi.Input[str]]:
        """
        The warmup ratio, used alongside LrSchedulerType.
        """
        return pulumi.get(self, "warmup_ratio")

    @warmup_ratio.setter
    def warmup_ratio(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "warmup_ratio", value)

    @property
    @pulumi.getter(name="weightDecay")
    def weight_decay(self) -> Optional[pulumi.Input[str]]:
        """
        The weight decay for the training procedure.
        """
        return pulumi.get(self, "weight_decay")

    @weight_decay.setter
    def weight_decay(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "weight_decay", value)


@pulumi.input_type
class NlpSweepSettingsArgs:
    def __init__(__self__, *,
                 sampling_algorithm: pulumi.Input[Union[str, 'SamplingAlgorithmType']],
                 early_termination: Optional[pulumi.Input[Union['BanditPolicyArgs', 'MedianStoppingPolicyArgs', 'TruncationSelectionPolicyArgs']]] = None):
        """
        Model sweeping and hyperparameter tuning related settings.
        :param pulumi.Input[Union[str, 'SamplingAlgorithmType']] sampling_algorithm: [Required] Type of sampling algorithm.
        :param pulumi.Input[Union['BanditPolicyArgs', 'MedianStoppingPolicyArgs', 'TruncationSelectionPolicyArgs']] early_termination: Type of early termination policy for the sweeping job.
        """
        pulumi.set(__self__, "sampling_algorithm", sampling_algorithm)
        if early_termination is not None:
            pulumi.set(__self__, "early_termination", early_termination)

    @property
    @pulumi.getter(name="samplingAlgorithm")
    def sampling_algorithm(self) -> pulumi.Input[Union[str, 'SamplingAlgorithmType']]:
        """
        [Required] Type of sampling algorithm.
        """
        return pulumi.get(self, "sampling_algorithm")

    @sampling_algorithm.setter
    def sampling_algorithm(self, value: pulumi.Input[Union[str, 'SamplingAlgorithmType']]):
        pulumi.set(self, "sampling_algorithm", value)

    @property
    @pulumi.getter(name="earlyTermination")
    def early_termination(self) -> Optional[pulumi.Input[Union['BanditPolicyArgs', 'MedianStoppingPolicyArgs', 'TruncationSelectionPolicyArgs']]]:
        """
        Type of early termination policy for the sweeping job.
        """
        return pulumi.get(self, "early_termination")

    @early_termination.setter
    def early_termination(self, value: Optional[pulumi.Input[Union['BanditPolicyArgs', 'MedianStoppingPolicyArgs', 'TruncationSelectionPolicyArgs']]]):
        pulumi.set(self, "early_termination", value)


@pulumi.input_type
class NlpVerticalFeaturizationSettingsArgs:
    def __init__(__self__, *,
                 dataset_language: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] dataset_language: Dataset language, useful for the text data.
        """
        if dataset_language is not None:
            pulumi.set(__self__, "dataset_language", dataset_language)

    @property
    @pulumi.getter(name="datasetLanguage")
    def dataset_language(self) -> Optional[pulumi.Input[str]]:
        """
        Dataset language, useful for the text data.
        """
        return pulumi.get(self, "dataset_language")

    @dataset_language.setter
    def dataset_language(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dataset_language", value)


@pulumi.input_type
class NlpVerticalLimitSettingsArgs:
    def __init__(__self__, *,
                 max_concurrent_trials: Optional[pulumi.Input[int]] = None,
                 max_nodes: Optional[pulumi.Input[int]] = None,
                 max_trials: Optional[pulumi.Input[int]] = None,
                 timeout: Optional[pulumi.Input[str]] = None,
                 trial_timeout: Optional[pulumi.Input[str]] = None):
        """
        Job execution constraints.
        :param pulumi.Input[int] max_concurrent_trials: Maximum Concurrent AutoML iterations.
        :param pulumi.Input[int] max_nodes: Maximum nodes to use for the experiment.
        :param pulumi.Input[int] max_trials: Number of AutoML iterations.
        :param pulumi.Input[str] timeout: AutoML job timeout.
        :param pulumi.Input[str] trial_timeout: Timeout for individual HD trials.
        """
        if max_concurrent_trials is None:
            max_concurrent_trials = 1
        if max_concurrent_trials is not None:
            pulumi.set(__self__, "max_concurrent_trials", max_concurrent_trials)
        if max_nodes is None:
            max_nodes = 1
        if max_nodes is not None:
            pulumi.set(__self__, "max_nodes", max_nodes)
        if max_trials is None:
            max_trials = 1
        if max_trials is not None:
            pulumi.set(__self__, "max_trials", max_trials)
        if timeout is None:
            timeout = 'P7D'
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if trial_timeout is not None:
            pulumi.set(__self__, "trial_timeout", trial_timeout)

    @property
    @pulumi.getter(name="maxConcurrentTrials")
    def max_concurrent_trials(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum Concurrent AutoML iterations.
        """
        return pulumi.get(self, "max_concurrent_trials")

    @max_concurrent_trials.setter
    def max_concurrent_trials(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_concurrent_trials", value)

    @property
    @pulumi.getter(name="maxNodes")
    def max_nodes(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum nodes to use for the experiment.
        """
        return pulumi.get(self, "max_nodes")

    @max_nodes.setter
    def max_nodes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_nodes", value)

    @property
    @pulumi.getter(name="maxTrials")
    def max_trials(self) -> Optional[pulumi.Input[int]]:
        """
        Number of AutoML iterations.
        """
        return pulumi.get(self, "max_trials")

    @max_trials.setter
    def max_trials(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_trials", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[str]]:
        """
        AutoML job timeout.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timeout", value)

    @property
    @pulumi.getter(name="trialTimeout")
    def trial_timeout(self) -> Optional[pulumi.Input[str]]:
        """
        Timeout for individual HD trials.
        """
        return pulumi.get(self, "trial_timeout")

    @trial_timeout.setter
    def trial_timeout(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "trial_timeout", value)


@pulumi.input_type
class NoneAuthTypeWorkspaceConnectionPropertiesArgs:
    def __init__(__self__, *,
                 auth_type: pulumi.Input[str],
                 category: Optional[pulumi.Input[Union[str, 'ConnectionCategory']]] = None,
                 target: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None,
                 value_format: Optional[pulumi.Input[Union[str, 'ValueFormat']]] = None):
        """
        :param pulumi.Input[str] auth_type: Authentication type of the connection target
               Expected value is 'None'.
        :param pulumi.Input[Union[str, 'ConnectionCategory']] category: Category of the connection
        :param pulumi.Input[str] value: Value details of the workspace connection.
        :param pulumi.Input[Union[str, 'ValueFormat']] value_format: format for the workspace connection value
        """
        pulumi.set(__self__, "auth_type", 'None')
        if category is not None:
            pulumi.set(__self__, "category", category)
        if target is not None:
            pulumi.set(__self__, "target", target)
        if value is not None:
            pulumi.set(__self__, "value", value)
        if value_format is not None:
            pulumi.set(__self__, "value_format", value_format)

    @property
    @pulumi.getter(name="authType")
    def auth_type(self) -> pulumi.Input[str]:
        """
        Authentication type of the connection target
        Expected value is 'None'.
        """
        return pulumi.get(self, "auth_type")

    @auth_type.setter
    def auth_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "auth_type", value)

    @property
    @pulumi.getter
    def category(self) -> Optional[pulumi.Input[Union[str, 'ConnectionCategory']]]:
        """
        Category of the connection
        """
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: Optional[pulumi.Input[Union[str, 'ConnectionCategory']]]):
        pulumi.set(self, "category", value)

    @property
    @pulumi.getter
    def target(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        Value details of the workspace connection.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter(name="valueFormat")
    def value_format(self) -> Optional[pulumi.Input[Union[str, 'ValueFormat']]]:
        """
        format for the workspace connection value
        """
        return pulumi.get(self, "value_format")

    @value_format.setter
    def value_format(self, value: Optional[pulumi.Input[Union[str, 'ValueFormat']]]):
        pulumi.set(self, "value_format", value)


@pulumi.input_type
class NoneDatastoreCredentialsArgs:
    def __init__(__self__, *,
                 credentials_type: pulumi.Input[str]):
        """
        Empty/none datastore credentials.
        :param pulumi.Input[str] credentials_type: Enum to determine the datastore credentials type.
               Expected value is 'None'.
        """
        pulumi.set(__self__, "credentials_type", 'None')

    @property
    @pulumi.getter(name="credentialsType")
    def credentials_type(self) -> pulumi.Input[str]:
        """
        Enum to determine the datastore credentials type.
        Expected value is 'None'.
        """
        return pulumi.get(self, "credentials_type")

    @credentials_type.setter
    def credentials_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "credentials_type", value)


@pulumi.input_type
class ObjectiveArgs:
    def __init__(__self__, *,
                 goal: pulumi.Input[Union[str, 'Goal']],
                 primary_metric: pulumi.Input[str]):
        """
        Optimization objective.
        :param pulumi.Input[Union[str, 'Goal']] goal: [Required] Defines supported metric goals for hyperparameter tuning
        :param pulumi.Input[str] primary_metric: [Required] Name of the metric to optimize.
        """
        pulumi.set(__self__, "goal", goal)
        pulumi.set(__self__, "primary_metric", primary_metric)

    @property
    @pulumi.getter
    def goal(self) -> pulumi.Input[Union[str, 'Goal']]:
        """
        [Required] Defines supported metric goals for hyperparameter tuning
        """
        return pulumi.get(self, "goal")

    @goal.setter
    def goal(self, value: pulumi.Input[Union[str, 'Goal']]):
        pulumi.set(self, "goal", value)

    @property
    @pulumi.getter(name="primaryMetric")
    def primary_metric(self) -> pulumi.Input[str]:
        """
        [Required] Name of the metric to optimize.
        """
        return pulumi.get(self, "primary_metric")

    @primary_metric.setter
    def primary_metric(self, value: pulumi.Input[str]):
        pulumi.set(self, "primary_metric", value)


@pulumi.input_type
class OnlineEndpointArgs:
    def __init__(__self__, *,
                 auth_mode: pulumi.Input[Union[str, 'EndpointAuthMode']],
                 compute: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 keys: Optional[pulumi.Input['EndpointAuthKeysArgs']] = None,
                 mirror_traffic: Optional[pulumi.Input[Mapping[str, pulumi.Input[int]]]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 public_network_access: Optional[pulumi.Input[Union[str, 'PublicNetworkAccessType']]] = None,
                 traffic: Optional[pulumi.Input[Mapping[str, pulumi.Input[int]]]] = None):
        """
        Online endpoint configuration
        :param pulumi.Input[Union[str, 'EndpointAuthMode']] auth_mode: [Required] Use 'Key' for key based authentication and 'AMLToken' for Azure Machine Learning token-based authentication. 'Key' doesn't expire but 'AMLToken' does.
        :param pulumi.Input[str] compute: ARM resource ID of the compute if it exists.
               optional
        :param pulumi.Input[str] description: Description of the inference endpoint.
        :param pulumi.Input['EndpointAuthKeysArgs'] keys: EndpointAuthKeys to set initially on an Endpoint.
               This property will always be returned as null. AuthKey values must be retrieved using the ListKeys API.
        :param pulumi.Input[Mapping[str, pulumi.Input[int]]] mirror_traffic: Percentage of traffic to be mirrored to each deployment without using returned scoring. Traffic values need to sum to utmost 50.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: Property dictionary. Properties can be added, but not removed or altered.
        :param pulumi.Input[Union[str, 'PublicNetworkAccessType']] public_network_access: Set to "Enabled" for endpoints that should allow public access when Private Link is enabled.
        :param pulumi.Input[Mapping[str, pulumi.Input[int]]] traffic: Percentage of traffic from endpoint to divert to each deployment. Traffic values need to sum to 100.
        """
        pulumi.set(__self__, "auth_mode", auth_mode)
        if compute is not None:
            pulumi.set(__self__, "compute", compute)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if keys is not None:
            pulumi.set(__self__, "keys", keys)
        if mirror_traffic is not None:
            pulumi.set(__self__, "mirror_traffic", mirror_traffic)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if public_network_access is None:
            public_network_access = 'Enabled'
        if public_network_access is not None:
            pulumi.set(__self__, "public_network_access", public_network_access)
        if traffic is not None:
            pulumi.set(__self__, "traffic", traffic)

    @property
    @pulumi.getter(name="authMode")
    def auth_mode(self) -> pulumi.Input[Union[str, 'EndpointAuthMode']]:
        """
        [Required] Use 'Key' for key based authentication and 'AMLToken' for Azure Machine Learning token-based authentication. 'Key' doesn't expire but 'AMLToken' does.
        """
        return pulumi.get(self, "auth_mode")

    @auth_mode.setter
    def auth_mode(self, value: pulumi.Input[Union[str, 'EndpointAuthMode']]):
        pulumi.set(self, "auth_mode", value)

    @property
    @pulumi.getter
    def compute(self) -> Optional[pulumi.Input[str]]:
        """
        ARM resource ID of the compute if it exists.
        optional
        """
        return pulumi.get(self, "compute")

    @compute.setter
    def compute(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compute", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the inference endpoint.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def keys(self) -> Optional[pulumi.Input['EndpointAuthKeysArgs']]:
        """
        EndpointAuthKeys to set initially on an Endpoint.
        This property will always be returned as null. AuthKey values must be retrieved using the ListKeys API.
        """
        return pulumi.get(self, "keys")

    @keys.setter
    def keys(self, value: Optional[pulumi.Input['EndpointAuthKeysArgs']]):
        pulumi.set(self, "keys", value)

    @property
    @pulumi.getter(name="mirrorTraffic")
    def mirror_traffic(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[int]]]]:
        """
        Percentage of traffic to be mirrored to each deployment without using returned scoring. Traffic values need to sum to utmost 50.
        """
        return pulumi.get(self, "mirror_traffic")

    @mirror_traffic.setter
    def mirror_traffic(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[int]]]]):
        pulumi.set(self, "mirror_traffic", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Property dictionary. Properties can be added, but not removed or altered.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter(name="publicNetworkAccess")
    def public_network_access(self) -> Optional[pulumi.Input[Union[str, 'PublicNetworkAccessType']]]:
        """
        Set to "Enabled" for endpoints that should allow public access when Private Link is enabled.
        """
        return pulumi.get(self, "public_network_access")

    @public_network_access.setter
    def public_network_access(self, value: Optional[pulumi.Input[Union[str, 'PublicNetworkAccessType']]]):
        pulumi.set(self, "public_network_access", value)

    @property
    @pulumi.getter
    def traffic(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[int]]]]:
        """
        Percentage of traffic from endpoint to divert to each deployment. Traffic values need to sum to 100.
        """
        return pulumi.get(self, "traffic")

    @traffic.setter
    def traffic(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[int]]]]):
        pulumi.set(self, "traffic", value)


@pulumi.input_type
class OnlineRequestSettingsArgs:
    def __init__(__self__, *,
                 max_concurrent_requests_per_instance: Optional[pulumi.Input[int]] = None,
                 max_queue_wait: Optional[pulumi.Input[str]] = None,
                 request_timeout: Optional[pulumi.Input[str]] = None):
        """
        Online deployment scoring requests configuration.
        :param pulumi.Input[int] max_concurrent_requests_per_instance: The number of maximum concurrent requests per node allowed per deployment. Defaults to 1.
        :param pulumi.Input[str] max_queue_wait: The maximum amount of time a request will stay in the queue in ISO 8601 format.
               Defaults to 500ms.
        :param pulumi.Input[str] request_timeout: The scoring timeout in ISO 8601 format.
               Defaults to 5000ms.
        """
        if max_concurrent_requests_per_instance is None:
            max_concurrent_requests_per_instance = 1
        if max_concurrent_requests_per_instance is not None:
            pulumi.set(__self__, "max_concurrent_requests_per_instance", max_concurrent_requests_per_instance)
        if max_queue_wait is None:
            max_queue_wait = 'PT0.5S'
        if max_queue_wait is not None:
            pulumi.set(__self__, "max_queue_wait", max_queue_wait)
        if request_timeout is None:
            request_timeout = 'PT5S'
        if request_timeout is not None:
            pulumi.set(__self__, "request_timeout", request_timeout)

    @property
    @pulumi.getter(name="maxConcurrentRequestsPerInstance")
    def max_concurrent_requests_per_instance(self) -> Optional[pulumi.Input[int]]:
        """
        The number of maximum concurrent requests per node allowed per deployment. Defaults to 1.
        """
        return pulumi.get(self, "max_concurrent_requests_per_instance")

    @max_concurrent_requests_per_instance.setter
    def max_concurrent_requests_per_instance(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_concurrent_requests_per_instance", value)

    @property
    @pulumi.getter(name="maxQueueWait")
    def max_queue_wait(self) -> Optional[pulumi.Input[str]]:
        """
        The maximum amount of time a request will stay in the queue in ISO 8601 format.
        Defaults to 500ms.
        """
        return pulumi.get(self, "max_queue_wait")

    @max_queue_wait.setter
    def max_queue_wait(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "max_queue_wait", value)

    @property
    @pulumi.getter(name="requestTimeout")
    def request_timeout(self) -> Optional[pulumi.Input[str]]:
        """
        The scoring timeout in ISO 8601 format.
        Defaults to 5000ms.
        """
        return pulumi.get(self, "request_timeout")

    @request_timeout.setter
    def request_timeout(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "request_timeout", value)


@pulumi.input_type
class OutputPathAssetReferenceArgs:
    def __init__(__self__, *,
                 reference_type: pulumi.Input[str],
                 job_id: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None):
        """
        Reference to an asset via its path in a job output.
        :param pulumi.Input[str] reference_type: Enum to determine which reference method to use for an asset.
               Expected value is 'OutputPath'.
        :param pulumi.Input[str] job_id: ARM resource ID of the job.
        :param pulumi.Input[str] path: The path of the file/directory in the job output.
        """
        pulumi.set(__self__, "reference_type", 'OutputPath')
        if job_id is not None:
            pulumi.set(__self__, "job_id", job_id)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter(name="referenceType")
    def reference_type(self) -> pulumi.Input[str]:
        """
        Enum to determine which reference method to use for an asset.
        Expected value is 'OutputPath'.
        """
        return pulumi.get(self, "reference_type")

    @reference_type.setter
    def reference_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "reference_type", value)

    @property
    @pulumi.getter(name="jobId")
    def job_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM resource ID of the job.
        """
        return pulumi.get(self, "job_id")

    @job_id.setter
    def job_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "job_id", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        The path of the file/directory in the job output.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)


@pulumi.input_type
class PATAuthTypeWorkspaceConnectionPropertiesArgs:
    def __init__(__self__, *,
                 auth_type: pulumi.Input[str],
                 category: Optional[pulumi.Input[Union[str, 'ConnectionCategory']]] = None,
                 credentials: Optional[pulumi.Input['WorkspaceConnectionPersonalAccessTokenArgs']] = None,
                 target: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None,
                 value_format: Optional[pulumi.Input[Union[str, 'ValueFormat']]] = None):
        """
        :param pulumi.Input[str] auth_type: Authentication type of the connection target
               Expected value is 'PAT'.
        :param pulumi.Input[Union[str, 'ConnectionCategory']] category: Category of the connection
        :param pulumi.Input[str] value: Value details of the workspace connection.
        :param pulumi.Input[Union[str, 'ValueFormat']] value_format: format for the workspace connection value
        """
        pulumi.set(__self__, "auth_type", 'PAT')
        if category is not None:
            pulumi.set(__self__, "category", category)
        if credentials is not None:
            pulumi.set(__self__, "credentials", credentials)
        if target is not None:
            pulumi.set(__self__, "target", target)
        if value is not None:
            pulumi.set(__self__, "value", value)
        if value_format is not None:
            pulumi.set(__self__, "value_format", value_format)

    @property
    @pulumi.getter(name="authType")
    def auth_type(self) -> pulumi.Input[str]:
        """
        Authentication type of the connection target
        Expected value is 'PAT'.
        """
        return pulumi.get(self, "auth_type")

    @auth_type.setter
    def auth_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "auth_type", value)

    @property
    @pulumi.getter
    def category(self) -> Optional[pulumi.Input[Union[str, 'ConnectionCategory']]]:
        """
        Category of the connection
        """
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: Optional[pulumi.Input[Union[str, 'ConnectionCategory']]]):
        pulumi.set(self, "category", value)

    @property
    @pulumi.getter
    def credentials(self) -> Optional[pulumi.Input['WorkspaceConnectionPersonalAccessTokenArgs']]:
        return pulumi.get(self, "credentials")

    @credentials.setter
    def credentials(self, value: Optional[pulumi.Input['WorkspaceConnectionPersonalAccessTokenArgs']]):
        pulumi.set(self, "credentials", value)

    @property
    @pulumi.getter
    def target(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        Value details of the workspace connection.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter(name="valueFormat")
    def value_format(self) -> Optional[pulumi.Input[Union[str, 'ValueFormat']]]:
        """
        format for the workspace connection value
        """
        return pulumi.get(self, "value_format")

    @value_format.setter
    def value_format(self, value: Optional[pulumi.Input[Union[str, 'ValueFormat']]]):
        pulumi.set(self, "value_format", value)


@pulumi.input_type
class PersonalComputeInstanceSettingsArgs:
    def __init__(__self__, *,
                 assigned_user: Optional[pulumi.Input['AssignedUserArgs']] = None):
        """
        Settings for a personal compute instance.
        :param pulumi.Input['AssignedUserArgs'] assigned_user: A user explicitly assigned to a personal compute instance.
        """
        if assigned_user is not None:
            pulumi.set(__self__, "assigned_user", assigned_user)

    @property
    @pulumi.getter(name="assignedUser")
    def assigned_user(self) -> Optional[pulumi.Input['AssignedUserArgs']]:
        """
        A user explicitly assigned to a personal compute instance.
        """
        return pulumi.get(self, "assigned_user")

    @assigned_user.setter
    def assigned_user(self, value: Optional[pulumi.Input['AssignedUserArgs']]):
        pulumi.set(self, "assigned_user", value)


@pulumi.input_type
class PipelineJobArgs:
    def __init__(__self__, *,
                 job_type: pulumi.Input[str],
                 component_id: Optional[pulumi.Input[str]] = None,
                 compute_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 experiment_name: Optional[pulumi.Input[str]] = None,
                 identity: Optional[pulumi.Input[Union['AmlTokenArgs', 'ManagedIdentityArgs', 'UserIdentityArgs']]] = None,
                 inputs: Optional[pulumi.Input[Mapping[str, pulumi.Input[Union['CustomModelJobInputArgs', 'LiteralJobInputArgs', 'MLFlowModelJobInputArgs', 'MLTableJobInputArgs', 'TritonModelJobInputArgs', 'UriFileJobInputArgs', 'UriFolderJobInputArgs']]]]] = None,
                 is_archived: Optional[pulumi.Input[bool]] = None,
                 jobs: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 outputs: Optional[pulumi.Input[Mapping[str, pulumi.Input[Union['CustomModelJobOutputArgs', 'MLFlowModelJobOutputArgs', 'MLTableJobOutputArgs', 'TritonModelJobOutputArgs', 'UriFileJobOutputArgs', 'UriFolderJobOutputArgs']]]]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 services: Optional[pulumi.Input[Mapping[str, pulumi.Input['JobServiceArgs']]]] = None,
                 settings: Optional[Any] = None,
                 source_job_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Pipeline Job definition: defines generic to MFE attributes.
        :param pulumi.Input[str] job_type: Enum to determine the type of job.
               Expected value is 'Pipeline'.
        :param pulumi.Input[str] component_id: ARM resource ID of the component resource.
        :param pulumi.Input[str] compute_id: ARM resource ID of the compute resource.
        :param pulumi.Input[str] description: The asset description text.
        :param pulumi.Input[str] display_name: Display name of job.
        :param pulumi.Input[str] experiment_name: The name of the experiment the job belongs to. If not set, the job is placed in the "Default" experiment.
        :param pulumi.Input[Union['AmlTokenArgs', 'ManagedIdentityArgs', 'UserIdentityArgs']] identity: Identity configuration. If set, this should be one of AmlToken, ManagedIdentity, UserIdentity or null.
               Defaults to AmlToken if null.
        :param pulumi.Input[Mapping[str, pulumi.Input[Union['CustomModelJobInputArgs', 'LiteralJobInputArgs', 'MLFlowModelJobInputArgs', 'MLTableJobInputArgs', 'TritonModelJobInputArgs', 'UriFileJobInputArgs', 'UriFolderJobInputArgs']]]] inputs: Inputs for the pipeline job.
        :param pulumi.Input[bool] is_archived: Is the asset archived?
        :param pulumi.Input[Mapping[str, Any]] jobs: Jobs construct the Pipeline Job.
        :param pulumi.Input[Mapping[str, pulumi.Input[Union['CustomModelJobOutputArgs', 'MLFlowModelJobOutputArgs', 'MLTableJobOutputArgs', 'TritonModelJobOutputArgs', 'UriFileJobOutputArgs', 'UriFolderJobOutputArgs']]]] outputs: Outputs for the pipeline job
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: The asset property dictionary.
        :param pulumi.Input[Mapping[str, pulumi.Input['JobServiceArgs']]] services: List of JobEndpoints.
               For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
        :param Any settings: Pipeline settings, for things like ContinueRunOnStepFailure etc.
        :param pulumi.Input[str] source_job_id: ARM resource ID of source job.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Tag dictionary. Tags can be added, removed, and updated.
        """
        pulumi.set(__self__, "job_type", 'Pipeline')
        if component_id is not None:
            pulumi.set(__self__, "component_id", component_id)
        if compute_id is not None:
            pulumi.set(__self__, "compute_id", compute_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if experiment_name is None:
            experiment_name = 'Default'
        if experiment_name is not None:
            pulumi.set(__self__, "experiment_name", experiment_name)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if inputs is not None:
            pulumi.set(__self__, "inputs", inputs)
        if is_archived is None:
            is_archived = False
        if is_archived is not None:
            pulumi.set(__self__, "is_archived", is_archived)
        if jobs is not None:
            pulumi.set(__self__, "jobs", jobs)
        if outputs is not None:
            pulumi.set(__self__, "outputs", outputs)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if services is not None:
            pulumi.set(__self__, "services", services)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if source_job_id is not None:
            pulumi.set(__self__, "source_job_id", source_job_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="jobType")
    def job_type(self) -> pulumi.Input[str]:
        """
        Enum to determine the type of job.
        Expected value is 'Pipeline'.
        """
        return pulumi.get(self, "job_type")

    @job_type.setter
    def job_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "job_type", value)

    @property
    @pulumi.getter(name="componentId")
    def component_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM resource ID of the component resource.
        """
        return pulumi.get(self, "component_id")

    @component_id.setter
    def component_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "component_id", value)

    @property
    @pulumi.getter(name="computeId")
    def compute_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM resource ID of the compute resource.
        """
        return pulumi.get(self, "compute_id")

    @compute_id.setter
    def compute_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compute_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The asset description text.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        Display name of job.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="experimentName")
    def experiment_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the experiment the job belongs to. If not set, the job is placed in the "Default" experiment.
        """
        return pulumi.get(self, "experiment_name")

    @experiment_name.setter
    def experiment_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "experiment_name", value)

    @property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input[Union['AmlTokenArgs', 'ManagedIdentityArgs', 'UserIdentityArgs']]]:
        """
        Identity configuration. If set, this should be one of AmlToken, ManagedIdentity, UserIdentity or null.
        Defaults to AmlToken if null.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input[Union['AmlTokenArgs', 'ManagedIdentityArgs', 'UserIdentityArgs']]]):
        pulumi.set(self, "identity", value)

    @property
    @pulumi.getter
    def inputs(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[Union['CustomModelJobInputArgs', 'LiteralJobInputArgs', 'MLFlowModelJobInputArgs', 'MLTableJobInputArgs', 'TritonModelJobInputArgs', 'UriFileJobInputArgs', 'UriFolderJobInputArgs']]]]]:
        """
        Inputs for the pipeline job.
        """
        return pulumi.get(self, "inputs")

    @inputs.setter
    def inputs(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[Union['CustomModelJobInputArgs', 'LiteralJobInputArgs', 'MLFlowModelJobInputArgs', 'MLTableJobInputArgs', 'TritonModelJobInputArgs', 'UriFileJobInputArgs', 'UriFolderJobInputArgs']]]]]):
        pulumi.set(self, "inputs", value)

    @property
    @pulumi.getter(name="isArchived")
    def is_archived(self) -> Optional[pulumi.Input[bool]]:
        """
        Is the asset archived?
        """
        return pulumi.get(self, "is_archived")

    @is_archived.setter
    def is_archived(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_archived", value)

    @property
    @pulumi.getter
    def jobs(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Jobs construct the Pipeline Job.
        """
        return pulumi.get(self, "jobs")

    @jobs.setter
    def jobs(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "jobs", value)

    @property
    @pulumi.getter
    def outputs(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[Union['CustomModelJobOutputArgs', 'MLFlowModelJobOutputArgs', 'MLTableJobOutputArgs', 'TritonModelJobOutputArgs', 'UriFileJobOutputArgs', 'UriFolderJobOutputArgs']]]]]:
        """
        Outputs for the pipeline job
        """
        return pulumi.get(self, "outputs")

    @outputs.setter
    def outputs(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[Union['CustomModelJobOutputArgs', 'MLFlowModelJobOutputArgs', 'MLTableJobOutputArgs', 'TritonModelJobOutputArgs', 'UriFileJobOutputArgs', 'UriFolderJobOutputArgs']]]]]):
        pulumi.set(self, "outputs", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The asset property dictionary.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter
    def services(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['JobServiceArgs']]]]:
        """
        List of JobEndpoints.
        For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
        """
        return pulumi.get(self, "services")

    @services.setter
    def services(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['JobServiceArgs']]]]):
        pulumi.set(self, "services", value)

    @property
    @pulumi.getter
    def settings(self) -> Optional[Any]:
        """
        Pipeline settings, for things like ContinueRunOnStepFailure etc.
        """
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: Optional[Any]):
        pulumi.set(self, "settings", value)

    @property
    @pulumi.getter(name="sourceJobId")
    def source_job_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM resource ID of source job.
        """
        return pulumi.get(self, "source_job_id")

    @source_job_id.setter
    def source_job_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_job_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Tag dictionary. Tags can be added, removed, and updated.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class PrivateLinkServiceConnectionStateArgs:
    def __init__(__self__, *,
                 actions_required: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[Union[str, 'PrivateEndpointServiceConnectionStatus']]] = None):
        """
        A collection of information about the state of the connection between service consumer and provider.
        :param pulumi.Input[str] actions_required: A message indicating if changes on the service provider require any updates on the consumer.
        :param pulumi.Input[str] description: The reason for approval/rejection of the connection.
        :param pulumi.Input[Union[str, 'PrivateEndpointServiceConnectionStatus']] status: Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
        """
        if actions_required is not None:
            pulumi.set(__self__, "actions_required", actions_required)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="actionsRequired")
    def actions_required(self) -> Optional[pulumi.Input[str]]:
        """
        A message indicating if changes on the service provider require any updates on the consumer.
        """
        return pulumi.get(self, "actions_required")

    @actions_required.setter
    def actions_required(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "actions_required", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The reason for approval/rejection of the connection.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[Union[str, 'PrivateEndpointServiceConnectionStatus']]]:
        """
        Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[Union[str, 'PrivateEndpointServiceConnectionStatus']]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class ProbeSettingsArgs:
    def __init__(__self__, *,
                 failure_threshold: Optional[pulumi.Input[int]] = None,
                 initial_delay: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[str]] = None,
                 success_threshold: Optional[pulumi.Input[int]] = None,
                 timeout: Optional[pulumi.Input[str]] = None):
        """
        Deployment container liveness/readiness probe configuration.
        :param pulumi.Input[int] failure_threshold: The number of failures to allow before returning an unhealthy status.
        :param pulumi.Input[str] initial_delay: The delay before the first probe in ISO 8601 format.
        :param pulumi.Input[str] period: The length of time between probes in ISO 8601 format.
        :param pulumi.Input[int] success_threshold: The number of successful probes before returning a healthy status.
        :param pulumi.Input[str] timeout: The probe timeout in ISO 8601 format.
        """
        if failure_threshold is None:
            failure_threshold = 30
        if failure_threshold is not None:
            pulumi.set(__self__, "failure_threshold", failure_threshold)
        if initial_delay is not None:
            pulumi.set(__self__, "initial_delay", initial_delay)
        if period is None:
            period = 'PT10S'
        if period is not None:
            pulumi.set(__self__, "period", period)
        if success_threshold is None:
            success_threshold = 1
        if success_threshold is not None:
            pulumi.set(__self__, "success_threshold", success_threshold)
        if timeout is None:
            timeout = 'PT2S'
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter(name="failureThreshold")
    def failure_threshold(self) -> Optional[pulumi.Input[int]]:
        """
        The number of failures to allow before returning an unhealthy status.
        """
        return pulumi.get(self, "failure_threshold")

    @failure_threshold.setter
    def failure_threshold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "failure_threshold", value)

    @property
    @pulumi.getter(name="initialDelay")
    def initial_delay(self) -> Optional[pulumi.Input[str]]:
        """
        The delay before the first probe in ISO 8601 format.
        """
        return pulumi.get(self, "initial_delay")

    @initial_delay.setter
    def initial_delay(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "initial_delay", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[str]]:
        """
        The length of time between probes in ISO 8601 format.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter(name="successThreshold")
    def success_threshold(self) -> Optional[pulumi.Input[int]]:
        """
        The number of successful probes before returning a healthy status.
        """
        return pulumi.get(self, "success_threshold")

    @success_threshold.setter
    def success_threshold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "success_threshold", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[str]]:
        """
        The probe timeout in ISO 8601 format.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timeout", value)


@pulumi.input_type
class PyTorchArgs:
    def __init__(__self__, *,
                 distribution_type: pulumi.Input[str],
                 process_count_per_instance: Optional[pulumi.Input[int]] = None):
        """
        PyTorch distribution configuration.
        :param pulumi.Input[str] distribution_type: Enum to determine the job distribution type.
               Expected value is 'PyTorch'.
        :param pulumi.Input[int] process_count_per_instance: Number of processes per node.
        """
        pulumi.set(__self__, "distribution_type", 'PyTorch')
        if process_count_per_instance is not None:
            pulumi.set(__self__, "process_count_per_instance", process_count_per_instance)

    @property
    @pulumi.getter(name="distributionType")
    def distribution_type(self) -> pulumi.Input[str]:
        """
        Enum to determine the job distribution type.
        Expected value is 'PyTorch'.
        """
        return pulumi.get(self, "distribution_type")

    @distribution_type.setter
    def distribution_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "distribution_type", value)

    @property
    @pulumi.getter(name="processCountPerInstance")
    def process_count_per_instance(self) -> Optional[pulumi.Input[int]]:
        """
        Number of processes per node.
        """
        return pulumi.get(self, "process_count_per_instance")

    @process_count_per_instance.setter
    def process_count_per_instance(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "process_count_per_instance", value)


@pulumi.input_type
class RandomSamplingAlgorithmArgs:
    def __init__(__self__, *,
                 sampling_algorithm_type: pulumi.Input[str],
                 logbase: Optional[pulumi.Input[str]] = None,
                 rule: Optional[pulumi.Input[Union[str, 'RandomSamplingAlgorithmRule']]] = None,
                 seed: Optional[pulumi.Input[int]] = None):
        """
        Defines a Sampling Algorithm that generates values randomly
        :param pulumi.Input[str] sampling_algorithm_type: 
               Expected value is 'Random'.
        :param pulumi.Input[str] logbase: An optional positive number or e in string format to be used as base for log based random sampling
        :param pulumi.Input[Union[str, 'RandomSamplingAlgorithmRule']] rule: The specific type of random algorithm
        :param pulumi.Input[int] seed: An optional integer to use as the seed for random number generation
        """
        pulumi.set(__self__, "sampling_algorithm_type", 'Random')
        if logbase is not None:
            pulumi.set(__self__, "logbase", logbase)
        if rule is None:
            rule = 'Random'
        if rule is not None:
            pulumi.set(__self__, "rule", rule)
        if seed is not None:
            pulumi.set(__self__, "seed", seed)

    @property
    @pulumi.getter(name="samplingAlgorithmType")
    def sampling_algorithm_type(self) -> pulumi.Input[str]:
        """

        Expected value is 'Random'.
        """
        return pulumi.get(self, "sampling_algorithm_type")

    @sampling_algorithm_type.setter
    def sampling_algorithm_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "sampling_algorithm_type", value)

    @property
    @pulumi.getter
    def logbase(self) -> Optional[pulumi.Input[str]]:
        """
        An optional positive number or e in string format to be used as base for log based random sampling
        """
        return pulumi.get(self, "logbase")

    @logbase.setter
    def logbase(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "logbase", value)

    @property
    @pulumi.getter
    def rule(self) -> Optional[pulumi.Input[Union[str, 'RandomSamplingAlgorithmRule']]]:
        """
        The specific type of random algorithm
        """
        return pulumi.get(self, "rule")

    @rule.setter
    def rule(self, value: Optional[pulumi.Input[Union[str, 'RandomSamplingAlgorithmRule']]]):
        pulumi.set(self, "rule", value)

    @property
    @pulumi.getter
    def seed(self) -> Optional[pulumi.Input[int]]:
        """
        An optional integer to use as the seed for random number generation
        """
        return pulumi.get(self, "seed")

    @seed.setter
    def seed(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "seed", value)


@pulumi.input_type
class RecurrenceScheduleArgs:
    def __init__(__self__, *,
                 hours: pulumi.Input[Sequence[pulumi.Input[int]]],
                 minutes: pulumi.Input[Sequence[pulumi.Input[int]]],
                 month_days: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 week_days: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'WeekDay']]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[int]]] hours: [Required] List of hours for the schedule.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] minutes: [Required] List of minutes for the schedule.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] month_days: List of month days for the schedule
        :param pulumi.Input[Sequence[pulumi.Input[Union[str, 'WeekDay']]]] week_days: List of days for the schedule.
        """
        pulumi.set(__self__, "hours", hours)
        pulumi.set(__self__, "minutes", minutes)
        if month_days is not None:
            pulumi.set(__self__, "month_days", month_days)
        if week_days is not None:
            pulumi.set(__self__, "week_days", week_days)

    @property
    @pulumi.getter
    def hours(self) -> pulumi.Input[Sequence[pulumi.Input[int]]]:
        """
        [Required] List of hours for the schedule.
        """
        return pulumi.get(self, "hours")

    @hours.setter
    def hours(self, value: pulumi.Input[Sequence[pulumi.Input[int]]]):
        pulumi.set(self, "hours", value)

    @property
    @pulumi.getter
    def minutes(self) -> pulumi.Input[Sequence[pulumi.Input[int]]]:
        """
        [Required] List of minutes for the schedule.
        """
        return pulumi.get(self, "minutes")

    @minutes.setter
    def minutes(self, value: pulumi.Input[Sequence[pulumi.Input[int]]]):
        pulumi.set(self, "minutes", value)

    @property
    @pulumi.getter(name="monthDays")
    def month_days(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        List of month days for the schedule
        """
        return pulumi.get(self, "month_days")

    @month_days.setter
    def month_days(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "month_days", value)

    @property
    @pulumi.getter(name="weekDays")
    def week_days(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'WeekDay']]]]]:
        """
        List of days for the schedule.
        """
        return pulumi.get(self, "week_days")

    @week_days.setter
    def week_days(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'WeekDay']]]]]):
        pulumi.set(self, "week_days", value)


@pulumi.input_type
class RecurrenceTriggerArgs:
    def __init__(__self__, *,
                 frequency: pulumi.Input[Union[str, 'RecurrenceFrequency']],
                 interval: pulumi.Input[int],
                 trigger_type: pulumi.Input[str],
                 end_time: Optional[pulumi.Input[str]] = None,
                 schedule: Optional[pulumi.Input['RecurrenceScheduleArgs']] = None,
                 start_time: Optional[pulumi.Input[str]] = None,
                 time_zone: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Union[str, 'RecurrenceFrequency']] frequency: [Required] The frequency to trigger schedule.
        :param pulumi.Input[int] interval: [Required] Specifies schedule interval in conjunction with frequency
        :param pulumi.Input[str] trigger_type: 
               Expected value is 'Recurrence'.
        :param pulumi.Input[str] end_time: Specifies end time of schedule in ISO 8601, but without a UTC offset. Refer https://en.wikipedia.org/wiki/ISO_8601.
               Recommented format would be "2022-06-01T00:00:01"
               If not present, the schedule will run indefinitely
        :param pulumi.Input['RecurrenceScheduleArgs'] schedule: The recurrence schedule.
        :param pulumi.Input[str] start_time: Specifies start time of schedule in ISO 8601 format, but without a UTC offset.
        :param pulumi.Input[str] time_zone: Specifies time zone in which the schedule runs.
               TimeZone should follow Windows time zone format. Refer: https://docs.microsoft.com/en-us/windows-hardware/manufacture/desktop/default-time-zones?view=windows-11
        """
        pulumi.set(__self__, "frequency", frequency)
        pulumi.set(__self__, "interval", interval)
        pulumi.set(__self__, "trigger_type", 'Recurrence')
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if time_zone is None:
            time_zone = 'UTC'
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)

    @property
    @pulumi.getter
    def frequency(self) -> pulumi.Input[Union[str, 'RecurrenceFrequency']]:
        """
        [Required] The frequency to trigger schedule.
        """
        return pulumi.get(self, "frequency")

    @frequency.setter
    def frequency(self, value: pulumi.Input[Union[str, 'RecurrenceFrequency']]):
        pulumi.set(self, "frequency", value)

    @property
    @pulumi.getter
    def interval(self) -> pulumi.Input[int]:
        """
        [Required] Specifies schedule interval in conjunction with frequency
        """
        return pulumi.get(self, "interval")

    @interval.setter
    def interval(self, value: pulumi.Input[int]):
        pulumi.set(self, "interval", value)

    @property
    @pulumi.getter(name="triggerType")
    def trigger_type(self) -> pulumi.Input[str]:
        """

        Expected value is 'Recurrence'.
        """
        return pulumi.get(self, "trigger_type")

    @trigger_type.setter
    def trigger_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "trigger_type", value)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies end time of schedule in ISO 8601, but without a UTC offset. Refer https://en.wikipedia.org/wiki/ISO_8601.
        Recommented format would be "2022-06-01T00:00:01"
        If not present, the schedule will run indefinitely
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "end_time", value)

    @property
    @pulumi.getter
    def schedule(self) -> Optional[pulumi.Input['RecurrenceScheduleArgs']]:
        """
        The recurrence schedule.
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: Optional[pulumi.Input['RecurrenceScheduleArgs']]):
        pulumi.set(self, "schedule", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies start time of schedule in ISO 8601 format, but without a UTC offset.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_time", value)

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies time zone in which the schedule runs.
        TimeZone should follow Windows time zone format. Refer: https://docs.microsoft.com/en-us/windows-hardware/manufacture/desktop/default-time-zones?view=windows-11
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_zone", value)


@pulumi.input_type
class RegistryRegionArmDetailsArgs:
    def __init__(__self__, *,
                 acr_details: Optional[pulumi.Input[Sequence[pulumi.Input['AcrDetailsArgs']]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 storage_account_details: Optional[pulumi.Input[Sequence[pulumi.Input['StorageAccountDetailsArgs']]]] = None):
        """
        Details for each region the registry is in
        :param pulumi.Input[Sequence[pulumi.Input['AcrDetailsArgs']]] acr_details: List of ACR accounts
        :param pulumi.Input[str] location: The location where the registry exists
        :param pulumi.Input[Sequence[pulumi.Input['StorageAccountDetailsArgs']]] storage_account_details: List of storage accounts
        """
        if acr_details is not None:
            pulumi.set(__self__, "acr_details", acr_details)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if storage_account_details is not None:
            pulumi.set(__self__, "storage_account_details", storage_account_details)

    @property
    @pulumi.getter(name="acrDetails")
    def acr_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AcrDetailsArgs']]]]:
        """
        List of ACR accounts
        """
        return pulumi.get(self, "acr_details")

    @acr_details.setter
    def acr_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AcrDetailsArgs']]]]):
        pulumi.set(self, "acr_details", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        The location where the registry exists
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="storageAccountDetails")
    def storage_account_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StorageAccountDetailsArgs']]]]:
        """
        List of storage accounts
        """
        return pulumi.get(self, "storage_account_details")

    @storage_account_details.setter
    def storage_account_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StorageAccountDetailsArgs']]]]):
        pulumi.set(self, "storage_account_details", value)


@pulumi.input_type
class RegistryArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 discovery_url: Optional[pulumi.Input[str]] = None,
                 intellectual_property_publisher: Optional[pulumi.Input[str]] = None,
                 managed_resource_group: Optional[pulumi.Input['ArmResourceIdArgs']] = None,
                 ml_flow_registry_uri: Optional[pulumi.Input[str]] = None,
                 private_link_count: Optional[pulumi.Input[int]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 public_network_access: Optional[pulumi.Input[str]] = None,
                 region_details: Optional[pulumi.Input[Sequence[pulumi.Input['RegistryRegionArmDetailsArgs']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Details of the Registry
        :param pulumi.Input[str] description: The asset description text.
        :param pulumi.Input['ArmResourceIdArgs'] managed_resource_group: Managed resource group created for the registry
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: The asset property dictionary.
        :param pulumi.Input[Sequence[pulumi.Input['RegistryRegionArmDetailsArgs']]] region_details: Details of each region the registry is in
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Tag dictionary. Tags can be added, removed, and updated.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if discovery_url is not None:
            pulumi.set(__self__, "discovery_url", discovery_url)
        if intellectual_property_publisher is not None:
            pulumi.set(__self__, "intellectual_property_publisher", intellectual_property_publisher)
        if managed_resource_group is not None:
            pulumi.set(__self__, "managed_resource_group", managed_resource_group)
        if ml_flow_registry_uri is not None:
            pulumi.set(__self__, "ml_flow_registry_uri", ml_flow_registry_uri)
        if private_link_count is not None:
            pulumi.set(__self__, "private_link_count", private_link_count)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if public_network_access is not None:
            pulumi.set(__self__, "public_network_access", public_network_access)
        if region_details is not None:
            pulumi.set(__self__, "region_details", region_details)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The asset description text.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="discoveryUrl")
    def discovery_url(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "discovery_url")

    @discovery_url.setter
    def discovery_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "discovery_url", value)

    @property
    @pulumi.getter(name="intellectualPropertyPublisher")
    def intellectual_property_publisher(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "intellectual_property_publisher")

    @intellectual_property_publisher.setter
    def intellectual_property_publisher(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "intellectual_property_publisher", value)

    @property
    @pulumi.getter(name="managedResourceGroup")
    def managed_resource_group(self) -> Optional[pulumi.Input['ArmResourceIdArgs']]:
        """
        Managed resource group created for the registry
        """
        return pulumi.get(self, "managed_resource_group")

    @managed_resource_group.setter
    def managed_resource_group(self, value: Optional[pulumi.Input['ArmResourceIdArgs']]):
        pulumi.set(self, "managed_resource_group", value)

    @property
    @pulumi.getter(name="mlFlowRegistryUri")
    def ml_flow_registry_uri(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "ml_flow_registry_uri")

    @ml_flow_registry_uri.setter
    def ml_flow_registry_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ml_flow_registry_uri", value)

    @property
    @pulumi.getter(name="privateLinkCount")
    def private_link_count(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "private_link_count")

    @private_link_count.setter
    def private_link_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "private_link_count", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The asset property dictionary.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter(name="publicNetworkAccess")
    def public_network_access(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "public_network_access")

    @public_network_access.setter
    def public_network_access(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_network_access", value)

    @property
    @pulumi.getter(name="regionDetails")
    def region_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RegistryRegionArmDetailsArgs']]]]:
        """
        Details of each region the registry is in
        """
        return pulumi.get(self, "region_details")

    @region_details.setter
    def region_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RegistryRegionArmDetailsArgs']]]]):
        pulumi.set(self, "region_details", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Tag dictionary. Tags can be added, removed, and updated.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class RegressionTrainingSettingsArgs:
    def __init__(__self__, *,
                 allowed_training_algorithms: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'RegressionModels']]]]] = None,
                 blocked_training_algorithms: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'RegressionModels']]]]] = None,
                 enable_dnn_training: Optional[pulumi.Input[bool]] = None,
                 enable_model_explainability: Optional[pulumi.Input[bool]] = None,
                 enable_onnx_compatible_models: Optional[pulumi.Input[bool]] = None,
                 enable_stack_ensemble: Optional[pulumi.Input[bool]] = None,
                 enable_vote_ensemble: Optional[pulumi.Input[bool]] = None,
                 ensemble_model_download_timeout: Optional[pulumi.Input[str]] = None,
                 stack_ensemble_settings: Optional[pulumi.Input['StackEnsembleSettingsArgs']] = None,
                 training_mode: Optional[pulumi.Input[Union[str, 'TrainingMode']]] = None):
        """
        Regression Training related configuration.
        :param pulumi.Input[Sequence[pulumi.Input[Union[str, 'RegressionModels']]]] allowed_training_algorithms: Allowed models for regression task.
        :param pulumi.Input[Sequence[pulumi.Input[Union[str, 'RegressionModels']]]] blocked_training_algorithms: Blocked models for regression task.
        :param pulumi.Input[bool] enable_dnn_training: Enable recommendation of DNN models.
        :param pulumi.Input[bool] enable_model_explainability: Flag to turn on explainability on best model.
        :param pulumi.Input[bool] enable_onnx_compatible_models: Flag for enabling onnx compatible models.
        :param pulumi.Input[bool] enable_stack_ensemble: Enable stack ensemble run.
        :param pulumi.Input[bool] enable_vote_ensemble: Enable voting ensemble run.
        :param pulumi.Input[str] ensemble_model_download_timeout: During VotingEnsemble and StackEnsemble model generation, multiple fitted models from the previous child runs are downloaded.
               Configure this parameter with a higher value than 300 secs, if more time is needed.
        :param pulumi.Input['StackEnsembleSettingsArgs'] stack_ensemble_settings: Stack ensemble settings for stack ensemble run.
        :param pulumi.Input[Union[str, 'TrainingMode']] training_mode: TrainingMode mode - Setting to 'auto' is same as setting it to 'non-distributed' for now, however in the future may result in mixed mode or heuristics based mode selection. Default is 'auto'.
               If 'Distributed' then only distributed featurization is used and distributed algorithms are chosen.
               If 'NonDistributed' then only non distributed algorithms are chosen.
        """
        if allowed_training_algorithms is not None:
            pulumi.set(__self__, "allowed_training_algorithms", allowed_training_algorithms)
        if blocked_training_algorithms is not None:
            pulumi.set(__self__, "blocked_training_algorithms", blocked_training_algorithms)
        if enable_dnn_training is None:
            enable_dnn_training = False
        if enable_dnn_training is not None:
            pulumi.set(__self__, "enable_dnn_training", enable_dnn_training)
        if enable_model_explainability is None:
            enable_model_explainability = True
        if enable_model_explainability is not None:
            pulumi.set(__self__, "enable_model_explainability", enable_model_explainability)
        if enable_onnx_compatible_models is None:
            enable_onnx_compatible_models = False
        if enable_onnx_compatible_models is not None:
            pulumi.set(__self__, "enable_onnx_compatible_models", enable_onnx_compatible_models)
        if enable_stack_ensemble is None:
            enable_stack_ensemble = True
        if enable_stack_ensemble is not None:
            pulumi.set(__self__, "enable_stack_ensemble", enable_stack_ensemble)
        if enable_vote_ensemble is None:
            enable_vote_ensemble = True
        if enable_vote_ensemble is not None:
            pulumi.set(__self__, "enable_vote_ensemble", enable_vote_ensemble)
        if ensemble_model_download_timeout is None:
            ensemble_model_download_timeout = 'PT5M'
        if ensemble_model_download_timeout is not None:
            pulumi.set(__self__, "ensemble_model_download_timeout", ensemble_model_download_timeout)
        if stack_ensemble_settings is not None:
            pulumi.set(__self__, "stack_ensemble_settings", stack_ensemble_settings)
        if training_mode is None:
            training_mode = 'Auto'
        if training_mode is not None:
            pulumi.set(__self__, "training_mode", training_mode)

    @property
    @pulumi.getter(name="allowedTrainingAlgorithms")
    def allowed_training_algorithms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'RegressionModels']]]]]:
        """
        Allowed models for regression task.
        """
        return pulumi.get(self, "allowed_training_algorithms")

    @allowed_training_algorithms.setter
    def allowed_training_algorithms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'RegressionModels']]]]]):
        pulumi.set(self, "allowed_training_algorithms", value)

    @property
    @pulumi.getter(name="blockedTrainingAlgorithms")
    def blocked_training_algorithms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'RegressionModels']]]]]:
        """
        Blocked models for regression task.
        """
        return pulumi.get(self, "blocked_training_algorithms")

    @blocked_training_algorithms.setter
    def blocked_training_algorithms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'RegressionModels']]]]]):
        pulumi.set(self, "blocked_training_algorithms", value)

    @property
    @pulumi.getter(name="enableDnnTraining")
    def enable_dnn_training(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable recommendation of DNN models.
        """
        return pulumi.get(self, "enable_dnn_training")

    @enable_dnn_training.setter
    def enable_dnn_training(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_dnn_training", value)

    @property
    @pulumi.getter(name="enableModelExplainability")
    def enable_model_explainability(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to turn on explainability on best model.
        """
        return pulumi.get(self, "enable_model_explainability")

    @enable_model_explainability.setter
    def enable_model_explainability(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_model_explainability", value)

    @property
    @pulumi.getter(name="enableOnnxCompatibleModels")
    def enable_onnx_compatible_models(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag for enabling onnx compatible models.
        """
        return pulumi.get(self, "enable_onnx_compatible_models")

    @enable_onnx_compatible_models.setter
    def enable_onnx_compatible_models(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_onnx_compatible_models", value)

    @property
    @pulumi.getter(name="enableStackEnsemble")
    def enable_stack_ensemble(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable stack ensemble run.
        """
        return pulumi.get(self, "enable_stack_ensemble")

    @enable_stack_ensemble.setter
    def enable_stack_ensemble(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_stack_ensemble", value)

    @property
    @pulumi.getter(name="enableVoteEnsemble")
    def enable_vote_ensemble(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable voting ensemble run.
        """
        return pulumi.get(self, "enable_vote_ensemble")

    @enable_vote_ensemble.setter
    def enable_vote_ensemble(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_vote_ensemble", value)

    @property
    @pulumi.getter(name="ensembleModelDownloadTimeout")
    def ensemble_model_download_timeout(self) -> Optional[pulumi.Input[str]]:
        """
        During VotingEnsemble and StackEnsemble model generation, multiple fitted models from the previous child runs are downloaded.
        Configure this parameter with a higher value than 300 secs, if more time is needed.
        """
        return pulumi.get(self, "ensemble_model_download_timeout")

    @ensemble_model_download_timeout.setter
    def ensemble_model_download_timeout(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ensemble_model_download_timeout", value)

    @property
    @pulumi.getter(name="stackEnsembleSettings")
    def stack_ensemble_settings(self) -> Optional[pulumi.Input['StackEnsembleSettingsArgs']]:
        """
        Stack ensemble settings for stack ensemble run.
        """
        return pulumi.get(self, "stack_ensemble_settings")

    @stack_ensemble_settings.setter
    def stack_ensemble_settings(self, value: Optional[pulumi.Input['StackEnsembleSettingsArgs']]):
        pulumi.set(self, "stack_ensemble_settings", value)

    @property
    @pulumi.getter(name="trainingMode")
    def training_mode(self) -> Optional[pulumi.Input[Union[str, 'TrainingMode']]]:
        """
        TrainingMode mode - Setting to 'auto' is same as setting it to 'non-distributed' for now, however in the future may result in mixed mode or heuristics based mode selection. Default is 'auto'.
        If 'Distributed' then only distributed featurization is used and distributed algorithms are chosen.
        If 'NonDistributed' then only non distributed algorithms are chosen.
        """
        return pulumi.get(self, "training_mode")

    @training_mode.setter
    def training_mode(self, value: Optional[pulumi.Input[Union[str, 'TrainingMode']]]):
        pulumi.set(self, "training_mode", value)


@pulumi.input_type
class RegressionArgs:
    def __init__(__self__, *,
                 task_type: pulumi.Input[str],
                 training_data: pulumi.Input['MLTableJobInputArgs'],
                 cv_split_column_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 featurization_settings: Optional[pulumi.Input['TableVerticalFeaturizationSettingsArgs']] = None,
                 fixed_parameters: Optional[pulumi.Input['TableFixedParametersArgs']] = None,
                 limit_settings: Optional[pulumi.Input['TableVerticalLimitSettingsArgs']] = None,
                 log_verbosity: Optional[pulumi.Input[Union[str, 'LogVerbosity']]] = None,
                 n_cross_validations: Optional[pulumi.Input[Union['AutoNCrossValidationsArgs', 'CustomNCrossValidationsArgs']]] = None,
                 primary_metric: Optional[pulumi.Input[Union[str, 'RegressionPrimaryMetrics']]] = None,
                 search_space: Optional[pulumi.Input[Sequence[pulumi.Input['TableParameterSubspaceArgs']]]] = None,
                 sweep_settings: Optional[pulumi.Input['TableSweepSettingsArgs']] = None,
                 target_column_name: Optional[pulumi.Input[str]] = None,
                 test_data: Optional[pulumi.Input['MLTableJobInputArgs']] = None,
                 test_data_size: Optional[pulumi.Input[float]] = None,
                 training_settings: Optional[pulumi.Input['RegressionTrainingSettingsArgs']] = None,
                 validation_data: Optional[pulumi.Input['MLTableJobInputArgs']] = None,
                 validation_data_size: Optional[pulumi.Input[float]] = None,
                 weight_column_name: Optional[pulumi.Input[str]] = None):
        """
        Regression task in AutoML Table vertical.
        :param pulumi.Input[str] task_type: AutoMLJob Task type.
               Expected value is 'Regression'.
        :param pulumi.Input['MLTableJobInputArgs'] training_data: [Required] Training data input.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] cv_split_column_names: Columns to use for CVSplit data.
        :param pulumi.Input['TableVerticalFeaturizationSettingsArgs'] featurization_settings: Featurization inputs needed for AutoML job.
        :param pulumi.Input['TableFixedParametersArgs'] fixed_parameters: Model/training parameters that will remain constant throughout training.
        :param pulumi.Input['TableVerticalLimitSettingsArgs'] limit_settings: Execution constraints for AutoMLJob.
        :param pulumi.Input[Union[str, 'LogVerbosity']] log_verbosity: Log verbosity for the job.
        :param pulumi.Input[Union['AutoNCrossValidationsArgs', 'CustomNCrossValidationsArgs']] n_cross_validations: Number of cross validation folds to be applied on training dataset
               when validation dataset is not provided.
        :param pulumi.Input[Union[str, 'RegressionPrimaryMetrics']] primary_metric: Primary metric for regression task.
        :param pulumi.Input[Sequence[pulumi.Input['TableParameterSubspaceArgs']]] search_space: Search space for sampling different combinations of models and their hyperparameters.
        :param pulumi.Input['TableSweepSettingsArgs'] sweep_settings: Settings for model sweeping and hyperparameter tuning.
        :param pulumi.Input[str] target_column_name: Target column name: This is prediction values column.
               Also known as label column name in context of classification tasks.
        :param pulumi.Input['MLTableJobInputArgs'] test_data: Test data input.
        :param pulumi.Input[float] test_data_size: The fraction of test dataset that needs to be set aside for validation purpose.
               Values between (0.0 , 1.0)
               Applied when validation dataset is not provided.
        :param pulumi.Input['RegressionTrainingSettingsArgs'] training_settings: Inputs for training phase for an AutoML Job.
        :param pulumi.Input['MLTableJobInputArgs'] validation_data: Validation data inputs.
        :param pulumi.Input[float] validation_data_size: The fraction of training dataset that needs to be set aside for validation purpose.
               Values between (0.0 , 1.0)
               Applied when validation dataset is not provided.
        :param pulumi.Input[str] weight_column_name: The name of the sample weight column. Automated ML supports a weighted column as an input, causing rows in the data to be weighted up or down.
        """
        pulumi.set(__self__, "task_type", 'Regression')
        pulumi.set(__self__, "training_data", training_data)
        if cv_split_column_names is not None:
            pulumi.set(__self__, "cv_split_column_names", cv_split_column_names)
        if featurization_settings is not None:
            pulumi.set(__self__, "featurization_settings", featurization_settings)
        if fixed_parameters is not None:
            pulumi.set(__self__, "fixed_parameters", fixed_parameters)
        if limit_settings is not None:
            pulumi.set(__self__, "limit_settings", limit_settings)
        if log_verbosity is None:
            log_verbosity = 'Info'
        if log_verbosity is not None:
            pulumi.set(__self__, "log_verbosity", log_verbosity)
        if n_cross_validations is not None:
            pulumi.set(__self__, "n_cross_validations", n_cross_validations)
        if primary_metric is None:
            primary_metric = 'NormalizedRootMeanSquaredError'
        if primary_metric is not None:
            pulumi.set(__self__, "primary_metric", primary_metric)
        if search_space is not None:
            pulumi.set(__self__, "search_space", search_space)
        if sweep_settings is not None:
            pulumi.set(__self__, "sweep_settings", sweep_settings)
        if target_column_name is not None:
            pulumi.set(__self__, "target_column_name", target_column_name)
        if test_data is not None:
            pulumi.set(__self__, "test_data", test_data)
        if test_data_size is not None:
            pulumi.set(__self__, "test_data_size", test_data_size)
        if training_settings is not None:
            pulumi.set(__self__, "training_settings", training_settings)
        if validation_data is not None:
            pulumi.set(__self__, "validation_data", validation_data)
        if validation_data_size is not None:
            pulumi.set(__self__, "validation_data_size", validation_data_size)
        if weight_column_name is not None:
            pulumi.set(__self__, "weight_column_name", weight_column_name)

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> pulumi.Input[str]:
        """
        AutoMLJob Task type.
        Expected value is 'Regression'.
        """
        return pulumi.get(self, "task_type")

    @task_type.setter
    def task_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "task_type", value)

    @property
    @pulumi.getter(name="trainingData")
    def training_data(self) -> pulumi.Input['MLTableJobInputArgs']:
        """
        [Required] Training data input.
        """
        return pulumi.get(self, "training_data")

    @training_data.setter
    def training_data(self, value: pulumi.Input['MLTableJobInputArgs']):
        pulumi.set(self, "training_data", value)

    @property
    @pulumi.getter(name="cvSplitColumnNames")
    def cv_split_column_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Columns to use for CVSplit data.
        """
        return pulumi.get(self, "cv_split_column_names")

    @cv_split_column_names.setter
    def cv_split_column_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "cv_split_column_names", value)

    @property
    @pulumi.getter(name="featurizationSettings")
    def featurization_settings(self) -> Optional[pulumi.Input['TableVerticalFeaturizationSettingsArgs']]:
        """
        Featurization inputs needed for AutoML job.
        """
        return pulumi.get(self, "featurization_settings")

    @featurization_settings.setter
    def featurization_settings(self, value: Optional[pulumi.Input['TableVerticalFeaturizationSettingsArgs']]):
        pulumi.set(self, "featurization_settings", value)

    @property
    @pulumi.getter(name="fixedParameters")
    def fixed_parameters(self) -> Optional[pulumi.Input['TableFixedParametersArgs']]:
        """
        Model/training parameters that will remain constant throughout training.
        """
        return pulumi.get(self, "fixed_parameters")

    @fixed_parameters.setter
    def fixed_parameters(self, value: Optional[pulumi.Input['TableFixedParametersArgs']]):
        pulumi.set(self, "fixed_parameters", value)

    @property
    @pulumi.getter(name="limitSettings")
    def limit_settings(self) -> Optional[pulumi.Input['TableVerticalLimitSettingsArgs']]:
        """
        Execution constraints for AutoMLJob.
        """
        return pulumi.get(self, "limit_settings")

    @limit_settings.setter
    def limit_settings(self, value: Optional[pulumi.Input['TableVerticalLimitSettingsArgs']]):
        pulumi.set(self, "limit_settings", value)

    @property
    @pulumi.getter(name="logVerbosity")
    def log_verbosity(self) -> Optional[pulumi.Input[Union[str, 'LogVerbosity']]]:
        """
        Log verbosity for the job.
        """
        return pulumi.get(self, "log_verbosity")

    @log_verbosity.setter
    def log_verbosity(self, value: Optional[pulumi.Input[Union[str, 'LogVerbosity']]]):
        pulumi.set(self, "log_verbosity", value)

    @property
    @pulumi.getter(name="nCrossValidations")
    def n_cross_validations(self) -> Optional[pulumi.Input[Union['AutoNCrossValidationsArgs', 'CustomNCrossValidationsArgs']]]:
        """
        Number of cross validation folds to be applied on training dataset
        when validation dataset is not provided.
        """
        return pulumi.get(self, "n_cross_validations")

    @n_cross_validations.setter
    def n_cross_validations(self, value: Optional[pulumi.Input[Union['AutoNCrossValidationsArgs', 'CustomNCrossValidationsArgs']]]):
        pulumi.set(self, "n_cross_validations", value)

    @property
    @pulumi.getter(name="primaryMetric")
    def primary_metric(self) -> Optional[pulumi.Input[Union[str, 'RegressionPrimaryMetrics']]]:
        """
        Primary metric for regression task.
        """
        return pulumi.get(self, "primary_metric")

    @primary_metric.setter
    def primary_metric(self, value: Optional[pulumi.Input[Union[str, 'RegressionPrimaryMetrics']]]):
        pulumi.set(self, "primary_metric", value)

    @property
    @pulumi.getter(name="searchSpace")
    def search_space(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TableParameterSubspaceArgs']]]]:
        """
        Search space for sampling different combinations of models and their hyperparameters.
        """
        return pulumi.get(self, "search_space")

    @search_space.setter
    def search_space(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TableParameterSubspaceArgs']]]]):
        pulumi.set(self, "search_space", value)

    @property
    @pulumi.getter(name="sweepSettings")
    def sweep_settings(self) -> Optional[pulumi.Input['TableSweepSettingsArgs']]:
        """
        Settings for model sweeping and hyperparameter tuning.
        """
        return pulumi.get(self, "sweep_settings")

    @sweep_settings.setter
    def sweep_settings(self, value: Optional[pulumi.Input['TableSweepSettingsArgs']]):
        pulumi.set(self, "sweep_settings", value)

    @property
    @pulumi.getter(name="targetColumnName")
    def target_column_name(self) -> Optional[pulumi.Input[str]]:
        """
        Target column name: This is prediction values column.
        Also known as label column name in context of classification tasks.
        """
        return pulumi.get(self, "target_column_name")

    @target_column_name.setter
    def target_column_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_column_name", value)

    @property
    @pulumi.getter(name="testData")
    def test_data(self) -> Optional[pulumi.Input['MLTableJobInputArgs']]:
        """
        Test data input.
        """
        return pulumi.get(self, "test_data")

    @test_data.setter
    def test_data(self, value: Optional[pulumi.Input['MLTableJobInputArgs']]):
        pulumi.set(self, "test_data", value)

    @property
    @pulumi.getter(name="testDataSize")
    def test_data_size(self) -> Optional[pulumi.Input[float]]:
        """
        The fraction of test dataset that needs to be set aside for validation purpose.
        Values between (0.0 , 1.0)
        Applied when validation dataset is not provided.
        """
        return pulumi.get(self, "test_data_size")

    @test_data_size.setter
    def test_data_size(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "test_data_size", value)

    @property
    @pulumi.getter(name="trainingSettings")
    def training_settings(self) -> Optional[pulumi.Input['RegressionTrainingSettingsArgs']]:
        """
        Inputs for training phase for an AutoML Job.
        """
        return pulumi.get(self, "training_settings")

    @training_settings.setter
    def training_settings(self, value: Optional[pulumi.Input['RegressionTrainingSettingsArgs']]):
        pulumi.set(self, "training_settings", value)

    @property
    @pulumi.getter(name="validationData")
    def validation_data(self) -> Optional[pulumi.Input['MLTableJobInputArgs']]:
        """
        Validation data inputs.
        """
        return pulumi.get(self, "validation_data")

    @validation_data.setter
    def validation_data(self, value: Optional[pulumi.Input['MLTableJobInputArgs']]):
        pulumi.set(self, "validation_data", value)

    @property
    @pulumi.getter(name="validationDataSize")
    def validation_data_size(self) -> Optional[pulumi.Input[float]]:
        """
        The fraction of training dataset that needs to be set aside for validation purpose.
        Values between (0.0 , 1.0)
        Applied when validation dataset is not provided.
        """
        return pulumi.get(self, "validation_data_size")

    @validation_data_size.setter
    def validation_data_size(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "validation_data_size", value)

    @property
    @pulumi.getter(name="weightColumnName")
    def weight_column_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the sample weight column. Automated ML supports a weighted column as an input, causing rows in the data to be weighted up or down.
        """
        return pulumi.get(self, "weight_column_name")

    @weight_column_name.setter
    def weight_column_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "weight_column_name", value)


@pulumi.input_type
class ResourceIdArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[str]):
        """
        Represents a resource ID. For example, for a subnet, it is the resource URL for the subnet.
        :param pulumi.Input[str] id: The ID of the resource
        """
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[str]:
        """
        The ID of the resource
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[str]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class RouteArgs:
    def __init__(__self__, *,
                 path: pulumi.Input[str],
                 port: pulumi.Input[int]):
        """
        :param pulumi.Input[str] path: [Required] The path for the route.
        :param pulumi.Input[int] port: [Required] The port for the route.
        """
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def path(self) -> pulumi.Input[str]:
        """
        [Required] The path for the route.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: pulumi.Input[str]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def port(self) -> pulumi.Input[int]:
        """
        [Required] The port for the route.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[int]):
        pulumi.set(self, "port", value)


@pulumi.input_type
class SASAuthTypeWorkspaceConnectionPropertiesArgs:
    def __init__(__self__, *,
                 auth_type: pulumi.Input[str],
                 category: Optional[pulumi.Input[Union[str, 'ConnectionCategory']]] = None,
                 credentials: Optional[pulumi.Input['WorkspaceConnectionSharedAccessSignatureArgs']] = None,
                 target: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None,
                 value_format: Optional[pulumi.Input[Union[str, 'ValueFormat']]] = None):
        """
        :param pulumi.Input[str] auth_type: Authentication type of the connection target
               Expected value is 'SAS'.
        :param pulumi.Input[Union[str, 'ConnectionCategory']] category: Category of the connection
        :param pulumi.Input[str] value: Value details of the workspace connection.
        :param pulumi.Input[Union[str, 'ValueFormat']] value_format: format for the workspace connection value
        """
        pulumi.set(__self__, "auth_type", 'SAS')
        if category is not None:
            pulumi.set(__self__, "category", category)
        if credentials is not None:
            pulumi.set(__self__, "credentials", credentials)
        if target is not None:
            pulumi.set(__self__, "target", target)
        if value is not None:
            pulumi.set(__self__, "value", value)
        if value_format is not None:
            pulumi.set(__self__, "value_format", value_format)

    @property
    @pulumi.getter(name="authType")
    def auth_type(self) -> pulumi.Input[str]:
        """
        Authentication type of the connection target
        Expected value is 'SAS'.
        """
        return pulumi.get(self, "auth_type")

    @auth_type.setter
    def auth_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "auth_type", value)

    @property
    @pulumi.getter
    def category(self) -> Optional[pulumi.Input[Union[str, 'ConnectionCategory']]]:
        """
        Category of the connection
        """
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: Optional[pulumi.Input[Union[str, 'ConnectionCategory']]]):
        pulumi.set(self, "category", value)

    @property
    @pulumi.getter
    def credentials(self) -> Optional[pulumi.Input['WorkspaceConnectionSharedAccessSignatureArgs']]:
        return pulumi.get(self, "credentials")

    @credentials.setter
    def credentials(self, value: Optional[pulumi.Input['WorkspaceConnectionSharedAccessSignatureArgs']]):
        pulumi.set(self, "credentials", value)

    @property
    @pulumi.getter
    def target(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        Value details of the workspace connection.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter(name="valueFormat")
    def value_format(self) -> Optional[pulumi.Input[Union[str, 'ValueFormat']]]:
        """
        format for the workspace connection value
        """
        return pulumi.get(self, "value_format")

    @value_format.setter
    def value_format(self, value: Optional[pulumi.Input[Union[str, 'ValueFormat']]]):
        pulumi.set(self, "value_format", value)


@pulumi.input_type
class SasDatastoreCredentialsArgs:
    def __init__(__self__, *,
                 credentials_type: pulumi.Input[str],
                 secrets: pulumi.Input['SasDatastoreSecretsArgs']):
        """
        SAS datastore credentials configuration.
        :param pulumi.Input[str] credentials_type: Enum to determine the datastore credentials type.
               Expected value is 'Sas'.
        :param pulumi.Input['SasDatastoreSecretsArgs'] secrets: [Required] Storage container secrets.
        """
        pulumi.set(__self__, "credentials_type", 'Sas')
        pulumi.set(__self__, "secrets", secrets)

    @property
    @pulumi.getter(name="credentialsType")
    def credentials_type(self) -> pulumi.Input[str]:
        """
        Enum to determine the datastore credentials type.
        Expected value is 'Sas'.
        """
        return pulumi.get(self, "credentials_type")

    @credentials_type.setter
    def credentials_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "credentials_type", value)

    @property
    @pulumi.getter
    def secrets(self) -> pulumi.Input['SasDatastoreSecretsArgs']:
        """
        [Required] Storage container secrets.
        """
        return pulumi.get(self, "secrets")

    @secrets.setter
    def secrets(self, value: pulumi.Input['SasDatastoreSecretsArgs']):
        pulumi.set(self, "secrets", value)


@pulumi.input_type
class SasDatastoreSecretsArgs:
    def __init__(__self__, *,
                 secrets_type: pulumi.Input[str],
                 sas_token: Optional[pulumi.Input[str]] = None):
        """
        Datastore SAS secrets.
        :param pulumi.Input[str] secrets_type: Enum to determine the datastore secrets type.
               Expected value is 'Sas'.
        :param pulumi.Input[str] sas_token: Storage container SAS token.
        """
        pulumi.set(__self__, "secrets_type", 'Sas')
        if sas_token is not None:
            pulumi.set(__self__, "sas_token", sas_token)

    @property
    @pulumi.getter(name="secretsType")
    def secrets_type(self) -> pulumi.Input[str]:
        """
        Enum to determine the datastore secrets type.
        Expected value is 'Sas'.
        """
        return pulumi.get(self, "secrets_type")

    @secrets_type.setter
    def secrets_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "secrets_type", value)

    @property
    @pulumi.getter(name="sasToken")
    def sas_token(self) -> Optional[pulumi.Input[str]]:
        """
        Storage container SAS token.
        """
        return pulumi.get(self, "sas_token")

    @sas_token.setter
    def sas_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sas_token", value)


@pulumi.input_type
class ScaleSettingsArgs:
    def __init__(__self__, *,
                 max_node_count: pulumi.Input[int],
                 min_node_count: Optional[pulumi.Input[int]] = None,
                 node_idle_time_before_scale_down: Optional[pulumi.Input[str]] = None):
        """
        scale settings for AML Compute
        :param pulumi.Input[int] max_node_count: Max number of nodes to use
        :param pulumi.Input[int] min_node_count: Min number of nodes to use
        :param pulumi.Input[str] node_idle_time_before_scale_down: Node Idle Time before scaling down amlCompute. This string needs to be in the RFC Format.
        """
        pulumi.set(__self__, "max_node_count", max_node_count)
        if min_node_count is None:
            min_node_count = 0
        if min_node_count is not None:
            pulumi.set(__self__, "min_node_count", min_node_count)
        if node_idle_time_before_scale_down is not None:
            pulumi.set(__self__, "node_idle_time_before_scale_down", node_idle_time_before_scale_down)

    @property
    @pulumi.getter(name="maxNodeCount")
    def max_node_count(self) -> pulumi.Input[int]:
        """
        Max number of nodes to use
        """
        return pulumi.get(self, "max_node_count")

    @max_node_count.setter
    def max_node_count(self, value: pulumi.Input[int]):
        pulumi.set(self, "max_node_count", value)

    @property
    @pulumi.getter(name="minNodeCount")
    def min_node_count(self) -> Optional[pulumi.Input[int]]:
        """
        Min number of nodes to use
        """
        return pulumi.get(self, "min_node_count")

    @min_node_count.setter
    def min_node_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_node_count", value)

    @property
    @pulumi.getter(name="nodeIdleTimeBeforeScaleDown")
    def node_idle_time_before_scale_down(self) -> Optional[pulumi.Input[str]]:
        """
        Node Idle Time before scaling down amlCompute. This string needs to be in the RFC Format.
        """
        return pulumi.get(self, "node_idle_time_before_scale_down")

    @node_idle_time_before_scale_down.setter
    def node_idle_time_before_scale_down(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_idle_time_before_scale_down", value)


@pulumi.input_type
class ScheduleBaseArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None,
                 provisioning_status: Optional[pulumi.Input[Union[str, 'ScheduleProvisioningState']]] = None,
                 status: Optional[pulumi.Input[Union[str, 'ScheduleStatus']]] = None):
        """
        :param pulumi.Input[str] id: A system assigned id for the schedule.
        :param pulumi.Input[Union[str, 'ScheduleProvisioningState']] provisioning_status: The current deployment state of schedule.
        :param pulumi.Input[Union[str, 'ScheduleStatus']] status: Is the schedule enabled or disabled?
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if provisioning_status is not None:
            pulumi.set(__self__, "provisioning_status", provisioning_status)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        A system assigned id for the schedule.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="provisioningStatus")
    def provisioning_status(self) -> Optional[pulumi.Input[Union[str, 'ScheduleProvisioningState']]]:
        """
        The current deployment state of schedule.
        """
        return pulumi.get(self, "provisioning_status")

    @provisioning_status.setter
    def provisioning_status(self, value: Optional[pulumi.Input[Union[str, 'ScheduleProvisioningState']]]):
        pulumi.set(self, "provisioning_status", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[Union[str, 'ScheduleStatus']]]:
        """
        Is the schedule enabled or disabled?
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[Union[str, 'ScheduleStatus']]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class ScheduleArgs:
    def __init__(__self__, *,
                 action: pulumi.Input[Union['EndpointScheduleActionArgs', 'JobScheduleActionArgs']],
                 trigger: pulumi.Input[Union['CronTriggerArgs', 'RecurrenceTriggerArgs']],
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 is_enabled: Optional[pulumi.Input[bool]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Base definition of a schedule
        :param pulumi.Input[Union['EndpointScheduleActionArgs', 'JobScheduleActionArgs']] action: [Required] Specifies the action of the schedule
        :param pulumi.Input[Union['CronTriggerArgs', 'RecurrenceTriggerArgs']] trigger: [Required] Specifies the trigger details
        :param pulumi.Input[str] description: The asset description text.
        :param pulumi.Input[str] display_name: Display name of schedule.
        :param pulumi.Input[bool] is_enabled: Is the schedule enabled?
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: The asset property dictionary.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Tag dictionary. Tags can be added, removed, and updated.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "trigger", trigger)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if is_enabled is None:
            is_enabled = True
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Input[Union['EndpointScheduleActionArgs', 'JobScheduleActionArgs']]:
        """
        [Required] Specifies the action of the schedule
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input[Union['EndpointScheduleActionArgs', 'JobScheduleActionArgs']]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter
    def trigger(self) -> pulumi.Input[Union['CronTriggerArgs', 'RecurrenceTriggerArgs']]:
        """
        [Required] Specifies the trigger details
        """
        return pulumi.get(self, "trigger")

    @trigger.setter
    def trigger(self, value: pulumi.Input[Union['CronTriggerArgs', 'RecurrenceTriggerArgs']]):
        pulumi.set(self, "trigger", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The asset description text.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        Display name of schedule.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Is the schedule enabled?
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_enabled", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The asset property dictionary.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Tag dictionary. Tags can be added, removed, and updated.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class ScriptReferenceArgs:
    def __init__(__self__, *,
                 script_arguments: Optional[pulumi.Input[str]] = None,
                 script_data: Optional[pulumi.Input[str]] = None,
                 script_source: Optional[pulumi.Input[str]] = None,
                 timeout: Optional[pulumi.Input[str]] = None):
        """
        Script reference
        :param pulumi.Input[str] script_arguments: Optional command line arguments passed to the script to run.
        :param pulumi.Input[str] script_data: The location of scripts in the mounted volume.
        :param pulumi.Input[str] script_source: The storage source of the script: inline, workspace.
        :param pulumi.Input[str] timeout: Optional time period passed to timeout command.
        """
        if script_arguments is not None:
            pulumi.set(__self__, "script_arguments", script_arguments)
        if script_data is not None:
            pulumi.set(__self__, "script_data", script_data)
        if script_source is not None:
            pulumi.set(__self__, "script_source", script_source)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter(name="scriptArguments")
    def script_arguments(self) -> Optional[pulumi.Input[str]]:
        """
        Optional command line arguments passed to the script to run.
        """
        return pulumi.get(self, "script_arguments")

    @script_arguments.setter
    def script_arguments(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "script_arguments", value)

    @property
    @pulumi.getter(name="scriptData")
    def script_data(self) -> Optional[pulumi.Input[str]]:
        """
        The location of scripts in the mounted volume.
        """
        return pulumi.get(self, "script_data")

    @script_data.setter
    def script_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "script_data", value)

    @property
    @pulumi.getter(name="scriptSource")
    def script_source(self) -> Optional[pulumi.Input[str]]:
        """
        The storage source of the script: inline, workspace.
        """
        return pulumi.get(self, "script_source")

    @script_source.setter
    def script_source(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "script_source", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[str]]:
        """
        Optional time period passed to timeout command.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timeout", value)


@pulumi.input_type
class ScriptsToExecuteArgs:
    def __init__(__self__, *,
                 creation_script: Optional[pulumi.Input['ScriptReferenceArgs']] = None,
                 startup_script: Optional[pulumi.Input['ScriptReferenceArgs']] = None):
        """
        Customized setup scripts
        :param pulumi.Input['ScriptReferenceArgs'] creation_script: Script that's run only once during provision of the compute.
        :param pulumi.Input['ScriptReferenceArgs'] startup_script: Script that's run every time the machine starts.
        """
        if creation_script is not None:
            pulumi.set(__self__, "creation_script", creation_script)
        if startup_script is not None:
            pulumi.set(__self__, "startup_script", startup_script)

    @property
    @pulumi.getter(name="creationScript")
    def creation_script(self) -> Optional[pulumi.Input['ScriptReferenceArgs']]:
        """
        Script that's run only once during provision of the compute.
        """
        return pulumi.get(self, "creation_script")

    @creation_script.setter
    def creation_script(self, value: Optional[pulumi.Input['ScriptReferenceArgs']]):
        pulumi.set(self, "creation_script", value)

    @property
    @pulumi.getter(name="startupScript")
    def startup_script(self) -> Optional[pulumi.Input['ScriptReferenceArgs']]:
        """
        Script that's run every time the machine starts.
        """
        return pulumi.get(self, "startup_script")

    @startup_script.setter
    def startup_script(self, value: Optional[pulumi.Input['ScriptReferenceArgs']]):
        pulumi.set(self, "startup_script", value)


@pulumi.input_type
class ServiceManagedResourcesSettingsArgs:
    def __init__(__self__, *,
                 cosmos_db: Optional[pulumi.Input['CosmosDbSettingsArgs']] = None):
        """
        :param pulumi.Input['CosmosDbSettingsArgs'] cosmos_db: The settings for the service managed cosmosdb account.
        """
        if cosmos_db is not None:
            pulumi.set(__self__, "cosmos_db", cosmos_db)

    @property
    @pulumi.getter(name="cosmosDb")
    def cosmos_db(self) -> Optional[pulumi.Input['CosmosDbSettingsArgs']]:
        """
        The settings for the service managed cosmosdb account.
        """
        return pulumi.get(self, "cosmos_db")

    @cosmos_db.setter
    def cosmos_db(self, value: Optional[pulumi.Input['CosmosDbSettingsArgs']]):
        pulumi.set(self, "cosmos_db", value)


@pulumi.input_type
class ServicePrincipalAuthTypeWorkspaceConnectionPropertiesArgs:
    def __init__(__self__, *,
                 auth_type: pulumi.Input[str],
                 category: Optional[pulumi.Input[Union[str, 'ConnectionCategory']]] = None,
                 credentials: Optional[pulumi.Input['WorkspaceConnectionServicePrincipalArgs']] = None,
                 target: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None,
                 value_format: Optional[pulumi.Input[Union[str, 'ValueFormat']]] = None):
        """
        :param pulumi.Input[str] auth_type: Authentication type of the connection target
               Expected value is 'ServicePrincipal'.
        :param pulumi.Input[Union[str, 'ConnectionCategory']] category: Category of the connection
        :param pulumi.Input[str] value: Value details of the workspace connection.
        :param pulumi.Input[Union[str, 'ValueFormat']] value_format: format for the workspace connection value
        """
        pulumi.set(__self__, "auth_type", 'ServicePrincipal')
        if category is not None:
            pulumi.set(__self__, "category", category)
        if credentials is not None:
            pulumi.set(__self__, "credentials", credentials)
        if target is not None:
            pulumi.set(__self__, "target", target)
        if value is not None:
            pulumi.set(__self__, "value", value)
        if value_format is not None:
            pulumi.set(__self__, "value_format", value_format)

    @property
    @pulumi.getter(name="authType")
    def auth_type(self) -> pulumi.Input[str]:
        """
        Authentication type of the connection target
        Expected value is 'ServicePrincipal'.
        """
        return pulumi.get(self, "auth_type")

    @auth_type.setter
    def auth_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "auth_type", value)

    @property
    @pulumi.getter
    def category(self) -> Optional[pulumi.Input[Union[str, 'ConnectionCategory']]]:
        """
        Category of the connection
        """
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: Optional[pulumi.Input[Union[str, 'ConnectionCategory']]]):
        pulumi.set(self, "category", value)

    @property
    @pulumi.getter
    def credentials(self) -> Optional[pulumi.Input['WorkspaceConnectionServicePrincipalArgs']]:
        return pulumi.get(self, "credentials")

    @credentials.setter
    def credentials(self, value: Optional[pulumi.Input['WorkspaceConnectionServicePrincipalArgs']]):
        pulumi.set(self, "credentials", value)

    @property
    @pulumi.getter
    def target(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        Value details of the workspace connection.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter(name="valueFormat")
    def value_format(self) -> Optional[pulumi.Input[Union[str, 'ValueFormat']]]:
        """
        format for the workspace connection value
        """
        return pulumi.get(self, "value_format")

    @value_format.setter
    def value_format(self, value: Optional[pulumi.Input[Union[str, 'ValueFormat']]]):
        pulumi.set(self, "value_format", value)


@pulumi.input_type
class ServicePrincipalDatastoreCredentialsArgs:
    def __init__(__self__, *,
                 client_id: pulumi.Input[str],
                 credentials_type: pulumi.Input[str],
                 secrets: pulumi.Input['ServicePrincipalDatastoreSecretsArgs'],
                 tenant_id: pulumi.Input[str],
                 authority_url: Optional[pulumi.Input[str]] = None,
                 resource_url: Optional[pulumi.Input[str]] = None):
        """
        Service Principal datastore credentials configuration.
        :param pulumi.Input[str] client_id: [Required] Service principal client ID.
        :param pulumi.Input[str] credentials_type: Enum to determine the datastore credentials type.
               Expected value is 'ServicePrincipal'.
        :param pulumi.Input['ServicePrincipalDatastoreSecretsArgs'] secrets: [Required] Service principal secrets.
        :param pulumi.Input[str] tenant_id: [Required] ID of the tenant to which the service principal belongs.
        :param pulumi.Input[str] authority_url: Authority URL used for authentication.
        :param pulumi.Input[str] resource_url: Resource the service principal has access to.
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "credentials_type", 'ServicePrincipal')
        pulumi.set(__self__, "secrets", secrets)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if authority_url is not None:
            pulumi.set(__self__, "authority_url", authority_url)
        if resource_url is not None:
            pulumi.set(__self__, "resource_url", resource_url)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Input[str]:
        """
        [Required] Service principal client ID.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="credentialsType")
    def credentials_type(self) -> pulumi.Input[str]:
        """
        Enum to determine the datastore credentials type.
        Expected value is 'ServicePrincipal'.
        """
        return pulumi.get(self, "credentials_type")

    @credentials_type.setter
    def credentials_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "credentials_type", value)

    @property
    @pulumi.getter
    def secrets(self) -> pulumi.Input['ServicePrincipalDatastoreSecretsArgs']:
        """
        [Required] Service principal secrets.
        """
        return pulumi.get(self, "secrets")

    @secrets.setter
    def secrets(self, value: pulumi.Input['ServicePrincipalDatastoreSecretsArgs']):
        pulumi.set(self, "secrets", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[str]:
        """
        [Required] ID of the tenant to which the service principal belongs.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="authorityUrl")
    def authority_url(self) -> Optional[pulumi.Input[str]]:
        """
        Authority URL used for authentication.
        """
        return pulumi.get(self, "authority_url")

    @authority_url.setter
    def authority_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authority_url", value)

    @property
    @pulumi.getter(name="resourceUrl")
    def resource_url(self) -> Optional[pulumi.Input[str]]:
        """
        Resource the service principal has access to.
        """
        return pulumi.get(self, "resource_url")

    @resource_url.setter
    def resource_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_url", value)


@pulumi.input_type
class ServicePrincipalDatastoreSecretsArgs:
    def __init__(__self__, *,
                 secrets_type: pulumi.Input[str],
                 client_secret: Optional[pulumi.Input[str]] = None):
        """
        Datastore Service Principal secrets.
        :param pulumi.Input[str] secrets_type: Enum to determine the datastore secrets type.
               Expected value is 'ServicePrincipal'.
        :param pulumi.Input[str] client_secret: Service principal secret.
        """
        pulumi.set(__self__, "secrets_type", 'ServicePrincipal')
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)

    @property
    @pulumi.getter(name="secretsType")
    def secrets_type(self) -> pulumi.Input[str]:
        """
        Enum to determine the datastore secrets type.
        Expected value is 'ServicePrincipal'.
        """
        return pulumi.get(self, "secrets_type")

    @secrets_type.setter
    def secrets_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "secrets_type", value)

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[pulumi.Input[str]]:
        """
        Service principal secret.
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_secret", value)


@pulumi.input_type
class SetupScriptsArgs:
    def __init__(__self__, *,
                 scripts: Optional[pulumi.Input['ScriptsToExecuteArgs']] = None):
        """
        Details of customized scripts to execute for setting up the cluster.
        :param pulumi.Input['ScriptsToExecuteArgs'] scripts: Customized setup scripts
        """
        if scripts is not None:
            pulumi.set(__self__, "scripts", scripts)

    @property
    @pulumi.getter
    def scripts(self) -> Optional[pulumi.Input['ScriptsToExecuteArgs']]:
        """
        Customized setup scripts
        """
        return pulumi.get(self, "scripts")

    @scripts.setter
    def scripts(self, value: Optional[pulumi.Input['ScriptsToExecuteArgs']]):
        pulumi.set(self, "scripts", value)


@pulumi.input_type
class SharedPrivateLinkResourceArgs:
    def __init__(__self__, *,
                 group_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 private_link_resource_id: Optional[pulumi.Input[str]] = None,
                 request_message: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[Union[str, 'PrivateEndpointServiceConnectionStatus']]] = None):
        """
        :param pulumi.Input[str] group_id: The private link resource group id.
        :param pulumi.Input[str] name: Unique name of the private link.
        :param pulumi.Input[str] private_link_resource_id: The resource id that private link links to.
        :param pulumi.Input[str] request_message: Request message.
        :param pulumi.Input[Union[str, 'PrivateEndpointServiceConnectionStatus']] status: Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
        """
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_link_resource_id is not None:
            pulumi.set(__self__, "private_link_resource_id", private_link_resource_id)
        if request_message is not None:
            pulumi.set(__self__, "request_message", request_message)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The private link resource group id.
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Unique name of the private link.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="privateLinkResourceId")
    def private_link_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        The resource id that private link links to.
        """
        return pulumi.get(self, "private_link_resource_id")

    @private_link_resource_id.setter
    def private_link_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_link_resource_id", value)

    @property
    @pulumi.getter(name="requestMessage")
    def request_message(self) -> Optional[pulumi.Input[str]]:
        """
        Request message.
        """
        return pulumi.get(self, "request_message")

    @request_message.setter
    def request_message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "request_message", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[Union[str, 'PrivateEndpointServiceConnectionStatus']]]:
        """
        Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[Union[str, 'PrivateEndpointServiceConnectionStatus']]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class SkuArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 capacity: Optional[pulumi.Input[int]] = None,
                 family: Optional[pulumi.Input[str]] = None,
                 size: Optional[pulumi.Input[str]] = None,
                 tier: Optional[pulumi.Input['SkuTier']] = None):
        """
        The resource model definition representing SKU
        :param pulumi.Input[str] name: The name of the SKU. Ex - P3. It is typically a letter+number code
        :param pulumi.Input[int] capacity: If the SKU supports scale out/in then the capacity integer should be included. If scale out/in is not possible for the resource this may be omitted.
        :param pulumi.Input[str] family: If the service has different generations of hardware, for the same SKU, then that can be captured here.
        :param pulumi.Input[str] size: The SKU size. When the name field is the combination of tier and some other value, this would be the standalone code. 
        :param pulumi.Input['SkuTier'] tier: This field is required to be implemented by the Resource Provider if the service has more than one tier, but is not required on a PUT.
        """
        pulumi.set(__self__, "name", name)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if family is not None:
            pulumi.set(__self__, "family", family)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the SKU. Ex - P3. It is typically a letter+number code
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def capacity(self) -> Optional[pulumi.Input[int]]:
        """
        If the SKU supports scale out/in then the capacity integer should be included. If scale out/in is not possible for the resource this may be omitted.
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "capacity", value)

    @property
    @pulumi.getter
    def family(self) -> Optional[pulumi.Input[str]]:
        """
        If the service has different generations of hardware, for the same SKU, then that can be captured here.
        """
        return pulumi.get(self, "family")

    @family.setter
    def family(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "family", value)

    @property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[str]]:
        """
        The SKU size. When the name field is the combination of tier and some other value, this would be the standalone code. 
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter
    def tier(self) -> Optional[pulumi.Input['SkuTier']]:
        """
        This field is required to be implemented by the Resource Provider if the service has more than one tier, but is not required on a PUT.
        """
        return pulumi.get(self, "tier")

    @tier.setter
    def tier(self, value: Optional[pulumi.Input['SkuTier']]):
        pulumi.set(self, "tier", value)


@pulumi.input_type
class SparkJobPythonEntryArgs:
    def __init__(__self__, *,
                 file: pulumi.Input[str],
                 spark_job_entry_type: pulumi.Input[str]):
        """
        :param pulumi.Input[str] file: [Required] Relative python file path for job entry point.
        :param pulumi.Input[str] spark_job_entry_type: 
               Expected value is 'SparkJobPythonEntry'.
        """
        pulumi.set(__self__, "file", file)
        pulumi.set(__self__, "spark_job_entry_type", 'SparkJobPythonEntry')

    @property
    @pulumi.getter
    def file(self) -> pulumi.Input[str]:
        """
        [Required] Relative python file path for job entry point.
        """
        return pulumi.get(self, "file")

    @file.setter
    def file(self, value: pulumi.Input[str]):
        pulumi.set(self, "file", value)

    @property
    @pulumi.getter(name="sparkJobEntryType")
    def spark_job_entry_type(self) -> pulumi.Input[str]:
        """

        Expected value is 'SparkJobPythonEntry'.
        """
        return pulumi.get(self, "spark_job_entry_type")

    @spark_job_entry_type.setter
    def spark_job_entry_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "spark_job_entry_type", value)


@pulumi.input_type
class SparkJobScalaEntryArgs:
    def __init__(__self__, *,
                 class_name: pulumi.Input[str],
                 spark_job_entry_type: pulumi.Input[str]):
        """
        :param pulumi.Input[str] class_name: [Required] Scala class name used as entry point.
        :param pulumi.Input[str] spark_job_entry_type: 
               Expected value is 'SparkJobScalaEntry'.
        """
        pulumi.set(__self__, "class_name", class_name)
        pulumi.set(__self__, "spark_job_entry_type", 'SparkJobScalaEntry')

    @property
    @pulumi.getter(name="className")
    def class_name(self) -> pulumi.Input[str]:
        """
        [Required] Scala class name used as entry point.
        """
        return pulumi.get(self, "class_name")

    @class_name.setter
    def class_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "class_name", value)

    @property
    @pulumi.getter(name="sparkJobEntryType")
    def spark_job_entry_type(self) -> pulumi.Input[str]:
        """

        Expected value is 'SparkJobScalaEntry'.
        """
        return pulumi.get(self, "spark_job_entry_type")

    @spark_job_entry_type.setter
    def spark_job_entry_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "spark_job_entry_type", value)


@pulumi.input_type
class SparkJobArgs:
    def __init__(__self__, *,
                 code_id: pulumi.Input[str],
                 entry: pulumi.Input[Union['SparkJobPythonEntryArgs', 'SparkJobScalaEntryArgs']],
                 job_type: pulumi.Input[str],
                 archives: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 args: Optional[pulumi.Input[str]] = None,
                 component_id: Optional[pulumi.Input[str]] = None,
                 compute_id: Optional[pulumi.Input[str]] = None,
                 conf: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 environment_id: Optional[pulumi.Input[str]] = None,
                 experiment_name: Optional[pulumi.Input[str]] = None,
                 files: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 identity: Optional[pulumi.Input[Union['AmlTokenArgs', 'ManagedIdentityArgs', 'UserIdentityArgs']]] = None,
                 inputs: Optional[pulumi.Input[Mapping[str, pulumi.Input[Union['CustomModelJobInputArgs', 'LiteralJobInputArgs', 'MLFlowModelJobInputArgs', 'MLTableJobInputArgs', 'TritonModelJobInputArgs', 'UriFileJobInputArgs', 'UriFolderJobInputArgs']]]]] = None,
                 is_archived: Optional[pulumi.Input[bool]] = None,
                 jars: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 outputs: Optional[pulumi.Input[Mapping[str, pulumi.Input[Union['CustomModelJobOutputArgs', 'MLFlowModelJobOutputArgs', 'MLTableJobOutputArgs', 'TritonModelJobOutputArgs', 'UriFileJobOutputArgs', 'UriFolderJobOutputArgs']]]]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 py_files: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 resources: Optional[pulumi.Input['SparkResourceConfigurationArgs']] = None,
                 services: Optional[pulumi.Input[Mapping[str, pulumi.Input['JobServiceArgs']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Spark job definition.
        :param pulumi.Input[str] code_id: [Required] ARM resource ID of the code asset.
        :param pulumi.Input[Union['SparkJobPythonEntryArgs', 'SparkJobScalaEntryArgs']] entry: [Required] The entry to execute on startup of the job.
        :param pulumi.Input[str] job_type: Enum to determine the type of job.
               Expected value is 'Spark'.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] archives: Archive files used in the job.
        :param pulumi.Input[str] args: Arguments for the job.
        :param pulumi.Input[str] component_id: ARM resource ID of the component resource.
        :param pulumi.Input[str] compute_id: ARM resource ID of the compute resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] conf: Spark configured properties.
        :param pulumi.Input[str] description: The asset description text.
        :param pulumi.Input[str] display_name: Display name of job.
        :param pulumi.Input[str] environment_id: The ARM resource ID of the Environment specification for the job.
        :param pulumi.Input[str] experiment_name: The name of the experiment the job belongs to. If not set, the job is placed in the "Default" experiment.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] files: Files used in the job.
        :param pulumi.Input[Union['AmlTokenArgs', 'ManagedIdentityArgs', 'UserIdentityArgs']] identity: Identity configuration. If set, this should be one of AmlToken, ManagedIdentity, UserIdentity or null.
               Defaults to AmlToken if null.
        :param pulumi.Input[Mapping[str, pulumi.Input[Union['CustomModelJobInputArgs', 'LiteralJobInputArgs', 'MLFlowModelJobInputArgs', 'MLTableJobInputArgs', 'TritonModelJobInputArgs', 'UriFileJobInputArgs', 'UriFolderJobInputArgs']]]] inputs: Mapping of input data bindings used in the job.
        :param pulumi.Input[bool] is_archived: Is the asset archived?
        :param pulumi.Input[Sequence[pulumi.Input[str]]] jars: Jar files used in the job.
        :param pulumi.Input[Mapping[str, pulumi.Input[Union['CustomModelJobOutputArgs', 'MLFlowModelJobOutputArgs', 'MLTableJobOutputArgs', 'TritonModelJobOutputArgs', 'UriFileJobOutputArgs', 'UriFolderJobOutputArgs']]]] outputs: Mapping of output data bindings used in the job.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: The asset property dictionary.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] py_files: Python files used in the job.
        :param pulumi.Input['SparkResourceConfigurationArgs'] resources: Compute Resource configuration for the job.
        :param pulumi.Input[Mapping[str, pulumi.Input['JobServiceArgs']]] services: List of JobEndpoints.
               For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Tag dictionary. Tags can be added, removed, and updated.
        """
        pulumi.set(__self__, "code_id", code_id)
        pulumi.set(__self__, "entry", entry)
        pulumi.set(__self__, "job_type", 'Spark')
        if archives is not None:
            pulumi.set(__self__, "archives", archives)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if component_id is not None:
            pulumi.set(__self__, "component_id", component_id)
        if compute_id is not None:
            pulumi.set(__self__, "compute_id", compute_id)
        if conf is not None:
            pulumi.set(__self__, "conf", conf)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if environment_id is not None:
            pulumi.set(__self__, "environment_id", environment_id)
        if experiment_name is None:
            experiment_name = 'Default'
        if experiment_name is not None:
            pulumi.set(__self__, "experiment_name", experiment_name)
        if files is not None:
            pulumi.set(__self__, "files", files)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if inputs is not None:
            pulumi.set(__self__, "inputs", inputs)
        if is_archived is None:
            is_archived = False
        if is_archived is not None:
            pulumi.set(__self__, "is_archived", is_archived)
        if jars is not None:
            pulumi.set(__self__, "jars", jars)
        if outputs is not None:
            pulumi.set(__self__, "outputs", outputs)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if py_files is not None:
            pulumi.set(__self__, "py_files", py_files)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)
        if services is not None:
            pulumi.set(__self__, "services", services)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="codeId")
    def code_id(self) -> pulumi.Input[str]:
        """
        [Required] ARM resource ID of the code asset.
        """
        return pulumi.get(self, "code_id")

    @code_id.setter
    def code_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "code_id", value)

    @property
    @pulumi.getter
    def entry(self) -> pulumi.Input[Union['SparkJobPythonEntryArgs', 'SparkJobScalaEntryArgs']]:
        """
        [Required] The entry to execute on startup of the job.
        """
        return pulumi.get(self, "entry")

    @entry.setter
    def entry(self, value: pulumi.Input[Union['SparkJobPythonEntryArgs', 'SparkJobScalaEntryArgs']]):
        pulumi.set(self, "entry", value)

    @property
    @pulumi.getter(name="jobType")
    def job_type(self) -> pulumi.Input[str]:
        """
        Enum to determine the type of job.
        Expected value is 'Spark'.
        """
        return pulumi.get(self, "job_type")

    @job_type.setter
    def job_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "job_type", value)

    @property
    @pulumi.getter
    def archives(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Archive files used in the job.
        """
        return pulumi.get(self, "archives")

    @archives.setter
    def archives(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "archives", value)

    @property
    @pulumi.getter
    def args(self) -> Optional[pulumi.Input[str]]:
        """
        Arguments for the job.
        """
        return pulumi.get(self, "args")

    @args.setter
    def args(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "args", value)

    @property
    @pulumi.getter(name="componentId")
    def component_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM resource ID of the component resource.
        """
        return pulumi.get(self, "component_id")

    @component_id.setter
    def component_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "component_id", value)

    @property
    @pulumi.getter(name="computeId")
    def compute_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM resource ID of the compute resource.
        """
        return pulumi.get(self, "compute_id")

    @compute_id.setter
    def compute_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compute_id", value)

    @property
    @pulumi.getter
    def conf(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Spark configured properties.
        """
        return pulumi.get(self, "conf")

    @conf.setter
    def conf(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "conf", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The asset description text.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        Display name of job.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ARM resource ID of the Environment specification for the job.
        """
        return pulumi.get(self, "environment_id")

    @environment_id.setter
    def environment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "environment_id", value)

    @property
    @pulumi.getter(name="experimentName")
    def experiment_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the experiment the job belongs to. If not set, the job is placed in the "Default" experiment.
        """
        return pulumi.get(self, "experiment_name")

    @experiment_name.setter
    def experiment_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "experiment_name", value)

    @property
    @pulumi.getter
    def files(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Files used in the job.
        """
        return pulumi.get(self, "files")

    @files.setter
    def files(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "files", value)

    @property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input[Union['AmlTokenArgs', 'ManagedIdentityArgs', 'UserIdentityArgs']]]:
        """
        Identity configuration. If set, this should be one of AmlToken, ManagedIdentity, UserIdentity or null.
        Defaults to AmlToken if null.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input[Union['AmlTokenArgs', 'ManagedIdentityArgs', 'UserIdentityArgs']]]):
        pulumi.set(self, "identity", value)

    @property
    @pulumi.getter
    def inputs(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[Union['CustomModelJobInputArgs', 'LiteralJobInputArgs', 'MLFlowModelJobInputArgs', 'MLTableJobInputArgs', 'TritonModelJobInputArgs', 'UriFileJobInputArgs', 'UriFolderJobInputArgs']]]]]:
        """
        Mapping of input data bindings used in the job.
        """
        return pulumi.get(self, "inputs")

    @inputs.setter
    def inputs(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[Union['CustomModelJobInputArgs', 'LiteralJobInputArgs', 'MLFlowModelJobInputArgs', 'MLTableJobInputArgs', 'TritonModelJobInputArgs', 'UriFileJobInputArgs', 'UriFolderJobInputArgs']]]]]):
        pulumi.set(self, "inputs", value)

    @property
    @pulumi.getter(name="isArchived")
    def is_archived(self) -> Optional[pulumi.Input[bool]]:
        """
        Is the asset archived?
        """
        return pulumi.get(self, "is_archived")

    @is_archived.setter
    def is_archived(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_archived", value)

    @property
    @pulumi.getter
    def jars(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Jar files used in the job.
        """
        return pulumi.get(self, "jars")

    @jars.setter
    def jars(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "jars", value)

    @property
    @pulumi.getter
    def outputs(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[Union['CustomModelJobOutputArgs', 'MLFlowModelJobOutputArgs', 'MLTableJobOutputArgs', 'TritonModelJobOutputArgs', 'UriFileJobOutputArgs', 'UriFolderJobOutputArgs']]]]]:
        """
        Mapping of output data bindings used in the job.
        """
        return pulumi.get(self, "outputs")

    @outputs.setter
    def outputs(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[Union['CustomModelJobOutputArgs', 'MLFlowModelJobOutputArgs', 'MLTableJobOutputArgs', 'TritonModelJobOutputArgs', 'UriFileJobOutputArgs', 'UriFolderJobOutputArgs']]]]]):
        pulumi.set(self, "outputs", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The asset property dictionary.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter(name="pyFiles")
    def py_files(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Python files used in the job.
        """
        return pulumi.get(self, "py_files")

    @py_files.setter
    def py_files(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "py_files", value)

    @property
    @pulumi.getter
    def resources(self) -> Optional[pulumi.Input['SparkResourceConfigurationArgs']]:
        """
        Compute Resource configuration for the job.
        """
        return pulumi.get(self, "resources")

    @resources.setter
    def resources(self, value: Optional[pulumi.Input['SparkResourceConfigurationArgs']]):
        pulumi.set(self, "resources", value)

    @property
    @pulumi.getter
    def services(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['JobServiceArgs']]]]:
        """
        List of JobEndpoints.
        For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
        """
        return pulumi.get(self, "services")

    @services.setter
    def services(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['JobServiceArgs']]]]):
        pulumi.set(self, "services", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Tag dictionary. Tags can be added, removed, and updated.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class SparkResourceConfigurationArgs:
    def __init__(__self__, *,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 runtime_version: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] instance_type: Optional type of VM used as supported by the compute target.
        :param pulumi.Input[str] runtime_version: Version of spark runtime used for the job.
        """
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if runtime_version is None:
            runtime_version = '3.1'
        if runtime_version is not None:
            pulumi.set(__self__, "runtime_version", runtime_version)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[str]]:
        """
        Optional type of VM used as supported by the compute target.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="runtimeVersion")
    def runtime_version(self) -> Optional[pulumi.Input[str]]:
        """
        Version of spark runtime used for the job.
        """
        return pulumi.get(self, "runtime_version")

    @runtime_version.setter
    def runtime_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "runtime_version", value)


@pulumi.input_type
class SslConfigurationArgs:
    def __init__(__self__, *,
                 cert: Optional[pulumi.Input[str]] = None,
                 cname: Optional[pulumi.Input[str]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 leaf_domain_label: Optional[pulumi.Input[str]] = None,
                 overwrite_existing_domain: Optional[pulumi.Input[bool]] = None,
                 status: Optional[pulumi.Input[Union[str, 'SslConfigStatus']]] = None):
        """
        The ssl configuration for scoring
        :param pulumi.Input[str] cert: Cert data
        :param pulumi.Input[str] cname: CNAME of the cert
        :param pulumi.Input[str] key: Key data
        :param pulumi.Input[str] leaf_domain_label: Leaf domain label of public endpoint
        :param pulumi.Input[bool] overwrite_existing_domain: Indicates whether to overwrite existing domain label.
        :param pulumi.Input[Union[str, 'SslConfigStatus']] status: Enable or disable ssl for scoring
        """
        if cert is not None:
            pulumi.set(__self__, "cert", cert)
        if cname is not None:
            pulumi.set(__self__, "cname", cname)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if leaf_domain_label is not None:
            pulumi.set(__self__, "leaf_domain_label", leaf_domain_label)
        if overwrite_existing_domain is not None:
            pulumi.set(__self__, "overwrite_existing_domain", overwrite_existing_domain)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def cert(self) -> Optional[pulumi.Input[str]]:
        """
        Cert data
        """
        return pulumi.get(self, "cert")

    @cert.setter
    def cert(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cert", value)

    @property
    @pulumi.getter
    def cname(self) -> Optional[pulumi.Input[str]]:
        """
        CNAME of the cert
        """
        return pulumi.get(self, "cname")

    @cname.setter
    def cname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cname", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        Key data
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter(name="leafDomainLabel")
    def leaf_domain_label(self) -> Optional[pulumi.Input[str]]:
        """
        Leaf domain label of public endpoint
        """
        return pulumi.get(self, "leaf_domain_label")

    @leaf_domain_label.setter
    def leaf_domain_label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "leaf_domain_label", value)

    @property
    @pulumi.getter(name="overwriteExistingDomain")
    def overwrite_existing_domain(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether to overwrite existing domain label.
        """
        return pulumi.get(self, "overwrite_existing_domain")

    @overwrite_existing_domain.setter
    def overwrite_existing_domain(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "overwrite_existing_domain", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[Union[str, 'SslConfigStatus']]]:
        """
        Enable or disable ssl for scoring
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[Union[str, 'SslConfigStatus']]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class StackEnsembleSettingsArgs:
    def __init__(__self__, *,
                 stack_meta_learner_k_wargs: Optional[Any] = None,
                 stack_meta_learner_train_percentage: Optional[pulumi.Input[float]] = None,
                 stack_meta_learner_type: Optional[pulumi.Input[Union[str, 'StackMetaLearnerType']]] = None):
        """
        Advances setting to customize StackEnsemble run.
        :param Any stack_meta_learner_k_wargs: Optional parameters to pass to the initializer of the meta-learner.
        :param pulumi.Input[float] stack_meta_learner_train_percentage: Specifies the proportion of the training set (when choosing train and validation type of training) to be reserved for training the meta-learner. Default value is 0.2.
        :param pulumi.Input[Union[str, 'StackMetaLearnerType']] stack_meta_learner_type: The meta-learner is a model trained on the output of the individual heterogeneous models.
        """
        if stack_meta_learner_k_wargs is not None:
            pulumi.set(__self__, "stack_meta_learner_k_wargs", stack_meta_learner_k_wargs)
        if stack_meta_learner_train_percentage is None:
            stack_meta_learner_train_percentage = 0.2
        if stack_meta_learner_train_percentage is not None:
            pulumi.set(__self__, "stack_meta_learner_train_percentage", stack_meta_learner_train_percentage)
        if stack_meta_learner_type is None:
            stack_meta_learner_type = 'None'
        if stack_meta_learner_type is not None:
            pulumi.set(__self__, "stack_meta_learner_type", stack_meta_learner_type)

    @property
    @pulumi.getter(name="stackMetaLearnerKWargs")
    def stack_meta_learner_k_wargs(self) -> Optional[Any]:
        """
        Optional parameters to pass to the initializer of the meta-learner.
        """
        return pulumi.get(self, "stack_meta_learner_k_wargs")

    @stack_meta_learner_k_wargs.setter
    def stack_meta_learner_k_wargs(self, value: Optional[Any]):
        pulumi.set(self, "stack_meta_learner_k_wargs", value)

    @property
    @pulumi.getter(name="stackMetaLearnerTrainPercentage")
    def stack_meta_learner_train_percentage(self) -> Optional[pulumi.Input[float]]:
        """
        Specifies the proportion of the training set (when choosing train and validation type of training) to be reserved for training the meta-learner. Default value is 0.2.
        """
        return pulumi.get(self, "stack_meta_learner_train_percentage")

    @stack_meta_learner_train_percentage.setter
    def stack_meta_learner_train_percentage(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "stack_meta_learner_train_percentage", value)

    @property
    @pulumi.getter(name="stackMetaLearnerType")
    def stack_meta_learner_type(self) -> Optional[pulumi.Input[Union[str, 'StackMetaLearnerType']]]:
        """
        The meta-learner is a model trained on the output of the individual heterogeneous models.
        """
        return pulumi.get(self, "stack_meta_learner_type")

    @stack_meta_learner_type.setter
    def stack_meta_learner_type(self, value: Optional[pulumi.Input[Union[str, 'StackMetaLearnerType']]]):
        pulumi.set(self, "stack_meta_learner_type", value)


@pulumi.input_type
class StorageAccountDetailsArgs:
    def __init__(__self__, *,
                 system_created_storage_account: Optional[pulumi.Input['SystemCreatedStorageAccountArgs']] = None,
                 user_created_storage_account: Optional[pulumi.Input['UserCreatedStorageAccountArgs']] = None):
        """
        Details of storage account to be used for the Registry
        """
        if system_created_storage_account is not None:
            pulumi.set(__self__, "system_created_storage_account", system_created_storage_account)
        if user_created_storage_account is not None:
            pulumi.set(__self__, "user_created_storage_account", user_created_storage_account)

    @property
    @pulumi.getter(name="systemCreatedStorageAccount")
    def system_created_storage_account(self) -> Optional[pulumi.Input['SystemCreatedStorageAccountArgs']]:
        return pulumi.get(self, "system_created_storage_account")

    @system_created_storage_account.setter
    def system_created_storage_account(self, value: Optional[pulumi.Input['SystemCreatedStorageAccountArgs']]):
        pulumi.set(self, "system_created_storage_account", value)

    @property
    @pulumi.getter(name="userCreatedStorageAccount")
    def user_created_storage_account(self) -> Optional[pulumi.Input['UserCreatedStorageAccountArgs']]:
        return pulumi.get(self, "user_created_storage_account")

    @user_created_storage_account.setter
    def user_created_storage_account(self, value: Optional[pulumi.Input['UserCreatedStorageAccountArgs']]):
        pulumi.set(self, "user_created_storage_account", value)


@pulumi.input_type
class SweepJobLimitsArgs:
    def __init__(__self__, *,
                 job_limits_type: pulumi.Input[str],
                 max_concurrent_trials: Optional[pulumi.Input[int]] = None,
                 max_total_trials: Optional[pulumi.Input[int]] = None,
                 timeout: Optional[pulumi.Input[str]] = None,
                 trial_timeout: Optional[pulumi.Input[str]] = None):
        """
        Sweep Job limit class.
        :param pulumi.Input[str] job_limits_type: 
               Expected value is 'Sweep'.
        :param pulumi.Input[int] max_concurrent_trials: Sweep Job max concurrent trials.
        :param pulumi.Input[int] max_total_trials: Sweep Job max total trials.
        :param pulumi.Input[str] timeout: The max run duration in ISO 8601 format, after which the job will be cancelled. Only supports duration with precision as low as Seconds.
        :param pulumi.Input[str] trial_timeout: Sweep Job Trial timeout value.
        """
        pulumi.set(__self__, "job_limits_type", 'Sweep')
        if max_concurrent_trials is not None:
            pulumi.set(__self__, "max_concurrent_trials", max_concurrent_trials)
        if max_total_trials is not None:
            pulumi.set(__self__, "max_total_trials", max_total_trials)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if trial_timeout is not None:
            pulumi.set(__self__, "trial_timeout", trial_timeout)

    @property
    @pulumi.getter(name="jobLimitsType")
    def job_limits_type(self) -> pulumi.Input[str]:
        """

        Expected value is 'Sweep'.
        """
        return pulumi.get(self, "job_limits_type")

    @job_limits_type.setter
    def job_limits_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "job_limits_type", value)

    @property
    @pulumi.getter(name="maxConcurrentTrials")
    def max_concurrent_trials(self) -> Optional[pulumi.Input[int]]:
        """
        Sweep Job max concurrent trials.
        """
        return pulumi.get(self, "max_concurrent_trials")

    @max_concurrent_trials.setter
    def max_concurrent_trials(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_concurrent_trials", value)

    @property
    @pulumi.getter(name="maxTotalTrials")
    def max_total_trials(self) -> Optional[pulumi.Input[int]]:
        """
        Sweep Job max total trials.
        """
        return pulumi.get(self, "max_total_trials")

    @max_total_trials.setter
    def max_total_trials(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_total_trials", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[str]]:
        """
        The max run duration in ISO 8601 format, after which the job will be cancelled. Only supports duration with precision as low as Seconds.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timeout", value)

    @property
    @pulumi.getter(name="trialTimeout")
    def trial_timeout(self) -> Optional[pulumi.Input[str]]:
        """
        Sweep Job Trial timeout value.
        """
        return pulumi.get(self, "trial_timeout")

    @trial_timeout.setter
    def trial_timeout(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "trial_timeout", value)


@pulumi.input_type
class SweepJobArgs:
    def __init__(__self__, *,
                 job_type: pulumi.Input[str],
                 objective: pulumi.Input['ObjectiveArgs'],
                 sampling_algorithm: pulumi.Input[Union['BayesianSamplingAlgorithmArgs', 'GridSamplingAlgorithmArgs', 'RandomSamplingAlgorithmArgs']],
                 search_space: Any,
                 trial: pulumi.Input['TrialComponentArgs'],
                 component_id: Optional[pulumi.Input[str]] = None,
                 compute_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 early_termination: Optional[pulumi.Input[Union['BanditPolicyArgs', 'MedianStoppingPolicyArgs', 'TruncationSelectionPolicyArgs']]] = None,
                 experiment_name: Optional[pulumi.Input[str]] = None,
                 identity: Optional[pulumi.Input[Union['AmlTokenArgs', 'ManagedIdentityArgs', 'UserIdentityArgs']]] = None,
                 inputs: Optional[pulumi.Input[Mapping[str, pulumi.Input[Union['CustomModelJobInputArgs', 'LiteralJobInputArgs', 'MLFlowModelJobInputArgs', 'MLTableJobInputArgs', 'TritonModelJobInputArgs', 'UriFileJobInputArgs', 'UriFolderJobInputArgs']]]]] = None,
                 is_archived: Optional[pulumi.Input[bool]] = None,
                 limits: Optional[pulumi.Input['SweepJobLimitsArgs']] = None,
                 outputs: Optional[pulumi.Input[Mapping[str, pulumi.Input[Union['CustomModelJobOutputArgs', 'MLFlowModelJobOutputArgs', 'MLTableJobOutputArgs', 'TritonModelJobOutputArgs', 'UriFileJobOutputArgs', 'UriFolderJobOutputArgs']]]]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 services: Optional[pulumi.Input[Mapping[str, pulumi.Input['JobServiceArgs']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Sweep job definition.
        :param pulumi.Input[str] job_type: Enum to determine the type of job.
               Expected value is 'Sweep'.
        :param pulumi.Input['ObjectiveArgs'] objective: [Required] Optimization objective.
        :param pulumi.Input[Union['BayesianSamplingAlgorithmArgs', 'GridSamplingAlgorithmArgs', 'RandomSamplingAlgorithmArgs']] sampling_algorithm: [Required] The hyperparameter sampling algorithm
        :param Any search_space: [Required] A dictionary containing each parameter and its distribution. The dictionary key is the name of the parameter
        :param pulumi.Input['TrialComponentArgs'] trial: [Required] Trial component definition.
        :param pulumi.Input[str] component_id: ARM resource ID of the component resource.
        :param pulumi.Input[str] compute_id: ARM resource ID of the compute resource.
        :param pulumi.Input[str] description: The asset description text.
        :param pulumi.Input[str] display_name: Display name of job.
        :param pulumi.Input[Union['BanditPolicyArgs', 'MedianStoppingPolicyArgs', 'TruncationSelectionPolicyArgs']] early_termination: Early termination policies enable canceling poor-performing runs before they complete
        :param pulumi.Input[str] experiment_name: The name of the experiment the job belongs to. If not set, the job is placed in the "Default" experiment.
        :param pulumi.Input[Union['AmlTokenArgs', 'ManagedIdentityArgs', 'UserIdentityArgs']] identity: Identity configuration. If set, this should be one of AmlToken, ManagedIdentity, UserIdentity or null.
               Defaults to AmlToken if null.
        :param pulumi.Input[Mapping[str, pulumi.Input[Union['CustomModelJobInputArgs', 'LiteralJobInputArgs', 'MLFlowModelJobInputArgs', 'MLTableJobInputArgs', 'TritonModelJobInputArgs', 'UriFileJobInputArgs', 'UriFolderJobInputArgs']]]] inputs: Mapping of input data bindings used in the job.
        :param pulumi.Input[bool] is_archived: Is the asset archived?
        :param pulumi.Input['SweepJobLimitsArgs'] limits: Sweep Job limit.
        :param pulumi.Input[Mapping[str, pulumi.Input[Union['CustomModelJobOutputArgs', 'MLFlowModelJobOutputArgs', 'MLTableJobOutputArgs', 'TritonModelJobOutputArgs', 'UriFileJobOutputArgs', 'UriFolderJobOutputArgs']]]] outputs: Mapping of output data bindings used in the job.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: The asset property dictionary.
        :param pulumi.Input[Mapping[str, pulumi.Input['JobServiceArgs']]] services: List of JobEndpoints.
               For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Tag dictionary. Tags can be added, removed, and updated.
        """
        pulumi.set(__self__, "job_type", 'Sweep')
        pulumi.set(__self__, "objective", objective)
        pulumi.set(__self__, "sampling_algorithm", sampling_algorithm)
        pulumi.set(__self__, "search_space", search_space)
        pulumi.set(__self__, "trial", trial)
        if component_id is not None:
            pulumi.set(__self__, "component_id", component_id)
        if compute_id is not None:
            pulumi.set(__self__, "compute_id", compute_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if early_termination is not None:
            pulumi.set(__self__, "early_termination", early_termination)
        if experiment_name is None:
            experiment_name = 'Default'
        if experiment_name is not None:
            pulumi.set(__self__, "experiment_name", experiment_name)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if inputs is not None:
            pulumi.set(__self__, "inputs", inputs)
        if is_archived is None:
            is_archived = False
        if is_archived is not None:
            pulumi.set(__self__, "is_archived", is_archived)
        if limits is not None:
            pulumi.set(__self__, "limits", limits)
        if outputs is not None:
            pulumi.set(__self__, "outputs", outputs)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if services is not None:
            pulumi.set(__self__, "services", services)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="jobType")
    def job_type(self) -> pulumi.Input[str]:
        """
        Enum to determine the type of job.
        Expected value is 'Sweep'.
        """
        return pulumi.get(self, "job_type")

    @job_type.setter
    def job_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "job_type", value)

    @property
    @pulumi.getter
    def objective(self) -> pulumi.Input['ObjectiveArgs']:
        """
        [Required] Optimization objective.
        """
        return pulumi.get(self, "objective")

    @objective.setter
    def objective(self, value: pulumi.Input['ObjectiveArgs']):
        pulumi.set(self, "objective", value)

    @property
    @pulumi.getter(name="samplingAlgorithm")
    def sampling_algorithm(self) -> pulumi.Input[Union['BayesianSamplingAlgorithmArgs', 'GridSamplingAlgorithmArgs', 'RandomSamplingAlgorithmArgs']]:
        """
        [Required] The hyperparameter sampling algorithm
        """
        return pulumi.get(self, "sampling_algorithm")

    @sampling_algorithm.setter
    def sampling_algorithm(self, value: pulumi.Input[Union['BayesianSamplingAlgorithmArgs', 'GridSamplingAlgorithmArgs', 'RandomSamplingAlgorithmArgs']]):
        pulumi.set(self, "sampling_algorithm", value)

    @property
    @pulumi.getter(name="searchSpace")
    def search_space(self) -> Any:
        """
        [Required] A dictionary containing each parameter and its distribution. The dictionary key is the name of the parameter
        """
        return pulumi.get(self, "search_space")

    @search_space.setter
    def search_space(self, value: Any):
        pulumi.set(self, "search_space", value)

    @property
    @pulumi.getter
    def trial(self) -> pulumi.Input['TrialComponentArgs']:
        """
        [Required] Trial component definition.
        """
        return pulumi.get(self, "trial")

    @trial.setter
    def trial(self, value: pulumi.Input['TrialComponentArgs']):
        pulumi.set(self, "trial", value)

    @property
    @pulumi.getter(name="componentId")
    def component_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM resource ID of the component resource.
        """
        return pulumi.get(self, "component_id")

    @component_id.setter
    def component_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "component_id", value)

    @property
    @pulumi.getter(name="computeId")
    def compute_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM resource ID of the compute resource.
        """
        return pulumi.get(self, "compute_id")

    @compute_id.setter
    def compute_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compute_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The asset description text.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        Display name of job.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="earlyTermination")
    def early_termination(self) -> Optional[pulumi.Input[Union['BanditPolicyArgs', 'MedianStoppingPolicyArgs', 'TruncationSelectionPolicyArgs']]]:
        """
        Early termination policies enable canceling poor-performing runs before they complete
        """
        return pulumi.get(self, "early_termination")

    @early_termination.setter
    def early_termination(self, value: Optional[pulumi.Input[Union['BanditPolicyArgs', 'MedianStoppingPolicyArgs', 'TruncationSelectionPolicyArgs']]]):
        pulumi.set(self, "early_termination", value)

    @property
    @pulumi.getter(name="experimentName")
    def experiment_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the experiment the job belongs to. If not set, the job is placed in the "Default" experiment.
        """
        return pulumi.get(self, "experiment_name")

    @experiment_name.setter
    def experiment_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "experiment_name", value)

    @property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input[Union['AmlTokenArgs', 'ManagedIdentityArgs', 'UserIdentityArgs']]]:
        """
        Identity configuration. If set, this should be one of AmlToken, ManagedIdentity, UserIdentity or null.
        Defaults to AmlToken if null.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input[Union['AmlTokenArgs', 'ManagedIdentityArgs', 'UserIdentityArgs']]]):
        pulumi.set(self, "identity", value)

    @property
    @pulumi.getter
    def inputs(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[Union['CustomModelJobInputArgs', 'LiteralJobInputArgs', 'MLFlowModelJobInputArgs', 'MLTableJobInputArgs', 'TritonModelJobInputArgs', 'UriFileJobInputArgs', 'UriFolderJobInputArgs']]]]]:
        """
        Mapping of input data bindings used in the job.
        """
        return pulumi.get(self, "inputs")

    @inputs.setter
    def inputs(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[Union['CustomModelJobInputArgs', 'LiteralJobInputArgs', 'MLFlowModelJobInputArgs', 'MLTableJobInputArgs', 'TritonModelJobInputArgs', 'UriFileJobInputArgs', 'UriFolderJobInputArgs']]]]]):
        pulumi.set(self, "inputs", value)

    @property
    @pulumi.getter(name="isArchived")
    def is_archived(self) -> Optional[pulumi.Input[bool]]:
        """
        Is the asset archived?
        """
        return pulumi.get(self, "is_archived")

    @is_archived.setter
    def is_archived(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_archived", value)

    @property
    @pulumi.getter
    def limits(self) -> Optional[pulumi.Input['SweepJobLimitsArgs']]:
        """
        Sweep Job limit.
        """
        return pulumi.get(self, "limits")

    @limits.setter
    def limits(self, value: Optional[pulumi.Input['SweepJobLimitsArgs']]):
        pulumi.set(self, "limits", value)

    @property
    @pulumi.getter
    def outputs(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[Union['CustomModelJobOutputArgs', 'MLFlowModelJobOutputArgs', 'MLTableJobOutputArgs', 'TritonModelJobOutputArgs', 'UriFileJobOutputArgs', 'UriFolderJobOutputArgs']]]]]:
        """
        Mapping of output data bindings used in the job.
        """
        return pulumi.get(self, "outputs")

    @outputs.setter
    def outputs(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[Union['CustomModelJobOutputArgs', 'MLFlowModelJobOutputArgs', 'MLTableJobOutputArgs', 'TritonModelJobOutputArgs', 'UriFileJobOutputArgs', 'UriFolderJobOutputArgs']]]]]):
        pulumi.set(self, "outputs", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The asset property dictionary.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter
    def services(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['JobServiceArgs']]]]:
        """
        List of JobEndpoints.
        For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
        """
        return pulumi.get(self, "services")

    @services.setter
    def services(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['JobServiceArgs']]]]):
        pulumi.set(self, "services", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Tag dictionary. Tags can be added, removed, and updated.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class SynapseSparkPropertiesArgs:
    def __init__(__self__, *,
                 auto_pause_properties: Optional[pulumi.Input['AutoPausePropertiesArgs']] = None,
                 auto_scale_properties: Optional[pulumi.Input['AutoScalePropertiesArgs']] = None,
                 node_count: Optional[pulumi.Input[int]] = None,
                 node_size: Optional[pulumi.Input[str]] = None,
                 node_size_family: Optional[pulumi.Input[str]] = None,
                 pool_name: Optional[pulumi.Input[str]] = None,
                 resource_group: Optional[pulumi.Input[str]] = None,
                 spark_version: Optional[pulumi.Input[str]] = None,
                 subscription_id: Optional[pulumi.Input[str]] = None,
                 workspace_name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input['AutoPausePropertiesArgs'] auto_pause_properties: Auto pause properties.
        :param pulumi.Input['AutoScalePropertiesArgs'] auto_scale_properties: Auto scale properties.
        :param pulumi.Input[int] node_count: The number of compute nodes currently assigned to the compute.
        :param pulumi.Input[str] node_size: Node size.
        :param pulumi.Input[str] node_size_family: Node size family.
        :param pulumi.Input[str] pool_name: Pool name.
        :param pulumi.Input[str] resource_group: Name of the resource group in which workspace is located.
        :param pulumi.Input[str] spark_version: Spark version.
        :param pulumi.Input[str] subscription_id: Azure subscription identifier.
        :param pulumi.Input[str] workspace_name: Name of Azure Machine Learning workspace.
        """
        if auto_pause_properties is not None:
            pulumi.set(__self__, "auto_pause_properties", auto_pause_properties)
        if auto_scale_properties is not None:
            pulumi.set(__self__, "auto_scale_properties", auto_scale_properties)
        if node_count is not None:
            pulumi.set(__self__, "node_count", node_count)
        if node_size is not None:
            pulumi.set(__self__, "node_size", node_size)
        if node_size_family is not None:
            pulumi.set(__self__, "node_size_family", node_size_family)
        if pool_name is not None:
            pulumi.set(__self__, "pool_name", pool_name)
        if resource_group is not None:
            pulumi.set(__self__, "resource_group", resource_group)
        if spark_version is not None:
            pulumi.set(__self__, "spark_version", spark_version)
        if subscription_id is not None:
            pulumi.set(__self__, "subscription_id", subscription_id)
        if workspace_name is not None:
            pulumi.set(__self__, "workspace_name", workspace_name)

    @property
    @pulumi.getter(name="autoPauseProperties")
    def auto_pause_properties(self) -> Optional[pulumi.Input['AutoPausePropertiesArgs']]:
        """
        Auto pause properties.
        """
        return pulumi.get(self, "auto_pause_properties")

    @auto_pause_properties.setter
    def auto_pause_properties(self, value: Optional[pulumi.Input['AutoPausePropertiesArgs']]):
        pulumi.set(self, "auto_pause_properties", value)

    @property
    @pulumi.getter(name="autoScaleProperties")
    def auto_scale_properties(self) -> Optional[pulumi.Input['AutoScalePropertiesArgs']]:
        """
        Auto scale properties.
        """
        return pulumi.get(self, "auto_scale_properties")

    @auto_scale_properties.setter
    def auto_scale_properties(self, value: Optional[pulumi.Input['AutoScalePropertiesArgs']]):
        pulumi.set(self, "auto_scale_properties", value)

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of compute nodes currently assigned to the compute.
        """
        return pulumi.get(self, "node_count")

    @node_count.setter
    def node_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "node_count", value)

    @property
    @pulumi.getter(name="nodeSize")
    def node_size(self) -> Optional[pulumi.Input[str]]:
        """
        Node size.
        """
        return pulumi.get(self, "node_size")

    @node_size.setter
    def node_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_size", value)

    @property
    @pulumi.getter(name="nodeSizeFamily")
    def node_size_family(self) -> Optional[pulumi.Input[str]]:
        """
        Node size family.
        """
        return pulumi.get(self, "node_size_family")

    @node_size_family.setter
    def node_size_family(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_size_family", value)

    @property
    @pulumi.getter(name="poolName")
    def pool_name(self) -> Optional[pulumi.Input[str]]:
        """
        Pool name.
        """
        return pulumi.get(self, "pool_name")

    @pool_name.setter
    def pool_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pool_name", value)

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the resource group in which workspace is located.
        """
        return pulumi.get(self, "resource_group")

    @resource_group.setter
    def resource_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group", value)

    @property
    @pulumi.getter(name="sparkVersion")
    def spark_version(self) -> Optional[pulumi.Input[str]]:
        """
        Spark version.
        """
        return pulumi.get(self, "spark_version")

    @spark_version.setter
    def spark_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "spark_version", value)

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> Optional[pulumi.Input[str]]:
        """
        Azure subscription identifier.
        """
        return pulumi.get(self, "subscription_id")

    @subscription_id.setter
    def subscription_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subscription_id", value)

    @property
    @pulumi.getter(name="workspaceName")
    def workspace_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of Azure Machine Learning workspace.
        """
        return pulumi.get(self, "workspace_name")

    @workspace_name.setter
    def workspace_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "workspace_name", value)


@pulumi.input_type
class SynapseSparkArgs:
    def __init__(__self__, *,
                 compute_type: pulumi.Input[str],
                 compute_location: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disable_local_auth: Optional[pulumi.Input[bool]] = None,
                 properties: Optional[pulumi.Input['SynapseSparkPropertiesArgs']] = None,
                 resource_id: Optional[pulumi.Input[str]] = None):
        """
        A SynapseSpark compute.
        :param pulumi.Input[str] compute_type: The type of compute
               Expected value is 'SynapseSpark'.
        :param pulumi.Input[str] compute_location: Location for the underlying compute
        :param pulumi.Input[str] description: The description of the Machine Learning compute.
        :param pulumi.Input[bool] disable_local_auth: Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
        :param pulumi.Input[str] resource_id: ARM resource id of the underlying compute
        """
        pulumi.set(__self__, "compute_type", 'SynapseSpark')
        if compute_location is not None:
            pulumi.set(__self__, "compute_location", compute_location)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_local_auth is not None:
            pulumi.set(__self__, "disable_local_auth", disable_local_auth)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="computeType")
    def compute_type(self) -> pulumi.Input[str]:
        """
        The type of compute
        Expected value is 'SynapseSpark'.
        """
        return pulumi.get(self, "compute_type")

    @compute_type.setter
    def compute_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "compute_type", value)

    @property
    @pulumi.getter(name="computeLocation")
    def compute_location(self) -> Optional[pulumi.Input[str]]:
        """
        Location for the underlying compute
        """
        return pulumi.get(self, "compute_location")

    @compute_location.setter
    def compute_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compute_location", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the Machine Learning compute.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="disableLocalAuth")
    def disable_local_auth(self) -> Optional[pulumi.Input[bool]]:
        """
        Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
        """
        return pulumi.get(self, "disable_local_auth")

    @disable_local_auth.setter
    def disable_local_auth(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_local_auth", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input['SynapseSparkPropertiesArgs']]:
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input['SynapseSparkPropertiesArgs']]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM resource id of the underlying compute
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_id", value)


@pulumi.input_type
class SystemCreatedAcrAccountArgs:
    def __init__(__self__, *,
                 acr_account_sku: Optional[pulumi.Input[str]] = None,
                 arm_resource_id: Optional[pulumi.Input['ArmResourceIdArgs']] = None):
        """
        :param pulumi.Input['ArmResourceIdArgs'] arm_resource_id: ARM ResourceId of a resource
        """
        if acr_account_sku is not None:
            pulumi.set(__self__, "acr_account_sku", acr_account_sku)
        if arm_resource_id is not None:
            pulumi.set(__self__, "arm_resource_id", arm_resource_id)

    @property
    @pulumi.getter(name="acrAccountSku")
    def acr_account_sku(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "acr_account_sku")

    @acr_account_sku.setter
    def acr_account_sku(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "acr_account_sku", value)

    @property
    @pulumi.getter(name="armResourceId")
    def arm_resource_id(self) -> Optional[pulumi.Input['ArmResourceIdArgs']]:
        """
        ARM ResourceId of a resource
        """
        return pulumi.get(self, "arm_resource_id")

    @arm_resource_id.setter
    def arm_resource_id(self, value: Optional[pulumi.Input['ArmResourceIdArgs']]):
        pulumi.set(self, "arm_resource_id", value)


@pulumi.input_type
class SystemCreatedStorageAccountArgs:
    def __init__(__self__, *,
                 allow_blob_public_access: Optional[pulumi.Input[bool]] = None,
                 arm_resource_id: Optional[pulumi.Input['ArmResourceIdArgs']] = None,
                 storage_account_hns_enabled: Optional[pulumi.Input[bool]] = None,
                 storage_account_type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input['ArmResourceIdArgs'] arm_resource_id: ARM ResourceId of a resource
        :param pulumi.Input[str] storage_account_type: Allowed values:
               "Standard_LRS",
               "Standard_GRS",
               "Standard_RAGRS",
               "Standard_ZRS",
               "Standard_GZRS",
               "Standard_RAGZRS",
               "Premium_LRS",
               "Premium_ZRS"
        """
        if allow_blob_public_access is not None:
            pulumi.set(__self__, "allow_blob_public_access", allow_blob_public_access)
        if arm_resource_id is not None:
            pulumi.set(__self__, "arm_resource_id", arm_resource_id)
        if storage_account_hns_enabled is not None:
            pulumi.set(__self__, "storage_account_hns_enabled", storage_account_hns_enabled)
        if storage_account_type is not None:
            pulumi.set(__self__, "storage_account_type", storage_account_type)

    @property
    @pulumi.getter(name="allowBlobPublicAccess")
    def allow_blob_public_access(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "allow_blob_public_access")

    @allow_blob_public_access.setter
    def allow_blob_public_access(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_blob_public_access", value)

    @property
    @pulumi.getter(name="armResourceId")
    def arm_resource_id(self) -> Optional[pulumi.Input['ArmResourceIdArgs']]:
        """
        ARM ResourceId of a resource
        """
        return pulumi.get(self, "arm_resource_id")

    @arm_resource_id.setter
    def arm_resource_id(self, value: Optional[pulumi.Input['ArmResourceIdArgs']]):
        pulumi.set(self, "arm_resource_id", value)

    @property
    @pulumi.getter(name="storageAccountHnsEnabled")
    def storage_account_hns_enabled(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "storage_account_hns_enabled")

    @storage_account_hns_enabled.setter
    def storage_account_hns_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "storage_account_hns_enabled", value)

    @property
    @pulumi.getter(name="storageAccountType")
    def storage_account_type(self) -> Optional[pulumi.Input[str]]:
        """
        Allowed values:
        "Standard_LRS",
        "Standard_GRS",
        "Standard_RAGRS",
        "Standard_ZRS",
        "Standard_GZRS",
        "Standard_RAGZRS",
        "Premium_LRS",
        "Premium_ZRS"
        """
        return pulumi.get(self, "storage_account_type")

    @storage_account_type.setter
    def storage_account_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_account_type", value)


@pulumi.input_type
class TableFixedParametersArgs:
    def __init__(__self__, *,
                 booster: Optional[pulumi.Input[str]] = None,
                 boosting_type: Optional[pulumi.Input[str]] = None,
                 grow_policy: Optional[pulumi.Input[str]] = None,
                 learning_rate: Optional[pulumi.Input[float]] = None,
                 max_bin: Optional[pulumi.Input[int]] = None,
                 max_depth: Optional[pulumi.Input[int]] = None,
                 max_leaves: Optional[pulumi.Input[int]] = None,
                 min_data_in_leaf: Optional[pulumi.Input[int]] = None,
                 min_split_gain: Optional[pulumi.Input[float]] = None,
                 model_name: Optional[pulumi.Input[str]] = None,
                 n_estimators: Optional[pulumi.Input[int]] = None,
                 num_leaves: Optional[pulumi.Input[int]] = None,
                 preprocessor_name: Optional[pulumi.Input[str]] = None,
                 reg_alpha: Optional[pulumi.Input[float]] = None,
                 reg_lambda: Optional[pulumi.Input[float]] = None,
                 subsample: Optional[pulumi.Input[float]] = None,
                 subsample_freq: Optional[pulumi.Input[float]] = None,
                 tree_method: Optional[pulumi.Input[str]] = None,
                 with_mean: Optional[pulumi.Input[bool]] = None,
                 with_std: Optional[pulumi.Input[bool]] = None):
        """
        Fixed training parameters that won't be swept over during AutoML Table training.
        :param pulumi.Input[str] booster: Specify the boosting type, e.g gbdt for XGBoost.
        :param pulumi.Input[str] boosting_type: Specify the boosting type, e.g gbdt for LightGBM.
        :param pulumi.Input[str] grow_policy: Specify the grow policy, which controls the way new nodes are added to the tree.
        :param pulumi.Input[float] learning_rate: The learning rate for the training procedure.
        :param pulumi.Input[int] max_bin: Specify the Maximum number of discrete bins to bucket continuous features .
        :param pulumi.Input[int] max_depth: Specify the max depth to limit the tree depth explicitly.
        :param pulumi.Input[int] max_leaves: Specify the max leaves to limit the tree leaves explicitly.
        :param pulumi.Input[int] min_data_in_leaf: The minimum number of data per leaf.
        :param pulumi.Input[float] min_split_gain: Minimum loss reduction required to make a further partition on a leaf node of the tree.
        :param pulumi.Input[str] model_name: The name of the model to train.
        :param pulumi.Input[int] n_estimators: Specify the number of trees (or rounds) in an model.
        :param pulumi.Input[int] num_leaves: Specify the number of leaves.
        :param pulumi.Input[str] preprocessor_name: The name of the preprocessor to use.
        :param pulumi.Input[float] reg_alpha: L1 regularization term on weights.
        :param pulumi.Input[float] reg_lambda: L2 regularization term on weights.
        :param pulumi.Input[float] subsample: Subsample ratio of the training instance.
        :param pulumi.Input[float] subsample_freq: Frequency of subsample.
        :param pulumi.Input[str] tree_method: Specify the tree method.
        :param pulumi.Input[bool] with_mean: If true, center before scaling the data with StandardScalar.
        :param pulumi.Input[bool] with_std: If true, scaling the data with Unit Variance with StandardScalar.
        """
        if booster is not None:
            pulumi.set(__self__, "booster", booster)
        if boosting_type is not None:
            pulumi.set(__self__, "boosting_type", boosting_type)
        if grow_policy is not None:
            pulumi.set(__self__, "grow_policy", grow_policy)
        if learning_rate is not None:
            pulumi.set(__self__, "learning_rate", learning_rate)
        if max_bin is not None:
            pulumi.set(__self__, "max_bin", max_bin)
        if max_depth is not None:
            pulumi.set(__self__, "max_depth", max_depth)
        if max_leaves is not None:
            pulumi.set(__self__, "max_leaves", max_leaves)
        if min_data_in_leaf is not None:
            pulumi.set(__self__, "min_data_in_leaf", min_data_in_leaf)
        if min_split_gain is not None:
            pulumi.set(__self__, "min_split_gain", min_split_gain)
        if model_name is not None:
            pulumi.set(__self__, "model_name", model_name)
        if n_estimators is not None:
            pulumi.set(__self__, "n_estimators", n_estimators)
        if num_leaves is not None:
            pulumi.set(__self__, "num_leaves", num_leaves)
        if preprocessor_name is not None:
            pulumi.set(__self__, "preprocessor_name", preprocessor_name)
        if reg_alpha is not None:
            pulumi.set(__self__, "reg_alpha", reg_alpha)
        if reg_lambda is not None:
            pulumi.set(__self__, "reg_lambda", reg_lambda)
        if subsample is not None:
            pulumi.set(__self__, "subsample", subsample)
        if subsample_freq is not None:
            pulumi.set(__self__, "subsample_freq", subsample_freq)
        if tree_method is not None:
            pulumi.set(__self__, "tree_method", tree_method)
        if with_mean is None:
            with_mean = False
        if with_mean is not None:
            pulumi.set(__self__, "with_mean", with_mean)
        if with_std is None:
            with_std = False
        if with_std is not None:
            pulumi.set(__self__, "with_std", with_std)

    @property
    @pulumi.getter
    def booster(self) -> Optional[pulumi.Input[str]]:
        """
        Specify the boosting type, e.g gbdt for XGBoost.
        """
        return pulumi.get(self, "booster")

    @booster.setter
    def booster(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "booster", value)

    @property
    @pulumi.getter(name="boostingType")
    def boosting_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specify the boosting type, e.g gbdt for LightGBM.
        """
        return pulumi.get(self, "boosting_type")

    @boosting_type.setter
    def boosting_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "boosting_type", value)

    @property
    @pulumi.getter(name="growPolicy")
    def grow_policy(self) -> Optional[pulumi.Input[str]]:
        """
        Specify the grow policy, which controls the way new nodes are added to the tree.
        """
        return pulumi.get(self, "grow_policy")

    @grow_policy.setter
    def grow_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "grow_policy", value)

    @property
    @pulumi.getter(name="learningRate")
    def learning_rate(self) -> Optional[pulumi.Input[float]]:
        """
        The learning rate for the training procedure.
        """
        return pulumi.get(self, "learning_rate")

    @learning_rate.setter
    def learning_rate(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "learning_rate", value)

    @property
    @pulumi.getter(name="maxBin")
    def max_bin(self) -> Optional[pulumi.Input[int]]:
        """
        Specify the Maximum number of discrete bins to bucket continuous features .
        """
        return pulumi.get(self, "max_bin")

    @max_bin.setter
    def max_bin(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_bin", value)

    @property
    @pulumi.getter(name="maxDepth")
    def max_depth(self) -> Optional[pulumi.Input[int]]:
        """
        Specify the max depth to limit the tree depth explicitly.
        """
        return pulumi.get(self, "max_depth")

    @max_depth.setter
    def max_depth(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_depth", value)

    @property
    @pulumi.getter(name="maxLeaves")
    def max_leaves(self) -> Optional[pulumi.Input[int]]:
        """
        Specify the max leaves to limit the tree leaves explicitly.
        """
        return pulumi.get(self, "max_leaves")

    @max_leaves.setter
    def max_leaves(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_leaves", value)

    @property
    @pulumi.getter(name="minDataInLeaf")
    def min_data_in_leaf(self) -> Optional[pulumi.Input[int]]:
        """
        The minimum number of data per leaf.
        """
        return pulumi.get(self, "min_data_in_leaf")

    @min_data_in_leaf.setter
    def min_data_in_leaf(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_data_in_leaf", value)

    @property
    @pulumi.getter(name="minSplitGain")
    def min_split_gain(self) -> Optional[pulumi.Input[float]]:
        """
        Minimum loss reduction required to make a further partition on a leaf node of the tree.
        """
        return pulumi.get(self, "min_split_gain")

    @min_split_gain.setter
    def min_split_gain(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "min_split_gain", value)

    @property
    @pulumi.getter(name="modelName")
    def model_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the model to train.
        """
        return pulumi.get(self, "model_name")

    @model_name.setter
    def model_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "model_name", value)

    @property
    @pulumi.getter(name="nEstimators")
    def n_estimators(self) -> Optional[pulumi.Input[int]]:
        """
        Specify the number of trees (or rounds) in an model.
        """
        return pulumi.get(self, "n_estimators")

    @n_estimators.setter
    def n_estimators(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "n_estimators", value)

    @property
    @pulumi.getter(name="numLeaves")
    def num_leaves(self) -> Optional[pulumi.Input[int]]:
        """
        Specify the number of leaves.
        """
        return pulumi.get(self, "num_leaves")

    @num_leaves.setter
    def num_leaves(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "num_leaves", value)

    @property
    @pulumi.getter(name="preprocessorName")
    def preprocessor_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the preprocessor to use.
        """
        return pulumi.get(self, "preprocessor_name")

    @preprocessor_name.setter
    def preprocessor_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "preprocessor_name", value)

    @property
    @pulumi.getter(name="regAlpha")
    def reg_alpha(self) -> Optional[pulumi.Input[float]]:
        """
        L1 regularization term on weights.
        """
        return pulumi.get(self, "reg_alpha")

    @reg_alpha.setter
    def reg_alpha(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "reg_alpha", value)

    @property
    @pulumi.getter(name="regLambda")
    def reg_lambda(self) -> Optional[pulumi.Input[float]]:
        """
        L2 regularization term on weights.
        """
        return pulumi.get(self, "reg_lambda")

    @reg_lambda.setter
    def reg_lambda(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "reg_lambda", value)

    @property
    @pulumi.getter
    def subsample(self) -> Optional[pulumi.Input[float]]:
        """
        Subsample ratio of the training instance.
        """
        return pulumi.get(self, "subsample")

    @subsample.setter
    def subsample(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "subsample", value)

    @property
    @pulumi.getter(name="subsampleFreq")
    def subsample_freq(self) -> Optional[pulumi.Input[float]]:
        """
        Frequency of subsample.
        """
        return pulumi.get(self, "subsample_freq")

    @subsample_freq.setter
    def subsample_freq(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "subsample_freq", value)

    @property
    @pulumi.getter(name="treeMethod")
    def tree_method(self) -> Optional[pulumi.Input[str]]:
        """
        Specify the tree method.
        """
        return pulumi.get(self, "tree_method")

    @tree_method.setter
    def tree_method(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tree_method", value)

    @property
    @pulumi.getter(name="withMean")
    def with_mean(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, center before scaling the data with StandardScalar.
        """
        return pulumi.get(self, "with_mean")

    @with_mean.setter
    def with_mean(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "with_mean", value)

    @property
    @pulumi.getter(name="withStd")
    def with_std(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, scaling the data with Unit Variance with StandardScalar.
        """
        return pulumi.get(self, "with_std")

    @with_std.setter
    def with_std(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "with_std", value)


@pulumi.input_type
class TableParameterSubspaceArgs:
    def __init__(__self__, *,
                 booster: Optional[pulumi.Input[str]] = None,
                 boosting_type: Optional[pulumi.Input[str]] = None,
                 grow_policy: Optional[pulumi.Input[str]] = None,
                 learning_rate: Optional[pulumi.Input[str]] = None,
                 max_bin: Optional[pulumi.Input[str]] = None,
                 max_depth: Optional[pulumi.Input[str]] = None,
                 max_leaves: Optional[pulumi.Input[str]] = None,
                 min_data_in_leaf: Optional[pulumi.Input[str]] = None,
                 min_split_gain: Optional[pulumi.Input[str]] = None,
                 model_name: Optional[pulumi.Input[str]] = None,
                 n_estimators: Optional[pulumi.Input[str]] = None,
                 num_leaves: Optional[pulumi.Input[str]] = None,
                 preprocessor_name: Optional[pulumi.Input[str]] = None,
                 reg_alpha: Optional[pulumi.Input[str]] = None,
                 reg_lambda: Optional[pulumi.Input[str]] = None,
                 subsample: Optional[pulumi.Input[str]] = None,
                 subsample_freq: Optional[pulumi.Input[str]] = None,
                 tree_method: Optional[pulumi.Input[str]] = None,
                 with_mean: Optional[pulumi.Input[str]] = None,
                 with_std: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] booster: Specify the boosting type, e.g gbdt for XGBoost.
        :param pulumi.Input[str] boosting_type: Specify the boosting type, e.g gbdt for LightGBM.
        :param pulumi.Input[str] grow_policy: Specify the grow policy, which controls the way new nodes are added to the tree.
        :param pulumi.Input[str] learning_rate: The learning rate for the training procedure.
        :param pulumi.Input[str] max_bin: Specify the Maximum number of discrete bins to bucket continuous features .
        :param pulumi.Input[str] max_depth: Specify the max depth to limit the tree depth explicitly.
        :param pulumi.Input[str] max_leaves: Specify the max leaves to limit the tree leaves explicitly.
        :param pulumi.Input[str] min_data_in_leaf: The minimum number of data per leaf.
        :param pulumi.Input[str] min_split_gain: Minimum loss reduction required to make a further partition on a leaf node of the tree.
        :param pulumi.Input[str] model_name: The name of the model to train.
        :param pulumi.Input[str] n_estimators: Specify the number of trees (or rounds) in an model.
        :param pulumi.Input[str] num_leaves: Specify the number of leaves.
        :param pulumi.Input[str] preprocessor_name: The name of the preprocessor to use.
        :param pulumi.Input[str] reg_alpha: L1 regularization term on weights.
        :param pulumi.Input[str] reg_lambda: L2 regularization term on weights.
        :param pulumi.Input[str] subsample: Subsample ratio of the training instance.
        :param pulumi.Input[str] subsample_freq: Frequency of subsample
        :param pulumi.Input[str] tree_method: Specify the tree method.
        :param pulumi.Input[str] with_mean: If true, center before scaling the data with StandardScalar.
        :param pulumi.Input[str] with_std: If true, scaling the data with Unit Variance with StandardScalar.
        """
        if booster is not None:
            pulumi.set(__self__, "booster", booster)
        if boosting_type is not None:
            pulumi.set(__self__, "boosting_type", boosting_type)
        if grow_policy is not None:
            pulumi.set(__self__, "grow_policy", grow_policy)
        if learning_rate is not None:
            pulumi.set(__self__, "learning_rate", learning_rate)
        if max_bin is not None:
            pulumi.set(__self__, "max_bin", max_bin)
        if max_depth is not None:
            pulumi.set(__self__, "max_depth", max_depth)
        if max_leaves is not None:
            pulumi.set(__self__, "max_leaves", max_leaves)
        if min_data_in_leaf is not None:
            pulumi.set(__self__, "min_data_in_leaf", min_data_in_leaf)
        if min_split_gain is not None:
            pulumi.set(__self__, "min_split_gain", min_split_gain)
        if model_name is not None:
            pulumi.set(__self__, "model_name", model_name)
        if n_estimators is not None:
            pulumi.set(__self__, "n_estimators", n_estimators)
        if num_leaves is not None:
            pulumi.set(__self__, "num_leaves", num_leaves)
        if preprocessor_name is not None:
            pulumi.set(__self__, "preprocessor_name", preprocessor_name)
        if reg_alpha is not None:
            pulumi.set(__self__, "reg_alpha", reg_alpha)
        if reg_lambda is not None:
            pulumi.set(__self__, "reg_lambda", reg_lambda)
        if subsample is not None:
            pulumi.set(__self__, "subsample", subsample)
        if subsample_freq is not None:
            pulumi.set(__self__, "subsample_freq", subsample_freq)
        if tree_method is not None:
            pulumi.set(__self__, "tree_method", tree_method)
        if with_mean is not None:
            pulumi.set(__self__, "with_mean", with_mean)
        if with_std is not None:
            pulumi.set(__self__, "with_std", with_std)

    @property
    @pulumi.getter
    def booster(self) -> Optional[pulumi.Input[str]]:
        """
        Specify the boosting type, e.g gbdt for XGBoost.
        """
        return pulumi.get(self, "booster")

    @booster.setter
    def booster(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "booster", value)

    @property
    @pulumi.getter(name="boostingType")
    def boosting_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specify the boosting type, e.g gbdt for LightGBM.
        """
        return pulumi.get(self, "boosting_type")

    @boosting_type.setter
    def boosting_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "boosting_type", value)

    @property
    @pulumi.getter(name="growPolicy")
    def grow_policy(self) -> Optional[pulumi.Input[str]]:
        """
        Specify the grow policy, which controls the way new nodes are added to the tree.
        """
        return pulumi.get(self, "grow_policy")

    @grow_policy.setter
    def grow_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "grow_policy", value)

    @property
    @pulumi.getter(name="learningRate")
    def learning_rate(self) -> Optional[pulumi.Input[str]]:
        """
        The learning rate for the training procedure.
        """
        return pulumi.get(self, "learning_rate")

    @learning_rate.setter
    def learning_rate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "learning_rate", value)

    @property
    @pulumi.getter(name="maxBin")
    def max_bin(self) -> Optional[pulumi.Input[str]]:
        """
        Specify the Maximum number of discrete bins to bucket continuous features .
        """
        return pulumi.get(self, "max_bin")

    @max_bin.setter
    def max_bin(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "max_bin", value)

    @property
    @pulumi.getter(name="maxDepth")
    def max_depth(self) -> Optional[pulumi.Input[str]]:
        """
        Specify the max depth to limit the tree depth explicitly.
        """
        return pulumi.get(self, "max_depth")

    @max_depth.setter
    def max_depth(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "max_depth", value)

    @property
    @pulumi.getter(name="maxLeaves")
    def max_leaves(self) -> Optional[pulumi.Input[str]]:
        """
        Specify the max leaves to limit the tree leaves explicitly.
        """
        return pulumi.get(self, "max_leaves")

    @max_leaves.setter
    def max_leaves(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "max_leaves", value)

    @property
    @pulumi.getter(name="minDataInLeaf")
    def min_data_in_leaf(self) -> Optional[pulumi.Input[str]]:
        """
        The minimum number of data per leaf.
        """
        return pulumi.get(self, "min_data_in_leaf")

    @min_data_in_leaf.setter
    def min_data_in_leaf(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "min_data_in_leaf", value)

    @property
    @pulumi.getter(name="minSplitGain")
    def min_split_gain(self) -> Optional[pulumi.Input[str]]:
        """
        Minimum loss reduction required to make a further partition on a leaf node of the tree.
        """
        return pulumi.get(self, "min_split_gain")

    @min_split_gain.setter
    def min_split_gain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "min_split_gain", value)

    @property
    @pulumi.getter(name="modelName")
    def model_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the model to train.
        """
        return pulumi.get(self, "model_name")

    @model_name.setter
    def model_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "model_name", value)

    @property
    @pulumi.getter(name="nEstimators")
    def n_estimators(self) -> Optional[pulumi.Input[str]]:
        """
        Specify the number of trees (or rounds) in an model.
        """
        return pulumi.get(self, "n_estimators")

    @n_estimators.setter
    def n_estimators(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "n_estimators", value)

    @property
    @pulumi.getter(name="numLeaves")
    def num_leaves(self) -> Optional[pulumi.Input[str]]:
        """
        Specify the number of leaves.
        """
        return pulumi.get(self, "num_leaves")

    @num_leaves.setter
    def num_leaves(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "num_leaves", value)

    @property
    @pulumi.getter(name="preprocessorName")
    def preprocessor_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the preprocessor to use.
        """
        return pulumi.get(self, "preprocessor_name")

    @preprocessor_name.setter
    def preprocessor_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "preprocessor_name", value)

    @property
    @pulumi.getter(name="regAlpha")
    def reg_alpha(self) -> Optional[pulumi.Input[str]]:
        """
        L1 regularization term on weights.
        """
        return pulumi.get(self, "reg_alpha")

    @reg_alpha.setter
    def reg_alpha(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "reg_alpha", value)

    @property
    @pulumi.getter(name="regLambda")
    def reg_lambda(self) -> Optional[pulumi.Input[str]]:
        """
        L2 regularization term on weights.
        """
        return pulumi.get(self, "reg_lambda")

    @reg_lambda.setter
    def reg_lambda(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "reg_lambda", value)

    @property
    @pulumi.getter
    def subsample(self) -> Optional[pulumi.Input[str]]:
        """
        Subsample ratio of the training instance.
        """
        return pulumi.get(self, "subsample")

    @subsample.setter
    def subsample(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subsample", value)

    @property
    @pulumi.getter(name="subsampleFreq")
    def subsample_freq(self) -> Optional[pulumi.Input[str]]:
        """
        Frequency of subsample
        """
        return pulumi.get(self, "subsample_freq")

    @subsample_freq.setter
    def subsample_freq(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subsample_freq", value)

    @property
    @pulumi.getter(name="treeMethod")
    def tree_method(self) -> Optional[pulumi.Input[str]]:
        """
        Specify the tree method.
        """
        return pulumi.get(self, "tree_method")

    @tree_method.setter
    def tree_method(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tree_method", value)

    @property
    @pulumi.getter(name="withMean")
    def with_mean(self) -> Optional[pulumi.Input[str]]:
        """
        If true, center before scaling the data with StandardScalar.
        """
        return pulumi.get(self, "with_mean")

    @with_mean.setter
    def with_mean(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "with_mean", value)

    @property
    @pulumi.getter(name="withStd")
    def with_std(self) -> Optional[pulumi.Input[str]]:
        """
        If true, scaling the data with Unit Variance with StandardScalar.
        """
        return pulumi.get(self, "with_std")

    @with_std.setter
    def with_std(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "with_std", value)


@pulumi.input_type
class TableSweepSettingsArgs:
    def __init__(__self__, *,
                 sampling_algorithm: pulumi.Input[Union[str, 'SamplingAlgorithmType']],
                 early_termination: Optional[pulumi.Input[Union['BanditPolicyArgs', 'MedianStoppingPolicyArgs', 'TruncationSelectionPolicyArgs']]] = None):
        """
        :param pulumi.Input[Union[str, 'SamplingAlgorithmType']] sampling_algorithm: [Required] Type of sampling algorithm.
        :param pulumi.Input[Union['BanditPolicyArgs', 'MedianStoppingPolicyArgs', 'TruncationSelectionPolicyArgs']] early_termination: Type of early termination policy for the sweeping job.
        """
        pulumi.set(__self__, "sampling_algorithm", sampling_algorithm)
        if early_termination is not None:
            pulumi.set(__self__, "early_termination", early_termination)

    @property
    @pulumi.getter(name="samplingAlgorithm")
    def sampling_algorithm(self) -> pulumi.Input[Union[str, 'SamplingAlgorithmType']]:
        """
        [Required] Type of sampling algorithm.
        """
        return pulumi.get(self, "sampling_algorithm")

    @sampling_algorithm.setter
    def sampling_algorithm(self, value: pulumi.Input[Union[str, 'SamplingAlgorithmType']]):
        pulumi.set(self, "sampling_algorithm", value)

    @property
    @pulumi.getter(name="earlyTermination")
    def early_termination(self) -> Optional[pulumi.Input[Union['BanditPolicyArgs', 'MedianStoppingPolicyArgs', 'TruncationSelectionPolicyArgs']]]:
        """
        Type of early termination policy for the sweeping job.
        """
        return pulumi.get(self, "early_termination")

    @early_termination.setter
    def early_termination(self, value: Optional[pulumi.Input[Union['BanditPolicyArgs', 'MedianStoppingPolicyArgs', 'TruncationSelectionPolicyArgs']]]):
        pulumi.set(self, "early_termination", value)


@pulumi.input_type
class TableVerticalFeaturizationSettingsArgs:
    def __init__(__self__, *,
                 blocked_transformers: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'BlockedTransformers']]]]] = None,
                 column_name_and_types: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 dataset_language: Optional[pulumi.Input[str]] = None,
                 enable_dnn_featurization: Optional[pulumi.Input[bool]] = None,
                 mode: Optional[pulumi.Input[Union[str, 'FeaturizationMode']]] = None,
                 transformer_params: Optional[pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input['ColumnTransformerArgs']]]]]] = None):
        """
        Featurization Configuration.
        :param pulumi.Input[Sequence[pulumi.Input[Union[str, 'BlockedTransformers']]]] blocked_transformers: These transformers shall not be used in featurization.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] column_name_and_types: Dictionary of column name and its type (int, float, string, datetime etc).
        :param pulumi.Input[str] dataset_language: Dataset language, useful for the text data.
        :param pulumi.Input[bool] enable_dnn_featurization: Determines whether to use Dnn based featurizers for data featurization.
        :param pulumi.Input[Union[str, 'FeaturizationMode']] mode: Featurization mode - User can keep the default 'Auto' mode and AutoML will take care of necessary transformation of the data in featurization phase.
               If 'Off' is selected then no featurization is done.
               If 'Custom' is selected then user can specify additional inputs to customize how featurization is done.
        :param pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input['ColumnTransformerArgs']]]]] transformer_params: User can specify additional transformers to be used along with the columns to which it would be applied and parameters for the transformer constructor.
        """
        if blocked_transformers is not None:
            pulumi.set(__self__, "blocked_transformers", blocked_transformers)
        if column_name_and_types is not None:
            pulumi.set(__self__, "column_name_and_types", column_name_and_types)
        if dataset_language is not None:
            pulumi.set(__self__, "dataset_language", dataset_language)
        if enable_dnn_featurization is None:
            enable_dnn_featurization = False
        if enable_dnn_featurization is not None:
            pulumi.set(__self__, "enable_dnn_featurization", enable_dnn_featurization)
        if mode is None:
            mode = 'Auto'
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if transformer_params is not None:
            pulumi.set(__self__, "transformer_params", transformer_params)

    @property
    @pulumi.getter(name="blockedTransformers")
    def blocked_transformers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'BlockedTransformers']]]]]:
        """
        These transformers shall not be used in featurization.
        """
        return pulumi.get(self, "blocked_transformers")

    @blocked_transformers.setter
    def blocked_transformers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'BlockedTransformers']]]]]):
        pulumi.set(self, "blocked_transformers", value)

    @property
    @pulumi.getter(name="columnNameAndTypes")
    def column_name_and_types(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Dictionary of column name and its type (int, float, string, datetime etc).
        """
        return pulumi.get(self, "column_name_and_types")

    @column_name_and_types.setter
    def column_name_and_types(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "column_name_and_types", value)

    @property
    @pulumi.getter(name="datasetLanguage")
    def dataset_language(self) -> Optional[pulumi.Input[str]]:
        """
        Dataset language, useful for the text data.
        """
        return pulumi.get(self, "dataset_language")

    @dataset_language.setter
    def dataset_language(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dataset_language", value)

    @property
    @pulumi.getter(name="enableDnnFeaturization")
    def enable_dnn_featurization(self) -> Optional[pulumi.Input[bool]]:
        """
        Determines whether to use Dnn based featurizers for data featurization.
        """
        return pulumi.get(self, "enable_dnn_featurization")

    @enable_dnn_featurization.setter
    def enable_dnn_featurization(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_dnn_featurization", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[Union[str, 'FeaturizationMode']]]:
        """
        Featurization mode - User can keep the default 'Auto' mode and AutoML will take care of necessary transformation of the data in featurization phase.
        If 'Off' is selected then no featurization is done.
        If 'Custom' is selected then user can specify additional inputs to customize how featurization is done.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[Union[str, 'FeaturizationMode']]]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter(name="transformerParams")
    def transformer_params(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input['ColumnTransformerArgs']]]]]]:
        """
        User can specify additional transformers to be used along with the columns to which it would be applied and parameters for the transformer constructor.
        """
        return pulumi.get(self, "transformer_params")

    @transformer_params.setter
    def transformer_params(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input['ColumnTransformerArgs']]]]]]):
        pulumi.set(self, "transformer_params", value)


@pulumi.input_type
class TableVerticalLimitSettingsArgs:
    def __init__(__self__, *,
                 enable_early_termination: Optional[pulumi.Input[bool]] = None,
                 exit_score: Optional[pulumi.Input[float]] = None,
                 max_concurrent_trials: Optional[pulumi.Input[int]] = None,
                 max_cores_per_trial: Optional[pulumi.Input[int]] = None,
                 max_nodes: Optional[pulumi.Input[int]] = None,
                 max_trials: Optional[pulumi.Input[int]] = None,
                 sweep_concurrent_trials: Optional[pulumi.Input[int]] = None,
                 sweep_trials: Optional[pulumi.Input[int]] = None,
                 timeout: Optional[pulumi.Input[str]] = None,
                 trial_timeout: Optional[pulumi.Input[str]] = None):
        """
        Job execution constraints.
        :param pulumi.Input[bool] enable_early_termination: Enable early termination, determines whether or not if AutoMLJob will terminate early if there is no score improvement in last 20 iterations.
        :param pulumi.Input[float] exit_score: Exit score for the AutoML job.
        :param pulumi.Input[int] max_concurrent_trials: Maximum Concurrent iterations.
        :param pulumi.Input[int] max_cores_per_trial: Max cores per iteration.
        :param pulumi.Input[int] max_nodes: Maximum nodes to use for the experiment.
        :param pulumi.Input[int] max_trials: Number of iterations.
        :param pulumi.Input[int] sweep_concurrent_trials: Number of concurrent sweeping runs that user wants to trigger.
        :param pulumi.Input[int] sweep_trials: Number of sweeping runs that user wants to trigger.
        :param pulumi.Input[str] timeout: AutoML job timeout.
        :param pulumi.Input[str] trial_timeout: Iteration timeout.
        """
        if enable_early_termination is None:
            enable_early_termination = True
        if enable_early_termination is not None:
            pulumi.set(__self__, "enable_early_termination", enable_early_termination)
        if exit_score is not None:
            pulumi.set(__self__, "exit_score", exit_score)
        if max_concurrent_trials is None:
            max_concurrent_trials = 1
        if max_concurrent_trials is not None:
            pulumi.set(__self__, "max_concurrent_trials", max_concurrent_trials)
        if max_cores_per_trial is None:
            max_cores_per_trial = -1
        if max_cores_per_trial is not None:
            pulumi.set(__self__, "max_cores_per_trial", max_cores_per_trial)
        if max_nodes is None:
            max_nodes = 1
        if max_nodes is not None:
            pulumi.set(__self__, "max_nodes", max_nodes)
        if max_trials is None:
            max_trials = 1000
        if max_trials is not None:
            pulumi.set(__self__, "max_trials", max_trials)
        if sweep_concurrent_trials is None:
            sweep_concurrent_trials = 0
        if sweep_concurrent_trials is not None:
            pulumi.set(__self__, "sweep_concurrent_trials", sweep_concurrent_trials)
        if sweep_trials is None:
            sweep_trials = 0
        if sweep_trials is not None:
            pulumi.set(__self__, "sweep_trials", sweep_trials)
        if timeout is None:
            timeout = 'PT6H'
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if trial_timeout is None:
            trial_timeout = 'PT30M'
        if trial_timeout is not None:
            pulumi.set(__self__, "trial_timeout", trial_timeout)

    @property
    @pulumi.getter(name="enableEarlyTermination")
    def enable_early_termination(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable early termination, determines whether or not if AutoMLJob will terminate early if there is no score improvement in last 20 iterations.
        """
        return pulumi.get(self, "enable_early_termination")

    @enable_early_termination.setter
    def enable_early_termination(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_early_termination", value)

    @property
    @pulumi.getter(name="exitScore")
    def exit_score(self) -> Optional[pulumi.Input[float]]:
        """
        Exit score for the AutoML job.
        """
        return pulumi.get(self, "exit_score")

    @exit_score.setter
    def exit_score(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "exit_score", value)

    @property
    @pulumi.getter(name="maxConcurrentTrials")
    def max_concurrent_trials(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum Concurrent iterations.
        """
        return pulumi.get(self, "max_concurrent_trials")

    @max_concurrent_trials.setter
    def max_concurrent_trials(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_concurrent_trials", value)

    @property
    @pulumi.getter(name="maxCoresPerTrial")
    def max_cores_per_trial(self) -> Optional[pulumi.Input[int]]:
        """
        Max cores per iteration.
        """
        return pulumi.get(self, "max_cores_per_trial")

    @max_cores_per_trial.setter
    def max_cores_per_trial(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_cores_per_trial", value)

    @property
    @pulumi.getter(name="maxNodes")
    def max_nodes(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum nodes to use for the experiment.
        """
        return pulumi.get(self, "max_nodes")

    @max_nodes.setter
    def max_nodes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_nodes", value)

    @property
    @pulumi.getter(name="maxTrials")
    def max_trials(self) -> Optional[pulumi.Input[int]]:
        """
        Number of iterations.
        """
        return pulumi.get(self, "max_trials")

    @max_trials.setter
    def max_trials(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_trials", value)

    @property
    @pulumi.getter(name="sweepConcurrentTrials")
    def sweep_concurrent_trials(self) -> Optional[pulumi.Input[int]]:
        """
        Number of concurrent sweeping runs that user wants to trigger.
        """
        return pulumi.get(self, "sweep_concurrent_trials")

    @sweep_concurrent_trials.setter
    def sweep_concurrent_trials(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "sweep_concurrent_trials", value)

    @property
    @pulumi.getter(name="sweepTrials")
    def sweep_trials(self) -> Optional[pulumi.Input[int]]:
        """
        Number of sweeping runs that user wants to trigger.
        """
        return pulumi.get(self, "sweep_trials")

    @sweep_trials.setter
    def sweep_trials(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "sweep_trials", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[str]]:
        """
        AutoML job timeout.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timeout", value)

    @property
    @pulumi.getter(name="trialTimeout")
    def trial_timeout(self) -> Optional[pulumi.Input[str]]:
        """
        Iteration timeout.
        """
        return pulumi.get(self, "trial_timeout")

    @trial_timeout.setter
    def trial_timeout(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "trial_timeout", value)


@pulumi.input_type
class TargetUtilizationScaleSettingsArgs:
    def __init__(__self__, *,
                 scale_type: pulumi.Input[str],
                 max_instances: Optional[pulumi.Input[int]] = None,
                 min_instances: Optional[pulumi.Input[int]] = None,
                 polling_interval: Optional[pulumi.Input[str]] = None,
                 target_utilization_percentage: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] scale_type: 
               Expected value is 'TargetUtilization'.
        :param pulumi.Input[int] max_instances: The maximum number of instances that the deployment can scale to. The quota will be reserved for max_instances.
        :param pulumi.Input[int] min_instances: The minimum number of instances to always be present.
        :param pulumi.Input[str] polling_interval: The polling interval in ISO 8691 format. Only supports duration with precision as low as Seconds.
        :param pulumi.Input[int] target_utilization_percentage: Target CPU usage for the autoscaler.
        """
        pulumi.set(__self__, "scale_type", 'TargetUtilization')
        if max_instances is None:
            max_instances = 1
        if max_instances is not None:
            pulumi.set(__self__, "max_instances", max_instances)
        if min_instances is None:
            min_instances = 1
        if min_instances is not None:
            pulumi.set(__self__, "min_instances", min_instances)
        if polling_interval is None:
            polling_interval = 'PT1S'
        if polling_interval is not None:
            pulumi.set(__self__, "polling_interval", polling_interval)
        if target_utilization_percentage is None:
            target_utilization_percentage = 70
        if target_utilization_percentage is not None:
            pulumi.set(__self__, "target_utilization_percentage", target_utilization_percentage)

    @property
    @pulumi.getter(name="scaleType")
    def scale_type(self) -> pulumi.Input[str]:
        """

        Expected value is 'TargetUtilization'.
        """
        return pulumi.get(self, "scale_type")

    @scale_type.setter
    def scale_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "scale_type", value)

    @property
    @pulumi.getter(name="maxInstances")
    def max_instances(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of instances that the deployment can scale to. The quota will be reserved for max_instances.
        """
        return pulumi.get(self, "max_instances")

    @max_instances.setter
    def max_instances(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_instances", value)

    @property
    @pulumi.getter(name="minInstances")
    def min_instances(self) -> Optional[pulumi.Input[int]]:
        """
        The minimum number of instances to always be present.
        """
        return pulumi.get(self, "min_instances")

    @min_instances.setter
    def min_instances(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_instances", value)

    @property
    @pulumi.getter(name="pollingInterval")
    def polling_interval(self) -> Optional[pulumi.Input[str]]:
        """
        The polling interval in ISO 8691 format. Only supports duration with precision as low as Seconds.
        """
        return pulumi.get(self, "polling_interval")

    @polling_interval.setter
    def polling_interval(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "polling_interval", value)

    @property
    @pulumi.getter(name="targetUtilizationPercentage")
    def target_utilization_percentage(self) -> Optional[pulumi.Input[int]]:
        """
        Target CPU usage for the autoscaler.
        """
        return pulumi.get(self, "target_utilization_percentage")

    @target_utilization_percentage.setter
    def target_utilization_percentage(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "target_utilization_percentage", value)


@pulumi.input_type
class TensorFlowArgs:
    def __init__(__self__, *,
                 distribution_type: pulumi.Input[str],
                 parameter_server_count: Optional[pulumi.Input[int]] = None,
                 worker_count: Optional[pulumi.Input[int]] = None):
        """
        TensorFlow distribution configuration.
        :param pulumi.Input[str] distribution_type: Enum to determine the job distribution type.
               Expected value is 'TensorFlow'.
        :param pulumi.Input[int] parameter_server_count: Number of parameter server tasks.
        :param pulumi.Input[int] worker_count: Number of workers. If not specified, will default to the instance count.
        """
        pulumi.set(__self__, "distribution_type", 'TensorFlow')
        if parameter_server_count is None:
            parameter_server_count = 0
        if parameter_server_count is not None:
            pulumi.set(__self__, "parameter_server_count", parameter_server_count)
        if worker_count is not None:
            pulumi.set(__self__, "worker_count", worker_count)

    @property
    @pulumi.getter(name="distributionType")
    def distribution_type(self) -> pulumi.Input[str]:
        """
        Enum to determine the job distribution type.
        Expected value is 'TensorFlow'.
        """
        return pulumi.get(self, "distribution_type")

    @distribution_type.setter
    def distribution_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "distribution_type", value)

    @property
    @pulumi.getter(name="parameterServerCount")
    def parameter_server_count(self) -> Optional[pulumi.Input[int]]:
        """
        Number of parameter server tasks.
        """
        return pulumi.get(self, "parameter_server_count")

    @parameter_server_count.setter
    def parameter_server_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "parameter_server_count", value)

    @property
    @pulumi.getter(name="workerCount")
    def worker_count(self) -> Optional[pulumi.Input[int]]:
        """
        Number of workers. If not specified, will default to the instance count.
        """
        return pulumi.get(self, "worker_count")

    @worker_count.setter
    def worker_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "worker_count", value)


@pulumi.input_type
class TextClassificationMultilabelArgs:
    def __init__(__self__, *,
                 task_type: pulumi.Input[str],
                 training_data: pulumi.Input['MLTableJobInputArgs'],
                 featurization_settings: Optional[pulumi.Input['NlpVerticalFeaturizationSettingsArgs']] = None,
                 fixed_parameters: Optional[pulumi.Input['NlpFixedParametersArgs']] = None,
                 limit_settings: Optional[pulumi.Input['NlpVerticalLimitSettingsArgs']] = None,
                 log_verbosity: Optional[pulumi.Input[Union[str, 'LogVerbosity']]] = None,
                 search_space: Optional[pulumi.Input[Sequence[pulumi.Input['NlpParameterSubspaceArgs']]]] = None,
                 sweep_settings: Optional[pulumi.Input['NlpSweepSettingsArgs']] = None,
                 target_column_name: Optional[pulumi.Input[str]] = None,
                 validation_data: Optional[pulumi.Input['MLTableJobInputArgs']] = None):
        """
        Text Classification Multilabel task in AutoML NLP vertical.
        NLP - Natural Language Processing.
        :param pulumi.Input[str] task_type: AutoMLJob Task type.
               Expected value is 'TextClassificationMultilabel'.
        :param pulumi.Input['MLTableJobInputArgs'] training_data: [Required] Training data input.
        :param pulumi.Input['NlpVerticalFeaturizationSettingsArgs'] featurization_settings: Featurization inputs needed for AutoML job.
        :param pulumi.Input['NlpFixedParametersArgs'] fixed_parameters: Model/training parameters that will remain constant throughout training.
        :param pulumi.Input['NlpVerticalLimitSettingsArgs'] limit_settings: Execution constraints for AutoMLJob.
        :param pulumi.Input[Union[str, 'LogVerbosity']] log_verbosity: Log verbosity for the job.
        :param pulumi.Input[Sequence[pulumi.Input['NlpParameterSubspaceArgs']]] search_space: Search space for sampling different combinations of models and their hyperparameters.
        :param pulumi.Input['NlpSweepSettingsArgs'] sweep_settings: Settings for model sweeping and hyperparameter tuning.
        :param pulumi.Input[str] target_column_name: Target column name: This is prediction values column.
               Also known as label column name in context of classification tasks.
        :param pulumi.Input['MLTableJobInputArgs'] validation_data: Validation data inputs.
        """
        pulumi.set(__self__, "task_type", 'TextClassificationMultilabel')
        pulumi.set(__self__, "training_data", training_data)
        if featurization_settings is not None:
            pulumi.set(__self__, "featurization_settings", featurization_settings)
        if fixed_parameters is not None:
            pulumi.set(__self__, "fixed_parameters", fixed_parameters)
        if limit_settings is not None:
            pulumi.set(__self__, "limit_settings", limit_settings)
        if log_verbosity is None:
            log_verbosity = 'Info'
        if log_verbosity is not None:
            pulumi.set(__self__, "log_verbosity", log_verbosity)
        if search_space is not None:
            pulumi.set(__self__, "search_space", search_space)
        if sweep_settings is not None:
            pulumi.set(__self__, "sweep_settings", sweep_settings)
        if target_column_name is not None:
            pulumi.set(__self__, "target_column_name", target_column_name)
        if validation_data is not None:
            pulumi.set(__self__, "validation_data", validation_data)

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> pulumi.Input[str]:
        """
        AutoMLJob Task type.
        Expected value is 'TextClassificationMultilabel'.
        """
        return pulumi.get(self, "task_type")

    @task_type.setter
    def task_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "task_type", value)

    @property
    @pulumi.getter(name="trainingData")
    def training_data(self) -> pulumi.Input['MLTableJobInputArgs']:
        """
        [Required] Training data input.
        """
        return pulumi.get(self, "training_data")

    @training_data.setter
    def training_data(self, value: pulumi.Input['MLTableJobInputArgs']):
        pulumi.set(self, "training_data", value)

    @property
    @pulumi.getter(name="featurizationSettings")
    def featurization_settings(self) -> Optional[pulumi.Input['NlpVerticalFeaturizationSettingsArgs']]:
        """
        Featurization inputs needed for AutoML job.
        """
        return pulumi.get(self, "featurization_settings")

    @featurization_settings.setter
    def featurization_settings(self, value: Optional[pulumi.Input['NlpVerticalFeaturizationSettingsArgs']]):
        pulumi.set(self, "featurization_settings", value)

    @property
    @pulumi.getter(name="fixedParameters")
    def fixed_parameters(self) -> Optional[pulumi.Input['NlpFixedParametersArgs']]:
        """
        Model/training parameters that will remain constant throughout training.
        """
        return pulumi.get(self, "fixed_parameters")

    @fixed_parameters.setter
    def fixed_parameters(self, value: Optional[pulumi.Input['NlpFixedParametersArgs']]):
        pulumi.set(self, "fixed_parameters", value)

    @property
    @pulumi.getter(name="limitSettings")
    def limit_settings(self) -> Optional[pulumi.Input['NlpVerticalLimitSettingsArgs']]:
        """
        Execution constraints for AutoMLJob.
        """
        return pulumi.get(self, "limit_settings")

    @limit_settings.setter
    def limit_settings(self, value: Optional[pulumi.Input['NlpVerticalLimitSettingsArgs']]):
        pulumi.set(self, "limit_settings", value)

    @property
    @pulumi.getter(name="logVerbosity")
    def log_verbosity(self) -> Optional[pulumi.Input[Union[str, 'LogVerbosity']]]:
        """
        Log verbosity for the job.
        """
        return pulumi.get(self, "log_verbosity")

    @log_verbosity.setter
    def log_verbosity(self, value: Optional[pulumi.Input[Union[str, 'LogVerbosity']]]):
        pulumi.set(self, "log_verbosity", value)

    @property
    @pulumi.getter(name="searchSpace")
    def search_space(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NlpParameterSubspaceArgs']]]]:
        """
        Search space for sampling different combinations of models and their hyperparameters.
        """
        return pulumi.get(self, "search_space")

    @search_space.setter
    def search_space(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NlpParameterSubspaceArgs']]]]):
        pulumi.set(self, "search_space", value)

    @property
    @pulumi.getter(name="sweepSettings")
    def sweep_settings(self) -> Optional[pulumi.Input['NlpSweepSettingsArgs']]:
        """
        Settings for model sweeping and hyperparameter tuning.
        """
        return pulumi.get(self, "sweep_settings")

    @sweep_settings.setter
    def sweep_settings(self, value: Optional[pulumi.Input['NlpSweepSettingsArgs']]):
        pulumi.set(self, "sweep_settings", value)

    @property
    @pulumi.getter(name="targetColumnName")
    def target_column_name(self) -> Optional[pulumi.Input[str]]:
        """
        Target column name: This is prediction values column.
        Also known as label column name in context of classification tasks.
        """
        return pulumi.get(self, "target_column_name")

    @target_column_name.setter
    def target_column_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_column_name", value)

    @property
    @pulumi.getter(name="validationData")
    def validation_data(self) -> Optional[pulumi.Input['MLTableJobInputArgs']]:
        """
        Validation data inputs.
        """
        return pulumi.get(self, "validation_data")

    @validation_data.setter
    def validation_data(self, value: Optional[pulumi.Input['MLTableJobInputArgs']]):
        pulumi.set(self, "validation_data", value)


@pulumi.input_type
class TextClassificationArgs:
    def __init__(__self__, *,
                 task_type: pulumi.Input[str],
                 training_data: pulumi.Input['MLTableJobInputArgs'],
                 featurization_settings: Optional[pulumi.Input['NlpVerticalFeaturizationSettingsArgs']] = None,
                 fixed_parameters: Optional[pulumi.Input['NlpFixedParametersArgs']] = None,
                 limit_settings: Optional[pulumi.Input['NlpVerticalLimitSettingsArgs']] = None,
                 log_verbosity: Optional[pulumi.Input[Union[str, 'LogVerbosity']]] = None,
                 primary_metric: Optional[pulumi.Input[Union[str, 'ClassificationPrimaryMetrics']]] = None,
                 search_space: Optional[pulumi.Input[Sequence[pulumi.Input['NlpParameterSubspaceArgs']]]] = None,
                 sweep_settings: Optional[pulumi.Input['NlpSweepSettingsArgs']] = None,
                 target_column_name: Optional[pulumi.Input[str]] = None,
                 validation_data: Optional[pulumi.Input['MLTableJobInputArgs']] = None):
        """
        Text Classification task in AutoML NLP vertical.
        NLP - Natural Language Processing.
        :param pulumi.Input[str] task_type: AutoMLJob Task type.
               Expected value is 'TextClassification'.
        :param pulumi.Input['MLTableJobInputArgs'] training_data: [Required] Training data input.
        :param pulumi.Input['NlpVerticalFeaturizationSettingsArgs'] featurization_settings: Featurization inputs needed for AutoML job.
        :param pulumi.Input['NlpFixedParametersArgs'] fixed_parameters: Model/training parameters that will remain constant throughout training.
        :param pulumi.Input['NlpVerticalLimitSettingsArgs'] limit_settings: Execution constraints for AutoMLJob.
        :param pulumi.Input[Union[str, 'LogVerbosity']] log_verbosity: Log verbosity for the job.
        :param pulumi.Input[Union[str, 'ClassificationPrimaryMetrics']] primary_metric: Primary metric for Text-Classification task.
        :param pulumi.Input[Sequence[pulumi.Input['NlpParameterSubspaceArgs']]] search_space: Search space for sampling different combinations of models and their hyperparameters.
        :param pulumi.Input['NlpSweepSettingsArgs'] sweep_settings: Settings for model sweeping and hyperparameter tuning.
        :param pulumi.Input[str] target_column_name: Target column name: This is prediction values column.
               Also known as label column name in context of classification tasks.
        :param pulumi.Input['MLTableJobInputArgs'] validation_data: Validation data inputs.
        """
        pulumi.set(__self__, "task_type", 'TextClassification')
        pulumi.set(__self__, "training_data", training_data)
        if featurization_settings is not None:
            pulumi.set(__self__, "featurization_settings", featurization_settings)
        if fixed_parameters is not None:
            pulumi.set(__self__, "fixed_parameters", fixed_parameters)
        if limit_settings is not None:
            pulumi.set(__self__, "limit_settings", limit_settings)
        if log_verbosity is None:
            log_verbosity = 'Info'
        if log_verbosity is not None:
            pulumi.set(__self__, "log_verbosity", log_verbosity)
        if primary_metric is None:
            primary_metric = 'Accuracy'
        if primary_metric is not None:
            pulumi.set(__self__, "primary_metric", primary_metric)
        if search_space is not None:
            pulumi.set(__self__, "search_space", search_space)
        if sweep_settings is not None:
            pulumi.set(__self__, "sweep_settings", sweep_settings)
        if target_column_name is not None:
            pulumi.set(__self__, "target_column_name", target_column_name)
        if validation_data is not None:
            pulumi.set(__self__, "validation_data", validation_data)

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> pulumi.Input[str]:
        """
        AutoMLJob Task type.
        Expected value is 'TextClassification'.
        """
        return pulumi.get(self, "task_type")

    @task_type.setter
    def task_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "task_type", value)

    @property
    @pulumi.getter(name="trainingData")
    def training_data(self) -> pulumi.Input['MLTableJobInputArgs']:
        """
        [Required] Training data input.
        """
        return pulumi.get(self, "training_data")

    @training_data.setter
    def training_data(self, value: pulumi.Input['MLTableJobInputArgs']):
        pulumi.set(self, "training_data", value)

    @property
    @pulumi.getter(name="featurizationSettings")
    def featurization_settings(self) -> Optional[pulumi.Input['NlpVerticalFeaturizationSettingsArgs']]:
        """
        Featurization inputs needed for AutoML job.
        """
        return pulumi.get(self, "featurization_settings")

    @featurization_settings.setter
    def featurization_settings(self, value: Optional[pulumi.Input['NlpVerticalFeaturizationSettingsArgs']]):
        pulumi.set(self, "featurization_settings", value)

    @property
    @pulumi.getter(name="fixedParameters")
    def fixed_parameters(self) -> Optional[pulumi.Input['NlpFixedParametersArgs']]:
        """
        Model/training parameters that will remain constant throughout training.
        """
        return pulumi.get(self, "fixed_parameters")

    @fixed_parameters.setter
    def fixed_parameters(self, value: Optional[pulumi.Input['NlpFixedParametersArgs']]):
        pulumi.set(self, "fixed_parameters", value)

    @property
    @pulumi.getter(name="limitSettings")
    def limit_settings(self) -> Optional[pulumi.Input['NlpVerticalLimitSettingsArgs']]:
        """
        Execution constraints for AutoMLJob.
        """
        return pulumi.get(self, "limit_settings")

    @limit_settings.setter
    def limit_settings(self, value: Optional[pulumi.Input['NlpVerticalLimitSettingsArgs']]):
        pulumi.set(self, "limit_settings", value)

    @property
    @pulumi.getter(name="logVerbosity")
    def log_verbosity(self) -> Optional[pulumi.Input[Union[str, 'LogVerbosity']]]:
        """
        Log verbosity for the job.
        """
        return pulumi.get(self, "log_verbosity")

    @log_verbosity.setter
    def log_verbosity(self, value: Optional[pulumi.Input[Union[str, 'LogVerbosity']]]):
        pulumi.set(self, "log_verbosity", value)

    @property
    @pulumi.getter(name="primaryMetric")
    def primary_metric(self) -> Optional[pulumi.Input[Union[str, 'ClassificationPrimaryMetrics']]]:
        """
        Primary metric for Text-Classification task.
        """
        return pulumi.get(self, "primary_metric")

    @primary_metric.setter
    def primary_metric(self, value: Optional[pulumi.Input[Union[str, 'ClassificationPrimaryMetrics']]]):
        pulumi.set(self, "primary_metric", value)

    @property
    @pulumi.getter(name="searchSpace")
    def search_space(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NlpParameterSubspaceArgs']]]]:
        """
        Search space for sampling different combinations of models and their hyperparameters.
        """
        return pulumi.get(self, "search_space")

    @search_space.setter
    def search_space(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NlpParameterSubspaceArgs']]]]):
        pulumi.set(self, "search_space", value)

    @property
    @pulumi.getter(name="sweepSettings")
    def sweep_settings(self) -> Optional[pulumi.Input['NlpSweepSettingsArgs']]:
        """
        Settings for model sweeping and hyperparameter tuning.
        """
        return pulumi.get(self, "sweep_settings")

    @sweep_settings.setter
    def sweep_settings(self, value: Optional[pulumi.Input['NlpSweepSettingsArgs']]):
        pulumi.set(self, "sweep_settings", value)

    @property
    @pulumi.getter(name="targetColumnName")
    def target_column_name(self) -> Optional[pulumi.Input[str]]:
        """
        Target column name: This is prediction values column.
        Also known as label column name in context of classification tasks.
        """
        return pulumi.get(self, "target_column_name")

    @target_column_name.setter
    def target_column_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_column_name", value)

    @property
    @pulumi.getter(name="validationData")
    def validation_data(self) -> Optional[pulumi.Input['MLTableJobInputArgs']]:
        """
        Validation data inputs.
        """
        return pulumi.get(self, "validation_data")

    @validation_data.setter
    def validation_data(self, value: Optional[pulumi.Input['MLTableJobInputArgs']]):
        pulumi.set(self, "validation_data", value)


@pulumi.input_type
class TextNerArgs:
    def __init__(__self__, *,
                 task_type: pulumi.Input[str],
                 training_data: pulumi.Input['MLTableJobInputArgs'],
                 featurization_settings: Optional[pulumi.Input['NlpVerticalFeaturizationSettingsArgs']] = None,
                 fixed_parameters: Optional[pulumi.Input['NlpFixedParametersArgs']] = None,
                 limit_settings: Optional[pulumi.Input['NlpVerticalLimitSettingsArgs']] = None,
                 log_verbosity: Optional[pulumi.Input[Union[str, 'LogVerbosity']]] = None,
                 search_space: Optional[pulumi.Input[Sequence[pulumi.Input['NlpParameterSubspaceArgs']]]] = None,
                 sweep_settings: Optional[pulumi.Input['NlpSweepSettingsArgs']] = None,
                 target_column_name: Optional[pulumi.Input[str]] = None,
                 validation_data: Optional[pulumi.Input['MLTableJobInputArgs']] = None):
        """
        Text-NER task in AutoML NLP vertical.
        NER - Named Entity Recognition.
        NLP - Natural Language Processing.
        :param pulumi.Input[str] task_type: AutoMLJob Task type.
               Expected value is 'TextNER'.
        :param pulumi.Input['MLTableJobInputArgs'] training_data: [Required] Training data input.
        :param pulumi.Input['NlpVerticalFeaturizationSettingsArgs'] featurization_settings: Featurization inputs needed for AutoML job.
        :param pulumi.Input['NlpFixedParametersArgs'] fixed_parameters: Model/training parameters that will remain constant throughout training.
        :param pulumi.Input['NlpVerticalLimitSettingsArgs'] limit_settings: Execution constraints for AutoMLJob.
        :param pulumi.Input[Union[str, 'LogVerbosity']] log_verbosity: Log verbosity for the job.
        :param pulumi.Input[Sequence[pulumi.Input['NlpParameterSubspaceArgs']]] search_space: Search space for sampling different combinations of models and their hyperparameters.
        :param pulumi.Input['NlpSweepSettingsArgs'] sweep_settings: Settings for model sweeping and hyperparameter tuning.
        :param pulumi.Input[str] target_column_name: Target column name: This is prediction values column.
               Also known as label column name in context of classification tasks.
        :param pulumi.Input['MLTableJobInputArgs'] validation_data: Validation data inputs.
        """
        pulumi.set(__self__, "task_type", 'TextNER')
        pulumi.set(__self__, "training_data", training_data)
        if featurization_settings is not None:
            pulumi.set(__self__, "featurization_settings", featurization_settings)
        if fixed_parameters is not None:
            pulumi.set(__self__, "fixed_parameters", fixed_parameters)
        if limit_settings is not None:
            pulumi.set(__self__, "limit_settings", limit_settings)
        if log_verbosity is None:
            log_verbosity = 'Info'
        if log_verbosity is not None:
            pulumi.set(__self__, "log_verbosity", log_verbosity)
        if search_space is not None:
            pulumi.set(__self__, "search_space", search_space)
        if sweep_settings is not None:
            pulumi.set(__self__, "sweep_settings", sweep_settings)
        if target_column_name is not None:
            pulumi.set(__self__, "target_column_name", target_column_name)
        if validation_data is not None:
            pulumi.set(__self__, "validation_data", validation_data)

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> pulumi.Input[str]:
        """
        AutoMLJob Task type.
        Expected value is 'TextNER'.
        """
        return pulumi.get(self, "task_type")

    @task_type.setter
    def task_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "task_type", value)

    @property
    @pulumi.getter(name="trainingData")
    def training_data(self) -> pulumi.Input['MLTableJobInputArgs']:
        """
        [Required] Training data input.
        """
        return pulumi.get(self, "training_data")

    @training_data.setter
    def training_data(self, value: pulumi.Input['MLTableJobInputArgs']):
        pulumi.set(self, "training_data", value)

    @property
    @pulumi.getter(name="featurizationSettings")
    def featurization_settings(self) -> Optional[pulumi.Input['NlpVerticalFeaturizationSettingsArgs']]:
        """
        Featurization inputs needed for AutoML job.
        """
        return pulumi.get(self, "featurization_settings")

    @featurization_settings.setter
    def featurization_settings(self, value: Optional[pulumi.Input['NlpVerticalFeaturizationSettingsArgs']]):
        pulumi.set(self, "featurization_settings", value)

    @property
    @pulumi.getter(name="fixedParameters")
    def fixed_parameters(self) -> Optional[pulumi.Input['NlpFixedParametersArgs']]:
        """
        Model/training parameters that will remain constant throughout training.
        """
        return pulumi.get(self, "fixed_parameters")

    @fixed_parameters.setter
    def fixed_parameters(self, value: Optional[pulumi.Input['NlpFixedParametersArgs']]):
        pulumi.set(self, "fixed_parameters", value)

    @property
    @pulumi.getter(name="limitSettings")
    def limit_settings(self) -> Optional[pulumi.Input['NlpVerticalLimitSettingsArgs']]:
        """
        Execution constraints for AutoMLJob.
        """
        return pulumi.get(self, "limit_settings")

    @limit_settings.setter
    def limit_settings(self, value: Optional[pulumi.Input['NlpVerticalLimitSettingsArgs']]):
        pulumi.set(self, "limit_settings", value)

    @property
    @pulumi.getter(name="logVerbosity")
    def log_verbosity(self) -> Optional[pulumi.Input[Union[str, 'LogVerbosity']]]:
        """
        Log verbosity for the job.
        """
        return pulumi.get(self, "log_verbosity")

    @log_verbosity.setter
    def log_verbosity(self, value: Optional[pulumi.Input[Union[str, 'LogVerbosity']]]):
        pulumi.set(self, "log_verbosity", value)

    @property
    @pulumi.getter(name="searchSpace")
    def search_space(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NlpParameterSubspaceArgs']]]]:
        """
        Search space for sampling different combinations of models and their hyperparameters.
        """
        return pulumi.get(self, "search_space")

    @search_space.setter
    def search_space(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NlpParameterSubspaceArgs']]]]):
        pulumi.set(self, "search_space", value)

    @property
    @pulumi.getter(name="sweepSettings")
    def sweep_settings(self) -> Optional[pulumi.Input['NlpSweepSettingsArgs']]:
        """
        Settings for model sweeping and hyperparameter tuning.
        """
        return pulumi.get(self, "sweep_settings")

    @sweep_settings.setter
    def sweep_settings(self, value: Optional[pulumi.Input['NlpSweepSettingsArgs']]):
        pulumi.set(self, "sweep_settings", value)

    @property
    @pulumi.getter(name="targetColumnName")
    def target_column_name(self) -> Optional[pulumi.Input[str]]:
        """
        Target column name: This is prediction values column.
        Also known as label column name in context of classification tasks.
        """
        return pulumi.get(self, "target_column_name")

    @target_column_name.setter
    def target_column_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_column_name", value)

    @property
    @pulumi.getter(name="validationData")
    def validation_data(self) -> Optional[pulumi.Input['MLTableJobInputArgs']]:
        """
        Validation data inputs.
        """
        return pulumi.get(self, "validation_data")

    @validation_data.setter
    def validation_data(self, value: Optional[pulumi.Input['MLTableJobInputArgs']]):
        pulumi.set(self, "validation_data", value)


@pulumi.input_type
class TmpfsOptionsArgs:
    def __init__(__self__, *,
                 size: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] size: Mention the Tmpfs size
        """
        if size is not None:
            pulumi.set(__self__, "size", size)

    @property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[int]]:
        """
        Mention the Tmpfs size
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "size", value)


@pulumi.input_type
class TrialComponentArgs:
    def __init__(__self__, *,
                 command: pulumi.Input[str],
                 environment_id: pulumi.Input[str],
                 code_id: Optional[pulumi.Input[str]] = None,
                 distribution: Optional[pulumi.Input[Union['MpiArgs', 'PyTorchArgs', 'TensorFlowArgs']]] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 resources: Optional[pulumi.Input['JobResourceConfigurationArgs']] = None):
        """
        Trial component definition.
        :param pulumi.Input[str] command: [Required] The command to execute on startup of the job. eg. "python train.py"
        :param pulumi.Input[str] environment_id: [Required] The ARM resource ID of the Environment specification for the job.
        :param pulumi.Input[str] code_id: ARM resource ID of the code asset.
        :param pulumi.Input[Union['MpiArgs', 'PyTorchArgs', 'TensorFlowArgs']] distribution: Distribution configuration of the job. If set, this should be one of Mpi, Tensorflow, PyTorch, or null.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] environment_variables: Environment variables included in the job.
        :param pulumi.Input['JobResourceConfigurationArgs'] resources: Compute Resource configuration for the job.
        """
        pulumi.set(__self__, "command", command)
        pulumi.set(__self__, "environment_id", environment_id)
        if code_id is not None:
            pulumi.set(__self__, "code_id", code_id)
        if distribution is not None:
            pulumi.set(__self__, "distribution", distribution)
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)

    @property
    @pulumi.getter
    def command(self) -> pulumi.Input[str]:
        """
        [Required] The command to execute on startup of the job. eg. "python train.py"
        """
        return pulumi.get(self, "command")

    @command.setter
    def command(self, value: pulumi.Input[str]):
        pulumi.set(self, "command", value)

    @property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> pulumi.Input[str]:
        """
        [Required] The ARM resource ID of the Environment specification for the job.
        """
        return pulumi.get(self, "environment_id")

    @environment_id.setter
    def environment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "environment_id", value)

    @property
    @pulumi.getter(name="codeId")
    def code_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM resource ID of the code asset.
        """
        return pulumi.get(self, "code_id")

    @code_id.setter
    def code_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "code_id", value)

    @property
    @pulumi.getter
    def distribution(self) -> Optional[pulumi.Input[Union['MpiArgs', 'PyTorchArgs', 'TensorFlowArgs']]]:
        """
        Distribution configuration of the job. If set, this should be one of Mpi, Tensorflow, PyTorch, or null.
        """
        return pulumi.get(self, "distribution")

    @distribution.setter
    def distribution(self, value: Optional[pulumi.Input[Union['MpiArgs', 'PyTorchArgs', 'TensorFlowArgs']]]):
        pulumi.set(self, "distribution", value)

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Environment variables included in the job.
        """
        return pulumi.get(self, "environment_variables")

    @environment_variables.setter
    def environment_variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "environment_variables", value)

    @property
    @pulumi.getter
    def resources(self) -> Optional[pulumi.Input['JobResourceConfigurationArgs']]:
        """
        Compute Resource configuration for the job.
        """
        return pulumi.get(self, "resources")

    @resources.setter
    def resources(self, value: Optional[pulumi.Input['JobResourceConfigurationArgs']]):
        pulumi.set(self, "resources", value)


@pulumi.input_type
class TritonModelJobInputArgs:
    def __init__(__self__, *,
                 job_input_type: pulumi.Input[str],
                 uri: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 mode: Optional[pulumi.Input[Union[str, 'InputDeliveryMode']]] = None):
        """
        :param pulumi.Input[str] job_input_type: Enum to determine the Job Input Type.
               Expected value is 'triton_model'.
        :param pulumi.Input[str] uri: [Required] Input Asset URI.
        :param pulumi.Input[str] description: Description for the input.
        :param pulumi.Input[Union[str, 'InputDeliveryMode']] mode: Input Asset Delivery Mode.
        """
        pulumi.set(__self__, "job_input_type", 'triton_model')
        pulumi.set(__self__, "uri", uri)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if mode is None:
            mode = 'ReadOnlyMount'
        if mode is not None:
            pulumi.set(__self__, "mode", mode)

    @property
    @pulumi.getter(name="jobInputType")
    def job_input_type(self) -> pulumi.Input[str]:
        """
        Enum to determine the Job Input Type.
        Expected value is 'triton_model'.
        """
        return pulumi.get(self, "job_input_type")

    @job_input_type.setter
    def job_input_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "job_input_type", value)

    @property
    @pulumi.getter
    def uri(self) -> pulumi.Input[str]:
        """
        [Required] Input Asset URI.
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: pulumi.Input[str]):
        pulumi.set(self, "uri", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description for the input.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[Union[str, 'InputDeliveryMode']]]:
        """
        Input Asset Delivery Mode.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[Union[str, 'InputDeliveryMode']]]):
        pulumi.set(self, "mode", value)


@pulumi.input_type
class TritonModelJobOutputArgs:
    def __init__(__self__, *,
                 job_output_type: pulumi.Input[str],
                 asset_name: Optional[pulumi.Input[str]] = None,
                 asset_version: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 mode: Optional[pulumi.Input[Union[str, 'OutputDeliveryMode']]] = None,
                 uri: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] job_output_type: Enum to determine the Job Output Type.
               Expected value is 'triton_model'.
        :param pulumi.Input[str] asset_name: Output Asset Name.
        :param pulumi.Input[str] asset_version: Output Asset Version.
        :param pulumi.Input[str] description: Description for the output.
        :param pulumi.Input[Union[str, 'OutputDeliveryMode']] mode: Output Asset Delivery Mode.
        :param pulumi.Input[str] uri: Output Asset URI.
        """
        pulumi.set(__self__, "job_output_type", 'triton_model')
        if asset_name is not None:
            pulumi.set(__self__, "asset_name", asset_name)
        if asset_version is not None:
            pulumi.set(__self__, "asset_version", asset_version)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if mode is None:
            mode = 'ReadWriteMount'
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter(name="jobOutputType")
    def job_output_type(self) -> pulumi.Input[str]:
        """
        Enum to determine the Job Output Type.
        Expected value is 'triton_model'.
        """
        return pulumi.get(self, "job_output_type")

    @job_output_type.setter
    def job_output_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "job_output_type", value)

    @property
    @pulumi.getter(name="assetName")
    def asset_name(self) -> Optional[pulumi.Input[str]]:
        """
        Output Asset Name.
        """
        return pulumi.get(self, "asset_name")

    @asset_name.setter
    def asset_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "asset_name", value)

    @property
    @pulumi.getter(name="assetVersion")
    def asset_version(self) -> Optional[pulumi.Input[str]]:
        """
        Output Asset Version.
        """
        return pulumi.get(self, "asset_version")

    @asset_version.setter
    def asset_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "asset_version", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description for the output.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[Union[str, 'OutputDeliveryMode']]]:
        """
        Output Asset Delivery Mode.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[Union[str, 'OutputDeliveryMode']]]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter
    def uri(self) -> Optional[pulumi.Input[str]]:
        """
        Output Asset URI.
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uri", value)


@pulumi.input_type
class TruncationSelectionPolicyArgs:
    def __init__(__self__, *,
                 policy_type: pulumi.Input[str],
                 delay_evaluation: Optional[pulumi.Input[int]] = None,
                 evaluation_interval: Optional[pulumi.Input[int]] = None,
                 truncation_percentage: Optional[pulumi.Input[int]] = None):
        """
        Defines an early termination policy that cancels a given percentage of runs at each evaluation interval.
        :param pulumi.Input[str] policy_type: 
               Expected value is 'TruncationSelection'.
        :param pulumi.Input[int] delay_evaluation: Number of intervals by which to delay the first evaluation.
        :param pulumi.Input[int] evaluation_interval: Interval (number of runs) between policy evaluations.
        :param pulumi.Input[int] truncation_percentage: The percentage of runs to cancel at each evaluation interval.
        """
        pulumi.set(__self__, "policy_type", 'TruncationSelection')
        if delay_evaluation is None:
            delay_evaluation = 0
        if delay_evaluation is not None:
            pulumi.set(__self__, "delay_evaluation", delay_evaluation)
        if evaluation_interval is None:
            evaluation_interval = 0
        if evaluation_interval is not None:
            pulumi.set(__self__, "evaluation_interval", evaluation_interval)
        if truncation_percentage is None:
            truncation_percentage = 0
        if truncation_percentage is not None:
            pulumi.set(__self__, "truncation_percentage", truncation_percentage)

    @property
    @pulumi.getter(name="policyType")
    def policy_type(self) -> pulumi.Input[str]:
        """

        Expected value is 'TruncationSelection'.
        """
        return pulumi.get(self, "policy_type")

    @policy_type.setter
    def policy_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "policy_type", value)

    @property
    @pulumi.getter(name="delayEvaluation")
    def delay_evaluation(self) -> Optional[pulumi.Input[int]]:
        """
        Number of intervals by which to delay the first evaluation.
        """
        return pulumi.get(self, "delay_evaluation")

    @delay_evaluation.setter
    def delay_evaluation(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "delay_evaluation", value)

    @property
    @pulumi.getter(name="evaluationInterval")
    def evaluation_interval(self) -> Optional[pulumi.Input[int]]:
        """
        Interval (number of runs) between policy evaluations.
        """
        return pulumi.get(self, "evaluation_interval")

    @evaluation_interval.setter
    def evaluation_interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "evaluation_interval", value)

    @property
    @pulumi.getter(name="truncationPercentage")
    def truncation_percentage(self) -> Optional[pulumi.Input[int]]:
        """
        The percentage of runs to cancel at each evaluation interval.
        """
        return pulumi.get(self, "truncation_percentage")

    @truncation_percentage.setter
    def truncation_percentage(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "truncation_percentage", value)


@pulumi.input_type
class UriFileDataVersionArgs:
    def __init__(__self__, *,
                 data_type: pulumi.Input[str],
                 data_uri: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 is_anonymous: Optional[pulumi.Input[bool]] = None,
                 is_archived: Optional[pulumi.Input[bool]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        uri-file data version entity
        :param pulumi.Input[str] data_type: Enum to determine the type of data.
               Expected value is 'uri_file'.
        :param pulumi.Input[str] data_uri: [Required] Uri of the data. Example: https://go.microsoft.com/fwlink/?linkid=2202330
        :param pulumi.Input[str] description: The asset description text.
        :param pulumi.Input[bool] is_anonymous: If the name version are system generated (anonymous registration).
        :param pulumi.Input[bool] is_archived: Is the asset archived?
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: The asset property dictionary.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Tag dictionary. Tags can be added, removed, and updated.
        """
        pulumi.set(__self__, "data_type", 'uri_file')
        pulumi.set(__self__, "data_uri", data_uri)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if is_anonymous is None:
            is_anonymous = False
        if is_anonymous is not None:
            pulumi.set(__self__, "is_anonymous", is_anonymous)
        if is_archived is None:
            is_archived = False
        if is_archived is not None:
            pulumi.set(__self__, "is_archived", is_archived)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="dataType")
    def data_type(self) -> pulumi.Input[str]:
        """
        Enum to determine the type of data.
        Expected value is 'uri_file'.
        """
        return pulumi.get(self, "data_type")

    @data_type.setter
    def data_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "data_type", value)

    @property
    @pulumi.getter(name="dataUri")
    def data_uri(self) -> pulumi.Input[str]:
        """
        [Required] Uri of the data. Example: https://go.microsoft.com/fwlink/?linkid=2202330
        """
        return pulumi.get(self, "data_uri")

    @data_uri.setter
    def data_uri(self, value: pulumi.Input[str]):
        pulumi.set(self, "data_uri", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The asset description text.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="isAnonymous")
    def is_anonymous(self) -> Optional[pulumi.Input[bool]]:
        """
        If the name version are system generated (anonymous registration).
        """
        return pulumi.get(self, "is_anonymous")

    @is_anonymous.setter
    def is_anonymous(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_anonymous", value)

    @property
    @pulumi.getter(name="isArchived")
    def is_archived(self) -> Optional[pulumi.Input[bool]]:
        """
        Is the asset archived?
        """
        return pulumi.get(self, "is_archived")

    @is_archived.setter
    def is_archived(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_archived", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The asset property dictionary.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Tag dictionary. Tags can be added, removed, and updated.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class UriFileJobInputArgs:
    def __init__(__self__, *,
                 job_input_type: pulumi.Input[str],
                 uri: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 mode: Optional[pulumi.Input[Union[str, 'InputDeliveryMode']]] = None):
        """
        :param pulumi.Input[str] job_input_type: Enum to determine the Job Input Type.
               Expected value is 'uri_file'.
        :param pulumi.Input[str] uri: [Required] Input Asset URI.
        :param pulumi.Input[str] description: Description for the input.
        :param pulumi.Input[Union[str, 'InputDeliveryMode']] mode: Input Asset Delivery Mode.
        """
        pulumi.set(__self__, "job_input_type", 'uri_file')
        pulumi.set(__self__, "uri", uri)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if mode is None:
            mode = 'ReadOnlyMount'
        if mode is not None:
            pulumi.set(__self__, "mode", mode)

    @property
    @pulumi.getter(name="jobInputType")
    def job_input_type(self) -> pulumi.Input[str]:
        """
        Enum to determine the Job Input Type.
        Expected value is 'uri_file'.
        """
        return pulumi.get(self, "job_input_type")

    @job_input_type.setter
    def job_input_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "job_input_type", value)

    @property
    @pulumi.getter
    def uri(self) -> pulumi.Input[str]:
        """
        [Required] Input Asset URI.
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: pulumi.Input[str]):
        pulumi.set(self, "uri", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description for the input.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[Union[str, 'InputDeliveryMode']]]:
        """
        Input Asset Delivery Mode.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[Union[str, 'InputDeliveryMode']]]):
        pulumi.set(self, "mode", value)


@pulumi.input_type
class UriFileJobOutputArgs:
    def __init__(__self__, *,
                 job_output_type: pulumi.Input[str],
                 asset_name: Optional[pulumi.Input[str]] = None,
                 asset_version: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 mode: Optional[pulumi.Input[Union[str, 'OutputDeliveryMode']]] = None,
                 uri: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] job_output_type: Enum to determine the Job Output Type.
               Expected value is 'uri_file'.
        :param pulumi.Input[str] asset_name: Output Asset Name.
        :param pulumi.Input[str] asset_version: Output Asset Version.
        :param pulumi.Input[str] description: Description for the output.
        :param pulumi.Input[Union[str, 'OutputDeliveryMode']] mode: Output Asset Delivery Mode.
        :param pulumi.Input[str] uri: Output Asset URI.
        """
        pulumi.set(__self__, "job_output_type", 'uri_file')
        if asset_name is not None:
            pulumi.set(__self__, "asset_name", asset_name)
        if asset_version is not None:
            pulumi.set(__self__, "asset_version", asset_version)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if mode is None:
            mode = 'ReadWriteMount'
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter(name="jobOutputType")
    def job_output_type(self) -> pulumi.Input[str]:
        """
        Enum to determine the Job Output Type.
        Expected value is 'uri_file'.
        """
        return pulumi.get(self, "job_output_type")

    @job_output_type.setter
    def job_output_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "job_output_type", value)

    @property
    @pulumi.getter(name="assetName")
    def asset_name(self) -> Optional[pulumi.Input[str]]:
        """
        Output Asset Name.
        """
        return pulumi.get(self, "asset_name")

    @asset_name.setter
    def asset_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "asset_name", value)

    @property
    @pulumi.getter(name="assetVersion")
    def asset_version(self) -> Optional[pulumi.Input[str]]:
        """
        Output Asset Version.
        """
        return pulumi.get(self, "asset_version")

    @asset_version.setter
    def asset_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "asset_version", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description for the output.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[Union[str, 'OutputDeliveryMode']]]:
        """
        Output Asset Delivery Mode.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[Union[str, 'OutputDeliveryMode']]]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter
    def uri(self) -> Optional[pulumi.Input[str]]:
        """
        Output Asset URI.
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uri", value)


@pulumi.input_type
class UriFolderDataVersionArgs:
    def __init__(__self__, *,
                 data_type: pulumi.Input[str],
                 data_uri: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 is_anonymous: Optional[pulumi.Input[bool]] = None,
                 is_archived: Optional[pulumi.Input[bool]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        uri-folder data version entity
        :param pulumi.Input[str] data_type: Enum to determine the type of data.
               Expected value is 'uri_folder'.
        :param pulumi.Input[str] data_uri: [Required] Uri of the data. Example: https://go.microsoft.com/fwlink/?linkid=2202330
        :param pulumi.Input[str] description: The asset description text.
        :param pulumi.Input[bool] is_anonymous: If the name version are system generated (anonymous registration).
        :param pulumi.Input[bool] is_archived: Is the asset archived?
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: The asset property dictionary.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Tag dictionary. Tags can be added, removed, and updated.
        """
        pulumi.set(__self__, "data_type", 'uri_folder')
        pulumi.set(__self__, "data_uri", data_uri)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if is_anonymous is None:
            is_anonymous = False
        if is_anonymous is not None:
            pulumi.set(__self__, "is_anonymous", is_anonymous)
        if is_archived is None:
            is_archived = False
        if is_archived is not None:
            pulumi.set(__self__, "is_archived", is_archived)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="dataType")
    def data_type(self) -> pulumi.Input[str]:
        """
        Enum to determine the type of data.
        Expected value is 'uri_folder'.
        """
        return pulumi.get(self, "data_type")

    @data_type.setter
    def data_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "data_type", value)

    @property
    @pulumi.getter(name="dataUri")
    def data_uri(self) -> pulumi.Input[str]:
        """
        [Required] Uri of the data. Example: https://go.microsoft.com/fwlink/?linkid=2202330
        """
        return pulumi.get(self, "data_uri")

    @data_uri.setter
    def data_uri(self, value: pulumi.Input[str]):
        pulumi.set(self, "data_uri", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The asset description text.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="isAnonymous")
    def is_anonymous(self) -> Optional[pulumi.Input[bool]]:
        """
        If the name version are system generated (anonymous registration).
        """
        return pulumi.get(self, "is_anonymous")

    @is_anonymous.setter
    def is_anonymous(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_anonymous", value)

    @property
    @pulumi.getter(name="isArchived")
    def is_archived(self) -> Optional[pulumi.Input[bool]]:
        """
        Is the asset archived?
        """
        return pulumi.get(self, "is_archived")

    @is_archived.setter
    def is_archived(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_archived", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The asset property dictionary.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Tag dictionary. Tags can be added, removed, and updated.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class UriFolderJobInputArgs:
    def __init__(__self__, *,
                 job_input_type: pulumi.Input[str],
                 uri: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 mode: Optional[pulumi.Input[Union[str, 'InputDeliveryMode']]] = None):
        """
        :param pulumi.Input[str] job_input_type: Enum to determine the Job Input Type.
               Expected value is 'uri_folder'.
        :param pulumi.Input[str] uri: [Required] Input Asset URI.
        :param pulumi.Input[str] description: Description for the input.
        :param pulumi.Input[Union[str, 'InputDeliveryMode']] mode: Input Asset Delivery Mode.
        """
        pulumi.set(__self__, "job_input_type", 'uri_folder')
        pulumi.set(__self__, "uri", uri)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if mode is None:
            mode = 'ReadOnlyMount'
        if mode is not None:
            pulumi.set(__self__, "mode", mode)

    @property
    @pulumi.getter(name="jobInputType")
    def job_input_type(self) -> pulumi.Input[str]:
        """
        Enum to determine the Job Input Type.
        Expected value is 'uri_folder'.
        """
        return pulumi.get(self, "job_input_type")

    @job_input_type.setter
    def job_input_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "job_input_type", value)

    @property
    @pulumi.getter
    def uri(self) -> pulumi.Input[str]:
        """
        [Required] Input Asset URI.
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: pulumi.Input[str]):
        pulumi.set(self, "uri", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description for the input.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[Union[str, 'InputDeliveryMode']]]:
        """
        Input Asset Delivery Mode.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[Union[str, 'InputDeliveryMode']]]):
        pulumi.set(self, "mode", value)


@pulumi.input_type
class UriFolderJobOutputArgs:
    def __init__(__self__, *,
                 job_output_type: pulumi.Input[str],
                 asset_name: Optional[pulumi.Input[str]] = None,
                 asset_version: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 mode: Optional[pulumi.Input[Union[str, 'OutputDeliveryMode']]] = None,
                 uri: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] job_output_type: Enum to determine the Job Output Type.
               Expected value is 'uri_folder'.
        :param pulumi.Input[str] asset_name: Output Asset Name.
        :param pulumi.Input[str] asset_version: Output Asset Version.
        :param pulumi.Input[str] description: Description for the output.
        :param pulumi.Input[Union[str, 'OutputDeliveryMode']] mode: Output Asset Delivery Mode.
        :param pulumi.Input[str] uri: Output Asset URI.
        """
        pulumi.set(__self__, "job_output_type", 'uri_folder')
        if asset_name is not None:
            pulumi.set(__self__, "asset_name", asset_name)
        if asset_version is not None:
            pulumi.set(__self__, "asset_version", asset_version)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if mode is None:
            mode = 'ReadWriteMount'
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter(name="jobOutputType")
    def job_output_type(self) -> pulumi.Input[str]:
        """
        Enum to determine the Job Output Type.
        Expected value is 'uri_folder'.
        """
        return pulumi.get(self, "job_output_type")

    @job_output_type.setter
    def job_output_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "job_output_type", value)

    @property
    @pulumi.getter(name="assetName")
    def asset_name(self) -> Optional[pulumi.Input[str]]:
        """
        Output Asset Name.
        """
        return pulumi.get(self, "asset_name")

    @asset_name.setter
    def asset_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "asset_name", value)

    @property
    @pulumi.getter(name="assetVersion")
    def asset_version(self) -> Optional[pulumi.Input[str]]:
        """
        Output Asset Version.
        """
        return pulumi.get(self, "asset_version")

    @asset_version.setter
    def asset_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "asset_version", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description for the output.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[Union[str, 'OutputDeliveryMode']]]:
        """
        Output Asset Delivery Mode.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[Union[str, 'OutputDeliveryMode']]]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter
    def uri(self) -> Optional[pulumi.Input[str]]:
        """
        Output Asset URI.
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uri", value)


@pulumi.input_type
class UserAccountCredentialsArgs:
    def __init__(__self__, *,
                 admin_user_name: pulumi.Input[str],
                 admin_user_password: Optional[pulumi.Input[str]] = None,
                 admin_user_ssh_public_key: Optional[pulumi.Input[str]] = None):
        """
        Settings for user account that gets created on each on the nodes of a compute.
        :param pulumi.Input[str] admin_user_name: Name of the administrator user account which can be used to SSH to nodes.
        :param pulumi.Input[str] admin_user_password: Password of the administrator user account.
        :param pulumi.Input[str] admin_user_ssh_public_key: SSH public key of the administrator user account.
        """
        pulumi.set(__self__, "admin_user_name", admin_user_name)
        if admin_user_password is not None:
            pulumi.set(__self__, "admin_user_password", admin_user_password)
        if admin_user_ssh_public_key is not None:
            pulumi.set(__self__, "admin_user_ssh_public_key", admin_user_ssh_public_key)

    @property
    @pulumi.getter(name="adminUserName")
    def admin_user_name(self) -> pulumi.Input[str]:
        """
        Name of the administrator user account which can be used to SSH to nodes.
        """
        return pulumi.get(self, "admin_user_name")

    @admin_user_name.setter
    def admin_user_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "admin_user_name", value)

    @property
    @pulumi.getter(name="adminUserPassword")
    def admin_user_password(self) -> Optional[pulumi.Input[str]]:
        """
        Password of the administrator user account.
        """
        return pulumi.get(self, "admin_user_password")

    @admin_user_password.setter
    def admin_user_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "admin_user_password", value)

    @property
    @pulumi.getter(name="adminUserSshPublicKey")
    def admin_user_ssh_public_key(self) -> Optional[pulumi.Input[str]]:
        """
        SSH public key of the administrator user account.
        """
        return pulumi.get(self, "admin_user_ssh_public_key")

    @admin_user_ssh_public_key.setter
    def admin_user_ssh_public_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "admin_user_ssh_public_key", value)


@pulumi.input_type
class UserCreatedAcrAccountArgs:
    def __init__(__self__, *,
                 arm_resource_id: Optional[pulumi.Input['ArmResourceIdArgs']] = None):
        """
        :param pulumi.Input['ArmResourceIdArgs'] arm_resource_id: ARM ResourceId of a resource
        """
        if arm_resource_id is not None:
            pulumi.set(__self__, "arm_resource_id", arm_resource_id)

    @property
    @pulumi.getter(name="armResourceId")
    def arm_resource_id(self) -> Optional[pulumi.Input['ArmResourceIdArgs']]:
        """
        ARM ResourceId of a resource
        """
        return pulumi.get(self, "arm_resource_id")

    @arm_resource_id.setter
    def arm_resource_id(self, value: Optional[pulumi.Input['ArmResourceIdArgs']]):
        pulumi.set(self, "arm_resource_id", value)


@pulumi.input_type
class UserCreatedStorageAccountArgs:
    def __init__(__self__, *,
                 arm_resource_id: Optional[pulumi.Input['ArmResourceIdArgs']] = None):
        """
        :param pulumi.Input['ArmResourceIdArgs'] arm_resource_id: ARM ResourceId of a resource
        """
        if arm_resource_id is not None:
            pulumi.set(__self__, "arm_resource_id", arm_resource_id)

    @property
    @pulumi.getter(name="armResourceId")
    def arm_resource_id(self) -> Optional[pulumi.Input['ArmResourceIdArgs']]:
        """
        ARM ResourceId of a resource
        """
        return pulumi.get(self, "arm_resource_id")

    @arm_resource_id.setter
    def arm_resource_id(self, value: Optional[pulumi.Input['ArmResourceIdArgs']]):
        pulumi.set(self, "arm_resource_id", value)


@pulumi.input_type
class UserIdentityArgs:
    def __init__(__self__, *,
                 identity_type: pulumi.Input[str]):
        """
        User identity configuration.
        :param pulumi.Input[str] identity_type: Enum to determine identity framework.
               Expected value is 'UserIdentity'.
        """
        pulumi.set(__self__, "identity_type", 'UserIdentity')

    @property
    @pulumi.getter(name="identityType")
    def identity_type(self) -> pulumi.Input[str]:
        """
        Enum to determine identity framework.
        Expected value is 'UserIdentity'.
        """
        return pulumi.get(self, "identity_type")

    @identity_type.setter
    def identity_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "identity_type", value)


@pulumi.input_type
class UsernamePasswordAuthTypeWorkspaceConnectionPropertiesArgs:
    def __init__(__self__, *,
                 auth_type: pulumi.Input[str],
                 category: Optional[pulumi.Input[Union[str, 'ConnectionCategory']]] = None,
                 credentials: Optional[pulumi.Input['WorkspaceConnectionUsernamePasswordArgs']] = None,
                 target: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None,
                 value_format: Optional[pulumi.Input[Union[str, 'ValueFormat']]] = None):
        """
        :param pulumi.Input[str] auth_type: Authentication type of the connection target
               Expected value is 'UsernamePassword'.
        :param pulumi.Input[Union[str, 'ConnectionCategory']] category: Category of the connection
        :param pulumi.Input[str] value: Value details of the workspace connection.
        :param pulumi.Input[Union[str, 'ValueFormat']] value_format: format for the workspace connection value
        """
        pulumi.set(__self__, "auth_type", 'UsernamePassword')
        if category is not None:
            pulumi.set(__self__, "category", category)
        if credentials is not None:
            pulumi.set(__self__, "credentials", credentials)
        if target is not None:
            pulumi.set(__self__, "target", target)
        if value is not None:
            pulumi.set(__self__, "value", value)
        if value_format is not None:
            pulumi.set(__self__, "value_format", value_format)

    @property
    @pulumi.getter(name="authType")
    def auth_type(self) -> pulumi.Input[str]:
        """
        Authentication type of the connection target
        Expected value is 'UsernamePassword'.
        """
        return pulumi.get(self, "auth_type")

    @auth_type.setter
    def auth_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "auth_type", value)

    @property
    @pulumi.getter
    def category(self) -> Optional[pulumi.Input[Union[str, 'ConnectionCategory']]]:
        """
        Category of the connection
        """
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: Optional[pulumi.Input[Union[str, 'ConnectionCategory']]]):
        pulumi.set(self, "category", value)

    @property
    @pulumi.getter
    def credentials(self) -> Optional[pulumi.Input['WorkspaceConnectionUsernamePasswordArgs']]:
        return pulumi.get(self, "credentials")

    @credentials.setter
    def credentials(self, value: Optional[pulumi.Input['WorkspaceConnectionUsernamePasswordArgs']]):
        pulumi.set(self, "credentials", value)

    @property
    @pulumi.getter
    def target(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        Value details of the workspace connection.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter(name="valueFormat")
    def value_format(self) -> Optional[pulumi.Input[Union[str, 'ValueFormat']]]:
        """
        format for the workspace connection value
        """
        return pulumi.get(self, "value_format")

    @value_format.setter
    def value_format(self, value: Optional[pulumi.Input[Union[str, 'ValueFormat']]]):
        pulumi.set(self, "value_format", value)


@pulumi.input_type
class VirtualMachineImageArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[str]):
        """
        Virtual Machine image for Windows AML Compute
        :param pulumi.Input[str] id: Virtual Machine image path
        """
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[str]:
        """
        Virtual Machine image path
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[str]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class VirtualMachineSchemaPropertiesArgs:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[str]] = None,
                 administrator_account: Optional[pulumi.Input['VirtualMachineSshCredentialsArgs']] = None,
                 is_notebook_instance_compute: Optional[pulumi.Input[bool]] = None,
                 notebook_server_port: Optional[pulumi.Input[int]] = None,
                 ssh_port: Optional[pulumi.Input[int]] = None,
                 virtual_machine_size: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] address: Public IP address of the virtual machine.
        :param pulumi.Input['VirtualMachineSshCredentialsArgs'] administrator_account: Admin credentials for virtual machine
        :param pulumi.Input[bool] is_notebook_instance_compute: Indicates whether this compute will be used for running notebooks.
        :param pulumi.Input[int] notebook_server_port: Notebook server port open for ssh connections.
        :param pulumi.Input[int] ssh_port: Port open for ssh connections.
        :param pulumi.Input[str] virtual_machine_size: Virtual Machine size
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if administrator_account is not None:
            pulumi.set(__self__, "administrator_account", administrator_account)
        if is_notebook_instance_compute is not None:
            pulumi.set(__self__, "is_notebook_instance_compute", is_notebook_instance_compute)
        if notebook_server_port is not None:
            pulumi.set(__self__, "notebook_server_port", notebook_server_port)
        if ssh_port is not None:
            pulumi.set(__self__, "ssh_port", ssh_port)
        if virtual_machine_size is not None:
            pulumi.set(__self__, "virtual_machine_size", virtual_machine_size)

    @property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[str]]:
        """
        Public IP address of the virtual machine.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter(name="administratorAccount")
    def administrator_account(self) -> Optional[pulumi.Input['VirtualMachineSshCredentialsArgs']]:
        """
        Admin credentials for virtual machine
        """
        return pulumi.get(self, "administrator_account")

    @administrator_account.setter
    def administrator_account(self, value: Optional[pulumi.Input['VirtualMachineSshCredentialsArgs']]):
        pulumi.set(self, "administrator_account", value)

    @property
    @pulumi.getter(name="isNotebookInstanceCompute")
    def is_notebook_instance_compute(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether this compute will be used for running notebooks.
        """
        return pulumi.get(self, "is_notebook_instance_compute")

    @is_notebook_instance_compute.setter
    def is_notebook_instance_compute(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_notebook_instance_compute", value)

    @property
    @pulumi.getter(name="notebookServerPort")
    def notebook_server_port(self) -> Optional[pulumi.Input[int]]:
        """
        Notebook server port open for ssh connections.
        """
        return pulumi.get(self, "notebook_server_port")

    @notebook_server_port.setter
    def notebook_server_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "notebook_server_port", value)

    @property
    @pulumi.getter(name="sshPort")
    def ssh_port(self) -> Optional[pulumi.Input[int]]:
        """
        Port open for ssh connections.
        """
        return pulumi.get(self, "ssh_port")

    @ssh_port.setter
    def ssh_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ssh_port", value)

    @property
    @pulumi.getter(name="virtualMachineSize")
    def virtual_machine_size(self) -> Optional[pulumi.Input[str]]:
        """
        Virtual Machine size
        """
        return pulumi.get(self, "virtual_machine_size")

    @virtual_machine_size.setter
    def virtual_machine_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "virtual_machine_size", value)


@pulumi.input_type
class VirtualMachineSshCredentialsArgs:
    def __init__(__self__, *,
                 password: Optional[pulumi.Input[str]] = None,
                 private_key_data: Optional[pulumi.Input[str]] = None,
                 public_key_data: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None):
        """
        Admin credentials for virtual machine
        :param pulumi.Input[str] password: Password of admin account
        :param pulumi.Input[str] private_key_data: Private key data
        :param pulumi.Input[str] public_key_data: Public key data
        :param pulumi.Input[str] username: Username of admin account
        """
        if password is not None:
            pulumi.set(__self__, "password", password)
        if private_key_data is not None:
            pulumi.set(__self__, "private_key_data", private_key_data)
        if public_key_data is not None:
            pulumi.set(__self__, "public_key_data", public_key_data)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        Password of admin account
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="privateKeyData")
    def private_key_data(self) -> Optional[pulumi.Input[str]]:
        """
        Private key data
        """
        return pulumi.get(self, "private_key_data")

    @private_key_data.setter
    def private_key_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_key_data", value)

    @property
    @pulumi.getter(name="publicKeyData")
    def public_key_data(self) -> Optional[pulumi.Input[str]]:
        """
        Public key data
        """
        return pulumi.get(self, "public_key_data")

    @public_key_data.setter
    def public_key_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_key_data", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        Username of admin account
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class VirtualMachineArgs:
    def __init__(__self__, *,
                 compute_type: pulumi.Input[str],
                 compute_location: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disable_local_auth: Optional[pulumi.Input[bool]] = None,
                 properties: Optional[pulumi.Input['VirtualMachineSchemaPropertiesArgs']] = None,
                 resource_id: Optional[pulumi.Input[str]] = None):
        """
        A Machine Learning compute based on Azure Virtual Machines.
        :param pulumi.Input[str] compute_type: The type of compute
               Expected value is 'VirtualMachine'.
        :param pulumi.Input[str] compute_location: Location for the underlying compute
        :param pulumi.Input[str] description: The description of the Machine Learning compute.
        :param pulumi.Input[bool] disable_local_auth: Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
        :param pulumi.Input[str] resource_id: ARM resource id of the underlying compute
        """
        pulumi.set(__self__, "compute_type", 'VirtualMachine')
        if compute_location is not None:
            pulumi.set(__self__, "compute_location", compute_location)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_local_auth is not None:
            pulumi.set(__self__, "disable_local_auth", disable_local_auth)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="computeType")
    def compute_type(self) -> pulumi.Input[str]:
        """
        The type of compute
        Expected value is 'VirtualMachine'.
        """
        return pulumi.get(self, "compute_type")

    @compute_type.setter
    def compute_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "compute_type", value)

    @property
    @pulumi.getter(name="computeLocation")
    def compute_location(self) -> Optional[pulumi.Input[str]]:
        """
        Location for the underlying compute
        """
        return pulumi.get(self, "compute_location")

    @compute_location.setter
    def compute_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compute_location", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the Machine Learning compute.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="disableLocalAuth")
    def disable_local_auth(self) -> Optional[pulumi.Input[bool]]:
        """
        Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
        """
        return pulumi.get(self, "disable_local_auth")

    @disable_local_auth.setter
    def disable_local_auth(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_local_auth", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input['VirtualMachineSchemaPropertiesArgs']]:
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input['VirtualMachineSchemaPropertiesArgs']]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARM resource id of the underlying compute
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_id", value)


@pulumi.input_type
class VolumeDefinitionArgs:
    def __init__(__self__, *,
                 bind: Optional[pulumi.Input['BindOptionsArgs']] = None,
                 consistency: Optional[pulumi.Input[str]] = None,
                 read_only: Optional[pulumi.Input[bool]] = None,
                 source: Optional[pulumi.Input[str]] = None,
                 target: Optional[pulumi.Input[str]] = None,
                 tmpfs: Optional[pulumi.Input['TmpfsOptionsArgs']] = None,
                 type: Optional[pulumi.Input[Union[str, 'VolumeDefinitionType']]] = None,
                 volume: Optional[pulumi.Input['VolumeOptionsArgs']] = None):
        """
        :param pulumi.Input['BindOptionsArgs'] bind: Bind Options of the mount
        :param pulumi.Input[str] consistency: Consistency of the volume
        :param pulumi.Input[bool] read_only: Indicate whether to mount volume as readOnly. Default value for this is false.
        :param pulumi.Input[str] source: Source of the mount. For bind mounts this is the host path.
        :param pulumi.Input[str] target: Target of the mount. For bind mounts this is the path in the container.
        :param pulumi.Input['TmpfsOptionsArgs'] tmpfs: tmpfs option of the mount
        :param pulumi.Input[Union[str, 'VolumeDefinitionType']] type: Type of Volume Definition. Possible Values: bind,volume,tmpfs,npipe
        :param pulumi.Input['VolumeOptionsArgs'] volume: Volume Options of the mount
        """
        if bind is not None:
            pulumi.set(__self__, "bind", bind)
        if consistency is not None:
            pulumi.set(__self__, "consistency", consistency)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if target is not None:
            pulumi.set(__self__, "target", target)
        if tmpfs is not None:
            pulumi.set(__self__, "tmpfs", tmpfs)
        if type is None:
            type = 'bind'
        if type is not None:
            pulumi.set(__self__, "type", type)
        if volume is not None:
            pulumi.set(__self__, "volume", volume)

    @property
    @pulumi.getter
    def bind(self) -> Optional[pulumi.Input['BindOptionsArgs']]:
        """
        Bind Options of the mount
        """
        return pulumi.get(self, "bind")

    @bind.setter
    def bind(self, value: Optional[pulumi.Input['BindOptionsArgs']]):
        pulumi.set(self, "bind", value)

    @property
    @pulumi.getter
    def consistency(self) -> Optional[pulumi.Input[str]]:
        """
        Consistency of the volume
        """
        return pulumi.get(self, "consistency")

    @consistency.setter
    def consistency(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "consistency", value)

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicate whether to mount volume as readOnly. Default value for this is false.
        """
        return pulumi.get(self, "read_only")

    @read_only.setter
    def read_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "read_only", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[str]]:
        """
        Source of the mount. For bind mounts this is the host path.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter
    def target(self) -> Optional[pulumi.Input[str]]:
        """
        Target of the mount. For bind mounts this is the path in the container.
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target", value)

    @property
    @pulumi.getter
    def tmpfs(self) -> Optional[pulumi.Input['TmpfsOptionsArgs']]:
        """
        tmpfs option of the mount
        """
        return pulumi.get(self, "tmpfs")

    @tmpfs.setter
    def tmpfs(self, value: Optional[pulumi.Input['TmpfsOptionsArgs']]):
        pulumi.set(self, "tmpfs", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[Union[str, 'VolumeDefinitionType']]]:
        """
        Type of Volume Definition. Possible Values: bind,volume,tmpfs,npipe
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[Union[str, 'VolumeDefinitionType']]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def volume(self) -> Optional[pulumi.Input['VolumeOptionsArgs']]:
        """
        Volume Options of the mount
        """
        return pulumi.get(self, "volume")

    @volume.setter
    def volume(self, value: Optional[pulumi.Input['VolumeOptionsArgs']]):
        pulumi.set(self, "volume", value)


@pulumi.input_type
class VolumeOptionsArgs:
    def __init__(__self__, *,
                 nocopy: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[bool] nocopy: Indicate whether volume is nocopy
        """
        if nocopy is not None:
            pulumi.set(__self__, "nocopy", nocopy)

    @property
    @pulumi.getter
    def nocopy(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicate whether volume is nocopy
        """
        return pulumi.get(self, "nocopy")

    @nocopy.setter
    def nocopy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "nocopy", value)


@pulumi.input_type
class WorkspaceConnectionAccessKeyArgs:
    def __init__(__self__, *,
                 access_key_id: Optional[pulumi.Input[str]] = None,
                 secret_access_key: Optional[pulumi.Input[str]] = None):
        if access_key_id is not None:
            pulumi.set(__self__, "access_key_id", access_key_id)
        if secret_access_key is not None:
            pulumi.set(__self__, "secret_access_key", secret_access_key)

    @property
    @pulumi.getter(name="accessKeyId")
    def access_key_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "access_key_id")

    @access_key_id.setter
    def access_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_key_id", value)

    @property
    @pulumi.getter(name="secretAccessKey")
    def secret_access_key(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "secret_access_key")

    @secret_access_key.setter
    def secret_access_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret_access_key", value)


@pulumi.input_type
class WorkspaceConnectionManagedIdentityArgs:
    def __init__(__self__, *,
                 client_id: Optional[pulumi.Input[str]] = None,
                 resource_id: Optional[pulumi.Input[str]] = None):
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_id", value)


@pulumi.input_type
class WorkspaceConnectionPersonalAccessTokenArgs:
    def __init__(__self__, *,
                 pat: Optional[pulumi.Input[str]] = None):
        if pat is not None:
            pulumi.set(__self__, "pat", pat)

    @property
    @pulumi.getter
    def pat(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "pat")

    @pat.setter
    def pat(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pat", value)


@pulumi.input_type
class WorkspaceConnectionServicePrincipalArgs:
    def __init__(__self__, *,
                 client_id: Optional[pulumi.Input[str]] = None,
                 client_secret: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None):
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_secret", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)


@pulumi.input_type
class WorkspaceConnectionSharedAccessSignatureArgs:
    def __init__(__self__, *,
                 sas: Optional[pulumi.Input[str]] = None):
        if sas is not None:
            pulumi.set(__self__, "sas", sas)

    @property
    @pulumi.getter
    def sas(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "sas")

    @sas.setter
    def sas(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sas", value)


@pulumi.input_type
class WorkspaceConnectionUsernamePasswordArgs:
    def __init__(__self__, *,
                 password: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None):
        if password is not None:
            pulumi.set(__self__, "password", password)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)


