# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetTrafficControllerInterfaceResult',
    'AwaitableGetTrafficControllerInterfaceResult',
    'get_traffic_controller_interface',
    'get_traffic_controller_interface_output',
]

@pulumi.output_type
class GetTrafficControllerInterfaceResult:
    """
    Concrete tracked resource types can be created by aliasing this type using a specific property type.
    """
    def __init__(__self__, associations=None, configuration_endpoints=None, frontends=None, id=None, location=None, name=None, provisioning_state=None, system_data=None, tags=None, type=None):
        if associations and not isinstance(associations, list):
            raise TypeError("Expected argument 'associations' to be a list")
        pulumi.set(__self__, "associations", associations)
        if configuration_endpoints and not isinstance(configuration_endpoints, list):
            raise TypeError("Expected argument 'configuration_endpoints' to be a list")
        pulumi.set(__self__, "configuration_endpoints", configuration_endpoints)
        if frontends and not isinstance(frontends, list):
            raise TypeError("Expected argument 'frontends' to be a list")
        pulumi.set(__self__, "frontends", frontends)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if provisioning_state and not isinstance(provisioning_state, str):
            raise TypeError("Expected argument 'provisioning_state' to be a str")
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if system_data and not isinstance(system_data, dict):
            raise TypeError("Expected argument 'system_data' to be a dict")
        pulumi.set(__self__, "system_data", system_data)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def associations(self) -> Sequence['outputs.ResourceIDResponse']:
        """
        Associations References List
        """
        return pulumi.get(self, "associations")

    @property
    @pulumi.getter(name="configurationEndpoints")
    def configuration_endpoints(self) -> Sequence[str]:
        """
        Configuration Endpoints.
        """
        return pulumi.get(self, "configuration_endpoints")

    @property
    @pulumi.getter
    def frontends(self) -> Sequence['outputs.ResourceIDResponse']:
        """
        Frontends References List
        """
        return pulumi.get(self, "frontends")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        The geo-location where the resource lives
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The status of the last operation.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="systemData")
    def system_data(self) -> 'outputs.SystemDataResponse':
        """
        Azure Resource Manager metadata containing createdBy and modifiedBy information.
        """
        return pulumi.get(self, "system_data")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
        """
        return pulumi.get(self, "type")


class AwaitableGetTrafficControllerInterfaceResult(GetTrafficControllerInterfaceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTrafficControllerInterfaceResult(
            associations=self.associations,
            configuration_endpoints=self.configuration_endpoints,
            frontends=self.frontends,
            id=self.id,
            location=self.location,
            name=self.name,
            provisioning_state=self.provisioning_state,
            system_data=self.system_data,
            tags=self.tags,
            type=self.type)


def get_traffic_controller_interface(resource_group_name: Optional[str] = None,
                                     traffic_controller_name: Optional[str] = None,
                                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTrafficControllerInterfaceResult:
    """
    Get a TrafficController
    API Version: 2022-10-01-preview.


    :param str resource_group_name: The name of the resource group. The name is case insensitive.
    :param str traffic_controller_name: traffic controller name for path
    """
    __args__ = dict()
    __args__['resourceGroupName'] = resource_group_name
    __args__['trafficControllerName'] = traffic_controller_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure-native:servicenetworking:getTrafficControllerInterface', __args__, opts=opts, typ=GetTrafficControllerInterfaceResult).value

    return AwaitableGetTrafficControllerInterfaceResult(
        associations=__ret__.associations,
        configuration_endpoints=__ret__.configuration_endpoints,
        frontends=__ret__.frontends,
        id=__ret__.id,
        location=__ret__.location,
        name=__ret__.name,
        provisioning_state=__ret__.provisioning_state,
        system_data=__ret__.system_data,
        tags=__ret__.tags,
        type=__ret__.type)


@_utilities.lift_output_func(get_traffic_controller_interface)
def get_traffic_controller_interface_output(resource_group_name: Optional[pulumi.Input[str]] = None,
                                            traffic_controller_name: Optional[pulumi.Input[str]] = None,
                                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetTrafficControllerInterfaceResult]:
    """
    Get a TrafficController
    API Version: 2022-10-01-preview.


    :param str resource_group_name: The name of the resource group. The name is case insensitive.
    :param str traffic_controller_name: traffic controller name for path
    """
    ...
