# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'AlertDetailsOverrideArgs',
    'AlertsDataTypeOfDataConnectorArgs',
    'AutomationRuleModifyPropertiesActionArgs',
    'AutomationRulePropertyArrayChangedValuesConditionArgs',
    'AutomationRulePropertyValuesChangedConditionArgs',
    'AutomationRulePropertyValuesConditionArgs',
    'AutomationRuleRunPlaybookActionArgs',
    'AutomationRuleTriggeringLogicArgs',
    'AwsCloudTrailDataConnectorDataTypesLogsArgs',
    'AwsCloudTrailDataConnectorDataTypesArgs',
    'DataConnectorDataTypeCommonArgs',
    'EntityMappingArgs',
    'EventGroupingSettingsArgs',
    'FieldMappingArgs',
    'GroupingConfigurationArgs',
    'IncidentConfigurationArgs',
    'IncidentInfoArgs',
    'IncidentLabelArgs',
    'IncidentOwnerInfoArgs',
    'IncidentPropertiesActionArgs',
    'MCASDataConnectorDataTypesArgs',
    'OfficeDataConnectorDataTypesExchangeArgs',
    'OfficeDataConnectorDataTypesSharePointArgs',
    'OfficeDataConnectorDataTypesTeamsArgs',
    'OfficeDataConnectorDataTypesArgs',
    'PlaybookActionPropertiesArgs',
    'PropertyArrayChangedConditionPropertiesArgs',
    'PropertyChangedConditionPropertiesArgs',
    'PropertyConditionPropertiesArgs',
    'SecurityMLAnalyticsSettingsDataSourceArgs',
    'TIDataConnectorDataTypesIndicatorsArgs',
    'TIDataConnectorDataTypesArgs',
    'ThreatIntelligenceExternalReferenceArgs',
    'ThreatIntelligenceGranularMarkingModelArgs',
    'ThreatIntelligenceKillChainPhaseArgs',
    'ThreatIntelligenceParsedPatternTypeValueArgs',
    'ThreatIntelligenceParsedPatternArgs',
    'UserInfoArgs',
    'WatchlistUserInfoArgs',
]

@pulumi.input_type
class AlertDetailsOverrideArgs:
    def __init__(__self__, *,
                 alert_description_format: Optional[pulumi.Input[str]] = None,
                 alert_display_name_format: Optional[pulumi.Input[str]] = None,
                 alert_severity_column_name: Optional[pulumi.Input[str]] = None,
                 alert_tactics_column_name: Optional[pulumi.Input[str]] = None):
        """
        Settings for how to dynamically override alert static details
        :param pulumi.Input[str] alert_description_format: the format containing columns name(s) to override the alert description
        :param pulumi.Input[str] alert_display_name_format: the format containing columns name(s) to override the alert name
        :param pulumi.Input[str] alert_severity_column_name: the column name to take the alert severity from
        :param pulumi.Input[str] alert_tactics_column_name: the column name to take the alert tactics from
        """
        if alert_description_format is not None:
            pulumi.set(__self__, "alert_description_format", alert_description_format)
        if alert_display_name_format is not None:
            pulumi.set(__self__, "alert_display_name_format", alert_display_name_format)
        if alert_severity_column_name is not None:
            pulumi.set(__self__, "alert_severity_column_name", alert_severity_column_name)
        if alert_tactics_column_name is not None:
            pulumi.set(__self__, "alert_tactics_column_name", alert_tactics_column_name)

    @property
    @pulumi.getter(name="alertDescriptionFormat")
    def alert_description_format(self) -> Optional[pulumi.Input[str]]:
        """
        the format containing columns name(s) to override the alert description
        """
        return pulumi.get(self, "alert_description_format")

    @alert_description_format.setter
    def alert_description_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "alert_description_format", value)

    @property
    @pulumi.getter(name="alertDisplayNameFormat")
    def alert_display_name_format(self) -> Optional[pulumi.Input[str]]:
        """
        the format containing columns name(s) to override the alert name
        """
        return pulumi.get(self, "alert_display_name_format")

    @alert_display_name_format.setter
    def alert_display_name_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "alert_display_name_format", value)

    @property
    @pulumi.getter(name="alertSeverityColumnName")
    def alert_severity_column_name(self) -> Optional[pulumi.Input[str]]:
        """
        the column name to take the alert severity from
        """
        return pulumi.get(self, "alert_severity_column_name")

    @alert_severity_column_name.setter
    def alert_severity_column_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "alert_severity_column_name", value)

    @property
    @pulumi.getter(name="alertTacticsColumnName")
    def alert_tactics_column_name(self) -> Optional[pulumi.Input[str]]:
        """
        the column name to take the alert tactics from
        """
        return pulumi.get(self, "alert_tactics_column_name")

    @alert_tactics_column_name.setter
    def alert_tactics_column_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "alert_tactics_column_name", value)


@pulumi.input_type
class AlertsDataTypeOfDataConnectorArgs:
    def __init__(__self__, *,
                 alerts: Optional[pulumi.Input['DataConnectorDataTypeCommonArgs']] = None):
        """
        Alerts data type for data connectors.
        :param pulumi.Input['DataConnectorDataTypeCommonArgs'] alerts: Alerts data type connection.
        """
        if alerts is not None:
            pulumi.set(__self__, "alerts", alerts)

    @property
    @pulumi.getter
    def alerts(self) -> Optional[pulumi.Input['DataConnectorDataTypeCommonArgs']]:
        """
        Alerts data type connection.
        """
        return pulumi.get(self, "alerts")

    @alerts.setter
    def alerts(self, value: Optional[pulumi.Input['DataConnectorDataTypeCommonArgs']]):
        pulumi.set(self, "alerts", value)


@pulumi.input_type
class AutomationRuleModifyPropertiesActionArgs:
    def __init__(__self__, *,
                 action_type: pulumi.Input[str],
                 order: pulumi.Input[int],
                 action_configuration: Optional[pulumi.Input['IncidentPropertiesActionArgs']] = None):
        """
        Describes an automation rule action to modify an object's properties
        :param pulumi.Input[str] action_type: The type of the automation rule action.
               Expected value is 'ModifyProperties'.
        """
        pulumi.set(__self__, "action_type", 'ModifyProperties')
        pulumi.set(__self__, "order", order)
        if action_configuration is not None:
            pulumi.set(__self__, "action_configuration", action_configuration)

    @property
    @pulumi.getter(name="actionType")
    def action_type(self) -> pulumi.Input[str]:
        """
        The type of the automation rule action.
        Expected value is 'ModifyProperties'.
        """
        return pulumi.get(self, "action_type")

    @action_type.setter
    def action_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "action_type", value)

    @property
    @pulumi.getter
    def order(self) -> pulumi.Input[int]:
        return pulumi.get(self, "order")

    @order.setter
    def order(self, value: pulumi.Input[int]):
        pulumi.set(self, "order", value)

    @property
    @pulumi.getter(name="actionConfiguration")
    def action_configuration(self) -> Optional[pulumi.Input['IncidentPropertiesActionArgs']]:
        return pulumi.get(self, "action_configuration")

    @action_configuration.setter
    def action_configuration(self, value: Optional[pulumi.Input['IncidentPropertiesActionArgs']]):
        pulumi.set(self, "action_configuration", value)


@pulumi.input_type
class AutomationRulePropertyArrayChangedValuesConditionArgs:
    def __init__(__self__, *,
                 array_type: Optional[pulumi.Input[Union[str, 'AutomationRulePropertyArrayChangedConditionSupportedArrayType']]] = None,
                 change_type: Optional[pulumi.Input[Union[str, 'AutomationRulePropertyArrayChangedConditionSupportedChangeType']]] = None):
        if array_type is not None:
            pulumi.set(__self__, "array_type", array_type)
        if change_type is not None:
            pulumi.set(__self__, "change_type", change_type)

    @property
    @pulumi.getter(name="arrayType")
    def array_type(self) -> Optional[pulumi.Input[Union[str, 'AutomationRulePropertyArrayChangedConditionSupportedArrayType']]]:
        return pulumi.get(self, "array_type")

    @array_type.setter
    def array_type(self, value: Optional[pulumi.Input[Union[str, 'AutomationRulePropertyArrayChangedConditionSupportedArrayType']]]):
        pulumi.set(self, "array_type", value)

    @property
    @pulumi.getter(name="changeType")
    def change_type(self) -> Optional[pulumi.Input[Union[str, 'AutomationRulePropertyArrayChangedConditionSupportedChangeType']]]:
        return pulumi.get(self, "change_type")

    @change_type.setter
    def change_type(self, value: Optional[pulumi.Input[Union[str, 'AutomationRulePropertyArrayChangedConditionSupportedChangeType']]]):
        pulumi.set(self, "change_type", value)


@pulumi.input_type
class AutomationRulePropertyValuesChangedConditionArgs:
    def __init__(__self__, *,
                 change_type: Optional[pulumi.Input[Union[str, 'AutomationRulePropertyChangedConditionSupportedChangedType']]] = None,
                 operator: Optional[pulumi.Input[Union[str, 'AutomationRulePropertyConditionSupportedOperator']]] = None,
                 property_name: Optional[pulumi.Input[Union[str, 'AutomationRulePropertyChangedConditionSupportedPropertyType']]] = None,
                 property_values: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        if change_type is not None:
            pulumi.set(__self__, "change_type", change_type)
        if operator is not None:
            pulumi.set(__self__, "operator", operator)
        if property_name is not None:
            pulumi.set(__self__, "property_name", property_name)
        if property_values is not None:
            pulumi.set(__self__, "property_values", property_values)

    @property
    @pulumi.getter(name="changeType")
    def change_type(self) -> Optional[pulumi.Input[Union[str, 'AutomationRulePropertyChangedConditionSupportedChangedType']]]:
        return pulumi.get(self, "change_type")

    @change_type.setter
    def change_type(self, value: Optional[pulumi.Input[Union[str, 'AutomationRulePropertyChangedConditionSupportedChangedType']]]):
        pulumi.set(self, "change_type", value)

    @property
    @pulumi.getter
    def operator(self) -> Optional[pulumi.Input[Union[str, 'AutomationRulePropertyConditionSupportedOperator']]]:
        return pulumi.get(self, "operator")

    @operator.setter
    def operator(self, value: Optional[pulumi.Input[Union[str, 'AutomationRulePropertyConditionSupportedOperator']]]):
        pulumi.set(self, "operator", value)

    @property
    @pulumi.getter(name="propertyName")
    def property_name(self) -> Optional[pulumi.Input[Union[str, 'AutomationRulePropertyChangedConditionSupportedPropertyType']]]:
        return pulumi.get(self, "property_name")

    @property_name.setter
    def property_name(self, value: Optional[pulumi.Input[Union[str, 'AutomationRulePropertyChangedConditionSupportedPropertyType']]]):
        pulumi.set(self, "property_name", value)

    @property
    @pulumi.getter(name="propertyValues")
    def property_values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "property_values")

    @property_values.setter
    def property_values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "property_values", value)


@pulumi.input_type
class AutomationRulePropertyValuesConditionArgs:
    def __init__(__self__, *,
                 operator: Optional[pulumi.Input[Union[str, 'AutomationRulePropertyConditionSupportedOperator']]] = None,
                 property_name: Optional[pulumi.Input[Union[str, 'AutomationRulePropertyConditionSupportedProperty']]] = None,
                 property_values: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[Union[str, 'AutomationRulePropertyConditionSupportedProperty']] property_name: The property to evaluate in an automation rule property condition.
        """
        if operator is not None:
            pulumi.set(__self__, "operator", operator)
        if property_name is not None:
            pulumi.set(__self__, "property_name", property_name)
        if property_values is not None:
            pulumi.set(__self__, "property_values", property_values)

    @property
    @pulumi.getter
    def operator(self) -> Optional[pulumi.Input[Union[str, 'AutomationRulePropertyConditionSupportedOperator']]]:
        return pulumi.get(self, "operator")

    @operator.setter
    def operator(self, value: Optional[pulumi.Input[Union[str, 'AutomationRulePropertyConditionSupportedOperator']]]):
        pulumi.set(self, "operator", value)

    @property
    @pulumi.getter(name="propertyName")
    def property_name(self) -> Optional[pulumi.Input[Union[str, 'AutomationRulePropertyConditionSupportedProperty']]]:
        """
        The property to evaluate in an automation rule property condition.
        """
        return pulumi.get(self, "property_name")

    @property_name.setter
    def property_name(self, value: Optional[pulumi.Input[Union[str, 'AutomationRulePropertyConditionSupportedProperty']]]):
        pulumi.set(self, "property_name", value)

    @property
    @pulumi.getter(name="propertyValues")
    def property_values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "property_values")

    @property_values.setter
    def property_values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "property_values", value)


@pulumi.input_type
class AutomationRuleRunPlaybookActionArgs:
    def __init__(__self__, *,
                 action_type: pulumi.Input[str],
                 order: pulumi.Input[int],
                 action_configuration: Optional[pulumi.Input['PlaybookActionPropertiesArgs']] = None):
        """
        Describes an automation rule action to run a playbook
        :param pulumi.Input[str] action_type: The type of the automation rule action.
               Expected value is 'RunPlaybook'.
        """
        pulumi.set(__self__, "action_type", 'RunPlaybook')
        pulumi.set(__self__, "order", order)
        if action_configuration is not None:
            pulumi.set(__self__, "action_configuration", action_configuration)

    @property
    @pulumi.getter(name="actionType")
    def action_type(self) -> pulumi.Input[str]:
        """
        The type of the automation rule action.
        Expected value is 'RunPlaybook'.
        """
        return pulumi.get(self, "action_type")

    @action_type.setter
    def action_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "action_type", value)

    @property
    @pulumi.getter
    def order(self) -> pulumi.Input[int]:
        return pulumi.get(self, "order")

    @order.setter
    def order(self, value: pulumi.Input[int]):
        pulumi.set(self, "order", value)

    @property
    @pulumi.getter(name="actionConfiguration")
    def action_configuration(self) -> Optional[pulumi.Input['PlaybookActionPropertiesArgs']]:
        return pulumi.get(self, "action_configuration")

    @action_configuration.setter
    def action_configuration(self, value: Optional[pulumi.Input['PlaybookActionPropertiesArgs']]):
        pulumi.set(self, "action_configuration", value)


@pulumi.input_type
class AutomationRuleTriggeringLogicArgs:
    def __init__(__self__, *,
                 is_enabled: pulumi.Input[bool],
                 triggers_on: pulumi.Input[Union[str, 'TriggersOn']],
                 triggers_when: pulumi.Input[Union[str, 'TriggersWhen']],
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PropertyArrayChangedConditionPropertiesArgs', 'PropertyChangedConditionPropertiesArgs', 'PropertyConditionPropertiesArgs']]]]] = None,
                 expiration_time_utc: Optional[pulumi.Input[str]] = None):
        """
        Describes automation rule triggering logic.
        :param pulumi.Input[bool] is_enabled: Determines whether the automation rule is enabled or disabled.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PropertyArrayChangedConditionPropertiesArgs', 'PropertyChangedConditionPropertiesArgs', 'PropertyConditionPropertiesArgs']]]] conditions: The conditions to evaluate to determine if the automation rule should be triggered on a given object.
        :param pulumi.Input[str] expiration_time_utc: Determines when the automation rule should automatically expire and be disabled.
        """
        pulumi.set(__self__, "is_enabled", is_enabled)
        pulumi.set(__self__, "triggers_on", triggers_on)
        pulumi.set(__self__, "triggers_when", triggers_when)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if expiration_time_utc is not None:
            pulumi.set(__self__, "expiration_time_utc", expiration_time_utc)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> pulumi.Input[bool]:
        """
        Determines whether the automation rule is enabled or disabled.
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "is_enabled", value)

    @property
    @pulumi.getter(name="triggersOn")
    def triggers_on(self) -> pulumi.Input[Union[str, 'TriggersOn']]:
        return pulumi.get(self, "triggers_on")

    @triggers_on.setter
    def triggers_on(self, value: pulumi.Input[Union[str, 'TriggersOn']]):
        pulumi.set(self, "triggers_on", value)

    @property
    @pulumi.getter(name="triggersWhen")
    def triggers_when(self) -> pulumi.Input[Union[str, 'TriggersWhen']]:
        return pulumi.get(self, "triggers_when")

    @triggers_when.setter
    def triggers_when(self, value: pulumi.Input[Union[str, 'TriggersWhen']]):
        pulumi.set(self, "triggers_when", value)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union['PropertyArrayChangedConditionPropertiesArgs', 'PropertyChangedConditionPropertiesArgs', 'PropertyConditionPropertiesArgs']]]]]:
        """
        The conditions to evaluate to determine if the automation rule should be triggered on a given object.
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PropertyArrayChangedConditionPropertiesArgs', 'PropertyChangedConditionPropertiesArgs', 'PropertyConditionPropertiesArgs']]]]]):
        pulumi.set(self, "conditions", value)

    @property
    @pulumi.getter(name="expirationTimeUtc")
    def expiration_time_utc(self) -> Optional[pulumi.Input[str]]:
        """
        Determines when the automation rule should automatically expire and be disabled.
        """
        return pulumi.get(self, "expiration_time_utc")

    @expiration_time_utc.setter
    def expiration_time_utc(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expiration_time_utc", value)


@pulumi.input_type
class AwsCloudTrailDataConnectorDataTypesLogsArgs:
    def __init__(__self__, *,
                 state: Optional[pulumi.Input[Union[str, 'DataTypeState']]] = None):
        """
        Logs data type.
        :param pulumi.Input[Union[str, 'DataTypeState']] state: Describe whether this data type connection is enabled or not.
        """
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[Union[str, 'DataTypeState']]]:
        """
        Describe whether this data type connection is enabled or not.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[Union[str, 'DataTypeState']]]):
        pulumi.set(self, "state", value)


@pulumi.input_type
class AwsCloudTrailDataConnectorDataTypesArgs:
    def __init__(__self__, *,
                 logs: Optional[pulumi.Input['AwsCloudTrailDataConnectorDataTypesLogsArgs']] = None):
        """
        The available data types for Amazon Web Services CloudTrail data connector.
        :param pulumi.Input['AwsCloudTrailDataConnectorDataTypesLogsArgs'] logs: Logs data type.
        """
        if logs is not None:
            pulumi.set(__self__, "logs", logs)

    @property
    @pulumi.getter
    def logs(self) -> Optional[pulumi.Input['AwsCloudTrailDataConnectorDataTypesLogsArgs']]:
        """
        Logs data type.
        """
        return pulumi.get(self, "logs")

    @logs.setter
    def logs(self, value: Optional[pulumi.Input['AwsCloudTrailDataConnectorDataTypesLogsArgs']]):
        pulumi.set(self, "logs", value)


@pulumi.input_type
class DataConnectorDataTypeCommonArgs:
    def __init__(__self__, *,
                 state: Optional[pulumi.Input[Union[str, 'DataTypeState']]] = None):
        """
        Common field for data type in data connectors.
        :param pulumi.Input[Union[str, 'DataTypeState']] state: Describe whether this data type connection is enabled or not.
        """
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[Union[str, 'DataTypeState']]]:
        """
        Describe whether this data type connection is enabled or not.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[Union[str, 'DataTypeState']]]):
        pulumi.set(self, "state", value)


@pulumi.input_type
class EntityMappingArgs:
    def __init__(__self__, *,
                 entity_type: Optional[pulumi.Input[Union[str, 'EntityMappingType']]] = None,
                 field_mappings: Optional[pulumi.Input[Sequence[pulumi.Input['FieldMappingArgs']]]] = None):
        """
        Single entity mapping for the alert rule
        :param pulumi.Input[Union[str, 'EntityMappingType']] entity_type: The V3 type of the mapped entity
        :param pulumi.Input[Sequence[pulumi.Input['FieldMappingArgs']]] field_mappings: array of field mappings for the given entity mapping
        """
        if entity_type is not None:
            pulumi.set(__self__, "entity_type", entity_type)
        if field_mappings is not None:
            pulumi.set(__self__, "field_mappings", field_mappings)

    @property
    @pulumi.getter(name="entityType")
    def entity_type(self) -> Optional[pulumi.Input[Union[str, 'EntityMappingType']]]:
        """
        The V3 type of the mapped entity
        """
        return pulumi.get(self, "entity_type")

    @entity_type.setter
    def entity_type(self, value: Optional[pulumi.Input[Union[str, 'EntityMappingType']]]):
        pulumi.set(self, "entity_type", value)

    @property
    @pulumi.getter(name="fieldMappings")
    def field_mappings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FieldMappingArgs']]]]:
        """
        array of field mappings for the given entity mapping
        """
        return pulumi.get(self, "field_mappings")

    @field_mappings.setter
    def field_mappings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FieldMappingArgs']]]]):
        pulumi.set(self, "field_mappings", value)


@pulumi.input_type
class EventGroupingSettingsArgs:
    def __init__(__self__, *,
                 aggregation_kind: Optional[pulumi.Input[Union[str, 'EventGroupingAggregationKind']]] = None):
        """
        Event grouping settings property bag.
        :param pulumi.Input[Union[str, 'EventGroupingAggregationKind']] aggregation_kind: The event grouping aggregation kinds
        """
        if aggregation_kind is not None:
            pulumi.set(__self__, "aggregation_kind", aggregation_kind)

    @property
    @pulumi.getter(name="aggregationKind")
    def aggregation_kind(self) -> Optional[pulumi.Input[Union[str, 'EventGroupingAggregationKind']]]:
        """
        The event grouping aggregation kinds
        """
        return pulumi.get(self, "aggregation_kind")

    @aggregation_kind.setter
    def aggregation_kind(self, value: Optional[pulumi.Input[Union[str, 'EventGroupingAggregationKind']]]):
        pulumi.set(self, "aggregation_kind", value)


@pulumi.input_type
class FieldMappingArgs:
    def __init__(__self__, *,
                 column_name: Optional[pulumi.Input[str]] = None,
                 identifier: Optional[pulumi.Input[str]] = None):
        """
        A single field mapping of the mapped entity
        :param pulumi.Input[str] column_name: the column name to be mapped to the identifier
        :param pulumi.Input[str] identifier: the V3 identifier of the entity
        """
        if column_name is not None:
            pulumi.set(__self__, "column_name", column_name)
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)

    @property
    @pulumi.getter(name="columnName")
    def column_name(self) -> Optional[pulumi.Input[str]]:
        """
        the column name to be mapped to the identifier
        """
        return pulumi.get(self, "column_name")

    @column_name.setter
    def column_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "column_name", value)

    @property
    @pulumi.getter
    def identifier(self) -> Optional[pulumi.Input[str]]:
        """
        the V3 identifier of the entity
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "identifier", value)


@pulumi.input_type
class GroupingConfigurationArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[bool],
                 lookback_duration: pulumi.Input[str],
                 matching_method: pulumi.Input[Union[str, 'MatchingMethod']],
                 reopen_closed_incident: pulumi.Input[bool],
                 group_by_alert_details: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'AlertDetail']]]]] = None,
                 group_by_custom_details: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 group_by_entities: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'EntityMappingType']]]]] = None):
        """
        Grouping configuration property bag.
        :param pulumi.Input[bool] enabled: Grouping enabled
        :param pulumi.Input[str] lookback_duration: Limit the group to alerts created within the lookback duration (in ISO 8601 duration format)
        :param pulumi.Input[Union[str, 'MatchingMethod']] matching_method: Grouping matching method. When method is Selected at least one of groupByEntities, groupByAlertDetails, groupByCustomDetails must be provided and not empty.
        :param pulumi.Input[bool] reopen_closed_incident: Re-open closed matching incidents
        :param pulumi.Input[Sequence[pulumi.Input[Union[str, 'AlertDetail']]]] group_by_alert_details: A list of alert details to group by (when matchingMethod is Selected)
        :param pulumi.Input[Sequence[pulumi.Input[str]]] group_by_custom_details: A list of custom details keys to group by (when matchingMethod is Selected). Only keys defined in the current alert rule may be used.
        :param pulumi.Input[Sequence[pulumi.Input[Union[str, 'EntityMappingType']]]] group_by_entities: A list of entity types to group by (when matchingMethod is Selected). Only entities defined in the current alert rule may be used.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "lookback_duration", lookback_duration)
        pulumi.set(__self__, "matching_method", matching_method)
        pulumi.set(__self__, "reopen_closed_incident", reopen_closed_incident)
        if group_by_alert_details is not None:
            pulumi.set(__self__, "group_by_alert_details", group_by_alert_details)
        if group_by_custom_details is not None:
            pulumi.set(__self__, "group_by_custom_details", group_by_custom_details)
        if group_by_entities is not None:
            pulumi.set(__self__, "group_by_entities", group_by_entities)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[bool]:
        """
        Grouping enabled
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="lookbackDuration")
    def lookback_duration(self) -> pulumi.Input[str]:
        """
        Limit the group to alerts created within the lookback duration (in ISO 8601 duration format)
        """
        return pulumi.get(self, "lookback_duration")

    @lookback_duration.setter
    def lookback_duration(self, value: pulumi.Input[str]):
        pulumi.set(self, "lookback_duration", value)

    @property
    @pulumi.getter(name="matchingMethod")
    def matching_method(self) -> pulumi.Input[Union[str, 'MatchingMethod']]:
        """
        Grouping matching method. When method is Selected at least one of groupByEntities, groupByAlertDetails, groupByCustomDetails must be provided and not empty.
        """
        return pulumi.get(self, "matching_method")

    @matching_method.setter
    def matching_method(self, value: pulumi.Input[Union[str, 'MatchingMethod']]):
        pulumi.set(self, "matching_method", value)

    @property
    @pulumi.getter(name="reopenClosedIncident")
    def reopen_closed_incident(self) -> pulumi.Input[bool]:
        """
        Re-open closed matching incidents
        """
        return pulumi.get(self, "reopen_closed_incident")

    @reopen_closed_incident.setter
    def reopen_closed_incident(self, value: pulumi.Input[bool]):
        pulumi.set(self, "reopen_closed_incident", value)

    @property
    @pulumi.getter(name="groupByAlertDetails")
    def group_by_alert_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'AlertDetail']]]]]:
        """
        A list of alert details to group by (when matchingMethod is Selected)
        """
        return pulumi.get(self, "group_by_alert_details")

    @group_by_alert_details.setter
    def group_by_alert_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'AlertDetail']]]]]):
        pulumi.set(self, "group_by_alert_details", value)

    @property
    @pulumi.getter(name="groupByCustomDetails")
    def group_by_custom_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of custom details keys to group by (when matchingMethod is Selected). Only keys defined in the current alert rule may be used.
        """
        return pulumi.get(self, "group_by_custom_details")

    @group_by_custom_details.setter
    def group_by_custom_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "group_by_custom_details", value)

    @property
    @pulumi.getter(name="groupByEntities")
    def group_by_entities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'EntityMappingType']]]]]:
        """
        A list of entity types to group by (when matchingMethod is Selected). Only entities defined in the current alert rule may be used.
        """
        return pulumi.get(self, "group_by_entities")

    @group_by_entities.setter
    def group_by_entities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'EntityMappingType']]]]]):
        pulumi.set(self, "group_by_entities", value)


@pulumi.input_type
class IncidentConfigurationArgs:
    def __init__(__self__, *,
                 create_incident: pulumi.Input[bool],
                 grouping_configuration: Optional[pulumi.Input['GroupingConfigurationArgs']] = None):
        """
        Incident Configuration property bag.
        :param pulumi.Input[bool] create_incident: Create incidents from alerts triggered by this analytics rule
        :param pulumi.Input['GroupingConfigurationArgs'] grouping_configuration: Set how the alerts that are triggered by this analytics rule, are grouped into incidents
        """
        pulumi.set(__self__, "create_incident", create_incident)
        if grouping_configuration is not None:
            pulumi.set(__self__, "grouping_configuration", grouping_configuration)

    @property
    @pulumi.getter(name="createIncident")
    def create_incident(self) -> pulumi.Input[bool]:
        """
        Create incidents from alerts triggered by this analytics rule
        """
        return pulumi.get(self, "create_incident")

    @create_incident.setter
    def create_incident(self, value: pulumi.Input[bool]):
        pulumi.set(self, "create_incident", value)

    @property
    @pulumi.getter(name="groupingConfiguration")
    def grouping_configuration(self) -> Optional[pulumi.Input['GroupingConfigurationArgs']]:
        """
        Set how the alerts that are triggered by this analytics rule, are grouped into incidents
        """
        return pulumi.get(self, "grouping_configuration")

    @grouping_configuration.setter
    def grouping_configuration(self, value: Optional[pulumi.Input['GroupingConfigurationArgs']]):
        pulumi.set(self, "grouping_configuration", value)


@pulumi.input_type
class IncidentInfoArgs:
    def __init__(__self__, *,
                 incident_id: Optional[pulumi.Input[str]] = None,
                 relation_name: Optional[pulumi.Input[str]] = None,
                 severity: Optional[pulumi.Input[Union[str, 'IncidentSeverity']]] = None,
                 title: Optional[pulumi.Input[str]] = None):
        """
        Describes related incident information for the bookmark
        :param pulumi.Input[str] incident_id: Incident Id
        :param pulumi.Input[str] relation_name: Relation Name
        :param pulumi.Input[Union[str, 'IncidentSeverity']] severity: The severity of the incident
        :param pulumi.Input[str] title: The title of the incident
        """
        if incident_id is not None:
            pulumi.set(__self__, "incident_id", incident_id)
        if relation_name is not None:
            pulumi.set(__self__, "relation_name", relation_name)
        if severity is not None:
            pulumi.set(__self__, "severity", severity)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter(name="incidentId")
    def incident_id(self) -> Optional[pulumi.Input[str]]:
        """
        Incident Id
        """
        return pulumi.get(self, "incident_id")

    @incident_id.setter
    def incident_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "incident_id", value)

    @property
    @pulumi.getter(name="relationName")
    def relation_name(self) -> Optional[pulumi.Input[str]]:
        """
        Relation Name
        """
        return pulumi.get(self, "relation_name")

    @relation_name.setter
    def relation_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "relation_name", value)

    @property
    @pulumi.getter
    def severity(self) -> Optional[pulumi.Input[Union[str, 'IncidentSeverity']]]:
        """
        The severity of the incident
        """
        return pulumi.get(self, "severity")

    @severity.setter
    def severity(self, value: Optional[pulumi.Input[Union[str, 'IncidentSeverity']]]):
        pulumi.set(self, "severity", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[str]]:
        """
        The title of the incident
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "title", value)


@pulumi.input_type
class IncidentLabelArgs:
    def __init__(__self__, *,
                 label_name: pulumi.Input[str]):
        """
        Represents an incident label
        :param pulumi.Input[str] label_name: The name of the label
        """
        pulumi.set(__self__, "label_name", label_name)

    @property
    @pulumi.getter(name="labelName")
    def label_name(self) -> pulumi.Input[str]:
        """
        The name of the label
        """
        return pulumi.get(self, "label_name")

    @label_name.setter
    def label_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "label_name", value)


@pulumi.input_type
class IncidentOwnerInfoArgs:
    def __init__(__self__, *,
                 assigned_to: Optional[pulumi.Input[str]] = None,
                 email: Optional[pulumi.Input[str]] = None,
                 object_id: Optional[pulumi.Input[str]] = None,
                 owner_type: Optional[pulumi.Input[Union[str, 'OwnerType']]] = None,
                 user_principal_name: Optional[pulumi.Input[str]] = None):
        """
        Information on the user an incident is assigned to
        :param pulumi.Input[str] assigned_to: The name of the user the incident is assigned to.
        :param pulumi.Input[str] email: The email of the user the incident is assigned to.
        :param pulumi.Input[str] object_id: The object id of the user the incident is assigned to.
        :param pulumi.Input[Union[str, 'OwnerType']] owner_type: The type of the owner the incident is assigned to.
        :param pulumi.Input[str] user_principal_name: The user principal name of the user the incident is assigned to.
        """
        if assigned_to is not None:
            pulumi.set(__self__, "assigned_to", assigned_to)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if object_id is not None:
            pulumi.set(__self__, "object_id", object_id)
        if owner_type is not None:
            pulumi.set(__self__, "owner_type", owner_type)
        if user_principal_name is not None:
            pulumi.set(__self__, "user_principal_name", user_principal_name)

    @property
    @pulumi.getter(name="assignedTo")
    def assigned_to(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the user the incident is assigned to.
        """
        return pulumi.get(self, "assigned_to")

    @assigned_to.setter
    def assigned_to(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "assigned_to", value)

    @property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[str]]:
        """
        The email of the user the incident is assigned to.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter(name="objectId")
    def object_id(self) -> Optional[pulumi.Input[str]]:
        """
        The object id of the user the incident is assigned to.
        """
        return pulumi.get(self, "object_id")

    @object_id.setter
    def object_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "object_id", value)

    @property
    @pulumi.getter(name="ownerType")
    def owner_type(self) -> Optional[pulumi.Input[Union[str, 'OwnerType']]]:
        """
        The type of the owner the incident is assigned to.
        """
        return pulumi.get(self, "owner_type")

    @owner_type.setter
    def owner_type(self, value: Optional[pulumi.Input[Union[str, 'OwnerType']]]):
        pulumi.set(self, "owner_type", value)

    @property
    @pulumi.getter(name="userPrincipalName")
    def user_principal_name(self) -> Optional[pulumi.Input[str]]:
        """
        The user principal name of the user the incident is assigned to.
        """
        return pulumi.get(self, "user_principal_name")

    @user_principal_name.setter
    def user_principal_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_principal_name", value)


@pulumi.input_type
class IncidentPropertiesActionArgs:
    def __init__(__self__, *,
                 classification: Optional[pulumi.Input[Union[str, 'IncidentClassification']]] = None,
                 classification_comment: Optional[pulumi.Input[str]] = None,
                 classification_reason: Optional[pulumi.Input[Union[str, 'IncidentClassificationReason']]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input['IncidentLabelArgs']]]] = None,
                 owner: Optional[pulumi.Input['IncidentOwnerInfoArgs']] = None,
                 severity: Optional[pulumi.Input[Union[str, 'IncidentSeverity']]] = None,
                 status: Optional[pulumi.Input[Union[str, 'IncidentStatus']]] = None):
        """
        :param pulumi.Input[Union[str, 'IncidentClassification']] classification: The reason the incident was closed
        :param pulumi.Input[str] classification_comment: Describes the reason the incident was closed.
        :param pulumi.Input[Union[str, 'IncidentClassificationReason']] classification_reason: The classification reason the incident was closed with
        :param pulumi.Input[Sequence[pulumi.Input['IncidentLabelArgs']]] labels: List of labels to add to the incident.
        :param pulumi.Input['IncidentOwnerInfoArgs'] owner: Information on the user an incident is assigned to
        :param pulumi.Input[Union[str, 'IncidentSeverity']] severity: The severity of the incident
        :param pulumi.Input[Union[str, 'IncidentStatus']] status: The status of the incident
        """
        if classification is not None:
            pulumi.set(__self__, "classification", classification)
        if classification_comment is not None:
            pulumi.set(__self__, "classification_comment", classification_comment)
        if classification_reason is not None:
            pulumi.set(__self__, "classification_reason", classification_reason)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if owner is not None:
            pulumi.set(__self__, "owner", owner)
        if severity is not None:
            pulumi.set(__self__, "severity", severity)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def classification(self) -> Optional[pulumi.Input[Union[str, 'IncidentClassification']]]:
        """
        The reason the incident was closed
        """
        return pulumi.get(self, "classification")

    @classification.setter
    def classification(self, value: Optional[pulumi.Input[Union[str, 'IncidentClassification']]]):
        pulumi.set(self, "classification", value)

    @property
    @pulumi.getter(name="classificationComment")
    def classification_comment(self) -> Optional[pulumi.Input[str]]:
        """
        Describes the reason the incident was closed.
        """
        return pulumi.get(self, "classification_comment")

    @classification_comment.setter
    def classification_comment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "classification_comment", value)

    @property
    @pulumi.getter(name="classificationReason")
    def classification_reason(self) -> Optional[pulumi.Input[Union[str, 'IncidentClassificationReason']]]:
        """
        The classification reason the incident was closed with
        """
        return pulumi.get(self, "classification_reason")

    @classification_reason.setter
    def classification_reason(self, value: Optional[pulumi.Input[Union[str, 'IncidentClassificationReason']]]):
        pulumi.set(self, "classification_reason", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IncidentLabelArgs']]]]:
        """
        List of labels to add to the incident.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IncidentLabelArgs']]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def owner(self) -> Optional[pulumi.Input['IncidentOwnerInfoArgs']]:
        """
        Information on the user an incident is assigned to
        """
        return pulumi.get(self, "owner")

    @owner.setter
    def owner(self, value: Optional[pulumi.Input['IncidentOwnerInfoArgs']]):
        pulumi.set(self, "owner", value)

    @property
    @pulumi.getter
    def severity(self) -> Optional[pulumi.Input[Union[str, 'IncidentSeverity']]]:
        """
        The severity of the incident
        """
        return pulumi.get(self, "severity")

    @severity.setter
    def severity(self, value: Optional[pulumi.Input[Union[str, 'IncidentSeverity']]]):
        pulumi.set(self, "severity", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[Union[str, 'IncidentStatus']]]:
        """
        The status of the incident
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[Union[str, 'IncidentStatus']]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class MCASDataConnectorDataTypesArgs:
    def __init__(__self__, *,
                 alerts: Optional[pulumi.Input['DataConnectorDataTypeCommonArgs']] = None,
                 discovery_logs: Optional[pulumi.Input['DataConnectorDataTypeCommonArgs']] = None):
        """
        The available data types for MCAS (Microsoft Cloud App Security) data connector.
        :param pulumi.Input['DataConnectorDataTypeCommonArgs'] alerts: Alerts data type connection.
        :param pulumi.Input['DataConnectorDataTypeCommonArgs'] discovery_logs: Discovery log data type connection.
        """
        if alerts is not None:
            pulumi.set(__self__, "alerts", alerts)
        if discovery_logs is not None:
            pulumi.set(__self__, "discovery_logs", discovery_logs)

    @property
    @pulumi.getter
    def alerts(self) -> Optional[pulumi.Input['DataConnectorDataTypeCommonArgs']]:
        """
        Alerts data type connection.
        """
        return pulumi.get(self, "alerts")

    @alerts.setter
    def alerts(self, value: Optional[pulumi.Input['DataConnectorDataTypeCommonArgs']]):
        pulumi.set(self, "alerts", value)

    @property
    @pulumi.getter(name="discoveryLogs")
    def discovery_logs(self) -> Optional[pulumi.Input['DataConnectorDataTypeCommonArgs']]:
        """
        Discovery log data type connection.
        """
        return pulumi.get(self, "discovery_logs")

    @discovery_logs.setter
    def discovery_logs(self, value: Optional[pulumi.Input['DataConnectorDataTypeCommonArgs']]):
        pulumi.set(self, "discovery_logs", value)


@pulumi.input_type
class OfficeDataConnectorDataTypesExchangeArgs:
    def __init__(__self__, *,
                 state: Optional[pulumi.Input[Union[str, 'DataTypeState']]] = None):
        """
        Exchange data type connection.
        :param pulumi.Input[Union[str, 'DataTypeState']] state: Describe whether this data type connection is enabled or not.
        """
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[Union[str, 'DataTypeState']]]:
        """
        Describe whether this data type connection is enabled or not.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[Union[str, 'DataTypeState']]]):
        pulumi.set(self, "state", value)


@pulumi.input_type
class OfficeDataConnectorDataTypesSharePointArgs:
    def __init__(__self__, *,
                 state: Optional[pulumi.Input[Union[str, 'DataTypeState']]] = None):
        """
        SharePoint data type connection.
        :param pulumi.Input[Union[str, 'DataTypeState']] state: Describe whether this data type connection is enabled or not.
        """
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[Union[str, 'DataTypeState']]]:
        """
        Describe whether this data type connection is enabled or not.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[Union[str, 'DataTypeState']]]):
        pulumi.set(self, "state", value)


@pulumi.input_type
class OfficeDataConnectorDataTypesTeamsArgs:
    def __init__(__self__, *,
                 state: Optional[pulumi.Input[Union[str, 'DataTypeState']]] = None):
        """
        Teams data type connection.
        :param pulumi.Input[Union[str, 'DataTypeState']] state: Describe whether this data type connection is enabled or not.
        """
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[Union[str, 'DataTypeState']]]:
        """
        Describe whether this data type connection is enabled or not.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[Union[str, 'DataTypeState']]]):
        pulumi.set(self, "state", value)


@pulumi.input_type
class OfficeDataConnectorDataTypesArgs:
    def __init__(__self__, *,
                 exchange: Optional[pulumi.Input['OfficeDataConnectorDataTypesExchangeArgs']] = None,
                 share_point: Optional[pulumi.Input['OfficeDataConnectorDataTypesSharePointArgs']] = None,
                 teams: Optional[pulumi.Input['OfficeDataConnectorDataTypesTeamsArgs']] = None):
        """
        The available data types for office data connector.
        :param pulumi.Input['OfficeDataConnectorDataTypesExchangeArgs'] exchange: Exchange data type connection.
        :param pulumi.Input['OfficeDataConnectorDataTypesSharePointArgs'] share_point: SharePoint data type connection.
        :param pulumi.Input['OfficeDataConnectorDataTypesTeamsArgs'] teams: Teams data type connection.
        """
        if exchange is not None:
            pulumi.set(__self__, "exchange", exchange)
        if share_point is not None:
            pulumi.set(__self__, "share_point", share_point)
        if teams is not None:
            pulumi.set(__self__, "teams", teams)

    @property
    @pulumi.getter
    def exchange(self) -> Optional[pulumi.Input['OfficeDataConnectorDataTypesExchangeArgs']]:
        """
        Exchange data type connection.
        """
        return pulumi.get(self, "exchange")

    @exchange.setter
    def exchange(self, value: Optional[pulumi.Input['OfficeDataConnectorDataTypesExchangeArgs']]):
        pulumi.set(self, "exchange", value)

    @property
    @pulumi.getter(name="sharePoint")
    def share_point(self) -> Optional[pulumi.Input['OfficeDataConnectorDataTypesSharePointArgs']]:
        """
        SharePoint data type connection.
        """
        return pulumi.get(self, "share_point")

    @share_point.setter
    def share_point(self, value: Optional[pulumi.Input['OfficeDataConnectorDataTypesSharePointArgs']]):
        pulumi.set(self, "share_point", value)

    @property
    @pulumi.getter
    def teams(self) -> Optional[pulumi.Input['OfficeDataConnectorDataTypesTeamsArgs']]:
        """
        Teams data type connection.
        """
        return pulumi.get(self, "teams")

    @teams.setter
    def teams(self, value: Optional[pulumi.Input['OfficeDataConnectorDataTypesTeamsArgs']]):
        pulumi.set(self, "teams", value)


@pulumi.input_type
class PlaybookActionPropertiesArgs:
    def __init__(__self__, *,
                 logic_app_resource_id: pulumi.Input[str],
                 tenant_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] logic_app_resource_id: The resource id of the playbook resource.
        :param pulumi.Input[str] tenant_id: The tenant id of the playbook resource.
        """
        pulumi.set(__self__, "logic_app_resource_id", logic_app_resource_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="logicAppResourceId")
    def logic_app_resource_id(self) -> pulumi.Input[str]:
        """
        The resource id of the playbook resource.
        """
        return pulumi.get(self, "logic_app_resource_id")

    @logic_app_resource_id.setter
    def logic_app_resource_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "logic_app_resource_id", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The tenant id of the playbook resource.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)


@pulumi.input_type
class PropertyArrayChangedConditionPropertiesArgs:
    def __init__(__self__, *,
                 condition_type: pulumi.Input[str],
                 condition_properties: Optional[pulumi.Input['AutomationRulePropertyArrayChangedValuesConditionArgs']] = None):
        """
        Describes an automation rule condition that evaluates an array property's value change
        :param pulumi.Input[str] condition_type: 
               Expected value is 'PropertyArrayChanged'.
        """
        pulumi.set(__self__, "condition_type", 'PropertyArrayChanged')
        if condition_properties is not None:
            pulumi.set(__self__, "condition_properties", condition_properties)

    @property
    @pulumi.getter(name="conditionType")
    def condition_type(self) -> pulumi.Input[str]:
        """

        Expected value is 'PropertyArrayChanged'.
        """
        return pulumi.get(self, "condition_type")

    @condition_type.setter
    def condition_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "condition_type", value)

    @property
    @pulumi.getter(name="conditionProperties")
    def condition_properties(self) -> Optional[pulumi.Input['AutomationRulePropertyArrayChangedValuesConditionArgs']]:
        return pulumi.get(self, "condition_properties")

    @condition_properties.setter
    def condition_properties(self, value: Optional[pulumi.Input['AutomationRulePropertyArrayChangedValuesConditionArgs']]):
        pulumi.set(self, "condition_properties", value)


@pulumi.input_type
class PropertyChangedConditionPropertiesArgs:
    def __init__(__self__, *,
                 condition_type: pulumi.Input[str],
                 condition_properties: Optional[pulumi.Input['AutomationRulePropertyValuesChangedConditionArgs']] = None):
        """
        Describes an automation rule condition that evaluates a property's value change
        :param pulumi.Input[str] condition_type: 
               Expected value is 'PropertyChanged'.
        """
        pulumi.set(__self__, "condition_type", 'PropertyChanged')
        if condition_properties is not None:
            pulumi.set(__self__, "condition_properties", condition_properties)

    @property
    @pulumi.getter(name="conditionType")
    def condition_type(self) -> pulumi.Input[str]:
        """

        Expected value is 'PropertyChanged'.
        """
        return pulumi.get(self, "condition_type")

    @condition_type.setter
    def condition_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "condition_type", value)

    @property
    @pulumi.getter(name="conditionProperties")
    def condition_properties(self) -> Optional[pulumi.Input['AutomationRulePropertyValuesChangedConditionArgs']]:
        return pulumi.get(self, "condition_properties")

    @condition_properties.setter
    def condition_properties(self, value: Optional[pulumi.Input['AutomationRulePropertyValuesChangedConditionArgs']]):
        pulumi.set(self, "condition_properties", value)


@pulumi.input_type
class PropertyConditionPropertiesArgs:
    def __init__(__self__, *,
                 condition_type: pulumi.Input[str],
                 condition_properties: Optional[pulumi.Input['AutomationRulePropertyValuesConditionArgs']] = None):
        """
        Describes an automation rule condition that evaluates a property's value
        :param pulumi.Input[str] condition_type: 
               Expected value is 'Property'.
        """
        pulumi.set(__self__, "condition_type", 'Property')
        if condition_properties is not None:
            pulumi.set(__self__, "condition_properties", condition_properties)

    @property
    @pulumi.getter(name="conditionType")
    def condition_type(self) -> pulumi.Input[str]:
        """

        Expected value is 'Property'.
        """
        return pulumi.get(self, "condition_type")

    @condition_type.setter
    def condition_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "condition_type", value)

    @property
    @pulumi.getter(name="conditionProperties")
    def condition_properties(self) -> Optional[pulumi.Input['AutomationRulePropertyValuesConditionArgs']]:
        return pulumi.get(self, "condition_properties")

    @condition_properties.setter
    def condition_properties(self, value: Optional[pulumi.Input['AutomationRulePropertyValuesConditionArgs']]):
        pulumi.set(self, "condition_properties", value)


@pulumi.input_type
class SecurityMLAnalyticsSettingsDataSourceArgs:
    def __init__(__self__, *,
                 connector_id: Optional[pulumi.Input[str]] = None,
                 data_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        security ml analytics settings data sources
        :param pulumi.Input[str] connector_id: The connector id that provides the following data types
        :param pulumi.Input[Sequence[pulumi.Input[str]]] data_types: The data types used by the security ml analytics settings
        """
        if connector_id is not None:
            pulumi.set(__self__, "connector_id", connector_id)
        if data_types is not None:
            pulumi.set(__self__, "data_types", data_types)

    @property
    @pulumi.getter(name="connectorId")
    def connector_id(self) -> Optional[pulumi.Input[str]]:
        """
        The connector id that provides the following data types
        """
        return pulumi.get(self, "connector_id")

    @connector_id.setter
    def connector_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connector_id", value)

    @property
    @pulumi.getter(name="dataTypes")
    def data_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The data types used by the security ml analytics settings
        """
        return pulumi.get(self, "data_types")

    @data_types.setter
    def data_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "data_types", value)


@pulumi.input_type
class TIDataConnectorDataTypesIndicatorsArgs:
    def __init__(__self__, *,
                 state: Optional[pulumi.Input[Union[str, 'DataTypeState']]] = None):
        """
        Data type for indicators connection.
        :param pulumi.Input[Union[str, 'DataTypeState']] state: Describe whether this data type connection is enabled or not.
        """
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[Union[str, 'DataTypeState']]]:
        """
        Describe whether this data type connection is enabled or not.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[Union[str, 'DataTypeState']]]):
        pulumi.set(self, "state", value)


@pulumi.input_type
class TIDataConnectorDataTypesArgs:
    def __init__(__self__, *,
                 indicators: Optional[pulumi.Input['TIDataConnectorDataTypesIndicatorsArgs']] = None):
        """
        The available data types for TI (Threat Intelligence) data connector.
        :param pulumi.Input['TIDataConnectorDataTypesIndicatorsArgs'] indicators: Data type for indicators connection.
        """
        if indicators is not None:
            pulumi.set(__self__, "indicators", indicators)

    @property
    @pulumi.getter
    def indicators(self) -> Optional[pulumi.Input['TIDataConnectorDataTypesIndicatorsArgs']]:
        """
        Data type for indicators connection.
        """
        return pulumi.get(self, "indicators")

    @indicators.setter
    def indicators(self, value: Optional[pulumi.Input['TIDataConnectorDataTypesIndicatorsArgs']]):
        pulumi.set(self, "indicators", value)


@pulumi.input_type
class ThreatIntelligenceExternalReferenceArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 external_id: Optional[pulumi.Input[str]] = None,
                 hashes: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 source_name: Optional[pulumi.Input[str]] = None,
                 url: Optional[pulumi.Input[str]] = None):
        """
        Describes external reference
        :param pulumi.Input[str] description: External reference description
        :param pulumi.Input[str] external_id: External reference ID
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] hashes: External reference hashes
        :param pulumi.Input[str] source_name: External reference source name
        :param pulumi.Input[str] url: External reference URL
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if external_id is not None:
            pulumi.set(__self__, "external_id", external_id)
        if hashes is not None:
            pulumi.set(__self__, "hashes", hashes)
        if source_name is not None:
            pulumi.set(__self__, "source_name", source_name)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        External reference description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> Optional[pulumi.Input[str]]:
        """
        External reference ID
        """
        return pulumi.get(self, "external_id")

    @external_id.setter
    def external_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "external_id", value)

    @property
    @pulumi.getter
    def hashes(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        External reference hashes
        """
        return pulumi.get(self, "hashes")

    @hashes.setter
    def hashes(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "hashes", value)

    @property
    @pulumi.getter(name="sourceName")
    def source_name(self) -> Optional[pulumi.Input[str]]:
        """
        External reference source name
        """
        return pulumi.get(self, "source_name")

    @source_name.setter
    def source_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_name", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        """
        External reference URL
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)


@pulumi.input_type
class ThreatIntelligenceGranularMarkingModelArgs:
    def __init__(__self__, *,
                 language: Optional[pulumi.Input[str]] = None,
                 marking_ref: Optional[pulumi.Input[int]] = None,
                 selectors: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Describes threat granular marking model entity
        :param pulumi.Input[str] language: Language granular marking model
        :param pulumi.Input[int] marking_ref: marking reference granular marking model
        :param pulumi.Input[Sequence[pulumi.Input[str]]] selectors: granular marking model selectors
        """
        if language is not None:
            pulumi.set(__self__, "language", language)
        if marking_ref is not None:
            pulumi.set(__self__, "marking_ref", marking_ref)
        if selectors is not None:
            pulumi.set(__self__, "selectors", selectors)

    @property
    @pulumi.getter
    def language(self) -> Optional[pulumi.Input[str]]:
        """
        Language granular marking model
        """
        return pulumi.get(self, "language")

    @language.setter
    def language(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "language", value)

    @property
    @pulumi.getter(name="markingRef")
    def marking_ref(self) -> Optional[pulumi.Input[int]]:
        """
        marking reference granular marking model
        """
        return pulumi.get(self, "marking_ref")

    @marking_ref.setter
    def marking_ref(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "marking_ref", value)

    @property
    @pulumi.getter
    def selectors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        granular marking model selectors
        """
        return pulumi.get(self, "selectors")

    @selectors.setter
    def selectors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "selectors", value)


@pulumi.input_type
class ThreatIntelligenceKillChainPhaseArgs:
    def __init__(__self__, *,
                 kill_chain_name: Optional[pulumi.Input[str]] = None,
                 phase_name: Optional[pulumi.Input[str]] = None):
        """
        Describes threat kill chain phase entity
        :param pulumi.Input[str] kill_chain_name: Kill chainName name
        :param pulumi.Input[str] phase_name: Phase name
        """
        if kill_chain_name is not None:
            pulumi.set(__self__, "kill_chain_name", kill_chain_name)
        if phase_name is not None:
            pulumi.set(__self__, "phase_name", phase_name)

    @property
    @pulumi.getter(name="killChainName")
    def kill_chain_name(self) -> Optional[pulumi.Input[str]]:
        """
        Kill chainName name
        """
        return pulumi.get(self, "kill_chain_name")

    @kill_chain_name.setter
    def kill_chain_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kill_chain_name", value)

    @property
    @pulumi.getter(name="phaseName")
    def phase_name(self) -> Optional[pulumi.Input[str]]:
        """
        Phase name
        """
        return pulumi.get(self, "phase_name")

    @phase_name.setter
    def phase_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "phase_name", value)


@pulumi.input_type
class ThreatIntelligenceParsedPatternTypeValueArgs:
    def __init__(__self__, *,
                 value: Optional[pulumi.Input[str]] = None,
                 value_type: Optional[pulumi.Input[str]] = None):
        """
        Describes threat kill chain phase entity
        :param pulumi.Input[str] value: Value of parsed pattern
        :param pulumi.Input[str] value_type: Type of the value
        """
        if value is not None:
            pulumi.set(__self__, "value", value)
        if value_type is not None:
            pulumi.set(__self__, "value_type", value_type)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        Value of parsed pattern
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter(name="valueType")
    def value_type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of the value
        """
        return pulumi.get(self, "value_type")

    @value_type.setter
    def value_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value_type", value)


@pulumi.input_type
class ThreatIntelligenceParsedPatternArgs:
    def __init__(__self__, *,
                 pattern_type_key: Optional[pulumi.Input[str]] = None,
                 pattern_type_values: Optional[pulumi.Input[Sequence[pulumi.Input['ThreatIntelligenceParsedPatternTypeValueArgs']]]] = None):
        """
        Describes parsed pattern entity
        :param pulumi.Input[str] pattern_type_key: Pattern type key
        :param pulumi.Input[Sequence[pulumi.Input['ThreatIntelligenceParsedPatternTypeValueArgs']]] pattern_type_values: Pattern type keys
        """
        if pattern_type_key is not None:
            pulumi.set(__self__, "pattern_type_key", pattern_type_key)
        if pattern_type_values is not None:
            pulumi.set(__self__, "pattern_type_values", pattern_type_values)

    @property
    @pulumi.getter(name="patternTypeKey")
    def pattern_type_key(self) -> Optional[pulumi.Input[str]]:
        """
        Pattern type key
        """
        return pulumi.get(self, "pattern_type_key")

    @pattern_type_key.setter
    def pattern_type_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pattern_type_key", value)

    @property
    @pulumi.getter(name="patternTypeValues")
    def pattern_type_values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ThreatIntelligenceParsedPatternTypeValueArgs']]]]:
        """
        Pattern type keys
        """
        return pulumi.get(self, "pattern_type_values")

    @pattern_type_values.setter
    def pattern_type_values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ThreatIntelligenceParsedPatternTypeValueArgs']]]]):
        pulumi.set(self, "pattern_type_values", value)


@pulumi.input_type
class UserInfoArgs:
    def __init__(__self__, *,
                 object_id: Optional[pulumi.Input[str]] = None):
        """
        User information that made some action
        :param pulumi.Input[str] object_id: The object id of the user.
        """
        if object_id is not None:
            pulumi.set(__self__, "object_id", object_id)

    @property
    @pulumi.getter(name="objectId")
    def object_id(self) -> Optional[pulumi.Input[str]]:
        """
        The object id of the user.
        """
        return pulumi.get(self, "object_id")

    @object_id.setter
    def object_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "object_id", value)


@pulumi.input_type
class WatchlistUserInfoArgs:
    def __init__(__self__, *,
                 object_id: Optional[pulumi.Input[str]] = None):
        """
        User information that made some action
        :param pulumi.Input[str] object_id: The object id of the user.
        """
        if object_id is not None:
            pulumi.set(__self__, "object_id", object_id)

    @property
    @pulumi.getter(name="objectId")
    def object_id(self) -> Optional[pulumi.Input[str]]:
        """
        The object id of the user.
        """
        return pulumi.get(self, "object_id")

    @object_id.setter
    def object_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "object_id", value)


