# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities

__all__ = [
    'GetScheduledAlertRuleResult',
    'AwaitableGetScheduledAlertRuleResult',
    'get_scheduled_alert_rule',
    'get_scheduled_alert_rule_output',
]

@pulumi.output_type
class GetScheduledAlertRuleResult:
    """
    Represents scheduled alert rule.
    """
    def __init__(__self__, alert_rule_template_name=None, description=None, display_name=None, enabled=None, etag=None, id=None, kind=None, last_modified_utc=None, name=None, query=None, query_frequency=None, query_period=None, severity=None, suppression_duration=None, suppression_enabled=None, tactics=None, trigger_operator=None, trigger_threshold=None, type=None):
        if alert_rule_template_name and not isinstance(alert_rule_template_name, str):
            raise TypeError("Expected argument 'alert_rule_template_name' to be a str")
        pulumi.set(__self__, "alert_rule_template_name", alert_rule_template_name)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if enabled and not isinstance(enabled, bool):
            raise TypeError("Expected argument 'enabled' to be a bool")
        pulumi.set(__self__, "enabled", enabled)
        if etag and not isinstance(etag, str):
            raise TypeError("Expected argument 'etag' to be a str")
        pulumi.set(__self__, "etag", etag)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if kind and not isinstance(kind, str):
            raise TypeError("Expected argument 'kind' to be a str")
        pulumi.set(__self__, "kind", kind)
        if last_modified_utc and not isinstance(last_modified_utc, str):
            raise TypeError("Expected argument 'last_modified_utc' to be a str")
        pulumi.set(__self__, "last_modified_utc", last_modified_utc)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if query and not isinstance(query, str):
            raise TypeError("Expected argument 'query' to be a str")
        pulumi.set(__self__, "query", query)
        if query_frequency and not isinstance(query_frequency, str):
            raise TypeError("Expected argument 'query_frequency' to be a str")
        pulumi.set(__self__, "query_frequency", query_frequency)
        if query_period and not isinstance(query_period, str):
            raise TypeError("Expected argument 'query_period' to be a str")
        pulumi.set(__self__, "query_period", query_period)
        if severity and not isinstance(severity, str):
            raise TypeError("Expected argument 'severity' to be a str")
        pulumi.set(__self__, "severity", severity)
        if suppression_duration and not isinstance(suppression_duration, str):
            raise TypeError("Expected argument 'suppression_duration' to be a str")
        pulumi.set(__self__, "suppression_duration", suppression_duration)
        if suppression_enabled and not isinstance(suppression_enabled, bool):
            raise TypeError("Expected argument 'suppression_enabled' to be a bool")
        pulumi.set(__self__, "suppression_enabled", suppression_enabled)
        if tactics and not isinstance(tactics, list):
            raise TypeError("Expected argument 'tactics' to be a list")
        pulumi.set(__self__, "tactics", tactics)
        if trigger_operator and not isinstance(trigger_operator, str):
            raise TypeError("Expected argument 'trigger_operator' to be a str")
        pulumi.set(__self__, "trigger_operator", trigger_operator)
        if trigger_threshold and not isinstance(trigger_threshold, int):
            raise TypeError("Expected argument 'trigger_threshold' to be a int")
        pulumi.set(__self__, "trigger_threshold", trigger_threshold)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="alertRuleTemplateName")
    def alert_rule_template_name(self) -> Optional[str]:
        """
        The Name of the alert rule template used to create this rule.
        """
        return pulumi.get(self, "alert_rule_template_name")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of the alert rule.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The display name for alerts created by this alert rule.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Determines whether this alert rule is enabled or disabled.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def etag(self) -> Optional[str]:
        """
        Etag of the azure resource
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Azure resource Id
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        The kind of the alert rule
        Expected value is 'Scheduled'.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="lastModifiedUtc")
    def last_modified_utc(self) -> str:
        """
        The last time that this alert rule has been modified.
        """
        return pulumi.get(self, "last_modified_utc")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Azure resource name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def query(self) -> str:
        """
        The query that creates alerts for this rule.
        """
        return pulumi.get(self, "query")

    @property
    @pulumi.getter(name="queryFrequency")
    def query_frequency(self) -> str:
        """
        The frequency (in ISO 8601 duration format) for this alert rule to run.
        """
        return pulumi.get(self, "query_frequency")

    @property
    @pulumi.getter(name="queryPeriod")
    def query_period(self) -> str:
        """
        The period (in ISO 8601 duration format) that this alert rule looks at.
        """
        return pulumi.get(self, "query_period")

    @property
    @pulumi.getter
    def severity(self) -> str:
        """
        The severity for alerts created by this alert rule.
        """
        return pulumi.get(self, "severity")

    @property
    @pulumi.getter(name="suppressionDuration")
    def suppression_duration(self) -> str:
        """
        The suppression (in ISO 8601 duration format) to wait since last time this alert rule been triggered.
        """
        return pulumi.get(self, "suppression_duration")

    @property
    @pulumi.getter(name="suppressionEnabled")
    def suppression_enabled(self) -> bool:
        """
        Determines whether the suppression for this alert rule is enabled or disabled.
        """
        return pulumi.get(self, "suppression_enabled")

    @property
    @pulumi.getter
    def tactics(self) -> Optional[Sequence[str]]:
        """
        The tactics of the alert rule
        """
        return pulumi.get(self, "tactics")

    @property
    @pulumi.getter(name="triggerOperator")
    def trigger_operator(self) -> str:
        """
        The operation against the threshold that triggers alert rule.
        """
        return pulumi.get(self, "trigger_operator")

    @property
    @pulumi.getter(name="triggerThreshold")
    def trigger_threshold(self) -> int:
        """
        The threshold triggers this alert rule.
        """
        return pulumi.get(self, "trigger_threshold")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Azure resource type
        """
        return pulumi.get(self, "type")


class AwaitableGetScheduledAlertRuleResult(GetScheduledAlertRuleResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetScheduledAlertRuleResult(
            alert_rule_template_name=self.alert_rule_template_name,
            description=self.description,
            display_name=self.display_name,
            enabled=self.enabled,
            etag=self.etag,
            id=self.id,
            kind=self.kind,
            last_modified_utc=self.last_modified_utc,
            name=self.name,
            query=self.query,
            query_frequency=self.query_frequency,
            query_period=self.query_period,
            severity=self.severity,
            suppression_duration=self.suppression_duration,
            suppression_enabled=self.suppression_enabled,
            tactics=self.tactics,
            trigger_operator=self.trigger_operator,
            trigger_threshold=self.trigger_threshold,
            type=self.type)


def get_scheduled_alert_rule(resource_group_name: Optional[str] = None,
                             rule_id: Optional[str] = None,
                             workspace_name: Optional[str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetScheduledAlertRuleResult:
    """
    Gets the alert rule.


    :param str resource_group_name: The name of the resource group within the user's subscription. The name is case insensitive.
    :param str rule_id: Alert rule ID
    :param str workspace_name: The name of the workspace.
    """
    __args__ = dict()
    __args__['resourceGroupName'] = resource_group_name
    __args__['ruleId'] = rule_id
    __args__['workspaceName'] = workspace_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure-native:securityinsights/v20200101:getScheduledAlertRule', __args__, opts=opts, typ=GetScheduledAlertRuleResult).value

    return AwaitableGetScheduledAlertRuleResult(
        alert_rule_template_name=__ret__.alert_rule_template_name,
        description=__ret__.description,
        display_name=__ret__.display_name,
        enabled=__ret__.enabled,
        etag=__ret__.etag,
        id=__ret__.id,
        kind=__ret__.kind,
        last_modified_utc=__ret__.last_modified_utc,
        name=__ret__.name,
        query=__ret__.query,
        query_frequency=__ret__.query_frequency,
        query_period=__ret__.query_period,
        severity=__ret__.severity,
        suppression_duration=__ret__.suppression_duration,
        suppression_enabled=__ret__.suppression_enabled,
        tactics=__ret__.tactics,
        trigger_operator=__ret__.trigger_operator,
        trigger_threshold=__ret__.trigger_threshold,
        type=__ret__.type)


@_utilities.lift_output_func(get_scheduled_alert_rule)
def get_scheduled_alert_rule_output(resource_group_name: Optional[pulumi.Input[str]] = None,
                                    rule_id: Optional[pulumi.Input[str]] = None,
                                    workspace_name: Optional[pulumi.Input[str]] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetScheduledAlertRuleResult]:
    """
    Gets the alert rule.


    :param str resource_group_name: The name of the resource group within the user's subscription. The name is case insensitive.
    :param str rule_id: Alert rule ID
    :param str workspace_name: The name of the workspace.
    """
    ...
