# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetRoleManagementPolicyAssignmentResult',
    'AwaitableGetRoleManagementPolicyAssignmentResult',
    'get_role_management_policy_assignment',
    'get_role_management_policy_assignment_output',
]

@pulumi.output_type
class GetRoleManagementPolicyAssignmentResult:
    """
    Role management policy
    """
    def __init__(__self__, id=None, name=None, policy_assignment_properties=None, policy_id=None, role_definition_id=None, scope=None, type=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if policy_assignment_properties and not isinstance(policy_assignment_properties, dict):
            raise TypeError("Expected argument 'policy_assignment_properties' to be a dict")
        pulumi.set(__self__, "policy_assignment_properties", policy_assignment_properties)
        if policy_id and not isinstance(policy_id, str):
            raise TypeError("Expected argument 'policy_id' to be a str")
        pulumi.set(__self__, "policy_id", policy_id)
        if role_definition_id and not isinstance(role_definition_id, str):
            raise TypeError("Expected argument 'role_definition_id' to be a str")
        pulumi.set(__self__, "role_definition_id", role_definition_id)
        if scope and not isinstance(scope, str):
            raise TypeError("Expected argument 'scope' to be a str")
        pulumi.set(__self__, "scope", scope)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The role management policy Id.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The role management policy name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="policyAssignmentProperties")
    def policy_assignment_properties(self) -> 'outputs.PolicyAssignmentPropertiesResponse':
        """
        Additional properties of scope, role definition and policy
        """
        return pulumi.get(self, "policy_assignment_properties")

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[str]:
        """
        The policy id role management policy assignment.
        """
        return pulumi.get(self, "policy_id")

    @property
    @pulumi.getter(name="roleDefinitionId")
    def role_definition_id(self) -> Optional[str]:
        """
        The role definition of management policy assignment.
        """
        return pulumi.get(self, "role_definition_id")

    @property
    @pulumi.getter
    def scope(self) -> Optional[str]:
        """
        The role management policy scope.
        """
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The role management policy type.
        """
        return pulumi.get(self, "type")


class AwaitableGetRoleManagementPolicyAssignmentResult(GetRoleManagementPolicyAssignmentResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRoleManagementPolicyAssignmentResult(
            id=self.id,
            name=self.name,
            policy_assignment_properties=self.policy_assignment_properties,
            policy_id=self.policy_id,
            role_definition_id=self.role_definition_id,
            scope=self.scope,
            type=self.type)


def get_role_management_policy_assignment(role_management_policy_assignment_name: Optional[str] = None,
                                          scope: Optional[str] = None,
                                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRoleManagementPolicyAssignmentResult:
    """
    Get the specified role management policy assignment for a resource scope


    :param str role_management_policy_assignment_name: The name of format {guid_guid} the role management policy assignment to get.
    :param str scope: The scope of the role management policy.
    """
    __args__ = dict()
    __args__['roleManagementPolicyAssignmentName'] = role_management_policy_assignment_name
    __args__['scope'] = scope
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure-native:authorization/v20201001preview:getRoleManagementPolicyAssignment', __args__, opts=opts, typ=GetRoleManagementPolicyAssignmentResult).value

    return AwaitableGetRoleManagementPolicyAssignmentResult(
        id=__ret__.id,
        name=__ret__.name,
        policy_assignment_properties=__ret__.policy_assignment_properties,
        policy_id=__ret__.policy_id,
        role_definition_id=__ret__.role_definition_id,
        scope=__ret__.scope,
        type=__ret__.type)


@_utilities.lift_output_func(get_role_management_policy_assignment)
def get_role_management_policy_assignment_output(role_management_policy_assignment_name: Optional[pulumi.Input[str]] = None,
                                                 scope: Optional[pulumi.Input[str]] = None,
                                                 opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetRoleManagementPolicyAssignmentResult]:
    """
    Get the specified role management policy assignment for a resource scope


    :param str role_management_policy_assignment_name: The name of format {guid_guid} the role management policy assignment to get.
    :param str scope: The scope of the role management policy.
    """
    ...
