# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

from enum import Enum

__all__ = [
    'AccessTier',
    'Action',
    'Bypass',
    'DefaultAction',
    'HttpProtocol',
    'IdentityType',
    'KeySource',
    'Kind',
    'Permissions',
    'PublicAccess',
    'ReasonCode',
    'RuleType',
    'Services',
    'SignedResource',
    'SignedResourceTypes',
    'SkuName',
    'State',
]


class AccessTier(str, Enum):
    """
    Required for storage accounts where kind = BlobStorage. The access tier used for billing.
    """
    HOT = "Hot"
    COOL = "Cool"


class Action(str, Enum):
    """
    The action of virtual network rule.
    """
    ALLOW = "Allow"


class Bypass(str, Enum):
    """
    Specifies whether traffic is bypassed for Logging/Metrics/AzureServices. Possible values are any combination of Logging|Metrics|AzureServices (For example, "Logging, Metrics"), or None to bypass none of those traffics.
    """
    NONE = "None"
    LOGGING = "Logging"
    METRICS = "Metrics"
    AZURE_SERVICES = "AzureServices"


class DefaultAction(str, Enum):
    """
    Specifies the default action of allow or deny when no other rules match.
    """
    ALLOW = "Allow"
    DENY = "Deny"


class HttpProtocol(str, Enum):
    """
    The protocol permitted for a request made with the account SAS.
    """
    HTTPS_HTTP = "https,http"
    HTTPS = "https"


class IdentityType(str, Enum):
    """
    The identity type.
    """
    SYSTEM_ASSIGNED = "SystemAssigned"


class KeySource(str, Enum):
    """
    The encryption keySource (provider). Possible values (case-insensitive):  Microsoft.Storage, Microsoft.Keyvault
    """
    MICROSOFT_STORAGE = "Microsoft.Storage"
    MICROSOFT_KEYVAULT = "Microsoft.Keyvault"


class Kind(str, Enum):
    """
    Required. Indicates the type of storage account.
    """
    STORAGE = "Storage"
    STORAGE_V2 = "StorageV2"
    BLOB_STORAGE = "BlobStorage"
    FILE_STORAGE = "FileStorage"
    BLOCK_BLOB_STORAGE = "BlockBlobStorage"


class Permissions(str, Enum):
    """
    The signed permissions for the service SAS. Possible values include: Read (r), Write (w), Delete (d), List (l), Add (a), Create (c), Update (u) and Process (p).
    """
    R = "r"
    D = "d"
    W = "w"
    L = "l"
    A = "a"
    C = "c"
    U = "u"
    P = "p"


class PublicAccess(str, Enum):
    """
    Specifies whether data in the container may be accessed publicly and the level of access.
    """
    CONTAINER = "Container"
    BLOB = "Blob"
    NONE = "None"


class ReasonCode(str, Enum):
    """
    The reason for the restriction. As of now this can be "QuotaId" or "NotAvailableForSubscription". Quota Id is set when the SKU has requiredQuotas parameter as the subscription does not belong to that quota. The "NotAvailableForSubscription" is related to capacity at DC.
    """
    QUOTA_ID = "QuotaId"
    NOT_AVAILABLE_FOR_SUBSCRIPTION = "NotAvailableForSubscription"


class RuleType(str, Enum):
    """
    The valid value is Lifecycle
    """
    LIFECYCLE = "Lifecycle"


class Services(str, Enum):
    """
    The signed services accessible with the account SAS. Possible values include: Blob (b), Queue (q), Table (t), File (f).
    """
    B = "b"
    Q = "q"
    T = "t"
    F = "f"


class SignedResource(str, Enum):
    """
    The signed services accessible with the service SAS. Possible values include: Blob (b), Container (c), File (f), Share (s).
    """
    B = "b"
    C = "c"
    F = "f"
    S = "s"


class SignedResourceTypes(str, Enum):
    """
    The signed resource types that are accessible with the account SAS. Service (s): Access to service-level APIs; Container (c): Access to container-level APIs; Object (o): Access to object-level APIs for blobs, queue messages, table entities, and files.
    """
    S = "s"
    C = "c"
    O = "o"


class SkuName(str, Enum):
    """
    Gets or sets the SKU name. Required for account creation; optional for update. Note that in older versions, SKU name was called accountType.
    """
    STANDARD_LRS = "Standard_LRS"
    STANDARD_GRS = "Standard_GRS"
    STANDARD_RAGRS = "Standard_RAGRS"
    STANDARD_ZRS = "Standard_ZRS"
    PREMIUM_LRS = "Premium_LRS"
    PREMIUM_ZRS = "Premium_ZRS"


class State(str, Enum):
    """
    Gets the state of virtual network rule.
    """
    PROVISIONING = "provisioning"
    DEPROVISIONING = "deprovisioning"
    SUCCEEDED = "succeeded"
    FAILED = "failed"
    NETWORK_SOURCE_DELETED = "networkSourceDeleted"
