# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'ACRPropertiesResponse',
    'AKSDeploymentPropertiesResponse',
    'AKSDeploymentSpecificationResponse',
    'ApacheTomcatAKSWorkloadDeploymentModelCustomPropertiesResponse',
    'ApacheTomcatAKSWorkloadDeploymentResponse',
    'ApacheTomcatWebApplicationResponse',
    'ApacheTomcatWorkloadInstanceModelCustomPropertiesResponse',
    'AppInsightMonitoringPropertiesResponse',
    'AutomationArtifactResponse',
    'AzureFileShareHydrationProfileResponse',
    'BindingResponse',
    'CertResponse',
    'ContainerImagePropertiesResponse',
    'DeployedResourcesPropertiesResponse',
    'DirectoryPathResponse',
    'GmsaAuthenticationPropertiesResponse',
    'HealthErrorModelResponse',
    'IISAKSWorkloadDeploymentModelCustomPropertiesResponse',
    'IISAKSWorkloadDeploymentResponse',
    'IISApplicationDetailsResponse',
    'IISVirtualApplicationDetailsResponse',
    'IISWebApplicationResponse',
    'IISWebServerResponse',
    'IISWorkloadInstanceModelCustomPropertiesResponse',
    'IdentityModelResponse',
    'InnerHealthErrorModelResponse',
    'KeyVaultSecretStorePropertiesResponse',
    'ManagedIdentityPropertiesResponse',
    'MigrateAgentModelPropertiesResponse',
    'MigrateAgentModelResponseSystemData',
    'MigrationConfigurationResponse',
    'ModernizeProjectModelPropertiesResponse',
    'ModernizeProjectModelResponseSystemData',
    'OperatingSystemDetailsResponse',
    'PortMappingResponse',
    'ResourceIdentityResponse',
    'ResourceRequirementsResponse',
    'SecretStoreDetailsResponse',
    'SecretStorePropertiesResponse',
    'TargetStorageProfileResponse',
    'UserAssignedIdentityResponse',
    'VMwareMigrateAgentModelCustomPropertiesResponse',
    'WebApplicationConfigurationResponse',
    'WebApplicationDirectoryResponse',
    'WebApplicationFrameworkResponse',
    'WorkloadDeploymentModelPropertiesResponse',
    'WorkloadDeploymentModelPropertiesResponseCurrentJob',
    'WorkloadDeploymentModelResponseSystemData',
    'WorkloadInstanceModelPropertiesResponse',
    'WorkloadInstanceModelPropertiesResponseCurrentJob',
    'WorkloadInstanceModelResponseSystemData',
]

@pulumi.output_type
class ACRPropertiesResponse(dict):
    """
    Class for ACR Properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "registryName":
            suggest = "registry_name"
        elif key == "resourceGroup":
            suggest = "resource_group"
        elif key == "subscriptionId":
            suggest = "subscription_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ACRPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ACRPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ACRPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 registry_name: Optional[str] = None,
                 resource_group: Optional[str] = None,
                 subscription_id: Optional[str] = None,
                 tenant_id: Optional[str] = None):
        """
        Class for ACR Properties.
        :param str registry_name: Gets or sets the azure container registry name.
        :param str resource_group: Gets or sets the resource group of the resource.
        :param str subscription_id: Gets or sets the subscription id of the resource.
        :param str tenant_id: Gets or sets the tenant id.
        """
        if registry_name is not None:
            pulumi.set(__self__, "registry_name", registry_name)
        if resource_group is not None:
            pulumi.set(__self__, "resource_group", resource_group)
        if subscription_id is not None:
            pulumi.set(__self__, "subscription_id", subscription_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="registryName")
    def registry_name(self) -> Optional[str]:
        """
        Gets or sets the azure container registry name.
        """
        return pulumi.get(self, "registry_name")

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> Optional[str]:
        """
        Gets or sets the resource group of the resource.
        """
        return pulumi.get(self, "resource_group")

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> Optional[str]:
        """
        Gets or sets the subscription id of the resource.
        """
        return pulumi.get(self, "subscription_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[str]:
        """
        Gets or sets the tenant id.
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class AKSDeploymentPropertiesResponse(dict):
    """
    Class for AKSDeployment Properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "aksClusterName":
            suggest = "aks_cluster_name"
        elif key == "resourceGroup":
            suggest = "resource_group"
        elif key == "subscriptionId":
            suggest = "subscription_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AKSDeploymentPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AKSDeploymentPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AKSDeploymentPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 aks_cluster_name: Optional[str] = None,
                 resource_group: Optional[str] = None,
                 subscription_id: Optional[str] = None,
                 tenant_id: Optional[str] = None):
        """
        Class for AKSDeployment Properties.
        :param str aks_cluster_name: Gets or sets the AKS cluster name.
        :param str resource_group: Gets or sets the resource group of the resource.
        :param str subscription_id: Gets or sets the subscription id of the resource.
        :param str tenant_id: Gets or sets the tenant id.
        """
        if aks_cluster_name is not None:
            pulumi.set(__self__, "aks_cluster_name", aks_cluster_name)
        if resource_group is not None:
            pulumi.set(__self__, "resource_group", resource_group)
        if subscription_id is not None:
            pulumi.set(__self__, "subscription_id", subscription_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="aksClusterName")
    def aks_cluster_name(self) -> Optional[str]:
        """
        Gets or sets the AKS cluster name.
        """
        return pulumi.get(self, "aks_cluster_name")

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> Optional[str]:
        """
        Gets or sets the resource group of the resource.
        """
        return pulumi.get(self, "resource_group")

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> Optional[str]:
        """
        Gets or sets the subscription id of the resource.
        """
        return pulumi.get(self, "subscription_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[str]:
        """
        Gets or sets the tenant id.
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class AKSDeploymentSpecificationResponse(dict):
    """
    AKS Deployment Specification.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kubernetesObjectsYaml":
            suggest = "kubernetes_objects_yaml"
        elif key == "loadBalancerType":
            suggest = "load_balancer_type"
        elif key == "replicaCount":
            suggest = "replica_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AKSDeploymentSpecificationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AKSDeploymentSpecificationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AKSDeploymentSpecificationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kubernetes_objects_yaml: Optional[str] = None,
                 load_balancer_type: Optional[str] = None,
                 replica_count: Optional[str] = None):
        """
        AKS Deployment Specification.
        :param str kubernetes_objects_yaml: Gets or sets the Merged Deployment and service Yaml.
        :param str load_balancer_type: Gets or sets the load balancer type.
        :param str replica_count: Gets or sets the replica count to be created in AKS.
        """
        if kubernetes_objects_yaml is not None:
            pulumi.set(__self__, "kubernetes_objects_yaml", kubernetes_objects_yaml)
        if load_balancer_type is not None:
            pulumi.set(__self__, "load_balancer_type", load_balancer_type)
        if replica_count is not None:
            pulumi.set(__self__, "replica_count", replica_count)

    @property
    @pulumi.getter(name="kubernetesObjectsYaml")
    def kubernetes_objects_yaml(self) -> Optional[str]:
        """
        Gets or sets the Merged Deployment and service Yaml.
        """
        return pulumi.get(self, "kubernetes_objects_yaml")

    @property
    @pulumi.getter(name="loadBalancerType")
    def load_balancer_type(self) -> Optional[str]:
        """
        Gets or sets the load balancer type.
        """
        return pulumi.get(self, "load_balancer_type")

    @property
    @pulumi.getter(name="replicaCount")
    def replica_count(self) -> Optional[str]:
        """
        Gets or sets the replica count to be created in AKS.
        """
        return pulumi.get(self, "replica_count")


@pulumi.output_type
class ApacheTomcatAKSWorkloadDeploymentModelCustomPropertiesResponse(dict):
    """
    ApacheTomcat workload instance model custom properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceType":
            suggest = "instance_type"
        elif key == "apacheTomcatAksWorkloadDeploymentProperties":
            suggest = "apache_tomcat_aks_workload_deployment_properties"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApacheTomcatAKSWorkloadDeploymentModelCustomPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApacheTomcatAKSWorkloadDeploymentModelCustomPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApacheTomcatAKSWorkloadDeploymentModelCustomPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_type: str,
                 apache_tomcat_aks_workload_deployment_properties: Optional['outputs.ApacheTomcatAKSWorkloadDeploymentResponse'] = None):
        """
        ApacheTomcat workload instance model custom properties.
        :param str instance_type: Gets or sets the instance type.
               Expected value is 'ApacheTomcatAKSWorkloadDeploymentModelCustomProperties'.
        :param 'ApacheTomcatAKSWorkloadDeploymentResponse' apache_tomcat_aks_workload_deployment_properties: ApacheTomcat web application.
        """
        pulumi.set(__self__, "instance_type", 'ApacheTomcatAKSWorkloadDeploymentModelCustomProperties')
        if apache_tomcat_aks_workload_deployment_properties is not None:
            pulumi.set(__self__, "apache_tomcat_aks_workload_deployment_properties", apache_tomcat_aks_workload_deployment_properties)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> str:
        """
        Gets or sets the instance type.
        Expected value is 'ApacheTomcatAKSWorkloadDeploymentModelCustomProperties'.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="apacheTomcatAksWorkloadDeploymentProperties")
    def apache_tomcat_aks_workload_deployment_properties(self) -> Optional['outputs.ApacheTomcatAKSWorkloadDeploymentResponse']:
        """
        ApacheTomcat web application.
        """
        return pulumi.get(self, "apache_tomcat_aks_workload_deployment_properties")


@pulumi.output_type
class ApacheTomcatAKSWorkloadDeploymentResponse(dict):
    """
    ApacheTomcat web application.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deploymentHistory":
            suggest = "deployment_history"
        elif key == "automationArtifactProperties":
            suggest = "automation_artifact_properties"
        elif key == "buildContainerImages":
            suggest = "build_container_images"
        elif key == "clusterProperties":
            suggest = "cluster_properties"
        elif key == "containerImageProperties":
            suggest = "container_image_properties"
        elif key == "deploymentNamePrefix":
            suggest = "deployment_name_prefix"
        elif key == "deploymentSpec":
            suggest = "deployment_spec"
        elif key == "monitoringProperties":
            suggest = "monitoring_properties"
        elif key == "targetPlatformIdentity":
            suggest = "target_platform_identity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApacheTomcatAKSWorkloadDeploymentResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApacheTomcatAKSWorkloadDeploymentResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApacheTomcatAKSWorkloadDeploymentResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 deployment_history: Sequence['outputs.DeployedResourcesPropertiesResponse'],
                 automation_artifact_properties: Optional['outputs.AutomationArtifactResponse'] = None,
                 bindings: Optional[Sequence['outputs.BindingResponse']] = None,
                 build_container_images: Optional[Sequence['outputs.ContainerImagePropertiesResponse']] = None,
                 cluster_properties: Optional['outputs.AKSDeploymentPropertiesResponse'] = None,
                 configurations: Optional[Sequence['outputs.WebApplicationConfigurationResponse']] = None,
                 container_image_properties: Optional['outputs.ContainerImagePropertiesResponse'] = None,
                 deployment_name_prefix: Optional[str] = None,
                 deployment_spec: Optional['outputs.AKSDeploymentSpecificationResponse'] = None,
                 directories: Optional[Sequence['outputs.WebApplicationDirectoryResponse']] = None,
                 limits: Optional['outputs.ResourceRequirementsResponse'] = None,
                 monitoring_properties: Optional['outputs.AppInsightMonitoringPropertiesResponse'] = None,
                 requests: Optional['outputs.ResourceRequirementsResponse'] = None,
                 target_platform_identity: Optional[str] = None):
        """
        ApacheTomcat web application.
        :param Sequence['DeployedResourcesPropertiesResponse'] deployment_history: Gets or sets the deployment history.
        :param 'AutomationArtifactResponse' automation_artifact_properties: Class for automation artifact.
        :param Sequence['BindingResponse'] bindings: Gets or sets the bindings for the application.
        :param Sequence['ContainerImagePropertiesResponse'] build_container_images: Gets or sets the build container images.
        :param 'AKSDeploymentPropertiesResponse' cluster_properties: Class for AKSDeployment Properties.
        :param Sequence['WebApplicationConfigurationResponse'] configurations: Gets or sets application configuration.
        :param 'ContainerImagePropertiesResponse' container_image_properties: Class for container image properties.
        :param str deployment_name_prefix: Gets or sets the deployment name prefix.
        :param 'AKSDeploymentSpecificationResponse' deployment_spec: AKS Deployment Specification.
        :param Sequence['WebApplicationDirectoryResponse'] directories: Gets or sets application directories.
        :param 'ResourceRequirementsResponse' limits: Resource Requirements.
        :param 'AppInsightMonitoringPropertiesResponse' monitoring_properties: Class for app insight monitoring properties.
        :param 'ResourceRequirementsResponse' requests: Resource Requirements.
        :param str target_platform_identity: Gets or sets the target platform managed identity.
        """
        pulumi.set(__self__, "deployment_history", deployment_history)
        if automation_artifact_properties is not None:
            pulumi.set(__self__, "automation_artifact_properties", automation_artifact_properties)
        if bindings is not None:
            pulumi.set(__self__, "bindings", bindings)
        if build_container_images is not None:
            pulumi.set(__self__, "build_container_images", build_container_images)
        if cluster_properties is not None:
            pulumi.set(__self__, "cluster_properties", cluster_properties)
        if configurations is not None:
            pulumi.set(__self__, "configurations", configurations)
        if container_image_properties is not None:
            pulumi.set(__self__, "container_image_properties", container_image_properties)
        if deployment_name_prefix is not None:
            pulumi.set(__self__, "deployment_name_prefix", deployment_name_prefix)
        if deployment_spec is not None:
            pulumi.set(__self__, "deployment_spec", deployment_spec)
        if directories is not None:
            pulumi.set(__self__, "directories", directories)
        if limits is not None:
            pulumi.set(__self__, "limits", limits)
        if monitoring_properties is not None:
            pulumi.set(__self__, "monitoring_properties", monitoring_properties)
        if requests is not None:
            pulumi.set(__self__, "requests", requests)
        if target_platform_identity is not None:
            pulumi.set(__self__, "target_platform_identity", target_platform_identity)

    @property
    @pulumi.getter(name="deploymentHistory")
    def deployment_history(self) -> Sequence['outputs.DeployedResourcesPropertiesResponse']:
        """
        Gets or sets the deployment history.
        """
        return pulumi.get(self, "deployment_history")

    @property
    @pulumi.getter(name="automationArtifactProperties")
    def automation_artifact_properties(self) -> Optional['outputs.AutomationArtifactResponse']:
        """
        Class for automation artifact.
        """
        return pulumi.get(self, "automation_artifact_properties")

    @property
    @pulumi.getter
    def bindings(self) -> Optional[Sequence['outputs.BindingResponse']]:
        """
        Gets or sets the bindings for the application.
        """
        return pulumi.get(self, "bindings")

    @property
    @pulumi.getter(name="buildContainerImages")
    def build_container_images(self) -> Optional[Sequence['outputs.ContainerImagePropertiesResponse']]:
        """
        Gets or sets the build container images.
        """
        return pulumi.get(self, "build_container_images")

    @property
    @pulumi.getter(name="clusterProperties")
    def cluster_properties(self) -> Optional['outputs.AKSDeploymentPropertiesResponse']:
        """
        Class for AKSDeployment Properties.
        """
        return pulumi.get(self, "cluster_properties")

    @property
    @pulumi.getter
    def configurations(self) -> Optional[Sequence['outputs.WebApplicationConfigurationResponse']]:
        """
        Gets or sets application configuration.
        """
        return pulumi.get(self, "configurations")

    @property
    @pulumi.getter(name="containerImageProperties")
    def container_image_properties(self) -> Optional['outputs.ContainerImagePropertiesResponse']:
        """
        Class for container image properties.
        """
        return pulumi.get(self, "container_image_properties")

    @property
    @pulumi.getter(name="deploymentNamePrefix")
    def deployment_name_prefix(self) -> Optional[str]:
        """
        Gets or sets the deployment name prefix.
        """
        return pulumi.get(self, "deployment_name_prefix")

    @property
    @pulumi.getter(name="deploymentSpec")
    def deployment_spec(self) -> Optional['outputs.AKSDeploymentSpecificationResponse']:
        """
        AKS Deployment Specification.
        """
        return pulumi.get(self, "deployment_spec")

    @property
    @pulumi.getter
    def directories(self) -> Optional[Sequence['outputs.WebApplicationDirectoryResponse']]:
        """
        Gets or sets application directories.
        """
        return pulumi.get(self, "directories")

    @property
    @pulumi.getter
    def limits(self) -> Optional['outputs.ResourceRequirementsResponse']:
        """
        Resource Requirements.
        """
        return pulumi.get(self, "limits")

    @property
    @pulumi.getter(name="monitoringProperties")
    def monitoring_properties(self) -> Optional['outputs.AppInsightMonitoringPropertiesResponse']:
        """
        Class for app insight monitoring properties.
        """
        return pulumi.get(self, "monitoring_properties")

    @property
    @pulumi.getter
    def requests(self) -> Optional['outputs.ResourceRequirementsResponse']:
        """
        Resource Requirements.
        """
        return pulumi.get(self, "requests")

    @property
    @pulumi.getter(name="targetPlatformIdentity")
    def target_platform_identity(self) -> Optional[str]:
        """
        Gets or sets the target platform managed identity.
        """
        return pulumi.get(self, "target_platform_identity")


@pulumi.output_type
class ApacheTomcatWebApplicationResponse(dict):
    """
    ApacheTomcat web application.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "applicationId":
            suggest = "application_id"
        elif key == "applicationName":
            suggest = "application_name"
        elif key == "applicationScratchPath":
            suggest = "application_scratch_path"
        elif key == "discoveredFrameworks":
            suggest = "discovered_frameworks"
        elif key == "displayName":
            suggest = "display_name"
        elif key == "primaryFramework":
            suggest = "primary_framework"
        elif key == "webServerId":
            suggest = "web_server_id"
        elif key == "webServerName":
            suggest = "web_server_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApacheTomcatWebApplicationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApacheTomcatWebApplicationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApacheTomcatWebApplicationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 application_id: Optional[str] = None,
                 application_name: Optional[str] = None,
                 application_scratch_path: Optional[str] = None,
                 bindings: Optional[Sequence['outputs.BindingResponse']] = None,
                 configurations: Optional[Sequence['outputs.WebApplicationConfigurationResponse']] = None,
                 directories: Optional[Sequence['outputs.WebApplicationDirectoryResponse']] = None,
                 discovered_frameworks: Optional[Sequence['outputs.WebApplicationFrameworkResponse']] = None,
                 display_name: Optional[str] = None,
                 limits: Optional['outputs.ResourceRequirementsResponse'] = None,
                 path: Optional['outputs.DirectoryPathResponse'] = None,
                 primary_framework: Optional['outputs.WebApplicationFrameworkResponse'] = None,
                 requests: Optional['outputs.ResourceRequirementsResponse'] = None,
                 web_server_id: Optional[str] = None,
                 web_server_name: Optional[str] = None):
        """
        ApacheTomcat web application.
        :param str application_id: Gets or sets the web application id.
        :param str application_name: Gets or sets the web application name.
        :param str application_scratch_path: Gets or sets application scratch path.
        :param Sequence['BindingResponse'] bindings: Gets or sets the bindings for the application.
        :param Sequence['WebApplicationConfigurationResponse'] configurations: Gets or sets application configuration.
        :param Sequence['WebApplicationDirectoryResponse'] directories: Gets or sets application directories.
        :param Sequence['WebApplicationFrameworkResponse'] discovered_frameworks: Gets or sets the discovered frameworks of application.
        :param str display_name: Gets or sets the display name.
        :param 'ResourceRequirementsResponse' limits: Resource Requirements.
        :param 'DirectoryPathResponse' path: Second level entity for virtual directories.
        :param 'WebApplicationFrameworkResponse' primary_framework: Framework specific data for a web application.
        :param 'ResourceRequirementsResponse' requests: Resource Requirements.
        :param str web_server_id: Gets or sets the web server id.
        :param str web_server_name: Gets or sets the web server name.
        """
        if application_id is not None:
            pulumi.set(__self__, "application_id", application_id)
        if application_name is not None:
            pulumi.set(__self__, "application_name", application_name)
        if application_scratch_path is not None:
            pulumi.set(__self__, "application_scratch_path", application_scratch_path)
        if bindings is not None:
            pulumi.set(__self__, "bindings", bindings)
        if configurations is not None:
            pulumi.set(__self__, "configurations", configurations)
        if directories is not None:
            pulumi.set(__self__, "directories", directories)
        if discovered_frameworks is not None:
            pulumi.set(__self__, "discovered_frameworks", discovered_frameworks)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if limits is not None:
            pulumi.set(__self__, "limits", limits)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if primary_framework is not None:
            pulumi.set(__self__, "primary_framework", primary_framework)
        if requests is not None:
            pulumi.set(__self__, "requests", requests)
        if web_server_id is not None:
            pulumi.set(__self__, "web_server_id", web_server_id)
        if web_server_name is not None:
            pulumi.set(__self__, "web_server_name", web_server_name)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> Optional[str]:
        """
        Gets or sets the web application id.
        """
        return pulumi.get(self, "application_id")

    @property
    @pulumi.getter(name="applicationName")
    def application_name(self) -> Optional[str]:
        """
        Gets or sets the web application name.
        """
        return pulumi.get(self, "application_name")

    @property
    @pulumi.getter(name="applicationScratchPath")
    def application_scratch_path(self) -> Optional[str]:
        """
        Gets or sets application scratch path.
        """
        return pulumi.get(self, "application_scratch_path")

    @property
    @pulumi.getter
    def bindings(self) -> Optional[Sequence['outputs.BindingResponse']]:
        """
        Gets or sets the bindings for the application.
        """
        return pulumi.get(self, "bindings")

    @property
    @pulumi.getter
    def configurations(self) -> Optional[Sequence['outputs.WebApplicationConfigurationResponse']]:
        """
        Gets or sets application configuration.
        """
        return pulumi.get(self, "configurations")

    @property
    @pulumi.getter
    def directories(self) -> Optional[Sequence['outputs.WebApplicationDirectoryResponse']]:
        """
        Gets or sets application directories.
        """
        return pulumi.get(self, "directories")

    @property
    @pulumi.getter(name="discoveredFrameworks")
    def discovered_frameworks(self) -> Optional[Sequence['outputs.WebApplicationFrameworkResponse']]:
        """
        Gets or sets the discovered frameworks of application.
        """
        return pulumi.get(self, "discovered_frameworks")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        Gets or sets the display name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def limits(self) -> Optional['outputs.ResourceRequirementsResponse']:
        """
        Resource Requirements.
        """
        return pulumi.get(self, "limits")

    @property
    @pulumi.getter
    def path(self) -> Optional['outputs.DirectoryPathResponse']:
        """
        Second level entity for virtual directories.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="primaryFramework")
    def primary_framework(self) -> Optional['outputs.WebApplicationFrameworkResponse']:
        """
        Framework specific data for a web application.
        """
        return pulumi.get(self, "primary_framework")

    @property
    @pulumi.getter
    def requests(self) -> Optional['outputs.ResourceRequirementsResponse']:
        """
        Resource Requirements.
        """
        return pulumi.get(self, "requests")

    @property
    @pulumi.getter(name="webServerId")
    def web_server_id(self) -> Optional[str]:
        """
        Gets or sets the web server id.
        """
        return pulumi.get(self, "web_server_id")

    @property
    @pulumi.getter(name="webServerName")
    def web_server_name(self) -> Optional[str]:
        """
        Gets or sets the web server name.
        """
        return pulumi.get(self, "web_server_name")


@pulumi.output_type
class ApacheTomcatWorkloadInstanceModelCustomPropertiesResponse(dict):
    """
    ApacheTomcat workload instance model custom properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceType":
            suggest = "instance_type"
        elif key == "apacheTomcatWebApplication":
            suggest = "apache_tomcat_web_application"
        elif key == "webAppArmId":
            suggest = "web_app_arm_id"
        elif key == "webAppSiteName":
            suggest = "web_app_site_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApacheTomcatWorkloadInstanceModelCustomPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApacheTomcatWorkloadInstanceModelCustomPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApacheTomcatWorkloadInstanceModelCustomPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_type: str,
                 apache_tomcat_web_application: Optional['outputs.ApacheTomcatWebApplicationResponse'] = None,
                 web_app_arm_id: Optional[str] = None,
                 web_app_site_name: Optional[str] = None):
        """
        ApacheTomcat workload instance model custom properties.
        :param str instance_type: Gets or sets the instance type.
               Expected value is 'ApacheTomcatWorkloadInstanceModelCustomProperties'.
        :param 'ApacheTomcatWebApplicationResponse' apache_tomcat_web_application: ApacheTomcat web application.
        :param str web_app_arm_id: Gets or sets the Web application ARM id.
        :param str web_app_site_name: Gets or sets the Web application site name.
        """
        pulumi.set(__self__, "instance_type", 'ApacheTomcatWorkloadInstanceModelCustomProperties')
        if apache_tomcat_web_application is not None:
            pulumi.set(__self__, "apache_tomcat_web_application", apache_tomcat_web_application)
        if web_app_arm_id is not None:
            pulumi.set(__self__, "web_app_arm_id", web_app_arm_id)
        if web_app_site_name is not None:
            pulumi.set(__self__, "web_app_site_name", web_app_site_name)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> str:
        """
        Gets or sets the instance type.
        Expected value is 'ApacheTomcatWorkloadInstanceModelCustomProperties'.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="apacheTomcatWebApplication")
    def apache_tomcat_web_application(self) -> Optional['outputs.ApacheTomcatWebApplicationResponse']:
        """
        ApacheTomcat web application.
        """
        return pulumi.get(self, "apache_tomcat_web_application")

    @property
    @pulumi.getter(name="webAppArmId")
    def web_app_arm_id(self) -> Optional[str]:
        """
        Gets or sets the Web application ARM id.
        """
        return pulumi.get(self, "web_app_arm_id")

    @property
    @pulumi.getter(name="webAppSiteName")
    def web_app_site_name(self) -> Optional[str]:
        """
        Gets or sets the Web application site name.
        """
        return pulumi.get(self, "web_app_site_name")


@pulumi.output_type
class AppInsightMonitoringPropertiesResponse(dict):
    """
    Class for app insight monitoring properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appInsightsName":
            suggest = "app_insights_name"
        elif key == "isEnabled":
            suggest = "is_enabled"
        elif key == "resourceGroup":
            suggest = "resource_group"
        elif key == "secretStoreDetails":
            suggest = "secret_store_details"
        elif key == "subscriptionId":
            suggest = "subscription_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppInsightMonitoringPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppInsightMonitoringPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppInsightMonitoringPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 app_insights_name: Optional[str] = None,
                 is_enabled: Optional[bool] = None,
                 region: Optional[str] = None,
                 resource_group: Optional[str] = None,
                 secret_store_details: Optional['outputs.SecretStoreDetailsResponse'] = None,
                 subscription_id: Optional[str] = None):
        """
        Class for app insight monitoring properties.
        :param str app_insights_name: Gets or sets the app insights name.
        :param bool is_enabled: Gets or sets a value indicating whether monitoring is enabled.
        :param str region: Gets or sets the region.
        :param str resource_group: Gets or sets the resource group of the resource.
        :param str subscription_id: Gets or sets the subscription id of the resource.
        """
        if app_insights_name is not None:
            pulumi.set(__self__, "app_insights_name", app_insights_name)
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if resource_group is not None:
            pulumi.set(__self__, "resource_group", resource_group)
        if secret_store_details is not None:
            pulumi.set(__self__, "secret_store_details", secret_store_details)
        if subscription_id is not None:
            pulumi.set(__self__, "subscription_id", subscription_id)

    @property
    @pulumi.getter(name="appInsightsName")
    def app_insights_name(self) -> Optional[str]:
        """
        Gets or sets the app insights name.
        """
        return pulumi.get(self, "app_insights_name")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[bool]:
        """
        Gets or sets a value indicating whether monitoring is enabled.
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        """
        Gets or sets the region.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> Optional[str]:
        """
        Gets or sets the resource group of the resource.
        """
        return pulumi.get(self, "resource_group")

    @property
    @pulumi.getter(name="secretStoreDetails")
    def secret_store_details(self) -> Optional['outputs.SecretStoreDetailsResponse']:
        return pulumi.get(self, "secret_store_details")

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> Optional[str]:
        """
        Gets or sets the subscription id of the resource.
        """
        return pulumi.get(self, "subscription_id")


@pulumi.output_type
class AutomationArtifactResponse(dict):
    """
    Class for automation artifact.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "azureFileShareProfile":
            suggest = "azure_file_share_profile"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutomationArtifactResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutomationArtifactResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutomationArtifactResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 artifacts: Optional[Mapping[str, str]] = None,
                 azure_file_share_profile: Optional['outputs.AzureFileShareHydrationProfileResponse'] = None,
                 status: Optional[str] = None):
        """
        Class for automation artifact.
        :param Mapping[str, str] artifacts: Gets or sets the artifacts.
        :param 'AzureFileShareHydrationProfileResponse' azure_file_share_profile: Azure file share profile for hydration of application folders not mounted on
               the container file system.
        :param str status: Gets or sets the status of automation artifacts.
        """
        if artifacts is not None:
            pulumi.set(__self__, "artifacts", artifacts)
        if azure_file_share_profile is not None:
            pulumi.set(__self__, "azure_file_share_profile", azure_file_share_profile)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def artifacts(self) -> Optional[Mapping[str, str]]:
        """
        Gets or sets the artifacts.
        """
        return pulumi.get(self, "artifacts")

    @property
    @pulumi.getter(name="azureFileShareProfile")
    def azure_file_share_profile(self) -> Optional['outputs.AzureFileShareHydrationProfileResponse']:
        """
        Azure file share profile for hydration of application folders not mounted on
        the container file system.
        """
        return pulumi.get(self, "azure_file_share_profile")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        Gets or sets the status of automation artifacts.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class AzureFileShareHydrationProfileResponse(dict):
    """
    Azure file share profile for hydration of application folders not mounted on
    the container file system.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "azureFileShareDirPath":
            suggest = "azure_file_share_dir_path"
        elif key == "azureFileShareName":
            suggest = "azure_file_share_name"
        elif key == "azureFileShareResourceGroup":
            suggest = "azure_file_share_resource_group"
        elif key == "azureFileShareStorageAccount":
            suggest = "azure_file_share_storage_account"
        elif key == "azureFileShareSubscriptionId":
            suggest = "azure_file_share_subscription_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureFileShareHydrationProfileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureFileShareHydrationProfileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureFileShareHydrationProfileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 azure_file_share_dir_path: Optional[str] = None,
                 azure_file_share_name: Optional[str] = None,
                 azure_file_share_resource_group: Optional[str] = None,
                 azure_file_share_storage_account: Optional[str] = None,
                 azure_file_share_subscription_id: Optional[str] = None):
        """
        Azure file share profile for hydration of application folders not mounted on
        the container file system.
        :param str azure_file_share_dir_path: Gets or sets the cloud directory path of the directory on azure file share.
        :param str azure_file_share_name: Gets or sets the name of the azure file share.
        :param str azure_file_share_resource_group: Gets or sets the name of the azure file share resource group.
        :param str azure_file_share_storage_account: Gets or sets the name of the azure file share storage account.
        :param str azure_file_share_subscription_id: Gets or sets the subscription id of the azure file share.
        """
        if azure_file_share_dir_path is not None:
            pulumi.set(__self__, "azure_file_share_dir_path", azure_file_share_dir_path)
        if azure_file_share_name is not None:
            pulumi.set(__self__, "azure_file_share_name", azure_file_share_name)
        if azure_file_share_resource_group is not None:
            pulumi.set(__self__, "azure_file_share_resource_group", azure_file_share_resource_group)
        if azure_file_share_storage_account is not None:
            pulumi.set(__self__, "azure_file_share_storage_account", azure_file_share_storage_account)
        if azure_file_share_subscription_id is not None:
            pulumi.set(__self__, "azure_file_share_subscription_id", azure_file_share_subscription_id)

    @property
    @pulumi.getter(name="azureFileShareDirPath")
    def azure_file_share_dir_path(self) -> Optional[str]:
        """
        Gets or sets the cloud directory path of the directory on azure file share.
        """
        return pulumi.get(self, "azure_file_share_dir_path")

    @property
    @pulumi.getter(name="azureFileShareName")
    def azure_file_share_name(self) -> Optional[str]:
        """
        Gets or sets the name of the azure file share.
        """
        return pulumi.get(self, "azure_file_share_name")

    @property
    @pulumi.getter(name="azureFileShareResourceGroup")
    def azure_file_share_resource_group(self) -> Optional[str]:
        """
        Gets or sets the name of the azure file share resource group.
        """
        return pulumi.get(self, "azure_file_share_resource_group")

    @property
    @pulumi.getter(name="azureFileShareStorageAccount")
    def azure_file_share_storage_account(self) -> Optional[str]:
        """
        Gets or sets the name of the azure file share storage account.
        """
        return pulumi.get(self, "azure_file_share_storage_account")

    @property
    @pulumi.getter(name="azureFileShareSubscriptionId")
    def azure_file_share_subscription_id(self) -> Optional[str]:
        """
        Gets or sets the subscription id of the azure file share.
        """
        return pulumi.get(self, "azure_file_share_subscription_id")


@pulumi.output_type
class BindingResponse(dict):
    """
    Binding for a web application.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hostName":
            suggest = "host_name"
        elif key == "ipAddress":
            suggest = "ip_address"
        elif key == "portMapping":
            suggest = "port_mapping"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BindingResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BindingResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BindingResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 cert: Optional['outputs.CertResponse'] = None,
                 host_name: Optional[str] = None,
                 ip_address: Optional[str] = None,
                 port: Optional[str] = None,
                 port_mapping: Optional['outputs.PortMappingResponse'] = None,
                 protocol: Optional[str] = None):
        """
        Binding for a web application.
        :param str id: Gets the ID.
        :param 'CertResponse' cert: WebApplication certificate.
        :param str host_name: Gets or sets the binding host name.
        :param str ip_address: Gets or sets the IP Address.
        :param str port: Gets or sets the application port.
        :param 'PortMappingResponse' port_mapping: WebApplication port mapping.
        :param str protocol: Gets or sets the protocol.
        """
        pulumi.set(__self__, "id", id)
        if cert is not None:
            pulumi.set(__self__, "cert", cert)
        if host_name is not None:
            pulumi.set(__self__, "host_name", host_name)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if port_mapping is not None:
            pulumi.set(__self__, "port_mapping", port_mapping)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Gets the ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def cert(self) -> Optional['outputs.CertResponse']:
        """
        WebApplication certificate.
        """
        return pulumi.get(self, "cert")

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> Optional[str]:
        """
        Gets or sets the binding host name.
        """
        return pulumi.get(self, "host_name")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[str]:
        """
        Gets or sets the IP Address.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter
    def port(self) -> Optional[str]:
        """
        Gets or sets the application port.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="portMapping")
    def port_mapping(self) -> Optional['outputs.PortMappingResponse']:
        """
        WebApplication port mapping.
        """
        return pulumi.get(self, "port_mapping")

    @property
    @pulumi.getter
    def protocol(self) -> Optional[str]:
        """
        Gets or sets the protocol.
        """
        return pulumi.get(self, "protocol")


@pulumi.output_type
class CertResponse(dict):
    """
    WebApplication certificate.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certData":
            suggest = "cert_data"
        elif key == "certNeeded":
            suggest = "cert_needed"
        elif key == "certProvided":
            suggest = "cert_provided"
        elif key == "secretStore":
            suggest = "secret_store"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cert_data: Optional[str] = None,
                 cert_needed: Optional[bool] = None,
                 cert_provided: Optional[bool] = None,
                 secret_store: Optional[str] = None):
        """
        WebApplication certificate.
        :param str cert_data: Gets or sets the Certificate data.
        :param bool cert_needed: Gets or sets a value indicating whether certificate is needed or not.
        :param bool cert_provided: Gets or sets a value indicating whether certificate is provided or not.
        :param str secret_store: Gets or sets the type of secret store for the certificate.
        """
        if cert_data is not None:
            pulumi.set(__self__, "cert_data", cert_data)
        if cert_needed is not None:
            pulumi.set(__self__, "cert_needed", cert_needed)
        if cert_provided is not None:
            pulumi.set(__self__, "cert_provided", cert_provided)
        if secret_store is not None:
            pulumi.set(__self__, "secret_store", secret_store)

    @property
    @pulumi.getter(name="certData")
    def cert_data(self) -> Optional[str]:
        """
        Gets or sets the Certificate data.
        """
        return pulumi.get(self, "cert_data")

    @property
    @pulumi.getter(name="certNeeded")
    def cert_needed(self) -> Optional[bool]:
        """
        Gets or sets a value indicating whether certificate is needed or not.
        """
        return pulumi.get(self, "cert_needed")

    @property
    @pulumi.getter(name="certProvided")
    def cert_provided(self) -> Optional[bool]:
        """
        Gets or sets a value indicating whether certificate is provided or not.
        """
        return pulumi.get(self, "cert_provided")

    @property
    @pulumi.getter(name="secretStore")
    def secret_store(self) -> Optional[str]:
        """
        Gets or sets the type of secret store for the certificate.
        """
        return pulumi.get(self, "secret_store")


@pulumi.output_type
class ContainerImagePropertiesResponse(dict):
    """
    Class for container image properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "imageName":
            suggest = "image_name"
        elif key == "imageTag":
            suggest = "image_tag"
        elif key == "registryProperties":
            suggest = "registry_properties"
        elif key == "runId":
            suggest = "run_id"
        elif key == "runStatus":
            suggest = "run_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerImagePropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerImagePropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerImagePropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 dockerfile: Optional[str] = None,
                 image_name: Optional[str] = None,
                 image_tag: Optional[str] = None,
                 registry_properties: Optional['outputs.ACRPropertiesResponse'] = None,
                 run_id: Optional[str] = None,
                 run_status: Optional[str] = None):
        """
        Class for container image properties.
        :param str id: Gets the ID.
        :param str dockerfile: Gets or sets the dockerfile for the container image.
        :param str image_name: Gets or sets the container image name.
        :param str image_tag: Gets or sets the container image tag.
        :param 'ACRPropertiesResponse' registry_properties: Class for ACR Properties.
        :param str run_id: Gets or sets the RunId.
        :param str run_status: Gets or sets the RunStatus.
        """
        pulumi.set(__self__, "id", id)
        if dockerfile is not None:
            pulumi.set(__self__, "dockerfile", dockerfile)
        if image_name is not None:
            pulumi.set(__self__, "image_name", image_name)
        if image_tag is not None:
            pulumi.set(__self__, "image_tag", image_tag)
        if registry_properties is not None:
            pulumi.set(__self__, "registry_properties", registry_properties)
        if run_id is not None:
            pulumi.set(__self__, "run_id", run_id)
        if run_status is not None:
            pulumi.set(__self__, "run_status", run_status)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Gets the ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def dockerfile(self) -> Optional[str]:
        """
        Gets or sets the dockerfile for the container image.
        """
        return pulumi.get(self, "dockerfile")

    @property
    @pulumi.getter(name="imageName")
    def image_name(self) -> Optional[str]:
        """
        Gets or sets the container image name.
        """
        return pulumi.get(self, "image_name")

    @property
    @pulumi.getter(name="imageTag")
    def image_tag(self) -> Optional[str]:
        """
        Gets or sets the container image tag.
        """
        return pulumi.get(self, "image_tag")

    @property
    @pulumi.getter(name="registryProperties")
    def registry_properties(self) -> Optional['outputs.ACRPropertiesResponse']:
        """
        Class for ACR Properties.
        """
        return pulumi.get(self, "registry_properties")

    @property
    @pulumi.getter(name="runId")
    def run_id(self) -> Optional[str]:
        """
        Gets or sets the RunId.
        """
        return pulumi.get(self, "run_id")

    @property
    @pulumi.getter(name="runStatus")
    def run_status(self) -> Optional[str]:
        """
        Gets or sets the RunStatus.
        """
        return pulumi.get(self, "run_status")


@pulumi.output_type
class DeployedResourcesPropertiesResponse(dict):
    """
    Class for deployed resource properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deployedResourceId":
            suggest = "deployed_resource_id"
        elif key == "deploymentTimestamp":
            suggest = "deployment_timestamp"
        elif key == "displayName":
            suggest = "display_name"
        elif key == "isCleanUpDone":
            suggest = "is_clean_up_done"
        elif key == "isTestMigration":
            suggest = "is_test_migration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeployedResourcesPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeployedResourcesPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeployedResourcesPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 context: str,
                 deployed_resource_id: str,
                 deployment_timestamp: str,
                 display_name: str,
                 id: str,
                 is_clean_up_done: bool,
                 is_test_migration: bool,
                 status: str,
                 type: str):
        """
        Class for deployed resource properties.
        :param str context: Gets or sets the context of deployed resources.
        :param str deployed_resource_id: Gets or sets the deployed resource id.
        :param str deployment_timestamp: Gets or sets the deployment timestamp.
        :param str display_name: Gets or sets the name of deployed resources.
        :param str id: Gets or sets the ID.
        :param bool is_clean_up_done: Gets or sets a value indicating whether resources are cleaned up from target.
        :param bool is_test_migration: Gets or sets a value indicating whether scenario is test migration.
        :param str status: Gets or sets the status of deployed resources.
        :param str type: Gets or sets the type of deployed resources.
        """
        pulumi.set(__self__, "context", context)
        pulumi.set(__self__, "deployed_resource_id", deployed_resource_id)
        pulumi.set(__self__, "deployment_timestamp", deployment_timestamp)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_clean_up_done", is_clean_up_done)
        pulumi.set(__self__, "is_test_migration", is_test_migration)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def context(self) -> str:
        """
        Gets or sets the context of deployed resources.
        """
        return pulumi.get(self, "context")

    @property
    @pulumi.getter(name="deployedResourceId")
    def deployed_resource_id(self) -> str:
        """
        Gets or sets the deployed resource id.
        """
        return pulumi.get(self, "deployed_resource_id")

    @property
    @pulumi.getter(name="deploymentTimestamp")
    def deployment_timestamp(self) -> str:
        """
        Gets or sets the deployment timestamp.
        """
        return pulumi.get(self, "deployment_timestamp")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Gets or sets the name of deployed resources.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Gets or sets the ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isCleanUpDone")
    def is_clean_up_done(self) -> bool:
        """
        Gets or sets a value indicating whether resources are cleaned up from target.
        """
        return pulumi.get(self, "is_clean_up_done")

    @property
    @pulumi.getter(name="isTestMigration")
    def is_test_migration(self) -> bool:
        """
        Gets or sets a value indicating whether scenario is test migration.
        """
        return pulumi.get(self, "is_test_migration")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Gets or sets the status of deployed resources.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Gets or sets the type of deployed resources.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class DirectoryPathResponse(dict):
    """
    Second level entity for virtual directories.
    """
    def __init__(__self__, *,
                 id: str,
                 physical: Optional[str] = None,
                 virtual: Optional[str] = None):
        """
        Second level entity for virtual directories.
        :param str id: Gets the ID.
        :param str physical: Gets or sets the physical path of the directory on the web server.
        :param str virtual: Gets or sets the virtual path for the directory.
        """
        pulumi.set(__self__, "id", id)
        if physical is not None:
            pulumi.set(__self__, "physical", physical)
        if virtual is not None:
            pulumi.set(__self__, "virtual", virtual)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Gets the ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def physical(self) -> Optional[str]:
        """
        Gets or sets the physical path of the directory on the web server.
        """
        return pulumi.get(self, "physical")

    @property
    @pulumi.getter
    def virtual(self) -> Optional[str]:
        """
        Gets or sets the virtual path for the directory.
        """
        return pulumi.get(self, "virtual")


@pulumi.output_type
class GmsaAuthenticationPropertiesResponse(dict):
    """
    Class for GMSA authentication details to configure Active Directory connectivity.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "configurationState":
            suggest = "configuration_state"
        elif key == "gmsaCredSpecName":
            suggest = "gmsa_cred_spec_name"
        elif key == "gmsaSecretName":
            suggest = "gmsa_secret_name"
        elif key == "adDomainControllerDns":
            suggest = "ad_domain_controller_dns"
        elif key == "adDomainFqdn":
            suggest = "ad_domain_fqdn"
        elif key == "akvProperties":
            suggest = "akv_properties"
        elif key == "domainAdminPassword":
            suggest = "domain_admin_password"
        elif key == "domainAdminUsername":
            suggest = "domain_admin_username"
        elif key == "domainControllerAddress":
            suggest = "domain_controller_address"
        elif key == "gmsaAccountName":
            suggest = "gmsa_account_name"
        elif key == "gmsaUserPassword":
            suggest = "gmsa_user_password"
        elif key == "gmsaUsername":
            suggest = "gmsa_username"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GmsaAuthenticationPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GmsaAuthenticationPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GmsaAuthenticationPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 configuration_state: str,
                 gmsa_cred_spec_name: str,
                 gmsa_secret_name: str,
                 ad_domain_controller_dns: Optional[str] = None,
                 ad_domain_fqdn: Optional[str] = None,
                 akv_properties: Optional['outputs.KeyVaultSecretStorePropertiesResponse'] = None,
                 domain_admin_password: Optional[str] = None,
                 domain_admin_username: Optional[str] = None,
                 domain_controller_address: Optional[str] = None,
                 gmsa_account_name: Optional[str] = None,
                 gmsa_user_password: Optional[str] = None,
                 gmsa_username: Optional[str] = None):
        """
        Class for GMSA authentication details to configure Active Directory connectivity.
        :param str configuration_state: Gets or sets the current state of GMSA configuration.
        :param str gmsa_cred_spec_name: Gets Cred Spec Name to be used.
        :param str gmsa_secret_name: Gets name of the secret where GMSA secret is stored in the KeyVault.
        :param str ad_domain_controller_dns: Gets or sets the list of dns server that can resolve the Active Directory Domain Name/Address.
        :param str ad_domain_fqdn: Gets or sets the FQDN of the Active Directory Domain. For e.g. 'contoso.local', 'fareast.corp.microsoft.com' etc.
        :param str domain_admin_password: Gets or sets the password of the user specified by RestApi.Controllers.V2022_05_01_preview.Models.WorkloadDeployment.Gmsa.GmsaAuthenticationProperties.DomainAdminUsername.
        :param str domain_admin_username: Gets or sets the name of the user having admin rights on the Active Directory Domain Controller.
        :param str domain_controller_address: Gets or sets the address of the Active Directory Domain Controller running Domain Services.
        :param str gmsa_account_name: Gets or sets the name to be used for GMSA.
        :param str gmsa_user_password: Gets or sets the password of the user specified by RestApi.Controllers.V2022_05_01_preview.Models.WorkloadDeployment.Gmsa.GmsaAuthenticationProperties.GmsaUsername.
        :param str gmsa_username: Gets or sets username of the user having authorization to access GMSA on Active Directory.
        """
        pulumi.set(__self__, "configuration_state", configuration_state)
        pulumi.set(__self__, "gmsa_cred_spec_name", gmsa_cred_spec_name)
        pulumi.set(__self__, "gmsa_secret_name", gmsa_secret_name)
        if ad_domain_controller_dns is not None:
            pulumi.set(__self__, "ad_domain_controller_dns", ad_domain_controller_dns)
        if ad_domain_fqdn is not None:
            pulumi.set(__self__, "ad_domain_fqdn", ad_domain_fqdn)
        if akv_properties is not None:
            pulumi.set(__self__, "akv_properties", akv_properties)
        if domain_admin_password is not None:
            pulumi.set(__self__, "domain_admin_password", domain_admin_password)
        if domain_admin_username is not None:
            pulumi.set(__self__, "domain_admin_username", domain_admin_username)
        if domain_controller_address is not None:
            pulumi.set(__self__, "domain_controller_address", domain_controller_address)
        if gmsa_account_name is not None:
            pulumi.set(__self__, "gmsa_account_name", gmsa_account_name)
        if gmsa_user_password is not None:
            pulumi.set(__self__, "gmsa_user_password", gmsa_user_password)
        if gmsa_username is not None:
            pulumi.set(__self__, "gmsa_username", gmsa_username)

    @property
    @pulumi.getter(name="configurationState")
    def configuration_state(self) -> str:
        """
        Gets or sets the current state of GMSA configuration.
        """
        return pulumi.get(self, "configuration_state")

    @property
    @pulumi.getter(name="gmsaCredSpecName")
    def gmsa_cred_spec_name(self) -> str:
        """
        Gets Cred Spec Name to be used.
        """
        return pulumi.get(self, "gmsa_cred_spec_name")

    @property
    @pulumi.getter(name="gmsaSecretName")
    def gmsa_secret_name(self) -> str:
        """
        Gets name of the secret where GMSA secret is stored in the KeyVault.
        """
        return pulumi.get(self, "gmsa_secret_name")

    @property
    @pulumi.getter(name="adDomainControllerDns")
    def ad_domain_controller_dns(self) -> Optional[str]:
        """
        Gets or sets the list of dns server that can resolve the Active Directory Domain Name/Address.
        """
        return pulumi.get(self, "ad_domain_controller_dns")

    @property
    @pulumi.getter(name="adDomainFqdn")
    def ad_domain_fqdn(self) -> Optional[str]:
        """
        Gets or sets the FQDN of the Active Directory Domain. For e.g. 'contoso.local', 'fareast.corp.microsoft.com' etc.
        """
        return pulumi.get(self, "ad_domain_fqdn")

    @property
    @pulumi.getter(name="akvProperties")
    def akv_properties(self) -> Optional['outputs.KeyVaultSecretStorePropertiesResponse']:
        return pulumi.get(self, "akv_properties")

    @property
    @pulumi.getter(name="domainAdminPassword")
    def domain_admin_password(self) -> Optional[str]:
        """
        Gets or sets the password of the user specified by RestApi.Controllers.V2022_05_01_preview.Models.WorkloadDeployment.Gmsa.GmsaAuthenticationProperties.DomainAdminUsername.
        """
        return pulumi.get(self, "domain_admin_password")

    @property
    @pulumi.getter(name="domainAdminUsername")
    def domain_admin_username(self) -> Optional[str]:
        """
        Gets or sets the name of the user having admin rights on the Active Directory Domain Controller.
        """
        return pulumi.get(self, "domain_admin_username")

    @property
    @pulumi.getter(name="domainControllerAddress")
    def domain_controller_address(self) -> Optional[str]:
        """
        Gets or sets the address of the Active Directory Domain Controller running Domain Services.
        """
        return pulumi.get(self, "domain_controller_address")

    @property
    @pulumi.getter(name="gmsaAccountName")
    def gmsa_account_name(self) -> Optional[str]:
        """
        Gets or sets the name to be used for GMSA.
        """
        return pulumi.get(self, "gmsa_account_name")

    @property
    @pulumi.getter(name="gmsaUserPassword")
    def gmsa_user_password(self) -> Optional[str]:
        """
        Gets or sets the password of the user specified by RestApi.Controllers.V2022_05_01_preview.Models.WorkloadDeployment.Gmsa.GmsaAuthenticationProperties.GmsaUsername.
        """
        return pulumi.get(self, "gmsa_user_password")

    @property
    @pulumi.getter(name="gmsaUsername")
    def gmsa_username(self) -> Optional[str]:
        """
        Gets or sets username of the user having authorization to access GMSA on Active Directory.
        """
        return pulumi.get(self, "gmsa_username")


@pulumi.output_type
class HealthErrorModelResponse(dict):
    """
    Health error model.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "creationTime":
            suggest = "creation_time"
        elif key == "healthCategory":
            suggest = "health_category"
        elif key == "isCustomerResolvable":
            suggest = "is_customer_resolvable"
        elif key == "affectedResourceCorrelationIds":
            suggest = "affected_resource_correlation_ids"
        elif key == "affectedResourceType":
            suggest = "affected_resource_type"
        elif key == "childErrors":
            suggest = "child_errors"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HealthErrorModelResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HealthErrorModelResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HealthErrorModelResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 category: str,
                 causes: str,
                 code: str,
                 creation_time: str,
                 health_category: str,
                 id: str,
                 is_customer_resolvable: bool,
                 message: str,
                 recommendation: str,
                 severity: str,
                 source: str,
                 summary: str,
                 affected_resource_correlation_ids: Optional[Sequence[str]] = None,
                 affected_resource_type: Optional[str] = None,
                 child_errors: Optional[Sequence['outputs.InnerHealthErrorModelResponse']] = None):
        """
        Health error model.
        :param str category: Gets or sets the error category.
        :param str causes: Gets or sets possible causes of the error.
        :param str code: Gets or sets the error code.
        :param str creation_time: Gets or sets the error creation time.
        :param str health_category: Gets or sets the health category.
        :param str id: Gets the ID.
        :param bool is_customer_resolvable: Gets or sets a value indicating whether the error is customer resolvable.
        :param str message: Gets or sets the error message.
        :param str recommendation: Gets or sets recommended action to resolve the error.
        :param str severity: Gets or sets the error severity.
        :param str source: Gets or sets the error source.
        :param str summary: Gets or sets the error summary.
        :param Sequence[str] affected_resource_correlation_ids: Gets or sets the list of affected resource correlation Ids. This can be used to
               uniquely identify the count of items affected by a specific category and severity
               as well as count of item affected by an specific issue.
        :param str affected_resource_type: Gets or sets the type of affected resource type.
        :param Sequence['InnerHealthErrorModelResponse'] child_errors: Gets or sets a list of child health errors associated with this error.
        """
        pulumi.set(__self__, "category", category)
        pulumi.set(__self__, "causes", causes)
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "creation_time", creation_time)
        pulumi.set(__self__, "health_category", health_category)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_customer_resolvable", is_customer_resolvable)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "recommendation", recommendation)
        pulumi.set(__self__, "severity", severity)
        pulumi.set(__self__, "source", source)
        pulumi.set(__self__, "summary", summary)
        if affected_resource_correlation_ids is not None:
            pulumi.set(__self__, "affected_resource_correlation_ids", affected_resource_correlation_ids)
        if affected_resource_type is not None:
            pulumi.set(__self__, "affected_resource_type", affected_resource_type)
        if child_errors is not None:
            pulumi.set(__self__, "child_errors", child_errors)

    @property
    @pulumi.getter
    def category(self) -> str:
        """
        Gets or sets the error category.
        """
        return pulumi.get(self, "category")

    @property
    @pulumi.getter
    def causes(self) -> str:
        """
        Gets or sets possible causes of the error.
        """
        return pulumi.get(self, "causes")

    @property
    @pulumi.getter
    def code(self) -> str:
        """
        Gets or sets the error code.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> str:
        """
        Gets or sets the error creation time.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter(name="healthCategory")
    def health_category(self) -> str:
        """
        Gets or sets the health category.
        """
        return pulumi.get(self, "health_category")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Gets the ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isCustomerResolvable")
    def is_customer_resolvable(self) -> bool:
        """
        Gets or sets a value indicating whether the error is customer resolvable.
        """
        return pulumi.get(self, "is_customer_resolvable")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        Gets or sets the error message.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def recommendation(self) -> str:
        """
        Gets or sets recommended action to resolve the error.
        """
        return pulumi.get(self, "recommendation")

    @property
    @pulumi.getter
    def severity(self) -> str:
        """
        Gets or sets the error severity.
        """
        return pulumi.get(self, "severity")

    @property
    @pulumi.getter
    def source(self) -> str:
        """
        Gets or sets the error source.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter
    def summary(self) -> str:
        """
        Gets or sets the error summary.
        """
        return pulumi.get(self, "summary")

    @property
    @pulumi.getter(name="affectedResourceCorrelationIds")
    def affected_resource_correlation_ids(self) -> Optional[Sequence[str]]:
        """
        Gets or sets the list of affected resource correlation Ids. This can be used to
        uniquely identify the count of items affected by a specific category and severity
        as well as count of item affected by an specific issue.
        """
        return pulumi.get(self, "affected_resource_correlation_ids")

    @property
    @pulumi.getter(name="affectedResourceType")
    def affected_resource_type(self) -> Optional[str]:
        """
        Gets or sets the type of affected resource type.
        """
        return pulumi.get(self, "affected_resource_type")

    @property
    @pulumi.getter(name="childErrors")
    def child_errors(self) -> Optional[Sequence['outputs.InnerHealthErrorModelResponse']]:
        """
        Gets or sets a list of child health errors associated with this error.
        """
        return pulumi.get(self, "child_errors")


@pulumi.output_type
class IISAKSWorkloadDeploymentModelCustomPropertiesResponse(dict):
    """
    IIS workload instance model custom properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceType":
            suggest = "instance_type"
        elif key == "iisAksWorkloadDeploymentProperties":
            suggest = "iis_aks_workload_deployment_properties"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IISAKSWorkloadDeploymentModelCustomPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IISAKSWorkloadDeploymentModelCustomPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IISAKSWorkloadDeploymentModelCustomPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_type: str,
                 iis_aks_workload_deployment_properties: Optional['outputs.IISAKSWorkloadDeploymentResponse'] = None):
        """
        IIS workload instance model custom properties.
        :param str instance_type: Gets or sets the instance type.
               Expected value is 'IISAKSWorkloadDeploymentModelCustomProperties'.
        :param 'IISAKSWorkloadDeploymentResponse' iis_aks_workload_deployment_properties: IIS AKS workload deployment.
        """
        pulumi.set(__self__, "instance_type", 'IISAKSWorkloadDeploymentModelCustomProperties')
        if iis_aks_workload_deployment_properties is not None:
            pulumi.set(__self__, "iis_aks_workload_deployment_properties", iis_aks_workload_deployment_properties)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> str:
        """
        Gets or sets the instance type.
        Expected value is 'IISAKSWorkloadDeploymentModelCustomProperties'.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="iisAksWorkloadDeploymentProperties")
    def iis_aks_workload_deployment_properties(self) -> Optional['outputs.IISAKSWorkloadDeploymentResponse']:
        """
        IIS AKS workload deployment.
        """
        return pulumi.get(self, "iis_aks_workload_deployment_properties")


@pulumi.output_type
class IISAKSWorkloadDeploymentResponse(dict):
    """
    IIS AKS workload deployment.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deploymentHistory":
            suggest = "deployment_history"
        elif key == "authenticationProperties":
            suggest = "authentication_properties"
        elif key == "automationArtifactProperties":
            suggest = "automation_artifact_properties"
        elif key == "buildContainerImages":
            suggest = "build_container_images"
        elif key == "clusterProperties":
            suggest = "cluster_properties"
        elif key == "containerImageProperties":
            suggest = "container_image_properties"
        elif key == "deploymentNamePrefix":
            suggest = "deployment_name_prefix"
        elif key == "deploymentSpec":
            suggest = "deployment_spec"
        elif key == "monitoringProperties":
            suggest = "monitoring_properties"
        elif key == "targetPlatformIdentity":
            suggest = "target_platform_identity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IISAKSWorkloadDeploymentResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IISAKSWorkloadDeploymentResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IISAKSWorkloadDeploymentResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 deployment_history: Sequence['outputs.DeployedResourcesPropertiesResponse'],
                 authentication_properties: Optional['outputs.GmsaAuthenticationPropertiesResponse'] = None,
                 automation_artifact_properties: Optional['outputs.AutomationArtifactResponse'] = None,
                 bindings: Optional[Sequence['outputs.BindingResponse']] = None,
                 build_container_images: Optional[Sequence['outputs.ContainerImagePropertiesResponse']] = None,
                 cluster_properties: Optional['outputs.AKSDeploymentPropertiesResponse'] = None,
                 configurations: Optional[Sequence['outputs.WebApplicationConfigurationResponse']] = None,
                 container_image_properties: Optional['outputs.ContainerImagePropertiesResponse'] = None,
                 deployment_name_prefix: Optional[str] = None,
                 deployment_spec: Optional['outputs.AKSDeploymentSpecificationResponse'] = None,
                 directories: Optional[Sequence['outputs.WebApplicationDirectoryResponse']] = None,
                 limits: Optional['outputs.ResourceRequirementsResponse'] = None,
                 monitoring_properties: Optional['outputs.AppInsightMonitoringPropertiesResponse'] = None,
                 requests: Optional['outputs.ResourceRequirementsResponse'] = None,
                 target_platform_identity: Optional[str] = None):
        """
        IIS AKS workload deployment.
        :param Sequence['DeployedResourcesPropertiesResponse'] deployment_history: Gets or sets the deployment history.
        :param 'GmsaAuthenticationPropertiesResponse' authentication_properties: Class for GMSA authentication details to configure Active Directory connectivity.
        :param 'AutomationArtifactResponse' automation_artifact_properties: Class for automation artifact.
        :param Sequence['BindingResponse'] bindings: Gets or sets the bindings for the application.
        :param Sequence['ContainerImagePropertiesResponse'] build_container_images: Gets or sets the build container images.
        :param 'AKSDeploymentPropertiesResponse' cluster_properties: Class for AKSDeployment Properties.
        :param Sequence['WebApplicationConfigurationResponse'] configurations: Gets or sets application configuration.
        :param 'ContainerImagePropertiesResponse' container_image_properties: Class for container image properties.
        :param str deployment_name_prefix: Gets or sets the deployment name prefix.
        :param 'AKSDeploymentSpecificationResponse' deployment_spec: AKS Deployment Specification.
        :param Sequence['WebApplicationDirectoryResponse'] directories: Gets or sets application directories.
        :param 'ResourceRequirementsResponse' limits: Resource Requirements.
        :param 'AppInsightMonitoringPropertiesResponse' monitoring_properties: Class for app insight monitoring properties.
        :param 'ResourceRequirementsResponse' requests: Resource Requirements.
        :param str target_platform_identity: Gets or sets the target platform managed identity.
        """
        pulumi.set(__self__, "deployment_history", deployment_history)
        if authentication_properties is not None:
            pulumi.set(__self__, "authentication_properties", authentication_properties)
        if automation_artifact_properties is not None:
            pulumi.set(__self__, "automation_artifact_properties", automation_artifact_properties)
        if bindings is not None:
            pulumi.set(__self__, "bindings", bindings)
        if build_container_images is not None:
            pulumi.set(__self__, "build_container_images", build_container_images)
        if cluster_properties is not None:
            pulumi.set(__self__, "cluster_properties", cluster_properties)
        if configurations is not None:
            pulumi.set(__self__, "configurations", configurations)
        if container_image_properties is not None:
            pulumi.set(__self__, "container_image_properties", container_image_properties)
        if deployment_name_prefix is not None:
            pulumi.set(__self__, "deployment_name_prefix", deployment_name_prefix)
        if deployment_spec is not None:
            pulumi.set(__self__, "deployment_spec", deployment_spec)
        if directories is not None:
            pulumi.set(__self__, "directories", directories)
        if limits is not None:
            pulumi.set(__self__, "limits", limits)
        if monitoring_properties is not None:
            pulumi.set(__self__, "monitoring_properties", monitoring_properties)
        if requests is not None:
            pulumi.set(__self__, "requests", requests)
        if target_platform_identity is not None:
            pulumi.set(__self__, "target_platform_identity", target_platform_identity)

    @property
    @pulumi.getter(name="deploymentHistory")
    def deployment_history(self) -> Sequence['outputs.DeployedResourcesPropertiesResponse']:
        """
        Gets or sets the deployment history.
        """
        return pulumi.get(self, "deployment_history")

    @property
    @pulumi.getter(name="authenticationProperties")
    def authentication_properties(self) -> Optional['outputs.GmsaAuthenticationPropertiesResponse']:
        """
        Class for GMSA authentication details to configure Active Directory connectivity.
        """
        return pulumi.get(self, "authentication_properties")

    @property
    @pulumi.getter(name="automationArtifactProperties")
    def automation_artifact_properties(self) -> Optional['outputs.AutomationArtifactResponse']:
        """
        Class for automation artifact.
        """
        return pulumi.get(self, "automation_artifact_properties")

    @property
    @pulumi.getter
    def bindings(self) -> Optional[Sequence['outputs.BindingResponse']]:
        """
        Gets or sets the bindings for the application.
        """
        return pulumi.get(self, "bindings")

    @property
    @pulumi.getter(name="buildContainerImages")
    def build_container_images(self) -> Optional[Sequence['outputs.ContainerImagePropertiesResponse']]:
        """
        Gets or sets the build container images.
        """
        return pulumi.get(self, "build_container_images")

    @property
    @pulumi.getter(name="clusterProperties")
    def cluster_properties(self) -> Optional['outputs.AKSDeploymentPropertiesResponse']:
        """
        Class for AKSDeployment Properties.
        """
        return pulumi.get(self, "cluster_properties")

    @property
    @pulumi.getter
    def configurations(self) -> Optional[Sequence['outputs.WebApplicationConfigurationResponse']]:
        """
        Gets or sets application configuration.
        """
        return pulumi.get(self, "configurations")

    @property
    @pulumi.getter(name="containerImageProperties")
    def container_image_properties(self) -> Optional['outputs.ContainerImagePropertiesResponse']:
        """
        Class for container image properties.
        """
        return pulumi.get(self, "container_image_properties")

    @property
    @pulumi.getter(name="deploymentNamePrefix")
    def deployment_name_prefix(self) -> Optional[str]:
        """
        Gets or sets the deployment name prefix.
        """
        return pulumi.get(self, "deployment_name_prefix")

    @property
    @pulumi.getter(name="deploymentSpec")
    def deployment_spec(self) -> Optional['outputs.AKSDeploymentSpecificationResponse']:
        """
        AKS Deployment Specification.
        """
        return pulumi.get(self, "deployment_spec")

    @property
    @pulumi.getter
    def directories(self) -> Optional[Sequence['outputs.WebApplicationDirectoryResponse']]:
        """
        Gets or sets application directories.
        """
        return pulumi.get(self, "directories")

    @property
    @pulumi.getter
    def limits(self) -> Optional['outputs.ResourceRequirementsResponse']:
        """
        Resource Requirements.
        """
        return pulumi.get(self, "limits")

    @property
    @pulumi.getter(name="monitoringProperties")
    def monitoring_properties(self) -> Optional['outputs.AppInsightMonitoringPropertiesResponse']:
        """
        Class for app insight monitoring properties.
        """
        return pulumi.get(self, "monitoring_properties")

    @property
    @pulumi.getter
    def requests(self) -> Optional['outputs.ResourceRequirementsResponse']:
        """
        Resource Requirements.
        """
        return pulumi.get(self, "requests")

    @property
    @pulumi.getter(name="targetPlatformIdentity")
    def target_platform_identity(self) -> Optional[str]:
        """
        Gets or sets the target platform managed identity.
        """
        return pulumi.get(self, "target_platform_identity")


@pulumi.output_type
class IISApplicationDetailsResponse(dict):
    """
    IISApplication details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "applicationPoolName":
            suggest = "application_pool_name"
        elif key == "enable32BitApiOnWin64":
            suggest = "enable32_bit_api_on_win64"
        elif key == "managedPipelineMode":
            suggest = "managed_pipeline_mode"
        elif key == "runtimeVersion":
            suggest = "runtime_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IISApplicationDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IISApplicationDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IISApplicationDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 application_pool_name: Optional[str] = None,
                 directories: Optional[Sequence['outputs.DirectoryPathResponse']] = None,
                 enable32_bit_api_on_win64: Optional[bool] = None,
                 managed_pipeline_mode: Optional[str] = None,
                 path: Optional['outputs.DirectoryPathResponse'] = None,
                 runtime_version: Optional[str] = None):
        """
        IISApplication details.
        :param str id: Gets the ID.
        :param str application_pool_name: Gets or sets the application pool name.
        :param Sequence['DirectoryPathResponse'] directories: Gets or sets the list of directories.
        :param bool enable32_bit_api_on_win64: Gets or sets a value indicating whether 32 bit applications are allowed to run on 64 bit.
        :param str managed_pipeline_mode: Gets or sets the managed pipeline mode.
        :param 'DirectoryPathResponse' path: Second level entity for virtual directories.
        :param str runtime_version: Gets or sets the runtime version.
        """
        pulumi.set(__self__, "id", id)
        if application_pool_name is not None:
            pulumi.set(__self__, "application_pool_name", application_pool_name)
        if directories is not None:
            pulumi.set(__self__, "directories", directories)
        if enable32_bit_api_on_win64 is not None:
            pulumi.set(__self__, "enable32_bit_api_on_win64", enable32_bit_api_on_win64)
        if managed_pipeline_mode is not None:
            pulumi.set(__self__, "managed_pipeline_mode", managed_pipeline_mode)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if runtime_version is not None:
            pulumi.set(__self__, "runtime_version", runtime_version)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Gets the ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="applicationPoolName")
    def application_pool_name(self) -> Optional[str]:
        """
        Gets or sets the application pool name.
        """
        return pulumi.get(self, "application_pool_name")

    @property
    @pulumi.getter
    def directories(self) -> Optional[Sequence['outputs.DirectoryPathResponse']]:
        """
        Gets or sets the list of directories.
        """
        return pulumi.get(self, "directories")

    @property
    @pulumi.getter(name="enable32BitApiOnWin64")
    def enable32_bit_api_on_win64(self) -> Optional[bool]:
        """
        Gets or sets a value indicating whether 32 bit applications are allowed to run on 64 bit.
        """
        return pulumi.get(self, "enable32_bit_api_on_win64")

    @property
    @pulumi.getter(name="managedPipelineMode")
    def managed_pipeline_mode(self) -> Optional[str]:
        """
        Gets or sets the managed pipeline mode.
        """
        return pulumi.get(self, "managed_pipeline_mode")

    @property
    @pulumi.getter
    def path(self) -> Optional['outputs.DirectoryPathResponse']:
        """
        Second level entity for virtual directories.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="runtimeVersion")
    def runtime_version(self) -> Optional[str]:
        """
        Gets or sets the runtime version.
        """
        return pulumi.get(self, "runtime_version")


@pulumi.output_type
class IISVirtualApplicationDetailsResponse(dict):
    """
    IIS virtual application details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isVirtualDirectory":
            suggest = "is_virtual_directory"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IISVirtualApplicationDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IISVirtualApplicationDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IISVirtualApplicationDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 is_virtual_directory: bool,
                 directories: Optional[Sequence['outputs.DirectoryPathResponse']] = None,
                 path: Optional['outputs.DirectoryPathResponse'] = None):
        """
        IIS virtual application details.
        :param str id: Gets the ID.
        :param bool is_virtual_directory: Gets a value indicating whether the application corresponds to a directory.
        :param Sequence['DirectoryPathResponse'] directories: Gets or sets the list of directories.
        :param 'DirectoryPathResponse' path: Second level entity for virtual directories.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_virtual_directory", is_virtual_directory)
        if directories is not None:
            pulumi.set(__self__, "directories", directories)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Gets the ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isVirtualDirectory")
    def is_virtual_directory(self) -> bool:
        """
        Gets a value indicating whether the application corresponds to a directory.
        """
        return pulumi.get(self, "is_virtual_directory")

    @property
    @pulumi.getter
    def directories(self) -> Optional[Sequence['outputs.DirectoryPathResponse']]:
        """
        Gets or sets the list of directories.
        """
        return pulumi.get(self, "directories")

    @property
    @pulumi.getter
    def path(self) -> Optional['outputs.DirectoryPathResponse']:
        """
        Second level entity for virtual directories.
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class IISWebApplicationResponse(dict):
    """
    IISWeb application.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "applicationId":
            suggest = "application_id"
        elif key == "applicationName":
            suggest = "application_name"
        elif key == "applicationScratchPath":
            suggest = "application_scratch_path"
        elif key == "discoveredFrameworks":
            suggest = "discovered_frameworks"
        elif key == "displayName":
            suggest = "display_name"
        elif key == "iisWebServer":
            suggest = "iis_web_server"
        elif key == "primaryFramework":
            suggest = "primary_framework"
        elif key == "virtualApplications":
            suggest = "virtual_applications"
        elif key == "webServerId":
            suggest = "web_server_id"
        elif key == "webServerName":
            suggest = "web_server_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IISWebApplicationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IISWebApplicationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IISWebApplicationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 application_id: Optional[str] = None,
                 application_name: Optional[str] = None,
                 application_scratch_path: Optional[str] = None,
                 applications: Optional[Sequence['outputs.IISApplicationDetailsResponse']] = None,
                 bindings: Optional[Sequence['outputs.BindingResponse']] = None,
                 configurations: Optional[Sequence['outputs.WebApplicationConfigurationResponse']] = None,
                 directories: Optional[Sequence['outputs.WebApplicationDirectoryResponse']] = None,
                 discovered_frameworks: Optional[Sequence['outputs.WebApplicationFrameworkResponse']] = None,
                 display_name: Optional[str] = None,
                 iis_web_server: Optional['outputs.IISWebServerResponse'] = None,
                 limits: Optional['outputs.ResourceRequirementsResponse'] = None,
                 path: Optional['outputs.DirectoryPathResponse'] = None,
                 primary_framework: Optional['outputs.WebApplicationFrameworkResponse'] = None,
                 requests: Optional['outputs.ResourceRequirementsResponse'] = None,
                 virtual_applications: Optional[Sequence['outputs.IISVirtualApplicationDetailsResponse']] = None,
                 web_server_id: Optional[str] = None,
                 web_server_name: Optional[str] = None):
        """
        IISWeb application.
        :param str application_id: Gets or sets the web application id.
        :param str application_name: Gets or sets the web application name.
        :param str application_scratch_path: Gets or sets application scratch path.
        :param Sequence['IISApplicationDetailsResponse'] applications: Gets or sets the list of applications for the IIS web site.
        :param Sequence['BindingResponse'] bindings: Gets or sets the bindings for the application.
        :param Sequence['WebApplicationConfigurationResponse'] configurations: Gets or sets application configuration.
        :param Sequence['WebApplicationDirectoryResponse'] directories: Gets or sets application directories.
        :param Sequence['WebApplicationFrameworkResponse'] discovered_frameworks: Gets or sets the discovered frameworks of application.
        :param str display_name: Gets or sets the display name.
        :param 'IISWebServerResponse' iis_web_server: IISWeb server.
        :param 'ResourceRequirementsResponse' limits: Resource Requirements.
        :param 'DirectoryPathResponse' path: Second level entity for virtual directories.
        :param 'WebApplicationFrameworkResponse' primary_framework: Framework specific data for a web application.
        :param 'ResourceRequirementsResponse' requests: Resource Requirements.
        :param Sequence['IISVirtualApplicationDetailsResponse'] virtual_applications: Gets or sets the list of application units for the web site.
        :param str web_server_id: Gets or sets the web server id.
        :param str web_server_name: Gets or sets the web server name.
        """
        if application_id is not None:
            pulumi.set(__self__, "application_id", application_id)
        if application_name is not None:
            pulumi.set(__self__, "application_name", application_name)
        if application_scratch_path is not None:
            pulumi.set(__self__, "application_scratch_path", application_scratch_path)
        if applications is not None:
            pulumi.set(__self__, "applications", applications)
        if bindings is not None:
            pulumi.set(__self__, "bindings", bindings)
        if configurations is not None:
            pulumi.set(__self__, "configurations", configurations)
        if directories is not None:
            pulumi.set(__self__, "directories", directories)
        if discovered_frameworks is not None:
            pulumi.set(__self__, "discovered_frameworks", discovered_frameworks)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if iis_web_server is not None:
            pulumi.set(__self__, "iis_web_server", iis_web_server)
        if limits is not None:
            pulumi.set(__self__, "limits", limits)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if primary_framework is not None:
            pulumi.set(__self__, "primary_framework", primary_framework)
        if requests is not None:
            pulumi.set(__self__, "requests", requests)
        if virtual_applications is not None:
            pulumi.set(__self__, "virtual_applications", virtual_applications)
        if web_server_id is not None:
            pulumi.set(__self__, "web_server_id", web_server_id)
        if web_server_name is not None:
            pulumi.set(__self__, "web_server_name", web_server_name)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> Optional[str]:
        """
        Gets or sets the web application id.
        """
        return pulumi.get(self, "application_id")

    @property
    @pulumi.getter(name="applicationName")
    def application_name(self) -> Optional[str]:
        """
        Gets or sets the web application name.
        """
        return pulumi.get(self, "application_name")

    @property
    @pulumi.getter(name="applicationScratchPath")
    def application_scratch_path(self) -> Optional[str]:
        """
        Gets or sets application scratch path.
        """
        return pulumi.get(self, "application_scratch_path")

    @property
    @pulumi.getter
    def applications(self) -> Optional[Sequence['outputs.IISApplicationDetailsResponse']]:
        """
        Gets or sets the list of applications for the IIS web site.
        """
        return pulumi.get(self, "applications")

    @property
    @pulumi.getter
    def bindings(self) -> Optional[Sequence['outputs.BindingResponse']]:
        """
        Gets or sets the bindings for the application.
        """
        return pulumi.get(self, "bindings")

    @property
    @pulumi.getter
    def configurations(self) -> Optional[Sequence['outputs.WebApplicationConfigurationResponse']]:
        """
        Gets or sets application configuration.
        """
        return pulumi.get(self, "configurations")

    @property
    @pulumi.getter
    def directories(self) -> Optional[Sequence['outputs.WebApplicationDirectoryResponse']]:
        """
        Gets or sets application directories.
        """
        return pulumi.get(self, "directories")

    @property
    @pulumi.getter(name="discoveredFrameworks")
    def discovered_frameworks(self) -> Optional[Sequence['outputs.WebApplicationFrameworkResponse']]:
        """
        Gets or sets the discovered frameworks of application.
        """
        return pulumi.get(self, "discovered_frameworks")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        Gets or sets the display name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="iisWebServer")
    def iis_web_server(self) -> Optional['outputs.IISWebServerResponse']:
        """
        IISWeb server.
        """
        return pulumi.get(self, "iis_web_server")

    @property
    @pulumi.getter
    def limits(self) -> Optional['outputs.ResourceRequirementsResponse']:
        """
        Resource Requirements.
        """
        return pulumi.get(self, "limits")

    @property
    @pulumi.getter
    def path(self) -> Optional['outputs.DirectoryPathResponse']:
        """
        Second level entity for virtual directories.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="primaryFramework")
    def primary_framework(self) -> Optional['outputs.WebApplicationFrameworkResponse']:
        """
        Framework specific data for a web application.
        """
        return pulumi.get(self, "primary_framework")

    @property
    @pulumi.getter
    def requests(self) -> Optional['outputs.ResourceRequirementsResponse']:
        """
        Resource Requirements.
        """
        return pulumi.get(self, "requests")

    @property
    @pulumi.getter(name="virtualApplications")
    def virtual_applications(self) -> Optional[Sequence['outputs.IISVirtualApplicationDetailsResponse']]:
        """
        Gets or sets the list of application units for the web site.
        """
        return pulumi.get(self, "virtual_applications")

    @property
    @pulumi.getter(name="webServerId")
    def web_server_id(self) -> Optional[str]:
        """
        Gets or sets the web server id.
        """
        return pulumi.get(self, "web_server_id")

    @property
    @pulumi.getter(name="webServerName")
    def web_server_name(self) -> Optional[str]:
        """
        Gets or sets the web server name.
        """
        return pulumi.get(self, "web_server_name")


@pulumi.output_type
class IISWebServerResponse(dict):
    """
    IISWeb server.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"
        elif key == "ipAddresses":
            suggest = "ip_addresses"
        elif key == "operatingSystemDetails":
            suggest = "operating_system_details"
        elif key == "rootConfigurationLocation":
            suggest = "root_configuration_location"
        elif key == "runAsAccountId":
            suggest = "run_as_account_id"
        elif key == "serverFqdn":
            suggest = "server_fqdn"
        elif key == "serverId":
            suggest = "server_id"
        elif key == "serverName":
            suggest = "server_name"
        elif key == "webApplications":
            suggest = "web_applications"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IISWebServerResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IISWebServerResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IISWebServerResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 display_name: Optional[str] = None,
                 ip_addresses: Optional[Sequence[str]] = None,
                 machines: Optional[Sequence[str]] = None,
                 operating_system_details: Optional['outputs.OperatingSystemDetailsResponse'] = None,
                 root_configuration_location: Optional[str] = None,
                 run_as_account_id: Optional[str] = None,
                 server_fqdn: Optional[str] = None,
                 server_id: Optional[str] = None,
                 server_name: Optional[str] = None,
                 version: Optional[str] = None,
                 web_applications: Optional[Sequence[str]] = None):
        """
        IISWeb server.
        :param str display_name: Gets or sets the display name.
        :param Sequence[str] ip_addresses: Gets or sets list of ip addresses.
        :param Sequence[str] machines: Gets or sets the list of machines.
        :param str root_configuration_location: Gets or sets the server root configuration location.
        :param str run_as_account_id: Gets or sets the run as account id.
        :param str server_fqdn: Gets or sets the server FQDN.
        :param str server_id: Gets or sets the web server id.
        :param str server_name: Gets or sets the web server name.
        :param str version: Gets or sets the server version.
        :param Sequence[str] web_applications: Gets or sets the list of web applications.
        """
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if ip_addresses is not None:
            pulumi.set(__self__, "ip_addresses", ip_addresses)
        if machines is not None:
            pulumi.set(__self__, "machines", machines)
        if operating_system_details is not None:
            pulumi.set(__self__, "operating_system_details", operating_system_details)
        if root_configuration_location is not None:
            pulumi.set(__self__, "root_configuration_location", root_configuration_location)
        if run_as_account_id is not None:
            pulumi.set(__self__, "run_as_account_id", run_as_account_id)
        if server_fqdn is not None:
            pulumi.set(__self__, "server_fqdn", server_fqdn)
        if server_id is not None:
            pulumi.set(__self__, "server_id", server_id)
        if server_name is not None:
            pulumi.set(__self__, "server_name", server_name)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if web_applications is not None:
            pulumi.set(__self__, "web_applications", web_applications)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        Gets or sets the display name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Optional[Sequence[str]]:
        """
        Gets or sets list of ip addresses.
        """
        return pulumi.get(self, "ip_addresses")

    @property
    @pulumi.getter
    def machines(self) -> Optional[Sequence[str]]:
        """
        Gets or sets the list of machines.
        """
        return pulumi.get(self, "machines")

    @property
    @pulumi.getter(name="operatingSystemDetails")
    def operating_system_details(self) -> Optional['outputs.OperatingSystemDetailsResponse']:
        return pulumi.get(self, "operating_system_details")

    @property
    @pulumi.getter(name="rootConfigurationLocation")
    def root_configuration_location(self) -> Optional[str]:
        """
        Gets or sets the server root configuration location.
        """
        return pulumi.get(self, "root_configuration_location")

    @property
    @pulumi.getter(name="runAsAccountId")
    def run_as_account_id(self) -> Optional[str]:
        """
        Gets or sets the run as account id.
        """
        return pulumi.get(self, "run_as_account_id")

    @property
    @pulumi.getter(name="serverFqdn")
    def server_fqdn(self) -> Optional[str]:
        """
        Gets or sets the server FQDN.
        """
        return pulumi.get(self, "server_fqdn")

    @property
    @pulumi.getter(name="serverId")
    def server_id(self) -> Optional[str]:
        """
        Gets or sets the web server id.
        """
        return pulumi.get(self, "server_id")

    @property
    @pulumi.getter(name="serverName")
    def server_name(self) -> Optional[str]:
        """
        Gets or sets the web server name.
        """
        return pulumi.get(self, "server_name")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        Gets or sets the server version.
        """
        return pulumi.get(self, "version")

    @property
    @pulumi.getter(name="webApplications")
    def web_applications(self) -> Optional[Sequence[str]]:
        """
        Gets or sets the list of web applications.
        """
        return pulumi.get(self, "web_applications")


@pulumi.output_type
class IISWorkloadInstanceModelCustomPropertiesResponse(dict):
    """
    IIS workload instance model custom properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceType":
            suggest = "instance_type"
        elif key == "containerName":
            suggest = "container_name"
        elif key == "fileshareName":
            suggest = "fileshare_name"
        elif key == "iisWebApplication":
            suggest = "iis_web_application"
        elif key == "webAppArmId":
            suggest = "web_app_arm_id"
        elif key == "webAppSiteName":
            suggest = "web_app_site_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IISWorkloadInstanceModelCustomPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IISWorkloadInstanceModelCustomPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IISWorkloadInstanceModelCustomPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_type: str,
                 container_name: Optional[str] = None,
                 fileshare_name: Optional[str] = None,
                 iis_web_application: Optional['outputs.IISWebApplicationResponse'] = None,
                 web_app_arm_id: Optional[str] = None,
                 web_app_site_name: Optional[str] = None):
        """
        IIS workload instance model custom properties.
        :param str instance_type: Gets or sets the instance type.
               Expected value is 'IISWorkloadInstanceModelCustomProperties'.
        :param str container_name: Gets or sets the container Id.
        :param str fileshare_name: Gets or sets the fileshare name.
        :param 'IISWebApplicationResponse' iis_web_application: IISWeb application.
        :param str web_app_arm_id: Gets or sets the Web application ARM id.
        :param str web_app_site_name: Gets or sets the Web application site name.
        """
        pulumi.set(__self__, "instance_type", 'IISWorkloadInstanceModelCustomProperties')
        if container_name is not None:
            pulumi.set(__self__, "container_name", container_name)
        if fileshare_name is not None:
            pulumi.set(__self__, "fileshare_name", fileshare_name)
        if iis_web_application is not None:
            pulumi.set(__self__, "iis_web_application", iis_web_application)
        if web_app_arm_id is not None:
            pulumi.set(__self__, "web_app_arm_id", web_app_arm_id)
        if web_app_site_name is not None:
            pulumi.set(__self__, "web_app_site_name", web_app_site_name)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> str:
        """
        Gets or sets the instance type.
        Expected value is 'IISWorkloadInstanceModelCustomProperties'.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> Optional[str]:
        """
        Gets or sets the container Id.
        """
        return pulumi.get(self, "container_name")

    @property
    @pulumi.getter(name="fileshareName")
    def fileshare_name(self) -> Optional[str]:
        """
        Gets or sets the fileshare name.
        """
        return pulumi.get(self, "fileshare_name")

    @property
    @pulumi.getter(name="iisWebApplication")
    def iis_web_application(self) -> Optional['outputs.IISWebApplicationResponse']:
        """
        IISWeb application.
        """
        return pulumi.get(self, "iis_web_application")

    @property
    @pulumi.getter(name="webAppArmId")
    def web_app_arm_id(self) -> Optional[str]:
        """
        Gets or sets the Web application ARM id.
        """
        return pulumi.get(self, "web_app_arm_id")

    @property
    @pulumi.getter(name="webAppSiteName")
    def web_app_site_name(self) -> Optional[str]:
        """
        Gets or sets the Web application site name.
        """
        return pulumi.get(self, "web_app_site_name")


@pulumi.output_type
class IdentityModelResponse(dict):
    """
    Identity model.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "aadAuthority":
            suggest = "aad_authority"
        elif key == "applicationId":
            suggest = "application_id"
        elif key == "objectId":
            suggest = "object_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IdentityModelResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IdentityModelResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IdentityModelResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 aad_authority: Optional[str] = None,
                 application_id: Optional[str] = None,
                 audience: Optional[str] = None,
                 object_id: Optional[str] = None,
                 tenant_id: Optional[str] = None):
        """
        Identity model.
        :param str aad_authority: Gets or sets the authority of the SPN with which MigrateAgent communicates to service.
        :param str application_id: Gets or sets the client/application Id of the SPN with which MigrateAgent communicates to
               service.
        :param str audience: Gets or sets the audience of the SPN with which MigrateAgent communicates to service.
        :param str object_id: Gets or sets the object Id of the SPN with which MigrateAgent communicates to service.
        :param str tenant_id: Gets or sets the tenant Id of the SPN with which MigrateAgent communicates to service.
        """
        if aad_authority is not None:
            pulumi.set(__self__, "aad_authority", aad_authority)
        if application_id is not None:
            pulumi.set(__self__, "application_id", application_id)
        if audience is not None:
            pulumi.set(__self__, "audience", audience)
        if object_id is not None:
            pulumi.set(__self__, "object_id", object_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="aadAuthority")
    def aad_authority(self) -> Optional[str]:
        """
        Gets or sets the authority of the SPN with which MigrateAgent communicates to service.
        """
        return pulumi.get(self, "aad_authority")

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> Optional[str]:
        """
        Gets or sets the client/application Id of the SPN with which MigrateAgent communicates to
        service.
        """
        return pulumi.get(self, "application_id")

    @property
    @pulumi.getter
    def audience(self) -> Optional[str]:
        """
        Gets or sets the audience of the SPN with which MigrateAgent communicates to service.
        """
        return pulumi.get(self, "audience")

    @property
    @pulumi.getter(name="objectId")
    def object_id(self) -> Optional[str]:
        """
        Gets or sets the object Id of the SPN with which MigrateAgent communicates to service.
        """
        return pulumi.get(self, "object_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[str]:
        """
        Gets or sets the tenant Id of the SPN with which MigrateAgent communicates to service.
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class InnerHealthErrorModelResponse(dict):
    """
    Inner health error model.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "creationTime":
            suggest = "creation_time"
        elif key == "healthCategory":
            suggest = "health_category"
        elif key == "isCustomerResolvable":
            suggest = "is_customer_resolvable"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InnerHealthErrorModelResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InnerHealthErrorModelResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InnerHealthErrorModelResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 category: str,
                 causes: str,
                 code: str,
                 creation_time: str,
                 health_category: str,
                 id: str,
                 is_customer_resolvable: bool,
                 message: str,
                 recommendation: str,
                 severity: str,
                 source: str,
                 summary: str):
        """
        Inner health error model.
        :param str category: Gets or sets the error category.
        :param str causes: Gets or sets possible causes of the error.
        :param str code: Gets or sets the error code.
        :param str creation_time: Gets or sets the error creation time.
        :param str health_category: Gets or sets the health category.
        :param str id: Gets the ID.
        :param bool is_customer_resolvable: Gets or sets a value indicating whether the error is customer resolvable.
        :param str message: Gets or sets the error message.
        :param str recommendation: Gets or sets recommended action to resolve the error.
        :param str severity: Gets or sets the error severity.
        :param str source: Gets or sets the error source.
        :param str summary: Gets or sets the error summary.
        """
        pulumi.set(__self__, "category", category)
        pulumi.set(__self__, "causes", causes)
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "creation_time", creation_time)
        pulumi.set(__self__, "health_category", health_category)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_customer_resolvable", is_customer_resolvable)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "recommendation", recommendation)
        pulumi.set(__self__, "severity", severity)
        pulumi.set(__self__, "source", source)
        pulumi.set(__self__, "summary", summary)

    @property
    @pulumi.getter
    def category(self) -> str:
        """
        Gets or sets the error category.
        """
        return pulumi.get(self, "category")

    @property
    @pulumi.getter
    def causes(self) -> str:
        """
        Gets or sets possible causes of the error.
        """
        return pulumi.get(self, "causes")

    @property
    @pulumi.getter
    def code(self) -> str:
        """
        Gets or sets the error code.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> str:
        """
        Gets or sets the error creation time.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter(name="healthCategory")
    def health_category(self) -> str:
        """
        Gets or sets the health category.
        """
        return pulumi.get(self, "health_category")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Gets the ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isCustomerResolvable")
    def is_customer_resolvable(self) -> bool:
        """
        Gets or sets a value indicating whether the error is customer resolvable.
        """
        return pulumi.get(self, "is_customer_resolvable")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        Gets or sets the error message.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def recommendation(self) -> str:
        """
        Gets or sets recommended action to resolve the error.
        """
        return pulumi.get(self, "recommendation")

    @property
    @pulumi.getter
    def severity(self) -> str:
        """
        Gets or sets the error severity.
        """
        return pulumi.get(self, "severity")

    @property
    @pulumi.getter
    def source(self) -> str:
        """
        Gets or sets the error source.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter
    def summary(self) -> str:
        """
        Gets or sets the error summary.
        """
        return pulumi.get(self, "summary")


@pulumi.output_type
class KeyVaultSecretStorePropertiesResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "inputType":
            suggest = "input_type"
        elif key == "keyvaultName":
            suggest = "keyvault_name"
        elif key == "managedIdentityProperties":
            suggest = "managed_identity_properties"
        elif key == "resourceGroup":
            suggest = "resource_group"
        elif key == "secretStoreId":
            suggest = "secret_store_id"
        elif key == "subscriptionId":
            suggest = "subscription_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KeyVaultSecretStorePropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KeyVaultSecretStorePropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KeyVaultSecretStorePropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 input_type: str,
                 keyvault_name: Optional[str] = None,
                 managed_identity_properties: Optional['outputs.ManagedIdentityPropertiesResponse'] = None,
                 resource_group: Optional[str] = None,
                 secret_store_id: Optional[str] = None,
                 subscription_id: Optional[str] = None,
                 tenant_id: Optional[str] = None):
        pulumi.set(__self__, "input_type", input_type)
        if keyvault_name is not None:
            pulumi.set(__self__, "keyvault_name", keyvault_name)
        if managed_identity_properties is not None:
            pulumi.set(__self__, "managed_identity_properties", managed_identity_properties)
        if resource_group is not None:
            pulumi.set(__self__, "resource_group", resource_group)
        if secret_store_id is not None:
            pulumi.set(__self__, "secret_store_id", secret_store_id)
        if subscription_id is not None:
            pulumi.set(__self__, "subscription_id", subscription_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="inputType")
    def input_type(self) -> str:
        return pulumi.get(self, "input_type")

    @property
    @pulumi.getter(name="keyvaultName")
    def keyvault_name(self) -> Optional[str]:
        return pulumi.get(self, "keyvault_name")

    @property
    @pulumi.getter(name="managedIdentityProperties")
    def managed_identity_properties(self) -> Optional['outputs.ManagedIdentityPropertiesResponse']:
        return pulumi.get(self, "managed_identity_properties")

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> Optional[str]:
        return pulumi.get(self, "resource_group")

    @property
    @pulumi.getter(name="secretStoreId")
    def secret_store_id(self) -> Optional[str]:
        return pulumi.get(self, "secret_store_id")

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> Optional[str]:
        return pulumi.get(self, "subscription_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[str]:
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class ManagedIdentityPropertiesResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "managedIdentityName":
            suggest = "managed_identity_name"
        elif key == "principalId":
            suggest = "principal_id"
        elif key == "resourceGroup":
            suggest = "resource_group"
        elif key == "subscriptionId":
            suggest = "subscription_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedIdentityPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedIdentityPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedIdentityPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: Optional[str] = None,
                 managed_identity_name: Optional[str] = None,
                 principal_id: Optional[str] = None,
                 resource_group: Optional[str] = None,
                 subscription_id: Optional[str] = None,
                 tenant_id: Optional[str] = None):
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if managed_identity_name is not None:
            pulumi.set(__self__, "managed_identity_name", managed_identity_name)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if resource_group is not None:
            pulumi.set(__self__, "resource_group", resource_group)
        if subscription_id is not None:
            pulumi.set(__self__, "subscription_id", subscription_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[str]:
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="managedIdentityName")
    def managed_identity_name(self) -> Optional[str]:
        return pulumi.get(self, "managed_identity_name")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[str]:
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> Optional[str]:
        return pulumi.get(self, "resource_group")

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> Optional[str]:
        return pulumi.get(self, "subscription_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[str]:
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class MigrateAgentModelPropertiesResponse(dict):
    """
    MigrateAgent model properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "correlationId":
            suggest = "correlation_id"
        elif key == "healthErrors":
            suggest = "health_errors"
        elif key == "isResponsive":
            suggest = "is_responsive"
        elif key == "lastHeartbeat":
            suggest = "last_heartbeat"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "versionNumber":
            suggest = "version_number"
        elif key == "authenticationIdentity":
            suggest = "authentication_identity"
        elif key == "customProperties":
            suggest = "custom_properties"
        elif key == "machineId":
            suggest = "machine_id"
        elif key == "machineName":
            suggest = "machine_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrateAgentModelPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrateAgentModelPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrateAgentModelPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 correlation_id: str,
                 health_errors: Sequence['outputs.HealthErrorModelResponse'],
                 is_responsive: bool,
                 last_heartbeat: str,
                 provisioning_state: str,
                 version_number: str,
                 authentication_identity: Optional['outputs.IdentityModelResponse'] = None,
                 custom_properties: Optional['outputs.VMwareMigrateAgentModelCustomPropertiesResponse'] = None,
                 machine_id: Optional[str] = None,
                 machine_name: Optional[str] = None):
        """
        MigrateAgent model properties.
        :param str correlation_id: Gets or sets the MigrateAgent correlation Id.
        :param Sequence['HealthErrorModelResponse'] health_errors: Gets or sets the list of health errors.
        :param bool is_responsive: Gets or sets a value indicating whether MigrateAgent is responsive.
        :param str last_heartbeat: Gets or sets the time when last heartbeat was sent by the MigrateAgent.
        :param str provisioning_state: Gets or sets the provisioning state of the MigrateAgent.
        :param str version_number: Gets or sets the MigrateAgent version.
        :param 'IdentityModelResponse' authentication_identity: Identity model.
        :param 'VMwareMigrateAgentModelCustomPropertiesResponse' custom_properties: MigrateAgent model custom properties.
        :param str machine_id: Gets or sets the machine Id where MigrateAgent is running.
        :param str machine_name: Gets or sets the machine name where MigrateAgent is running.
        """
        pulumi.set(__self__, "correlation_id", correlation_id)
        pulumi.set(__self__, "health_errors", health_errors)
        pulumi.set(__self__, "is_responsive", is_responsive)
        pulumi.set(__self__, "last_heartbeat", last_heartbeat)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "version_number", version_number)
        if authentication_identity is not None:
            pulumi.set(__self__, "authentication_identity", authentication_identity)
        if custom_properties is not None:
            pulumi.set(__self__, "custom_properties", custom_properties)
        if machine_id is not None:
            pulumi.set(__self__, "machine_id", machine_id)
        if machine_name is not None:
            pulumi.set(__self__, "machine_name", machine_name)

    @property
    @pulumi.getter(name="correlationId")
    def correlation_id(self) -> str:
        """
        Gets or sets the MigrateAgent correlation Id.
        """
        return pulumi.get(self, "correlation_id")

    @property
    @pulumi.getter(name="healthErrors")
    def health_errors(self) -> Sequence['outputs.HealthErrorModelResponse']:
        """
        Gets or sets the list of health errors.
        """
        return pulumi.get(self, "health_errors")

    @property
    @pulumi.getter(name="isResponsive")
    def is_responsive(self) -> bool:
        """
        Gets or sets a value indicating whether MigrateAgent is responsive.
        """
        return pulumi.get(self, "is_responsive")

    @property
    @pulumi.getter(name="lastHeartbeat")
    def last_heartbeat(self) -> str:
        """
        Gets or sets the time when last heartbeat was sent by the MigrateAgent.
        """
        return pulumi.get(self, "last_heartbeat")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        Gets or sets the provisioning state of the MigrateAgent.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="versionNumber")
    def version_number(self) -> str:
        """
        Gets or sets the MigrateAgent version.
        """
        return pulumi.get(self, "version_number")

    @property
    @pulumi.getter(name="authenticationIdentity")
    def authentication_identity(self) -> Optional['outputs.IdentityModelResponse']:
        """
        Identity model.
        """
        return pulumi.get(self, "authentication_identity")

    @property
    @pulumi.getter(name="customProperties")
    def custom_properties(self) -> Optional['outputs.VMwareMigrateAgentModelCustomPropertiesResponse']:
        """
        MigrateAgent model custom properties.
        """
        return pulumi.get(self, "custom_properties")

    @property
    @pulumi.getter(name="machineId")
    def machine_id(self) -> Optional[str]:
        """
        Gets or sets the machine Id where MigrateAgent is running.
        """
        return pulumi.get(self, "machine_id")

    @property
    @pulumi.getter(name="machineName")
    def machine_name(self) -> Optional[str]:
        """
        Gets or sets the machine name where MigrateAgent is running.
        """
        return pulumi.get(self, "machine_name")


@pulumi.output_type
class MigrateAgentModelResponseSystemData(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "createdBy":
            suggest = "created_by"
        elif key == "createdByType":
            suggest = "created_by_type"
        elif key == "lastModifiedAt":
            suggest = "last_modified_at"
        elif key == "lastModifiedBy":
            suggest = "last_modified_by"
        elif key == "lastModifiedByType":
            suggest = "last_modified_by_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrateAgentModelResponseSystemData. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrateAgentModelResponseSystemData.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrateAgentModelResponseSystemData.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: Optional[str] = None,
                 created_by: Optional[str] = None,
                 created_by_type: Optional[str] = None,
                 last_modified_at: Optional[str] = None,
                 last_modified_by: Optional[str] = None,
                 last_modified_by_type: Optional[str] = None):
        """
        :param str created_at: Gets or sets the timestamp of resource creation (UTC).
        :param str created_by: Gets or sets identity that created the resource.
        :param str created_by_type: Gets or sets the type of identity that created the resource: user, application,
               managedIdentity.
        :param str last_modified_at: Gets or sets the timestamp of resource last modification (UTC).
        :param str last_modified_by: Gets or sets the identity that last modified the resource.
        :param str last_modified_by_type: Gets or sets the type of identity that last modified the resource: user, application,
               managedIdentity.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_by_type is not None:
            pulumi.set(__self__, "created_by_type", created_by_type)
        if last_modified_at is not None:
            pulumi.set(__self__, "last_modified_at", last_modified_at)
        if last_modified_by is not None:
            pulumi.set(__self__, "last_modified_by", last_modified_by)
        if last_modified_by_type is not None:
            pulumi.set(__self__, "last_modified_by_type", last_modified_by_type)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        Gets or sets the timestamp of resource creation (UTC).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[str]:
        """
        Gets or sets identity that created the resource.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="createdByType")
    def created_by_type(self) -> Optional[str]:
        """
        Gets or sets the type of identity that created the resource: user, application,
        managedIdentity.
        """
        return pulumi.get(self, "created_by_type")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> Optional[str]:
        """
        Gets or sets the timestamp of resource last modification (UTC).
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> Optional[str]:
        """
        Gets or sets the identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by")

    @property
    @pulumi.getter(name="lastModifiedByType")
    def last_modified_by_type(self) -> Optional[str]:
        """
        Gets or sets the type of identity that last modified the resource: user, application,
        managedIdentity.
        """
        return pulumi.get(self, "last_modified_by_type")


@pulumi.output_type
class MigrationConfigurationResponse(dict):
    """
    MigrationConfiguration properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyVaultResourceId":
            suggest = "key_vault_resource_id"
        elif key == "migrationSolutionResourceId":
            suggest = "migration_solution_resource_id"
        elif key == "storageAccountResourceId":
            suggest = "storage_account_resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MigrationConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MigrationConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MigrationConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_vault_resource_id: Optional[str] = None,
                 migration_solution_resource_id: Optional[str] = None,
                 storage_account_resource_id: Optional[str] = None):
        """
        MigrationConfiguration properties.
        :param str key_vault_resource_id: Gets or sets the key vault resource Id.
        :param str migration_solution_resource_id: Gets or sets the migration solution resource Id.
        :param str storage_account_resource_id: Gets or sets the storage account resource Id.
        """
        if key_vault_resource_id is not None:
            pulumi.set(__self__, "key_vault_resource_id", key_vault_resource_id)
        if migration_solution_resource_id is not None:
            pulumi.set(__self__, "migration_solution_resource_id", migration_solution_resource_id)
        if storage_account_resource_id is not None:
            pulumi.set(__self__, "storage_account_resource_id", storage_account_resource_id)

    @property
    @pulumi.getter(name="keyVaultResourceId")
    def key_vault_resource_id(self) -> Optional[str]:
        """
        Gets or sets the key vault resource Id.
        """
        return pulumi.get(self, "key_vault_resource_id")

    @property
    @pulumi.getter(name="migrationSolutionResourceId")
    def migration_solution_resource_id(self) -> Optional[str]:
        """
        Gets or sets the migration solution resource Id.
        """
        return pulumi.get(self, "migration_solution_resource_id")

    @property
    @pulumi.getter(name="storageAccountResourceId")
    def storage_account_resource_id(self) -> Optional[str]:
        """
        Gets or sets the storage account resource Id.
        """
        return pulumi.get(self, "storage_account_resource_id")


@pulumi.output_type
class ModernizeProjectModelPropertiesResponse(dict):
    """
    ModernizeProject properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "serviceEndpoint":
            suggest = "service_endpoint"
        elif key == "serviceResourceId":
            suggest = "service_resource_id"
        elif key == "migrationConfiguration":
            suggest = "migration_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModernizeProjectModelPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModernizeProjectModelPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModernizeProjectModelPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 provisioning_state: str,
                 service_endpoint: str,
                 service_resource_id: str,
                 migration_configuration: Optional['outputs.MigrationConfigurationResponse'] = None):
        """
        ModernizeProject properties.
        :param str provisioning_state: Gets or sets the provisioning state of the ModernizeProject.
        :param str service_endpoint: Gets or sets the service endpoint.
        :param str service_resource_id: Gets or sets the service resource Id.
        :param 'MigrationConfigurationResponse' migration_configuration: MigrationConfiguration properties.
        """
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "service_endpoint", service_endpoint)
        pulumi.set(__self__, "service_resource_id", service_resource_id)
        if migration_configuration is not None:
            pulumi.set(__self__, "migration_configuration", migration_configuration)

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        Gets or sets the provisioning state of the ModernizeProject.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="serviceEndpoint")
    def service_endpoint(self) -> str:
        """
        Gets or sets the service endpoint.
        """
        return pulumi.get(self, "service_endpoint")

    @property
    @pulumi.getter(name="serviceResourceId")
    def service_resource_id(self) -> str:
        """
        Gets or sets the service resource Id.
        """
        return pulumi.get(self, "service_resource_id")

    @property
    @pulumi.getter(name="migrationConfiguration")
    def migration_configuration(self) -> Optional['outputs.MigrationConfigurationResponse']:
        """
        MigrationConfiguration properties.
        """
        return pulumi.get(self, "migration_configuration")


@pulumi.output_type
class ModernizeProjectModelResponseSystemData(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "createdBy":
            suggest = "created_by"
        elif key == "createdByType":
            suggest = "created_by_type"
        elif key == "lastModifiedAt":
            suggest = "last_modified_at"
        elif key == "lastModifiedBy":
            suggest = "last_modified_by"
        elif key == "lastModifiedByType":
            suggest = "last_modified_by_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModernizeProjectModelResponseSystemData. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModernizeProjectModelResponseSystemData.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModernizeProjectModelResponseSystemData.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: Optional[str] = None,
                 created_by: Optional[str] = None,
                 created_by_type: Optional[str] = None,
                 last_modified_at: Optional[str] = None,
                 last_modified_by: Optional[str] = None,
                 last_modified_by_type: Optional[str] = None):
        """
        :param str created_at: Gets or sets the timestamp of resource creation (UTC).
        :param str created_by: Gets or sets identity that created the resource.
        :param str created_by_type: Gets or sets the type of identity that created the resource: user, application,
               managedIdentity.
        :param str last_modified_at: Gets or sets the timestamp of resource last modification (UTC).
        :param str last_modified_by: Gets or sets the identity that last modified the resource.
        :param str last_modified_by_type: Gets or sets the type of identity that last modified the resource: user, application,
               managedIdentity.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_by_type is not None:
            pulumi.set(__self__, "created_by_type", created_by_type)
        if last_modified_at is not None:
            pulumi.set(__self__, "last_modified_at", last_modified_at)
        if last_modified_by is not None:
            pulumi.set(__self__, "last_modified_by", last_modified_by)
        if last_modified_by_type is not None:
            pulumi.set(__self__, "last_modified_by_type", last_modified_by_type)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        Gets or sets the timestamp of resource creation (UTC).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[str]:
        """
        Gets or sets identity that created the resource.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="createdByType")
    def created_by_type(self) -> Optional[str]:
        """
        Gets or sets the type of identity that created the resource: user, application,
        managedIdentity.
        """
        return pulumi.get(self, "created_by_type")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> Optional[str]:
        """
        Gets or sets the timestamp of resource last modification (UTC).
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> Optional[str]:
        """
        Gets or sets the identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by")

    @property
    @pulumi.getter(name="lastModifiedByType")
    def last_modified_by_type(self) -> Optional[str]:
        """
        Gets or sets the type of identity that last modified the resource: user, application,
        managedIdentity.
        """
        return pulumi.get(self, "last_modified_by_type")


@pulumi.output_type
class OperatingSystemDetailsResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "osArchitecture":
            suggest = "os_architecture"
        elif key == "osName":
            suggest = "os_name"
        elif key == "osVersion":
            suggest = "os_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OperatingSystemDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OperatingSystemDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OperatingSystemDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 os: Optional[str] = None,
                 os_architecture: Optional[str] = None,
                 os_name: Optional[str] = None,
                 os_version: Optional[str] = None):
        if os is not None:
            pulumi.set(__self__, "os", os)
        if os_architecture is not None:
            pulumi.set(__self__, "os_architecture", os_architecture)
        if os_name is not None:
            pulumi.set(__self__, "os_name", os_name)
        if os_version is not None:
            pulumi.set(__self__, "os_version", os_version)

    @property
    @pulumi.getter
    def os(self) -> Optional[str]:
        return pulumi.get(self, "os")

    @property
    @pulumi.getter(name="osArchitecture")
    def os_architecture(self) -> Optional[str]:
        return pulumi.get(self, "os_architecture")

    @property
    @pulumi.getter(name="osName")
    def os_name(self) -> Optional[str]:
        return pulumi.get(self, "os_name")

    @property
    @pulumi.getter(name="osVersion")
    def os_version(self) -> Optional[str]:
        return pulumi.get(self, "os_version")


@pulumi.output_type
class PortMappingResponse(dict):
    """
    WebApplication port mapping.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "externalPort":
            suggest = "external_port"
        elif key == "internalPort":
            suggest = "internal_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PortMappingResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PortMappingResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PortMappingResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 external_port: Optional[int] = None,
                 internal_port: Optional[int] = None):
        """
        WebApplication port mapping.
        :param int external_port: Gets or sets the External Port.
        :param int internal_port: Gets or sets the Internal Port.
        """
        if external_port is not None:
            pulumi.set(__self__, "external_port", external_port)
        if internal_port is not None:
            pulumi.set(__self__, "internal_port", internal_port)

    @property
    @pulumi.getter(name="externalPort")
    def external_port(self) -> Optional[int]:
        """
        Gets or sets the External Port.
        """
        return pulumi.get(self, "external_port")

    @property
    @pulumi.getter(name="internalPort")
    def internal_port(self) -> Optional[int]:
        """
        Gets or sets the Internal Port.
        """
        return pulumi.get(self, "internal_port")


@pulumi.output_type
class ResourceIdentityResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"
        elif key == "userAssignedIdentities":
            suggest = "user_assigned_identities"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceIdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceIdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceIdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 principal_id: Optional[str] = None,
                 tenant_id: Optional[str] = None,
                 type: Optional[str] = None,
                 user_assigned_identities: Optional[Mapping[str, 'outputs.UserAssignedIdentityResponse']] = None):
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_assigned_identities is not None:
            pulumi.set(__self__, "user_assigned_identities", user_assigned_identities)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[str]:
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[str]:
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="userAssignedIdentities")
    def user_assigned_identities(self) -> Optional[Mapping[str, 'outputs.UserAssignedIdentityResponse']]:
        return pulumi.get(self, "user_assigned_identities")


@pulumi.output_type
class ResourceRequirementsResponse(dict):
    """
    Resource Requirements.
    """
    def __init__(__self__, *,
                 cpu: Optional[str] = None,
                 memory: Optional[str] = None):
        """
        Resource Requirements.
        :param str cpu: Gets or sets the Cpu requirement.
        :param str memory: Gets or sets the Memory requirement.
        """
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if memory is not None:
            pulumi.set(__self__, "memory", memory)

    @property
    @pulumi.getter
    def cpu(self) -> Optional[str]:
        """
        Gets or sets the Cpu requirement.
        """
        return pulumi.get(self, "cpu")

    @property
    @pulumi.getter
    def memory(self) -> Optional[str]:
        """
        Gets or sets the Memory requirement.
        """
        return pulumi.get(self, "memory")


@pulumi.output_type
class SecretStoreDetailsResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretStore":
            suggest = "secret_store"
        elif key == "secretStoreProperties":
            suggest = "secret_store_properties"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretStoreDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretStoreDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretStoreDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 secret_store: Optional[str] = None,
                 secret_store_properties: Optional['outputs.SecretStorePropertiesResponse'] = None):
        if secret_store is not None:
            pulumi.set(__self__, "secret_store", secret_store)
        if secret_store_properties is not None:
            pulumi.set(__self__, "secret_store_properties", secret_store_properties)

    @property
    @pulumi.getter(name="secretStore")
    def secret_store(self) -> Optional[str]:
        return pulumi.get(self, "secret_store")

    @property
    @pulumi.getter(name="secretStoreProperties")
    def secret_store_properties(self) -> Optional['outputs.SecretStorePropertiesResponse']:
        return pulumi.get(self, "secret_store_properties")


@pulumi.output_type
class SecretStorePropertiesResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "inputType":
            suggest = "input_type"
        elif key == "secretStoreId":
            suggest = "secret_store_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretStorePropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretStorePropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretStorePropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 input_type: str,
                 secret_store_id: Optional[str] = None):
        pulumi.set(__self__, "input_type", input_type)
        if secret_store_id is not None:
            pulumi.set(__self__, "secret_store_id", secret_store_id)

    @property
    @pulumi.getter(name="inputType")
    def input_type(self) -> str:
        return pulumi.get(self, "input_type")

    @property
    @pulumi.getter(name="secretStoreId")
    def secret_store_id(self) -> Optional[str]:
        return pulumi.get(self, "secret_store_id")


@pulumi.output_type
class TargetStorageProfileResponse(dict):
    """
    Storage profile for the directory on the target container.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "azureFileShareProfile":
            suggest = "azure_file_share_profile"
        elif key == "hydrationStorageProviderType":
            suggest = "hydration_storage_provider_type"
        elif key == "persistentVolumeId":
            suggest = "persistent_volume_id"
        elif key == "storageAccessType":
            suggest = "storage_access_type"
        elif key == "storageProjectionType":
            suggest = "storage_projection_type"
        elif key == "targetName":
            suggest = "target_name"
        elif key == "targetSize":
            suggest = "target_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TargetStorageProfileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TargetStorageProfileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TargetStorageProfileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 azure_file_share_profile: Optional['outputs.AzureFileShareHydrationProfileResponse'] = None,
                 hydration_storage_provider_type: Optional[str] = None,
                 persistent_volume_id: Optional[str] = None,
                 storage_access_type: Optional[str] = None,
                 storage_projection_type: Optional[str] = None,
                 target_name: Optional[str] = None,
                 target_size: Optional[str] = None):
        """
        Storage profile for the directory on the target container.
        :param 'AzureFileShareHydrationProfileResponse' azure_file_share_profile: Azure file share profile for hydration of application folders not mounted on
               the container file system.
        :param str hydration_storage_provider_type: Gets or sets the storage provider type on the target.
               Applicable when StorageProjectionType is not ContainerFileSystem.
        :param str persistent_volume_id: Gets or sets the target persistent volume id.
               Applicable when StorageProjectionType is PersistentVolume and on using an
               existing PersistentVolume.
        :param str storage_access_type: Gets or sets the target storage access type.
        :param str storage_projection_type: Gets or sets the target projection type.
        :param str target_name: Gets or sets the name of the projected volume on the target environment.
        :param str target_size: Gets or sets the storage size on the target.
               Applicable when StorageProjectionType is PersistentVolume and on creating a new
               PersistentVolume.
        """
        if azure_file_share_profile is not None:
            pulumi.set(__self__, "azure_file_share_profile", azure_file_share_profile)
        if hydration_storage_provider_type is not None:
            pulumi.set(__self__, "hydration_storage_provider_type", hydration_storage_provider_type)
        if persistent_volume_id is not None:
            pulumi.set(__self__, "persistent_volume_id", persistent_volume_id)
        if storage_access_type is not None:
            pulumi.set(__self__, "storage_access_type", storage_access_type)
        if storage_projection_type is not None:
            pulumi.set(__self__, "storage_projection_type", storage_projection_type)
        if target_name is not None:
            pulumi.set(__self__, "target_name", target_name)
        if target_size is not None:
            pulumi.set(__self__, "target_size", target_size)

    @property
    @pulumi.getter(name="azureFileShareProfile")
    def azure_file_share_profile(self) -> Optional['outputs.AzureFileShareHydrationProfileResponse']:
        """
        Azure file share profile for hydration of application folders not mounted on
        the container file system.
        """
        return pulumi.get(self, "azure_file_share_profile")

    @property
    @pulumi.getter(name="hydrationStorageProviderType")
    def hydration_storage_provider_type(self) -> Optional[str]:
        """
        Gets or sets the storage provider type on the target.
        Applicable when StorageProjectionType is not ContainerFileSystem.
        """
        return pulumi.get(self, "hydration_storage_provider_type")

    @property
    @pulumi.getter(name="persistentVolumeId")
    def persistent_volume_id(self) -> Optional[str]:
        """
        Gets or sets the target persistent volume id.
        Applicable when StorageProjectionType is PersistentVolume and on using an
        existing PersistentVolume.
        """
        return pulumi.get(self, "persistent_volume_id")

    @property
    @pulumi.getter(name="storageAccessType")
    def storage_access_type(self) -> Optional[str]:
        """
        Gets or sets the target storage access type.
        """
        return pulumi.get(self, "storage_access_type")

    @property
    @pulumi.getter(name="storageProjectionType")
    def storage_projection_type(self) -> Optional[str]:
        """
        Gets or sets the target projection type.
        """
        return pulumi.get(self, "storage_projection_type")

    @property
    @pulumi.getter(name="targetName")
    def target_name(self) -> Optional[str]:
        """
        Gets or sets the name of the projected volume on the target environment.
        """
        return pulumi.get(self, "target_name")

    @property
    @pulumi.getter(name="targetSize")
    def target_size(self) -> Optional[str]:
        """
        Gets or sets the storage size on the target.
        Applicable when StorageProjectionType is PersistentVolume and on creating a new
        PersistentVolume.
        """
        return pulumi.get(self, "target_size")


@pulumi.output_type
class UserAssignedIdentityResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "principalId":
            suggest = "principal_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserAssignedIdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserAssignedIdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserAssignedIdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: Optional[str] = None,
                 principal_id: Optional[str] = None):
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[str]:
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[str]:
        return pulumi.get(self, "principal_id")


@pulumi.output_type
class VMwareMigrateAgentModelCustomPropertiesResponse(dict):
    """
    VMware MigrateAgent model custom properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceType":
            suggest = "instance_type"
        elif key == "fabricFriendlyName":
            suggest = "fabric_friendly_name"
        elif key == "vmwareSiteId":
            suggest = "vmware_site_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VMwareMigrateAgentModelCustomPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VMwareMigrateAgentModelCustomPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VMwareMigrateAgentModelCustomPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_type: str,
                 fabric_friendly_name: Optional[str] = None,
                 vmware_site_id: Optional[str] = None):
        """
        VMware MigrateAgent model custom properties.
        :param str instance_type: Gets or sets the instance type.
               Expected value is 'VMwareMigrateAgentModelCustomProperties'.
        :param str fabric_friendly_name: Gets or sets the friendly name of the,of the MigrateAgent fabric.
        :param str vmware_site_id: Gets or sets the master Site Id of the Migrate Agent.
        """
        pulumi.set(__self__, "instance_type", 'VMwareMigrateAgentModelCustomProperties')
        if fabric_friendly_name is not None:
            pulumi.set(__self__, "fabric_friendly_name", fabric_friendly_name)
        if vmware_site_id is not None:
            pulumi.set(__self__, "vmware_site_id", vmware_site_id)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> str:
        """
        Gets or sets the instance type.
        Expected value is 'VMwareMigrateAgentModelCustomProperties'.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="fabricFriendlyName")
    def fabric_friendly_name(self) -> Optional[str]:
        """
        Gets or sets the friendly name of the,of the MigrateAgent fabric.
        """
        return pulumi.get(self, "fabric_friendly_name")

    @property
    @pulumi.getter(name="vmwareSiteId")
    def vmware_site_id(self) -> Optional[str]:
        """
        Gets or sets the master Site Id of the Migrate Agent.
        """
        return pulumi.get(self, "vmware_site_id")


@pulumi.output_type
class WebApplicationConfigurationResponse(dict):
    """
    Class for web application configurations.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "filePath":
            suggest = "file_path"
        elif key == "isDeploymentTimeEditable":
            suggest = "is_deployment_time_editable"
        elif key == "localFilePath":
            suggest = "local_file_path"
        elif key == "secretStoreDetails":
            suggest = "secret_store_details"
        elif key == "targetFilePath":
            suggest = "target_file_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebApplicationConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebApplicationConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebApplicationConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 file_path: Optional[str] = None,
                 identifier: Optional[str] = None,
                 is_deployment_time_editable: Optional[bool] = None,
                 local_file_path: Optional[str] = None,
                 name: Optional[str] = None,
                 secret_store_details: Optional['outputs.SecretStoreDetailsResponse'] = None,
                 section: Optional[str] = None,
                 target_file_path: Optional[str] = None,
                 type: Optional[str] = None,
                 value: Optional[str] = None):
        """
        Class for web application configurations.
        :param str id: Gets the ID.
        :param str file_path: Gets or sets the configuration file path.
        :param str identifier: Gets or sets the identifier for the configuration.
        :param bool is_deployment_time_editable: Gets or sets a value indicating whether the configuration is edited or not by the user.
        :param str local_file_path: Gets or sets the configuration local file path.
        :param str name: Gets or sets the configuration name.
        :param str section: Gets or sets the configuration section in the file.
        :param str target_file_path: Gets or sets the configuration target file path.
        :param str type: Gets or sets the configuration type.
        :param str value: Gets or sets the configuration value.
        """
        pulumi.set(__self__, "id", id)
        if file_path is not None:
            pulumi.set(__self__, "file_path", file_path)
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)
        if is_deployment_time_editable is not None:
            pulumi.set(__self__, "is_deployment_time_editable", is_deployment_time_editable)
        if local_file_path is not None:
            pulumi.set(__self__, "local_file_path", local_file_path)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if secret_store_details is not None:
            pulumi.set(__self__, "secret_store_details", secret_store_details)
        if section is not None:
            pulumi.set(__self__, "section", section)
        if target_file_path is not None:
            pulumi.set(__self__, "target_file_path", target_file_path)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Gets the ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="filePath")
    def file_path(self) -> Optional[str]:
        """
        Gets or sets the configuration file path.
        """
        return pulumi.get(self, "file_path")

    @property
    @pulumi.getter
    def identifier(self) -> Optional[str]:
        """
        Gets or sets the identifier for the configuration.
        """
        return pulumi.get(self, "identifier")

    @property
    @pulumi.getter(name="isDeploymentTimeEditable")
    def is_deployment_time_editable(self) -> Optional[bool]:
        """
        Gets or sets a value indicating whether the configuration is edited or not by the user.
        """
        return pulumi.get(self, "is_deployment_time_editable")

    @property
    @pulumi.getter(name="localFilePath")
    def local_file_path(self) -> Optional[str]:
        """
        Gets or sets the configuration local file path.
        """
        return pulumi.get(self, "local_file_path")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Gets or sets the configuration name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="secretStoreDetails")
    def secret_store_details(self) -> Optional['outputs.SecretStoreDetailsResponse']:
        return pulumi.get(self, "secret_store_details")

    @property
    @pulumi.getter
    def section(self) -> Optional[str]:
        """
        Gets or sets the configuration section in the file.
        """
        return pulumi.get(self, "section")

    @property
    @pulumi.getter(name="targetFilePath")
    def target_file_path(self) -> Optional[str]:
        """
        Gets or sets the configuration target file path.
        """
        return pulumi.get(self, "target_file_path")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Gets or sets the configuration type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        Gets or sets the configuration value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class WebApplicationDirectoryResponse(dict):
    """
    WebApplication directory structure.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isEditable":
            suggest = "is_editable"
        elif key == "sourcePaths":
            suggest = "source_paths"
        elif key == "sourceSize":
            suggest = "source_size"
        elif key == "storageProfile":
            suggest = "storage_profile"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebApplicationDirectoryResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebApplicationDirectoryResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebApplicationDirectoryResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 is_editable: Optional[bool] = None,
                 source_paths: Optional[Sequence[str]] = None,
                 source_size: Optional[str] = None,
                 storage_profile: Optional['outputs.TargetStorageProfileResponse'] = None):
        """
        WebApplication directory structure.
        :param str id: Gets the unique id corresponding to the application directory.
        :param bool is_editable: Gets or sets a value indicating whether the directory object is editable.
               True when the directory is added as an optional directory, false when discovery is done
               manually.
        :param Sequence[str] source_paths: Gets or sets the paths of the directory on the source machine.
        :param str source_size: Gets or sets the size of the directory on the source machine.
        :param 'TargetStorageProfileResponse' storage_profile: Storage profile for the directory on the target container.
        """
        pulumi.set(__self__, "id", id)
        if is_editable is not None:
            pulumi.set(__self__, "is_editable", is_editable)
        if source_paths is not None:
            pulumi.set(__self__, "source_paths", source_paths)
        if source_size is not None:
            pulumi.set(__self__, "source_size", source_size)
        if storage_profile is not None:
            pulumi.set(__self__, "storage_profile", storage_profile)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Gets the unique id corresponding to the application directory.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isEditable")
    def is_editable(self) -> Optional[bool]:
        """
        Gets or sets a value indicating whether the directory object is editable.
        True when the directory is added as an optional directory, false when discovery is done
        manually.
        """
        return pulumi.get(self, "is_editable")

    @property
    @pulumi.getter(name="sourcePaths")
    def source_paths(self) -> Optional[Sequence[str]]:
        """
        Gets or sets the paths of the directory on the source machine.
        """
        return pulumi.get(self, "source_paths")

    @property
    @pulumi.getter(name="sourceSize")
    def source_size(self) -> Optional[str]:
        """
        Gets or sets the size of the directory on the source machine.
        """
        return pulumi.get(self, "source_size")

    @property
    @pulumi.getter(name="storageProfile")
    def storage_profile(self) -> Optional['outputs.TargetStorageProfileResponse']:
        """
        Storage profile for the directory on the target container.
        """
        return pulumi.get(self, "storage_profile")


@pulumi.output_type
class WebApplicationFrameworkResponse(dict):
    """
    Framework specific data for a web application.
    """
    def __init__(__self__, *,
                 id: str,
                 name: Optional[str] = None,
                 version: Optional[str] = None):
        """
        Framework specific data for a web application.
        :param str id: Gets the ID.
        :param str name: Gets or sets Name of the framework.
        :param str version: Gets or sets Version of the framework.
        """
        pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Gets the ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Gets or sets Name of the framework.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        Gets or sets Version of the framework.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class WorkloadDeploymentModelPropertiesResponse(dict):
    """
    Workload deployment model properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedOperations":
            suggest = "allowed_operations"
        elif key == "correlationId":
            suggest = "correlation_id"
        elif key == "currentJob":
            suggest = "current_job"
        elif key == "healthErrors":
            suggest = "health_errors"
        elif key == "lastSuccessfulMigrateTime":
            suggest = "last_successful_migrate_time"
        elif key == "lastSuccessfulTestMigrateTime":
            suggest = "last_successful_test_migrate_time"
        elif key == "migrationStatus":
            suggest = "migration_status"
        elif key == "migrationStatusDescription":
            suggest = "migration_status_description"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "statusDescription":
            suggest = "status_description"
        elif key == "testMigrationStatus":
            suggest = "test_migration_status"
        elif key == "testMigrationStatusDescription":
            suggest = "test_migration_status_description"
        elif key == "customProperties":
            suggest = "custom_properties"
        elif key == "displayName":
            suggest = "display_name"
        elif key == "targetPlatform":
            suggest = "target_platform"
        elif key == "workloadInstanceProperties":
            suggest = "workload_instance_properties"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkloadDeploymentModelPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkloadDeploymentModelPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkloadDeploymentModelPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_operations: Sequence[str],
                 correlation_id: str,
                 current_job: 'outputs.WorkloadDeploymentModelPropertiesResponseCurrentJob',
                 health_errors: Sequence['outputs.HealthErrorModelResponse'],
                 last_successful_migrate_time: str,
                 last_successful_test_migrate_time: str,
                 migration_status: str,
                 migration_status_description: str,
                 provisioning_state: str,
                 status: str,
                 status_description: str,
                 test_migration_status: str,
                 test_migration_status_description: str,
                 custom_properties: Optional[Any] = None,
                 display_name: Optional[str] = None,
                 target_platform: Optional[str] = None,
                 workload_instance_properties: Optional['outputs.WorkloadInstanceModelPropertiesResponse'] = None):
        """
        Workload deployment model properties.
        :param Sequence[str] allowed_operations: Gets or sets the allowed scenarios on the workload deployment.
        :param str correlation_id: Gets or sets the workload deployment correlation Id.
        :param Sequence['HealthErrorModelResponse'] health_errors: Gets or sets the list of health errors.
        :param str last_successful_migrate_time: Gets or sets the Last successful unplanned migrate time.
        :param str last_successful_test_migrate_time: Gets or sets the Last successful test migrate time.
        :param str migration_status: Gets or sets the migrate state.
        :param str migration_status_description: Gets or sets the migrate state description.
        :param str provisioning_state: Gets or sets the provisioning state of the workload deployment.
        :param str status: Gets or sets the workload deployment status.
        :param str status_description: Gets or sets the workload deployment status description.
        :param str test_migration_status: Gets or sets the test migrate state.
        :param str test_migration_status_description: Gets or sets the Test migrate state description.
        :param Union['ApacheTomcatAKSWorkloadDeploymentModelCustomPropertiesResponse', 'IISAKSWorkloadDeploymentModelCustomPropertiesResponse'] custom_properties: Workload deployment model custom properties.
        :param str display_name: Gets or sets the display name.
        :param str target_platform: Gets or sets the deployment target platform.
        :param 'WorkloadInstanceModelPropertiesResponse' workload_instance_properties: Workload instance model properties.
        """
        pulumi.set(__self__, "allowed_operations", allowed_operations)
        pulumi.set(__self__, "correlation_id", correlation_id)
        pulumi.set(__self__, "current_job", current_job)
        pulumi.set(__self__, "health_errors", health_errors)
        pulumi.set(__self__, "last_successful_migrate_time", last_successful_migrate_time)
        pulumi.set(__self__, "last_successful_test_migrate_time", last_successful_test_migrate_time)
        pulumi.set(__self__, "migration_status", migration_status)
        pulumi.set(__self__, "migration_status_description", migration_status_description)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "status_description", status_description)
        pulumi.set(__self__, "test_migration_status", test_migration_status)
        pulumi.set(__self__, "test_migration_status_description", test_migration_status_description)
        if custom_properties is not None:
            pulumi.set(__self__, "custom_properties", custom_properties)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if target_platform is not None:
            pulumi.set(__self__, "target_platform", target_platform)
        if workload_instance_properties is not None:
            pulumi.set(__self__, "workload_instance_properties", workload_instance_properties)

    @property
    @pulumi.getter(name="allowedOperations")
    def allowed_operations(self) -> Sequence[str]:
        """
        Gets or sets the allowed scenarios on the workload deployment.
        """
        return pulumi.get(self, "allowed_operations")

    @property
    @pulumi.getter(name="correlationId")
    def correlation_id(self) -> str:
        """
        Gets or sets the workload deployment correlation Id.
        """
        return pulumi.get(self, "correlation_id")

    @property
    @pulumi.getter(name="currentJob")
    def current_job(self) -> 'outputs.WorkloadDeploymentModelPropertiesResponseCurrentJob':
        return pulumi.get(self, "current_job")

    @property
    @pulumi.getter(name="healthErrors")
    def health_errors(self) -> Sequence['outputs.HealthErrorModelResponse']:
        """
        Gets or sets the list of health errors.
        """
        return pulumi.get(self, "health_errors")

    @property
    @pulumi.getter(name="lastSuccessfulMigrateTime")
    def last_successful_migrate_time(self) -> str:
        """
        Gets or sets the Last successful unplanned migrate time.
        """
        return pulumi.get(self, "last_successful_migrate_time")

    @property
    @pulumi.getter(name="lastSuccessfulTestMigrateTime")
    def last_successful_test_migrate_time(self) -> str:
        """
        Gets or sets the Last successful test migrate time.
        """
        return pulumi.get(self, "last_successful_test_migrate_time")

    @property
    @pulumi.getter(name="migrationStatus")
    def migration_status(self) -> str:
        """
        Gets or sets the migrate state.
        """
        return pulumi.get(self, "migration_status")

    @property
    @pulumi.getter(name="migrationStatusDescription")
    def migration_status_description(self) -> str:
        """
        Gets or sets the migrate state description.
        """
        return pulumi.get(self, "migration_status_description")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        Gets or sets the provisioning state of the workload deployment.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Gets or sets the workload deployment status.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="statusDescription")
    def status_description(self) -> str:
        """
        Gets or sets the workload deployment status description.
        """
        return pulumi.get(self, "status_description")

    @property
    @pulumi.getter(name="testMigrationStatus")
    def test_migration_status(self) -> str:
        """
        Gets or sets the test migrate state.
        """
        return pulumi.get(self, "test_migration_status")

    @property
    @pulumi.getter(name="testMigrationStatusDescription")
    def test_migration_status_description(self) -> str:
        """
        Gets or sets the Test migrate state description.
        """
        return pulumi.get(self, "test_migration_status_description")

    @property
    @pulumi.getter(name="customProperties")
    def custom_properties(self) -> Optional[Any]:
        """
        Workload deployment model custom properties.
        """
        return pulumi.get(self, "custom_properties")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        Gets or sets the display name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="targetPlatform")
    def target_platform(self) -> Optional[str]:
        """
        Gets or sets the deployment target platform.
        """
        return pulumi.get(self, "target_platform")

    @property
    @pulumi.getter(name="workloadInstanceProperties")
    def workload_instance_properties(self) -> Optional['outputs.WorkloadInstanceModelPropertiesResponse']:
        """
        Workload instance model properties.
        """
        return pulumi.get(self, "workload_instance_properties")


@pulumi.output_type
class WorkloadDeploymentModelPropertiesResponseCurrentJob(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"
        elif key == "endTime":
            suggest = "end_time"
        elif key == "scenarioName":
            suggest = "scenario_name"
        elif key == "startTime":
            suggest = "start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkloadDeploymentModelPropertiesResponseCurrentJob. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkloadDeploymentModelPropertiesResponseCurrentJob.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkloadDeploymentModelPropertiesResponseCurrentJob.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 display_name: str,
                 end_time: str,
                 id: str,
                 name: str,
                 scenario_name: str,
                 start_time: str,
                 state: str):
        """
        :param str display_name: Gets or sets the workflow friendly display name.
        :param str end_time: Gets or sets end time of the workflow.
        :param str id: Gets or sets workflow Id.
        :param str name: Gets or sets workflow name.
        :param str scenario_name: Gets or sets workload scenario name.
        :param str start_time: Gets or sets start time of the workflow.
        :param str state: Gets or sets workflow state.
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "scenario_name", scenario_name)
        pulumi.set(__self__, "start_time", start_time)
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Gets or sets the workflow friendly display name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> str:
        """
        Gets or sets end time of the workflow.
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Gets or sets workflow Id.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Gets or sets workflow name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="scenarioName")
    def scenario_name(self) -> str:
        """
        Gets or sets workload scenario name.
        """
        return pulumi.get(self, "scenario_name")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        Gets or sets start time of the workflow.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Gets or sets workflow state.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class WorkloadDeploymentModelResponseSystemData(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "createdBy":
            suggest = "created_by"
        elif key == "createdByType":
            suggest = "created_by_type"
        elif key == "lastModifiedAt":
            suggest = "last_modified_at"
        elif key == "lastModifiedBy":
            suggest = "last_modified_by"
        elif key == "lastModifiedByType":
            suggest = "last_modified_by_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkloadDeploymentModelResponseSystemData. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkloadDeploymentModelResponseSystemData.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkloadDeploymentModelResponseSystemData.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: Optional[str] = None,
                 created_by: Optional[str] = None,
                 created_by_type: Optional[str] = None,
                 last_modified_at: Optional[str] = None,
                 last_modified_by: Optional[str] = None,
                 last_modified_by_type: Optional[str] = None):
        """
        :param str created_at: Gets or sets the timestamp of resource creation (UTC).
        :param str created_by: Gets or sets identity that created the resource.
        :param str created_by_type: Gets or sets the type of identity that created the resource: user, application,
               managedIdentity.
        :param str last_modified_at: Gets or sets the timestamp of resource last modification (UTC).
        :param str last_modified_by: Gets or sets the identity that last modified the resource.
        :param str last_modified_by_type: Gets or sets the type of identity that last modified the resource: user, application,
               managedIdentity.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_by_type is not None:
            pulumi.set(__self__, "created_by_type", created_by_type)
        if last_modified_at is not None:
            pulumi.set(__self__, "last_modified_at", last_modified_at)
        if last_modified_by is not None:
            pulumi.set(__self__, "last_modified_by", last_modified_by)
        if last_modified_by_type is not None:
            pulumi.set(__self__, "last_modified_by_type", last_modified_by_type)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        Gets or sets the timestamp of resource creation (UTC).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[str]:
        """
        Gets or sets identity that created the resource.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="createdByType")
    def created_by_type(self) -> Optional[str]:
        """
        Gets or sets the type of identity that created the resource: user, application,
        managedIdentity.
        """
        return pulumi.get(self, "created_by_type")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> Optional[str]:
        """
        Gets or sets the timestamp of resource last modification (UTC).
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> Optional[str]:
        """
        Gets or sets the identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by")

    @property
    @pulumi.getter(name="lastModifiedByType")
    def last_modified_by_type(self) -> Optional[str]:
        """
        Gets or sets the type of identity that last modified the resource: user, application,
        managedIdentity.
        """
        return pulumi.get(self, "last_modified_by_type")


@pulumi.output_type
class WorkloadInstanceModelPropertiesResponse(dict):
    """
    Workload instance model properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedOperations":
            suggest = "allowed_operations"
        elif key == "currentJob":
            suggest = "current_job"
        elif key == "healthErrors":
            suggest = "health_errors"
        elif key == "lastSuccessfulReplicationCycleTime":
            suggest = "last_successful_replication_cycle_time"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "replicationHealth":
            suggest = "replication_health"
        elif key == "replicationStatus":
            suggest = "replication_status"
        elif key == "replicationStatusDescription":
            suggest = "replication_status_description"
        elif key == "customProperties":
            suggest = "custom_properties"
        elif key == "displayName":
            suggest = "display_name"
        elif key == "masterSiteName":
            suggest = "master_site_name"
        elif key == "migrateAgentId":
            suggest = "migrate_agent_id"
        elif key == "sourceName":
            suggest = "source_name"
        elif key == "sourcePlatform":
            suggest = "source_platform"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkloadInstanceModelPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkloadInstanceModelPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkloadInstanceModelPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_operations: Sequence[str],
                 current_job: 'outputs.WorkloadInstanceModelPropertiesResponseCurrentJob',
                 health_errors: Sequence['outputs.HealthErrorModelResponse'],
                 last_successful_replication_cycle_time: str,
                 provisioning_state: str,
                 replication_health: str,
                 replication_status: str,
                 replication_status_description: str,
                 custom_properties: Optional[Any] = None,
                 display_name: Optional[str] = None,
                 master_site_name: Optional[str] = None,
                 migrate_agent_id: Optional[str] = None,
                 name: Optional[str] = None,
                 source_name: Optional[str] = None,
                 source_platform: Optional[str] = None):
        """
        Workload instance model properties.
        :param Sequence[str] allowed_operations: Gets or sets the allowed scenarios on the workload instance.
        :param Sequence['HealthErrorModelResponse'] health_errors: Gets or sets the list of health errors.
        :param str last_successful_replication_cycle_time: Gets or sets the Last successful replication cycle time.
        :param str provisioning_state: Gets or sets the provisioning state of the workload instance.
        :param str replication_health: Gets or sets the replication health of the workload instance.
        :param str replication_status: Gets or sets the replication state of the workload instance.
        :param str replication_status_description: Gets or sets the workload replication state description.
        :param Union['ApacheTomcatWorkloadInstanceModelCustomPropertiesResponse', 'IISWorkloadInstanceModelCustomPropertiesResponse'] custom_properties: Workload instance model custom properties.
        :param str display_name: Gets or sets the display name.
        :param str master_site_name: Gets or Sets the master site name.
        :param str migrate_agent_id: Gets or sets the migrate agent id associated with the workload instance.
        :param str name: Gets or sets the workload instance name.
        :param str source_name: Gets or sets the source name.
        :param str source_platform: Gets or sets the source platform.
        """
        pulumi.set(__self__, "allowed_operations", allowed_operations)
        pulumi.set(__self__, "current_job", current_job)
        pulumi.set(__self__, "health_errors", health_errors)
        pulumi.set(__self__, "last_successful_replication_cycle_time", last_successful_replication_cycle_time)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "replication_health", replication_health)
        pulumi.set(__self__, "replication_status", replication_status)
        pulumi.set(__self__, "replication_status_description", replication_status_description)
        if custom_properties is not None:
            pulumi.set(__self__, "custom_properties", custom_properties)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if master_site_name is not None:
            pulumi.set(__self__, "master_site_name", master_site_name)
        if migrate_agent_id is not None:
            pulumi.set(__self__, "migrate_agent_id", migrate_agent_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if source_name is not None:
            pulumi.set(__self__, "source_name", source_name)
        if source_platform is not None:
            pulumi.set(__self__, "source_platform", source_platform)

    @property
    @pulumi.getter(name="allowedOperations")
    def allowed_operations(self) -> Sequence[str]:
        """
        Gets or sets the allowed scenarios on the workload instance.
        """
        return pulumi.get(self, "allowed_operations")

    @property
    @pulumi.getter(name="currentJob")
    def current_job(self) -> 'outputs.WorkloadInstanceModelPropertiesResponseCurrentJob':
        return pulumi.get(self, "current_job")

    @property
    @pulumi.getter(name="healthErrors")
    def health_errors(self) -> Sequence['outputs.HealthErrorModelResponse']:
        """
        Gets or sets the list of health errors.
        """
        return pulumi.get(self, "health_errors")

    @property
    @pulumi.getter(name="lastSuccessfulReplicationCycleTime")
    def last_successful_replication_cycle_time(self) -> str:
        """
        Gets or sets the Last successful replication cycle time.
        """
        return pulumi.get(self, "last_successful_replication_cycle_time")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        Gets or sets the provisioning state of the workload instance.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="replicationHealth")
    def replication_health(self) -> str:
        """
        Gets or sets the replication health of the workload instance.
        """
        return pulumi.get(self, "replication_health")

    @property
    @pulumi.getter(name="replicationStatus")
    def replication_status(self) -> str:
        """
        Gets or sets the replication state of the workload instance.
        """
        return pulumi.get(self, "replication_status")

    @property
    @pulumi.getter(name="replicationStatusDescription")
    def replication_status_description(self) -> str:
        """
        Gets or sets the workload replication state description.
        """
        return pulumi.get(self, "replication_status_description")

    @property
    @pulumi.getter(name="customProperties")
    def custom_properties(self) -> Optional[Any]:
        """
        Workload instance model custom properties.
        """
        return pulumi.get(self, "custom_properties")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        Gets or sets the display name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="masterSiteName")
    def master_site_name(self) -> Optional[str]:
        """
        Gets or Sets the master site name.
        """
        return pulumi.get(self, "master_site_name")

    @property
    @pulumi.getter(name="migrateAgentId")
    def migrate_agent_id(self) -> Optional[str]:
        """
        Gets or sets the migrate agent id associated with the workload instance.
        """
        return pulumi.get(self, "migrate_agent_id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Gets or sets the workload instance name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="sourceName")
    def source_name(self) -> Optional[str]:
        """
        Gets or sets the source name.
        """
        return pulumi.get(self, "source_name")

    @property
    @pulumi.getter(name="sourcePlatform")
    def source_platform(self) -> Optional[str]:
        """
        Gets or sets the source platform.
        """
        return pulumi.get(self, "source_platform")


@pulumi.output_type
class WorkloadInstanceModelPropertiesResponseCurrentJob(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"
        elif key == "endTime":
            suggest = "end_time"
        elif key == "scenarioName":
            suggest = "scenario_name"
        elif key == "startTime":
            suggest = "start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkloadInstanceModelPropertiesResponseCurrentJob. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkloadInstanceModelPropertiesResponseCurrentJob.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkloadInstanceModelPropertiesResponseCurrentJob.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 display_name: str,
                 end_time: str,
                 id: str,
                 name: str,
                 scenario_name: str,
                 start_time: str,
                 state: str):
        """
        :param str display_name: Gets or sets the workflow friendly display name.
        :param str end_time: Gets or sets end time of the workflow.
        :param str id: Gets or sets workflow Id.
        :param str name: Gets or sets workflow name.
        :param str scenario_name: Gets or sets workload scenario name.
        :param str start_time: Gets or sets start time of the workflow.
        :param str state: Gets or sets workflow state.
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "scenario_name", scenario_name)
        pulumi.set(__self__, "start_time", start_time)
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Gets or sets the workflow friendly display name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> str:
        """
        Gets or sets end time of the workflow.
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Gets or sets workflow Id.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Gets or sets workflow name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="scenarioName")
    def scenario_name(self) -> str:
        """
        Gets or sets workload scenario name.
        """
        return pulumi.get(self, "scenario_name")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        Gets or sets start time of the workflow.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Gets or sets workflow state.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class WorkloadInstanceModelResponseSystemData(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "createdBy":
            suggest = "created_by"
        elif key == "createdByType":
            suggest = "created_by_type"
        elif key == "lastModifiedAt":
            suggest = "last_modified_at"
        elif key == "lastModifiedBy":
            suggest = "last_modified_by"
        elif key == "lastModifiedByType":
            suggest = "last_modified_by_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkloadInstanceModelResponseSystemData. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkloadInstanceModelResponseSystemData.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkloadInstanceModelResponseSystemData.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: Optional[str] = None,
                 created_by: Optional[str] = None,
                 created_by_type: Optional[str] = None,
                 last_modified_at: Optional[str] = None,
                 last_modified_by: Optional[str] = None,
                 last_modified_by_type: Optional[str] = None):
        """
        :param str created_at: Gets or sets the timestamp of resource creation (UTC).
        :param str created_by: Gets or sets identity that created the resource.
        :param str created_by_type: Gets or sets the type of identity that created the resource: user, application,
               managedIdentity.
        :param str last_modified_at: Gets or sets the timestamp of resource last modification (UTC).
        :param str last_modified_by: Gets or sets the identity that last modified the resource.
        :param str last_modified_by_type: Gets or sets the type of identity that last modified the resource: user, application,
               managedIdentity.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_by_type is not None:
            pulumi.set(__self__, "created_by_type", created_by_type)
        if last_modified_at is not None:
            pulumi.set(__self__, "last_modified_at", last_modified_at)
        if last_modified_by is not None:
            pulumi.set(__self__, "last_modified_by", last_modified_by)
        if last_modified_by_type is not None:
            pulumi.set(__self__, "last_modified_by_type", last_modified_by_type)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        Gets or sets the timestamp of resource creation (UTC).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[str]:
        """
        Gets or sets identity that created the resource.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="createdByType")
    def created_by_type(self) -> Optional[str]:
        """
        Gets or sets the type of identity that created the resource: user, application,
        managedIdentity.
        """
        return pulumi.get(self, "created_by_type")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> Optional[str]:
        """
        Gets or sets the timestamp of resource last modification (UTC).
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> Optional[str]:
        """
        Gets or sets the identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by")

    @property
    @pulumi.getter(name="lastModifiedByType")
    def last_modified_by_type(self) -> Optional[str]:
        """
        Gets or sets the type of identity that last modified the resource: user, application,
        managedIdentity.
        """
        return pulumi.get(self, "last_modified_by_type")


