# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'FileDestinationResponse',
    'NotificationPropertiesResponse',
    'SchedulePropertiesResponse',
    'SystemDataResponse',
]

@pulumi.output_type
class FileDestinationResponse(dict):
    """
    Destination of the view data. Currently only csv format is supported.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fileFormats":
            suggest = "file_formats"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FileDestinationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FileDestinationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FileDestinationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 file_formats: Optional[Sequence[str]] = None):
        """
        Destination of the view data. Currently only csv format is supported.
        :param Sequence[str] file_formats: Destination of the view data. Currently only csv format is supported.
        """
        if file_formats is not None:
            pulumi.set(__self__, "file_formats", file_formats)

    @property
    @pulumi.getter(name="fileFormats")
    def file_formats(self) -> Optional[Sequence[str]]:
        """
        Destination of the view data. Currently only csv format is supported.
        """
        return pulumi.get(self, "file_formats")


@pulumi.output_type
class NotificationPropertiesResponse(dict):
    """
    The properties of the scheduled action notification.
    """
    def __init__(__self__, *,
                 subject: str,
                 to: Sequence[str],
                 message: Optional[str] = None):
        """
        The properties of the scheduled action notification.
        :param str subject: Subject of the email. Length is limited to 70 characters.
        :param Sequence[str] to: Array of email addresses.
        :param str message: Optional message to be added in the email. Length is limited to 250 characters.
        """
        pulumi.set(__self__, "subject", subject)
        pulumi.set(__self__, "to", to)
        if message is not None:
            pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter
    def subject(self) -> str:
        """
        Subject of the email. Length is limited to 70 characters.
        """
        return pulumi.get(self, "subject")

    @property
    @pulumi.getter
    def to(self) -> Sequence[str]:
        """
        Array of email addresses.
        """
        return pulumi.get(self, "to")

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        """
        Optional message to be added in the email. Length is limited to 250 characters.
        """
        return pulumi.get(self, "message")


@pulumi.output_type
class SchedulePropertiesResponse(dict):
    """
    The properties of the schedule.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endDate":
            suggest = "end_date"
        elif key == "startDate":
            suggest = "start_date"
        elif key == "dayOfMonth":
            suggest = "day_of_month"
        elif key == "daysOfWeek":
            suggest = "days_of_week"
        elif key == "hourOfDay":
            suggest = "hour_of_day"
        elif key == "weeksOfMonth":
            suggest = "weeks_of_month"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SchedulePropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SchedulePropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SchedulePropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 end_date: str,
                 frequency: str,
                 start_date: str,
                 day_of_month: Optional[int] = None,
                 days_of_week: Optional[Sequence[str]] = None,
                 hour_of_day: Optional[int] = None,
                 weeks_of_month: Optional[Sequence[str]] = None):
        """
        The properties of the schedule.
        :param str end_date: The end date and time of the scheduled action (UTC).
        :param str frequency: Frequency of the schedule.
        :param str start_date: The start date and time of the scheduled action (UTC).
        :param int day_of_month: UTC day on which cost analysis data will be emailed. Must be between 1 and 31. This property is applicable when frequency is Monthly and overrides weeksOfMonth or daysOfWeek.
        :param Sequence[str] days_of_week: Day names in english on which cost analysis data will be emailed. This property is applicable when frequency is Weekly or Monthly.
        :param int hour_of_day: UTC time at which cost analysis data will be emailed.
        :param Sequence[str] weeks_of_month: Weeks in which cost analysis data will be emailed. This property is applicable when frequency is Monthly and used in combination with daysOfWeek.
        """
        pulumi.set(__self__, "end_date", end_date)
        pulumi.set(__self__, "frequency", frequency)
        pulumi.set(__self__, "start_date", start_date)
        if day_of_month is not None:
            pulumi.set(__self__, "day_of_month", day_of_month)
        if days_of_week is not None:
            pulumi.set(__self__, "days_of_week", days_of_week)
        if hour_of_day is not None:
            pulumi.set(__self__, "hour_of_day", hour_of_day)
        if weeks_of_month is not None:
            pulumi.set(__self__, "weeks_of_month", weeks_of_month)

    @property
    @pulumi.getter(name="endDate")
    def end_date(self) -> str:
        """
        The end date and time of the scheduled action (UTC).
        """
        return pulumi.get(self, "end_date")

    @property
    @pulumi.getter
    def frequency(self) -> str:
        """
        Frequency of the schedule.
        """
        return pulumi.get(self, "frequency")

    @property
    @pulumi.getter(name="startDate")
    def start_date(self) -> str:
        """
        The start date and time of the scheduled action (UTC).
        """
        return pulumi.get(self, "start_date")

    @property
    @pulumi.getter(name="dayOfMonth")
    def day_of_month(self) -> Optional[int]:
        """
        UTC day on which cost analysis data will be emailed. Must be between 1 and 31. This property is applicable when frequency is Monthly and overrides weeksOfMonth or daysOfWeek.
        """
        return pulumi.get(self, "day_of_month")

    @property
    @pulumi.getter(name="daysOfWeek")
    def days_of_week(self) -> Optional[Sequence[str]]:
        """
        Day names in english on which cost analysis data will be emailed. This property is applicable when frequency is Weekly or Monthly.
        """
        return pulumi.get(self, "days_of_week")

    @property
    @pulumi.getter(name="hourOfDay")
    def hour_of_day(self) -> Optional[int]:
        """
        UTC time at which cost analysis data will be emailed.
        """
        return pulumi.get(self, "hour_of_day")

    @property
    @pulumi.getter(name="weeksOfMonth")
    def weeks_of_month(self) -> Optional[Sequence[str]]:
        """
        Weeks in which cost analysis data will be emailed. This property is applicable when frequency is Monthly and used in combination with daysOfWeek.
        """
        return pulumi.get(self, "weeks_of_month")


@pulumi.output_type
class SystemDataResponse(dict):
    """
    Metadata pertaining to creation and last modification of the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "createdBy":
            suggest = "created_by"
        elif key == "createdByType":
            suggest = "created_by_type"
        elif key == "lastModifiedAt":
            suggest = "last_modified_at"
        elif key == "lastModifiedBy":
            suggest = "last_modified_by"
        elif key == "lastModifiedByType":
            suggest = "last_modified_by_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SystemDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: Optional[str] = None,
                 created_by: Optional[str] = None,
                 created_by_type: Optional[str] = None,
                 last_modified_at: Optional[str] = None,
                 last_modified_by: Optional[str] = None,
                 last_modified_by_type: Optional[str] = None):
        """
        Metadata pertaining to creation and last modification of the resource.
        :param str created_at: The timestamp of resource creation (UTC).
        :param str created_by: The identity that created the resource.
        :param str created_by_type: The type of identity that created the resource.
        :param str last_modified_at: The timestamp of resource last modification (UTC)
        :param str last_modified_by: The identity that last modified the resource.
        :param str last_modified_by_type: The type of identity that last modified the resource.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_by_type is not None:
            pulumi.set(__self__, "created_by_type", created_by_type)
        if last_modified_at is not None:
            pulumi.set(__self__, "last_modified_at", last_modified_at)
        if last_modified_by is not None:
            pulumi.set(__self__, "last_modified_by", last_modified_by)
        if last_modified_by_type is not None:
            pulumi.set(__self__, "last_modified_by_type", last_modified_by_type)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The timestamp of resource creation (UTC).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[str]:
        """
        The identity that created the resource.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="createdByType")
    def created_by_type(self) -> Optional[str]:
        """
        The type of identity that created the resource.
        """
        return pulumi.get(self, "created_by_type")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> Optional[str]:
        """
        The timestamp of resource last modification (UTC)
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> Optional[str]:
        """
        The identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by")

    @property
    @pulumi.getter(name="lastModifiedByType")
    def last_modified_by_type(self) -> Optional[str]:
        """
        The type of identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by_type")


