# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from ._enums import *

__all__ = [
    'DiskPoolPropertiesArgs',
    'ElasticSanPoolPropertiesArgs',
    'EphemeralPoolPropertiesArgs',
]

@pulumi.input_type
class DiskPoolPropertiesArgs:
    def __init__(__self__, *,
                 csi_params: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 disks: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 max_volume_capacity_gi_b: Optional[pulumi.Input[float]] = None):
        """
        Disk Pool Properties
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] csi_params: List of KV pairs to set in StorageClass to configure CSI driver.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] disks: Only required if individual disk selection is desired. Path to disk, e.g. <nodename>:/dev/sda or WWN. Supports specifying multiple disks (same syntax as tags).
        :param pulumi.Input[float] max_volume_capacity_gi_b: Maximum capacity of the volumes in GiB the user intends to create. Default 512.
        """
        if csi_params is not None:
            pulumi.set(__self__, "csi_params", csi_params)
        if disks is not None:
            pulumi.set(__self__, "disks", disks)
        if max_volume_capacity_gi_b is None:
            max_volume_capacity_gi_b = 512
        if max_volume_capacity_gi_b is not None:
            pulumi.set(__self__, "max_volume_capacity_gi_b", max_volume_capacity_gi_b)

    @property
    @pulumi.getter(name="csiParams")
    def csi_params(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        List of KV pairs to set in StorageClass to configure CSI driver.
        """
        return pulumi.get(self, "csi_params")

    @csi_params.setter
    def csi_params(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "csi_params", value)

    @property
    @pulumi.getter
    def disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Only required if individual disk selection is desired. Path to disk, e.g. <nodename>:/dev/sda or WWN. Supports specifying multiple disks (same syntax as tags).
        """
        return pulumi.get(self, "disks")

    @disks.setter
    def disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "disks", value)

    @property
    @pulumi.getter(name="maxVolumeCapacityGiB")
    def max_volume_capacity_gi_b(self) -> Optional[pulumi.Input[float]]:
        """
        Maximum capacity of the volumes in GiB the user intends to create. Default 512.
        """
        return pulumi.get(self, "max_volume_capacity_gi_b")

    @max_volume_capacity_gi_b.setter
    def max_volume_capacity_gi_b(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "max_volume_capacity_gi_b", value)


@pulumi.input_type
class ElasticSanPoolPropertiesArgs:
    def __init__(__self__, *,
                 resource_group: pulumi.Input[str],
                 san_name: pulumi.Input[str],
                 volume_group: pulumi.Input[str]):
        """
        Elastic San Pool Properties
        :param pulumi.Input[str] resource_group: Resource group of an existing SAN.
        :param pulumi.Input[str] san_name: Name of an existing SAN.
        :param pulumi.Input[str] volume_group: Volume group of an existing SAN.
        """
        pulumi.set(__self__, "resource_group", resource_group)
        pulumi.set(__self__, "san_name", san_name)
        pulumi.set(__self__, "volume_group", volume_group)

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> pulumi.Input[str]:
        """
        Resource group of an existing SAN.
        """
        return pulumi.get(self, "resource_group")

    @resource_group.setter
    def resource_group(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_group", value)

    @property
    @pulumi.getter(name="sanName")
    def san_name(self) -> pulumi.Input[str]:
        """
        Name of an existing SAN.
        """
        return pulumi.get(self, "san_name")

    @san_name.setter
    def san_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "san_name", value)

    @property
    @pulumi.getter(name="volumeGroup")
    def volume_group(self) -> pulumi.Input[str]:
        """
        Volume group of an existing SAN.
        """
        return pulumi.get(self, "volume_group")

    @volume_group.setter
    def volume_group(self, value: pulumi.Input[str]):
        pulumi.set(self, "volume_group", value)


@pulumi.input_type
class EphemeralPoolPropertiesArgs:
    def __init__(__self__, *,
                 disk_selector: pulumi.Input[Sequence[pulumi.Input[str]]],
                 disks: pulumi.Input[Sequence[pulumi.Input[str]]],
                 disk_format: Optional[pulumi.Input[bool]] = None):
        """
        Ephemeral Pool Properties
        :param pulumi.Input[Sequence[pulumi.Input[str]]] disk_selector: Template name or KV pairs containing disk selection criteria, e.g. model="Microsoft NVMe Direct Disk" to match all Lsv2 NVMe disks.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] disks: Only required if individual disk selection is desired. Path to disk, e.g. <nodename>:/dev/sda or WWN. Supports specifying multiple disks (same syntax as tags).
        :param pulumi.Input[bool] disk_format: Consent to format the local disks.
        """
        pulumi.set(__self__, "disk_selector", disk_selector)
        pulumi.set(__self__, "disks", disks)
        if disk_format is None:
            disk_format = False
        if disk_format is not None:
            pulumi.set(__self__, "disk_format", disk_format)

    @property
    @pulumi.getter(name="diskSelector")
    def disk_selector(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Template name or KV pairs containing disk selection criteria, e.g. model="Microsoft NVMe Direct Disk" to match all Lsv2 NVMe disks.
        """
        return pulumi.get(self, "disk_selector")

    @disk_selector.setter
    def disk_selector(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "disk_selector", value)

    @property
    @pulumi.getter
    def disks(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Only required if individual disk selection is desired. Path to disk, e.g. <nodename>:/dev/sda or WWN. Supports specifying multiple disks (same syntax as tags).
        """
        return pulumi.get(self, "disks")

    @disks.setter
    def disks(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "disks", value)

    @property
    @pulumi.getter(name="diskFormat")
    def disk_format(self) -> Optional[pulumi.Input[bool]]:
        """
        Consent to format the local disks.
        """
        return pulumi.get(self, "disk_format")

    @disk_format.setter
    def disk_format(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disk_format", value)


