# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'IdentityArgs',
    'NonComplianceMessageArgs',
    'OverrideArgs',
    'ParameterValuesValueArgs',
    'ResourceSelectorArgs',
    'SelectorArgs',
]

@pulumi.input_type
class IdentityArgs:
    def __init__(__self__, *,
                 type: Optional[pulumi.Input['ResourceIdentityType']] = None,
                 user_assigned_identities: Optional[pulumi.Input[Mapping[str, Any]]] = None):
        """
        Identity for the resource.  Policy assignments support a maximum of one identity.  That is either a system assigned identity or a single user assigned identity.
        :param pulumi.Input['ResourceIdentityType'] type: The identity type. This is the only required field when adding a system or user assigned identity to a resource.
        :param pulumi.Input[Mapping[str, Any]] user_assigned_identities: The user identity associated with the policy. The user identity dictionary key references will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_assigned_identities is not None:
            pulumi.set(__self__, "user_assigned_identities", user_assigned_identities)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input['ResourceIdentityType']]:
        """
        The identity type. This is the only required field when adding a system or user assigned identity to a resource.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input['ResourceIdentityType']]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="userAssignedIdentities")
    def user_assigned_identities(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        The user identity associated with the policy. The user identity dictionary key references will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        """
        return pulumi.get(self, "user_assigned_identities")

    @user_assigned_identities.setter
    def user_assigned_identities(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "user_assigned_identities", value)


@pulumi.input_type
class NonComplianceMessageArgs:
    def __init__(__self__, *,
                 message: pulumi.Input[str],
                 policy_definition_reference_id: Optional[pulumi.Input[str]] = None):
        """
        A message that describes why a resource is non-compliant with the policy. This is shown in 'deny' error messages and on resource's non-compliant compliance results.
        :param pulumi.Input[str] message: A message that describes why a resource is non-compliant with the policy. This is shown in 'deny' error messages and on resource's non-compliant compliance results.
        :param pulumi.Input[str] policy_definition_reference_id: The policy definition reference ID within a policy set definition the message is intended for. This is only applicable if the policy assignment assigns a policy set definition. If this is not provided the message applies to all policies assigned by this policy assignment.
        """
        pulumi.set(__self__, "message", message)
        if policy_definition_reference_id is not None:
            pulumi.set(__self__, "policy_definition_reference_id", policy_definition_reference_id)

    @property
    @pulumi.getter
    def message(self) -> pulumi.Input[str]:
        """
        A message that describes why a resource is non-compliant with the policy. This is shown in 'deny' error messages and on resource's non-compliant compliance results.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: pulumi.Input[str]):
        pulumi.set(self, "message", value)

    @property
    @pulumi.getter(name="policyDefinitionReferenceId")
    def policy_definition_reference_id(self) -> Optional[pulumi.Input[str]]:
        """
        The policy definition reference ID within a policy set definition the message is intended for. This is only applicable if the policy assignment assigns a policy set definition. If this is not provided the message applies to all policies assigned by this policy assignment.
        """
        return pulumi.get(self, "policy_definition_reference_id")

    @policy_definition_reference_id.setter
    def policy_definition_reference_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_definition_reference_id", value)


@pulumi.input_type
class OverrideArgs:
    def __init__(__self__, *,
                 kind: Optional[pulumi.Input[Union[str, 'OverrideKind']]] = None,
                 selectors: Optional[pulumi.Input[Sequence[pulumi.Input['SelectorArgs']]]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        The policy property value override.
        :param pulumi.Input[Union[str, 'OverrideKind']] kind: The override kind.
        :param pulumi.Input[Sequence[pulumi.Input['SelectorArgs']]] selectors: The list of the selector expressions.
        :param pulumi.Input[str] value: The value to override the policy property.
        """
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if selectors is not None:
            pulumi.set(__self__, "selectors", selectors)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[Union[str, 'OverrideKind']]]:
        """
        The override kind.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[Union[str, 'OverrideKind']]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def selectors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SelectorArgs']]]]:
        """
        The list of the selector expressions.
        """
        return pulumi.get(self, "selectors")

    @selectors.setter
    def selectors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SelectorArgs']]]]):
        pulumi.set(self, "selectors", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        The value to override the policy property.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class ParameterValuesValueArgs:
    def __init__(__self__, *,
                 value: Optional[Any] = None):
        """
        The value of a parameter.
        :param Any value: The value of the parameter.
        """
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[Any]:
        """
        The value of the parameter.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[Any]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class ResourceSelectorArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 selectors: Optional[pulumi.Input[Sequence[pulumi.Input['SelectorArgs']]]] = None):
        """
        The resource selector to filter policies by resource properties.
        :param pulumi.Input[str] name: The name of the resource selector.
        :param pulumi.Input[Sequence[pulumi.Input['SelectorArgs']]] selectors: The list of the selector expressions.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if selectors is not None:
            pulumi.set(__self__, "selectors", selectors)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the resource selector.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def selectors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SelectorArgs']]]]:
        """
        The list of the selector expressions.
        """
        return pulumi.get(self, "selectors")

    @selectors.setter
    def selectors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SelectorArgs']]]]):
        pulumi.set(self, "selectors", value)


@pulumi.input_type
class SelectorArgs:
    def __init__(__self__, *,
                 in_: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 kind: Optional[pulumi.Input[Union[str, 'SelectorKind']]] = None,
                 not_in: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The selector expression.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] in_: The list of values to filter in.
        :param pulumi.Input[Union[str, 'SelectorKind']] kind: The selector kind.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] not_in: The list of values to filter out.
        """
        if in_ is not None:
            pulumi.set(__self__, "in_", in_)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if not_in is not None:
            pulumi.set(__self__, "not_in", not_in)

    @property
    @pulumi.getter(name="in")
    def in_(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of values to filter in.
        """
        return pulumi.get(self, "in_")

    @in_.setter
    def in_(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "in_", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[Union[str, 'SelectorKind']]]:
        """
        The selector kind.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[Union[str, 'SelectorKind']]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter(name="notIn")
    def not_in(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of values to filter out.
        """
        return pulumi.get(self, "not_in")

    @not_in.setter
    def not_in(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "not_in", value)


