# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'ApplicationServerConfigurationResponse',
    'ApplicationServerFullResourceNamesResponse',
    'ApplicationServerVmDetailsResponse',
    'CentralServerConfigurationResponse',
    'CentralServerFullResourceNamesResponse',
    'CentralServerVmDetailsResponse',
    'CreateAndMountFileShareConfigurationResponse',
    'DB2ProviderInstancePropertiesResponse',
    'DatabaseConfigurationResponse',
    'DatabaseServerFullResourceNamesResponse',
    'DatabaseVmDetailsResponse',
    'DeployerVmPackagesResponse',
    'DeploymentConfigurationResponse',
    'DeploymentWithOSConfigurationResponse',
    'DiscoveryConfigurationResponse',
    'DiskConfigurationResponse',
    'DiskDetailsResponse',
    'DiskSkuResponse',
    'DiskVolumeConfigurationResponse',
    'EnqueueReplicationServerPropertiesResponse',
    'EnqueueServerPropertiesResponse',
    'ErrorDefinitionResponse',
    'ErrorResponse',
    'ErrorResponseInnerError',
    'ExternalInstallationSoftwareConfigurationResponse',
    'GatewayServerPropertiesResponse',
    'HanaDbProviderInstancePropertiesResponse',
    'HighAvailabilityConfigurationResponse',
    'HighAvailabilitySoftwareConfigurationResponse',
    'ImageReferenceResponse',
    'LinuxConfigurationResponse',
    'LoadBalancerDetailsResponse',
    'LoadBalancerResourceNamesResponse',
    'ManagedRGConfigurationResponse',
    'MessageServerPropertiesResponse',
    'MonitorPropertiesResponseErrors',
    'MountFileShareConfigurationResponse',
    'MsSqlServerProviderInstancePropertiesResponse',
    'NetworkConfigurationResponse',
    'NetworkInterfaceResourceNamesResponse',
    'OSProfileResponse',
    'OsSapConfigurationResponse',
    'PrometheusHaClusterProviderInstancePropertiesResponse',
    'PrometheusOSProviderInstancePropertiesResponse',
    'ProviderInstancePropertiesResponseErrors',
    'SAPAvailabilityZonePairResponse',
    'SAPDiskConfigurationResponse',
    'SAPInstallWithoutOSConfigSoftwareConfigurationResponse',
    'SAPSupportedSkuResponse',
    'SAPVirtualInstanceErrorResponse',
    'SapLandscapeMonitorMetricThresholdsResponse',
    'SapLandscapeMonitorPropertiesResponseGrouping',
    'SapLandscapeMonitorSidMappingResponse',
    'SapNetWeaverProviderInstancePropertiesResponse',
    'ServiceInitiatedSoftwareConfigurationResponse',
    'SharedStorageResourceNamesResponse',
    'SingleServerConfigurationResponse',
    'SingleServerFullResourceNamesResponse',
    'SkipFileShareConfigurationResponse',
    'SshConfigurationResponse',
    'SshKeyPairResponse',
    'SshPublicKeyResponse',
    'StorageConfigurationResponse',
    'StorageInformationResponse',
    'SystemDataResponse',
    'ThreeTierConfigurationResponse',
    'ThreeTierFullResourceNamesResponse',
    'UserAssignedIdentityResponse',
    'UserAssignedServiceIdentityResponse',
    'VirtualMachineConfigurationResponse',
    'VirtualMachineResourceNamesResponse',
    'WindowsConfigurationResponse',
]

@pulumi.output_type
class ApplicationServerConfigurationResponse(dict):
    """
    Gets or sets the application server configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceCount":
            suggest = "instance_count"
        elif key == "subnetId":
            suggest = "subnet_id"
        elif key == "virtualMachineConfiguration":
            suggest = "virtual_machine_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationServerConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationServerConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationServerConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_count: float,
                 subnet_id: str,
                 virtual_machine_configuration: 'outputs.VirtualMachineConfigurationResponse'):
        """
        Gets or sets the application server configuration.
        :param float instance_count: The number of app server instances.
        :param str subnet_id: The subnet id.
        :param 'VirtualMachineConfigurationResponse' virtual_machine_configuration: Gets or sets the virtual machine configuration.
        """
        pulumi.set(__self__, "instance_count", instance_count)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "virtual_machine_configuration", virtual_machine_configuration)

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> float:
        """
        The number of app server instances.
        """
        return pulumi.get(self, "instance_count")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        """
        The subnet id.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="virtualMachineConfiguration")
    def virtual_machine_configuration(self) -> 'outputs.VirtualMachineConfigurationResponse':
        """
        Gets or sets the virtual machine configuration.
        """
        return pulumi.get(self, "virtual_machine_configuration")


@pulumi.output_type
class ApplicationServerFullResourceNamesResponse(dict):
    """
    The full resource names object for application layer resources. The number of entries in this list should be equal to the number VMs to be created for application layer.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "availabilitySetName":
            suggest = "availability_set_name"
        elif key == "virtualMachines":
            suggest = "virtual_machines"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationServerFullResourceNamesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationServerFullResourceNamesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationServerFullResourceNamesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 availability_set_name: Optional[str] = None,
                 virtual_machines: Optional[Sequence['outputs.VirtualMachineResourceNamesResponse']] = None):
        """
        The full resource names object for application layer resources. The number of entries in this list should be equal to the number VMs to be created for application layer.
        :param str availability_set_name: The full name for availability set. In case name is not provided, it will be defaulted to {SID}-App-AvSet.
        :param Sequence['VirtualMachineResourceNamesResponse'] virtual_machines: The list of virtual machine naming details.
        """
        if availability_set_name is not None:
            pulumi.set(__self__, "availability_set_name", availability_set_name)
        if virtual_machines is not None:
            pulumi.set(__self__, "virtual_machines", virtual_machines)

    @property
    @pulumi.getter(name="availabilitySetName")
    def availability_set_name(self) -> Optional[str]:
        """
        The full name for availability set. In case name is not provided, it will be defaulted to {SID}-App-AvSet.
        """
        return pulumi.get(self, "availability_set_name")

    @property
    @pulumi.getter(name="virtualMachines")
    def virtual_machines(self) -> Optional[Sequence['outputs.VirtualMachineResourceNamesResponse']]:
        """
        The list of virtual machine naming details.
        """
        return pulumi.get(self, "virtual_machines")


@pulumi.output_type
class ApplicationServerVmDetailsResponse(dict):
    """
    The Application Server VM Details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storageDetails":
            suggest = "storage_details"
        elif key == "virtualMachineId":
            suggest = "virtual_machine_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationServerVmDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationServerVmDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationServerVmDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 storage_details: Sequence['outputs.StorageInformationResponse'],
                 type: str,
                 virtual_machine_id: str):
        """
        The Application Server VM Details.
        :param Sequence['StorageInformationResponse'] storage_details: Storage details of all the Storage Accounts attached to the App Virtual Machine. For e.g. NFS on AFS Shared Storage.
        :param str type: Defines the type of application server VM.
        """
        pulumi.set(__self__, "storage_details", storage_details)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "virtual_machine_id", virtual_machine_id)

    @property
    @pulumi.getter(name="storageDetails")
    def storage_details(self) -> Sequence['outputs.StorageInformationResponse']:
        """
        Storage details of all the Storage Accounts attached to the App Virtual Machine. For e.g. NFS on AFS Shared Storage.
        """
        return pulumi.get(self, "storage_details")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Defines the type of application server VM.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="virtualMachineId")
    def virtual_machine_id(self) -> str:
        return pulumi.get(self, "virtual_machine_id")


@pulumi.output_type
class CentralServerConfigurationResponse(dict):
    """
    Gets or sets the central server configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceCount":
            suggest = "instance_count"
        elif key == "subnetId":
            suggest = "subnet_id"
        elif key == "virtualMachineConfiguration":
            suggest = "virtual_machine_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CentralServerConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CentralServerConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CentralServerConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_count: float,
                 subnet_id: str,
                 virtual_machine_configuration: 'outputs.VirtualMachineConfigurationResponse'):
        """
        Gets or sets the central server configuration.
        :param float instance_count: The number of central server VMs.
        :param str subnet_id: The subnet id.
        :param 'VirtualMachineConfigurationResponse' virtual_machine_configuration: Gets or sets the virtual machine configuration.
        """
        pulumi.set(__self__, "instance_count", instance_count)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "virtual_machine_configuration", virtual_machine_configuration)

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> float:
        """
        The number of central server VMs.
        """
        return pulumi.get(self, "instance_count")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        """
        The subnet id.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="virtualMachineConfiguration")
    def virtual_machine_configuration(self) -> 'outputs.VirtualMachineConfigurationResponse':
        """
        Gets or sets the virtual machine configuration.
        """
        return pulumi.get(self, "virtual_machine_configuration")


@pulumi.output_type
class CentralServerFullResourceNamesResponse(dict):
    """
    The full resource names object for central server layer resources.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "availabilitySetName":
            suggest = "availability_set_name"
        elif key == "loadBalancer":
            suggest = "load_balancer"
        elif key == "virtualMachines":
            suggest = "virtual_machines"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CentralServerFullResourceNamesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CentralServerFullResourceNamesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CentralServerFullResourceNamesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 availability_set_name: Optional[str] = None,
                 load_balancer: Optional['outputs.LoadBalancerResourceNamesResponse'] = None,
                 virtual_machines: Optional[Sequence['outputs.VirtualMachineResourceNamesResponse']] = None):
        """
        The full resource names object for central server layer resources.
        :param str availability_set_name: The full name for availability set. In case name is not provided, it will be defaulted to {SID}-ASCS-AvSet.
        :param 'LoadBalancerResourceNamesResponse' load_balancer: The resource names object for load balancer and related resources.
        :param Sequence['VirtualMachineResourceNamesResponse'] virtual_machines: The list of names for all ASCS virtual machines to be deployed. The number of entries in this list should be equal to the number VMs to be created for ASCS layer. At maximum, there can be two virtual machines at this layer: ASCS and ERS.
        """
        if availability_set_name is not None:
            pulumi.set(__self__, "availability_set_name", availability_set_name)
        if load_balancer is not None:
            pulumi.set(__self__, "load_balancer", load_balancer)
        if virtual_machines is not None:
            pulumi.set(__self__, "virtual_machines", virtual_machines)

    @property
    @pulumi.getter(name="availabilitySetName")
    def availability_set_name(self) -> Optional[str]:
        """
        The full name for availability set. In case name is not provided, it will be defaulted to {SID}-ASCS-AvSet.
        """
        return pulumi.get(self, "availability_set_name")

    @property
    @pulumi.getter(name="loadBalancer")
    def load_balancer(self) -> Optional['outputs.LoadBalancerResourceNamesResponse']:
        """
        The resource names object for load balancer and related resources.
        """
        return pulumi.get(self, "load_balancer")

    @property
    @pulumi.getter(name="virtualMachines")
    def virtual_machines(self) -> Optional[Sequence['outputs.VirtualMachineResourceNamesResponse']]:
        """
        The list of names for all ASCS virtual machines to be deployed. The number of entries in this list should be equal to the number VMs to be created for ASCS layer. At maximum, there can be two virtual machines at this layer: ASCS and ERS.
        """
        return pulumi.get(self, "virtual_machines")


@pulumi.output_type
class CentralServerVmDetailsResponse(dict):
    """
    The SAP Central Services Instance VM details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storageDetails":
            suggest = "storage_details"
        elif key == "virtualMachineId":
            suggest = "virtual_machine_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CentralServerVmDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CentralServerVmDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CentralServerVmDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 storage_details: Sequence['outputs.StorageInformationResponse'],
                 type: str,
                 virtual_machine_id: str):
        """
        The SAP Central Services Instance VM details.
        :param Sequence['StorageInformationResponse'] storage_details: Storage details of all the Storage Accounts attached to the ASCS Virtual Machine. For e.g. NFS on AFS Shared Storage.
        :param str type: Defines the type of central server VM.
        """
        pulumi.set(__self__, "storage_details", storage_details)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "virtual_machine_id", virtual_machine_id)

    @property
    @pulumi.getter(name="storageDetails")
    def storage_details(self) -> Sequence['outputs.StorageInformationResponse']:
        """
        Storage details of all the Storage Accounts attached to the ASCS Virtual Machine. For e.g. NFS on AFS Shared Storage.
        """
        return pulumi.get(self, "storage_details")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Defines the type of central server VM.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="virtualMachineId")
    def virtual_machine_id(self) -> str:
        return pulumi.get(self, "virtual_machine_id")


@pulumi.output_type
class CreateAndMountFileShareConfigurationResponse(dict):
    """
    Gets or sets the file share configuration where the transport directory fileshare is created and mounted as a part of the create infra flow. Please pre-create the resource group you intend to place the transport directory in. The storage account and fileshare will be auto-created by the ACSS and doesn’t need to pre-created.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "configurationType":
            suggest = "configuration_type"
        elif key == "resourceGroup":
            suggest = "resource_group"
        elif key == "storageAccountName":
            suggest = "storage_account_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CreateAndMountFileShareConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CreateAndMountFileShareConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CreateAndMountFileShareConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 configuration_type: str,
                 resource_group: Optional[str] = None,
                 storage_account_name: Optional[str] = None):
        """
        Gets or sets the file share configuration where the transport directory fileshare is created and mounted as a part of the create infra flow. Please pre-create the resource group you intend to place the transport directory in. The storage account and fileshare will be auto-created by the ACSS and doesn’t need to pre-created.
        :param str configuration_type: The type of file share config.
               Expected value is 'CreateAndMount'.
        :param str resource_group: The name of transport file share resource group. This should be pre created by the customer. The app rg is used in case of missing input.
        :param str storage_account_name: The name of file share storage account name . A custom name is used in case of missing input.
        """
        pulumi.set(__self__, "configuration_type", 'CreateAndMount')
        if resource_group is not None:
            pulumi.set(__self__, "resource_group", resource_group)
        if storage_account_name is not None:
            pulumi.set(__self__, "storage_account_name", storage_account_name)

    @property
    @pulumi.getter(name="configurationType")
    def configuration_type(self) -> str:
        """
        The type of file share config.
        Expected value is 'CreateAndMount'.
        """
        return pulumi.get(self, "configuration_type")

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> Optional[str]:
        """
        The name of transport file share resource group. This should be pre created by the customer. The app rg is used in case of missing input.
        """
        return pulumi.get(self, "resource_group")

    @property
    @pulumi.getter(name="storageAccountName")
    def storage_account_name(self) -> Optional[str]:
        """
        The name of file share storage account name . A custom name is used in case of missing input.
        """
        return pulumi.get(self, "storage_account_name")


@pulumi.output_type
class DB2ProviderInstancePropertiesResponse(dict):
    """
    Gets or sets the DB2 provider properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "providerType":
            suggest = "provider_type"
        elif key == "dbName":
            suggest = "db_name"
        elif key == "dbPassword":
            suggest = "db_password"
        elif key == "dbPasswordUri":
            suggest = "db_password_uri"
        elif key == "dbPort":
            suggest = "db_port"
        elif key == "dbUsername":
            suggest = "db_username"
        elif key == "sapSid":
            suggest = "sap_sid"
        elif key == "sslCertificateUri":
            suggest = "ssl_certificate_uri"
        elif key == "sslPreference":
            suggest = "ssl_preference"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DB2ProviderInstancePropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DB2ProviderInstancePropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DB2ProviderInstancePropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 provider_type: str,
                 db_name: Optional[str] = None,
                 db_password: Optional[str] = None,
                 db_password_uri: Optional[str] = None,
                 db_port: Optional[str] = None,
                 db_username: Optional[str] = None,
                 hostname: Optional[str] = None,
                 sap_sid: Optional[str] = None,
                 ssl_certificate_uri: Optional[str] = None,
                 ssl_preference: Optional[str] = None):
        """
        Gets or sets the DB2 provider properties.
        :param str provider_type: The provider type. For example, the value can be SapHana.
               Expected value is 'Db2'.
        :param str db_name: Gets or sets the db2 database name.
        :param str db_password: Gets or sets the db2 database password.
        :param str db_password_uri: Gets or sets the key vault URI to secret with the database password.
        :param str db_port: Gets or sets the db2 database sql port.
        :param str db_username: Gets or sets the db2 database user name.
        :param str hostname: Gets or sets the target virtual machine name.
        :param str sap_sid: Gets or sets the SAP System Identifier
        :param str ssl_certificate_uri: Gets or sets the blob URI to SSL certificate for the DB2 Database.
        :param str ssl_preference: Gets or sets certificate preference if secure communication is enabled.
        """
        pulumi.set(__self__, "provider_type", 'Db2')
        if db_name is not None:
            pulumi.set(__self__, "db_name", db_name)
        if db_password is not None:
            pulumi.set(__self__, "db_password", db_password)
        if db_password_uri is not None:
            pulumi.set(__self__, "db_password_uri", db_password_uri)
        if db_port is not None:
            pulumi.set(__self__, "db_port", db_port)
        if db_username is not None:
            pulumi.set(__self__, "db_username", db_username)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if sap_sid is not None:
            pulumi.set(__self__, "sap_sid", sap_sid)
        if ssl_certificate_uri is not None:
            pulumi.set(__self__, "ssl_certificate_uri", ssl_certificate_uri)
        if ssl_preference is not None:
            pulumi.set(__self__, "ssl_preference", ssl_preference)

    @property
    @pulumi.getter(name="providerType")
    def provider_type(self) -> str:
        """
        The provider type. For example, the value can be SapHana.
        Expected value is 'Db2'.
        """
        return pulumi.get(self, "provider_type")

    @property
    @pulumi.getter(name="dbName")
    def db_name(self) -> Optional[str]:
        """
        Gets or sets the db2 database name.
        """
        return pulumi.get(self, "db_name")

    @property
    @pulumi.getter(name="dbPassword")
    def db_password(self) -> Optional[str]:
        """
        Gets or sets the db2 database password.
        """
        return pulumi.get(self, "db_password")

    @property
    @pulumi.getter(name="dbPasswordUri")
    def db_password_uri(self) -> Optional[str]:
        """
        Gets or sets the key vault URI to secret with the database password.
        """
        return pulumi.get(self, "db_password_uri")

    @property
    @pulumi.getter(name="dbPort")
    def db_port(self) -> Optional[str]:
        """
        Gets or sets the db2 database sql port.
        """
        return pulumi.get(self, "db_port")

    @property
    @pulumi.getter(name="dbUsername")
    def db_username(self) -> Optional[str]:
        """
        Gets or sets the db2 database user name.
        """
        return pulumi.get(self, "db_username")

    @property
    @pulumi.getter
    def hostname(self) -> Optional[str]:
        """
        Gets or sets the target virtual machine name.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter(name="sapSid")
    def sap_sid(self) -> Optional[str]:
        """
        Gets or sets the SAP System Identifier
        """
        return pulumi.get(self, "sap_sid")

    @property
    @pulumi.getter(name="sslCertificateUri")
    def ssl_certificate_uri(self) -> Optional[str]:
        """
        Gets or sets the blob URI to SSL certificate for the DB2 Database.
        """
        return pulumi.get(self, "ssl_certificate_uri")

    @property
    @pulumi.getter(name="sslPreference")
    def ssl_preference(self) -> Optional[str]:
        """
        Gets or sets certificate preference if secure communication is enabled.
        """
        return pulumi.get(self, "ssl_preference")


@pulumi.output_type
class DatabaseConfigurationResponse(dict):
    """
    Gets or sets the database configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceCount":
            suggest = "instance_count"
        elif key == "subnetId":
            suggest = "subnet_id"
        elif key == "virtualMachineConfiguration":
            suggest = "virtual_machine_configuration"
        elif key == "databaseType":
            suggest = "database_type"
        elif key == "diskConfiguration":
            suggest = "disk_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_count: float,
                 subnet_id: str,
                 virtual_machine_configuration: 'outputs.VirtualMachineConfigurationResponse',
                 database_type: Optional[str] = None,
                 disk_configuration: Optional['outputs.DiskConfigurationResponse'] = None):
        """
        Gets or sets the database configuration.
        :param float instance_count: The number of database VMs.
        :param str subnet_id: The subnet id.
        :param 'VirtualMachineConfigurationResponse' virtual_machine_configuration: Gets or sets the virtual machine configuration.
        :param str database_type: The database type.
        :param 'DiskConfigurationResponse' disk_configuration: Gets or sets the disk configuration.
        """
        pulumi.set(__self__, "instance_count", instance_count)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "virtual_machine_configuration", virtual_machine_configuration)
        if database_type is not None:
            pulumi.set(__self__, "database_type", database_type)
        if disk_configuration is not None:
            pulumi.set(__self__, "disk_configuration", disk_configuration)

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> float:
        """
        The number of database VMs.
        """
        return pulumi.get(self, "instance_count")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        """
        The subnet id.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="virtualMachineConfiguration")
    def virtual_machine_configuration(self) -> 'outputs.VirtualMachineConfigurationResponse':
        """
        Gets or sets the virtual machine configuration.
        """
        return pulumi.get(self, "virtual_machine_configuration")

    @property
    @pulumi.getter(name="databaseType")
    def database_type(self) -> Optional[str]:
        """
        The database type.
        """
        return pulumi.get(self, "database_type")

    @property
    @pulumi.getter(name="diskConfiguration")
    def disk_configuration(self) -> Optional['outputs.DiskConfigurationResponse']:
        """
        Gets or sets the disk configuration.
        """
        return pulumi.get(self, "disk_configuration")


@pulumi.output_type
class DatabaseServerFullResourceNamesResponse(dict):
    """
    The full resource names object for database layer resources. The number of entries in this list should be equal to the number VMs to be created for database layer.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "availabilitySetName":
            suggest = "availability_set_name"
        elif key == "loadBalancer":
            suggest = "load_balancer"
        elif key == "virtualMachines":
            suggest = "virtual_machines"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseServerFullResourceNamesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseServerFullResourceNamesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseServerFullResourceNamesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 availability_set_name: Optional[str] = None,
                 load_balancer: Optional['outputs.LoadBalancerResourceNamesResponse'] = None,
                 virtual_machines: Optional[Sequence['outputs.VirtualMachineResourceNamesResponse']] = None):
        """
        The full resource names object for database layer resources. The number of entries in this list should be equal to the number VMs to be created for database layer.
        :param str availability_set_name: The full name for availability set. In case name is not provided, it will be defaulted to {SID}-DB-AvSet.
        :param 'LoadBalancerResourceNamesResponse' load_balancer: The resource names object for load balancer and related resources.
        :param Sequence['VirtualMachineResourceNamesResponse'] virtual_machines: The list of virtual machine naming details.
        """
        if availability_set_name is not None:
            pulumi.set(__self__, "availability_set_name", availability_set_name)
        if load_balancer is not None:
            pulumi.set(__self__, "load_balancer", load_balancer)
        if virtual_machines is not None:
            pulumi.set(__self__, "virtual_machines", virtual_machines)

    @property
    @pulumi.getter(name="availabilitySetName")
    def availability_set_name(self) -> Optional[str]:
        """
        The full name for availability set. In case name is not provided, it will be defaulted to {SID}-DB-AvSet.
        """
        return pulumi.get(self, "availability_set_name")

    @property
    @pulumi.getter(name="loadBalancer")
    def load_balancer(self) -> Optional['outputs.LoadBalancerResourceNamesResponse']:
        """
        The resource names object for load balancer and related resources.
        """
        return pulumi.get(self, "load_balancer")

    @property
    @pulumi.getter(name="virtualMachines")
    def virtual_machines(self) -> Optional[Sequence['outputs.VirtualMachineResourceNamesResponse']]:
        """
        The list of virtual machine naming details.
        """
        return pulumi.get(self, "virtual_machines")


@pulumi.output_type
class DatabaseVmDetailsResponse(dict):
    """
    Database VM details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storageDetails":
            suggest = "storage_details"
        elif key == "virtualMachineId":
            suggest = "virtual_machine_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseVmDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseVmDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseVmDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 status: str,
                 storage_details: Sequence['outputs.StorageInformationResponse'],
                 virtual_machine_id: str):
        """
        Database VM details.
        :param str status: Defines the SAP Instance status.
        :param Sequence['StorageInformationResponse'] storage_details: Storage details of all the Storage Accounts attached to the Database Virtual Machine. For e.g. NFS on AFS Shared Storage.
        """
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "storage_details", storage_details)
        pulumi.set(__self__, "virtual_machine_id", virtual_machine_id)

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Defines the SAP Instance status.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="storageDetails")
    def storage_details(self) -> Sequence['outputs.StorageInformationResponse']:
        """
        Storage details of all the Storage Accounts attached to the Database Virtual Machine. For e.g. NFS on AFS Shared Storage.
        """
        return pulumi.get(self, "storage_details")

    @property
    @pulumi.getter(name="virtualMachineId")
    def virtual_machine_id(self) -> str:
        return pulumi.get(self, "virtual_machine_id")


@pulumi.output_type
class DeployerVmPackagesResponse(dict):
    """
    Defines the url and storage account ID where deployer VM packages are uploaded
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storageAccountId":
            suggest = "storage_account_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeployerVmPackagesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeployerVmPackagesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeployerVmPackagesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 storage_account_id: Optional[str] = None,
                 url: Optional[str] = None):
        """
        Defines the url and storage account ID where deployer VM packages are uploaded
        :param str storage_account_id: The deployer VM packages storage account id
        :param str url: The URL to the deployer VM packages file.
        """
        if storage_account_id is not None:
            pulumi.set(__self__, "storage_account_id", storage_account_id)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter(name="storageAccountId")
    def storage_account_id(self) -> Optional[str]:
        """
        The deployer VM packages storage account id
        """
        return pulumi.get(self, "storage_account_id")

    @property
    @pulumi.getter
    def url(self) -> Optional[str]:
        """
        The URL to the deployer VM packages file.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class DeploymentConfigurationResponse(dict):
    """
    Deployment Configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "configurationType":
            suggest = "configuration_type"
        elif key == "appLocation":
            suggest = "app_location"
        elif key == "infrastructureConfiguration":
            suggest = "infrastructure_configuration"
        elif key == "softwareConfiguration":
            suggest = "software_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 configuration_type: str,
                 app_location: Optional[str] = None,
                 infrastructure_configuration: Optional[Any] = None,
                 software_configuration: Optional[Any] = None):
        """
        Deployment Configuration.
        :param str configuration_type: The configuration Type.
               Expected value is 'Deployment'.
        :param str app_location: The geo-location where the SAP system is to be created.
        :param Union['SingleServerConfigurationResponse', 'ThreeTierConfigurationResponse'] infrastructure_configuration: The infrastructure configuration.
        :param Union['ExternalInstallationSoftwareConfigurationResponse', 'SAPInstallWithoutOSConfigSoftwareConfigurationResponse', 'ServiceInitiatedSoftwareConfigurationResponse'] software_configuration: The software configuration.
        """
        pulumi.set(__self__, "configuration_type", 'Deployment')
        if app_location is not None:
            pulumi.set(__self__, "app_location", app_location)
        if infrastructure_configuration is not None:
            pulumi.set(__self__, "infrastructure_configuration", infrastructure_configuration)
        if software_configuration is not None:
            pulumi.set(__self__, "software_configuration", software_configuration)

    @property
    @pulumi.getter(name="configurationType")
    def configuration_type(self) -> str:
        """
        The configuration Type.
        Expected value is 'Deployment'.
        """
        return pulumi.get(self, "configuration_type")

    @property
    @pulumi.getter(name="appLocation")
    def app_location(self) -> Optional[str]:
        """
        The geo-location where the SAP system is to be created.
        """
        return pulumi.get(self, "app_location")

    @property
    @pulumi.getter(name="infrastructureConfiguration")
    def infrastructure_configuration(self) -> Optional[Any]:
        """
        The infrastructure configuration.
        """
        return pulumi.get(self, "infrastructure_configuration")

    @property
    @pulumi.getter(name="softwareConfiguration")
    def software_configuration(self) -> Optional[Any]:
        """
        The software configuration.
        """
        return pulumi.get(self, "software_configuration")


@pulumi.output_type
class DeploymentWithOSConfigurationResponse(dict):
    """
    Deployment along with OS Configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "configurationType":
            suggest = "configuration_type"
        elif key == "appLocation":
            suggest = "app_location"
        elif key == "infrastructureConfiguration":
            suggest = "infrastructure_configuration"
        elif key == "osSapConfiguration":
            suggest = "os_sap_configuration"
        elif key == "softwareConfiguration":
            suggest = "software_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentWithOSConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentWithOSConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentWithOSConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 configuration_type: str,
                 app_location: Optional[str] = None,
                 infrastructure_configuration: Optional[Any] = None,
                 os_sap_configuration: Optional['outputs.OsSapConfigurationResponse'] = None,
                 software_configuration: Optional[Any] = None):
        """
        Deployment along with OS Configuration.
        :param str configuration_type: The configuration Type.
               Expected value is 'DeploymentWithOSConfig'.
        :param str app_location: The geo-location where the SAP system is to be created.
        :param Union['SingleServerConfigurationResponse', 'ThreeTierConfigurationResponse'] infrastructure_configuration: The infrastructure configuration.
        :param 'OsSapConfigurationResponse' os_sap_configuration: The OS and SAP configuration.
        :param Union['ExternalInstallationSoftwareConfigurationResponse', 'SAPInstallWithoutOSConfigSoftwareConfigurationResponse', 'ServiceInitiatedSoftwareConfigurationResponse'] software_configuration: The software configuration.
        """
        pulumi.set(__self__, "configuration_type", 'DeploymentWithOSConfig')
        if app_location is not None:
            pulumi.set(__self__, "app_location", app_location)
        if infrastructure_configuration is not None:
            pulumi.set(__self__, "infrastructure_configuration", infrastructure_configuration)
        if os_sap_configuration is not None:
            pulumi.set(__self__, "os_sap_configuration", os_sap_configuration)
        if software_configuration is not None:
            pulumi.set(__self__, "software_configuration", software_configuration)

    @property
    @pulumi.getter(name="configurationType")
    def configuration_type(self) -> str:
        """
        The configuration Type.
        Expected value is 'DeploymentWithOSConfig'.
        """
        return pulumi.get(self, "configuration_type")

    @property
    @pulumi.getter(name="appLocation")
    def app_location(self) -> Optional[str]:
        """
        The geo-location where the SAP system is to be created.
        """
        return pulumi.get(self, "app_location")

    @property
    @pulumi.getter(name="infrastructureConfiguration")
    def infrastructure_configuration(self) -> Optional[Any]:
        """
        The infrastructure configuration.
        """
        return pulumi.get(self, "infrastructure_configuration")

    @property
    @pulumi.getter(name="osSapConfiguration")
    def os_sap_configuration(self) -> Optional['outputs.OsSapConfigurationResponse']:
        """
        The OS and SAP configuration.
        """
        return pulumi.get(self, "os_sap_configuration")

    @property
    @pulumi.getter(name="softwareConfiguration")
    def software_configuration(self) -> Optional[Any]:
        """
        The software configuration.
        """
        return pulumi.get(self, "software_configuration")


@pulumi.output_type
class DiscoveryConfigurationResponse(dict):
    """
    Discovery Details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appLocation":
            suggest = "app_location"
        elif key == "configurationType":
            suggest = "configuration_type"
        elif key == "centralServerVmId":
            suggest = "central_server_vm_id"
        elif key == "managedRgStorageAccountName":
            suggest = "managed_rg_storage_account_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DiscoveryConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DiscoveryConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DiscoveryConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 app_location: str,
                 configuration_type: str,
                 central_server_vm_id: Optional[str] = None,
                 managed_rg_storage_account_name: Optional[str] = None):
        """
        Discovery Details.
        :param str app_location: The geo-location where the SAP system exists.
        :param str configuration_type: The configuration Type.
               Expected value is 'Discovery'.
        :param str central_server_vm_id: The virtual machine ID of the Central Server.
        :param str managed_rg_storage_account_name: The custom storage account name for the storage account created by the service in the managed resource group created as part of VIS deployment.<br><br>Refer to the storage account naming rules [here](https://learn.microsoft.com/azure/azure-resource-manager/management/resource-name-rules#microsoftstorage).<br><br>If not provided, the service will create the storage account with a random name.
        """
        pulumi.set(__self__, "app_location", app_location)
        pulumi.set(__self__, "configuration_type", 'Discovery')
        if central_server_vm_id is not None:
            pulumi.set(__self__, "central_server_vm_id", central_server_vm_id)
        if managed_rg_storage_account_name is not None:
            pulumi.set(__self__, "managed_rg_storage_account_name", managed_rg_storage_account_name)

    @property
    @pulumi.getter(name="appLocation")
    def app_location(self) -> str:
        """
        The geo-location where the SAP system exists.
        """
        return pulumi.get(self, "app_location")

    @property
    @pulumi.getter(name="configurationType")
    def configuration_type(self) -> str:
        """
        The configuration Type.
        Expected value is 'Discovery'.
        """
        return pulumi.get(self, "configuration_type")

    @property
    @pulumi.getter(name="centralServerVmId")
    def central_server_vm_id(self) -> Optional[str]:
        """
        The virtual machine ID of the Central Server.
        """
        return pulumi.get(self, "central_server_vm_id")

    @property
    @pulumi.getter(name="managedRgStorageAccountName")
    def managed_rg_storage_account_name(self) -> Optional[str]:
        """
        The custom storage account name for the storage account created by the service in the managed resource group created as part of VIS deployment.<br><br>Refer to the storage account naming rules [here](https://learn.microsoft.com/azure/azure-resource-manager/management/resource-name-rules#microsoftstorage).<br><br>If not provided, the service will create the storage account with a random name.
        """
        return pulumi.get(self, "managed_rg_storage_account_name")


@pulumi.output_type
class DiskConfigurationResponse(dict):
    """
    The Disk Configuration Details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskVolumeConfigurations":
            suggest = "disk_volume_configurations"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DiskConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DiskConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DiskConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disk_volume_configurations: Optional[Mapping[str, 'outputs.DiskVolumeConfigurationResponse']] = None):
        """
        The Disk Configuration Details.
        :param Mapping[str, 'DiskVolumeConfigurationResponse'] disk_volume_configurations: The disk configuration for the db volume. For HANA, Required volumes are: ['hana/data', 'hana/log', hana/shared', 'usr/sap', 'os'], Optional volume : ['backup'].
        """
        if disk_volume_configurations is not None:
            pulumi.set(__self__, "disk_volume_configurations", disk_volume_configurations)

    @property
    @pulumi.getter(name="diskVolumeConfigurations")
    def disk_volume_configurations(self) -> Optional[Mapping[str, 'outputs.DiskVolumeConfigurationResponse']]:
        """
        The disk configuration for the db volume. For HANA, Required volumes are: ['hana/data', 'hana/log', hana/shared', 'usr/sap', 'os'], Optional volume : ['backup'].
        """
        return pulumi.get(self, "disk_volume_configurations")


@pulumi.output_type
class DiskDetailsResponse(dict):
    """
    The supported disk size details for a disk type.
    """
    def __init__(__self__, *,
                 disk_tier: Optional[str] = None,
                 iops_read_write: Optional[float] = None,
                 maximum_supported_disk_count: Optional[float] = None,
                 mbps_read_write: Optional[float] = None,
                 minimum_supported_disk_count: Optional[float] = None,
                 size_gb: Optional[float] = None,
                 sku: Optional['outputs.DiskSkuResponse'] = None):
        """
        The supported disk size details for a disk type.
        :param str disk_tier: The disk tier, e.g. P10, E10.
        :param float iops_read_write: The disk Iops.
        :param float maximum_supported_disk_count: The maximum supported disk count.
        :param float mbps_read_write: The disk provisioned throughput in MBps.
        :param float minimum_supported_disk_count: The minimum supported disk count.
        :param float size_gb: The disk size in GB.
        :param 'DiskSkuResponse' sku: The type of disk sku. For example, Standard_LRS, Standard_ZRS, Premium_LRS, Premium_ZRS.
        """
        if disk_tier is not None:
            pulumi.set(__self__, "disk_tier", disk_tier)
        if iops_read_write is not None:
            pulumi.set(__self__, "iops_read_write", iops_read_write)
        if maximum_supported_disk_count is not None:
            pulumi.set(__self__, "maximum_supported_disk_count", maximum_supported_disk_count)
        if mbps_read_write is not None:
            pulumi.set(__self__, "mbps_read_write", mbps_read_write)
        if minimum_supported_disk_count is not None:
            pulumi.set(__self__, "minimum_supported_disk_count", minimum_supported_disk_count)
        if size_gb is not None:
            pulumi.set(__self__, "size_gb", size_gb)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)

    @property
    @pulumi.getter(name="diskTier")
    def disk_tier(self) -> Optional[str]:
        """
        The disk tier, e.g. P10, E10.
        """
        return pulumi.get(self, "disk_tier")

    @property
    @pulumi.getter(name="iopsReadWrite")
    def iops_read_write(self) -> Optional[float]:
        """
        The disk Iops.
        """
        return pulumi.get(self, "iops_read_write")

    @property
    @pulumi.getter(name="maximumSupportedDiskCount")
    def maximum_supported_disk_count(self) -> Optional[float]:
        """
        The maximum supported disk count.
        """
        return pulumi.get(self, "maximum_supported_disk_count")

    @property
    @pulumi.getter(name="mbpsReadWrite")
    def mbps_read_write(self) -> Optional[float]:
        """
        The disk provisioned throughput in MBps.
        """
        return pulumi.get(self, "mbps_read_write")

    @property
    @pulumi.getter(name="minimumSupportedDiskCount")
    def minimum_supported_disk_count(self) -> Optional[float]:
        """
        The minimum supported disk count.
        """
        return pulumi.get(self, "minimum_supported_disk_count")

    @property
    @pulumi.getter(name="sizeGB")
    def size_gb(self) -> Optional[float]:
        """
        The disk size in GB.
        """
        return pulumi.get(self, "size_gb")

    @property
    @pulumi.getter
    def sku(self) -> Optional['outputs.DiskSkuResponse']:
        """
        The type of disk sku. For example, Standard_LRS, Standard_ZRS, Premium_LRS, Premium_ZRS.
        """
        return pulumi.get(self, "sku")


@pulumi.output_type
class DiskSkuResponse(dict):
    """
    The type of disk sku. For example, Standard_LRS, Standard_ZRS, Premium_LRS, Premium_ZRS.
    """
    def __init__(__self__, *,
                 name: Optional[str] = None):
        """
        The type of disk sku. For example, Standard_LRS, Standard_ZRS, Premium_LRS, Premium_ZRS.
        :param str name: Defines the disk sku name.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Defines the disk sku name.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class DiskVolumeConfigurationResponse(dict):
    """
    The disk configuration required for the selected volume.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sizeGB":
            suggest = "size_gb"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DiskVolumeConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DiskVolumeConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DiskVolumeConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 count: Optional[float] = None,
                 size_gb: Optional[float] = None,
                 sku: Optional['outputs.DiskSkuResponse'] = None):
        """
        The disk configuration required for the selected volume.
        :param float count: The total number of disks required for the concerned volume.
        :param float size_gb: The disk size in GB.
        :param 'DiskSkuResponse' sku: The disk SKU details.
        """
        if count is not None:
            pulumi.set(__self__, "count", count)
        if size_gb is not None:
            pulumi.set(__self__, "size_gb", size_gb)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)

    @property
    @pulumi.getter
    def count(self) -> Optional[float]:
        """
        The total number of disks required for the concerned volume.
        """
        return pulumi.get(self, "count")

    @property
    @pulumi.getter(name="sizeGB")
    def size_gb(self) -> Optional[float]:
        """
        The disk size in GB.
        """
        return pulumi.get(self, "size_gb")

    @property
    @pulumi.getter
    def sku(self) -> Optional['outputs.DiskSkuResponse']:
        """
        The disk SKU details.
        """
        return pulumi.get(self, "sku")


@pulumi.output_type
class EnqueueReplicationServerPropertiesResponse(dict):
    """
    Defines the SAP Enqueue Replication Server (ERS) properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ersVersion":
            suggest = "ers_version"
        elif key == "instanceNo":
            suggest = "instance_no"
        elif key == "ipAddress":
            suggest = "ip_address"
        elif key == "kernelPatch":
            suggest = "kernel_patch"
        elif key == "kernelVersion":
            suggest = "kernel_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EnqueueReplicationServerPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EnqueueReplicationServerPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EnqueueReplicationServerPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ers_version: str,
                 health: str,
                 hostname: str,
                 instance_no: str,
                 ip_address: str,
                 kernel_patch: str,
                 kernel_version: str):
        """
        Defines the SAP Enqueue Replication Server (ERS) properties.
        :param str ers_version: Defines the type of Enqueue Replication Server.
        :param str health: Defines the health of SAP Instances.
        :param str hostname: ERS SAP Hostname.
        :param str instance_no: ERS Instance Number.
        :param str ip_address: ERS SAP IP Address.
        :param str kernel_patch: ERS SAP Kernel Patch level.
        :param str kernel_version: ERS SAP Kernel Version.
        """
        pulumi.set(__self__, "ers_version", ers_version)
        pulumi.set(__self__, "health", health)
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "instance_no", instance_no)
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "kernel_patch", kernel_patch)
        pulumi.set(__self__, "kernel_version", kernel_version)

    @property
    @pulumi.getter(name="ersVersion")
    def ers_version(self) -> str:
        """
        Defines the type of Enqueue Replication Server.
        """
        return pulumi.get(self, "ers_version")

    @property
    @pulumi.getter
    def health(self) -> str:
        """
        Defines the health of SAP Instances.
        """
        return pulumi.get(self, "health")

    @property
    @pulumi.getter
    def hostname(self) -> str:
        """
        ERS SAP Hostname.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter(name="instanceNo")
    def instance_no(self) -> str:
        """
        ERS Instance Number.
        """
        return pulumi.get(self, "instance_no")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> str:
        """
        ERS SAP IP Address.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="kernelPatch")
    def kernel_patch(self) -> str:
        """
        ERS SAP Kernel Patch level.
        """
        return pulumi.get(self, "kernel_patch")

    @property
    @pulumi.getter(name="kernelVersion")
    def kernel_version(self) -> str:
        """
        ERS SAP Kernel Version.
        """
        return pulumi.get(self, "kernel_version")


@pulumi.output_type
class EnqueueServerPropertiesResponse(dict):
    """
    Defines the SAP Enqueue Server properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipAddress":
            suggest = "ip_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EnqueueServerPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EnqueueServerPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EnqueueServerPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 health: str,
                 hostname: str,
                 ip_address: str,
                 port: float):
        """
        Defines the SAP Enqueue Server properties.
        :param str health: Defines the health of SAP Instances.
        :param str hostname: Enqueue Server SAP Hostname.
        :param str ip_address: Enqueue Server SAP IP Address.
        :param float port: Enqueue Server Port.
        """
        pulumi.set(__self__, "health", health)
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def health(self) -> str:
        """
        Defines the health of SAP Instances.
        """
        return pulumi.get(self, "health")

    @property
    @pulumi.getter
    def hostname(self) -> str:
        """
        Enqueue Server SAP Hostname.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> str:
        """
        Enqueue Server SAP IP Address.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter
    def port(self) -> float:
        """
        Enqueue Server Port.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class ErrorDefinitionResponse(dict):
    """
    Error definition.
    """
    def __init__(__self__, *,
                 code: str,
                 details: Sequence['outputs.ErrorDefinitionResponse'],
                 message: str):
        """
        Error definition.
        :param str code: Service specific error code which serves as the substatus for the HTTP error code.
        :param Sequence['ErrorDefinitionResponse'] details: Internal error details.
        :param str message: Description of the error.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "details", details)
        pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter
    def code(self) -> str:
        """
        Service specific error code which serves as the substatus for the HTTP error code.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def details(self) -> Sequence['outputs.ErrorDefinitionResponse']:
        """
        Internal error details.
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        Description of the error.
        """
        return pulumi.get(self, "message")


@pulumi.output_type
class ErrorResponse(dict):
    """
    Standard error object.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "innerError":
            suggest = "inner_error"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ErrorResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ErrorResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ErrorResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 code: str,
                 details: Sequence['outputs.ErrorResponse'],
                 inner_error: 'outputs.ErrorResponseInnerError',
                 message: str,
                 target: str):
        """
        Standard error object.
        :param str code: Server-defined set of error codes.
        :param Sequence['ErrorResponse'] details: Array of details about specific errors that led to this reported error.
        :param 'ErrorResponseInnerError' inner_error: Object containing more specific information than  the current object about the error.
        :param str message: Human-readable representation of the error.
        :param str target: Target of the error.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "details", details)
        pulumi.set(__self__, "inner_error", inner_error)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter
    def code(self) -> str:
        """
        Server-defined set of error codes.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def details(self) -> Sequence['outputs.ErrorResponse']:
        """
        Array of details about specific errors that led to this reported error.
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter(name="innerError")
    def inner_error(self) -> 'outputs.ErrorResponseInnerError':
        """
        Object containing more specific information than  the current object about the error.
        """
        return pulumi.get(self, "inner_error")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        Human-readable representation of the error.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def target(self) -> str:
        """
        Target of the error.
        """
        return pulumi.get(self, "target")


@pulumi.output_type
class ErrorResponseInnerError(dict):
    """
    Object containing more specific information than  the current object about the error.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "innerError":
            suggest = "inner_error"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ErrorResponseInnerError. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ErrorResponseInnerError.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ErrorResponseInnerError.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 inner_error: Optional['outputs.ErrorResponse'] = None):
        """
        Object containing more specific information than  the current object about the error.
        :param 'ErrorResponse' inner_error: Standard error object.
        """
        if inner_error is not None:
            pulumi.set(__self__, "inner_error", inner_error)

    @property
    @pulumi.getter(name="innerError")
    def inner_error(self) -> Optional['outputs.ErrorResponse']:
        """
        Standard error object.
        """
        return pulumi.get(self, "inner_error")


@pulumi.output_type
class ExternalInstallationSoftwareConfigurationResponse(dict):
    """
    The SAP Software configuration Input when the software is installed externally outside the service.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "softwareInstallationType":
            suggest = "software_installation_type"
        elif key == "centralServerVmId":
            suggest = "central_server_vm_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExternalInstallationSoftwareConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExternalInstallationSoftwareConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExternalInstallationSoftwareConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 software_installation_type: str,
                 central_server_vm_id: Optional[str] = None):
        """
        The SAP Software configuration Input when the software is installed externally outside the service.
        :param str software_installation_type: The SAP software installation Type.
               Expected value is 'External'.
        :param str central_server_vm_id: The resource ID of the virtual machine containing the central server instance.
        """
        pulumi.set(__self__, "software_installation_type", 'External')
        if central_server_vm_id is not None:
            pulumi.set(__self__, "central_server_vm_id", central_server_vm_id)

    @property
    @pulumi.getter(name="softwareInstallationType")
    def software_installation_type(self) -> str:
        """
        The SAP software installation Type.
        Expected value is 'External'.
        """
        return pulumi.get(self, "software_installation_type")

    @property
    @pulumi.getter(name="centralServerVmId")
    def central_server_vm_id(self) -> Optional[str]:
        """
        The resource ID of the virtual machine containing the central server instance.
        """
        return pulumi.get(self, "central_server_vm_id")


@pulumi.output_type
class GatewayServerPropertiesResponse(dict):
    """
    Defines the SAP Gateway Server properties.
    """
    def __init__(__self__, *,
                 health: str,
                 port: float):
        """
        Defines the SAP Gateway Server properties.
        :param str health: Defines the health of SAP Instances.
        :param float port: Gateway Port.
        """
        pulumi.set(__self__, "health", health)
        pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def health(self) -> str:
        """
        Defines the health of SAP Instances.
        """
        return pulumi.get(self, "health")

    @property
    @pulumi.getter
    def port(self) -> float:
        """
        Gateway Port.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class HanaDbProviderInstancePropertiesResponse(dict):
    """
    Gets or sets the provider properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "providerType":
            suggest = "provider_type"
        elif key == "dbName":
            suggest = "db_name"
        elif key == "dbPassword":
            suggest = "db_password"
        elif key == "dbPasswordUri":
            suggest = "db_password_uri"
        elif key == "dbUsername":
            suggest = "db_username"
        elif key == "instanceNumber":
            suggest = "instance_number"
        elif key == "sapSid":
            suggest = "sap_sid"
        elif key == "sqlPort":
            suggest = "sql_port"
        elif key == "sslCertificateUri":
            suggest = "ssl_certificate_uri"
        elif key == "sslHostNameInCertificate":
            suggest = "ssl_host_name_in_certificate"
        elif key == "sslPreference":
            suggest = "ssl_preference"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HanaDbProviderInstancePropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HanaDbProviderInstancePropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HanaDbProviderInstancePropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 provider_type: str,
                 db_name: Optional[str] = None,
                 db_password: Optional[str] = None,
                 db_password_uri: Optional[str] = None,
                 db_username: Optional[str] = None,
                 hostname: Optional[str] = None,
                 instance_number: Optional[str] = None,
                 sap_sid: Optional[str] = None,
                 sql_port: Optional[str] = None,
                 ssl_certificate_uri: Optional[str] = None,
                 ssl_host_name_in_certificate: Optional[str] = None,
                 ssl_preference: Optional[str] = None):
        """
        Gets or sets the provider properties.
        :param str provider_type: The provider type. For example, the value can be SapHana.
               Expected value is 'SapHana'.
        :param str db_name: Gets or sets the hana database name.
        :param str db_password: Gets or sets the database password.
        :param str db_password_uri: Gets or sets the key vault URI to secret with the database password.
        :param str db_username: Gets or sets the database user name.
        :param str hostname: Gets or sets the target virtual machine size.
        :param str instance_number: Gets or sets the database instance number.
        :param str sap_sid: Gets or sets the SAP System Identifier.
        :param str sql_port: Gets or sets the database sql port.
        :param str ssl_certificate_uri: Gets or sets the blob URI to SSL certificate for the DB.
        :param str ssl_host_name_in_certificate: Gets or sets the hostname(s) in the SSL certificate.
        :param str ssl_preference: Gets or sets certificate preference if secure communication is enabled.
        """
        pulumi.set(__self__, "provider_type", 'SapHana')
        if db_name is not None:
            pulumi.set(__self__, "db_name", db_name)
        if db_password is not None:
            pulumi.set(__self__, "db_password", db_password)
        if db_password_uri is not None:
            pulumi.set(__self__, "db_password_uri", db_password_uri)
        if db_username is not None:
            pulumi.set(__self__, "db_username", db_username)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if instance_number is not None:
            pulumi.set(__self__, "instance_number", instance_number)
        if sap_sid is not None:
            pulumi.set(__self__, "sap_sid", sap_sid)
        if sql_port is not None:
            pulumi.set(__self__, "sql_port", sql_port)
        if ssl_certificate_uri is not None:
            pulumi.set(__self__, "ssl_certificate_uri", ssl_certificate_uri)
        if ssl_host_name_in_certificate is not None:
            pulumi.set(__self__, "ssl_host_name_in_certificate", ssl_host_name_in_certificate)
        if ssl_preference is not None:
            pulumi.set(__self__, "ssl_preference", ssl_preference)

    @property
    @pulumi.getter(name="providerType")
    def provider_type(self) -> str:
        """
        The provider type. For example, the value can be SapHana.
        Expected value is 'SapHana'.
        """
        return pulumi.get(self, "provider_type")

    @property
    @pulumi.getter(name="dbName")
    def db_name(self) -> Optional[str]:
        """
        Gets or sets the hana database name.
        """
        return pulumi.get(self, "db_name")

    @property
    @pulumi.getter(name="dbPassword")
    def db_password(self) -> Optional[str]:
        """
        Gets or sets the database password.
        """
        return pulumi.get(self, "db_password")

    @property
    @pulumi.getter(name="dbPasswordUri")
    def db_password_uri(self) -> Optional[str]:
        """
        Gets or sets the key vault URI to secret with the database password.
        """
        return pulumi.get(self, "db_password_uri")

    @property
    @pulumi.getter(name="dbUsername")
    def db_username(self) -> Optional[str]:
        """
        Gets or sets the database user name.
        """
        return pulumi.get(self, "db_username")

    @property
    @pulumi.getter
    def hostname(self) -> Optional[str]:
        """
        Gets or sets the target virtual machine size.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter(name="instanceNumber")
    def instance_number(self) -> Optional[str]:
        """
        Gets or sets the database instance number.
        """
        return pulumi.get(self, "instance_number")

    @property
    @pulumi.getter(name="sapSid")
    def sap_sid(self) -> Optional[str]:
        """
        Gets or sets the SAP System Identifier.
        """
        return pulumi.get(self, "sap_sid")

    @property
    @pulumi.getter(name="sqlPort")
    def sql_port(self) -> Optional[str]:
        """
        Gets or sets the database sql port.
        """
        return pulumi.get(self, "sql_port")

    @property
    @pulumi.getter(name="sslCertificateUri")
    def ssl_certificate_uri(self) -> Optional[str]:
        """
        Gets or sets the blob URI to SSL certificate for the DB.
        """
        return pulumi.get(self, "ssl_certificate_uri")

    @property
    @pulumi.getter(name="sslHostNameInCertificate")
    def ssl_host_name_in_certificate(self) -> Optional[str]:
        """
        Gets or sets the hostname(s) in the SSL certificate.
        """
        return pulumi.get(self, "ssl_host_name_in_certificate")

    @property
    @pulumi.getter(name="sslPreference")
    def ssl_preference(self) -> Optional[str]:
        """
        Gets or sets certificate preference if secure communication is enabled.
        """
        return pulumi.get(self, "ssl_preference")


@pulumi.output_type
class HighAvailabilityConfigurationResponse(dict):
    """
    Gets or sets the high availability configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "highAvailabilityType":
            suggest = "high_availability_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HighAvailabilityConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HighAvailabilityConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HighAvailabilityConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 high_availability_type: str):
        """
        Gets or sets the high availability configuration.
        :param str high_availability_type: The high availability type.
        """
        pulumi.set(__self__, "high_availability_type", high_availability_type)

    @property
    @pulumi.getter(name="highAvailabilityType")
    def high_availability_type(self) -> str:
        """
        The high availability type.
        """
        return pulumi.get(self, "high_availability_type")


@pulumi.output_type
class HighAvailabilitySoftwareConfigurationResponse(dict):
    """
    Gets or sets the HA software configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fencingClientId":
            suggest = "fencing_client_id"
        elif key == "fencingClientPassword":
            suggest = "fencing_client_password"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HighAvailabilitySoftwareConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HighAvailabilitySoftwareConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HighAvailabilitySoftwareConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fencing_client_id: str,
                 fencing_client_password: str):
        """
        Gets or sets the HA software configuration.
        :param str fencing_client_id: The fencing client id.
        :param str fencing_client_password: The fencing client id secret/password. The secret should never expire. This will be used pacemaker to start/stop the cluster VMs.
        """
        pulumi.set(__self__, "fencing_client_id", fencing_client_id)
        pulumi.set(__self__, "fencing_client_password", fencing_client_password)

    @property
    @pulumi.getter(name="fencingClientId")
    def fencing_client_id(self) -> str:
        """
        The fencing client id.
        """
        return pulumi.get(self, "fencing_client_id")

    @property
    @pulumi.getter(name="fencingClientPassword")
    def fencing_client_password(self) -> str:
        """
        The fencing client id secret/password. The secret should never expire. This will be used pacemaker to start/stop the cluster VMs.
        """
        return pulumi.get(self, "fencing_client_password")


@pulumi.output_type
class ImageReferenceResponse(dict):
    """
    Specifies information about the image to use. You can specify information about platform images, marketplace images, or virtual machine images. This element is required when you want to use a platform image, marketplace image, or virtual machine image, but is not used in other creation operations. NOTE: Image reference publisher and offer can only be set when you create the scale set.
    """
    def __init__(__self__, *,
                 offer: Optional[str] = None,
                 publisher: Optional[str] = None,
                 sku: Optional[str] = None,
                 version: Optional[str] = None):
        """
        Specifies information about the image to use. You can specify information about platform images, marketplace images, or virtual machine images. This element is required when you want to use a platform image, marketplace image, or virtual machine image, but is not used in other creation operations. NOTE: Image reference publisher and offer can only be set when you create the scale set.
        :param str offer: Specifies the offer of the platform image or marketplace image used to create the virtual machine.
        :param str publisher: The image publisher.
        :param str sku: The image SKU.
        :param str version: Specifies the version of the platform image or marketplace image used to create the virtual machine. The allowed formats are Major.Minor.Build or 'latest'. Major, Minor, and Build are decimal numbers. Specify 'latest' to use the latest version of an image available at deploy time. Even if you use 'latest', the VM image will not automatically update after deploy time even if a new version becomes available.
        """
        if offer is not None:
            pulumi.set(__self__, "offer", offer)
        if publisher is not None:
            pulumi.set(__self__, "publisher", publisher)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def offer(self) -> Optional[str]:
        """
        Specifies the offer of the platform image or marketplace image used to create the virtual machine.
        """
        return pulumi.get(self, "offer")

    @property
    @pulumi.getter
    def publisher(self) -> Optional[str]:
        """
        The image publisher.
        """
        return pulumi.get(self, "publisher")

    @property
    @pulumi.getter
    def sku(self) -> Optional[str]:
        """
        The image SKU.
        """
        return pulumi.get(self, "sku")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        Specifies the version of the platform image or marketplace image used to create the virtual machine. The allowed formats are Major.Minor.Build or 'latest'. Major, Minor, and Build are decimal numbers. Specify 'latest' to use the latest version of an image available at deploy time. Even if you use 'latest', the VM image will not automatically update after deploy time even if a new version becomes available.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class LinuxConfigurationResponse(dict):
    """
    Specifies the Linux operating system settings on the virtual machine. <br><br>For a list of supported Linux distributions, see [Linux on Azure-Endorsed Distributions](https://docs.microsoft.com/azure/virtual-machines/linux/endorsed-distros).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "osType":
            suggest = "os_type"
        elif key == "disablePasswordAuthentication":
            suggest = "disable_password_authentication"
        elif key == "sshKeyPair":
            suggest = "ssh_key_pair"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LinuxConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LinuxConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LinuxConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 os_type: str,
                 disable_password_authentication: Optional[bool] = None,
                 ssh: Optional['outputs.SshConfigurationResponse'] = None,
                 ssh_key_pair: Optional['outputs.SshKeyPairResponse'] = None):
        """
        Specifies the Linux operating system settings on the virtual machine. <br><br>For a list of supported Linux distributions, see [Linux on Azure-Endorsed Distributions](https://docs.microsoft.com/azure/virtual-machines/linux/endorsed-distros).
        :param str os_type: The OS Type
               Expected value is 'Linux'.
        :param bool disable_password_authentication: Specifies whether password authentication should be disabled.
        :param 'SshConfigurationResponse' ssh: Specifies the ssh key configuration for a Linux OS. (This property is deprecated, please use 'sshKeyPair' instead)
        :param 'SshKeyPairResponse' ssh_key_pair: The SSH Key-pair used to authenticate with the VM's.
        """
        pulumi.set(__self__, "os_type", 'Linux')
        if disable_password_authentication is not None:
            pulumi.set(__self__, "disable_password_authentication", disable_password_authentication)
        if ssh is not None:
            pulumi.set(__self__, "ssh", ssh)
        if ssh_key_pair is not None:
            pulumi.set(__self__, "ssh_key_pair", ssh_key_pair)

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> str:
        """
        The OS Type
        Expected value is 'Linux'.
        """
        return pulumi.get(self, "os_type")

    @property
    @pulumi.getter(name="disablePasswordAuthentication")
    def disable_password_authentication(self) -> Optional[bool]:
        """
        Specifies whether password authentication should be disabled.
        """
        return pulumi.get(self, "disable_password_authentication")

    @property
    @pulumi.getter
    def ssh(self) -> Optional['outputs.SshConfigurationResponse']:
        """
        Specifies the ssh key configuration for a Linux OS. (This property is deprecated, please use 'sshKeyPair' instead)
        """
        return pulumi.get(self, "ssh")

    @property
    @pulumi.getter(name="sshKeyPair")
    def ssh_key_pair(self) -> Optional['outputs.SshKeyPairResponse']:
        """
        The SSH Key-pair used to authenticate with the VM's.
        """
        return pulumi.get(self, "ssh_key_pair")


@pulumi.output_type
class LoadBalancerDetailsResponse(dict):
    """
    The Load Balancer details such as Load Balancer ID.
    """
    def __init__(__self__, *,
                 id: str):
        """
        The Load Balancer details such as Load Balancer ID.
        """
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")


@pulumi.output_type
class LoadBalancerResourceNamesResponse(dict):
    """
    The resource names object for load balancer and related resources.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backendPoolNames":
            suggest = "backend_pool_names"
        elif key == "frontendIpConfigurationNames":
            suggest = "frontend_ip_configuration_names"
        elif key == "healthProbeNames":
            suggest = "health_probe_names"
        elif key == "loadBalancerName":
            suggest = "load_balancer_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadBalancerResourceNamesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadBalancerResourceNamesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadBalancerResourceNamesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backend_pool_names: Optional[Sequence[str]] = None,
                 frontend_ip_configuration_names: Optional[Sequence[str]] = None,
                 health_probe_names: Optional[Sequence[str]] = None,
                 load_balancer_name: Optional[str] = None):
        """
        The resource names object for load balancer and related resources.
        :param Sequence[str] backend_pool_names: The list of backend pool names. Currently, ACSS deploys only one backend pool and hence, size of this list should be 1
        :param Sequence[str] frontend_ip_configuration_names: The list of frontend IP configuration names. If provided as input, size of this list should be 2 for cs layer and should be 1 for database layer.
        :param Sequence[str] health_probe_names: The list of health probe names. If provided as input, size of this list should be 2 for cs layer and should be 1 for database layer.
        :param str load_balancer_name: The full resource name for load balancer. If this value is not provided, load balancer will be name as {ASCS/DB}-loadBalancer.
        """
        if backend_pool_names is not None:
            pulumi.set(__self__, "backend_pool_names", backend_pool_names)
        if frontend_ip_configuration_names is not None:
            pulumi.set(__self__, "frontend_ip_configuration_names", frontend_ip_configuration_names)
        if health_probe_names is not None:
            pulumi.set(__self__, "health_probe_names", health_probe_names)
        if load_balancer_name is not None:
            pulumi.set(__self__, "load_balancer_name", load_balancer_name)

    @property
    @pulumi.getter(name="backendPoolNames")
    def backend_pool_names(self) -> Optional[Sequence[str]]:
        """
        The list of backend pool names. Currently, ACSS deploys only one backend pool and hence, size of this list should be 1
        """
        return pulumi.get(self, "backend_pool_names")

    @property
    @pulumi.getter(name="frontendIpConfigurationNames")
    def frontend_ip_configuration_names(self) -> Optional[Sequence[str]]:
        """
        The list of frontend IP configuration names. If provided as input, size of this list should be 2 for cs layer and should be 1 for database layer.
        """
        return pulumi.get(self, "frontend_ip_configuration_names")

    @property
    @pulumi.getter(name="healthProbeNames")
    def health_probe_names(self) -> Optional[Sequence[str]]:
        """
        The list of health probe names. If provided as input, size of this list should be 2 for cs layer and should be 1 for database layer.
        """
        return pulumi.get(self, "health_probe_names")

    @property
    @pulumi.getter(name="loadBalancerName")
    def load_balancer_name(self) -> Optional[str]:
        """
        The full resource name for load balancer. If this value is not provided, load balancer will be name as {ASCS/DB}-loadBalancer.
        """
        return pulumi.get(self, "load_balancer_name")


@pulumi.output_type
class ManagedRGConfigurationResponse(dict):
    """
    Managed resource group configuration
    """
    def __init__(__self__, *,
                 name: Optional[str] = None):
        """
        Managed resource group configuration
        :param str name: Managed resource group name
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Managed resource group name
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class MessageServerPropertiesResponse(dict):
    """
    Defines the SAP Message Server properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "httpPort":
            suggest = "http_port"
        elif key == "httpsPort":
            suggest = "https_port"
        elif key == "internalMsPort":
            suggest = "internal_ms_port"
        elif key == "ipAddress":
            suggest = "ip_address"
        elif key == "msPort":
            suggest = "ms_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MessageServerPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MessageServerPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MessageServerPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 health: str,
                 hostname: str,
                 http_port: float,
                 https_port: float,
                 internal_ms_port: float,
                 ip_address: str,
                 ms_port: float):
        """
        Defines the SAP Message Server properties.
        :param str health: Defines the health of SAP Instances.
        :param str hostname: Message Server SAP Hostname.
        :param float http_port: Message Server HTTP Port.
        :param float https_port: Message Server HTTPS Port.
        :param float internal_ms_port: Message Server internal MS port.
        :param str ip_address: Message server IP Address.
        :param float ms_port: Message Server port.
        """
        pulumi.set(__self__, "health", health)
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "http_port", http_port)
        pulumi.set(__self__, "https_port", https_port)
        pulumi.set(__self__, "internal_ms_port", internal_ms_port)
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "ms_port", ms_port)

    @property
    @pulumi.getter
    def health(self) -> str:
        """
        Defines the health of SAP Instances.
        """
        return pulumi.get(self, "health")

    @property
    @pulumi.getter
    def hostname(self) -> str:
        """
        Message Server SAP Hostname.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter(name="httpPort")
    def http_port(self) -> float:
        """
        Message Server HTTP Port.
        """
        return pulumi.get(self, "http_port")

    @property
    @pulumi.getter(name="httpsPort")
    def https_port(self) -> float:
        """
        Message Server HTTPS Port.
        """
        return pulumi.get(self, "https_port")

    @property
    @pulumi.getter(name="internalMsPort")
    def internal_ms_port(self) -> float:
        """
        Message Server internal MS port.
        """
        return pulumi.get(self, "internal_ms_port")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> str:
        """
        Message server IP Address.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="msPort")
    def ms_port(self) -> float:
        """
        Message Server port.
        """
        return pulumi.get(self, "ms_port")


@pulumi.output_type
class MonitorPropertiesResponseErrors(dict):
    """
    Defines the SAP monitor errors.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "innerError":
            suggest = "inner_error"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MonitorPropertiesResponseErrors. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MonitorPropertiesResponseErrors.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MonitorPropertiesResponseErrors.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 code: str,
                 details: Sequence['outputs.ErrorResponse'],
                 inner_error: 'outputs.ErrorResponseInnerError',
                 message: str,
                 target: str):
        """
        Defines the SAP monitor errors.
        :param str code: Server-defined set of error codes.
        :param Sequence['ErrorResponse'] details: Array of details about specific errors that led to this reported error.
        :param 'ErrorResponseInnerError' inner_error: Object containing more specific information than  the current object about the error.
        :param str message: Human-readable representation of the error.
        :param str target: Target of the error.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "details", details)
        pulumi.set(__self__, "inner_error", inner_error)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter
    def code(self) -> str:
        """
        Server-defined set of error codes.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def details(self) -> Sequence['outputs.ErrorResponse']:
        """
        Array of details about specific errors that led to this reported error.
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter(name="innerError")
    def inner_error(self) -> 'outputs.ErrorResponseInnerError':
        """
        Object containing more specific information than  the current object about the error.
        """
        return pulumi.get(self, "inner_error")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        Human-readable representation of the error.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def target(self) -> str:
        """
        Target of the error.
        """
        return pulumi.get(self, "target")


@pulumi.output_type
class MountFileShareConfigurationResponse(dict):
    """
    Gets or sets the file share configuration where the transport directory fileshare already exists, and user wishes to mount the fileshare as a part of the create infra flow.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "configurationType":
            suggest = "configuration_type"
        elif key == "privateEndpointId":
            suggest = "private_endpoint_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MountFileShareConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MountFileShareConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MountFileShareConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 configuration_type: str,
                 id: str,
                 private_endpoint_id: str):
        """
        Gets or sets the file share configuration where the transport directory fileshare already exists, and user wishes to mount the fileshare as a part of the create infra flow.
        :param str configuration_type: The type of file share config.
               Expected value is 'Mount'.
        :param str id: The fileshare resource ID
        :param str private_endpoint_id: The private endpoint resource ID
        """
        pulumi.set(__self__, "configuration_type", 'Mount')
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "private_endpoint_id", private_endpoint_id)

    @property
    @pulumi.getter(name="configurationType")
    def configuration_type(self) -> str:
        """
        The type of file share config.
        Expected value is 'Mount'.
        """
        return pulumi.get(self, "configuration_type")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The fileshare resource ID
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="privateEndpointId")
    def private_endpoint_id(self) -> str:
        """
        The private endpoint resource ID
        """
        return pulumi.get(self, "private_endpoint_id")


@pulumi.output_type
class MsSqlServerProviderInstancePropertiesResponse(dict):
    """
    Gets or sets the SQL server provider properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "providerType":
            suggest = "provider_type"
        elif key == "dbPassword":
            suggest = "db_password"
        elif key == "dbPasswordUri":
            suggest = "db_password_uri"
        elif key == "dbPort":
            suggest = "db_port"
        elif key == "dbUsername":
            suggest = "db_username"
        elif key == "sapSid":
            suggest = "sap_sid"
        elif key == "sslCertificateUri":
            suggest = "ssl_certificate_uri"
        elif key == "sslPreference":
            suggest = "ssl_preference"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MsSqlServerProviderInstancePropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MsSqlServerProviderInstancePropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MsSqlServerProviderInstancePropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 provider_type: str,
                 db_password: Optional[str] = None,
                 db_password_uri: Optional[str] = None,
                 db_port: Optional[str] = None,
                 db_username: Optional[str] = None,
                 hostname: Optional[str] = None,
                 sap_sid: Optional[str] = None,
                 ssl_certificate_uri: Optional[str] = None,
                 ssl_preference: Optional[str] = None):
        """
        Gets or sets the SQL server provider properties.
        :param str provider_type: The provider type. For example, the value can be SapHana.
               Expected value is 'MsSqlServer'.
        :param str db_password: Gets or sets the database password.
        :param str db_password_uri: Gets or sets the key vault URI to secret with the database password.
        :param str db_port: Gets or sets the database sql port.
        :param str db_username: Gets or sets the database user name.
        :param str hostname: Gets or sets the SQL server host name.
        :param str sap_sid: Gets or sets the SAP System Identifier
        :param str ssl_certificate_uri: Gets or sets the blob URI to SSL certificate for the SQL Database.
        :param str ssl_preference: Gets or sets certificate preference if secure communication is enabled.
        """
        pulumi.set(__self__, "provider_type", 'MsSqlServer')
        if db_password is not None:
            pulumi.set(__self__, "db_password", db_password)
        if db_password_uri is not None:
            pulumi.set(__self__, "db_password_uri", db_password_uri)
        if db_port is not None:
            pulumi.set(__self__, "db_port", db_port)
        if db_username is not None:
            pulumi.set(__self__, "db_username", db_username)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if sap_sid is not None:
            pulumi.set(__self__, "sap_sid", sap_sid)
        if ssl_certificate_uri is not None:
            pulumi.set(__self__, "ssl_certificate_uri", ssl_certificate_uri)
        if ssl_preference is not None:
            pulumi.set(__self__, "ssl_preference", ssl_preference)

    @property
    @pulumi.getter(name="providerType")
    def provider_type(self) -> str:
        """
        The provider type. For example, the value can be SapHana.
        Expected value is 'MsSqlServer'.
        """
        return pulumi.get(self, "provider_type")

    @property
    @pulumi.getter(name="dbPassword")
    def db_password(self) -> Optional[str]:
        """
        Gets or sets the database password.
        """
        return pulumi.get(self, "db_password")

    @property
    @pulumi.getter(name="dbPasswordUri")
    def db_password_uri(self) -> Optional[str]:
        """
        Gets or sets the key vault URI to secret with the database password.
        """
        return pulumi.get(self, "db_password_uri")

    @property
    @pulumi.getter(name="dbPort")
    def db_port(self) -> Optional[str]:
        """
        Gets or sets the database sql port.
        """
        return pulumi.get(self, "db_port")

    @property
    @pulumi.getter(name="dbUsername")
    def db_username(self) -> Optional[str]:
        """
        Gets or sets the database user name.
        """
        return pulumi.get(self, "db_username")

    @property
    @pulumi.getter
    def hostname(self) -> Optional[str]:
        """
        Gets or sets the SQL server host name.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter(name="sapSid")
    def sap_sid(self) -> Optional[str]:
        """
        Gets or sets the SAP System Identifier
        """
        return pulumi.get(self, "sap_sid")

    @property
    @pulumi.getter(name="sslCertificateUri")
    def ssl_certificate_uri(self) -> Optional[str]:
        """
        Gets or sets the blob URI to SSL certificate for the SQL Database.
        """
        return pulumi.get(self, "ssl_certificate_uri")

    @property
    @pulumi.getter(name="sslPreference")
    def ssl_preference(self) -> Optional[str]:
        """
        Gets or sets certificate preference if secure communication is enabled.
        """
        return pulumi.get(self, "ssl_preference")


@pulumi.output_type
class NetworkConfigurationResponse(dict):
    """
    Defines the network configuration type for SAP system infrastructure that is being deployed 
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isSecondaryIpEnabled":
            suggest = "is_secondary_ip_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_secondary_ip_enabled: Optional[bool] = None):
        """
        Defines the network configuration type for SAP system infrastructure that is being deployed 
        :param bool is_secondary_ip_enabled: Specifies whether a secondary IP address should be added to the network interface on all VMs of the SAP system being deployed
        """
        if is_secondary_ip_enabled is None:
            is_secondary_ip_enabled = False
        if is_secondary_ip_enabled is not None:
            pulumi.set(__self__, "is_secondary_ip_enabled", is_secondary_ip_enabled)

    @property
    @pulumi.getter(name="isSecondaryIpEnabled")
    def is_secondary_ip_enabled(self) -> Optional[bool]:
        """
        Specifies whether a secondary IP address should be added to the network interface on all VMs of the SAP system being deployed
        """
        return pulumi.get(self, "is_secondary_ip_enabled")


@pulumi.output_type
class NetworkInterfaceResourceNamesResponse(dict):
    """
    The resource names object for network interface and related resources.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "networkInterfaceName":
            suggest = "network_interface_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkInterfaceResourceNamesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkInterfaceResourceNamesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkInterfaceResourceNamesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 network_interface_name: Optional[str] = None):
        """
        The resource names object for network interface and related resources.
        :param str network_interface_name: The full name for network interface. If name is not provided, service uses a default name based on the deployment type. For SingleServer, default name is {SID}-Nic. In case of HA-AvZone systems, default name will be {SID}-{App/ASCS/DB}-Zone{A/B}-Nic with an incrementor at the end in case of more than 1 instance per layer. For distributed and HA-AvSet systems, default name will be {SID}-{App/ASCS/DB}-Nic with an incrementor at the end in case of more than 1 instance per layer.
        """
        if network_interface_name is not None:
            pulumi.set(__self__, "network_interface_name", network_interface_name)

    @property
    @pulumi.getter(name="networkInterfaceName")
    def network_interface_name(self) -> Optional[str]:
        """
        The full name for network interface. If name is not provided, service uses a default name based on the deployment type. For SingleServer, default name is {SID}-Nic. In case of HA-AvZone systems, default name will be {SID}-{App/ASCS/DB}-Zone{A/B}-Nic with an incrementor at the end in case of more than 1 instance per layer. For distributed and HA-AvSet systems, default name will be {SID}-{App/ASCS/DB}-Nic with an incrementor at the end in case of more than 1 instance per layer.
        """
        return pulumi.get(self, "network_interface_name")


@pulumi.output_type
class OSProfileResponse(dict):
    """
    Specifies the operating system settings for the virtual machine. Some of the settings cannot be changed once VM is provisioned.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "adminPassword":
            suggest = "admin_password"
        elif key == "adminUsername":
            suggest = "admin_username"
        elif key == "osConfiguration":
            suggest = "os_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OSProfileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OSProfileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OSProfileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 admin_password: Optional[str] = None,
                 admin_username: Optional[str] = None,
                 os_configuration: Optional[Any] = None):
        """
        Specifies the operating system settings for the virtual machine. Some of the settings cannot be changed once VM is provisioned.
        :param str admin_password: Specifies the password of the administrator account. <br><br> **Minimum-length (Windows):** 8 characters <br><br> **Minimum-length (Linux):** 6 characters <br><br> **Max-length (Windows):** 123 characters <br><br> **Max-length (Linux):** 72 characters <br><br> **Complexity requirements:** 3 out of 4 conditions below need to be fulfilled <br> Has lower characters <br>Has upper characters <br> Has a digit <br> Has a special character (Regex match [\\W_]) <br><br> **Disallowed values:** "abc@123", "P@$$w0rd", "P@ssw0rd", "P@ssword123", "Pa$$word", "pass@word1", "Password!", "Password1", "Password22", "iloveyou!" <br><br> For resetting the password, see [How to reset the Remote Desktop service or its login password in a Windows VM](https://docs.microsoft.com/troubleshoot/azure/virtual-machines/reset-rdp) <br><br> For resetting root password, see [Manage users, SSH, and check or repair disks on Azure Linux VMs using the VMAccess Extension](https://docs.microsoft.com/troubleshoot/azure/virtual-machines/troubleshoot-ssh-connection)
        :param str admin_username: Specifies the name of the administrator account. <br><br> This property cannot be updated after the VM is created. <br><br> **Windows-only restriction:** Cannot end in "." <br><br> **Disallowed values:** "administrator", "admin", "user", "user1", "test", "user2", "test1", "user3", "admin1", "1", "123", "a", "actuser", "adm", "admin2", "aspnet", "backup", "console", "david", "guest", "john", "owner", "root", "server", "sql", "support", "support_388945a0", "sys", "test2", "test3", "user4", "user5". <br><br> **Minimum-length (Linux):** 1  character <br><br> **Max-length (Linux):** 64 characters <br><br> **Max-length (Windows):** 20 characters.
        :param Union['LinuxConfigurationResponse', 'WindowsConfigurationResponse'] os_configuration: Specifies Windows operating system settings on the virtual machine.
        """
        if admin_password is not None:
            pulumi.set(__self__, "admin_password", admin_password)
        if admin_username is not None:
            pulumi.set(__self__, "admin_username", admin_username)
        if os_configuration is not None:
            pulumi.set(__self__, "os_configuration", os_configuration)

    @property
    @pulumi.getter(name="adminPassword")
    def admin_password(self) -> Optional[str]:
        """
        Specifies the password of the administrator account. <br><br> **Minimum-length (Windows):** 8 characters <br><br> **Minimum-length (Linux):** 6 characters <br><br> **Max-length (Windows):** 123 characters <br><br> **Max-length (Linux):** 72 characters <br><br> **Complexity requirements:** 3 out of 4 conditions below need to be fulfilled <br> Has lower characters <br>Has upper characters <br> Has a digit <br> Has a special character (Regex match [\\W_]) <br><br> **Disallowed values:** "abc@123", "P@$$w0rd", "P@ssw0rd", "P@ssword123", "Pa$$word", "pass@word1", "Password!", "Password1", "Password22", "iloveyou!" <br><br> For resetting the password, see [How to reset the Remote Desktop service or its login password in a Windows VM](https://docs.microsoft.com/troubleshoot/azure/virtual-machines/reset-rdp) <br><br> For resetting root password, see [Manage users, SSH, and check or repair disks on Azure Linux VMs using the VMAccess Extension](https://docs.microsoft.com/troubleshoot/azure/virtual-machines/troubleshoot-ssh-connection)
        """
        return pulumi.get(self, "admin_password")

    @property
    @pulumi.getter(name="adminUsername")
    def admin_username(self) -> Optional[str]:
        """
        Specifies the name of the administrator account. <br><br> This property cannot be updated after the VM is created. <br><br> **Windows-only restriction:** Cannot end in "." <br><br> **Disallowed values:** "administrator", "admin", "user", "user1", "test", "user2", "test1", "user3", "admin1", "1", "123", "a", "actuser", "adm", "admin2", "aspnet", "backup", "console", "david", "guest", "john", "owner", "root", "server", "sql", "support", "support_388945a0", "sys", "test2", "test3", "user4", "user5". <br><br> **Minimum-length (Linux):** 1  character <br><br> **Max-length (Linux):** 64 characters <br><br> **Max-length (Windows):** 20 characters.
        """
        return pulumi.get(self, "admin_username")

    @property
    @pulumi.getter(name="osConfiguration")
    def os_configuration(self) -> Optional[Any]:
        """
        Specifies Windows operating system settings on the virtual machine.
        """
        return pulumi.get(self, "os_configuration")


@pulumi.output_type
class OsSapConfigurationResponse(dict):
    """
    Defines the OS and SAP Configurations for Deployment
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deployerVmPackages":
            suggest = "deployer_vm_packages"
        elif key == "sapFqdn":
            suggest = "sap_fqdn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OsSapConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OsSapConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OsSapConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 deployer_vm_packages: Optional['outputs.DeployerVmPackagesResponse'] = None,
                 sap_fqdn: Optional[str] = None):
        """
        Defines the OS and SAP Configurations for Deployment
        :param 'DeployerVmPackagesResponse' deployer_vm_packages: The url and storage account ID where deployer VM packages are uploaded
        :param str sap_fqdn: The FQDN to set for the SAP system
        """
        if deployer_vm_packages is not None:
            pulumi.set(__self__, "deployer_vm_packages", deployer_vm_packages)
        if sap_fqdn is not None:
            pulumi.set(__self__, "sap_fqdn", sap_fqdn)

    @property
    @pulumi.getter(name="deployerVmPackages")
    def deployer_vm_packages(self) -> Optional['outputs.DeployerVmPackagesResponse']:
        """
        The url and storage account ID where deployer VM packages are uploaded
        """
        return pulumi.get(self, "deployer_vm_packages")

    @property
    @pulumi.getter(name="sapFqdn")
    def sap_fqdn(self) -> Optional[str]:
        """
        The FQDN to set for the SAP system
        """
        return pulumi.get(self, "sap_fqdn")


@pulumi.output_type
class PrometheusHaClusterProviderInstancePropertiesResponse(dict):
    """
    Gets or sets the PrometheusHaCluster provider properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "providerType":
            suggest = "provider_type"
        elif key == "clusterName":
            suggest = "cluster_name"
        elif key == "prometheusUrl":
            suggest = "prometheus_url"
        elif key == "sslCertificateUri":
            suggest = "ssl_certificate_uri"
        elif key == "sslPreference":
            suggest = "ssl_preference"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrometheusHaClusterProviderInstancePropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrometheusHaClusterProviderInstancePropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrometheusHaClusterProviderInstancePropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 provider_type: str,
                 cluster_name: Optional[str] = None,
                 hostname: Optional[str] = None,
                 prometheus_url: Optional[str] = None,
                 sid: Optional[str] = None,
                 ssl_certificate_uri: Optional[str] = None,
                 ssl_preference: Optional[str] = None):
        """
        Gets or sets the PrometheusHaCluster provider properties.
        :param str provider_type: The provider type. For example, the value can be SapHana.
               Expected value is 'PrometheusHaCluster'.
        :param str cluster_name: Gets or sets the clusterName.
        :param str hostname: Gets or sets the target machine name.
        :param str prometheus_url: URL of the Node Exporter endpoint.
        :param str sid: Gets or sets the cluster sid.
        :param str ssl_certificate_uri: Gets or sets the blob URI to SSL certificate for the HA cluster exporter.
        :param str ssl_preference: Gets or sets certificate preference if secure communication is enabled.
        """
        pulumi.set(__self__, "provider_type", 'PrometheusHaCluster')
        if cluster_name is not None:
            pulumi.set(__self__, "cluster_name", cluster_name)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if prometheus_url is not None:
            pulumi.set(__self__, "prometheus_url", prometheus_url)
        if sid is not None:
            pulumi.set(__self__, "sid", sid)
        if ssl_certificate_uri is not None:
            pulumi.set(__self__, "ssl_certificate_uri", ssl_certificate_uri)
        if ssl_preference is not None:
            pulumi.set(__self__, "ssl_preference", ssl_preference)

    @property
    @pulumi.getter(name="providerType")
    def provider_type(self) -> str:
        """
        The provider type. For example, the value can be SapHana.
        Expected value is 'PrometheusHaCluster'.
        """
        return pulumi.get(self, "provider_type")

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[str]:
        """
        Gets or sets the clusterName.
        """
        return pulumi.get(self, "cluster_name")

    @property
    @pulumi.getter
    def hostname(self) -> Optional[str]:
        """
        Gets or sets the target machine name.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter(name="prometheusUrl")
    def prometheus_url(self) -> Optional[str]:
        """
        URL of the Node Exporter endpoint.
        """
        return pulumi.get(self, "prometheus_url")

    @property
    @pulumi.getter
    def sid(self) -> Optional[str]:
        """
        Gets or sets the cluster sid.
        """
        return pulumi.get(self, "sid")

    @property
    @pulumi.getter(name="sslCertificateUri")
    def ssl_certificate_uri(self) -> Optional[str]:
        """
        Gets or sets the blob URI to SSL certificate for the HA cluster exporter.
        """
        return pulumi.get(self, "ssl_certificate_uri")

    @property
    @pulumi.getter(name="sslPreference")
    def ssl_preference(self) -> Optional[str]:
        """
        Gets or sets certificate preference if secure communication is enabled.
        """
        return pulumi.get(self, "ssl_preference")


@pulumi.output_type
class PrometheusOSProviderInstancePropertiesResponse(dict):
    """
    Gets or sets the PrometheusOS provider properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "providerType":
            suggest = "provider_type"
        elif key == "prometheusUrl":
            suggest = "prometheus_url"
        elif key == "sapSid":
            suggest = "sap_sid"
        elif key == "sslCertificateUri":
            suggest = "ssl_certificate_uri"
        elif key == "sslPreference":
            suggest = "ssl_preference"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrometheusOSProviderInstancePropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrometheusOSProviderInstancePropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrometheusOSProviderInstancePropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 provider_type: str,
                 prometheus_url: Optional[str] = None,
                 sap_sid: Optional[str] = None,
                 ssl_certificate_uri: Optional[str] = None,
                 ssl_preference: Optional[str] = None):
        """
        Gets or sets the PrometheusOS provider properties.
        :param str provider_type: The provider type. For example, the value can be SapHana.
               Expected value is 'PrometheusOS'.
        :param str prometheus_url: URL of the Node Exporter endpoint
        :param str sap_sid: Gets or sets the SAP System Identifier
        :param str ssl_certificate_uri: Gets or sets the blob URI to SSL certificate for the prometheus node exporter.
        :param str ssl_preference: Gets or sets certificate preference if secure communication is enabled.
        """
        pulumi.set(__self__, "provider_type", 'PrometheusOS')
        if prometheus_url is not None:
            pulumi.set(__self__, "prometheus_url", prometheus_url)
        if sap_sid is not None:
            pulumi.set(__self__, "sap_sid", sap_sid)
        if ssl_certificate_uri is not None:
            pulumi.set(__self__, "ssl_certificate_uri", ssl_certificate_uri)
        if ssl_preference is not None:
            pulumi.set(__self__, "ssl_preference", ssl_preference)

    @property
    @pulumi.getter(name="providerType")
    def provider_type(self) -> str:
        """
        The provider type. For example, the value can be SapHana.
        Expected value is 'PrometheusOS'.
        """
        return pulumi.get(self, "provider_type")

    @property
    @pulumi.getter(name="prometheusUrl")
    def prometheus_url(self) -> Optional[str]:
        """
        URL of the Node Exporter endpoint
        """
        return pulumi.get(self, "prometheus_url")

    @property
    @pulumi.getter(name="sapSid")
    def sap_sid(self) -> Optional[str]:
        """
        Gets or sets the SAP System Identifier
        """
        return pulumi.get(self, "sap_sid")

    @property
    @pulumi.getter(name="sslCertificateUri")
    def ssl_certificate_uri(self) -> Optional[str]:
        """
        Gets or sets the blob URI to SSL certificate for the prometheus node exporter.
        """
        return pulumi.get(self, "ssl_certificate_uri")

    @property
    @pulumi.getter(name="sslPreference")
    def ssl_preference(self) -> Optional[str]:
        """
        Gets or sets certificate preference if secure communication is enabled.
        """
        return pulumi.get(self, "ssl_preference")


@pulumi.output_type
class ProviderInstancePropertiesResponseErrors(dict):
    """
    Defines the provider instance errors.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "innerError":
            suggest = "inner_error"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProviderInstancePropertiesResponseErrors. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProviderInstancePropertiesResponseErrors.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProviderInstancePropertiesResponseErrors.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 code: str,
                 details: Sequence['outputs.ErrorResponse'],
                 inner_error: 'outputs.ErrorResponseInnerError',
                 message: str,
                 target: str):
        """
        Defines the provider instance errors.
        :param str code: Server-defined set of error codes.
        :param Sequence['ErrorResponse'] details: Array of details about specific errors that led to this reported error.
        :param 'ErrorResponseInnerError' inner_error: Object containing more specific information than  the current object about the error.
        :param str message: Human-readable representation of the error.
        :param str target: Target of the error.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "details", details)
        pulumi.set(__self__, "inner_error", inner_error)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter
    def code(self) -> str:
        """
        Server-defined set of error codes.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def details(self) -> Sequence['outputs.ErrorResponse']:
        """
        Array of details about specific errors that led to this reported error.
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter(name="innerError")
    def inner_error(self) -> 'outputs.ErrorResponseInnerError':
        """
        Object containing more specific information than  the current object about the error.
        """
        return pulumi.get(self, "inner_error")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        Human-readable representation of the error.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def target(self) -> str:
        """
        Target of the error.
        """
        return pulumi.get(self, "target")


@pulumi.output_type
class SAPAvailabilityZonePairResponse(dict):
    """
    The SAP Availability Zone Pair.
    """
    def __init__(__self__, *,
                 zone_a: Optional[float] = None,
                 zone_b: Optional[float] = None):
        """
        The SAP Availability Zone Pair.
        :param float zone_a: The zone A.
        :param float zone_b: The zone B.
        """
        if zone_a is not None:
            pulumi.set(__self__, "zone_a", zone_a)
        if zone_b is not None:
            pulumi.set(__self__, "zone_b", zone_b)

    @property
    @pulumi.getter(name="zoneA")
    def zone_a(self) -> Optional[float]:
        """
        The zone A.
        """
        return pulumi.get(self, "zone_a")

    @property
    @pulumi.getter(name="zoneB")
    def zone_b(self) -> Optional[float]:
        """
        The zone B.
        """
        return pulumi.get(self, "zone_b")


@pulumi.output_type
class SAPDiskConfigurationResponse(dict):
    """
    The SAP Disk Configuration contains 'recommended disk' details and list of supported disks detail for a volume type.
    """
    def __init__(__self__, *,
                 recommended_configuration: Optional['outputs.DiskVolumeConfigurationResponse'] = None,
                 supported_configurations: Optional[Sequence['outputs.DiskDetailsResponse']] = None):
        """
        The SAP Disk Configuration contains 'recommended disk' details and list of supported disks detail for a volume type.
        :param 'DiskVolumeConfigurationResponse' recommended_configuration: The recommended disk details for a given VM Sku.
        :param Sequence['DiskDetailsResponse'] supported_configurations: The list of supported disks for a given VM Sku.
        """
        if recommended_configuration is not None:
            pulumi.set(__self__, "recommended_configuration", recommended_configuration)
        if supported_configurations is not None:
            pulumi.set(__self__, "supported_configurations", supported_configurations)

    @property
    @pulumi.getter(name="recommendedConfiguration")
    def recommended_configuration(self) -> Optional['outputs.DiskVolumeConfigurationResponse']:
        """
        The recommended disk details for a given VM Sku.
        """
        return pulumi.get(self, "recommended_configuration")

    @property
    @pulumi.getter(name="supportedConfigurations")
    def supported_configurations(self) -> Optional[Sequence['outputs.DiskDetailsResponse']]:
        """
        The list of supported disks for a given VM Sku.
        """
        return pulumi.get(self, "supported_configurations")


@pulumi.output_type
class SAPInstallWithoutOSConfigSoftwareConfigurationResponse(dict):
    """
    The SAP Software configuration Input when the software is to be installed by service without OS Configurations
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bomUrl":
            suggest = "bom_url"
        elif key == "sapBitsStorageAccountId":
            suggest = "sap_bits_storage_account_id"
        elif key == "softwareInstallationType":
            suggest = "software_installation_type"
        elif key == "softwareVersion":
            suggest = "software_version"
        elif key == "highAvailabilitySoftwareConfiguration":
            suggest = "high_availability_software_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SAPInstallWithoutOSConfigSoftwareConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SAPInstallWithoutOSConfigSoftwareConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SAPInstallWithoutOSConfigSoftwareConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bom_url: str,
                 sap_bits_storage_account_id: str,
                 software_installation_type: str,
                 software_version: str,
                 high_availability_software_configuration: Optional['outputs.HighAvailabilitySoftwareConfigurationResponse'] = None):
        """
        The SAP Software configuration Input when the software is to be installed by service without OS Configurations
        :param str bom_url: The URL to the SAP Build of Materials(BOM) file.
        :param str sap_bits_storage_account_id: The SAP bits storage account id.
        :param str software_installation_type: The SAP software installation Type.
               Expected value is 'SAPInstallWithoutOSConfig'.
        :param str software_version: The software version to install.
        :param 'HighAvailabilitySoftwareConfigurationResponse' high_availability_software_configuration: Gets or sets the HA software configuration.
        """
        pulumi.set(__self__, "bom_url", bom_url)
        pulumi.set(__self__, "sap_bits_storage_account_id", sap_bits_storage_account_id)
        pulumi.set(__self__, "software_installation_type", 'SAPInstallWithoutOSConfig')
        pulumi.set(__self__, "software_version", software_version)
        if high_availability_software_configuration is not None:
            pulumi.set(__self__, "high_availability_software_configuration", high_availability_software_configuration)

    @property
    @pulumi.getter(name="bomUrl")
    def bom_url(self) -> str:
        """
        The URL to the SAP Build of Materials(BOM) file.
        """
        return pulumi.get(self, "bom_url")

    @property
    @pulumi.getter(name="sapBitsStorageAccountId")
    def sap_bits_storage_account_id(self) -> str:
        """
        The SAP bits storage account id.
        """
        return pulumi.get(self, "sap_bits_storage_account_id")

    @property
    @pulumi.getter(name="softwareInstallationType")
    def software_installation_type(self) -> str:
        """
        The SAP software installation Type.
        Expected value is 'SAPInstallWithoutOSConfig'.
        """
        return pulumi.get(self, "software_installation_type")

    @property
    @pulumi.getter(name="softwareVersion")
    def software_version(self) -> str:
        """
        The software version to install.
        """
        return pulumi.get(self, "software_version")

    @property
    @pulumi.getter(name="highAvailabilitySoftwareConfiguration")
    def high_availability_software_configuration(self) -> Optional['outputs.HighAvailabilitySoftwareConfigurationResponse']:
        """
        Gets or sets the HA software configuration.
        """
        return pulumi.get(self, "high_availability_software_configuration")


@pulumi.output_type
class SAPSupportedSkuResponse(dict):
    """
    The SAP supported SKU.
    """
    def __init__(__self__, *,
                 is_app_server_certified: Optional[bool] = None,
                 is_database_certified: Optional[bool] = None,
                 vm_sku: Optional[str] = None):
        """
        The SAP supported SKU.
        :param bool is_app_server_certified: True if the Sku is certified for App server in the SAP system.
        :param bool is_database_certified: True if the Sku is certified for Database server in the SAP system.
        :param str vm_sku: The VM Sku.
        """
        if is_app_server_certified is not None:
            pulumi.set(__self__, "is_app_server_certified", is_app_server_certified)
        if is_database_certified is not None:
            pulumi.set(__self__, "is_database_certified", is_database_certified)
        if vm_sku is not None:
            pulumi.set(__self__, "vm_sku", vm_sku)

    @property
    @pulumi.getter(name="isAppServerCertified")
    def is_app_server_certified(self) -> Optional[bool]:
        """
        True if the Sku is certified for App server in the SAP system.
        """
        return pulumi.get(self, "is_app_server_certified")

    @property
    @pulumi.getter(name="isDatabaseCertified")
    def is_database_certified(self) -> Optional[bool]:
        """
        True if the Sku is certified for Database server in the SAP system.
        """
        return pulumi.get(self, "is_database_certified")

    @property
    @pulumi.getter(name="vmSku")
    def vm_sku(self) -> Optional[str]:
        """
        The VM Sku.
        """
        return pulumi.get(self, "vm_sku")


@pulumi.output_type
class SAPVirtualInstanceErrorResponse(dict):
    """
    An error response from the Virtual Instance for SAP Workload service.
    """
    def __init__(__self__, *,
                 properties: Optional['outputs.ErrorDefinitionResponse'] = None):
        """
        An error response from the Virtual Instance for SAP Workload service.
        :param 'ErrorDefinitionResponse' properties: The Virtual Instance for SAP error body.
        """
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter
    def properties(self) -> Optional['outputs.ErrorDefinitionResponse']:
        """
        The Virtual Instance for SAP error body.
        """
        return pulumi.get(self, "properties")


@pulumi.output_type
class SapLandscapeMonitorMetricThresholdsResponse(dict):
    """
    Gets or sets the Threshold Values for Top Metrics Health.
    """
    def __init__(__self__, *,
                 green: Optional[float] = None,
                 name: Optional[str] = None,
                 red: Optional[float] = None,
                 yellow: Optional[float] = None):
        """
        Gets or sets the Threshold Values for Top Metrics Health.
        :param float green: Gets or sets the threshold value for Green.
        :param str name: Gets or sets the name of the threshold.
        :param float red: Gets or sets the threshold value for Red.
        :param float yellow: Gets or sets the threshold value for Yellow.
        """
        if green is not None:
            pulumi.set(__self__, "green", green)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if red is not None:
            pulumi.set(__self__, "red", red)
        if yellow is not None:
            pulumi.set(__self__, "yellow", yellow)

    @property
    @pulumi.getter
    def green(self) -> Optional[float]:
        """
        Gets or sets the threshold value for Green.
        """
        return pulumi.get(self, "green")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Gets or sets the name of the threshold.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def red(self) -> Optional[float]:
        """
        Gets or sets the threshold value for Red.
        """
        return pulumi.get(self, "red")

    @property
    @pulumi.getter
    def yellow(self) -> Optional[float]:
        """
        Gets or sets the threshold value for Yellow.
        """
        return pulumi.get(self, "yellow")


@pulumi.output_type
class SapLandscapeMonitorPropertiesResponseGrouping(dict):
    """
    Gets or sets the SID groupings by landscape and Environment.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sapApplication":
            suggest = "sap_application"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SapLandscapeMonitorPropertiesResponseGrouping. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SapLandscapeMonitorPropertiesResponseGrouping.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SapLandscapeMonitorPropertiesResponseGrouping.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 landscape: Optional[Sequence['outputs.SapLandscapeMonitorSidMappingResponse']] = None,
                 sap_application: Optional[Sequence['outputs.SapLandscapeMonitorSidMappingResponse']] = None):
        """
        Gets or sets the SID groupings by landscape and Environment.
        :param Sequence['SapLandscapeMonitorSidMappingResponse'] landscape: Gets or sets the list of landscape to SID mappings.
        :param Sequence['SapLandscapeMonitorSidMappingResponse'] sap_application: Gets or sets the list of Sap Applications to SID mappings.
        """
        if landscape is not None:
            pulumi.set(__self__, "landscape", landscape)
        if sap_application is not None:
            pulumi.set(__self__, "sap_application", sap_application)

    @property
    @pulumi.getter
    def landscape(self) -> Optional[Sequence['outputs.SapLandscapeMonitorSidMappingResponse']]:
        """
        Gets or sets the list of landscape to SID mappings.
        """
        return pulumi.get(self, "landscape")

    @property
    @pulumi.getter(name="sapApplication")
    def sap_application(self) -> Optional[Sequence['outputs.SapLandscapeMonitorSidMappingResponse']]:
        """
        Gets or sets the list of Sap Applications to SID mappings.
        """
        return pulumi.get(self, "sap_application")


@pulumi.output_type
class SapLandscapeMonitorSidMappingResponse(dict):
    """
    Gets or sets the mapping for SID to Environment/Applications.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "topSid":
            suggest = "top_sid"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SapLandscapeMonitorSidMappingResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SapLandscapeMonitorSidMappingResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SapLandscapeMonitorSidMappingResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: Optional[str] = None,
                 top_sid: Optional[Sequence[str]] = None):
        """
        Gets or sets the mapping for SID to Environment/Applications.
        :param str name: Gets or sets the name of the grouping.
        :param Sequence[str] top_sid: Gets or sets the list of SID's.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if top_sid is not None:
            pulumi.set(__self__, "top_sid", top_sid)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Gets or sets the name of the grouping.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="topSid")
    def top_sid(self) -> Optional[Sequence[str]]:
        """
        Gets or sets the list of SID's.
        """
        return pulumi.get(self, "top_sid")


@pulumi.output_type
class SapNetWeaverProviderInstancePropertiesResponse(dict):
    """
    Gets or sets the provider properties.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "providerType":
            suggest = "provider_type"
        elif key == "sapClientId":
            suggest = "sap_client_id"
        elif key == "sapHostFileEntries":
            suggest = "sap_host_file_entries"
        elif key == "sapHostname":
            suggest = "sap_hostname"
        elif key == "sapInstanceNr":
            suggest = "sap_instance_nr"
        elif key == "sapPassword":
            suggest = "sap_password"
        elif key == "sapPasswordUri":
            suggest = "sap_password_uri"
        elif key == "sapPortNumber":
            suggest = "sap_port_number"
        elif key == "sapSid":
            suggest = "sap_sid"
        elif key == "sapUsername":
            suggest = "sap_username"
        elif key == "sslCertificateUri":
            suggest = "ssl_certificate_uri"
        elif key == "sslPreference":
            suggest = "ssl_preference"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SapNetWeaverProviderInstancePropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SapNetWeaverProviderInstancePropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SapNetWeaverProviderInstancePropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 provider_type: str,
                 sap_client_id: Optional[str] = None,
                 sap_host_file_entries: Optional[Sequence[str]] = None,
                 sap_hostname: Optional[str] = None,
                 sap_instance_nr: Optional[str] = None,
                 sap_password: Optional[str] = None,
                 sap_password_uri: Optional[str] = None,
                 sap_port_number: Optional[str] = None,
                 sap_sid: Optional[str] = None,
                 sap_username: Optional[str] = None,
                 ssl_certificate_uri: Optional[str] = None,
                 ssl_preference: Optional[str] = None):
        """
        Gets or sets the provider properties.
        :param str provider_type: The provider type. For example, the value can be SapHana.
               Expected value is 'SapNetWeaver'.
        :param str sap_client_id: Gets or sets the SAP Client ID.
        :param Sequence[str] sap_host_file_entries: Gets or sets the list of HostFile Entries
        :param str sap_hostname: Gets or sets the target virtual machine IP Address/FQDN.
        :param str sap_instance_nr: Gets or sets the instance number of SAP NetWeaver.
        :param str sap_password: Sets the SAP password.
        :param str sap_password_uri: Gets or sets the key vault URI to secret with the SAP password.
        :param str sap_port_number: Gets or sets the SAP HTTP port number.
        :param str sap_sid: Gets or sets the SAP System Identifier
        :param str sap_username: Gets or sets the SAP user name.
        :param str ssl_certificate_uri: Gets or sets the blob URI to SSL certificate for the SAP system.
        :param str ssl_preference: Gets or sets certificate preference if secure communication is enabled.
        """
        pulumi.set(__self__, "provider_type", 'SapNetWeaver')
        if sap_client_id is not None:
            pulumi.set(__self__, "sap_client_id", sap_client_id)
        if sap_host_file_entries is not None:
            pulumi.set(__self__, "sap_host_file_entries", sap_host_file_entries)
        if sap_hostname is not None:
            pulumi.set(__self__, "sap_hostname", sap_hostname)
        if sap_instance_nr is not None:
            pulumi.set(__self__, "sap_instance_nr", sap_instance_nr)
        if sap_password is not None:
            pulumi.set(__self__, "sap_password", sap_password)
        if sap_password_uri is not None:
            pulumi.set(__self__, "sap_password_uri", sap_password_uri)
        if sap_port_number is not None:
            pulumi.set(__self__, "sap_port_number", sap_port_number)
        if sap_sid is not None:
            pulumi.set(__self__, "sap_sid", sap_sid)
        if sap_username is not None:
            pulumi.set(__self__, "sap_username", sap_username)
        if ssl_certificate_uri is not None:
            pulumi.set(__self__, "ssl_certificate_uri", ssl_certificate_uri)
        if ssl_preference is not None:
            pulumi.set(__self__, "ssl_preference", ssl_preference)

    @property
    @pulumi.getter(name="providerType")
    def provider_type(self) -> str:
        """
        The provider type. For example, the value can be SapHana.
        Expected value is 'SapNetWeaver'.
        """
        return pulumi.get(self, "provider_type")

    @property
    @pulumi.getter(name="sapClientId")
    def sap_client_id(self) -> Optional[str]:
        """
        Gets or sets the SAP Client ID.
        """
        return pulumi.get(self, "sap_client_id")

    @property
    @pulumi.getter(name="sapHostFileEntries")
    def sap_host_file_entries(self) -> Optional[Sequence[str]]:
        """
        Gets or sets the list of HostFile Entries
        """
        return pulumi.get(self, "sap_host_file_entries")

    @property
    @pulumi.getter(name="sapHostname")
    def sap_hostname(self) -> Optional[str]:
        """
        Gets or sets the target virtual machine IP Address/FQDN.
        """
        return pulumi.get(self, "sap_hostname")

    @property
    @pulumi.getter(name="sapInstanceNr")
    def sap_instance_nr(self) -> Optional[str]:
        """
        Gets or sets the instance number of SAP NetWeaver.
        """
        return pulumi.get(self, "sap_instance_nr")

    @property
    @pulumi.getter(name="sapPassword")
    def sap_password(self) -> Optional[str]:
        """
        Sets the SAP password.
        """
        return pulumi.get(self, "sap_password")

    @property
    @pulumi.getter(name="sapPasswordUri")
    def sap_password_uri(self) -> Optional[str]:
        """
        Gets or sets the key vault URI to secret with the SAP password.
        """
        return pulumi.get(self, "sap_password_uri")

    @property
    @pulumi.getter(name="sapPortNumber")
    def sap_port_number(self) -> Optional[str]:
        """
        Gets or sets the SAP HTTP port number.
        """
        return pulumi.get(self, "sap_port_number")

    @property
    @pulumi.getter(name="sapSid")
    def sap_sid(self) -> Optional[str]:
        """
        Gets or sets the SAP System Identifier
        """
        return pulumi.get(self, "sap_sid")

    @property
    @pulumi.getter(name="sapUsername")
    def sap_username(self) -> Optional[str]:
        """
        Gets or sets the SAP user name.
        """
        return pulumi.get(self, "sap_username")

    @property
    @pulumi.getter(name="sslCertificateUri")
    def ssl_certificate_uri(self) -> Optional[str]:
        """
        Gets or sets the blob URI to SSL certificate for the SAP system.
        """
        return pulumi.get(self, "ssl_certificate_uri")

    @property
    @pulumi.getter(name="sslPreference")
    def ssl_preference(self) -> Optional[str]:
        """
        Gets or sets certificate preference if secure communication is enabled.
        """
        return pulumi.get(self, "ssl_preference")


@pulumi.output_type
class ServiceInitiatedSoftwareConfigurationResponse(dict):
    """
    The SAP Software configuration Input when the software is to be installed by service.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bomUrl":
            suggest = "bom_url"
        elif key == "sapBitsStorageAccountId":
            suggest = "sap_bits_storage_account_id"
        elif key == "sapFqdn":
            suggest = "sap_fqdn"
        elif key == "softwareInstallationType":
            suggest = "software_installation_type"
        elif key == "softwareVersion":
            suggest = "software_version"
        elif key == "sshPrivateKey":
            suggest = "ssh_private_key"
        elif key == "highAvailabilitySoftwareConfiguration":
            suggest = "high_availability_software_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceInitiatedSoftwareConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceInitiatedSoftwareConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceInitiatedSoftwareConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bom_url: str,
                 sap_bits_storage_account_id: str,
                 sap_fqdn: str,
                 software_installation_type: str,
                 software_version: str,
                 ssh_private_key: str,
                 high_availability_software_configuration: Optional['outputs.HighAvailabilitySoftwareConfigurationResponse'] = None):
        """
        The SAP Software configuration Input when the software is to be installed by service.
        :param str bom_url: The URL to the SAP Build of Materials(BOM) file.
        :param str sap_bits_storage_account_id: The SAP bits storage account id.
        :param str sap_fqdn: The FQDN to set for the SAP system during install.
        :param str software_installation_type: The SAP software installation Type.
               Expected value is 'ServiceInitiated'.
        :param str software_version: The software version to install.
        :param str ssh_private_key: The SSH private key.
        :param 'HighAvailabilitySoftwareConfigurationResponse' high_availability_software_configuration: Gets or sets the HA software configuration.
        """
        pulumi.set(__self__, "bom_url", bom_url)
        pulumi.set(__self__, "sap_bits_storage_account_id", sap_bits_storage_account_id)
        pulumi.set(__self__, "sap_fqdn", sap_fqdn)
        pulumi.set(__self__, "software_installation_type", 'ServiceInitiated')
        pulumi.set(__self__, "software_version", software_version)
        pulumi.set(__self__, "ssh_private_key", ssh_private_key)
        if high_availability_software_configuration is not None:
            pulumi.set(__self__, "high_availability_software_configuration", high_availability_software_configuration)

    @property
    @pulumi.getter(name="bomUrl")
    def bom_url(self) -> str:
        """
        The URL to the SAP Build of Materials(BOM) file.
        """
        return pulumi.get(self, "bom_url")

    @property
    @pulumi.getter(name="sapBitsStorageAccountId")
    def sap_bits_storage_account_id(self) -> str:
        """
        The SAP bits storage account id.
        """
        return pulumi.get(self, "sap_bits_storage_account_id")

    @property
    @pulumi.getter(name="sapFqdn")
    def sap_fqdn(self) -> str:
        """
        The FQDN to set for the SAP system during install.
        """
        return pulumi.get(self, "sap_fqdn")

    @property
    @pulumi.getter(name="softwareInstallationType")
    def software_installation_type(self) -> str:
        """
        The SAP software installation Type.
        Expected value is 'ServiceInitiated'.
        """
        return pulumi.get(self, "software_installation_type")

    @property
    @pulumi.getter(name="softwareVersion")
    def software_version(self) -> str:
        """
        The software version to install.
        """
        return pulumi.get(self, "software_version")

    @property
    @pulumi.getter(name="sshPrivateKey")
    def ssh_private_key(self) -> str:
        """
        The SSH private key.
        """
        return pulumi.get(self, "ssh_private_key")

    @property
    @pulumi.getter(name="highAvailabilitySoftwareConfiguration")
    def high_availability_software_configuration(self) -> Optional['outputs.HighAvailabilitySoftwareConfigurationResponse']:
        """
        Gets or sets the HA software configuration.
        """
        return pulumi.get(self, "high_availability_software_configuration")


@pulumi.output_type
class SharedStorageResourceNamesResponse(dict):
    """
    The resource names object for shared storage.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sharedStorageAccountName":
            suggest = "shared_storage_account_name"
        elif key == "sharedStorageAccountPrivateEndPointName":
            suggest = "shared_storage_account_private_end_point_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SharedStorageResourceNamesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SharedStorageResourceNamesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SharedStorageResourceNamesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 shared_storage_account_name: Optional[str] = None,
                 shared_storage_account_private_end_point_name: Optional[str] = None):
        """
        The resource names object for shared storage.
        :param str shared_storage_account_name: The full name of the shared storage account. If it is not provided, it will be defaulted to {SID}nfs{guid of 15 chars}.
        :param str shared_storage_account_private_end_point_name: The full name of private end point for the shared storage account. If it is not provided, it will be defaulted to {storageAccountName}_pe
        """
        if shared_storage_account_name is not None:
            pulumi.set(__self__, "shared_storage_account_name", shared_storage_account_name)
        if shared_storage_account_private_end_point_name is not None:
            pulumi.set(__self__, "shared_storage_account_private_end_point_name", shared_storage_account_private_end_point_name)

    @property
    @pulumi.getter(name="sharedStorageAccountName")
    def shared_storage_account_name(self) -> Optional[str]:
        """
        The full name of the shared storage account. If it is not provided, it will be defaulted to {SID}nfs{guid of 15 chars}.
        """
        return pulumi.get(self, "shared_storage_account_name")

    @property
    @pulumi.getter(name="sharedStorageAccountPrivateEndPointName")
    def shared_storage_account_private_end_point_name(self) -> Optional[str]:
        """
        The full name of private end point for the shared storage account. If it is not provided, it will be defaulted to {storageAccountName}_pe
        """
        return pulumi.get(self, "shared_storage_account_private_end_point_name")


@pulumi.output_type
class SingleServerConfigurationResponse(dict):
    """
    Gets or sets the single server configuration. For prerequisites for creating the infrastructure, please see [here](https://go.microsoft.com/fwlink/?linkid=2212611&clcid=0x409)
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appResourceGroup":
            suggest = "app_resource_group"
        elif key == "deploymentType":
            suggest = "deployment_type"
        elif key == "subnetId":
            suggest = "subnet_id"
        elif key == "virtualMachineConfiguration":
            suggest = "virtual_machine_configuration"
        elif key == "customResourceNames":
            suggest = "custom_resource_names"
        elif key == "databaseType":
            suggest = "database_type"
        elif key == "dbDiskConfiguration":
            suggest = "db_disk_configuration"
        elif key == "networkConfiguration":
            suggest = "network_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SingleServerConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SingleServerConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SingleServerConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 app_resource_group: str,
                 deployment_type: str,
                 subnet_id: str,
                 virtual_machine_configuration: 'outputs.VirtualMachineConfigurationResponse',
                 custom_resource_names: Optional['outputs.SingleServerFullResourceNamesResponse'] = None,
                 database_type: Optional[str] = None,
                 db_disk_configuration: Optional['outputs.DiskConfigurationResponse'] = None,
                 network_configuration: Optional['outputs.NetworkConfigurationResponse'] = None):
        """
        Gets or sets the single server configuration. For prerequisites for creating the infrastructure, please see [here](https://go.microsoft.com/fwlink/?linkid=2212611&clcid=0x409)
        :param str app_resource_group: The application resource group where SAP system resources will be deployed.
        :param str deployment_type: The type of SAP deployment, single server or Three tier.
               Expected value is 'SingleServer'.
        :param str subnet_id: The subnet id.
        :param 'VirtualMachineConfigurationResponse' virtual_machine_configuration: Gets or sets the virtual machine configuration.
        :param 'SingleServerFullResourceNamesResponse' custom_resource_names: The set of custom names to be used for underlying azure resources that are part of the SAP system.
        :param str database_type: The database type.
        :param 'DiskConfigurationResponse' db_disk_configuration: Gets or sets the disk configuration.
        :param 'NetworkConfigurationResponse' network_configuration: Network configuration for the server
        """
        pulumi.set(__self__, "app_resource_group", app_resource_group)
        pulumi.set(__self__, "deployment_type", 'SingleServer')
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "virtual_machine_configuration", virtual_machine_configuration)
        if custom_resource_names is not None:
            pulumi.set(__self__, "custom_resource_names", custom_resource_names)
        if database_type is not None:
            pulumi.set(__self__, "database_type", database_type)
        if db_disk_configuration is not None:
            pulumi.set(__self__, "db_disk_configuration", db_disk_configuration)
        if network_configuration is not None:
            pulumi.set(__self__, "network_configuration", network_configuration)

    @property
    @pulumi.getter(name="appResourceGroup")
    def app_resource_group(self) -> str:
        """
        The application resource group where SAP system resources will be deployed.
        """
        return pulumi.get(self, "app_resource_group")

    @property
    @pulumi.getter(name="deploymentType")
    def deployment_type(self) -> str:
        """
        The type of SAP deployment, single server or Three tier.
        Expected value is 'SingleServer'.
        """
        return pulumi.get(self, "deployment_type")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        """
        The subnet id.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="virtualMachineConfiguration")
    def virtual_machine_configuration(self) -> 'outputs.VirtualMachineConfigurationResponse':
        """
        Gets or sets the virtual machine configuration.
        """
        return pulumi.get(self, "virtual_machine_configuration")

    @property
    @pulumi.getter(name="customResourceNames")
    def custom_resource_names(self) -> Optional['outputs.SingleServerFullResourceNamesResponse']:
        """
        The set of custom names to be used for underlying azure resources that are part of the SAP system.
        """
        return pulumi.get(self, "custom_resource_names")

    @property
    @pulumi.getter(name="databaseType")
    def database_type(self) -> Optional[str]:
        """
        The database type.
        """
        return pulumi.get(self, "database_type")

    @property
    @pulumi.getter(name="dbDiskConfiguration")
    def db_disk_configuration(self) -> Optional['outputs.DiskConfigurationResponse']:
        """
        Gets or sets the disk configuration.
        """
        return pulumi.get(self, "db_disk_configuration")

    @property
    @pulumi.getter(name="networkConfiguration")
    def network_configuration(self) -> Optional['outputs.NetworkConfigurationResponse']:
        """
        Network configuration for the server
        """
        return pulumi.get(self, "network_configuration")


@pulumi.output_type
class SingleServerFullResourceNamesResponse(dict):
    """
    The resource name object where the specified values will be full resource names of the corresponding resources in a single server SAP system.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "namingPatternType":
            suggest = "naming_pattern_type"
        elif key == "virtualMachine":
            suggest = "virtual_machine"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SingleServerFullResourceNamesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SingleServerFullResourceNamesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SingleServerFullResourceNamesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 naming_pattern_type: str,
                 virtual_machine: Optional['outputs.VirtualMachineResourceNamesResponse'] = None):
        """
        The resource name object where the specified values will be full resource names of the corresponding resources in a single server SAP system.
        :param str naming_pattern_type: The pattern type to be used for resource naming.
               Expected value is 'FullResourceName'.
        :param 'VirtualMachineResourceNamesResponse' virtual_machine: The resource names object for virtual machine and related resources.
        """
        pulumi.set(__self__, "naming_pattern_type", 'FullResourceName')
        if virtual_machine is not None:
            pulumi.set(__self__, "virtual_machine", virtual_machine)

    @property
    @pulumi.getter(name="namingPatternType")
    def naming_pattern_type(self) -> str:
        """
        The pattern type to be used for resource naming.
        Expected value is 'FullResourceName'.
        """
        return pulumi.get(self, "naming_pattern_type")

    @property
    @pulumi.getter(name="virtualMachine")
    def virtual_machine(self) -> Optional['outputs.VirtualMachineResourceNamesResponse']:
        """
        The resource names object for virtual machine and related resources.
        """
        return pulumi.get(self, "virtual_machine")


@pulumi.output_type
class SkipFileShareConfigurationResponse(dict):
    """
    Gets or sets the file share configuration for scenarios where transport directory fileshare is not created or required.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "configurationType":
            suggest = "configuration_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SkipFileShareConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SkipFileShareConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SkipFileShareConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 configuration_type: str):
        """
        Gets or sets the file share configuration for scenarios where transport directory fileshare is not created or required.
        :param str configuration_type: The type of file share config.
               Expected value is 'Skip'.
        """
        pulumi.set(__self__, "configuration_type", 'Skip')

    @property
    @pulumi.getter(name="configurationType")
    def configuration_type(self) -> str:
        """
        The type of file share config.
        Expected value is 'Skip'.
        """
        return pulumi.get(self, "configuration_type")


@pulumi.output_type
class SshConfigurationResponse(dict):
    """
    SSH configuration for Linux based VMs running on Azure
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "publicKeys":
            suggest = "public_keys"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SshConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SshConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SshConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 public_keys: Optional[Sequence['outputs.SshPublicKeyResponse']] = None):
        """
        SSH configuration for Linux based VMs running on Azure
        :param Sequence['SshPublicKeyResponse'] public_keys: The list of SSH public keys used to authenticate with linux based VMs.
        """
        if public_keys is not None:
            pulumi.set(__self__, "public_keys", public_keys)

    @property
    @pulumi.getter(name="publicKeys")
    def public_keys(self) -> Optional[Sequence['outputs.SshPublicKeyResponse']]:
        """
        The list of SSH public keys used to authenticate with linux based VMs.
        """
        return pulumi.get(self, "public_keys")


@pulumi.output_type
class SshKeyPairResponse(dict):
    """
    The SSH Key-pair used to authenticate with the VM. The key needs to be at least 2048-bit and in ssh-rsa format. <br><br> For creating ssh keys, see [Create SSH keys on Linux and Mac for Linux VMs in Azure](https://docs.microsoft.com/azure/virtual-machines/linux/create-ssh-keys-detailed).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateKey":
            suggest = "private_key"
        elif key == "publicKey":
            suggest = "public_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SshKeyPairResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SshKeyPairResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SshKeyPairResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 private_key: Optional[str] = None,
                 public_key: Optional[str] = None):
        """
        The SSH Key-pair used to authenticate with the VM. The key needs to be at least 2048-bit and in ssh-rsa format. <br><br> For creating ssh keys, see [Create SSH keys on Linux and Mac for Linux VMs in Azure](https://docs.microsoft.com/azure/virtual-machines/linux/create-ssh-keys-detailed).
        :param str private_key: SSH private key.
        :param str public_key: SSH public key
        """
        if private_key is not None:
            pulumi.set(__self__, "private_key", private_key)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> Optional[str]:
        """
        SSH private key.
        """
        return pulumi.get(self, "private_key")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[str]:
        """
        SSH public key
        """
        return pulumi.get(self, "public_key")


@pulumi.output_type
class SshPublicKeyResponse(dict):
    """
    Contains information about SSH certificate public key and the path on the Linux VM where the public key is placed.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyData":
            suggest = "key_data"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SshPublicKeyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SshPublicKeyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SshPublicKeyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_data: Optional[str] = None):
        """
        Contains information about SSH certificate public key and the path on the Linux VM where the public key is placed.
        :param str key_data: SSH public key certificate used to authenticate with the VM through ssh. The key needs to be at least 2048-bit and in ssh-rsa format. <br><br> For creating ssh keys, see [Create SSH keys on Linux and Mac for Linux VMs in Azure](https://docs.microsoft.com/azure/virtual-machines/linux/create-ssh-keys-detailed).
        """
        if key_data is not None:
            pulumi.set(__self__, "key_data", key_data)

    @property
    @pulumi.getter(name="keyData")
    def key_data(self) -> Optional[str]:
        """
        SSH public key certificate used to authenticate with the VM through ssh. The key needs to be at least 2048-bit and in ssh-rsa format. <br><br> For creating ssh keys, see [Create SSH keys on Linux and Mac for Linux VMs in Azure](https://docs.microsoft.com/azure/virtual-machines/linux/create-ssh-keys-detailed).
        """
        return pulumi.get(self, "key_data")


@pulumi.output_type
class StorageConfigurationResponse(dict):
    """
    Gets or sets the storage configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "transportFileShareConfiguration":
            suggest = "transport_file_share_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StorageConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StorageConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StorageConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 transport_file_share_configuration: Optional[Any] = None):
        """
        Gets or sets the storage configuration.
        :param Union['CreateAndMountFileShareConfigurationResponse', 'MountFileShareConfigurationResponse', 'SkipFileShareConfigurationResponse'] transport_file_share_configuration: The properties of the transport directory attached to the VIS. The default for transportFileShareConfiguration is the createAndMount flow if storage configuration is missing.
        """
        if transport_file_share_configuration is not None:
            pulumi.set(__self__, "transport_file_share_configuration", transport_file_share_configuration)

    @property
    @pulumi.getter(name="transportFileShareConfiguration")
    def transport_file_share_configuration(self) -> Optional[Any]:
        """
        The properties of the transport directory attached to the VIS. The default for transportFileShareConfiguration is the createAndMount flow if storage configuration is missing.
        """
        return pulumi.get(self, "transport_file_share_configuration")


@pulumi.output_type
class StorageInformationResponse(dict):
    """
    Storage details of all the Storage accounts attached to the VM. For e.g. NFS on AFS Shared Storage. 
    """
    def __init__(__self__, *,
                 id: str):
        """
        Storage details of all the Storage accounts attached to the VM. For e.g. NFS on AFS Shared Storage. 
        """
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")


@pulumi.output_type
class SystemDataResponse(dict):
    """
    Metadata pertaining to creation and last modification of the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "createdBy":
            suggest = "created_by"
        elif key == "createdByType":
            suggest = "created_by_type"
        elif key == "lastModifiedAt":
            suggest = "last_modified_at"
        elif key == "lastModifiedBy":
            suggest = "last_modified_by"
        elif key == "lastModifiedByType":
            suggest = "last_modified_by_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SystemDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: Optional[str] = None,
                 created_by: Optional[str] = None,
                 created_by_type: Optional[str] = None,
                 last_modified_at: Optional[str] = None,
                 last_modified_by: Optional[str] = None,
                 last_modified_by_type: Optional[str] = None):
        """
        Metadata pertaining to creation and last modification of the resource.
        :param str created_at: The timestamp of resource creation (UTC).
        :param str created_by: The identity that created the resource.
        :param str created_by_type: The type of identity that created the resource.
        :param str last_modified_at: The timestamp of resource last modification (UTC)
        :param str last_modified_by: The identity that last modified the resource.
        :param str last_modified_by_type: The type of identity that last modified the resource.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_by_type is not None:
            pulumi.set(__self__, "created_by_type", created_by_type)
        if last_modified_at is not None:
            pulumi.set(__self__, "last_modified_at", last_modified_at)
        if last_modified_by is not None:
            pulumi.set(__self__, "last_modified_by", last_modified_by)
        if last_modified_by_type is not None:
            pulumi.set(__self__, "last_modified_by_type", last_modified_by_type)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The timestamp of resource creation (UTC).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[str]:
        """
        The identity that created the resource.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="createdByType")
    def created_by_type(self) -> Optional[str]:
        """
        The type of identity that created the resource.
        """
        return pulumi.get(self, "created_by_type")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> Optional[str]:
        """
        The timestamp of resource last modification (UTC)
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> Optional[str]:
        """
        The identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by")

    @property
    @pulumi.getter(name="lastModifiedByType")
    def last_modified_by_type(self) -> Optional[str]:
        """
        The type of identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by_type")


@pulumi.output_type
class ThreeTierConfigurationResponse(dict):
    """
    Gets or sets the three tier SAP configuration. For prerequisites for creating the infrastructure, please see [here](https://go.microsoft.com/fwlink/?linkid=2212611&clcid=0x409)
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appResourceGroup":
            suggest = "app_resource_group"
        elif key == "applicationServer":
            suggest = "application_server"
        elif key == "centralServer":
            suggest = "central_server"
        elif key == "databaseServer":
            suggest = "database_server"
        elif key == "deploymentType":
            suggest = "deployment_type"
        elif key == "customResourceNames":
            suggest = "custom_resource_names"
        elif key == "highAvailabilityConfig":
            suggest = "high_availability_config"
        elif key == "networkConfiguration":
            suggest = "network_configuration"
        elif key == "storageConfiguration":
            suggest = "storage_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ThreeTierConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ThreeTierConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ThreeTierConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 app_resource_group: str,
                 application_server: 'outputs.ApplicationServerConfigurationResponse',
                 central_server: 'outputs.CentralServerConfigurationResponse',
                 database_server: 'outputs.DatabaseConfigurationResponse',
                 deployment_type: str,
                 custom_resource_names: Optional['outputs.ThreeTierFullResourceNamesResponse'] = None,
                 high_availability_config: Optional['outputs.HighAvailabilityConfigurationResponse'] = None,
                 network_configuration: Optional['outputs.NetworkConfigurationResponse'] = None,
                 storage_configuration: Optional['outputs.StorageConfigurationResponse'] = None):
        """
        Gets or sets the three tier SAP configuration. For prerequisites for creating the infrastructure, please see [here](https://go.microsoft.com/fwlink/?linkid=2212611&clcid=0x409)
        :param str app_resource_group: The application resource group where SAP system resources will be deployed.
        :param 'ApplicationServerConfigurationResponse' application_server: The application server configuration.
        :param 'CentralServerConfigurationResponse' central_server: The central server configuration.
        :param 'DatabaseConfigurationResponse' database_server: The database configuration.
        :param str deployment_type: The type of SAP deployment, single server or Three tier.
               Expected value is 'ThreeTier'.
        :param 'ThreeTierFullResourceNamesResponse' custom_resource_names: The set of custom names to be used for underlying azure resources that are part of the SAP system.
        :param 'HighAvailabilityConfigurationResponse' high_availability_config: The high availability configuration.
        :param 'NetworkConfigurationResponse' network_configuration: Network configuration common to all servers
        :param 'StorageConfigurationResponse' storage_configuration: The storage configuration.
        """
        pulumi.set(__self__, "app_resource_group", app_resource_group)
        pulumi.set(__self__, "application_server", application_server)
        pulumi.set(__self__, "central_server", central_server)
        pulumi.set(__self__, "database_server", database_server)
        pulumi.set(__self__, "deployment_type", 'ThreeTier')
        if custom_resource_names is not None:
            pulumi.set(__self__, "custom_resource_names", custom_resource_names)
        if high_availability_config is not None:
            pulumi.set(__self__, "high_availability_config", high_availability_config)
        if network_configuration is not None:
            pulumi.set(__self__, "network_configuration", network_configuration)
        if storage_configuration is not None:
            pulumi.set(__self__, "storage_configuration", storage_configuration)

    @property
    @pulumi.getter(name="appResourceGroup")
    def app_resource_group(self) -> str:
        """
        The application resource group where SAP system resources will be deployed.
        """
        return pulumi.get(self, "app_resource_group")

    @property
    @pulumi.getter(name="applicationServer")
    def application_server(self) -> 'outputs.ApplicationServerConfigurationResponse':
        """
        The application server configuration.
        """
        return pulumi.get(self, "application_server")

    @property
    @pulumi.getter(name="centralServer")
    def central_server(self) -> 'outputs.CentralServerConfigurationResponse':
        """
        The central server configuration.
        """
        return pulumi.get(self, "central_server")

    @property
    @pulumi.getter(name="databaseServer")
    def database_server(self) -> 'outputs.DatabaseConfigurationResponse':
        """
        The database configuration.
        """
        return pulumi.get(self, "database_server")

    @property
    @pulumi.getter(name="deploymentType")
    def deployment_type(self) -> str:
        """
        The type of SAP deployment, single server or Three tier.
        Expected value is 'ThreeTier'.
        """
        return pulumi.get(self, "deployment_type")

    @property
    @pulumi.getter(name="customResourceNames")
    def custom_resource_names(self) -> Optional['outputs.ThreeTierFullResourceNamesResponse']:
        """
        The set of custom names to be used for underlying azure resources that are part of the SAP system.
        """
        return pulumi.get(self, "custom_resource_names")

    @property
    @pulumi.getter(name="highAvailabilityConfig")
    def high_availability_config(self) -> Optional['outputs.HighAvailabilityConfigurationResponse']:
        """
        The high availability configuration.
        """
        return pulumi.get(self, "high_availability_config")

    @property
    @pulumi.getter(name="networkConfiguration")
    def network_configuration(self) -> Optional['outputs.NetworkConfigurationResponse']:
        """
        Network configuration common to all servers
        """
        return pulumi.get(self, "network_configuration")

    @property
    @pulumi.getter(name="storageConfiguration")
    def storage_configuration(self) -> Optional['outputs.StorageConfigurationResponse']:
        """
        The storage configuration.
        """
        return pulumi.get(self, "storage_configuration")


@pulumi.output_type
class ThreeTierFullResourceNamesResponse(dict):
    """
    The resource name object where the specified values will be full resource names of the corresponding resources in a three tier SAP system.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "namingPatternType":
            suggest = "naming_pattern_type"
        elif key == "applicationServer":
            suggest = "application_server"
        elif key == "centralServer":
            suggest = "central_server"
        elif key == "databaseServer":
            suggest = "database_server"
        elif key == "sharedStorage":
            suggest = "shared_storage"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ThreeTierFullResourceNamesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ThreeTierFullResourceNamesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ThreeTierFullResourceNamesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 naming_pattern_type: str,
                 application_server: Optional['outputs.ApplicationServerFullResourceNamesResponse'] = None,
                 central_server: Optional['outputs.CentralServerFullResourceNamesResponse'] = None,
                 database_server: Optional['outputs.DatabaseServerFullResourceNamesResponse'] = None,
                 shared_storage: Optional['outputs.SharedStorageResourceNamesResponse'] = None):
        """
        The resource name object where the specified values will be full resource names of the corresponding resources in a three tier SAP system.
        :param str naming_pattern_type: The pattern type to be used for resource naming.
               Expected value is 'FullResourceName'.
        :param 'ApplicationServerFullResourceNamesResponse' application_server: The full resource names object for application layer resources. The number of entries in this list should be equal to the number VMs to be created for application layer.
        :param 'CentralServerFullResourceNamesResponse' central_server: The full resource names object for central server layer resources.
        :param 'DatabaseServerFullResourceNamesResponse' database_server: The full resource names object for database layer resources. The number of entries in this list should be equal to the number VMs to be created for database layer.
        :param 'SharedStorageResourceNamesResponse' shared_storage: The resource names object for shared storage.
        """
        pulumi.set(__self__, "naming_pattern_type", 'FullResourceName')
        if application_server is not None:
            pulumi.set(__self__, "application_server", application_server)
        if central_server is not None:
            pulumi.set(__self__, "central_server", central_server)
        if database_server is not None:
            pulumi.set(__self__, "database_server", database_server)
        if shared_storage is not None:
            pulumi.set(__self__, "shared_storage", shared_storage)

    @property
    @pulumi.getter(name="namingPatternType")
    def naming_pattern_type(self) -> str:
        """
        The pattern type to be used for resource naming.
        Expected value is 'FullResourceName'.
        """
        return pulumi.get(self, "naming_pattern_type")

    @property
    @pulumi.getter(name="applicationServer")
    def application_server(self) -> Optional['outputs.ApplicationServerFullResourceNamesResponse']:
        """
        The full resource names object for application layer resources. The number of entries in this list should be equal to the number VMs to be created for application layer.
        """
        return pulumi.get(self, "application_server")

    @property
    @pulumi.getter(name="centralServer")
    def central_server(self) -> Optional['outputs.CentralServerFullResourceNamesResponse']:
        """
        The full resource names object for central server layer resources.
        """
        return pulumi.get(self, "central_server")

    @property
    @pulumi.getter(name="databaseServer")
    def database_server(self) -> Optional['outputs.DatabaseServerFullResourceNamesResponse']:
        """
        The full resource names object for database layer resources. The number of entries in this list should be equal to the number VMs to be created for database layer.
        """
        return pulumi.get(self, "database_server")

    @property
    @pulumi.getter(name="sharedStorage")
    def shared_storage(self) -> Optional['outputs.SharedStorageResourceNamesResponse']:
        """
        The resource names object for shared storage.
        """
        return pulumi.get(self, "shared_storage")


@pulumi.output_type
class UserAssignedIdentityResponse(dict):
    """
    User assigned identity properties
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "principalId":
            suggest = "principal_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserAssignedIdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserAssignedIdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserAssignedIdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: str,
                 principal_id: str):
        """
        User assigned identity properties
        :param str client_id: The client ID of the assigned identity.
        :param str principal_id: The principal ID of the assigned identity.
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "principal_id", principal_id)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> str:
        """
        The client ID of the assigned identity.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        The principal ID of the assigned identity.
        """
        return pulumi.get(self, "principal_id")


@pulumi.output_type
class UserAssignedServiceIdentityResponse(dict):
    """
    A pre-created user assigned identity with appropriate roles assigned. To learn more on identity and roles required, visit the ACSS how-to-guide.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "userAssignedIdentities":
            suggest = "user_assigned_identities"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserAssignedServiceIdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserAssignedServiceIdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserAssignedServiceIdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 user_assigned_identities: Optional[Mapping[str, 'outputs.UserAssignedIdentityResponse']] = None):
        """
        A pre-created user assigned identity with appropriate roles assigned. To learn more on identity and roles required, visit the ACSS how-to-guide.
        :param str type: Type of manage identity
        :param Mapping[str, 'UserAssignedIdentityResponse'] user_assigned_identities: User assigned identities dictionary
        """
        pulumi.set(__self__, "type", type)
        if user_assigned_identities is not None:
            pulumi.set(__self__, "user_assigned_identities", user_assigned_identities)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of manage identity
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="userAssignedIdentities")
    def user_assigned_identities(self) -> Optional[Mapping[str, 'outputs.UserAssignedIdentityResponse']]:
        """
        User assigned identities dictionary
        """
        return pulumi.get(self, "user_assigned_identities")


@pulumi.output_type
class VirtualMachineConfigurationResponse(dict):
    """
    Defines the virtual machine configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "imageReference":
            suggest = "image_reference"
        elif key == "osProfile":
            suggest = "os_profile"
        elif key == "vmSize":
            suggest = "vm_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 image_reference: 'outputs.ImageReferenceResponse',
                 os_profile: 'outputs.OSProfileResponse',
                 vm_size: str):
        """
        Defines the virtual machine configuration.
        :param 'ImageReferenceResponse' image_reference: The image reference.
        :param 'OSProfileResponse' os_profile: The OS profile.
        :param str vm_size: The virtual machine size.
        """
        pulumi.set(__self__, "image_reference", image_reference)
        pulumi.set(__self__, "os_profile", os_profile)
        pulumi.set(__self__, "vm_size", vm_size)

    @property
    @pulumi.getter(name="imageReference")
    def image_reference(self) -> 'outputs.ImageReferenceResponse':
        """
        The image reference.
        """
        return pulumi.get(self, "image_reference")

    @property
    @pulumi.getter(name="osProfile")
    def os_profile(self) -> 'outputs.OSProfileResponse':
        """
        The OS profile.
        """
        return pulumi.get(self, "os_profile")

    @property
    @pulumi.getter(name="vmSize")
    def vm_size(self) -> str:
        """
        The virtual machine size.
        """
        return pulumi.get(self, "vm_size")


@pulumi.output_type
class VirtualMachineResourceNamesResponse(dict):
    """
    The resource names object for virtual machine and related resources.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataDiskNames":
            suggest = "data_disk_names"
        elif key == "hostName":
            suggest = "host_name"
        elif key == "networkInterfaces":
            suggest = "network_interfaces"
        elif key == "osDiskName":
            suggest = "os_disk_name"
        elif key == "vmName":
            suggest = "vm_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineResourceNamesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineResourceNamesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineResourceNamesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_disk_names: Optional[Mapping[str, Sequence[str]]] = None,
                 host_name: Optional[str] = None,
                 network_interfaces: Optional[Sequence['outputs.NetworkInterfaceResourceNamesResponse']] = None,
                 os_disk_name: Optional[str] = None,
                 vm_name: Optional[str] = None):
        """
        The resource names object for virtual machine and related resources.
        :param Mapping[str, Sequence[str]] data_disk_names: The full resource names for virtual machine data disks. This is a dictionary containing list of names of data disks per volume. Currently supported volumes for database layer are ['hana/data', 'hana/log', hana/shared', 'usr/sap', 'os', 'backup']. For application and cs layers, only 'default' volume is supported
        :param str host_name: The full name for virtual-machine's host (computer name). Currently, ACSS only supports host names which are less than or equal to 13 characters long. If this value is not provided, vmName will be used as host name.
        :param Sequence['NetworkInterfaceResourceNamesResponse'] network_interfaces: The list of network interface name objects for the selected virtual machine. Currently, only one network interface is supported per virtual machine.
        :param str os_disk_name: The full name for OS disk attached to the VM. If this value is not provided, it will be named by ARM as per its default naming standards (prefixed with vm name). There is only one OS disk attached per Virtual Machine.
        :param str vm_name: The full name for virtual machine. The length of this field can be upto 64 characters. If name is not provided, service uses a default name based on the deployment type. For SingleServer, default name is {SID}vm. In case of HA-AvZone systems, default name will be {SID}{app/ascs/db}z{a/b}vm with an incrementor at the end in case of more than 1 vm per layer. For distributed and HA-AvSet systems, default name will be {SID}{app/ascs/db}vm with an incrementor at the end in case of more than 1 vm per layer.
        """
        if data_disk_names is not None:
            pulumi.set(__self__, "data_disk_names", data_disk_names)
        if host_name is not None:
            pulumi.set(__self__, "host_name", host_name)
        if network_interfaces is not None:
            pulumi.set(__self__, "network_interfaces", network_interfaces)
        if os_disk_name is not None:
            pulumi.set(__self__, "os_disk_name", os_disk_name)
        if vm_name is not None:
            pulumi.set(__self__, "vm_name", vm_name)

    @property
    @pulumi.getter(name="dataDiskNames")
    def data_disk_names(self) -> Optional[Mapping[str, Sequence[str]]]:
        """
        The full resource names for virtual machine data disks. This is a dictionary containing list of names of data disks per volume. Currently supported volumes for database layer are ['hana/data', 'hana/log', hana/shared', 'usr/sap', 'os', 'backup']. For application and cs layers, only 'default' volume is supported
        """
        return pulumi.get(self, "data_disk_names")

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> Optional[str]:
        """
        The full name for virtual-machine's host (computer name). Currently, ACSS only supports host names which are less than or equal to 13 characters long. If this value is not provided, vmName will be used as host name.
        """
        return pulumi.get(self, "host_name")

    @property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Optional[Sequence['outputs.NetworkInterfaceResourceNamesResponse']]:
        """
        The list of network interface name objects for the selected virtual machine. Currently, only one network interface is supported per virtual machine.
        """
        return pulumi.get(self, "network_interfaces")

    @property
    @pulumi.getter(name="osDiskName")
    def os_disk_name(self) -> Optional[str]:
        """
        The full name for OS disk attached to the VM. If this value is not provided, it will be named by ARM as per its default naming standards (prefixed with vm name). There is only one OS disk attached per Virtual Machine.
        """
        return pulumi.get(self, "os_disk_name")

    @property
    @pulumi.getter(name="vmName")
    def vm_name(self) -> Optional[str]:
        """
        The full name for virtual machine. The length of this field can be upto 64 characters. If name is not provided, service uses a default name based on the deployment type. For SingleServer, default name is {SID}vm. In case of HA-AvZone systems, default name will be {SID}{app/ascs/db}z{a/b}vm with an incrementor at the end in case of more than 1 vm per layer. For distributed and HA-AvSet systems, default name will be {SID}{app/ascs/db}vm with an incrementor at the end in case of more than 1 vm per layer.
        """
        return pulumi.get(self, "vm_name")


@pulumi.output_type
class WindowsConfigurationResponse(dict):
    """
    Specifies Windows operating system settings on the virtual machine.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "osType":
            suggest = "os_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WindowsConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WindowsConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WindowsConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 os_type: str):
        """
        Specifies Windows operating system settings on the virtual machine.
        :param str os_type: The OS Type
               Expected value is 'Windows'.
        """
        pulumi.set(__self__, "os_type", 'Windows')

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> str:
        """
        The OS Type
        Expected value is 'Windows'.
        """
        return pulumi.get(self, "os_type")


