# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'ApiDefinitionInfoResponse',
    'ApiManagementConfigResponse',
    'AppLogsConfigurationResponse',
    'ApplicationLogsConfigResponse',
    'ArcConfigurationResponse',
    'ArmIdWrapperResponse',
    'ArmPlanResponse',
    'AseV3NetworkingConfigurationResponse',
    'AutoHealActionsResponse',
    'AutoHealCustomActionResponse',
    'AutoHealRulesResponse',
    'AutoHealTriggersResponse',
    'AzureBlobStorageApplicationLogsConfigResponse',
    'AzureBlobStorageHttpLogsConfigResponse',
    'AzureResourceErrorInfoResponse',
    'AzureStorageInfoValueResponse',
    'AzureTableStorageApplicationLogsConfigResponse',
    'BackupItemResponse',
    'BackupScheduleResponse',
    'CapabilityResponse',
    'ConfigurationResponse',
    'ConnStringInfoResponse',
    'ConnStringValueTypePairResponse',
    'ContainerAppSecretResponse',
    'ContainerAppsConfigurationResponse',
    'ContainerResourcesResponse',
    'ContainerResponse',
    'CorsSettingsResponse',
    'CustomDnsSuffixConfigurationResponse',
    'CustomScaleRuleResponse',
    'DaprComponentResponse',
    'DaprMetadataResponse',
    'DaprResponse',
    'DatabaseBackupSettingResponse',
    'DatabaseConnectionOverviewResponse',
    'EnabledConfigResponse',
    'EnvironmentVarResponse',
    'ErrorEntityResponse',
    'ExperimentsResponse',
    'ExpressionResponse',
    'ExpressionRootResponse',
    'ExtendedLocationResponse',
    'FileSystemApplicationLogsConfigResponse',
    'FileSystemHttpLogsConfigResponse',
    'FrontEndConfigurationResponse',
    'GitHubActionCodeConfigurationResponse',
    'GitHubActionConfigurationResponse',
    'GitHubActionContainerConfigurationResponse',
    'HandlerMappingResponse',
    'HostNameSslStateResponse',
    'HostingEnvironmentProfileResponse',
    'HttpLogsConfigResponse',
    'HttpScaleRuleResponse',
    'IdentifierResponse',
    'IngressResponse',
    'IpSecurityRestrictionResponse',
    'KubeEnvironmentProfileResponse',
    'LogAnalyticsConfigurationResponse',
    'ManagedServiceIdentityResponse',
    'NameValuePairResponse',
    'PrivateLinkConnectionStateResponse',
    'PushSettingsResponse',
    'QueueScaleRuleResponse',
    'RampUpRuleResponse',
    'RegistryCredentialsResponse',
    'RemotePrivateEndpointConnectionResponse',
    'RequestsBasedTriggerResponse',
    'ResponseMessageEnvelopeRemotePrivateEndpointConnectionResponse',
    'ScaleResponse',
    'ScaleRuleAuthResponse',
    'ScaleRuleResponse',
    'SecretResponse',
    'SiteConfigResponse',
    'SiteLimitsResponse',
    'SiteMachineKeyResponse',
    'SkuCapacityResponse',
    'SkuDescriptionResponse',
    'SlotSwapStatusResponse',
    'SlowRequestsBasedTriggerResponse',
    'StaticSiteBuildPropertiesResponse',
    'StaticSiteDatabaseConnectionConfigurationFileOverviewResponse',
    'StaticSiteLinkedBackendResponse',
    'StaticSiteTemplateOptionsResponse',
    'StaticSiteUserARMResourceResponse',
    'StaticSiteUserProvidedFunctionAppResponse',
    'StatusCodesBasedTriggerResponse',
    'StatusCodesRangeBasedTriggerResponse',
    'TemplateResponse',
    'TrafficWeightResponse',
    'UserAssignedIdentityResponse',
    'VirtualApplicationResponse',
    'VirtualDirectoryResponse',
    'VirtualNetworkProfileResponse',
    'VnetRouteResponse',
    'WorkflowEnvelopeResponseProperties',
    'WorkflowHealthResponse',
    'WorkflowTriggerListCallbackUrlQueriesResponse',
]

@pulumi.output_type
class ApiDefinitionInfoResponse(dict):
    """
    Information about the formal API definition for the app.
    """
    def __init__(__self__, *,
                 url: Optional[str] = None):
        """
        Information about the formal API definition for the app.
        :param str url: The URL of the API definition.
        """
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def url(self) -> Optional[str]:
        """
        The URL of the API definition.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class ApiManagementConfigResponse(dict):
    """
    Azure API management (APIM) configuration linked to the app.
    """
    def __init__(__self__, *,
                 id: Optional[str] = None):
        """
        Azure API management (APIM) configuration linked to the app.
        :param str id: APIM-Api Identifier.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        APIM-Api Identifier.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class AppLogsConfigurationResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logAnalyticsConfiguration":
            suggest = "log_analytics_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppLogsConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppLogsConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppLogsConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 destination: Optional[str] = None,
                 log_analytics_configuration: Optional['outputs.LogAnalyticsConfigurationResponse'] = None):
        if destination is not None:
            pulumi.set(__self__, "destination", destination)
        if log_analytics_configuration is not None:
            pulumi.set(__self__, "log_analytics_configuration", log_analytics_configuration)

    @property
    @pulumi.getter
    def destination(self) -> Optional[str]:
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter(name="logAnalyticsConfiguration")
    def log_analytics_configuration(self) -> Optional['outputs.LogAnalyticsConfigurationResponse']:
        return pulumi.get(self, "log_analytics_configuration")


@pulumi.output_type
class ApplicationLogsConfigResponse(dict):
    """
    Application logs configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "azureBlobStorage":
            suggest = "azure_blob_storage"
        elif key == "azureTableStorage":
            suggest = "azure_table_storage"
        elif key == "fileSystem":
            suggest = "file_system"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationLogsConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationLogsConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationLogsConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 azure_blob_storage: Optional['outputs.AzureBlobStorageApplicationLogsConfigResponse'] = None,
                 azure_table_storage: Optional['outputs.AzureTableStorageApplicationLogsConfigResponse'] = None,
                 file_system: Optional['outputs.FileSystemApplicationLogsConfigResponse'] = None):
        """
        Application logs configuration.
        :param 'AzureBlobStorageApplicationLogsConfigResponse' azure_blob_storage: Application logs to blob storage configuration.
        :param 'AzureTableStorageApplicationLogsConfigResponse' azure_table_storage: Application logs to azure table storage configuration.
        :param 'FileSystemApplicationLogsConfigResponse' file_system: Application logs to file system configuration.
        """
        if azure_blob_storage is not None:
            pulumi.set(__self__, "azure_blob_storage", azure_blob_storage)
        if azure_table_storage is not None:
            pulumi.set(__self__, "azure_table_storage", azure_table_storage)
        if file_system is not None:
            pulumi.set(__self__, "file_system", file_system)

    @property
    @pulumi.getter(name="azureBlobStorage")
    def azure_blob_storage(self) -> Optional['outputs.AzureBlobStorageApplicationLogsConfigResponse']:
        """
        Application logs to blob storage configuration.
        """
        return pulumi.get(self, "azure_blob_storage")

    @property
    @pulumi.getter(name="azureTableStorage")
    def azure_table_storage(self) -> Optional['outputs.AzureTableStorageApplicationLogsConfigResponse']:
        """
        Application logs to azure table storage configuration.
        """
        return pulumi.get(self, "azure_table_storage")

    @property
    @pulumi.getter(name="fileSystem")
    def file_system(self) -> Optional['outputs.FileSystemApplicationLogsConfigResponse']:
        """
        Application logs to file system configuration.
        """
        return pulumi.get(self, "file_system")


@pulumi.output_type
class ArcConfigurationResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "artifactStorageAccessMode":
            suggest = "artifact_storage_access_mode"
        elif key == "artifactStorageClassName":
            suggest = "artifact_storage_class_name"
        elif key == "artifactStorageMountPath":
            suggest = "artifact_storage_mount_path"
        elif key == "artifactStorageNodeName":
            suggest = "artifact_storage_node_name"
        elif key == "artifactsStorageType":
            suggest = "artifacts_storage_type"
        elif key == "frontEndServiceConfiguration":
            suggest = "front_end_service_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ArcConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ArcConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ArcConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 artifact_storage_access_mode: Optional[str] = None,
                 artifact_storage_class_name: Optional[str] = None,
                 artifact_storage_mount_path: Optional[str] = None,
                 artifact_storage_node_name: Optional[str] = None,
                 artifacts_storage_type: Optional[str] = None,
                 front_end_service_configuration: Optional['outputs.FrontEndConfigurationResponse'] = None):
        if artifact_storage_access_mode is not None:
            pulumi.set(__self__, "artifact_storage_access_mode", artifact_storage_access_mode)
        if artifact_storage_class_name is not None:
            pulumi.set(__self__, "artifact_storage_class_name", artifact_storage_class_name)
        if artifact_storage_mount_path is not None:
            pulumi.set(__self__, "artifact_storage_mount_path", artifact_storage_mount_path)
        if artifact_storage_node_name is not None:
            pulumi.set(__self__, "artifact_storage_node_name", artifact_storage_node_name)
        if artifacts_storage_type is not None:
            pulumi.set(__self__, "artifacts_storage_type", artifacts_storage_type)
        if front_end_service_configuration is not None:
            pulumi.set(__self__, "front_end_service_configuration", front_end_service_configuration)

    @property
    @pulumi.getter(name="artifactStorageAccessMode")
    def artifact_storage_access_mode(self) -> Optional[str]:
        return pulumi.get(self, "artifact_storage_access_mode")

    @property
    @pulumi.getter(name="artifactStorageClassName")
    def artifact_storage_class_name(self) -> Optional[str]:
        return pulumi.get(self, "artifact_storage_class_name")

    @property
    @pulumi.getter(name="artifactStorageMountPath")
    def artifact_storage_mount_path(self) -> Optional[str]:
        return pulumi.get(self, "artifact_storage_mount_path")

    @property
    @pulumi.getter(name="artifactStorageNodeName")
    def artifact_storage_node_name(self) -> Optional[str]:
        return pulumi.get(self, "artifact_storage_node_name")

    @property
    @pulumi.getter(name="artifactsStorageType")
    def artifacts_storage_type(self) -> Optional[str]:
        return pulumi.get(self, "artifacts_storage_type")

    @property
    @pulumi.getter(name="frontEndServiceConfiguration")
    def front_end_service_configuration(self) -> Optional['outputs.FrontEndConfigurationResponse']:
        return pulumi.get(self, "front_end_service_configuration")


@pulumi.output_type
class ArmIdWrapperResponse(dict):
    """
    A wrapper for an ARM resource id
    """
    def __init__(__self__, *,
                 id: str):
        """
        A wrapper for an ARM resource id
        """
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")


@pulumi.output_type
class ArmPlanResponse(dict):
    """
    The plan object in Azure Resource Manager, represents a marketplace plan.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "promotionCode":
            suggest = "promotion_code"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ArmPlanResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ArmPlanResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ArmPlanResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: Optional[str] = None,
                 product: Optional[str] = None,
                 promotion_code: Optional[str] = None,
                 publisher: Optional[str] = None,
                 version: Optional[str] = None):
        """
        The plan object in Azure Resource Manager, represents a marketplace plan.
        :param str name: The name.
        :param str product: The product.
        :param str promotion_code: The promotion code.
        :param str publisher: The publisher.
        :param str version: Version of product.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if product is not None:
            pulumi.set(__self__, "product", product)
        if promotion_code is not None:
            pulumi.set(__self__, "promotion_code", promotion_code)
        if publisher is not None:
            pulumi.set(__self__, "publisher", publisher)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def product(self) -> Optional[str]:
        """
        The product.
        """
        return pulumi.get(self, "product")

    @property
    @pulumi.getter(name="promotionCode")
    def promotion_code(self) -> Optional[str]:
        """
        The promotion code.
        """
        return pulumi.get(self, "promotion_code")

    @property
    @pulumi.getter
    def publisher(self) -> Optional[str]:
        """
        The publisher.
        """
        return pulumi.get(self, "publisher")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        Version of product.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class AseV3NetworkingConfigurationResponse(dict):
    """
    Full view of networking configuration for an ASE.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "externalInboundIpAddresses":
            suggest = "external_inbound_ip_addresses"
        elif key == "internalInboundIpAddresses":
            suggest = "internal_inbound_ip_addresses"
        elif key == "linuxOutboundIpAddresses":
            suggest = "linux_outbound_ip_addresses"
        elif key == "windowsOutboundIpAddresses":
            suggest = "windows_outbound_ip_addresses"
        elif key == "allowNewPrivateEndpointConnections":
            suggest = "allow_new_private_endpoint_connections"
        elif key == "ftpEnabled":
            suggest = "ftp_enabled"
        elif key == "inboundIpAddressOverride":
            suggest = "inbound_ip_address_override"
        elif key == "remoteDebugEnabled":
            suggest = "remote_debug_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AseV3NetworkingConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AseV3NetworkingConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AseV3NetworkingConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 external_inbound_ip_addresses: Sequence[str],
                 id: str,
                 internal_inbound_ip_addresses: Sequence[str],
                 linux_outbound_ip_addresses: Sequence[str],
                 name: str,
                 type: str,
                 windows_outbound_ip_addresses: Sequence[str],
                 allow_new_private_endpoint_connections: Optional[bool] = None,
                 ftp_enabled: Optional[bool] = None,
                 inbound_ip_address_override: Optional[str] = None,
                 kind: Optional[str] = None,
                 remote_debug_enabled: Optional[bool] = None):
        """
        Full view of networking configuration for an ASE.
        :param str id: Resource Id.
        :param str name: Resource Name.
        :param str type: Resource type.
        :param bool allow_new_private_endpoint_connections: Property to enable and disable new private endpoint connection creation on ASE
        :param bool ftp_enabled: Property to enable and disable FTP on ASEV3
        :param str inbound_ip_address_override: Customer provided Inbound IP Address. Only able to be set on Ase create.
        :param str kind: Kind of resource.
        :param bool remote_debug_enabled: Property to enable and disable Remote Debug on ASEV3
        """
        pulumi.set(__self__, "external_inbound_ip_addresses", external_inbound_ip_addresses)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "internal_inbound_ip_addresses", internal_inbound_ip_addresses)
        pulumi.set(__self__, "linux_outbound_ip_addresses", linux_outbound_ip_addresses)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "windows_outbound_ip_addresses", windows_outbound_ip_addresses)
        if allow_new_private_endpoint_connections is not None:
            pulumi.set(__self__, "allow_new_private_endpoint_connections", allow_new_private_endpoint_connections)
        if ftp_enabled is not None:
            pulumi.set(__self__, "ftp_enabled", ftp_enabled)
        if inbound_ip_address_override is not None:
            pulumi.set(__self__, "inbound_ip_address_override", inbound_ip_address_override)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if remote_debug_enabled is not None:
            pulumi.set(__self__, "remote_debug_enabled", remote_debug_enabled)

    @property
    @pulumi.getter(name="externalInboundIpAddresses")
    def external_inbound_ip_addresses(self) -> Sequence[str]:
        return pulumi.get(self, "external_inbound_ip_addresses")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Resource Id.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="internalInboundIpAddresses")
    def internal_inbound_ip_addresses(self) -> Sequence[str]:
        return pulumi.get(self, "internal_inbound_ip_addresses")

    @property
    @pulumi.getter(name="linuxOutboundIpAddresses")
    def linux_outbound_ip_addresses(self) -> Sequence[str]:
        return pulumi.get(self, "linux_outbound_ip_addresses")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Resource Name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Resource type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="windowsOutboundIpAddresses")
    def windows_outbound_ip_addresses(self) -> Sequence[str]:
        return pulumi.get(self, "windows_outbound_ip_addresses")

    @property
    @pulumi.getter(name="allowNewPrivateEndpointConnections")
    def allow_new_private_endpoint_connections(self) -> Optional[bool]:
        """
        Property to enable and disable new private endpoint connection creation on ASE
        """
        return pulumi.get(self, "allow_new_private_endpoint_connections")

    @property
    @pulumi.getter(name="ftpEnabled")
    def ftp_enabled(self) -> Optional[bool]:
        """
        Property to enable and disable FTP on ASEV3
        """
        return pulumi.get(self, "ftp_enabled")

    @property
    @pulumi.getter(name="inboundIpAddressOverride")
    def inbound_ip_address_override(self) -> Optional[str]:
        """
        Customer provided Inbound IP Address. Only able to be set on Ase create.
        """
        return pulumi.get(self, "inbound_ip_address_override")

    @property
    @pulumi.getter
    def kind(self) -> Optional[str]:
        """
        Kind of resource.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="remoteDebugEnabled")
    def remote_debug_enabled(self) -> Optional[bool]:
        """
        Property to enable and disable Remote Debug on ASEV3
        """
        return pulumi.get(self, "remote_debug_enabled")


@pulumi.output_type
class AutoHealActionsResponse(dict):
    """
    Actions which to take by the auto-heal module when a rule is triggered.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "actionType":
            suggest = "action_type"
        elif key == "customAction":
            suggest = "custom_action"
        elif key == "minProcessExecutionTime":
            suggest = "min_process_execution_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutoHealActionsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutoHealActionsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutoHealActionsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action_type: Optional[str] = None,
                 custom_action: Optional['outputs.AutoHealCustomActionResponse'] = None,
                 min_process_execution_time: Optional[str] = None):
        """
        Actions which to take by the auto-heal module when a rule is triggered.
        :param str action_type: Predefined action to be taken.
        :param 'AutoHealCustomActionResponse' custom_action: Custom action to be taken.
        :param str min_process_execution_time: Minimum time the process must execute
               before taking the action
        """
        if action_type is not None:
            pulumi.set(__self__, "action_type", action_type)
        if custom_action is not None:
            pulumi.set(__self__, "custom_action", custom_action)
        if min_process_execution_time is not None:
            pulumi.set(__self__, "min_process_execution_time", min_process_execution_time)

    @property
    @pulumi.getter(name="actionType")
    def action_type(self) -> Optional[str]:
        """
        Predefined action to be taken.
        """
        return pulumi.get(self, "action_type")

    @property
    @pulumi.getter(name="customAction")
    def custom_action(self) -> Optional['outputs.AutoHealCustomActionResponse']:
        """
        Custom action to be taken.
        """
        return pulumi.get(self, "custom_action")

    @property
    @pulumi.getter(name="minProcessExecutionTime")
    def min_process_execution_time(self) -> Optional[str]:
        """
        Minimum time the process must execute
        before taking the action
        """
        return pulumi.get(self, "min_process_execution_time")


@pulumi.output_type
class AutoHealCustomActionResponse(dict):
    """
    Custom action to be executed
    when an auto heal rule is triggered.
    """
    def __init__(__self__, *,
                 exe: Optional[str] = None,
                 parameters: Optional[str] = None):
        """
        Custom action to be executed
        when an auto heal rule is triggered.
        :param str exe: Executable to be run.
        :param str parameters: Parameters for the executable.
        """
        if exe is not None:
            pulumi.set(__self__, "exe", exe)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def exe(self) -> Optional[str]:
        """
        Executable to be run.
        """
        return pulumi.get(self, "exe")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[str]:
        """
        Parameters for the executable.
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class AutoHealRulesResponse(dict):
    """
    Rules that can be defined for auto-heal.
    """
    def __init__(__self__, *,
                 actions: Optional['outputs.AutoHealActionsResponse'] = None,
                 triggers: Optional['outputs.AutoHealTriggersResponse'] = None):
        """
        Rules that can be defined for auto-heal.
        :param 'AutoHealActionsResponse' actions: Actions to be executed when a rule is triggered.
        :param 'AutoHealTriggersResponse' triggers: Conditions that describe when to execute the auto-heal actions.
        """
        if actions is not None:
            pulumi.set(__self__, "actions", actions)
        if triggers is not None:
            pulumi.set(__self__, "triggers", triggers)

    @property
    @pulumi.getter
    def actions(self) -> Optional['outputs.AutoHealActionsResponse']:
        """
        Actions to be executed when a rule is triggered.
        """
        return pulumi.get(self, "actions")

    @property
    @pulumi.getter
    def triggers(self) -> Optional['outputs.AutoHealTriggersResponse']:
        """
        Conditions that describe when to execute the auto-heal actions.
        """
        return pulumi.get(self, "triggers")


@pulumi.output_type
class AutoHealTriggersResponse(dict):
    """
    Triggers for auto-heal.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateBytesInKB":
            suggest = "private_bytes_in_kb"
        elif key == "slowRequests":
            suggest = "slow_requests"
        elif key == "slowRequestsWithPath":
            suggest = "slow_requests_with_path"
        elif key == "statusCodes":
            suggest = "status_codes"
        elif key == "statusCodesRange":
            suggest = "status_codes_range"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutoHealTriggersResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutoHealTriggersResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutoHealTriggersResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 private_bytes_in_kb: Optional[int] = None,
                 requests: Optional['outputs.RequestsBasedTriggerResponse'] = None,
                 slow_requests: Optional['outputs.SlowRequestsBasedTriggerResponse'] = None,
                 slow_requests_with_path: Optional[Sequence['outputs.SlowRequestsBasedTriggerResponse']] = None,
                 status_codes: Optional[Sequence['outputs.StatusCodesBasedTriggerResponse']] = None,
                 status_codes_range: Optional[Sequence['outputs.StatusCodesRangeBasedTriggerResponse']] = None):
        """
        Triggers for auto-heal.
        :param int private_bytes_in_kb: A rule based on private bytes.
        :param 'RequestsBasedTriggerResponse' requests: A rule based on total requests.
        :param 'SlowRequestsBasedTriggerResponse' slow_requests: A rule based on request execution time.
        :param Sequence['SlowRequestsBasedTriggerResponse'] slow_requests_with_path: A rule based on multiple Slow Requests Rule with path
        :param Sequence['StatusCodesBasedTriggerResponse'] status_codes: A rule based on status codes.
        :param Sequence['StatusCodesRangeBasedTriggerResponse'] status_codes_range: A rule based on status codes ranges.
        """
        if private_bytes_in_kb is not None:
            pulumi.set(__self__, "private_bytes_in_kb", private_bytes_in_kb)
        if requests is not None:
            pulumi.set(__self__, "requests", requests)
        if slow_requests is not None:
            pulumi.set(__self__, "slow_requests", slow_requests)
        if slow_requests_with_path is not None:
            pulumi.set(__self__, "slow_requests_with_path", slow_requests_with_path)
        if status_codes is not None:
            pulumi.set(__self__, "status_codes", status_codes)
        if status_codes_range is not None:
            pulumi.set(__self__, "status_codes_range", status_codes_range)

    @property
    @pulumi.getter(name="privateBytesInKB")
    def private_bytes_in_kb(self) -> Optional[int]:
        """
        A rule based on private bytes.
        """
        return pulumi.get(self, "private_bytes_in_kb")

    @property
    @pulumi.getter
    def requests(self) -> Optional['outputs.RequestsBasedTriggerResponse']:
        """
        A rule based on total requests.
        """
        return pulumi.get(self, "requests")

    @property
    @pulumi.getter(name="slowRequests")
    def slow_requests(self) -> Optional['outputs.SlowRequestsBasedTriggerResponse']:
        """
        A rule based on request execution time.
        """
        return pulumi.get(self, "slow_requests")

    @property
    @pulumi.getter(name="slowRequestsWithPath")
    def slow_requests_with_path(self) -> Optional[Sequence['outputs.SlowRequestsBasedTriggerResponse']]:
        """
        A rule based on multiple Slow Requests Rule with path
        """
        return pulumi.get(self, "slow_requests_with_path")

    @property
    @pulumi.getter(name="statusCodes")
    def status_codes(self) -> Optional[Sequence['outputs.StatusCodesBasedTriggerResponse']]:
        """
        A rule based on status codes.
        """
        return pulumi.get(self, "status_codes")

    @property
    @pulumi.getter(name="statusCodesRange")
    def status_codes_range(self) -> Optional[Sequence['outputs.StatusCodesRangeBasedTriggerResponse']]:
        """
        A rule based on status codes ranges.
        """
        return pulumi.get(self, "status_codes_range")


@pulumi.output_type
class AzureBlobStorageApplicationLogsConfigResponse(dict):
    """
    Application logs azure blob storage configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "retentionInDays":
            suggest = "retention_in_days"
        elif key == "sasUrl":
            suggest = "sas_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureBlobStorageApplicationLogsConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureBlobStorageApplicationLogsConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureBlobStorageApplicationLogsConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 level: Optional[str] = None,
                 retention_in_days: Optional[int] = None,
                 sas_url: Optional[str] = None):
        """
        Application logs azure blob storage configuration.
        :param str level: Log level.
        :param int retention_in_days: Retention in days.
               Remove blobs older than X days.
               0 or lower means no retention.
        :param str sas_url: SAS url to a azure blob container with read/write/list/delete permissions.
        """
        if level is not None:
            pulumi.set(__self__, "level", level)
        if retention_in_days is not None:
            pulumi.set(__self__, "retention_in_days", retention_in_days)
        if sas_url is not None:
            pulumi.set(__self__, "sas_url", sas_url)

    @property
    @pulumi.getter
    def level(self) -> Optional[str]:
        """
        Log level.
        """
        return pulumi.get(self, "level")

    @property
    @pulumi.getter(name="retentionInDays")
    def retention_in_days(self) -> Optional[int]:
        """
        Retention in days.
        Remove blobs older than X days.
        0 or lower means no retention.
        """
        return pulumi.get(self, "retention_in_days")

    @property
    @pulumi.getter(name="sasUrl")
    def sas_url(self) -> Optional[str]:
        """
        SAS url to a azure blob container with read/write/list/delete permissions.
        """
        return pulumi.get(self, "sas_url")


@pulumi.output_type
class AzureBlobStorageHttpLogsConfigResponse(dict):
    """
    Http logs to azure blob storage configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "retentionInDays":
            suggest = "retention_in_days"
        elif key == "sasUrl":
            suggest = "sas_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureBlobStorageHttpLogsConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureBlobStorageHttpLogsConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureBlobStorageHttpLogsConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: Optional[bool] = None,
                 retention_in_days: Optional[int] = None,
                 sas_url: Optional[str] = None):
        """
        Http logs to azure blob storage configuration.
        :param bool enabled: True if configuration is enabled, false if it is disabled and null if configuration is not set.
        :param int retention_in_days: Retention in days.
               Remove blobs older than X days.
               0 or lower means no retention.
        :param str sas_url: SAS url to a azure blob container with read/write/list/delete permissions.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if retention_in_days is not None:
            pulumi.set(__self__, "retention_in_days", retention_in_days)
        if sas_url is not None:
            pulumi.set(__self__, "sas_url", sas_url)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        True if configuration is enabled, false if it is disabled and null if configuration is not set.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="retentionInDays")
    def retention_in_days(self) -> Optional[int]:
        """
        Retention in days.
        Remove blobs older than X days.
        0 or lower means no retention.
        """
        return pulumi.get(self, "retention_in_days")

    @property
    @pulumi.getter(name="sasUrl")
    def sas_url(self) -> Optional[str]:
        """
        SAS url to a azure blob container with read/write/list/delete permissions.
        """
        return pulumi.get(self, "sas_url")


@pulumi.output_type
class AzureResourceErrorInfoResponse(dict):
    """
    The azure resource error info.
    """
    def __init__(__self__, *,
                 code: str,
                 message: str,
                 details: Optional[Sequence['outputs.AzureResourceErrorInfoResponse']] = None):
        """
        The azure resource error info.
        :param str code: The error code.
        :param str message: The error message.
        :param Sequence['AzureResourceErrorInfoResponse'] details: The error details.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "message", message)
        if details is not None:
            pulumi.set(__self__, "details", details)

    @property
    @pulumi.getter
    def code(self) -> str:
        """
        The error code.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        The error message.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def details(self) -> Optional[Sequence['outputs.AzureResourceErrorInfoResponse']]:
        """
        The error details.
        """
        return pulumi.get(self, "details")


@pulumi.output_type
class AzureStorageInfoValueResponse(dict):
    """
    Azure Files or Blob Storage access information value for dictionary storage.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessKey":
            suggest = "access_key"
        elif key == "accountName":
            suggest = "account_name"
        elif key == "mountPath":
            suggest = "mount_path"
        elif key == "shareName":
            suggest = "share_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureStorageInfoValueResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureStorageInfoValueResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureStorageInfoValueResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 state: str,
                 access_key: Optional[str] = None,
                 account_name: Optional[str] = None,
                 mount_path: Optional[str] = None,
                 share_name: Optional[str] = None,
                 type: Optional[str] = None):
        """
        Azure Files or Blob Storage access information value for dictionary storage.
        :param str state: State of the storage account.
        :param str access_key: Access key for the storage account.
        :param str account_name: Name of the storage account.
        :param str mount_path: Path to mount the storage within the site's runtime environment.
        :param str share_name: Name of the file share (container name, for Blob storage).
        :param str type: Type of storage.
        """
        pulumi.set(__self__, "state", state)
        if access_key is not None:
            pulumi.set(__self__, "access_key", access_key)
        if account_name is not None:
            pulumi.set(__self__, "account_name", account_name)
        if mount_path is not None:
            pulumi.set(__self__, "mount_path", mount_path)
        if share_name is not None:
            pulumi.set(__self__, "share_name", share_name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        State of the storage account.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> Optional[str]:
        """
        Access key for the storage account.
        """
        return pulumi.get(self, "access_key")

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> Optional[str]:
        """
        Name of the storage account.
        """
        return pulumi.get(self, "account_name")

    @property
    @pulumi.getter(name="mountPath")
    def mount_path(self) -> Optional[str]:
        """
        Path to mount the storage within the site's runtime environment.
        """
        return pulumi.get(self, "mount_path")

    @property
    @pulumi.getter(name="shareName")
    def share_name(self) -> Optional[str]:
        """
        Name of the file share (container name, for Blob storage).
        """
        return pulumi.get(self, "share_name")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Type of storage.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class AzureTableStorageApplicationLogsConfigResponse(dict):
    """
    Application logs to Azure table storage configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sasUrl":
            suggest = "sas_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureTableStorageApplicationLogsConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureTableStorageApplicationLogsConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureTableStorageApplicationLogsConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 sas_url: str,
                 level: Optional[str] = None):
        """
        Application logs to Azure table storage configuration.
        :param str sas_url: SAS URL to an Azure table with add/query/delete permissions.
        :param str level: Log level.
        """
        pulumi.set(__self__, "sas_url", sas_url)
        if level is not None:
            pulumi.set(__self__, "level", level)

    @property
    @pulumi.getter(name="sasUrl")
    def sas_url(self) -> str:
        """
        SAS URL to an Azure table with add/query/delete permissions.
        """
        return pulumi.get(self, "sas_url")

    @property
    @pulumi.getter
    def level(self) -> Optional[str]:
        """
        Log level.
        """
        return pulumi.get(self, "level")


@pulumi.output_type
class BackupItemResponse(dict):
    """
    Backup description.
    """
    def __init__(__self__, *,
                 backup_id: int,
                 blob_name: str,
                 correlation_id: str,
                 created: str,
                 databases: Sequence['outputs.DatabaseBackupSettingResponse'],
                 finished_time_stamp: str,
                 id: str,
                 last_restore_time_stamp: str,
                 log: str,
                 name: str,
                 scheduled: bool,
                 size_in_bytes: float,
                 status: str,
                 storage_account_url: str,
                 type: str,
                 website_size_in_bytes: float,
                 kind: Optional[str] = None):
        """
        Backup description.
        :param int backup_id: Id of the backup.
        :param str blob_name: Name of the blob which contains data for this backup.
        :param str correlation_id: Unique correlation identifier. Please use this along with the timestamp while communicating with Azure support.
        :param str created: Timestamp of the backup creation.
        :param Sequence['DatabaseBackupSettingResponse'] databases: List of databases included in the backup.
        :param str finished_time_stamp: Timestamp when this backup finished.
        :param str id: Resource Id.
        :param str last_restore_time_stamp: Timestamp of a last restore operation which used this backup.
        :param str log: Details regarding this backup. Might contain an error message.
        :param str name: Resource Name.
        :param bool scheduled: True if this backup has been created due to a schedule being triggered.
        :param float size_in_bytes: Size of the backup in bytes.
        :param str status: Backup status.
        :param str storage_account_url: SAS URL for the storage account container which contains this backup.
        :param str type: Resource type.
        :param float website_size_in_bytes: Size of the original web app which has been backed up.
        :param str kind: Kind of resource.
        """
        pulumi.set(__self__, "backup_id", backup_id)
        pulumi.set(__self__, "blob_name", blob_name)
        pulumi.set(__self__, "correlation_id", correlation_id)
        pulumi.set(__self__, "created", created)
        pulumi.set(__self__, "databases", databases)
        pulumi.set(__self__, "finished_time_stamp", finished_time_stamp)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "last_restore_time_stamp", last_restore_time_stamp)
        pulumi.set(__self__, "log", log)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "scheduled", scheduled)
        pulumi.set(__self__, "size_in_bytes", size_in_bytes)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "storage_account_url", storage_account_url)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "website_size_in_bytes", website_size_in_bytes)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)

    @property
    @pulumi.getter(name="backupId")
    def backup_id(self) -> int:
        """
        Id of the backup.
        """
        return pulumi.get(self, "backup_id")

    @property
    @pulumi.getter(name="blobName")
    def blob_name(self) -> str:
        """
        Name of the blob which contains data for this backup.
        """
        return pulumi.get(self, "blob_name")

    @property
    @pulumi.getter(name="correlationId")
    def correlation_id(self) -> str:
        """
        Unique correlation identifier. Please use this along with the timestamp while communicating with Azure support.
        """
        return pulumi.get(self, "correlation_id")

    @property
    @pulumi.getter
    def created(self) -> str:
        """
        Timestamp of the backup creation.
        """
        return pulumi.get(self, "created")

    @property
    @pulumi.getter
    def databases(self) -> Sequence['outputs.DatabaseBackupSettingResponse']:
        """
        List of databases included in the backup.
        """
        return pulumi.get(self, "databases")

    @property
    @pulumi.getter(name="finishedTimeStamp")
    def finished_time_stamp(self) -> str:
        """
        Timestamp when this backup finished.
        """
        return pulumi.get(self, "finished_time_stamp")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Resource Id.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lastRestoreTimeStamp")
    def last_restore_time_stamp(self) -> str:
        """
        Timestamp of a last restore operation which used this backup.
        """
        return pulumi.get(self, "last_restore_time_stamp")

    @property
    @pulumi.getter
    def log(self) -> str:
        """
        Details regarding this backup. Might contain an error message.
        """
        return pulumi.get(self, "log")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Resource Name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def scheduled(self) -> bool:
        """
        True if this backup has been created due to a schedule being triggered.
        """
        return pulumi.get(self, "scheduled")

    @property
    @pulumi.getter(name="sizeInBytes")
    def size_in_bytes(self) -> float:
        """
        Size of the backup in bytes.
        """
        return pulumi.get(self, "size_in_bytes")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Backup status.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="storageAccountUrl")
    def storage_account_url(self) -> str:
        """
        SAS URL for the storage account container which contains this backup.
        """
        return pulumi.get(self, "storage_account_url")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Resource type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="websiteSizeInBytes")
    def website_size_in_bytes(self) -> float:
        """
        Size of the original web app which has been backed up.
        """
        return pulumi.get(self, "website_size_in_bytes")

    @property
    @pulumi.getter
    def kind(self) -> Optional[str]:
        """
        Kind of resource.
        """
        return pulumi.get(self, "kind")


@pulumi.output_type
class BackupScheduleResponse(dict):
    """
    Description of a backup schedule. Describes how often should be the backup performed and what should be the retention policy.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "frequencyInterval":
            suggest = "frequency_interval"
        elif key == "frequencyUnit":
            suggest = "frequency_unit"
        elif key == "keepAtLeastOneBackup":
            suggest = "keep_at_least_one_backup"
        elif key == "lastExecutionTime":
            suggest = "last_execution_time"
        elif key == "retentionPeriodInDays":
            suggest = "retention_period_in_days"
        elif key == "startTime":
            suggest = "start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackupScheduleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackupScheduleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackupScheduleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 frequency_interval: int,
                 frequency_unit: str,
                 keep_at_least_one_backup: bool,
                 last_execution_time: str,
                 retention_period_in_days: int,
                 start_time: Optional[str] = None):
        """
        Description of a backup schedule. Describes how often should be the backup performed and what should be the retention policy.
        :param int frequency_interval: How often the backup should be executed (e.g. for weekly backup, this should be set to 7 and FrequencyUnit should be set to Day)
        :param str frequency_unit: The unit of time for how often the backup should be executed (e.g. for weekly backup, this should be set to Day and FrequencyInterval should be set to 7)
        :param bool keep_at_least_one_backup: True if the retention policy should always keep at least one backup in the storage account, regardless how old it is; false otherwise.
        :param str last_execution_time: Last time when this schedule was triggered.
        :param int retention_period_in_days: After how many days backups should be deleted.
        :param str start_time: When the schedule should start working.
        """
        if frequency_interval is None:
            frequency_interval = 7
        pulumi.set(__self__, "frequency_interval", frequency_interval)
        if frequency_unit is None:
            frequency_unit = 'Day'
        pulumi.set(__self__, "frequency_unit", frequency_unit)
        if keep_at_least_one_backup is None:
            keep_at_least_one_backup = True
        pulumi.set(__self__, "keep_at_least_one_backup", keep_at_least_one_backup)
        pulumi.set(__self__, "last_execution_time", last_execution_time)
        if retention_period_in_days is None:
            retention_period_in_days = 30
        pulumi.set(__self__, "retention_period_in_days", retention_period_in_days)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="frequencyInterval")
    def frequency_interval(self) -> int:
        """
        How often the backup should be executed (e.g. for weekly backup, this should be set to 7 and FrequencyUnit should be set to Day)
        """
        return pulumi.get(self, "frequency_interval")

    @property
    @pulumi.getter(name="frequencyUnit")
    def frequency_unit(self) -> str:
        """
        The unit of time for how often the backup should be executed (e.g. for weekly backup, this should be set to Day and FrequencyInterval should be set to 7)
        """
        return pulumi.get(self, "frequency_unit")

    @property
    @pulumi.getter(name="keepAtLeastOneBackup")
    def keep_at_least_one_backup(self) -> bool:
        """
        True if the retention policy should always keep at least one backup in the storage account, regardless how old it is; false otherwise.
        """
        return pulumi.get(self, "keep_at_least_one_backup")

    @property
    @pulumi.getter(name="lastExecutionTime")
    def last_execution_time(self) -> str:
        """
        Last time when this schedule was triggered.
        """
        return pulumi.get(self, "last_execution_time")

    @property
    @pulumi.getter(name="retentionPeriodInDays")
    def retention_period_in_days(self) -> int:
        """
        After how many days backups should be deleted.
        """
        return pulumi.get(self, "retention_period_in_days")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[str]:
        """
        When the schedule should start working.
        """
        return pulumi.get(self, "start_time")


@pulumi.output_type
class CapabilityResponse(dict):
    """
    Describes the capabilities/features allowed for a specific SKU.
    """
    def __init__(__self__, *,
                 name: Optional[str] = None,
                 reason: Optional[str] = None,
                 value: Optional[str] = None):
        """
        Describes the capabilities/features allowed for a specific SKU.
        :param str name: Name of the SKU capability.
        :param str reason: Reason of the SKU capability.
        :param str value: Value of the SKU capability.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the SKU capability.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def reason(self) -> Optional[str]:
        """
        Reason of the SKU capability.
        """
        return pulumi.get(self, "reason")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        Value of the SKU capability.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ConfigurationResponse(dict):
    """
    Non versioned Container App configuration properties that define the mutable settings of a Container app
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "activeRevisionsMode":
            suggest = "active_revisions_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 active_revisions_mode: Optional[str] = None,
                 ingress: Optional['outputs.IngressResponse'] = None,
                 registries: Optional[Sequence['outputs.RegistryCredentialsResponse']] = None,
                 secrets: Optional[Sequence['outputs.SecretResponse']] = None):
        """
        Non versioned Container App configuration properties that define the mutable settings of a Container app
        :param str active_revisions_mode: ActiveRevisionsMode controls how active revisions are handled for the Container app:
               <list><item>Multiple: multiple revisions can be active. If no value if provided, this is the default</item><item>Single: Only one revision can be active at a time. Revision weights can not be used in this mode</item></list>
        :param 'IngressResponse' ingress: Ingress configurations.
        :param Sequence['RegistryCredentialsResponse'] registries: Collection of private container registry credentials for containers used by the Container app
        :param Sequence['SecretResponse'] secrets: Collection of secrets used by a Container app
        """
        if active_revisions_mode is not None:
            pulumi.set(__self__, "active_revisions_mode", active_revisions_mode)
        if ingress is not None:
            pulumi.set(__self__, "ingress", ingress)
        if registries is not None:
            pulumi.set(__self__, "registries", registries)
        if secrets is not None:
            pulumi.set(__self__, "secrets", secrets)

    @property
    @pulumi.getter(name="activeRevisionsMode")
    def active_revisions_mode(self) -> Optional[str]:
        """
        ActiveRevisionsMode controls how active revisions are handled for the Container app:
        <list><item>Multiple: multiple revisions can be active. If no value if provided, this is the default</item><item>Single: Only one revision can be active at a time. Revision weights can not be used in this mode</item></list>
        """
        return pulumi.get(self, "active_revisions_mode")

    @property
    @pulumi.getter
    def ingress(self) -> Optional['outputs.IngressResponse']:
        """
        Ingress configurations.
        """
        return pulumi.get(self, "ingress")

    @property
    @pulumi.getter
    def registries(self) -> Optional[Sequence['outputs.RegistryCredentialsResponse']]:
        """
        Collection of private container registry credentials for containers used by the Container app
        """
        return pulumi.get(self, "registries")

    @property
    @pulumi.getter
    def secrets(self) -> Optional[Sequence['outputs.SecretResponse']]:
        """
        Collection of secrets used by a Container app
        """
        return pulumi.get(self, "secrets")


@pulumi.output_type
class ConnStringInfoResponse(dict):
    """
    Database connection string information.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectionString":
            suggest = "connection_string"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnStringInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnStringInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnStringInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connection_string: Optional[str] = None,
                 name: Optional[str] = None,
                 type: Optional[str] = None):
        """
        Database connection string information.
        :param str connection_string: Connection string value.
        :param str name: Name of connection string.
        :param str type: Type of database.
        """
        if connection_string is not None:
            pulumi.set(__self__, "connection_string", connection_string)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> Optional[str]:
        """
        Connection string value.
        """
        return pulumi.get(self, "connection_string")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of connection string.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Type of database.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ConnStringValueTypePairResponse(dict):
    """
    Database connection string value to type pair.
    """
    def __init__(__self__, *,
                 type: str,
                 value: str):
        """
        Database connection string value to type pair.
        :param str type: Type of database.
        :param str value: Value of pair.
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of database.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Value of pair.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ContainerAppSecretResponse(dict):
    """
    Container App Secret.
    """
    def __init__(__self__, *,
                 name: str,
                 value: str):
        """
        Container App Secret.
        :param str name: Secret Name.
        :param str value: Secret Value.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Secret Name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Secret Value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ContainerAppsConfigurationResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appSubnetResourceId":
            suggest = "app_subnet_resource_id"
        elif key == "controlPlaneSubnetResourceId":
            suggest = "control_plane_subnet_resource_id"
        elif key == "daprAIInstrumentationKey":
            suggest = "dapr_ai_instrumentation_key"
        elif key == "dockerBridgeCidr":
            suggest = "docker_bridge_cidr"
        elif key == "platformReservedCidr":
            suggest = "platform_reserved_cidr"
        elif key == "platformReservedDnsIP":
            suggest = "platform_reserved_dns_ip"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerAppsConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerAppsConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerAppsConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 app_subnet_resource_id: Optional[str] = None,
                 control_plane_subnet_resource_id: Optional[str] = None,
                 dapr_ai_instrumentation_key: Optional[str] = None,
                 docker_bridge_cidr: Optional[str] = None,
                 platform_reserved_cidr: Optional[str] = None,
                 platform_reserved_dns_ip: Optional[str] = None):
        """
        :param str app_subnet_resource_id: Resource ID of a subnet for control plane infrastructure components. This subnet must be in the same VNET as the subnet defined in appSubnetResourceId. Must not overlap with the IP range defined in platformReservedCidr, if defined.
        :param str control_plane_subnet_resource_id: Resource ID of a subnet for control plane infrastructure components. This subnet must be in the same VNET as the subnet defined in appSubnetResourceId. Must not overlap with the IP range defined in platformReservedCidr, if defined.
        :param str dapr_ai_instrumentation_key: Azure Monitor instrumentation key used by Dapr to export Service to Service communication telemetry
        :param str docker_bridge_cidr: CIDR notation IP range assigned to the Docker bridge network. It must not overlap with any Subnet IP ranges or the IP range defined in platformReservedCidr, if defined.
        :param str platform_reserved_cidr: IP range in CIDR notation that can be reserved for environment infrastructure IP addresses. It must not overlap with any other Subnet IP ranges.
        :param str platform_reserved_dns_ip: An IP address from the IP range defined by platformReservedCidr that will be reserved for the internal DNS server
        """
        if app_subnet_resource_id is not None:
            pulumi.set(__self__, "app_subnet_resource_id", app_subnet_resource_id)
        if control_plane_subnet_resource_id is not None:
            pulumi.set(__self__, "control_plane_subnet_resource_id", control_plane_subnet_resource_id)
        if dapr_ai_instrumentation_key is not None:
            pulumi.set(__self__, "dapr_ai_instrumentation_key", dapr_ai_instrumentation_key)
        if docker_bridge_cidr is not None:
            pulumi.set(__self__, "docker_bridge_cidr", docker_bridge_cidr)
        if platform_reserved_cidr is not None:
            pulumi.set(__self__, "platform_reserved_cidr", platform_reserved_cidr)
        if platform_reserved_dns_ip is not None:
            pulumi.set(__self__, "platform_reserved_dns_ip", platform_reserved_dns_ip)

    @property
    @pulumi.getter(name="appSubnetResourceId")
    def app_subnet_resource_id(self) -> Optional[str]:
        """
        Resource ID of a subnet for control plane infrastructure components. This subnet must be in the same VNET as the subnet defined in appSubnetResourceId. Must not overlap with the IP range defined in platformReservedCidr, if defined.
        """
        return pulumi.get(self, "app_subnet_resource_id")

    @property
    @pulumi.getter(name="controlPlaneSubnetResourceId")
    def control_plane_subnet_resource_id(self) -> Optional[str]:
        """
        Resource ID of a subnet for control plane infrastructure components. This subnet must be in the same VNET as the subnet defined in appSubnetResourceId. Must not overlap with the IP range defined in platformReservedCidr, if defined.
        """
        return pulumi.get(self, "control_plane_subnet_resource_id")

    @property
    @pulumi.getter(name="daprAIInstrumentationKey")
    def dapr_ai_instrumentation_key(self) -> Optional[str]:
        """
        Azure Monitor instrumentation key used by Dapr to export Service to Service communication telemetry
        """
        return pulumi.get(self, "dapr_ai_instrumentation_key")

    @property
    @pulumi.getter(name="dockerBridgeCidr")
    def docker_bridge_cidr(self) -> Optional[str]:
        """
        CIDR notation IP range assigned to the Docker bridge network. It must not overlap with any Subnet IP ranges or the IP range defined in platformReservedCidr, if defined.
        """
        return pulumi.get(self, "docker_bridge_cidr")

    @property
    @pulumi.getter(name="platformReservedCidr")
    def platform_reserved_cidr(self) -> Optional[str]:
        """
        IP range in CIDR notation that can be reserved for environment infrastructure IP addresses. It must not overlap with any other Subnet IP ranges.
        """
        return pulumi.get(self, "platform_reserved_cidr")

    @property
    @pulumi.getter(name="platformReservedDnsIP")
    def platform_reserved_dns_ip(self) -> Optional[str]:
        """
        An IP address from the IP range defined by platformReservedCidr that will be reserved for the internal DNS server
        """
        return pulumi.get(self, "platform_reserved_dns_ip")


@pulumi.output_type
class ContainerResourcesResponse(dict):
    """
    Container App container resource requirements.
    """
    def __init__(__self__, *,
                 cpu: Optional[float] = None,
                 memory: Optional[str] = None):
        """
        Container App container resource requirements.
        :param float cpu: Required CPU in cores, e.g. 0.5
        :param str memory: Required memory, e.g. "250Mb"
        """
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if memory is not None:
            pulumi.set(__self__, "memory", memory)

    @property
    @pulumi.getter
    def cpu(self) -> Optional[float]:
        """
        Required CPU in cores, e.g. 0.5
        """
        return pulumi.get(self, "cpu")

    @property
    @pulumi.getter
    def memory(self) -> Optional[str]:
        """
        Required memory, e.g. "250Mb"
        """
        return pulumi.get(self, "memory")


@pulumi.output_type
class ContainerResponse(dict):
    """
    Container App container definition.
    """
    def __init__(__self__, *,
                 args: Optional[Sequence[str]] = None,
                 command: Optional[Sequence[str]] = None,
                 env: Optional[Sequence['outputs.EnvironmentVarResponse']] = None,
                 image: Optional[str] = None,
                 name: Optional[str] = None,
                 resources: Optional['outputs.ContainerResourcesResponse'] = None):
        """
        Container App container definition.
        :param Sequence[str] args: Container start command arguments.
        :param Sequence[str] command: Container start command.
        :param Sequence['EnvironmentVarResponse'] env: Container environment variables.
        :param str image: Container image tag.
        :param str name: Custom container name.
        :param 'ContainerResourcesResponse' resources: Container resource requirements.
        """
        if args is not None:
            pulumi.set(__self__, "args", args)
        if command is not None:
            pulumi.set(__self__, "command", command)
        if env is not None:
            pulumi.set(__self__, "env", env)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)

    @property
    @pulumi.getter
    def args(self) -> Optional[Sequence[str]]:
        """
        Container start command arguments.
        """
        return pulumi.get(self, "args")

    @property
    @pulumi.getter
    def command(self) -> Optional[Sequence[str]]:
        """
        Container start command.
        """
        return pulumi.get(self, "command")

    @property
    @pulumi.getter
    def env(self) -> Optional[Sequence['outputs.EnvironmentVarResponse']]:
        """
        Container environment variables.
        """
        return pulumi.get(self, "env")

    @property
    @pulumi.getter
    def image(self) -> Optional[str]:
        """
        Container image tag.
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Custom container name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def resources(self) -> Optional['outputs.ContainerResourcesResponse']:
        """
        Container resource requirements.
        """
        return pulumi.get(self, "resources")


@pulumi.output_type
class CorsSettingsResponse(dict):
    """
    Cross-Origin Resource Sharing (CORS) settings for the app.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedOrigins":
            suggest = "allowed_origins"
        elif key == "supportCredentials":
            suggest = "support_credentials"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CorsSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CorsSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CorsSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_origins: Optional[Sequence[str]] = None,
                 support_credentials: Optional[bool] = None):
        """
        Cross-Origin Resource Sharing (CORS) settings for the app.
        :param Sequence[str] allowed_origins: Gets or sets the list of origins that should be allowed to make cross-origin
               calls (for example: http://example.com:12345). Use "*" to allow all.
        :param bool support_credentials: Gets or sets whether CORS requests with credentials are allowed. See 
               https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS#Requests_with_credentials
               for more details.
        """
        if allowed_origins is not None:
            pulumi.set(__self__, "allowed_origins", allowed_origins)
        if support_credentials is not None:
            pulumi.set(__self__, "support_credentials", support_credentials)

    @property
    @pulumi.getter(name="allowedOrigins")
    def allowed_origins(self) -> Optional[Sequence[str]]:
        """
        Gets or sets the list of origins that should be allowed to make cross-origin
        calls (for example: http://example.com:12345). Use "*" to allow all.
        """
        return pulumi.get(self, "allowed_origins")

    @property
    @pulumi.getter(name="supportCredentials")
    def support_credentials(self) -> Optional[bool]:
        """
        Gets or sets whether CORS requests with credentials are allowed. See 
        https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS#Requests_with_credentials
        for more details.
        """
        return pulumi.get(self, "support_credentials")


@pulumi.output_type
class CustomDnsSuffixConfigurationResponse(dict):
    """
    Full view of the custom domain suffix configuration for ASEv3.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningDetails":
            suggest = "provisioning_details"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "certificateUrl":
            suggest = "certificate_url"
        elif key == "dnsSuffix":
            suggest = "dns_suffix"
        elif key == "keyVaultReferenceIdentity":
            suggest = "key_vault_reference_identity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomDnsSuffixConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomDnsSuffixConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomDnsSuffixConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 name: str,
                 provisioning_details: str,
                 provisioning_state: str,
                 type: str,
                 certificate_url: Optional[str] = None,
                 dns_suffix: Optional[str] = None,
                 key_vault_reference_identity: Optional[str] = None,
                 kind: Optional[str] = None):
        """
        Full view of the custom domain suffix configuration for ASEv3.
        :param str id: Resource Id.
        :param str name: Resource Name.
        :param str type: Resource type.
        :param str certificate_url: The URL referencing the Azure Key Vault certificate secret that should be used as the default SSL/TLS certificate for sites with the custom domain suffix.
        :param str dns_suffix: The default custom domain suffix to use for all sites deployed on the ASE.
        :param str key_vault_reference_identity: The user-assigned identity to use for resolving the key vault certificate reference. If not specified, the system-assigned ASE identity will be used if available.
        :param str kind: Kind of resource.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "provisioning_details", provisioning_details)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "type", type)
        if certificate_url is not None:
            pulumi.set(__self__, "certificate_url", certificate_url)
        if dns_suffix is not None:
            pulumi.set(__self__, "dns_suffix", dns_suffix)
        if key_vault_reference_identity is not None:
            pulumi.set(__self__, "key_vault_reference_identity", key_vault_reference_identity)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Resource Id.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Resource Name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="provisioningDetails")
    def provisioning_details(self) -> str:
        return pulumi.get(self, "provisioning_details")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Resource type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="certificateUrl")
    def certificate_url(self) -> Optional[str]:
        """
        The URL referencing the Azure Key Vault certificate secret that should be used as the default SSL/TLS certificate for sites with the custom domain suffix.
        """
        return pulumi.get(self, "certificate_url")

    @property
    @pulumi.getter(name="dnsSuffix")
    def dns_suffix(self) -> Optional[str]:
        """
        The default custom domain suffix to use for all sites deployed on the ASE.
        """
        return pulumi.get(self, "dns_suffix")

    @property
    @pulumi.getter(name="keyVaultReferenceIdentity")
    def key_vault_reference_identity(self) -> Optional[str]:
        """
        The user-assigned identity to use for resolving the key vault certificate reference. If not specified, the system-assigned ASE identity will be used if available.
        """
        return pulumi.get(self, "key_vault_reference_identity")

    @property
    @pulumi.getter
    def kind(self) -> Optional[str]:
        """
        Kind of resource.
        """
        return pulumi.get(self, "kind")


@pulumi.output_type
class CustomScaleRuleResponse(dict):
    """
    Container App container Custom scaling rule.
    """
    def __init__(__self__, *,
                 auth: Optional[Sequence['outputs.ScaleRuleAuthResponse']] = None,
                 metadata: Optional[Mapping[str, str]] = None,
                 type: Optional[str] = None):
        """
        Container App container Custom scaling rule.
        :param Sequence['ScaleRuleAuthResponse'] auth: Authentication secrets for the custom scale rule.
        :param Mapping[str, str] metadata: Metadata properties to describe custom scale rule.
        :param str type: Type of the custom scale rule
               eg: azure-servicebus, redis etc.
        """
        if auth is not None:
            pulumi.set(__self__, "auth", auth)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def auth(self) -> Optional[Sequence['outputs.ScaleRuleAuthResponse']]:
        """
        Authentication secrets for the custom scale rule.
        """
        return pulumi.get(self, "auth")

    @property
    @pulumi.getter
    def metadata(self) -> Optional[Mapping[str, str]]:
        """
        Metadata properties to describe custom scale rule.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Type of the custom scale rule
        eg: azure-servicebus, redis etc.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class DaprComponentResponse(dict):
    """
    Dapr component configuration
    """
    def __init__(__self__, *,
                 metadata: Optional[Sequence['outputs.DaprMetadataResponse']] = None,
                 name: Optional[str] = None,
                 type: Optional[str] = None,
                 version: Optional[str] = None):
        """
        Dapr component configuration
        :param Sequence['DaprMetadataResponse'] metadata: Component metadata
        :param str name: Component name
        :param str type: Component type
        :param str version: Component version
        """
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[Sequence['outputs.DaprMetadataResponse']]:
        """
        Component metadata
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Component name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Component type
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        Component version
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class DaprMetadataResponse(dict):
    """
    Container App Dapr component metadata.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretRef":
            suggest = "secret_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DaprMetadataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DaprMetadataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DaprMetadataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: Optional[str] = None,
                 secret_ref: Optional[str] = None,
                 value: Optional[str] = None):
        """
        Container App Dapr component metadata.
        :param str name: Metadata property name.
        :param str secret_ref: Name of the Container App secret from which to pull the metadata property value.
        :param str value: Metadata property value.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if secret_ref is not None:
            pulumi.set(__self__, "secret_ref", secret_ref)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Metadata property name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="secretRef")
    def secret_ref(self) -> Optional[str]:
        """
        Name of the Container App secret from which to pull the metadata property value.
        """
        return pulumi.get(self, "secret_ref")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        Metadata property value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class DaprResponse(dict):
    """
    Container App Dapr configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appId":
            suggest = "app_id"
        elif key == "appPort":
            suggest = "app_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DaprResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DaprResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DaprResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 app_id: Optional[str] = None,
                 app_port: Optional[int] = None,
                 components: Optional[Sequence['outputs.DaprComponentResponse']] = None,
                 enabled: Optional[bool] = None):
        """
        Container App Dapr configuration.
        :param str app_id: Dapr application identifier
        :param int app_port: Port on which the Dapr side car
        :param Sequence['DaprComponentResponse'] components: Collection of Dapr components
        :param bool enabled: Boolean indicating if the Dapr side car is enabled
        """
        if app_id is not None:
            pulumi.set(__self__, "app_id", app_id)
        if app_port is not None:
            pulumi.set(__self__, "app_port", app_port)
        if components is not None:
            pulumi.set(__self__, "components", components)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter(name="appId")
    def app_id(self) -> Optional[str]:
        """
        Dapr application identifier
        """
        return pulumi.get(self, "app_id")

    @property
    @pulumi.getter(name="appPort")
    def app_port(self) -> Optional[int]:
        """
        Port on which the Dapr side car
        """
        return pulumi.get(self, "app_port")

    @property
    @pulumi.getter
    def components(self) -> Optional[Sequence['outputs.DaprComponentResponse']]:
        """
        Collection of Dapr components
        """
        return pulumi.get(self, "components")

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Boolean indicating if the Dapr side car is enabled
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class DatabaseBackupSettingResponse(dict):
    """
    Database backup settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "databaseType":
            suggest = "database_type"
        elif key == "connectionString":
            suggest = "connection_string"
        elif key == "connectionStringName":
            suggest = "connection_string_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseBackupSettingResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseBackupSettingResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseBackupSettingResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 database_type: str,
                 connection_string: Optional[str] = None,
                 connection_string_name: Optional[str] = None,
                 name: Optional[str] = None):
        """
        Database backup settings.
        :param str database_type: Database type (e.g. SqlAzure / MySql).
        :param str connection_string: Contains a connection string to a database which is being backed up or restored. If the restore should happen to a new database, the database name inside is the new one.
        :param str connection_string_name: Contains a connection string name that is linked to the SiteConfig.ConnectionStrings.
               This is used during restore with overwrite connection strings options.
        """
        pulumi.set(__self__, "database_type", database_type)
        if connection_string is not None:
            pulumi.set(__self__, "connection_string", connection_string)
        if connection_string_name is not None:
            pulumi.set(__self__, "connection_string_name", connection_string_name)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="databaseType")
    def database_type(self) -> str:
        """
        Database type (e.g. SqlAzure / MySql).
        """
        return pulumi.get(self, "database_type")

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> Optional[str]:
        """
        Contains a connection string to a database which is being backed up or restored. If the restore should happen to a new database, the database name inside is the new one.
        """
        return pulumi.get(self, "connection_string")

    @property
    @pulumi.getter(name="connectionStringName")
    def connection_string_name(self) -> Optional[str]:
        """
        Contains a connection string name that is linked to the SiteConfig.ConnectionStrings.
        This is used during restore with overwrite connection strings options.
        """
        return pulumi.get(self, "connection_string_name")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        return pulumi.get(self, "name")


@pulumi.output_type
class DatabaseConnectionOverviewResponse(dict):
    """
    Static Site Database Connection overview.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "configurationFiles":
            suggest = "configuration_files"
        elif key == "connectionIdentity":
            suggest = "connection_identity"
        elif key == "resourceId":
            suggest = "resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseConnectionOverviewResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseConnectionOverviewResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseConnectionOverviewResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 configuration_files: Sequence['outputs.StaticSiteDatabaseConnectionConfigurationFileOverviewResponse'],
                 connection_identity: str,
                 name: str,
                 region: str,
                 resource_id: str):
        """
        Static Site Database Connection overview.
        :param Sequence['StaticSiteDatabaseConnectionConfigurationFileOverviewResponse'] configuration_files: A list of configuration files associated with this database connection.
        :param str connection_identity: If present, the identity is used in conjunction with connection string to connect to the database. Use of the system-assigned managed identity is indicated with the string 'SystemAssigned', while use of a user-assigned managed identity is indicated with the resource id of the managed identity resource.
        :param str name: If present, the name of this database connection resource.
        :param str region: The region of the database resource.
        :param str resource_id: The resource id of the database.
        """
        pulumi.set(__self__, "configuration_files", configuration_files)
        pulumi.set(__self__, "connection_identity", connection_identity)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "resource_id", resource_id)

    @property
    @pulumi.getter(name="configurationFiles")
    def configuration_files(self) -> Sequence['outputs.StaticSiteDatabaseConnectionConfigurationFileOverviewResponse']:
        """
        A list of configuration files associated with this database connection.
        """
        return pulumi.get(self, "configuration_files")

    @property
    @pulumi.getter(name="connectionIdentity")
    def connection_identity(self) -> str:
        """
        If present, the identity is used in conjunction with connection string to connect to the database. Use of the system-assigned managed identity is indicated with the string 'SystemAssigned', while use of a user-assigned managed identity is indicated with the resource id of the managed identity resource.
        """
        return pulumi.get(self, "connection_identity")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        If present, the name of this database connection resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        The region of the database resource.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> str:
        """
        The resource id of the database.
        """
        return pulumi.get(self, "resource_id")


@pulumi.output_type
class EnabledConfigResponse(dict):
    """
    Enabled configuration.
    """
    def __init__(__self__, *,
                 enabled: Optional[bool] = None):
        """
        Enabled configuration.
        :param bool enabled: True if configuration is enabled, false if it is disabled and null if configuration is not set.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        True if configuration is enabled, false if it is disabled and null if configuration is not set.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class EnvironmentVarResponse(dict):
    """
    Container App container environment variable.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretRef":
            suggest = "secret_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EnvironmentVarResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EnvironmentVarResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EnvironmentVarResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: Optional[str] = None,
                 secret_ref: Optional[str] = None,
                 value: Optional[str] = None):
        """
        Container App container environment variable.
        :param str name: Environment variable name.
        :param str secret_ref: Name of the Container App secret from which to pull the environment variable value.
        :param str value: Non-secret environment variable value.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if secret_ref is not None:
            pulumi.set(__self__, "secret_ref", secret_ref)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Environment variable name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="secretRef")
    def secret_ref(self) -> Optional[str]:
        """
        Name of the Container App secret from which to pull the environment variable value.
        """
        return pulumi.get(self, "secret_ref")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        Non-secret environment variable value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ErrorEntityResponse(dict):
    """
    Body of the error response returned from the API.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "extendedCode":
            suggest = "extended_code"
        elif key == "innerErrors":
            suggest = "inner_errors"
        elif key == "messageTemplate":
            suggest = "message_template"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ErrorEntityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ErrorEntityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ErrorEntityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 code: Optional[str] = None,
                 details: Optional[Sequence['outputs.ErrorEntityResponse']] = None,
                 extended_code: Optional[str] = None,
                 inner_errors: Optional[Sequence['outputs.ErrorEntityResponse']] = None,
                 message: Optional[str] = None,
                 message_template: Optional[str] = None,
                 parameters: Optional[Sequence[str]] = None,
                 target: Optional[str] = None):
        """
        Body of the error response returned from the API.
        :param str code: Basic error code.
        :param Sequence['ErrorEntityResponse'] details: Error Details.
        :param str extended_code: Type of error.
        :param Sequence['ErrorEntityResponse'] inner_errors: Inner errors.
        :param str message: Any details of the error.
        :param str message_template: Message template.
        :param Sequence[str] parameters: Parameters for the template.
        :param str target: The error target.
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if details is not None:
            pulumi.set(__self__, "details", details)
        if extended_code is not None:
            pulumi.set(__self__, "extended_code", extended_code)
        if inner_errors is not None:
            pulumi.set(__self__, "inner_errors", inner_errors)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if message_template is not None:
            pulumi.set(__self__, "message_template", message_template)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if target is not None:
            pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter
    def code(self) -> Optional[str]:
        """
        Basic error code.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def details(self) -> Optional[Sequence['outputs.ErrorEntityResponse']]:
        """
        Error Details.
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter(name="extendedCode")
    def extended_code(self) -> Optional[str]:
        """
        Type of error.
        """
        return pulumi.get(self, "extended_code")

    @property
    @pulumi.getter(name="innerErrors")
    def inner_errors(self) -> Optional[Sequence['outputs.ErrorEntityResponse']]:
        """
        Inner errors.
        """
        return pulumi.get(self, "inner_errors")

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        """
        Any details of the error.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter(name="messageTemplate")
    def message_template(self) -> Optional[str]:
        """
        Message template.
        """
        return pulumi.get(self, "message_template")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[Sequence[str]]:
        """
        Parameters for the template.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def target(self) -> Optional[str]:
        """
        The error target.
        """
        return pulumi.get(self, "target")


@pulumi.output_type
class ExperimentsResponse(dict):
    """
    Routing rules in production experiments.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "rampUpRules":
            suggest = "ramp_up_rules"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExperimentsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExperimentsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExperimentsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ramp_up_rules: Optional[Sequence['outputs.RampUpRuleResponse']] = None):
        """
        Routing rules in production experiments.
        :param Sequence['RampUpRuleResponse'] ramp_up_rules: List of ramp-up rules.
        """
        if ramp_up_rules is not None:
            pulumi.set(__self__, "ramp_up_rules", ramp_up_rules)

    @property
    @pulumi.getter(name="rampUpRules")
    def ramp_up_rules(self) -> Optional[Sequence['outputs.RampUpRuleResponse']]:
        """
        List of ramp-up rules.
        """
        return pulumi.get(self, "ramp_up_rules")


@pulumi.output_type
class ExpressionResponse(dict):
    """
    The expression.
    """
    def __init__(__self__, *,
                 error: Optional['outputs.AzureResourceErrorInfoResponse'] = None,
                 subexpressions: Optional[Sequence['outputs.ExpressionResponse']] = None,
                 text: Optional[str] = None,
                 value: Optional[Any] = None):
        """
        The expression.
        :param 'AzureResourceErrorInfoResponse' error: The azure resource error info.
        :param Sequence['ExpressionResponse'] subexpressions: The sub expressions.
        :param str text: The text.
        """
        if error is not None:
            pulumi.set(__self__, "error", error)
        if subexpressions is not None:
            pulumi.set(__self__, "subexpressions", subexpressions)
        if text is not None:
            pulumi.set(__self__, "text", text)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def error(self) -> Optional['outputs.AzureResourceErrorInfoResponse']:
        """
        The azure resource error info.
        """
        return pulumi.get(self, "error")

    @property
    @pulumi.getter
    def subexpressions(self) -> Optional[Sequence['outputs.ExpressionResponse']]:
        """
        The sub expressions.
        """
        return pulumi.get(self, "subexpressions")

    @property
    @pulumi.getter
    def text(self) -> Optional[str]:
        """
        The text.
        """
        return pulumi.get(self, "text")

    @property
    @pulumi.getter
    def value(self) -> Optional[Any]:
        return pulumi.get(self, "value")


@pulumi.output_type
class ExpressionRootResponse(dict):
    """
    The expression root.
    """
    def __init__(__self__, *,
                 error: Optional['outputs.AzureResourceErrorInfoResponse'] = None,
                 path: Optional[str] = None,
                 subexpressions: Optional[Sequence['outputs.ExpressionResponse']] = None,
                 text: Optional[str] = None,
                 value: Optional[Any] = None):
        """
        The expression root.
        :param 'AzureResourceErrorInfoResponse' error: The azure resource error info.
        :param str path: The path.
        :param Sequence['ExpressionResponse'] subexpressions: The sub expressions.
        :param str text: The text.
        """
        if error is not None:
            pulumi.set(__self__, "error", error)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if subexpressions is not None:
            pulumi.set(__self__, "subexpressions", subexpressions)
        if text is not None:
            pulumi.set(__self__, "text", text)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def error(self) -> Optional['outputs.AzureResourceErrorInfoResponse']:
        """
        The azure resource error info.
        """
        return pulumi.get(self, "error")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        The path.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def subexpressions(self) -> Optional[Sequence['outputs.ExpressionResponse']]:
        """
        The sub expressions.
        """
        return pulumi.get(self, "subexpressions")

    @property
    @pulumi.getter
    def text(self) -> Optional[str]:
        """
        The text.
        """
        return pulumi.get(self, "text")

    @property
    @pulumi.getter
    def value(self) -> Optional[Any]:
        return pulumi.get(self, "value")


@pulumi.output_type
class ExtendedLocationResponse(dict):
    """
    Extended Location.
    """
    def __init__(__self__, *,
                 type: str,
                 name: Optional[str] = None):
        """
        Extended Location.
        :param str type: Type of extended location.
        :param str name: Name of extended location.
        """
        pulumi.set(__self__, "type", type)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of extended location.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of extended location.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class FileSystemApplicationLogsConfigResponse(dict):
    """
    Application logs to file system configuration.
    """
    def __init__(__self__, *,
                 level: Optional[str] = None):
        """
        Application logs to file system configuration.
        :param str level: Log level.
        """
        if level is None:
            level = 'Off'
        if level is not None:
            pulumi.set(__self__, "level", level)

    @property
    @pulumi.getter
    def level(self) -> Optional[str]:
        """
        Log level.
        """
        return pulumi.get(self, "level")


@pulumi.output_type
class FileSystemHttpLogsConfigResponse(dict):
    """
    Http logs to file system configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "retentionInDays":
            suggest = "retention_in_days"
        elif key == "retentionInMb":
            suggest = "retention_in_mb"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FileSystemHttpLogsConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FileSystemHttpLogsConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FileSystemHttpLogsConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: Optional[bool] = None,
                 retention_in_days: Optional[int] = None,
                 retention_in_mb: Optional[int] = None):
        """
        Http logs to file system configuration.
        :param bool enabled: True if configuration is enabled, false if it is disabled and null if configuration is not set.
        :param int retention_in_days: Retention in days.
               Remove files older than X days.
               0 or lower means no retention.
        :param int retention_in_mb: Maximum size in megabytes that http log files can use.
               When reached old log files will be removed to make space for new ones.
               Value can range between 25 and 100.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if retention_in_days is not None:
            pulumi.set(__self__, "retention_in_days", retention_in_days)
        if retention_in_mb is not None:
            pulumi.set(__self__, "retention_in_mb", retention_in_mb)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        True if configuration is enabled, false if it is disabled and null if configuration is not set.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="retentionInDays")
    def retention_in_days(self) -> Optional[int]:
        """
        Retention in days.
        Remove files older than X days.
        0 or lower means no retention.
        """
        return pulumi.get(self, "retention_in_days")

    @property
    @pulumi.getter(name="retentionInMb")
    def retention_in_mb(self) -> Optional[int]:
        """
        Maximum size in megabytes that http log files can use.
        When reached old log files will be removed to make space for new ones.
        Value can range between 25 and 100.
        """
        return pulumi.get(self, "retention_in_mb")


@pulumi.output_type
class FrontEndConfigurationResponse(dict):
    def __init__(__self__, *,
                 kind: Optional[str] = None):
        if kind is not None:
            pulumi.set(__self__, "kind", kind)

    @property
    @pulumi.getter
    def kind(self) -> Optional[str]:
        return pulumi.get(self, "kind")


@pulumi.output_type
class GitHubActionCodeConfigurationResponse(dict):
    """
    The GitHub action code configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "runtimeStack":
            suggest = "runtime_stack"
        elif key == "runtimeVersion":
            suggest = "runtime_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GitHubActionCodeConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GitHubActionCodeConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GitHubActionCodeConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 runtime_stack: Optional[str] = None,
                 runtime_version: Optional[str] = None):
        """
        The GitHub action code configuration.
        :param str runtime_stack: Runtime stack is used to determine the workflow file content for code base apps.
        :param str runtime_version: Runtime version is used to determine what build version to set in the workflow file.
        """
        if runtime_stack is not None:
            pulumi.set(__self__, "runtime_stack", runtime_stack)
        if runtime_version is not None:
            pulumi.set(__self__, "runtime_version", runtime_version)

    @property
    @pulumi.getter(name="runtimeStack")
    def runtime_stack(self) -> Optional[str]:
        """
        Runtime stack is used to determine the workflow file content for code base apps.
        """
        return pulumi.get(self, "runtime_stack")

    @property
    @pulumi.getter(name="runtimeVersion")
    def runtime_version(self) -> Optional[str]:
        """
        Runtime version is used to determine what build version to set in the workflow file.
        """
        return pulumi.get(self, "runtime_version")


@pulumi.output_type
class GitHubActionConfigurationResponse(dict):
    """
    The GitHub action configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "codeConfiguration":
            suggest = "code_configuration"
        elif key == "containerConfiguration":
            suggest = "container_configuration"
        elif key == "generateWorkflowFile":
            suggest = "generate_workflow_file"
        elif key == "isLinux":
            suggest = "is_linux"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GitHubActionConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GitHubActionConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GitHubActionConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 code_configuration: Optional['outputs.GitHubActionCodeConfigurationResponse'] = None,
                 container_configuration: Optional['outputs.GitHubActionContainerConfigurationResponse'] = None,
                 generate_workflow_file: Optional[bool] = None,
                 is_linux: Optional[bool] = None):
        """
        The GitHub action configuration.
        :param 'GitHubActionCodeConfigurationResponse' code_configuration: GitHub Action code configuration.
        :param 'GitHubActionContainerConfigurationResponse' container_configuration: GitHub Action container configuration.
        :param bool generate_workflow_file: Workflow option to determine whether the workflow file should be generated and written to the repository.
        :param bool is_linux: This will help determine the workflow configuration to select.
        """
        if code_configuration is not None:
            pulumi.set(__self__, "code_configuration", code_configuration)
        if container_configuration is not None:
            pulumi.set(__self__, "container_configuration", container_configuration)
        if generate_workflow_file is not None:
            pulumi.set(__self__, "generate_workflow_file", generate_workflow_file)
        if is_linux is not None:
            pulumi.set(__self__, "is_linux", is_linux)

    @property
    @pulumi.getter(name="codeConfiguration")
    def code_configuration(self) -> Optional['outputs.GitHubActionCodeConfigurationResponse']:
        """
        GitHub Action code configuration.
        """
        return pulumi.get(self, "code_configuration")

    @property
    @pulumi.getter(name="containerConfiguration")
    def container_configuration(self) -> Optional['outputs.GitHubActionContainerConfigurationResponse']:
        """
        GitHub Action container configuration.
        """
        return pulumi.get(self, "container_configuration")

    @property
    @pulumi.getter(name="generateWorkflowFile")
    def generate_workflow_file(self) -> Optional[bool]:
        """
        Workflow option to determine whether the workflow file should be generated and written to the repository.
        """
        return pulumi.get(self, "generate_workflow_file")

    @property
    @pulumi.getter(name="isLinux")
    def is_linux(self) -> Optional[bool]:
        """
        This will help determine the workflow configuration to select.
        """
        return pulumi.get(self, "is_linux")


@pulumi.output_type
class GitHubActionContainerConfigurationResponse(dict):
    """
    The GitHub action container configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "imageName":
            suggest = "image_name"
        elif key == "serverUrl":
            suggest = "server_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GitHubActionContainerConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GitHubActionContainerConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GitHubActionContainerConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 image_name: Optional[str] = None,
                 password: Optional[str] = None,
                 server_url: Optional[str] = None,
                 username: Optional[str] = None):
        """
        The GitHub action container configuration.
        :param str image_name: The image name for the build.
        :param str password: The password used to upload the image to the container registry.
        :param str server_url: The server URL for the container registry where the build will be hosted.
        :param str username: The username used to upload the image to the container registry.
        """
        if image_name is not None:
            pulumi.set(__self__, "image_name", image_name)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if server_url is not None:
            pulumi.set(__self__, "server_url", server_url)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="imageName")
    def image_name(self) -> Optional[str]:
        """
        The image name for the build.
        """
        return pulumi.get(self, "image_name")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        The password used to upload the image to the container registry.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="serverUrl")
    def server_url(self) -> Optional[str]:
        """
        The server URL for the container registry where the build will be hosted.
        """
        return pulumi.get(self, "server_url")

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        """
        The username used to upload the image to the container registry.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class HandlerMappingResponse(dict):
    """
    The IIS handler mappings used to define which handler processes HTTP requests with certain extension. 
    For example, it is used to configure php-cgi.exe process to handle all HTTP requests with *.php extension.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "scriptProcessor":
            suggest = "script_processor"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HandlerMappingResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HandlerMappingResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HandlerMappingResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 arguments: Optional[str] = None,
                 extension: Optional[str] = None,
                 script_processor: Optional[str] = None):
        """
        The IIS handler mappings used to define which handler processes HTTP requests with certain extension. 
        For example, it is used to configure php-cgi.exe process to handle all HTTP requests with *.php extension.
        :param str arguments: Command-line arguments to be passed to the script processor.
        :param str extension: Requests with this extension will be handled using the specified FastCGI application.
        :param str script_processor: The absolute path to the FastCGI application.
        """
        if arguments is not None:
            pulumi.set(__self__, "arguments", arguments)
        if extension is not None:
            pulumi.set(__self__, "extension", extension)
        if script_processor is not None:
            pulumi.set(__self__, "script_processor", script_processor)

    @property
    @pulumi.getter
    def arguments(self) -> Optional[str]:
        """
        Command-line arguments to be passed to the script processor.
        """
        return pulumi.get(self, "arguments")

    @property
    @pulumi.getter
    def extension(self) -> Optional[str]:
        """
        Requests with this extension will be handled using the specified FastCGI application.
        """
        return pulumi.get(self, "extension")

    @property
    @pulumi.getter(name="scriptProcessor")
    def script_processor(self) -> Optional[str]:
        """
        The absolute path to the FastCGI application.
        """
        return pulumi.get(self, "script_processor")


@pulumi.output_type
class HostNameSslStateResponse(dict):
    """
    SSL-enabled hostname.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hostType":
            suggest = "host_type"
        elif key == "sslState":
            suggest = "ssl_state"
        elif key == "toUpdate":
            suggest = "to_update"
        elif key == "virtualIP":
            suggest = "virtual_ip"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HostNameSslStateResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HostNameSslStateResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HostNameSslStateResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 host_type: Optional[str] = None,
                 name: Optional[str] = None,
                 ssl_state: Optional[str] = None,
                 thumbprint: Optional[str] = None,
                 to_update: Optional[bool] = None,
                 virtual_ip: Optional[str] = None):
        """
        SSL-enabled hostname.
        :param str host_type: Indicates whether the hostname is a standard or repository hostname.
        :param str name: Hostname.
        :param str ssl_state: SSL type.
        :param str thumbprint: SSL certificate thumbprint.
        :param bool to_update: Set to <code>true</code> to update existing hostname.
        :param str virtual_ip: Virtual IP address assigned to the hostname if IP based SSL is enabled.
        """
        if host_type is not None:
            pulumi.set(__self__, "host_type", host_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ssl_state is not None:
            pulumi.set(__self__, "ssl_state", ssl_state)
        if thumbprint is not None:
            pulumi.set(__self__, "thumbprint", thumbprint)
        if to_update is not None:
            pulumi.set(__self__, "to_update", to_update)
        if virtual_ip is not None:
            pulumi.set(__self__, "virtual_ip", virtual_ip)

    @property
    @pulumi.getter(name="hostType")
    def host_type(self) -> Optional[str]:
        """
        Indicates whether the hostname is a standard or repository hostname.
        """
        return pulumi.get(self, "host_type")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Hostname.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="sslState")
    def ssl_state(self) -> Optional[str]:
        """
        SSL type.
        """
        return pulumi.get(self, "ssl_state")

    @property
    @pulumi.getter
    def thumbprint(self) -> Optional[str]:
        """
        SSL certificate thumbprint.
        """
        return pulumi.get(self, "thumbprint")

    @property
    @pulumi.getter(name="toUpdate")
    def to_update(self) -> Optional[bool]:
        """
        Set to <code>true</code> to update existing hostname.
        """
        return pulumi.get(self, "to_update")

    @property
    @pulumi.getter(name="virtualIP")
    def virtual_ip(self) -> Optional[str]:
        """
        Virtual IP address assigned to the hostname if IP based SSL is enabled.
        """
        return pulumi.get(self, "virtual_ip")


@pulumi.output_type
class HostingEnvironmentProfileResponse(dict):
    """
    Specification for an App Service Environment to use for this resource.
    """
    def __init__(__self__, *,
                 name: str,
                 type: str,
                 id: Optional[str] = None):
        """
        Specification for an App Service Environment to use for this resource.
        :param str name: Name of the App Service Environment.
        :param str type: Resource type of the App Service Environment.
        :param str id: Resource ID of the App Service Environment.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the App Service Environment.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Resource type of the App Service Environment.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID of the App Service Environment.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class HttpLogsConfigResponse(dict):
    """
    Http logs configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "azureBlobStorage":
            suggest = "azure_blob_storage"
        elif key == "fileSystem":
            suggest = "file_system"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HttpLogsConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HttpLogsConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HttpLogsConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 azure_blob_storage: Optional['outputs.AzureBlobStorageHttpLogsConfigResponse'] = None,
                 file_system: Optional['outputs.FileSystemHttpLogsConfigResponse'] = None):
        """
        Http logs configuration.
        :param 'AzureBlobStorageHttpLogsConfigResponse' azure_blob_storage: Http logs to azure blob storage configuration.
        :param 'FileSystemHttpLogsConfigResponse' file_system: Http logs to file system configuration.
        """
        if azure_blob_storage is not None:
            pulumi.set(__self__, "azure_blob_storage", azure_blob_storage)
        if file_system is not None:
            pulumi.set(__self__, "file_system", file_system)

    @property
    @pulumi.getter(name="azureBlobStorage")
    def azure_blob_storage(self) -> Optional['outputs.AzureBlobStorageHttpLogsConfigResponse']:
        """
        Http logs to azure blob storage configuration.
        """
        return pulumi.get(self, "azure_blob_storage")

    @property
    @pulumi.getter(name="fileSystem")
    def file_system(self) -> Optional['outputs.FileSystemHttpLogsConfigResponse']:
        """
        Http logs to file system configuration.
        """
        return pulumi.get(self, "file_system")


@pulumi.output_type
class HttpScaleRuleResponse(dict):
    """
    Container App container Custom scaling rule.
    """
    def __init__(__self__, *,
                 auth: Optional[Sequence['outputs.ScaleRuleAuthResponse']] = None,
                 metadata: Optional[Mapping[str, str]] = None):
        """
        Container App container Custom scaling rule.
        :param Sequence['ScaleRuleAuthResponse'] auth: Authentication secrets for the custom scale rule.
        :param Mapping[str, str] metadata: Metadata properties to describe http scale rule.
        """
        if auth is not None:
            pulumi.set(__self__, "auth", auth)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)

    @property
    @pulumi.getter
    def auth(self) -> Optional[Sequence['outputs.ScaleRuleAuthResponse']]:
        """
        Authentication secrets for the custom scale rule.
        """
        return pulumi.get(self, "auth")

    @property
    @pulumi.getter
    def metadata(self) -> Optional[Mapping[str, str]]:
        """
        Metadata properties to describe http scale rule.
        """
        return pulumi.get(self, "metadata")


@pulumi.output_type
class IdentifierResponse(dict):
    """
    A domain specific resource identifier.
    """
    def __init__(__self__, *,
                 id: str,
                 name: str,
                 type: str,
                 kind: Optional[str] = None,
                 value: Optional[str] = None):
        """
        A domain specific resource identifier.
        :param str id: Resource Id.
        :param str name: Resource Name.
        :param str type: Resource type.
        :param str kind: Kind of resource.
        :param str value: String representation of the identity.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Resource Id.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Resource Name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Resource type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def kind(self) -> Optional[str]:
        """
        Kind of resource.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        String representation of the identity.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class IngressResponse(dict):
    """
    Container App Ingress configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowInsecure":
            suggest = "allow_insecure"
        elif key == "targetPort":
            suggest = "target_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IngressResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IngressResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IngressResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fqdn: str,
                 allow_insecure: Optional[bool] = None,
                 external: Optional[bool] = None,
                 target_port: Optional[int] = None,
                 traffic: Optional[Sequence['outputs.TrafficWeightResponse']] = None,
                 transport: Optional[str] = None):
        """
        Container App Ingress configuration.
        :param str fqdn: Hostname.
        :param bool allow_insecure: Bool indicating if HTTP connections to is allowed. If set to false HTTP connections are automatically redirected to HTTPS connections
        :param bool external: Bool indicating if app exposes an external http endpoint
        :param int target_port: Target Port in containers for traffic from ingress
        :param str transport: Ingress transport protocol
        """
        pulumi.set(__self__, "fqdn", fqdn)
        if allow_insecure is not None:
            pulumi.set(__self__, "allow_insecure", allow_insecure)
        if external is None:
            external = False
        if external is not None:
            pulumi.set(__self__, "external", external)
        if target_port is not None:
            pulumi.set(__self__, "target_port", target_port)
        if traffic is not None:
            pulumi.set(__self__, "traffic", traffic)
        if transport is not None:
            pulumi.set(__self__, "transport", transport)

    @property
    @pulumi.getter
    def fqdn(self) -> str:
        """
        Hostname.
        """
        return pulumi.get(self, "fqdn")

    @property
    @pulumi.getter(name="allowInsecure")
    def allow_insecure(self) -> Optional[bool]:
        """
        Bool indicating if HTTP connections to is allowed. If set to false HTTP connections are automatically redirected to HTTPS connections
        """
        return pulumi.get(self, "allow_insecure")

    @property
    @pulumi.getter
    def external(self) -> Optional[bool]:
        """
        Bool indicating if app exposes an external http endpoint
        """
        return pulumi.get(self, "external")

    @property
    @pulumi.getter(name="targetPort")
    def target_port(self) -> Optional[int]:
        """
        Target Port in containers for traffic from ingress
        """
        return pulumi.get(self, "target_port")

    @property
    @pulumi.getter
    def traffic(self) -> Optional[Sequence['outputs.TrafficWeightResponse']]:
        return pulumi.get(self, "traffic")

    @property
    @pulumi.getter
    def transport(self) -> Optional[str]:
        """
        Ingress transport protocol
        """
        return pulumi.get(self, "transport")


@pulumi.output_type
class IpSecurityRestrictionResponse(dict):
    """
    IP security restriction on an app.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipAddress":
            suggest = "ip_address"
        elif key == "subnetMask":
            suggest = "subnet_mask"
        elif key == "subnetTrafficTag":
            suggest = "subnet_traffic_tag"
        elif key == "vnetSubnetResourceId":
            suggest = "vnet_subnet_resource_id"
        elif key == "vnetTrafficTag":
            suggest = "vnet_traffic_tag"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IpSecurityRestrictionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IpSecurityRestrictionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IpSecurityRestrictionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: Optional[str] = None,
                 description: Optional[str] = None,
                 headers: Optional[Mapping[str, Sequence[str]]] = None,
                 ip_address: Optional[str] = None,
                 name: Optional[str] = None,
                 priority: Optional[int] = None,
                 subnet_mask: Optional[str] = None,
                 subnet_traffic_tag: Optional[int] = None,
                 tag: Optional[str] = None,
                 vnet_subnet_resource_id: Optional[str] = None,
                 vnet_traffic_tag: Optional[int] = None):
        """
        IP security restriction on an app.
        :param str action: Allow or Deny access for this IP range.
        :param str description: IP restriction rule description.
        :param Mapping[str, Sequence[str]] headers: IP restriction rule headers.
               X-Forwarded-Host (https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Forwarded-Host#Examples). 
               The matching logic is ..
               - If the property is null or empty (default), all hosts(or lack of) are allowed.
               - A value is compared using ordinal-ignore-case (excluding port number).
               - Subdomain wildcards are permitted but don't match the root domain. For example, *.contoso.com matches the subdomain foo.contoso.com
                but not the root domain contoso.com or multi-level foo.bar.contoso.com
               - Unicode host names are allowed but are converted to Punycode for matching.
               
               X-Forwarded-For (https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Forwarded-For#Examples).
               The matching logic is ..
               - If the property is null or empty (default), any forwarded-for chains (or lack of) are allowed.
               - If any address (excluding port number) in the chain (comma separated) matches the CIDR defined by the property.
               
               X-Azure-FDID and X-FD-HealthProbe.
               The matching logic is exact match.
        :param str ip_address: IP address the security restriction is valid for.
               It can be in form of pure ipv4 address (required SubnetMask property) or
               CIDR notation such as ipv4/mask (leading bit match). For CIDR,
               SubnetMask property must not be specified.
        :param str name: IP restriction rule name.
        :param int priority: Priority of IP restriction rule.
        :param str subnet_mask: Subnet mask for the range of IP addresses the restriction is valid for.
        :param int subnet_traffic_tag: (internal) Subnet traffic tag
        :param str tag: Defines what this IP filter will be used for. This is to support IP filtering on proxies.
        :param str vnet_subnet_resource_id: Virtual network resource id
        :param int vnet_traffic_tag: (internal) Vnet traffic tag
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if subnet_mask is not None:
            pulumi.set(__self__, "subnet_mask", subnet_mask)
        if subnet_traffic_tag is not None:
            pulumi.set(__self__, "subnet_traffic_tag", subnet_traffic_tag)
        if tag is not None:
            pulumi.set(__self__, "tag", tag)
        if vnet_subnet_resource_id is not None:
            pulumi.set(__self__, "vnet_subnet_resource_id", vnet_subnet_resource_id)
        if vnet_traffic_tag is not None:
            pulumi.set(__self__, "vnet_traffic_tag", vnet_traffic_tag)

    @property
    @pulumi.getter
    def action(self) -> Optional[str]:
        """
        Allow or Deny access for this IP range.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        IP restriction rule description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def headers(self) -> Optional[Mapping[str, Sequence[str]]]:
        """
        IP restriction rule headers.
        X-Forwarded-Host (https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Forwarded-Host#Examples). 
        The matching logic is ..
        - If the property is null or empty (default), all hosts(or lack of) are allowed.
        - A value is compared using ordinal-ignore-case (excluding port number).
        - Subdomain wildcards are permitted but don't match the root domain. For example, *.contoso.com matches the subdomain foo.contoso.com
         but not the root domain contoso.com or multi-level foo.bar.contoso.com
        - Unicode host names are allowed but are converted to Punycode for matching.

        X-Forwarded-For (https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Forwarded-For#Examples).
        The matching logic is ..
        - If the property is null or empty (default), any forwarded-for chains (or lack of) are allowed.
        - If any address (excluding port number) in the chain (comma separated) matches the CIDR defined by the property.

        X-Azure-FDID and X-FD-HealthProbe.
        The matching logic is exact match.
        """
        return pulumi.get(self, "headers")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[str]:
        """
        IP address the security restriction is valid for.
        It can be in form of pure ipv4 address (required SubnetMask property) or
        CIDR notation such as ipv4/mask (leading bit match). For CIDR,
        SubnetMask property must not be specified.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        IP restriction rule name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def priority(self) -> Optional[int]:
        """
        Priority of IP restriction rule.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter(name="subnetMask")
    def subnet_mask(self) -> Optional[str]:
        """
        Subnet mask for the range of IP addresses the restriction is valid for.
        """
        return pulumi.get(self, "subnet_mask")

    @property
    @pulumi.getter(name="subnetTrafficTag")
    def subnet_traffic_tag(self) -> Optional[int]:
        """
        (internal) Subnet traffic tag
        """
        return pulumi.get(self, "subnet_traffic_tag")

    @property
    @pulumi.getter
    def tag(self) -> Optional[str]:
        """
        Defines what this IP filter will be used for. This is to support IP filtering on proxies.
        """
        return pulumi.get(self, "tag")

    @property
    @pulumi.getter(name="vnetSubnetResourceId")
    def vnet_subnet_resource_id(self) -> Optional[str]:
        """
        Virtual network resource id
        """
        return pulumi.get(self, "vnet_subnet_resource_id")

    @property
    @pulumi.getter(name="vnetTrafficTag")
    def vnet_traffic_tag(self) -> Optional[int]:
        """
        (internal) Vnet traffic tag
        """
        return pulumi.get(self, "vnet_traffic_tag")


@pulumi.output_type
class KubeEnvironmentProfileResponse(dict):
    """
    Specification for a Kubernetes Environment to use for this resource.
    """
    def __init__(__self__, *,
                 name: str,
                 type: str,
                 id: Optional[str] = None):
        """
        Specification for a Kubernetes Environment to use for this resource.
        :param str name: Name of the Kubernetes Environment.
        :param str type: Resource type of the Kubernetes Environment.
        :param str id: Resource ID of the Kubernetes Environment.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the Kubernetes Environment.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Resource type of the Kubernetes Environment.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID of the Kubernetes Environment.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class LogAnalyticsConfigurationResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customerId":
            suggest = "customer_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LogAnalyticsConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LogAnalyticsConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LogAnalyticsConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 customer_id: Optional[str] = None):
        if customer_id is not None:
            pulumi.set(__self__, "customer_id", customer_id)

    @property
    @pulumi.getter(name="customerId")
    def customer_id(self) -> Optional[str]:
        return pulumi.get(self, "customer_id")


@pulumi.output_type
class ManagedServiceIdentityResponse(dict):
    """
    Managed service identity.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"
        elif key == "userAssignedIdentities":
            suggest = "user_assigned_identities"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedServiceIdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedServiceIdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedServiceIdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 principal_id: str,
                 tenant_id: str,
                 type: Optional[str] = None,
                 user_assigned_identities: Optional[Mapping[str, 'outputs.UserAssignedIdentityResponse']] = None):
        """
        Managed service identity.
        :param str principal_id: Principal Id of managed service identity.
        :param str tenant_id: Tenant of managed service identity.
        :param str type: Type of managed service identity.
        :param Mapping[str, 'UserAssignedIdentityResponse'] user_assigned_identities: The list of user assigned identities associated with the resource. The user identity dictionary key references will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}
        """
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_assigned_identities is not None:
            pulumi.set(__self__, "user_assigned_identities", user_assigned_identities)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        Principal Id of managed service identity.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        Tenant of managed service identity.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Type of managed service identity.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="userAssignedIdentities")
    def user_assigned_identities(self) -> Optional[Mapping[str, 'outputs.UserAssignedIdentityResponse']]:
        """
        The list of user assigned identities associated with the resource. The user identity dictionary key references will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}
        """
        return pulumi.get(self, "user_assigned_identities")


@pulumi.output_type
class NameValuePairResponse(dict):
    """
    Name value pair.
    """
    def __init__(__self__, *,
                 name: Optional[str] = None,
                 value: Optional[str] = None):
        """
        Name value pair.
        :param str name: Pair name.
        :param str value: Pair value.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Pair name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        Pair value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class PrivateLinkConnectionStateResponse(dict):
    """
    The state of a private link connection
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "actionsRequired":
            suggest = "actions_required"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateLinkConnectionStateResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateLinkConnectionStateResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateLinkConnectionStateResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 actions_required: Optional[str] = None,
                 description: Optional[str] = None,
                 status: Optional[str] = None):
        """
        The state of a private link connection
        :param str actions_required: ActionsRequired for a private link connection
        :param str description: Description of a private link connection
        :param str status: Status of a private link connection
        """
        if actions_required is not None:
            pulumi.set(__self__, "actions_required", actions_required)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="actionsRequired")
    def actions_required(self) -> Optional[str]:
        """
        ActionsRequired for a private link connection
        """
        return pulumi.get(self, "actions_required")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Description of a private link connection
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        Status of a private link connection
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class PushSettingsResponse(dict):
    """
    Push settings for the App.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isPushEnabled":
            suggest = "is_push_enabled"
        elif key == "dynamicTagsJson":
            suggest = "dynamic_tags_json"
        elif key == "tagWhitelistJson":
            suggest = "tag_whitelist_json"
        elif key == "tagsRequiringAuth":
            suggest = "tags_requiring_auth"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PushSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PushSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PushSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 is_push_enabled: bool,
                 name: str,
                 type: str,
                 dynamic_tags_json: Optional[str] = None,
                 kind: Optional[str] = None,
                 tag_whitelist_json: Optional[str] = None,
                 tags_requiring_auth: Optional[str] = None):
        """
        Push settings for the App.
        :param str id: Resource Id.
        :param bool is_push_enabled: Gets or sets a flag indicating whether the Push endpoint is enabled.
        :param str name: Resource Name.
        :param str type: Resource type.
        :param str dynamic_tags_json: Gets or sets a JSON string containing a list of dynamic tags that will be evaluated from user claims in the push registration endpoint.
        :param str kind: Kind of resource.
        :param str tag_whitelist_json: Gets or sets a JSON string containing a list of tags that are whitelisted for use by the push registration endpoint.
        :param str tags_requiring_auth: Gets or sets a JSON string containing a list of tags that require user authentication to be used in the push registration endpoint.
               Tags can consist of alphanumeric characters and the following:
               '_', '@', '#', '.', ':', '-'. 
               Validation should be performed at the PushRequestHandler.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_push_enabled", is_push_enabled)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        if dynamic_tags_json is not None:
            pulumi.set(__self__, "dynamic_tags_json", dynamic_tags_json)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if tag_whitelist_json is not None:
            pulumi.set(__self__, "tag_whitelist_json", tag_whitelist_json)
        if tags_requiring_auth is not None:
            pulumi.set(__self__, "tags_requiring_auth", tags_requiring_auth)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Resource Id.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isPushEnabled")
    def is_push_enabled(self) -> bool:
        """
        Gets or sets a flag indicating whether the Push endpoint is enabled.
        """
        return pulumi.get(self, "is_push_enabled")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Resource Name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Resource type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="dynamicTagsJson")
    def dynamic_tags_json(self) -> Optional[str]:
        """
        Gets or sets a JSON string containing a list of dynamic tags that will be evaluated from user claims in the push registration endpoint.
        """
        return pulumi.get(self, "dynamic_tags_json")

    @property
    @pulumi.getter
    def kind(self) -> Optional[str]:
        """
        Kind of resource.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="tagWhitelistJson")
    def tag_whitelist_json(self) -> Optional[str]:
        """
        Gets or sets a JSON string containing a list of tags that are whitelisted for use by the push registration endpoint.
        """
        return pulumi.get(self, "tag_whitelist_json")

    @property
    @pulumi.getter(name="tagsRequiringAuth")
    def tags_requiring_auth(self) -> Optional[str]:
        """
        Gets or sets a JSON string containing a list of tags that require user authentication to be used in the push registration endpoint.
        Tags can consist of alphanumeric characters and the following:
        '_', '@', '#', '.', ':', '-'. 
        Validation should be performed at the PushRequestHandler.
        """
        return pulumi.get(self, "tags_requiring_auth")


@pulumi.output_type
class QueueScaleRuleResponse(dict):
    """
    Container App container Azure Queue based scaling rule.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "queueLength":
            suggest = "queue_length"
        elif key == "queueName":
            suggest = "queue_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in QueueScaleRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        QueueScaleRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        QueueScaleRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auth: Optional[Sequence['outputs.ScaleRuleAuthResponse']] = None,
                 queue_length: Optional[int] = None,
                 queue_name: Optional[str] = None):
        """
        Container App container Azure Queue based scaling rule.
        :param Sequence['ScaleRuleAuthResponse'] auth: Authentication secrets for the queue scale rule.
        :param int queue_length: Queue length.
        :param str queue_name: Queue name.
        """
        if auth is not None:
            pulumi.set(__self__, "auth", auth)
        if queue_length is not None:
            pulumi.set(__self__, "queue_length", queue_length)
        if queue_name is not None:
            pulumi.set(__self__, "queue_name", queue_name)

    @property
    @pulumi.getter
    def auth(self) -> Optional[Sequence['outputs.ScaleRuleAuthResponse']]:
        """
        Authentication secrets for the queue scale rule.
        """
        return pulumi.get(self, "auth")

    @property
    @pulumi.getter(name="queueLength")
    def queue_length(self) -> Optional[int]:
        """
        Queue length.
        """
        return pulumi.get(self, "queue_length")

    @property
    @pulumi.getter(name="queueName")
    def queue_name(self) -> Optional[str]:
        """
        Queue name.
        """
        return pulumi.get(self, "queue_name")


@pulumi.output_type
class RampUpRuleResponse(dict):
    """
    Routing rules for ramp up testing. This rule allows to redirect static traffic % to a slot or to gradually change routing % based on performance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "actionHostName":
            suggest = "action_host_name"
        elif key == "changeDecisionCallbackUrl":
            suggest = "change_decision_callback_url"
        elif key == "changeIntervalInMinutes":
            suggest = "change_interval_in_minutes"
        elif key == "changeStep":
            suggest = "change_step"
        elif key == "maxReroutePercentage":
            suggest = "max_reroute_percentage"
        elif key == "minReroutePercentage":
            suggest = "min_reroute_percentage"
        elif key == "reroutePercentage":
            suggest = "reroute_percentage"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RampUpRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RampUpRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RampUpRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action_host_name: Optional[str] = None,
                 change_decision_callback_url: Optional[str] = None,
                 change_interval_in_minutes: Optional[int] = None,
                 change_step: Optional[float] = None,
                 max_reroute_percentage: Optional[float] = None,
                 min_reroute_percentage: Optional[float] = None,
                 name: Optional[str] = None,
                 reroute_percentage: Optional[float] = None):
        """
        Routing rules for ramp up testing. This rule allows to redirect static traffic % to a slot or to gradually change routing % based on performance.
        :param str action_host_name: Hostname of a slot to which the traffic will be redirected if decided to. E.g. myapp-stage.azurewebsites.net.
        :param str change_decision_callback_url: Custom decision algorithm can be provided in TiPCallback site extension which URL can be specified. See TiPCallback site extension for the scaffold and contracts.
               https://www.siteextensions.net/packages/TiPCallback/
        :param int change_interval_in_minutes: Specifies interval in minutes to reevaluate ReroutePercentage.
        :param float change_step: In auto ramp up scenario this is the step to add/remove from <code>ReroutePercentage</code> until it reaches \\n<code>MinReroutePercentage</code> or 
               <code>MaxReroutePercentage</code>. Site metrics are checked every N minutes specified in <code>ChangeIntervalInMinutes</code>.\\nCustom decision algorithm 
               can be provided in TiPCallback site extension which URL can be specified in <code>ChangeDecisionCallbackUrl</code>.
        :param float max_reroute_percentage: Specifies upper boundary below which ReroutePercentage will stay.
        :param float min_reroute_percentage: Specifies lower boundary above which ReroutePercentage will stay.
        :param str name: Name of the routing rule. The recommended name would be to point to the slot which will receive the traffic in the experiment.
        :param float reroute_percentage: Percentage of the traffic which will be redirected to <code>ActionHostName</code>.
        """
        if action_host_name is not None:
            pulumi.set(__self__, "action_host_name", action_host_name)
        if change_decision_callback_url is not None:
            pulumi.set(__self__, "change_decision_callback_url", change_decision_callback_url)
        if change_interval_in_minutes is not None:
            pulumi.set(__self__, "change_interval_in_minutes", change_interval_in_minutes)
        if change_step is not None:
            pulumi.set(__self__, "change_step", change_step)
        if max_reroute_percentage is not None:
            pulumi.set(__self__, "max_reroute_percentage", max_reroute_percentage)
        if min_reroute_percentage is not None:
            pulumi.set(__self__, "min_reroute_percentage", min_reroute_percentage)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if reroute_percentage is not None:
            pulumi.set(__self__, "reroute_percentage", reroute_percentage)

    @property
    @pulumi.getter(name="actionHostName")
    def action_host_name(self) -> Optional[str]:
        """
        Hostname of a slot to which the traffic will be redirected if decided to. E.g. myapp-stage.azurewebsites.net.
        """
        return pulumi.get(self, "action_host_name")

    @property
    @pulumi.getter(name="changeDecisionCallbackUrl")
    def change_decision_callback_url(self) -> Optional[str]:
        """
        Custom decision algorithm can be provided in TiPCallback site extension which URL can be specified. See TiPCallback site extension for the scaffold and contracts.
        https://www.siteextensions.net/packages/TiPCallback/
        """
        return pulumi.get(self, "change_decision_callback_url")

    @property
    @pulumi.getter(name="changeIntervalInMinutes")
    def change_interval_in_minutes(self) -> Optional[int]:
        """
        Specifies interval in minutes to reevaluate ReroutePercentage.
        """
        return pulumi.get(self, "change_interval_in_minutes")

    @property
    @pulumi.getter(name="changeStep")
    def change_step(self) -> Optional[float]:
        """
        In auto ramp up scenario this is the step to add/remove from <code>ReroutePercentage</code> until it reaches \\n<code>MinReroutePercentage</code> or 
        <code>MaxReroutePercentage</code>. Site metrics are checked every N minutes specified in <code>ChangeIntervalInMinutes</code>.\\nCustom decision algorithm 
        can be provided in TiPCallback site extension which URL can be specified in <code>ChangeDecisionCallbackUrl</code>.
        """
        return pulumi.get(self, "change_step")

    @property
    @pulumi.getter(name="maxReroutePercentage")
    def max_reroute_percentage(self) -> Optional[float]:
        """
        Specifies upper boundary below which ReroutePercentage will stay.
        """
        return pulumi.get(self, "max_reroute_percentage")

    @property
    @pulumi.getter(name="minReroutePercentage")
    def min_reroute_percentage(self) -> Optional[float]:
        """
        Specifies lower boundary above which ReroutePercentage will stay.
        """
        return pulumi.get(self, "min_reroute_percentage")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the routing rule. The recommended name would be to point to the slot which will receive the traffic in the experiment.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="reroutePercentage")
    def reroute_percentage(self) -> Optional[float]:
        """
        Percentage of the traffic which will be redirected to <code>ActionHostName</code>.
        """
        return pulumi.get(self, "reroute_percentage")


@pulumi.output_type
class RegistryCredentialsResponse(dict):
    """
    Container App Private Registry
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "passwordSecretRef":
            suggest = "password_secret_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RegistryCredentialsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RegistryCredentialsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RegistryCredentialsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 password_secret_ref: Optional[str] = None,
                 server: Optional[str] = None,
                 username: Optional[str] = None):
        """
        Container App Private Registry
        :param str password_secret_ref: The name of the Secret that contains the registry login password
        :param str server: Container Registry Server
        :param str username: Container Registry Username
        """
        if password_secret_ref is not None:
            pulumi.set(__self__, "password_secret_ref", password_secret_ref)
        if server is not None:
            pulumi.set(__self__, "server", server)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="passwordSecretRef")
    def password_secret_ref(self) -> Optional[str]:
        """
        The name of the Secret that contains the registry login password
        """
        return pulumi.get(self, "password_secret_ref")

    @property
    @pulumi.getter
    def server(self) -> Optional[str]:
        """
        Container Registry Server
        """
        return pulumi.get(self, "server")

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        """
        Container Registry Username
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class RemotePrivateEndpointConnectionResponse(dict):
    """
    A remote private endpoint connection
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "ipAddresses":
            suggest = "ip_addresses"
        elif key == "privateEndpoint":
            suggest = "private_endpoint"
        elif key == "privateLinkServiceConnectionState":
            suggest = "private_link_service_connection_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RemotePrivateEndpointConnectionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RemotePrivateEndpointConnectionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RemotePrivateEndpointConnectionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 name: str,
                 provisioning_state: str,
                 type: str,
                 ip_addresses: Optional[Sequence[str]] = None,
                 kind: Optional[str] = None,
                 private_endpoint: Optional['outputs.ArmIdWrapperResponse'] = None,
                 private_link_service_connection_state: Optional['outputs.PrivateLinkConnectionStateResponse'] = None):
        """
        A remote private endpoint connection
        :param str id: Resource Id.
        :param str name: Resource Name.
        :param str type: Resource type.
        :param Sequence[str] ip_addresses: Private IPAddresses mapped to the remote private endpoint
        :param str kind: Kind of resource.
        :param 'ArmIdWrapperResponse' private_endpoint: PrivateEndpoint of a remote private endpoint connection
        :param 'PrivateLinkConnectionStateResponse' private_link_service_connection_state: The state of a private link connection
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "type", type)
        if ip_addresses is not None:
            pulumi.set(__self__, "ip_addresses", ip_addresses)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if private_endpoint is not None:
            pulumi.set(__self__, "private_endpoint", private_endpoint)
        if private_link_service_connection_state is not None:
            pulumi.set(__self__, "private_link_service_connection_state", private_link_service_connection_state)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Resource Id.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Resource Name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Resource type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Optional[Sequence[str]]:
        """
        Private IPAddresses mapped to the remote private endpoint
        """
        return pulumi.get(self, "ip_addresses")

    @property
    @pulumi.getter
    def kind(self) -> Optional[str]:
        """
        Kind of resource.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="privateEndpoint")
    def private_endpoint(self) -> Optional['outputs.ArmIdWrapperResponse']:
        """
        PrivateEndpoint of a remote private endpoint connection
        """
        return pulumi.get(self, "private_endpoint")

    @property
    @pulumi.getter(name="privateLinkServiceConnectionState")
    def private_link_service_connection_state(self) -> Optional['outputs.PrivateLinkConnectionStateResponse']:
        """
        The state of a private link connection
        """
        return pulumi.get(self, "private_link_service_connection_state")


@pulumi.output_type
class RequestsBasedTriggerResponse(dict):
    """
    Trigger based on total requests.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "timeInterval":
            suggest = "time_interval"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RequestsBasedTriggerResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RequestsBasedTriggerResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RequestsBasedTriggerResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 count: Optional[int] = None,
                 time_interval: Optional[str] = None):
        """
        Trigger based on total requests.
        :param int count: Request Count.
        :param str time_interval: Time interval.
        """
        if count is not None:
            pulumi.set(__self__, "count", count)
        if time_interval is not None:
            pulumi.set(__self__, "time_interval", time_interval)

    @property
    @pulumi.getter
    def count(self) -> Optional[int]:
        """
        Request Count.
        """
        return pulumi.get(self, "count")

    @property
    @pulumi.getter(name="timeInterval")
    def time_interval(self) -> Optional[str]:
        """
        Time interval.
        """
        return pulumi.get(self, "time_interval")


@pulumi.output_type
class ResponseMessageEnvelopeRemotePrivateEndpointConnectionResponse(dict):
    """
    Message envelope that contains the common Azure resource manager properties and the resource provider specific content.
    """
    def __init__(__self__, *,
                 error: Optional['outputs.ErrorEntityResponse'] = None,
                 id: Optional[str] = None,
                 identity: Optional['outputs.ManagedServiceIdentityResponse'] = None,
                 location: Optional[str] = None,
                 name: Optional[str] = None,
                 plan: Optional['outputs.ArmPlanResponse'] = None,
                 properties: Optional['outputs.RemotePrivateEndpointConnectionResponse'] = None,
                 sku: Optional['outputs.SkuDescriptionResponse'] = None,
                 status: Optional[str] = None,
                 tags: Optional[Mapping[str, str]] = None,
                 type: Optional[str] = None,
                 zones: Optional[Sequence[str]] = None):
        """
        Message envelope that contains the common Azure resource manager properties and the resource provider specific content.
        :param 'ErrorEntityResponse' error: Azure-AsyncOperation Error info.
        :param str id: Resource Id. Typically ID is populated only for responses to GET requests. Caller is responsible for passing in this
               value for GET requests only.
               For example: /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupId}/providers/Microsoft.Web/sites/{sitename}
        :param 'ManagedServiceIdentityResponse' identity: MSI resource
        :param str location: Geographical region resource belongs to e.g. SouthCentralUS, SouthEastAsia.
        :param str name: Name of resource.
        :param 'ArmPlanResponse' plan: Azure resource manager plan.
        :param 'RemotePrivateEndpointConnectionResponse' properties: Resource specific properties.
        :param 'SkuDescriptionResponse' sku: SKU description of the resource.
        :param str status: Azure-AsyncOperation Status info.
        :param Mapping[str, str] tags: Tags associated with resource.
        :param str type: Type of resource e.g "Microsoft.Web/sites".
        :param Sequence[str] zones: Logical Availability Zones the service is hosted in
        """
        if error is not None:
            pulumi.set(__self__, "error", error)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if plan is not None:
            pulumi.set(__self__, "plan", plan)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if zones is not None:
            pulumi.set(__self__, "zones", zones)

    @property
    @pulumi.getter
    def error(self) -> Optional['outputs.ErrorEntityResponse']:
        """
        Azure-AsyncOperation Error info.
        """
        return pulumi.get(self, "error")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource Id. Typically ID is populated only for responses to GET requests. Caller is responsible for passing in this
        value for GET requests only.
        For example: /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupId}/providers/Microsoft.Web/sites/{sitename}
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def identity(self) -> Optional['outputs.ManagedServiceIdentityResponse']:
        """
        MSI resource
        """
        return pulumi.get(self, "identity")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        Geographical region resource belongs to e.g. SouthCentralUS, SouthEastAsia.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def plan(self) -> Optional['outputs.ArmPlanResponse']:
        """
        Azure resource manager plan.
        """
        return pulumi.get(self, "plan")

    @property
    @pulumi.getter
    def properties(self) -> Optional['outputs.RemotePrivateEndpointConnectionResponse']:
        """
        Resource specific properties.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter
    def sku(self) -> Optional['outputs.SkuDescriptionResponse']:
        """
        SKU description of the resource.
        """
        return pulumi.get(self, "sku")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        Azure-AsyncOperation Status info.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Tags associated with resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Type of resource e.g "Microsoft.Web/sites".
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def zones(self) -> Optional[Sequence[str]]:
        """
        Logical Availability Zones the service is hosted in
        """
        return pulumi.get(self, "zones")


@pulumi.output_type
class ScaleResponse(dict):
    """
    Container App scaling configurations.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxReplicas":
            suggest = "max_replicas"
        elif key == "minReplicas":
            suggest = "min_replicas"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScaleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScaleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScaleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_replicas: Optional[int] = None,
                 min_replicas: Optional[int] = None,
                 rules: Optional[Sequence['outputs.ScaleRuleResponse']] = None):
        """
        Container App scaling configurations.
        :param int max_replicas: Optional. Maximum number of container replicas. Defaults to 10 if not set.
        :param int min_replicas: Optional. Minimum number of container replicas.
        :param Sequence['ScaleRuleResponse'] rules: Scaling rules.
        """
        if max_replicas is not None:
            pulumi.set(__self__, "max_replicas", max_replicas)
        if min_replicas is not None:
            pulumi.set(__self__, "min_replicas", min_replicas)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter(name="maxReplicas")
    def max_replicas(self) -> Optional[int]:
        """
        Optional. Maximum number of container replicas. Defaults to 10 if not set.
        """
        return pulumi.get(self, "max_replicas")

    @property
    @pulumi.getter(name="minReplicas")
    def min_replicas(self) -> Optional[int]:
        """
        Optional. Minimum number of container replicas.
        """
        return pulumi.get(self, "min_replicas")

    @property
    @pulumi.getter
    def rules(self) -> Optional[Sequence['outputs.ScaleRuleResponse']]:
        """
        Scaling rules.
        """
        return pulumi.get(self, "rules")


@pulumi.output_type
class ScaleRuleAuthResponse(dict):
    """
    Auth Secrets for Container App Scale Rule
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretRef":
            suggest = "secret_ref"
        elif key == "triggerParameter":
            suggest = "trigger_parameter"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScaleRuleAuthResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScaleRuleAuthResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScaleRuleAuthResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 secret_ref: Optional[str] = None,
                 trigger_parameter: Optional[str] = None):
        """
        Auth Secrets for Container App Scale Rule
        :param str secret_ref: Name of the Container App secret from which to pull the auth params.
        :param str trigger_parameter: Trigger Parameter that uses the secret
        """
        if secret_ref is not None:
            pulumi.set(__self__, "secret_ref", secret_ref)
        if trigger_parameter is not None:
            pulumi.set(__self__, "trigger_parameter", trigger_parameter)

    @property
    @pulumi.getter(name="secretRef")
    def secret_ref(self) -> Optional[str]:
        """
        Name of the Container App secret from which to pull the auth params.
        """
        return pulumi.get(self, "secret_ref")

    @property
    @pulumi.getter(name="triggerParameter")
    def trigger_parameter(self) -> Optional[str]:
        """
        Trigger Parameter that uses the secret
        """
        return pulumi.get(self, "trigger_parameter")


@pulumi.output_type
class ScaleRuleResponse(dict):
    """
    Container App container scaling rule.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "azureQueue":
            suggest = "azure_queue"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScaleRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScaleRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScaleRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 azure_queue: Optional['outputs.QueueScaleRuleResponse'] = None,
                 custom: Optional['outputs.CustomScaleRuleResponse'] = None,
                 http: Optional['outputs.HttpScaleRuleResponse'] = None,
                 name: Optional[str] = None):
        """
        Container App container scaling rule.
        :param 'QueueScaleRuleResponse' azure_queue: Azure Queue based scaling.
        :param 'CustomScaleRuleResponse' custom: Custom scale rule.
        :param 'HttpScaleRuleResponse' http: HTTP requests based scaling.
        :param str name: Scale Rule Name
        """
        if azure_queue is not None:
            pulumi.set(__self__, "azure_queue", azure_queue)
        if custom is not None:
            pulumi.set(__self__, "custom", custom)
        if http is not None:
            pulumi.set(__self__, "http", http)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="azureQueue")
    def azure_queue(self) -> Optional['outputs.QueueScaleRuleResponse']:
        """
        Azure Queue based scaling.
        """
        return pulumi.get(self, "azure_queue")

    @property
    @pulumi.getter
    def custom(self) -> Optional['outputs.CustomScaleRuleResponse']:
        """
        Custom scale rule.
        """
        return pulumi.get(self, "custom")

    @property
    @pulumi.getter
    def http(self) -> Optional['outputs.HttpScaleRuleResponse']:
        """
        HTTP requests based scaling.
        """
        return pulumi.get(self, "http")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Scale Rule Name
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class SecretResponse(dict):
    """
    Container App Secret.
    """
    def __init__(__self__, *,
                 name: Optional[str] = None):
        """
        Container App Secret.
        :param str name: Secret Name.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Secret Name.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class SiteConfigResponse(dict):
    """
    Configuration of an App Service app.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "machineKey":
            suggest = "machine_key"
        elif key == "acrUseManagedIdentityCreds":
            suggest = "acr_use_managed_identity_creds"
        elif key == "acrUserManagedIdentityID":
            suggest = "acr_user_managed_identity_id"
        elif key == "alwaysOn":
            suggest = "always_on"
        elif key == "apiDefinition":
            suggest = "api_definition"
        elif key == "apiManagementConfig":
            suggest = "api_management_config"
        elif key == "appCommandLine":
            suggest = "app_command_line"
        elif key == "appSettings":
            suggest = "app_settings"
        elif key == "autoHealEnabled":
            suggest = "auto_heal_enabled"
        elif key == "autoHealRules":
            suggest = "auto_heal_rules"
        elif key == "autoSwapSlotName":
            suggest = "auto_swap_slot_name"
        elif key == "azureStorageAccounts":
            suggest = "azure_storage_accounts"
        elif key == "connectionStrings":
            suggest = "connection_strings"
        elif key == "defaultDocuments":
            suggest = "default_documents"
        elif key == "detailedErrorLoggingEnabled":
            suggest = "detailed_error_logging_enabled"
        elif key == "documentRoot":
            suggest = "document_root"
        elif key == "elasticWebAppScaleLimit":
            suggest = "elastic_web_app_scale_limit"
        elif key == "ftpsState":
            suggest = "ftps_state"
        elif key == "functionAppScaleLimit":
            suggest = "function_app_scale_limit"
        elif key == "functionsRuntimeScaleMonitoringEnabled":
            suggest = "functions_runtime_scale_monitoring_enabled"
        elif key == "handlerMappings":
            suggest = "handler_mappings"
        elif key == "healthCheckPath":
            suggest = "health_check_path"
        elif key == "http20Enabled":
            suggest = "http20_enabled"
        elif key == "httpLoggingEnabled":
            suggest = "http_logging_enabled"
        elif key == "ipSecurityRestrictions":
            suggest = "ip_security_restrictions"
        elif key == "ipSecurityRestrictionsDefaultAction":
            suggest = "ip_security_restrictions_default_action"
        elif key == "javaContainer":
            suggest = "java_container"
        elif key == "javaContainerVersion":
            suggest = "java_container_version"
        elif key == "javaVersion":
            suggest = "java_version"
        elif key == "keyVaultReferenceIdentity":
            suggest = "key_vault_reference_identity"
        elif key == "linuxFxVersion":
            suggest = "linux_fx_version"
        elif key == "loadBalancing":
            suggest = "load_balancing"
        elif key == "localMySqlEnabled":
            suggest = "local_my_sql_enabled"
        elif key == "logsDirectorySizeLimit":
            suggest = "logs_directory_size_limit"
        elif key == "managedPipelineMode":
            suggest = "managed_pipeline_mode"
        elif key == "managedServiceIdentityId":
            suggest = "managed_service_identity_id"
        elif key == "minTlsVersion":
            suggest = "min_tls_version"
        elif key == "minimumElasticInstanceCount":
            suggest = "minimum_elastic_instance_count"
        elif key == "netFrameworkVersion":
            suggest = "net_framework_version"
        elif key == "nodeVersion":
            suggest = "node_version"
        elif key == "numberOfWorkers":
            suggest = "number_of_workers"
        elif key == "phpVersion":
            suggest = "php_version"
        elif key == "powerShellVersion":
            suggest = "power_shell_version"
        elif key == "preWarmedInstanceCount":
            suggest = "pre_warmed_instance_count"
        elif key == "publicNetworkAccess":
            suggest = "public_network_access"
        elif key == "publishingUsername":
            suggest = "publishing_username"
        elif key == "pythonVersion":
            suggest = "python_version"
        elif key == "remoteDebuggingEnabled":
            suggest = "remote_debugging_enabled"
        elif key == "remoteDebuggingVersion":
            suggest = "remote_debugging_version"
        elif key == "requestTracingEnabled":
            suggest = "request_tracing_enabled"
        elif key == "requestTracingExpirationTime":
            suggest = "request_tracing_expiration_time"
        elif key == "scmIpSecurityRestrictions":
            suggest = "scm_ip_security_restrictions"
        elif key == "scmIpSecurityRestrictionsDefaultAction":
            suggest = "scm_ip_security_restrictions_default_action"
        elif key == "scmIpSecurityRestrictionsUseMain":
            suggest = "scm_ip_security_restrictions_use_main"
        elif key == "scmMinTlsVersion":
            suggest = "scm_min_tls_version"
        elif key == "scmType":
            suggest = "scm_type"
        elif key == "tracingOptions":
            suggest = "tracing_options"
        elif key == "use32BitWorkerProcess":
            suggest = "use32_bit_worker_process"
        elif key == "virtualApplications":
            suggest = "virtual_applications"
        elif key == "vnetName":
            suggest = "vnet_name"
        elif key == "vnetPrivatePortsCount":
            suggest = "vnet_private_ports_count"
        elif key == "vnetRouteAllEnabled":
            suggest = "vnet_route_all_enabled"
        elif key == "webSocketsEnabled":
            suggest = "web_sockets_enabled"
        elif key == "websiteTimeZone":
            suggest = "website_time_zone"
        elif key == "windowsFxVersion":
            suggest = "windows_fx_version"
        elif key == "xManagedServiceIdentityId":
            suggest = "x_managed_service_identity_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SiteConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SiteConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SiteConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 machine_key: 'outputs.SiteMachineKeyResponse',
                 acr_use_managed_identity_creds: Optional[bool] = None,
                 acr_user_managed_identity_id: Optional[str] = None,
                 always_on: Optional[bool] = None,
                 api_definition: Optional['outputs.ApiDefinitionInfoResponse'] = None,
                 api_management_config: Optional['outputs.ApiManagementConfigResponse'] = None,
                 app_command_line: Optional[str] = None,
                 app_settings: Optional[Sequence['outputs.NameValuePairResponse']] = None,
                 auto_heal_enabled: Optional[bool] = None,
                 auto_heal_rules: Optional['outputs.AutoHealRulesResponse'] = None,
                 auto_swap_slot_name: Optional[str] = None,
                 azure_storage_accounts: Optional[Mapping[str, 'outputs.AzureStorageInfoValueResponse']] = None,
                 connection_strings: Optional[Sequence['outputs.ConnStringInfoResponse']] = None,
                 cors: Optional['outputs.CorsSettingsResponse'] = None,
                 default_documents: Optional[Sequence[str]] = None,
                 detailed_error_logging_enabled: Optional[bool] = None,
                 document_root: Optional[str] = None,
                 elastic_web_app_scale_limit: Optional[int] = None,
                 experiments: Optional['outputs.ExperimentsResponse'] = None,
                 ftps_state: Optional[str] = None,
                 function_app_scale_limit: Optional[int] = None,
                 functions_runtime_scale_monitoring_enabled: Optional[bool] = None,
                 handler_mappings: Optional[Sequence['outputs.HandlerMappingResponse']] = None,
                 health_check_path: Optional[str] = None,
                 http20_enabled: Optional[bool] = None,
                 http_logging_enabled: Optional[bool] = None,
                 ip_security_restrictions: Optional[Sequence['outputs.IpSecurityRestrictionResponse']] = None,
                 ip_security_restrictions_default_action: Optional[str] = None,
                 java_container: Optional[str] = None,
                 java_container_version: Optional[str] = None,
                 java_version: Optional[str] = None,
                 key_vault_reference_identity: Optional[str] = None,
                 limits: Optional['outputs.SiteLimitsResponse'] = None,
                 linux_fx_version: Optional[str] = None,
                 load_balancing: Optional[str] = None,
                 local_my_sql_enabled: Optional[bool] = None,
                 logs_directory_size_limit: Optional[int] = None,
                 managed_pipeline_mode: Optional[str] = None,
                 managed_service_identity_id: Optional[int] = None,
                 min_tls_version: Optional[str] = None,
                 minimum_elastic_instance_count: Optional[int] = None,
                 net_framework_version: Optional[str] = None,
                 node_version: Optional[str] = None,
                 number_of_workers: Optional[int] = None,
                 php_version: Optional[str] = None,
                 power_shell_version: Optional[str] = None,
                 pre_warmed_instance_count: Optional[int] = None,
                 public_network_access: Optional[str] = None,
                 publishing_username: Optional[str] = None,
                 push: Optional['outputs.PushSettingsResponse'] = None,
                 python_version: Optional[str] = None,
                 remote_debugging_enabled: Optional[bool] = None,
                 remote_debugging_version: Optional[str] = None,
                 request_tracing_enabled: Optional[bool] = None,
                 request_tracing_expiration_time: Optional[str] = None,
                 scm_ip_security_restrictions: Optional[Sequence['outputs.IpSecurityRestrictionResponse']] = None,
                 scm_ip_security_restrictions_default_action: Optional[str] = None,
                 scm_ip_security_restrictions_use_main: Optional[bool] = None,
                 scm_min_tls_version: Optional[str] = None,
                 scm_type: Optional[str] = None,
                 tracing_options: Optional[str] = None,
                 use32_bit_worker_process: Optional[bool] = None,
                 virtual_applications: Optional[Sequence['outputs.VirtualApplicationResponse']] = None,
                 vnet_name: Optional[str] = None,
                 vnet_private_ports_count: Optional[int] = None,
                 vnet_route_all_enabled: Optional[bool] = None,
                 web_sockets_enabled: Optional[bool] = None,
                 website_time_zone: Optional[str] = None,
                 windows_fx_version: Optional[str] = None,
                 x_managed_service_identity_id: Optional[int] = None):
        """
        Configuration of an App Service app.
        :param 'SiteMachineKeyResponse' machine_key: Site MachineKey.
        :param bool acr_use_managed_identity_creds: Flag to use Managed Identity Creds for ACR pull
        :param str acr_user_managed_identity_id: If using user managed identity, the user managed identity ClientId
        :param bool always_on: <code>true</code> if Always On is enabled; otherwise, <code>false</code>.
        :param 'ApiDefinitionInfoResponse' api_definition: Information about the formal API definition for the app.
        :param 'ApiManagementConfigResponse' api_management_config: Azure API management settings linked to the app.
        :param str app_command_line: App command line to launch.
        :param Sequence['NameValuePairResponse'] app_settings: Application settings.
        :param bool auto_heal_enabled: <code>true</code> if Auto Heal is enabled; otherwise, <code>false</code>.
        :param 'AutoHealRulesResponse' auto_heal_rules: Auto Heal rules.
        :param str auto_swap_slot_name: Auto-swap slot name.
        :param Mapping[str, 'AzureStorageInfoValueResponse'] azure_storage_accounts: List of Azure Storage Accounts.
        :param Sequence['ConnStringInfoResponse'] connection_strings: Connection strings.
        :param 'CorsSettingsResponse' cors: Cross-Origin Resource Sharing (CORS) settings.
        :param Sequence[str] default_documents: Default documents.
        :param bool detailed_error_logging_enabled: <code>true</code> if detailed error logging is enabled; otherwise, <code>false</code>.
        :param str document_root: Document root.
        :param int elastic_web_app_scale_limit: Maximum number of workers that a site can scale out to.
               This setting only applies to apps in plans where ElasticScaleEnabled is <code>true</code>
        :param 'ExperimentsResponse' experiments: This is work around for polymorphic types.
        :param str ftps_state: State of FTP / FTPS service
        :param int function_app_scale_limit: Maximum number of workers that a site can scale out to.
               This setting only applies to the Consumption and Elastic Premium Plans
        :param bool functions_runtime_scale_monitoring_enabled: Gets or sets a value indicating whether functions runtime scale monitoring is enabled. When enabled,
               the ScaleController will not monitor event sources directly, but will instead call to the
               runtime to get scale status.
        :param Sequence['HandlerMappingResponse'] handler_mappings: Handler mappings.
        :param str health_check_path: Health check path
        :param bool http20_enabled: Http20Enabled: configures a web site to allow clients to connect over http2.0
        :param bool http_logging_enabled: <code>true</code> if HTTP logging is enabled; otherwise, <code>false</code>.
        :param Sequence['IpSecurityRestrictionResponse'] ip_security_restrictions: IP security restrictions for main.
        :param str ip_security_restrictions_default_action: Default action for main access restriction if no rules are matched.
        :param str java_container: Java container.
        :param str java_container_version: Java container version.
        :param str java_version: Java version.
        :param str key_vault_reference_identity: Identity to use for Key Vault Reference authentication.
        :param 'SiteLimitsResponse' limits: Site limits.
        :param str linux_fx_version: Linux App Framework and version
        :param str load_balancing: Site load balancing.
        :param bool local_my_sql_enabled: <code>true</code> to enable local MySQL; otherwise, <code>false</code>.
        :param int logs_directory_size_limit: HTTP logs directory size limit.
        :param str managed_pipeline_mode: Managed pipeline mode.
        :param int managed_service_identity_id: Managed Service Identity Id
        :param str min_tls_version: MinTlsVersion: configures the minimum version of TLS required for SSL requests
        :param int minimum_elastic_instance_count: Number of minimum instance count for a site
               This setting only applies to the Elastic Plans
        :param str net_framework_version: .NET Framework version.
        :param str node_version: Version of Node.js.
        :param int number_of_workers: Number of workers.
        :param str php_version: Version of PHP.
        :param str power_shell_version: Version of PowerShell.
        :param int pre_warmed_instance_count: Number of preWarmed instances.
               This setting only applies to the Consumption and Elastic Plans
        :param str public_network_access: Property to allow or block all public traffic.
        :param str publishing_username: Publishing user name.
        :param 'PushSettingsResponse' push: Push endpoint settings.
        :param str python_version: Version of Python.
        :param bool remote_debugging_enabled: <code>true</code> if remote debugging is enabled; otherwise, <code>false</code>.
        :param str remote_debugging_version: Remote debugging version.
        :param bool request_tracing_enabled: <code>true</code> if request tracing is enabled; otherwise, <code>false</code>.
        :param str request_tracing_expiration_time: Request tracing expiration time.
        :param Sequence['IpSecurityRestrictionResponse'] scm_ip_security_restrictions: IP security restrictions for scm.
        :param str scm_ip_security_restrictions_default_action: Default action for scm access restriction if no rules are matched.
        :param bool scm_ip_security_restrictions_use_main: IP security restrictions for scm to use main.
        :param str scm_min_tls_version: ScmMinTlsVersion: configures the minimum version of TLS required for SSL requests for SCM site
        :param str scm_type: SCM type.
        :param str tracing_options: Tracing options.
        :param bool use32_bit_worker_process: <code>true</code> to use 32-bit worker process; otherwise, <code>false</code>.
        :param Sequence['VirtualApplicationResponse'] virtual_applications: Virtual applications.
        :param str vnet_name: Virtual Network name.
        :param int vnet_private_ports_count: The number of private ports assigned to this app. These will be assigned dynamically on runtime.
        :param bool vnet_route_all_enabled: Virtual Network Route All enabled. This causes all outbound traffic to have Virtual Network Security Groups and User Defined Routes applied.
        :param bool web_sockets_enabled: <code>true</code> if WebSocket is enabled; otherwise, <code>false</code>.
        :param str website_time_zone: Sets the time zone a site uses for generating timestamps. Compatible with Linux and Windows App Service. Setting the WEBSITE_TIME_ZONE app setting takes precedence over this config. For Linux, expects tz database values https://www.iana.org/time-zones (for a quick reference see https://en.wikipedia.org/wiki/List_of_tz_database_time_zones). For Windows, expects one of the time zones listed under HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion\\Time Zones
        :param str windows_fx_version: Xenon App Framework and version
        :param int x_managed_service_identity_id: Explicit Managed Service Identity Id
        """
        pulumi.set(__self__, "machine_key", machine_key)
        if acr_use_managed_identity_creds is not None:
            pulumi.set(__self__, "acr_use_managed_identity_creds", acr_use_managed_identity_creds)
        if acr_user_managed_identity_id is not None:
            pulumi.set(__self__, "acr_user_managed_identity_id", acr_user_managed_identity_id)
        if always_on is not None:
            pulumi.set(__self__, "always_on", always_on)
        if api_definition is not None:
            pulumi.set(__self__, "api_definition", api_definition)
        if api_management_config is not None:
            pulumi.set(__self__, "api_management_config", api_management_config)
        if app_command_line is not None:
            pulumi.set(__self__, "app_command_line", app_command_line)
        if app_settings is not None:
            pulumi.set(__self__, "app_settings", app_settings)
        if auto_heal_enabled is not None:
            pulumi.set(__self__, "auto_heal_enabled", auto_heal_enabled)
        if auto_heal_rules is not None:
            pulumi.set(__self__, "auto_heal_rules", auto_heal_rules)
        if auto_swap_slot_name is not None:
            pulumi.set(__self__, "auto_swap_slot_name", auto_swap_slot_name)
        if azure_storage_accounts is not None:
            pulumi.set(__self__, "azure_storage_accounts", azure_storage_accounts)
        if connection_strings is not None:
            pulumi.set(__self__, "connection_strings", connection_strings)
        if cors is not None:
            pulumi.set(__self__, "cors", cors)
        if default_documents is not None:
            pulumi.set(__self__, "default_documents", default_documents)
        if detailed_error_logging_enabled is not None:
            pulumi.set(__self__, "detailed_error_logging_enabled", detailed_error_logging_enabled)
        if document_root is not None:
            pulumi.set(__self__, "document_root", document_root)
        if elastic_web_app_scale_limit is not None:
            pulumi.set(__self__, "elastic_web_app_scale_limit", elastic_web_app_scale_limit)
        if experiments is not None:
            pulumi.set(__self__, "experiments", experiments)
        if ftps_state is not None:
            pulumi.set(__self__, "ftps_state", ftps_state)
        if function_app_scale_limit is not None:
            pulumi.set(__self__, "function_app_scale_limit", function_app_scale_limit)
        if functions_runtime_scale_monitoring_enabled is not None:
            pulumi.set(__self__, "functions_runtime_scale_monitoring_enabled", functions_runtime_scale_monitoring_enabled)
        if handler_mappings is not None:
            pulumi.set(__self__, "handler_mappings", handler_mappings)
        if health_check_path is not None:
            pulumi.set(__self__, "health_check_path", health_check_path)
        if http20_enabled is None:
            http20_enabled = True
        if http20_enabled is not None:
            pulumi.set(__self__, "http20_enabled", http20_enabled)
        if http_logging_enabled is not None:
            pulumi.set(__self__, "http_logging_enabled", http_logging_enabled)
        if ip_security_restrictions is not None:
            pulumi.set(__self__, "ip_security_restrictions", ip_security_restrictions)
        if ip_security_restrictions_default_action is not None:
            pulumi.set(__self__, "ip_security_restrictions_default_action", ip_security_restrictions_default_action)
        if java_container is not None:
            pulumi.set(__self__, "java_container", java_container)
        if java_container_version is not None:
            pulumi.set(__self__, "java_container_version", java_container_version)
        if java_version is not None:
            pulumi.set(__self__, "java_version", java_version)
        if key_vault_reference_identity is not None:
            pulumi.set(__self__, "key_vault_reference_identity", key_vault_reference_identity)
        if limits is not None:
            pulumi.set(__self__, "limits", limits)
        if linux_fx_version is not None:
            pulumi.set(__self__, "linux_fx_version", linux_fx_version)
        if load_balancing is not None:
            pulumi.set(__self__, "load_balancing", load_balancing)
        if local_my_sql_enabled is None:
            local_my_sql_enabled = False
        if local_my_sql_enabled is not None:
            pulumi.set(__self__, "local_my_sql_enabled", local_my_sql_enabled)
        if logs_directory_size_limit is not None:
            pulumi.set(__self__, "logs_directory_size_limit", logs_directory_size_limit)
        if managed_pipeline_mode is not None:
            pulumi.set(__self__, "managed_pipeline_mode", managed_pipeline_mode)
        if managed_service_identity_id is not None:
            pulumi.set(__self__, "managed_service_identity_id", managed_service_identity_id)
        if min_tls_version is not None:
            pulumi.set(__self__, "min_tls_version", min_tls_version)
        if minimum_elastic_instance_count is not None:
            pulumi.set(__self__, "minimum_elastic_instance_count", minimum_elastic_instance_count)
        if net_framework_version is None:
            net_framework_version = 'v4.6'
        if net_framework_version is not None:
            pulumi.set(__self__, "net_framework_version", net_framework_version)
        if node_version is not None:
            pulumi.set(__self__, "node_version", node_version)
        if number_of_workers is not None:
            pulumi.set(__self__, "number_of_workers", number_of_workers)
        if php_version is not None:
            pulumi.set(__self__, "php_version", php_version)
        if power_shell_version is not None:
            pulumi.set(__self__, "power_shell_version", power_shell_version)
        if pre_warmed_instance_count is not None:
            pulumi.set(__self__, "pre_warmed_instance_count", pre_warmed_instance_count)
        if public_network_access is not None:
            pulumi.set(__self__, "public_network_access", public_network_access)
        if publishing_username is not None:
            pulumi.set(__self__, "publishing_username", publishing_username)
        if push is not None:
            pulumi.set(__self__, "push", push)
        if python_version is not None:
            pulumi.set(__self__, "python_version", python_version)
        if remote_debugging_enabled is not None:
            pulumi.set(__self__, "remote_debugging_enabled", remote_debugging_enabled)
        if remote_debugging_version is not None:
            pulumi.set(__self__, "remote_debugging_version", remote_debugging_version)
        if request_tracing_enabled is not None:
            pulumi.set(__self__, "request_tracing_enabled", request_tracing_enabled)
        if request_tracing_expiration_time is not None:
            pulumi.set(__self__, "request_tracing_expiration_time", request_tracing_expiration_time)
        if scm_ip_security_restrictions is not None:
            pulumi.set(__self__, "scm_ip_security_restrictions", scm_ip_security_restrictions)
        if scm_ip_security_restrictions_default_action is not None:
            pulumi.set(__self__, "scm_ip_security_restrictions_default_action", scm_ip_security_restrictions_default_action)
        if scm_ip_security_restrictions_use_main is not None:
            pulumi.set(__self__, "scm_ip_security_restrictions_use_main", scm_ip_security_restrictions_use_main)
        if scm_min_tls_version is not None:
            pulumi.set(__self__, "scm_min_tls_version", scm_min_tls_version)
        if scm_type is not None:
            pulumi.set(__self__, "scm_type", scm_type)
        if tracing_options is not None:
            pulumi.set(__self__, "tracing_options", tracing_options)
        if use32_bit_worker_process is not None:
            pulumi.set(__self__, "use32_bit_worker_process", use32_bit_worker_process)
        if virtual_applications is not None:
            pulumi.set(__self__, "virtual_applications", virtual_applications)
        if vnet_name is not None:
            pulumi.set(__self__, "vnet_name", vnet_name)
        if vnet_private_ports_count is not None:
            pulumi.set(__self__, "vnet_private_ports_count", vnet_private_ports_count)
        if vnet_route_all_enabled is not None:
            pulumi.set(__self__, "vnet_route_all_enabled", vnet_route_all_enabled)
        if web_sockets_enabled is not None:
            pulumi.set(__self__, "web_sockets_enabled", web_sockets_enabled)
        if website_time_zone is not None:
            pulumi.set(__self__, "website_time_zone", website_time_zone)
        if windows_fx_version is not None:
            pulumi.set(__self__, "windows_fx_version", windows_fx_version)
        if x_managed_service_identity_id is not None:
            pulumi.set(__self__, "x_managed_service_identity_id", x_managed_service_identity_id)

    @property
    @pulumi.getter(name="machineKey")
    def machine_key(self) -> 'outputs.SiteMachineKeyResponse':
        """
        Site MachineKey.
        """
        return pulumi.get(self, "machine_key")

    @property
    @pulumi.getter(name="acrUseManagedIdentityCreds")
    def acr_use_managed_identity_creds(self) -> Optional[bool]:
        """
        Flag to use Managed Identity Creds for ACR pull
        """
        return pulumi.get(self, "acr_use_managed_identity_creds")

    @property
    @pulumi.getter(name="acrUserManagedIdentityID")
    def acr_user_managed_identity_id(self) -> Optional[str]:
        """
        If using user managed identity, the user managed identity ClientId
        """
        return pulumi.get(self, "acr_user_managed_identity_id")

    @property
    @pulumi.getter(name="alwaysOn")
    def always_on(self) -> Optional[bool]:
        """
        <code>true</code> if Always On is enabled; otherwise, <code>false</code>.
        """
        return pulumi.get(self, "always_on")

    @property
    @pulumi.getter(name="apiDefinition")
    def api_definition(self) -> Optional['outputs.ApiDefinitionInfoResponse']:
        """
        Information about the formal API definition for the app.
        """
        return pulumi.get(self, "api_definition")

    @property
    @pulumi.getter(name="apiManagementConfig")
    def api_management_config(self) -> Optional['outputs.ApiManagementConfigResponse']:
        """
        Azure API management settings linked to the app.
        """
        return pulumi.get(self, "api_management_config")

    @property
    @pulumi.getter(name="appCommandLine")
    def app_command_line(self) -> Optional[str]:
        """
        App command line to launch.
        """
        return pulumi.get(self, "app_command_line")

    @property
    @pulumi.getter(name="appSettings")
    def app_settings(self) -> Optional[Sequence['outputs.NameValuePairResponse']]:
        """
        Application settings.
        """
        return pulumi.get(self, "app_settings")

    @property
    @pulumi.getter(name="autoHealEnabled")
    def auto_heal_enabled(self) -> Optional[bool]:
        """
        <code>true</code> if Auto Heal is enabled; otherwise, <code>false</code>.
        """
        return pulumi.get(self, "auto_heal_enabled")

    @property
    @pulumi.getter(name="autoHealRules")
    def auto_heal_rules(self) -> Optional['outputs.AutoHealRulesResponse']:
        """
        Auto Heal rules.
        """
        return pulumi.get(self, "auto_heal_rules")

    @property
    @pulumi.getter(name="autoSwapSlotName")
    def auto_swap_slot_name(self) -> Optional[str]:
        """
        Auto-swap slot name.
        """
        return pulumi.get(self, "auto_swap_slot_name")

    @property
    @pulumi.getter(name="azureStorageAccounts")
    def azure_storage_accounts(self) -> Optional[Mapping[str, 'outputs.AzureStorageInfoValueResponse']]:
        """
        List of Azure Storage Accounts.
        """
        return pulumi.get(self, "azure_storage_accounts")

    @property
    @pulumi.getter(name="connectionStrings")
    def connection_strings(self) -> Optional[Sequence['outputs.ConnStringInfoResponse']]:
        """
        Connection strings.
        """
        return pulumi.get(self, "connection_strings")

    @property
    @pulumi.getter
    def cors(self) -> Optional['outputs.CorsSettingsResponse']:
        """
        Cross-Origin Resource Sharing (CORS) settings.
        """
        return pulumi.get(self, "cors")

    @property
    @pulumi.getter(name="defaultDocuments")
    def default_documents(self) -> Optional[Sequence[str]]:
        """
        Default documents.
        """
        return pulumi.get(self, "default_documents")

    @property
    @pulumi.getter(name="detailedErrorLoggingEnabled")
    def detailed_error_logging_enabled(self) -> Optional[bool]:
        """
        <code>true</code> if detailed error logging is enabled; otherwise, <code>false</code>.
        """
        return pulumi.get(self, "detailed_error_logging_enabled")

    @property
    @pulumi.getter(name="documentRoot")
    def document_root(self) -> Optional[str]:
        """
        Document root.
        """
        return pulumi.get(self, "document_root")

    @property
    @pulumi.getter(name="elasticWebAppScaleLimit")
    def elastic_web_app_scale_limit(self) -> Optional[int]:
        """
        Maximum number of workers that a site can scale out to.
        This setting only applies to apps in plans where ElasticScaleEnabled is <code>true</code>
        """
        return pulumi.get(self, "elastic_web_app_scale_limit")

    @property
    @pulumi.getter
    def experiments(self) -> Optional['outputs.ExperimentsResponse']:
        """
        This is work around for polymorphic types.
        """
        return pulumi.get(self, "experiments")

    @property
    @pulumi.getter(name="ftpsState")
    def ftps_state(self) -> Optional[str]:
        """
        State of FTP / FTPS service
        """
        return pulumi.get(self, "ftps_state")

    @property
    @pulumi.getter(name="functionAppScaleLimit")
    def function_app_scale_limit(self) -> Optional[int]:
        """
        Maximum number of workers that a site can scale out to.
        This setting only applies to the Consumption and Elastic Premium Plans
        """
        return pulumi.get(self, "function_app_scale_limit")

    @property
    @pulumi.getter(name="functionsRuntimeScaleMonitoringEnabled")
    def functions_runtime_scale_monitoring_enabled(self) -> Optional[bool]:
        """
        Gets or sets a value indicating whether functions runtime scale monitoring is enabled. When enabled,
        the ScaleController will not monitor event sources directly, but will instead call to the
        runtime to get scale status.
        """
        return pulumi.get(self, "functions_runtime_scale_monitoring_enabled")

    @property
    @pulumi.getter(name="handlerMappings")
    def handler_mappings(self) -> Optional[Sequence['outputs.HandlerMappingResponse']]:
        """
        Handler mappings.
        """
        return pulumi.get(self, "handler_mappings")

    @property
    @pulumi.getter(name="healthCheckPath")
    def health_check_path(self) -> Optional[str]:
        """
        Health check path
        """
        return pulumi.get(self, "health_check_path")

    @property
    @pulumi.getter(name="http20Enabled")
    def http20_enabled(self) -> Optional[bool]:
        """
        Http20Enabled: configures a web site to allow clients to connect over http2.0
        """
        return pulumi.get(self, "http20_enabled")

    @property
    @pulumi.getter(name="httpLoggingEnabled")
    def http_logging_enabled(self) -> Optional[bool]:
        """
        <code>true</code> if HTTP logging is enabled; otherwise, <code>false</code>.
        """
        return pulumi.get(self, "http_logging_enabled")

    @property
    @pulumi.getter(name="ipSecurityRestrictions")
    def ip_security_restrictions(self) -> Optional[Sequence['outputs.IpSecurityRestrictionResponse']]:
        """
        IP security restrictions for main.
        """
        return pulumi.get(self, "ip_security_restrictions")

    @property
    @pulumi.getter(name="ipSecurityRestrictionsDefaultAction")
    def ip_security_restrictions_default_action(self) -> Optional[str]:
        """
        Default action for main access restriction if no rules are matched.
        """
        return pulumi.get(self, "ip_security_restrictions_default_action")

    @property
    @pulumi.getter(name="javaContainer")
    def java_container(self) -> Optional[str]:
        """
        Java container.
        """
        return pulumi.get(self, "java_container")

    @property
    @pulumi.getter(name="javaContainerVersion")
    def java_container_version(self) -> Optional[str]:
        """
        Java container version.
        """
        return pulumi.get(self, "java_container_version")

    @property
    @pulumi.getter(name="javaVersion")
    def java_version(self) -> Optional[str]:
        """
        Java version.
        """
        return pulumi.get(self, "java_version")

    @property
    @pulumi.getter(name="keyVaultReferenceIdentity")
    def key_vault_reference_identity(self) -> Optional[str]:
        """
        Identity to use for Key Vault Reference authentication.
        """
        return pulumi.get(self, "key_vault_reference_identity")

    @property
    @pulumi.getter
    def limits(self) -> Optional['outputs.SiteLimitsResponse']:
        """
        Site limits.
        """
        return pulumi.get(self, "limits")

    @property
    @pulumi.getter(name="linuxFxVersion")
    def linux_fx_version(self) -> Optional[str]:
        """
        Linux App Framework and version
        """
        return pulumi.get(self, "linux_fx_version")

    @property
    @pulumi.getter(name="loadBalancing")
    def load_balancing(self) -> Optional[str]:
        """
        Site load balancing.
        """
        return pulumi.get(self, "load_balancing")

    @property
    @pulumi.getter(name="localMySqlEnabled")
    def local_my_sql_enabled(self) -> Optional[bool]:
        """
        <code>true</code> to enable local MySQL; otherwise, <code>false</code>.
        """
        return pulumi.get(self, "local_my_sql_enabled")

    @property
    @pulumi.getter(name="logsDirectorySizeLimit")
    def logs_directory_size_limit(self) -> Optional[int]:
        """
        HTTP logs directory size limit.
        """
        return pulumi.get(self, "logs_directory_size_limit")

    @property
    @pulumi.getter(name="managedPipelineMode")
    def managed_pipeline_mode(self) -> Optional[str]:
        """
        Managed pipeline mode.
        """
        return pulumi.get(self, "managed_pipeline_mode")

    @property
    @pulumi.getter(name="managedServiceIdentityId")
    def managed_service_identity_id(self) -> Optional[int]:
        """
        Managed Service Identity Id
        """
        return pulumi.get(self, "managed_service_identity_id")

    @property
    @pulumi.getter(name="minTlsVersion")
    def min_tls_version(self) -> Optional[str]:
        """
        MinTlsVersion: configures the minimum version of TLS required for SSL requests
        """
        return pulumi.get(self, "min_tls_version")

    @property
    @pulumi.getter(name="minimumElasticInstanceCount")
    def minimum_elastic_instance_count(self) -> Optional[int]:
        """
        Number of minimum instance count for a site
        This setting only applies to the Elastic Plans
        """
        return pulumi.get(self, "minimum_elastic_instance_count")

    @property
    @pulumi.getter(name="netFrameworkVersion")
    def net_framework_version(self) -> Optional[str]:
        """
        .NET Framework version.
        """
        return pulumi.get(self, "net_framework_version")

    @property
    @pulumi.getter(name="nodeVersion")
    def node_version(self) -> Optional[str]:
        """
        Version of Node.js.
        """
        return pulumi.get(self, "node_version")

    @property
    @pulumi.getter(name="numberOfWorkers")
    def number_of_workers(self) -> Optional[int]:
        """
        Number of workers.
        """
        return pulumi.get(self, "number_of_workers")

    @property
    @pulumi.getter(name="phpVersion")
    def php_version(self) -> Optional[str]:
        """
        Version of PHP.
        """
        return pulumi.get(self, "php_version")

    @property
    @pulumi.getter(name="powerShellVersion")
    def power_shell_version(self) -> Optional[str]:
        """
        Version of PowerShell.
        """
        return pulumi.get(self, "power_shell_version")

    @property
    @pulumi.getter(name="preWarmedInstanceCount")
    def pre_warmed_instance_count(self) -> Optional[int]:
        """
        Number of preWarmed instances.
        This setting only applies to the Consumption and Elastic Plans
        """
        return pulumi.get(self, "pre_warmed_instance_count")

    @property
    @pulumi.getter(name="publicNetworkAccess")
    def public_network_access(self) -> Optional[str]:
        """
        Property to allow or block all public traffic.
        """
        return pulumi.get(self, "public_network_access")

    @property
    @pulumi.getter(name="publishingUsername")
    def publishing_username(self) -> Optional[str]:
        """
        Publishing user name.
        """
        return pulumi.get(self, "publishing_username")

    @property
    @pulumi.getter
    def push(self) -> Optional['outputs.PushSettingsResponse']:
        """
        Push endpoint settings.
        """
        return pulumi.get(self, "push")

    @property
    @pulumi.getter(name="pythonVersion")
    def python_version(self) -> Optional[str]:
        """
        Version of Python.
        """
        return pulumi.get(self, "python_version")

    @property
    @pulumi.getter(name="remoteDebuggingEnabled")
    def remote_debugging_enabled(self) -> Optional[bool]:
        """
        <code>true</code> if remote debugging is enabled; otherwise, <code>false</code>.
        """
        return pulumi.get(self, "remote_debugging_enabled")

    @property
    @pulumi.getter(name="remoteDebuggingVersion")
    def remote_debugging_version(self) -> Optional[str]:
        """
        Remote debugging version.
        """
        return pulumi.get(self, "remote_debugging_version")

    @property
    @pulumi.getter(name="requestTracingEnabled")
    def request_tracing_enabled(self) -> Optional[bool]:
        """
        <code>true</code> if request tracing is enabled; otherwise, <code>false</code>.
        """
        return pulumi.get(self, "request_tracing_enabled")

    @property
    @pulumi.getter(name="requestTracingExpirationTime")
    def request_tracing_expiration_time(self) -> Optional[str]:
        """
        Request tracing expiration time.
        """
        return pulumi.get(self, "request_tracing_expiration_time")

    @property
    @pulumi.getter(name="scmIpSecurityRestrictions")
    def scm_ip_security_restrictions(self) -> Optional[Sequence['outputs.IpSecurityRestrictionResponse']]:
        """
        IP security restrictions for scm.
        """
        return pulumi.get(self, "scm_ip_security_restrictions")

    @property
    @pulumi.getter(name="scmIpSecurityRestrictionsDefaultAction")
    def scm_ip_security_restrictions_default_action(self) -> Optional[str]:
        """
        Default action for scm access restriction if no rules are matched.
        """
        return pulumi.get(self, "scm_ip_security_restrictions_default_action")

    @property
    @pulumi.getter(name="scmIpSecurityRestrictionsUseMain")
    def scm_ip_security_restrictions_use_main(self) -> Optional[bool]:
        """
        IP security restrictions for scm to use main.
        """
        return pulumi.get(self, "scm_ip_security_restrictions_use_main")

    @property
    @pulumi.getter(name="scmMinTlsVersion")
    def scm_min_tls_version(self) -> Optional[str]:
        """
        ScmMinTlsVersion: configures the minimum version of TLS required for SSL requests for SCM site
        """
        return pulumi.get(self, "scm_min_tls_version")

    @property
    @pulumi.getter(name="scmType")
    def scm_type(self) -> Optional[str]:
        """
        SCM type.
        """
        return pulumi.get(self, "scm_type")

    @property
    @pulumi.getter(name="tracingOptions")
    def tracing_options(self) -> Optional[str]:
        """
        Tracing options.
        """
        return pulumi.get(self, "tracing_options")

    @property
    @pulumi.getter(name="use32BitWorkerProcess")
    def use32_bit_worker_process(self) -> Optional[bool]:
        """
        <code>true</code> to use 32-bit worker process; otherwise, <code>false</code>.
        """
        return pulumi.get(self, "use32_bit_worker_process")

    @property
    @pulumi.getter(name="virtualApplications")
    def virtual_applications(self) -> Optional[Sequence['outputs.VirtualApplicationResponse']]:
        """
        Virtual applications.
        """
        return pulumi.get(self, "virtual_applications")

    @property
    @pulumi.getter(name="vnetName")
    def vnet_name(self) -> Optional[str]:
        """
        Virtual Network name.
        """
        return pulumi.get(self, "vnet_name")

    @property
    @pulumi.getter(name="vnetPrivatePortsCount")
    def vnet_private_ports_count(self) -> Optional[int]:
        """
        The number of private ports assigned to this app. These will be assigned dynamically on runtime.
        """
        return pulumi.get(self, "vnet_private_ports_count")

    @property
    @pulumi.getter(name="vnetRouteAllEnabled")
    def vnet_route_all_enabled(self) -> Optional[bool]:
        """
        Virtual Network Route All enabled. This causes all outbound traffic to have Virtual Network Security Groups and User Defined Routes applied.
        """
        return pulumi.get(self, "vnet_route_all_enabled")

    @property
    @pulumi.getter(name="webSocketsEnabled")
    def web_sockets_enabled(self) -> Optional[bool]:
        """
        <code>true</code> if WebSocket is enabled; otherwise, <code>false</code>.
        """
        return pulumi.get(self, "web_sockets_enabled")

    @property
    @pulumi.getter(name="websiteTimeZone")
    def website_time_zone(self) -> Optional[str]:
        """
        Sets the time zone a site uses for generating timestamps. Compatible with Linux and Windows App Service. Setting the WEBSITE_TIME_ZONE app setting takes precedence over this config. For Linux, expects tz database values https://www.iana.org/time-zones (for a quick reference see https://en.wikipedia.org/wiki/List_of_tz_database_time_zones). For Windows, expects one of the time zones listed under HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion\\Time Zones
        """
        return pulumi.get(self, "website_time_zone")

    @property
    @pulumi.getter(name="windowsFxVersion")
    def windows_fx_version(self) -> Optional[str]:
        """
        Xenon App Framework and version
        """
        return pulumi.get(self, "windows_fx_version")

    @property
    @pulumi.getter(name="xManagedServiceIdentityId")
    def x_managed_service_identity_id(self) -> Optional[int]:
        """
        Explicit Managed Service Identity Id
        """
        return pulumi.get(self, "x_managed_service_identity_id")


@pulumi.output_type
class SiteLimitsResponse(dict):
    """
    Metric limits set on an app.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxDiskSizeInMb":
            suggest = "max_disk_size_in_mb"
        elif key == "maxMemoryInMb":
            suggest = "max_memory_in_mb"
        elif key == "maxPercentageCpu":
            suggest = "max_percentage_cpu"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SiteLimitsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SiteLimitsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SiteLimitsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_disk_size_in_mb: Optional[float] = None,
                 max_memory_in_mb: Optional[float] = None,
                 max_percentage_cpu: Optional[float] = None):
        """
        Metric limits set on an app.
        :param float max_disk_size_in_mb: Maximum allowed disk size usage in MB.
        :param float max_memory_in_mb: Maximum allowed memory usage in MB.
        :param float max_percentage_cpu: Maximum allowed CPU usage percentage.
        """
        if max_disk_size_in_mb is not None:
            pulumi.set(__self__, "max_disk_size_in_mb", max_disk_size_in_mb)
        if max_memory_in_mb is not None:
            pulumi.set(__self__, "max_memory_in_mb", max_memory_in_mb)
        if max_percentage_cpu is not None:
            pulumi.set(__self__, "max_percentage_cpu", max_percentage_cpu)

    @property
    @pulumi.getter(name="maxDiskSizeInMb")
    def max_disk_size_in_mb(self) -> Optional[float]:
        """
        Maximum allowed disk size usage in MB.
        """
        return pulumi.get(self, "max_disk_size_in_mb")

    @property
    @pulumi.getter(name="maxMemoryInMb")
    def max_memory_in_mb(self) -> Optional[float]:
        """
        Maximum allowed memory usage in MB.
        """
        return pulumi.get(self, "max_memory_in_mb")

    @property
    @pulumi.getter(name="maxPercentageCpu")
    def max_percentage_cpu(self) -> Optional[float]:
        """
        Maximum allowed CPU usage percentage.
        """
        return pulumi.get(self, "max_percentage_cpu")


@pulumi.output_type
class SiteMachineKeyResponse(dict):
    """
    MachineKey of an app.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "decryptionKey":
            suggest = "decryption_key"
        elif key == "validationKey":
            suggest = "validation_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SiteMachineKeyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SiteMachineKeyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SiteMachineKeyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 decryption: Optional[str] = None,
                 decryption_key: Optional[str] = None,
                 validation: Optional[str] = None,
                 validation_key: Optional[str] = None):
        """
        MachineKey of an app.
        :param str decryption: Algorithm used for decryption.
        :param str decryption_key: Decryption key.
        :param str validation: MachineKey validation.
        :param str validation_key: Validation key.
        """
        if decryption is not None:
            pulumi.set(__self__, "decryption", decryption)
        if decryption_key is not None:
            pulumi.set(__self__, "decryption_key", decryption_key)
        if validation is not None:
            pulumi.set(__self__, "validation", validation)
        if validation_key is not None:
            pulumi.set(__self__, "validation_key", validation_key)

    @property
    @pulumi.getter
    def decryption(self) -> Optional[str]:
        """
        Algorithm used for decryption.
        """
        return pulumi.get(self, "decryption")

    @property
    @pulumi.getter(name="decryptionKey")
    def decryption_key(self) -> Optional[str]:
        """
        Decryption key.
        """
        return pulumi.get(self, "decryption_key")

    @property
    @pulumi.getter
    def validation(self) -> Optional[str]:
        """
        MachineKey validation.
        """
        return pulumi.get(self, "validation")

    @property
    @pulumi.getter(name="validationKey")
    def validation_key(self) -> Optional[str]:
        """
        Validation key.
        """
        return pulumi.get(self, "validation_key")


@pulumi.output_type
class SkuCapacityResponse(dict):
    """
    Description of the App Service plan scale options.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "elasticMaximum":
            suggest = "elastic_maximum"
        elif key == "scaleType":
            suggest = "scale_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SkuCapacityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SkuCapacityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SkuCapacityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default: Optional[int] = None,
                 elastic_maximum: Optional[int] = None,
                 maximum: Optional[int] = None,
                 minimum: Optional[int] = None,
                 scale_type: Optional[str] = None):
        """
        Description of the App Service plan scale options.
        :param int default: Default number of workers for this App Service plan SKU.
        :param int elastic_maximum: Maximum number of Elastic workers for this App Service plan SKU.
        :param int maximum: Maximum number of workers for this App Service plan SKU.
        :param int minimum: Minimum number of workers for this App Service plan SKU.
        :param str scale_type: Available scale configurations for an App Service plan.
        """
        if default is not None:
            pulumi.set(__self__, "default", default)
        if elastic_maximum is not None:
            pulumi.set(__self__, "elastic_maximum", elastic_maximum)
        if maximum is not None:
            pulumi.set(__self__, "maximum", maximum)
        if minimum is not None:
            pulumi.set(__self__, "minimum", minimum)
        if scale_type is not None:
            pulumi.set(__self__, "scale_type", scale_type)

    @property
    @pulumi.getter
    def default(self) -> Optional[int]:
        """
        Default number of workers for this App Service plan SKU.
        """
        return pulumi.get(self, "default")

    @property
    @pulumi.getter(name="elasticMaximum")
    def elastic_maximum(self) -> Optional[int]:
        """
        Maximum number of Elastic workers for this App Service plan SKU.
        """
        return pulumi.get(self, "elastic_maximum")

    @property
    @pulumi.getter
    def maximum(self) -> Optional[int]:
        """
        Maximum number of workers for this App Service plan SKU.
        """
        return pulumi.get(self, "maximum")

    @property
    @pulumi.getter
    def minimum(self) -> Optional[int]:
        """
        Minimum number of workers for this App Service plan SKU.
        """
        return pulumi.get(self, "minimum")

    @property
    @pulumi.getter(name="scaleType")
    def scale_type(self) -> Optional[str]:
        """
        Available scale configurations for an App Service plan.
        """
        return pulumi.get(self, "scale_type")


@pulumi.output_type
class SkuDescriptionResponse(dict):
    """
    Description of a SKU for a scalable resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "skuCapacity":
            suggest = "sku_capacity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SkuDescriptionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SkuDescriptionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SkuDescriptionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 capabilities: Optional[Sequence['outputs.CapabilityResponse']] = None,
                 capacity: Optional[int] = None,
                 family: Optional[str] = None,
                 locations: Optional[Sequence[str]] = None,
                 name: Optional[str] = None,
                 size: Optional[str] = None,
                 sku_capacity: Optional['outputs.SkuCapacityResponse'] = None,
                 tier: Optional[str] = None):
        """
        Description of a SKU for a scalable resource.
        :param Sequence['CapabilityResponse'] capabilities: Capabilities of the SKU, e.g., is traffic manager enabled?
        :param int capacity: Current number of instances assigned to the resource.
        :param str family: Family code of the resource SKU.
        :param Sequence[str] locations: Locations of the SKU.
        :param str name: Name of the resource SKU.
        :param str size: Size specifier of the resource SKU.
        :param 'SkuCapacityResponse' sku_capacity: Min, max, and default scale values of the SKU.
        :param str tier: Service tier of the resource SKU.
        """
        if capabilities is not None:
            pulumi.set(__self__, "capabilities", capabilities)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if family is not None:
            pulumi.set(__self__, "family", family)
        if locations is not None:
            pulumi.set(__self__, "locations", locations)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if sku_capacity is not None:
            pulumi.set(__self__, "sku_capacity", sku_capacity)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter
    def capabilities(self) -> Optional[Sequence['outputs.CapabilityResponse']]:
        """
        Capabilities of the SKU, e.g., is traffic manager enabled?
        """
        return pulumi.get(self, "capabilities")

    @property
    @pulumi.getter
    def capacity(self) -> Optional[int]:
        """
        Current number of instances assigned to the resource.
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter
    def family(self) -> Optional[str]:
        """
        Family code of the resource SKU.
        """
        return pulumi.get(self, "family")

    @property
    @pulumi.getter
    def locations(self) -> Optional[Sequence[str]]:
        """
        Locations of the SKU.
        """
        return pulumi.get(self, "locations")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the resource SKU.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def size(self) -> Optional[str]:
        """
        Size specifier of the resource SKU.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter(name="skuCapacity")
    def sku_capacity(self) -> Optional['outputs.SkuCapacityResponse']:
        """
        Min, max, and default scale values of the SKU.
        """
        return pulumi.get(self, "sku_capacity")

    @property
    @pulumi.getter
    def tier(self) -> Optional[str]:
        """
        Service tier of the resource SKU.
        """
        return pulumi.get(self, "tier")


@pulumi.output_type
class SlotSwapStatusResponse(dict):
    """
    The status of the last successful slot swap operation.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "destinationSlotName":
            suggest = "destination_slot_name"
        elif key == "sourceSlotName":
            suggest = "source_slot_name"
        elif key == "timestampUtc":
            suggest = "timestamp_utc"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SlotSwapStatusResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SlotSwapStatusResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SlotSwapStatusResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 destination_slot_name: str,
                 source_slot_name: str,
                 timestamp_utc: str):
        """
        The status of the last successful slot swap operation.
        :param str destination_slot_name: The destination slot of the last swap operation.
        :param str source_slot_name: The source slot of the last swap operation.
        :param str timestamp_utc: The time the last successful slot swap completed.
        """
        pulumi.set(__self__, "destination_slot_name", destination_slot_name)
        pulumi.set(__self__, "source_slot_name", source_slot_name)
        pulumi.set(__self__, "timestamp_utc", timestamp_utc)

    @property
    @pulumi.getter(name="destinationSlotName")
    def destination_slot_name(self) -> str:
        """
        The destination slot of the last swap operation.
        """
        return pulumi.get(self, "destination_slot_name")

    @property
    @pulumi.getter(name="sourceSlotName")
    def source_slot_name(self) -> str:
        """
        The source slot of the last swap operation.
        """
        return pulumi.get(self, "source_slot_name")

    @property
    @pulumi.getter(name="timestampUtc")
    def timestamp_utc(self) -> str:
        """
        The time the last successful slot swap completed.
        """
        return pulumi.get(self, "timestamp_utc")


@pulumi.output_type
class SlowRequestsBasedTriggerResponse(dict):
    """
    Trigger based on request execution time.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "timeInterval":
            suggest = "time_interval"
        elif key == "timeTaken":
            suggest = "time_taken"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SlowRequestsBasedTriggerResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SlowRequestsBasedTriggerResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SlowRequestsBasedTriggerResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 count: Optional[int] = None,
                 path: Optional[str] = None,
                 time_interval: Optional[str] = None,
                 time_taken: Optional[str] = None):
        """
        Trigger based on request execution time.
        :param int count: Request Count.
        :param str path: Request Path.
        :param str time_interval: Time interval.
        :param str time_taken: Time taken.
        """
        if count is not None:
            pulumi.set(__self__, "count", count)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if time_interval is not None:
            pulumi.set(__self__, "time_interval", time_interval)
        if time_taken is not None:
            pulumi.set(__self__, "time_taken", time_taken)

    @property
    @pulumi.getter
    def count(self) -> Optional[int]:
        """
        Request Count.
        """
        return pulumi.get(self, "count")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        Request Path.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="timeInterval")
    def time_interval(self) -> Optional[str]:
        """
        Time interval.
        """
        return pulumi.get(self, "time_interval")

    @property
    @pulumi.getter(name="timeTaken")
    def time_taken(self) -> Optional[str]:
        """
        Time taken.
        """
        return pulumi.get(self, "time_taken")


@pulumi.output_type
class StaticSiteBuildPropertiesResponse(dict):
    """
    Build properties for the static site.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiBuildCommand":
            suggest = "api_build_command"
        elif key == "apiLocation":
            suggest = "api_location"
        elif key == "appArtifactLocation":
            suggest = "app_artifact_location"
        elif key == "appBuildCommand":
            suggest = "app_build_command"
        elif key == "appLocation":
            suggest = "app_location"
        elif key == "githubActionSecretNameOverride":
            suggest = "github_action_secret_name_override"
        elif key == "outputLocation":
            suggest = "output_location"
        elif key == "skipGithubActionWorkflowGeneration":
            suggest = "skip_github_action_workflow_generation"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StaticSiteBuildPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StaticSiteBuildPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StaticSiteBuildPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_build_command: Optional[str] = None,
                 api_location: Optional[str] = None,
                 app_artifact_location: Optional[str] = None,
                 app_build_command: Optional[str] = None,
                 app_location: Optional[str] = None,
                 github_action_secret_name_override: Optional[str] = None,
                 output_location: Optional[str] = None,
                 skip_github_action_workflow_generation: Optional[bool] = None):
        """
        Build properties for the static site.
        :param str api_build_command: A custom command to run during deployment of the Azure Functions API application.
        :param str api_location: The path to the api code within the repository.
        :param str app_artifact_location: Deprecated: The path of the app artifacts after building (deprecated in favor of OutputLocation)
        :param str app_build_command: A custom command to run during deployment of the static content application.
        :param str app_location: The path to the app code within the repository.
        :param str github_action_secret_name_override: Github Action secret name override.
        :param str output_location: The output path of the app after building.
        :param bool skip_github_action_workflow_generation: Skip Github Action workflow generation.
        """
        if api_build_command is not None:
            pulumi.set(__self__, "api_build_command", api_build_command)
        if api_location is not None:
            pulumi.set(__self__, "api_location", api_location)
        if app_artifact_location is not None:
            pulumi.set(__self__, "app_artifact_location", app_artifact_location)
        if app_build_command is not None:
            pulumi.set(__self__, "app_build_command", app_build_command)
        if app_location is not None:
            pulumi.set(__self__, "app_location", app_location)
        if github_action_secret_name_override is not None:
            pulumi.set(__self__, "github_action_secret_name_override", github_action_secret_name_override)
        if output_location is not None:
            pulumi.set(__self__, "output_location", output_location)
        if skip_github_action_workflow_generation is not None:
            pulumi.set(__self__, "skip_github_action_workflow_generation", skip_github_action_workflow_generation)

    @property
    @pulumi.getter(name="apiBuildCommand")
    def api_build_command(self) -> Optional[str]:
        """
        A custom command to run during deployment of the Azure Functions API application.
        """
        return pulumi.get(self, "api_build_command")

    @property
    @pulumi.getter(name="apiLocation")
    def api_location(self) -> Optional[str]:
        """
        The path to the api code within the repository.
        """
        return pulumi.get(self, "api_location")

    @property
    @pulumi.getter(name="appArtifactLocation")
    def app_artifact_location(self) -> Optional[str]:
        """
        Deprecated: The path of the app artifacts after building (deprecated in favor of OutputLocation)
        """
        return pulumi.get(self, "app_artifact_location")

    @property
    @pulumi.getter(name="appBuildCommand")
    def app_build_command(self) -> Optional[str]:
        """
        A custom command to run during deployment of the static content application.
        """
        return pulumi.get(self, "app_build_command")

    @property
    @pulumi.getter(name="appLocation")
    def app_location(self) -> Optional[str]:
        """
        The path to the app code within the repository.
        """
        return pulumi.get(self, "app_location")

    @property
    @pulumi.getter(name="githubActionSecretNameOverride")
    def github_action_secret_name_override(self) -> Optional[str]:
        """
        Github Action secret name override.
        """
        return pulumi.get(self, "github_action_secret_name_override")

    @property
    @pulumi.getter(name="outputLocation")
    def output_location(self) -> Optional[str]:
        """
        The output path of the app after building.
        """
        return pulumi.get(self, "output_location")

    @property
    @pulumi.getter(name="skipGithubActionWorkflowGeneration")
    def skip_github_action_workflow_generation(self) -> Optional[bool]:
        """
        Skip Github Action workflow generation.
        """
        return pulumi.get(self, "skip_github_action_workflow_generation")


@pulumi.output_type
class StaticSiteDatabaseConnectionConfigurationFileOverviewResponse(dict):
    """
    A database connection configuration file
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fileName":
            suggest = "file_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StaticSiteDatabaseConnectionConfigurationFileOverviewResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StaticSiteDatabaseConnectionConfigurationFileOverviewResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StaticSiteDatabaseConnectionConfigurationFileOverviewResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 contents: str,
                 file_name: str,
                 type: str):
        """
        A database connection configuration file
        :param str contents: The Base64 encoding of the file contents.
        :param str file_name: The name of the configuration file.
        :param str type: The type of configuration file.
        """
        pulumi.set(__self__, "contents", contents)
        pulumi.set(__self__, "file_name", file_name)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def contents(self) -> str:
        """
        The Base64 encoding of the file contents.
        """
        return pulumi.get(self, "contents")

    @property
    @pulumi.getter(name="fileName")
    def file_name(self) -> str:
        """
        The name of the configuration file.
        """
        return pulumi.get(self, "file_name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of configuration file.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class StaticSiteLinkedBackendResponse(dict):
    """
    Static Site Linked Backend ARM resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdOn":
            suggest = "created_on"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "backendResourceId":
            suggest = "backend_resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StaticSiteLinkedBackendResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StaticSiteLinkedBackendResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StaticSiteLinkedBackendResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_on: str,
                 provisioning_state: str,
                 backend_resource_id: Optional[str] = None,
                 region: Optional[str] = None):
        """
        Static Site Linked Backend ARM resource.
        :param str created_on: The date and time on which the backend was linked to the static site.
        :param str provisioning_state: The provisioning state of the linking process.
        :param str backend_resource_id: The resource id of the backend linked to the static site
        :param str region: The region of the backend linked to the static site
        """
        pulumi.set(__self__, "created_on", created_on)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if backend_resource_id is not None:
            pulumi.set(__self__, "backend_resource_id", backend_resource_id)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> str:
        """
        The date and time on which the backend was linked to the static site.
        """
        return pulumi.get(self, "created_on")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the linking process.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="backendResourceId")
    def backend_resource_id(self) -> Optional[str]:
        """
        The resource id of the backend linked to the static site
        """
        return pulumi.get(self, "backend_resource_id")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        """
        The region of the backend linked to the static site
        """
        return pulumi.get(self, "region")


@pulumi.output_type
class StaticSiteTemplateOptionsResponse(dict):
    """
    Template Options for the static site.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isPrivate":
            suggest = "is_private"
        elif key == "repositoryName":
            suggest = "repository_name"
        elif key == "templateRepositoryUrl":
            suggest = "template_repository_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StaticSiteTemplateOptionsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StaticSiteTemplateOptionsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StaticSiteTemplateOptionsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 description: Optional[str] = None,
                 is_private: Optional[bool] = None,
                 owner: Optional[str] = None,
                 repository_name: Optional[str] = None,
                 template_repository_url: Optional[str] = None):
        """
        Template Options for the static site.
        :param str description: Description of the newly generated repository.
        :param bool is_private: Whether or not the newly generated repository is a private repository. Defaults to false (i.e. public).
        :param str owner: Owner of the newly generated repository.
        :param str repository_name: Name of the newly generated repository.
        :param str template_repository_url: URL of the template repository. The newly generated repository will be based on this one.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if is_private is not None:
            pulumi.set(__self__, "is_private", is_private)
        if owner is not None:
            pulumi.set(__self__, "owner", owner)
        if repository_name is not None:
            pulumi.set(__self__, "repository_name", repository_name)
        if template_repository_url is not None:
            pulumi.set(__self__, "template_repository_url", template_repository_url)

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Description of the newly generated repository.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="isPrivate")
    def is_private(self) -> Optional[bool]:
        """
        Whether or not the newly generated repository is a private repository. Defaults to false (i.e. public).
        """
        return pulumi.get(self, "is_private")

    @property
    @pulumi.getter
    def owner(self) -> Optional[str]:
        """
        Owner of the newly generated repository.
        """
        return pulumi.get(self, "owner")

    @property
    @pulumi.getter(name="repositoryName")
    def repository_name(self) -> Optional[str]:
        """
        Name of the newly generated repository.
        """
        return pulumi.get(self, "repository_name")

    @property
    @pulumi.getter(name="templateRepositoryUrl")
    def template_repository_url(self) -> Optional[str]:
        """
        URL of the template repository. The newly generated repository will be based on this one.
        """
        return pulumi.get(self, "template_repository_url")


@pulumi.output_type
class StaticSiteUserARMResourceResponse(dict):
    """
    Static Site User ARM resource.
    """
    def __init__(__self__, *,
                 display_name: str,
                 id: str,
                 name: str,
                 provider: str,
                 type: str,
                 user_id: str,
                 kind: Optional[str] = None,
                 roles: Optional[str] = None):
        """
        Static Site User ARM resource.
        :param str display_name: The display name for the static site user.
        :param str id: Resource Id.
        :param str name: Resource Name.
        :param str provider: The identity provider for the static site user.
        :param str type: Resource type.
        :param str user_id: The user id for the static site user.
        :param str kind: Kind of resource.
        :param str roles: The roles for the static site user, in free-form string format
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "provider", provider)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "user_id", user_id)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if roles is not None:
            pulumi.set(__self__, "roles", roles)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The display name for the static site user.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Resource Id.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Resource Name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def provider(self) -> str:
        """
        The identity provider for the static site user.
        """
        return pulumi.get(self, "provider")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Resource type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> str:
        """
        The user id for the static site user.
        """
        return pulumi.get(self, "user_id")

    @property
    @pulumi.getter
    def kind(self) -> Optional[str]:
        """
        Kind of resource.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def roles(self) -> Optional[str]:
        """
        The roles for the static site user, in free-form string format
        """
        return pulumi.get(self, "roles")


@pulumi.output_type
class StaticSiteUserProvidedFunctionAppResponse(dict):
    """
    A static site user provided function.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdOn":
            suggest = "created_on"
        elif key == "functionAppRegion":
            suggest = "function_app_region"
        elif key == "functionAppResourceId":
            suggest = "function_app_resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StaticSiteUserProvidedFunctionAppResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StaticSiteUserProvidedFunctionAppResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StaticSiteUserProvidedFunctionAppResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_on: str,
                 id: str,
                 name: str,
                 type: str,
                 function_app_region: Optional[str] = None,
                 function_app_resource_id: Optional[str] = None,
                 kind: Optional[str] = None):
        """
        A static site user provided function.
        :param str created_on: The date and time on which the function app was registered with the static site.
        :param str id: Resource Id.
        :param str name: Resource Name.
        :param str type: Resource type.
        :param str function_app_region: The region of the function app registered with the static site
        :param str function_app_resource_id: The resource id of the function app registered with the static site
        :param str kind: Kind of resource.
        """
        pulumi.set(__self__, "created_on", created_on)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        if function_app_region is not None:
            pulumi.set(__self__, "function_app_region", function_app_region)
        if function_app_resource_id is not None:
            pulumi.set(__self__, "function_app_resource_id", function_app_resource_id)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)

    @property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> str:
        """
        The date and time on which the function app was registered with the static site.
        """
        return pulumi.get(self, "created_on")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Resource Id.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Resource Name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Resource type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="functionAppRegion")
    def function_app_region(self) -> Optional[str]:
        """
        The region of the function app registered with the static site
        """
        return pulumi.get(self, "function_app_region")

    @property
    @pulumi.getter(name="functionAppResourceId")
    def function_app_resource_id(self) -> Optional[str]:
        """
        The resource id of the function app registered with the static site
        """
        return pulumi.get(self, "function_app_resource_id")

    @property
    @pulumi.getter
    def kind(self) -> Optional[str]:
        """
        Kind of resource.
        """
        return pulumi.get(self, "kind")


@pulumi.output_type
class StatusCodesBasedTriggerResponse(dict):
    """
    Trigger based on status code.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "subStatus":
            suggest = "sub_status"
        elif key == "timeInterval":
            suggest = "time_interval"
        elif key == "win32Status":
            suggest = "win32_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StatusCodesBasedTriggerResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StatusCodesBasedTriggerResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StatusCodesBasedTriggerResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 count: Optional[int] = None,
                 path: Optional[str] = None,
                 status: Optional[int] = None,
                 sub_status: Optional[int] = None,
                 time_interval: Optional[str] = None,
                 win32_status: Optional[int] = None):
        """
        Trigger based on status code.
        :param int count: Request Count.
        :param str path: Request Path
        :param int status: HTTP status code.
        :param int sub_status: Request Sub Status.
        :param str time_interval: Time interval.
        :param int win32_status: Win32 error code.
        """
        if count is not None:
            pulumi.set(__self__, "count", count)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if sub_status is not None:
            pulumi.set(__self__, "sub_status", sub_status)
        if time_interval is not None:
            pulumi.set(__self__, "time_interval", time_interval)
        if win32_status is not None:
            pulumi.set(__self__, "win32_status", win32_status)

    @property
    @pulumi.getter
    def count(self) -> Optional[int]:
        """
        Request Count.
        """
        return pulumi.get(self, "count")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        Request Path
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def status(self) -> Optional[int]:
        """
        HTTP status code.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="subStatus")
    def sub_status(self) -> Optional[int]:
        """
        Request Sub Status.
        """
        return pulumi.get(self, "sub_status")

    @property
    @pulumi.getter(name="timeInterval")
    def time_interval(self) -> Optional[str]:
        """
        Time interval.
        """
        return pulumi.get(self, "time_interval")

    @property
    @pulumi.getter(name="win32Status")
    def win32_status(self) -> Optional[int]:
        """
        Win32 error code.
        """
        return pulumi.get(self, "win32_status")


@pulumi.output_type
class StatusCodesRangeBasedTriggerResponse(dict):
    """
    Trigger based on range of status codes.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "statusCodes":
            suggest = "status_codes"
        elif key == "timeInterval":
            suggest = "time_interval"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StatusCodesRangeBasedTriggerResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StatusCodesRangeBasedTriggerResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StatusCodesRangeBasedTriggerResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 count: Optional[int] = None,
                 path: Optional[str] = None,
                 status_codes: Optional[str] = None,
                 time_interval: Optional[str] = None):
        """
        Trigger based on range of status codes.
        :param int count: Request Count.
        :param str status_codes: HTTP status code.
        :param str time_interval: Time interval.
        """
        if count is not None:
            pulumi.set(__self__, "count", count)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if status_codes is not None:
            pulumi.set(__self__, "status_codes", status_codes)
        if time_interval is not None:
            pulumi.set(__self__, "time_interval", time_interval)

    @property
    @pulumi.getter
    def count(self) -> Optional[int]:
        """
        Request Count.
        """
        return pulumi.get(self, "count")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="statusCodes")
    def status_codes(self) -> Optional[str]:
        """
        HTTP status code.
        """
        return pulumi.get(self, "status_codes")

    @property
    @pulumi.getter(name="timeInterval")
    def time_interval(self) -> Optional[str]:
        """
        Time interval.
        """
        return pulumi.get(self, "time_interval")


@pulumi.output_type
class TemplateResponse(dict):
    """
    Container App versioned application definition.
    Defines the desired state of an immutable revision.
    Any changes to this section Will result in a new revision being created
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "revisionSuffix":
            suggest = "revision_suffix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TemplateResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TemplateResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TemplateResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 containers: Optional[Sequence['outputs.ContainerResponse']] = None,
                 dapr: Optional['outputs.DaprResponse'] = None,
                 revision_suffix: Optional[str] = None,
                 scale: Optional['outputs.ScaleResponse'] = None):
        """
        Container App versioned application definition.
        Defines the desired state of an immutable revision.
        Any changes to this section Will result in a new revision being created
        :param Sequence['ContainerResponse'] containers: List of container definitions for the Container App.
        :param 'DaprResponse' dapr: Dapr configuration for the Container App.
        :param str revision_suffix: User friendly suffix that is appended to the revision name
        :param 'ScaleResponse' scale: Scaling properties for the Container App.
        """
        if containers is not None:
            pulumi.set(__self__, "containers", containers)
        if dapr is not None:
            pulumi.set(__self__, "dapr", dapr)
        if revision_suffix is not None:
            pulumi.set(__self__, "revision_suffix", revision_suffix)
        if scale is not None:
            pulumi.set(__self__, "scale", scale)

    @property
    @pulumi.getter
    def containers(self) -> Optional[Sequence['outputs.ContainerResponse']]:
        """
        List of container definitions for the Container App.
        """
        return pulumi.get(self, "containers")

    @property
    @pulumi.getter
    def dapr(self) -> Optional['outputs.DaprResponse']:
        """
        Dapr configuration for the Container App.
        """
        return pulumi.get(self, "dapr")

    @property
    @pulumi.getter(name="revisionSuffix")
    def revision_suffix(self) -> Optional[str]:
        """
        User friendly suffix that is appended to the revision name
        """
        return pulumi.get(self, "revision_suffix")

    @property
    @pulumi.getter
    def scale(self) -> Optional['outputs.ScaleResponse']:
        """
        Scaling properties for the Container App.
        """
        return pulumi.get(self, "scale")


@pulumi.output_type
class TrafficWeightResponse(dict):
    """
    Traffic weight assigned to a revision
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "latestRevision":
            suggest = "latest_revision"
        elif key == "revisionName":
            suggest = "revision_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TrafficWeightResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TrafficWeightResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TrafficWeightResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 latest_revision: Optional[bool] = None,
                 revision_name: Optional[str] = None,
                 weight: Optional[int] = None):
        """
        Traffic weight assigned to a revision
        :param bool latest_revision: Indicates that the traffic weight belongs to a latest stable revision
        :param str revision_name: Name of a revision
        :param int weight: Traffic weight assigned to a revision
        """
        if latest_revision is None:
            latest_revision = False
        if latest_revision is not None:
            pulumi.set(__self__, "latest_revision", latest_revision)
        if revision_name is not None:
            pulumi.set(__self__, "revision_name", revision_name)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter(name="latestRevision")
    def latest_revision(self) -> Optional[bool]:
        """
        Indicates that the traffic weight belongs to a latest stable revision
        """
        return pulumi.get(self, "latest_revision")

    @property
    @pulumi.getter(name="revisionName")
    def revision_name(self) -> Optional[str]:
        """
        Name of a revision
        """
        return pulumi.get(self, "revision_name")

    @property
    @pulumi.getter
    def weight(self) -> Optional[int]:
        """
        Traffic weight assigned to a revision
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class UserAssignedIdentityResponse(dict):
    """
    User Assigned identity.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "principalId":
            suggest = "principal_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserAssignedIdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserAssignedIdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserAssignedIdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: str,
                 principal_id: str):
        """
        User Assigned identity.
        :param str client_id: Client Id of user assigned identity
        :param str principal_id: Principal Id of user assigned identity
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "principal_id", principal_id)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> str:
        """
        Client Id of user assigned identity
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        Principal Id of user assigned identity
        """
        return pulumi.get(self, "principal_id")


@pulumi.output_type
class VirtualApplicationResponse(dict):
    """
    Virtual application in an app.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "physicalPath":
            suggest = "physical_path"
        elif key == "preloadEnabled":
            suggest = "preload_enabled"
        elif key == "virtualDirectories":
            suggest = "virtual_directories"
        elif key == "virtualPath":
            suggest = "virtual_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualApplicationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualApplicationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualApplicationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 physical_path: Optional[str] = None,
                 preload_enabled: Optional[bool] = None,
                 virtual_directories: Optional[Sequence['outputs.VirtualDirectoryResponse']] = None,
                 virtual_path: Optional[str] = None):
        """
        Virtual application in an app.
        :param str physical_path: Physical path.
        :param bool preload_enabled: <code>true</code> if preloading is enabled; otherwise, <code>false</code>.
        :param Sequence['VirtualDirectoryResponse'] virtual_directories: Virtual directories for virtual application.
        :param str virtual_path: Virtual path.
        """
        if physical_path is not None:
            pulumi.set(__self__, "physical_path", physical_path)
        if preload_enabled is not None:
            pulumi.set(__self__, "preload_enabled", preload_enabled)
        if virtual_directories is not None:
            pulumi.set(__self__, "virtual_directories", virtual_directories)
        if virtual_path is not None:
            pulumi.set(__self__, "virtual_path", virtual_path)

    @property
    @pulumi.getter(name="physicalPath")
    def physical_path(self) -> Optional[str]:
        """
        Physical path.
        """
        return pulumi.get(self, "physical_path")

    @property
    @pulumi.getter(name="preloadEnabled")
    def preload_enabled(self) -> Optional[bool]:
        """
        <code>true</code> if preloading is enabled; otherwise, <code>false</code>.
        """
        return pulumi.get(self, "preload_enabled")

    @property
    @pulumi.getter(name="virtualDirectories")
    def virtual_directories(self) -> Optional[Sequence['outputs.VirtualDirectoryResponse']]:
        """
        Virtual directories for virtual application.
        """
        return pulumi.get(self, "virtual_directories")

    @property
    @pulumi.getter(name="virtualPath")
    def virtual_path(self) -> Optional[str]:
        """
        Virtual path.
        """
        return pulumi.get(self, "virtual_path")


@pulumi.output_type
class VirtualDirectoryResponse(dict):
    """
    Directory for virtual application.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "physicalPath":
            suggest = "physical_path"
        elif key == "virtualPath":
            suggest = "virtual_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualDirectoryResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualDirectoryResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualDirectoryResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 physical_path: Optional[str] = None,
                 virtual_path: Optional[str] = None):
        """
        Directory for virtual application.
        :param str physical_path: Physical path.
        :param str virtual_path: Path to virtual application.
        """
        if physical_path is not None:
            pulumi.set(__self__, "physical_path", physical_path)
        if virtual_path is not None:
            pulumi.set(__self__, "virtual_path", virtual_path)

    @property
    @pulumi.getter(name="physicalPath")
    def physical_path(self) -> Optional[str]:
        """
        Physical path.
        """
        return pulumi.get(self, "physical_path")

    @property
    @pulumi.getter(name="virtualPath")
    def virtual_path(self) -> Optional[str]:
        """
        Path to virtual application.
        """
        return pulumi.get(self, "virtual_path")


@pulumi.output_type
class VirtualNetworkProfileResponse(dict):
    """
    Specification for using a Virtual Network.
    """
    def __init__(__self__, *,
                 id: str,
                 name: str,
                 type: str,
                 subnet: Optional[str] = None):
        """
        Specification for using a Virtual Network.
        :param str id: Resource id of the Virtual Network.
        :param str name: Name of the Virtual Network (read-only).
        :param str type: Resource type of the Virtual Network (read-only).
        :param str subnet: Subnet within the Virtual Network.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Resource id of the Virtual Network.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the Virtual Network (read-only).
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Resource type of the Virtual Network (read-only).
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def subnet(self) -> Optional[str]:
        """
        Subnet within the Virtual Network.
        """
        return pulumi.get(self, "subnet")


@pulumi.output_type
class VnetRouteResponse(dict):
    """
    Virtual Network route contract used to pass routing information for a Virtual Network.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endAddress":
            suggest = "end_address"
        elif key == "routeType":
            suggest = "route_type"
        elif key == "startAddress":
            suggest = "start_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VnetRouteResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VnetRouteResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VnetRouteResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 name: str,
                 type: str,
                 end_address: Optional[str] = None,
                 kind: Optional[str] = None,
                 route_type: Optional[str] = None,
                 start_address: Optional[str] = None):
        """
        Virtual Network route contract used to pass routing information for a Virtual Network.
        :param str id: Resource Id.
        :param str name: Resource Name.
        :param str type: Resource type.
        :param str end_address: The ending address for this route. If the start address is specified in CIDR notation, this must be omitted.
        :param str kind: Kind of resource.
        :param str route_type: The type of route this is:
               DEFAULT - By default, every app has routes to the local address ranges specified by RFC1918
               INHERITED - Routes inherited from the real Virtual Network routes
               STATIC - Static route set on the app only
               
               These values will be used for syncing an app's routes with those from a Virtual Network.
        :param str start_address: The starting address for this route. This may also include a CIDR notation, in which case the end address must not be specified.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        if end_address is not None:
            pulumi.set(__self__, "end_address", end_address)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if route_type is not None:
            pulumi.set(__self__, "route_type", route_type)
        if start_address is not None:
            pulumi.set(__self__, "start_address", start_address)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Resource Id.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Resource Name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Resource type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="endAddress")
    def end_address(self) -> Optional[str]:
        """
        The ending address for this route. If the start address is specified in CIDR notation, this must be omitted.
        """
        return pulumi.get(self, "end_address")

    @property
    @pulumi.getter
    def kind(self) -> Optional[str]:
        """
        Kind of resource.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="routeType")
    def route_type(self) -> Optional[str]:
        """
        The type of route this is:
        DEFAULT - By default, every app has routes to the local address ranges specified by RFC1918
        INHERITED - Routes inherited from the real Virtual Network routes
        STATIC - Static route set on the app only

        These values will be used for syncing an app's routes with those from a Virtual Network.
        """
        return pulumi.get(self, "route_type")

    @property
    @pulumi.getter(name="startAddress")
    def start_address(self) -> Optional[str]:
        """
        The starting address for this route. This may also include a CIDR notation, in which case the end address must not be specified.
        """
        return pulumi.get(self, "start_address")


@pulumi.output_type
class WorkflowEnvelopeResponseProperties(dict):
    """
    Additional workflow properties.
    """
    def __init__(__self__, *,
                 files: Optional[Mapping[str, Any]] = None,
                 flow_state: Optional[str] = None,
                 health: Optional['outputs.WorkflowHealthResponse'] = None):
        """
        Additional workflow properties.
        :param Mapping[str, Any] files: Gets or sets the files.
        :param str flow_state: Gets or sets the state of the workflow.
        :param 'WorkflowHealthResponse' health: Gets or sets workflow health.
        """
        if files is not None:
            pulumi.set(__self__, "files", files)
        if flow_state is not None:
            pulumi.set(__self__, "flow_state", flow_state)
        if health is not None:
            pulumi.set(__self__, "health", health)

    @property
    @pulumi.getter
    def files(self) -> Optional[Mapping[str, Any]]:
        """
        Gets or sets the files.
        """
        return pulumi.get(self, "files")

    @property
    @pulumi.getter(name="flowState")
    def flow_state(self) -> Optional[str]:
        """
        Gets or sets the state of the workflow.
        """
        return pulumi.get(self, "flow_state")

    @property
    @pulumi.getter
    def health(self) -> Optional['outputs.WorkflowHealthResponse']:
        """
        Gets or sets workflow health.
        """
        return pulumi.get(self, "health")


@pulumi.output_type
class WorkflowHealthResponse(dict):
    """
    Represents the workflow health.
    """
    def __init__(__self__, *,
                 state: str,
                 error: Optional['outputs.ErrorEntityResponse'] = None):
        """
        Represents the workflow health.
        :param str state: Gets or sets the workflow health state.
        :param 'ErrorEntityResponse' error: Gets or sets the workflow error.
        """
        pulumi.set(__self__, "state", state)
        if error is not None:
            pulumi.set(__self__, "error", error)

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Gets or sets the workflow health state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def error(self) -> Optional['outputs.ErrorEntityResponse']:
        """
        Gets or sets the workflow error.
        """
        return pulumi.get(self, "error")


@pulumi.output_type
class WorkflowTriggerListCallbackUrlQueriesResponse(dict):
    """
    Gets the workflow trigger callback URL query parameters.
    """
    def __init__(__self__, *,
                 api_version: Optional[str] = None,
                 se: Optional[str] = None,
                 sig: Optional[str] = None,
                 sp: Optional[str] = None,
                 sv: Optional[str] = None):
        """
        Gets the workflow trigger callback URL query parameters.
        :param str api_version: The api version.
        :param str se: The SAS timestamp.
        :param str sig: The SAS signature.
        :param str sp: The SAS permissions.
        :param str sv: The SAS version.
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", api_version)
        if se is not None:
            pulumi.set(__self__, "se", se)
        if sig is not None:
            pulumi.set(__self__, "sig", sig)
        if sp is not None:
            pulumi.set(__self__, "sp", sp)
        if sv is not None:
            pulumi.set(__self__, "sv", sv)

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[str]:
        """
        The api version.
        """
        return pulumi.get(self, "api_version")

    @property
    @pulumi.getter
    def se(self) -> Optional[str]:
        """
        The SAS timestamp.
        """
        return pulumi.get(self, "se")

    @property
    @pulumi.getter
    def sig(self) -> Optional[str]:
        """
        The SAS signature.
        """
        return pulumi.get(self, "sig")

    @property
    @pulumi.getter
    def sp(self) -> Optional[str]:
        """
        The SAS permissions.
        """
        return pulumi.get(self, "sp")

    @property
    @pulumi.getter
    def sv(self) -> Optional[str]:
        """
        The SAS version.
        """
        return pulumi.get(self, "sv")


