# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'AgentPropertiesResponseErrorDetails',
    'AzureStorageBlobContainerEndpointPropertiesResponse',
    'NfsMountEndpointPropertiesResponse',
    'SystemDataResponse',
]

@pulumi.output_type
class AgentPropertiesResponseErrorDetails(dict):
    def __init__(__self__, *,
                 code: Optional[str] = None,
                 message: Optional[str] = None):
        """
        :param str code: Error code reported by Agent
        :param str message: Expanded description of reported error code
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if message is not None:
            pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter
    def code(self) -> Optional[str]:
        """
        Error code reported by Agent
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        """
        Expanded description of reported error code
        """
        return pulumi.get(self, "message")


@pulumi.output_type
class AzureStorageBlobContainerEndpointPropertiesResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "blobContainerName":
            suggest = "blob_container_name"
        elif key == "endpointType":
            suggest = "endpoint_type"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "storageAccountResourceId":
            suggest = "storage_account_resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureStorageBlobContainerEndpointPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureStorageBlobContainerEndpointPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureStorageBlobContainerEndpointPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 blob_container_name: str,
                 endpoint_type: str,
                 provisioning_state: str,
                 storage_account_resource_id: str,
                 description: Optional[str] = None):
        """
        :param str blob_container_name: The name of the Storage blob container that is the target destination.
        :param str endpoint_type: The Endpoint resource type.
               Expected value is 'AzureStorageBlobContainer'.
        :param str provisioning_state: The provisioning state of this resource.
        :param str storage_account_resource_id: The Azure Resource ID of the storage account that is the target destination.
        :param str description: A description for the Endpoint.
        """
        pulumi.set(__self__, "blob_container_name", blob_container_name)
        pulumi.set(__self__, "endpoint_type", 'AzureStorageBlobContainer')
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "storage_account_resource_id", storage_account_resource_id)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter(name="blobContainerName")
    def blob_container_name(self) -> str:
        """
        The name of the Storage blob container that is the target destination.
        """
        return pulumi.get(self, "blob_container_name")

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> str:
        """
        The Endpoint resource type.
        Expected value is 'AzureStorageBlobContainer'.
        """
        return pulumi.get(self, "endpoint_type")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of this resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="storageAccountResourceId")
    def storage_account_resource_id(self) -> str:
        """
        The Azure Resource ID of the storage account that is the target destination.
        """
        return pulumi.get(self, "storage_account_resource_id")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A description for the Endpoint.
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class NfsMountEndpointPropertiesResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endpointType":
            suggest = "endpoint_type"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "nfsVersion":
            suggest = "nfs_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NfsMountEndpointPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NfsMountEndpointPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NfsMountEndpointPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint_type: str,
                 export: str,
                 host: str,
                 provisioning_state: str,
                 description: Optional[str] = None,
                 nfs_version: Optional[str] = None):
        """
        :param str endpoint_type: The Endpoint resource type.
               Expected value is 'NfsMount'.
        :param str export: The directory being exported from the server.
        :param str host: The host name or IP address of the server exporting the file system.
        :param str provisioning_state: The provisioning state of this resource.
        :param str description: A description for the Endpoint.
        :param str nfs_version: The NFS protocol version.
        """
        pulumi.set(__self__, "endpoint_type", 'NfsMount')
        pulumi.set(__self__, "export", export)
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if nfs_version is not None:
            pulumi.set(__self__, "nfs_version", nfs_version)

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> str:
        """
        The Endpoint resource type.
        Expected value is 'NfsMount'.
        """
        return pulumi.get(self, "endpoint_type")

    @property
    @pulumi.getter
    def export(self) -> str:
        """
        The directory being exported from the server.
        """
        return pulumi.get(self, "export")

    @property
    @pulumi.getter
    def host(self) -> str:
        """
        The host name or IP address of the server exporting the file system.
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of this resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A description for the Endpoint.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="nfsVersion")
    def nfs_version(self) -> Optional[str]:
        """
        The NFS protocol version.
        """
        return pulumi.get(self, "nfs_version")


@pulumi.output_type
class SystemDataResponse(dict):
    """
    Metadata pertaining to creation and last modification of the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "createdBy":
            suggest = "created_by"
        elif key == "createdByType":
            suggest = "created_by_type"
        elif key == "lastModifiedAt":
            suggest = "last_modified_at"
        elif key == "lastModifiedBy":
            suggest = "last_modified_by"
        elif key == "lastModifiedByType":
            suggest = "last_modified_by_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SystemDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: Optional[str] = None,
                 created_by: Optional[str] = None,
                 created_by_type: Optional[str] = None,
                 last_modified_at: Optional[str] = None,
                 last_modified_by: Optional[str] = None,
                 last_modified_by_type: Optional[str] = None):
        """
        Metadata pertaining to creation and last modification of the resource.
        :param str created_at: The timestamp of resource creation (UTC).
        :param str created_by: The identity that created the resource.
        :param str created_by_type: The type of identity that created the resource.
        :param str last_modified_at: The timestamp of resource last modification (UTC)
        :param str last_modified_by: The identity that last modified the resource.
        :param str last_modified_by_type: The type of identity that last modified the resource.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_by_type is not None:
            pulumi.set(__self__, "created_by_type", created_by_type)
        if last_modified_at is not None:
            pulumi.set(__self__, "last_modified_at", last_modified_at)
        if last_modified_by is not None:
            pulumi.set(__self__, "last_modified_by", last_modified_by)
        if last_modified_by_type is not None:
            pulumi.set(__self__, "last_modified_by_type", last_modified_by_type)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The timestamp of resource creation (UTC).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[str]:
        """
        The identity that created the resource.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="createdByType")
    def created_by_type(self) -> Optional[str]:
        """
        The type of identity that created the resource.
        """
        return pulumi.get(self, "created_by_type")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> Optional[str]:
        """
        The timestamp of resource last modification (UTC)
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> Optional[str]:
        """
        The identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by")

    @property
    @pulumi.getter(name="lastModifiedByType")
    def last_modified_by_type(self) -> Optional[str]:
        """
        The type of identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by_type")


