# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'ActorResponse',
    'EncryptionPropertyResponse',
    'EventContentResponse',
    'EventRequestMessageResponse',
    'EventResponse',
    'EventResponseMessageResponse',
    'ExportPolicyResponse',
    'IPRuleResponse',
    'IdentityPropertiesResponse',
    'KeyVaultPropertiesResponse',
    'NetworkRuleSetResponse',
    'PoliciesResponse',
    'PrivateEndpointConnectionResponse',
    'PrivateEndpointResponse',
    'PrivateLinkServiceConnectionStateResponse',
    'QuarantinePolicyResponse',
    'RegistryPasswordResponse',
    'RequestResponse',
    'RetentionPolicyResponse',
    'SkuResponse',
    'SourceResponse',
    'StatusResponse',
    'SystemDataResponse',
    'TargetResponse',
    'TokenCertificateResponse',
    'TokenCredentialsPropertiesResponse',
    'TokenPasswordResponse',
    'TrustPolicyResponse',
    'UserIdentityPropertiesResponse',
]

@pulumi.output_type
class ActorResponse(dict):
    """
    The agent that initiated the event. For most situations, this could be from the authorization context of the request.
    """
    def __init__(__self__, *,
                 name: Optional[str] = None):
        """
        The agent that initiated the event. For most situations, this could be from the authorization context of the request.
        :param str name: The subject or username associated with the request context that generated the event.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The subject or username associated with the request context that generated the event.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class EncryptionPropertyResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyVaultProperties":
            suggest = "key_vault_properties"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EncryptionPropertyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EncryptionPropertyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EncryptionPropertyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_vault_properties: Optional['outputs.KeyVaultPropertiesResponse'] = None,
                 status: Optional[str] = None):
        """
        :param 'KeyVaultPropertiesResponse' key_vault_properties: Key vault properties.
        :param str status: Indicates whether or not the encryption is enabled for container registry.
        """
        if key_vault_properties is not None:
            pulumi.set(__self__, "key_vault_properties", key_vault_properties)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="keyVaultProperties")
    def key_vault_properties(self) -> Optional['outputs.KeyVaultPropertiesResponse']:
        """
        Key vault properties.
        """
        return pulumi.get(self, "key_vault_properties")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        Indicates whether or not the encryption is enabled for container registry.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class EventContentResponse(dict):
    """
    The content of the event request message.
    """
    def __init__(__self__, *,
                 action: Optional[str] = None,
                 actor: Optional['outputs.ActorResponse'] = None,
                 id: Optional[str] = None,
                 request: Optional['outputs.RequestResponse'] = None,
                 source: Optional['outputs.SourceResponse'] = None,
                 target: Optional['outputs.TargetResponse'] = None,
                 timestamp: Optional[str] = None):
        """
        The content of the event request message.
        :param str action: The action that encompasses the provided event.
        :param 'ActorResponse' actor: The agent that initiated the event. For most situations, this could be from the authorization context of the request.
        :param str id: The event ID.
        :param 'RequestResponse' request: The request that generated the event.
        :param 'SourceResponse' source: The registry node that generated the event. Put differently, while the actor initiates the event, the source generates it.
        :param 'TargetResponse' target: The target of the event.
        :param str timestamp: The time at which the event occurred.
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if actor is not None:
            pulumi.set(__self__, "actor", actor)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if request is not None:
            pulumi.set(__self__, "request", request)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if target is not None:
            pulumi.set(__self__, "target", target)
        if timestamp is not None:
            pulumi.set(__self__, "timestamp", timestamp)

    @property
    @pulumi.getter
    def action(self) -> Optional[str]:
        """
        The action that encompasses the provided event.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def actor(self) -> Optional['outputs.ActorResponse']:
        """
        The agent that initiated the event. For most situations, this could be from the authorization context of the request.
        """
        return pulumi.get(self, "actor")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The event ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def request(self) -> Optional['outputs.RequestResponse']:
        """
        The request that generated the event.
        """
        return pulumi.get(self, "request")

    @property
    @pulumi.getter
    def source(self) -> Optional['outputs.SourceResponse']:
        """
        The registry node that generated the event. Put differently, while the actor initiates the event, the source generates it.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter
    def target(self) -> Optional['outputs.TargetResponse']:
        """
        The target of the event.
        """
        return pulumi.get(self, "target")

    @property
    @pulumi.getter
    def timestamp(self) -> Optional[str]:
        """
        The time at which the event occurred.
        """
        return pulumi.get(self, "timestamp")


@pulumi.output_type
class EventRequestMessageResponse(dict):
    """
    The event request message sent to the service URI.
    """
    def __init__(__self__, *,
                 content: Optional['outputs.EventContentResponse'] = None,
                 headers: Optional[Mapping[str, str]] = None,
                 method: Optional[str] = None,
                 request_uri: Optional[str] = None,
                 version: Optional[str] = None):
        """
        The event request message sent to the service URI.
        :param 'EventContentResponse' content: The content of the event request message.
        :param Mapping[str, str] headers: The headers of the event request message.
        :param str method: The HTTP method used to send the event request message.
        :param str request_uri: The URI used to send the event request message.
        :param str version: The HTTP message version.
        """
        if content is not None:
            pulumi.set(__self__, "content", content)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if method is not None:
            pulumi.set(__self__, "method", method)
        if request_uri is not None:
            pulumi.set(__self__, "request_uri", request_uri)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def content(self) -> Optional['outputs.EventContentResponse']:
        """
        The content of the event request message.
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter
    def headers(self) -> Optional[Mapping[str, str]]:
        """
        The headers of the event request message.
        """
        return pulumi.get(self, "headers")

    @property
    @pulumi.getter
    def method(self) -> Optional[str]:
        """
        The HTTP method used to send the event request message.
        """
        return pulumi.get(self, "method")

    @property
    @pulumi.getter(name="requestUri")
    def request_uri(self) -> Optional[str]:
        """
        The URI used to send the event request message.
        """
        return pulumi.get(self, "request_uri")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        The HTTP message version.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class EventResponse(dict):
    """
    The event for a webhook.
    """
    def __init__(__self__, *,
                 event_request_message: Optional['outputs.EventRequestMessageResponse'] = None,
                 event_response_message: Optional['outputs.EventResponseMessageResponse'] = None,
                 id: Optional[str] = None):
        """
        The event for a webhook.
        :param 'EventRequestMessageResponse' event_request_message: The event request message sent to the service URI.
        :param 'EventResponseMessageResponse' event_response_message: The event response message received from the service URI.
        :param str id: The event ID.
        """
        if event_request_message is not None:
            pulumi.set(__self__, "event_request_message", event_request_message)
        if event_response_message is not None:
            pulumi.set(__self__, "event_response_message", event_response_message)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter(name="eventRequestMessage")
    def event_request_message(self) -> Optional['outputs.EventRequestMessageResponse']:
        """
        The event request message sent to the service URI.
        """
        return pulumi.get(self, "event_request_message")

    @property
    @pulumi.getter(name="eventResponseMessage")
    def event_response_message(self) -> Optional['outputs.EventResponseMessageResponse']:
        """
        The event response message received from the service URI.
        """
        return pulumi.get(self, "event_response_message")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The event ID.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class EventResponseMessageResponse(dict):
    """
    The event response message received from the service URI.
    """
    def __init__(__self__, *,
                 content: Optional[str] = None,
                 headers: Optional[Mapping[str, str]] = None,
                 reason_phrase: Optional[str] = None,
                 status_code: Optional[str] = None,
                 version: Optional[str] = None):
        """
        The event response message received from the service URI.
        :param str content: The content of the event response message.
        :param Mapping[str, str] headers: The headers of the event response message.
        :param str reason_phrase: The reason phrase of the event response message.
        :param str status_code: The status code of the event response message.
        :param str version: The HTTP message version.
        """
        if content is not None:
            pulumi.set(__self__, "content", content)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if reason_phrase is not None:
            pulumi.set(__self__, "reason_phrase", reason_phrase)
        if status_code is not None:
            pulumi.set(__self__, "status_code", status_code)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def content(self) -> Optional[str]:
        """
        The content of the event response message.
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter
    def headers(self) -> Optional[Mapping[str, str]]:
        """
        The headers of the event response message.
        """
        return pulumi.get(self, "headers")

    @property
    @pulumi.getter(name="reasonPhrase")
    def reason_phrase(self) -> Optional[str]:
        """
        The reason phrase of the event response message.
        """
        return pulumi.get(self, "reason_phrase")

    @property
    @pulumi.getter(name="statusCode")
    def status_code(self) -> Optional[str]:
        """
        The status code of the event response message.
        """
        return pulumi.get(self, "status_code")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        The HTTP message version.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class ExportPolicyResponse(dict):
    """
    The export policy for a container registry.
    """
    def __init__(__self__, *,
                 status: Optional[str] = None):
        """
        The export policy for a container registry.
        :param str status: The value that indicates whether the policy is enabled or not.
        """
        if status is None:
            status = 'enabled'
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        The value that indicates whether the policy is enabled or not.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class IPRuleResponse(dict):
    """
    IP rule with specific IP or IP range in CIDR format.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "iPAddressOrRange":
            suggest = "i_p_address_or_range"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IPRuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IPRuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IPRuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 i_p_address_or_range: str,
                 action: Optional[str] = None):
        """
        IP rule with specific IP or IP range in CIDR format.
        :param str i_p_address_or_range: Specifies the IP or IP range in CIDR format. Only IPV4 address is allowed.
        :param str action: The action of IP ACL rule.
        """
        pulumi.set(__self__, "i_p_address_or_range", i_p_address_or_range)
        if action is None:
            action = 'Allow'
        if action is not None:
            pulumi.set(__self__, "action", action)

    @property
    @pulumi.getter(name="iPAddressOrRange")
    def i_p_address_or_range(self) -> str:
        """
        Specifies the IP or IP range in CIDR format. Only IPV4 address is allowed.
        """
        return pulumi.get(self, "i_p_address_or_range")

    @property
    @pulumi.getter
    def action(self) -> Optional[str]:
        """
        The action of IP ACL rule.
        """
        return pulumi.get(self, "action")


@pulumi.output_type
class IdentityPropertiesResponse(dict):
    """
    Managed identity for the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"
        elif key == "userAssignedIdentities":
            suggest = "user_assigned_identities"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IdentityPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IdentityPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IdentityPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 principal_id: Optional[str] = None,
                 tenant_id: Optional[str] = None,
                 type: Optional[str] = None,
                 user_assigned_identities: Optional[Mapping[str, 'outputs.UserIdentityPropertiesResponse']] = None):
        """
        Managed identity for the resource.
        :param str principal_id: The principal ID of resource identity.
        :param str tenant_id: The tenant ID of resource.
        :param str type: The identity type.
        :param Mapping[str, 'UserIdentityPropertiesResponse'] user_assigned_identities: The list of user identities associated with the resource. The user identity 
               dictionary key references will be ARM resource ids in the form: 
               '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/
                   providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        """
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_assigned_identities is not None:
            pulumi.set(__self__, "user_assigned_identities", user_assigned_identities)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[str]:
        """
        The principal ID of resource identity.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[str]:
        """
        The tenant ID of resource.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The identity type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="userAssignedIdentities")
    def user_assigned_identities(self) -> Optional[Mapping[str, 'outputs.UserIdentityPropertiesResponse']]:
        """
        The list of user identities associated with the resource. The user identity 
        dictionary key references will be ARM resource ids in the form: 
        '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/
            providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        """
        return pulumi.get(self, "user_assigned_identities")


@pulumi.output_type
class KeyVaultPropertiesResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyRotationEnabled":
            suggest = "key_rotation_enabled"
        elif key == "lastKeyRotationTimestamp":
            suggest = "last_key_rotation_timestamp"
        elif key == "versionedKeyIdentifier":
            suggest = "versioned_key_identifier"
        elif key == "keyIdentifier":
            suggest = "key_identifier"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KeyVaultPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KeyVaultPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KeyVaultPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_rotation_enabled: bool,
                 last_key_rotation_timestamp: str,
                 versioned_key_identifier: str,
                 identity: Optional[str] = None,
                 key_identifier: Optional[str] = None):
        """
        :param bool key_rotation_enabled: Auto key rotation status for a CMK enabled registry.
        :param str last_key_rotation_timestamp: Timestamp of the last successful key rotation.
        :param str versioned_key_identifier: The fully qualified key identifier that includes the version of the key that is actually used for encryption.
        :param str identity: The client id of the identity which will be used to access key vault.
        :param str key_identifier: Key vault uri to access the encryption key.
        """
        pulumi.set(__self__, "key_rotation_enabled", key_rotation_enabled)
        pulumi.set(__self__, "last_key_rotation_timestamp", last_key_rotation_timestamp)
        pulumi.set(__self__, "versioned_key_identifier", versioned_key_identifier)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if key_identifier is not None:
            pulumi.set(__self__, "key_identifier", key_identifier)

    @property
    @pulumi.getter(name="keyRotationEnabled")
    def key_rotation_enabled(self) -> bool:
        """
        Auto key rotation status for a CMK enabled registry.
        """
        return pulumi.get(self, "key_rotation_enabled")

    @property
    @pulumi.getter(name="lastKeyRotationTimestamp")
    def last_key_rotation_timestamp(self) -> str:
        """
        Timestamp of the last successful key rotation.
        """
        return pulumi.get(self, "last_key_rotation_timestamp")

    @property
    @pulumi.getter(name="versionedKeyIdentifier")
    def versioned_key_identifier(self) -> str:
        """
        The fully qualified key identifier that includes the version of the key that is actually used for encryption.
        """
        return pulumi.get(self, "versioned_key_identifier")

    @property
    @pulumi.getter
    def identity(self) -> Optional[str]:
        """
        The client id of the identity which will be used to access key vault.
        """
        return pulumi.get(self, "identity")

    @property
    @pulumi.getter(name="keyIdentifier")
    def key_identifier(self) -> Optional[str]:
        """
        Key vault uri to access the encryption key.
        """
        return pulumi.get(self, "key_identifier")


@pulumi.output_type
class NetworkRuleSetResponse(dict):
    """
    The network rule set for a container registry.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultAction":
            suggest = "default_action"
        elif key == "ipRules":
            suggest = "ip_rules"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkRuleSetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkRuleSetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkRuleSetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_action: str,
                 ip_rules: Optional[Sequence['outputs.IPRuleResponse']] = None):
        """
        The network rule set for a container registry.
        :param str default_action: The default action of allow or deny when no other rules match.
        :param Sequence['IPRuleResponse'] ip_rules: The IP ACL rules.
        """
        if default_action is None:
            default_action = 'Allow'
        pulumi.set(__self__, "default_action", default_action)
        if ip_rules is not None:
            pulumi.set(__self__, "ip_rules", ip_rules)

    @property
    @pulumi.getter(name="defaultAction")
    def default_action(self) -> str:
        """
        The default action of allow or deny when no other rules match.
        """
        return pulumi.get(self, "default_action")

    @property
    @pulumi.getter(name="ipRules")
    def ip_rules(self) -> Optional[Sequence['outputs.IPRuleResponse']]:
        """
        The IP ACL rules.
        """
        return pulumi.get(self, "ip_rules")


@pulumi.output_type
class PoliciesResponse(dict):
    """
    The policies for a container registry.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "exportPolicy":
            suggest = "export_policy"
        elif key == "quarantinePolicy":
            suggest = "quarantine_policy"
        elif key == "retentionPolicy":
            suggest = "retention_policy"
        elif key == "trustPolicy":
            suggest = "trust_policy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PoliciesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PoliciesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PoliciesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 export_policy: Optional['outputs.ExportPolicyResponse'] = None,
                 quarantine_policy: Optional['outputs.QuarantinePolicyResponse'] = None,
                 retention_policy: Optional['outputs.RetentionPolicyResponse'] = None,
                 trust_policy: Optional['outputs.TrustPolicyResponse'] = None):
        """
        The policies for a container registry.
        :param 'ExportPolicyResponse' export_policy: The export policy for a container registry.
        :param 'QuarantinePolicyResponse' quarantine_policy: The quarantine policy for a container registry.
        :param 'RetentionPolicyResponse' retention_policy: The retention policy for a container registry.
        :param 'TrustPolicyResponse' trust_policy: The content trust policy for a container registry.
        """
        if export_policy is not None:
            pulumi.set(__self__, "export_policy", export_policy)
        if quarantine_policy is not None:
            pulumi.set(__self__, "quarantine_policy", quarantine_policy)
        if retention_policy is not None:
            pulumi.set(__self__, "retention_policy", retention_policy)
        if trust_policy is not None:
            pulumi.set(__self__, "trust_policy", trust_policy)

    @property
    @pulumi.getter(name="exportPolicy")
    def export_policy(self) -> Optional['outputs.ExportPolicyResponse']:
        """
        The export policy for a container registry.
        """
        return pulumi.get(self, "export_policy")

    @property
    @pulumi.getter(name="quarantinePolicy")
    def quarantine_policy(self) -> Optional['outputs.QuarantinePolicyResponse']:
        """
        The quarantine policy for a container registry.
        """
        return pulumi.get(self, "quarantine_policy")

    @property
    @pulumi.getter(name="retentionPolicy")
    def retention_policy(self) -> Optional['outputs.RetentionPolicyResponse']:
        """
        The retention policy for a container registry.
        """
        return pulumi.get(self, "retention_policy")

    @property
    @pulumi.getter(name="trustPolicy")
    def trust_policy(self) -> Optional['outputs.TrustPolicyResponse']:
        """
        The content trust policy for a container registry.
        """
        return pulumi.get(self, "trust_policy")


@pulumi.output_type
class PrivateEndpointConnectionResponse(dict):
    """
    An object that represents a private endpoint connection for a container registry.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "systemData":
            suggest = "system_data"
        elif key == "privateEndpoint":
            suggest = "private_endpoint"
        elif key == "privateLinkServiceConnectionState":
            suggest = "private_link_service_connection_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateEndpointConnectionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateEndpointConnectionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateEndpointConnectionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 name: str,
                 provisioning_state: str,
                 system_data: 'outputs.SystemDataResponse',
                 type: str,
                 private_endpoint: Optional['outputs.PrivateEndpointResponse'] = None,
                 private_link_service_connection_state: Optional['outputs.PrivateLinkServiceConnectionStateResponse'] = None):
        """
        An object that represents a private endpoint connection for a container registry.
        :param str id: The resource ID.
        :param str name: The name of the resource.
        :param str provisioning_state: The provisioning state of private endpoint connection resource.
        :param 'SystemDataResponse' system_data: Metadata pertaining to creation and last modification of the resource.
        :param str type: The type of the resource.
        :param 'PrivateEndpointResponse' private_endpoint: The resource of private endpoint.
        :param 'PrivateLinkServiceConnectionStateResponse' private_link_service_connection_state: A collection of information about the state of the connection between service consumer and provider.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "system_data", system_data)
        pulumi.set(__self__, "type", type)
        if private_endpoint is not None:
            pulumi.set(__self__, "private_endpoint", private_endpoint)
        if private_link_service_connection_state is not None:
            pulumi.set(__self__, "private_link_service_connection_state", private_link_service_connection_state)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of private endpoint connection resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="systemData")
    def system_data(self) -> 'outputs.SystemDataResponse':
        """
        Metadata pertaining to creation and last modification of the resource.
        """
        return pulumi.get(self, "system_data")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the resource.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="privateEndpoint")
    def private_endpoint(self) -> Optional['outputs.PrivateEndpointResponse']:
        """
        The resource of private endpoint.
        """
        return pulumi.get(self, "private_endpoint")

    @property
    @pulumi.getter(name="privateLinkServiceConnectionState")
    def private_link_service_connection_state(self) -> Optional['outputs.PrivateLinkServiceConnectionStateResponse']:
        """
        A collection of information about the state of the connection between service consumer and provider.
        """
        return pulumi.get(self, "private_link_service_connection_state")


@pulumi.output_type
class PrivateEndpointResponse(dict):
    """
    The Private Endpoint resource.
    """
    def __init__(__self__, *,
                 id: Optional[str] = None):
        """
        The Private Endpoint resource.
        :param str id: This is private endpoint resource created with Microsoft.Network resource provider.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        This is private endpoint resource created with Microsoft.Network resource provider.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class PrivateLinkServiceConnectionStateResponse(dict):
    """
    The state of a private link service connection.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "actionsRequired":
            suggest = "actions_required"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateLinkServiceConnectionStateResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateLinkServiceConnectionStateResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateLinkServiceConnectionStateResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 actions_required: Optional[str] = None,
                 description: Optional[str] = None,
                 status: Optional[str] = None):
        """
        The state of a private link service connection.
        :param str actions_required: A message indicating if changes on the service provider require any updates on the consumer.
        :param str description: The description for connection status. For example if connection is rejected it can indicate reason for rejection.
        :param str status: The private link service connection status.
        """
        if actions_required is not None:
            pulumi.set(__self__, "actions_required", actions_required)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="actionsRequired")
    def actions_required(self) -> Optional[str]:
        """
        A message indicating if changes on the service provider require any updates on the consumer.
        """
        return pulumi.get(self, "actions_required")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description for connection status. For example if connection is rejected it can indicate reason for rejection.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        The private link service connection status.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class QuarantinePolicyResponse(dict):
    """
    The quarantine policy for a container registry.
    """
    def __init__(__self__, *,
                 status: Optional[str] = None):
        """
        The quarantine policy for a container registry.
        :param str status: The value that indicates whether the policy is enabled or not.
        """
        if status is None:
            status = 'disabled'
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        The value that indicates whether the policy is enabled or not.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class RegistryPasswordResponse(dict):
    """
    The login password for the container registry.
    """
    def __init__(__self__, *,
                 name: Optional[str] = None,
                 value: Optional[str] = None):
        """
        The login password for the container registry.
        :param str name: The password name.
        :param str value: The password value.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The password name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        The password value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class RequestResponse(dict):
    """
    The request that generated the event.
    """
    def __init__(__self__, *,
                 addr: Optional[str] = None,
                 host: Optional[str] = None,
                 id: Optional[str] = None,
                 method: Optional[str] = None,
                 useragent: Optional[str] = None):
        """
        The request that generated the event.
        :param str addr: The IP or hostname and possibly port of the client connection that initiated the event. This is the RemoteAddr from the standard http request.
        :param str host: The externally accessible hostname of the registry instance, as specified by the http host header on incoming requests.
        :param str id: The ID of the request that initiated the event.
        :param str method: The request method that generated the event.
        :param str useragent: The user agent header of the request.
        """
        if addr is not None:
            pulumi.set(__self__, "addr", addr)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if method is not None:
            pulumi.set(__self__, "method", method)
        if useragent is not None:
            pulumi.set(__self__, "useragent", useragent)

    @property
    @pulumi.getter
    def addr(self) -> Optional[str]:
        """
        The IP or hostname and possibly port of the client connection that initiated the event. This is the RemoteAddr from the standard http request.
        """
        return pulumi.get(self, "addr")

    @property
    @pulumi.getter
    def host(self) -> Optional[str]:
        """
        The externally accessible hostname of the registry instance, as specified by the http host header on incoming requests.
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The ID of the request that initiated the event.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def method(self) -> Optional[str]:
        """
        The request method that generated the event.
        """
        return pulumi.get(self, "method")

    @property
    @pulumi.getter
    def useragent(self) -> Optional[str]:
        """
        The user agent header of the request.
        """
        return pulumi.get(self, "useragent")


@pulumi.output_type
class RetentionPolicyResponse(dict):
    """
    The retention policy for a container registry.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastUpdatedTime":
            suggest = "last_updated_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RetentionPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RetentionPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RetentionPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 last_updated_time: str,
                 days: Optional[int] = None,
                 status: Optional[str] = None):
        """
        The retention policy for a container registry.
        :param str last_updated_time: The timestamp when the policy was last updated.
        :param int days: The number of days to retain an untagged manifest after which it gets purged.
        :param str status: The value that indicates whether the policy is enabled or not.
        """
        pulumi.set(__self__, "last_updated_time", last_updated_time)
        if days is None:
            days = 7
        if days is not None:
            pulumi.set(__self__, "days", days)
        if status is None:
            status = 'disabled'
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="lastUpdatedTime")
    def last_updated_time(self) -> str:
        """
        The timestamp when the policy was last updated.
        """
        return pulumi.get(self, "last_updated_time")

    @property
    @pulumi.getter
    def days(self) -> Optional[int]:
        """
        The number of days to retain an untagged manifest after which it gets purged.
        """
        return pulumi.get(self, "days")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        The value that indicates whether the policy is enabled or not.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class SkuResponse(dict):
    """
    The SKU of a container registry.
    """
    def __init__(__self__, *,
                 name: str,
                 tier: str):
        """
        The SKU of a container registry.
        :param str name: The SKU name of the container registry. Required for registry creation.
        :param str tier: The SKU tier based on the SKU name.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The SKU name of the container registry. Required for registry creation.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def tier(self) -> str:
        """
        The SKU tier based on the SKU name.
        """
        return pulumi.get(self, "tier")


@pulumi.output_type
class SourceResponse(dict):
    """
    The registry node that generated the event. Put differently, while the actor initiates the event, the source generates it.
    """
    def __init__(__self__, *,
                 addr: Optional[str] = None,
                 instance_id: Optional[str] = None):
        """
        The registry node that generated the event. Put differently, while the actor initiates the event, the source generates it.
        :param str addr: The IP or hostname and the port of the registry node that generated the event. Generally, this will be resolved by os.Hostname() along with the running port.
        :param str instance_id: The running instance of an application. Changes after each restart.
        """
        if addr is not None:
            pulumi.set(__self__, "addr", addr)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)

    @property
    @pulumi.getter
    def addr(self) -> Optional[str]:
        """
        The IP or hostname and the port of the registry node that generated the event. Generally, this will be resolved by os.Hostname() along with the running port.
        """
        return pulumi.get(self, "addr")

    @property
    @pulumi.getter(name="instanceID")
    def instance_id(self) -> Optional[str]:
        """
        The running instance of an application. Changes after each restart.
        """
        return pulumi.get(self, "instance_id")


@pulumi.output_type
class StatusResponse(dict):
    """
    The status of an Azure resource at the time the operation was called.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayStatus":
            suggest = "display_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StatusResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StatusResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StatusResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 display_status: str,
                 message: str,
                 timestamp: str):
        """
        The status of an Azure resource at the time the operation was called.
        :param str display_status: The short label for the status.
        :param str message: The detailed message for the status, including alerts and error messages.
        :param str timestamp: The timestamp when the status was changed to the current value.
        """
        pulumi.set(__self__, "display_status", display_status)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "timestamp", timestamp)

    @property
    @pulumi.getter(name="displayStatus")
    def display_status(self) -> str:
        """
        The short label for the status.
        """
        return pulumi.get(self, "display_status")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        The detailed message for the status, including alerts and error messages.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def timestamp(self) -> str:
        """
        The timestamp when the status was changed to the current value.
        """
        return pulumi.get(self, "timestamp")


@pulumi.output_type
class SystemDataResponse(dict):
    """
    Metadata pertaining to creation and last modification of the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "createdBy":
            suggest = "created_by"
        elif key == "createdByType":
            suggest = "created_by_type"
        elif key == "lastModifiedAt":
            suggest = "last_modified_at"
        elif key == "lastModifiedBy":
            suggest = "last_modified_by"
        elif key == "lastModifiedByType":
            suggest = "last_modified_by_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SystemDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: Optional[str] = None,
                 created_by: Optional[str] = None,
                 created_by_type: Optional[str] = None,
                 last_modified_at: Optional[str] = None,
                 last_modified_by: Optional[str] = None,
                 last_modified_by_type: Optional[str] = None):
        """
        Metadata pertaining to creation and last modification of the resource.
        :param str created_at: The timestamp of resource creation (UTC).
        :param str created_by: The identity that created the resource.
        :param str created_by_type: The type of identity that created the resource.
        :param str last_modified_at: The timestamp of resource modification (UTC).
        :param str last_modified_by: The identity that last modified the resource.
        :param str last_modified_by_type: The type of identity that last modified the resource.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_by_type is not None:
            pulumi.set(__self__, "created_by_type", created_by_type)
        if last_modified_at is not None:
            pulumi.set(__self__, "last_modified_at", last_modified_at)
        if last_modified_by is not None:
            pulumi.set(__self__, "last_modified_by", last_modified_by)
        if last_modified_by_type is not None:
            pulumi.set(__self__, "last_modified_by_type", last_modified_by_type)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The timestamp of resource creation (UTC).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[str]:
        """
        The identity that created the resource.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="createdByType")
    def created_by_type(self) -> Optional[str]:
        """
        The type of identity that created the resource.
        """
        return pulumi.get(self, "created_by_type")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> Optional[str]:
        """
        The timestamp of resource modification (UTC).
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> Optional[str]:
        """
        The identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by")

    @property
    @pulumi.getter(name="lastModifiedByType")
    def last_modified_by_type(self) -> Optional[str]:
        """
        The type of identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by_type")


@pulumi.output_type
class TargetResponse(dict):
    """
    The target of the event.
    """
    def __init__(__self__, *,
                 digest: Optional[str] = None,
                 length: Optional[float] = None,
                 media_type: Optional[str] = None,
                 name: Optional[str] = None,
                 repository: Optional[str] = None,
                 size: Optional[float] = None,
                 tag: Optional[str] = None,
                 url: Optional[str] = None,
                 version: Optional[str] = None):
        """
        The target of the event.
        :param str digest: The digest of the content, as defined by the Registry V2 HTTP API Specification.
        :param float length: The number of bytes of the content. Same as Size field.
        :param str media_type: The MIME type of the referenced object.
        :param str name: The name of the artifact.
        :param str repository: The repository name.
        :param float size: The number of bytes of the content. Same as Length field.
        :param str tag: The tag name.
        :param str url: The direct URL to the content.
        :param str version: The version of the artifact.
        """
        if digest is not None:
            pulumi.set(__self__, "digest", digest)
        if length is not None:
            pulumi.set(__self__, "length", length)
        if media_type is not None:
            pulumi.set(__self__, "media_type", media_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if repository is not None:
            pulumi.set(__self__, "repository", repository)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if tag is not None:
            pulumi.set(__self__, "tag", tag)
        if url is not None:
            pulumi.set(__self__, "url", url)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def digest(self) -> Optional[str]:
        """
        The digest of the content, as defined by the Registry V2 HTTP API Specification.
        """
        return pulumi.get(self, "digest")

    @property
    @pulumi.getter
    def length(self) -> Optional[float]:
        """
        The number of bytes of the content. Same as Size field.
        """
        return pulumi.get(self, "length")

    @property
    @pulumi.getter(name="mediaType")
    def media_type(self) -> Optional[str]:
        """
        The MIME type of the referenced object.
        """
        return pulumi.get(self, "media_type")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the artifact.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def repository(self) -> Optional[str]:
        """
        The repository name.
        """
        return pulumi.get(self, "repository")

    @property
    @pulumi.getter
    def size(self) -> Optional[float]:
        """
        The number of bytes of the content. Same as Length field.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def tag(self) -> Optional[str]:
        """
        The tag name.
        """
        return pulumi.get(self, "tag")

    @property
    @pulumi.getter
    def url(self) -> Optional[str]:
        """
        The direct URL to the content.
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        The version of the artifact.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class TokenCertificateResponse(dict):
    """
    The properties of a certificate used for authenticating a token.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "encodedPemCertificate":
            suggest = "encoded_pem_certificate"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TokenCertificateResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TokenCertificateResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TokenCertificateResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 encoded_pem_certificate: Optional[str] = None,
                 expiry: Optional[str] = None,
                 name: Optional[str] = None,
                 thumbprint: Optional[str] = None):
        """
        The properties of a certificate used for authenticating a token.
        :param str encoded_pem_certificate: Base 64 encoded string of the public certificate1 in PEM format that will be used for authenticating the token.
        :param str expiry: The expiry datetime of the certificate.
        :param str thumbprint: The thumbprint of the certificate.
        """
        if encoded_pem_certificate is not None:
            pulumi.set(__self__, "encoded_pem_certificate", encoded_pem_certificate)
        if expiry is not None:
            pulumi.set(__self__, "expiry", expiry)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if thumbprint is not None:
            pulumi.set(__self__, "thumbprint", thumbprint)

    @property
    @pulumi.getter(name="encodedPemCertificate")
    def encoded_pem_certificate(self) -> Optional[str]:
        """
        Base 64 encoded string of the public certificate1 in PEM format that will be used for authenticating the token.
        """
        return pulumi.get(self, "encoded_pem_certificate")

    @property
    @pulumi.getter
    def expiry(self) -> Optional[str]:
        """
        The expiry datetime of the certificate.
        """
        return pulumi.get(self, "expiry")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def thumbprint(self) -> Optional[str]:
        """
        The thumbprint of the certificate.
        """
        return pulumi.get(self, "thumbprint")


@pulumi.output_type
class TokenCredentialsPropertiesResponse(dict):
    """
    The properties of the credentials that can be used for authenticating the token.
    """
    def __init__(__self__, *,
                 certificates: Optional[Sequence['outputs.TokenCertificateResponse']] = None,
                 passwords: Optional[Sequence['outputs.TokenPasswordResponse']] = None):
        """
        The properties of the credentials that can be used for authenticating the token.
        """
        if certificates is not None:
            pulumi.set(__self__, "certificates", certificates)
        if passwords is not None:
            pulumi.set(__self__, "passwords", passwords)

    @property
    @pulumi.getter
    def certificates(self) -> Optional[Sequence['outputs.TokenCertificateResponse']]:
        return pulumi.get(self, "certificates")

    @property
    @pulumi.getter
    def passwords(self) -> Optional[Sequence['outputs.TokenPasswordResponse']]:
        return pulumi.get(self, "passwords")


@pulumi.output_type
class TokenPasswordResponse(dict):
    """
    The password that will be used for authenticating the token of a container registry.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "creationTime":
            suggest = "creation_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TokenPasswordResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TokenPasswordResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TokenPasswordResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 value: str,
                 creation_time: Optional[str] = None,
                 expiry: Optional[str] = None,
                 name: Optional[str] = None):
        """
        The password that will be used for authenticating the token of a container registry.
        :param str value: The password value.
        :param str creation_time: The creation datetime of the password.
        :param str expiry: The expiry datetime of the password.
        :param str name: The password name "password1" or "password2"
        """
        pulumi.set(__self__, "value", value)
        if creation_time is not None:
            pulumi.set(__self__, "creation_time", creation_time)
        if expiry is not None:
            pulumi.set(__self__, "expiry", expiry)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The password value.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> Optional[str]:
        """
        The creation datetime of the password.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter
    def expiry(self) -> Optional[str]:
        """
        The expiry datetime of the password.
        """
        return pulumi.get(self, "expiry")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The password name "password1" or "password2"
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class TrustPolicyResponse(dict):
    """
    The content trust policy for a container registry.
    """
    def __init__(__self__, *,
                 status: Optional[str] = None,
                 type: Optional[str] = None):
        """
        The content trust policy for a container registry.
        :param str status: The value that indicates whether the policy is enabled or not.
        :param str type: The type of trust policy.
        """
        if status is None:
            status = 'disabled'
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is None:
            type = 'Notary'
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        The value that indicates whether the policy is enabled or not.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of trust policy.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class UserIdentityPropertiesResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "principalId":
            suggest = "principal_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserIdentityPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserIdentityPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserIdentityPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: Optional[str] = None,
                 principal_id: Optional[str] = None):
        """
        :param str client_id: The client id of user assigned identity.
        :param str principal_id: The principal id of user assigned identity.
        """
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[str]:
        """
        The client id of user assigned identity.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[str]:
        """
        The principal id of user assigned identity.
        """
        return pulumi.get(self, "principal_id")


