# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'ExtendedLocationResponse',
    'GalleryImageStatusResponse',
    'IPPoolInfoResponse',
    'IPPoolResponse',
    'InterfaceDNSSettingsResponse',
    'IpConfigurationResponse',
    'IpConfigurationResponseProperties',
    'IpConfigurationResponseSubnet',
    'NetworkInterfaceStatusResponse',
    'SystemDataResponse',
    'VirtualHardDiskStatusResponse',
    'VirtualMachineStatusResponse',
    'VirtualNetworkStatusResponse',
    'VirtualmachinesPropertiesResponseDataDisks',
    'VirtualmachinesPropertiesResponseDynamicMemoryConfig',
    'VirtualmachinesPropertiesResponseHardwareProfile',
    'VirtualmachinesPropertiesResponseImageReference',
    'VirtualmachinesPropertiesResponseLinuxConfiguration',
    'VirtualmachinesPropertiesResponseNetworkInterfaces',
    'VirtualmachinesPropertiesResponseNetworkProfile',
    'VirtualmachinesPropertiesResponseOsProfile',
    'VirtualmachinesPropertiesResponsePublicKeys',
    'VirtualmachinesPropertiesResponsePublicKeysPublicKeys',
    'VirtualmachinesPropertiesResponseSecurityProfile',
    'VirtualmachinesPropertiesResponseSsh',
    'VirtualmachinesPropertiesResponseSshSsh',
    'VirtualmachinesPropertiesResponseStorageProfile',
    'VirtualmachinesPropertiesResponseWindowsConfiguration',
    'VirtualnetworksPropertiesResponseIpConfigurationReferences',
    'VirtualnetworksPropertiesResponseRouteTable',
    'VirtualnetworksPropertiesResponseRoutes',
    'VirtualnetworksPropertiesResponseSubnets',
]

@pulumi.output_type
class ExtendedLocationResponse(dict):
    """
    The complex type of the extended location.
    """
    def __init__(__self__, *,
                 name: Optional[str] = None,
                 type: Optional[str] = None):
        """
        The complex type of the extended location.
        :param str name: The name of the extended location.
        :param str type: The type of the extended location.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the extended location.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of the extended location.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GalleryImageStatusResponse(dict):
    """
    GalleryImageStatus defines the observed state of MOCGalleryImage
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "errorCode":
            suggest = "error_code"
        elif key == "errorMessage":
            suggest = "error_message"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GalleryImageStatusResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GalleryImageStatusResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GalleryImageStatusResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 error_code: Optional[str] = None,
                 error_message: Optional[str] = None):
        """
        GalleryImageStatus defines the observed state of MOCGalleryImage
        :param str error_code: GalleryImage provisioning error code
        :param str error_message: Descriptive error message
        """
        if error_code is not None:
            pulumi.set(__self__, "error_code", error_code)
        if error_message is not None:
            pulumi.set(__self__, "error_message", error_message)

    @property
    @pulumi.getter(name="errorCode")
    def error_code(self) -> Optional[str]:
        """
        GalleryImage provisioning error code
        """
        return pulumi.get(self, "error_code")

    @property
    @pulumi.getter(name="errorMessage")
    def error_message(self) -> Optional[str]:
        """
        Descriptive error message
        """
        return pulumi.get(self, "error_message")


@pulumi.output_type
class IPPoolInfoResponse(dict):
    def __init__(__self__, *,
                 available: str,
                 used: str):
        """
        :param str available: no. of ip addresses available in the ip pool
        :param str used: no. of ip addresses allocated from the ip pool
        """
        pulumi.set(__self__, "available", available)
        pulumi.set(__self__, "used", used)

    @property
    @pulumi.getter
    def available(self) -> str:
        """
        no. of ip addresses available in the ip pool
        """
        return pulumi.get(self, "available")

    @property
    @pulumi.getter
    def used(self) -> str:
        """
        no. of ip addresses allocated from the ip pool
        """
        return pulumi.get(self, "used")


@pulumi.output_type
class IPPoolResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipPoolType":
            suggest = "ip_pool_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IPPoolResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IPPoolResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IPPoolResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 end: Optional[str] = None,
                 info: Optional['outputs.IPPoolInfoResponse'] = None,
                 ip_pool_type: Optional[str] = None,
                 start: Optional[str] = None):
        """
        :param str end: Last IP in the pool
        :param str ip_pool_type: ip pool type
        :param str start: First IP in the pool
        """
        if end is not None:
            pulumi.set(__self__, "end", end)
        if info is not None:
            pulumi.set(__self__, "info", info)
        if ip_pool_type is not None:
            pulumi.set(__self__, "ip_pool_type", ip_pool_type)
        if start is not None:
            pulumi.set(__self__, "start", start)

    @property
    @pulumi.getter
    def end(self) -> Optional[str]:
        """
        Last IP in the pool
        """
        return pulumi.get(self, "end")

    @property
    @pulumi.getter
    def info(self) -> Optional['outputs.IPPoolInfoResponse']:
        return pulumi.get(self, "info")

    @property
    @pulumi.getter(name="ipPoolType")
    def ip_pool_type(self) -> Optional[str]:
        """
        ip pool type
        """
        return pulumi.get(self, "ip_pool_type")

    @property
    @pulumi.getter
    def start(self) -> Optional[str]:
        """
        First IP in the pool
        """
        return pulumi.get(self, "start")


@pulumi.output_type
class InterfaceDNSSettingsResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dnsServers":
            suggest = "dns_servers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InterfaceDNSSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InterfaceDNSSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InterfaceDNSSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dns_servers: Optional[Sequence[str]] = None):
        """
        :param Sequence[str] dns_servers: List of DNS server IP Addresses for the interface
        """
        if dns_servers is not None:
            pulumi.set(__self__, "dns_servers", dns_servers)

    @property
    @pulumi.getter(name="dnsServers")
    def dns_servers(self) -> Optional[Sequence[str]]:
        """
        List of DNS server IP Addresses for the interface
        """
        return pulumi.get(self, "dns_servers")


@pulumi.output_type
class IpConfigurationResponse(dict):
    """
    InterfaceIPConfiguration iPConfiguration in a network interface.
    """
    def __init__(__self__, *,
                 name: Optional[str] = None,
                 properties: Optional['outputs.IpConfigurationResponseProperties'] = None):
        """
        InterfaceIPConfiguration iPConfiguration in a network interface.
        :param str name: Name - The name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param 'IpConfigurationResponseProperties' properties: InterfaceIPConfigurationPropertiesFormat properties of IP configuration.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name - The name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def properties(self) -> Optional['outputs.IpConfigurationResponseProperties']:
        """
        InterfaceIPConfigurationPropertiesFormat properties of IP configuration.
        """
        return pulumi.get(self, "properties")


@pulumi.output_type
class IpConfigurationResponseProperties(dict):
    """
    InterfaceIPConfigurationPropertiesFormat properties of IP configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "prefixLength":
            suggest = "prefix_length"
        elif key == "privateIPAddress":
            suggest = "private_ip_address"
        elif key == "privateIPAllocationMethod":
            suggest = "private_ip_allocation_method"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IpConfigurationResponseProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IpConfigurationResponseProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IpConfigurationResponseProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 prefix_length: Optional[str] = None,
                 private_ip_address: Optional[str] = None,
                 private_ip_allocation_method: Optional[str] = None,
                 subnet: Optional['outputs.IpConfigurationResponseSubnet'] = None):
        """
        InterfaceIPConfigurationPropertiesFormat properties of IP configuration.
        :param str prefix_length: prefixLength for network interface
        :param str private_ip_address: PrivateIPAddress - Private IP address of the IP configuration.
        :param str private_ip_allocation_method: PrivateIPAllocationMethod - The private IP address allocation method. Possible values include: 'Static', 'Dynamic'
        :param 'IpConfigurationResponseSubnet' subnet: Subnet - Name of Subnet bound to the IP configuration.
        """
        if prefix_length is not None:
            pulumi.set(__self__, "prefix_length", prefix_length)
        if private_ip_address is not None:
            pulumi.set(__self__, "private_ip_address", private_ip_address)
        if private_ip_allocation_method is not None:
            pulumi.set(__self__, "private_ip_allocation_method", private_ip_allocation_method)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)

    @property
    @pulumi.getter(name="prefixLength")
    def prefix_length(self) -> Optional[str]:
        """
        prefixLength for network interface
        """
        return pulumi.get(self, "prefix_length")

    @property
    @pulumi.getter(name="privateIPAddress")
    def private_ip_address(self) -> Optional[str]:
        """
        PrivateIPAddress - Private IP address of the IP configuration.
        """
        return pulumi.get(self, "private_ip_address")

    @property
    @pulumi.getter(name="privateIPAllocationMethod")
    def private_ip_allocation_method(self) -> Optional[str]:
        """
        PrivateIPAllocationMethod - The private IP address allocation method. Possible values include: 'Static', 'Dynamic'
        """
        return pulumi.get(self, "private_ip_allocation_method")

    @property
    @pulumi.getter
    def subnet(self) -> Optional['outputs.IpConfigurationResponseSubnet']:
        """
        Subnet - Name of Subnet bound to the IP configuration.
        """
        return pulumi.get(self, "subnet")


@pulumi.output_type
class IpConfigurationResponseSubnet(dict):
    """
    Subnet - Name of Subnet bound to the IP configuration.
    """
    def __init__(__self__, *,
                 id: Optional[str] = None):
        """
        Subnet - Name of Subnet bound to the IP configuration.
        :param str id: ID - The ARM resource id in the form of /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/...
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        ID - The ARM resource id in the form of /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/...
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class NetworkInterfaceStatusResponse(dict):
    """
    NetworkInterfaceStatus defines the observed state of NetworkInterface
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "errorCode":
            suggest = "error_code"
        elif key == "errorMessage":
            suggest = "error_message"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkInterfaceStatusResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkInterfaceStatusResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkInterfaceStatusResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 error_code: Optional[str] = None,
                 error_message: Optional[str] = None):
        """
        NetworkInterfaceStatus defines the observed state of NetworkInterface
        :param str error_code: NetworkInterface provisioning error code
        :param str error_message: Descriptive error message
        """
        if error_code is not None:
            pulumi.set(__self__, "error_code", error_code)
        if error_message is not None:
            pulumi.set(__self__, "error_message", error_message)

    @property
    @pulumi.getter(name="errorCode")
    def error_code(self) -> Optional[str]:
        """
        NetworkInterface provisioning error code
        """
        return pulumi.get(self, "error_code")

    @property
    @pulumi.getter(name="errorMessage")
    def error_message(self) -> Optional[str]:
        """
        Descriptive error message
        """
        return pulumi.get(self, "error_message")


@pulumi.output_type
class SystemDataResponse(dict):
    """
    Metadata pertaining to creation and last modification of the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "createdBy":
            suggest = "created_by"
        elif key == "createdByType":
            suggest = "created_by_type"
        elif key == "lastModifiedAt":
            suggest = "last_modified_at"
        elif key == "lastModifiedBy":
            suggest = "last_modified_by"
        elif key == "lastModifiedByType":
            suggest = "last_modified_by_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SystemDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: Optional[str] = None,
                 created_by: Optional[str] = None,
                 created_by_type: Optional[str] = None,
                 last_modified_at: Optional[str] = None,
                 last_modified_by: Optional[str] = None,
                 last_modified_by_type: Optional[str] = None):
        """
        Metadata pertaining to creation and last modification of the resource.
        :param str created_at: The timestamp of resource creation (UTC).
        :param str created_by: The identity that created the resource.
        :param str created_by_type: The type of identity that created the resource.
        :param str last_modified_at: The timestamp of resource last modification (UTC)
        :param str last_modified_by: The identity that last modified the resource.
        :param str last_modified_by_type: The type of identity that last modified the resource.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_by_type is not None:
            pulumi.set(__self__, "created_by_type", created_by_type)
        if last_modified_at is not None:
            pulumi.set(__self__, "last_modified_at", last_modified_at)
        if last_modified_by is not None:
            pulumi.set(__self__, "last_modified_by", last_modified_by)
        if last_modified_by_type is not None:
            pulumi.set(__self__, "last_modified_by_type", last_modified_by_type)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The timestamp of resource creation (UTC).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[str]:
        """
        The identity that created the resource.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="createdByType")
    def created_by_type(self) -> Optional[str]:
        """
        The type of identity that created the resource.
        """
        return pulumi.get(self, "created_by_type")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> Optional[str]:
        """
        The timestamp of resource last modification (UTC)
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> Optional[str]:
        """
        The identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by")

    @property
    @pulumi.getter(name="lastModifiedByType")
    def last_modified_by_type(self) -> Optional[str]:
        """
        The type of identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by_type")


@pulumi.output_type
class VirtualHardDiskStatusResponse(dict):
    """
    VirtualHardDiskStatus defines the observed state of VirtualHardDisk
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "errorCode":
            suggest = "error_code"
        elif key == "errorMessage":
            suggest = "error_message"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualHardDiskStatusResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualHardDiskStatusResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualHardDiskStatusResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 error_code: Optional[str] = None,
                 error_message: Optional[str] = None):
        """
        VirtualHardDiskStatus defines the observed state of VirtualHardDisk
        :param str error_code: NetworkInterface provisioning error code
        :param str error_message: Descriptive error message
        """
        if error_code is not None:
            pulumi.set(__self__, "error_code", error_code)
        if error_message is not None:
            pulumi.set(__self__, "error_message", error_message)

    @property
    @pulumi.getter(name="errorCode")
    def error_code(self) -> Optional[str]:
        """
        NetworkInterface provisioning error code
        """
        return pulumi.get(self, "error_code")

    @property
    @pulumi.getter(name="errorMessage")
    def error_message(self) -> Optional[str]:
        """
        Descriptive error message
        """
        return pulumi.get(self, "error_message")


@pulumi.output_type
class VirtualMachineStatusResponse(dict):
    """
    VirtualMachineStatus defines the observed state of VirtualMachine
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "errorCode":
            suggest = "error_code"
        elif key == "errorMessage":
            suggest = "error_message"
        elif key == "powerState":
            suggest = "power_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineStatusResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineStatusResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineStatusResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 error_code: Optional[str] = None,
                 error_message: Optional[str] = None,
                 power_state: Optional[str] = None):
        """
        VirtualMachineStatus defines the observed state of VirtualMachine
        :param str error_code: VM provisioning error code
        :param str error_message: Descriptive error message
        :param str power_state: PowerState of the VM
        """
        if error_code is not None:
            pulumi.set(__self__, "error_code", error_code)
        if error_message is not None:
            pulumi.set(__self__, "error_message", error_message)
        if power_state is not None:
            pulumi.set(__self__, "power_state", power_state)

    @property
    @pulumi.getter(name="errorCode")
    def error_code(self) -> Optional[str]:
        """
        VM provisioning error code
        """
        return pulumi.get(self, "error_code")

    @property
    @pulumi.getter(name="errorMessage")
    def error_message(self) -> Optional[str]:
        """
        Descriptive error message
        """
        return pulumi.get(self, "error_message")

    @property
    @pulumi.getter(name="powerState")
    def power_state(self) -> Optional[str]:
        """
        PowerState of the VM
        """
        return pulumi.get(self, "power_state")


@pulumi.output_type
class VirtualNetworkStatusResponse(dict):
    """
    VirtualNetworkStatus defines the observed state of VirtualNetwork
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "errorCode":
            suggest = "error_code"
        elif key == "errorMessage":
            suggest = "error_message"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualNetworkStatusResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualNetworkStatusResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualNetworkStatusResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 error_code: Optional[str] = None,
                 error_message: Optional[str] = None):
        """
        VirtualNetworkStatus defines the observed state of VirtualNetwork
        :param str error_code: VirtualNetwork provisioning error code
        :param str error_message: Descriptive error message
        """
        if error_code is not None:
            pulumi.set(__self__, "error_code", error_code)
        if error_message is not None:
            pulumi.set(__self__, "error_message", error_message)

    @property
    @pulumi.getter(name="errorCode")
    def error_code(self) -> Optional[str]:
        """
        VirtualNetwork provisioning error code
        """
        return pulumi.get(self, "error_code")

    @property
    @pulumi.getter(name="errorMessage")
    def error_message(self) -> Optional[str]:
        """
        Descriptive error message
        """
        return pulumi.get(self, "error_message")


@pulumi.output_type
class VirtualmachinesPropertiesResponseDataDisks(dict):
    def __init__(__self__, *,
                 name: Optional[str] = None):
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        return pulumi.get(self, "name")


@pulumi.output_type
class VirtualmachinesPropertiesResponseDynamicMemoryConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maximumMemoryGB":
            suggest = "maximum_memory_gb"
        elif key == "minimumMemoryGB":
            suggest = "minimum_memory_gb"
        elif key == "targetMemoryBuffer":
            suggest = "target_memory_buffer"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualmachinesPropertiesResponseDynamicMemoryConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualmachinesPropertiesResponseDynamicMemoryConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualmachinesPropertiesResponseDynamicMemoryConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 maximum_memory_gb: Optional[float] = None,
                 minimum_memory_gb: Optional[float] = None,
                 target_memory_buffer: Optional[int] = None):
        if maximum_memory_gb is not None:
            pulumi.set(__self__, "maximum_memory_gb", maximum_memory_gb)
        if minimum_memory_gb is not None:
            pulumi.set(__self__, "minimum_memory_gb", minimum_memory_gb)
        if target_memory_buffer is not None:
            pulumi.set(__self__, "target_memory_buffer", target_memory_buffer)

    @property
    @pulumi.getter(name="maximumMemoryGB")
    def maximum_memory_gb(self) -> Optional[float]:
        return pulumi.get(self, "maximum_memory_gb")

    @property
    @pulumi.getter(name="minimumMemoryGB")
    def minimum_memory_gb(self) -> Optional[float]:
        return pulumi.get(self, "minimum_memory_gb")

    @property
    @pulumi.getter(name="targetMemoryBuffer")
    def target_memory_buffer(self) -> Optional[int]:
        return pulumi.get(self, "target_memory_buffer")


@pulumi.output_type
class VirtualmachinesPropertiesResponseHardwareProfile(dict):
    """
    HardwareProfile - Specifies the hardware settings for the virtual machine.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dynamicMemoryConfig":
            suggest = "dynamic_memory_config"
        elif key == "memoryGB":
            suggest = "memory_gb"
        elif key == "vmSize":
            suggest = "vm_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualmachinesPropertiesResponseHardwareProfile. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualmachinesPropertiesResponseHardwareProfile.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualmachinesPropertiesResponseHardwareProfile.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dynamic_memory_config: Optional['outputs.VirtualmachinesPropertiesResponseDynamicMemoryConfig'] = None,
                 memory_gb: Optional[int] = None,
                 processors: Optional[int] = None,
                 vm_size: Optional[str] = None):
        """
        HardwareProfile - Specifies the hardware settings for the virtual machine.
        :param int memory_gb: RAM in gb for the virtual machine
        :param int processors: number of processors for the virtual machine
        """
        if dynamic_memory_config is not None:
            pulumi.set(__self__, "dynamic_memory_config", dynamic_memory_config)
        if memory_gb is not None:
            pulumi.set(__self__, "memory_gb", memory_gb)
        if processors is not None:
            pulumi.set(__self__, "processors", processors)
        if vm_size is not None:
            pulumi.set(__self__, "vm_size", vm_size)

    @property
    @pulumi.getter(name="dynamicMemoryConfig")
    def dynamic_memory_config(self) -> Optional['outputs.VirtualmachinesPropertiesResponseDynamicMemoryConfig']:
        return pulumi.get(self, "dynamic_memory_config")

    @property
    @pulumi.getter(name="memoryGB")
    def memory_gb(self) -> Optional[int]:
        """
        RAM in gb for the virtual machine
        """
        return pulumi.get(self, "memory_gb")

    @property
    @pulumi.getter
    def processors(self) -> Optional[int]:
        """
        number of processors for the virtual machine
        """
        return pulumi.get(self, "processors")

    @property
    @pulumi.getter(name="vmSize")
    def vm_size(self) -> Optional[str]:
        return pulumi.get(self, "vm_size")


@pulumi.output_type
class VirtualmachinesPropertiesResponseImageReference(dict):
    """
    Which Image to use for the virtual machine
    """
    def __init__(__self__, *,
                 name: Optional[str] = None):
        """
        Which Image to use for the virtual machine
        :param str name: Name - Name of the image
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name - Name of the image
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class VirtualmachinesPropertiesResponseLinuxConfiguration(dict):
    """
    LinuxConfiguration - linux specific configuration values for the virtual machine
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "disablePasswordAuthentication":
            suggest = "disable_password_authentication"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualmachinesPropertiesResponseLinuxConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualmachinesPropertiesResponseLinuxConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualmachinesPropertiesResponseLinuxConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disable_password_authentication: Optional[bool] = None,
                 ssh: Optional['outputs.VirtualmachinesPropertiesResponseSsh'] = None):
        """
        LinuxConfiguration - linux specific configuration values for the virtual machine
        :param bool disable_password_authentication: DisablePasswordAuthentication - whether password authentication should be disabled
        :param 'VirtualmachinesPropertiesResponseSsh' ssh: SSH - contains settings related to ssh configuration
        """
        if disable_password_authentication is not None:
            pulumi.set(__self__, "disable_password_authentication", disable_password_authentication)
        if ssh is not None:
            pulumi.set(__self__, "ssh", ssh)

    @property
    @pulumi.getter(name="disablePasswordAuthentication")
    def disable_password_authentication(self) -> Optional[bool]:
        """
        DisablePasswordAuthentication - whether password authentication should be disabled
        """
        return pulumi.get(self, "disable_password_authentication")

    @property
    @pulumi.getter
    def ssh(self) -> Optional['outputs.VirtualmachinesPropertiesResponseSsh']:
        """
        SSH - contains settings related to ssh configuration
        """
        return pulumi.get(self, "ssh")


@pulumi.output_type
class VirtualmachinesPropertiesResponseNetworkInterfaces(dict):
    def __init__(__self__, *,
                 id: Optional[str] = None):
        """
        :param str id: Name of the network interface
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Name of the network interface
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class VirtualmachinesPropertiesResponseNetworkProfile(dict):
    """
    NetworkProfile - describes the network configuration the virtual machine
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "networkInterfaces":
            suggest = "network_interfaces"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualmachinesPropertiesResponseNetworkProfile. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualmachinesPropertiesResponseNetworkProfile.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualmachinesPropertiesResponseNetworkProfile.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 network_interfaces: Optional[Sequence['outputs.VirtualmachinesPropertiesResponseNetworkInterfaces']] = None):
        """
        NetworkProfile - describes the network configuration the virtual machine
        :param Sequence['VirtualmachinesPropertiesResponseNetworkInterfaces'] network_interfaces: NetworkInterfaces - list of network interfaces to be attached to the virtual machine
        """
        if network_interfaces is not None:
            pulumi.set(__self__, "network_interfaces", network_interfaces)

    @property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Optional[Sequence['outputs.VirtualmachinesPropertiesResponseNetworkInterfaces']]:
        """
        NetworkInterfaces - list of network interfaces to be attached to the virtual machine
        """
        return pulumi.get(self, "network_interfaces")


@pulumi.output_type
class VirtualmachinesPropertiesResponseOsProfile(dict):
    """
    OsProfile - describes the configuration of the operating system and sets login data
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "adminUsername":
            suggest = "admin_username"
        elif key == "computerName":
            suggest = "computer_name"
        elif key == "linuxConfiguration":
            suggest = "linux_configuration"
        elif key == "osType":
            suggest = "os_type"
        elif key == "windowsConfiguration":
            suggest = "windows_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualmachinesPropertiesResponseOsProfile. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualmachinesPropertiesResponseOsProfile.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualmachinesPropertiesResponseOsProfile.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 admin_username: Optional[str] = None,
                 computer_name: Optional[str] = None,
                 linux_configuration: Optional['outputs.VirtualmachinesPropertiesResponseLinuxConfiguration'] = None,
                 os_type: Optional[str] = None,
                 windows_configuration: Optional['outputs.VirtualmachinesPropertiesResponseWindowsConfiguration'] = None):
        """
        OsProfile - describes the configuration of the operating system and sets login data
        :param str admin_username: AdminUsername - admin username
        :param str computer_name: ComputerName - name of the compute
        :param 'VirtualmachinesPropertiesResponseLinuxConfiguration' linux_configuration: LinuxConfiguration - linux specific configuration values for the virtual machine
        :param str os_type: OsType - string specifying whether the OS is Linux or Windows
        :param 'VirtualmachinesPropertiesResponseWindowsConfiguration' windows_configuration: Windows Configuration for the virtual machine 
        """
        if admin_username is not None:
            pulumi.set(__self__, "admin_username", admin_username)
        if computer_name is not None:
            pulumi.set(__self__, "computer_name", computer_name)
        if linux_configuration is not None:
            pulumi.set(__self__, "linux_configuration", linux_configuration)
        if os_type is not None:
            pulumi.set(__self__, "os_type", os_type)
        if windows_configuration is not None:
            pulumi.set(__self__, "windows_configuration", windows_configuration)

    @property
    @pulumi.getter(name="adminUsername")
    def admin_username(self) -> Optional[str]:
        """
        AdminUsername - admin username
        """
        return pulumi.get(self, "admin_username")

    @property
    @pulumi.getter(name="computerName")
    def computer_name(self) -> Optional[str]:
        """
        ComputerName - name of the compute
        """
        return pulumi.get(self, "computer_name")

    @property
    @pulumi.getter(name="linuxConfiguration")
    def linux_configuration(self) -> Optional['outputs.VirtualmachinesPropertiesResponseLinuxConfiguration']:
        """
        LinuxConfiguration - linux specific configuration values for the virtual machine
        """
        return pulumi.get(self, "linux_configuration")

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> Optional[str]:
        """
        OsType - string specifying whether the OS is Linux or Windows
        """
        return pulumi.get(self, "os_type")

    @property
    @pulumi.getter(name="windowsConfiguration")
    def windows_configuration(self) -> Optional['outputs.VirtualmachinesPropertiesResponseWindowsConfiguration']:
        """
        Windows Configuration for the virtual machine 
        """
        return pulumi.get(self, "windows_configuration")


@pulumi.output_type
class VirtualmachinesPropertiesResponsePublicKeys(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyData":
            suggest = "key_data"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualmachinesPropertiesResponsePublicKeys. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualmachinesPropertiesResponsePublicKeys.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualmachinesPropertiesResponsePublicKeys.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_data: Optional[str] = None,
                 path: Optional[str] = None):
        """
        :param str key_data: KeyData - SSH public key certificate used to authenticate with the VM through ssh. The key needs to be at least 2048-bit and in ssh-rsa format. <br><br> For creating ssh keys, see [Create SSH keys on Linux and Mac for Li      nux VMs in Azure](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-mac-create-ssh-keys?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json).
        :param str path: Path - Specifies the full path on the created VM where ssh public key is stored. If the file already exists, the specified key is appended to the file. Example: /home/user/.ssh/authorized_keys
        """
        if key_data is not None:
            pulumi.set(__self__, "key_data", key_data)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter(name="keyData")
    def key_data(self) -> Optional[str]:
        """
        KeyData - SSH public key certificate used to authenticate with the VM through ssh. The key needs to be at least 2048-bit and in ssh-rsa format. <br><br> For creating ssh keys, see [Create SSH keys on Linux and Mac for Li      nux VMs in Azure](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-mac-create-ssh-keys?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json).
        """
        return pulumi.get(self, "key_data")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        Path - Specifies the full path on the created VM where ssh public key is stored. If the file already exists, the specified key is appended to the file. Example: /home/user/.ssh/authorized_keys
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class VirtualmachinesPropertiesResponsePublicKeysPublicKeys(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyData":
            suggest = "key_data"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualmachinesPropertiesResponsePublicKeysPublicKeys. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualmachinesPropertiesResponsePublicKeysPublicKeys.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualmachinesPropertiesResponsePublicKeysPublicKeys.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_data: Optional[str] = None,
                 path: Optional[str] = None):
        """
        :param str key_data: KeyData - SSH public key certificate used to authenticate with the VM through ssh. The key needs to be at least 2048-bit and in ssh-rsa format. <br><br> For creating ssh keys, see [Create SSH keys on Linux and Mac for Li      nux VMs in Azure](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-mac-create-ssh-keys?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json).
        :param str path: Path - Specifies the full path on the created VM where ssh public key is stored. If the file already exists, the specified key is appended to the file. Example: /home/user/.ssh/authorized_keys
        """
        if key_data is not None:
            pulumi.set(__self__, "key_data", key_data)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter(name="keyData")
    def key_data(self) -> Optional[str]:
        """
        KeyData - SSH public key certificate used to authenticate with the VM through ssh. The key needs to be at least 2048-bit and in ssh-rsa format. <br><br> For creating ssh keys, see [Create SSH keys on Linux and Mac for Li      nux VMs in Azure](https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-mac-create-ssh-keys?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json).
        """
        return pulumi.get(self, "key_data")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        Path - Specifies the full path on the created VM where ssh public key is stored. If the file already exists, the specified key is appended to the file. Example: /home/user/.ssh/authorized_keys
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class VirtualmachinesPropertiesResponseSecurityProfile(dict):
    """
    SecurityProfile - Specifies the security settings for the virtual machine.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableTPM":
            suggest = "enable_tpm"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualmachinesPropertiesResponseSecurityProfile. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualmachinesPropertiesResponseSecurityProfile.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualmachinesPropertiesResponseSecurityProfile.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_tpm: Optional[bool] = None):
        """
        SecurityProfile - Specifies the security settings for the virtual machine.
        """
        if enable_tpm is not None:
            pulumi.set(__self__, "enable_tpm", enable_tpm)

    @property
    @pulumi.getter(name="enableTPM")
    def enable_tpm(self) -> Optional[bool]:
        return pulumi.get(self, "enable_tpm")


@pulumi.output_type
class VirtualmachinesPropertiesResponseSsh(dict):
    """
    SSH - contains settings related to ssh configuration
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "publicKeys":
            suggest = "public_keys"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualmachinesPropertiesResponseSsh. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualmachinesPropertiesResponseSsh.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualmachinesPropertiesResponseSsh.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 public_keys: Optional[Sequence['outputs.VirtualmachinesPropertiesResponsePublicKeys']] = None):
        """
        SSH - contains settings related to ssh configuration
        :param Sequence['VirtualmachinesPropertiesResponsePublicKeys'] public_keys: PublicKeys - The list of SSH public keys used to authenticate with linux based VMs.
        """
        if public_keys is not None:
            pulumi.set(__self__, "public_keys", public_keys)

    @property
    @pulumi.getter(name="publicKeys")
    def public_keys(self) -> Optional[Sequence['outputs.VirtualmachinesPropertiesResponsePublicKeys']]:
        """
        PublicKeys - The list of SSH public keys used to authenticate with linux based VMs.
        """
        return pulumi.get(self, "public_keys")


@pulumi.output_type
class VirtualmachinesPropertiesResponseSshSsh(dict):
    """
    SSH Configuration
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "publicKeys":
            suggest = "public_keys"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualmachinesPropertiesResponseSshSsh. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualmachinesPropertiesResponseSshSsh.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualmachinesPropertiesResponseSshSsh.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 public_keys: Optional[Sequence['outputs.VirtualmachinesPropertiesResponsePublicKeysPublicKeys']] = None):
        """
        SSH Configuration
        :param Sequence['VirtualmachinesPropertiesResponsePublicKeysPublicKeys'] public_keys: PublicKeys - The list of SSH public keys used to authenticate with linux based VMs.
        """
        if public_keys is not None:
            pulumi.set(__self__, "public_keys", public_keys)

    @property
    @pulumi.getter(name="publicKeys")
    def public_keys(self) -> Optional[Sequence['outputs.VirtualmachinesPropertiesResponsePublicKeysPublicKeys']]:
        """
        PublicKeys - The list of SSH public keys used to authenticate with linux based VMs.
        """
        return pulumi.get(self, "public_keys")


@pulumi.output_type
class VirtualmachinesPropertiesResponseStorageProfile(dict):
    """
    StorageProfile - contains information about the disks and storage information for the virtual machine
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataDisks":
            suggest = "data_disks"
        elif key == "imageReference":
            suggest = "image_reference"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualmachinesPropertiesResponseStorageProfile. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualmachinesPropertiesResponseStorageProfile.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualmachinesPropertiesResponseStorageProfile.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_disks: Optional[Sequence['outputs.VirtualmachinesPropertiesResponseDataDisks']] = None,
                 image_reference: Optional['outputs.VirtualmachinesPropertiesResponseImageReference'] = None):
        """
        StorageProfile - contains information about the disks and storage information for the virtual machine
        :param Sequence['VirtualmachinesPropertiesResponseDataDisks'] data_disks: adds data disks to the virtual machine
        :param 'VirtualmachinesPropertiesResponseImageReference' image_reference: Which Image to use for the virtual machine
        """
        if data_disks is not None:
            pulumi.set(__self__, "data_disks", data_disks)
        if image_reference is not None:
            pulumi.set(__self__, "image_reference", image_reference)

    @property
    @pulumi.getter(name="dataDisks")
    def data_disks(self) -> Optional[Sequence['outputs.VirtualmachinesPropertiesResponseDataDisks']]:
        """
        adds data disks to the virtual machine
        """
        return pulumi.get(self, "data_disks")

    @property
    @pulumi.getter(name="imageReference")
    def image_reference(self) -> Optional['outputs.VirtualmachinesPropertiesResponseImageReference']:
        """
        Which Image to use for the virtual machine
        """
        return pulumi.get(self, "image_reference")


@pulumi.output_type
class VirtualmachinesPropertiesResponseWindowsConfiguration(dict):
    """
    Windows Configuration for the virtual machine 
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableAutomaticUpdates":
            suggest = "enable_automatic_updates"
        elif key == "timeZone":
            suggest = "time_zone"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualmachinesPropertiesResponseWindowsConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualmachinesPropertiesResponseWindowsConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualmachinesPropertiesResponseWindowsConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_automatic_updates: Optional[bool] = None,
                 ssh: Optional['outputs.VirtualmachinesPropertiesResponseSshSsh'] = None,
                 time_zone: Optional[str] = None):
        """
        Windows Configuration for the virtual machine 
        :param bool enable_automatic_updates: Whether to EnableAutomaticUpdates on the machine
        :param 'VirtualmachinesPropertiesResponseSshSsh' ssh: SSH Configuration
        :param str time_zone: TimeZone for the virtual machine
        """
        if enable_automatic_updates is not None:
            pulumi.set(__self__, "enable_automatic_updates", enable_automatic_updates)
        if ssh is not None:
            pulumi.set(__self__, "ssh", ssh)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)

    @property
    @pulumi.getter(name="enableAutomaticUpdates")
    def enable_automatic_updates(self) -> Optional[bool]:
        """
        Whether to EnableAutomaticUpdates on the machine
        """
        return pulumi.get(self, "enable_automatic_updates")

    @property
    @pulumi.getter
    def ssh(self) -> Optional['outputs.VirtualmachinesPropertiesResponseSshSsh']:
        """
        SSH Configuration
        """
        return pulumi.get(self, "ssh")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[str]:
        """
        TimeZone for the virtual machine
        """
        return pulumi.get(self, "time_zone")


@pulumi.output_type
class VirtualnetworksPropertiesResponseIpConfigurationReferences(dict):
    """
    IPConfigurationReference - Describes a IPConfiguration under the virtual network
    """
    def __init__(__self__, *,
                 id: Optional[str] = None):
        """
        IPConfigurationReference - Describes a IPConfiguration under the virtual network
        :param str id: Name of the Ip Configuration
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Name of the Ip Configuration
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class VirtualnetworksPropertiesResponseRouteTable(dict):
    """
    RouteTable for the subnet
    """
    def __init__(__self__, *,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 routes: Optional[Sequence['outputs.VirtualnetworksPropertiesResponseRoutes']] = None,
                 type: Optional[str] = None):
        """
        RouteTable for the subnet
        :param str id: route ID - ID of the IP route
        :param str name: Name - READ-ONLY; Resource name.
        :param Sequence['VirtualnetworksPropertiesResponseRoutes'] routes: Routes - Collection of routes contained within a route table.
        :param str type: Type - READ-ONLY; Resource type.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if routes is not None:
            pulumi.set(__self__, "routes", routes)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        route ID - ID of the IP route
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name - READ-ONLY; Resource name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def routes(self) -> Optional[Sequence['outputs.VirtualnetworksPropertiesResponseRoutes']]:
        """
        Routes - Collection of routes contained within a route table.
        """
        return pulumi.get(self, "routes")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Type - READ-ONLY; Resource type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class VirtualnetworksPropertiesResponseRoutes(dict):
    """
    Route is associated with a subnet.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "addressPrefix":
            suggest = "address_prefix"
        elif key == "nextHopIpAddress":
            suggest = "next_hop_ip_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualnetworksPropertiesResponseRoutes. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualnetworksPropertiesResponseRoutes.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualnetworksPropertiesResponseRoutes.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address_prefix: Optional[str] = None,
                 name: Optional[str] = None,
                 next_hop_ip_address: Optional[str] = None):
        """
        Route is associated with a subnet.
        :param str address_prefix: AddressPrefix - The destination CIDR to which the route applies.
        :param str name: Name - name of the subnet
        :param str next_hop_ip_address: NextHopIPAddress - The IP address packets should be forwarded to. Next hop values are only allowed in routes where the next hop type is VirtualAppliance.
        """
        if address_prefix is not None:
            pulumi.set(__self__, "address_prefix", address_prefix)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if next_hop_ip_address is not None:
            pulumi.set(__self__, "next_hop_ip_address", next_hop_ip_address)

    @property
    @pulumi.getter(name="addressPrefix")
    def address_prefix(self) -> Optional[str]:
        """
        AddressPrefix - The destination CIDR to which the route applies.
        """
        return pulumi.get(self, "address_prefix")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name - name of the subnet
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nextHopIpAddress")
    def next_hop_ip_address(self) -> Optional[str]:
        """
        NextHopIPAddress - The IP address packets should be forwarded to. Next hop values are only allowed in routes where the next hop type is VirtualAppliance.
        """
        return pulumi.get(self, "next_hop_ip_address")


@pulumi.output_type
class VirtualnetworksPropertiesResponseSubnets(dict):
    """
    Subnet subnet in a virtual network resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "addressPrefix":
            suggest = "address_prefix"
        elif key == "addressPrefixes":
            suggest = "address_prefixes"
        elif key == "ipAllocationMethod":
            suggest = "ip_allocation_method"
        elif key == "ipConfigurationReferences":
            suggest = "ip_configuration_references"
        elif key == "ipPools":
            suggest = "ip_pools"
        elif key == "routeTable":
            suggest = "route_table"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualnetworksPropertiesResponseSubnets. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualnetworksPropertiesResponseSubnets.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualnetworksPropertiesResponseSubnets.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address_prefix: Optional[str] = None,
                 address_prefixes: Optional[Sequence[str]] = None,
                 ip_allocation_method: Optional[str] = None,
                 ip_configuration_references: Optional[Sequence['outputs.VirtualnetworksPropertiesResponseIpConfigurationReferences']] = None,
                 ip_pools: Optional[Sequence['outputs.IPPoolResponse']] = None,
                 name: Optional[str] = None,
                 route_table: Optional['outputs.VirtualnetworksPropertiesResponseRouteTable'] = None,
                 vlan: Optional[int] = None):
        """
        Subnet subnet in a virtual network resource.
        :param str address_prefix: Cidr for this subnet - IPv4, IPv6
        :param Sequence[str] address_prefixes: AddressPrefixes - List of address prefixes for the subnet.
        :param str ip_allocation_method: IPAllocationMethod - The IP address allocation method. Possible values include: 'Static', 'Dynamic'
        :param Sequence['VirtualnetworksPropertiesResponseIpConfigurationReferences'] ip_configuration_references: IPConfigurationReferences - list of IPConfigurationReferences
        :param Sequence['IPPoolResponse'] ip_pools: network associated pool of IP Addresses
        :param str name: Name - The name of the resource that is unique within a resource group. This name can be used to access the resource.
        :param 'VirtualnetworksPropertiesResponseRouteTable' route_table: RouteTable for the subnet
        :param int vlan: Vlan to use for the subnet
        """
        if address_prefix is not None:
            pulumi.set(__self__, "address_prefix", address_prefix)
        if address_prefixes is not None:
            pulumi.set(__self__, "address_prefixes", address_prefixes)
        if ip_allocation_method is not None:
            pulumi.set(__self__, "ip_allocation_method", ip_allocation_method)
        if ip_configuration_references is not None:
            pulumi.set(__self__, "ip_configuration_references", ip_configuration_references)
        if ip_pools is not None:
            pulumi.set(__self__, "ip_pools", ip_pools)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if route_table is not None:
            pulumi.set(__self__, "route_table", route_table)
        if vlan is not None:
            pulumi.set(__self__, "vlan", vlan)

    @property
    @pulumi.getter(name="addressPrefix")
    def address_prefix(self) -> Optional[str]:
        """
        Cidr for this subnet - IPv4, IPv6
        """
        return pulumi.get(self, "address_prefix")

    @property
    @pulumi.getter(name="addressPrefixes")
    def address_prefixes(self) -> Optional[Sequence[str]]:
        """
        AddressPrefixes - List of address prefixes for the subnet.
        """
        return pulumi.get(self, "address_prefixes")

    @property
    @pulumi.getter(name="ipAllocationMethod")
    def ip_allocation_method(self) -> Optional[str]:
        """
        IPAllocationMethod - The IP address allocation method. Possible values include: 'Static', 'Dynamic'
        """
        return pulumi.get(self, "ip_allocation_method")

    @property
    @pulumi.getter(name="ipConfigurationReferences")
    def ip_configuration_references(self) -> Optional[Sequence['outputs.VirtualnetworksPropertiesResponseIpConfigurationReferences']]:
        """
        IPConfigurationReferences - list of IPConfigurationReferences
        """
        return pulumi.get(self, "ip_configuration_references")

    @property
    @pulumi.getter(name="ipPools")
    def ip_pools(self) -> Optional[Sequence['outputs.IPPoolResponse']]:
        """
        network associated pool of IP Addresses
        """
        return pulumi.get(self, "ip_pools")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name - The name of the resource that is unique within a resource group. This name can be used to access the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="routeTable")
    def route_table(self) -> Optional['outputs.VirtualnetworksPropertiesResponseRouteTable']:
        """
        RouteTable for the subnet
        """
        return pulumi.get(self, "route_table")

    @property
    @pulumi.getter
    def vlan(self) -> Optional[int]:
        """
        Vlan to use for the subnet
        """
        return pulumi.get(self, "vlan")


