# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'BackendPoolsSettingsArgs',
    'BackendPoolArgs',
    'BackendArgs',
    'CacheConfigurationArgs',
    'CustomRuleListArgs',
    'CustomRuleArgs',
    'ForwardingConfigurationArgs',
    'FrontDoorManagedRuleGroupOverrideArgs',
    'FrontDoorManagedRuleOverrideArgs',
    'FrontDoorManagedRuleSetArgs',
    'FrontDoorMatchConditionArgs',
    'FrontDoorPolicySettingsArgs',
    'FrontendEndpointUpdateParametersWebApplicationFirewallPolicyLinkArgs',
    'FrontendEndpointArgs',
    'HeaderActionArgs',
    'HealthProbeSettingsModelArgs',
    'LoadBalancingSettingsModelArgs',
    'ManagedRuleExclusionArgs',
    'ManagedRuleSetListArgs',
    'RedirectConfigurationArgs',
    'RoutingRuleUpdateParametersWebApplicationFirewallPolicyLinkArgs',
    'RoutingRuleArgs',
    'RulesEngineActionArgs',
    'RulesEngineMatchConditionArgs',
    'RulesEngineRuleArgs',
    'SkuArgs',
    'SubResourceArgs',
]

@pulumi.input_type
class BackendPoolsSettingsArgs:
    def __init__(__self__, *,
                 enforce_certificate_name_check: Optional[pulumi.Input[Union[str, 'EnforceCertificateNameCheckEnabledState']]] = None,
                 send_recv_timeout_seconds: Optional[pulumi.Input[int]] = None):
        """
        Settings that apply to all backend pools.
        :param pulumi.Input[Union[str, 'EnforceCertificateNameCheckEnabledState']] enforce_certificate_name_check: Whether to enforce certificate name check on HTTPS requests to all backend pools. No effect on non-HTTPS requests.
        :param pulumi.Input[int] send_recv_timeout_seconds: Send and receive timeout on forwarding request to the backend. When timeout is reached, the request fails and returns.
        """
        if enforce_certificate_name_check is None:
            enforce_certificate_name_check = 'Enabled'
        if enforce_certificate_name_check is not None:
            pulumi.set(__self__, "enforce_certificate_name_check", enforce_certificate_name_check)
        if send_recv_timeout_seconds is not None:
            pulumi.set(__self__, "send_recv_timeout_seconds", send_recv_timeout_seconds)

    @property
    @pulumi.getter(name="enforceCertificateNameCheck")
    def enforce_certificate_name_check(self) -> Optional[pulumi.Input[Union[str, 'EnforceCertificateNameCheckEnabledState']]]:
        """
        Whether to enforce certificate name check on HTTPS requests to all backend pools. No effect on non-HTTPS requests.
        """
        return pulumi.get(self, "enforce_certificate_name_check")

    @enforce_certificate_name_check.setter
    def enforce_certificate_name_check(self, value: Optional[pulumi.Input[Union[str, 'EnforceCertificateNameCheckEnabledState']]]):
        pulumi.set(self, "enforce_certificate_name_check", value)

    @property
    @pulumi.getter(name="sendRecvTimeoutSeconds")
    def send_recv_timeout_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        Send and receive timeout on forwarding request to the backend. When timeout is reached, the request fails and returns.
        """
        return pulumi.get(self, "send_recv_timeout_seconds")

    @send_recv_timeout_seconds.setter
    def send_recv_timeout_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "send_recv_timeout_seconds", value)


@pulumi.input_type
class BackendPoolArgs:
    def __init__(__self__, *,
                 backends: Optional[pulumi.Input[Sequence[pulumi.Input['BackendArgs']]]] = None,
                 health_probe_settings: Optional[pulumi.Input['SubResourceArgs']] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 load_balancing_settings: Optional[pulumi.Input['SubResourceArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        A backend pool is a collection of backends that can be routed to.
        :param pulumi.Input[Sequence[pulumi.Input['BackendArgs']]] backends: The set of backends for this pool
        :param pulumi.Input['SubResourceArgs'] health_probe_settings: L7 health probe settings for a backend pool
        :param pulumi.Input[str] id: Resource ID.
        :param pulumi.Input['SubResourceArgs'] load_balancing_settings: Load balancing settings for a backend pool
        :param pulumi.Input[str] name: Resource name.
        """
        if backends is not None:
            pulumi.set(__self__, "backends", backends)
        if health_probe_settings is not None:
            pulumi.set(__self__, "health_probe_settings", health_probe_settings)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if load_balancing_settings is not None:
            pulumi.set(__self__, "load_balancing_settings", load_balancing_settings)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def backends(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BackendArgs']]]]:
        """
        The set of backends for this pool
        """
        return pulumi.get(self, "backends")

    @backends.setter
    def backends(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BackendArgs']]]]):
        pulumi.set(self, "backends", value)

    @property
    @pulumi.getter(name="healthProbeSettings")
    def health_probe_settings(self) -> Optional[pulumi.Input['SubResourceArgs']]:
        """
        L7 health probe settings for a backend pool
        """
        return pulumi.get(self, "health_probe_settings")

    @health_probe_settings.setter
    def health_probe_settings(self, value: Optional[pulumi.Input['SubResourceArgs']]):
        pulumi.set(self, "health_probe_settings", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="loadBalancingSettings")
    def load_balancing_settings(self) -> Optional[pulumi.Input['SubResourceArgs']]:
        """
        Load balancing settings for a backend pool
        """
        return pulumi.get(self, "load_balancing_settings")

    @load_balancing_settings.setter
    def load_balancing_settings(self, value: Optional[pulumi.Input['SubResourceArgs']]):
        pulumi.set(self, "load_balancing_settings", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class BackendArgs:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[str]] = None,
                 backend_host_header: Optional[pulumi.Input[str]] = None,
                 enabled_state: Optional[pulumi.Input[Union[str, 'BackendEnabledState']]] = None,
                 http_port: Optional[pulumi.Input[int]] = None,
                 https_port: Optional[pulumi.Input[int]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 private_link_alias: Optional[pulumi.Input[str]] = None,
                 private_link_approval_message: Optional[pulumi.Input[str]] = None,
                 private_link_location: Optional[pulumi.Input[str]] = None,
                 private_link_resource_id: Optional[pulumi.Input[str]] = None,
                 weight: Optional[pulumi.Input[int]] = None):
        """
        Backend address of a frontDoor load balancer.
        :param pulumi.Input[str] address: Location of the backend (IP address or FQDN)
        :param pulumi.Input[str] backend_host_header: The value to use as the host header sent to the backend. If blank or unspecified, this defaults to the incoming host.
        :param pulumi.Input[Union[str, 'BackendEnabledState']] enabled_state: Whether to enable use of this backend. Permitted values are 'Enabled' or 'Disabled'
        :param pulumi.Input[int] http_port: The HTTP TCP port number. Must be between 1 and 65535.
        :param pulumi.Input[int] https_port: The HTTPS TCP port number. Must be between 1 and 65535.
        :param pulumi.Input[int] priority: Priority to use for load balancing. Higher priorities will not be used for load balancing if any lower priority backend is healthy.
        :param pulumi.Input[str] private_link_alias: The Alias of the Private Link resource. Populating this optional field indicates that this backend is 'Private'
        :param pulumi.Input[str] private_link_approval_message: A custom message to be included in the approval request to connect to the Private Link
        :param pulumi.Input[str] private_link_location: The location of the Private Link resource. Required only if 'privateLinkResourceId' is populated
        :param pulumi.Input[str] private_link_resource_id: The Resource Id of the Private Link resource. Populating this optional field indicates that this backend is 'Private'
        :param pulumi.Input[int] weight: Weight of this endpoint for load balancing purposes.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if backend_host_header is not None:
            pulumi.set(__self__, "backend_host_header", backend_host_header)
        if enabled_state is not None:
            pulumi.set(__self__, "enabled_state", enabled_state)
        if http_port is not None:
            pulumi.set(__self__, "http_port", http_port)
        if https_port is not None:
            pulumi.set(__self__, "https_port", https_port)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if private_link_alias is not None:
            pulumi.set(__self__, "private_link_alias", private_link_alias)
        if private_link_approval_message is not None:
            pulumi.set(__self__, "private_link_approval_message", private_link_approval_message)
        if private_link_location is not None:
            pulumi.set(__self__, "private_link_location", private_link_location)
        if private_link_resource_id is not None:
            pulumi.set(__self__, "private_link_resource_id", private_link_resource_id)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[str]]:
        """
        Location of the backend (IP address or FQDN)
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter(name="backendHostHeader")
    def backend_host_header(self) -> Optional[pulumi.Input[str]]:
        """
        The value to use as the host header sent to the backend. If blank or unspecified, this defaults to the incoming host.
        """
        return pulumi.get(self, "backend_host_header")

    @backend_host_header.setter
    def backend_host_header(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backend_host_header", value)

    @property
    @pulumi.getter(name="enabledState")
    def enabled_state(self) -> Optional[pulumi.Input[Union[str, 'BackendEnabledState']]]:
        """
        Whether to enable use of this backend. Permitted values are 'Enabled' or 'Disabled'
        """
        return pulumi.get(self, "enabled_state")

    @enabled_state.setter
    def enabled_state(self, value: Optional[pulumi.Input[Union[str, 'BackendEnabledState']]]):
        pulumi.set(self, "enabled_state", value)

    @property
    @pulumi.getter(name="httpPort")
    def http_port(self) -> Optional[pulumi.Input[int]]:
        """
        The HTTP TCP port number. Must be between 1 and 65535.
        """
        return pulumi.get(self, "http_port")

    @http_port.setter
    def http_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "http_port", value)

    @property
    @pulumi.getter(name="httpsPort")
    def https_port(self) -> Optional[pulumi.Input[int]]:
        """
        The HTTPS TCP port number. Must be between 1 and 65535.
        """
        return pulumi.get(self, "https_port")

    @https_port.setter
    def https_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "https_port", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[int]]:
        """
        Priority to use for load balancing. Higher priorities will not be used for load balancing if any lower priority backend is healthy.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter(name="privateLinkAlias")
    def private_link_alias(self) -> Optional[pulumi.Input[str]]:
        """
        The Alias of the Private Link resource. Populating this optional field indicates that this backend is 'Private'
        """
        return pulumi.get(self, "private_link_alias")

    @private_link_alias.setter
    def private_link_alias(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_link_alias", value)

    @property
    @pulumi.getter(name="privateLinkApprovalMessage")
    def private_link_approval_message(self) -> Optional[pulumi.Input[str]]:
        """
        A custom message to be included in the approval request to connect to the Private Link
        """
        return pulumi.get(self, "private_link_approval_message")

    @private_link_approval_message.setter
    def private_link_approval_message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_link_approval_message", value)

    @property
    @pulumi.getter(name="privateLinkLocation")
    def private_link_location(self) -> Optional[pulumi.Input[str]]:
        """
        The location of the Private Link resource. Required only if 'privateLinkResourceId' is populated
        """
        return pulumi.get(self, "private_link_location")

    @private_link_location.setter
    def private_link_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_link_location", value)

    @property
    @pulumi.getter(name="privateLinkResourceId")
    def private_link_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Resource Id of the Private Link resource. Populating this optional field indicates that this backend is 'Private'
        """
        return pulumi.get(self, "private_link_resource_id")

    @private_link_resource_id.setter
    def private_link_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_link_resource_id", value)

    @property
    @pulumi.getter
    def weight(self) -> Optional[pulumi.Input[int]]:
        """
        Weight of this endpoint for load balancing purposes.
        """
        return pulumi.get(self, "weight")

    @weight.setter
    def weight(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "weight", value)


@pulumi.input_type
class CacheConfigurationArgs:
    def __init__(__self__, *,
                 cache_duration: Optional[pulumi.Input[str]] = None,
                 dynamic_compression: Optional[pulumi.Input[Union[str, 'DynamicCompressionEnabled']]] = None,
                 query_parameter_strip_directive: Optional[pulumi.Input[Union[str, 'FrontDoorQuery']]] = None,
                 query_parameters: Optional[pulumi.Input[str]] = None):
        """
        Caching settings for a caching-type route. To disable caching, do not provide a cacheConfiguration object.
        :param pulumi.Input[str] cache_duration: The duration for which the content needs to be cached. Allowed format is in ISO 8601 format (http://en.wikipedia.org/wiki/ISO_8601#Durations). HTTP requires the value to be no more than a year
        :param pulumi.Input[Union[str, 'DynamicCompressionEnabled']] dynamic_compression: Whether to use dynamic compression for cached content
        :param pulumi.Input[Union[str, 'FrontDoorQuery']] query_parameter_strip_directive: Treatment of URL query terms when forming the cache key.
        :param pulumi.Input[str] query_parameters: query parameters to include or exclude (comma separated).
        """
        if cache_duration is not None:
            pulumi.set(__self__, "cache_duration", cache_duration)
        if dynamic_compression is not None:
            pulumi.set(__self__, "dynamic_compression", dynamic_compression)
        if query_parameter_strip_directive is not None:
            pulumi.set(__self__, "query_parameter_strip_directive", query_parameter_strip_directive)
        if query_parameters is not None:
            pulumi.set(__self__, "query_parameters", query_parameters)

    @property
    @pulumi.getter(name="cacheDuration")
    def cache_duration(self) -> Optional[pulumi.Input[str]]:
        """
        The duration for which the content needs to be cached. Allowed format is in ISO 8601 format (http://en.wikipedia.org/wiki/ISO_8601#Durations). HTTP requires the value to be no more than a year
        """
        return pulumi.get(self, "cache_duration")

    @cache_duration.setter
    def cache_duration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cache_duration", value)

    @property
    @pulumi.getter(name="dynamicCompression")
    def dynamic_compression(self) -> Optional[pulumi.Input[Union[str, 'DynamicCompressionEnabled']]]:
        """
        Whether to use dynamic compression for cached content
        """
        return pulumi.get(self, "dynamic_compression")

    @dynamic_compression.setter
    def dynamic_compression(self, value: Optional[pulumi.Input[Union[str, 'DynamicCompressionEnabled']]]):
        pulumi.set(self, "dynamic_compression", value)

    @property
    @pulumi.getter(name="queryParameterStripDirective")
    def query_parameter_strip_directive(self) -> Optional[pulumi.Input[Union[str, 'FrontDoorQuery']]]:
        """
        Treatment of URL query terms when forming the cache key.
        """
        return pulumi.get(self, "query_parameter_strip_directive")

    @query_parameter_strip_directive.setter
    def query_parameter_strip_directive(self, value: Optional[pulumi.Input[Union[str, 'FrontDoorQuery']]]):
        pulumi.set(self, "query_parameter_strip_directive", value)

    @property
    @pulumi.getter(name="queryParameters")
    def query_parameters(self) -> Optional[pulumi.Input[str]]:
        """
        query parameters to include or exclude (comma separated).
        """
        return pulumi.get(self, "query_parameters")

    @query_parameters.setter
    def query_parameters(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "query_parameters", value)


@pulumi.input_type
class CustomRuleListArgs:
    def __init__(__self__, *,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['CustomRuleArgs']]]] = None):
        """
        Defines contents of custom rules
        :param pulumi.Input[Sequence[pulumi.Input['CustomRuleArgs']]] rules: List of rules
        """
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CustomRuleArgs']]]]:
        """
        List of rules
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CustomRuleArgs']]]]):
        pulumi.set(self, "rules", value)


@pulumi.input_type
class CustomRuleArgs:
    def __init__(__self__, *,
                 action: pulumi.Input[Union[str, 'ActionType']],
                 match_conditions: pulumi.Input[Sequence[pulumi.Input['FrontDoorMatchConditionArgs']]],
                 priority: pulumi.Input[int],
                 rule_type: pulumi.Input[Union[str, 'RuleType']],
                 enabled_state: Optional[pulumi.Input[Union[str, 'CustomRuleEnabledState']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 rate_limit_duration_in_minutes: Optional[pulumi.Input[int]] = None,
                 rate_limit_threshold: Optional[pulumi.Input[int]] = None):
        """
        Defines contents of a web application rule
        :param pulumi.Input[Union[str, 'ActionType']] action: Describes what action to be applied when rule matches.
        :param pulumi.Input[Sequence[pulumi.Input['FrontDoorMatchConditionArgs']]] match_conditions: List of match conditions.
        :param pulumi.Input[int] priority: Describes priority of the rule. Rules with a lower value will be evaluated before rules with a higher value.
        :param pulumi.Input[Union[str, 'RuleType']] rule_type: Describes type of rule.
        :param pulumi.Input[Union[str, 'CustomRuleEnabledState']] enabled_state: Describes if the custom rule is in enabled or disabled state. Defaults to Enabled if not specified.
        :param pulumi.Input[str] name: Describes the name of the rule.
        :param pulumi.Input[int] rate_limit_duration_in_minutes: Time window for resetting the rate limit count. Default is 1 minute.
        :param pulumi.Input[int] rate_limit_threshold: Number of allowed requests per client within the time window.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "match_conditions", match_conditions)
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "rule_type", rule_type)
        if enabled_state is not None:
            pulumi.set(__self__, "enabled_state", enabled_state)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if rate_limit_duration_in_minutes is not None:
            pulumi.set(__self__, "rate_limit_duration_in_minutes", rate_limit_duration_in_minutes)
        if rate_limit_threshold is not None:
            pulumi.set(__self__, "rate_limit_threshold", rate_limit_threshold)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Input[Union[str, 'ActionType']]:
        """
        Describes what action to be applied when rule matches.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input[Union[str, 'ActionType']]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter(name="matchConditions")
    def match_conditions(self) -> pulumi.Input[Sequence[pulumi.Input['FrontDoorMatchConditionArgs']]]:
        """
        List of match conditions.
        """
        return pulumi.get(self, "match_conditions")

    @match_conditions.setter
    def match_conditions(self, value: pulumi.Input[Sequence[pulumi.Input['FrontDoorMatchConditionArgs']]]):
        pulumi.set(self, "match_conditions", value)

    @property
    @pulumi.getter
    def priority(self) -> pulumi.Input[int]:
        """
        Describes priority of the rule. Rules with a lower value will be evaluated before rules with a higher value.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: pulumi.Input[int]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter(name="ruleType")
    def rule_type(self) -> pulumi.Input[Union[str, 'RuleType']]:
        """
        Describes type of rule.
        """
        return pulumi.get(self, "rule_type")

    @rule_type.setter
    def rule_type(self, value: pulumi.Input[Union[str, 'RuleType']]):
        pulumi.set(self, "rule_type", value)

    @property
    @pulumi.getter(name="enabledState")
    def enabled_state(self) -> Optional[pulumi.Input[Union[str, 'CustomRuleEnabledState']]]:
        """
        Describes if the custom rule is in enabled or disabled state. Defaults to Enabled if not specified.
        """
        return pulumi.get(self, "enabled_state")

    @enabled_state.setter
    def enabled_state(self, value: Optional[pulumi.Input[Union[str, 'CustomRuleEnabledState']]]):
        pulumi.set(self, "enabled_state", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Describes the name of the rule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="rateLimitDurationInMinutes")
    def rate_limit_duration_in_minutes(self) -> Optional[pulumi.Input[int]]:
        """
        Time window for resetting the rate limit count. Default is 1 minute.
        """
        return pulumi.get(self, "rate_limit_duration_in_minutes")

    @rate_limit_duration_in_minutes.setter
    def rate_limit_duration_in_minutes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "rate_limit_duration_in_minutes", value)

    @property
    @pulumi.getter(name="rateLimitThreshold")
    def rate_limit_threshold(self) -> Optional[pulumi.Input[int]]:
        """
        Number of allowed requests per client within the time window.
        """
        return pulumi.get(self, "rate_limit_threshold")

    @rate_limit_threshold.setter
    def rate_limit_threshold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "rate_limit_threshold", value)


@pulumi.input_type
class ForwardingConfigurationArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str],
                 backend_pool: Optional[pulumi.Input['SubResourceArgs']] = None,
                 cache_configuration: Optional[pulumi.Input['CacheConfigurationArgs']] = None,
                 custom_forwarding_path: Optional[pulumi.Input[str]] = None,
                 forwarding_protocol: Optional[pulumi.Input[Union[str, 'FrontDoorForwardingProtocol']]] = None):
        """
        Describes Forwarding Route.
        :param pulumi.Input[str] odata_type: 
               Expected value is '#Microsoft.Azure.FrontDoor.Models.FrontdoorForwardingConfiguration'.
        :param pulumi.Input['SubResourceArgs'] backend_pool: A reference to the BackendPool which this rule routes to.
        :param pulumi.Input['CacheConfigurationArgs'] cache_configuration: The caching configuration associated with this rule.
        :param pulumi.Input[str] custom_forwarding_path: A custom path used to rewrite resource paths matched by this rule. Leave empty to use incoming path.
        :param pulumi.Input[Union[str, 'FrontDoorForwardingProtocol']] forwarding_protocol: Protocol this rule will use when forwarding traffic to backends.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Azure.FrontDoor.Models.FrontdoorForwardingConfiguration')
        if backend_pool is not None:
            pulumi.set(__self__, "backend_pool", backend_pool)
        if cache_configuration is not None:
            pulumi.set(__self__, "cache_configuration", cache_configuration)
        if custom_forwarding_path is not None:
            pulumi.set(__self__, "custom_forwarding_path", custom_forwarding_path)
        if forwarding_protocol is not None:
            pulumi.set(__self__, "forwarding_protocol", forwarding_protocol)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """

        Expected value is '#Microsoft.Azure.FrontDoor.Models.FrontdoorForwardingConfiguration'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter(name="backendPool")
    def backend_pool(self) -> Optional[pulumi.Input['SubResourceArgs']]:
        """
        A reference to the BackendPool which this rule routes to.
        """
        return pulumi.get(self, "backend_pool")

    @backend_pool.setter
    def backend_pool(self, value: Optional[pulumi.Input['SubResourceArgs']]):
        pulumi.set(self, "backend_pool", value)

    @property
    @pulumi.getter(name="cacheConfiguration")
    def cache_configuration(self) -> Optional[pulumi.Input['CacheConfigurationArgs']]:
        """
        The caching configuration associated with this rule.
        """
        return pulumi.get(self, "cache_configuration")

    @cache_configuration.setter
    def cache_configuration(self, value: Optional[pulumi.Input['CacheConfigurationArgs']]):
        pulumi.set(self, "cache_configuration", value)

    @property
    @pulumi.getter(name="customForwardingPath")
    def custom_forwarding_path(self) -> Optional[pulumi.Input[str]]:
        """
        A custom path used to rewrite resource paths matched by this rule. Leave empty to use incoming path.
        """
        return pulumi.get(self, "custom_forwarding_path")

    @custom_forwarding_path.setter
    def custom_forwarding_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_forwarding_path", value)

    @property
    @pulumi.getter(name="forwardingProtocol")
    def forwarding_protocol(self) -> Optional[pulumi.Input[Union[str, 'FrontDoorForwardingProtocol']]]:
        """
        Protocol this rule will use when forwarding traffic to backends.
        """
        return pulumi.get(self, "forwarding_protocol")

    @forwarding_protocol.setter
    def forwarding_protocol(self, value: Optional[pulumi.Input[Union[str, 'FrontDoorForwardingProtocol']]]):
        pulumi.set(self, "forwarding_protocol", value)


@pulumi.input_type
class FrontDoorManagedRuleGroupOverrideArgs:
    def __init__(__self__, *,
                 rule_group_name: pulumi.Input[str],
                 exclusions: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedRuleExclusionArgs']]]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['FrontDoorManagedRuleOverrideArgs']]]] = None):
        """
        Defines a managed rule group override setting.
        :param pulumi.Input[str] rule_group_name: Describes the managed rule group to override.
        :param pulumi.Input[Sequence[pulumi.Input['ManagedRuleExclusionArgs']]] exclusions: Describes the exclusions that are applied to all rules in the group.
        :param pulumi.Input[Sequence[pulumi.Input['FrontDoorManagedRuleOverrideArgs']]] rules: List of rules that will be disabled. If none specified, all rules in the group will be disabled.
        """
        pulumi.set(__self__, "rule_group_name", rule_group_name)
        if exclusions is not None:
            pulumi.set(__self__, "exclusions", exclusions)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter(name="ruleGroupName")
    def rule_group_name(self) -> pulumi.Input[str]:
        """
        Describes the managed rule group to override.
        """
        return pulumi.get(self, "rule_group_name")

    @rule_group_name.setter
    def rule_group_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "rule_group_name", value)

    @property
    @pulumi.getter
    def exclusions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ManagedRuleExclusionArgs']]]]:
        """
        Describes the exclusions that are applied to all rules in the group.
        """
        return pulumi.get(self, "exclusions")

    @exclusions.setter
    def exclusions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedRuleExclusionArgs']]]]):
        pulumi.set(self, "exclusions", value)

    @property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FrontDoorManagedRuleOverrideArgs']]]]:
        """
        List of rules that will be disabled. If none specified, all rules in the group will be disabled.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FrontDoorManagedRuleOverrideArgs']]]]):
        pulumi.set(self, "rules", value)


@pulumi.input_type
class FrontDoorManagedRuleOverrideArgs:
    def __init__(__self__, *,
                 rule_id: pulumi.Input[str],
                 action: Optional[pulumi.Input[Union[str, 'ActionType']]] = None,
                 enabled_state: Optional[pulumi.Input[Union[str, 'ManagedRuleEnabledState']]] = None,
                 exclusions: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedRuleExclusionArgs']]]] = None):
        """
        Defines a managed rule group override setting.
        :param pulumi.Input[str] rule_id: Identifier for the managed rule.
        :param pulumi.Input[Union[str, 'ActionType']] action: Describes the override action to be applied when rule matches.
        :param pulumi.Input[Union[str, 'ManagedRuleEnabledState']] enabled_state: Describes if the managed rule is in enabled or disabled state. Defaults to Disabled if not specified.
        :param pulumi.Input[Sequence[pulumi.Input['ManagedRuleExclusionArgs']]] exclusions: Describes the exclusions that are applied to this specific rule.
        """
        pulumi.set(__self__, "rule_id", rule_id)
        if action is not None:
            pulumi.set(__self__, "action", action)
        if enabled_state is not None:
            pulumi.set(__self__, "enabled_state", enabled_state)
        if exclusions is not None:
            pulumi.set(__self__, "exclusions", exclusions)

    @property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> pulumi.Input[str]:
        """
        Identifier for the managed rule.
        """
        return pulumi.get(self, "rule_id")

    @rule_id.setter
    def rule_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "rule_id", value)

    @property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[Union[str, 'ActionType']]]:
        """
        Describes the override action to be applied when rule matches.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[Union[str, 'ActionType']]]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter(name="enabledState")
    def enabled_state(self) -> Optional[pulumi.Input[Union[str, 'ManagedRuleEnabledState']]]:
        """
        Describes if the managed rule is in enabled or disabled state. Defaults to Disabled if not specified.
        """
        return pulumi.get(self, "enabled_state")

    @enabled_state.setter
    def enabled_state(self, value: Optional[pulumi.Input[Union[str, 'ManagedRuleEnabledState']]]):
        pulumi.set(self, "enabled_state", value)

    @property
    @pulumi.getter
    def exclusions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ManagedRuleExclusionArgs']]]]:
        """
        Describes the exclusions that are applied to this specific rule.
        """
        return pulumi.get(self, "exclusions")

    @exclusions.setter
    def exclusions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedRuleExclusionArgs']]]]):
        pulumi.set(self, "exclusions", value)


@pulumi.input_type
class FrontDoorManagedRuleSetArgs:
    def __init__(__self__, *,
                 rule_set_type: pulumi.Input[str],
                 rule_set_version: pulumi.Input[str],
                 exclusions: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedRuleExclusionArgs']]]] = None,
                 rule_group_overrides: Optional[pulumi.Input[Sequence[pulumi.Input['FrontDoorManagedRuleGroupOverrideArgs']]]] = None,
                 rule_set_action: Optional[pulumi.Input[Union[str, 'ManagedRuleSetActionType']]] = None):
        """
        Defines a managed rule set.
        :param pulumi.Input[str] rule_set_type: Defines the rule set type to use.
        :param pulumi.Input[str] rule_set_version: Defines the version of the rule set to use.
        :param pulumi.Input[Sequence[pulumi.Input['ManagedRuleExclusionArgs']]] exclusions: Describes the exclusions that are applied to all rules in the set.
        :param pulumi.Input[Sequence[pulumi.Input['FrontDoorManagedRuleGroupOverrideArgs']]] rule_group_overrides: Defines the rule group overrides to apply to the rule set.
        :param pulumi.Input[Union[str, 'ManagedRuleSetActionType']] rule_set_action: Defines the action to take when a managed rule set score threshold is met.
        """
        pulumi.set(__self__, "rule_set_type", rule_set_type)
        pulumi.set(__self__, "rule_set_version", rule_set_version)
        if exclusions is not None:
            pulumi.set(__self__, "exclusions", exclusions)
        if rule_group_overrides is not None:
            pulumi.set(__self__, "rule_group_overrides", rule_group_overrides)
        if rule_set_action is not None:
            pulumi.set(__self__, "rule_set_action", rule_set_action)

    @property
    @pulumi.getter(name="ruleSetType")
    def rule_set_type(self) -> pulumi.Input[str]:
        """
        Defines the rule set type to use.
        """
        return pulumi.get(self, "rule_set_type")

    @rule_set_type.setter
    def rule_set_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "rule_set_type", value)

    @property
    @pulumi.getter(name="ruleSetVersion")
    def rule_set_version(self) -> pulumi.Input[str]:
        """
        Defines the version of the rule set to use.
        """
        return pulumi.get(self, "rule_set_version")

    @rule_set_version.setter
    def rule_set_version(self, value: pulumi.Input[str]):
        pulumi.set(self, "rule_set_version", value)

    @property
    @pulumi.getter
    def exclusions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ManagedRuleExclusionArgs']]]]:
        """
        Describes the exclusions that are applied to all rules in the set.
        """
        return pulumi.get(self, "exclusions")

    @exclusions.setter
    def exclusions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedRuleExclusionArgs']]]]):
        pulumi.set(self, "exclusions", value)

    @property
    @pulumi.getter(name="ruleGroupOverrides")
    def rule_group_overrides(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FrontDoorManagedRuleGroupOverrideArgs']]]]:
        """
        Defines the rule group overrides to apply to the rule set.
        """
        return pulumi.get(self, "rule_group_overrides")

    @rule_group_overrides.setter
    def rule_group_overrides(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FrontDoorManagedRuleGroupOverrideArgs']]]]):
        pulumi.set(self, "rule_group_overrides", value)

    @property
    @pulumi.getter(name="ruleSetAction")
    def rule_set_action(self) -> Optional[pulumi.Input[Union[str, 'ManagedRuleSetActionType']]]:
        """
        Defines the action to take when a managed rule set score threshold is met.
        """
        return pulumi.get(self, "rule_set_action")

    @rule_set_action.setter
    def rule_set_action(self, value: Optional[pulumi.Input[Union[str, 'ManagedRuleSetActionType']]]):
        pulumi.set(self, "rule_set_action", value)


@pulumi.input_type
class FrontDoorMatchConditionArgs:
    def __init__(__self__, *,
                 match_value: pulumi.Input[Sequence[pulumi.Input[str]]],
                 match_variable: pulumi.Input[Union[str, 'FrontDoorMatchVariable']],
                 operator: pulumi.Input[Union[str, 'Operator']],
                 negate_condition: Optional[pulumi.Input[bool]] = None,
                 selector: Optional[pulumi.Input[str]] = None,
                 transforms: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'TransformType']]]]] = None):
        """
        Define a match condition.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] match_value: List of possible match values.
        :param pulumi.Input[Union[str, 'FrontDoorMatchVariable']] match_variable: Request variable to compare with.
        :param pulumi.Input[Union[str, 'Operator']] operator: Comparison type to use for matching with the variable value.
        :param pulumi.Input[bool] negate_condition: Describes if the result of this condition should be negated.
        :param pulumi.Input[str] selector: Match against a specific key from the QueryString, PostArgs, RequestHeader or Cookies variables. Default is null.
        :param pulumi.Input[Sequence[pulumi.Input[Union[str, 'TransformType']]]] transforms: List of transforms.
        """
        pulumi.set(__self__, "match_value", match_value)
        pulumi.set(__self__, "match_variable", match_variable)
        pulumi.set(__self__, "operator", operator)
        if negate_condition is not None:
            pulumi.set(__self__, "negate_condition", negate_condition)
        if selector is not None:
            pulumi.set(__self__, "selector", selector)
        if transforms is not None:
            pulumi.set(__self__, "transforms", transforms)

    @property
    @pulumi.getter(name="matchValue")
    def match_value(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        List of possible match values.
        """
        return pulumi.get(self, "match_value")

    @match_value.setter
    def match_value(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "match_value", value)

    @property
    @pulumi.getter(name="matchVariable")
    def match_variable(self) -> pulumi.Input[Union[str, 'FrontDoorMatchVariable']]:
        """
        Request variable to compare with.
        """
        return pulumi.get(self, "match_variable")

    @match_variable.setter
    def match_variable(self, value: pulumi.Input[Union[str, 'FrontDoorMatchVariable']]):
        pulumi.set(self, "match_variable", value)

    @property
    @pulumi.getter
    def operator(self) -> pulumi.Input[Union[str, 'Operator']]:
        """
        Comparison type to use for matching with the variable value.
        """
        return pulumi.get(self, "operator")

    @operator.setter
    def operator(self, value: pulumi.Input[Union[str, 'Operator']]):
        pulumi.set(self, "operator", value)

    @property
    @pulumi.getter(name="negateCondition")
    def negate_condition(self) -> Optional[pulumi.Input[bool]]:
        """
        Describes if the result of this condition should be negated.
        """
        return pulumi.get(self, "negate_condition")

    @negate_condition.setter
    def negate_condition(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "negate_condition", value)

    @property
    @pulumi.getter
    def selector(self) -> Optional[pulumi.Input[str]]:
        """
        Match against a specific key from the QueryString, PostArgs, RequestHeader or Cookies variables. Default is null.
        """
        return pulumi.get(self, "selector")

    @selector.setter
    def selector(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "selector", value)

    @property
    @pulumi.getter
    def transforms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'TransformType']]]]]:
        """
        List of transforms.
        """
        return pulumi.get(self, "transforms")

    @transforms.setter
    def transforms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'TransformType']]]]]):
        pulumi.set(self, "transforms", value)


@pulumi.input_type
class FrontDoorPolicySettingsArgs:
    def __init__(__self__, *,
                 custom_block_response_body: Optional[pulumi.Input[str]] = None,
                 custom_block_response_status_code: Optional[pulumi.Input[int]] = None,
                 enabled_state: Optional[pulumi.Input[Union[str, 'PolicyEnabledState']]] = None,
                 mode: Optional[pulumi.Input[Union[str, 'PolicyMode']]] = None,
                 redirect_url: Optional[pulumi.Input[str]] = None,
                 request_body_check: Optional[pulumi.Input[Union[str, 'PolicyRequestBodyCheck']]] = None):
        """
        Defines top-level WebApplicationFirewallPolicy configuration settings.
        :param pulumi.Input[str] custom_block_response_body: If the action type is block, customer can override the response body. The body must be specified in base64 encoding.
        :param pulumi.Input[int] custom_block_response_status_code: If the action type is block, customer can override the response status code.
        :param pulumi.Input[Union[str, 'PolicyEnabledState']] enabled_state: Describes if the policy is in enabled or disabled state. Defaults to Enabled if not specified.
        :param pulumi.Input[Union[str, 'PolicyMode']] mode: Describes if it is in detection mode or prevention mode at policy level.
        :param pulumi.Input[str] redirect_url: If action type is redirect, this field represents redirect URL for the client.
        :param pulumi.Input[Union[str, 'PolicyRequestBodyCheck']] request_body_check: Describes if policy managed rules will inspect the request body content.
        """
        if custom_block_response_body is not None:
            pulumi.set(__self__, "custom_block_response_body", custom_block_response_body)
        if custom_block_response_status_code is not None:
            pulumi.set(__self__, "custom_block_response_status_code", custom_block_response_status_code)
        if enabled_state is not None:
            pulumi.set(__self__, "enabled_state", enabled_state)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if redirect_url is not None:
            pulumi.set(__self__, "redirect_url", redirect_url)
        if request_body_check is not None:
            pulumi.set(__self__, "request_body_check", request_body_check)

    @property
    @pulumi.getter(name="customBlockResponseBody")
    def custom_block_response_body(self) -> Optional[pulumi.Input[str]]:
        """
        If the action type is block, customer can override the response body. The body must be specified in base64 encoding.
        """
        return pulumi.get(self, "custom_block_response_body")

    @custom_block_response_body.setter
    def custom_block_response_body(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_block_response_body", value)

    @property
    @pulumi.getter(name="customBlockResponseStatusCode")
    def custom_block_response_status_code(self) -> Optional[pulumi.Input[int]]:
        """
        If the action type is block, customer can override the response status code.
        """
        return pulumi.get(self, "custom_block_response_status_code")

    @custom_block_response_status_code.setter
    def custom_block_response_status_code(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "custom_block_response_status_code", value)

    @property
    @pulumi.getter(name="enabledState")
    def enabled_state(self) -> Optional[pulumi.Input[Union[str, 'PolicyEnabledState']]]:
        """
        Describes if the policy is in enabled or disabled state. Defaults to Enabled if not specified.
        """
        return pulumi.get(self, "enabled_state")

    @enabled_state.setter
    def enabled_state(self, value: Optional[pulumi.Input[Union[str, 'PolicyEnabledState']]]):
        pulumi.set(self, "enabled_state", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[Union[str, 'PolicyMode']]]:
        """
        Describes if it is in detection mode or prevention mode at policy level.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[Union[str, 'PolicyMode']]]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter(name="redirectUrl")
    def redirect_url(self) -> Optional[pulumi.Input[str]]:
        """
        If action type is redirect, this field represents redirect URL for the client.
        """
        return pulumi.get(self, "redirect_url")

    @redirect_url.setter
    def redirect_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "redirect_url", value)

    @property
    @pulumi.getter(name="requestBodyCheck")
    def request_body_check(self) -> Optional[pulumi.Input[Union[str, 'PolicyRequestBodyCheck']]]:
        """
        Describes if policy managed rules will inspect the request body content.
        """
        return pulumi.get(self, "request_body_check")

    @request_body_check.setter
    def request_body_check(self, value: Optional[pulumi.Input[Union[str, 'PolicyRequestBodyCheck']]]):
        pulumi.set(self, "request_body_check", value)


@pulumi.input_type
class FrontendEndpointUpdateParametersWebApplicationFirewallPolicyLinkArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None):
        """
        Defines the Web Application Firewall policy for each host (if applicable)
        :param pulumi.Input[str] id: Resource ID.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class FrontendEndpointArgs:
    def __init__(__self__, *,
                 host_name: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 session_affinity_enabled_state: Optional[pulumi.Input[Union[str, 'SessionAffinityEnabledState']]] = None,
                 session_affinity_ttl_seconds: Optional[pulumi.Input[int]] = None,
                 web_application_firewall_policy_link: Optional[pulumi.Input['FrontendEndpointUpdateParametersWebApplicationFirewallPolicyLinkArgs']] = None):
        """
        A frontend endpoint used for routing.
        :param pulumi.Input[str] host_name: The host name of the frontendEndpoint. Must be a domain name.
        :param pulumi.Input[str] id: Resource ID.
        :param pulumi.Input[str] name: Resource name.
        :param pulumi.Input[Union[str, 'SessionAffinityEnabledState']] session_affinity_enabled_state: Whether to allow session affinity on this host. Valid options are 'Enabled' or 'Disabled'
        :param pulumi.Input[int] session_affinity_ttl_seconds: UNUSED. This field will be ignored. The TTL to use in seconds for session affinity, if applicable.
        :param pulumi.Input['FrontendEndpointUpdateParametersWebApplicationFirewallPolicyLinkArgs'] web_application_firewall_policy_link: Defines the Web Application Firewall policy for each host (if applicable)
        """
        if host_name is not None:
            pulumi.set(__self__, "host_name", host_name)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if session_affinity_enabled_state is not None:
            pulumi.set(__self__, "session_affinity_enabled_state", session_affinity_enabled_state)
        if session_affinity_ttl_seconds is not None:
            pulumi.set(__self__, "session_affinity_ttl_seconds", session_affinity_ttl_seconds)
        if web_application_firewall_policy_link is not None:
            pulumi.set(__self__, "web_application_firewall_policy_link", web_application_firewall_policy_link)

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> Optional[pulumi.Input[str]]:
        """
        The host name of the frontendEndpoint. Must be a domain name.
        """
        return pulumi.get(self, "host_name")

    @host_name.setter
    def host_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_name", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="sessionAffinityEnabledState")
    def session_affinity_enabled_state(self) -> Optional[pulumi.Input[Union[str, 'SessionAffinityEnabledState']]]:
        """
        Whether to allow session affinity on this host. Valid options are 'Enabled' or 'Disabled'
        """
        return pulumi.get(self, "session_affinity_enabled_state")

    @session_affinity_enabled_state.setter
    def session_affinity_enabled_state(self, value: Optional[pulumi.Input[Union[str, 'SessionAffinityEnabledState']]]):
        pulumi.set(self, "session_affinity_enabled_state", value)

    @property
    @pulumi.getter(name="sessionAffinityTtlSeconds")
    def session_affinity_ttl_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        UNUSED. This field will be ignored. The TTL to use in seconds for session affinity, if applicable.
        """
        return pulumi.get(self, "session_affinity_ttl_seconds")

    @session_affinity_ttl_seconds.setter
    def session_affinity_ttl_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "session_affinity_ttl_seconds", value)

    @property
    @pulumi.getter(name="webApplicationFirewallPolicyLink")
    def web_application_firewall_policy_link(self) -> Optional[pulumi.Input['FrontendEndpointUpdateParametersWebApplicationFirewallPolicyLinkArgs']]:
        """
        Defines the Web Application Firewall policy for each host (if applicable)
        """
        return pulumi.get(self, "web_application_firewall_policy_link")

    @web_application_firewall_policy_link.setter
    def web_application_firewall_policy_link(self, value: Optional[pulumi.Input['FrontendEndpointUpdateParametersWebApplicationFirewallPolicyLinkArgs']]):
        pulumi.set(self, "web_application_firewall_policy_link", value)


@pulumi.input_type
class HeaderActionArgs:
    def __init__(__self__, *,
                 header_action_type: pulumi.Input[Union[str, 'HeaderActionType']],
                 header_name: pulumi.Input[str],
                 value: Optional[pulumi.Input[str]] = None):
        """
        An action that can manipulate an http header.
        :param pulumi.Input[Union[str, 'HeaderActionType']] header_action_type: Which type of manipulation to apply to the header.
        :param pulumi.Input[str] header_name: The name of the header this action will apply to.
        :param pulumi.Input[str] value: The value to update the given header name with. This value is not used if the actionType is Delete.
        """
        pulumi.set(__self__, "header_action_type", header_action_type)
        pulumi.set(__self__, "header_name", header_name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="headerActionType")
    def header_action_type(self) -> pulumi.Input[Union[str, 'HeaderActionType']]:
        """
        Which type of manipulation to apply to the header.
        """
        return pulumi.get(self, "header_action_type")

    @header_action_type.setter
    def header_action_type(self, value: pulumi.Input[Union[str, 'HeaderActionType']]):
        pulumi.set(self, "header_action_type", value)

    @property
    @pulumi.getter(name="headerName")
    def header_name(self) -> pulumi.Input[str]:
        """
        The name of the header this action will apply to.
        """
        return pulumi.get(self, "header_name")

    @header_name.setter
    def header_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "header_name", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        The value to update the given header name with. This value is not used if the actionType is Delete.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class HealthProbeSettingsModelArgs:
    def __init__(__self__, *,
                 enabled_state: Optional[pulumi.Input[Union[str, 'HealthProbeEnabled']]] = None,
                 health_probe_method: Optional[pulumi.Input[Union[str, 'FrontDoorHealthProbeMethod']]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 interval_in_seconds: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 protocol: Optional[pulumi.Input[Union[str, 'FrontDoorProtocol']]] = None):
        """
        Load balancing settings for a backend pool
        :param pulumi.Input[Union[str, 'HealthProbeEnabled']] enabled_state: Whether to enable health probes to be made against backends defined under backendPools. Health probes can only be disabled if there is a single enabled backend in single enabled backend pool.
        :param pulumi.Input[Union[str, 'FrontDoorHealthProbeMethod']] health_probe_method: Configures which HTTP method to use to probe the backends defined under backendPools.
        :param pulumi.Input[str] id: Resource ID.
        :param pulumi.Input[int] interval_in_seconds: The number of seconds between health probes.
        :param pulumi.Input[str] name: Resource name.
        :param pulumi.Input[str] path: The path to use for the health probe. Default is /
        :param pulumi.Input[Union[str, 'FrontDoorProtocol']] protocol: Protocol scheme to use for this probe
        """
        if enabled_state is not None:
            pulumi.set(__self__, "enabled_state", enabled_state)
        if health_probe_method is None:
            health_probe_method = 'HEAD'
        if health_probe_method is not None:
            pulumi.set(__self__, "health_probe_method", health_probe_method)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if interval_in_seconds is not None:
            pulumi.set(__self__, "interval_in_seconds", interval_in_seconds)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter(name="enabledState")
    def enabled_state(self) -> Optional[pulumi.Input[Union[str, 'HealthProbeEnabled']]]:
        """
        Whether to enable health probes to be made against backends defined under backendPools. Health probes can only be disabled if there is a single enabled backend in single enabled backend pool.
        """
        return pulumi.get(self, "enabled_state")

    @enabled_state.setter
    def enabled_state(self, value: Optional[pulumi.Input[Union[str, 'HealthProbeEnabled']]]):
        pulumi.set(self, "enabled_state", value)

    @property
    @pulumi.getter(name="healthProbeMethod")
    def health_probe_method(self) -> Optional[pulumi.Input[Union[str, 'FrontDoorHealthProbeMethod']]]:
        """
        Configures which HTTP method to use to probe the backends defined under backendPools.
        """
        return pulumi.get(self, "health_probe_method")

    @health_probe_method.setter
    def health_probe_method(self, value: Optional[pulumi.Input[Union[str, 'FrontDoorHealthProbeMethod']]]):
        pulumi.set(self, "health_probe_method", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="intervalInSeconds")
    def interval_in_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        The number of seconds between health probes.
        """
        return pulumi.get(self, "interval_in_seconds")

    @interval_in_seconds.setter
    def interval_in_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "interval_in_seconds", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        The path to use for the health probe. Default is /
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[Union[str, 'FrontDoorProtocol']]]:
        """
        Protocol scheme to use for this probe
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[Union[str, 'FrontDoorProtocol']]]):
        pulumi.set(self, "protocol", value)


@pulumi.input_type
class LoadBalancingSettingsModelArgs:
    def __init__(__self__, *,
                 additional_latency_milliseconds: Optional[pulumi.Input[int]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 sample_size: Optional[pulumi.Input[int]] = None,
                 successful_samples_required: Optional[pulumi.Input[int]] = None):
        """
        Load balancing settings for a backend pool
        :param pulumi.Input[int] additional_latency_milliseconds: The additional latency in milliseconds for probes to fall into the lowest latency bucket
        :param pulumi.Input[str] id: Resource ID.
        :param pulumi.Input[str] name: Resource name.
        :param pulumi.Input[int] sample_size: The number of samples to consider for load balancing decisions
        :param pulumi.Input[int] successful_samples_required: The number of samples within the sample period that must succeed
        """
        if additional_latency_milliseconds is not None:
            pulumi.set(__self__, "additional_latency_milliseconds", additional_latency_milliseconds)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if sample_size is not None:
            pulumi.set(__self__, "sample_size", sample_size)
        if successful_samples_required is not None:
            pulumi.set(__self__, "successful_samples_required", successful_samples_required)

    @property
    @pulumi.getter(name="additionalLatencyMilliseconds")
    def additional_latency_milliseconds(self) -> Optional[pulumi.Input[int]]:
        """
        The additional latency in milliseconds for probes to fall into the lowest latency bucket
        """
        return pulumi.get(self, "additional_latency_milliseconds")

    @additional_latency_milliseconds.setter
    def additional_latency_milliseconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "additional_latency_milliseconds", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="sampleSize")
    def sample_size(self) -> Optional[pulumi.Input[int]]:
        """
        The number of samples to consider for load balancing decisions
        """
        return pulumi.get(self, "sample_size")

    @sample_size.setter
    def sample_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "sample_size", value)

    @property
    @pulumi.getter(name="successfulSamplesRequired")
    def successful_samples_required(self) -> Optional[pulumi.Input[int]]:
        """
        The number of samples within the sample period that must succeed
        """
        return pulumi.get(self, "successful_samples_required")

    @successful_samples_required.setter
    def successful_samples_required(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "successful_samples_required", value)


@pulumi.input_type
class ManagedRuleExclusionArgs:
    def __init__(__self__, *,
                 match_variable: pulumi.Input[Union[str, 'ManagedRuleExclusionMatchVariable']],
                 selector: pulumi.Input[str],
                 selector_match_operator: pulumi.Input[Union[str, 'ManagedRuleExclusionSelectorMatchOperator']]):
        """
        Exclude variables from managed rule evaluation.
        :param pulumi.Input[Union[str, 'ManagedRuleExclusionMatchVariable']] match_variable: The variable type to be excluded.
        :param pulumi.Input[str] selector: Selector value for which elements in the collection this exclusion applies to.
        :param pulumi.Input[Union[str, 'ManagedRuleExclusionSelectorMatchOperator']] selector_match_operator: Comparison operator to apply to the selector when specifying which elements in the collection this exclusion applies to.
        """
        pulumi.set(__self__, "match_variable", match_variable)
        pulumi.set(__self__, "selector", selector)
        pulumi.set(__self__, "selector_match_operator", selector_match_operator)

    @property
    @pulumi.getter(name="matchVariable")
    def match_variable(self) -> pulumi.Input[Union[str, 'ManagedRuleExclusionMatchVariable']]:
        """
        The variable type to be excluded.
        """
        return pulumi.get(self, "match_variable")

    @match_variable.setter
    def match_variable(self, value: pulumi.Input[Union[str, 'ManagedRuleExclusionMatchVariable']]):
        pulumi.set(self, "match_variable", value)

    @property
    @pulumi.getter
    def selector(self) -> pulumi.Input[str]:
        """
        Selector value for which elements in the collection this exclusion applies to.
        """
        return pulumi.get(self, "selector")

    @selector.setter
    def selector(self, value: pulumi.Input[str]):
        pulumi.set(self, "selector", value)

    @property
    @pulumi.getter(name="selectorMatchOperator")
    def selector_match_operator(self) -> pulumi.Input[Union[str, 'ManagedRuleExclusionSelectorMatchOperator']]:
        """
        Comparison operator to apply to the selector when specifying which elements in the collection this exclusion applies to.
        """
        return pulumi.get(self, "selector_match_operator")

    @selector_match_operator.setter
    def selector_match_operator(self, value: pulumi.Input[Union[str, 'ManagedRuleExclusionSelectorMatchOperator']]):
        pulumi.set(self, "selector_match_operator", value)


@pulumi.input_type
class ManagedRuleSetListArgs:
    def __init__(__self__, *,
                 managed_rule_sets: Optional[pulumi.Input[Sequence[pulumi.Input['FrontDoorManagedRuleSetArgs']]]] = None):
        """
        Defines the list of managed rule sets for the policy.
        :param pulumi.Input[Sequence[pulumi.Input['FrontDoorManagedRuleSetArgs']]] managed_rule_sets: List of rule sets.
        """
        if managed_rule_sets is not None:
            pulumi.set(__self__, "managed_rule_sets", managed_rule_sets)

    @property
    @pulumi.getter(name="managedRuleSets")
    def managed_rule_sets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FrontDoorManagedRuleSetArgs']]]]:
        """
        List of rule sets.
        """
        return pulumi.get(self, "managed_rule_sets")

    @managed_rule_sets.setter
    def managed_rule_sets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FrontDoorManagedRuleSetArgs']]]]):
        pulumi.set(self, "managed_rule_sets", value)


@pulumi.input_type
class RedirectConfigurationArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str],
                 custom_fragment: Optional[pulumi.Input[str]] = None,
                 custom_host: Optional[pulumi.Input[str]] = None,
                 custom_path: Optional[pulumi.Input[str]] = None,
                 custom_query_string: Optional[pulumi.Input[str]] = None,
                 redirect_protocol: Optional[pulumi.Input[Union[str, 'FrontDoorRedirectProtocol']]] = None,
                 redirect_type: Optional[pulumi.Input[Union[str, 'FrontDoorRedirectType']]] = None):
        """
        Describes Redirect Route.
        :param pulumi.Input[str] odata_type: 
               Expected value is '#Microsoft.Azure.FrontDoor.Models.FrontdoorRedirectConfiguration'.
        :param pulumi.Input[str] custom_fragment: Fragment to add to the redirect URL. Fragment is the part of the URL that comes after #. Do not include the #.
        :param pulumi.Input[str] custom_host: Host to redirect. Leave empty to use the incoming host as the destination host.
        :param pulumi.Input[str] custom_path: The full path to redirect. Path cannot be empty and must start with /. Leave empty to use the incoming path as destination path.
        :param pulumi.Input[str] custom_query_string: The set of query strings to be placed in the redirect URL. Setting this value would replace any existing query string; leave empty to preserve the incoming query string. Query string must be in <key>=<value> format. The first ? and & will be added automatically so do not include them in the front, but do separate multiple query strings with &.
        :param pulumi.Input[Union[str, 'FrontDoorRedirectProtocol']] redirect_protocol: The protocol of the destination to where the traffic is redirected
        :param pulumi.Input[Union[str, 'FrontDoorRedirectType']] redirect_type: The redirect type the rule will use when redirecting traffic.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Azure.FrontDoor.Models.FrontdoorRedirectConfiguration')
        if custom_fragment is not None:
            pulumi.set(__self__, "custom_fragment", custom_fragment)
        if custom_host is not None:
            pulumi.set(__self__, "custom_host", custom_host)
        if custom_path is not None:
            pulumi.set(__self__, "custom_path", custom_path)
        if custom_query_string is not None:
            pulumi.set(__self__, "custom_query_string", custom_query_string)
        if redirect_protocol is not None:
            pulumi.set(__self__, "redirect_protocol", redirect_protocol)
        if redirect_type is not None:
            pulumi.set(__self__, "redirect_type", redirect_type)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """

        Expected value is '#Microsoft.Azure.FrontDoor.Models.FrontdoorRedirectConfiguration'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter(name="customFragment")
    def custom_fragment(self) -> Optional[pulumi.Input[str]]:
        """
        Fragment to add to the redirect URL. Fragment is the part of the URL that comes after #. Do not include the #.
        """
        return pulumi.get(self, "custom_fragment")

    @custom_fragment.setter
    def custom_fragment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_fragment", value)

    @property
    @pulumi.getter(name="customHost")
    def custom_host(self) -> Optional[pulumi.Input[str]]:
        """
        Host to redirect. Leave empty to use the incoming host as the destination host.
        """
        return pulumi.get(self, "custom_host")

    @custom_host.setter
    def custom_host(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_host", value)

    @property
    @pulumi.getter(name="customPath")
    def custom_path(self) -> Optional[pulumi.Input[str]]:
        """
        The full path to redirect. Path cannot be empty and must start with /. Leave empty to use the incoming path as destination path.
        """
        return pulumi.get(self, "custom_path")

    @custom_path.setter
    def custom_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_path", value)

    @property
    @pulumi.getter(name="customQueryString")
    def custom_query_string(self) -> Optional[pulumi.Input[str]]:
        """
        The set of query strings to be placed in the redirect URL. Setting this value would replace any existing query string; leave empty to preserve the incoming query string. Query string must be in <key>=<value> format. The first ? and & will be added automatically so do not include them in the front, but do separate multiple query strings with &.
        """
        return pulumi.get(self, "custom_query_string")

    @custom_query_string.setter
    def custom_query_string(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_query_string", value)

    @property
    @pulumi.getter(name="redirectProtocol")
    def redirect_protocol(self) -> Optional[pulumi.Input[Union[str, 'FrontDoorRedirectProtocol']]]:
        """
        The protocol of the destination to where the traffic is redirected
        """
        return pulumi.get(self, "redirect_protocol")

    @redirect_protocol.setter
    def redirect_protocol(self, value: Optional[pulumi.Input[Union[str, 'FrontDoorRedirectProtocol']]]):
        pulumi.set(self, "redirect_protocol", value)

    @property
    @pulumi.getter(name="redirectType")
    def redirect_type(self) -> Optional[pulumi.Input[Union[str, 'FrontDoorRedirectType']]]:
        """
        The redirect type the rule will use when redirecting traffic.
        """
        return pulumi.get(self, "redirect_type")

    @redirect_type.setter
    def redirect_type(self, value: Optional[pulumi.Input[Union[str, 'FrontDoorRedirectType']]]):
        pulumi.set(self, "redirect_type", value)


@pulumi.input_type
class RoutingRuleUpdateParametersWebApplicationFirewallPolicyLinkArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None):
        """
        Defines the Web Application Firewall policy for each routing rule (if applicable)
        :param pulumi.Input[str] id: Resource ID.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class RoutingRuleArgs:
    def __init__(__self__, *,
                 accepted_protocols: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'FrontDoorProtocol']]]]] = None,
                 enabled_state: Optional[pulumi.Input[Union[str, 'RoutingRuleEnabledState']]] = None,
                 frontend_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input['SubResourceArgs']]]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 patterns_to_match: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 route_configuration: Optional[pulumi.Input[Union['ForwardingConfigurationArgs', 'RedirectConfigurationArgs']]] = None,
                 rules_engine: Optional[pulumi.Input['SubResourceArgs']] = None,
                 web_application_firewall_policy_link: Optional[pulumi.Input['RoutingRuleUpdateParametersWebApplicationFirewallPolicyLinkArgs']] = None):
        """
        A routing rule represents a specification for traffic to treat and where to send it, along with health probe information.
        :param pulumi.Input[Sequence[pulumi.Input[Union[str, 'FrontDoorProtocol']]]] accepted_protocols: Protocol schemes to match for this rule
        :param pulumi.Input[Union[str, 'RoutingRuleEnabledState']] enabled_state: Whether to enable use of this rule. Permitted values are 'Enabled' or 'Disabled'
        :param pulumi.Input[Sequence[pulumi.Input['SubResourceArgs']]] frontend_endpoints: Frontend endpoints associated with this rule
        :param pulumi.Input[str] id: Resource ID.
        :param pulumi.Input[str] name: Resource name.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] patterns_to_match: The route patterns of the rule.
        :param pulumi.Input[Union['ForwardingConfigurationArgs', 'RedirectConfigurationArgs']] route_configuration: A reference to the routing configuration.
        :param pulumi.Input['SubResourceArgs'] rules_engine: A reference to a specific Rules Engine Configuration to apply to this route.
        :param pulumi.Input['RoutingRuleUpdateParametersWebApplicationFirewallPolicyLinkArgs'] web_application_firewall_policy_link: Defines the Web Application Firewall policy for each routing rule (if applicable)
        """
        if accepted_protocols is not None:
            pulumi.set(__self__, "accepted_protocols", accepted_protocols)
        if enabled_state is not None:
            pulumi.set(__self__, "enabled_state", enabled_state)
        if frontend_endpoints is not None:
            pulumi.set(__self__, "frontend_endpoints", frontend_endpoints)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if patterns_to_match is not None:
            pulumi.set(__self__, "patterns_to_match", patterns_to_match)
        if route_configuration is not None:
            pulumi.set(__self__, "route_configuration", route_configuration)
        if rules_engine is not None:
            pulumi.set(__self__, "rules_engine", rules_engine)
        if web_application_firewall_policy_link is not None:
            pulumi.set(__self__, "web_application_firewall_policy_link", web_application_firewall_policy_link)

    @property
    @pulumi.getter(name="acceptedProtocols")
    def accepted_protocols(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'FrontDoorProtocol']]]]]:
        """
        Protocol schemes to match for this rule
        """
        return pulumi.get(self, "accepted_protocols")

    @accepted_protocols.setter
    def accepted_protocols(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'FrontDoorProtocol']]]]]):
        pulumi.set(self, "accepted_protocols", value)

    @property
    @pulumi.getter(name="enabledState")
    def enabled_state(self) -> Optional[pulumi.Input[Union[str, 'RoutingRuleEnabledState']]]:
        """
        Whether to enable use of this rule. Permitted values are 'Enabled' or 'Disabled'
        """
        return pulumi.get(self, "enabled_state")

    @enabled_state.setter
    def enabled_state(self, value: Optional[pulumi.Input[Union[str, 'RoutingRuleEnabledState']]]):
        pulumi.set(self, "enabled_state", value)

    @property
    @pulumi.getter(name="frontendEndpoints")
    def frontend_endpoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SubResourceArgs']]]]:
        """
        Frontend endpoints associated with this rule
        """
        return pulumi.get(self, "frontend_endpoints")

    @frontend_endpoints.setter
    def frontend_endpoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SubResourceArgs']]]]):
        pulumi.set(self, "frontend_endpoints", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="patternsToMatch")
    def patterns_to_match(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The route patterns of the rule.
        """
        return pulumi.get(self, "patterns_to_match")

    @patterns_to_match.setter
    def patterns_to_match(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "patterns_to_match", value)

    @property
    @pulumi.getter(name="routeConfiguration")
    def route_configuration(self) -> Optional[pulumi.Input[Union['ForwardingConfigurationArgs', 'RedirectConfigurationArgs']]]:
        """
        A reference to the routing configuration.
        """
        return pulumi.get(self, "route_configuration")

    @route_configuration.setter
    def route_configuration(self, value: Optional[pulumi.Input[Union['ForwardingConfigurationArgs', 'RedirectConfigurationArgs']]]):
        pulumi.set(self, "route_configuration", value)

    @property
    @pulumi.getter(name="rulesEngine")
    def rules_engine(self) -> Optional[pulumi.Input['SubResourceArgs']]:
        """
        A reference to a specific Rules Engine Configuration to apply to this route.
        """
        return pulumi.get(self, "rules_engine")

    @rules_engine.setter
    def rules_engine(self, value: Optional[pulumi.Input['SubResourceArgs']]):
        pulumi.set(self, "rules_engine", value)

    @property
    @pulumi.getter(name="webApplicationFirewallPolicyLink")
    def web_application_firewall_policy_link(self) -> Optional[pulumi.Input['RoutingRuleUpdateParametersWebApplicationFirewallPolicyLinkArgs']]:
        """
        Defines the Web Application Firewall policy for each routing rule (if applicable)
        """
        return pulumi.get(self, "web_application_firewall_policy_link")

    @web_application_firewall_policy_link.setter
    def web_application_firewall_policy_link(self, value: Optional[pulumi.Input['RoutingRuleUpdateParametersWebApplicationFirewallPolicyLinkArgs']]):
        pulumi.set(self, "web_application_firewall_policy_link", value)


@pulumi.input_type
class RulesEngineActionArgs:
    def __init__(__self__, *,
                 request_header_actions: Optional[pulumi.Input[Sequence[pulumi.Input['HeaderActionArgs']]]] = None,
                 response_header_actions: Optional[pulumi.Input[Sequence[pulumi.Input['HeaderActionArgs']]]] = None,
                 route_configuration_override: Optional[pulumi.Input[Union['ForwardingConfigurationArgs', 'RedirectConfigurationArgs']]] = None):
        """
        One or more actions that will execute, modifying the request and/or response.
        :param pulumi.Input[Sequence[pulumi.Input['HeaderActionArgs']]] request_header_actions: A list of header actions to apply from the request from AFD to the origin.
        :param pulumi.Input[Sequence[pulumi.Input['HeaderActionArgs']]] response_header_actions: A list of header actions to apply from the response from AFD to the client.
        :param pulumi.Input[Union['ForwardingConfigurationArgs', 'RedirectConfigurationArgs']] route_configuration_override: Override the route configuration.
        """
        if request_header_actions is not None:
            pulumi.set(__self__, "request_header_actions", request_header_actions)
        if response_header_actions is not None:
            pulumi.set(__self__, "response_header_actions", response_header_actions)
        if route_configuration_override is not None:
            pulumi.set(__self__, "route_configuration_override", route_configuration_override)

    @property
    @pulumi.getter(name="requestHeaderActions")
    def request_header_actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['HeaderActionArgs']]]]:
        """
        A list of header actions to apply from the request from AFD to the origin.
        """
        return pulumi.get(self, "request_header_actions")

    @request_header_actions.setter
    def request_header_actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['HeaderActionArgs']]]]):
        pulumi.set(self, "request_header_actions", value)

    @property
    @pulumi.getter(name="responseHeaderActions")
    def response_header_actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['HeaderActionArgs']]]]:
        """
        A list of header actions to apply from the response from AFD to the client.
        """
        return pulumi.get(self, "response_header_actions")

    @response_header_actions.setter
    def response_header_actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['HeaderActionArgs']]]]):
        pulumi.set(self, "response_header_actions", value)

    @property
    @pulumi.getter(name="routeConfigurationOverride")
    def route_configuration_override(self) -> Optional[pulumi.Input[Union['ForwardingConfigurationArgs', 'RedirectConfigurationArgs']]]:
        """
        Override the route configuration.
        """
        return pulumi.get(self, "route_configuration_override")

    @route_configuration_override.setter
    def route_configuration_override(self, value: Optional[pulumi.Input[Union['ForwardingConfigurationArgs', 'RedirectConfigurationArgs']]]):
        pulumi.set(self, "route_configuration_override", value)


@pulumi.input_type
class RulesEngineMatchConditionArgs:
    def __init__(__self__, *,
                 rules_engine_match_value: pulumi.Input[Sequence[pulumi.Input[str]]],
                 rules_engine_match_variable: pulumi.Input[Union[str, 'RulesEngineMatchVariable']],
                 rules_engine_operator: pulumi.Input[Union[str, 'RulesEngineOperator']],
                 negate_condition: Optional[pulumi.Input[bool]] = None,
                 selector: Optional[pulumi.Input[str]] = None,
                 transforms: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'Transform']]]]] = None):
        """
        Define a match condition
        :param pulumi.Input[Sequence[pulumi.Input[str]]] rules_engine_match_value: Match values to match against. The operator will apply to each value in here with OR semantics. If any of them match the variable with the given operator this match condition is considered a match.
        :param pulumi.Input[Union[str, 'RulesEngineMatchVariable']] rules_engine_match_variable: Match Variable
        :param pulumi.Input[Union[str, 'RulesEngineOperator']] rules_engine_operator: Describes operator to apply to the match condition.
        :param pulumi.Input[bool] negate_condition: Describes if this is negate condition or not
        :param pulumi.Input[str] selector: Name of selector in RequestHeader or RequestBody to be matched
        :param pulumi.Input[Sequence[pulumi.Input[Union[str, 'Transform']]]] transforms: List of transforms
        """
        pulumi.set(__self__, "rules_engine_match_value", rules_engine_match_value)
        pulumi.set(__self__, "rules_engine_match_variable", rules_engine_match_variable)
        pulumi.set(__self__, "rules_engine_operator", rules_engine_operator)
        if negate_condition is not None:
            pulumi.set(__self__, "negate_condition", negate_condition)
        if selector is not None:
            pulumi.set(__self__, "selector", selector)
        if transforms is not None:
            pulumi.set(__self__, "transforms", transforms)

    @property
    @pulumi.getter(name="rulesEngineMatchValue")
    def rules_engine_match_value(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Match values to match against. The operator will apply to each value in here with OR semantics. If any of them match the variable with the given operator this match condition is considered a match.
        """
        return pulumi.get(self, "rules_engine_match_value")

    @rules_engine_match_value.setter
    def rules_engine_match_value(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "rules_engine_match_value", value)

    @property
    @pulumi.getter(name="rulesEngineMatchVariable")
    def rules_engine_match_variable(self) -> pulumi.Input[Union[str, 'RulesEngineMatchVariable']]:
        """
        Match Variable
        """
        return pulumi.get(self, "rules_engine_match_variable")

    @rules_engine_match_variable.setter
    def rules_engine_match_variable(self, value: pulumi.Input[Union[str, 'RulesEngineMatchVariable']]):
        pulumi.set(self, "rules_engine_match_variable", value)

    @property
    @pulumi.getter(name="rulesEngineOperator")
    def rules_engine_operator(self) -> pulumi.Input[Union[str, 'RulesEngineOperator']]:
        """
        Describes operator to apply to the match condition.
        """
        return pulumi.get(self, "rules_engine_operator")

    @rules_engine_operator.setter
    def rules_engine_operator(self, value: pulumi.Input[Union[str, 'RulesEngineOperator']]):
        pulumi.set(self, "rules_engine_operator", value)

    @property
    @pulumi.getter(name="negateCondition")
    def negate_condition(self) -> Optional[pulumi.Input[bool]]:
        """
        Describes if this is negate condition or not
        """
        return pulumi.get(self, "negate_condition")

    @negate_condition.setter
    def negate_condition(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "negate_condition", value)

    @property
    @pulumi.getter
    def selector(self) -> Optional[pulumi.Input[str]]:
        """
        Name of selector in RequestHeader or RequestBody to be matched
        """
        return pulumi.get(self, "selector")

    @selector.setter
    def selector(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "selector", value)

    @property
    @pulumi.getter
    def transforms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'Transform']]]]]:
        """
        List of transforms
        """
        return pulumi.get(self, "transforms")

    @transforms.setter
    def transforms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'Transform']]]]]):
        pulumi.set(self, "transforms", value)


@pulumi.input_type
class RulesEngineRuleArgs:
    def __init__(__self__, *,
                 action: pulumi.Input['RulesEngineActionArgs'],
                 name: pulumi.Input[str],
                 priority: pulumi.Input[int],
                 match_conditions: Optional[pulumi.Input[Sequence[pulumi.Input['RulesEngineMatchConditionArgs']]]] = None,
                 match_processing_behavior: Optional[pulumi.Input[Union[str, 'MatchProcessingBehavior']]] = None):
        """
        Contains a list of match conditions, and an action on how to modify the request/response. If multiple rules match, the actions from one rule that conflict with a previous rule overwrite for a singular action, or append in the case of headers manipulation.
        :param pulumi.Input['RulesEngineActionArgs'] action: Actions to perform on the request and response if all of the match conditions are met.
        :param pulumi.Input[str] name: A name to refer to this specific rule.
        :param pulumi.Input[int] priority: A priority assigned to this rule. 
        :param pulumi.Input[Sequence[pulumi.Input['RulesEngineMatchConditionArgs']]] match_conditions: A list of match conditions that must meet in order for the actions of this rule to run. Having no match conditions means the actions will always run.
        :param pulumi.Input[Union[str, 'MatchProcessingBehavior']] match_processing_behavior: If this rule is a match should the rules engine continue running the remaining rules or stop. If not present, defaults to Continue.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "priority", priority)
        if match_conditions is not None:
            pulumi.set(__self__, "match_conditions", match_conditions)
        if match_processing_behavior is not None:
            pulumi.set(__self__, "match_processing_behavior", match_processing_behavior)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Input['RulesEngineActionArgs']:
        """
        Actions to perform on the request and response if all of the match conditions are met.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input['RulesEngineActionArgs']):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        A name to refer to this specific rule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def priority(self) -> pulumi.Input[int]:
        """
        A priority assigned to this rule. 
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: pulumi.Input[int]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter(name="matchConditions")
    def match_conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RulesEngineMatchConditionArgs']]]]:
        """
        A list of match conditions that must meet in order for the actions of this rule to run. Having no match conditions means the actions will always run.
        """
        return pulumi.get(self, "match_conditions")

    @match_conditions.setter
    def match_conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RulesEngineMatchConditionArgs']]]]):
        pulumi.set(self, "match_conditions", value)

    @property
    @pulumi.getter(name="matchProcessingBehavior")
    def match_processing_behavior(self) -> Optional[pulumi.Input[Union[str, 'MatchProcessingBehavior']]]:
        """
        If this rule is a match should the rules engine continue running the remaining rules or stop. If not present, defaults to Continue.
        """
        return pulumi.get(self, "match_processing_behavior")

    @match_processing_behavior.setter
    def match_processing_behavior(self, value: Optional[pulumi.Input[Union[str, 'MatchProcessingBehavior']]]):
        pulumi.set(self, "match_processing_behavior", value)


@pulumi.input_type
class SkuArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[Union[str, 'SkuName']]] = None):
        """
        The pricing tier of the web application firewall policy.
        :param pulumi.Input[Union[str, 'SkuName']] name: Name of the pricing tier.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[Union[str, 'SkuName']]]:
        """
        Name of the pricing tier.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[Union[str, 'SkuName']]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class SubResourceArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None):
        """
        Reference to another subresource.
        :param pulumi.Input[str] id: Resource ID.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)


