# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'ListBotSecretsResult',
    'AwaitableListBotSecretsResult',
    'list_bot_secrets',
    'list_bot_secrets_output',
]

@pulumi.output_type
class ListBotSecretsResult:
    """
    Health Bot Keys Response.
    """
    def __init__(__self__, secrets=None):
        if secrets and not isinstance(secrets, list):
            raise TypeError("Expected argument 'secrets' to be a list")
        pulumi.set(__self__, "secrets", secrets)

    @property
    @pulumi.getter
    def secrets(self) -> Optional[Sequence['outputs.HealthBotKeyResponse']]:
        """
        Array of Azure Health Bot Secrets.
        """
        return pulumi.get(self, "secrets")


class AwaitableListBotSecretsResult(ListBotSecretsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return ListBotSecretsResult(
            secrets=self.secrets)


def list_bot_secrets(bot_name: Optional[str] = None,
                     resource_group_name: Optional[str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableListBotSecretsResult:
    """
    List all secrets of a HealthBot.


    :param str bot_name: The name of the Bot resource.
    :param str resource_group_name: The name of the Bot resource group in the user subscription.
    """
    __args__ = dict()
    __args__['botName'] = bot_name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure-native:healthbot/v20220808:listBotSecrets', __args__, opts=opts, typ=ListBotSecretsResult).value

    return AwaitableListBotSecretsResult(
        secrets=__ret__.secrets)


@_utilities.lift_output_func(list_bot_secrets)
def list_bot_secrets_output(bot_name: Optional[pulumi.Input[str]] = None,
                            resource_group_name: Optional[pulumi.Input[str]] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[ListBotSecretsResult]:
    """
    List all secrets of a HealthBot.


    :param str bot_name: The name of the Bot resource.
    :param str resource_group_name: The name of the Bot resource group in the user subscription.
    """
    ...
