# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'CapabilityArgs',
    'CassandraKeyspaceResourceArgs',
    'CassandraPartitionKeyArgs',
    'CassandraSchemaArgs',
    'CassandraTableResourceArgs',
    'ClusterKeyArgs',
    'ColumnArgs',
    'ConflictResolutionPolicyArgs',
    'ConsistencyPolicyArgs',
    'ContainerPartitionKeyArgs',
    'ExcludedPathArgs',
    'GremlinDatabaseResourceArgs',
    'GremlinGraphResourceArgs',
    'IncludedPathArgs',
    'IndexesArgs',
    'IndexingPolicyArgs',
    'LocationArgs',
    'MongoDBCollectionResourceArgs',
    'MongoDBDatabaseResourceArgs',
    'MongoIndexKeysArgs',
    'MongoIndexOptionsArgs',
    'MongoIndexArgs',
    'SqlContainerResourceArgs',
    'SqlDatabaseResourceArgs',
    'TableResourceArgs',
    'UniqueKeyPolicyArgs',
    'UniqueKeyArgs',
    'VirtualNetworkRuleArgs',
]

@pulumi.input_type
class CapabilityArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None):
        """
        Cosmos DB capability object
        :param pulumi.Input[str] name: Name of the Cosmos DB capability. For example, "name": "EnableCassandra". Current values also include "EnableTable" and "EnableGremlin".
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the Cosmos DB capability. For example, "name": "EnableCassandra". Current values also include "EnableTable" and "EnableGremlin".
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class CassandraKeyspaceResourceArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[str]):
        """
        Cosmos DB Cassandra keyspace id object
        :param pulumi.Input[str] id: Name of the Cosmos DB Cassandra keyspace
        """
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[str]:
        """
        Name of the Cosmos DB Cassandra keyspace
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[str]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class CassandraPartitionKeyArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None):
        """
        Cosmos DB Cassandra table partition key
        :param pulumi.Input[str] name: Name of the Cosmos DB Cassandra table partition key
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the Cosmos DB Cassandra table partition key
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class CassandraSchemaArgs:
    def __init__(__self__, *,
                 cluster_keys: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterKeyArgs']]]] = None,
                 columns: Optional[pulumi.Input[Sequence[pulumi.Input['ColumnArgs']]]] = None,
                 partition_keys: Optional[pulumi.Input[Sequence[pulumi.Input['CassandraPartitionKeyArgs']]]] = None):
        """
        Cosmos DB Cassandra table schema
        :param pulumi.Input[Sequence[pulumi.Input['ClusterKeyArgs']]] cluster_keys: List of cluster key.
        :param pulumi.Input[Sequence[pulumi.Input['ColumnArgs']]] columns: List of Cassandra table columns.
        :param pulumi.Input[Sequence[pulumi.Input['CassandraPartitionKeyArgs']]] partition_keys: List of partition key.
        """
        if cluster_keys is not None:
            pulumi.set(__self__, "cluster_keys", cluster_keys)
        if columns is not None:
            pulumi.set(__self__, "columns", columns)
        if partition_keys is not None:
            pulumi.set(__self__, "partition_keys", partition_keys)

    @property
    @pulumi.getter(name="clusterKeys")
    def cluster_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterKeyArgs']]]]:
        """
        List of cluster key.
        """
        return pulumi.get(self, "cluster_keys")

    @cluster_keys.setter
    def cluster_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterKeyArgs']]]]):
        pulumi.set(self, "cluster_keys", value)

    @property
    @pulumi.getter
    def columns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ColumnArgs']]]]:
        """
        List of Cassandra table columns.
        """
        return pulumi.get(self, "columns")

    @columns.setter
    def columns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ColumnArgs']]]]):
        pulumi.set(self, "columns", value)

    @property
    @pulumi.getter(name="partitionKeys")
    def partition_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CassandraPartitionKeyArgs']]]]:
        """
        List of partition key.
        """
        return pulumi.get(self, "partition_keys")

    @partition_keys.setter
    def partition_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CassandraPartitionKeyArgs']]]]):
        pulumi.set(self, "partition_keys", value)


@pulumi.input_type
class CassandraTableResourceArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[str],
                 default_ttl: Optional[pulumi.Input[int]] = None,
                 schema: Optional[pulumi.Input['CassandraSchemaArgs']] = None):
        """
        Cosmos DB Cassandra table id object
        :param pulumi.Input[str] id: Name of the Cosmos DB Cassandra table
        :param pulumi.Input[int] default_ttl: Time to live of the Cosmos DB Cassandra table
        :param pulumi.Input['CassandraSchemaArgs'] schema: Schema of the Cosmos DB Cassandra table
        """
        pulumi.set(__self__, "id", id)
        if default_ttl is not None:
            pulumi.set(__self__, "default_ttl", default_ttl)
        if schema is not None:
            pulumi.set(__self__, "schema", schema)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[str]:
        """
        Name of the Cosmos DB Cassandra table
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="defaultTtl")
    def default_ttl(self) -> Optional[pulumi.Input[int]]:
        """
        Time to live of the Cosmos DB Cassandra table
        """
        return pulumi.get(self, "default_ttl")

    @default_ttl.setter
    def default_ttl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "default_ttl", value)

    @property
    @pulumi.getter
    def schema(self) -> Optional[pulumi.Input['CassandraSchemaArgs']]:
        """
        Schema of the Cosmos DB Cassandra table
        """
        return pulumi.get(self, "schema")

    @schema.setter
    def schema(self, value: Optional[pulumi.Input['CassandraSchemaArgs']]):
        pulumi.set(self, "schema", value)


@pulumi.input_type
class ClusterKeyArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 order_by: Optional[pulumi.Input[str]] = None):
        """
        Cosmos DB Cassandra table cluster key
        :param pulumi.Input[str] name: Name of the Cosmos DB Cassandra table cluster key
        :param pulumi.Input[str] order_by: Order of the Cosmos DB Cassandra table cluster key, only support "Asc" and "Desc"
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if order_by is not None:
            pulumi.set(__self__, "order_by", order_by)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the Cosmos DB Cassandra table cluster key
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="orderBy")
    def order_by(self) -> Optional[pulumi.Input[str]]:
        """
        Order of the Cosmos DB Cassandra table cluster key, only support "Asc" and "Desc"
        """
        return pulumi.get(self, "order_by")

    @order_by.setter
    def order_by(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "order_by", value)


@pulumi.input_type
class ColumnArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        Cosmos DB Cassandra table column
        :param pulumi.Input[str] name: Name of the Cosmos DB Cassandra table column
        :param pulumi.Input[str] type: Type of the Cosmos DB Cassandra table column
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the Cosmos DB Cassandra table column
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of the Cosmos DB Cassandra table column
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class ConflictResolutionPolicyArgs:
    def __init__(__self__, *,
                 conflict_resolution_path: Optional[pulumi.Input[str]] = None,
                 conflict_resolution_procedure: Optional[pulumi.Input[str]] = None,
                 mode: Optional[pulumi.Input[Union[str, 'ConflictResolutionMode']]] = None):
        """
        The conflict resolution policy for the container.
        :param pulumi.Input[str] conflict_resolution_path: The conflict resolution path in the case of LastWriterWins mode.
        :param pulumi.Input[str] conflict_resolution_procedure: The procedure to resolve conflicts in the case of custom mode.
        :param pulumi.Input[Union[str, 'ConflictResolutionMode']] mode: Indicates the conflict resolution mode.
        """
        if conflict_resolution_path is not None:
            pulumi.set(__self__, "conflict_resolution_path", conflict_resolution_path)
        if conflict_resolution_procedure is not None:
            pulumi.set(__self__, "conflict_resolution_procedure", conflict_resolution_procedure)
        if mode is None:
            mode = 'LastWriterWins'
        if mode is not None:
            pulumi.set(__self__, "mode", mode)

    @property
    @pulumi.getter(name="conflictResolutionPath")
    def conflict_resolution_path(self) -> Optional[pulumi.Input[str]]:
        """
        The conflict resolution path in the case of LastWriterWins mode.
        """
        return pulumi.get(self, "conflict_resolution_path")

    @conflict_resolution_path.setter
    def conflict_resolution_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "conflict_resolution_path", value)

    @property
    @pulumi.getter(name="conflictResolutionProcedure")
    def conflict_resolution_procedure(self) -> Optional[pulumi.Input[str]]:
        """
        The procedure to resolve conflicts in the case of custom mode.
        """
        return pulumi.get(self, "conflict_resolution_procedure")

    @conflict_resolution_procedure.setter
    def conflict_resolution_procedure(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "conflict_resolution_procedure", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[Union[str, 'ConflictResolutionMode']]]:
        """
        Indicates the conflict resolution mode.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[Union[str, 'ConflictResolutionMode']]]):
        pulumi.set(self, "mode", value)


@pulumi.input_type
class ConsistencyPolicyArgs:
    def __init__(__self__, *,
                 default_consistency_level: pulumi.Input['DefaultConsistencyLevel'],
                 max_interval_in_seconds: Optional[pulumi.Input[int]] = None,
                 max_staleness_prefix: Optional[pulumi.Input[float]] = None):
        """
        The consistency policy for the Cosmos DB database account.
        :param pulumi.Input['DefaultConsistencyLevel'] default_consistency_level: The default consistency level and configuration settings of the Cosmos DB account.
        :param pulumi.Input[int] max_interval_in_seconds: When used with the Bounded Staleness consistency level, this value represents the time amount of staleness (in seconds) tolerated. Accepted range for this value is 5 - 86400. Required when defaultConsistencyPolicy is set to 'BoundedStaleness'.
        :param pulumi.Input[float] max_staleness_prefix: When used with the Bounded Staleness consistency level, this value represents the number of stale requests tolerated. Accepted range for this value is 1 – 2,147,483,647. Required when defaultConsistencyPolicy is set to 'BoundedStaleness'.
        """
        pulumi.set(__self__, "default_consistency_level", default_consistency_level)
        if max_interval_in_seconds is not None:
            pulumi.set(__self__, "max_interval_in_seconds", max_interval_in_seconds)
        if max_staleness_prefix is not None:
            pulumi.set(__self__, "max_staleness_prefix", max_staleness_prefix)

    @property
    @pulumi.getter(name="defaultConsistencyLevel")
    def default_consistency_level(self) -> pulumi.Input['DefaultConsistencyLevel']:
        """
        The default consistency level and configuration settings of the Cosmos DB account.
        """
        return pulumi.get(self, "default_consistency_level")

    @default_consistency_level.setter
    def default_consistency_level(self, value: pulumi.Input['DefaultConsistencyLevel']):
        pulumi.set(self, "default_consistency_level", value)

    @property
    @pulumi.getter(name="maxIntervalInSeconds")
    def max_interval_in_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        When used with the Bounded Staleness consistency level, this value represents the time amount of staleness (in seconds) tolerated. Accepted range for this value is 5 - 86400. Required when defaultConsistencyPolicy is set to 'BoundedStaleness'.
        """
        return pulumi.get(self, "max_interval_in_seconds")

    @max_interval_in_seconds.setter
    def max_interval_in_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_interval_in_seconds", value)

    @property
    @pulumi.getter(name="maxStalenessPrefix")
    def max_staleness_prefix(self) -> Optional[pulumi.Input[float]]:
        """
        When used with the Bounded Staleness consistency level, this value represents the number of stale requests tolerated. Accepted range for this value is 1 – 2,147,483,647. Required when defaultConsistencyPolicy is set to 'BoundedStaleness'.
        """
        return pulumi.get(self, "max_staleness_prefix")

    @max_staleness_prefix.setter
    def max_staleness_prefix(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "max_staleness_prefix", value)


@pulumi.input_type
class ContainerPartitionKeyArgs:
    def __init__(__self__, *,
                 kind: Optional[pulumi.Input[Union[str, 'PartitionKind']]] = None,
                 paths: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The configuration of the partition key to be used for partitioning data into multiple partitions
        :param pulumi.Input[Union[str, 'PartitionKind']] kind: Indicates the kind of algorithm used for partitioning
        :param pulumi.Input[Sequence[pulumi.Input[str]]] paths: List of paths using which data within the container can be partitioned
        """
        if kind is None:
            kind = 'Hash'
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if paths is not None:
            pulumi.set(__self__, "paths", paths)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[Union[str, 'PartitionKind']]]:
        """
        Indicates the kind of algorithm used for partitioning
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[Union[str, 'PartitionKind']]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def paths(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of paths using which data within the container can be partitioned
        """
        return pulumi.get(self, "paths")

    @paths.setter
    def paths(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "paths", value)


@pulumi.input_type
class ExcludedPathArgs:
    def __init__(__self__, *,
                 path: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] path: The path for which the indexing behavior applies to. Index paths typically start with root and end with wildcard (/path/*)
        """
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        The path for which the indexing behavior applies to. Index paths typically start with root and end with wildcard (/path/*)
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)


@pulumi.input_type
class GremlinDatabaseResourceArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[str]):
        """
        Cosmos DB Gremlin database id object
        :param pulumi.Input[str] id: Name of the Cosmos DB Gremlin database
        """
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[str]:
        """
        Name of the Cosmos DB Gremlin database
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[str]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class GremlinGraphResourceArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[str],
                 conflict_resolution_policy: Optional[pulumi.Input['ConflictResolutionPolicyArgs']] = None,
                 default_ttl: Optional[pulumi.Input[int]] = None,
                 indexing_policy: Optional[pulumi.Input['IndexingPolicyArgs']] = None,
                 partition_key: Optional[pulumi.Input['ContainerPartitionKeyArgs']] = None,
                 unique_key_policy: Optional[pulumi.Input['UniqueKeyPolicyArgs']] = None):
        """
        Cosmos DB Gremlin graph resource object
        :param pulumi.Input[str] id: Name of the Cosmos DB Gremlin graph
        :param pulumi.Input['ConflictResolutionPolicyArgs'] conflict_resolution_policy: The conflict resolution policy for the graph.
        :param pulumi.Input[int] default_ttl: Default time to live
        :param pulumi.Input['IndexingPolicyArgs'] indexing_policy: The configuration of the indexing policy. By default, the indexing is automatic for all document paths within the graph
        :param pulumi.Input['ContainerPartitionKeyArgs'] partition_key: The configuration of the partition key to be used for partitioning data into multiple partitions
        :param pulumi.Input['UniqueKeyPolicyArgs'] unique_key_policy: The unique key policy configuration for specifying uniqueness constraints on documents in the collection in the Azure Cosmos DB service.
        """
        pulumi.set(__self__, "id", id)
        if conflict_resolution_policy is not None:
            pulumi.set(__self__, "conflict_resolution_policy", conflict_resolution_policy)
        if default_ttl is not None:
            pulumi.set(__self__, "default_ttl", default_ttl)
        if indexing_policy is not None:
            pulumi.set(__self__, "indexing_policy", indexing_policy)
        if partition_key is not None:
            pulumi.set(__self__, "partition_key", partition_key)
        if unique_key_policy is not None:
            pulumi.set(__self__, "unique_key_policy", unique_key_policy)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[str]:
        """
        Name of the Cosmos DB Gremlin graph
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="conflictResolutionPolicy")
    def conflict_resolution_policy(self) -> Optional[pulumi.Input['ConflictResolutionPolicyArgs']]:
        """
        The conflict resolution policy for the graph.
        """
        return pulumi.get(self, "conflict_resolution_policy")

    @conflict_resolution_policy.setter
    def conflict_resolution_policy(self, value: Optional[pulumi.Input['ConflictResolutionPolicyArgs']]):
        pulumi.set(self, "conflict_resolution_policy", value)

    @property
    @pulumi.getter(name="defaultTtl")
    def default_ttl(self) -> Optional[pulumi.Input[int]]:
        """
        Default time to live
        """
        return pulumi.get(self, "default_ttl")

    @default_ttl.setter
    def default_ttl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "default_ttl", value)

    @property
    @pulumi.getter(name="indexingPolicy")
    def indexing_policy(self) -> Optional[pulumi.Input['IndexingPolicyArgs']]:
        """
        The configuration of the indexing policy. By default, the indexing is automatic for all document paths within the graph
        """
        return pulumi.get(self, "indexing_policy")

    @indexing_policy.setter
    def indexing_policy(self, value: Optional[pulumi.Input['IndexingPolicyArgs']]):
        pulumi.set(self, "indexing_policy", value)

    @property
    @pulumi.getter(name="partitionKey")
    def partition_key(self) -> Optional[pulumi.Input['ContainerPartitionKeyArgs']]:
        """
        The configuration of the partition key to be used for partitioning data into multiple partitions
        """
        return pulumi.get(self, "partition_key")

    @partition_key.setter
    def partition_key(self, value: Optional[pulumi.Input['ContainerPartitionKeyArgs']]):
        pulumi.set(self, "partition_key", value)

    @property
    @pulumi.getter(name="uniqueKeyPolicy")
    def unique_key_policy(self) -> Optional[pulumi.Input['UniqueKeyPolicyArgs']]:
        """
        The unique key policy configuration for specifying uniqueness constraints on documents in the collection in the Azure Cosmos DB service.
        """
        return pulumi.get(self, "unique_key_policy")

    @unique_key_policy.setter
    def unique_key_policy(self, value: Optional[pulumi.Input['UniqueKeyPolicyArgs']]):
        pulumi.set(self, "unique_key_policy", value)


@pulumi.input_type
class IncludedPathArgs:
    def __init__(__self__, *,
                 indexes: Optional[pulumi.Input[Sequence[pulumi.Input['IndexesArgs']]]] = None,
                 path: Optional[pulumi.Input[str]] = None):
        """
        The paths that are included in indexing
        :param pulumi.Input[Sequence[pulumi.Input['IndexesArgs']]] indexes: List of indexes for this path
        :param pulumi.Input[str] path: The path for which the indexing behavior applies to. Index paths typically start with root and end with wildcard (/path/*)
        """
        if indexes is not None:
            pulumi.set(__self__, "indexes", indexes)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter
    def indexes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IndexesArgs']]]]:
        """
        List of indexes for this path
        """
        return pulumi.get(self, "indexes")

    @indexes.setter
    def indexes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IndexesArgs']]]]):
        pulumi.set(self, "indexes", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        The path for which the indexing behavior applies to. Index paths typically start with root and end with wildcard (/path/*)
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)


@pulumi.input_type
class IndexesArgs:
    def __init__(__self__, *,
                 data_type: Optional[pulumi.Input[Union[str, 'DataType']]] = None,
                 kind: Optional[pulumi.Input[Union[str, 'IndexKind']]] = None,
                 precision: Optional[pulumi.Input[int]] = None):
        """
        The indexes for the path.
        :param pulumi.Input[Union[str, 'DataType']] data_type: The datatype for which the indexing behavior is applied to.
        :param pulumi.Input[Union[str, 'IndexKind']] kind: Indicates the type of index.
        :param pulumi.Input[int] precision: The precision of the index. -1 is maximum precision.
        """
        if data_type is None:
            data_type = 'String'
        if data_type is not None:
            pulumi.set(__self__, "data_type", data_type)
        if kind is None:
            kind = 'Hash'
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if precision is not None:
            pulumi.set(__self__, "precision", precision)

    @property
    @pulumi.getter(name="dataType")
    def data_type(self) -> Optional[pulumi.Input[Union[str, 'DataType']]]:
        """
        The datatype for which the indexing behavior is applied to.
        """
        return pulumi.get(self, "data_type")

    @data_type.setter
    def data_type(self, value: Optional[pulumi.Input[Union[str, 'DataType']]]):
        pulumi.set(self, "data_type", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[Union[str, 'IndexKind']]]:
        """
        Indicates the type of index.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[Union[str, 'IndexKind']]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def precision(self) -> Optional[pulumi.Input[int]]:
        """
        The precision of the index. -1 is maximum precision.
        """
        return pulumi.get(self, "precision")

    @precision.setter
    def precision(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "precision", value)


@pulumi.input_type
class IndexingPolicyArgs:
    def __init__(__self__, *,
                 automatic: Optional[pulumi.Input[bool]] = None,
                 excluded_paths: Optional[pulumi.Input[Sequence[pulumi.Input['ExcludedPathArgs']]]] = None,
                 included_paths: Optional[pulumi.Input[Sequence[pulumi.Input['IncludedPathArgs']]]] = None,
                 indexing_mode: Optional[pulumi.Input[Union[str, 'IndexingMode']]] = None):
        """
        Cosmos DB indexing policy
        :param pulumi.Input[bool] automatic: Indicates if the indexing policy is automatic
        :param pulumi.Input[Sequence[pulumi.Input['ExcludedPathArgs']]] excluded_paths: List of paths to exclude from indexing
        :param pulumi.Input[Sequence[pulumi.Input['IncludedPathArgs']]] included_paths: List of paths to include in the indexing
        :param pulumi.Input[Union[str, 'IndexingMode']] indexing_mode: Indicates the indexing mode.
        """
        if automatic is not None:
            pulumi.set(__self__, "automatic", automatic)
        if excluded_paths is not None:
            pulumi.set(__self__, "excluded_paths", excluded_paths)
        if included_paths is not None:
            pulumi.set(__self__, "included_paths", included_paths)
        if indexing_mode is None:
            indexing_mode = 'Consistent'
        if indexing_mode is not None:
            pulumi.set(__self__, "indexing_mode", indexing_mode)

    @property
    @pulumi.getter
    def automatic(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates if the indexing policy is automatic
        """
        return pulumi.get(self, "automatic")

    @automatic.setter
    def automatic(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "automatic", value)

    @property
    @pulumi.getter(name="excludedPaths")
    def excluded_paths(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ExcludedPathArgs']]]]:
        """
        List of paths to exclude from indexing
        """
        return pulumi.get(self, "excluded_paths")

    @excluded_paths.setter
    def excluded_paths(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ExcludedPathArgs']]]]):
        pulumi.set(self, "excluded_paths", value)

    @property
    @pulumi.getter(name="includedPaths")
    def included_paths(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IncludedPathArgs']]]]:
        """
        List of paths to include in the indexing
        """
        return pulumi.get(self, "included_paths")

    @included_paths.setter
    def included_paths(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IncludedPathArgs']]]]):
        pulumi.set(self, "included_paths", value)

    @property
    @pulumi.getter(name="indexingMode")
    def indexing_mode(self) -> Optional[pulumi.Input[Union[str, 'IndexingMode']]]:
        """
        Indicates the indexing mode.
        """
        return pulumi.get(self, "indexing_mode")

    @indexing_mode.setter
    def indexing_mode(self, value: Optional[pulumi.Input[Union[str, 'IndexingMode']]]):
        pulumi.set(self, "indexing_mode", value)


@pulumi.input_type
class LocationArgs:
    def __init__(__self__, *,
                 failover_priority: Optional[pulumi.Input[int]] = None,
                 is_zone_redundant: Optional[pulumi.Input[bool]] = None,
                 location_name: Optional[pulumi.Input[str]] = None):
        """
        A region in which the Azure Cosmos DB database account is deployed.
        :param pulumi.Input[int] failover_priority: The failover priority of the region. A failover priority of 0 indicates a write region. The maximum value for a failover priority = (total number of regions - 1). Failover priority values must be unique for each of the regions in which the database account exists.
        :param pulumi.Input[bool] is_zone_redundant: Flag to indicate whether or not this region is an AvailabilityZone region
        :param pulumi.Input[str] location_name: The name of the region.
        """
        if failover_priority is not None:
            pulumi.set(__self__, "failover_priority", failover_priority)
        if is_zone_redundant is not None:
            pulumi.set(__self__, "is_zone_redundant", is_zone_redundant)
        if location_name is not None:
            pulumi.set(__self__, "location_name", location_name)

    @property
    @pulumi.getter(name="failoverPriority")
    def failover_priority(self) -> Optional[pulumi.Input[int]]:
        """
        The failover priority of the region. A failover priority of 0 indicates a write region. The maximum value for a failover priority = (total number of regions - 1). Failover priority values must be unique for each of the regions in which the database account exists.
        """
        return pulumi.get(self, "failover_priority")

    @failover_priority.setter
    def failover_priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "failover_priority", value)

    @property
    @pulumi.getter(name="isZoneRedundant")
    def is_zone_redundant(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to indicate whether or not this region is an AvailabilityZone region
        """
        return pulumi.get(self, "is_zone_redundant")

    @is_zone_redundant.setter
    def is_zone_redundant(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_zone_redundant", value)

    @property
    @pulumi.getter(name="locationName")
    def location_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the region.
        """
        return pulumi.get(self, "location_name")

    @location_name.setter
    def location_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location_name", value)


@pulumi.input_type
class MongoDBCollectionResourceArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[str],
                 indexes: Optional[pulumi.Input[Sequence[pulumi.Input['MongoIndexArgs']]]] = None,
                 shard_key: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Cosmos DB MongoDB collection resource object
        :param pulumi.Input[str] id: Name of the Cosmos DB MongoDB collection
        :param pulumi.Input[Sequence[pulumi.Input['MongoIndexArgs']]] indexes: List of index keys
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] shard_key: A key-value pair of shard keys to be applied for the request.
        """
        pulumi.set(__self__, "id", id)
        if indexes is not None:
            pulumi.set(__self__, "indexes", indexes)
        if shard_key is not None:
            pulumi.set(__self__, "shard_key", shard_key)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[str]:
        """
        Name of the Cosmos DB MongoDB collection
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def indexes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MongoIndexArgs']]]]:
        """
        List of index keys
        """
        return pulumi.get(self, "indexes")

    @indexes.setter
    def indexes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MongoIndexArgs']]]]):
        pulumi.set(self, "indexes", value)

    @property
    @pulumi.getter(name="shardKey")
    def shard_key(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A key-value pair of shard keys to be applied for the request.
        """
        return pulumi.get(self, "shard_key")

    @shard_key.setter
    def shard_key(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "shard_key", value)


@pulumi.input_type
class MongoDBDatabaseResourceArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[str]):
        """
        Cosmos DB MongoDB database id object
        :param pulumi.Input[str] id: Name of the Cosmos DB MongoDB database
        """
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[str]:
        """
        Name of the Cosmos DB MongoDB database
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[str]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class MongoIndexKeysArgs:
    def __init__(__self__, *,
                 keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Cosmos DB MongoDB collection resource object
        :param pulumi.Input[Sequence[pulumi.Input[str]]] keys: List of keys for each MongoDB collection in the Azure Cosmos DB service
        """
        if keys is not None:
            pulumi.set(__self__, "keys", keys)

    @property
    @pulumi.getter
    def keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of keys for each MongoDB collection in the Azure Cosmos DB service
        """
        return pulumi.get(self, "keys")

    @keys.setter
    def keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "keys", value)


@pulumi.input_type
class MongoIndexOptionsArgs:
    def __init__(__self__, *,
                 expire_after_seconds: Optional[pulumi.Input[int]] = None,
                 unique: Optional[pulumi.Input[bool]] = None):
        """
        Cosmos DB MongoDB collection index options
        :param pulumi.Input[int] expire_after_seconds: Expire after seconds
        :param pulumi.Input[bool] unique: Is unique or not
        """
        if expire_after_seconds is not None:
            pulumi.set(__self__, "expire_after_seconds", expire_after_seconds)
        if unique is not None:
            pulumi.set(__self__, "unique", unique)

    @property
    @pulumi.getter(name="expireAfterSeconds")
    def expire_after_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        Expire after seconds
        """
        return pulumi.get(self, "expire_after_seconds")

    @expire_after_seconds.setter
    def expire_after_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "expire_after_seconds", value)

    @property
    @pulumi.getter
    def unique(self) -> Optional[pulumi.Input[bool]]:
        """
        Is unique or not
        """
        return pulumi.get(self, "unique")

    @unique.setter
    def unique(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "unique", value)


@pulumi.input_type
class MongoIndexArgs:
    def __init__(__self__, *,
                 key: Optional[pulumi.Input['MongoIndexKeysArgs']] = None,
                 options: Optional[pulumi.Input['MongoIndexOptionsArgs']] = None):
        """
        Cosmos DB MongoDB collection index key
        :param pulumi.Input['MongoIndexKeysArgs'] key: Cosmos DB MongoDB collection index keys
        :param pulumi.Input['MongoIndexOptionsArgs'] options: Cosmos DB MongoDB collection index key options
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if options is not None:
            pulumi.set(__self__, "options", options)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input['MongoIndexKeysArgs']]:
        """
        Cosmos DB MongoDB collection index keys
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input['MongoIndexKeysArgs']]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input['MongoIndexOptionsArgs']]:
        """
        Cosmos DB MongoDB collection index key options
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input['MongoIndexOptionsArgs']]):
        pulumi.set(self, "options", value)


@pulumi.input_type
class SqlContainerResourceArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[str],
                 conflict_resolution_policy: Optional[pulumi.Input['ConflictResolutionPolicyArgs']] = None,
                 default_ttl: Optional[pulumi.Input[int]] = None,
                 indexing_policy: Optional[pulumi.Input['IndexingPolicyArgs']] = None,
                 partition_key: Optional[pulumi.Input['ContainerPartitionKeyArgs']] = None,
                 unique_key_policy: Optional[pulumi.Input['UniqueKeyPolicyArgs']] = None):
        """
        Cosmos DB SQL container resource object
        :param pulumi.Input[str] id: Name of the Cosmos DB SQL container
        :param pulumi.Input['ConflictResolutionPolicyArgs'] conflict_resolution_policy: The conflict resolution policy for the container.
        :param pulumi.Input[int] default_ttl: Default time to live
        :param pulumi.Input['IndexingPolicyArgs'] indexing_policy: The configuration of the indexing policy. By default, the indexing is automatic for all document paths within the container
        :param pulumi.Input['ContainerPartitionKeyArgs'] partition_key: The configuration of the partition key to be used for partitioning data into multiple partitions
        :param pulumi.Input['UniqueKeyPolicyArgs'] unique_key_policy: The unique key policy configuration for specifying uniqueness constraints on documents in the collection in the Azure Cosmos DB service.
        """
        pulumi.set(__self__, "id", id)
        if conflict_resolution_policy is not None:
            pulumi.set(__self__, "conflict_resolution_policy", conflict_resolution_policy)
        if default_ttl is not None:
            pulumi.set(__self__, "default_ttl", default_ttl)
        if indexing_policy is not None:
            pulumi.set(__self__, "indexing_policy", indexing_policy)
        if partition_key is not None:
            pulumi.set(__self__, "partition_key", partition_key)
        if unique_key_policy is not None:
            pulumi.set(__self__, "unique_key_policy", unique_key_policy)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[str]:
        """
        Name of the Cosmos DB SQL container
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="conflictResolutionPolicy")
    def conflict_resolution_policy(self) -> Optional[pulumi.Input['ConflictResolutionPolicyArgs']]:
        """
        The conflict resolution policy for the container.
        """
        return pulumi.get(self, "conflict_resolution_policy")

    @conflict_resolution_policy.setter
    def conflict_resolution_policy(self, value: Optional[pulumi.Input['ConflictResolutionPolicyArgs']]):
        pulumi.set(self, "conflict_resolution_policy", value)

    @property
    @pulumi.getter(name="defaultTtl")
    def default_ttl(self) -> Optional[pulumi.Input[int]]:
        """
        Default time to live
        """
        return pulumi.get(self, "default_ttl")

    @default_ttl.setter
    def default_ttl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "default_ttl", value)

    @property
    @pulumi.getter(name="indexingPolicy")
    def indexing_policy(self) -> Optional[pulumi.Input['IndexingPolicyArgs']]:
        """
        The configuration of the indexing policy. By default, the indexing is automatic for all document paths within the container
        """
        return pulumi.get(self, "indexing_policy")

    @indexing_policy.setter
    def indexing_policy(self, value: Optional[pulumi.Input['IndexingPolicyArgs']]):
        pulumi.set(self, "indexing_policy", value)

    @property
    @pulumi.getter(name="partitionKey")
    def partition_key(self) -> Optional[pulumi.Input['ContainerPartitionKeyArgs']]:
        """
        The configuration of the partition key to be used for partitioning data into multiple partitions
        """
        return pulumi.get(self, "partition_key")

    @partition_key.setter
    def partition_key(self, value: Optional[pulumi.Input['ContainerPartitionKeyArgs']]):
        pulumi.set(self, "partition_key", value)

    @property
    @pulumi.getter(name="uniqueKeyPolicy")
    def unique_key_policy(self) -> Optional[pulumi.Input['UniqueKeyPolicyArgs']]:
        """
        The unique key policy configuration for specifying uniqueness constraints on documents in the collection in the Azure Cosmos DB service.
        """
        return pulumi.get(self, "unique_key_policy")

    @unique_key_policy.setter
    def unique_key_policy(self, value: Optional[pulumi.Input['UniqueKeyPolicyArgs']]):
        pulumi.set(self, "unique_key_policy", value)


@pulumi.input_type
class SqlDatabaseResourceArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[str]):
        """
        Cosmos DB SQL database id object
        :param pulumi.Input[str] id: Name of the Cosmos DB SQL database
        """
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[str]:
        """
        Name of the Cosmos DB SQL database
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[str]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class TableResourceArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[str]):
        """
        Cosmos DB table id object
        :param pulumi.Input[str] id: Name of the Cosmos DB table
        """
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[str]:
        """
        Name of the Cosmos DB table
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[str]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class UniqueKeyPolicyArgs:
    def __init__(__self__, *,
                 unique_keys: Optional[pulumi.Input[Sequence[pulumi.Input['UniqueKeyArgs']]]] = None):
        """
        The unique key policy configuration for specifying uniqueness constraints on documents in the collection in the Azure Cosmos DB service.
        :param pulumi.Input[Sequence[pulumi.Input['UniqueKeyArgs']]] unique_keys: List of unique keys on that enforces uniqueness constraint on documents in the collection in the Azure Cosmos DB service.
        """
        if unique_keys is not None:
            pulumi.set(__self__, "unique_keys", unique_keys)

    @property
    @pulumi.getter(name="uniqueKeys")
    def unique_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UniqueKeyArgs']]]]:
        """
        List of unique keys on that enforces uniqueness constraint on documents in the collection in the Azure Cosmos DB service.
        """
        return pulumi.get(self, "unique_keys")

    @unique_keys.setter
    def unique_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UniqueKeyArgs']]]]):
        pulumi.set(self, "unique_keys", value)


@pulumi.input_type
class UniqueKeyArgs:
    def __init__(__self__, *,
                 paths: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The unique key on that enforces uniqueness constraint on documents in the collection in the Azure Cosmos DB service.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] paths: List of paths must be unique for each document in the Azure Cosmos DB service
        """
        if paths is not None:
            pulumi.set(__self__, "paths", paths)

    @property
    @pulumi.getter
    def paths(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of paths must be unique for each document in the Azure Cosmos DB service
        """
        return pulumi.get(self, "paths")

    @paths.setter
    def paths(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "paths", value)


@pulumi.input_type
class VirtualNetworkRuleArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None,
                 ignore_missing_v_net_service_endpoint: Optional[pulumi.Input[bool]] = None):
        """
        Virtual Network ACL Rule object
        :param pulumi.Input[str] id: Resource ID of a subnet, for example: /subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}.
        :param pulumi.Input[bool] ignore_missing_v_net_service_endpoint: Create firewall rule before the virtual network has vnet service endpoint enabled.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if ignore_missing_v_net_service_endpoint is not None:
            pulumi.set(__self__, "ignore_missing_v_net_service_endpoint", ignore_missing_v_net_service_endpoint)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource ID of a subnet, for example: /subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="ignoreMissingVNetServiceEndpoint")
    def ignore_missing_v_net_service_endpoint(self) -> Optional[pulumi.Input[bool]]:
        """
        Create firewall rule before the virtual network has vnet service endpoint enabled.
        """
        return pulumi.get(self, "ignore_missing_v_net_service_endpoint")

    @ignore_missing_v_net_service_endpoint.setter
    def ignore_missing_v_net_service_endpoint(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ignore_missing_v_net_service_endpoint", value)


