# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = ['VolumeSnapshotArgs', 'VolumeSnapshot']

@pulumi.input_type
class VolumeSnapshotArgs:
    def __init__(__self__, *,
                 mount_options: pulumi.Input[Sequence[pulumi.Input[str]]],
                 pool_name: pulumi.Input[str],
                 reclaim_policy: pulumi.Input[Union[str, 'ReclaimPolicy']],
                 resource_group_name: pulumi.Input[str],
                 source: pulumi.Input[str],
                 volume_mode: pulumi.Input[Union[str, 'VolumeMode']],
                 volume_snapshot_name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a VolumeSnapshot resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] mount_options: List of string mount options
        :param pulumi.Input[str] pool_name: Pool Object
        :param pulumi.Input[Union[str, 'ReclaimPolicy']] reclaim_policy: Reclaim Policy, Delete or Retain
        :param pulumi.Input[str] resource_group_name: The name of the resource group. The name is case insensitive.
        :param pulumi.Input[str] source: Reference to the source volume
        :param pulumi.Input[Union[str, 'VolumeMode']] volume_mode: Indicates how the volumes created from the snapshot should be attached
        :param pulumi.Input[str] volume_snapshot_name: Volume Snapshot Resource
        """
        pulumi.set(__self__, "mount_options", mount_options)
        pulumi.set(__self__, "pool_name", pool_name)
        pulumi.set(__self__, "reclaim_policy", reclaim_policy)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "source", source)
        pulumi.set(__self__, "volume_mode", volume_mode)
        if volume_snapshot_name is not None:
            pulumi.set(__self__, "volume_snapshot_name", volume_snapshot_name)

    @property
    @pulumi.getter(name="mountOptions")
    def mount_options(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        List of string mount options
        """
        return pulumi.get(self, "mount_options")

    @mount_options.setter
    def mount_options(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "mount_options", value)

    @property
    @pulumi.getter(name="poolName")
    def pool_name(self) -> pulumi.Input[str]:
        """
        Pool Object
        """
        return pulumi.get(self, "pool_name")

    @pool_name.setter
    def pool_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "pool_name", value)

    @property
    @pulumi.getter(name="reclaimPolicy")
    def reclaim_policy(self) -> pulumi.Input[Union[str, 'ReclaimPolicy']]:
        """
        Reclaim Policy, Delete or Retain
        """
        return pulumi.get(self, "reclaim_policy")

    @reclaim_policy.setter
    def reclaim_policy(self, value: pulumi.Input[Union[str, 'ReclaimPolicy']]):
        pulumi.set(self, "reclaim_policy", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[str]:
        """
        The name of the resource group. The name is case insensitive.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter
    def source(self) -> pulumi.Input[str]:
        """
        Reference to the source volume
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: pulumi.Input[str]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter(name="volumeMode")
    def volume_mode(self) -> pulumi.Input[Union[str, 'VolumeMode']]:
        """
        Indicates how the volumes created from the snapshot should be attached
        """
        return pulumi.get(self, "volume_mode")

    @volume_mode.setter
    def volume_mode(self, value: pulumi.Input[Union[str, 'VolumeMode']]):
        pulumi.set(self, "volume_mode", value)

    @property
    @pulumi.getter(name="volumeSnapshotName")
    def volume_snapshot_name(self) -> Optional[pulumi.Input[str]]:
        """
        Volume Snapshot Resource
        """
        return pulumi.get(self, "volume_snapshot_name")

    @volume_snapshot_name.setter
    def volume_snapshot_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "volume_snapshot_name", value)


class VolumeSnapshot(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 mount_options: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 pool_name: Optional[pulumi.Input[str]] = None,
                 reclaim_policy: Optional[pulumi.Input[Union[str, 'ReclaimPolicy']]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 source: Optional[pulumi.Input[str]] = None,
                 volume_mode: Optional[pulumi.Input[Union[str, 'VolumeMode']]] = None,
                 volume_snapshot_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Concrete proxy resource types can be created by aliasing this type using a specific property type.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] mount_options: List of string mount options
        :param pulumi.Input[str] pool_name: Pool Object
        :param pulumi.Input[Union[str, 'ReclaimPolicy']] reclaim_policy: Reclaim Policy, Delete or Retain
        :param pulumi.Input[str] resource_group_name: The name of the resource group. The name is case insensitive.
        :param pulumi.Input[str] source: Reference to the source volume
        :param pulumi.Input[Union[str, 'VolumeMode']] volume_mode: Indicates how the volumes created from the snapshot should be attached
        :param pulumi.Input[str] volume_snapshot_name: Volume Snapshot Resource
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VolumeSnapshotArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Concrete proxy resource types can be created by aliasing this type using a specific property type.

        :param str resource_name: The name of the resource.
        :param VolumeSnapshotArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VolumeSnapshotArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 mount_options: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 pool_name: Optional[pulumi.Input[str]] = None,
                 reclaim_policy: Optional[pulumi.Input[Union[str, 'ReclaimPolicy']]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 source: Optional[pulumi.Input[str]] = None,
                 volume_mode: Optional[pulumi.Input[Union[str, 'VolumeMode']]] = None,
                 volume_snapshot_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VolumeSnapshotArgs.__new__(VolumeSnapshotArgs)

            if mount_options is None and not opts.urn:
                raise TypeError("Missing required property 'mount_options'")
            __props__.__dict__["mount_options"] = mount_options
            if pool_name is None and not opts.urn:
                raise TypeError("Missing required property 'pool_name'")
            __props__.__dict__["pool_name"] = pool_name
            if reclaim_policy is None and not opts.urn:
                raise TypeError("Missing required property 'reclaim_policy'")
            __props__.__dict__["reclaim_policy"] = reclaim_policy
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            if source is None and not opts.urn:
                raise TypeError("Missing required property 'source'")
            __props__.__dict__["source"] = source
            if volume_mode is None and not opts.urn:
                raise TypeError("Missing required property 'volume_mode'")
            __props__.__dict__["volume_mode"] = volume_mode
            __props__.__dict__["volume_snapshot_name"] = volume_snapshot_name
            __props__.__dict__["name"] = None
            __props__.__dict__["provisioning_state"] = None
            __props__.__dict__["system_data"] = None
            __props__.__dict__["type"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="azure-native:containerstorage:VolumeSnapshot")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(VolumeSnapshot, __self__).__init__(
            'azure-native:containerstorage/v20230301preview:VolumeSnapshot',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'VolumeSnapshot':
        """
        Get an existing VolumeSnapshot resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = VolumeSnapshotArgs.__new__(VolumeSnapshotArgs)

        __props__.__dict__["mount_options"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["provisioning_state"] = None
        __props__.__dict__["reclaim_policy"] = None
        __props__.__dict__["source"] = None
        __props__.__dict__["system_data"] = None
        __props__.__dict__["type"] = None
        __props__.__dict__["volume_mode"] = None
        return VolumeSnapshot(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="mountOptions")
    def mount_options(self) -> pulumi.Output[Sequence[str]]:
        """
        List of string mount options
        """
        return pulumi.get(self, "mount_options")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> pulumi.Output[str]:
        """
        The status of the last operation.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="reclaimPolicy")
    def reclaim_policy(self) -> pulumi.Output[str]:
        """
        Reclaim Policy, Delete or Retain
        """
        return pulumi.get(self, "reclaim_policy")

    @property
    @pulumi.getter
    def source(self) -> pulumi.Output[str]:
        """
        Reference to the source volume
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter(name="systemData")
    def system_data(self) -> pulumi.Output['outputs.SystemDataResponse']:
        """
        Azure Resource Manager metadata containing createdBy and modifiedBy information.
        """
        return pulumi.get(self, "system_data")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="volumeMode")
    def volume_mode(self) -> pulumi.Output[str]:
        """
        Indicates how the volumes created from the snapshot should be attached
        """
        return pulumi.get(self, "volume_mode")

