# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'DiskPoolPropertiesResponse',
    'ElasticSanPoolPropertiesResponse',
    'EphemeralPoolPropertiesResponse',
    'SystemDataResponse',
]

@pulumi.output_type
class DiskPoolPropertiesResponse(dict):
    """
    Disk Pool Properties
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "csiParams":
            suggest = "csi_params"
        elif key == "maxVolumeCapacityGiB":
            suggest = "max_volume_capacity_gi_b"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DiskPoolPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DiskPoolPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DiskPoolPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 csi_params: Optional[Mapping[str, str]] = None,
                 disks: Optional[Sequence[str]] = None,
                 max_volume_capacity_gi_b: Optional[float] = None):
        """
        Disk Pool Properties
        :param Mapping[str, str] csi_params: List of KV pairs to set in StorageClass to configure CSI driver.
        :param Sequence[str] disks: Only required if individual disk selection is desired. Path to disk, e.g. <nodename>:/dev/sda or WWN. Supports specifying multiple disks (same syntax as tags).
        :param float max_volume_capacity_gi_b: Maximum capacity of the volumes in GiB the user intends to create. Default 512.
        """
        if csi_params is not None:
            pulumi.set(__self__, "csi_params", csi_params)
        if disks is not None:
            pulumi.set(__self__, "disks", disks)
        if max_volume_capacity_gi_b is None:
            max_volume_capacity_gi_b = 512
        if max_volume_capacity_gi_b is not None:
            pulumi.set(__self__, "max_volume_capacity_gi_b", max_volume_capacity_gi_b)

    @property
    @pulumi.getter(name="csiParams")
    def csi_params(self) -> Optional[Mapping[str, str]]:
        """
        List of KV pairs to set in StorageClass to configure CSI driver.
        """
        return pulumi.get(self, "csi_params")

    @property
    @pulumi.getter
    def disks(self) -> Optional[Sequence[str]]:
        """
        Only required if individual disk selection is desired. Path to disk, e.g. <nodename>:/dev/sda or WWN. Supports specifying multiple disks (same syntax as tags).
        """
        return pulumi.get(self, "disks")

    @property
    @pulumi.getter(name="maxVolumeCapacityGiB")
    def max_volume_capacity_gi_b(self) -> Optional[float]:
        """
        Maximum capacity of the volumes in GiB the user intends to create. Default 512.
        """
        return pulumi.get(self, "max_volume_capacity_gi_b")


@pulumi.output_type
class ElasticSanPoolPropertiesResponse(dict):
    """
    Elastic San Pool Properties
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceGroup":
            suggest = "resource_group"
        elif key == "sanName":
            suggest = "san_name"
        elif key == "volumeGroup":
            suggest = "volume_group"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ElasticSanPoolPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ElasticSanPoolPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ElasticSanPoolPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_group: str,
                 san_name: str,
                 volume_group: str):
        """
        Elastic San Pool Properties
        :param str resource_group: Resource group of an existing SAN.
        :param str san_name: Name of an existing SAN.
        :param str volume_group: Volume group of an existing SAN.
        """
        pulumi.set(__self__, "resource_group", resource_group)
        pulumi.set(__self__, "san_name", san_name)
        pulumi.set(__self__, "volume_group", volume_group)

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> str:
        """
        Resource group of an existing SAN.
        """
        return pulumi.get(self, "resource_group")

    @property
    @pulumi.getter(name="sanName")
    def san_name(self) -> str:
        """
        Name of an existing SAN.
        """
        return pulumi.get(self, "san_name")

    @property
    @pulumi.getter(name="volumeGroup")
    def volume_group(self) -> str:
        """
        Volume group of an existing SAN.
        """
        return pulumi.get(self, "volume_group")


@pulumi.output_type
class EphemeralPoolPropertiesResponse(dict):
    """
    Ephemeral Pool Properties
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskSelector":
            suggest = "disk_selector"
        elif key == "diskFormat":
            suggest = "disk_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EphemeralPoolPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EphemeralPoolPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EphemeralPoolPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disk_selector: Sequence[str],
                 disks: Sequence[str],
                 disk_format: Optional[bool] = None):
        """
        Ephemeral Pool Properties
        :param Sequence[str] disk_selector: Template name or KV pairs containing disk selection criteria, e.g. model="Microsoft NVMe Direct Disk" to match all Lsv2 NVMe disks.
        :param Sequence[str] disks: Only required if individual disk selection is desired. Path to disk, e.g. <nodename>:/dev/sda or WWN. Supports specifying multiple disks (same syntax as tags).
        :param bool disk_format: Consent to format the local disks.
        """
        pulumi.set(__self__, "disk_selector", disk_selector)
        pulumi.set(__self__, "disks", disks)
        if disk_format is None:
            disk_format = False
        if disk_format is not None:
            pulumi.set(__self__, "disk_format", disk_format)

    @property
    @pulumi.getter(name="diskSelector")
    def disk_selector(self) -> Sequence[str]:
        """
        Template name or KV pairs containing disk selection criteria, e.g. model="Microsoft NVMe Direct Disk" to match all Lsv2 NVMe disks.
        """
        return pulumi.get(self, "disk_selector")

    @property
    @pulumi.getter
    def disks(self) -> Sequence[str]:
        """
        Only required if individual disk selection is desired. Path to disk, e.g. <nodename>:/dev/sda or WWN. Supports specifying multiple disks (same syntax as tags).
        """
        return pulumi.get(self, "disks")

    @property
    @pulumi.getter(name="diskFormat")
    def disk_format(self) -> Optional[bool]:
        """
        Consent to format the local disks.
        """
        return pulumi.get(self, "disk_format")


@pulumi.output_type
class SystemDataResponse(dict):
    """
    Metadata pertaining to creation and last modification of the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "createdBy":
            suggest = "created_by"
        elif key == "createdByType":
            suggest = "created_by_type"
        elif key == "lastModifiedAt":
            suggest = "last_modified_at"
        elif key == "lastModifiedBy":
            suggest = "last_modified_by"
        elif key == "lastModifiedByType":
            suggest = "last_modified_by_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SystemDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: Optional[str] = None,
                 created_by: Optional[str] = None,
                 created_by_type: Optional[str] = None,
                 last_modified_at: Optional[str] = None,
                 last_modified_by: Optional[str] = None,
                 last_modified_by_type: Optional[str] = None):
        """
        Metadata pertaining to creation and last modification of the resource.
        :param str created_at: The timestamp of resource creation (UTC).
        :param str created_by: The identity that created the resource.
        :param str created_by_type: The type of identity that created the resource.
        :param str last_modified_at: The timestamp of resource last modification (UTC)
        :param str last_modified_by: The identity that last modified the resource.
        :param str last_modified_by_type: The type of identity that last modified the resource.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_by_type is not None:
            pulumi.set(__self__, "created_by_type", created_by_type)
        if last_modified_at is not None:
            pulumi.set(__self__, "last_modified_at", last_modified_at)
        if last_modified_by is not None:
            pulumi.set(__self__, "last_modified_by", last_modified_by)
        if last_modified_by_type is not None:
            pulumi.set(__self__, "last_modified_by_type", last_modified_by_type)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The timestamp of resource creation (UTC).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[str]:
        """
        The identity that created the resource.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="createdByType")
    def created_by_type(self) -> Optional[str]:
        """
        The type of identity that created the resource.
        """
        return pulumi.get(self, "created_by_type")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> Optional[str]:
        """
        The timestamp of resource last modification (UTC)
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> Optional[str]:
        """
        The identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by")

    @property
    @pulumi.getter(name="lastModifiedByType")
    def last_modified_by_type(self) -> Optional[str]:
        """
        The type of identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by_type")


