# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetVolumeResult',
    'AwaitableGetVolumeResult',
    'get_volume',
    'get_volume_output',
]

@pulumi.output_type
class GetVolumeResult:
    """
    Concrete proxy resource types can be created by aliasing this type using a specific property type.
    """
    def __init__(__self__, capacity_gi_b=None, id=None, labels=None, mount_options=None, name=None, provisioning_state=None, reclaim_policy=None, system_data=None, type=None, volume_mode=None):
        if capacity_gi_b and not isinstance(capacity_gi_b, float):
            raise TypeError("Expected argument 'capacity_gi_b' to be a float")
        pulumi.set(__self__, "capacity_gi_b", capacity_gi_b)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if mount_options and not isinstance(mount_options, list):
            raise TypeError("Expected argument 'mount_options' to be a list")
        pulumi.set(__self__, "mount_options", mount_options)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if provisioning_state and not isinstance(provisioning_state, str):
            raise TypeError("Expected argument 'provisioning_state' to be a str")
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if reclaim_policy and not isinstance(reclaim_policy, str):
            raise TypeError("Expected argument 'reclaim_policy' to be a str")
        pulumi.set(__self__, "reclaim_policy", reclaim_policy)
        if system_data and not isinstance(system_data, dict):
            raise TypeError("Expected argument 'system_data' to be a dict")
        pulumi.set(__self__, "system_data", system_data)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if volume_mode and not isinstance(volume_mode, str):
            raise TypeError("Expected argument 'volume_mode' to be a str")
        pulumi.set(__self__, "volume_mode", volume_mode)

    @property
    @pulumi.getter(name="capacityGiB")
    def capacity_gi_b(self) -> float:
        """
        Requested capacity in GiB
        """
        return pulumi.get(self, "capacity_gi_b")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        String KV pairs indicating labels
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="mountOptions")
    def mount_options(self) -> Sequence[str]:
        """
        List of string mount options
        """
        return pulumi.get(self, "mount_options")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The status of the last operation.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="reclaimPolicy")
    def reclaim_policy(self) -> str:
        """
        Reclaim Policy, Delete or Retain
        """
        return pulumi.get(self, "reclaim_policy")

    @property
    @pulumi.getter(name="systemData")
    def system_data(self) -> 'outputs.SystemDataResponse':
        """
        Azure Resource Manager metadata containing createdBy and modifiedBy information.
        """
        return pulumi.get(self, "system_data")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="volumeMode")
    def volume_mode(self) -> str:
        """
        Indicates how the volume should be attached
        """
        return pulumi.get(self, "volume_mode")


class AwaitableGetVolumeResult(GetVolumeResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVolumeResult(
            capacity_gi_b=self.capacity_gi_b,
            id=self.id,
            labels=self.labels,
            mount_options=self.mount_options,
            name=self.name,
            provisioning_state=self.provisioning_state,
            reclaim_policy=self.reclaim_policy,
            system_data=self.system_data,
            type=self.type,
            volume_mode=self.volume_mode)


def get_volume(pool_name: Optional[str] = None,
               resource_group_name: Optional[str] = None,
               volume_name: Optional[str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVolumeResult:
    """
    Get a Volume


    :param str pool_name: Pool Object
    :param str resource_group_name: The name of the resource group. The name is case insensitive.
    :param str volume_name: Volume Resource
    """
    __args__ = dict()
    __args__['poolName'] = pool_name
    __args__['resourceGroupName'] = resource_group_name
    __args__['volumeName'] = volume_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure-native:containerstorage/v20230301preview:getVolume', __args__, opts=opts, typ=GetVolumeResult).value

    return AwaitableGetVolumeResult(
        capacity_gi_b=__ret__.capacity_gi_b,
        id=__ret__.id,
        labels=__ret__.labels,
        mount_options=__ret__.mount_options,
        name=__ret__.name,
        provisioning_state=__ret__.provisioning_state,
        reclaim_policy=__ret__.reclaim_policy,
        system_data=__ret__.system_data,
        type=__ret__.type,
        volume_mode=__ret__.volume_mode)


@_utilities.lift_output_func(get_volume)
def get_volume_output(pool_name: Optional[pulumi.Input[str]] = None,
                      resource_group_name: Optional[pulumi.Input[str]] = None,
                      volume_name: Optional[pulumi.Input[str]] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetVolumeResult]:
    """
    Get a Volume


    :param str pool_name: Pool Object
    :param str resource_group_name: The name of the resource group. The name is case insensitive.
    :param str volume_name: Volume Resource
    """
    ...
