# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities

__all__ = [
    'AttestationServiceCreationSpecificParamsArgs',
    'JSONWebKeySetArgs',
    'JSONWebKeyArgs',
]

@pulumi.input_type
class AttestationServiceCreationSpecificParamsArgs:
    def __init__(__self__, *,
                 attestation_policy: Optional[pulumi.Input[str]] = None,
                 policy_signing_certificates: Optional[pulumi.Input['JSONWebKeySetArgs']] = None):
        """
        Client supplied parameters used to create a new attestation service instance.
        :param pulumi.Input[str] attestation_policy: Name of attestation policy.
        :param pulumi.Input['JSONWebKeySetArgs'] policy_signing_certificates: JSON Web Key Set defining a set of X.509 Certificates that will represent the parent certificate for the signing certificate used for policy operations
        """
        if attestation_policy is not None:
            pulumi.set(__self__, "attestation_policy", attestation_policy)
        if policy_signing_certificates is not None:
            pulumi.set(__self__, "policy_signing_certificates", policy_signing_certificates)

    @property
    @pulumi.getter(name="attestationPolicy")
    def attestation_policy(self) -> Optional[pulumi.Input[str]]:
        """
        Name of attestation policy.
        """
        return pulumi.get(self, "attestation_policy")

    @attestation_policy.setter
    def attestation_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "attestation_policy", value)

    @property
    @pulumi.getter(name="policySigningCertificates")
    def policy_signing_certificates(self) -> Optional[pulumi.Input['JSONWebKeySetArgs']]:
        """
        JSON Web Key Set defining a set of X.509 Certificates that will represent the parent certificate for the signing certificate used for policy operations
        """
        return pulumi.get(self, "policy_signing_certificates")

    @policy_signing_certificates.setter
    def policy_signing_certificates(self, value: Optional[pulumi.Input['JSONWebKeySetArgs']]):
        pulumi.set(self, "policy_signing_certificates", value)


@pulumi.input_type
class JSONWebKeySetArgs:
    def __init__(__self__, *,
                 keys: Optional[pulumi.Input[Sequence[pulumi.Input['JSONWebKeyArgs']]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['JSONWebKeyArgs']]] keys: The value of the "keys" parameter is an array of JWK values.  By
               default, the order of the JWK values within the array does not imply
               an order of preference among them, although applications of JWK Sets
               can choose to assign a meaning to the order for their purposes, if
               desired.
        """
        if keys is not None:
            pulumi.set(__self__, "keys", keys)

    @property
    @pulumi.getter
    def keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JSONWebKeyArgs']]]]:
        """
        The value of the "keys" parameter is an array of JWK values.  By
        default, the order of the JWK values within the array does not imply
        an order of preference among them, although applications of JWK Sets
        can choose to assign a meaning to the order for their purposes, if
        desired.
        """
        return pulumi.get(self, "keys")

    @keys.setter
    def keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JSONWebKeyArgs']]]]):
        pulumi.set(self, "keys", value)


@pulumi.input_type
class JSONWebKeyArgs:
    def __init__(__self__, *,
                 kty: pulumi.Input[str],
                 alg: Optional[pulumi.Input[str]] = None,
                 crv: Optional[pulumi.Input[str]] = None,
                 d: Optional[pulumi.Input[str]] = None,
                 dp: Optional[pulumi.Input[str]] = None,
                 dq: Optional[pulumi.Input[str]] = None,
                 e: Optional[pulumi.Input[str]] = None,
                 k: Optional[pulumi.Input[str]] = None,
                 kid: Optional[pulumi.Input[str]] = None,
                 n: Optional[pulumi.Input[str]] = None,
                 p: Optional[pulumi.Input[str]] = None,
                 q: Optional[pulumi.Input[str]] = None,
                 qi: Optional[pulumi.Input[str]] = None,
                 use: Optional[pulumi.Input[str]] = None,
                 x: Optional[pulumi.Input[str]] = None,
                 x5c: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 y: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] kty: The "kty" (key type) parameter identifies the cryptographic algorithm
               family used with the key, such as "RSA" or "EC". "kty" values should
               either be registered in the IANA "JSON Web Key Types" registry
               established by [JWA] or be a value that contains a Collision-
               Resistant Name.  The "kty" value is a case-sensitive string.
        :param pulumi.Input[str] alg: The "alg" (algorithm) parameter identifies the algorithm intended for
               use with the key.  The values used should either be registered in the
               IANA "JSON Web Signature and Encryption Algorithms" registry
               established by [JWA] or be a value that contains a Collision-
               Resistant Name.
        :param pulumi.Input[str] crv: The "crv" (curve) parameter identifies the curve type
        :param pulumi.Input[str] d: RSA private exponent or ECC private key
        :param pulumi.Input[str] dp: RSA Private Key Parameter
        :param pulumi.Input[str] dq: RSA Private Key Parameter
        :param pulumi.Input[str] e: RSA public exponent, in Base64
        :param pulumi.Input[str] k: Symmetric key
        :param pulumi.Input[str] kid: The "kid" (key ID) parameter is used to match a specific key.  This
               is used, for instance, to choose among a set of keys within a JWK Set
               during key rollover.  The structure of the "kid" value is
               unspecified.  When "kid" values are used within a JWK Set, different
               keys within the JWK Set SHOULD use distinct "kid" values.  (One
               example in which different keys might use the same "kid" value is if
               they have different "kty" (key type) values but are considered to be
               equivalent alternatives by the application using them.)  The "kid"
               value is a case-sensitive string.
        :param pulumi.Input[str] n: RSA modulus, in Base64
        :param pulumi.Input[str] p: RSA secret prime
        :param pulumi.Input[str] q: RSA secret prime, with p < q
        :param pulumi.Input[str] qi: RSA Private Key Parameter
        :param pulumi.Input[str] use: Use ("public key use") identifies the intended use of
               the public key. The "use" parameter is employed to indicate whether
               a public key is used for encrypting data or verifying the signature
               on data. Values are commonly "sig" (signature) or "enc" (encryption).
        :param pulumi.Input[str] x: X coordinate for the Elliptic Curve point
        :param pulumi.Input[Sequence[pulumi.Input[str]]] x5c: The "x5c" (X.509 certificate chain) parameter contains a chain of one
               or more PKIX certificates [RFC5280].  The certificate chain is
               represented as a JSON array of certificate value strings.  Each
               string in the array is a base64-encoded (Section 4 of [RFC4648] --
               not base64url-encoded) DER [ITU.X690.1994] PKIX certificate value.
               The PKIX certificate containing the key value MUST be the first
               certificate.
        :param pulumi.Input[str] y: Y coordinate for the Elliptic Curve point
        """
        pulumi.set(__self__, "kty", kty)
        if alg is not None:
            pulumi.set(__self__, "alg", alg)
        if crv is not None:
            pulumi.set(__self__, "crv", crv)
        if d is not None:
            pulumi.set(__self__, "d", d)
        if dp is not None:
            pulumi.set(__self__, "dp", dp)
        if dq is not None:
            pulumi.set(__self__, "dq", dq)
        if e is not None:
            pulumi.set(__self__, "e", e)
        if k is not None:
            pulumi.set(__self__, "k", k)
        if kid is not None:
            pulumi.set(__self__, "kid", kid)
        if n is not None:
            pulumi.set(__self__, "n", n)
        if p is not None:
            pulumi.set(__self__, "p", p)
        if q is not None:
            pulumi.set(__self__, "q", q)
        if qi is not None:
            pulumi.set(__self__, "qi", qi)
        if use is not None:
            pulumi.set(__self__, "use", use)
        if x is not None:
            pulumi.set(__self__, "x", x)
        if x5c is not None:
            pulumi.set(__self__, "x5c", x5c)
        if y is not None:
            pulumi.set(__self__, "y", y)

    @property
    @pulumi.getter
    def kty(self) -> pulumi.Input[str]:
        """
        The "kty" (key type) parameter identifies the cryptographic algorithm
        family used with the key, such as "RSA" or "EC". "kty" values should
        either be registered in the IANA "JSON Web Key Types" registry
        established by [JWA] or be a value that contains a Collision-
        Resistant Name.  The "kty" value is a case-sensitive string.
        """
        return pulumi.get(self, "kty")

    @kty.setter
    def kty(self, value: pulumi.Input[str]):
        pulumi.set(self, "kty", value)

    @property
    @pulumi.getter
    def alg(self) -> Optional[pulumi.Input[str]]:
        """
        The "alg" (algorithm) parameter identifies the algorithm intended for
        use with the key.  The values used should either be registered in the
        IANA "JSON Web Signature and Encryption Algorithms" registry
        established by [JWA] or be a value that contains a Collision-
        Resistant Name.
        """
        return pulumi.get(self, "alg")

    @alg.setter
    def alg(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "alg", value)

    @property
    @pulumi.getter
    def crv(self) -> Optional[pulumi.Input[str]]:
        """
        The "crv" (curve) parameter identifies the curve type
        """
        return pulumi.get(self, "crv")

    @crv.setter
    def crv(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "crv", value)

    @property
    @pulumi.getter
    def d(self) -> Optional[pulumi.Input[str]]:
        """
        RSA private exponent or ECC private key
        """
        return pulumi.get(self, "d")

    @d.setter
    def d(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "d", value)

    @property
    @pulumi.getter
    def dp(self) -> Optional[pulumi.Input[str]]:
        """
        RSA Private Key Parameter
        """
        return pulumi.get(self, "dp")

    @dp.setter
    def dp(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dp", value)

    @property
    @pulumi.getter
    def dq(self) -> Optional[pulumi.Input[str]]:
        """
        RSA Private Key Parameter
        """
        return pulumi.get(self, "dq")

    @dq.setter
    def dq(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dq", value)

    @property
    @pulumi.getter
    def e(self) -> Optional[pulumi.Input[str]]:
        """
        RSA public exponent, in Base64
        """
        return pulumi.get(self, "e")

    @e.setter
    def e(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "e", value)

    @property
    @pulumi.getter
    def k(self) -> Optional[pulumi.Input[str]]:
        """
        Symmetric key
        """
        return pulumi.get(self, "k")

    @k.setter
    def k(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "k", value)

    @property
    @pulumi.getter
    def kid(self) -> Optional[pulumi.Input[str]]:
        """
        The "kid" (key ID) parameter is used to match a specific key.  This
        is used, for instance, to choose among a set of keys within a JWK Set
        during key rollover.  The structure of the "kid" value is
        unspecified.  When "kid" values are used within a JWK Set, different
        keys within the JWK Set SHOULD use distinct "kid" values.  (One
        example in which different keys might use the same "kid" value is if
        they have different "kty" (key type) values but are considered to be
        equivalent alternatives by the application using them.)  The "kid"
        value is a case-sensitive string.
        """
        return pulumi.get(self, "kid")

    @kid.setter
    def kid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kid", value)

    @property
    @pulumi.getter
    def n(self) -> Optional[pulumi.Input[str]]:
        """
        RSA modulus, in Base64
        """
        return pulumi.get(self, "n")

    @n.setter
    def n(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "n", value)

    @property
    @pulumi.getter
    def p(self) -> Optional[pulumi.Input[str]]:
        """
        RSA secret prime
        """
        return pulumi.get(self, "p")

    @p.setter
    def p(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "p", value)

    @property
    @pulumi.getter
    def q(self) -> Optional[pulumi.Input[str]]:
        """
        RSA secret prime, with p < q
        """
        return pulumi.get(self, "q")

    @q.setter
    def q(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "q", value)

    @property
    @pulumi.getter
    def qi(self) -> Optional[pulumi.Input[str]]:
        """
        RSA Private Key Parameter
        """
        return pulumi.get(self, "qi")

    @qi.setter
    def qi(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "qi", value)

    @property
    @pulumi.getter
    def use(self) -> Optional[pulumi.Input[str]]:
        """
        Use ("public key use") identifies the intended use of
        the public key. The "use" parameter is employed to indicate whether
        a public key is used for encrypting data or verifying the signature
        on data. Values are commonly "sig" (signature) or "enc" (encryption).
        """
        return pulumi.get(self, "use")

    @use.setter
    def use(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "use", value)

    @property
    @pulumi.getter
    def x(self) -> Optional[pulumi.Input[str]]:
        """
        X coordinate for the Elliptic Curve point
        """
        return pulumi.get(self, "x")

    @x.setter
    def x(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "x", value)

    @property
    @pulumi.getter
    def x5c(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The "x5c" (X.509 certificate chain) parameter contains a chain of one
        or more PKIX certificates [RFC5280].  The certificate chain is
        represented as a JSON array of certificate value strings.  Each
        string in the array is a base64-encoded (Section 4 of [RFC4648] --
        not base64url-encoded) DER [ITU.X690.1994] PKIX certificate value.
        The PKIX certificate containing the key value MUST be the first
        certificate.
        """
        return pulumi.get(self, "x5c")

    @x5c.setter
    def x5c(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "x5c", value)

    @property
    @pulumi.getter
    def y(self) -> Optional[pulumi.Input[str]]:
        """
        Y coordinate for the Elliptic Curve point
        """
        return pulumi.get(self, "y")

    @y.setter
    def y(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "y", value)


