# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetSqlPoolVulnerabilityAssessmentRuleBaselineResult',
    'AwaitableGetSqlPoolVulnerabilityAssessmentRuleBaselineResult',
    'get_sql_pool_vulnerability_assessment_rule_baseline',
    'get_sql_pool_vulnerability_assessment_rule_baseline_output',
]

warnings.warn("""Version 2019-06-01-preview will be removed in v2 of the provider.""", DeprecationWarning)

@pulumi.output_type
class GetSqlPoolVulnerabilityAssessmentRuleBaselineResult:
    """
    A Sql pool vulnerability assessment rule baseline.
    """
    def __init__(__self__, baseline_results=None, id=None, name=None, type=None):
        if baseline_results and not isinstance(baseline_results, list):
            raise TypeError("Expected argument 'baseline_results' to be a list")
        pulumi.set(__self__, "baseline_results", baseline_results)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="baselineResults")
    def baseline_results(self) -> Sequence['outputs.SqlPoolVulnerabilityAssessmentRuleBaselineItemResponse']:
        """
        The rule baseline result
        """
        return pulumi.get(self, "baseline_results")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
        """
        return pulumi.get(self, "type")


class AwaitableGetSqlPoolVulnerabilityAssessmentRuleBaselineResult(GetSqlPoolVulnerabilityAssessmentRuleBaselineResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSqlPoolVulnerabilityAssessmentRuleBaselineResult(
            baseline_results=self.baseline_results,
            id=self.id,
            name=self.name,
            type=self.type)


def get_sql_pool_vulnerability_assessment_rule_baseline(baseline_name: Optional[str] = None,
                                                        resource_group_name: Optional[str] = None,
                                                        rule_id: Optional[str] = None,
                                                        sql_pool_name: Optional[str] = None,
                                                        vulnerability_assessment_name: Optional[str] = None,
                                                        workspace_name: Optional[str] = None,
                                                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSqlPoolVulnerabilityAssessmentRuleBaselineResult:
    """
    Gets a SqlPool's vulnerability assessment rule baseline.


    :param str baseline_name: The name of the vulnerability assessment rule baseline (default implies a baseline on a Sql pool level rule and master for server level rule).
    :param str resource_group_name: The name of the resource group. The name is case insensitive.
    :param str rule_id: The vulnerability assessment rule ID.
    :param str sql_pool_name: SQL pool name
    :param str vulnerability_assessment_name: The name of the vulnerability assessment.
    :param str workspace_name: The name of the workspace
    """
    pulumi.log.warn("""get_sql_pool_vulnerability_assessment_rule_baseline is deprecated: Version 2019-06-01-preview will be removed in v2 of the provider.""")
    __args__ = dict()
    __args__['baselineName'] = baseline_name
    __args__['resourceGroupName'] = resource_group_name
    __args__['ruleId'] = rule_id
    __args__['sqlPoolName'] = sql_pool_name
    __args__['vulnerabilityAssessmentName'] = vulnerability_assessment_name
    __args__['workspaceName'] = workspace_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure-native:synapse/v20190601preview:getSqlPoolVulnerabilityAssessmentRuleBaseline', __args__, opts=opts, typ=GetSqlPoolVulnerabilityAssessmentRuleBaselineResult).value

    return AwaitableGetSqlPoolVulnerabilityAssessmentRuleBaselineResult(
        baseline_results=__ret__.baseline_results,
        id=__ret__.id,
        name=__ret__.name,
        type=__ret__.type)


@_utilities.lift_output_func(get_sql_pool_vulnerability_assessment_rule_baseline)
def get_sql_pool_vulnerability_assessment_rule_baseline_output(baseline_name: Optional[pulumi.Input[str]] = None,
                                                               resource_group_name: Optional[pulumi.Input[str]] = None,
                                                               rule_id: Optional[pulumi.Input[str]] = None,
                                                               sql_pool_name: Optional[pulumi.Input[str]] = None,
                                                               vulnerability_assessment_name: Optional[pulumi.Input[str]] = None,
                                                               workspace_name: Optional[pulumi.Input[str]] = None,
                                                               opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetSqlPoolVulnerabilityAssessmentRuleBaselineResult]:
    """
    Gets a SqlPool's vulnerability assessment rule baseline.


    :param str baseline_name: The name of the vulnerability assessment rule baseline (default implies a baseline on a Sql pool level rule and master for server level rule).
    :param str resource_group_name: The name of the resource group. The name is case insensitive.
    :param str rule_id: The vulnerability assessment rule ID.
    :param str sql_pool_name: SQL pool name
    :param str vulnerability_assessment_name: The name of the vulnerability assessment.
    :param str workspace_name: The name of the workspace
    """
    pulumi.log.warn("""get_sql_pool_vulnerability_assessment_rule_baseline is deprecated: Version 2019-06-01-preview will be removed in v2 of the provider.""")
    ...
