# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'GovernanceAssignmentAdditionalDataResponse',
    'GovernanceEmailNotificationResponse',
    'GovernanceRuleEmailNotificationResponse',
    'GovernanceRuleMetadataResponse',
    'GovernanceRuleOwnerSourceResponse',
    'RemediationEtaResponse',
]

@pulumi.output_type
class GovernanceAssignmentAdditionalDataResponse(dict):
    """
    Describe the additional data of governance assignment - optional
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ticketLink":
            suggest = "ticket_link"
        elif key == "ticketNumber":
            suggest = "ticket_number"
        elif key == "ticketStatus":
            suggest = "ticket_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GovernanceAssignmentAdditionalDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GovernanceAssignmentAdditionalDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GovernanceAssignmentAdditionalDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ticket_link: Optional[str] = None,
                 ticket_number: Optional[int] = None,
                 ticket_status: Optional[str] = None):
        """
        Describe the additional data of governance assignment - optional
        :param str ticket_link: Ticket link associated with this governance assignment - for example: https://snow.com
        :param int ticket_number: Ticket number associated with this governance assignment
        :param str ticket_status: The ticket status associated with this governance assignment - for example: Active
        """
        if ticket_link is not None:
            pulumi.set(__self__, "ticket_link", ticket_link)
        if ticket_number is not None:
            pulumi.set(__self__, "ticket_number", ticket_number)
        if ticket_status is not None:
            pulumi.set(__self__, "ticket_status", ticket_status)

    @property
    @pulumi.getter(name="ticketLink")
    def ticket_link(self) -> Optional[str]:
        """
        Ticket link associated with this governance assignment - for example: https://snow.com
        """
        return pulumi.get(self, "ticket_link")

    @property
    @pulumi.getter(name="ticketNumber")
    def ticket_number(self) -> Optional[int]:
        """
        Ticket number associated with this governance assignment
        """
        return pulumi.get(self, "ticket_number")

    @property
    @pulumi.getter(name="ticketStatus")
    def ticket_status(self) -> Optional[str]:
        """
        The ticket status associated with this governance assignment - for example: Active
        """
        return pulumi.get(self, "ticket_status")


@pulumi.output_type
class GovernanceEmailNotificationResponse(dict):
    """
    The governance email weekly notification configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "disableManagerEmailNotification":
            suggest = "disable_manager_email_notification"
        elif key == "disableOwnerEmailNotification":
            suggest = "disable_owner_email_notification"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GovernanceEmailNotificationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GovernanceEmailNotificationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GovernanceEmailNotificationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disable_manager_email_notification: Optional[bool] = None,
                 disable_owner_email_notification: Optional[bool] = None):
        """
        The governance email weekly notification configuration.
        :param bool disable_manager_email_notification: Exclude manager from weekly email notification.
        :param bool disable_owner_email_notification: Exclude  owner from weekly email notification.
        """
        if disable_manager_email_notification is not None:
            pulumi.set(__self__, "disable_manager_email_notification", disable_manager_email_notification)
        if disable_owner_email_notification is not None:
            pulumi.set(__self__, "disable_owner_email_notification", disable_owner_email_notification)

    @property
    @pulumi.getter(name="disableManagerEmailNotification")
    def disable_manager_email_notification(self) -> Optional[bool]:
        """
        Exclude manager from weekly email notification.
        """
        return pulumi.get(self, "disable_manager_email_notification")

    @property
    @pulumi.getter(name="disableOwnerEmailNotification")
    def disable_owner_email_notification(self) -> Optional[bool]:
        """
        Exclude  owner from weekly email notification.
        """
        return pulumi.get(self, "disable_owner_email_notification")


@pulumi.output_type
class GovernanceRuleEmailNotificationResponse(dict):
    """
    The governance email weekly notification configuration
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "disableManagerEmailNotification":
            suggest = "disable_manager_email_notification"
        elif key == "disableOwnerEmailNotification":
            suggest = "disable_owner_email_notification"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GovernanceRuleEmailNotificationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GovernanceRuleEmailNotificationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GovernanceRuleEmailNotificationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disable_manager_email_notification: Optional[bool] = None,
                 disable_owner_email_notification: Optional[bool] = None):
        """
        The governance email weekly notification configuration
        :param bool disable_manager_email_notification: Defines whether manager email notifications are disabled
        :param bool disable_owner_email_notification: Defines whether owner email notifications are disabled
        """
        if disable_manager_email_notification is not None:
            pulumi.set(__self__, "disable_manager_email_notification", disable_manager_email_notification)
        if disable_owner_email_notification is not None:
            pulumi.set(__self__, "disable_owner_email_notification", disable_owner_email_notification)

    @property
    @pulumi.getter(name="disableManagerEmailNotification")
    def disable_manager_email_notification(self) -> Optional[bool]:
        """
        Defines whether manager email notifications are disabled
        """
        return pulumi.get(self, "disable_manager_email_notification")

    @property
    @pulumi.getter(name="disableOwnerEmailNotification")
    def disable_owner_email_notification(self) -> Optional[bool]:
        """
        Defines whether owner email notifications are disabled
        """
        return pulumi.get(self, "disable_owner_email_notification")


@pulumi.output_type
class GovernanceRuleMetadataResponse(dict):
    """
    The governance rule metadata
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdBy":
            suggest = "created_by"
        elif key == "createdOn":
            suggest = "created_on"
        elif key == "updatedBy":
            suggest = "updated_by"
        elif key == "updatedOn":
            suggest = "updated_on"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GovernanceRuleMetadataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GovernanceRuleMetadataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GovernanceRuleMetadataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_by: str,
                 created_on: str,
                 updated_by: str,
                 updated_on: str):
        """
        The governance rule metadata
        :param str created_by: Governance rule Created by object id (GUID)
        :param str created_on: Governance rule creation date
        :param str updated_by: Governance rule last updated by object id (GUID)
        :param str updated_on: Governance rule last update date
        """
        pulumi.set(__self__, "created_by", created_by)
        pulumi.set(__self__, "created_on", created_on)
        pulumi.set(__self__, "updated_by", updated_by)
        pulumi.set(__self__, "updated_on", updated_on)

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> str:
        """
        Governance rule Created by object id (GUID)
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="createdOn")
    def created_on(self) -> str:
        """
        Governance rule creation date
        """
        return pulumi.get(self, "created_on")

    @property
    @pulumi.getter(name="updatedBy")
    def updated_by(self) -> str:
        """
        Governance rule last updated by object id (GUID)
        """
        return pulumi.get(self, "updated_by")

    @property
    @pulumi.getter(name="updatedOn")
    def updated_on(self) -> str:
        """
        Governance rule last update date
        """
        return pulumi.get(self, "updated_on")


@pulumi.output_type
class GovernanceRuleOwnerSourceResponse(dict):
    """
    Describe the owner source of governance rule
    """
    def __init__(__self__, *,
                 type: Optional[str] = None,
                 value: Optional[str] = None):
        """
        Describe the owner source of governance rule
        :param str type: The owner type for the governance rule owner source
        :param str value: The source value e.g. tag key like owner name or email address
        """
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The owner type for the governance rule owner source
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        The source value e.g. tag key like owner name or email address
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class RemediationEtaResponse(dict):
    """
    The ETA (estimated time of arrival) for remediation
    """
    def __init__(__self__, *,
                 eta: str,
                 justification: str):
        """
        The ETA (estimated time of arrival) for remediation
        :param str eta: ETA for remediation.
        :param str justification: Justification for change of Eta.
        """
        pulumi.set(__self__, "eta", eta)
        pulumi.set(__self__, "justification", justification)

    @property
    @pulumi.getter
    def eta(self) -> str:
        """
        ETA for remediation.
        """
        return pulumi.get(self, "eta")

    @property
    @pulumi.getter
    def justification(self) -> str:
        """
        Justification for change of Eta.
        """
        return pulumi.get(self, "justification")


