# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['TrunkedNetworkArgs', 'TrunkedNetwork']

@pulumi.input_type
class TrunkedNetworkArgs:
    def __init__(__self__, *,
                 extended_location: pulumi.Input['ExtendedLocationArgs'],
                 isolation_domain_ids: pulumi.Input[Sequence[pulumi.Input[str]]],
                 resource_group_name: pulumi.Input[str],
                 vlans: pulumi.Input[Sequence[pulumi.Input[float]]],
                 hybrid_aks_plugin_type: Optional[pulumi.Input[Union[str, 'HybridAksPluginType']]] = None,
                 interface_name: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 trunked_network_name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a TrunkedNetwork resource.
        :param pulumi.Input['ExtendedLocationArgs'] extended_location: The extended location of the cluster associated with the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] isolation_domain_ids: The list of resource IDs representing the Network Fabric isolation domains. It can be any combination of l2IsolationDomain and l3IsolationDomain resources.
        :param pulumi.Input[str] resource_group_name: The name of the resource group. The name is case insensitive.
        :param pulumi.Input[Sequence[pulumi.Input[float]]] vlans: The list of vlans that are selected from the isolation domains for trunking.
        :param pulumi.Input[Union[str, 'HybridAksPluginType']] hybrid_aks_plugin_type: The network plugin type for Hybrid AKS.
        :param pulumi.Input[str] interface_name: The default interface name for this trunked network in the virtual machine. This name can be overridden by the name supplied in the network attachment configuration of that virtual machine.
        :param pulumi.Input[str] location: The geo-location where the resource lives
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Resource tags.
        :param pulumi.Input[str] trunked_network_name: The name of the trunked network.
        """
        pulumi.set(__self__, "extended_location", extended_location)
        pulumi.set(__self__, "isolation_domain_ids", isolation_domain_ids)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "vlans", vlans)
        if hybrid_aks_plugin_type is None:
            hybrid_aks_plugin_type = 'SRIOV'
        if hybrid_aks_plugin_type is not None:
            pulumi.set(__self__, "hybrid_aks_plugin_type", hybrid_aks_plugin_type)
        if interface_name is not None:
            pulumi.set(__self__, "interface_name", interface_name)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if trunked_network_name is not None:
            pulumi.set(__self__, "trunked_network_name", trunked_network_name)

    @property
    @pulumi.getter(name="extendedLocation")
    def extended_location(self) -> pulumi.Input['ExtendedLocationArgs']:
        """
        The extended location of the cluster associated with the resource.
        """
        return pulumi.get(self, "extended_location")

    @extended_location.setter
    def extended_location(self, value: pulumi.Input['ExtendedLocationArgs']):
        pulumi.set(self, "extended_location", value)

    @property
    @pulumi.getter(name="isolationDomainIds")
    def isolation_domain_ids(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The list of resource IDs representing the Network Fabric isolation domains. It can be any combination of l2IsolationDomain and l3IsolationDomain resources.
        """
        return pulumi.get(self, "isolation_domain_ids")

    @isolation_domain_ids.setter
    def isolation_domain_ids(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "isolation_domain_ids", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[str]:
        """
        The name of the resource group. The name is case insensitive.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter
    def vlans(self) -> pulumi.Input[Sequence[pulumi.Input[float]]]:
        """
        The list of vlans that are selected from the isolation domains for trunking.
        """
        return pulumi.get(self, "vlans")

    @vlans.setter
    def vlans(self, value: pulumi.Input[Sequence[pulumi.Input[float]]]):
        pulumi.set(self, "vlans", value)

    @property
    @pulumi.getter(name="hybridAksPluginType")
    def hybrid_aks_plugin_type(self) -> Optional[pulumi.Input[Union[str, 'HybridAksPluginType']]]:
        """
        The network plugin type for Hybrid AKS.
        """
        return pulumi.get(self, "hybrid_aks_plugin_type")

    @hybrid_aks_plugin_type.setter
    def hybrid_aks_plugin_type(self, value: Optional[pulumi.Input[Union[str, 'HybridAksPluginType']]]):
        pulumi.set(self, "hybrid_aks_plugin_type", value)

    @property
    @pulumi.getter(name="interfaceName")
    def interface_name(self) -> Optional[pulumi.Input[str]]:
        """
        The default interface name for this trunked network in the virtual machine. This name can be overridden by the name supplied in the network attachment configuration of that virtual machine.
        """
        return pulumi.get(self, "interface_name")

    @interface_name.setter
    def interface_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "interface_name", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        The geo-location where the resource lives
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="trunkedNetworkName")
    def trunked_network_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the trunked network.
        """
        return pulumi.get(self, "trunked_network_name")

    @trunked_network_name.setter
    def trunked_network_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "trunked_network_name", value)


class TrunkedNetwork(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 extended_location: Optional[pulumi.Input[pulumi.InputType['ExtendedLocationArgs']]] = None,
                 hybrid_aks_plugin_type: Optional[pulumi.Input[Union[str, 'HybridAksPluginType']]] = None,
                 interface_name: Optional[pulumi.Input[str]] = None,
                 isolation_domain_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 trunked_network_name: Optional[pulumi.Input[str]] = None,
                 vlans: Optional[pulumi.Input[Sequence[pulumi.Input[float]]]] = None,
                 __props__=None):
        """
        Create a TrunkedNetwork resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['ExtendedLocationArgs']] extended_location: The extended location of the cluster associated with the resource.
        :param pulumi.Input[Union[str, 'HybridAksPluginType']] hybrid_aks_plugin_type: The network plugin type for Hybrid AKS.
        :param pulumi.Input[str] interface_name: The default interface name for this trunked network in the virtual machine. This name can be overridden by the name supplied in the network attachment configuration of that virtual machine.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] isolation_domain_ids: The list of resource IDs representing the Network Fabric isolation domains. It can be any combination of l2IsolationDomain and l3IsolationDomain resources.
        :param pulumi.Input[str] location: The geo-location where the resource lives
        :param pulumi.Input[str] resource_group_name: The name of the resource group. The name is case insensitive.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Resource tags.
        :param pulumi.Input[str] trunked_network_name: The name of the trunked network.
        :param pulumi.Input[Sequence[pulumi.Input[float]]] vlans: The list of vlans that are selected from the isolation domains for trunking.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TrunkedNetworkArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a TrunkedNetwork resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param TrunkedNetworkArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TrunkedNetworkArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 extended_location: Optional[pulumi.Input[pulumi.InputType['ExtendedLocationArgs']]] = None,
                 hybrid_aks_plugin_type: Optional[pulumi.Input[Union[str, 'HybridAksPluginType']]] = None,
                 interface_name: Optional[pulumi.Input[str]] = None,
                 isolation_domain_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 trunked_network_name: Optional[pulumi.Input[str]] = None,
                 vlans: Optional[pulumi.Input[Sequence[pulumi.Input[float]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TrunkedNetworkArgs.__new__(TrunkedNetworkArgs)

            if extended_location is None and not opts.urn:
                raise TypeError("Missing required property 'extended_location'")
            __props__.__dict__["extended_location"] = extended_location
            if hybrid_aks_plugin_type is None:
                hybrid_aks_plugin_type = 'SRIOV'
            __props__.__dict__["hybrid_aks_plugin_type"] = hybrid_aks_plugin_type
            __props__.__dict__["interface_name"] = interface_name
            if isolation_domain_ids is None and not opts.urn:
                raise TypeError("Missing required property 'isolation_domain_ids'")
            __props__.__dict__["isolation_domain_ids"] = isolation_domain_ids
            __props__.__dict__["location"] = location
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["trunked_network_name"] = trunked_network_name
            if vlans is None and not opts.urn:
                raise TypeError("Missing required property 'vlans'")
            __props__.__dict__["vlans"] = vlans
            __props__.__dict__["cluster_id"] = None
            __props__.__dict__["detailed_status"] = None
            __props__.__dict__["detailed_status_message"] = None
            __props__.__dict__["hybrid_aks_clusters_associated_ids"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["provisioning_state"] = None
            __props__.__dict__["system_data"] = None
            __props__.__dict__["type"] = None
            __props__.__dict__["virtual_machines_associated_ids"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="azure-native:networkcloud:TrunkedNetwork")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(TrunkedNetwork, __self__).__init__(
            'azure-native:networkcloud/v20221212preview:TrunkedNetwork',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'TrunkedNetwork':
        """
        Get an existing TrunkedNetwork resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = TrunkedNetworkArgs.__new__(TrunkedNetworkArgs)

        __props__.__dict__["cluster_id"] = None
        __props__.__dict__["detailed_status"] = None
        __props__.__dict__["detailed_status_message"] = None
        __props__.__dict__["extended_location"] = None
        __props__.__dict__["hybrid_aks_clusters_associated_ids"] = None
        __props__.__dict__["hybrid_aks_plugin_type"] = None
        __props__.__dict__["interface_name"] = None
        __props__.__dict__["isolation_domain_ids"] = None
        __props__.__dict__["location"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["provisioning_state"] = None
        __props__.__dict__["system_data"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["type"] = None
        __props__.__dict__["virtual_machines_associated_ids"] = None
        __props__.__dict__["vlans"] = None
        return TrunkedNetwork(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Output[str]:
        """
        The resource ID of the Network Cloud cluster this trunked network is associated with.
        """
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter(name="detailedStatus")
    def detailed_status(self) -> pulumi.Output[str]:
        """
        The more detailed status of the trunked network.
        """
        return pulumi.get(self, "detailed_status")

    @property
    @pulumi.getter(name="detailedStatusMessage")
    def detailed_status_message(self) -> pulumi.Output[str]:
        """
        The descriptive message about the current detailed status.
        """
        return pulumi.get(self, "detailed_status_message")

    @property
    @pulumi.getter(name="extendedLocation")
    def extended_location(self) -> pulumi.Output['outputs.ExtendedLocationResponse']:
        """
        The extended location of the cluster associated with the resource.
        """
        return pulumi.get(self, "extended_location")

    @property
    @pulumi.getter(name="hybridAksClustersAssociatedIds")
    def hybrid_aks_clusters_associated_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        The list of Hybrid AKS cluster resource IDs that are associated with this trunked network.
        """
        return pulumi.get(self, "hybrid_aks_clusters_associated_ids")

    @property
    @pulumi.getter(name="hybridAksPluginType")
    def hybrid_aks_plugin_type(self) -> pulumi.Output[Optional[str]]:
        """
        The network plugin type for Hybrid AKS.
        """
        return pulumi.get(self, "hybrid_aks_plugin_type")

    @property
    @pulumi.getter(name="interfaceName")
    def interface_name(self) -> pulumi.Output[Optional[str]]:
        """
        The default interface name for this trunked network in the virtual machine. This name can be overridden by the name supplied in the network attachment configuration of that virtual machine.
        """
        return pulumi.get(self, "interface_name")

    @property
    @pulumi.getter(name="isolationDomainIds")
    def isolation_domain_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        The list of resource IDs representing the Network Fabric isolation domains. It can be any combination of l2IsolationDomain and l3IsolationDomain resources.
        """
        return pulumi.get(self, "isolation_domain_ids")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        """
        The geo-location where the resource lives
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> pulumi.Output[str]:
        """
        The provisioning state of the trunked network.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="systemData")
    def system_data(self) -> pulumi.Output['outputs.SystemDataResponse']:
        """
        Azure Resource Manager metadata containing createdBy and modifiedBy information.
        """
        return pulumi.get(self, "system_data")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="virtualMachinesAssociatedIds")
    def virtual_machines_associated_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        The list of virtual machine resource IDs, excluding any Hybrid AKS virtual machines, that are currently using this trunked network.
        """
        return pulumi.get(self, "virtual_machines_associated_ids")

    @property
    @pulumi.getter
    def vlans(self) -> pulumi.Output[Sequence[float]]:
        """
        The list of vlans that are selected from the isolation domains for trunking.
        """
        return pulumi.get(self, "vlans")

