# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AccessControlResponse',
    'AccountEncryptionResponse',
    'AssetFileEncryptionMetadataResponse',
    'AssetStreamingLocatorResponse',
    'AudioTrackResponse',
    'CbcsDrmConfigurationResponse',
    'CencDrmConfigurationResponse',
    'ClearKeyEncryptionConfigurationResponse',
    'CommonEncryptionCbcsResponse',
    'CommonEncryptionCencResponse',
    'ContentKeyPolicyClearKeyConfigurationResponse',
    'ContentKeyPolicyFairPlayConfigurationResponse',
    'ContentKeyPolicyFairPlayOfflineRentalConfigurationResponse',
    'ContentKeyPolicyOpenRestrictionResponse',
    'ContentKeyPolicyOptionResponse',
    'ContentKeyPolicyPlayReadyConfigurationResponse',
    'ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeaderResponse',
    'ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifierResponse',
    'ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestrictionResponse',
    'ContentKeyPolicyPlayReadyLicenseResponse',
    'ContentKeyPolicyPlayReadyPlayRightResponse',
    'ContentKeyPolicyRsaTokenKeyResponse',
    'ContentKeyPolicySymmetricTokenKeyResponse',
    'ContentKeyPolicyTokenClaimResponse',
    'ContentKeyPolicyTokenRestrictionResponse',
    'ContentKeyPolicyUnknownConfigurationResponse',
    'ContentKeyPolicyUnknownRestrictionResponse',
    'ContentKeyPolicyWidevineConfigurationResponse',
    'ContentKeyPolicyX509CertificateTokenKeyResponse',
    'DashSettingsResponse',
    'DefaultKeyResponse',
    'EdgeUsageDataCollectionPolicyResponse',
    'EdgeUsageDataEventHubResponse',
    'EnabledProtocolsResponse',
    'EnvelopeEncryptionResponse',
    'FilterTrackPropertyConditionResponse',
    'FilterTrackSelectionResponse',
    'FirstQualityResponse',
    'HlsSettingsResponse',
    'KeyDeliveryResponse',
    'KeyVaultPropertiesResponse',
    'MediaServiceIdentityResponse',
    'NoEncryptionResponse',
    'PresentationTimeRangeResponse',
    'PrivateEndpointConnectionResponse',
    'PrivateEndpointResponse',
    'PrivateLinkServiceConnectionStateResponse',
    'ResourceIdentityResponse',
    'StorageAccountResponse',
    'StreamingLocatorContentKeyResponse',
    'StreamingPathResponse',
    'StreamingPolicyContentKeyResponse',
    'StreamingPolicyContentKeysResponse',
    'StreamingPolicyFairPlayConfigurationResponse',
    'StreamingPolicyPlayReadyConfigurationResponse',
    'StreamingPolicyWidevineConfigurationResponse',
    'SystemDataResponse',
    'TextTrackResponse',
    'TrackPropertyConditionResponse',
    'TrackSelectionResponse',
    'UserAssignedManagedIdentityResponse',
    'VideoTrackResponse',
]

@pulumi.output_type
class AccessControlResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultAction":
            suggest = "default_action"
        elif key == "ipAllowList":
            suggest = "ip_allow_list"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccessControlResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccessControlResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccessControlResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_action: Optional[str] = None,
                 ip_allow_list: Optional[Sequence[str]] = None):
        """
        :param str default_action: The behavior for IP access control in Key Delivery.
        :param Sequence[str] ip_allow_list: The IP allow list for access control in Key Delivery. If the default action is set to 'Allow', the IP allow list must be empty.
        """
        if default_action is not None:
            pulumi.set(__self__, "default_action", default_action)
        if ip_allow_list is not None:
            pulumi.set(__self__, "ip_allow_list", ip_allow_list)

    @property
    @pulumi.getter(name="defaultAction")
    def default_action(self) -> Optional[str]:
        """
        The behavior for IP access control in Key Delivery.
        """
        return pulumi.get(self, "default_action")

    @property
    @pulumi.getter(name="ipAllowList")
    def ip_allow_list(self) -> Optional[Sequence[str]]:
        """
        The IP allow list for access control in Key Delivery. If the default action is set to 'Allow', the IP allow list must be empty.
        """
        return pulumi.get(self, "ip_allow_list")


@pulumi.output_type
class AccountEncryptionResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyVaultProperties":
            suggest = "key_vault_properties"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccountEncryptionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccountEncryptionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccountEncryptionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 status: str,
                 type: str,
                 identity: Optional['outputs.ResourceIdentityResponse'] = None,
                 key_vault_properties: Optional['outputs.KeyVaultPropertiesResponse'] = None):
        """
        :param str status: The current status of the Key Vault mapping.
        :param str type: The type of key used to encrypt the Account Key.
        :param 'ResourceIdentityResponse' identity: The Key Vault identity.
        :param 'KeyVaultPropertiesResponse' key_vault_properties: The properties of the key used to encrypt the account.
        """
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "type", type)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if key_vault_properties is not None:
            pulumi.set(__self__, "key_vault_properties", key_vault_properties)

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The current status of the Key Vault mapping.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of key used to encrypt the Account Key.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def identity(self) -> Optional['outputs.ResourceIdentityResponse']:
        """
        The Key Vault identity.
        """
        return pulumi.get(self, "identity")

    @property
    @pulumi.getter(name="keyVaultProperties")
    def key_vault_properties(self) -> Optional['outputs.KeyVaultPropertiesResponse']:
        """
        The properties of the key used to encrypt the account.
        """
        return pulumi.get(self, "key_vault_properties")


@pulumi.output_type
class AssetFileEncryptionMetadataResponse(dict):
    """
    The Asset File Storage encryption metadata.
    """
    def __init__(__self__, *,
                 asset_file_id: str,
                 asset_file_name: Optional[str] = None,
                 initialization_vector: Optional[str] = None):
        """
        The Asset File Storage encryption metadata.
        :param str asset_file_id: The Asset File Id.
        :param str asset_file_name: The Asset File name.
        :param str initialization_vector: The Asset File initialization vector.
        """
        pulumi.set(__self__, "asset_file_id", asset_file_id)
        if asset_file_name is not None:
            pulumi.set(__self__, "asset_file_name", asset_file_name)
        if initialization_vector is not None:
            pulumi.set(__self__, "initialization_vector", initialization_vector)

    @property
    @pulumi.getter(name="assetFileId")
    def asset_file_id(self) -> str:
        """
        The Asset File Id.
        """
        return pulumi.get(self, "asset_file_id")

    @property
    @pulumi.getter(name="assetFileName")
    def asset_file_name(self) -> Optional[str]:
        """
        The Asset File name.
        """
        return pulumi.get(self, "asset_file_name")

    @property
    @pulumi.getter(name="initializationVector")
    def initialization_vector(self) -> Optional[str]:
        """
        The Asset File initialization vector.
        """
        return pulumi.get(self, "initialization_vector")


@pulumi.output_type
class AssetStreamingLocatorResponse(dict):
    """
    Properties of the Streaming Locator.
    """
    def __init__(__self__, *,
                 asset_name: str,
                 created: str,
                 default_content_key_policy_name: str,
                 end_time: str,
                 name: str,
                 start_time: str,
                 streaming_locator_id: str,
                 streaming_policy_name: str):
        """
        Properties of the Streaming Locator.
        :param str asset_name: Asset Name.
        :param str created: The creation time of the Streaming Locator.
        :param str default_content_key_policy_name: Name of the default ContentKeyPolicy used by this Streaming Locator.
        :param str end_time: The end time of the Streaming Locator.
        :param str name: Streaming Locator name.
        :param str start_time: The start time of the Streaming Locator.
        :param str streaming_locator_id: StreamingLocatorId of the Streaming Locator.
        :param str streaming_policy_name: Name of the Streaming Policy used by this Streaming Locator.
        """
        pulumi.set(__self__, "asset_name", asset_name)
        pulumi.set(__self__, "created", created)
        pulumi.set(__self__, "default_content_key_policy_name", default_content_key_policy_name)
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "start_time", start_time)
        pulumi.set(__self__, "streaming_locator_id", streaming_locator_id)
        pulumi.set(__self__, "streaming_policy_name", streaming_policy_name)

    @property
    @pulumi.getter(name="assetName")
    def asset_name(self) -> str:
        """
        Asset Name.
        """
        return pulumi.get(self, "asset_name")

    @property
    @pulumi.getter
    def created(self) -> str:
        """
        The creation time of the Streaming Locator.
        """
        return pulumi.get(self, "created")

    @property
    @pulumi.getter(name="defaultContentKeyPolicyName")
    def default_content_key_policy_name(self) -> str:
        """
        Name of the default ContentKeyPolicy used by this Streaming Locator.
        """
        return pulumi.get(self, "default_content_key_policy_name")

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> str:
        """
        The end time of the Streaming Locator.
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Streaming Locator name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        The start time of the Streaming Locator.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter(name="streamingLocatorId")
    def streaming_locator_id(self) -> str:
        """
        StreamingLocatorId of the Streaming Locator.
        """
        return pulumi.get(self, "streaming_locator_id")

    @property
    @pulumi.getter(name="streamingPolicyName")
    def streaming_policy_name(self) -> str:
        """
        Name of the Streaming Policy used by this Streaming Locator.
        """
        return pulumi.get(self, "streaming_policy_name")


@pulumi.output_type
class AudioTrackResponse(dict):
    """
    Represents an audio track in the asset.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bitRate":
            suggest = "bit_rate"
        elif key == "odataType":
            suggest = "odata_type"
        elif key == "dashSettings":
            suggest = "dash_settings"
        elif key == "displayName":
            suggest = "display_name"
        elif key == "fileName":
            suggest = "file_name"
        elif key == "hlsSettings":
            suggest = "hls_settings"
        elif key == "languageCode":
            suggest = "language_code"
        elif key == "mpeg4TrackId":
            suggest = "mpeg4_track_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AudioTrackResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AudioTrackResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AudioTrackResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bit_rate: int,
                 odata_type: str,
                 dash_settings: Optional['outputs.DashSettingsResponse'] = None,
                 display_name: Optional[str] = None,
                 file_name: Optional[str] = None,
                 hls_settings: Optional['outputs.HlsSettingsResponse'] = None,
                 language_code: Optional[str] = None,
                 mpeg4_track_id: Optional[int] = None):
        """
        Represents an audio track in the asset.
        :param int bit_rate: The stream bit rate for the audio track.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.AudioTrack'.
        :param 'DashSettingsResponse' dash_settings: The DASH specific setting for the audio track.
        :param str display_name: The display name of the audio track on a video player. In HLS, this maps to the NAME attribute of EXT-X-MEDIA.
        :param str file_name: The file name to the source file. This file is located in the storage container of the asset.
        :param 'HlsSettingsResponse' hls_settings: The HLS specific setting for the audio track.
        :param str language_code: The RFC5646 language code for the audio track.
        :param int mpeg4_track_id: The MPEG-4 audio track ID for the audio track.
        """
        pulumi.set(__self__, "bit_rate", bit_rate)
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.AudioTrack')
        if dash_settings is not None:
            pulumi.set(__self__, "dash_settings", dash_settings)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if file_name is not None:
            pulumi.set(__self__, "file_name", file_name)
        if hls_settings is not None:
            pulumi.set(__self__, "hls_settings", hls_settings)
        if language_code is not None:
            pulumi.set(__self__, "language_code", language_code)
        if mpeg4_track_id is not None:
            pulumi.set(__self__, "mpeg4_track_id", mpeg4_track_id)

    @property
    @pulumi.getter(name="bitRate")
    def bit_rate(self) -> int:
        """
        The stream bit rate for the audio track.
        """
        return pulumi.get(self, "bit_rate")

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.AudioTrack'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter(name="dashSettings")
    def dash_settings(self) -> Optional['outputs.DashSettingsResponse']:
        """
        The DASH specific setting for the audio track.
        """
        return pulumi.get(self, "dash_settings")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        The display name of the audio track on a video player. In HLS, this maps to the NAME attribute of EXT-X-MEDIA.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="fileName")
    def file_name(self) -> Optional[str]:
        """
        The file name to the source file. This file is located in the storage container of the asset.
        """
        return pulumi.get(self, "file_name")

    @property
    @pulumi.getter(name="hlsSettings")
    def hls_settings(self) -> Optional['outputs.HlsSettingsResponse']:
        """
        The HLS specific setting for the audio track.
        """
        return pulumi.get(self, "hls_settings")

    @property
    @pulumi.getter(name="languageCode")
    def language_code(self) -> Optional[str]:
        """
        The RFC5646 language code for the audio track.
        """
        return pulumi.get(self, "language_code")

    @property
    @pulumi.getter(name="mpeg4TrackId")
    def mpeg4_track_id(self) -> Optional[int]:
        """
        The MPEG-4 audio track ID for the audio track.
        """
        return pulumi.get(self, "mpeg4_track_id")


@pulumi.output_type
class CbcsDrmConfigurationResponse(dict):
    """
    Class to specify DRM configurations of CommonEncryptionCbcs scheme in Streaming Policy
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fairPlay":
            suggest = "fair_play"
        elif key == "playReady":
            suggest = "play_ready"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CbcsDrmConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CbcsDrmConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CbcsDrmConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fair_play: Optional['outputs.StreamingPolicyFairPlayConfigurationResponse'] = None,
                 play_ready: Optional['outputs.StreamingPolicyPlayReadyConfigurationResponse'] = None,
                 widevine: Optional['outputs.StreamingPolicyWidevineConfigurationResponse'] = None):
        """
        Class to specify DRM configurations of CommonEncryptionCbcs scheme in Streaming Policy
        :param 'StreamingPolicyFairPlayConfigurationResponse' fair_play: FairPlay configurations
        :param 'StreamingPolicyPlayReadyConfigurationResponse' play_ready: PlayReady configurations
        :param 'StreamingPolicyWidevineConfigurationResponse' widevine: Widevine configurations
        """
        if fair_play is not None:
            pulumi.set(__self__, "fair_play", fair_play)
        if play_ready is not None:
            pulumi.set(__self__, "play_ready", play_ready)
        if widevine is not None:
            pulumi.set(__self__, "widevine", widevine)

    @property
    @pulumi.getter(name="fairPlay")
    def fair_play(self) -> Optional['outputs.StreamingPolicyFairPlayConfigurationResponse']:
        """
        FairPlay configurations
        """
        return pulumi.get(self, "fair_play")

    @property
    @pulumi.getter(name="playReady")
    def play_ready(self) -> Optional['outputs.StreamingPolicyPlayReadyConfigurationResponse']:
        """
        PlayReady configurations
        """
        return pulumi.get(self, "play_ready")

    @property
    @pulumi.getter
    def widevine(self) -> Optional['outputs.StreamingPolicyWidevineConfigurationResponse']:
        """
        Widevine configurations
        """
        return pulumi.get(self, "widevine")


@pulumi.output_type
class CencDrmConfigurationResponse(dict):
    """
    Class to specify DRM configurations of CommonEncryptionCenc scheme in Streaming Policy
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "playReady":
            suggest = "play_ready"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CencDrmConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CencDrmConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CencDrmConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 play_ready: Optional['outputs.StreamingPolicyPlayReadyConfigurationResponse'] = None,
                 widevine: Optional['outputs.StreamingPolicyWidevineConfigurationResponse'] = None):
        """
        Class to specify DRM configurations of CommonEncryptionCenc scheme in Streaming Policy
        :param 'StreamingPolicyPlayReadyConfigurationResponse' play_ready: PlayReady configurations
        :param 'StreamingPolicyWidevineConfigurationResponse' widevine: Widevine configurations
        """
        if play_ready is not None:
            pulumi.set(__self__, "play_ready", play_ready)
        if widevine is not None:
            pulumi.set(__self__, "widevine", widevine)

    @property
    @pulumi.getter(name="playReady")
    def play_ready(self) -> Optional['outputs.StreamingPolicyPlayReadyConfigurationResponse']:
        """
        PlayReady configurations
        """
        return pulumi.get(self, "play_ready")

    @property
    @pulumi.getter
    def widevine(self) -> Optional['outputs.StreamingPolicyWidevineConfigurationResponse']:
        """
        Widevine configurations
        """
        return pulumi.get(self, "widevine")


@pulumi.output_type
class ClearKeyEncryptionConfigurationResponse(dict):
    """
    Class to specify ClearKey configuration of common encryption schemes in Streaming Policy
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customKeysAcquisitionUrlTemplate":
            suggest = "custom_keys_acquisition_url_template"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClearKeyEncryptionConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClearKeyEncryptionConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClearKeyEncryptionConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 custom_keys_acquisition_url_template: Optional[str] = None):
        """
        Class to specify ClearKey configuration of common encryption schemes in Streaming Policy
        :param str custom_keys_acquisition_url_template: Template for the URL of the custom service delivering content keys to end user players. Not required when using Azure Media Services for issuing licenses. The template supports replaceable tokens that the service will update at runtime with the value specific to the request.  The currently supported token value is {AlternativeMediaId}, which is replaced with the value of StreamingLocatorId.AlternativeMediaId.
        """
        if custom_keys_acquisition_url_template is not None:
            pulumi.set(__self__, "custom_keys_acquisition_url_template", custom_keys_acquisition_url_template)

    @property
    @pulumi.getter(name="customKeysAcquisitionUrlTemplate")
    def custom_keys_acquisition_url_template(self) -> Optional[str]:
        """
        Template for the URL of the custom service delivering content keys to end user players. Not required when using Azure Media Services for issuing licenses. The template supports replaceable tokens that the service will update at runtime with the value specific to the request.  The currently supported token value is {AlternativeMediaId}, which is replaced with the value of StreamingLocatorId.AlternativeMediaId.
        """
        return pulumi.get(self, "custom_keys_acquisition_url_template")


@pulumi.output_type
class CommonEncryptionCbcsResponse(dict):
    """
    Class for CommonEncryptionCbcs encryption scheme
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clearKeyEncryptionConfiguration":
            suggest = "clear_key_encryption_configuration"
        elif key == "clearTracks":
            suggest = "clear_tracks"
        elif key == "contentKeys":
            suggest = "content_keys"
        elif key == "enabledProtocols":
            suggest = "enabled_protocols"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CommonEncryptionCbcsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CommonEncryptionCbcsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CommonEncryptionCbcsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 clear_key_encryption_configuration: Optional['outputs.ClearKeyEncryptionConfigurationResponse'] = None,
                 clear_tracks: Optional[Sequence['outputs.TrackSelectionResponse']] = None,
                 content_keys: Optional['outputs.StreamingPolicyContentKeysResponse'] = None,
                 drm: Optional['outputs.CbcsDrmConfigurationResponse'] = None,
                 enabled_protocols: Optional['outputs.EnabledProtocolsResponse'] = None):
        """
        Class for CommonEncryptionCbcs encryption scheme
        :param 'ClearKeyEncryptionConfigurationResponse' clear_key_encryption_configuration: Optional configuration supporting ClearKey in CommonEncryptionCbcs encryption scheme.
        :param Sequence['TrackSelectionResponse'] clear_tracks: Representing which tracks should not be encrypted
        :param 'StreamingPolicyContentKeysResponse' content_keys: Representing default content key for each encryption scheme and separate content keys for specific tracks
        :param 'CbcsDrmConfigurationResponse' drm: Configuration of DRMs for current encryption scheme
        :param 'EnabledProtocolsResponse' enabled_protocols: Representing supported protocols
        """
        if clear_key_encryption_configuration is not None:
            pulumi.set(__self__, "clear_key_encryption_configuration", clear_key_encryption_configuration)
        if clear_tracks is not None:
            pulumi.set(__self__, "clear_tracks", clear_tracks)
        if content_keys is not None:
            pulumi.set(__self__, "content_keys", content_keys)
        if drm is not None:
            pulumi.set(__self__, "drm", drm)
        if enabled_protocols is not None:
            pulumi.set(__self__, "enabled_protocols", enabled_protocols)

    @property
    @pulumi.getter(name="clearKeyEncryptionConfiguration")
    def clear_key_encryption_configuration(self) -> Optional['outputs.ClearKeyEncryptionConfigurationResponse']:
        """
        Optional configuration supporting ClearKey in CommonEncryptionCbcs encryption scheme.
        """
        return pulumi.get(self, "clear_key_encryption_configuration")

    @property
    @pulumi.getter(name="clearTracks")
    def clear_tracks(self) -> Optional[Sequence['outputs.TrackSelectionResponse']]:
        """
        Representing which tracks should not be encrypted
        """
        return pulumi.get(self, "clear_tracks")

    @property
    @pulumi.getter(name="contentKeys")
    def content_keys(self) -> Optional['outputs.StreamingPolicyContentKeysResponse']:
        """
        Representing default content key for each encryption scheme and separate content keys for specific tracks
        """
        return pulumi.get(self, "content_keys")

    @property
    @pulumi.getter
    def drm(self) -> Optional['outputs.CbcsDrmConfigurationResponse']:
        """
        Configuration of DRMs for current encryption scheme
        """
        return pulumi.get(self, "drm")

    @property
    @pulumi.getter(name="enabledProtocols")
    def enabled_protocols(self) -> Optional['outputs.EnabledProtocolsResponse']:
        """
        Representing supported protocols
        """
        return pulumi.get(self, "enabled_protocols")


@pulumi.output_type
class CommonEncryptionCencResponse(dict):
    """
    Class for envelope encryption scheme
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clearKeyEncryptionConfiguration":
            suggest = "clear_key_encryption_configuration"
        elif key == "clearTracks":
            suggest = "clear_tracks"
        elif key == "contentKeys":
            suggest = "content_keys"
        elif key == "enabledProtocols":
            suggest = "enabled_protocols"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CommonEncryptionCencResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CommonEncryptionCencResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CommonEncryptionCencResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 clear_key_encryption_configuration: Optional['outputs.ClearKeyEncryptionConfigurationResponse'] = None,
                 clear_tracks: Optional[Sequence['outputs.TrackSelectionResponse']] = None,
                 content_keys: Optional['outputs.StreamingPolicyContentKeysResponse'] = None,
                 drm: Optional['outputs.CencDrmConfigurationResponse'] = None,
                 enabled_protocols: Optional['outputs.EnabledProtocolsResponse'] = None):
        """
        Class for envelope encryption scheme
        :param 'ClearKeyEncryptionConfigurationResponse' clear_key_encryption_configuration: Optional configuration supporting ClearKey in CommonEncryptionCenc encryption scheme.
        :param Sequence['TrackSelectionResponse'] clear_tracks: Representing which tracks should not be encrypted
        :param 'StreamingPolicyContentKeysResponse' content_keys: Representing default content key for each encryption scheme and separate content keys for specific tracks
        :param 'CencDrmConfigurationResponse' drm: Configuration of DRMs for CommonEncryptionCenc encryption scheme
        :param 'EnabledProtocolsResponse' enabled_protocols: Representing supported protocols
        """
        if clear_key_encryption_configuration is not None:
            pulumi.set(__self__, "clear_key_encryption_configuration", clear_key_encryption_configuration)
        if clear_tracks is not None:
            pulumi.set(__self__, "clear_tracks", clear_tracks)
        if content_keys is not None:
            pulumi.set(__self__, "content_keys", content_keys)
        if drm is not None:
            pulumi.set(__self__, "drm", drm)
        if enabled_protocols is not None:
            pulumi.set(__self__, "enabled_protocols", enabled_protocols)

    @property
    @pulumi.getter(name="clearKeyEncryptionConfiguration")
    def clear_key_encryption_configuration(self) -> Optional['outputs.ClearKeyEncryptionConfigurationResponse']:
        """
        Optional configuration supporting ClearKey in CommonEncryptionCenc encryption scheme.
        """
        return pulumi.get(self, "clear_key_encryption_configuration")

    @property
    @pulumi.getter(name="clearTracks")
    def clear_tracks(self) -> Optional[Sequence['outputs.TrackSelectionResponse']]:
        """
        Representing which tracks should not be encrypted
        """
        return pulumi.get(self, "clear_tracks")

    @property
    @pulumi.getter(name="contentKeys")
    def content_keys(self) -> Optional['outputs.StreamingPolicyContentKeysResponse']:
        """
        Representing default content key for each encryption scheme and separate content keys for specific tracks
        """
        return pulumi.get(self, "content_keys")

    @property
    @pulumi.getter
    def drm(self) -> Optional['outputs.CencDrmConfigurationResponse']:
        """
        Configuration of DRMs for CommonEncryptionCenc encryption scheme
        """
        return pulumi.get(self, "drm")

    @property
    @pulumi.getter(name="enabledProtocols")
    def enabled_protocols(self) -> Optional['outputs.EnabledProtocolsResponse']:
        """
        Representing supported protocols
        """
        return pulumi.get(self, "enabled_protocols")


@pulumi.output_type
class ContentKeyPolicyClearKeyConfigurationResponse(dict):
    """
    Represents a configuration for non-DRM keys.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContentKeyPolicyClearKeyConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContentKeyPolicyClearKeyConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContentKeyPolicyClearKeyConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str):
        """
        Represents a configuration for non-DRM keys.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.ContentKeyPolicyClearKeyConfiguration'.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.ContentKeyPolicyClearKeyConfiguration')

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.ContentKeyPolicyClearKeyConfiguration'.
        """
        return pulumi.get(self, "odata_type")


@pulumi.output_type
class ContentKeyPolicyFairPlayConfigurationResponse(dict):
    """
    Specifies a configuration for FairPlay licenses.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fairPlayPfx":
            suggest = "fair_play_pfx"
        elif key == "fairPlayPfxPassword":
            suggest = "fair_play_pfx_password"
        elif key == "odataType":
            suggest = "odata_type"
        elif key == "rentalAndLeaseKeyType":
            suggest = "rental_and_lease_key_type"
        elif key == "rentalDuration":
            suggest = "rental_duration"
        elif key == "offlineRentalConfiguration":
            suggest = "offline_rental_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContentKeyPolicyFairPlayConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContentKeyPolicyFairPlayConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContentKeyPolicyFairPlayConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ask: str,
                 fair_play_pfx: str,
                 fair_play_pfx_password: str,
                 odata_type: str,
                 rental_and_lease_key_type: str,
                 rental_duration: float,
                 offline_rental_configuration: Optional['outputs.ContentKeyPolicyFairPlayOfflineRentalConfigurationResponse'] = None):
        """
        Specifies a configuration for FairPlay licenses.
        :param str ask: The key that must be used as FairPlay Application Secret key. This needs to be base64 encoded.
        :param str fair_play_pfx: The Base64 representation of FairPlay certificate in PKCS 12 (pfx) format (including private key).
        :param str fair_play_pfx_password: The password encrypting FairPlay certificate in PKCS 12 (pfx) format.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.ContentKeyPolicyFairPlayConfiguration'.
        :param str rental_and_lease_key_type: The rental and lease key type.
        :param float rental_duration: The rental duration. Must be greater than or equal to 0.
        :param 'ContentKeyPolicyFairPlayOfflineRentalConfigurationResponse' offline_rental_configuration: Offline rental policy
        """
        pulumi.set(__self__, "ask", ask)
        pulumi.set(__self__, "fair_play_pfx", fair_play_pfx)
        pulumi.set(__self__, "fair_play_pfx_password", fair_play_pfx_password)
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.ContentKeyPolicyFairPlayConfiguration')
        pulumi.set(__self__, "rental_and_lease_key_type", rental_and_lease_key_type)
        pulumi.set(__self__, "rental_duration", rental_duration)
        if offline_rental_configuration is not None:
            pulumi.set(__self__, "offline_rental_configuration", offline_rental_configuration)

    @property
    @pulumi.getter
    def ask(self) -> str:
        """
        The key that must be used as FairPlay Application Secret key. This needs to be base64 encoded.
        """
        return pulumi.get(self, "ask")

    @property
    @pulumi.getter(name="fairPlayPfx")
    def fair_play_pfx(self) -> str:
        """
        The Base64 representation of FairPlay certificate in PKCS 12 (pfx) format (including private key).
        """
        return pulumi.get(self, "fair_play_pfx")

    @property
    @pulumi.getter(name="fairPlayPfxPassword")
    def fair_play_pfx_password(self) -> str:
        """
        The password encrypting FairPlay certificate in PKCS 12 (pfx) format.
        """
        return pulumi.get(self, "fair_play_pfx_password")

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.ContentKeyPolicyFairPlayConfiguration'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter(name="rentalAndLeaseKeyType")
    def rental_and_lease_key_type(self) -> str:
        """
        The rental and lease key type.
        """
        return pulumi.get(self, "rental_and_lease_key_type")

    @property
    @pulumi.getter(name="rentalDuration")
    def rental_duration(self) -> float:
        """
        The rental duration. Must be greater than or equal to 0.
        """
        return pulumi.get(self, "rental_duration")

    @property
    @pulumi.getter(name="offlineRentalConfiguration")
    def offline_rental_configuration(self) -> Optional['outputs.ContentKeyPolicyFairPlayOfflineRentalConfigurationResponse']:
        """
        Offline rental policy
        """
        return pulumi.get(self, "offline_rental_configuration")


@pulumi.output_type
class ContentKeyPolicyFairPlayOfflineRentalConfigurationResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "playbackDurationSeconds":
            suggest = "playback_duration_seconds"
        elif key == "storageDurationSeconds":
            suggest = "storage_duration_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContentKeyPolicyFairPlayOfflineRentalConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContentKeyPolicyFairPlayOfflineRentalConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContentKeyPolicyFairPlayOfflineRentalConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 playback_duration_seconds: float,
                 storage_duration_seconds: float):
        """
        :param float playback_duration_seconds: Playback duration
        :param float storage_duration_seconds: Storage duration
        """
        pulumi.set(__self__, "playback_duration_seconds", playback_duration_seconds)
        pulumi.set(__self__, "storage_duration_seconds", storage_duration_seconds)

    @property
    @pulumi.getter(name="playbackDurationSeconds")
    def playback_duration_seconds(self) -> float:
        """
        Playback duration
        """
        return pulumi.get(self, "playback_duration_seconds")

    @property
    @pulumi.getter(name="storageDurationSeconds")
    def storage_duration_seconds(self) -> float:
        """
        Storage duration
        """
        return pulumi.get(self, "storage_duration_seconds")


@pulumi.output_type
class ContentKeyPolicyOpenRestrictionResponse(dict):
    """
    Represents an open restriction. License or key will be delivered on every request.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContentKeyPolicyOpenRestrictionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContentKeyPolicyOpenRestrictionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContentKeyPolicyOpenRestrictionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str):
        """
        Represents an open restriction. License or key will be delivered on every request.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.ContentKeyPolicyOpenRestriction'.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.ContentKeyPolicyOpenRestriction')

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.ContentKeyPolicyOpenRestriction'.
        """
        return pulumi.get(self, "odata_type")


@pulumi.output_type
class ContentKeyPolicyOptionResponse(dict):
    """
    Represents a policy option.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "policyOptionId":
            suggest = "policy_option_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContentKeyPolicyOptionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContentKeyPolicyOptionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContentKeyPolicyOptionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 configuration: Any,
                 policy_option_id: str,
                 restriction: Any,
                 name: Optional[str] = None):
        """
        Represents a policy option.
        :param Union['ContentKeyPolicyClearKeyConfigurationResponse', 'ContentKeyPolicyFairPlayConfigurationResponse', 'ContentKeyPolicyPlayReadyConfigurationResponse', 'ContentKeyPolicyUnknownConfigurationResponse', 'ContentKeyPolicyWidevineConfigurationResponse'] configuration: The key delivery configuration.
        :param str policy_option_id: The legacy Policy Option ID.
        :param Union['ContentKeyPolicyOpenRestrictionResponse', 'ContentKeyPolicyTokenRestrictionResponse', 'ContentKeyPolicyUnknownRestrictionResponse'] restriction: The requirements that must be met to deliver keys with this configuration
        :param str name: The Policy Option description.
        """
        pulumi.set(__self__, "configuration", configuration)
        pulumi.set(__self__, "policy_option_id", policy_option_id)
        pulumi.set(__self__, "restriction", restriction)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def configuration(self) -> Any:
        """
        The key delivery configuration.
        """
        return pulumi.get(self, "configuration")

    @property
    @pulumi.getter(name="policyOptionId")
    def policy_option_id(self) -> str:
        """
        The legacy Policy Option ID.
        """
        return pulumi.get(self, "policy_option_id")

    @property
    @pulumi.getter
    def restriction(self) -> Any:
        """
        The requirements that must be met to deliver keys with this configuration
        """
        return pulumi.get(self, "restriction")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The Policy Option description.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class ContentKeyPolicyPlayReadyConfigurationResponse(dict):
    """
    Specifies a configuration for PlayReady licenses.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "responseCustomData":
            suggest = "response_custom_data"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContentKeyPolicyPlayReadyConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContentKeyPolicyPlayReadyConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContentKeyPolicyPlayReadyConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 licenses: Sequence['outputs.ContentKeyPolicyPlayReadyLicenseResponse'],
                 odata_type: str,
                 response_custom_data: Optional[str] = None):
        """
        Specifies a configuration for PlayReady licenses.
        :param Sequence['ContentKeyPolicyPlayReadyLicenseResponse'] licenses: The PlayReady licenses.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.ContentKeyPolicyPlayReadyConfiguration'.
        :param str response_custom_data: The custom response data.
        """
        pulumi.set(__self__, "licenses", licenses)
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.ContentKeyPolicyPlayReadyConfiguration')
        if response_custom_data is not None:
            pulumi.set(__self__, "response_custom_data", response_custom_data)

    @property
    @pulumi.getter
    def licenses(self) -> Sequence['outputs.ContentKeyPolicyPlayReadyLicenseResponse']:
        """
        The PlayReady licenses.
        """
        return pulumi.get(self, "licenses")

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.ContentKeyPolicyPlayReadyConfiguration'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter(name="responseCustomData")
    def response_custom_data(self) -> Optional[str]:
        """
        The custom response data.
        """
        return pulumi.get(self, "response_custom_data")


@pulumi.output_type
class ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeaderResponse(dict):
    """
    Specifies that the content key ID is in the PlayReady header.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeaderResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeaderResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeaderResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str):
        """
        Specifies that the content key ID is in the PlayReady header.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeader'.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeader')

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeader'.
        """
        return pulumi.get(self, "odata_type")


@pulumi.output_type
class ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifierResponse(dict):
    """
    Specifies that the content key ID is specified in the PlayReady configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyId":
            suggest = "key_id"
        elif key == "odataType":
            suggest = "odata_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifierResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifierResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifierResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_id: str,
                 odata_type: str):
        """
        Specifies that the content key ID is specified in the PlayReady configuration.
        :param str key_id: The content key ID.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifier'.
        """
        pulumi.set(__self__, "key_id", key_id)
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifier')

    @property
    @pulumi.getter(name="keyId")
    def key_id(self) -> str:
        """
        The content key ID.
        """
        return pulumi.get(self, "key_id")

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifier'.
        """
        return pulumi.get(self, "odata_type")


@pulumi.output_type
class ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestrictionResponse(dict):
    """
    Configures the Explicit Analog Television Output Restriction control bits. For further details see the PlayReady Compliance Rules.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bestEffort":
            suggest = "best_effort"
        elif key == "configurationData":
            suggest = "configuration_data"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestrictionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestrictionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestrictionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 best_effort: bool,
                 configuration_data: int):
        """
        Configures the Explicit Analog Television Output Restriction control bits. For further details see the PlayReady Compliance Rules.
        :param bool best_effort: Indicates whether this restriction is enforced on a Best Effort basis.
        :param int configuration_data: Configures the restriction control bits. Must be between 0 and 3 inclusive.
        """
        pulumi.set(__self__, "best_effort", best_effort)
        pulumi.set(__self__, "configuration_data", configuration_data)

    @property
    @pulumi.getter(name="bestEffort")
    def best_effort(self) -> bool:
        """
        Indicates whether this restriction is enforced on a Best Effort basis.
        """
        return pulumi.get(self, "best_effort")

    @property
    @pulumi.getter(name="configurationData")
    def configuration_data(self) -> int:
        """
        Configures the restriction control bits. Must be between 0 and 3 inclusive.
        """
        return pulumi.get(self, "configuration_data")


@pulumi.output_type
class ContentKeyPolicyPlayReadyLicenseResponse(dict):
    """
    The PlayReady license
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowTestDevices":
            suggest = "allow_test_devices"
        elif key == "contentKeyLocation":
            suggest = "content_key_location"
        elif key == "contentType":
            suggest = "content_type"
        elif key == "licenseType":
            suggest = "license_type"
        elif key == "beginDate":
            suggest = "begin_date"
        elif key == "expirationDate":
            suggest = "expiration_date"
        elif key == "gracePeriod":
            suggest = "grace_period"
        elif key == "playRight":
            suggest = "play_right"
        elif key == "relativeBeginDate":
            suggest = "relative_begin_date"
        elif key == "relativeExpirationDate":
            suggest = "relative_expiration_date"
        elif key == "securityLevel":
            suggest = "security_level"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContentKeyPolicyPlayReadyLicenseResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContentKeyPolicyPlayReadyLicenseResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContentKeyPolicyPlayReadyLicenseResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_test_devices: bool,
                 content_key_location: Any,
                 content_type: str,
                 license_type: str,
                 begin_date: Optional[str] = None,
                 expiration_date: Optional[str] = None,
                 grace_period: Optional[str] = None,
                 play_right: Optional['outputs.ContentKeyPolicyPlayReadyPlayRightResponse'] = None,
                 relative_begin_date: Optional[str] = None,
                 relative_expiration_date: Optional[str] = None,
                 security_level: Optional[str] = None):
        """
        The PlayReady license
        :param bool allow_test_devices: A flag indicating whether test devices can use the license.
        :param Union['ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeaderResponse', 'ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifierResponse'] content_key_location: The content key location.
        :param str content_type: The PlayReady content type.
        :param str license_type: The license type.
        :param str begin_date: The begin date of license
        :param str expiration_date: The expiration date of license.
        :param str grace_period: The grace period of license.
        :param 'ContentKeyPolicyPlayReadyPlayRightResponse' play_right: The license PlayRight
        :param str relative_begin_date: The relative begin date of license.
        :param str relative_expiration_date: The relative expiration date of license.
        :param str security_level: The security level.
        """
        pulumi.set(__self__, "allow_test_devices", allow_test_devices)
        pulumi.set(__self__, "content_key_location", content_key_location)
        pulumi.set(__self__, "content_type", content_type)
        pulumi.set(__self__, "license_type", license_type)
        if begin_date is not None:
            pulumi.set(__self__, "begin_date", begin_date)
        if expiration_date is not None:
            pulumi.set(__self__, "expiration_date", expiration_date)
        if grace_period is not None:
            pulumi.set(__self__, "grace_period", grace_period)
        if play_right is not None:
            pulumi.set(__self__, "play_right", play_right)
        if relative_begin_date is not None:
            pulumi.set(__self__, "relative_begin_date", relative_begin_date)
        if relative_expiration_date is not None:
            pulumi.set(__self__, "relative_expiration_date", relative_expiration_date)
        if security_level is not None:
            pulumi.set(__self__, "security_level", security_level)

    @property
    @pulumi.getter(name="allowTestDevices")
    def allow_test_devices(self) -> bool:
        """
        A flag indicating whether test devices can use the license.
        """
        return pulumi.get(self, "allow_test_devices")

    @property
    @pulumi.getter(name="contentKeyLocation")
    def content_key_location(self) -> Any:
        """
        The content key location.
        """
        return pulumi.get(self, "content_key_location")

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> str:
        """
        The PlayReady content type.
        """
        return pulumi.get(self, "content_type")

    @property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> str:
        """
        The license type.
        """
        return pulumi.get(self, "license_type")

    @property
    @pulumi.getter(name="beginDate")
    def begin_date(self) -> Optional[str]:
        """
        The begin date of license
        """
        return pulumi.get(self, "begin_date")

    @property
    @pulumi.getter(name="expirationDate")
    def expiration_date(self) -> Optional[str]:
        """
        The expiration date of license.
        """
        return pulumi.get(self, "expiration_date")

    @property
    @pulumi.getter(name="gracePeriod")
    def grace_period(self) -> Optional[str]:
        """
        The grace period of license.
        """
        return pulumi.get(self, "grace_period")

    @property
    @pulumi.getter(name="playRight")
    def play_right(self) -> Optional['outputs.ContentKeyPolicyPlayReadyPlayRightResponse']:
        """
        The license PlayRight
        """
        return pulumi.get(self, "play_right")

    @property
    @pulumi.getter(name="relativeBeginDate")
    def relative_begin_date(self) -> Optional[str]:
        """
        The relative begin date of license.
        """
        return pulumi.get(self, "relative_begin_date")

    @property
    @pulumi.getter(name="relativeExpirationDate")
    def relative_expiration_date(self) -> Optional[str]:
        """
        The relative expiration date of license.
        """
        return pulumi.get(self, "relative_expiration_date")

    @property
    @pulumi.getter(name="securityLevel")
    def security_level(self) -> Optional[str]:
        """
        The security level.
        """
        return pulumi.get(self, "security_level")


@pulumi.output_type
class ContentKeyPolicyPlayReadyPlayRightResponse(dict):
    """
    Configures the Play Right in the PlayReady license.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowPassingVideoContentToUnknownOutput":
            suggest = "allow_passing_video_content_to_unknown_output"
        elif key == "digitalVideoOnlyContentRestriction":
            suggest = "digital_video_only_content_restriction"
        elif key == "imageConstraintForAnalogComponentVideoRestriction":
            suggest = "image_constraint_for_analog_component_video_restriction"
        elif key == "imageConstraintForAnalogComputerMonitorRestriction":
            suggest = "image_constraint_for_analog_computer_monitor_restriction"
        elif key == "agcAndColorStripeRestriction":
            suggest = "agc_and_color_stripe_restriction"
        elif key == "analogVideoOpl":
            suggest = "analog_video_opl"
        elif key == "compressedDigitalAudioOpl":
            suggest = "compressed_digital_audio_opl"
        elif key == "compressedDigitalVideoOpl":
            suggest = "compressed_digital_video_opl"
        elif key == "explicitAnalogTelevisionOutputRestriction":
            suggest = "explicit_analog_television_output_restriction"
        elif key == "firstPlayExpiration":
            suggest = "first_play_expiration"
        elif key == "scmsRestriction":
            suggest = "scms_restriction"
        elif key == "uncompressedDigitalAudioOpl":
            suggest = "uncompressed_digital_audio_opl"
        elif key == "uncompressedDigitalVideoOpl":
            suggest = "uncompressed_digital_video_opl"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContentKeyPolicyPlayReadyPlayRightResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContentKeyPolicyPlayReadyPlayRightResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContentKeyPolicyPlayReadyPlayRightResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_passing_video_content_to_unknown_output: str,
                 digital_video_only_content_restriction: bool,
                 image_constraint_for_analog_component_video_restriction: bool,
                 image_constraint_for_analog_computer_monitor_restriction: bool,
                 agc_and_color_stripe_restriction: Optional[int] = None,
                 analog_video_opl: Optional[int] = None,
                 compressed_digital_audio_opl: Optional[int] = None,
                 compressed_digital_video_opl: Optional[int] = None,
                 explicit_analog_television_output_restriction: Optional['outputs.ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestrictionResponse'] = None,
                 first_play_expiration: Optional[str] = None,
                 scms_restriction: Optional[int] = None,
                 uncompressed_digital_audio_opl: Optional[int] = None,
                 uncompressed_digital_video_opl: Optional[int] = None):
        """
        Configures the Play Right in the PlayReady license.
        :param str allow_passing_video_content_to_unknown_output: Configures Unknown output handling settings of the license.
        :param bool digital_video_only_content_restriction: Enables the Image Constraint For Analog Component Video Restriction in the license.
        :param bool image_constraint_for_analog_component_video_restriction: Enables the Image Constraint For Analog Component Video Restriction in the license.
        :param bool image_constraint_for_analog_computer_monitor_restriction: Enables the Image Constraint For Analog Component Video Restriction in the license.
        :param int agc_and_color_stripe_restriction: Configures Automatic Gain Control (AGC) and Color Stripe in the license. Must be between 0 and 3 inclusive.
        :param int analog_video_opl: Specifies the output protection level for compressed digital audio.
        :param int compressed_digital_audio_opl: Specifies the output protection level for compressed digital audio.
        :param int compressed_digital_video_opl: Specifies the output protection level for compressed digital video.
        :param 'ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestrictionResponse' explicit_analog_television_output_restriction: Configures the Explicit Analog Television Output Restriction in the license. Configuration data must be between 0 and 3 inclusive.
        :param str first_play_expiration: The amount of time that the license is valid after the license is first used to play content.
        :param int scms_restriction: Configures the Serial Copy Management System (SCMS) in the license. Must be between 0 and 3 inclusive.
        :param int uncompressed_digital_audio_opl: Specifies the output protection level for uncompressed digital audio.
        :param int uncompressed_digital_video_opl: Specifies the output protection level for uncompressed digital video.
        """
        pulumi.set(__self__, "allow_passing_video_content_to_unknown_output", allow_passing_video_content_to_unknown_output)
        pulumi.set(__self__, "digital_video_only_content_restriction", digital_video_only_content_restriction)
        pulumi.set(__self__, "image_constraint_for_analog_component_video_restriction", image_constraint_for_analog_component_video_restriction)
        pulumi.set(__self__, "image_constraint_for_analog_computer_monitor_restriction", image_constraint_for_analog_computer_monitor_restriction)
        if agc_and_color_stripe_restriction is not None:
            pulumi.set(__self__, "agc_and_color_stripe_restriction", agc_and_color_stripe_restriction)
        if analog_video_opl is not None:
            pulumi.set(__self__, "analog_video_opl", analog_video_opl)
        if compressed_digital_audio_opl is not None:
            pulumi.set(__self__, "compressed_digital_audio_opl", compressed_digital_audio_opl)
        if compressed_digital_video_opl is not None:
            pulumi.set(__self__, "compressed_digital_video_opl", compressed_digital_video_opl)
        if explicit_analog_television_output_restriction is not None:
            pulumi.set(__self__, "explicit_analog_television_output_restriction", explicit_analog_television_output_restriction)
        if first_play_expiration is not None:
            pulumi.set(__self__, "first_play_expiration", first_play_expiration)
        if scms_restriction is not None:
            pulumi.set(__self__, "scms_restriction", scms_restriction)
        if uncompressed_digital_audio_opl is not None:
            pulumi.set(__self__, "uncompressed_digital_audio_opl", uncompressed_digital_audio_opl)
        if uncompressed_digital_video_opl is not None:
            pulumi.set(__self__, "uncompressed_digital_video_opl", uncompressed_digital_video_opl)

    @property
    @pulumi.getter(name="allowPassingVideoContentToUnknownOutput")
    def allow_passing_video_content_to_unknown_output(self) -> str:
        """
        Configures Unknown output handling settings of the license.
        """
        return pulumi.get(self, "allow_passing_video_content_to_unknown_output")

    @property
    @pulumi.getter(name="digitalVideoOnlyContentRestriction")
    def digital_video_only_content_restriction(self) -> bool:
        """
        Enables the Image Constraint For Analog Component Video Restriction in the license.
        """
        return pulumi.get(self, "digital_video_only_content_restriction")

    @property
    @pulumi.getter(name="imageConstraintForAnalogComponentVideoRestriction")
    def image_constraint_for_analog_component_video_restriction(self) -> bool:
        """
        Enables the Image Constraint For Analog Component Video Restriction in the license.
        """
        return pulumi.get(self, "image_constraint_for_analog_component_video_restriction")

    @property
    @pulumi.getter(name="imageConstraintForAnalogComputerMonitorRestriction")
    def image_constraint_for_analog_computer_monitor_restriction(self) -> bool:
        """
        Enables the Image Constraint For Analog Component Video Restriction in the license.
        """
        return pulumi.get(self, "image_constraint_for_analog_computer_monitor_restriction")

    @property
    @pulumi.getter(name="agcAndColorStripeRestriction")
    def agc_and_color_stripe_restriction(self) -> Optional[int]:
        """
        Configures Automatic Gain Control (AGC) and Color Stripe in the license. Must be between 0 and 3 inclusive.
        """
        return pulumi.get(self, "agc_and_color_stripe_restriction")

    @property
    @pulumi.getter(name="analogVideoOpl")
    def analog_video_opl(self) -> Optional[int]:
        """
        Specifies the output protection level for compressed digital audio.
        """
        return pulumi.get(self, "analog_video_opl")

    @property
    @pulumi.getter(name="compressedDigitalAudioOpl")
    def compressed_digital_audio_opl(self) -> Optional[int]:
        """
        Specifies the output protection level for compressed digital audio.
        """
        return pulumi.get(self, "compressed_digital_audio_opl")

    @property
    @pulumi.getter(name="compressedDigitalVideoOpl")
    def compressed_digital_video_opl(self) -> Optional[int]:
        """
        Specifies the output protection level for compressed digital video.
        """
        return pulumi.get(self, "compressed_digital_video_opl")

    @property
    @pulumi.getter(name="explicitAnalogTelevisionOutputRestriction")
    def explicit_analog_television_output_restriction(self) -> Optional['outputs.ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestrictionResponse']:
        """
        Configures the Explicit Analog Television Output Restriction in the license. Configuration data must be between 0 and 3 inclusive.
        """
        return pulumi.get(self, "explicit_analog_television_output_restriction")

    @property
    @pulumi.getter(name="firstPlayExpiration")
    def first_play_expiration(self) -> Optional[str]:
        """
        The amount of time that the license is valid after the license is first used to play content.
        """
        return pulumi.get(self, "first_play_expiration")

    @property
    @pulumi.getter(name="scmsRestriction")
    def scms_restriction(self) -> Optional[int]:
        """
        Configures the Serial Copy Management System (SCMS) in the license. Must be between 0 and 3 inclusive.
        """
        return pulumi.get(self, "scms_restriction")

    @property
    @pulumi.getter(name="uncompressedDigitalAudioOpl")
    def uncompressed_digital_audio_opl(self) -> Optional[int]:
        """
        Specifies the output protection level for uncompressed digital audio.
        """
        return pulumi.get(self, "uncompressed_digital_audio_opl")

    @property
    @pulumi.getter(name="uncompressedDigitalVideoOpl")
    def uncompressed_digital_video_opl(self) -> Optional[int]:
        """
        Specifies the output protection level for uncompressed digital video.
        """
        return pulumi.get(self, "uncompressed_digital_video_opl")


@pulumi.output_type
class ContentKeyPolicyRsaTokenKeyResponse(dict):
    """
    Specifies a RSA key for token validation
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContentKeyPolicyRsaTokenKeyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContentKeyPolicyRsaTokenKeyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContentKeyPolicyRsaTokenKeyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 exponent: str,
                 modulus: str,
                 odata_type: str):
        """
        Specifies a RSA key for token validation
        :param str exponent: The RSA Parameter exponent
        :param str modulus: The RSA Parameter modulus
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.ContentKeyPolicyRsaTokenKey'.
        """
        pulumi.set(__self__, "exponent", exponent)
        pulumi.set(__self__, "modulus", modulus)
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.ContentKeyPolicyRsaTokenKey')

    @property
    @pulumi.getter
    def exponent(self) -> str:
        """
        The RSA Parameter exponent
        """
        return pulumi.get(self, "exponent")

    @property
    @pulumi.getter
    def modulus(self) -> str:
        """
        The RSA Parameter modulus
        """
        return pulumi.get(self, "modulus")

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.ContentKeyPolicyRsaTokenKey'.
        """
        return pulumi.get(self, "odata_type")


@pulumi.output_type
class ContentKeyPolicySymmetricTokenKeyResponse(dict):
    """
    Specifies a symmetric key for token validation.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyValue":
            suggest = "key_value"
        elif key == "odataType":
            suggest = "odata_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContentKeyPolicySymmetricTokenKeyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContentKeyPolicySymmetricTokenKeyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContentKeyPolicySymmetricTokenKeyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_value: str,
                 odata_type: str):
        """
        Specifies a symmetric key for token validation.
        :param str key_value: The key value of the key
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.ContentKeyPolicySymmetricTokenKey'.
        """
        pulumi.set(__self__, "key_value", key_value)
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.ContentKeyPolicySymmetricTokenKey')

    @property
    @pulumi.getter(name="keyValue")
    def key_value(self) -> str:
        """
        The key value of the key
        """
        return pulumi.get(self, "key_value")

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.ContentKeyPolicySymmetricTokenKey'.
        """
        return pulumi.get(self, "odata_type")


@pulumi.output_type
class ContentKeyPolicyTokenClaimResponse(dict):
    """
    Represents a token claim.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "claimType":
            suggest = "claim_type"
        elif key == "claimValue":
            suggest = "claim_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContentKeyPolicyTokenClaimResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContentKeyPolicyTokenClaimResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContentKeyPolicyTokenClaimResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 claim_type: Optional[str] = None,
                 claim_value: Optional[str] = None):
        """
        Represents a token claim.
        :param str claim_type: Token claim type.
        :param str claim_value: Token claim value.
        """
        if claim_type is not None:
            pulumi.set(__self__, "claim_type", claim_type)
        if claim_value is not None:
            pulumi.set(__self__, "claim_value", claim_value)

    @property
    @pulumi.getter(name="claimType")
    def claim_type(self) -> Optional[str]:
        """
        Token claim type.
        """
        return pulumi.get(self, "claim_type")

    @property
    @pulumi.getter(name="claimValue")
    def claim_value(self) -> Optional[str]:
        """
        Token claim value.
        """
        return pulumi.get(self, "claim_value")


@pulumi.output_type
class ContentKeyPolicyTokenRestrictionResponse(dict):
    """
    Represents a token restriction. Provided token must match these requirements for successful license or key delivery.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "primaryVerificationKey":
            suggest = "primary_verification_key"
        elif key == "restrictionTokenType":
            suggest = "restriction_token_type"
        elif key == "alternateVerificationKeys":
            suggest = "alternate_verification_keys"
        elif key == "openIdConnectDiscoveryDocument":
            suggest = "open_id_connect_discovery_document"
        elif key == "requiredClaims":
            suggest = "required_claims"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContentKeyPolicyTokenRestrictionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContentKeyPolicyTokenRestrictionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContentKeyPolicyTokenRestrictionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 audience: str,
                 issuer: str,
                 odata_type: str,
                 primary_verification_key: Any,
                 restriction_token_type: str,
                 alternate_verification_keys: Optional[Sequence[Any]] = None,
                 open_id_connect_discovery_document: Optional[str] = None,
                 required_claims: Optional[Sequence['outputs.ContentKeyPolicyTokenClaimResponse']] = None):
        """
        Represents a token restriction. Provided token must match these requirements for successful license or key delivery.
        :param str audience: The audience for the token.
        :param str issuer: The token issuer.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.ContentKeyPolicyTokenRestriction'.
        :param Union['ContentKeyPolicyRsaTokenKeyResponse', 'ContentKeyPolicySymmetricTokenKeyResponse', 'ContentKeyPolicyX509CertificateTokenKeyResponse'] primary_verification_key: The primary verification key.
        :param str restriction_token_type: The type of token.
        :param Sequence[Union['ContentKeyPolicyRsaTokenKeyResponse', 'ContentKeyPolicySymmetricTokenKeyResponse', 'ContentKeyPolicyX509CertificateTokenKeyResponse']] alternate_verification_keys: A list of alternative verification keys.
        :param str open_id_connect_discovery_document: The OpenID connect discovery document.
        :param Sequence['ContentKeyPolicyTokenClaimResponse'] required_claims: A list of required token claims.
        """
        pulumi.set(__self__, "audience", audience)
        pulumi.set(__self__, "issuer", issuer)
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.ContentKeyPolicyTokenRestriction')
        pulumi.set(__self__, "primary_verification_key", primary_verification_key)
        pulumi.set(__self__, "restriction_token_type", restriction_token_type)
        if alternate_verification_keys is not None:
            pulumi.set(__self__, "alternate_verification_keys", alternate_verification_keys)
        if open_id_connect_discovery_document is not None:
            pulumi.set(__self__, "open_id_connect_discovery_document", open_id_connect_discovery_document)
        if required_claims is not None:
            pulumi.set(__self__, "required_claims", required_claims)

    @property
    @pulumi.getter
    def audience(self) -> str:
        """
        The audience for the token.
        """
        return pulumi.get(self, "audience")

    @property
    @pulumi.getter
    def issuer(self) -> str:
        """
        The token issuer.
        """
        return pulumi.get(self, "issuer")

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.ContentKeyPolicyTokenRestriction'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter(name="primaryVerificationKey")
    def primary_verification_key(self) -> Any:
        """
        The primary verification key.
        """
        return pulumi.get(self, "primary_verification_key")

    @property
    @pulumi.getter(name="restrictionTokenType")
    def restriction_token_type(self) -> str:
        """
        The type of token.
        """
        return pulumi.get(self, "restriction_token_type")

    @property
    @pulumi.getter(name="alternateVerificationKeys")
    def alternate_verification_keys(self) -> Optional[Sequence[Any]]:
        """
        A list of alternative verification keys.
        """
        return pulumi.get(self, "alternate_verification_keys")

    @property
    @pulumi.getter(name="openIdConnectDiscoveryDocument")
    def open_id_connect_discovery_document(self) -> Optional[str]:
        """
        The OpenID connect discovery document.
        """
        return pulumi.get(self, "open_id_connect_discovery_document")

    @property
    @pulumi.getter(name="requiredClaims")
    def required_claims(self) -> Optional[Sequence['outputs.ContentKeyPolicyTokenClaimResponse']]:
        """
        A list of required token claims.
        """
        return pulumi.get(self, "required_claims")


@pulumi.output_type
class ContentKeyPolicyUnknownConfigurationResponse(dict):
    """
    Represents a ContentKeyPolicyConfiguration that is unavailable in the current API version.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContentKeyPolicyUnknownConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContentKeyPolicyUnknownConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContentKeyPolicyUnknownConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str):
        """
        Represents a ContentKeyPolicyConfiguration that is unavailable in the current API version.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.ContentKeyPolicyUnknownConfiguration'.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.ContentKeyPolicyUnknownConfiguration')

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.ContentKeyPolicyUnknownConfiguration'.
        """
        return pulumi.get(self, "odata_type")


@pulumi.output_type
class ContentKeyPolicyUnknownRestrictionResponse(dict):
    """
    Represents a ContentKeyPolicyRestriction that is unavailable in the current API version.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContentKeyPolicyUnknownRestrictionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContentKeyPolicyUnknownRestrictionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContentKeyPolicyUnknownRestrictionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str):
        """
        Represents a ContentKeyPolicyRestriction that is unavailable in the current API version.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.ContentKeyPolicyUnknownRestriction'.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.ContentKeyPolicyUnknownRestriction')

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.ContentKeyPolicyUnknownRestriction'.
        """
        return pulumi.get(self, "odata_type")


@pulumi.output_type
class ContentKeyPolicyWidevineConfigurationResponse(dict):
    """
    Specifies a configuration for Widevine licenses.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "widevineTemplate":
            suggest = "widevine_template"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContentKeyPolicyWidevineConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContentKeyPolicyWidevineConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContentKeyPolicyWidevineConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 widevine_template: str):
        """
        Specifies a configuration for Widevine licenses.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.ContentKeyPolicyWidevineConfiguration'.
        :param str widevine_template: The Widevine template.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.ContentKeyPolicyWidevineConfiguration')
        pulumi.set(__self__, "widevine_template", widevine_template)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.ContentKeyPolicyWidevineConfiguration'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter(name="widevineTemplate")
    def widevine_template(self) -> str:
        """
        The Widevine template.
        """
        return pulumi.get(self, "widevine_template")


@pulumi.output_type
class ContentKeyPolicyX509CertificateTokenKeyResponse(dict):
    """
    Specifies a certificate for token validation.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"
        elif key == "rawBody":
            suggest = "raw_body"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContentKeyPolicyX509CertificateTokenKeyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContentKeyPolicyX509CertificateTokenKeyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContentKeyPolicyX509CertificateTokenKeyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str,
                 raw_body: str):
        """
        Specifies a certificate for token validation.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.ContentKeyPolicyX509CertificateTokenKey'.
        :param str raw_body: The raw data field of a certificate in PKCS 12 format (X509Certificate2 in .NET)
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.ContentKeyPolicyX509CertificateTokenKey')
        pulumi.set(__self__, "raw_body", raw_body)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.ContentKeyPolicyX509CertificateTokenKey'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter(name="rawBody")
    def raw_body(self) -> str:
        """
        The raw data field of a certificate in PKCS 12 format (X509Certificate2 in .NET)
        """
        return pulumi.get(self, "raw_body")


@pulumi.output_type
class DashSettingsResponse(dict):
    """
    The DASH setting for a track.
    """
    def __init__(__self__, *,
                 role: Optional[str] = None):
        """
        The DASH setting for a track.
        :param str role: The role for the DASH setting.
        """
        if role is not None:
            pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter
    def role(self) -> Optional[str]:
        """
        The role for the DASH setting.
        """
        return pulumi.get(self, "role")


@pulumi.output_type
class DefaultKeyResponse(dict):
    """
    Class to specify properties of default content key for each encryption scheme
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "policyName":
            suggest = "policy_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DefaultKeyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DefaultKeyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DefaultKeyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 label: Optional[str] = None,
                 policy_name: Optional[str] = None):
        """
        Class to specify properties of default content key for each encryption scheme
        :param str label: Label can be used to specify Content Key when creating a Streaming Locator
        :param str policy_name: Policy used by Default Key
        """
        if label is not None:
            pulumi.set(__self__, "label", label)
        if policy_name is not None:
            pulumi.set(__self__, "policy_name", policy_name)

    @property
    @pulumi.getter
    def label(self) -> Optional[str]:
        """
        Label can be used to specify Content Key when creating a Streaming Locator
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> Optional[str]:
        """
        Policy used by Default Key
        """
        return pulumi.get(self, "policy_name")


@pulumi.output_type
class EdgeUsageDataCollectionPolicyResponse(dict):
    def __init__(__self__, *,
                 data_collection_frequency: Optional[str] = None,
                 data_reporting_frequency: Optional[str] = None,
                 event_hub_details: Optional['outputs.EdgeUsageDataEventHubResponse'] = None,
                 max_allowed_unreported_usage_duration: Optional[str] = None):
        """
        :param str data_collection_frequency: Usage data collection frequency in ISO 8601 duration format e.g. PT10M , PT5H.
        :param str data_reporting_frequency: Usage data reporting frequency in ISO 8601 duration format e.g. PT10M , PT5H.
        :param 'EdgeUsageDataEventHubResponse' event_hub_details: Details of Event Hub where the usage will be reported.
        :param str max_allowed_unreported_usage_duration: Maximum time for which the functionality of the device will not be hampered for not reporting the usage data.
        """
        if data_collection_frequency is not None:
            pulumi.set(__self__, "data_collection_frequency", data_collection_frequency)
        if data_reporting_frequency is not None:
            pulumi.set(__self__, "data_reporting_frequency", data_reporting_frequency)
        if event_hub_details is not None:
            pulumi.set(__self__, "event_hub_details", event_hub_details)
        if max_allowed_unreported_usage_duration is not None:
            pulumi.set(__self__, "max_allowed_unreported_usage_duration", max_allowed_unreported_usage_duration)

    @property
    @pulumi.getter(name="dataCollectionFrequency")
    def data_collection_frequency(self) -> Optional[str]:
        """
        Usage data collection frequency in ISO 8601 duration format e.g. PT10M , PT5H.
        """
        return pulumi.get(self, "data_collection_frequency")

    @property
    @pulumi.getter(name="dataReportingFrequency")
    def data_reporting_frequency(self) -> Optional[str]:
        """
        Usage data reporting frequency in ISO 8601 duration format e.g. PT10M , PT5H.
        """
        return pulumi.get(self, "data_reporting_frequency")

    @property
    @pulumi.getter(name="eventHubDetails")
    def event_hub_details(self) -> Optional['outputs.EdgeUsageDataEventHubResponse']:
        """
        Details of Event Hub where the usage will be reported.
        """
        return pulumi.get(self, "event_hub_details")

    @property
    @pulumi.getter(name="maxAllowedUnreportedUsageDuration")
    def max_allowed_unreported_usage_duration(self) -> Optional[str]:
        """
        Maximum time for which the functionality of the device will not be hampered for not reporting the usage data.
        """
        return pulumi.get(self, "max_allowed_unreported_usage_duration")


@pulumi.output_type
class EdgeUsageDataEventHubResponse(dict):
    def __init__(__self__, *,
                 name: Optional[str] = None,
                 namespace: Optional[str] = None,
                 token: Optional[str] = None):
        """
        :param str name: Name of the Event Hub where usage will be reported.
        :param str namespace: Namespace of the Event Hub where usage will be reported.
        :param str token: SAS token needed to interact with Event Hub.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if token is not None:
            pulumi.set(__self__, "token", token)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the Event Hub where usage will be reported.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def namespace(self) -> Optional[str]:
        """
        Namespace of the Event Hub where usage will be reported.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def token(self) -> Optional[str]:
        """
        SAS token needed to interact with Event Hub.
        """
        return pulumi.get(self, "token")


@pulumi.output_type
class EnabledProtocolsResponse(dict):
    """
    Class to specify which protocols are enabled
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "smoothStreaming":
            suggest = "smooth_streaming"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EnabledProtocolsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EnabledProtocolsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EnabledProtocolsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dash: bool,
                 download: bool,
                 hls: bool,
                 smooth_streaming: bool):
        """
        Class to specify which protocols are enabled
        :param bool dash: Enable DASH protocol or not
        :param bool download: Enable Download protocol or not
        :param bool hls: Enable HLS protocol or not
        :param bool smooth_streaming: Enable SmoothStreaming protocol or not
        """
        pulumi.set(__self__, "dash", dash)
        pulumi.set(__self__, "download", download)
        pulumi.set(__self__, "hls", hls)
        pulumi.set(__self__, "smooth_streaming", smooth_streaming)

    @property
    @pulumi.getter
    def dash(self) -> bool:
        """
        Enable DASH protocol or not
        """
        return pulumi.get(self, "dash")

    @property
    @pulumi.getter
    def download(self) -> bool:
        """
        Enable Download protocol or not
        """
        return pulumi.get(self, "download")

    @property
    @pulumi.getter
    def hls(self) -> bool:
        """
        Enable HLS protocol or not
        """
        return pulumi.get(self, "hls")

    @property
    @pulumi.getter(name="smoothStreaming")
    def smooth_streaming(self) -> bool:
        """
        Enable SmoothStreaming protocol or not
        """
        return pulumi.get(self, "smooth_streaming")


@pulumi.output_type
class EnvelopeEncryptionResponse(dict):
    """
    Class for EnvelopeEncryption encryption scheme
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clearTracks":
            suggest = "clear_tracks"
        elif key == "contentKeys":
            suggest = "content_keys"
        elif key == "customKeyAcquisitionUrlTemplate":
            suggest = "custom_key_acquisition_url_template"
        elif key == "enabledProtocols":
            suggest = "enabled_protocols"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EnvelopeEncryptionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EnvelopeEncryptionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EnvelopeEncryptionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 clear_tracks: Optional[Sequence['outputs.TrackSelectionResponse']] = None,
                 content_keys: Optional['outputs.StreamingPolicyContentKeysResponse'] = None,
                 custom_key_acquisition_url_template: Optional[str] = None,
                 enabled_protocols: Optional['outputs.EnabledProtocolsResponse'] = None):
        """
        Class for EnvelopeEncryption encryption scheme
        :param Sequence['TrackSelectionResponse'] clear_tracks: Representing which tracks should not be encrypted
        :param 'StreamingPolicyContentKeysResponse' content_keys: Representing default content key for each encryption scheme and separate content keys for specific tracks
        :param str custom_key_acquisition_url_template: Template for the URL of the custom service delivering keys to end user players.  Not required when using Azure Media Services for issuing keys.  The template supports replaceable tokens that the service will update at runtime with the value specific to the request.  The currently supported token values are {AlternativeMediaId}, which is replaced with the value of StreamingLocatorId.AlternativeMediaId, and {ContentKeyId}, which is replaced with the value of identifier of the key being requested.
        :param 'EnabledProtocolsResponse' enabled_protocols: Representing supported protocols
        """
        if clear_tracks is not None:
            pulumi.set(__self__, "clear_tracks", clear_tracks)
        if content_keys is not None:
            pulumi.set(__self__, "content_keys", content_keys)
        if custom_key_acquisition_url_template is not None:
            pulumi.set(__self__, "custom_key_acquisition_url_template", custom_key_acquisition_url_template)
        if enabled_protocols is not None:
            pulumi.set(__self__, "enabled_protocols", enabled_protocols)

    @property
    @pulumi.getter(name="clearTracks")
    def clear_tracks(self) -> Optional[Sequence['outputs.TrackSelectionResponse']]:
        """
        Representing which tracks should not be encrypted
        """
        return pulumi.get(self, "clear_tracks")

    @property
    @pulumi.getter(name="contentKeys")
    def content_keys(self) -> Optional['outputs.StreamingPolicyContentKeysResponse']:
        """
        Representing default content key for each encryption scheme and separate content keys for specific tracks
        """
        return pulumi.get(self, "content_keys")

    @property
    @pulumi.getter(name="customKeyAcquisitionUrlTemplate")
    def custom_key_acquisition_url_template(self) -> Optional[str]:
        """
        Template for the URL of the custom service delivering keys to end user players.  Not required when using Azure Media Services for issuing keys.  The template supports replaceable tokens that the service will update at runtime with the value specific to the request.  The currently supported token values are {AlternativeMediaId}, which is replaced with the value of StreamingLocatorId.AlternativeMediaId, and {ContentKeyId}, which is replaced with the value of identifier of the key being requested.
        """
        return pulumi.get(self, "custom_key_acquisition_url_template")

    @property
    @pulumi.getter(name="enabledProtocols")
    def enabled_protocols(self) -> Optional['outputs.EnabledProtocolsResponse']:
        """
        Representing supported protocols
        """
        return pulumi.get(self, "enabled_protocols")


@pulumi.output_type
class FilterTrackPropertyConditionResponse(dict):
    """
    The class to specify one track property condition.
    """
    def __init__(__self__, *,
                 operation: str,
                 property: str,
                 value: str):
        """
        The class to specify one track property condition.
        :param str operation: The track property condition operation.
        :param str property: The track property type.
        :param str value: The track property value.
        """
        pulumi.set(__self__, "operation", operation)
        pulumi.set(__self__, "property", property)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def operation(self) -> str:
        """
        The track property condition operation.
        """
        return pulumi.get(self, "operation")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The track property value.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter
    def property(self) -> str:
        """
        The track property type.
        """
        return pulumi.get(self, "property")


@pulumi.output_type
class FilterTrackSelectionResponse(dict):
    """
    Representing a list of FilterTrackPropertyConditions to select a track.  The filters are combined using a logical AND operation.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "trackSelections":
            suggest = "track_selections"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FilterTrackSelectionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FilterTrackSelectionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FilterTrackSelectionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 track_selections: Sequence['outputs.FilterTrackPropertyConditionResponse']):
        """
        Representing a list of FilterTrackPropertyConditions to select a track.  The filters are combined using a logical AND operation.
        :param Sequence['FilterTrackPropertyConditionResponse'] track_selections: The track selections.
        """
        pulumi.set(__self__, "track_selections", track_selections)

    @property
    @pulumi.getter(name="trackSelections")
    def track_selections(self) -> Sequence['outputs.FilterTrackPropertyConditionResponse']:
        """
        The track selections.
        """
        return pulumi.get(self, "track_selections")


@pulumi.output_type
class FirstQualityResponse(dict):
    """
    Filter First Quality
    """
    def __init__(__self__, *,
                 bitrate: int):
        """
        Filter First Quality
        :param int bitrate: The first quality bitrate.
        """
        pulumi.set(__self__, "bitrate", bitrate)

    @property
    @pulumi.getter
    def bitrate(self) -> int:
        """
        The first quality bitrate.
        """
        return pulumi.get(self, "bitrate")


@pulumi.output_type
class HlsSettingsResponse(dict):
    """
    The HLS setting for a track.
    """
    def __init__(__self__, *,
                 characteristics: Optional[str] = None,
                 default: Optional[bool] = None,
                 forced: Optional[bool] = None):
        """
        The HLS setting for a track.
        :param str characteristics: The characteristics for the HLS setting.
        :param bool default: The default for the HLS setting.
        :param bool forced: The forced for the HLS setting.
        """
        if characteristics is not None:
            pulumi.set(__self__, "characteristics", characteristics)
        if default is not None:
            pulumi.set(__self__, "default", default)
        if forced is not None:
            pulumi.set(__self__, "forced", forced)

    @property
    @pulumi.getter
    def characteristics(self) -> Optional[str]:
        """
        The characteristics for the HLS setting.
        """
        return pulumi.get(self, "characteristics")

    @property
    @pulumi.getter
    def default(self) -> Optional[bool]:
        """
        The default for the HLS setting.
        """
        return pulumi.get(self, "default")

    @property
    @pulumi.getter
    def forced(self) -> Optional[bool]:
        """
        The forced for the HLS setting.
        """
        return pulumi.get(self, "forced")


@pulumi.output_type
class KeyDeliveryResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessControl":
            suggest = "access_control"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KeyDeliveryResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KeyDeliveryResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KeyDeliveryResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_control: Optional['outputs.AccessControlResponse'] = None):
        """
        :param 'AccessControlResponse' access_control: The access control properties for Key Delivery.
        """
        if access_control is not None:
            pulumi.set(__self__, "access_control", access_control)

    @property
    @pulumi.getter(name="accessControl")
    def access_control(self) -> Optional['outputs.AccessControlResponse']:
        """
        The access control properties for Key Delivery.
        """
        return pulumi.get(self, "access_control")


@pulumi.output_type
class KeyVaultPropertiesResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "currentKeyIdentifier":
            suggest = "current_key_identifier"
        elif key == "keyIdentifier":
            suggest = "key_identifier"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KeyVaultPropertiesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KeyVaultPropertiesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KeyVaultPropertiesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 current_key_identifier: str,
                 key_identifier: Optional[str] = None):
        """
        :param str current_key_identifier: The current key used to encrypt the Media Services account, including the key version.
        :param str key_identifier: The URL of the Key Vault key used to encrypt the account. The key may either be versioned (for example https://vault/keys/mykey/version1) or reference a key without a version (for example https://vault/keys/mykey).
        """
        pulumi.set(__self__, "current_key_identifier", current_key_identifier)
        if key_identifier is not None:
            pulumi.set(__self__, "key_identifier", key_identifier)

    @property
    @pulumi.getter(name="currentKeyIdentifier")
    def current_key_identifier(self) -> str:
        """
        The current key used to encrypt the Media Services account, including the key version.
        """
        return pulumi.get(self, "current_key_identifier")

    @property
    @pulumi.getter(name="keyIdentifier")
    def key_identifier(self) -> Optional[str]:
        """
        The URL of the Key Vault key used to encrypt the account. The key may either be versioned (for example https://vault/keys/mykey/version1) or reference a key without a version (for example https://vault/keys/mykey).
        """
        return pulumi.get(self, "key_identifier")


@pulumi.output_type
class MediaServiceIdentityResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"
        elif key == "userAssignedIdentities":
            suggest = "user_assigned_identities"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MediaServiceIdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MediaServiceIdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MediaServiceIdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 principal_id: str,
                 tenant_id: str,
                 type: str,
                 user_assigned_identities: Optional[Mapping[str, 'outputs.UserAssignedManagedIdentityResponse']] = None):
        """
        :param str principal_id: The Principal ID of the identity.
        :param str tenant_id: The Tenant ID of the identity.
        :param str type: The identity type.
        :param Mapping[str, 'UserAssignedManagedIdentityResponse'] user_assigned_identities: The user assigned managed identities.
        """
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        pulumi.set(__self__, "type", type)
        if user_assigned_identities is not None:
            pulumi.set(__self__, "user_assigned_identities", user_assigned_identities)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        The Principal ID of the identity.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        The Tenant ID of the identity.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The identity type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="userAssignedIdentities")
    def user_assigned_identities(self) -> Optional[Mapping[str, 'outputs.UserAssignedManagedIdentityResponse']]:
        """
        The user assigned managed identities.
        """
        return pulumi.get(self, "user_assigned_identities")


@pulumi.output_type
class NoEncryptionResponse(dict):
    """
    Class for NoEncryption scheme
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enabledProtocols":
            suggest = "enabled_protocols"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NoEncryptionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NoEncryptionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NoEncryptionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled_protocols: Optional['outputs.EnabledProtocolsResponse'] = None):
        """
        Class for NoEncryption scheme
        :param 'EnabledProtocolsResponse' enabled_protocols: Representing supported protocols
        """
        if enabled_protocols is not None:
            pulumi.set(__self__, "enabled_protocols", enabled_protocols)

    @property
    @pulumi.getter(name="enabledProtocols")
    def enabled_protocols(self) -> Optional['outputs.EnabledProtocolsResponse']:
        """
        Representing supported protocols
        """
        return pulumi.get(self, "enabled_protocols")


@pulumi.output_type
class PresentationTimeRangeResponse(dict):
    """
    The presentation time range, this is asset related and not recommended for Account Filter.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endTimestamp":
            suggest = "end_timestamp"
        elif key == "forceEndTimestamp":
            suggest = "force_end_timestamp"
        elif key == "liveBackoffDuration":
            suggest = "live_backoff_duration"
        elif key == "presentationWindowDuration":
            suggest = "presentation_window_duration"
        elif key == "startTimestamp":
            suggest = "start_timestamp"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PresentationTimeRangeResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PresentationTimeRangeResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PresentationTimeRangeResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 end_timestamp: Optional[float] = None,
                 force_end_timestamp: Optional[bool] = None,
                 live_backoff_duration: Optional[float] = None,
                 presentation_window_duration: Optional[float] = None,
                 start_timestamp: Optional[float] = None,
                 timescale: Optional[float] = None):
        """
        The presentation time range, this is asset related and not recommended for Account Filter.
        :param float end_timestamp: The absolute end time boundary.
        :param bool force_end_timestamp: The indicator of forcing existing of end time stamp.
        :param float live_backoff_duration: The relative to end right edge.
        :param float presentation_window_duration: The relative to end sliding window.
        :param float start_timestamp: The absolute start time boundary.
        :param float timescale: The time scale of time stamps.
        """
        if end_timestamp is not None:
            pulumi.set(__self__, "end_timestamp", end_timestamp)
        if force_end_timestamp is not None:
            pulumi.set(__self__, "force_end_timestamp", force_end_timestamp)
        if live_backoff_duration is not None:
            pulumi.set(__self__, "live_backoff_duration", live_backoff_duration)
        if presentation_window_duration is not None:
            pulumi.set(__self__, "presentation_window_duration", presentation_window_duration)
        if start_timestamp is not None:
            pulumi.set(__self__, "start_timestamp", start_timestamp)
        if timescale is not None:
            pulumi.set(__self__, "timescale", timescale)

    @property
    @pulumi.getter(name="endTimestamp")
    def end_timestamp(self) -> Optional[float]:
        """
        The absolute end time boundary.
        """
        return pulumi.get(self, "end_timestamp")

    @property
    @pulumi.getter(name="forceEndTimestamp")
    def force_end_timestamp(self) -> Optional[bool]:
        """
        The indicator of forcing existing of end time stamp.
        """
        return pulumi.get(self, "force_end_timestamp")

    @property
    @pulumi.getter(name="liveBackoffDuration")
    def live_backoff_duration(self) -> Optional[float]:
        """
        The relative to end right edge.
        """
        return pulumi.get(self, "live_backoff_duration")

    @property
    @pulumi.getter(name="presentationWindowDuration")
    def presentation_window_duration(self) -> Optional[float]:
        """
        The relative to end sliding window.
        """
        return pulumi.get(self, "presentation_window_duration")

    @property
    @pulumi.getter(name="startTimestamp")
    def start_timestamp(self) -> Optional[float]:
        """
        The absolute start time boundary.
        """
        return pulumi.get(self, "start_timestamp")

    @property
    @pulumi.getter
    def timescale(self) -> Optional[float]:
        """
        The time scale of time stamps.
        """
        return pulumi.get(self, "timescale")


@pulumi.output_type
class PrivateEndpointConnectionResponse(dict):
    """
    The Private Endpoint Connection resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateLinkServiceConnectionState":
            suggest = "private_link_service_connection_state"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "privateEndpoint":
            suggest = "private_endpoint"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateEndpointConnectionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateEndpointConnectionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateEndpointConnectionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 name: str,
                 private_link_service_connection_state: 'outputs.PrivateLinkServiceConnectionStateResponse',
                 provisioning_state: str,
                 type: str,
                 private_endpoint: Optional['outputs.PrivateEndpointResponse'] = None):
        """
        The Private Endpoint Connection resource.
        :param str id: Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
        :param str name: The name of the resource
        :param 'PrivateLinkServiceConnectionStateResponse' private_link_service_connection_state: A collection of information about the state of the connection between service consumer and provider.
        :param str provisioning_state: The provisioning state of the private endpoint connection resource.
        :param str type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
        :param 'PrivateEndpointResponse' private_endpoint: The resource of private end point.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "private_link_service_connection_state", private_link_service_connection_state)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "type", type)
        if private_endpoint is not None:
            pulumi.set(__self__, "private_endpoint", private_endpoint)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="privateLinkServiceConnectionState")
    def private_link_service_connection_state(self) -> 'outputs.PrivateLinkServiceConnectionStateResponse':
        """
        A collection of information about the state of the connection between service consumer and provider.
        """
        return pulumi.get(self, "private_link_service_connection_state")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the private endpoint connection resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="privateEndpoint")
    def private_endpoint(self) -> Optional['outputs.PrivateEndpointResponse']:
        """
        The resource of private end point.
        """
        return pulumi.get(self, "private_endpoint")


@pulumi.output_type
class PrivateEndpointResponse(dict):
    """
    The Private Endpoint resource.
    """
    def __init__(__self__, *,
                 id: str):
        """
        The Private Endpoint resource.
        :param str id: The ARM identifier for Private Endpoint
        """
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ARM identifier for Private Endpoint
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class PrivateLinkServiceConnectionStateResponse(dict):
    """
    A collection of information about the state of the connection between service consumer and provider.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "actionsRequired":
            suggest = "actions_required"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateLinkServiceConnectionStateResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateLinkServiceConnectionStateResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateLinkServiceConnectionStateResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 actions_required: Optional[str] = None,
                 description: Optional[str] = None,
                 status: Optional[str] = None):
        """
        A collection of information about the state of the connection between service consumer and provider.
        :param str actions_required: A message indicating if changes on the service provider require any updates on the consumer.
        :param str description: The reason for approval/rejection of the connection.
        :param str status: Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
        """
        if actions_required is not None:
            pulumi.set(__self__, "actions_required", actions_required)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="actionsRequired")
    def actions_required(self) -> Optional[str]:
        """
        A message indicating if changes on the service provider require any updates on the consumer.
        """
        return pulumi.get(self, "actions_required")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The reason for approval/rejection of the connection.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class ResourceIdentityResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "useSystemAssignedIdentity":
            suggest = "use_system_assigned_identity"
        elif key == "userAssignedIdentity":
            suggest = "user_assigned_identity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceIdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceIdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceIdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 use_system_assigned_identity: bool,
                 user_assigned_identity: Optional[str] = None):
        """
        :param bool use_system_assigned_identity: Indicates whether to use System Assigned Managed Identity. Mutual exclusive with User Assigned Managed Identity.
        :param str user_assigned_identity: The user assigned managed identity's ARM ID to use when accessing a resource.
        """
        pulumi.set(__self__, "use_system_assigned_identity", use_system_assigned_identity)
        if user_assigned_identity is not None:
            pulumi.set(__self__, "user_assigned_identity", user_assigned_identity)

    @property
    @pulumi.getter(name="useSystemAssignedIdentity")
    def use_system_assigned_identity(self) -> bool:
        """
        Indicates whether to use System Assigned Managed Identity. Mutual exclusive with User Assigned Managed Identity.
        """
        return pulumi.get(self, "use_system_assigned_identity")

    @property
    @pulumi.getter(name="userAssignedIdentity")
    def user_assigned_identity(self) -> Optional[str]:
        """
        The user assigned managed identity's ARM ID to use when accessing a resource.
        """
        return pulumi.get(self, "user_assigned_identity")


@pulumi.output_type
class StorageAccountResponse(dict):
    """
    The storage account details.
    """
    def __init__(__self__, *,
                 status: str,
                 type: str,
                 id: Optional[str] = None,
                 identity: Optional['outputs.ResourceIdentityResponse'] = None):
        """
        The storage account details.
        :param str status: The current status of the storage account mapping.
        :param str type: The type of the storage account.
        :param str id: The ID of the storage account resource. Media Services relies on tables and queues as well as blobs, so the primary storage account must be a Standard Storage account (either Microsoft.ClassicStorage or Microsoft.Storage). Blob only storage accounts can be added as secondary storage accounts.
        :param 'ResourceIdentityResponse' identity: The storage account identity.
        """
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "type", type)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The current status of the storage account mapping.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the storage account.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The ID of the storage account resource. Media Services relies on tables and queues as well as blobs, so the primary storage account must be a Standard Storage account (either Microsoft.ClassicStorage or Microsoft.Storage). Blob only storage accounts can be added as secondary storage accounts.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def identity(self) -> Optional['outputs.ResourceIdentityResponse']:
        """
        The storage account identity.
        """
        return pulumi.get(self, "identity")


@pulumi.output_type
class StreamingLocatorContentKeyResponse(dict):
    """
    Class for content key in Streaming Locator
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "policyName":
            suggest = "policy_name"
        elif key == "labelReferenceInStreamingPolicy":
            suggest = "label_reference_in_streaming_policy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StreamingLocatorContentKeyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StreamingLocatorContentKeyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StreamingLocatorContentKeyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 policy_name: str,
                 tracks: Sequence['outputs.TrackSelectionResponse'],
                 type: str,
                 label_reference_in_streaming_policy: Optional[str] = None,
                 value: Optional[str] = None):
        """
        Class for content key in Streaming Locator
        :param str id: ID of Content Key
        :param str policy_name: ContentKeyPolicy used by Content Key
        :param Sequence['TrackSelectionResponse'] tracks: Tracks which use this Content Key
        :param str type: Encryption type of Content Key
        :param str label_reference_in_streaming_policy: Label of Content Key as specified in the Streaming Policy
        :param str value: Value of Content Key
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "policy_name", policy_name)
        pulumi.set(__self__, "tracks", tracks)
        pulumi.set(__self__, "type", type)
        if label_reference_in_streaming_policy is not None:
            pulumi.set(__self__, "label_reference_in_streaming_policy", label_reference_in_streaming_policy)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        ID of Content Key
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> str:
        """
        ContentKeyPolicy used by Content Key
        """
        return pulumi.get(self, "policy_name")

    @property
    @pulumi.getter
    def tracks(self) -> Sequence['outputs.TrackSelectionResponse']:
        """
        Tracks which use this Content Key
        """
        return pulumi.get(self, "tracks")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Encryption type of Content Key
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="labelReferenceInStreamingPolicy")
    def label_reference_in_streaming_policy(self) -> Optional[str]:
        """
        Label of Content Key as specified in the Streaming Policy
        """
        return pulumi.get(self, "label_reference_in_streaming_policy")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        Value of Content Key
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class StreamingPathResponse(dict):
    """
    Class of paths for streaming
    """
    def __init__(__self__, *,
                 encryption_scheme: str,
                 streaming_protocol: str,
                 paths: Optional[Sequence[str]] = None):
        """
        Class of paths for streaming
        :param str encryption_scheme: Encryption scheme
        :param str streaming_protocol: Streaming protocol
        :param Sequence[str] paths: Streaming paths for each protocol and encryptionScheme pair
        """
        pulumi.set(__self__, "encryption_scheme", encryption_scheme)
        pulumi.set(__self__, "streaming_protocol", streaming_protocol)
        if paths is not None:
            pulumi.set(__self__, "paths", paths)

    @property
    @pulumi.getter(name="encryptionScheme")
    def encryption_scheme(self) -> str:
        """
        Encryption scheme
        """
        return pulumi.get(self, "encryption_scheme")

    @property
    @pulumi.getter(name="streamingProtocol")
    def streaming_protocol(self) -> str:
        """
        Streaming protocol
        """
        return pulumi.get(self, "streaming_protocol")

    @property
    @pulumi.getter
    def paths(self) -> Optional[Sequence[str]]:
        """
        Streaming paths for each protocol and encryptionScheme pair
        """
        return pulumi.get(self, "paths")


@pulumi.output_type
class StreamingPolicyContentKeyResponse(dict):
    """
    Class to specify properties of content key
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "policyName":
            suggest = "policy_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StreamingPolicyContentKeyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StreamingPolicyContentKeyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StreamingPolicyContentKeyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 label: Optional[str] = None,
                 policy_name: Optional[str] = None,
                 tracks: Optional[Sequence['outputs.TrackSelectionResponse']] = None):
        """
        Class to specify properties of content key
        :param str label: Label can be used to specify Content Key when creating a Streaming Locator
        :param str policy_name: Policy used by Content Key
        :param Sequence['TrackSelectionResponse'] tracks: Tracks which use this content key
        """
        if label is not None:
            pulumi.set(__self__, "label", label)
        if policy_name is not None:
            pulumi.set(__self__, "policy_name", policy_name)
        if tracks is not None:
            pulumi.set(__self__, "tracks", tracks)

    @property
    @pulumi.getter
    def label(self) -> Optional[str]:
        """
        Label can be used to specify Content Key when creating a Streaming Locator
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> Optional[str]:
        """
        Policy used by Content Key
        """
        return pulumi.get(self, "policy_name")

    @property
    @pulumi.getter
    def tracks(self) -> Optional[Sequence['outputs.TrackSelectionResponse']]:
        """
        Tracks which use this content key
        """
        return pulumi.get(self, "tracks")


@pulumi.output_type
class StreamingPolicyContentKeysResponse(dict):
    """
    Class to specify properties of all content keys in Streaming Policy
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultKey":
            suggest = "default_key"
        elif key == "keyToTrackMappings":
            suggest = "key_to_track_mappings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StreamingPolicyContentKeysResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StreamingPolicyContentKeysResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StreamingPolicyContentKeysResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_key: Optional['outputs.DefaultKeyResponse'] = None,
                 key_to_track_mappings: Optional[Sequence['outputs.StreamingPolicyContentKeyResponse']] = None):
        """
        Class to specify properties of all content keys in Streaming Policy
        :param 'DefaultKeyResponse' default_key: Default content key for an encryption scheme
        :param Sequence['StreamingPolicyContentKeyResponse'] key_to_track_mappings: Representing tracks needs separate content key
        """
        if default_key is not None:
            pulumi.set(__self__, "default_key", default_key)
        if key_to_track_mappings is not None:
            pulumi.set(__self__, "key_to_track_mappings", key_to_track_mappings)

    @property
    @pulumi.getter(name="defaultKey")
    def default_key(self) -> Optional['outputs.DefaultKeyResponse']:
        """
        Default content key for an encryption scheme
        """
        return pulumi.get(self, "default_key")

    @property
    @pulumi.getter(name="keyToTrackMappings")
    def key_to_track_mappings(self) -> Optional[Sequence['outputs.StreamingPolicyContentKeyResponse']]:
        """
        Representing tracks needs separate content key
        """
        return pulumi.get(self, "key_to_track_mappings")


@pulumi.output_type
class StreamingPolicyFairPlayConfigurationResponse(dict):
    """
    Class to specify configurations of FairPlay in Streaming Policy
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowPersistentLicense":
            suggest = "allow_persistent_license"
        elif key == "customLicenseAcquisitionUrlTemplate":
            suggest = "custom_license_acquisition_url_template"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StreamingPolicyFairPlayConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StreamingPolicyFairPlayConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StreamingPolicyFairPlayConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_persistent_license: bool,
                 custom_license_acquisition_url_template: Optional[str] = None):
        """
        Class to specify configurations of FairPlay in Streaming Policy
        :param bool allow_persistent_license: All license to be persistent or not
        :param str custom_license_acquisition_url_template: Template for the URL of the custom service delivering licenses to end user players.  Not required when using Azure Media Services for issuing licenses.  The template supports replaceable tokens that the service will update at runtime with the value specific to the request.  The currently supported token values are {AlternativeMediaId}, which is replaced with the value of StreamingLocatorId.AlternativeMediaId, and {ContentKeyId}, which is replaced with the value of identifier of the key being requested.
        """
        pulumi.set(__self__, "allow_persistent_license", allow_persistent_license)
        if custom_license_acquisition_url_template is not None:
            pulumi.set(__self__, "custom_license_acquisition_url_template", custom_license_acquisition_url_template)

    @property
    @pulumi.getter(name="allowPersistentLicense")
    def allow_persistent_license(self) -> bool:
        """
        All license to be persistent or not
        """
        return pulumi.get(self, "allow_persistent_license")

    @property
    @pulumi.getter(name="customLicenseAcquisitionUrlTemplate")
    def custom_license_acquisition_url_template(self) -> Optional[str]:
        """
        Template for the URL of the custom service delivering licenses to end user players.  Not required when using Azure Media Services for issuing licenses.  The template supports replaceable tokens that the service will update at runtime with the value specific to the request.  The currently supported token values are {AlternativeMediaId}, which is replaced with the value of StreamingLocatorId.AlternativeMediaId, and {ContentKeyId}, which is replaced with the value of identifier of the key being requested.
        """
        return pulumi.get(self, "custom_license_acquisition_url_template")


@pulumi.output_type
class StreamingPolicyPlayReadyConfigurationResponse(dict):
    """
    Class to specify configurations of PlayReady in Streaming Policy
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customLicenseAcquisitionUrlTemplate":
            suggest = "custom_license_acquisition_url_template"
        elif key == "playReadyCustomAttributes":
            suggest = "play_ready_custom_attributes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StreamingPolicyPlayReadyConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StreamingPolicyPlayReadyConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StreamingPolicyPlayReadyConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 custom_license_acquisition_url_template: Optional[str] = None,
                 play_ready_custom_attributes: Optional[str] = None):
        """
        Class to specify configurations of PlayReady in Streaming Policy
        :param str custom_license_acquisition_url_template: Template for the URL of the custom service delivering licenses to end user players.  Not required when using Azure Media Services for issuing licenses.  The template supports replaceable tokens that the service will update at runtime with the value specific to the request.  The currently supported token values are {AlternativeMediaId}, which is replaced with the value of StreamingLocatorId.AlternativeMediaId, and {ContentKeyId}, which is replaced with the value of identifier of the key being requested.
        :param str play_ready_custom_attributes: Custom attributes for PlayReady
        """
        if custom_license_acquisition_url_template is not None:
            pulumi.set(__self__, "custom_license_acquisition_url_template", custom_license_acquisition_url_template)
        if play_ready_custom_attributes is not None:
            pulumi.set(__self__, "play_ready_custom_attributes", play_ready_custom_attributes)

    @property
    @pulumi.getter(name="customLicenseAcquisitionUrlTemplate")
    def custom_license_acquisition_url_template(self) -> Optional[str]:
        """
        Template for the URL of the custom service delivering licenses to end user players.  Not required when using Azure Media Services for issuing licenses.  The template supports replaceable tokens that the service will update at runtime with the value specific to the request.  The currently supported token values are {AlternativeMediaId}, which is replaced with the value of StreamingLocatorId.AlternativeMediaId, and {ContentKeyId}, which is replaced with the value of identifier of the key being requested.
        """
        return pulumi.get(self, "custom_license_acquisition_url_template")

    @property
    @pulumi.getter(name="playReadyCustomAttributes")
    def play_ready_custom_attributes(self) -> Optional[str]:
        """
        Custom attributes for PlayReady
        """
        return pulumi.get(self, "play_ready_custom_attributes")


@pulumi.output_type
class StreamingPolicyWidevineConfigurationResponse(dict):
    """
    Class to specify configurations of Widevine in Streaming Policy
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customLicenseAcquisitionUrlTemplate":
            suggest = "custom_license_acquisition_url_template"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StreamingPolicyWidevineConfigurationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StreamingPolicyWidevineConfigurationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StreamingPolicyWidevineConfigurationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 custom_license_acquisition_url_template: Optional[str] = None):
        """
        Class to specify configurations of Widevine in Streaming Policy
        :param str custom_license_acquisition_url_template: Template for the URL of the custom service delivering licenses to end user players.  Not required when using Azure Media Services for issuing licenses.  The template supports replaceable tokens that the service will update at runtime with the value specific to the request.  The currently supported token values are {AlternativeMediaId}, which is replaced with the value of StreamingLocatorId.AlternativeMediaId, and {ContentKeyId}, which is replaced with the value of identifier of the key being requested.
        """
        if custom_license_acquisition_url_template is not None:
            pulumi.set(__self__, "custom_license_acquisition_url_template", custom_license_acquisition_url_template)

    @property
    @pulumi.getter(name="customLicenseAcquisitionUrlTemplate")
    def custom_license_acquisition_url_template(self) -> Optional[str]:
        """
        Template for the URL of the custom service delivering licenses to end user players.  Not required when using Azure Media Services for issuing licenses.  The template supports replaceable tokens that the service will update at runtime with the value specific to the request.  The currently supported token values are {AlternativeMediaId}, which is replaced with the value of StreamingLocatorId.AlternativeMediaId, and {ContentKeyId}, which is replaced with the value of identifier of the key being requested.
        """
        return pulumi.get(self, "custom_license_acquisition_url_template")


@pulumi.output_type
class SystemDataResponse(dict):
    """
    Metadata pertaining to creation and last modification of the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "createdBy":
            suggest = "created_by"
        elif key == "createdByType":
            suggest = "created_by_type"
        elif key == "lastModifiedAt":
            suggest = "last_modified_at"
        elif key == "lastModifiedBy":
            suggest = "last_modified_by"
        elif key == "lastModifiedByType":
            suggest = "last_modified_by_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SystemDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: Optional[str] = None,
                 created_by: Optional[str] = None,
                 created_by_type: Optional[str] = None,
                 last_modified_at: Optional[str] = None,
                 last_modified_by: Optional[str] = None,
                 last_modified_by_type: Optional[str] = None):
        """
        Metadata pertaining to creation and last modification of the resource.
        :param str created_at: The timestamp of resource creation (UTC).
        :param str created_by: The identity that created the resource.
        :param str created_by_type: The type of identity that created the resource.
        :param str last_modified_at: The timestamp of resource last modification (UTC)
        :param str last_modified_by: The identity that last modified the resource.
        :param str last_modified_by_type: The type of identity that last modified the resource.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_by_type is not None:
            pulumi.set(__self__, "created_by_type", created_by_type)
        if last_modified_at is not None:
            pulumi.set(__self__, "last_modified_at", last_modified_at)
        if last_modified_by is not None:
            pulumi.set(__self__, "last_modified_by", last_modified_by)
        if last_modified_by_type is not None:
            pulumi.set(__self__, "last_modified_by_type", last_modified_by_type)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The timestamp of resource creation (UTC).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[str]:
        """
        The identity that created the resource.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="createdByType")
    def created_by_type(self) -> Optional[str]:
        """
        The type of identity that created the resource.
        """
        return pulumi.get(self, "created_by_type")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> Optional[str]:
        """
        The timestamp of resource last modification (UTC)
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> Optional[str]:
        """
        The identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by")

    @property
    @pulumi.getter(name="lastModifiedByType")
    def last_modified_by_type(self) -> Optional[str]:
        """
        The type of identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by_type")


@pulumi.output_type
class TextTrackResponse(dict):
    """
    Represents a text track in an asset. A text track is usually used for sparse data related to the audio or video tracks.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "languageCode":
            suggest = "language_code"
        elif key == "odataType":
            suggest = "odata_type"
        elif key == "displayName":
            suggest = "display_name"
        elif key == "fileName":
            suggest = "file_name"
        elif key == "hlsSettings":
            suggest = "hls_settings"
        elif key == "playerVisibility":
            suggest = "player_visibility"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TextTrackResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TextTrackResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TextTrackResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 language_code: str,
                 odata_type: str,
                 display_name: Optional[str] = None,
                 file_name: Optional[str] = None,
                 hls_settings: Optional['outputs.HlsSettingsResponse'] = None,
                 player_visibility: Optional[str] = None):
        """
        Represents a text track in an asset. A text track is usually used for sparse data related to the audio or video tracks.
        :param str language_code: The RFC5646 language code for the text track.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.TextTrack'.
        :param str display_name: The display name of the text track on a video player. In HLS, this maps to the NAME attribute of EXT-X-MEDIA.
        :param str file_name: The file name to the source file. This file is located in the storage container of the asset.
        :param 'HlsSettingsResponse' hls_settings: The HLS specific setting for the text track.
        :param str player_visibility: When PlayerVisibility is set to "Visible", the text track will be present in the DASH manifest or HLS playlist when requested by a client. When the PlayerVisibility is set to "Hidden", the text will not be available to the client. The default value is "Visible".
        """
        pulumi.set(__self__, "language_code", language_code)
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.TextTrack')
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if file_name is not None:
            pulumi.set(__self__, "file_name", file_name)
        if hls_settings is not None:
            pulumi.set(__self__, "hls_settings", hls_settings)
        if player_visibility is not None:
            pulumi.set(__self__, "player_visibility", player_visibility)

    @property
    @pulumi.getter(name="languageCode")
    def language_code(self) -> str:
        """
        The RFC5646 language code for the text track.
        """
        return pulumi.get(self, "language_code")

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.TextTrack'.
        """
        return pulumi.get(self, "odata_type")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        The display name of the text track on a video player. In HLS, this maps to the NAME attribute of EXT-X-MEDIA.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="fileName")
    def file_name(self) -> Optional[str]:
        """
        The file name to the source file. This file is located in the storage container of the asset.
        """
        return pulumi.get(self, "file_name")

    @property
    @pulumi.getter(name="hlsSettings")
    def hls_settings(self) -> Optional['outputs.HlsSettingsResponse']:
        """
        The HLS specific setting for the text track.
        """
        return pulumi.get(self, "hls_settings")

    @property
    @pulumi.getter(name="playerVisibility")
    def player_visibility(self) -> Optional[str]:
        """
        When PlayerVisibility is set to "Visible", the text track will be present in the DASH manifest or HLS playlist when requested by a client. When the PlayerVisibility is set to "Hidden", the text will not be available to the client. The default value is "Visible".
        """
        return pulumi.get(self, "player_visibility")


@pulumi.output_type
class TrackPropertyConditionResponse(dict):
    """
    Class to specify one track property condition
    """
    def __init__(__self__, *,
                 operation: str,
                 property: str,
                 value: Optional[str] = None):
        """
        Class to specify one track property condition
        :param str operation: Track property condition operation
        :param str property: Track property type
        :param str value: Track property value
        """
        pulumi.set(__self__, "operation", operation)
        pulumi.set(__self__, "property", property)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def operation(self) -> str:
        """
        Track property condition operation
        """
        return pulumi.get(self, "operation")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        Track property value
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter
    def property(self) -> str:
        """
        Track property type
        """
        return pulumi.get(self, "property")


@pulumi.output_type
class TrackSelectionResponse(dict):
    """
    Class to select a track
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "trackSelections":
            suggest = "track_selections"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TrackSelectionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TrackSelectionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TrackSelectionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 track_selections: Optional[Sequence['outputs.TrackPropertyConditionResponse']] = None):
        """
        Class to select a track
        :param Sequence['TrackPropertyConditionResponse'] track_selections: TrackSelections is a track property condition list which can specify track(s)
        """
        if track_selections is not None:
            pulumi.set(__self__, "track_selections", track_selections)

    @property
    @pulumi.getter(name="trackSelections")
    def track_selections(self) -> Optional[Sequence['outputs.TrackPropertyConditionResponse']]:
        """
        TrackSelections is a track property condition list which can specify track(s)
        """
        return pulumi.get(self, "track_selections")


@pulumi.output_type
class UserAssignedManagedIdentityResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "principalId":
            suggest = "principal_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserAssignedManagedIdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserAssignedManagedIdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserAssignedManagedIdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: str,
                 principal_id: str):
        """
        :param str client_id: The client ID.
        :param str principal_id: The principal ID.
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "principal_id", principal_id)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> str:
        """
        The client ID.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        The principal ID.
        """
        return pulumi.get(self, "principal_id")


@pulumi.output_type
class VideoTrackResponse(dict):
    """
    Represents a video track in the asset.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "odataType":
            suggest = "odata_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VideoTrackResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VideoTrackResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VideoTrackResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 odata_type: str):
        """
        Represents a video track in the asset.
        :param str odata_type: The discriminator for derived types.
               Expected value is '#Microsoft.Media.VideoTrack'.
        """
        pulumi.set(__self__, "odata_type", '#Microsoft.Media.VideoTrack')

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> str:
        """
        The discriminator for derived types.
        Expected value is '#Microsoft.Media.VideoTrack'.
        """
        return pulumi.get(self, "odata_type")


