# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from ._enums import *

__all__ = [
    'ActionGroupArgs',
    'ActionListArgs',
    'AlertRuleAllOfConditionArgs',
    'AlertRuleAnyOfOrLeafConditionArgs',
    'AlertRuleLeafConditionArgs',
    'AlertingActionArgs',
    'ApplicationInsightsComponentAnalyticsItemPropertiesArgs',
    'ApplicationInsightsComponentDataVolumeCapArgs',
    'ApplicationInsightsComponentProactiveDetectionConfigurationRuleDefinitionsArgs',
    'ArmRoleReceiverArgs',
    'AutomationRunbookReceiverArgs',
    'AutoscaleNotificationArgs',
    'AutoscaleProfileArgs',
    'AzNsActionGroupArgs',
    'AzureAppPushReceiverArgs',
    'AzureFunctionReceiverArgs',
    'CriteriaArgs',
    'DataCollectionEndpointNetworkAclsArgs',
    'DataCollectionRuleDataSourcesArgs',
    'DataCollectionRuleDestinationsArgs',
    'DataFlowArgs',
    'DataSourceConfigurationArgs',
    'DataSourceArgs',
    'DestinationsSpecAzureMonitorMetricsArgs',
    'DimensionArgs',
    'DynamicMetricCriteriaArgs',
    'DynamicThresholdFailingPeriodsArgs',
    'EmailNotificationArgs',
    'EmailReceiverArgs',
    'EtwEventConfigurationArgs',
    'EtwProviderConfigurationArgs',
    'EventLogConfigurationArgs',
    'ExtensionDataSourceArgs',
    'ItsmReceiverArgs',
    'LocationThresholdRuleConditionArgs',
    'LogAnalyticsDestinationArgs',
    'LogMetricTriggerArgs',
    'LogSettingsArgs',
    'LogToMetricActionArgs',
    'LogicAppReceiverArgs',
    'ManagementEventAggregationConditionArgs',
    'ManagementEventRuleConditionArgs',
    'ManagementGroupLogSettingsArgs',
    'MetricAlertActionArgs',
    'MetricAlertMultipleResourceMultipleMetricCriteriaArgs',
    'MetricAlertSingleResourceMultipleMetricCriteriaArgs',
    'MetricCriteriaArgs',
    'MetricDimensionArgs',
    'MetricSettingsArgs',
    'MetricTriggerArgs',
    'MyWorkbookManagedIdentityArgs',
    'PerfCounterDataSourceArgs',
    'PerformanceCounterConfigurationArgs',
    'PrivateEndpointPropertyArgs',
    'PrivateLinkServiceConnectionStatePropertyArgs',
    'RecurrenceArgs',
    'RecurrentScheduleArgs',
    'RetentionPolicyArgs',
    'RuleEmailActionArgs',
    'RuleManagementEventClaimsDataSourceArgs',
    'RuleManagementEventDataSourceArgs',
    'RuleMetricDataSourceArgs',
    'RuleWebhookActionArgs',
    'ScaleActionArgs',
    'ScaleCapacityArgs',
    'ScaleRuleMetricDimensionArgs',
    'ScaleRuleArgs',
    'ScheduleArgs',
    'SinkConfigurationArgs',
    'SmsReceiverArgs',
    'SourceArgs',
    'SubscriptionLogSettingsArgs',
    'SyslogDataSourceArgs',
    'ThresholdRuleConditionArgs',
    'TimeWindowArgs',
    'TriggerConditionArgs',
    'VoiceReceiverArgs',
    'WebTestGeolocationArgs',
    'WebTestPropertiesConfigurationArgs',
    'WebhookNotificationArgs',
    'WebhookReceiverArgs',
    'WebtestLocationAvailabilityCriteriaArgs',
    'WindowsEventLogDataSourceArgs',
    'WorkbookManagedIdentityArgs',
    'WorkbookTemplateGalleryArgs',
    'WorkbookTemplateLocalizedGalleryArgs',
]

@pulumi.input_type
class ActionGroupArgs:
    def __init__(__self__, *,
                 action_group_id: pulumi.Input[str],
                 webhook_properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        A pointer to an Azure Action Group.
        :param pulumi.Input[str] action_group_id: The resource ID of the Action Group. This cannot be null or empty.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] webhook_properties: the dictionary of custom properties to include with the post operation. These data are appended to the webhook payload.
        """
        pulumi.set(__self__, "action_group_id", action_group_id)
        if webhook_properties is not None:
            pulumi.set(__self__, "webhook_properties", webhook_properties)

    @property
    @pulumi.getter(name="actionGroupId")
    def action_group_id(self) -> pulumi.Input[str]:
        """
        The resource ID of the Action Group. This cannot be null or empty.
        """
        return pulumi.get(self, "action_group_id")

    @action_group_id.setter
    def action_group_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "action_group_id", value)

    @property
    @pulumi.getter(name="webhookProperties")
    def webhook_properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        the dictionary of custom properties to include with the post operation. These data are appended to the webhook payload.
        """
        return pulumi.get(self, "webhook_properties")

    @webhook_properties.setter
    def webhook_properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "webhook_properties", value)


@pulumi.input_type
class ActionListArgs:
    def __init__(__self__, *,
                 action_groups: Optional[pulumi.Input[Sequence[pulumi.Input['ActionGroupArgs']]]] = None):
        """
        A list of Activity Log Alert rule actions.
        :param pulumi.Input[Sequence[pulumi.Input['ActionGroupArgs']]] action_groups: The list of the Action Groups.
        """
        if action_groups is not None:
            pulumi.set(__self__, "action_groups", action_groups)

    @property
    @pulumi.getter(name="actionGroups")
    def action_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ActionGroupArgs']]]]:
        """
        The list of the Action Groups.
        """
        return pulumi.get(self, "action_groups")

    @action_groups.setter
    def action_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ActionGroupArgs']]]]):
        pulumi.set(self, "action_groups", value)


@pulumi.input_type
class AlertRuleAllOfConditionArgs:
    def __init__(__self__, *,
                 all_of: pulumi.Input[Sequence[pulumi.Input['AlertRuleAnyOfOrLeafConditionArgs']]]):
        """
        An Activity Log Alert rule condition that is met when all its member conditions are met.
        :param pulumi.Input[Sequence[pulumi.Input['AlertRuleAnyOfOrLeafConditionArgs']]] all_of: The list of Activity Log Alert rule conditions.
        """
        pulumi.set(__self__, "all_of", all_of)

    @property
    @pulumi.getter(name="allOf")
    def all_of(self) -> pulumi.Input[Sequence[pulumi.Input['AlertRuleAnyOfOrLeafConditionArgs']]]:
        """
        The list of Activity Log Alert rule conditions.
        """
        return pulumi.get(self, "all_of")

    @all_of.setter
    def all_of(self, value: pulumi.Input[Sequence[pulumi.Input['AlertRuleAnyOfOrLeafConditionArgs']]]):
        pulumi.set(self, "all_of", value)


@pulumi.input_type
class AlertRuleAnyOfOrLeafConditionArgs:
    def __init__(__self__, *,
                 any_of: Optional[pulumi.Input[Sequence[pulumi.Input['AlertRuleLeafConditionArgs']]]] = None,
                 contains_any: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 equals: Optional[pulumi.Input[str]] = None,
                 field: Optional[pulumi.Input[str]] = None):
        """
        An Activity Log Alert rule condition that is met when all its member conditions are met.
        Each condition can be of one of the following types:
        __Important__: Each type has its unique subset of properties. Properties from different types CANNOT exist in one condition.
           * __Leaf Condition -__ must contain 'field' and either 'equals' or 'containsAny'.
          _Please note, 'anyOf' should __not__ be set in a Leaf Condition._
          * __AnyOf Condition -__ must contain __only__ 'anyOf' (which is an array of Leaf Conditions).
          _Please note, 'field', 'equals' and 'containsAny' should __not__ be set in an AnyOf Condition._

        :param pulumi.Input[Sequence[pulumi.Input['AlertRuleLeafConditionArgs']]] any_of: An Activity Log Alert rule condition that is met when at least one of its member leaf conditions are met.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] contains_any: The value of the event's field will be compared to the values in this array (case-insensitive) to determine if the condition is met.
        :param pulumi.Input[str] equals: The value of the event's field will be compared to this value (case-insensitive) to determine if the condition is met.
        :param pulumi.Input[str] field: The name of the Activity Log event's field that this condition will examine.
               The possible values for this field are (case-insensitive): 'resourceId', 'category', 'caller', 'level', 'operationName', 'resourceGroup', 'resourceProvider', 'status', 'subStatus', 'resourceType', or anything beginning with 'properties'.
        """
        if any_of is not None:
            pulumi.set(__self__, "any_of", any_of)
        if contains_any is not None:
            pulumi.set(__self__, "contains_any", contains_any)
        if equals is not None:
            pulumi.set(__self__, "equals", equals)
        if field is not None:
            pulumi.set(__self__, "field", field)

    @property
    @pulumi.getter(name="anyOf")
    def any_of(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlertRuleLeafConditionArgs']]]]:
        """
        An Activity Log Alert rule condition that is met when at least one of its member leaf conditions are met.
        """
        return pulumi.get(self, "any_of")

    @any_of.setter
    def any_of(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlertRuleLeafConditionArgs']]]]):
        pulumi.set(self, "any_of", value)

    @property
    @pulumi.getter(name="containsAny")
    def contains_any(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The value of the event's field will be compared to the values in this array (case-insensitive) to determine if the condition is met.
        """
        return pulumi.get(self, "contains_any")

    @contains_any.setter
    def contains_any(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "contains_any", value)

    @property
    @pulumi.getter
    def equals(self) -> Optional[pulumi.Input[str]]:
        """
        The value of the event's field will be compared to this value (case-insensitive) to determine if the condition is met.
        """
        return pulumi.get(self, "equals")

    @equals.setter
    def equals(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "equals", value)

    @property
    @pulumi.getter
    def field(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Activity Log event's field that this condition will examine.
        The possible values for this field are (case-insensitive): 'resourceId', 'category', 'caller', 'level', 'operationName', 'resourceGroup', 'resourceProvider', 'status', 'subStatus', 'resourceType', or anything beginning with 'properties'.
        """
        return pulumi.get(self, "field")

    @field.setter
    def field(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "field", value)


@pulumi.input_type
class AlertRuleLeafConditionArgs:
    def __init__(__self__, *,
                 contains_any: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 equals: Optional[pulumi.Input[str]] = None,
                 field: Optional[pulumi.Input[str]] = None):
        """
        An Activity Log Alert rule condition that is met by comparing the field and value of an Activity Log event.
        This condition must contain 'field' and either 'equals' or 'containsAny'.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] contains_any: The value of the event's field will be compared to the values in this array (case-insensitive) to determine if the condition is met.
        :param pulumi.Input[str] equals: The value of the event's field will be compared to this value (case-insensitive) to determine if the condition is met.
        :param pulumi.Input[str] field: The name of the Activity Log event's field that this condition will examine.
               The possible values for this field are (case-insensitive): 'resourceId', 'category', 'caller', 'level', 'operationName', 'resourceGroup', 'resourceProvider', 'status', 'subStatus', 'resourceType', or anything beginning with 'properties'.
        """
        if contains_any is not None:
            pulumi.set(__self__, "contains_any", contains_any)
        if equals is not None:
            pulumi.set(__self__, "equals", equals)
        if field is not None:
            pulumi.set(__self__, "field", field)

    @property
    @pulumi.getter(name="containsAny")
    def contains_any(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The value of the event's field will be compared to the values in this array (case-insensitive) to determine if the condition is met.
        """
        return pulumi.get(self, "contains_any")

    @contains_any.setter
    def contains_any(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "contains_any", value)

    @property
    @pulumi.getter
    def equals(self) -> Optional[pulumi.Input[str]]:
        """
        The value of the event's field will be compared to this value (case-insensitive) to determine if the condition is met.
        """
        return pulumi.get(self, "equals")

    @equals.setter
    def equals(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "equals", value)

    @property
    @pulumi.getter
    def field(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Activity Log event's field that this condition will examine.
        The possible values for this field are (case-insensitive): 'resourceId', 'category', 'caller', 'level', 'operationName', 'resourceGroup', 'resourceProvider', 'status', 'subStatus', 'resourceType', or anything beginning with 'properties'.
        """
        return pulumi.get(self, "field")

    @field.setter
    def field(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "field", value)


@pulumi.input_type
class AlertingActionArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str],
                 severity: pulumi.Input[Union[str, 'AlertSeverity']],
                 trigger: pulumi.Input['TriggerConditionArgs'],
                 azns_action: Optional[pulumi.Input['AzNsActionGroupArgs']] = None,
                 throttling_in_min: Optional[pulumi.Input[int]] = None):
        """
        Specify action need to be taken when rule type is Alert
        :param pulumi.Input[str] odata_type: Specifies the action. Supported values - AlertingAction, LogToMetricAction
               Expected value is 'Microsoft.WindowsAzure.Management.Monitoring.Alerts.Models.Microsoft.AppInsights.Nexus.DataContracts.Resources.ScheduledQueryRules.AlertingAction'.
        :param pulumi.Input[Union[str, 'AlertSeverity']] severity: Severity of the alert
        :param pulumi.Input['TriggerConditionArgs'] trigger: The trigger condition that results in the alert rule being.
        :param pulumi.Input['AzNsActionGroupArgs'] azns_action: Azure action group reference.
        :param pulumi.Input[int] throttling_in_min: time (in minutes) for which Alerts should be throttled or suppressed.
        """
        pulumi.set(__self__, "odata_type", 'Microsoft.WindowsAzure.Management.Monitoring.Alerts.Models.Microsoft.AppInsights.Nexus.DataContracts.Resources.ScheduledQueryRules.AlertingAction')
        pulumi.set(__self__, "severity", severity)
        pulumi.set(__self__, "trigger", trigger)
        if azns_action is not None:
            pulumi.set(__self__, "azns_action", azns_action)
        if throttling_in_min is not None:
            pulumi.set(__self__, "throttling_in_min", throttling_in_min)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        Specifies the action. Supported values - AlertingAction, LogToMetricAction
        Expected value is 'Microsoft.WindowsAzure.Management.Monitoring.Alerts.Models.Microsoft.AppInsights.Nexus.DataContracts.Resources.ScheduledQueryRules.AlertingAction'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter
    def severity(self) -> pulumi.Input[Union[str, 'AlertSeverity']]:
        """
        Severity of the alert
        """
        return pulumi.get(self, "severity")

    @severity.setter
    def severity(self, value: pulumi.Input[Union[str, 'AlertSeverity']]):
        pulumi.set(self, "severity", value)

    @property
    @pulumi.getter
    def trigger(self) -> pulumi.Input['TriggerConditionArgs']:
        """
        The trigger condition that results in the alert rule being.
        """
        return pulumi.get(self, "trigger")

    @trigger.setter
    def trigger(self, value: pulumi.Input['TriggerConditionArgs']):
        pulumi.set(self, "trigger", value)

    @property
    @pulumi.getter(name="aznsAction")
    def azns_action(self) -> Optional[pulumi.Input['AzNsActionGroupArgs']]:
        """
        Azure action group reference.
        """
        return pulumi.get(self, "azns_action")

    @azns_action.setter
    def azns_action(self, value: Optional[pulumi.Input['AzNsActionGroupArgs']]):
        pulumi.set(self, "azns_action", value)

    @property
    @pulumi.getter(name="throttlingInMin")
    def throttling_in_min(self) -> Optional[pulumi.Input[int]]:
        """
        time (in minutes) for which Alerts should be throttled or suppressed.
        """
        return pulumi.get(self, "throttling_in_min")

    @throttling_in_min.setter
    def throttling_in_min(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "throttling_in_min", value)


@pulumi.input_type
class ApplicationInsightsComponentAnalyticsItemPropertiesArgs:
    def __init__(__self__, *,
                 function_alias: Optional[pulumi.Input[str]] = None):
        """
        A set of properties that can be defined in the context of a specific item type. Each type may have its own properties.
        :param pulumi.Input[str] function_alias: A function alias, used when the type of the item is Function
        """
        if function_alias is not None:
            pulumi.set(__self__, "function_alias", function_alias)

    @property
    @pulumi.getter(name="functionAlias")
    def function_alias(self) -> Optional[pulumi.Input[str]]:
        """
        A function alias, used when the type of the item is Function
        """
        return pulumi.get(self, "function_alias")

    @function_alias.setter
    def function_alias(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "function_alias", value)


@pulumi.input_type
class ApplicationInsightsComponentDataVolumeCapArgs:
    def __init__(__self__, *,
                 cap: Optional[pulumi.Input[float]] = None,
                 stop_send_notification_when_hit_cap: Optional[pulumi.Input[bool]] = None,
                 stop_send_notification_when_hit_threshold: Optional[pulumi.Input[bool]] = None,
                 warning_threshold: Optional[pulumi.Input[int]] = None):
        """
        An Application Insights component daily data volume cap
        :param pulumi.Input[float] cap: Daily data volume cap in GB.
        :param pulumi.Input[bool] stop_send_notification_when_hit_cap: Do not send a notification email when the daily data volume cap is met.
        :param pulumi.Input[bool] stop_send_notification_when_hit_threshold: Reserved, not used for now.
        :param pulumi.Input[int] warning_threshold: Reserved, not used for now.
        """
        if cap is not None:
            pulumi.set(__self__, "cap", cap)
        if stop_send_notification_when_hit_cap is not None:
            pulumi.set(__self__, "stop_send_notification_when_hit_cap", stop_send_notification_when_hit_cap)
        if stop_send_notification_when_hit_threshold is not None:
            pulumi.set(__self__, "stop_send_notification_when_hit_threshold", stop_send_notification_when_hit_threshold)
        if warning_threshold is not None:
            pulumi.set(__self__, "warning_threshold", warning_threshold)

    @property
    @pulumi.getter
    def cap(self) -> Optional[pulumi.Input[float]]:
        """
        Daily data volume cap in GB.
        """
        return pulumi.get(self, "cap")

    @cap.setter
    def cap(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "cap", value)

    @property
    @pulumi.getter(name="stopSendNotificationWhenHitCap")
    def stop_send_notification_when_hit_cap(self) -> Optional[pulumi.Input[bool]]:
        """
        Do not send a notification email when the daily data volume cap is met.
        """
        return pulumi.get(self, "stop_send_notification_when_hit_cap")

    @stop_send_notification_when_hit_cap.setter
    def stop_send_notification_when_hit_cap(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "stop_send_notification_when_hit_cap", value)

    @property
    @pulumi.getter(name="stopSendNotificationWhenHitThreshold")
    def stop_send_notification_when_hit_threshold(self) -> Optional[pulumi.Input[bool]]:
        """
        Reserved, not used for now.
        """
        return pulumi.get(self, "stop_send_notification_when_hit_threshold")

    @stop_send_notification_when_hit_threshold.setter
    def stop_send_notification_when_hit_threshold(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "stop_send_notification_when_hit_threshold", value)

    @property
    @pulumi.getter(name="warningThreshold")
    def warning_threshold(self) -> Optional[pulumi.Input[int]]:
        """
        Reserved, not used for now.
        """
        return pulumi.get(self, "warning_threshold")

    @warning_threshold.setter
    def warning_threshold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "warning_threshold", value)


@pulumi.input_type
class ApplicationInsightsComponentProactiveDetectionConfigurationRuleDefinitionsArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 help_url: Optional[pulumi.Input[str]] = None,
                 is_enabled_by_default: Optional[pulumi.Input[bool]] = None,
                 is_hidden: Optional[pulumi.Input[bool]] = None,
                 is_in_preview: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 supports_email_notifications: Optional[pulumi.Input[bool]] = None):
        """
        Static definitions of the ProactiveDetection configuration rule (same values for all components).
        :param pulumi.Input[str] description: The rule description
        :param pulumi.Input[str] display_name: The rule name as it is displayed in UI
        :param pulumi.Input[str] help_url: URL which displays additional info about the proactive detection rule
        :param pulumi.Input[bool] is_enabled_by_default: A flag indicating whether the rule is enabled by default
        :param pulumi.Input[bool] is_hidden: A flag indicating whether the rule is hidden (from the UI)
        :param pulumi.Input[bool] is_in_preview: A flag indicating whether the rule is in preview
        :param pulumi.Input[str] name: The rule name
        :param pulumi.Input[bool] supports_email_notifications: A flag indicating whether email notifications are supported for detections for this rule
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if help_url is not None:
            pulumi.set(__self__, "help_url", help_url)
        if is_enabled_by_default is not None:
            pulumi.set(__self__, "is_enabled_by_default", is_enabled_by_default)
        if is_hidden is not None:
            pulumi.set(__self__, "is_hidden", is_hidden)
        if is_in_preview is not None:
            pulumi.set(__self__, "is_in_preview", is_in_preview)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if supports_email_notifications is not None:
            pulumi.set(__self__, "supports_email_notifications", supports_email_notifications)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The rule description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        The rule name as it is displayed in UI
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="helpUrl")
    def help_url(self) -> Optional[pulumi.Input[str]]:
        """
        URL which displays additional info about the proactive detection rule
        """
        return pulumi.get(self, "help_url")

    @help_url.setter
    def help_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "help_url", value)

    @property
    @pulumi.getter(name="isEnabledByDefault")
    def is_enabled_by_default(self) -> Optional[pulumi.Input[bool]]:
        """
        A flag indicating whether the rule is enabled by default
        """
        return pulumi.get(self, "is_enabled_by_default")

    @is_enabled_by_default.setter
    def is_enabled_by_default(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_enabled_by_default", value)

    @property
    @pulumi.getter(name="isHidden")
    def is_hidden(self) -> Optional[pulumi.Input[bool]]:
        """
        A flag indicating whether the rule is hidden (from the UI)
        """
        return pulumi.get(self, "is_hidden")

    @is_hidden.setter
    def is_hidden(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_hidden", value)

    @property
    @pulumi.getter(name="isInPreview")
    def is_in_preview(self) -> Optional[pulumi.Input[bool]]:
        """
        A flag indicating whether the rule is in preview
        """
        return pulumi.get(self, "is_in_preview")

    @is_in_preview.setter
    def is_in_preview(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_in_preview", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The rule name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="supportsEmailNotifications")
    def supports_email_notifications(self) -> Optional[pulumi.Input[bool]]:
        """
        A flag indicating whether email notifications are supported for detections for this rule
        """
        return pulumi.get(self, "supports_email_notifications")

    @supports_email_notifications.setter
    def supports_email_notifications(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "supports_email_notifications", value)


@pulumi.input_type
class ArmRoleReceiverArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 role_id: pulumi.Input[str],
                 use_common_alert_schema: Optional[pulumi.Input[bool]] = None):
        """
        An arm role receiver.
        :param pulumi.Input[str] name: The name of the arm role receiver. Names must be unique across all receivers within an action group.
        :param pulumi.Input[str] role_id: The arm role id.
        :param pulumi.Input[bool] use_common_alert_schema: Indicates whether to use common alert schema.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "role_id", role_id)
        if use_common_alert_schema is None:
            use_common_alert_schema = False
        if use_common_alert_schema is not None:
            pulumi.set(__self__, "use_common_alert_schema", use_common_alert_schema)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the arm role receiver. Names must be unique across all receivers within an action group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="roleId")
    def role_id(self) -> pulumi.Input[str]:
        """
        The arm role id.
        """
        return pulumi.get(self, "role_id")

    @role_id.setter
    def role_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "role_id", value)

    @property
    @pulumi.getter(name="useCommonAlertSchema")
    def use_common_alert_schema(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether to use common alert schema.
        """
        return pulumi.get(self, "use_common_alert_schema")

    @use_common_alert_schema.setter
    def use_common_alert_schema(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_common_alert_schema", value)


@pulumi.input_type
class AutomationRunbookReceiverArgs:
    def __init__(__self__, *,
                 automation_account_id: pulumi.Input[str],
                 is_global_runbook: pulumi.Input[bool],
                 runbook_name: pulumi.Input[str],
                 webhook_resource_id: pulumi.Input[str],
                 name: Optional[pulumi.Input[str]] = None,
                 service_uri: Optional[pulumi.Input[str]] = None,
                 use_common_alert_schema: Optional[pulumi.Input[bool]] = None):
        """
        The Azure Automation Runbook notification receiver.
        :param pulumi.Input[str] automation_account_id: The Azure automation account Id which holds this runbook and authenticate to Azure resource.
        :param pulumi.Input[bool] is_global_runbook: Indicates whether this instance is global runbook.
        :param pulumi.Input[str] runbook_name: The name for this runbook.
        :param pulumi.Input[str] webhook_resource_id: The resource id for webhook linked to this runbook.
        :param pulumi.Input[str] name: Indicates name of the webhook.
        :param pulumi.Input[str] service_uri: The URI where webhooks should be sent.
        :param pulumi.Input[bool] use_common_alert_schema: Indicates whether to use common alert schema.
        """
        pulumi.set(__self__, "automation_account_id", automation_account_id)
        pulumi.set(__self__, "is_global_runbook", is_global_runbook)
        pulumi.set(__self__, "runbook_name", runbook_name)
        pulumi.set(__self__, "webhook_resource_id", webhook_resource_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if service_uri is not None:
            pulumi.set(__self__, "service_uri", service_uri)
        if use_common_alert_schema is None:
            use_common_alert_schema = False
        if use_common_alert_schema is not None:
            pulumi.set(__self__, "use_common_alert_schema", use_common_alert_schema)

    @property
    @pulumi.getter(name="automationAccountId")
    def automation_account_id(self) -> pulumi.Input[str]:
        """
        The Azure automation account Id which holds this runbook and authenticate to Azure resource.
        """
        return pulumi.get(self, "automation_account_id")

    @automation_account_id.setter
    def automation_account_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "automation_account_id", value)

    @property
    @pulumi.getter(name="isGlobalRunbook")
    def is_global_runbook(self) -> pulumi.Input[bool]:
        """
        Indicates whether this instance is global runbook.
        """
        return pulumi.get(self, "is_global_runbook")

    @is_global_runbook.setter
    def is_global_runbook(self, value: pulumi.Input[bool]):
        pulumi.set(self, "is_global_runbook", value)

    @property
    @pulumi.getter(name="runbookName")
    def runbook_name(self) -> pulumi.Input[str]:
        """
        The name for this runbook.
        """
        return pulumi.get(self, "runbook_name")

    @runbook_name.setter
    def runbook_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "runbook_name", value)

    @property
    @pulumi.getter(name="webhookResourceId")
    def webhook_resource_id(self) -> pulumi.Input[str]:
        """
        The resource id for webhook linked to this runbook.
        """
        return pulumi.get(self, "webhook_resource_id")

    @webhook_resource_id.setter
    def webhook_resource_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "webhook_resource_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates name of the webhook.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="serviceUri")
    def service_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The URI where webhooks should be sent.
        """
        return pulumi.get(self, "service_uri")

    @service_uri.setter
    def service_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_uri", value)

    @property
    @pulumi.getter(name="useCommonAlertSchema")
    def use_common_alert_schema(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether to use common alert schema.
        """
        return pulumi.get(self, "use_common_alert_schema")

    @use_common_alert_schema.setter
    def use_common_alert_schema(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_common_alert_schema", value)


@pulumi.input_type
class AutoscaleNotificationArgs:
    def __init__(__self__, *,
                 operation: pulumi.Input['OperationType'],
                 email: Optional[pulumi.Input['EmailNotificationArgs']] = None,
                 webhooks: Optional[pulumi.Input[Sequence[pulumi.Input['WebhookNotificationArgs']]]] = None):
        """
        Autoscale notification.
        :param pulumi.Input['OperationType'] operation: the operation associated with the notification and its value must be "scale"
        :param pulumi.Input['EmailNotificationArgs'] email: the email notification.
        :param pulumi.Input[Sequence[pulumi.Input['WebhookNotificationArgs']]] webhooks: the collection of webhook notifications.
        """
        pulumi.set(__self__, "operation", operation)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if webhooks is not None:
            pulumi.set(__self__, "webhooks", webhooks)

    @property
    @pulumi.getter
    def operation(self) -> pulumi.Input['OperationType']:
        """
        the operation associated with the notification and its value must be "scale"
        """
        return pulumi.get(self, "operation")

    @operation.setter
    def operation(self, value: pulumi.Input['OperationType']):
        pulumi.set(self, "operation", value)

    @property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input['EmailNotificationArgs']]:
        """
        the email notification.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input['EmailNotificationArgs']]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter
    def webhooks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WebhookNotificationArgs']]]]:
        """
        the collection of webhook notifications.
        """
        return pulumi.get(self, "webhooks")

    @webhooks.setter
    def webhooks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WebhookNotificationArgs']]]]):
        pulumi.set(self, "webhooks", value)


@pulumi.input_type
class AutoscaleProfileArgs:
    def __init__(__self__, *,
                 capacity: pulumi.Input['ScaleCapacityArgs'],
                 name: pulumi.Input[str],
                 rules: pulumi.Input[Sequence[pulumi.Input['ScaleRuleArgs']]],
                 fixed_date: Optional[pulumi.Input['TimeWindowArgs']] = None,
                 recurrence: Optional[pulumi.Input['RecurrenceArgs']] = None):
        """
        Autoscale profile.
        :param pulumi.Input['ScaleCapacityArgs'] capacity: the number of instances that can be used during this profile.
        :param pulumi.Input[str] name: the name of the profile.
        :param pulumi.Input[Sequence[pulumi.Input['ScaleRuleArgs']]] rules: the collection of rules that provide the triggers and parameters for the scaling action. A maximum of 10 rules can be specified.
        :param pulumi.Input['TimeWindowArgs'] fixed_date: the specific date-time for the profile. This element is not used if the Recurrence element is used.
        :param pulumi.Input['RecurrenceArgs'] recurrence: the repeating times at which this profile begins. This element is not used if the FixedDate element is used.
        """
        pulumi.set(__self__, "capacity", capacity)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "rules", rules)
        if fixed_date is not None:
            pulumi.set(__self__, "fixed_date", fixed_date)
        if recurrence is not None:
            pulumi.set(__self__, "recurrence", recurrence)

    @property
    @pulumi.getter
    def capacity(self) -> pulumi.Input['ScaleCapacityArgs']:
        """
        the number of instances that can be used during this profile.
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: pulumi.Input['ScaleCapacityArgs']):
        pulumi.set(self, "capacity", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        the name of the profile.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def rules(self) -> pulumi.Input[Sequence[pulumi.Input['ScaleRuleArgs']]]:
        """
        the collection of rules that provide the triggers and parameters for the scaling action. A maximum of 10 rules can be specified.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: pulumi.Input[Sequence[pulumi.Input['ScaleRuleArgs']]]):
        pulumi.set(self, "rules", value)

    @property
    @pulumi.getter(name="fixedDate")
    def fixed_date(self) -> Optional[pulumi.Input['TimeWindowArgs']]:
        """
        the specific date-time for the profile. This element is not used if the Recurrence element is used.
        """
        return pulumi.get(self, "fixed_date")

    @fixed_date.setter
    def fixed_date(self, value: Optional[pulumi.Input['TimeWindowArgs']]):
        pulumi.set(self, "fixed_date", value)

    @property
    @pulumi.getter
    def recurrence(self) -> Optional[pulumi.Input['RecurrenceArgs']]:
        """
        the repeating times at which this profile begins. This element is not used if the FixedDate element is used.
        """
        return pulumi.get(self, "recurrence")

    @recurrence.setter
    def recurrence(self, value: Optional[pulumi.Input['RecurrenceArgs']]):
        pulumi.set(self, "recurrence", value)


@pulumi.input_type
class AzNsActionGroupArgs:
    def __init__(__self__, *,
                 action_group: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 custom_webhook_payload: Optional[pulumi.Input[str]] = None,
                 email_subject: Optional[pulumi.Input[str]] = None):
        """
        Azure action group
        :param pulumi.Input[Sequence[pulumi.Input[str]]] action_group: Azure Action Group reference.
        :param pulumi.Input[str] custom_webhook_payload: Custom payload to be sent for all webhook URI in Azure action group
        :param pulumi.Input[str] email_subject: Custom subject override for all email ids in Azure action group
        """
        if action_group is not None:
            pulumi.set(__self__, "action_group", action_group)
        if custom_webhook_payload is not None:
            pulumi.set(__self__, "custom_webhook_payload", custom_webhook_payload)
        if email_subject is not None:
            pulumi.set(__self__, "email_subject", email_subject)

    @property
    @pulumi.getter(name="actionGroup")
    def action_group(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Azure Action Group reference.
        """
        return pulumi.get(self, "action_group")

    @action_group.setter
    def action_group(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "action_group", value)

    @property
    @pulumi.getter(name="customWebhookPayload")
    def custom_webhook_payload(self) -> Optional[pulumi.Input[str]]:
        """
        Custom payload to be sent for all webhook URI in Azure action group
        """
        return pulumi.get(self, "custom_webhook_payload")

    @custom_webhook_payload.setter
    def custom_webhook_payload(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_webhook_payload", value)

    @property
    @pulumi.getter(name="emailSubject")
    def email_subject(self) -> Optional[pulumi.Input[str]]:
        """
        Custom subject override for all email ids in Azure action group
        """
        return pulumi.get(self, "email_subject")

    @email_subject.setter
    def email_subject(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email_subject", value)


@pulumi.input_type
class AzureAppPushReceiverArgs:
    def __init__(__self__, *,
                 email_address: pulumi.Input[str],
                 name: pulumi.Input[str]):
        """
        The Azure mobile App push notification receiver.
        :param pulumi.Input[str] email_address: The email address registered for the Azure mobile app.
        :param pulumi.Input[str] name: The name of the Azure mobile app push receiver. Names must be unique across all receivers within an action group.
        """
        pulumi.set(__self__, "email_address", email_address)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="emailAddress")
    def email_address(self) -> pulumi.Input[str]:
        """
        The email address registered for the Azure mobile app.
        """
        return pulumi.get(self, "email_address")

    @email_address.setter
    def email_address(self, value: pulumi.Input[str]):
        pulumi.set(self, "email_address", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the Azure mobile app push receiver. Names must be unique across all receivers within an action group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class AzureFunctionReceiverArgs:
    def __init__(__self__, *,
                 function_app_resource_id: pulumi.Input[str],
                 function_name: pulumi.Input[str],
                 http_trigger_url: pulumi.Input[str],
                 name: pulumi.Input[str],
                 use_common_alert_schema: Optional[pulumi.Input[bool]] = None):
        """
        An azure function receiver.
        :param pulumi.Input[str] function_app_resource_id: The azure resource id of the function app.
        :param pulumi.Input[str] function_name: The function name in the function app.
        :param pulumi.Input[str] http_trigger_url: The http trigger url where http request sent to.
        :param pulumi.Input[str] name: The name of the azure function receiver. Names must be unique across all receivers within an action group.
        :param pulumi.Input[bool] use_common_alert_schema: Indicates whether to use common alert schema.
        """
        pulumi.set(__self__, "function_app_resource_id", function_app_resource_id)
        pulumi.set(__self__, "function_name", function_name)
        pulumi.set(__self__, "http_trigger_url", http_trigger_url)
        pulumi.set(__self__, "name", name)
        if use_common_alert_schema is None:
            use_common_alert_schema = False
        if use_common_alert_schema is not None:
            pulumi.set(__self__, "use_common_alert_schema", use_common_alert_schema)

    @property
    @pulumi.getter(name="functionAppResourceId")
    def function_app_resource_id(self) -> pulumi.Input[str]:
        """
        The azure resource id of the function app.
        """
        return pulumi.get(self, "function_app_resource_id")

    @function_app_resource_id.setter
    def function_app_resource_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "function_app_resource_id", value)

    @property
    @pulumi.getter(name="functionName")
    def function_name(self) -> pulumi.Input[str]:
        """
        The function name in the function app.
        """
        return pulumi.get(self, "function_name")

    @function_name.setter
    def function_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "function_name", value)

    @property
    @pulumi.getter(name="httpTriggerUrl")
    def http_trigger_url(self) -> pulumi.Input[str]:
        """
        The http trigger url where http request sent to.
        """
        return pulumi.get(self, "http_trigger_url")

    @http_trigger_url.setter
    def http_trigger_url(self, value: pulumi.Input[str]):
        pulumi.set(self, "http_trigger_url", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the azure function receiver. Names must be unique across all receivers within an action group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="useCommonAlertSchema")
    def use_common_alert_schema(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether to use common alert schema.
        """
        return pulumi.get(self, "use_common_alert_schema")

    @use_common_alert_schema.setter
    def use_common_alert_schema(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_common_alert_schema", value)


@pulumi.input_type
class CriteriaArgs:
    def __init__(__self__, *,
                 metric_name: pulumi.Input[str],
                 dimensions: Optional[pulumi.Input[Sequence[pulumi.Input['DimensionArgs']]]] = None):
        """
        Specifies the criteria for converting log to metric.
        :param pulumi.Input[str] metric_name: Name of the metric
        :param pulumi.Input[Sequence[pulumi.Input['DimensionArgs']]] dimensions: List of Dimensions for creating metric
        """
        pulumi.set(__self__, "metric_name", metric_name)
        if dimensions is not None:
            pulumi.set(__self__, "dimensions", dimensions)

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> pulumi.Input[str]:
        """
        Name of the metric
        """
        return pulumi.get(self, "metric_name")

    @metric_name.setter
    def metric_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "metric_name", value)

    @property
    @pulumi.getter
    def dimensions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DimensionArgs']]]]:
        """
        List of Dimensions for creating metric
        """
        return pulumi.get(self, "dimensions")

    @dimensions.setter
    def dimensions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DimensionArgs']]]]):
        pulumi.set(self, "dimensions", value)


@pulumi.input_type
class DataCollectionEndpointNetworkAclsArgs:
    def __init__(__self__, *,
                 public_network_access: Optional[pulumi.Input[Union[str, 'KnownPublicNetworkAccessOptions']]] = None):
        """
        Network access control rules for the endpoints.
        :param pulumi.Input[Union[str, 'KnownPublicNetworkAccessOptions']] public_network_access: The configuration to set whether network access from public internet to the endpoints are allowed.
        """
        if public_network_access is not None:
            pulumi.set(__self__, "public_network_access", public_network_access)

    @property
    @pulumi.getter(name="publicNetworkAccess")
    def public_network_access(self) -> Optional[pulumi.Input[Union[str, 'KnownPublicNetworkAccessOptions']]]:
        """
        The configuration to set whether network access from public internet to the endpoints are allowed.
        """
        return pulumi.get(self, "public_network_access")

    @public_network_access.setter
    def public_network_access(self, value: Optional[pulumi.Input[Union[str, 'KnownPublicNetworkAccessOptions']]]):
        pulumi.set(self, "public_network_access", value)


@pulumi.input_type
class DataCollectionRuleDataSourcesArgs:
    def __init__(__self__, *,
                 extensions: Optional[pulumi.Input[Sequence[pulumi.Input['ExtensionDataSourceArgs']]]] = None,
                 performance_counters: Optional[pulumi.Input[Sequence[pulumi.Input['PerfCounterDataSourceArgs']]]] = None,
                 syslog: Optional[pulumi.Input[Sequence[pulumi.Input['SyslogDataSourceArgs']]]] = None,
                 windows_event_logs: Optional[pulumi.Input[Sequence[pulumi.Input['WindowsEventLogDataSourceArgs']]]] = None):
        """
        The specification of data sources. 
        This property is optional and can be omitted if the rule is meant to be used via direct calls to the provisioned endpoint.
        :param pulumi.Input[Sequence[pulumi.Input['ExtensionDataSourceArgs']]] extensions: The list of Azure VM extension data source configurations.
        :param pulumi.Input[Sequence[pulumi.Input['PerfCounterDataSourceArgs']]] performance_counters: The list of performance counter data source configurations.
        :param pulumi.Input[Sequence[pulumi.Input['SyslogDataSourceArgs']]] syslog: The list of Syslog data source configurations.
        :param pulumi.Input[Sequence[pulumi.Input['WindowsEventLogDataSourceArgs']]] windows_event_logs: The list of Windows Event Log data source configurations.
        """
        if extensions is not None:
            pulumi.set(__self__, "extensions", extensions)
        if performance_counters is not None:
            pulumi.set(__self__, "performance_counters", performance_counters)
        if syslog is not None:
            pulumi.set(__self__, "syslog", syslog)
        if windows_event_logs is not None:
            pulumi.set(__self__, "windows_event_logs", windows_event_logs)

    @property
    @pulumi.getter
    def extensions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ExtensionDataSourceArgs']]]]:
        """
        The list of Azure VM extension data source configurations.
        """
        return pulumi.get(self, "extensions")

    @extensions.setter
    def extensions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ExtensionDataSourceArgs']]]]):
        pulumi.set(self, "extensions", value)

    @property
    @pulumi.getter(name="performanceCounters")
    def performance_counters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PerfCounterDataSourceArgs']]]]:
        """
        The list of performance counter data source configurations.
        """
        return pulumi.get(self, "performance_counters")

    @performance_counters.setter
    def performance_counters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PerfCounterDataSourceArgs']]]]):
        pulumi.set(self, "performance_counters", value)

    @property
    @pulumi.getter
    def syslog(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SyslogDataSourceArgs']]]]:
        """
        The list of Syslog data source configurations.
        """
        return pulumi.get(self, "syslog")

    @syslog.setter
    def syslog(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SyslogDataSourceArgs']]]]):
        pulumi.set(self, "syslog", value)

    @property
    @pulumi.getter(name="windowsEventLogs")
    def windows_event_logs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WindowsEventLogDataSourceArgs']]]]:
        """
        The list of Windows Event Log data source configurations.
        """
        return pulumi.get(self, "windows_event_logs")

    @windows_event_logs.setter
    def windows_event_logs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WindowsEventLogDataSourceArgs']]]]):
        pulumi.set(self, "windows_event_logs", value)


@pulumi.input_type
class DataCollectionRuleDestinationsArgs:
    def __init__(__self__, *,
                 azure_monitor_metrics: Optional[pulumi.Input['DestinationsSpecAzureMonitorMetricsArgs']] = None,
                 log_analytics: Optional[pulumi.Input[Sequence[pulumi.Input['LogAnalyticsDestinationArgs']]]] = None):
        """
        The specification of destinations.
        :param pulumi.Input['DestinationsSpecAzureMonitorMetricsArgs'] azure_monitor_metrics: Azure Monitor Metrics destination.
        :param pulumi.Input[Sequence[pulumi.Input['LogAnalyticsDestinationArgs']]] log_analytics: List of Log Analytics destinations.
        """
        if azure_monitor_metrics is not None:
            pulumi.set(__self__, "azure_monitor_metrics", azure_monitor_metrics)
        if log_analytics is not None:
            pulumi.set(__self__, "log_analytics", log_analytics)

    @property
    @pulumi.getter(name="azureMonitorMetrics")
    def azure_monitor_metrics(self) -> Optional[pulumi.Input['DestinationsSpecAzureMonitorMetricsArgs']]:
        """
        Azure Monitor Metrics destination.
        """
        return pulumi.get(self, "azure_monitor_metrics")

    @azure_monitor_metrics.setter
    def azure_monitor_metrics(self, value: Optional[pulumi.Input['DestinationsSpecAzureMonitorMetricsArgs']]):
        pulumi.set(self, "azure_monitor_metrics", value)

    @property
    @pulumi.getter(name="logAnalytics")
    def log_analytics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LogAnalyticsDestinationArgs']]]]:
        """
        List of Log Analytics destinations.
        """
        return pulumi.get(self, "log_analytics")

    @log_analytics.setter
    def log_analytics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LogAnalyticsDestinationArgs']]]]):
        pulumi.set(self, "log_analytics", value)


@pulumi.input_type
class DataFlowArgs:
    def __init__(__self__, *,
                 destinations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 streams: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'KnownDataFlowStreams']]]]] = None):
        """
        Definition of which streams are sent to which destinations.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] destinations: List of destinations for this data flow.
        :param pulumi.Input[Sequence[pulumi.Input[Union[str, 'KnownDataFlowStreams']]]] streams: List of streams for this data flow.
        """
        if destinations is not None:
            pulumi.set(__self__, "destinations", destinations)
        if streams is not None:
            pulumi.set(__self__, "streams", streams)

    @property
    @pulumi.getter
    def destinations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of destinations for this data flow.
        """
        return pulumi.get(self, "destinations")

    @destinations.setter
    def destinations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "destinations", value)

    @property
    @pulumi.getter
    def streams(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'KnownDataFlowStreams']]]]]:
        """
        List of streams for this data flow.
        """
        return pulumi.get(self, "streams")

    @streams.setter
    def streams(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'KnownDataFlowStreams']]]]]):
        pulumi.set(self, "streams", value)


@pulumi.input_type
class DataSourceConfigurationArgs:
    def __init__(__self__, *,
                 event_logs: Optional[pulumi.Input[Sequence[pulumi.Input['EventLogConfigurationArgs']]]] = None,
                 perf_counters: Optional[pulumi.Input[Sequence[pulumi.Input['PerformanceCounterConfigurationArgs']]]] = None,
                 providers: Optional[pulumi.Input[Sequence[pulumi.Input['EtwProviderConfigurationArgs']]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['EventLogConfigurationArgs']]] event_logs: Windows event logs configuration.
        :param pulumi.Input[Sequence[pulumi.Input['PerformanceCounterConfigurationArgs']]] perf_counters: Performance counter configuration
        :param pulumi.Input[Sequence[pulumi.Input['EtwProviderConfigurationArgs']]] providers: ETW providers configuration
        """
        if event_logs is not None:
            pulumi.set(__self__, "event_logs", event_logs)
        if perf_counters is not None:
            pulumi.set(__self__, "perf_counters", perf_counters)
        if providers is not None:
            pulumi.set(__self__, "providers", providers)

    @property
    @pulumi.getter(name="eventLogs")
    def event_logs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EventLogConfigurationArgs']]]]:
        """
        Windows event logs configuration.
        """
        return pulumi.get(self, "event_logs")

    @event_logs.setter
    def event_logs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EventLogConfigurationArgs']]]]):
        pulumi.set(self, "event_logs", value)

    @property
    @pulumi.getter(name="perfCounters")
    def perf_counters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PerformanceCounterConfigurationArgs']]]]:
        """
        Performance counter configuration
        """
        return pulumi.get(self, "perf_counters")

    @perf_counters.setter
    def perf_counters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PerformanceCounterConfigurationArgs']]]]):
        pulumi.set(self, "perf_counters", value)

    @property
    @pulumi.getter
    def providers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EtwProviderConfigurationArgs']]]]:
        """
        ETW providers configuration
        """
        return pulumi.get(self, "providers")

    @providers.setter
    def providers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EtwProviderConfigurationArgs']]]]):
        pulumi.set(self, "providers", value)


@pulumi.input_type
class DataSourceArgs:
    def __init__(__self__, *,
                 configuration: pulumi.Input['DataSourceConfigurationArgs'],
                 kind: pulumi.Input[str],
                 sinks: pulumi.Input[Sequence[pulumi.Input['SinkConfigurationArgs']]]):
        """
        Data source object contains configuration to collect telemetry and one or more sinks to send that telemetry data to
        :param pulumi.Input[str] kind: Datasource kind
        """
        pulumi.set(__self__, "configuration", configuration)
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "sinks", sinks)

    @property
    @pulumi.getter
    def configuration(self) -> pulumi.Input['DataSourceConfigurationArgs']:
        return pulumi.get(self, "configuration")

    @configuration.setter
    def configuration(self, value: pulumi.Input['DataSourceConfigurationArgs']):
        pulumi.set(self, "configuration", value)

    @property
    @pulumi.getter
    def kind(self) -> pulumi.Input[str]:
        """
        Datasource kind
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: pulumi.Input[str]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def sinks(self) -> pulumi.Input[Sequence[pulumi.Input['SinkConfigurationArgs']]]:
        return pulumi.get(self, "sinks")

    @sinks.setter
    def sinks(self, value: pulumi.Input[Sequence[pulumi.Input['SinkConfigurationArgs']]]):
        pulumi.set(self, "sinks", value)


@pulumi.input_type
class DestinationsSpecAzureMonitorMetricsArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None):
        """
        Azure Monitor Metrics destination.
        :param pulumi.Input[str] name: A friendly name for the destination. 
               This name should be unique across all destinations (regardless of type) within the data collection rule.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A friendly name for the destination. 
        This name should be unique across all destinations (regardless of type) within the data collection rule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class DimensionArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 operator: pulumi.Input[Union[str, 'Operator']],
                 values: pulumi.Input[Sequence[pulumi.Input[str]]]):
        """
        Specifies the criteria for converting log to metric.
        :param pulumi.Input[str] name: Name of the dimension
        :param pulumi.Input[Union[str, 'Operator']] operator: Operator for dimension values
        :param pulumi.Input[Sequence[pulumi.Input[str]]] values: List of dimension values
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "operator", operator)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Name of the dimension
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def operator(self) -> pulumi.Input[Union[str, 'Operator']]:
        """
        Operator for dimension values
        """
        return pulumi.get(self, "operator")

    @operator.setter
    def operator(self, value: pulumi.Input[Union[str, 'Operator']]):
        pulumi.set(self, "operator", value)

    @property
    @pulumi.getter
    def values(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        List of dimension values
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class DynamicMetricCriteriaArgs:
    def __init__(__self__, *,
                 alert_sensitivity: pulumi.Input[Union[str, 'DynamicThresholdSensitivity']],
                 criterion_type: pulumi.Input[str],
                 failing_periods: pulumi.Input['DynamicThresholdFailingPeriodsArgs'],
                 metric_name: pulumi.Input[str],
                 name: pulumi.Input[str],
                 operator: pulumi.Input[Union[str, 'DynamicThresholdOperator']],
                 time_aggregation: pulumi.Input[Union[str, 'AggregationTypeEnum']],
                 dimensions: Optional[pulumi.Input[Sequence[pulumi.Input['MetricDimensionArgs']]]] = None,
                 ignore_data_before: Optional[pulumi.Input[str]] = None,
                 metric_namespace: Optional[pulumi.Input[str]] = None,
                 skip_metric_validation: Optional[pulumi.Input[bool]] = None):
        """
        Criterion for dynamic threshold.
        :param pulumi.Input[Union[str, 'DynamicThresholdSensitivity']] alert_sensitivity: The extent of deviation required to trigger an alert. This will affect how tight the threshold is to the metric series pattern.
        :param pulumi.Input[str] criterion_type: Specifies the type of threshold criteria
               Expected value is 'DynamicThresholdCriterion'.
        :param pulumi.Input['DynamicThresholdFailingPeriodsArgs'] failing_periods: The minimum number of violations required within the selected lookback time window required to raise an alert.
        :param pulumi.Input[str] metric_name: Name of the metric.
        :param pulumi.Input[str] name: Name of the criteria.
        :param pulumi.Input[Union[str, 'DynamicThresholdOperator']] operator: The operator used to compare the metric value against the threshold.
        :param pulumi.Input[Union[str, 'AggregationTypeEnum']] time_aggregation: the criteria time aggregation types.
        :param pulumi.Input[Sequence[pulumi.Input['MetricDimensionArgs']]] dimensions: List of dimension conditions.
        :param pulumi.Input[str] ignore_data_before: Use this option to set the date from which to start learning the metric historical data and calculate the dynamic thresholds (in ISO8601 format)
        :param pulumi.Input[str] metric_namespace: Namespace of the metric.
        :param pulumi.Input[bool] skip_metric_validation: Allows creating an alert rule on a custom metric that isn't yet emitted, by causing the metric validation to be skipped.
        """
        pulumi.set(__self__, "alert_sensitivity", alert_sensitivity)
        pulumi.set(__self__, "criterion_type", 'DynamicThresholdCriterion')
        pulumi.set(__self__, "failing_periods", failing_periods)
        pulumi.set(__self__, "metric_name", metric_name)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "operator", operator)
        pulumi.set(__self__, "time_aggregation", time_aggregation)
        if dimensions is not None:
            pulumi.set(__self__, "dimensions", dimensions)
        if ignore_data_before is not None:
            pulumi.set(__self__, "ignore_data_before", ignore_data_before)
        if metric_namespace is not None:
            pulumi.set(__self__, "metric_namespace", metric_namespace)
        if skip_metric_validation is not None:
            pulumi.set(__self__, "skip_metric_validation", skip_metric_validation)

    @property
    @pulumi.getter(name="alertSensitivity")
    def alert_sensitivity(self) -> pulumi.Input[Union[str, 'DynamicThresholdSensitivity']]:
        """
        The extent of deviation required to trigger an alert. This will affect how tight the threshold is to the metric series pattern.
        """
        return pulumi.get(self, "alert_sensitivity")

    @alert_sensitivity.setter
    def alert_sensitivity(self, value: pulumi.Input[Union[str, 'DynamicThresholdSensitivity']]):
        pulumi.set(self, "alert_sensitivity", value)

    @property
    @pulumi.getter(name="criterionType")
    def criterion_type(self) -> pulumi.Input[str]:
        """
        Specifies the type of threshold criteria
        Expected value is 'DynamicThresholdCriterion'.
        """
        return pulumi.get(self, "criterion_type")

    @criterion_type.setter
    def criterion_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "criterion_type", value)

    @property
    @pulumi.getter(name="failingPeriods")
    def failing_periods(self) -> pulumi.Input['DynamicThresholdFailingPeriodsArgs']:
        """
        The minimum number of violations required within the selected lookback time window required to raise an alert.
        """
        return pulumi.get(self, "failing_periods")

    @failing_periods.setter
    def failing_periods(self, value: pulumi.Input['DynamicThresholdFailingPeriodsArgs']):
        pulumi.set(self, "failing_periods", value)

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> pulumi.Input[str]:
        """
        Name of the metric.
        """
        return pulumi.get(self, "metric_name")

    @metric_name.setter
    def metric_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "metric_name", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Name of the criteria.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def operator(self) -> pulumi.Input[Union[str, 'DynamicThresholdOperator']]:
        """
        The operator used to compare the metric value against the threshold.
        """
        return pulumi.get(self, "operator")

    @operator.setter
    def operator(self, value: pulumi.Input[Union[str, 'DynamicThresholdOperator']]):
        pulumi.set(self, "operator", value)

    @property
    @pulumi.getter(name="timeAggregation")
    def time_aggregation(self) -> pulumi.Input[Union[str, 'AggregationTypeEnum']]:
        """
        the criteria time aggregation types.
        """
        return pulumi.get(self, "time_aggregation")

    @time_aggregation.setter
    def time_aggregation(self, value: pulumi.Input[Union[str, 'AggregationTypeEnum']]):
        pulumi.set(self, "time_aggregation", value)

    @property
    @pulumi.getter
    def dimensions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MetricDimensionArgs']]]]:
        """
        List of dimension conditions.
        """
        return pulumi.get(self, "dimensions")

    @dimensions.setter
    def dimensions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MetricDimensionArgs']]]]):
        pulumi.set(self, "dimensions", value)

    @property
    @pulumi.getter(name="ignoreDataBefore")
    def ignore_data_before(self) -> Optional[pulumi.Input[str]]:
        """
        Use this option to set the date from which to start learning the metric historical data and calculate the dynamic thresholds (in ISO8601 format)
        """
        return pulumi.get(self, "ignore_data_before")

    @ignore_data_before.setter
    def ignore_data_before(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ignore_data_before", value)

    @property
    @pulumi.getter(name="metricNamespace")
    def metric_namespace(self) -> Optional[pulumi.Input[str]]:
        """
        Namespace of the metric.
        """
        return pulumi.get(self, "metric_namespace")

    @metric_namespace.setter
    def metric_namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metric_namespace", value)

    @property
    @pulumi.getter(name="skipMetricValidation")
    def skip_metric_validation(self) -> Optional[pulumi.Input[bool]]:
        """
        Allows creating an alert rule on a custom metric that isn't yet emitted, by causing the metric validation to be skipped.
        """
        return pulumi.get(self, "skip_metric_validation")

    @skip_metric_validation.setter
    def skip_metric_validation(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "skip_metric_validation", value)


@pulumi.input_type
class DynamicThresholdFailingPeriodsArgs:
    def __init__(__self__, *,
                 min_failing_periods_to_alert: pulumi.Input[float],
                 number_of_evaluation_periods: pulumi.Input[float]):
        """
        The minimum number of violations required within the selected lookback time window required to raise an alert.
        :param pulumi.Input[float] min_failing_periods_to_alert: The number of violations to trigger an alert. Should be smaller or equal to numberOfEvaluationPeriods.
        :param pulumi.Input[float] number_of_evaluation_periods: The number of aggregated lookback points. The lookback time window is calculated based on the aggregation granularity (windowSize) and the selected number of aggregated points.
        """
        pulumi.set(__self__, "min_failing_periods_to_alert", min_failing_periods_to_alert)
        pulumi.set(__self__, "number_of_evaluation_periods", number_of_evaluation_periods)

    @property
    @pulumi.getter(name="minFailingPeriodsToAlert")
    def min_failing_periods_to_alert(self) -> pulumi.Input[float]:
        """
        The number of violations to trigger an alert. Should be smaller or equal to numberOfEvaluationPeriods.
        """
        return pulumi.get(self, "min_failing_periods_to_alert")

    @min_failing_periods_to_alert.setter
    def min_failing_periods_to_alert(self, value: pulumi.Input[float]):
        pulumi.set(self, "min_failing_periods_to_alert", value)

    @property
    @pulumi.getter(name="numberOfEvaluationPeriods")
    def number_of_evaluation_periods(self) -> pulumi.Input[float]:
        """
        The number of aggregated lookback points. The lookback time window is calculated based on the aggregation granularity (windowSize) and the selected number of aggregated points.
        """
        return pulumi.get(self, "number_of_evaluation_periods")

    @number_of_evaluation_periods.setter
    def number_of_evaluation_periods(self, value: pulumi.Input[float]):
        pulumi.set(self, "number_of_evaluation_periods", value)


@pulumi.input_type
class EmailNotificationArgs:
    def __init__(__self__, *,
                 custom_emails: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 send_to_subscription_administrator: Optional[pulumi.Input[bool]] = None,
                 send_to_subscription_co_administrators: Optional[pulumi.Input[bool]] = None):
        """
        Email notification of an autoscale event.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] custom_emails: the custom e-mails list. This value can be null or empty, in which case this attribute will be ignored.
        :param pulumi.Input[bool] send_to_subscription_administrator: a value indicating whether to send email to subscription administrator.
        :param pulumi.Input[bool] send_to_subscription_co_administrators: a value indicating whether to send email to subscription co-administrators.
        """
        if custom_emails is not None:
            pulumi.set(__self__, "custom_emails", custom_emails)
        if send_to_subscription_administrator is None:
            send_to_subscription_administrator = False
        if send_to_subscription_administrator is not None:
            pulumi.set(__self__, "send_to_subscription_administrator", send_to_subscription_administrator)
        if send_to_subscription_co_administrators is None:
            send_to_subscription_co_administrators = False
        if send_to_subscription_co_administrators is not None:
            pulumi.set(__self__, "send_to_subscription_co_administrators", send_to_subscription_co_administrators)

    @property
    @pulumi.getter(name="customEmails")
    def custom_emails(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        the custom e-mails list. This value can be null or empty, in which case this attribute will be ignored.
        """
        return pulumi.get(self, "custom_emails")

    @custom_emails.setter
    def custom_emails(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "custom_emails", value)

    @property
    @pulumi.getter(name="sendToSubscriptionAdministrator")
    def send_to_subscription_administrator(self) -> Optional[pulumi.Input[bool]]:
        """
        a value indicating whether to send email to subscription administrator.
        """
        return pulumi.get(self, "send_to_subscription_administrator")

    @send_to_subscription_administrator.setter
    def send_to_subscription_administrator(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "send_to_subscription_administrator", value)

    @property
    @pulumi.getter(name="sendToSubscriptionCoAdministrators")
    def send_to_subscription_co_administrators(self) -> Optional[pulumi.Input[bool]]:
        """
        a value indicating whether to send email to subscription co-administrators.
        """
        return pulumi.get(self, "send_to_subscription_co_administrators")

    @send_to_subscription_co_administrators.setter
    def send_to_subscription_co_administrators(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "send_to_subscription_co_administrators", value)


@pulumi.input_type
class EmailReceiverArgs:
    def __init__(__self__, *,
                 email_address: pulumi.Input[str],
                 name: pulumi.Input[str],
                 use_common_alert_schema: Optional[pulumi.Input[bool]] = None):
        """
        An email receiver.
        :param pulumi.Input[str] email_address: The email address of this receiver.
        :param pulumi.Input[str] name: The name of the email receiver. Names must be unique across all receivers within an action group.
        :param pulumi.Input[bool] use_common_alert_schema: Indicates whether to use common alert schema.
        """
        pulumi.set(__self__, "email_address", email_address)
        pulumi.set(__self__, "name", name)
        if use_common_alert_schema is None:
            use_common_alert_schema = False
        if use_common_alert_schema is not None:
            pulumi.set(__self__, "use_common_alert_schema", use_common_alert_schema)

    @property
    @pulumi.getter(name="emailAddress")
    def email_address(self) -> pulumi.Input[str]:
        """
        The email address of this receiver.
        """
        return pulumi.get(self, "email_address")

    @email_address.setter
    def email_address(self, value: pulumi.Input[str]):
        pulumi.set(self, "email_address", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the email receiver. Names must be unique across all receivers within an action group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="useCommonAlertSchema")
    def use_common_alert_schema(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether to use common alert schema.
        """
        return pulumi.get(self, "use_common_alert_schema")

    @use_common_alert_schema.setter
    def use_common_alert_schema(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_common_alert_schema", value)


@pulumi.input_type
class EtwEventConfigurationArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[int],
                 name: pulumi.Input[str],
                 filter: Optional[pulumi.Input[str]] = None):
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[int]:
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[int]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def filter(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "filter", value)


@pulumi.input_type
class EtwProviderConfigurationArgs:
    def __init__(__self__, *,
                 events: pulumi.Input[Sequence[pulumi.Input['EtwEventConfigurationArgs']]],
                 id: pulumi.Input[str]):
        pulumi.set(__self__, "events", events)
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def events(self) -> pulumi.Input[Sequence[pulumi.Input['EtwEventConfigurationArgs']]]:
        return pulumi.get(self, "events")

    @events.setter
    def events(self, value: pulumi.Input[Sequence[pulumi.Input['EtwEventConfigurationArgs']]]):
        pulumi.set(self, "events", value)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[str]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class EventLogConfigurationArgs:
    def __init__(__self__, *,
                 log_name: pulumi.Input[str],
                 filter: Optional[pulumi.Input[str]] = None):
        pulumi.set(__self__, "log_name", log_name)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)

    @property
    @pulumi.getter(name="logName")
    def log_name(self) -> pulumi.Input[str]:
        return pulumi.get(self, "log_name")

    @log_name.setter
    def log_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "log_name", value)

    @property
    @pulumi.getter
    def filter(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "filter", value)


@pulumi.input_type
class ExtensionDataSourceArgs:
    def __init__(__self__, *,
                 extension_name: pulumi.Input[str],
                 extension_settings: Optional[Any] = None,
                 input_data_sources: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 streams: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'KnownExtensionDataSourceStreams']]]]] = None):
        """
        Definition of which data will be collected from a separate VM extension that integrates with the Azure Monitor Agent.
        Collected from either Windows and Linux machines, depending on which extension is defined.
        :param pulumi.Input[str] extension_name: The name of the VM extension.
        :param Any extension_settings: The extension settings. The format is specific for particular extension.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] input_data_sources: The list of data sources this extension needs data from.
        :param pulumi.Input[str] name: A friendly name for the data source. 
               This name should be unique across all data sources (regardless of type) within the data collection rule.
        :param pulumi.Input[Sequence[pulumi.Input[Union[str, 'KnownExtensionDataSourceStreams']]]] streams: List of streams that this data source will be sent to.
               A stream indicates what schema will be used for this data and usually what table in Log Analytics the data will be sent to.
        """
        pulumi.set(__self__, "extension_name", extension_name)
        if extension_settings is not None:
            pulumi.set(__self__, "extension_settings", extension_settings)
        if input_data_sources is not None:
            pulumi.set(__self__, "input_data_sources", input_data_sources)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if streams is not None:
            pulumi.set(__self__, "streams", streams)

    @property
    @pulumi.getter(name="extensionName")
    def extension_name(self) -> pulumi.Input[str]:
        """
        The name of the VM extension.
        """
        return pulumi.get(self, "extension_name")

    @extension_name.setter
    def extension_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "extension_name", value)

    @property
    @pulumi.getter(name="extensionSettings")
    def extension_settings(self) -> Optional[Any]:
        """
        The extension settings. The format is specific for particular extension.
        """
        return pulumi.get(self, "extension_settings")

    @extension_settings.setter
    def extension_settings(self, value: Optional[Any]):
        pulumi.set(self, "extension_settings", value)

    @property
    @pulumi.getter(name="inputDataSources")
    def input_data_sources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of data sources this extension needs data from.
        """
        return pulumi.get(self, "input_data_sources")

    @input_data_sources.setter
    def input_data_sources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "input_data_sources", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A friendly name for the data source. 
        This name should be unique across all data sources (regardless of type) within the data collection rule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def streams(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'KnownExtensionDataSourceStreams']]]]]:
        """
        List of streams that this data source will be sent to.
        A stream indicates what schema will be used for this data and usually what table in Log Analytics the data will be sent to.
        """
        return pulumi.get(self, "streams")

    @streams.setter
    def streams(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'KnownExtensionDataSourceStreams']]]]]):
        pulumi.set(self, "streams", value)


@pulumi.input_type
class ItsmReceiverArgs:
    def __init__(__self__, *,
                 connection_id: pulumi.Input[str],
                 name: pulumi.Input[str],
                 region: pulumi.Input[str],
                 ticket_configuration: pulumi.Input[str],
                 workspace_id: pulumi.Input[str]):
        """
        An Itsm receiver.
        :param pulumi.Input[str] connection_id: Unique identification of ITSM connection among multiple defined in above workspace.
        :param pulumi.Input[str] name: The name of the Itsm receiver. Names must be unique across all receivers within an action group.
        :param pulumi.Input[str] region: Region in which workspace resides. Supported values:'centralindia','japaneast','southeastasia','australiasoutheast','uksouth','westcentralus','canadacentral','eastus','westeurope'
        :param pulumi.Input[str] ticket_configuration: JSON blob for the configurations of the ITSM action. CreateMultipleWorkItems option will be part of this blob as well.
        :param pulumi.Input[str] workspace_id: OMS LA instance identifier.
        """
        pulumi.set(__self__, "connection_id", connection_id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "ticket_configuration", ticket_configuration)
        pulumi.set(__self__, "workspace_id", workspace_id)

    @property
    @pulumi.getter(name="connectionId")
    def connection_id(self) -> pulumi.Input[str]:
        """
        Unique identification of ITSM connection among multiple defined in above workspace.
        """
        return pulumi.get(self, "connection_id")

    @connection_id.setter
    def connection_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "connection_id", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the Itsm receiver. Names must be unique across all receivers within an action group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> pulumi.Input[str]:
        """
        Region in which workspace resides. Supported values:'centralindia','japaneast','southeastasia','australiasoutheast','uksouth','westcentralus','canadacentral','eastus','westeurope'
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[str]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="ticketConfiguration")
    def ticket_configuration(self) -> pulumi.Input[str]:
        """
        JSON blob for the configurations of the ITSM action. CreateMultipleWorkItems option will be part of this blob as well.
        """
        return pulumi.get(self, "ticket_configuration")

    @ticket_configuration.setter
    def ticket_configuration(self, value: pulumi.Input[str]):
        pulumi.set(self, "ticket_configuration", value)

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Input[str]:
        """
        OMS LA instance identifier.
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "workspace_id", value)


@pulumi.input_type
class LocationThresholdRuleConditionArgs:
    def __init__(__self__, *,
                 failed_location_count: pulumi.Input[int],
                 odata_type: pulumi.Input[str],
                 data_source: Optional[pulumi.Input[Union['RuleManagementEventDataSourceArgs', 'RuleMetricDataSourceArgs']]] = None,
                 window_size: Optional[pulumi.Input[str]] = None):
        """
        A rule condition based on a certain number of locations failing.
        :param pulumi.Input[int] failed_location_count: the number of locations that must fail to activate the alert.
        :param pulumi.Input[str] odata_type: specifies the type of condition. This can be one of three types: ManagementEventRuleCondition (occurrences of management events), LocationThresholdRuleCondition (based on the number of failures of a web test), and ThresholdRuleCondition (based on the threshold of a metric).
               Expected value is 'Microsoft.Azure.Management.Insights.Models.LocationThresholdRuleCondition'.
        :param pulumi.Input[Union['RuleManagementEventDataSourceArgs', 'RuleMetricDataSourceArgs']] data_source: the resource from which the rule collects its data. For this type dataSource will always be of type RuleMetricDataSource.
        :param pulumi.Input[str] window_size: the period of time (in ISO 8601 duration format) that is used to monitor alert activity based on the threshold. If specified then it must be between 5 minutes and 1 day.
        """
        pulumi.set(__self__, "failed_location_count", failed_location_count)
        pulumi.set(__self__, "odata_type", 'Microsoft.Azure.Management.Insights.Models.LocationThresholdRuleCondition')
        if data_source is not None:
            pulumi.set(__self__, "data_source", data_source)
        if window_size is not None:
            pulumi.set(__self__, "window_size", window_size)

    @property
    @pulumi.getter(name="failedLocationCount")
    def failed_location_count(self) -> pulumi.Input[int]:
        """
        the number of locations that must fail to activate the alert.
        """
        return pulumi.get(self, "failed_location_count")

    @failed_location_count.setter
    def failed_location_count(self, value: pulumi.Input[int]):
        pulumi.set(self, "failed_location_count", value)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        specifies the type of condition. This can be one of three types: ManagementEventRuleCondition (occurrences of management events), LocationThresholdRuleCondition (based on the number of failures of a web test), and ThresholdRuleCondition (based on the threshold of a metric).
        Expected value is 'Microsoft.Azure.Management.Insights.Models.LocationThresholdRuleCondition'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter(name="dataSource")
    def data_source(self) -> Optional[pulumi.Input[Union['RuleManagementEventDataSourceArgs', 'RuleMetricDataSourceArgs']]]:
        """
        the resource from which the rule collects its data. For this type dataSource will always be of type RuleMetricDataSource.
        """
        return pulumi.get(self, "data_source")

    @data_source.setter
    def data_source(self, value: Optional[pulumi.Input[Union['RuleManagementEventDataSourceArgs', 'RuleMetricDataSourceArgs']]]):
        pulumi.set(self, "data_source", value)

    @property
    @pulumi.getter(name="windowSize")
    def window_size(self) -> Optional[pulumi.Input[str]]:
        """
        the period of time (in ISO 8601 duration format) that is used to monitor alert activity based on the threshold. If specified then it must be between 5 minutes and 1 day.
        """
        return pulumi.get(self, "window_size")

    @window_size.setter
    def window_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "window_size", value)


@pulumi.input_type
class LogAnalyticsDestinationArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 workspace_resource_id: Optional[pulumi.Input[str]] = None):
        """
        Log Analytics destination.
        :param pulumi.Input[str] name: A friendly name for the destination. 
               This name should be unique across all destinations (regardless of type) within the data collection rule.
        :param pulumi.Input[str] workspace_resource_id: The resource ID of the Log Analytics workspace.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if workspace_resource_id is not None:
            pulumi.set(__self__, "workspace_resource_id", workspace_resource_id)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A friendly name for the destination. 
        This name should be unique across all destinations (regardless of type) within the data collection rule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="workspaceResourceId")
    def workspace_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        The resource ID of the Log Analytics workspace.
        """
        return pulumi.get(self, "workspace_resource_id")

    @workspace_resource_id.setter
    def workspace_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "workspace_resource_id", value)


@pulumi.input_type
class LogMetricTriggerArgs:
    def __init__(__self__, *,
                 metric_column: Optional[pulumi.Input[str]] = None,
                 metric_trigger_type: Optional[pulumi.Input[Union[str, 'MetricTriggerType']]] = None,
                 threshold: Optional[pulumi.Input[float]] = None,
                 threshold_operator: Optional[pulumi.Input[Union[str, 'ConditionalOperator']]] = None):
        """
        A log metrics trigger descriptor.
        :param pulumi.Input[str] metric_column: Evaluation of metric on a particular column
        :param pulumi.Input[Union[str, 'MetricTriggerType']] metric_trigger_type: Metric Trigger Type - 'Consecutive' or 'Total'
        :param pulumi.Input[float] threshold: The threshold of the metric trigger.
        :param pulumi.Input[Union[str, 'ConditionalOperator']] threshold_operator: Evaluation operation for Metric -'GreaterThan' or 'LessThan' or 'Equal'.
        """
        if metric_column is not None:
            pulumi.set(__self__, "metric_column", metric_column)
        if metric_trigger_type is not None:
            pulumi.set(__self__, "metric_trigger_type", metric_trigger_type)
        if threshold is not None:
            pulumi.set(__self__, "threshold", threshold)
        if threshold_operator is not None:
            pulumi.set(__self__, "threshold_operator", threshold_operator)

    @property
    @pulumi.getter(name="metricColumn")
    def metric_column(self) -> Optional[pulumi.Input[str]]:
        """
        Evaluation of metric on a particular column
        """
        return pulumi.get(self, "metric_column")

    @metric_column.setter
    def metric_column(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metric_column", value)

    @property
    @pulumi.getter(name="metricTriggerType")
    def metric_trigger_type(self) -> Optional[pulumi.Input[Union[str, 'MetricTriggerType']]]:
        """
        Metric Trigger Type - 'Consecutive' or 'Total'
        """
        return pulumi.get(self, "metric_trigger_type")

    @metric_trigger_type.setter
    def metric_trigger_type(self, value: Optional[pulumi.Input[Union[str, 'MetricTriggerType']]]):
        pulumi.set(self, "metric_trigger_type", value)

    @property
    @pulumi.getter
    def threshold(self) -> Optional[pulumi.Input[float]]:
        """
        The threshold of the metric trigger.
        """
        return pulumi.get(self, "threshold")

    @threshold.setter
    def threshold(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "threshold", value)

    @property
    @pulumi.getter(name="thresholdOperator")
    def threshold_operator(self) -> Optional[pulumi.Input[Union[str, 'ConditionalOperator']]]:
        """
        Evaluation operation for Metric -'GreaterThan' or 'LessThan' or 'Equal'.
        """
        return pulumi.get(self, "threshold_operator")

    @threshold_operator.setter
    def threshold_operator(self, value: Optional[pulumi.Input[Union[str, 'ConditionalOperator']]]):
        pulumi.set(self, "threshold_operator", value)


@pulumi.input_type
class LogSettingsArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[bool],
                 category: Optional[pulumi.Input[str]] = None,
                 retention_policy: Optional[pulumi.Input['RetentionPolicyArgs']] = None):
        """
        Part of MultiTenantDiagnosticSettings. Specifies the settings for a particular log.
        :param pulumi.Input[bool] enabled: a value indicating whether this log is enabled.
        :param pulumi.Input[str] category: Name of a Diagnostic Log category for a resource type this setting is applied to. To obtain the list of Diagnostic Log categories for a resource, first perform a GET diagnostic settings operation.
        :param pulumi.Input['RetentionPolicyArgs'] retention_policy: the retention policy for this log.
        """
        pulumi.set(__self__, "enabled", enabled)
        if category is not None:
            pulumi.set(__self__, "category", category)
        if retention_policy is not None:
            pulumi.set(__self__, "retention_policy", retention_policy)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[bool]:
        """
        a value indicating whether this log is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def category(self) -> Optional[pulumi.Input[str]]:
        """
        Name of a Diagnostic Log category for a resource type this setting is applied to. To obtain the list of Diagnostic Log categories for a resource, first perform a GET diagnostic settings operation.
        """
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "category", value)

    @property
    @pulumi.getter(name="retentionPolicy")
    def retention_policy(self) -> Optional[pulumi.Input['RetentionPolicyArgs']]:
        """
        the retention policy for this log.
        """
        return pulumi.get(self, "retention_policy")

    @retention_policy.setter
    def retention_policy(self, value: Optional[pulumi.Input['RetentionPolicyArgs']]):
        pulumi.set(self, "retention_policy", value)


@pulumi.input_type
class LogToMetricActionArgs:
    def __init__(__self__, *,
                 criteria: pulumi.Input[Sequence[pulumi.Input['CriteriaArgs']]],
                 odata_type: pulumi.Input[str]):
        """
        Specify action need to be taken when rule type is converting log to metric
        :param pulumi.Input[Sequence[pulumi.Input['CriteriaArgs']]] criteria: Criteria of Metric
        :param pulumi.Input[str] odata_type: Specifies the action. Supported values - AlertingAction, LogToMetricAction
               Expected value is 'Microsoft.WindowsAzure.Management.Monitoring.Alerts.Models.Microsoft.AppInsights.Nexus.DataContracts.Resources.ScheduledQueryRules.LogToMetricAction'.
        """
        pulumi.set(__self__, "criteria", criteria)
        pulumi.set(__self__, "odata_type", 'Microsoft.WindowsAzure.Management.Monitoring.Alerts.Models.Microsoft.AppInsights.Nexus.DataContracts.Resources.ScheduledQueryRules.LogToMetricAction')

    @property
    @pulumi.getter
    def criteria(self) -> pulumi.Input[Sequence[pulumi.Input['CriteriaArgs']]]:
        """
        Criteria of Metric
        """
        return pulumi.get(self, "criteria")

    @criteria.setter
    def criteria(self, value: pulumi.Input[Sequence[pulumi.Input['CriteriaArgs']]]):
        pulumi.set(self, "criteria", value)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        Specifies the action. Supported values - AlertingAction, LogToMetricAction
        Expected value is 'Microsoft.WindowsAzure.Management.Monitoring.Alerts.Models.Microsoft.AppInsights.Nexus.DataContracts.Resources.ScheduledQueryRules.LogToMetricAction'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)


@pulumi.input_type
class LogicAppReceiverArgs:
    def __init__(__self__, *,
                 callback_url: pulumi.Input[str],
                 name: pulumi.Input[str],
                 resource_id: pulumi.Input[str],
                 use_common_alert_schema: Optional[pulumi.Input[bool]] = None):
        """
        A logic app receiver.
        :param pulumi.Input[str] callback_url: The callback url where http request sent to.
        :param pulumi.Input[str] name: The name of the logic app receiver. Names must be unique across all receivers within an action group.
        :param pulumi.Input[str] resource_id: The azure resource id of the logic app receiver.
        :param pulumi.Input[bool] use_common_alert_schema: Indicates whether to use common alert schema.
        """
        pulumi.set(__self__, "callback_url", callback_url)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "resource_id", resource_id)
        if use_common_alert_schema is None:
            use_common_alert_schema = False
        if use_common_alert_schema is not None:
            pulumi.set(__self__, "use_common_alert_schema", use_common_alert_schema)

    @property
    @pulumi.getter(name="callbackUrl")
    def callback_url(self) -> pulumi.Input[str]:
        """
        The callback url where http request sent to.
        """
        return pulumi.get(self, "callback_url")

    @callback_url.setter
    def callback_url(self, value: pulumi.Input[str]):
        pulumi.set(self, "callback_url", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the logic app receiver. Names must be unique across all receivers within an action group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> pulumi.Input[str]:
        """
        The azure resource id of the logic app receiver.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_id", value)

    @property
    @pulumi.getter(name="useCommonAlertSchema")
    def use_common_alert_schema(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether to use common alert schema.
        """
        return pulumi.get(self, "use_common_alert_schema")

    @use_common_alert_schema.setter
    def use_common_alert_schema(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_common_alert_schema", value)


@pulumi.input_type
class ManagementEventAggregationConditionArgs:
    def __init__(__self__, *,
                 operator: Optional[pulumi.Input['ConditionOperator']] = None,
                 threshold: Optional[pulumi.Input[float]] = None,
                 window_size: Optional[pulumi.Input[str]] = None):
        """
        How the data that is collected should be combined over time.
        :param pulumi.Input['ConditionOperator'] operator: the condition operator.
        :param pulumi.Input[float] threshold: The threshold value that activates the alert.
        :param pulumi.Input[str] window_size: the period of time (in ISO 8601 duration format) that is used to monitor alert activity based on the threshold. If specified then it must be between 5 minutes and 1 day.
        """
        if operator is not None:
            pulumi.set(__self__, "operator", operator)
        if threshold is not None:
            pulumi.set(__self__, "threshold", threshold)
        if window_size is not None:
            pulumi.set(__self__, "window_size", window_size)

    @property
    @pulumi.getter
    def operator(self) -> Optional[pulumi.Input['ConditionOperator']]:
        """
        the condition operator.
        """
        return pulumi.get(self, "operator")

    @operator.setter
    def operator(self, value: Optional[pulumi.Input['ConditionOperator']]):
        pulumi.set(self, "operator", value)

    @property
    @pulumi.getter
    def threshold(self) -> Optional[pulumi.Input[float]]:
        """
        The threshold value that activates the alert.
        """
        return pulumi.get(self, "threshold")

    @threshold.setter
    def threshold(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "threshold", value)

    @property
    @pulumi.getter(name="windowSize")
    def window_size(self) -> Optional[pulumi.Input[str]]:
        """
        the period of time (in ISO 8601 duration format) that is used to monitor alert activity based on the threshold. If specified then it must be between 5 minutes and 1 day.
        """
        return pulumi.get(self, "window_size")

    @window_size.setter
    def window_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "window_size", value)


@pulumi.input_type
class ManagementEventRuleConditionArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str],
                 aggregation: Optional[pulumi.Input['ManagementEventAggregationConditionArgs']] = None,
                 data_source: Optional[pulumi.Input[Union['RuleManagementEventDataSourceArgs', 'RuleMetricDataSourceArgs']]] = None):
        """
        A management event rule condition.
        :param pulumi.Input[str] odata_type: specifies the type of condition. This can be one of three types: ManagementEventRuleCondition (occurrences of management events), LocationThresholdRuleCondition (based on the number of failures of a web test), and ThresholdRuleCondition (based on the threshold of a metric).
               Expected value is 'Microsoft.Azure.Management.Insights.Models.ManagementEventRuleCondition'.
        :param pulumi.Input['ManagementEventAggregationConditionArgs'] aggregation: How the data that is collected should be combined over time and when the alert is activated. Note that for management event alerts aggregation is optional – if it is not provided then any event will cause the alert to activate.
        :param pulumi.Input[Union['RuleManagementEventDataSourceArgs', 'RuleMetricDataSourceArgs']] data_source: the resource from which the rule collects its data. For this type dataSource will always be of type RuleMetricDataSource.
        """
        pulumi.set(__self__, "odata_type", 'Microsoft.Azure.Management.Insights.Models.ManagementEventRuleCondition')
        if aggregation is not None:
            pulumi.set(__self__, "aggregation", aggregation)
        if data_source is not None:
            pulumi.set(__self__, "data_source", data_source)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        specifies the type of condition. This can be one of three types: ManagementEventRuleCondition (occurrences of management events), LocationThresholdRuleCondition (based on the number of failures of a web test), and ThresholdRuleCondition (based on the threshold of a metric).
        Expected value is 'Microsoft.Azure.Management.Insights.Models.ManagementEventRuleCondition'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter
    def aggregation(self) -> Optional[pulumi.Input['ManagementEventAggregationConditionArgs']]:
        """
        How the data that is collected should be combined over time and when the alert is activated. Note that for management event alerts aggregation is optional – if it is not provided then any event will cause the alert to activate.
        """
        return pulumi.get(self, "aggregation")

    @aggregation.setter
    def aggregation(self, value: Optional[pulumi.Input['ManagementEventAggregationConditionArgs']]):
        pulumi.set(self, "aggregation", value)

    @property
    @pulumi.getter(name="dataSource")
    def data_source(self) -> Optional[pulumi.Input[Union['RuleManagementEventDataSourceArgs', 'RuleMetricDataSourceArgs']]]:
        """
        the resource from which the rule collects its data. For this type dataSource will always be of type RuleMetricDataSource.
        """
        return pulumi.get(self, "data_source")

    @data_source.setter
    def data_source(self, value: Optional[pulumi.Input[Union['RuleManagementEventDataSourceArgs', 'RuleMetricDataSourceArgs']]]):
        pulumi.set(self, "data_source", value)


@pulumi.input_type
class ManagementGroupLogSettingsArgs:
    def __init__(__self__, *,
                 category: pulumi.Input[str],
                 enabled: pulumi.Input[bool]):
        """
        Part of Management Group diagnostic setting. Specifies the settings for a particular log.
        :param pulumi.Input[str] category: Name of a Management Group Diagnostic Log category for a resource type this setting is applied to.
        :param pulumi.Input[bool] enabled: a value indicating whether this log is enabled.
        """
        pulumi.set(__self__, "category", category)
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def category(self) -> pulumi.Input[str]:
        """
        Name of a Management Group Diagnostic Log category for a resource type this setting is applied to.
        """
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: pulumi.Input[str]):
        pulumi.set(self, "category", value)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[bool]:
        """
        a value indicating whether this log is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enabled", value)


@pulumi.input_type
class MetricAlertActionArgs:
    def __init__(__self__, *,
                 action_group_id: Optional[pulumi.Input[str]] = None,
                 web_hook_properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        An alert action.
        :param pulumi.Input[str] action_group_id: the id of the action group to use.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] web_hook_properties: This field allows specifying custom properties, which would be appended to the alert payload sent as input to the webhook.
        """
        if action_group_id is not None:
            pulumi.set(__self__, "action_group_id", action_group_id)
        if web_hook_properties is not None:
            pulumi.set(__self__, "web_hook_properties", web_hook_properties)

    @property
    @pulumi.getter(name="actionGroupId")
    def action_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        the id of the action group to use.
        """
        return pulumi.get(self, "action_group_id")

    @action_group_id.setter
    def action_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "action_group_id", value)

    @property
    @pulumi.getter(name="webHookProperties")
    def web_hook_properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        This field allows specifying custom properties, which would be appended to the alert payload sent as input to the webhook.
        """
        return pulumi.get(self, "web_hook_properties")

    @web_hook_properties.setter
    def web_hook_properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "web_hook_properties", value)


@pulumi.input_type
class MetricAlertMultipleResourceMultipleMetricCriteriaArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str],
                 all_of: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DynamicMetricCriteriaArgs', 'MetricCriteriaArgs']]]]] = None):
        """
        Specifies the metric alert criteria for multiple resource that has multiple metric criteria.
        :param pulumi.Input[str] odata_type: specifies the type of the alert criteria.
               Expected value is 'Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria'.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DynamicMetricCriteriaArgs', 'MetricCriteriaArgs']]]] all_of: the list of multiple metric criteria for this 'all of' operation. 
        """
        pulumi.set(__self__, "odata_type", 'Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria')
        if all_of is not None:
            pulumi.set(__self__, "all_of", all_of)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        specifies the type of the alert criteria.
        Expected value is 'Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter(name="allOf")
    def all_of(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union['DynamicMetricCriteriaArgs', 'MetricCriteriaArgs']]]]]:
        """
        the list of multiple metric criteria for this 'all of' operation. 
        """
        return pulumi.get(self, "all_of")

    @all_of.setter
    def all_of(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DynamicMetricCriteriaArgs', 'MetricCriteriaArgs']]]]]):
        pulumi.set(self, "all_of", value)


@pulumi.input_type
class MetricAlertSingleResourceMultipleMetricCriteriaArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str],
                 all_of: Optional[pulumi.Input[Sequence[pulumi.Input['MetricCriteriaArgs']]]] = None):
        """
        Specifies the metric alert criteria for a single resource that has multiple metric criteria.
        :param pulumi.Input[str] odata_type: specifies the type of the alert criteria.
               Expected value is 'Microsoft.Azure.Monitor.SingleResourceMultipleMetricCriteria'.
        :param pulumi.Input[Sequence[pulumi.Input['MetricCriteriaArgs']]] all_of: The list of metric criteria for this 'all of' operation. 
        """
        pulumi.set(__self__, "odata_type", 'Microsoft.Azure.Monitor.SingleResourceMultipleMetricCriteria')
        if all_of is not None:
            pulumi.set(__self__, "all_of", all_of)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        specifies the type of the alert criteria.
        Expected value is 'Microsoft.Azure.Monitor.SingleResourceMultipleMetricCriteria'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter(name="allOf")
    def all_of(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MetricCriteriaArgs']]]]:
        """
        The list of metric criteria for this 'all of' operation. 
        """
        return pulumi.get(self, "all_of")

    @all_of.setter
    def all_of(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MetricCriteriaArgs']]]]):
        pulumi.set(self, "all_of", value)


@pulumi.input_type
class MetricCriteriaArgs:
    def __init__(__self__, *,
                 criterion_type: pulumi.Input[str],
                 metric_name: pulumi.Input[str],
                 name: pulumi.Input[str],
                 operator: pulumi.Input[Union[str, 'Operator']],
                 threshold: pulumi.Input[float],
                 time_aggregation: pulumi.Input[Union[str, 'AggregationTypeEnum']],
                 dimensions: Optional[pulumi.Input[Sequence[pulumi.Input['MetricDimensionArgs']]]] = None,
                 metric_namespace: Optional[pulumi.Input[str]] = None,
                 skip_metric_validation: Optional[pulumi.Input[bool]] = None):
        """
        Criterion to filter metrics.
        :param pulumi.Input[str] criterion_type: Specifies the type of threshold criteria
               Expected value is 'StaticThresholdCriterion'.
        :param pulumi.Input[str] metric_name: Name of the metric.
        :param pulumi.Input[str] name: Name of the criteria.
        :param pulumi.Input[Union[str, 'Operator']] operator: the criteria operator.
        :param pulumi.Input[float] threshold: the criteria threshold value that activates the alert.
        :param pulumi.Input[Union[str, 'AggregationTypeEnum']] time_aggregation: the criteria time aggregation types.
        :param pulumi.Input[Sequence[pulumi.Input['MetricDimensionArgs']]] dimensions: List of dimension conditions.
        :param pulumi.Input[str] metric_namespace: Namespace of the metric.
        :param pulumi.Input[bool] skip_metric_validation: Allows creating an alert rule on a custom metric that isn't yet emitted, by causing the metric validation to be skipped.
        """
        pulumi.set(__self__, "criterion_type", 'StaticThresholdCriterion')
        pulumi.set(__self__, "metric_name", metric_name)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "operator", operator)
        pulumi.set(__self__, "threshold", threshold)
        pulumi.set(__self__, "time_aggregation", time_aggregation)
        if dimensions is not None:
            pulumi.set(__self__, "dimensions", dimensions)
        if metric_namespace is not None:
            pulumi.set(__self__, "metric_namespace", metric_namespace)
        if skip_metric_validation is not None:
            pulumi.set(__self__, "skip_metric_validation", skip_metric_validation)

    @property
    @pulumi.getter(name="criterionType")
    def criterion_type(self) -> pulumi.Input[str]:
        """
        Specifies the type of threshold criteria
        Expected value is 'StaticThresholdCriterion'.
        """
        return pulumi.get(self, "criterion_type")

    @criterion_type.setter
    def criterion_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "criterion_type", value)

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> pulumi.Input[str]:
        """
        Name of the metric.
        """
        return pulumi.get(self, "metric_name")

    @metric_name.setter
    def metric_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "metric_name", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Name of the criteria.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def operator(self) -> pulumi.Input[Union[str, 'Operator']]:
        """
        the criteria operator.
        """
        return pulumi.get(self, "operator")

    @operator.setter
    def operator(self, value: pulumi.Input[Union[str, 'Operator']]):
        pulumi.set(self, "operator", value)

    @property
    @pulumi.getter
    def threshold(self) -> pulumi.Input[float]:
        """
        the criteria threshold value that activates the alert.
        """
        return pulumi.get(self, "threshold")

    @threshold.setter
    def threshold(self, value: pulumi.Input[float]):
        pulumi.set(self, "threshold", value)

    @property
    @pulumi.getter(name="timeAggregation")
    def time_aggregation(self) -> pulumi.Input[Union[str, 'AggregationTypeEnum']]:
        """
        the criteria time aggregation types.
        """
        return pulumi.get(self, "time_aggregation")

    @time_aggregation.setter
    def time_aggregation(self, value: pulumi.Input[Union[str, 'AggregationTypeEnum']]):
        pulumi.set(self, "time_aggregation", value)

    @property
    @pulumi.getter
    def dimensions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MetricDimensionArgs']]]]:
        """
        List of dimension conditions.
        """
        return pulumi.get(self, "dimensions")

    @dimensions.setter
    def dimensions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MetricDimensionArgs']]]]):
        pulumi.set(self, "dimensions", value)

    @property
    @pulumi.getter(name="metricNamespace")
    def metric_namespace(self) -> Optional[pulumi.Input[str]]:
        """
        Namespace of the metric.
        """
        return pulumi.get(self, "metric_namespace")

    @metric_namespace.setter
    def metric_namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metric_namespace", value)

    @property
    @pulumi.getter(name="skipMetricValidation")
    def skip_metric_validation(self) -> Optional[pulumi.Input[bool]]:
        """
        Allows creating an alert rule on a custom metric that isn't yet emitted, by causing the metric validation to be skipped.
        """
        return pulumi.get(self, "skip_metric_validation")

    @skip_metric_validation.setter
    def skip_metric_validation(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "skip_metric_validation", value)


@pulumi.input_type
class MetricDimensionArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 operator: pulumi.Input[str],
                 values: pulumi.Input[Sequence[pulumi.Input[str]]]):
        """
        Specifies a metric dimension.
        :param pulumi.Input[str] name: Name of the dimension.
        :param pulumi.Input[str] operator: the dimension operator. Only 'Include' and 'Exclude' are supported
        :param pulumi.Input[Sequence[pulumi.Input[str]]] values: list of dimension values.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "operator", operator)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Name of the dimension.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def operator(self) -> pulumi.Input[str]:
        """
        the dimension operator. Only 'Include' and 'Exclude' are supported
        """
        return pulumi.get(self, "operator")

    @operator.setter
    def operator(self, value: pulumi.Input[str]):
        pulumi.set(self, "operator", value)

    @property
    @pulumi.getter
    def values(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        list of dimension values.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class MetricSettingsArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[bool],
                 category: Optional[pulumi.Input[str]] = None,
                 retention_policy: Optional[pulumi.Input['RetentionPolicyArgs']] = None,
                 time_grain: Optional[pulumi.Input[str]] = None):
        """
        Part of MultiTenantDiagnosticSettings. Specifies the settings for a particular metric.
        :param pulumi.Input[bool] enabled: a value indicating whether this category is enabled.
        :param pulumi.Input[str] category: Name of a Diagnostic Metric category for a resource type this setting is applied to. To obtain the list of Diagnostic metric categories for a resource, first perform a GET diagnostic settings operation.
        :param pulumi.Input['RetentionPolicyArgs'] retention_policy: the retention policy for this category.
        :param pulumi.Input[str] time_grain: the timegrain of the metric in ISO8601 format.
        """
        pulumi.set(__self__, "enabled", enabled)
        if category is not None:
            pulumi.set(__self__, "category", category)
        if retention_policy is not None:
            pulumi.set(__self__, "retention_policy", retention_policy)
        if time_grain is not None:
            pulumi.set(__self__, "time_grain", time_grain)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[bool]:
        """
        a value indicating whether this category is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def category(self) -> Optional[pulumi.Input[str]]:
        """
        Name of a Diagnostic Metric category for a resource type this setting is applied to. To obtain the list of Diagnostic metric categories for a resource, first perform a GET diagnostic settings operation.
        """
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "category", value)

    @property
    @pulumi.getter(name="retentionPolicy")
    def retention_policy(self) -> Optional[pulumi.Input['RetentionPolicyArgs']]:
        """
        the retention policy for this category.
        """
        return pulumi.get(self, "retention_policy")

    @retention_policy.setter
    def retention_policy(self, value: Optional[pulumi.Input['RetentionPolicyArgs']]):
        pulumi.set(self, "retention_policy", value)

    @property
    @pulumi.getter(name="timeGrain")
    def time_grain(self) -> Optional[pulumi.Input[str]]:
        """
        the timegrain of the metric in ISO8601 format.
        """
        return pulumi.get(self, "time_grain")

    @time_grain.setter
    def time_grain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_grain", value)


@pulumi.input_type
class MetricTriggerArgs:
    def __init__(__self__, *,
                 metric_name: pulumi.Input[str],
                 metric_resource_uri: pulumi.Input[str],
                 operator: pulumi.Input['ComparisonOperationType'],
                 statistic: pulumi.Input['MetricStatisticType'],
                 threshold: pulumi.Input[float],
                 time_aggregation: pulumi.Input['TimeAggregationType'],
                 time_grain: pulumi.Input[str],
                 time_window: pulumi.Input[str],
                 dimensions: Optional[pulumi.Input[Sequence[pulumi.Input['ScaleRuleMetricDimensionArgs']]]] = None,
                 divide_per_instance: Optional[pulumi.Input[bool]] = None,
                 metric_namespace: Optional[pulumi.Input[str]] = None,
                 metric_resource_location: Optional[pulumi.Input[str]] = None):
        """
        The trigger that results in a scaling action.
        :param pulumi.Input[str] metric_name: the name of the metric that defines what the rule monitors.
        :param pulumi.Input[str] metric_resource_uri: the resource identifier of the resource the rule monitors.
        :param pulumi.Input['ComparisonOperationType'] operator: the operator that is used to compare the metric data and the threshold.
        :param pulumi.Input['MetricStatisticType'] statistic: the metric statistic type. How the metrics from multiple instances are combined.
        :param pulumi.Input[float] threshold: the threshold of the metric that triggers the scale action.
        :param pulumi.Input['TimeAggregationType'] time_aggregation: time aggregation type. How the data that is collected should be combined over time. The default value is Average.
        :param pulumi.Input[str] time_grain: the granularity of metrics the rule monitors. Must be one of the predefined values returned from metric definitions for the metric. Must be between 12 hours and 1 minute.
        :param pulumi.Input[str] time_window: the range of time in which instance data is collected. This value must be greater than the delay in metric collection, which can vary from resource-to-resource. Must be between 12 hours and 5 minutes.
        :param pulumi.Input[Sequence[pulumi.Input['ScaleRuleMetricDimensionArgs']]] dimensions: List of dimension conditions. For example: [{"DimensionName":"AppName","Operator":"Equals","Values":["App1"]},{"DimensionName":"Deployment","Operator":"Equals","Values":["default"]}].
        :param pulumi.Input[bool] divide_per_instance: a value indicating whether metric should divide per instance.
        :param pulumi.Input[str] metric_namespace: the namespace of the metric that defines what the rule monitors.
        :param pulumi.Input[str] metric_resource_location: the location of the resource the rule monitors.
        """
        pulumi.set(__self__, "metric_name", metric_name)
        pulumi.set(__self__, "metric_resource_uri", metric_resource_uri)
        pulumi.set(__self__, "operator", operator)
        pulumi.set(__self__, "statistic", statistic)
        pulumi.set(__self__, "threshold", threshold)
        pulumi.set(__self__, "time_aggregation", time_aggregation)
        pulumi.set(__self__, "time_grain", time_grain)
        pulumi.set(__self__, "time_window", time_window)
        if dimensions is not None:
            pulumi.set(__self__, "dimensions", dimensions)
        if divide_per_instance is not None:
            pulumi.set(__self__, "divide_per_instance", divide_per_instance)
        if metric_namespace is not None:
            pulumi.set(__self__, "metric_namespace", metric_namespace)
        if metric_resource_location is not None:
            pulumi.set(__self__, "metric_resource_location", metric_resource_location)

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> pulumi.Input[str]:
        """
        the name of the metric that defines what the rule monitors.
        """
        return pulumi.get(self, "metric_name")

    @metric_name.setter
    def metric_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "metric_name", value)

    @property
    @pulumi.getter(name="metricResourceUri")
    def metric_resource_uri(self) -> pulumi.Input[str]:
        """
        the resource identifier of the resource the rule monitors.
        """
        return pulumi.get(self, "metric_resource_uri")

    @metric_resource_uri.setter
    def metric_resource_uri(self, value: pulumi.Input[str]):
        pulumi.set(self, "metric_resource_uri", value)

    @property
    @pulumi.getter
    def operator(self) -> pulumi.Input['ComparisonOperationType']:
        """
        the operator that is used to compare the metric data and the threshold.
        """
        return pulumi.get(self, "operator")

    @operator.setter
    def operator(self, value: pulumi.Input['ComparisonOperationType']):
        pulumi.set(self, "operator", value)

    @property
    @pulumi.getter
    def statistic(self) -> pulumi.Input['MetricStatisticType']:
        """
        the metric statistic type. How the metrics from multiple instances are combined.
        """
        return pulumi.get(self, "statistic")

    @statistic.setter
    def statistic(self, value: pulumi.Input['MetricStatisticType']):
        pulumi.set(self, "statistic", value)

    @property
    @pulumi.getter
    def threshold(self) -> pulumi.Input[float]:
        """
        the threshold of the metric that triggers the scale action.
        """
        return pulumi.get(self, "threshold")

    @threshold.setter
    def threshold(self, value: pulumi.Input[float]):
        pulumi.set(self, "threshold", value)

    @property
    @pulumi.getter(name="timeAggregation")
    def time_aggregation(self) -> pulumi.Input['TimeAggregationType']:
        """
        time aggregation type. How the data that is collected should be combined over time. The default value is Average.
        """
        return pulumi.get(self, "time_aggregation")

    @time_aggregation.setter
    def time_aggregation(self, value: pulumi.Input['TimeAggregationType']):
        pulumi.set(self, "time_aggregation", value)

    @property
    @pulumi.getter(name="timeGrain")
    def time_grain(self) -> pulumi.Input[str]:
        """
        the granularity of metrics the rule monitors. Must be one of the predefined values returned from metric definitions for the metric. Must be between 12 hours and 1 minute.
        """
        return pulumi.get(self, "time_grain")

    @time_grain.setter
    def time_grain(self, value: pulumi.Input[str]):
        pulumi.set(self, "time_grain", value)

    @property
    @pulumi.getter(name="timeWindow")
    def time_window(self) -> pulumi.Input[str]:
        """
        the range of time in which instance data is collected. This value must be greater than the delay in metric collection, which can vary from resource-to-resource. Must be between 12 hours and 5 minutes.
        """
        return pulumi.get(self, "time_window")

    @time_window.setter
    def time_window(self, value: pulumi.Input[str]):
        pulumi.set(self, "time_window", value)

    @property
    @pulumi.getter
    def dimensions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ScaleRuleMetricDimensionArgs']]]]:
        """
        List of dimension conditions. For example: [{"DimensionName":"AppName","Operator":"Equals","Values":["App1"]},{"DimensionName":"Deployment","Operator":"Equals","Values":["default"]}].
        """
        return pulumi.get(self, "dimensions")

    @dimensions.setter
    def dimensions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ScaleRuleMetricDimensionArgs']]]]):
        pulumi.set(self, "dimensions", value)

    @property
    @pulumi.getter(name="dividePerInstance")
    def divide_per_instance(self) -> Optional[pulumi.Input[bool]]:
        """
        a value indicating whether metric should divide per instance.
        """
        return pulumi.get(self, "divide_per_instance")

    @divide_per_instance.setter
    def divide_per_instance(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "divide_per_instance", value)

    @property
    @pulumi.getter(name="metricNamespace")
    def metric_namespace(self) -> Optional[pulumi.Input[str]]:
        """
        the namespace of the metric that defines what the rule monitors.
        """
        return pulumi.get(self, "metric_namespace")

    @metric_namespace.setter
    def metric_namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metric_namespace", value)

    @property
    @pulumi.getter(name="metricResourceLocation")
    def metric_resource_location(self) -> Optional[pulumi.Input[str]]:
        """
        the location of the resource the rule monitors.
        """
        return pulumi.get(self, "metric_resource_location")

    @metric_resource_location.setter
    def metric_resource_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metric_resource_location", value)


@pulumi.input_type
class MyWorkbookManagedIdentityArgs:
    def __init__(__self__, *,
                 type: Optional[pulumi.Input[str]] = None):
        """
        Customer Managed Identity
        :param pulumi.Input[str] type: The identity type.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The identity type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class PerfCounterDataSourceArgs:
    def __init__(__self__, *,
                 counter_specifiers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 sampling_frequency_in_seconds: Optional[pulumi.Input[int]] = None,
                 streams: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'KnownPerfCounterDataSourceStreams']]]]] = None):
        """
        Definition of which performance counters will be collected and how they will be collected by this data collection rule.
        Collected from both Windows and Linux machines where the counter is present.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] counter_specifiers: A list of specifier names of the performance counters you want to collect.
               Use a wildcard (*) to collect a counter for all instances.
               To get a list of performance counters on Windows, run the command 'typeperf'.
        :param pulumi.Input[str] name: A friendly name for the data source. 
               This name should be unique across all data sources (regardless of type) within the data collection rule.
        :param pulumi.Input[int] sampling_frequency_in_seconds: The number of seconds between consecutive counter measurements (samples).
        :param pulumi.Input[Sequence[pulumi.Input[Union[str, 'KnownPerfCounterDataSourceStreams']]]] streams: List of streams that this data source will be sent to.
               A stream indicates what schema will be used for this data and usually what table in Log Analytics the data will be sent to.
        """
        if counter_specifiers is not None:
            pulumi.set(__self__, "counter_specifiers", counter_specifiers)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if sampling_frequency_in_seconds is not None:
            pulumi.set(__self__, "sampling_frequency_in_seconds", sampling_frequency_in_seconds)
        if streams is not None:
            pulumi.set(__self__, "streams", streams)

    @property
    @pulumi.getter(name="counterSpecifiers")
    def counter_specifiers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of specifier names of the performance counters you want to collect.
        Use a wildcard (*) to collect a counter for all instances.
        To get a list of performance counters on Windows, run the command 'typeperf'.
        """
        return pulumi.get(self, "counter_specifiers")

    @counter_specifiers.setter
    def counter_specifiers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "counter_specifiers", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A friendly name for the data source. 
        This name should be unique across all data sources (regardless of type) within the data collection rule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="samplingFrequencyInSeconds")
    def sampling_frequency_in_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        The number of seconds between consecutive counter measurements (samples).
        """
        return pulumi.get(self, "sampling_frequency_in_seconds")

    @sampling_frequency_in_seconds.setter
    def sampling_frequency_in_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "sampling_frequency_in_seconds", value)

    @property
    @pulumi.getter
    def streams(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'KnownPerfCounterDataSourceStreams']]]]]:
        """
        List of streams that this data source will be sent to.
        A stream indicates what schema will be used for this data and usually what table in Log Analytics the data will be sent to.
        """
        return pulumi.get(self, "streams")

    @streams.setter
    def streams(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'KnownPerfCounterDataSourceStreams']]]]]):
        pulumi.set(self, "streams", value)


@pulumi.input_type
class PerformanceCounterConfigurationArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 sampling_period: pulumi.Input[str],
                 instance: Optional[pulumi.Input[str]] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "sampling_period", sampling_period)
        if instance is not None:
            pulumi.set(__self__, "instance", instance)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="samplingPeriod")
    def sampling_period(self) -> pulumi.Input[str]:
        return pulumi.get(self, "sampling_period")

    @sampling_period.setter
    def sampling_period(self, value: pulumi.Input[str]):
        pulumi.set(self, "sampling_period", value)

    @property
    @pulumi.getter
    def instance(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "instance")

    @instance.setter
    def instance(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance", value)


@pulumi.input_type
class PrivateEndpointPropertyArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None):
        """
        Private endpoint which the connection belongs to.
        :param pulumi.Input[str] id: Resource id of the private endpoint.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Resource id of the private endpoint.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class PrivateLinkServiceConnectionStatePropertyArgs:
    def __init__(__self__, *,
                 description: pulumi.Input[str],
                 status: pulumi.Input[str]):
        """
        State of the private endpoint connection.
        :param pulumi.Input[str] description: The private link service connection description.
        :param pulumi.Input[str] status: The private link service connection status.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Input[str]:
        """
        The private link service connection description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[str]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def status(self) -> pulumi.Input[str]:
        """
        The private link service connection status.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: pulumi.Input[str]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class RecurrenceArgs:
    def __init__(__self__, *,
                 frequency: pulumi.Input['RecurrenceFrequency'],
                 schedule: pulumi.Input['RecurrentScheduleArgs']):
        """
        The repeating times at which this profile begins. This element is not used if the FixedDate element is used.
        :param pulumi.Input['RecurrenceFrequency'] frequency: the recurrence frequency. How often the schedule profile should take effect. This value must be Week, meaning each week will have the same set of profiles. For example, to set a daily schedule, set **schedule** to every day of the week. The frequency property specifies that the schedule is repeated weekly.
        :param pulumi.Input['RecurrentScheduleArgs'] schedule: the scheduling constraints for when the profile begins.
        """
        pulumi.set(__self__, "frequency", frequency)
        pulumi.set(__self__, "schedule", schedule)

    @property
    @pulumi.getter
    def frequency(self) -> pulumi.Input['RecurrenceFrequency']:
        """
        the recurrence frequency. How often the schedule profile should take effect. This value must be Week, meaning each week will have the same set of profiles. For example, to set a daily schedule, set **schedule** to every day of the week. The frequency property specifies that the schedule is repeated weekly.
        """
        return pulumi.get(self, "frequency")

    @frequency.setter
    def frequency(self, value: pulumi.Input['RecurrenceFrequency']):
        pulumi.set(self, "frequency", value)

    @property
    @pulumi.getter
    def schedule(self) -> pulumi.Input['RecurrentScheduleArgs']:
        """
        the scheduling constraints for when the profile begins.
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: pulumi.Input['RecurrentScheduleArgs']):
        pulumi.set(self, "schedule", value)


@pulumi.input_type
class RecurrentScheduleArgs:
    def __init__(__self__, *,
                 days: pulumi.Input[Sequence[pulumi.Input[str]]],
                 hours: pulumi.Input[Sequence[pulumi.Input[int]]],
                 minutes: pulumi.Input[Sequence[pulumi.Input[int]]],
                 time_zone: pulumi.Input[str]):
        """
        The scheduling constraints for when the profile begins.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] days: the collection of days that the profile takes effect on. Possible values are Sunday through Saturday.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] hours: A collection of hours that the profile takes effect on. Values supported are 0 to 23 on the 24-hour clock (AM/PM times are not supported).
        :param pulumi.Input[Sequence[pulumi.Input[int]]] minutes: A collection of minutes at which the profile takes effect at.
        :param pulumi.Input[str] time_zone: the timezone for the hours of the profile. Some examples of valid time zones are: Dateline Standard Time, UTC-11, Hawaiian Standard Time, Alaskan Standard Time, Pacific Standard Time (Mexico), Pacific Standard Time, US Mountain Standard Time, Mountain Standard Time (Mexico), Mountain Standard Time, Central America Standard Time, Central Standard Time, Central Standard Time (Mexico), Canada Central Standard Time, SA Pacific Standard Time, Eastern Standard Time, US Eastern Standard Time, Venezuela Standard Time, Paraguay Standard Time, Atlantic Standard Time, Central Brazilian Standard Time, SA Western Standard Time, Pacific SA Standard Time, Newfoundland Standard Time, E. South America Standard Time, Argentina Standard Time, SA Eastern Standard Time, Greenland Standard Time, Montevideo Standard Time, Bahia Standard Time, UTC-02, Mid-Atlantic Standard Time, Azores Standard Time, Cape Verde Standard Time, Morocco Standard Time, UTC, GMT Standard Time, Greenwich Standard Time, W. Europe Standard Time, Central Europe Standard Time, Romance Standard Time, Central European Standard Time, W. Central Africa Standard Time, Namibia Standard Time, Jordan Standard Time, GTB Standard Time, Middle East Standard Time, Egypt Standard Time, Syria Standard Time, E. Europe Standard Time, South Africa Standard Time, FLE Standard Time, Turkey Standard Time, Israel Standard Time, Kaliningrad Standard Time, Libya Standard Time, Arabic Standard Time, Arab Standard Time, Belarus Standard Time, Russian Standard Time, E. Africa Standard Time, Iran Standard Time, Arabian Standard Time, Azerbaijan Standard Time, Russia Time Zone 3, Mauritius Standard Time, Georgian Standard Time, Caucasus Standard Time, Afghanistan Standard Time, West Asia Standard Time, Ekaterinburg Standard Time, Pakistan Standard Time, India Standard Time, Sri Lanka Standard Time, Nepal Standard Time, Central Asia Standard Time, Bangladesh Standard Time, N. Central Asia Standard Time, Myanmar Standard Time, SE Asia Standard Time, North Asia Standard Time, China Standard Time, North Asia East Standard Time, Singapore Standard Time, W. Australia Standard Time, Taipei Standard Time, Ulaanbaatar Standard Time, Tokyo Standard Time, Korea Standard Time, Yakutsk Standard Time, Cen. Australia Standard Time, AUS Central Standard Time, E. Australia Standard Time, AUS Eastern Standard Time, West Pacific Standard Time, Tasmania Standard Time, Magadan Standard Time, Vladivostok Standard Time, Russia Time Zone 10, Central Pacific Standard Time, Russia Time Zone 11, New Zealand Standard Time, UTC+12, Fiji Standard Time, Kamchatka Standard Time, Tonga Standard Time, Samoa Standard Time, Line Islands Standard Time
        """
        pulumi.set(__self__, "days", days)
        pulumi.set(__self__, "hours", hours)
        pulumi.set(__self__, "minutes", minutes)
        pulumi.set(__self__, "time_zone", time_zone)

    @property
    @pulumi.getter
    def days(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        the collection of days that the profile takes effect on. Possible values are Sunday through Saturday.
        """
        return pulumi.get(self, "days")

    @days.setter
    def days(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "days", value)

    @property
    @pulumi.getter
    def hours(self) -> pulumi.Input[Sequence[pulumi.Input[int]]]:
        """
        A collection of hours that the profile takes effect on. Values supported are 0 to 23 on the 24-hour clock (AM/PM times are not supported).
        """
        return pulumi.get(self, "hours")

    @hours.setter
    def hours(self, value: pulumi.Input[Sequence[pulumi.Input[int]]]):
        pulumi.set(self, "hours", value)

    @property
    @pulumi.getter
    def minutes(self) -> pulumi.Input[Sequence[pulumi.Input[int]]]:
        """
        A collection of minutes at which the profile takes effect at.
        """
        return pulumi.get(self, "minutes")

    @minutes.setter
    def minutes(self, value: pulumi.Input[Sequence[pulumi.Input[int]]]):
        pulumi.set(self, "minutes", value)

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> pulumi.Input[str]:
        """
        the timezone for the hours of the profile. Some examples of valid time zones are: Dateline Standard Time, UTC-11, Hawaiian Standard Time, Alaskan Standard Time, Pacific Standard Time (Mexico), Pacific Standard Time, US Mountain Standard Time, Mountain Standard Time (Mexico), Mountain Standard Time, Central America Standard Time, Central Standard Time, Central Standard Time (Mexico), Canada Central Standard Time, SA Pacific Standard Time, Eastern Standard Time, US Eastern Standard Time, Venezuela Standard Time, Paraguay Standard Time, Atlantic Standard Time, Central Brazilian Standard Time, SA Western Standard Time, Pacific SA Standard Time, Newfoundland Standard Time, E. South America Standard Time, Argentina Standard Time, SA Eastern Standard Time, Greenland Standard Time, Montevideo Standard Time, Bahia Standard Time, UTC-02, Mid-Atlantic Standard Time, Azores Standard Time, Cape Verde Standard Time, Morocco Standard Time, UTC, GMT Standard Time, Greenwich Standard Time, W. Europe Standard Time, Central Europe Standard Time, Romance Standard Time, Central European Standard Time, W. Central Africa Standard Time, Namibia Standard Time, Jordan Standard Time, GTB Standard Time, Middle East Standard Time, Egypt Standard Time, Syria Standard Time, E. Europe Standard Time, South Africa Standard Time, FLE Standard Time, Turkey Standard Time, Israel Standard Time, Kaliningrad Standard Time, Libya Standard Time, Arabic Standard Time, Arab Standard Time, Belarus Standard Time, Russian Standard Time, E. Africa Standard Time, Iran Standard Time, Arabian Standard Time, Azerbaijan Standard Time, Russia Time Zone 3, Mauritius Standard Time, Georgian Standard Time, Caucasus Standard Time, Afghanistan Standard Time, West Asia Standard Time, Ekaterinburg Standard Time, Pakistan Standard Time, India Standard Time, Sri Lanka Standard Time, Nepal Standard Time, Central Asia Standard Time, Bangladesh Standard Time, N. Central Asia Standard Time, Myanmar Standard Time, SE Asia Standard Time, North Asia Standard Time, China Standard Time, North Asia East Standard Time, Singapore Standard Time, W. Australia Standard Time, Taipei Standard Time, Ulaanbaatar Standard Time, Tokyo Standard Time, Korea Standard Time, Yakutsk Standard Time, Cen. Australia Standard Time, AUS Central Standard Time, E. Australia Standard Time, AUS Eastern Standard Time, West Pacific Standard Time, Tasmania Standard Time, Magadan Standard Time, Vladivostok Standard Time, Russia Time Zone 10, Central Pacific Standard Time, Russia Time Zone 11, New Zealand Standard Time, UTC+12, Fiji Standard Time, Kamchatka Standard Time, Tonga Standard Time, Samoa Standard Time, Line Islands Standard Time
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: pulumi.Input[str]):
        pulumi.set(self, "time_zone", value)


@pulumi.input_type
class RetentionPolicyArgs:
    def __init__(__self__, *,
                 days: pulumi.Input[int],
                 enabled: pulumi.Input[bool]):
        """
        Specifies the retention policy for the log.
        :param pulumi.Input[int] days: the number of days for the retention in days. A value of 0 will retain the events indefinitely.
        :param pulumi.Input[bool] enabled: a value indicating whether the retention policy is enabled.
        """
        pulumi.set(__self__, "days", days)
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def days(self) -> pulumi.Input[int]:
        """
        the number of days for the retention in days. A value of 0 will retain the events indefinitely.
        """
        return pulumi.get(self, "days")

    @days.setter
    def days(self, value: pulumi.Input[int]):
        pulumi.set(self, "days", value)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[bool]:
        """
        a value indicating whether the retention policy is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enabled", value)


@pulumi.input_type
class RuleEmailActionArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str],
                 custom_emails: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 send_to_service_owners: Optional[pulumi.Input[bool]] = None):
        """
        Specifies the action to send email when the rule condition is evaluated. The discriminator is always RuleEmailAction in this case.
        :param pulumi.Input[str] odata_type: specifies the type of the action. There are two types of actions: RuleEmailAction and RuleWebhookAction.
               Expected value is 'Microsoft.Azure.Management.Insights.Models.RuleEmailAction'.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] custom_emails: the list of administrator's custom email addresses to notify of the activation of the alert.
        :param pulumi.Input[bool] send_to_service_owners: Whether the administrators (service and co-administrators) of the service should be notified when the alert is activated.
        """
        pulumi.set(__self__, "odata_type", 'Microsoft.Azure.Management.Insights.Models.RuleEmailAction')
        if custom_emails is not None:
            pulumi.set(__self__, "custom_emails", custom_emails)
        if send_to_service_owners is not None:
            pulumi.set(__self__, "send_to_service_owners", send_to_service_owners)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        specifies the type of the action. There are two types of actions: RuleEmailAction and RuleWebhookAction.
        Expected value is 'Microsoft.Azure.Management.Insights.Models.RuleEmailAction'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter(name="customEmails")
    def custom_emails(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        the list of administrator's custom email addresses to notify of the activation of the alert.
        """
        return pulumi.get(self, "custom_emails")

    @custom_emails.setter
    def custom_emails(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "custom_emails", value)

    @property
    @pulumi.getter(name="sendToServiceOwners")
    def send_to_service_owners(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the administrators (service and co-administrators) of the service should be notified when the alert is activated.
        """
        return pulumi.get(self, "send_to_service_owners")

    @send_to_service_owners.setter
    def send_to_service_owners(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "send_to_service_owners", value)


@pulumi.input_type
class RuleManagementEventClaimsDataSourceArgs:
    def __init__(__self__, *,
                 email_address: Optional[pulumi.Input[str]] = None):
        """
        The claims for a rule management event data source.
        :param pulumi.Input[str] email_address: the email address.
        """
        if email_address is not None:
            pulumi.set(__self__, "email_address", email_address)

    @property
    @pulumi.getter(name="emailAddress")
    def email_address(self) -> Optional[pulumi.Input[str]]:
        """
        the email address.
        """
        return pulumi.get(self, "email_address")

    @email_address.setter
    def email_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email_address", value)


@pulumi.input_type
class RuleManagementEventDataSourceArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str],
                 claims: Optional[pulumi.Input['RuleManagementEventClaimsDataSourceArgs']] = None,
                 event_name: Optional[pulumi.Input[str]] = None,
                 event_source: Optional[pulumi.Input[str]] = None,
                 legacy_resource_id: Optional[pulumi.Input[str]] = None,
                 level: Optional[pulumi.Input[str]] = None,
                 metric_namespace: Optional[pulumi.Input[str]] = None,
                 operation_name: Optional[pulumi.Input[str]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 resource_location: Optional[pulumi.Input[str]] = None,
                 resource_provider_name: Optional[pulumi.Input[str]] = None,
                 resource_uri: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 sub_status: Optional[pulumi.Input[str]] = None):
        """
        A rule management event data source. The discriminator fields is always RuleManagementEventDataSource in this case.
        :param pulumi.Input[str] odata_type: specifies the type of data source. There are two types of rule data sources: RuleMetricDataSource and RuleManagementEventDataSource
               Expected value is 'Microsoft.Azure.Management.Insights.Models.RuleManagementEventDataSource'.
        :param pulumi.Input['RuleManagementEventClaimsDataSourceArgs'] claims: the claims.
        :param pulumi.Input[str] event_name: the event name.
        :param pulumi.Input[str] event_source: the event source.
        :param pulumi.Input[str] legacy_resource_id: the legacy resource identifier of the resource the rule monitors. **NOTE**: this property cannot be updated for an existing rule.
        :param pulumi.Input[str] level: the level.
        :param pulumi.Input[str] metric_namespace: the namespace of the metric.
        :param pulumi.Input[str] operation_name: The name of the operation that should be checked for. If no name is provided, any operation will match.
        :param pulumi.Input[str] resource_group_name: the resource group name.
        :param pulumi.Input[str] resource_location: the location of the resource.
        :param pulumi.Input[str] resource_provider_name: the resource provider name.
        :param pulumi.Input[str] resource_uri: the resource identifier of the resource the rule monitors. **NOTE**: this property cannot be updated for an existing rule.
        :param pulumi.Input[str] status: The status of the operation that should be checked for. If no status is provided, any status will match.
        :param pulumi.Input[str] sub_status: the substatus.
        """
        pulumi.set(__self__, "odata_type", 'Microsoft.Azure.Management.Insights.Models.RuleManagementEventDataSource')
        if claims is not None:
            pulumi.set(__self__, "claims", claims)
        if event_name is not None:
            pulumi.set(__self__, "event_name", event_name)
        if event_source is not None:
            pulumi.set(__self__, "event_source", event_source)
        if legacy_resource_id is not None:
            pulumi.set(__self__, "legacy_resource_id", legacy_resource_id)
        if level is not None:
            pulumi.set(__self__, "level", level)
        if metric_namespace is not None:
            pulumi.set(__self__, "metric_namespace", metric_namespace)
        if operation_name is not None:
            pulumi.set(__self__, "operation_name", operation_name)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if resource_location is not None:
            pulumi.set(__self__, "resource_location", resource_location)
        if resource_provider_name is not None:
            pulumi.set(__self__, "resource_provider_name", resource_provider_name)
        if resource_uri is not None:
            pulumi.set(__self__, "resource_uri", resource_uri)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if sub_status is not None:
            pulumi.set(__self__, "sub_status", sub_status)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        specifies the type of data source. There are two types of rule data sources: RuleMetricDataSource and RuleManagementEventDataSource
        Expected value is 'Microsoft.Azure.Management.Insights.Models.RuleManagementEventDataSource'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter
    def claims(self) -> Optional[pulumi.Input['RuleManagementEventClaimsDataSourceArgs']]:
        """
        the claims.
        """
        return pulumi.get(self, "claims")

    @claims.setter
    def claims(self, value: Optional[pulumi.Input['RuleManagementEventClaimsDataSourceArgs']]):
        pulumi.set(self, "claims", value)

    @property
    @pulumi.getter(name="eventName")
    def event_name(self) -> Optional[pulumi.Input[str]]:
        """
        the event name.
        """
        return pulumi.get(self, "event_name")

    @event_name.setter
    def event_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "event_name", value)

    @property
    @pulumi.getter(name="eventSource")
    def event_source(self) -> Optional[pulumi.Input[str]]:
        """
        the event source.
        """
        return pulumi.get(self, "event_source")

    @event_source.setter
    def event_source(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "event_source", value)

    @property
    @pulumi.getter(name="legacyResourceId")
    def legacy_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        the legacy resource identifier of the resource the rule monitors. **NOTE**: this property cannot be updated for an existing rule.
        """
        return pulumi.get(self, "legacy_resource_id")

    @legacy_resource_id.setter
    def legacy_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "legacy_resource_id", value)

    @property
    @pulumi.getter
    def level(self) -> Optional[pulumi.Input[str]]:
        """
        the level.
        """
        return pulumi.get(self, "level")

    @level.setter
    def level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "level", value)

    @property
    @pulumi.getter(name="metricNamespace")
    def metric_namespace(self) -> Optional[pulumi.Input[str]]:
        """
        the namespace of the metric.
        """
        return pulumi.get(self, "metric_namespace")

    @metric_namespace.setter
    def metric_namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metric_namespace", value)

    @property
    @pulumi.getter(name="operationName")
    def operation_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the operation that should be checked for. If no name is provided, any operation will match.
        """
        return pulumi.get(self, "operation_name")

    @operation_name.setter
    def operation_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "operation_name", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[str]]:
        """
        the resource group name.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="resourceLocation")
    def resource_location(self) -> Optional[pulumi.Input[str]]:
        """
        the location of the resource.
        """
        return pulumi.get(self, "resource_location")

    @resource_location.setter
    def resource_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_location", value)

    @property
    @pulumi.getter(name="resourceProviderName")
    def resource_provider_name(self) -> Optional[pulumi.Input[str]]:
        """
        the resource provider name.
        """
        return pulumi.get(self, "resource_provider_name")

    @resource_provider_name.setter
    def resource_provider_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_provider_name", value)

    @property
    @pulumi.getter(name="resourceUri")
    def resource_uri(self) -> Optional[pulumi.Input[str]]:
        """
        the resource identifier of the resource the rule monitors. **NOTE**: this property cannot be updated for an existing rule.
        """
        return pulumi.get(self, "resource_uri")

    @resource_uri.setter
    def resource_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_uri", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the operation that should be checked for. If no status is provided, any status will match.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="subStatus")
    def sub_status(self) -> Optional[pulumi.Input[str]]:
        """
        the substatus.
        """
        return pulumi.get(self, "sub_status")

    @sub_status.setter
    def sub_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sub_status", value)


@pulumi.input_type
class RuleMetricDataSourceArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str],
                 legacy_resource_id: Optional[pulumi.Input[str]] = None,
                 metric_name: Optional[pulumi.Input[str]] = None,
                 metric_namespace: Optional[pulumi.Input[str]] = None,
                 resource_location: Optional[pulumi.Input[str]] = None,
                 resource_uri: Optional[pulumi.Input[str]] = None):
        """
        A rule metric data source. The discriminator value is always RuleMetricDataSource in this case.
        :param pulumi.Input[str] odata_type: specifies the type of data source. There are two types of rule data sources: RuleMetricDataSource and RuleManagementEventDataSource
               Expected value is 'Microsoft.Azure.Management.Insights.Models.RuleMetricDataSource'.
        :param pulumi.Input[str] legacy_resource_id: the legacy resource identifier of the resource the rule monitors. **NOTE**: this property cannot be updated for an existing rule.
        :param pulumi.Input[str] metric_name: the name of the metric that defines what the rule monitors.
        :param pulumi.Input[str] metric_namespace: the namespace of the metric.
        :param pulumi.Input[str] resource_location: the location of the resource.
        :param pulumi.Input[str] resource_uri: the resource identifier of the resource the rule monitors. **NOTE**: this property cannot be updated for an existing rule.
        """
        pulumi.set(__self__, "odata_type", 'Microsoft.Azure.Management.Insights.Models.RuleMetricDataSource')
        if legacy_resource_id is not None:
            pulumi.set(__self__, "legacy_resource_id", legacy_resource_id)
        if metric_name is not None:
            pulumi.set(__self__, "metric_name", metric_name)
        if metric_namespace is not None:
            pulumi.set(__self__, "metric_namespace", metric_namespace)
        if resource_location is not None:
            pulumi.set(__self__, "resource_location", resource_location)
        if resource_uri is not None:
            pulumi.set(__self__, "resource_uri", resource_uri)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        specifies the type of data source. There are two types of rule data sources: RuleMetricDataSource and RuleManagementEventDataSource
        Expected value is 'Microsoft.Azure.Management.Insights.Models.RuleMetricDataSource'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter(name="legacyResourceId")
    def legacy_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        the legacy resource identifier of the resource the rule monitors. **NOTE**: this property cannot be updated for an existing rule.
        """
        return pulumi.get(self, "legacy_resource_id")

    @legacy_resource_id.setter
    def legacy_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "legacy_resource_id", value)

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> Optional[pulumi.Input[str]]:
        """
        the name of the metric that defines what the rule monitors.
        """
        return pulumi.get(self, "metric_name")

    @metric_name.setter
    def metric_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metric_name", value)

    @property
    @pulumi.getter(name="metricNamespace")
    def metric_namespace(self) -> Optional[pulumi.Input[str]]:
        """
        the namespace of the metric.
        """
        return pulumi.get(self, "metric_namespace")

    @metric_namespace.setter
    def metric_namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metric_namespace", value)

    @property
    @pulumi.getter(name="resourceLocation")
    def resource_location(self) -> Optional[pulumi.Input[str]]:
        """
        the location of the resource.
        """
        return pulumi.get(self, "resource_location")

    @resource_location.setter
    def resource_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_location", value)

    @property
    @pulumi.getter(name="resourceUri")
    def resource_uri(self) -> Optional[pulumi.Input[str]]:
        """
        the resource identifier of the resource the rule monitors. **NOTE**: this property cannot be updated for an existing rule.
        """
        return pulumi.get(self, "resource_uri")

    @resource_uri.setter
    def resource_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_uri", value)


@pulumi.input_type
class RuleWebhookActionArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str],
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 service_uri: Optional[pulumi.Input[str]] = None):
        """
        Specifies the action to post to service when the rule condition is evaluated. The discriminator is always RuleWebhookAction in this case.
        :param pulumi.Input[str] odata_type: specifies the type of the action. There are two types of actions: RuleEmailAction and RuleWebhookAction.
               Expected value is 'Microsoft.Azure.Management.Insights.Models.RuleWebhookAction'.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: the dictionary of custom properties to include with the post operation. These data are appended to the webhook payload.
        :param pulumi.Input[str] service_uri: the service uri to Post the notification when the alert activates or resolves.
        """
        pulumi.set(__self__, "odata_type", 'Microsoft.Azure.Management.Insights.Models.RuleWebhookAction')
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if service_uri is not None:
            pulumi.set(__self__, "service_uri", service_uri)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        specifies the type of the action. There are two types of actions: RuleEmailAction and RuleWebhookAction.
        Expected value is 'Microsoft.Azure.Management.Insights.Models.RuleWebhookAction'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        the dictionary of custom properties to include with the post operation. These data are appended to the webhook payload.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter(name="serviceUri")
    def service_uri(self) -> Optional[pulumi.Input[str]]:
        """
        the service uri to Post the notification when the alert activates or resolves.
        """
        return pulumi.get(self, "service_uri")

    @service_uri.setter
    def service_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_uri", value)


@pulumi.input_type
class ScaleActionArgs:
    def __init__(__self__, *,
                 cooldown: pulumi.Input[str],
                 direction: pulumi.Input['ScaleDirection'],
                 type: pulumi.Input['ScaleType'],
                 value: Optional[pulumi.Input[str]] = None):
        """
        The parameters for the scaling action.
        :param pulumi.Input[str] cooldown: the amount of time to wait since the last scaling action before this action occurs. It must be between 1 week and 1 minute in ISO 8601 format.
        :param pulumi.Input['ScaleDirection'] direction: the scale direction. Whether the scaling action increases or decreases the number of instances.
        :param pulumi.Input['ScaleType'] type: the type of action that should occur when the scale rule fires.
        :param pulumi.Input[str] value: the number of instances that are involved in the scaling action. This value must be 1 or greater. The default value is 1.
        """
        pulumi.set(__self__, "cooldown", cooldown)
        pulumi.set(__self__, "direction", direction)
        pulumi.set(__self__, "type", type)
        if value is None:
            value = '1'
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def cooldown(self) -> pulumi.Input[str]:
        """
        the amount of time to wait since the last scaling action before this action occurs. It must be between 1 week and 1 minute in ISO 8601 format.
        """
        return pulumi.get(self, "cooldown")

    @cooldown.setter
    def cooldown(self, value: pulumi.Input[str]):
        pulumi.set(self, "cooldown", value)

    @property
    @pulumi.getter
    def direction(self) -> pulumi.Input['ScaleDirection']:
        """
        the scale direction. Whether the scaling action increases or decreases the number of instances.
        """
        return pulumi.get(self, "direction")

    @direction.setter
    def direction(self, value: pulumi.Input['ScaleDirection']):
        pulumi.set(self, "direction", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input['ScaleType']:
        """
        the type of action that should occur when the scale rule fires.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input['ScaleType']):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        the number of instances that are involved in the scaling action. This value must be 1 or greater. The default value is 1.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class ScaleCapacityArgs:
    def __init__(__self__, *,
                 default: pulumi.Input[str],
                 maximum: pulumi.Input[str],
                 minimum: pulumi.Input[str]):
        """
        The number of instances that can be used during this profile.
        :param pulumi.Input[str] default: the number of instances that will be set if metrics are not available for evaluation. The default is only used if the current instance count is lower than the default.
        :param pulumi.Input[str] maximum: the maximum number of instances for the resource. The actual maximum number of instances is limited by the cores that are available in the subscription.
        :param pulumi.Input[str] minimum: the minimum number of instances for the resource.
        """
        pulumi.set(__self__, "default", default)
        pulumi.set(__self__, "maximum", maximum)
        pulumi.set(__self__, "minimum", minimum)

    @property
    @pulumi.getter
    def default(self) -> pulumi.Input[str]:
        """
        the number of instances that will be set if metrics are not available for evaluation. The default is only used if the current instance count is lower than the default.
        """
        return pulumi.get(self, "default")

    @default.setter
    def default(self, value: pulumi.Input[str]):
        pulumi.set(self, "default", value)

    @property
    @pulumi.getter
    def maximum(self) -> pulumi.Input[str]:
        """
        the maximum number of instances for the resource. The actual maximum number of instances is limited by the cores that are available in the subscription.
        """
        return pulumi.get(self, "maximum")

    @maximum.setter
    def maximum(self, value: pulumi.Input[str]):
        pulumi.set(self, "maximum", value)

    @property
    @pulumi.getter
    def minimum(self) -> pulumi.Input[str]:
        """
        the minimum number of instances for the resource.
        """
        return pulumi.get(self, "minimum")

    @minimum.setter
    def minimum(self, value: pulumi.Input[str]):
        pulumi.set(self, "minimum", value)


@pulumi.input_type
class ScaleRuleMetricDimensionArgs:
    def __init__(__self__, *,
                 dimension_name: pulumi.Input[str],
                 operator: pulumi.Input[Union[str, 'ScaleRuleMetricDimensionOperationType']],
                 values: pulumi.Input[Sequence[pulumi.Input[str]]]):
        """
        Specifies an auto scale rule metric dimension.
        :param pulumi.Input[str] dimension_name: Name of the dimension.
        :param pulumi.Input[Union[str, 'ScaleRuleMetricDimensionOperationType']] operator: the dimension operator. Only 'Equals' and 'NotEquals' are supported. 'Equals' being equal to any of the values. 'NotEquals' being not equal to all of the values
        :param pulumi.Input[Sequence[pulumi.Input[str]]] values: list of dimension values. For example: ["App1","App2"].
        """
        pulumi.set(__self__, "dimension_name", dimension_name)
        pulumi.set(__self__, "operator", operator)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter(name="dimensionName")
    def dimension_name(self) -> pulumi.Input[str]:
        """
        Name of the dimension.
        """
        return pulumi.get(self, "dimension_name")

    @dimension_name.setter
    def dimension_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "dimension_name", value)

    @property
    @pulumi.getter
    def operator(self) -> pulumi.Input[Union[str, 'ScaleRuleMetricDimensionOperationType']]:
        """
        the dimension operator. Only 'Equals' and 'NotEquals' are supported. 'Equals' being equal to any of the values. 'NotEquals' being not equal to all of the values
        """
        return pulumi.get(self, "operator")

    @operator.setter
    def operator(self, value: pulumi.Input[Union[str, 'ScaleRuleMetricDimensionOperationType']]):
        pulumi.set(self, "operator", value)

    @property
    @pulumi.getter
    def values(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        list of dimension values. For example: ["App1","App2"].
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class ScaleRuleArgs:
    def __init__(__self__, *,
                 metric_trigger: pulumi.Input['MetricTriggerArgs'],
                 scale_action: pulumi.Input['ScaleActionArgs']):
        """
        A rule that provide the triggers and parameters for the scaling action.
        :param pulumi.Input['MetricTriggerArgs'] metric_trigger: the trigger that results in a scaling action.
        :param pulumi.Input['ScaleActionArgs'] scale_action: the parameters for the scaling action.
        """
        pulumi.set(__self__, "metric_trigger", metric_trigger)
        pulumi.set(__self__, "scale_action", scale_action)

    @property
    @pulumi.getter(name="metricTrigger")
    def metric_trigger(self) -> pulumi.Input['MetricTriggerArgs']:
        """
        the trigger that results in a scaling action.
        """
        return pulumi.get(self, "metric_trigger")

    @metric_trigger.setter
    def metric_trigger(self, value: pulumi.Input['MetricTriggerArgs']):
        pulumi.set(self, "metric_trigger", value)

    @property
    @pulumi.getter(name="scaleAction")
    def scale_action(self) -> pulumi.Input['ScaleActionArgs']:
        """
        the parameters for the scaling action.
        """
        return pulumi.get(self, "scale_action")

    @scale_action.setter
    def scale_action(self, value: pulumi.Input['ScaleActionArgs']):
        pulumi.set(self, "scale_action", value)


@pulumi.input_type
class ScheduleArgs:
    def __init__(__self__, *,
                 frequency_in_minutes: pulumi.Input[int],
                 time_window_in_minutes: pulumi.Input[int]):
        """
        Defines how often to run the search and the time interval.
        :param pulumi.Input[int] frequency_in_minutes: frequency (in minutes) at which rule condition should be evaluated.
        :param pulumi.Input[int] time_window_in_minutes: Time window for which data needs to be fetched for query (should be greater than or equal to frequencyInMinutes).
        """
        pulumi.set(__self__, "frequency_in_minutes", frequency_in_minutes)
        pulumi.set(__self__, "time_window_in_minutes", time_window_in_minutes)

    @property
    @pulumi.getter(name="frequencyInMinutes")
    def frequency_in_minutes(self) -> pulumi.Input[int]:
        """
        frequency (in minutes) at which rule condition should be evaluated.
        """
        return pulumi.get(self, "frequency_in_minutes")

    @frequency_in_minutes.setter
    def frequency_in_minutes(self, value: pulumi.Input[int]):
        pulumi.set(self, "frequency_in_minutes", value)

    @property
    @pulumi.getter(name="timeWindowInMinutes")
    def time_window_in_minutes(self) -> pulumi.Input[int]:
        """
        Time window for which data needs to be fetched for query (should be greater than or equal to frequencyInMinutes).
        """
        return pulumi.get(self, "time_window_in_minutes")

    @time_window_in_minutes.setter
    def time_window_in_minutes(self, value: pulumi.Input[int]):
        pulumi.set(self, "time_window_in_minutes", value)


@pulumi.input_type
class SinkConfigurationArgs:
    def __init__(__self__, *,
                 kind: pulumi.Input[str]):
        pulumi.set(__self__, "kind", kind)

    @property
    @pulumi.getter
    def kind(self) -> pulumi.Input[str]:
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: pulumi.Input[str]):
        pulumi.set(self, "kind", value)


@pulumi.input_type
class SmsReceiverArgs:
    def __init__(__self__, *,
                 country_code: pulumi.Input[str],
                 name: pulumi.Input[str],
                 phone_number: pulumi.Input[str]):
        """
        An SMS receiver.
        :param pulumi.Input[str] country_code: The country code of the SMS receiver.
        :param pulumi.Input[str] name: The name of the SMS receiver. Names must be unique across all receivers within an action group.
        :param pulumi.Input[str] phone_number: The phone number of the SMS receiver.
        """
        pulumi.set(__self__, "country_code", country_code)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "phone_number", phone_number)

    @property
    @pulumi.getter(name="countryCode")
    def country_code(self) -> pulumi.Input[str]:
        """
        The country code of the SMS receiver.
        """
        return pulumi.get(self, "country_code")

    @country_code.setter
    def country_code(self, value: pulumi.Input[str]):
        pulumi.set(self, "country_code", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the SMS receiver. Names must be unique across all receivers within an action group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="phoneNumber")
    def phone_number(self) -> pulumi.Input[str]:
        """
        The phone number of the SMS receiver.
        """
        return pulumi.get(self, "phone_number")

    @phone_number.setter
    def phone_number(self, value: pulumi.Input[str]):
        pulumi.set(self, "phone_number", value)


@pulumi.input_type
class SourceArgs:
    def __init__(__self__, *,
                 data_source_id: pulumi.Input[str],
                 authorized_resources: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 query: Optional[pulumi.Input[str]] = None,
                 query_type: Optional[pulumi.Input[Union[str, 'QueryType']]] = None):
        """
        Specifies the log search query.
        :param pulumi.Input[str] data_source_id: The resource uri over which log search query is to be run.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] authorized_resources: List of  Resource referred into query
        :param pulumi.Input[str] query: Log search query. Required for action type - AlertingAction
        :param pulumi.Input[Union[str, 'QueryType']] query_type: Set value to 'ResultCount' .
        """
        pulumi.set(__self__, "data_source_id", data_source_id)
        if authorized_resources is not None:
            pulumi.set(__self__, "authorized_resources", authorized_resources)
        if query is not None:
            pulumi.set(__self__, "query", query)
        if query_type is not None:
            pulumi.set(__self__, "query_type", query_type)

    @property
    @pulumi.getter(name="dataSourceId")
    def data_source_id(self) -> pulumi.Input[str]:
        """
        The resource uri over which log search query is to be run.
        """
        return pulumi.get(self, "data_source_id")

    @data_source_id.setter
    def data_source_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "data_source_id", value)

    @property
    @pulumi.getter(name="authorizedResources")
    def authorized_resources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of  Resource referred into query
        """
        return pulumi.get(self, "authorized_resources")

    @authorized_resources.setter
    def authorized_resources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "authorized_resources", value)

    @property
    @pulumi.getter
    def query(self) -> Optional[pulumi.Input[str]]:
        """
        Log search query. Required for action type - AlertingAction
        """
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "query", value)

    @property
    @pulumi.getter(name="queryType")
    def query_type(self) -> Optional[pulumi.Input[Union[str, 'QueryType']]]:
        """
        Set value to 'ResultCount' .
        """
        return pulumi.get(self, "query_type")

    @query_type.setter
    def query_type(self, value: Optional[pulumi.Input[Union[str, 'QueryType']]]):
        pulumi.set(self, "query_type", value)


@pulumi.input_type
class SubscriptionLogSettingsArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[bool],
                 category: Optional[pulumi.Input[str]] = None):
        """
        Part of Subscription diagnostic setting. Specifies the settings for a particular log.
        :param pulumi.Input[bool] enabled: a value indicating whether this log is enabled.
        :param pulumi.Input[str] category: Name of a Subscription Diagnostic Log category for a resource type this setting is applied to.
        """
        pulumi.set(__self__, "enabled", enabled)
        if category is not None:
            pulumi.set(__self__, "category", category)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[bool]:
        """
        a value indicating whether this log is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def category(self) -> Optional[pulumi.Input[str]]:
        """
        Name of a Subscription Diagnostic Log category for a resource type this setting is applied to.
        """
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "category", value)


@pulumi.input_type
class SyslogDataSourceArgs:
    def __init__(__self__, *,
                 facility_names: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'KnownSyslogDataSourceFacilityNames']]]]] = None,
                 log_levels: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'KnownSyslogDataSourceLogLevels']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 streams: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'KnownSyslogDataSourceStreams']]]]] = None):
        """
        Definition of which syslog data will be collected and how it will be collected.
        Only collected from Linux machines.
        :param pulumi.Input[Sequence[pulumi.Input[Union[str, 'KnownSyslogDataSourceFacilityNames']]]] facility_names: The list of facility names.
        :param pulumi.Input[Sequence[pulumi.Input[Union[str, 'KnownSyslogDataSourceLogLevels']]]] log_levels: The log levels to collect.
        :param pulumi.Input[str] name: A friendly name for the data source. 
               This name should be unique across all data sources (regardless of type) within the data collection rule.
        :param pulumi.Input[Sequence[pulumi.Input[Union[str, 'KnownSyslogDataSourceStreams']]]] streams: List of streams that this data source will be sent to.
               A stream indicates what schema will be used for this data and usually what table in Log Analytics the data will be sent to.
        """
        if facility_names is not None:
            pulumi.set(__self__, "facility_names", facility_names)
        if log_levels is not None:
            pulumi.set(__self__, "log_levels", log_levels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if streams is not None:
            pulumi.set(__self__, "streams", streams)

    @property
    @pulumi.getter(name="facilityNames")
    def facility_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'KnownSyslogDataSourceFacilityNames']]]]]:
        """
        The list of facility names.
        """
        return pulumi.get(self, "facility_names")

    @facility_names.setter
    def facility_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'KnownSyslogDataSourceFacilityNames']]]]]):
        pulumi.set(self, "facility_names", value)

    @property
    @pulumi.getter(name="logLevels")
    def log_levels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'KnownSyslogDataSourceLogLevels']]]]]:
        """
        The log levels to collect.
        """
        return pulumi.get(self, "log_levels")

    @log_levels.setter
    def log_levels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'KnownSyslogDataSourceLogLevels']]]]]):
        pulumi.set(self, "log_levels", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A friendly name for the data source. 
        This name should be unique across all data sources (regardless of type) within the data collection rule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def streams(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'KnownSyslogDataSourceStreams']]]]]:
        """
        List of streams that this data source will be sent to.
        A stream indicates what schema will be used for this data and usually what table in Log Analytics the data will be sent to.
        """
        return pulumi.get(self, "streams")

    @streams.setter
    def streams(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'KnownSyslogDataSourceStreams']]]]]):
        pulumi.set(self, "streams", value)


@pulumi.input_type
class ThresholdRuleConditionArgs:
    def __init__(__self__, *,
                 odata_type: pulumi.Input[str],
                 operator: pulumi.Input['ConditionOperator'],
                 threshold: pulumi.Input[float],
                 data_source: Optional[pulumi.Input[Union['RuleManagementEventDataSourceArgs', 'RuleMetricDataSourceArgs']]] = None,
                 time_aggregation: Optional[pulumi.Input['TimeAggregationOperator']] = None,
                 window_size: Optional[pulumi.Input[str]] = None):
        """
        A rule condition based on a metric crossing a threshold.
        :param pulumi.Input[str] odata_type: specifies the type of condition. This can be one of three types: ManagementEventRuleCondition (occurrences of management events), LocationThresholdRuleCondition (based on the number of failures of a web test), and ThresholdRuleCondition (based on the threshold of a metric).
               Expected value is 'Microsoft.Azure.Management.Insights.Models.ThresholdRuleCondition'.
        :param pulumi.Input['ConditionOperator'] operator: the operator used to compare the data and the threshold.
        :param pulumi.Input[float] threshold: the threshold value that activates the alert.
        :param pulumi.Input[Union['RuleManagementEventDataSourceArgs', 'RuleMetricDataSourceArgs']] data_source: the resource from which the rule collects its data. For this type dataSource will always be of type RuleMetricDataSource.
        :param pulumi.Input['TimeAggregationOperator'] time_aggregation: the time aggregation operator. How the data that are collected should be combined over time. The default value is the PrimaryAggregationType of the Metric.
        :param pulumi.Input[str] window_size: the period of time (in ISO 8601 duration format) that is used to monitor alert activity based on the threshold. If specified then it must be between 5 minutes and 1 day.
        """
        pulumi.set(__self__, "odata_type", 'Microsoft.Azure.Management.Insights.Models.ThresholdRuleCondition')
        pulumi.set(__self__, "operator", operator)
        pulumi.set(__self__, "threshold", threshold)
        if data_source is not None:
            pulumi.set(__self__, "data_source", data_source)
        if time_aggregation is not None:
            pulumi.set(__self__, "time_aggregation", time_aggregation)
        if window_size is not None:
            pulumi.set(__self__, "window_size", window_size)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        specifies the type of condition. This can be one of three types: ManagementEventRuleCondition (occurrences of management events), LocationThresholdRuleCondition (based on the number of failures of a web test), and ThresholdRuleCondition (based on the threshold of a metric).
        Expected value is 'Microsoft.Azure.Management.Insights.Models.ThresholdRuleCondition'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter
    def operator(self) -> pulumi.Input['ConditionOperator']:
        """
        the operator used to compare the data and the threshold.
        """
        return pulumi.get(self, "operator")

    @operator.setter
    def operator(self, value: pulumi.Input['ConditionOperator']):
        pulumi.set(self, "operator", value)

    @property
    @pulumi.getter
    def threshold(self) -> pulumi.Input[float]:
        """
        the threshold value that activates the alert.
        """
        return pulumi.get(self, "threshold")

    @threshold.setter
    def threshold(self, value: pulumi.Input[float]):
        pulumi.set(self, "threshold", value)

    @property
    @pulumi.getter(name="dataSource")
    def data_source(self) -> Optional[pulumi.Input[Union['RuleManagementEventDataSourceArgs', 'RuleMetricDataSourceArgs']]]:
        """
        the resource from which the rule collects its data. For this type dataSource will always be of type RuleMetricDataSource.
        """
        return pulumi.get(self, "data_source")

    @data_source.setter
    def data_source(self, value: Optional[pulumi.Input[Union['RuleManagementEventDataSourceArgs', 'RuleMetricDataSourceArgs']]]):
        pulumi.set(self, "data_source", value)

    @property
    @pulumi.getter(name="timeAggregation")
    def time_aggregation(self) -> Optional[pulumi.Input['TimeAggregationOperator']]:
        """
        the time aggregation operator. How the data that are collected should be combined over time. The default value is the PrimaryAggregationType of the Metric.
        """
        return pulumi.get(self, "time_aggregation")

    @time_aggregation.setter
    def time_aggregation(self, value: Optional[pulumi.Input['TimeAggregationOperator']]):
        pulumi.set(self, "time_aggregation", value)

    @property
    @pulumi.getter(name="windowSize")
    def window_size(self) -> Optional[pulumi.Input[str]]:
        """
        the period of time (in ISO 8601 duration format) that is used to monitor alert activity based on the threshold. If specified then it must be between 5 minutes and 1 day.
        """
        return pulumi.get(self, "window_size")

    @window_size.setter
    def window_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "window_size", value)


@pulumi.input_type
class TimeWindowArgs:
    def __init__(__self__, *,
                 end: pulumi.Input[str],
                 start: pulumi.Input[str],
                 time_zone: Optional[pulumi.Input[str]] = None):
        """
        A specific date-time for the profile.
        :param pulumi.Input[str] end: the end time for the profile in ISO 8601 format.
        :param pulumi.Input[str] start: the start time for the profile in ISO 8601 format.
        :param pulumi.Input[str] time_zone: the timezone of the start and end times for the profile. Some examples of valid time zones are: Dateline Standard Time, UTC-11, Hawaiian Standard Time, Alaskan Standard Time, Pacific Standard Time (Mexico), Pacific Standard Time, US Mountain Standard Time, Mountain Standard Time (Mexico), Mountain Standard Time, Central America Standard Time, Central Standard Time, Central Standard Time (Mexico), Canada Central Standard Time, SA Pacific Standard Time, Eastern Standard Time, US Eastern Standard Time, Venezuela Standard Time, Paraguay Standard Time, Atlantic Standard Time, Central Brazilian Standard Time, SA Western Standard Time, Pacific SA Standard Time, Newfoundland Standard Time, E. South America Standard Time, Argentina Standard Time, SA Eastern Standard Time, Greenland Standard Time, Montevideo Standard Time, Bahia Standard Time, UTC-02, Mid-Atlantic Standard Time, Azores Standard Time, Cape Verde Standard Time, Morocco Standard Time, UTC, GMT Standard Time, Greenwich Standard Time, W. Europe Standard Time, Central Europe Standard Time, Romance Standard Time, Central European Standard Time, W. Central Africa Standard Time, Namibia Standard Time, Jordan Standard Time, GTB Standard Time, Middle East Standard Time, Egypt Standard Time, Syria Standard Time, E. Europe Standard Time, South Africa Standard Time, FLE Standard Time, Turkey Standard Time, Israel Standard Time, Kaliningrad Standard Time, Libya Standard Time, Arabic Standard Time, Arab Standard Time, Belarus Standard Time, Russian Standard Time, E. Africa Standard Time, Iran Standard Time, Arabian Standard Time, Azerbaijan Standard Time, Russia Time Zone 3, Mauritius Standard Time, Georgian Standard Time, Caucasus Standard Time, Afghanistan Standard Time, West Asia Standard Time, Ekaterinburg Standard Time, Pakistan Standard Time, India Standard Time, Sri Lanka Standard Time, Nepal Standard Time, Central Asia Standard Time, Bangladesh Standard Time, N. Central Asia Standard Time, Myanmar Standard Time, SE Asia Standard Time, North Asia Standard Time, China Standard Time, North Asia East Standard Time, Singapore Standard Time, W. Australia Standard Time, Taipei Standard Time, Ulaanbaatar Standard Time, Tokyo Standard Time, Korea Standard Time, Yakutsk Standard Time, Cen. Australia Standard Time, AUS Central Standard Time, E. Australia Standard Time, AUS Eastern Standard Time, West Pacific Standard Time, Tasmania Standard Time, Magadan Standard Time, Vladivostok Standard Time, Russia Time Zone 10, Central Pacific Standard Time, Russia Time Zone 11, New Zealand Standard Time, UTC+12, Fiji Standard Time, Kamchatka Standard Time, Tonga Standard Time, Samoa Standard Time, Line Islands Standard Time
        """
        pulumi.set(__self__, "end", end)
        pulumi.set(__self__, "start", start)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)

    @property
    @pulumi.getter
    def end(self) -> pulumi.Input[str]:
        """
        the end time for the profile in ISO 8601 format.
        """
        return pulumi.get(self, "end")

    @end.setter
    def end(self, value: pulumi.Input[str]):
        pulumi.set(self, "end", value)

    @property
    @pulumi.getter
    def start(self) -> pulumi.Input[str]:
        """
        the start time for the profile in ISO 8601 format.
        """
        return pulumi.get(self, "start")

    @start.setter
    def start(self, value: pulumi.Input[str]):
        pulumi.set(self, "start", value)

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[str]]:
        """
        the timezone of the start and end times for the profile. Some examples of valid time zones are: Dateline Standard Time, UTC-11, Hawaiian Standard Time, Alaskan Standard Time, Pacific Standard Time (Mexico), Pacific Standard Time, US Mountain Standard Time, Mountain Standard Time (Mexico), Mountain Standard Time, Central America Standard Time, Central Standard Time, Central Standard Time (Mexico), Canada Central Standard Time, SA Pacific Standard Time, Eastern Standard Time, US Eastern Standard Time, Venezuela Standard Time, Paraguay Standard Time, Atlantic Standard Time, Central Brazilian Standard Time, SA Western Standard Time, Pacific SA Standard Time, Newfoundland Standard Time, E. South America Standard Time, Argentina Standard Time, SA Eastern Standard Time, Greenland Standard Time, Montevideo Standard Time, Bahia Standard Time, UTC-02, Mid-Atlantic Standard Time, Azores Standard Time, Cape Verde Standard Time, Morocco Standard Time, UTC, GMT Standard Time, Greenwich Standard Time, W. Europe Standard Time, Central Europe Standard Time, Romance Standard Time, Central European Standard Time, W. Central Africa Standard Time, Namibia Standard Time, Jordan Standard Time, GTB Standard Time, Middle East Standard Time, Egypt Standard Time, Syria Standard Time, E. Europe Standard Time, South Africa Standard Time, FLE Standard Time, Turkey Standard Time, Israel Standard Time, Kaliningrad Standard Time, Libya Standard Time, Arabic Standard Time, Arab Standard Time, Belarus Standard Time, Russian Standard Time, E. Africa Standard Time, Iran Standard Time, Arabian Standard Time, Azerbaijan Standard Time, Russia Time Zone 3, Mauritius Standard Time, Georgian Standard Time, Caucasus Standard Time, Afghanistan Standard Time, West Asia Standard Time, Ekaterinburg Standard Time, Pakistan Standard Time, India Standard Time, Sri Lanka Standard Time, Nepal Standard Time, Central Asia Standard Time, Bangladesh Standard Time, N. Central Asia Standard Time, Myanmar Standard Time, SE Asia Standard Time, North Asia Standard Time, China Standard Time, North Asia East Standard Time, Singapore Standard Time, W. Australia Standard Time, Taipei Standard Time, Ulaanbaatar Standard Time, Tokyo Standard Time, Korea Standard Time, Yakutsk Standard Time, Cen. Australia Standard Time, AUS Central Standard Time, E. Australia Standard Time, AUS Eastern Standard Time, West Pacific Standard Time, Tasmania Standard Time, Magadan Standard Time, Vladivostok Standard Time, Russia Time Zone 10, Central Pacific Standard Time, Russia Time Zone 11, New Zealand Standard Time, UTC+12, Fiji Standard Time, Kamchatka Standard Time, Tonga Standard Time, Samoa Standard Time, Line Islands Standard Time
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_zone", value)


@pulumi.input_type
class TriggerConditionArgs:
    def __init__(__self__, *,
                 threshold: pulumi.Input[float],
                 threshold_operator: pulumi.Input[Union[str, 'ConditionalOperator']],
                 metric_trigger: Optional[pulumi.Input['LogMetricTriggerArgs']] = None):
        """
        The condition that results in the Log Search rule.
        :param pulumi.Input[float] threshold: Result or count threshold based on which rule should be triggered.
        :param pulumi.Input[Union[str, 'ConditionalOperator']] threshold_operator: Evaluation operation for rule - 'GreaterThan' or 'LessThan.
        :param pulumi.Input['LogMetricTriggerArgs'] metric_trigger: Trigger condition for metric query rule
        """
        pulumi.set(__self__, "threshold", threshold)
        pulumi.set(__self__, "threshold_operator", threshold_operator)
        if metric_trigger is not None:
            pulumi.set(__self__, "metric_trigger", metric_trigger)

    @property
    @pulumi.getter
    def threshold(self) -> pulumi.Input[float]:
        """
        Result or count threshold based on which rule should be triggered.
        """
        return pulumi.get(self, "threshold")

    @threshold.setter
    def threshold(self, value: pulumi.Input[float]):
        pulumi.set(self, "threshold", value)

    @property
    @pulumi.getter(name="thresholdOperator")
    def threshold_operator(self) -> pulumi.Input[Union[str, 'ConditionalOperator']]:
        """
        Evaluation operation for rule - 'GreaterThan' or 'LessThan.
        """
        return pulumi.get(self, "threshold_operator")

    @threshold_operator.setter
    def threshold_operator(self, value: pulumi.Input[Union[str, 'ConditionalOperator']]):
        pulumi.set(self, "threshold_operator", value)

    @property
    @pulumi.getter(name="metricTrigger")
    def metric_trigger(self) -> Optional[pulumi.Input['LogMetricTriggerArgs']]:
        """
        Trigger condition for metric query rule
        """
        return pulumi.get(self, "metric_trigger")

    @metric_trigger.setter
    def metric_trigger(self, value: Optional[pulumi.Input['LogMetricTriggerArgs']]):
        pulumi.set(self, "metric_trigger", value)


@pulumi.input_type
class VoiceReceiverArgs:
    def __init__(__self__, *,
                 country_code: pulumi.Input[str],
                 name: pulumi.Input[str],
                 phone_number: pulumi.Input[str]):
        """
        A voice receiver.
        :param pulumi.Input[str] country_code: The country code of the voice receiver.
        :param pulumi.Input[str] name: The name of the voice receiver. Names must be unique across all receivers within an action group.
        :param pulumi.Input[str] phone_number: The phone number of the voice receiver.
        """
        pulumi.set(__self__, "country_code", country_code)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "phone_number", phone_number)

    @property
    @pulumi.getter(name="countryCode")
    def country_code(self) -> pulumi.Input[str]:
        """
        The country code of the voice receiver.
        """
        return pulumi.get(self, "country_code")

    @country_code.setter
    def country_code(self, value: pulumi.Input[str]):
        pulumi.set(self, "country_code", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the voice receiver. Names must be unique across all receivers within an action group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="phoneNumber")
    def phone_number(self) -> pulumi.Input[str]:
        """
        The phone number of the voice receiver.
        """
        return pulumi.get(self, "phone_number")

    @phone_number.setter
    def phone_number(self, value: pulumi.Input[str]):
        pulumi.set(self, "phone_number", value)


@pulumi.input_type
class WebTestGeolocationArgs:
    def __init__(__self__, *,
                 location: Optional[pulumi.Input[str]] = None):
        """
        Geo-physical location to run a web test from. You must specify one or more locations for the test to run from.
        :param pulumi.Input[str] location: Location ID for the webtest to run from.
        """
        if location is not None:
            pulumi.set(__self__, "location", location)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Location ID for the webtest to run from.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)


@pulumi.input_type
class WebTestPropertiesConfigurationArgs:
    def __init__(__self__, *,
                 web_test: Optional[pulumi.Input[str]] = None):
        """
        An XML configuration specification for a WebTest.
        :param pulumi.Input[str] web_test: The XML specification of a WebTest to run against an application.
        """
        if web_test is not None:
            pulumi.set(__self__, "web_test", web_test)

    @property
    @pulumi.getter(name="webTest")
    def web_test(self) -> Optional[pulumi.Input[str]]:
        """
        The XML specification of a WebTest to run against an application.
        """
        return pulumi.get(self, "web_test")

    @web_test.setter
    def web_test(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "web_test", value)


@pulumi.input_type
class WebhookNotificationArgs:
    def __init__(__self__, *,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 service_uri: Optional[pulumi.Input[str]] = None):
        """
        Webhook notification of an autoscale event.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: a property bag of settings. This value can be empty.
        :param pulumi.Input[str] service_uri: the service address to receive the notification.
        """
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if service_uri is not None:
            pulumi.set(__self__, "service_uri", service_uri)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        a property bag of settings. This value can be empty.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter(name="serviceUri")
    def service_uri(self) -> Optional[pulumi.Input[str]]:
        """
        the service address to receive the notification.
        """
        return pulumi.get(self, "service_uri")

    @service_uri.setter
    def service_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_uri", value)


@pulumi.input_type
class WebhookReceiverArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 service_uri: pulumi.Input[str],
                 identifier_uri: Optional[pulumi.Input[str]] = None,
                 object_id: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 use_aad_auth: Optional[pulumi.Input[bool]] = None,
                 use_common_alert_schema: Optional[pulumi.Input[bool]] = None):
        """
        A webhook receiver.
        :param pulumi.Input[str] name: The name of the webhook receiver. Names must be unique across all receivers within an action group.
        :param pulumi.Input[str] service_uri: The URI where webhooks should be sent.
        :param pulumi.Input[str] identifier_uri: Indicates the identifier uri for aad auth.
        :param pulumi.Input[str] object_id: Indicates the webhook app object Id for aad auth.
        :param pulumi.Input[str] tenant_id: Indicates the tenant id for aad auth.
        :param pulumi.Input[bool] use_aad_auth: Indicates whether or not use AAD authentication.
        :param pulumi.Input[bool] use_common_alert_schema: Indicates whether to use common alert schema.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "service_uri", service_uri)
        if identifier_uri is not None:
            pulumi.set(__self__, "identifier_uri", identifier_uri)
        if object_id is not None:
            pulumi.set(__self__, "object_id", object_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if use_aad_auth is None:
            use_aad_auth = False
        if use_aad_auth is not None:
            pulumi.set(__self__, "use_aad_auth", use_aad_auth)
        if use_common_alert_schema is None:
            use_common_alert_schema = False
        if use_common_alert_schema is not None:
            pulumi.set(__self__, "use_common_alert_schema", use_common_alert_schema)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the webhook receiver. Names must be unique across all receivers within an action group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="serviceUri")
    def service_uri(self) -> pulumi.Input[str]:
        """
        The URI where webhooks should be sent.
        """
        return pulumi.get(self, "service_uri")

    @service_uri.setter
    def service_uri(self, value: pulumi.Input[str]):
        pulumi.set(self, "service_uri", value)

    @property
    @pulumi.getter(name="identifierUri")
    def identifier_uri(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates the identifier uri for aad auth.
        """
        return pulumi.get(self, "identifier_uri")

    @identifier_uri.setter
    def identifier_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "identifier_uri", value)

    @property
    @pulumi.getter(name="objectId")
    def object_id(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates the webhook app object Id for aad auth.
        """
        return pulumi.get(self, "object_id")

    @object_id.setter
    def object_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "object_id", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates the tenant id for aad auth.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="useAadAuth")
    def use_aad_auth(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether or not use AAD authentication.
        """
        return pulumi.get(self, "use_aad_auth")

    @use_aad_auth.setter
    def use_aad_auth(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_aad_auth", value)

    @property
    @pulumi.getter(name="useCommonAlertSchema")
    def use_common_alert_schema(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether to use common alert schema.
        """
        return pulumi.get(self, "use_common_alert_schema")

    @use_common_alert_schema.setter
    def use_common_alert_schema(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_common_alert_schema", value)


@pulumi.input_type
class WebtestLocationAvailabilityCriteriaArgs:
    def __init__(__self__, *,
                 component_id: pulumi.Input[str],
                 failed_location_count: pulumi.Input[float],
                 odata_type: pulumi.Input[str],
                 web_test_id: pulumi.Input[str]):
        """
        Specifies the metric alert rule criteria for a web test resource.
        :param pulumi.Input[str] component_id: The Application Insights resource Id.
        :param pulumi.Input[float] failed_location_count: The number of failed locations.
        :param pulumi.Input[str] odata_type: specifies the type of the alert criteria.
               Expected value is 'Microsoft.Azure.Monitor.WebtestLocationAvailabilityCriteria'.
        :param pulumi.Input[str] web_test_id: The Application Insights web test Id.
        """
        pulumi.set(__self__, "component_id", component_id)
        pulumi.set(__self__, "failed_location_count", failed_location_count)
        pulumi.set(__self__, "odata_type", 'Microsoft.Azure.Monitor.WebtestLocationAvailabilityCriteria')
        pulumi.set(__self__, "web_test_id", web_test_id)

    @property
    @pulumi.getter(name="componentId")
    def component_id(self) -> pulumi.Input[str]:
        """
        The Application Insights resource Id.
        """
        return pulumi.get(self, "component_id")

    @component_id.setter
    def component_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "component_id", value)

    @property
    @pulumi.getter(name="failedLocationCount")
    def failed_location_count(self) -> pulumi.Input[float]:
        """
        The number of failed locations.
        """
        return pulumi.get(self, "failed_location_count")

    @failed_location_count.setter
    def failed_location_count(self, value: pulumi.Input[float]):
        pulumi.set(self, "failed_location_count", value)

    @property
    @pulumi.getter(name="odataType")
    def odata_type(self) -> pulumi.Input[str]:
        """
        specifies the type of the alert criteria.
        Expected value is 'Microsoft.Azure.Monitor.WebtestLocationAvailabilityCriteria'.
        """
        return pulumi.get(self, "odata_type")

    @odata_type.setter
    def odata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "odata_type", value)

    @property
    @pulumi.getter(name="webTestId")
    def web_test_id(self) -> pulumi.Input[str]:
        """
        The Application Insights web test Id.
        """
        return pulumi.get(self, "web_test_id")

    @web_test_id.setter
    def web_test_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "web_test_id", value)


@pulumi.input_type
class WindowsEventLogDataSourceArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 streams: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'KnownWindowsEventLogDataSourceStreams']]]]] = None,
                 x_path_queries: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Definition of which Windows Event Log events will be collected and how they will be collected.
        Only collected from Windows machines.
        :param pulumi.Input[str] name: A friendly name for the data source. 
               This name should be unique across all data sources (regardless of type) within the data collection rule.
        :param pulumi.Input[Sequence[pulumi.Input[Union[str, 'KnownWindowsEventLogDataSourceStreams']]]] streams: List of streams that this data source will be sent to.
               A stream indicates what schema will be used for this data and usually what table in Log Analytics the data will be sent to.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] x_path_queries: A list of Windows Event Log queries in XPATH format.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if streams is not None:
            pulumi.set(__self__, "streams", streams)
        if x_path_queries is not None:
            pulumi.set(__self__, "x_path_queries", x_path_queries)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A friendly name for the data source. 
        This name should be unique across all data sources (regardless of type) within the data collection rule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def streams(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'KnownWindowsEventLogDataSourceStreams']]]]]:
        """
        List of streams that this data source will be sent to.
        A stream indicates what schema will be used for this data and usually what table in Log Analytics the data will be sent to.
        """
        return pulumi.get(self, "streams")

    @streams.setter
    def streams(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Union[str, 'KnownWindowsEventLogDataSourceStreams']]]]]):
        pulumi.set(self, "streams", value)

    @property
    @pulumi.getter(name="xPathQueries")
    def x_path_queries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of Windows Event Log queries in XPATH format.
        """
        return pulumi.get(self, "x_path_queries")

    @x_path_queries.setter
    def x_path_queries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "x_path_queries", value)


@pulumi.input_type
class WorkbookManagedIdentityArgs:
    def __init__(__self__, *,
                 type: Optional[pulumi.Input[str]] = None):
        """
        Customer Managed Identity
        :param pulumi.Input[str] type: The identity type.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The identity type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class WorkbookTemplateGalleryArgs:
    def __init__(__self__, *,
                 category: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 order: Optional[pulumi.Input[int]] = None,
                 resource_type: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        Gallery information for a workbook template.
        :param pulumi.Input[str] category: Category for the gallery.
        :param pulumi.Input[str] name: Name of the workbook template in the gallery.
        :param pulumi.Input[int] order: Order of the template within the gallery.
        :param pulumi.Input[str] resource_type: Azure resource type supported by the gallery.
        :param pulumi.Input[str] type: Type of workbook supported by the workbook template.
        """
        if category is not None:
            pulumi.set(__self__, "category", category)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if order is not None:
            pulumi.set(__self__, "order", order)
        if resource_type is not None:
            pulumi.set(__self__, "resource_type", resource_type)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def category(self) -> Optional[pulumi.Input[str]]:
        """
        Category for the gallery.
        """
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "category", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the workbook template in the gallery.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def order(self) -> Optional[pulumi.Input[int]]:
        """
        Order of the template within the gallery.
        """
        return pulumi.get(self, "order")

    @order.setter
    def order(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "order", value)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[pulumi.Input[str]]:
        """
        Azure resource type supported by the gallery.
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_type", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of workbook supported by the workbook template.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class WorkbookTemplateLocalizedGalleryArgs:
    def __init__(__self__, *,
                 galleries: Optional[pulumi.Input[Sequence[pulumi.Input['WorkbookTemplateGalleryArgs']]]] = None,
                 template_data: Optional[Any] = None):
        """
        Localized template data and gallery information.
        :param pulumi.Input[Sequence[pulumi.Input['WorkbookTemplateGalleryArgs']]] galleries: Workbook galleries supported by the template.
        :param Any template_data: Valid JSON object containing workbook template payload.
        """
        if galleries is not None:
            pulumi.set(__self__, "galleries", galleries)
        if template_data is not None:
            pulumi.set(__self__, "template_data", template_data)

    @property
    @pulumi.getter
    def galleries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkbookTemplateGalleryArgs']]]]:
        """
        Workbook galleries supported by the template.
        """
        return pulumi.get(self, "galleries")

    @galleries.setter
    def galleries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkbookTemplateGalleryArgs']]]]):
        pulumi.set(self, "galleries", value)

    @property
    @pulumi.getter(name="templateData")
    def template_data(self) -> Optional[Any]:
        """
        Valid JSON object containing workbook template payload.
        """
        return pulumi.get(self, "template_data")

    @template_data.setter
    def template_data(self, value: Optional[Any]):
        pulumi.set(self, "template_data", value)


