# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetNspAccessRuleResult',
    'AwaitableGetNspAccessRuleResult',
    'get_nsp_access_rule',
    'get_nsp_access_rule_output',
]

@pulumi.output_type
class GetNspAccessRuleResult:
    """
    The NSP access rule resource
    """
    def __init__(__self__, address_prefixes=None, direction=None, email_addresses=None, fully_qualified_domain_names=None, id=None, location=None, name=None, network_security_perimeters=None, phone_numbers=None, provisioning_state=None, subscriptions=None, tags=None, type=None):
        if address_prefixes and not isinstance(address_prefixes, list):
            raise TypeError("Expected argument 'address_prefixes' to be a list")
        pulumi.set(__self__, "address_prefixes", address_prefixes)
        if direction and not isinstance(direction, str):
            raise TypeError("Expected argument 'direction' to be a str")
        pulumi.set(__self__, "direction", direction)
        if email_addresses and not isinstance(email_addresses, list):
            raise TypeError("Expected argument 'email_addresses' to be a list")
        pulumi.set(__self__, "email_addresses", email_addresses)
        if fully_qualified_domain_names and not isinstance(fully_qualified_domain_names, list):
            raise TypeError("Expected argument 'fully_qualified_domain_names' to be a list")
        pulumi.set(__self__, "fully_qualified_domain_names", fully_qualified_domain_names)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if network_security_perimeters and not isinstance(network_security_perimeters, list):
            raise TypeError("Expected argument 'network_security_perimeters' to be a list")
        pulumi.set(__self__, "network_security_perimeters", network_security_perimeters)
        if phone_numbers and not isinstance(phone_numbers, list):
            raise TypeError("Expected argument 'phone_numbers' to be a list")
        pulumi.set(__self__, "phone_numbers", phone_numbers)
        if provisioning_state and not isinstance(provisioning_state, str):
            raise TypeError("Expected argument 'provisioning_state' to be a str")
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        if subscriptions and not isinstance(subscriptions, list):
            raise TypeError("Expected argument 'subscriptions' to be a list")
        pulumi.set(__self__, "subscriptions", subscriptions)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="addressPrefixes")
    def address_prefixes(self) -> Optional[Sequence[str]]:
        """
        Inbound address prefixes (IPv4/IPv6)
        """
        return pulumi.get(self, "address_prefixes")

    @property
    @pulumi.getter
    def direction(self) -> Optional[str]:
        """
        Direction that specifies whether the access rules is inbound/outbound.
        """
        return pulumi.get(self, "direction")

    @property
    @pulumi.getter(name="emailAddresses")
    def email_addresses(self) -> Optional[Sequence[str]]:
        """
        Outbound rules email address format.
        """
        return pulumi.get(self, "email_addresses")

    @property
    @pulumi.getter(name="fullyQualifiedDomainNames")
    def fully_qualified_domain_names(self) -> Optional[Sequence[str]]:
        """
        Outbound rules fully qualified domain name format.
        """
        return pulumi.get(self, "fully_qualified_domain_names")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        Resource location.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Resource name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkSecurityPerimeters")
    def network_security_perimeters(self) -> Optional[Sequence['outputs.PerimeterBasedAccessRuleResponse']]:
        """
        Inbound rule specified by the perimeter id.
        """
        return pulumi.get(self, "network_security_perimeters")

    @property
    @pulumi.getter(name="phoneNumbers")
    def phone_numbers(self) -> Optional[Sequence[str]]:
        """
        Outbound rules phone number format.
        """
        return pulumi.get(self, "phone_numbers")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the scope assignment resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def subscriptions(self) -> Optional[Sequence['outputs.SubscriptionIdResponse']]:
        """
        List of subscription ids
        """
        return pulumi.get(self, "subscriptions")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Resource tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Resource type.
        """
        return pulumi.get(self, "type")


class AwaitableGetNspAccessRuleResult(GetNspAccessRuleResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNspAccessRuleResult(
            address_prefixes=self.address_prefixes,
            direction=self.direction,
            email_addresses=self.email_addresses,
            fully_qualified_domain_names=self.fully_qualified_domain_names,
            id=self.id,
            location=self.location,
            name=self.name,
            network_security_perimeters=self.network_security_perimeters,
            phone_numbers=self.phone_numbers,
            provisioning_state=self.provisioning_state,
            subscriptions=self.subscriptions,
            tags=self.tags,
            type=self.type)


def get_nsp_access_rule(access_rule_name: Optional[str] = None,
                        network_security_perimeter_name: Optional[str] = None,
                        profile_name: Optional[str] = None,
                        resource_group_name: Optional[str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNspAccessRuleResult:
    """
    Gets the specified NSP access rule by name.


    :param str access_rule_name: The name of the NSP access rule.
    :param str network_security_perimeter_name: The name of the network security perimeter.
    :param str profile_name: The name of the NSP profile.
    :param str resource_group_name: The name of the resource group.
    """
    __args__ = dict()
    __args__['accessRuleName'] = access_rule_name
    __args__['networkSecurityPerimeterName'] = network_security_perimeter_name
    __args__['profileName'] = profile_name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure-native:network/v20210201preview:getNspAccessRule', __args__, opts=opts, typ=GetNspAccessRuleResult).value

    return AwaitableGetNspAccessRuleResult(
        address_prefixes=__ret__.address_prefixes,
        direction=__ret__.direction,
        email_addresses=__ret__.email_addresses,
        fully_qualified_domain_names=__ret__.fully_qualified_domain_names,
        id=__ret__.id,
        location=__ret__.location,
        name=__ret__.name,
        network_security_perimeters=__ret__.network_security_perimeters,
        phone_numbers=__ret__.phone_numbers,
        provisioning_state=__ret__.provisioning_state,
        subscriptions=__ret__.subscriptions,
        tags=__ret__.tags,
        type=__ret__.type)


@_utilities.lift_output_func(get_nsp_access_rule)
def get_nsp_access_rule_output(access_rule_name: Optional[pulumi.Input[str]] = None,
                               network_security_perimeter_name: Optional[pulumi.Input[str]] = None,
                               profile_name: Optional[pulumi.Input[str]] = None,
                               resource_group_name: Optional[pulumi.Input[str]] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetNspAccessRuleResult]:
    """
    Gets the specified NSP access rule by name.


    :param str access_rule_name: The name of the NSP access rule.
    :param str network_security_perimeter_name: The name of the network security perimeter.
    :param str profile_name: The name of the NSP profile.
    :param str resource_group_name: The name of the resource group.
    """
    ...
