# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'ACRPropertiesArgs',
    'AKSDeploymentPropertiesArgs',
    'AKSDeploymentSpecificationArgs',
    'ApacheTomcatAKSWorkloadDeploymentModelCustomPropertiesArgs',
    'ApacheTomcatAKSWorkloadDeploymentArgs',
    'ApacheTomcatWebApplicationArgs',
    'ApacheTomcatWorkloadInstanceModelCustomPropertiesArgs',
    'AppInsightMonitoringPropertiesArgs',
    'AutomationArtifactArgs',
    'AzureFileShareHydrationProfileArgs',
    'BindingArgs',
    'CertArgs',
    'ContainerImagePropertiesArgs',
    'DirectoryPathArgs',
    'GmsaAuthenticationPropertiesArgs',
    'IISAKSWorkloadDeploymentModelCustomPropertiesArgs',
    'IISAKSWorkloadDeploymentArgs',
    'IISApplicationDetailsArgs',
    'IISVirtualApplicationDetailsArgs',
    'IISWebApplicationArgs',
    'IISWebServerArgs',
    'IISWorkloadInstanceModelCustomPropertiesArgs',
    'IdentityModelArgs',
    'KeyVaultSecretStorePropertiesArgs',
    'ManagedIdentityPropertiesArgs',
    'MigrateAgentModelPropertiesArgs',
    'MigrationConfigurationArgs',
    'ModernizeProjectModelPropertiesArgs',
    'OperatingSystemDetailsArgs',
    'PortMappingArgs',
    'ResourceIdentityArgs',
    'ResourceRequirementsArgs',
    'SecretStoreDetailsArgs',
    'SecretStorePropertiesArgs',
    'TargetStorageProfileArgs',
    'UserAssignedIdentityArgs',
    'VMwareMigrateAgentModelCustomPropertiesArgs',
    'WebApplicationConfigurationArgs',
    'WebApplicationDirectoryArgs',
    'WebApplicationFrameworkArgs',
    'WorkloadDeploymentModelPropertiesArgs',
    'WorkloadInstanceModelPropertiesArgs',
]

@pulumi.input_type
class ACRPropertiesArgs:
    def __init__(__self__, *,
                 registry_name: Optional[pulumi.Input[str]] = None,
                 resource_group: Optional[pulumi.Input[str]] = None,
                 subscription_id: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None):
        """
        Class for ACR Properties.
        :param pulumi.Input[str] registry_name: Gets or sets the azure container registry name.
        :param pulumi.Input[str] resource_group: Gets or sets the resource group of the resource.
        :param pulumi.Input[str] subscription_id: Gets or sets the subscription id of the resource.
        :param pulumi.Input[str] tenant_id: Gets or sets the tenant id.
        """
        if registry_name is not None:
            pulumi.set(__self__, "registry_name", registry_name)
        if resource_group is not None:
            pulumi.set(__self__, "resource_group", resource_group)
        if subscription_id is not None:
            pulumi.set(__self__, "subscription_id", subscription_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="registryName")
    def registry_name(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the azure container registry name.
        """
        return pulumi.get(self, "registry_name")

    @registry_name.setter
    def registry_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "registry_name", value)

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the resource group of the resource.
        """
        return pulumi.get(self, "resource_group")

    @resource_group.setter
    def resource_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group", value)

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the subscription id of the resource.
        """
        return pulumi.get(self, "subscription_id")

    @subscription_id.setter
    def subscription_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subscription_id", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the tenant id.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)


@pulumi.input_type
class AKSDeploymentPropertiesArgs:
    def __init__(__self__, *,
                 aks_cluster_name: Optional[pulumi.Input[str]] = None,
                 resource_group: Optional[pulumi.Input[str]] = None,
                 subscription_id: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None):
        """
        Class for AKSDeployment Properties.
        :param pulumi.Input[str] aks_cluster_name: Gets or sets the AKS cluster name.
        :param pulumi.Input[str] resource_group: Gets or sets the resource group of the resource.
        :param pulumi.Input[str] subscription_id: Gets or sets the subscription id of the resource.
        :param pulumi.Input[str] tenant_id: Gets or sets the tenant id.
        """
        if aks_cluster_name is not None:
            pulumi.set(__self__, "aks_cluster_name", aks_cluster_name)
        if resource_group is not None:
            pulumi.set(__self__, "resource_group", resource_group)
        if subscription_id is not None:
            pulumi.set(__self__, "subscription_id", subscription_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="aksClusterName")
    def aks_cluster_name(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the AKS cluster name.
        """
        return pulumi.get(self, "aks_cluster_name")

    @aks_cluster_name.setter
    def aks_cluster_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "aks_cluster_name", value)

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the resource group of the resource.
        """
        return pulumi.get(self, "resource_group")

    @resource_group.setter
    def resource_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group", value)

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the subscription id of the resource.
        """
        return pulumi.get(self, "subscription_id")

    @subscription_id.setter
    def subscription_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subscription_id", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the tenant id.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)


@pulumi.input_type
class AKSDeploymentSpecificationArgs:
    def __init__(__self__, *,
                 kubernetes_objects_yaml: Optional[pulumi.Input[str]] = None,
                 load_balancer_type: Optional[pulumi.Input[Union[str, 'LoadBalancerType']]] = None,
                 replica_count: Optional[pulumi.Input[str]] = None):
        """
        AKS Deployment Specification.
        :param pulumi.Input[str] kubernetes_objects_yaml: Gets or sets the Merged Deployment and service Yaml.
        :param pulumi.Input[Union[str, 'LoadBalancerType']] load_balancer_type: Gets or sets the load balancer type.
        :param pulumi.Input[str] replica_count: Gets or sets the replica count to be created in AKS.
        """
        if kubernetes_objects_yaml is not None:
            pulumi.set(__self__, "kubernetes_objects_yaml", kubernetes_objects_yaml)
        if load_balancer_type is not None:
            pulumi.set(__self__, "load_balancer_type", load_balancer_type)
        if replica_count is not None:
            pulumi.set(__self__, "replica_count", replica_count)

    @property
    @pulumi.getter(name="kubernetesObjectsYaml")
    def kubernetes_objects_yaml(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the Merged Deployment and service Yaml.
        """
        return pulumi.get(self, "kubernetes_objects_yaml")

    @kubernetes_objects_yaml.setter
    def kubernetes_objects_yaml(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kubernetes_objects_yaml", value)

    @property
    @pulumi.getter(name="loadBalancerType")
    def load_balancer_type(self) -> Optional[pulumi.Input[Union[str, 'LoadBalancerType']]]:
        """
        Gets or sets the load balancer type.
        """
        return pulumi.get(self, "load_balancer_type")

    @load_balancer_type.setter
    def load_balancer_type(self, value: Optional[pulumi.Input[Union[str, 'LoadBalancerType']]]):
        pulumi.set(self, "load_balancer_type", value)

    @property
    @pulumi.getter(name="replicaCount")
    def replica_count(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the replica count to be created in AKS.
        """
        return pulumi.get(self, "replica_count")

    @replica_count.setter
    def replica_count(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "replica_count", value)


@pulumi.input_type
class ApacheTomcatAKSWorkloadDeploymentModelCustomPropertiesArgs:
    def __init__(__self__, *,
                 instance_type: pulumi.Input[str],
                 apache_tomcat_aks_workload_deployment_properties: Optional[pulumi.Input['ApacheTomcatAKSWorkloadDeploymentArgs']] = None):
        """
        ApacheTomcat workload instance model custom properties.
        :param pulumi.Input[str] instance_type: Gets or sets the instance type.
               Expected value is 'ApacheTomcatAKSWorkloadDeploymentModelCustomProperties'.
        :param pulumi.Input['ApacheTomcatAKSWorkloadDeploymentArgs'] apache_tomcat_aks_workload_deployment_properties: ApacheTomcat web application.
        """
        pulumi.set(__self__, "instance_type", 'ApacheTomcatAKSWorkloadDeploymentModelCustomProperties')
        if apache_tomcat_aks_workload_deployment_properties is not None:
            pulumi.set(__self__, "apache_tomcat_aks_workload_deployment_properties", apache_tomcat_aks_workload_deployment_properties)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Input[str]:
        """
        Gets or sets the instance type.
        Expected value is 'ApacheTomcatAKSWorkloadDeploymentModelCustomProperties'.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="apacheTomcatAksWorkloadDeploymentProperties")
    def apache_tomcat_aks_workload_deployment_properties(self) -> Optional[pulumi.Input['ApacheTomcatAKSWorkloadDeploymentArgs']]:
        """
        ApacheTomcat web application.
        """
        return pulumi.get(self, "apache_tomcat_aks_workload_deployment_properties")

    @apache_tomcat_aks_workload_deployment_properties.setter
    def apache_tomcat_aks_workload_deployment_properties(self, value: Optional[pulumi.Input['ApacheTomcatAKSWorkloadDeploymentArgs']]):
        pulumi.set(self, "apache_tomcat_aks_workload_deployment_properties", value)


@pulumi.input_type
class ApacheTomcatAKSWorkloadDeploymentArgs:
    def __init__(__self__, *,
                 automation_artifact_properties: Optional[pulumi.Input['AutomationArtifactArgs']] = None,
                 bindings: Optional[pulumi.Input[Sequence[pulumi.Input['BindingArgs']]]] = None,
                 build_container_images: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerImagePropertiesArgs']]]] = None,
                 cluster_properties: Optional[pulumi.Input['AKSDeploymentPropertiesArgs']] = None,
                 configurations: Optional[pulumi.Input[Sequence[pulumi.Input['WebApplicationConfigurationArgs']]]] = None,
                 container_image_properties: Optional[pulumi.Input['ContainerImagePropertiesArgs']] = None,
                 deployment_name_prefix: Optional[pulumi.Input[str]] = None,
                 deployment_spec: Optional[pulumi.Input['AKSDeploymentSpecificationArgs']] = None,
                 directories: Optional[pulumi.Input[Sequence[pulumi.Input['WebApplicationDirectoryArgs']]]] = None,
                 limits: Optional[pulumi.Input['ResourceRequirementsArgs']] = None,
                 monitoring_properties: Optional[pulumi.Input['AppInsightMonitoringPropertiesArgs']] = None,
                 requests: Optional[pulumi.Input['ResourceRequirementsArgs']] = None,
                 target_platform_identity: Optional[pulumi.Input[str]] = None):
        """
        ApacheTomcat web application.
        :param pulumi.Input['AutomationArtifactArgs'] automation_artifact_properties: Class for automation artifact.
        :param pulumi.Input[Sequence[pulumi.Input['BindingArgs']]] bindings: Gets or sets the bindings for the application.
        :param pulumi.Input[Sequence[pulumi.Input['ContainerImagePropertiesArgs']]] build_container_images: Gets or sets the build container images.
        :param pulumi.Input['AKSDeploymentPropertiesArgs'] cluster_properties: Class for AKSDeployment Properties.
        :param pulumi.Input[Sequence[pulumi.Input['WebApplicationConfigurationArgs']]] configurations: Gets or sets application configuration.
        :param pulumi.Input['ContainerImagePropertiesArgs'] container_image_properties: Class for container image properties.
        :param pulumi.Input[str] deployment_name_prefix: Gets or sets the deployment name prefix.
        :param pulumi.Input['AKSDeploymentSpecificationArgs'] deployment_spec: AKS Deployment Specification.
        :param pulumi.Input[Sequence[pulumi.Input['WebApplicationDirectoryArgs']]] directories: Gets or sets application directories.
        :param pulumi.Input['ResourceRequirementsArgs'] limits: Resource Requirements.
        :param pulumi.Input['AppInsightMonitoringPropertiesArgs'] monitoring_properties: Class for app insight monitoring properties.
        :param pulumi.Input['ResourceRequirementsArgs'] requests: Resource Requirements.
        :param pulumi.Input[str] target_platform_identity: Gets or sets the target platform managed identity.
        """
        if automation_artifact_properties is not None:
            pulumi.set(__self__, "automation_artifact_properties", automation_artifact_properties)
        if bindings is not None:
            pulumi.set(__self__, "bindings", bindings)
        if build_container_images is not None:
            pulumi.set(__self__, "build_container_images", build_container_images)
        if cluster_properties is not None:
            pulumi.set(__self__, "cluster_properties", cluster_properties)
        if configurations is not None:
            pulumi.set(__self__, "configurations", configurations)
        if container_image_properties is not None:
            pulumi.set(__self__, "container_image_properties", container_image_properties)
        if deployment_name_prefix is not None:
            pulumi.set(__self__, "deployment_name_prefix", deployment_name_prefix)
        if deployment_spec is not None:
            pulumi.set(__self__, "deployment_spec", deployment_spec)
        if directories is not None:
            pulumi.set(__self__, "directories", directories)
        if limits is not None:
            pulumi.set(__self__, "limits", limits)
        if monitoring_properties is not None:
            pulumi.set(__self__, "monitoring_properties", monitoring_properties)
        if requests is not None:
            pulumi.set(__self__, "requests", requests)
        if target_platform_identity is not None:
            pulumi.set(__self__, "target_platform_identity", target_platform_identity)

    @property
    @pulumi.getter(name="automationArtifactProperties")
    def automation_artifact_properties(self) -> Optional[pulumi.Input['AutomationArtifactArgs']]:
        """
        Class for automation artifact.
        """
        return pulumi.get(self, "automation_artifact_properties")

    @automation_artifact_properties.setter
    def automation_artifact_properties(self, value: Optional[pulumi.Input['AutomationArtifactArgs']]):
        pulumi.set(self, "automation_artifact_properties", value)

    @property
    @pulumi.getter
    def bindings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BindingArgs']]]]:
        """
        Gets or sets the bindings for the application.
        """
        return pulumi.get(self, "bindings")

    @bindings.setter
    def bindings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BindingArgs']]]]):
        pulumi.set(self, "bindings", value)

    @property
    @pulumi.getter(name="buildContainerImages")
    def build_container_images(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerImagePropertiesArgs']]]]:
        """
        Gets or sets the build container images.
        """
        return pulumi.get(self, "build_container_images")

    @build_container_images.setter
    def build_container_images(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerImagePropertiesArgs']]]]):
        pulumi.set(self, "build_container_images", value)

    @property
    @pulumi.getter(name="clusterProperties")
    def cluster_properties(self) -> Optional[pulumi.Input['AKSDeploymentPropertiesArgs']]:
        """
        Class for AKSDeployment Properties.
        """
        return pulumi.get(self, "cluster_properties")

    @cluster_properties.setter
    def cluster_properties(self, value: Optional[pulumi.Input['AKSDeploymentPropertiesArgs']]):
        pulumi.set(self, "cluster_properties", value)

    @property
    @pulumi.getter
    def configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WebApplicationConfigurationArgs']]]]:
        """
        Gets or sets application configuration.
        """
        return pulumi.get(self, "configurations")

    @configurations.setter
    def configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WebApplicationConfigurationArgs']]]]):
        pulumi.set(self, "configurations", value)

    @property
    @pulumi.getter(name="containerImageProperties")
    def container_image_properties(self) -> Optional[pulumi.Input['ContainerImagePropertiesArgs']]:
        """
        Class for container image properties.
        """
        return pulumi.get(self, "container_image_properties")

    @container_image_properties.setter
    def container_image_properties(self, value: Optional[pulumi.Input['ContainerImagePropertiesArgs']]):
        pulumi.set(self, "container_image_properties", value)

    @property
    @pulumi.getter(name="deploymentNamePrefix")
    def deployment_name_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the deployment name prefix.
        """
        return pulumi.get(self, "deployment_name_prefix")

    @deployment_name_prefix.setter
    def deployment_name_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deployment_name_prefix", value)

    @property
    @pulumi.getter(name="deploymentSpec")
    def deployment_spec(self) -> Optional[pulumi.Input['AKSDeploymentSpecificationArgs']]:
        """
        AKS Deployment Specification.
        """
        return pulumi.get(self, "deployment_spec")

    @deployment_spec.setter
    def deployment_spec(self, value: Optional[pulumi.Input['AKSDeploymentSpecificationArgs']]):
        pulumi.set(self, "deployment_spec", value)

    @property
    @pulumi.getter
    def directories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WebApplicationDirectoryArgs']]]]:
        """
        Gets or sets application directories.
        """
        return pulumi.get(self, "directories")

    @directories.setter
    def directories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WebApplicationDirectoryArgs']]]]):
        pulumi.set(self, "directories", value)

    @property
    @pulumi.getter
    def limits(self) -> Optional[pulumi.Input['ResourceRequirementsArgs']]:
        """
        Resource Requirements.
        """
        return pulumi.get(self, "limits")

    @limits.setter
    def limits(self, value: Optional[pulumi.Input['ResourceRequirementsArgs']]):
        pulumi.set(self, "limits", value)

    @property
    @pulumi.getter(name="monitoringProperties")
    def monitoring_properties(self) -> Optional[pulumi.Input['AppInsightMonitoringPropertiesArgs']]:
        """
        Class for app insight monitoring properties.
        """
        return pulumi.get(self, "monitoring_properties")

    @monitoring_properties.setter
    def monitoring_properties(self, value: Optional[pulumi.Input['AppInsightMonitoringPropertiesArgs']]):
        pulumi.set(self, "monitoring_properties", value)

    @property
    @pulumi.getter
    def requests(self) -> Optional[pulumi.Input['ResourceRequirementsArgs']]:
        """
        Resource Requirements.
        """
        return pulumi.get(self, "requests")

    @requests.setter
    def requests(self, value: Optional[pulumi.Input['ResourceRequirementsArgs']]):
        pulumi.set(self, "requests", value)

    @property
    @pulumi.getter(name="targetPlatformIdentity")
    def target_platform_identity(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the target platform managed identity.
        """
        return pulumi.get(self, "target_platform_identity")

    @target_platform_identity.setter
    def target_platform_identity(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_platform_identity", value)


@pulumi.input_type
class ApacheTomcatWebApplicationArgs:
    def __init__(__self__, *,
                 application_id: Optional[pulumi.Input[str]] = None,
                 application_name: Optional[pulumi.Input[str]] = None,
                 application_scratch_path: Optional[pulumi.Input[str]] = None,
                 bindings: Optional[pulumi.Input[Sequence[pulumi.Input['BindingArgs']]]] = None,
                 configurations: Optional[pulumi.Input[Sequence[pulumi.Input['WebApplicationConfigurationArgs']]]] = None,
                 directories: Optional[pulumi.Input[Sequence[pulumi.Input['WebApplicationDirectoryArgs']]]] = None,
                 discovered_frameworks: Optional[pulumi.Input[Sequence[pulumi.Input['WebApplicationFrameworkArgs']]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 limits: Optional[pulumi.Input['ResourceRequirementsArgs']] = None,
                 path: Optional[pulumi.Input['DirectoryPathArgs']] = None,
                 primary_framework: Optional[pulumi.Input['WebApplicationFrameworkArgs']] = None,
                 requests: Optional[pulumi.Input['ResourceRequirementsArgs']] = None,
                 web_server_id: Optional[pulumi.Input[str]] = None,
                 web_server_name: Optional[pulumi.Input[str]] = None):
        """
        ApacheTomcat web application.
        :param pulumi.Input[str] application_id: Gets or sets the web application id.
        :param pulumi.Input[str] application_name: Gets or sets the web application name.
        :param pulumi.Input[str] application_scratch_path: Gets or sets application scratch path.
        :param pulumi.Input[Sequence[pulumi.Input['BindingArgs']]] bindings: Gets or sets the bindings for the application.
        :param pulumi.Input[Sequence[pulumi.Input['WebApplicationConfigurationArgs']]] configurations: Gets or sets application configuration.
        :param pulumi.Input[Sequence[pulumi.Input['WebApplicationDirectoryArgs']]] directories: Gets or sets application directories.
        :param pulumi.Input[Sequence[pulumi.Input['WebApplicationFrameworkArgs']]] discovered_frameworks: Gets or sets the discovered frameworks of application.
        :param pulumi.Input[str] display_name: Gets or sets the display name.
        :param pulumi.Input['ResourceRequirementsArgs'] limits: Resource Requirements.
        :param pulumi.Input['DirectoryPathArgs'] path: Second level entity for virtual directories.
        :param pulumi.Input['WebApplicationFrameworkArgs'] primary_framework: Framework specific data for a web application.
        :param pulumi.Input['ResourceRequirementsArgs'] requests: Resource Requirements.
        :param pulumi.Input[str] web_server_id: Gets or sets the web server id.
        :param pulumi.Input[str] web_server_name: Gets or sets the web server name.
        """
        if application_id is not None:
            pulumi.set(__self__, "application_id", application_id)
        if application_name is not None:
            pulumi.set(__self__, "application_name", application_name)
        if application_scratch_path is not None:
            pulumi.set(__self__, "application_scratch_path", application_scratch_path)
        if bindings is not None:
            pulumi.set(__self__, "bindings", bindings)
        if configurations is not None:
            pulumi.set(__self__, "configurations", configurations)
        if directories is not None:
            pulumi.set(__self__, "directories", directories)
        if discovered_frameworks is not None:
            pulumi.set(__self__, "discovered_frameworks", discovered_frameworks)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if limits is not None:
            pulumi.set(__self__, "limits", limits)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if primary_framework is not None:
            pulumi.set(__self__, "primary_framework", primary_framework)
        if requests is not None:
            pulumi.set(__self__, "requests", requests)
        if web_server_id is not None:
            pulumi.set(__self__, "web_server_id", web_server_id)
        if web_server_name is not None:
            pulumi.set(__self__, "web_server_name", web_server_name)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the web application id.
        """
        return pulumi.get(self, "application_id")

    @application_id.setter
    def application_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "application_id", value)

    @property
    @pulumi.getter(name="applicationName")
    def application_name(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the web application name.
        """
        return pulumi.get(self, "application_name")

    @application_name.setter
    def application_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "application_name", value)

    @property
    @pulumi.getter(name="applicationScratchPath")
    def application_scratch_path(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets application scratch path.
        """
        return pulumi.get(self, "application_scratch_path")

    @application_scratch_path.setter
    def application_scratch_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "application_scratch_path", value)

    @property
    @pulumi.getter
    def bindings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BindingArgs']]]]:
        """
        Gets or sets the bindings for the application.
        """
        return pulumi.get(self, "bindings")

    @bindings.setter
    def bindings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BindingArgs']]]]):
        pulumi.set(self, "bindings", value)

    @property
    @pulumi.getter
    def configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WebApplicationConfigurationArgs']]]]:
        """
        Gets or sets application configuration.
        """
        return pulumi.get(self, "configurations")

    @configurations.setter
    def configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WebApplicationConfigurationArgs']]]]):
        pulumi.set(self, "configurations", value)

    @property
    @pulumi.getter
    def directories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WebApplicationDirectoryArgs']]]]:
        """
        Gets or sets application directories.
        """
        return pulumi.get(self, "directories")

    @directories.setter
    def directories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WebApplicationDirectoryArgs']]]]):
        pulumi.set(self, "directories", value)

    @property
    @pulumi.getter(name="discoveredFrameworks")
    def discovered_frameworks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WebApplicationFrameworkArgs']]]]:
        """
        Gets or sets the discovered frameworks of application.
        """
        return pulumi.get(self, "discovered_frameworks")

    @discovered_frameworks.setter
    def discovered_frameworks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WebApplicationFrameworkArgs']]]]):
        pulumi.set(self, "discovered_frameworks", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the display name.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def limits(self) -> Optional[pulumi.Input['ResourceRequirementsArgs']]:
        """
        Resource Requirements.
        """
        return pulumi.get(self, "limits")

    @limits.setter
    def limits(self, value: Optional[pulumi.Input['ResourceRequirementsArgs']]):
        pulumi.set(self, "limits", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input['DirectoryPathArgs']]:
        """
        Second level entity for virtual directories.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input['DirectoryPathArgs']]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="primaryFramework")
    def primary_framework(self) -> Optional[pulumi.Input['WebApplicationFrameworkArgs']]:
        """
        Framework specific data for a web application.
        """
        return pulumi.get(self, "primary_framework")

    @primary_framework.setter
    def primary_framework(self, value: Optional[pulumi.Input['WebApplicationFrameworkArgs']]):
        pulumi.set(self, "primary_framework", value)

    @property
    @pulumi.getter
    def requests(self) -> Optional[pulumi.Input['ResourceRequirementsArgs']]:
        """
        Resource Requirements.
        """
        return pulumi.get(self, "requests")

    @requests.setter
    def requests(self, value: Optional[pulumi.Input['ResourceRequirementsArgs']]):
        pulumi.set(self, "requests", value)

    @property
    @pulumi.getter(name="webServerId")
    def web_server_id(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the web server id.
        """
        return pulumi.get(self, "web_server_id")

    @web_server_id.setter
    def web_server_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "web_server_id", value)

    @property
    @pulumi.getter(name="webServerName")
    def web_server_name(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the web server name.
        """
        return pulumi.get(self, "web_server_name")

    @web_server_name.setter
    def web_server_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "web_server_name", value)


@pulumi.input_type
class ApacheTomcatWorkloadInstanceModelCustomPropertiesArgs:
    def __init__(__self__, *,
                 instance_type: pulumi.Input[str],
                 apache_tomcat_web_application: Optional[pulumi.Input['ApacheTomcatWebApplicationArgs']] = None,
                 web_app_arm_id: Optional[pulumi.Input[str]] = None,
                 web_app_site_name: Optional[pulumi.Input[str]] = None):
        """
        ApacheTomcat workload instance model custom properties.
        :param pulumi.Input[str] instance_type: Gets or sets the instance type.
               Expected value is 'ApacheTomcatWorkloadInstanceModelCustomProperties'.
        :param pulumi.Input['ApacheTomcatWebApplicationArgs'] apache_tomcat_web_application: ApacheTomcat web application.
        :param pulumi.Input[str] web_app_arm_id: Gets or sets the Web application ARM id.
        :param pulumi.Input[str] web_app_site_name: Gets or sets the Web application site name.
        """
        pulumi.set(__self__, "instance_type", 'ApacheTomcatWorkloadInstanceModelCustomProperties')
        if apache_tomcat_web_application is not None:
            pulumi.set(__self__, "apache_tomcat_web_application", apache_tomcat_web_application)
        if web_app_arm_id is not None:
            pulumi.set(__self__, "web_app_arm_id", web_app_arm_id)
        if web_app_site_name is not None:
            pulumi.set(__self__, "web_app_site_name", web_app_site_name)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Input[str]:
        """
        Gets or sets the instance type.
        Expected value is 'ApacheTomcatWorkloadInstanceModelCustomProperties'.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="apacheTomcatWebApplication")
    def apache_tomcat_web_application(self) -> Optional[pulumi.Input['ApacheTomcatWebApplicationArgs']]:
        """
        ApacheTomcat web application.
        """
        return pulumi.get(self, "apache_tomcat_web_application")

    @apache_tomcat_web_application.setter
    def apache_tomcat_web_application(self, value: Optional[pulumi.Input['ApacheTomcatWebApplicationArgs']]):
        pulumi.set(self, "apache_tomcat_web_application", value)

    @property
    @pulumi.getter(name="webAppArmId")
    def web_app_arm_id(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the Web application ARM id.
        """
        return pulumi.get(self, "web_app_arm_id")

    @web_app_arm_id.setter
    def web_app_arm_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "web_app_arm_id", value)

    @property
    @pulumi.getter(name="webAppSiteName")
    def web_app_site_name(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the Web application site name.
        """
        return pulumi.get(self, "web_app_site_name")

    @web_app_site_name.setter
    def web_app_site_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "web_app_site_name", value)


@pulumi.input_type
class AppInsightMonitoringPropertiesArgs:
    def __init__(__self__, *,
                 app_insights_name: Optional[pulumi.Input[str]] = None,
                 is_enabled: Optional[pulumi.Input[bool]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 resource_group: Optional[pulumi.Input[str]] = None,
                 secret_store_details: Optional[pulumi.Input['SecretStoreDetailsArgs']] = None,
                 subscription_id: Optional[pulumi.Input[str]] = None):
        """
        Class for app insight monitoring properties.
        :param pulumi.Input[str] app_insights_name: Gets or sets the app insights name.
        :param pulumi.Input[bool] is_enabled: Gets or sets a value indicating whether monitoring is enabled.
        :param pulumi.Input[str] region: Gets or sets the region.
        :param pulumi.Input[str] resource_group: Gets or sets the resource group of the resource.
        :param pulumi.Input[str] subscription_id: Gets or sets the subscription id of the resource.
        """
        if app_insights_name is not None:
            pulumi.set(__self__, "app_insights_name", app_insights_name)
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if resource_group is not None:
            pulumi.set(__self__, "resource_group", resource_group)
        if secret_store_details is not None:
            pulumi.set(__self__, "secret_store_details", secret_store_details)
        if subscription_id is not None:
            pulumi.set(__self__, "subscription_id", subscription_id)

    @property
    @pulumi.getter(name="appInsightsName")
    def app_insights_name(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the app insights name.
        """
        return pulumi.get(self, "app_insights_name")

    @app_insights_name.setter
    def app_insights_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_insights_name", value)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Gets or sets a value indicating whether monitoring is enabled.
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_enabled", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the region.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the resource group of the resource.
        """
        return pulumi.get(self, "resource_group")

    @resource_group.setter
    def resource_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group", value)

    @property
    @pulumi.getter(name="secretStoreDetails")
    def secret_store_details(self) -> Optional[pulumi.Input['SecretStoreDetailsArgs']]:
        return pulumi.get(self, "secret_store_details")

    @secret_store_details.setter
    def secret_store_details(self, value: Optional[pulumi.Input['SecretStoreDetailsArgs']]):
        pulumi.set(self, "secret_store_details", value)

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the subscription id of the resource.
        """
        return pulumi.get(self, "subscription_id")

    @subscription_id.setter
    def subscription_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subscription_id", value)


@pulumi.input_type
class AutomationArtifactArgs:
    def __init__(__self__, *,
                 artifacts: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 azure_file_share_profile: Optional[pulumi.Input['AzureFileShareHydrationProfileArgs']] = None,
                 status: Optional[pulumi.Input[Union[str, 'AutomationArtifactStatus']]] = None):
        """
        Class for automation artifact.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] artifacts: Gets or sets the artifacts.
        :param pulumi.Input['AzureFileShareHydrationProfileArgs'] azure_file_share_profile: Azure file share profile for hydration of application folders not mounted on
               the container file system.
        :param pulumi.Input[Union[str, 'AutomationArtifactStatus']] status: Gets or sets the status of automation artifacts.
        """
        if artifacts is not None:
            pulumi.set(__self__, "artifacts", artifacts)
        if azure_file_share_profile is not None:
            pulumi.set(__self__, "azure_file_share_profile", azure_file_share_profile)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def artifacts(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Gets or sets the artifacts.
        """
        return pulumi.get(self, "artifacts")

    @artifacts.setter
    def artifacts(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "artifacts", value)

    @property
    @pulumi.getter(name="azureFileShareProfile")
    def azure_file_share_profile(self) -> Optional[pulumi.Input['AzureFileShareHydrationProfileArgs']]:
        """
        Azure file share profile for hydration of application folders not mounted on
        the container file system.
        """
        return pulumi.get(self, "azure_file_share_profile")

    @azure_file_share_profile.setter
    def azure_file_share_profile(self, value: Optional[pulumi.Input['AzureFileShareHydrationProfileArgs']]):
        pulumi.set(self, "azure_file_share_profile", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[Union[str, 'AutomationArtifactStatus']]]:
        """
        Gets or sets the status of automation artifacts.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[Union[str, 'AutomationArtifactStatus']]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class AzureFileShareHydrationProfileArgs:
    def __init__(__self__, *,
                 azure_file_share_dir_path: Optional[pulumi.Input[str]] = None,
                 azure_file_share_name: Optional[pulumi.Input[str]] = None,
                 azure_file_share_resource_group: Optional[pulumi.Input[str]] = None,
                 azure_file_share_storage_account: Optional[pulumi.Input[str]] = None,
                 azure_file_share_subscription_id: Optional[pulumi.Input[str]] = None):
        """
        Azure file share profile for hydration of application folders not mounted on
        the container file system.
        :param pulumi.Input[str] azure_file_share_dir_path: Gets or sets the cloud directory path of the directory on azure file share.
        :param pulumi.Input[str] azure_file_share_name: Gets or sets the name of the azure file share.
        :param pulumi.Input[str] azure_file_share_resource_group: Gets or sets the name of the azure file share resource group.
        :param pulumi.Input[str] azure_file_share_storage_account: Gets or sets the name of the azure file share storage account.
        :param pulumi.Input[str] azure_file_share_subscription_id: Gets or sets the subscription id of the azure file share.
        """
        if azure_file_share_dir_path is not None:
            pulumi.set(__self__, "azure_file_share_dir_path", azure_file_share_dir_path)
        if azure_file_share_name is not None:
            pulumi.set(__self__, "azure_file_share_name", azure_file_share_name)
        if azure_file_share_resource_group is not None:
            pulumi.set(__self__, "azure_file_share_resource_group", azure_file_share_resource_group)
        if azure_file_share_storage_account is not None:
            pulumi.set(__self__, "azure_file_share_storage_account", azure_file_share_storage_account)
        if azure_file_share_subscription_id is not None:
            pulumi.set(__self__, "azure_file_share_subscription_id", azure_file_share_subscription_id)

    @property
    @pulumi.getter(name="azureFileShareDirPath")
    def azure_file_share_dir_path(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the cloud directory path of the directory on azure file share.
        """
        return pulumi.get(self, "azure_file_share_dir_path")

    @azure_file_share_dir_path.setter
    def azure_file_share_dir_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "azure_file_share_dir_path", value)

    @property
    @pulumi.getter(name="azureFileShareName")
    def azure_file_share_name(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the name of the azure file share.
        """
        return pulumi.get(self, "azure_file_share_name")

    @azure_file_share_name.setter
    def azure_file_share_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "azure_file_share_name", value)

    @property
    @pulumi.getter(name="azureFileShareResourceGroup")
    def azure_file_share_resource_group(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the name of the azure file share resource group.
        """
        return pulumi.get(self, "azure_file_share_resource_group")

    @azure_file_share_resource_group.setter
    def azure_file_share_resource_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "azure_file_share_resource_group", value)

    @property
    @pulumi.getter(name="azureFileShareStorageAccount")
    def azure_file_share_storage_account(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the name of the azure file share storage account.
        """
        return pulumi.get(self, "azure_file_share_storage_account")

    @azure_file_share_storage_account.setter
    def azure_file_share_storage_account(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "azure_file_share_storage_account", value)

    @property
    @pulumi.getter(name="azureFileShareSubscriptionId")
    def azure_file_share_subscription_id(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the subscription id of the azure file share.
        """
        return pulumi.get(self, "azure_file_share_subscription_id")

    @azure_file_share_subscription_id.setter
    def azure_file_share_subscription_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "azure_file_share_subscription_id", value)


@pulumi.input_type
class BindingArgs:
    def __init__(__self__, *,
                 cert: Optional[pulumi.Input['CertArgs']] = None,
                 host_name: Optional[pulumi.Input[str]] = None,
                 ip_address: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[str]] = None,
                 port_mapping: Optional[pulumi.Input['PortMappingArgs']] = None,
                 protocol: Optional[pulumi.Input[str]] = None):
        """
        Binding for a web application.
        :param pulumi.Input['CertArgs'] cert: WebApplication certificate.
        :param pulumi.Input[str] host_name: Gets or sets the binding host name.
        :param pulumi.Input[str] ip_address: Gets or sets the IP Address.
        :param pulumi.Input[str] port: Gets or sets the application port.
        :param pulumi.Input['PortMappingArgs'] port_mapping: WebApplication port mapping.
        :param pulumi.Input[str] protocol: Gets or sets the protocol.
        """
        if cert is not None:
            pulumi.set(__self__, "cert", cert)
        if host_name is not None:
            pulumi.set(__self__, "host_name", host_name)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if port_mapping is not None:
            pulumi.set(__self__, "port_mapping", port_mapping)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter
    def cert(self) -> Optional[pulumi.Input['CertArgs']]:
        """
        WebApplication certificate.
        """
        return pulumi.get(self, "cert")

    @cert.setter
    def cert(self, value: Optional[pulumi.Input['CertArgs']]):
        pulumi.set(self, "cert", value)

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the binding host name.
        """
        return pulumi.get(self, "host_name")

    @host_name.setter
    def host_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_name", value)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the IP Address.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the application port.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="portMapping")
    def port_mapping(self) -> Optional[pulumi.Input['PortMappingArgs']]:
        """
        WebApplication port mapping.
        """
        return pulumi.get(self, "port_mapping")

    @port_mapping.setter
    def port_mapping(self, value: Optional[pulumi.Input['PortMappingArgs']]):
        pulumi.set(self, "port_mapping", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the protocol.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)


@pulumi.input_type
class CertArgs:
    def __init__(__self__, *,
                 cert_data: Optional[pulumi.Input[str]] = None,
                 cert_needed: Optional[pulumi.Input[bool]] = None,
                 cert_provided: Optional[pulumi.Input[bool]] = None,
                 secret_store: Optional[pulumi.Input[Union[str, 'SecretStoreType']]] = None):
        """
        WebApplication certificate.
        :param pulumi.Input[str] cert_data: Gets or sets the Certificate data.
        :param pulumi.Input[bool] cert_needed: Gets or sets a value indicating whether certificate is needed or not.
        :param pulumi.Input[bool] cert_provided: Gets or sets a value indicating whether certificate is provided or not.
        :param pulumi.Input[Union[str, 'SecretStoreType']] secret_store: Gets or sets the type of secret store for the certificate.
        """
        if cert_data is not None:
            pulumi.set(__self__, "cert_data", cert_data)
        if cert_needed is not None:
            pulumi.set(__self__, "cert_needed", cert_needed)
        if cert_provided is not None:
            pulumi.set(__self__, "cert_provided", cert_provided)
        if secret_store is not None:
            pulumi.set(__self__, "secret_store", secret_store)

    @property
    @pulumi.getter(name="certData")
    def cert_data(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the Certificate data.
        """
        return pulumi.get(self, "cert_data")

    @cert_data.setter
    def cert_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cert_data", value)

    @property
    @pulumi.getter(name="certNeeded")
    def cert_needed(self) -> Optional[pulumi.Input[bool]]:
        """
        Gets or sets a value indicating whether certificate is needed or not.
        """
        return pulumi.get(self, "cert_needed")

    @cert_needed.setter
    def cert_needed(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "cert_needed", value)

    @property
    @pulumi.getter(name="certProvided")
    def cert_provided(self) -> Optional[pulumi.Input[bool]]:
        """
        Gets or sets a value indicating whether certificate is provided or not.
        """
        return pulumi.get(self, "cert_provided")

    @cert_provided.setter
    def cert_provided(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "cert_provided", value)

    @property
    @pulumi.getter(name="secretStore")
    def secret_store(self) -> Optional[pulumi.Input[Union[str, 'SecretStoreType']]]:
        """
        Gets or sets the type of secret store for the certificate.
        """
        return pulumi.get(self, "secret_store")

    @secret_store.setter
    def secret_store(self, value: Optional[pulumi.Input[Union[str, 'SecretStoreType']]]):
        pulumi.set(self, "secret_store", value)


@pulumi.input_type
class ContainerImagePropertiesArgs:
    def __init__(__self__, *,
                 dockerfile: Optional[pulumi.Input[str]] = None,
                 image_name: Optional[pulumi.Input[str]] = None,
                 image_tag: Optional[pulumi.Input[str]] = None,
                 registry_properties: Optional[pulumi.Input['ACRPropertiesArgs']] = None,
                 run_id: Optional[pulumi.Input[str]] = None,
                 run_status: Optional[pulumi.Input[str]] = None):
        """
        Class for container image properties.
        :param pulumi.Input[str] dockerfile: Gets or sets the dockerfile for the container image.
        :param pulumi.Input[str] image_name: Gets or sets the container image name.
        :param pulumi.Input[str] image_tag: Gets or sets the container image tag.
        :param pulumi.Input['ACRPropertiesArgs'] registry_properties: Class for ACR Properties.
        :param pulumi.Input[str] run_id: Gets or sets the RunId.
        :param pulumi.Input[str] run_status: Gets or sets the RunStatus.
        """
        if dockerfile is not None:
            pulumi.set(__self__, "dockerfile", dockerfile)
        if image_name is not None:
            pulumi.set(__self__, "image_name", image_name)
        if image_tag is not None:
            pulumi.set(__self__, "image_tag", image_tag)
        if registry_properties is not None:
            pulumi.set(__self__, "registry_properties", registry_properties)
        if run_id is not None:
            pulumi.set(__self__, "run_id", run_id)
        if run_status is not None:
            pulumi.set(__self__, "run_status", run_status)

    @property
    @pulumi.getter
    def dockerfile(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the dockerfile for the container image.
        """
        return pulumi.get(self, "dockerfile")

    @dockerfile.setter
    def dockerfile(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dockerfile", value)

    @property
    @pulumi.getter(name="imageName")
    def image_name(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the container image name.
        """
        return pulumi.get(self, "image_name")

    @image_name.setter
    def image_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_name", value)

    @property
    @pulumi.getter(name="imageTag")
    def image_tag(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the container image tag.
        """
        return pulumi.get(self, "image_tag")

    @image_tag.setter
    def image_tag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_tag", value)

    @property
    @pulumi.getter(name="registryProperties")
    def registry_properties(self) -> Optional[pulumi.Input['ACRPropertiesArgs']]:
        """
        Class for ACR Properties.
        """
        return pulumi.get(self, "registry_properties")

    @registry_properties.setter
    def registry_properties(self, value: Optional[pulumi.Input['ACRPropertiesArgs']]):
        pulumi.set(self, "registry_properties", value)

    @property
    @pulumi.getter(name="runId")
    def run_id(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the RunId.
        """
        return pulumi.get(self, "run_id")

    @run_id.setter
    def run_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "run_id", value)

    @property
    @pulumi.getter(name="runStatus")
    def run_status(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the RunStatus.
        """
        return pulumi.get(self, "run_status")

    @run_status.setter
    def run_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "run_status", value)


@pulumi.input_type
class DirectoryPathArgs:
    def __init__(__self__, *,
                 physical: Optional[pulumi.Input[str]] = None,
                 virtual: Optional[pulumi.Input[str]] = None):
        """
        Second level entity for virtual directories.
        :param pulumi.Input[str] physical: Gets or sets the physical path of the directory on the web server.
        :param pulumi.Input[str] virtual: Gets or sets the virtual path for the directory.
        """
        if physical is not None:
            pulumi.set(__self__, "physical", physical)
        if virtual is not None:
            pulumi.set(__self__, "virtual", virtual)

    @property
    @pulumi.getter
    def physical(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the physical path of the directory on the web server.
        """
        return pulumi.get(self, "physical")

    @physical.setter
    def physical(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "physical", value)

    @property
    @pulumi.getter
    def virtual(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the virtual path for the directory.
        """
        return pulumi.get(self, "virtual")

    @virtual.setter
    def virtual(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "virtual", value)


@pulumi.input_type
class GmsaAuthenticationPropertiesArgs:
    def __init__(__self__, *,
                 ad_domain_controller_dns: Optional[pulumi.Input[str]] = None,
                 ad_domain_fqdn: Optional[pulumi.Input[str]] = None,
                 akv_properties: Optional[pulumi.Input['KeyVaultSecretStorePropertiesArgs']] = None,
                 domain_admin_password: Optional[pulumi.Input[str]] = None,
                 domain_admin_username: Optional[pulumi.Input[str]] = None,
                 domain_controller_address: Optional[pulumi.Input[str]] = None,
                 gmsa_account_name: Optional[pulumi.Input[str]] = None,
                 gmsa_user_password: Optional[pulumi.Input[str]] = None,
                 gmsa_username: Optional[pulumi.Input[str]] = None):
        """
        Class for GMSA authentication details to configure Active Directory connectivity.
        :param pulumi.Input[str] ad_domain_controller_dns: Gets or sets the list of dns server that can resolve the Active Directory Domain Name/Address.
        :param pulumi.Input[str] ad_domain_fqdn: Gets or sets the FQDN of the Active Directory Domain. For e.g. 'contoso.local', 'fareast.corp.microsoft.com' etc.
        :param pulumi.Input[str] domain_admin_password: Gets or sets the password of the user specified by RestApi.Controllers.V2022_05_01_preview.Models.WorkloadDeployment.Gmsa.GmsaAuthenticationProperties.DomainAdminUsername.
        :param pulumi.Input[str] domain_admin_username: Gets or sets the name of the user having admin rights on the Active Directory Domain Controller.
        :param pulumi.Input[str] domain_controller_address: Gets or sets the address of the Active Directory Domain Controller running Domain Services.
        :param pulumi.Input[str] gmsa_account_name: Gets or sets the name to be used for GMSA.
        :param pulumi.Input[str] gmsa_user_password: Gets or sets the password of the user specified by RestApi.Controllers.V2022_05_01_preview.Models.WorkloadDeployment.Gmsa.GmsaAuthenticationProperties.GmsaUsername.
        :param pulumi.Input[str] gmsa_username: Gets or sets username of the user having authorization to access GMSA on Active Directory.
        """
        if ad_domain_controller_dns is not None:
            pulumi.set(__self__, "ad_domain_controller_dns", ad_domain_controller_dns)
        if ad_domain_fqdn is not None:
            pulumi.set(__self__, "ad_domain_fqdn", ad_domain_fqdn)
        if akv_properties is not None:
            pulumi.set(__self__, "akv_properties", akv_properties)
        if domain_admin_password is not None:
            pulumi.set(__self__, "domain_admin_password", domain_admin_password)
        if domain_admin_username is not None:
            pulumi.set(__self__, "domain_admin_username", domain_admin_username)
        if domain_controller_address is not None:
            pulumi.set(__self__, "domain_controller_address", domain_controller_address)
        if gmsa_account_name is not None:
            pulumi.set(__self__, "gmsa_account_name", gmsa_account_name)
        if gmsa_user_password is not None:
            pulumi.set(__self__, "gmsa_user_password", gmsa_user_password)
        if gmsa_username is not None:
            pulumi.set(__self__, "gmsa_username", gmsa_username)

    @property
    @pulumi.getter(name="adDomainControllerDns")
    def ad_domain_controller_dns(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the list of dns server that can resolve the Active Directory Domain Name/Address.
        """
        return pulumi.get(self, "ad_domain_controller_dns")

    @ad_domain_controller_dns.setter
    def ad_domain_controller_dns(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ad_domain_controller_dns", value)

    @property
    @pulumi.getter(name="adDomainFqdn")
    def ad_domain_fqdn(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the FQDN of the Active Directory Domain. For e.g. 'contoso.local', 'fareast.corp.microsoft.com' etc.
        """
        return pulumi.get(self, "ad_domain_fqdn")

    @ad_domain_fqdn.setter
    def ad_domain_fqdn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ad_domain_fqdn", value)

    @property
    @pulumi.getter(name="akvProperties")
    def akv_properties(self) -> Optional[pulumi.Input['KeyVaultSecretStorePropertiesArgs']]:
        return pulumi.get(self, "akv_properties")

    @akv_properties.setter
    def akv_properties(self, value: Optional[pulumi.Input['KeyVaultSecretStorePropertiesArgs']]):
        pulumi.set(self, "akv_properties", value)

    @property
    @pulumi.getter(name="domainAdminPassword")
    def domain_admin_password(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the password of the user specified by RestApi.Controllers.V2022_05_01_preview.Models.WorkloadDeployment.Gmsa.GmsaAuthenticationProperties.DomainAdminUsername.
        """
        return pulumi.get(self, "domain_admin_password")

    @domain_admin_password.setter
    def domain_admin_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain_admin_password", value)

    @property
    @pulumi.getter(name="domainAdminUsername")
    def domain_admin_username(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the name of the user having admin rights on the Active Directory Domain Controller.
        """
        return pulumi.get(self, "domain_admin_username")

    @domain_admin_username.setter
    def domain_admin_username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain_admin_username", value)

    @property
    @pulumi.getter(name="domainControllerAddress")
    def domain_controller_address(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the address of the Active Directory Domain Controller running Domain Services.
        """
        return pulumi.get(self, "domain_controller_address")

    @domain_controller_address.setter
    def domain_controller_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain_controller_address", value)

    @property
    @pulumi.getter(name="gmsaAccountName")
    def gmsa_account_name(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the name to be used for GMSA.
        """
        return pulumi.get(self, "gmsa_account_name")

    @gmsa_account_name.setter
    def gmsa_account_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gmsa_account_name", value)

    @property
    @pulumi.getter(name="gmsaUserPassword")
    def gmsa_user_password(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the password of the user specified by RestApi.Controllers.V2022_05_01_preview.Models.WorkloadDeployment.Gmsa.GmsaAuthenticationProperties.GmsaUsername.
        """
        return pulumi.get(self, "gmsa_user_password")

    @gmsa_user_password.setter
    def gmsa_user_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gmsa_user_password", value)

    @property
    @pulumi.getter(name="gmsaUsername")
    def gmsa_username(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets username of the user having authorization to access GMSA on Active Directory.
        """
        return pulumi.get(self, "gmsa_username")

    @gmsa_username.setter
    def gmsa_username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gmsa_username", value)


@pulumi.input_type
class IISAKSWorkloadDeploymentModelCustomPropertiesArgs:
    def __init__(__self__, *,
                 instance_type: pulumi.Input[str],
                 iis_aks_workload_deployment_properties: Optional[pulumi.Input['IISAKSWorkloadDeploymentArgs']] = None):
        """
        IIS workload instance model custom properties.
        :param pulumi.Input[str] instance_type: Gets or sets the instance type.
               Expected value is 'IISAKSWorkloadDeploymentModelCustomProperties'.
        :param pulumi.Input['IISAKSWorkloadDeploymentArgs'] iis_aks_workload_deployment_properties: IIS AKS workload deployment.
        """
        pulumi.set(__self__, "instance_type", 'IISAKSWorkloadDeploymentModelCustomProperties')
        if iis_aks_workload_deployment_properties is not None:
            pulumi.set(__self__, "iis_aks_workload_deployment_properties", iis_aks_workload_deployment_properties)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Input[str]:
        """
        Gets or sets the instance type.
        Expected value is 'IISAKSWorkloadDeploymentModelCustomProperties'.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="iisAksWorkloadDeploymentProperties")
    def iis_aks_workload_deployment_properties(self) -> Optional[pulumi.Input['IISAKSWorkloadDeploymentArgs']]:
        """
        IIS AKS workload deployment.
        """
        return pulumi.get(self, "iis_aks_workload_deployment_properties")

    @iis_aks_workload_deployment_properties.setter
    def iis_aks_workload_deployment_properties(self, value: Optional[pulumi.Input['IISAKSWorkloadDeploymentArgs']]):
        pulumi.set(self, "iis_aks_workload_deployment_properties", value)


@pulumi.input_type
class IISAKSWorkloadDeploymentArgs:
    def __init__(__self__, *,
                 authentication_properties: Optional[pulumi.Input['GmsaAuthenticationPropertiesArgs']] = None,
                 automation_artifact_properties: Optional[pulumi.Input['AutomationArtifactArgs']] = None,
                 bindings: Optional[pulumi.Input[Sequence[pulumi.Input['BindingArgs']]]] = None,
                 build_container_images: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerImagePropertiesArgs']]]] = None,
                 cluster_properties: Optional[pulumi.Input['AKSDeploymentPropertiesArgs']] = None,
                 configurations: Optional[pulumi.Input[Sequence[pulumi.Input['WebApplicationConfigurationArgs']]]] = None,
                 container_image_properties: Optional[pulumi.Input['ContainerImagePropertiesArgs']] = None,
                 deployment_name_prefix: Optional[pulumi.Input[str]] = None,
                 deployment_spec: Optional[pulumi.Input['AKSDeploymentSpecificationArgs']] = None,
                 directories: Optional[pulumi.Input[Sequence[pulumi.Input['WebApplicationDirectoryArgs']]]] = None,
                 limits: Optional[pulumi.Input['ResourceRequirementsArgs']] = None,
                 monitoring_properties: Optional[pulumi.Input['AppInsightMonitoringPropertiesArgs']] = None,
                 requests: Optional[pulumi.Input['ResourceRequirementsArgs']] = None,
                 target_platform_identity: Optional[pulumi.Input[str]] = None):
        """
        IIS AKS workload deployment.
        :param pulumi.Input['GmsaAuthenticationPropertiesArgs'] authentication_properties: Class for GMSA authentication details to configure Active Directory connectivity.
        :param pulumi.Input['AutomationArtifactArgs'] automation_artifact_properties: Class for automation artifact.
        :param pulumi.Input[Sequence[pulumi.Input['BindingArgs']]] bindings: Gets or sets the bindings for the application.
        :param pulumi.Input[Sequence[pulumi.Input['ContainerImagePropertiesArgs']]] build_container_images: Gets or sets the build container images.
        :param pulumi.Input['AKSDeploymentPropertiesArgs'] cluster_properties: Class for AKSDeployment Properties.
        :param pulumi.Input[Sequence[pulumi.Input['WebApplicationConfigurationArgs']]] configurations: Gets or sets application configuration.
        :param pulumi.Input['ContainerImagePropertiesArgs'] container_image_properties: Class for container image properties.
        :param pulumi.Input[str] deployment_name_prefix: Gets or sets the deployment name prefix.
        :param pulumi.Input['AKSDeploymentSpecificationArgs'] deployment_spec: AKS Deployment Specification.
        :param pulumi.Input[Sequence[pulumi.Input['WebApplicationDirectoryArgs']]] directories: Gets or sets application directories.
        :param pulumi.Input['ResourceRequirementsArgs'] limits: Resource Requirements.
        :param pulumi.Input['AppInsightMonitoringPropertiesArgs'] monitoring_properties: Class for app insight monitoring properties.
        :param pulumi.Input['ResourceRequirementsArgs'] requests: Resource Requirements.
        :param pulumi.Input[str] target_platform_identity: Gets or sets the target platform managed identity.
        """
        if authentication_properties is not None:
            pulumi.set(__self__, "authentication_properties", authentication_properties)
        if automation_artifact_properties is not None:
            pulumi.set(__self__, "automation_artifact_properties", automation_artifact_properties)
        if bindings is not None:
            pulumi.set(__self__, "bindings", bindings)
        if build_container_images is not None:
            pulumi.set(__self__, "build_container_images", build_container_images)
        if cluster_properties is not None:
            pulumi.set(__self__, "cluster_properties", cluster_properties)
        if configurations is not None:
            pulumi.set(__self__, "configurations", configurations)
        if container_image_properties is not None:
            pulumi.set(__self__, "container_image_properties", container_image_properties)
        if deployment_name_prefix is not None:
            pulumi.set(__self__, "deployment_name_prefix", deployment_name_prefix)
        if deployment_spec is not None:
            pulumi.set(__self__, "deployment_spec", deployment_spec)
        if directories is not None:
            pulumi.set(__self__, "directories", directories)
        if limits is not None:
            pulumi.set(__self__, "limits", limits)
        if monitoring_properties is not None:
            pulumi.set(__self__, "monitoring_properties", monitoring_properties)
        if requests is not None:
            pulumi.set(__self__, "requests", requests)
        if target_platform_identity is not None:
            pulumi.set(__self__, "target_platform_identity", target_platform_identity)

    @property
    @pulumi.getter(name="authenticationProperties")
    def authentication_properties(self) -> Optional[pulumi.Input['GmsaAuthenticationPropertiesArgs']]:
        """
        Class for GMSA authentication details to configure Active Directory connectivity.
        """
        return pulumi.get(self, "authentication_properties")

    @authentication_properties.setter
    def authentication_properties(self, value: Optional[pulumi.Input['GmsaAuthenticationPropertiesArgs']]):
        pulumi.set(self, "authentication_properties", value)

    @property
    @pulumi.getter(name="automationArtifactProperties")
    def automation_artifact_properties(self) -> Optional[pulumi.Input['AutomationArtifactArgs']]:
        """
        Class for automation artifact.
        """
        return pulumi.get(self, "automation_artifact_properties")

    @automation_artifact_properties.setter
    def automation_artifact_properties(self, value: Optional[pulumi.Input['AutomationArtifactArgs']]):
        pulumi.set(self, "automation_artifact_properties", value)

    @property
    @pulumi.getter
    def bindings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BindingArgs']]]]:
        """
        Gets or sets the bindings for the application.
        """
        return pulumi.get(self, "bindings")

    @bindings.setter
    def bindings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BindingArgs']]]]):
        pulumi.set(self, "bindings", value)

    @property
    @pulumi.getter(name="buildContainerImages")
    def build_container_images(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerImagePropertiesArgs']]]]:
        """
        Gets or sets the build container images.
        """
        return pulumi.get(self, "build_container_images")

    @build_container_images.setter
    def build_container_images(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerImagePropertiesArgs']]]]):
        pulumi.set(self, "build_container_images", value)

    @property
    @pulumi.getter(name="clusterProperties")
    def cluster_properties(self) -> Optional[pulumi.Input['AKSDeploymentPropertiesArgs']]:
        """
        Class for AKSDeployment Properties.
        """
        return pulumi.get(self, "cluster_properties")

    @cluster_properties.setter
    def cluster_properties(self, value: Optional[pulumi.Input['AKSDeploymentPropertiesArgs']]):
        pulumi.set(self, "cluster_properties", value)

    @property
    @pulumi.getter
    def configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WebApplicationConfigurationArgs']]]]:
        """
        Gets or sets application configuration.
        """
        return pulumi.get(self, "configurations")

    @configurations.setter
    def configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WebApplicationConfigurationArgs']]]]):
        pulumi.set(self, "configurations", value)

    @property
    @pulumi.getter(name="containerImageProperties")
    def container_image_properties(self) -> Optional[pulumi.Input['ContainerImagePropertiesArgs']]:
        """
        Class for container image properties.
        """
        return pulumi.get(self, "container_image_properties")

    @container_image_properties.setter
    def container_image_properties(self, value: Optional[pulumi.Input['ContainerImagePropertiesArgs']]):
        pulumi.set(self, "container_image_properties", value)

    @property
    @pulumi.getter(name="deploymentNamePrefix")
    def deployment_name_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the deployment name prefix.
        """
        return pulumi.get(self, "deployment_name_prefix")

    @deployment_name_prefix.setter
    def deployment_name_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deployment_name_prefix", value)

    @property
    @pulumi.getter(name="deploymentSpec")
    def deployment_spec(self) -> Optional[pulumi.Input['AKSDeploymentSpecificationArgs']]:
        """
        AKS Deployment Specification.
        """
        return pulumi.get(self, "deployment_spec")

    @deployment_spec.setter
    def deployment_spec(self, value: Optional[pulumi.Input['AKSDeploymentSpecificationArgs']]):
        pulumi.set(self, "deployment_spec", value)

    @property
    @pulumi.getter
    def directories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WebApplicationDirectoryArgs']]]]:
        """
        Gets or sets application directories.
        """
        return pulumi.get(self, "directories")

    @directories.setter
    def directories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WebApplicationDirectoryArgs']]]]):
        pulumi.set(self, "directories", value)

    @property
    @pulumi.getter
    def limits(self) -> Optional[pulumi.Input['ResourceRequirementsArgs']]:
        """
        Resource Requirements.
        """
        return pulumi.get(self, "limits")

    @limits.setter
    def limits(self, value: Optional[pulumi.Input['ResourceRequirementsArgs']]):
        pulumi.set(self, "limits", value)

    @property
    @pulumi.getter(name="monitoringProperties")
    def monitoring_properties(self) -> Optional[pulumi.Input['AppInsightMonitoringPropertiesArgs']]:
        """
        Class for app insight monitoring properties.
        """
        return pulumi.get(self, "monitoring_properties")

    @monitoring_properties.setter
    def monitoring_properties(self, value: Optional[pulumi.Input['AppInsightMonitoringPropertiesArgs']]):
        pulumi.set(self, "monitoring_properties", value)

    @property
    @pulumi.getter
    def requests(self) -> Optional[pulumi.Input['ResourceRequirementsArgs']]:
        """
        Resource Requirements.
        """
        return pulumi.get(self, "requests")

    @requests.setter
    def requests(self, value: Optional[pulumi.Input['ResourceRequirementsArgs']]):
        pulumi.set(self, "requests", value)

    @property
    @pulumi.getter(name="targetPlatformIdentity")
    def target_platform_identity(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the target platform managed identity.
        """
        return pulumi.get(self, "target_platform_identity")

    @target_platform_identity.setter
    def target_platform_identity(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_platform_identity", value)


@pulumi.input_type
class IISApplicationDetailsArgs:
    def __init__(__self__, *,
                 application_pool_name: Optional[pulumi.Input[str]] = None,
                 directories: Optional[pulumi.Input[Sequence[pulumi.Input['DirectoryPathArgs']]]] = None,
                 enable32_bit_api_on_win64: Optional[pulumi.Input[bool]] = None,
                 managed_pipeline_mode: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input['DirectoryPathArgs']] = None,
                 runtime_version: Optional[pulumi.Input[str]] = None):
        """
        IISApplication details.
        :param pulumi.Input[str] application_pool_name: Gets or sets the application pool name.
        :param pulumi.Input[Sequence[pulumi.Input['DirectoryPathArgs']]] directories: Gets or sets the list of directories.
        :param pulumi.Input[bool] enable32_bit_api_on_win64: Gets or sets a value indicating whether 32 bit applications are allowed to run on 64 bit.
        :param pulumi.Input[str] managed_pipeline_mode: Gets or sets the managed pipeline mode.
        :param pulumi.Input['DirectoryPathArgs'] path: Second level entity for virtual directories.
        :param pulumi.Input[str] runtime_version: Gets or sets the runtime version.
        """
        if application_pool_name is not None:
            pulumi.set(__self__, "application_pool_name", application_pool_name)
        if directories is not None:
            pulumi.set(__self__, "directories", directories)
        if enable32_bit_api_on_win64 is not None:
            pulumi.set(__self__, "enable32_bit_api_on_win64", enable32_bit_api_on_win64)
        if managed_pipeline_mode is not None:
            pulumi.set(__self__, "managed_pipeline_mode", managed_pipeline_mode)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if runtime_version is not None:
            pulumi.set(__self__, "runtime_version", runtime_version)

    @property
    @pulumi.getter(name="applicationPoolName")
    def application_pool_name(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the application pool name.
        """
        return pulumi.get(self, "application_pool_name")

    @application_pool_name.setter
    def application_pool_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "application_pool_name", value)

    @property
    @pulumi.getter
    def directories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DirectoryPathArgs']]]]:
        """
        Gets or sets the list of directories.
        """
        return pulumi.get(self, "directories")

    @directories.setter
    def directories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DirectoryPathArgs']]]]):
        pulumi.set(self, "directories", value)

    @property
    @pulumi.getter(name="enable32BitApiOnWin64")
    def enable32_bit_api_on_win64(self) -> Optional[pulumi.Input[bool]]:
        """
        Gets or sets a value indicating whether 32 bit applications are allowed to run on 64 bit.
        """
        return pulumi.get(self, "enable32_bit_api_on_win64")

    @enable32_bit_api_on_win64.setter
    def enable32_bit_api_on_win64(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable32_bit_api_on_win64", value)

    @property
    @pulumi.getter(name="managedPipelineMode")
    def managed_pipeline_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the managed pipeline mode.
        """
        return pulumi.get(self, "managed_pipeline_mode")

    @managed_pipeline_mode.setter
    def managed_pipeline_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "managed_pipeline_mode", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input['DirectoryPathArgs']]:
        """
        Second level entity for virtual directories.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input['DirectoryPathArgs']]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="runtimeVersion")
    def runtime_version(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the runtime version.
        """
        return pulumi.get(self, "runtime_version")

    @runtime_version.setter
    def runtime_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "runtime_version", value)


@pulumi.input_type
class IISVirtualApplicationDetailsArgs:
    def __init__(__self__, *,
                 directories: Optional[pulumi.Input[Sequence[pulumi.Input['DirectoryPathArgs']]]] = None,
                 path: Optional[pulumi.Input['DirectoryPathArgs']] = None):
        """
        IIS virtual application details.
        :param pulumi.Input[Sequence[pulumi.Input['DirectoryPathArgs']]] directories: Gets or sets the list of directories.
        :param pulumi.Input['DirectoryPathArgs'] path: Second level entity for virtual directories.
        """
        if directories is not None:
            pulumi.set(__self__, "directories", directories)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter
    def directories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DirectoryPathArgs']]]]:
        """
        Gets or sets the list of directories.
        """
        return pulumi.get(self, "directories")

    @directories.setter
    def directories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DirectoryPathArgs']]]]):
        pulumi.set(self, "directories", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input['DirectoryPathArgs']]:
        """
        Second level entity for virtual directories.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input['DirectoryPathArgs']]):
        pulumi.set(self, "path", value)


@pulumi.input_type
class IISWebApplicationArgs:
    def __init__(__self__, *,
                 application_id: Optional[pulumi.Input[str]] = None,
                 application_name: Optional[pulumi.Input[str]] = None,
                 application_scratch_path: Optional[pulumi.Input[str]] = None,
                 applications: Optional[pulumi.Input[Sequence[pulumi.Input['IISApplicationDetailsArgs']]]] = None,
                 bindings: Optional[pulumi.Input[Sequence[pulumi.Input['BindingArgs']]]] = None,
                 configurations: Optional[pulumi.Input[Sequence[pulumi.Input['WebApplicationConfigurationArgs']]]] = None,
                 directories: Optional[pulumi.Input[Sequence[pulumi.Input['WebApplicationDirectoryArgs']]]] = None,
                 discovered_frameworks: Optional[pulumi.Input[Sequence[pulumi.Input['WebApplicationFrameworkArgs']]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 iis_web_server: Optional[pulumi.Input['IISWebServerArgs']] = None,
                 limits: Optional[pulumi.Input['ResourceRequirementsArgs']] = None,
                 path: Optional[pulumi.Input['DirectoryPathArgs']] = None,
                 primary_framework: Optional[pulumi.Input['WebApplicationFrameworkArgs']] = None,
                 requests: Optional[pulumi.Input['ResourceRequirementsArgs']] = None,
                 virtual_applications: Optional[pulumi.Input[Sequence[pulumi.Input['IISVirtualApplicationDetailsArgs']]]] = None,
                 web_server_id: Optional[pulumi.Input[str]] = None,
                 web_server_name: Optional[pulumi.Input[str]] = None):
        """
        IISWeb application.
        :param pulumi.Input[str] application_id: Gets or sets the web application id.
        :param pulumi.Input[str] application_name: Gets or sets the web application name.
        :param pulumi.Input[str] application_scratch_path: Gets or sets application scratch path.
        :param pulumi.Input[Sequence[pulumi.Input['IISApplicationDetailsArgs']]] applications: Gets or sets the list of applications for the IIS web site.
        :param pulumi.Input[Sequence[pulumi.Input['BindingArgs']]] bindings: Gets or sets the bindings for the application.
        :param pulumi.Input[Sequence[pulumi.Input['WebApplicationConfigurationArgs']]] configurations: Gets or sets application configuration.
        :param pulumi.Input[Sequence[pulumi.Input['WebApplicationDirectoryArgs']]] directories: Gets or sets application directories.
        :param pulumi.Input[Sequence[pulumi.Input['WebApplicationFrameworkArgs']]] discovered_frameworks: Gets or sets the discovered frameworks of application.
        :param pulumi.Input[str] display_name: Gets or sets the display name.
        :param pulumi.Input['IISWebServerArgs'] iis_web_server: IISWeb server.
        :param pulumi.Input['ResourceRequirementsArgs'] limits: Resource Requirements.
        :param pulumi.Input['DirectoryPathArgs'] path: Second level entity for virtual directories.
        :param pulumi.Input['WebApplicationFrameworkArgs'] primary_framework: Framework specific data for a web application.
        :param pulumi.Input['ResourceRequirementsArgs'] requests: Resource Requirements.
        :param pulumi.Input[Sequence[pulumi.Input['IISVirtualApplicationDetailsArgs']]] virtual_applications: Gets or sets the list of application units for the web site.
        :param pulumi.Input[str] web_server_id: Gets or sets the web server id.
        :param pulumi.Input[str] web_server_name: Gets or sets the web server name.
        """
        if application_id is not None:
            pulumi.set(__self__, "application_id", application_id)
        if application_name is not None:
            pulumi.set(__self__, "application_name", application_name)
        if application_scratch_path is not None:
            pulumi.set(__self__, "application_scratch_path", application_scratch_path)
        if applications is not None:
            pulumi.set(__self__, "applications", applications)
        if bindings is not None:
            pulumi.set(__self__, "bindings", bindings)
        if configurations is not None:
            pulumi.set(__self__, "configurations", configurations)
        if directories is not None:
            pulumi.set(__self__, "directories", directories)
        if discovered_frameworks is not None:
            pulumi.set(__self__, "discovered_frameworks", discovered_frameworks)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if iis_web_server is not None:
            pulumi.set(__self__, "iis_web_server", iis_web_server)
        if limits is not None:
            pulumi.set(__self__, "limits", limits)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if primary_framework is not None:
            pulumi.set(__self__, "primary_framework", primary_framework)
        if requests is not None:
            pulumi.set(__self__, "requests", requests)
        if virtual_applications is not None:
            pulumi.set(__self__, "virtual_applications", virtual_applications)
        if web_server_id is not None:
            pulumi.set(__self__, "web_server_id", web_server_id)
        if web_server_name is not None:
            pulumi.set(__self__, "web_server_name", web_server_name)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the web application id.
        """
        return pulumi.get(self, "application_id")

    @application_id.setter
    def application_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "application_id", value)

    @property
    @pulumi.getter(name="applicationName")
    def application_name(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the web application name.
        """
        return pulumi.get(self, "application_name")

    @application_name.setter
    def application_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "application_name", value)

    @property
    @pulumi.getter(name="applicationScratchPath")
    def application_scratch_path(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets application scratch path.
        """
        return pulumi.get(self, "application_scratch_path")

    @application_scratch_path.setter
    def application_scratch_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "application_scratch_path", value)

    @property
    @pulumi.getter
    def applications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IISApplicationDetailsArgs']]]]:
        """
        Gets or sets the list of applications for the IIS web site.
        """
        return pulumi.get(self, "applications")

    @applications.setter
    def applications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IISApplicationDetailsArgs']]]]):
        pulumi.set(self, "applications", value)

    @property
    @pulumi.getter
    def bindings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BindingArgs']]]]:
        """
        Gets or sets the bindings for the application.
        """
        return pulumi.get(self, "bindings")

    @bindings.setter
    def bindings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BindingArgs']]]]):
        pulumi.set(self, "bindings", value)

    @property
    @pulumi.getter
    def configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WebApplicationConfigurationArgs']]]]:
        """
        Gets or sets application configuration.
        """
        return pulumi.get(self, "configurations")

    @configurations.setter
    def configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WebApplicationConfigurationArgs']]]]):
        pulumi.set(self, "configurations", value)

    @property
    @pulumi.getter
    def directories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WebApplicationDirectoryArgs']]]]:
        """
        Gets or sets application directories.
        """
        return pulumi.get(self, "directories")

    @directories.setter
    def directories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WebApplicationDirectoryArgs']]]]):
        pulumi.set(self, "directories", value)

    @property
    @pulumi.getter(name="discoveredFrameworks")
    def discovered_frameworks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WebApplicationFrameworkArgs']]]]:
        """
        Gets or sets the discovered frameworks of application.
        """
        return pulumi.get(self, "discovered_frameworks")

    @discovered_frameworks.setter
    def discovered_frameworks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WebApplicationFrameworkArgs']]]]):
        pulumi.set(self, "discovered_frameworks", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the display name.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="iisWebServer")
    def iis_web_server(self) -> Optional[pulumi.Input['IISWebServerArgs']]:
        """
        IISWeb server.
        """
        return pulumi.get(self, "iis_web_server")

    @iis_web_server.setter
    def iis_web_server(self, value: Optional[pulumi.Input['IISWebServerArgs']]):
        pulumi.set(self, "iis_web_server", value)

    @property
    @pulumi.getter
    def limits(self) -> Optional[pulumi.Input['ResourceRequirementsArgs']]:
        """
        Resource Requirements.
        """
        return pulumi.get(self, "limits")

    @limits.setter
    def limits(self, value: Optional[pulumi.Input['ResourceRequirementsArgs']]):
        pulumi.set(self, "limits", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input['DirectoryPathArgs']]:
        """
        Second level entity for virtual directories.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input['DirectoryPathArgs']]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="primaryFramework")
    def primary_framework(self) -> Optional[pulumi.Input['WebApplicationFrameworkArgs']]:
        """
        Framework specific data for a web application.
        """
        return pulumi.get(self, "primary_framework")

    @primary_framework.setter
    def primary_framework(self, value: Optional[pulumi.Input['WebApplicationFrameworkArgs']]):
        pulumi.set(self, "primary_framework", value)

    @property
    @pulumi.getter
    def requests(self) -> Optional[pulumi.Input['ResourceRequirementsArgs']]:
        """
        Resource Requirements.
        """
        return pulumi.get(self, "requests")

    @requests.setter
    def requests(self, value: Optional[pulumi.Input['ResourceRequirementsArgs']]):
        pulumi.set(self, "requests", value)

    @property
    @pulumi.getter(name="virtualApplications")
    def virtual_applications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IISVirtualApplicationDetailsArgs']]]]:
        """
        Gets or sets the list of application units for the web site.
        """
        return pulumi.get(self, "virtual_applications")

    @virtual_applications.setter
    def virtual_applications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IISVirtualApplicationDetailsArgs']]]]):
        pulumi.set(self, "virtual_applications", value)

    @property
    @pulumi.getter(name="webServerId")
    def web_server_id(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the web server id.
        """
        return pulumi.get(self, "web_server_id")

    @web_server_id.setter
    def web_server_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "web_server_id", value)

    @property
    @pulumi.getter(name="webServerName")
    def web_server_name(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the web server name.
        """
        return pulumi.get(self, "web_server_name")

    @web_server_name.setter
    def web_server_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "web_server_name", value)


@pulumi.input_type
class IISWebServerArgs:
    def __init__(__self__, *,
                 display_name: Optional[pulumi.Input[str]] = None,
                 ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 machines: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 operating_system_details: Optional[pulumi.Input['OperatingSystemDetailsArgs']] = None,
                 root_configuration_location: Optional[pulumi.Input[str]] = None,
                 run_as_account_id: Optional[pulumi.Input[str]] = None,
                 server_fqdn: Optional[pulumi.Input[str]] = None,
                 server_id: Optional[pulumi.Input[str]] = None,
                 server_name: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 web_applications: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        IISWeb server.
        :param pulumi.Input[str] display_name: Gets or sets the display name.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ip_addresses: Gets or sets list of ip addresses.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] machines: Gets or sets the list of machines.
        :param pulumi.Input[str] root_configuration_location: Gets or sets the server root configuration location.
        :param pulumi.Input[str] run_as_account_id: Gets or sets the run as account id.
        :param pulumi.Input[str] server_fqdn: Gets or sets the server FQDN.
        :param pulumi.Input[str] server_id: Gets or sets the web server id.
        :param pulumi.Input[str] server_name: Gets or sets the web server name.
        :param pulumi.Input[str] version: Gets or sets the server version.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] web_applications: Gets or sets the list of web applications.
        """
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if ip_addresses is not None:
            pulumi.set(__self__, "ip_addresses", ip_addresses)
        if machines is not None:
            pulumi.set(__self__, "machines", machines)
        if operating_system_details is not None:
            pulumi.set(__self__, "operating_system_details", operating_system_details)
        if root_configuration_location is not None:
            pulumi.set(__self__, "root_configuration_location", root_configuration_location)
        if run_as_account_id is not None:
            pulumi.set(__self__, "run_as_account_id", run_as_account_id)
        if server_fqdn is not None:
            pulumi.set(__self__, "server_fqdn", server_fqdn)
        if server_id is not None:
            pulumi.set(__self__, "server_id", server_id)
        if server_name is not None:
            pulumi.set(__self__, "server_name", server_name)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if web_applications is not None:
            pulumi.set(__self__, "web_applications", web_applications)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the display name.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Gets or sets list of ip addresses.
        """
        return pulumi.get(self, "ip_addresses")

    @ip_addresses.setter
    def ip_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ip_addresses", value)

    @property
    @pulumi.getter
    def machines(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Gets or sets the list of machines.
        """
        return pulumi.get(self, "machines")

    @machines.setter
    def machines(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "machines", value)

    @property
    @pulumi.getter(name="operatingSystemDetails")
    def operating_system_details(self) -> Optional[pulumi.Input['OperatingSystemDetailsArgs']]:
        return pulumi.get(self, "operating_system_details")

    @operating_system_details.setter
    def operating_system_details(self, value: Optional[pulumi.Input['OperatingSystemDetailsArgs']]):
        pulumi.set(self, "operating_system_details", value)

    @property
    @pulumi.getter(name="rootConfigurationLocation")
    def root_configuration_location(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the server root configuration location.
        """
        return pulumi.get(self, "root_configuration_location")

    @root_configuration_location.setter
    def root_configuration_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "root_configuration_location", value)

    @property
    @pulumi.getter(name="runAsAccountId")
    def run_as_account_id(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the run as account id.
        """
        return pulumi.get(self, "run_as_account_id")

    @run_as_account_id.setter
    def run_as_account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "run_as_account_id", value)

    @property
    @pulumi.getter(name="serverFqdn")
    def server_fqdn(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the server FQDN.
        """
        return pulumi.get(self, "server_fqdn")

    @server_fqdn.setter
    def server_fqdn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_fqdn", value)

    @property
    @pulumi.getter(name="serverId")
    def server_id(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the web server id.
        """
        return pulumi.get(self, "server_id")

    @server_id.setter
    def server_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_id", value)

    @property
    @pulumi.getter(name="serverName")
    def server_name(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the web server name.
        """
        return pulumi.get(self, "server_name")

    @server_name.setter
    def server_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_name", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the server version.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter(name="webApplications")
    def web_applications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Gets or sets the list of web applications.
        """
        return pulumi.get(self, "web_applications")

    @web_applications.setter
    def web_applications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "web_applications", value)


@pulumi.input_type
class IISWorkloadInstanceModelCustomPropertiesArgs:
    def __init__(__self__, *,
                 instance_type: pulumi.Input[str],
                 container_name: Optional[pulumi.Input[str]] = None,
                 fileshare_name: Optional[pulumi.Input[str]] = None,
                 iis_web_application: Optional[pulumi.Input['IISWebApplicationArgs']] = None,
                 web_app_arm_id: Optional[pulumi.Input[str]] = None,
                 web_app_site_name: Optional[pulumi.Input[str]] = None):
        """
        IIS workload instance model custom properties.
        :param pulumi.Input[str] instance_type: Gets or sets the instance type.
               Expected value is 'IISWorkloadInstanceModelCustomProperties'.
        :param pulumi.Input[str] container_name: Gets or sets the container Id.
        :param pulumi.Input[str] fileshare_name: Gets or sets the fileshare name.
        :param pulumi.Input['IISWebApplicationArgs'] iis_web_application: IISWeb application.
        :param pulumi.Input[str] web_app_arm_id: Gets or sets the Web application ARM id.
        :param pulumi.Input[str] web_app_site_name: Gets or sets the Web application site name.
        """
        pulumi.set(__self__, "instance_type", 'IISWorkloadInstanceModelCustomProperties')
        if container_name is not None:
            pulumi.set(__self__, "container_name", container_name)
        if fileshare_name is not None:
            pulumi.set(__self__, "fileshare_name", fileshare_name)
        if iis_web_application is not None:
            pulumi.set(__self__, "iis_web_application", iis_web_application)
        if web_app_arm_id is not None:
            pulumi.set(__self__, "web_app_arm_id", web_app_arm_id)
        if web_app_site_name is not None:
            pulumi.set(__self__, "web_app_site_name", web_app_site_name)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Input[str]:
        """
        Gets or sets the instance type.
        Expected value is 'IISWorkloadInstanceModelCustomProperties'.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the container Id.
        """
        return pulumi.get(self, "container_name")

    @container_name.setter
    def container_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "container_name", value)

    @property
    @pulumi.getter(name="fileshareName")
    def fileshare_name(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the fileshare name.
        """
        return pulumi.get(self, "fileshare_name")

    @fileshare_name.setter
    def fileshare_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fileshare_name", value)

    @property
    @pulumi.getter(name="iisWebApplication")
    def iis_web_application(self) -> Optional[pulumi.Input['IISWebApplicationArgs']]:
        """
        IISWeb application.
        """
        return pulumi.get(self, "iis_web_application")

    @iis_web_application.setter
    def iis_web_application(self, value: Optional[pulumi.Input['IISWebApplicationArgs']]):
        pulumi.set(self, "iis_web_application", value)

    @property
    @pulumi.getter(name="webAppArmId")
    def web_app_arm_id(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the Web application ARM id.
        """
        return pulumi.get(self, "web_app_arm_id")

    @web_app_arm_id.setter
    def web_app_arm_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "web_app_arm_id", value)

    @property
    @pulumi.getter(name="webAppSiteName")
    def web_app_site_name(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the Web application site name.
        """
        return pulumi.get(self, "web_app_site_name")

    @web_app_site_name.setter
    def web_app_site_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "web_app_site_name", value)


@pulumi.input_type
class IdentityModelArgs:
    def __init__(__self__, *,
                 aad_authority: Optional[pulumi.Input[str]] = None,
                 application_id: Optional[pulumi.Input[str]] = None,
                 audience: Optional[pulumi.Input[str]] = None,
                 object_id: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None):
        """
        Identity model.
        :param pulumi.Input[str] aad_authority: Gets or sets the authority of the SPN with which MigrateAgent communicates to service.
        :param pulumi.Input[str] application_id: Gets or sets the client/application Id of the SPN with which MigrateAgent communicates to
               service.
        :param pulumi.Input[str] audience: Gets or sets the audience of the SPN with which MigrateAgent communicates to service.
        :param pulumi.Input[str] object_id: Gets or sets the object Id of the SPN with which MigrateAgent communicates to service.
        :param pulumi.Input[str] tenant_id: Gets or sets the tenant Id of the SPN with which MigrateAgent communicates to service.
        """
        if aad_authority is not None:
            pulumi.set(__self__, "aad_authority", aad_authority)
        if application_id is not None:
            pulumi.set(__self__, "application_id", application_id)
        if audience is not None:
            pulumi.set(__self__, "audience", audience)
        if object_id is not None:
            pulumi.set(__self__, "object_id", object_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="aadAuthority")
    def aad_authority(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the authority of the SPN with which MigrateAgent communicates to service.
        """
        return pulumi.get(self, "aad_authority")

    @aad_authority.setter
    def aad_authority(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "aad_authority", value)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the client/application Id of the SPN with which MigrateAgent communicates to
        service.
        """
        return pulumi.get(self, "application_id")

    @application_id.setter
    def application_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "application_id", value)

    @property
    @pulumi.getter
    def audience(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the audience of the SPN with which MigrateAgent communicates to service.
        """
        return pulumi.get(self, "audience")

    @audience.setter
    def audience(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "audience", value)

    @property
    @pulumi.getter(name="objectId")
    def object_id(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the object Id of the SPN with which MigrateAgent communicates to service.
        """
        return pulumi.get(self, "object_id")

    @object_id.setter
    def object_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "object_id", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the tenant Id of the SPN with which MigrateAgent communicates to service.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)


@pulumi.input_type
class KeyVaultSecretStorePropertiesArgs:
    def __init__(__self__, *,
                 keyvault_name: Optional[pulumi.Input[str]] = None,
                 managed_identity_properties: Optional[pulumi.Input['ManagedIdentityPropertiesArgs']] = None,
                 resource_group: Optional[pulumi.Input[str]] = None,
                 secret_store_id: Optional[pulumi.Input[str]] = None,
                 subscription_id: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None):
        if keyvault_name is not None:
            pulumi.set(__self__, "keyvault_name", keyvault_name)
        if managed_identity_properties is not None:
            pulumi.set(__self__, "managed_identity_properties", managed_identity_properties)
        if resource_group is not None:
            pulumi.set(__self__, "resource_group", resource_group)
        if secret_store_id is not None:
            pulumi.set(__self__, "secret_store_id", secret_store_id)
        if subscription_id is not None:
            pulumi.set(__self__, "subscription_id", subscription_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="keyvaultName")
    def keyvault_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "keyvault_name")

    @keyvault_name.setter
    def keyvault_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "keyvault_name", value)

    @property
    @pulumi.getter(name="managedIdentityProperties")
    def managed_identity_properties(self) -> Optional[pulumi.Input['ManagedIdentityPropertiesArgs']]:
        return pulumi.get(self, "managed_identity_properties")

    @managed_identity_properties.setter
    def managed_identity_properties(self, value: Optional[pulumi.Input['ManagedIdentityPropertiesArgs']]):
        pulumi.set(self, "managed_identity_properties", value)

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "resource_group")

    @resource_group.setter
    def resource_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group", value)

    @property
    @pulumi.getter(name="secretStoreId")
    def secret_store_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "secret_store_id")

    @secret_store_id.setter
    def secret_store_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret_store_id", value)

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "subscription_id")

    @subscription_id.setter
    def subscription_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subscription_id", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)


@pulumi.input_type
class ManagedIdentityPropertiesArgs:
    def __init__(__self__, *,
                 client_id: Optional[pulumi.Input[str]] = None,
                 managed_identity_name: Optional[pulumi.Input[str]] = None,
                 principal_id: Optional[pulumi.Input[str]] = None,
                 resource_group: Optional[pulumi.Input[str]] = None,
                 subscription_id: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None):
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if managed_identity_name is not None:
            pulumi.set(__self__, "managed_identity_name", managed_identity_name)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if resource_group is not None:
            pulumi.set(__self__, "resource_group", resource_group)
        if subscription_id is not None:
            pulumi.set(__self__, "subscription_id", subscription_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="managedIdentityName")
    def managed_identity_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "managed_identity_name")

    @managed_identity_name.setter
    def managed_identity_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "managed_identity_name", value)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "principal_id", value)

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "resource_group")

    @resource_group.setter
    def resource_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group", value)

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "subscription_id")

    @subscription_id.setter
    def subscription_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subscription_id", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)


@pulumi.input_type
class MigrateAgentModelPropertiesArgs:
    def __init__(__self__, *,
                 authentication_identity: Optional[pulumi.Input['IdentityModelArgs']] = None,
                 custom_properties: Optional[pulumi.Input['VMwareMigrateAgentModelCustomPropertiesArgs']] = None,
                 machine_id: Optional[pulumi.Input[str]] = None,
                 machine_name: Optional[pulumi.Input[str]] = None):
        """
        MigrateAgent model properties.
        :param pulumi.Input['IdentityModelArgs'] authentication_identity: Identity model.
        :param pulumi.Input['VMwareMigrateAgentModelCustomPropertiesArgs'] custom_properties: MigrateAgent model custom properties.
        :param pulumi.Input[str] machine_id: Gets or sets the machine Id where MigrateAgent is running.
        :param pulumi.Input[str] machine_name: Gets or sets the machine name where MigrateAgent is running.
        """
        if authentication_identity is not None:
            pulumi.set(__self__, "authentication_identity", authentication_identity)
        if custom_properties is not None:
            pulumi.set(__self__, "custom_properties", custom_properties)
        if machine_id is not None:
            pulumi.set(__self__, "machine_id", machine_id)
        if machine_name is not None:
            pulumi.set(__self__, "machine_name", machine_name)

    @property
    @pulumi.getter(name="authenticationIdentity")
    def authentication_identity(self) -> Optional[pulumi.Input['IdentityModelArgs']]:
        """
        Identity model.
        """
        return pulumi.get(self, "authentication_identity")

    @authentication_identity.setter
    def authentication_identity(self, value: Optional[pulumi.Input['IdentityModelArgs']]):
        pulumi.set(self, "authentication_identity", value)

    @property
    @pulumi.getter(name="customProperties")
    def custom_properties(self) -> Optional[pulumi.Input['VMwareMigrateAgentModelCustomPropertiesArgs']]:
        """
        MigrateAgent model custom properties.
        """
        return pulumi.get(self, "custom_properties")

    @custom_properties.setter
    def custom_properties(self, value: Optional[pulumi.Input['VMwareMigrateAgentModelCustomPropertiesArgs']]):
        pulumi.set(self, "custom_properties", value)

    @property
    @pulumi.getter(name="machineId")
    def machine_id(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the machine Id where MigrateAgent is running.
        """
        return pulumi.get(self, "machine_id")

    @machine_id.setter
    def machine_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "machine_id", value)

    @property
    @pulumi.getter(name="machineName")
    def machine_name(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the machine name where MigrateAgent is running.
        """
        return pulumi.get(self, "machine_name")

    @machine_name.setter
    def machine_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "machine_name", value)


@pulumi.input_type
class MigrationConfigurationArgs:
    def __init__(__self__, *,
                 key_vault_resource_id: Optional[pulumi.Input[str]] = None,
                 migration_solution_resource_id: Optional[pulumi.Input[str]] = None,
                 storage_account_resource_id: Optional[pulumi.Input[str]] = None):
        """
        MigrationConfiguration properties.
        :param pulumi.Input[str] key_vault_resource_id: Gets or sets the key vault resource Id.
        :param pulumi.Input[str] migration_solution_resource_id: Gets or sets the migration solution resource Id.
        :param pulumi.Input[str] storage_account_resource_id: Gets or sets the storage account resource Id.
        """
        if key_vault_resource_id is not None:
            pulumi.set(__self__, "key_vault_resource_id", key_vault_resource_id)
        if migration_solution_resource_id is not None:
            pulumi.set(__self__, "migration_solution_resource_id", migration_solution_resource_id)
        if storage_account_resource_id is not None:
            pulumi.set(__self__, "storage_account_resource_id", storage_account_resource_id)

    @property
    @pulumi.getter(name="keyVaultResourceId")
    def key_vault_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the key vault resource Id.
        """
        return pulumi.get(self, "key_vault_resource_id")

    @key_vault_resource_id.setter
    def key_vault_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_vault_resource_id", value)

    @property
    @pulumi.getter(name="migrationSolutionResourceId")
    def migration_solution_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the migration solution resource Id.
        """
        return pulumi.get(self, "migration_solution_resource_id")

    @migration_solution_resource_id.setter
    def migration_solution_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "migration_solution_resource_id", value)

    @property
    @pulumi.getter(name="storageAccountResourceId")
    def storage_account_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the storage account resource Id.
        """
        return pulumi.get(self, "storage_account_resource_id")

    @storage_account_resource_id.setter
    def storage_account_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_account_resource_id", value)


@pulumi.input_type
class ModernizeProjectModelPropertiesArgs:
    def __init__(__self__, *,
                 migration_configuration: Optional[pulumi.Input['MigrationConfigurationArgs']] = None):
        """
        ModernizeProject properties.
        :param pulumi.Input['MigrationConfigurationArgs'] migration_configuration: MigrationConfiguration properties.
        """
        if migration_configuration is not None:
            pulumi.set(__self__, "migration_configuration", migration_configuration)

    @property
    @pulumi.getter(name="migrationConfiguration")
    def migration_configuration(self) -> Optional[pulumi.Input['MigrationConfigurationArgs']]:
        """
        MigrationConfiguration properties.
        """
        return pulumi.get(self, "migration_configuration")

    @migration_configuration.setter
    def migration_configuration(self, value: Optional[pulumi.Input['MigrationConfigurationArgs']]):
        pulumi.set(self, "migration_configuration", value)


@pulumi.input_type
class OperatingSystemDetailsArgs:
    def __init__(__self__, *,
                 os: Optional[pulumi.Input[Union[str, 'OperatingSystemType']]] = None,
                 os_architecture: Optional[pulumi.Input[str]] = None,
                 os_name: Optional[pulumi.Input[str]] = None,
                 os_version: Optional[pulumi.Input[str]] = None):
        if os is not None:
            pulumi.set(__self__, "os", os)
        if os_architecture is not None:
            pulumi.set(__self__, "os_architecture", os_architecture)
        if os_name is not None:
            pulumi.set(__self__, "os_name", os_name)
        if os_version is not None:
            pulumi.set(__self__, "os_version", os_version)

    @property
    @pulumi.getter
    def os(self) -> Optional[pulumi.Input[Union[str, 'OperatingSystemType']]]:
        return pulumi.get(self, "os")

    @os.setter
    def os(self, value: Optional[pulumi.Input[Union[str, 'OperatingSystemType']]]):
        pulumi.set(self, "os", value)

    @property
    @pulumi.getter(name="osArchitecture")
    def os_architecture(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "os_architecture")

    @os_architecture.setter
    def os_architecture(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "os_architecture", value)

    @property
    @pulumi.getter(name="osName")
    def os_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "os_name")

    @os_name.setter
    def os_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "os_name", value)

    @property
    @pulumi.getter(name="osVersion")
    def os_version(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "os_version")

    @os_version.setter
    def os_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "os_version", value)


@pulumi.input_type
class PortMappingArgs:
    def __init__(__self__, *,
                 external_port: Optional[pulumi.Input[int]] = None,
                 internal_port: Optional[pulumi.Input[int]] = None):
        """
        WebApplication port mapping.
        :param pulumi.Input[int] external_port: Gets or sets the External Port.
        :param pulumi.Input[int] internal_port: Gets or sets the Internal Port.
        """
        if external_port is not None:
            pulumi.set(__self__, "external_port", external_port)
        if internal_port is not None:
            pulumi.set(__self__, "internal_port", internal_port)

    @property
    @pulumi.getter(name="externalPort")
    def external_port(self) -> Optional[pulumi.Input[int]]:
        """
        Gets or sets the External Port.
        """
        return pulumi.get(self, "external_port")

    @external_port.setter
    def external_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "external_port", value)

    @property
    @pulumi.getter(name="internalPort")
    def internal_port(self) -> Optional[pulumi.Input[int]]:
        """
        Gets or sets the Internal Port.
        """
        return pulumi.get(self, "internal_port")

    @internal_port.setter
    def internal_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "internal_port", value)


@pulumi.input_type
class ResourceIdentityArgs:
    def __init__(__self__, *,
                 principal_id: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[Union[str, 'ResourceIdentityTypes']]] = None,
                 user_assigned_identities: Optional[pulumi.Input[Mapping[str, pulumi.Input['UserAssignedIdentityArgs']]]] = None):
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_assigned_identities is not None:
            pulumi.set(__self__, "user_assigned_identities", user_assigned_identities)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "principal_id", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[Union[str, 'ResourceIdentityTypes']]]:
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[Union[str, 'ResourceIdentityTypes']]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="userAssignedIdentities")
    def user_assigned_identities(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['UserAssignedIdentityArgs']]]]:
        return pulumi.get(self, "user_assigned_identities")

    @user_assigned_identities.setter
    def user_assigned_identities(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['UserAssignedIdentityArgs']]]]):
        pulumi.set(self, "user_assigned_identities", value)


@pulumi.input_type
class ResourceRequirementsArgs:
    def __init__(__self__, *,
                 cpu: Optional[pulumi.Input[str]] = None,
                 memory: Optional[pulumi.Input[str]] = None):
        """
        Resource Requirements.
        :param pulumi.Input[str] cpu: Gets or sets the Cpu requirement.
        :param pulumi.Input[str] memory: Gets or sets the Memory requirement.
        """
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if memory is not None:
            pulumi.set(__self__, "memory", memory)

    @property
    @pulumi.getter
    def cpu(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the Cpu requirement.
        """
        return pulumi.get(self, "cpu")

    @cpu.setter
    def cpu(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cpu", value)

    @property
    @pulumi.getter
    def memory(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the Memory requirement.
        """
        return pulumi.get(self, "memory")

    @memory.setter
    def memory(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "memory", value)


@pulumi.input_type
class SecretStoreDetailsArgs:
    def __init__(__self__, *,
                 secret_store: Optional[pulumi.Input[Union[str, 'SecretStoreType']]] = None,
                 secret_store_properties: Optional[pulumi.Input['SecretStorePropertiesArgs']] = None):
        if secret_store is not None:
            pulumi.set(__self__, "secret_store", secret_store)
        if secret_store_properties is not None:
            pulumi.set(__self__, "secret_store_properties", secret_store_properties)

    @property
    @pulumi.getter(name="secretStore")
    def secret_store(self) -> Optional[pulumi.Input[Union[str, 'SecretStoreType']]]:
        return pulumi.get(self, "secret_store")

    @secret_store.setter
    def secret_store(self, value: Optional[pulumi.Input[Union[str, 'SecretStoreType']]]):
        pulumi.set(self, "secret_store", value)

    @property
    @pulumi.getter(name="secretStoreProperties")
    def secret_store_properties(self) -> Optional[pulumi.Input['SecretStorePropertiesArgs']]:
        return pulumi.get(self, "secret_store_properties")

    @secret_store_properties.setter
    def secret_store_properties(self, value: Optional[pulumi.Input['SecretStorePropertiesArgs']]):
        pulumi.set(self, "secret_store_properties", value)


@pulumi.input_type
class SecretStorePropertiesArgs:
    def __init__(__self__, *,
                 secret_store_id: Optional[pulumi.Input[str]] = None):
        if secret_store_id is not None:
            pulumi.set(__self__, "secret_store_id", secret_store_id)

    @property
    @pulumi.getter(name="secretStoreId")
    def secret_store_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "secret_store_id")

    @secret_store_id.setter
    def secret_store_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret_store_id", value)


@pulumi.input_type
class TargetStorageProfileArgs:
    def __init__(__self__, *,
                 azure_file_share_profile: Optional[pulumi.Input['AzureFileShareHydrationProfileArgs']] = None,
                 hydration_storage_provider_type: Optional[pulumi.Input[Union[str, 'TargetHydrationStorageProviderType']]] = None,
                 persistent_volume_id: Optional[pulumi.Input[str]] = None,
                 storage_access_type: Optional[pulumi.Input[Union[str, 'TargetStorageAccessType']]] = None,
                 storage_projection_type: Optional[pulumi.Input[Union[str, 'TargetStorageProjectionType']]] = None,
                 target_name: Optional[pulumi.Input[str]] = None,
                 target_size: Optional[pulumi.Input[str]] = None):
        """
        Storage profile for the directory on the target container.
        :param pulumi.Input['AzureFileShareHydrationProfileArgs'] azure_file_share_profile: Azure file share profile for hydration of application folders not mounted on
               the container file system.
        :param pulumi.Input[Union[str, 'TargetHydrationStorageProviderType']] hydration_storage_provider_type: Gets or sets the storage provider type on the target.
               Applicable when StorageProjectionType is not ContainerFileSystem.
        :param pulumi.Input[str] persistent_volume_id: Gets or sets the target persistent volume id.
               Applicable when StorageProjectionType is PersistentVolume and on using an
               existing PersistentVolume.
        :param pulumi.Input[Union[str, 'TargetStorageAccessType']] storage_access_type: Gets or sets the target storage access type.
        :param pulumi.Input[Union[str, 'TargetStorageProjectionType']] storage_projection_type: Gets or sets the target projection type.
        :param pulumi.Input[str] target_name: Gets or sets the name of the projected volume on the target environment.
        :param pulumi.Input[str] target_size: Gets or sets the storage size on the target.
               Applicable when StorageProjectionType is PersistentVolume and on creating a new
               PersistentVolume.
        """
        if azure_file_share_profile is not None:
            pulumi.set(__self__, "azure_file_share_profile", azure_file_share_profile)
        if hydration_storage_provider_type is not None:
            pulumi.set(__self__, "hydration_storage_provider_type", hydration_storage_provider_type)
        if persistent_volume_id is not None:
            pulumi.set(__self__, "persistent_volume_id", persistent_volume_id)
        if storage_access_type is not None:
            pulumi.set(__self__, "storage_access_type", storage_access_type)
        if storage_projection_type is not None:
            pulumi.set(__self__, "storage_projection_type", storage_projection_type)
        if target_name is not None:
            pulumi.set(__self__, "target_name", target_name)
        if target_size is not None:
            pulumi.set(__self__, "target_size", target_size)

    @property
    @pulumi.getter(name="azureFileShareProfile")
    def azure_file_share_profile(self) -> Optional[pulumi.Input['AzureFileShareHydrationProfileArgs']]:
        """
        Azure file share profile for hydration of application folders not mounted on
        the container file system.
        """
        return pulumi.get(self, "azure_file_share_profile")

    @azure_file_share_profile.setter
    def azure_file_share_profile(self, value: Optional[pulumi.Input['AzureFileShareHydrationProfileArgs']]):
        pulumi.set(self, "azure_file_share_profile", value)

    @property
    @pulumi.getter(name="hydrationStorageProviderType")
    def hydration_storage_provider_type(self) -> Optional[pulumi.Input[Union[str, 'TargetHydrationStorageProviderType']]]:
        """
        Gets or sets the storage provider type on the target.
        Applicable when StorageProjectionType is not ContainerFileSystem.
        """
        return pulumi.get(self, "hydration_storage_provider_type")

    @hydration_storage_provider_type.setter
    def hydration_storage_provider_type(self, value: Optional[pulumi.Input[Union[str, 'TargetHydrationStorageProviderType']]]):
        pulumi.set(self, "hydration_storage_provider_type", value)

    @property
    @pulumi.getter(name="persistentVolumeId")
    def persistent_volume_id(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the target persistent volume id.
        Applicable when StorageProjectionType is PersistentVolume and on using an
        existing PersistentVolume.
        """
        return pulumi.get(self, "persistent_volume_id")

    @persistent_volume_id.setter
    def persistent_volume_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "persistent_volume_id", value)

    @property
    @pulumi.getter(name="storageAccessType")
    def storage_access_type(self) -> Optional[pulumi.Input[Union[str, 'TargetStorageAccessType']]]:
        """
        Gets or sets the target storage access type.
        """
        return pulumi.get(self, "storage_access_type")

    @storage_access_type.setter
    def storage_access_type(self, value: Optional[pulumi.Input[Union[str, 'TargetStorageAccessType']]]):
        pulumi.set(self, "storage_access_type", value)

    @property
    @pulumi.getter(name="storageProjectionType")
    def storage_projection_type(self) -> Optional[pulumi.Input[Union[str, 'TargetStorageProjectionType']]]:
        """
        Gets or sets the target projection type.
        """
        return pulumi.get(self, "storage_projection_type")

    @storage_projection_type.setter
    def storage_projection_type(self, value: Optional[pulumi.Input[Union[str, 'TargetStorageProjectionType']]]):
        pulumi.set(self, "storage_projection_type", value)

    @property
    @pulumi.getter(name="targetName")
    def target_name(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the name of the projected volume on the target environment.
        """
        return pulumi.get(self, "target_name")

    @target_name.setter
    def target_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_name", value)

    @property
    @pulumi.getter(name="targetSize")
    def target_size(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the storage size on the target.
        Applicable when StorageProjectionType is PersistentVolume and on creating a new
        PersistentVolume.
        """
        return pulumi.get(self, "target_size")

    @target_size.setter
    def target_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_size", value)


@pulumi.input_type
class UserAssignedIdentityArgs:
    def __init__(__self__, *,
                 client_id: Optional[pulumi.Input[str]] = None,
                 principal_id: Optional[pulumi.Input[str]] = None):
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "principal_id", value)


@pulumi.input_type
class VMwareMigrateAgentModelCustomPropertiesArgs:
    def __init__(__self__, *,
                 instance_type: pulumi.Input[str],
                 fabric_friendly_name: Optional[pulumi.Input[str]] = None,
                 vmware_site_id: Optional[pulumi.Input[str]] = None):
        """
        VMware MigrateAgent model custom properties.
        :param pulumi.Input[str] instance_type: Gets or sets the instance type.
               Expected value is 'VMwareMigrateAgentModelCustomProperties'.
        :param pulumi.Input[str] fabric_friendly_name: Gets or sets the friendly name of the,of the MigrateAgent fabric.
        :param pulumi.Input[str] vmware_site_id: Gets or sets the master Site Id of the Migrate Agent.
        """
        pulumi.set(__self__, "instance_type", 'VMwareMigrateAgentModelCustomProperties')
        if fabric_friendly_name is not None:
            pulumi.set(__self__, "fabric_friendly_name", fabric_friendly_name)
        if vmware_site_id is not None:
            pulumi.set(__self__, "vmware_site_id", vmware_site_id)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Input[str]:
        """
        Gets or sets the instance type.
        Expected value is 'VMwareMigrateAgentModelCustomProperties'.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="fabricFriendlyName")
    def fabric_friendly_name(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the friendly name of the,of the MigrateAgent fabric.
        """
        return pulumi.get(self, "fabric_friendly_name")

    @fabric_friendly_name.setter
    def fabric_friendly_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fabric_friendly_name", value)

    @property
    @pulumi.getter(name="vmwareSiteId")
    def vmware_site_id(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the master Site Id of the Migrate Agent.
        """
        return pulumi.get(self, "vmware_site_id")

    @vmware_site_id.setter
    def vmware_site_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vmware_site_id", value)


@pulumi.input_type
class WebApplicationConfigurationArgs:
    def __init__(__self__, *,
                 file_path: Optional[pulumi.Input[str]] = None,
                 identifier: Optional[pulumi.Input[str]] = None,
                 is_deployment_time_editable: Optional[pulumi.Input[bool]] = None,
                 local_file_path: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 secret_store_details: Optional[pulumi.Input['SecretStoreDetailsArgs']] = None,
                 section: Optional[pulumi.Input[str]] = None,
                 target_file_path: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[Union[str, 'ConfigurationType']]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        Class for web application configurations.
        :param pulumi.Input[str] file_path: Gets or sets the configuration file path.
        :param pulumi.Input[str] identifier: Gets or sets the identifier for the configuration.
        :param pulumi.Input[bool] is_deployment_time_editable: Gets or sets a value indicating whether the configuration is edited or not by the user.
        :param pulumi.Input[str] local_file_path: Gets or sets the configuration local file path.
        :param pulumi.Input[str] name: Gets or sets the configuration name.
        :param pulumi.Input[str] section: Gets or sets the configuration section in the file.
        :param pulumi.Input[str] target_file_path: Gets or sets the configuration target file path.
        :param pulumi.Input[Union[str, 'ConfigurationType']] type: Gets or sets the configuration type.
        :param pulumi.Input[str] value: Gets or sets the configuration value.
        """
        if file_path is not None:
            pulumi.set(__self__, "file_path", file_path)
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)
        if is_deployment_time_editable is not None:
            pulumi.set(__self__, "is_deployment_time_editable", is_deployment_time_editable)
        if local_file_path is not None:
            pulumi.set(__self__, "local_file_path", local_file_path)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if secret_store_details is not None:
            pulumi.set(__self__, "secret_store_details", secret_store_details)
        if section is not None:
            pulumi.set(__self__, "section", section)
        if target_file_path is not None:
            pulumi.set(__self__, "target_file_path", target_file_path)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="filePath")
    def file_path(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the configuration file path.
        """
        return pulumi.get(self, "file_path")

    @file_path.setter
    def file_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "file_path", value)

    @property
    @pulumi.getter
    def identifier(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the identifier for the configuration.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "identifier", value)

    @property
    @pulumi.getter(name="isDeploymentTimeEditable")
    def is_deployment_time_editable(self) -> Optional[pulumi.Input[bool]]:
        """
        Gets or sets a value indicating whether the configuration is edited or not by the user.
        """
        return pulumi.get(self, "is_deployment_time_editable")

    @is_deployment_time_editable.setter
    def is_deployment_time_editable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_deployment_time_editable", value)

    @property
    @pulumi.getter(name="localFilePath")
    def local_file_path(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the configuration local file path.
        """
        return pulumi.get(self, "local_file_path")

    @local_file_path.setter
    def local_file_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "local_file_path", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the configuration name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="secretStoreDetails")
    def secret_store_details(self) -> Optional[pulumi.Input['SecretStoreDetailsArgs']]:
        return pulumi.get(self, "secret_store_details")

    @secret_store_details.setter
    def secret_store_details(self, value: Optional[pulumi.Input['SecretStoreDetailsArgs']]):
        pulumi.set(self, "secret_store_details", value)

    @property
    @pulumi.getter
    def section(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the configuration section in the file.
        """
        return pulumi.get(self, "section")

    @section.setter
    def section(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "section", value)

    @property
    @pulumi.getter(name="targetFilePath")
    def target_file_path(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the configuration target file path.
        """
        return pulumi.get(self, "target_file_path")

    @target_file_path.setter
    def target_file_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_file_path", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[Union[str, 'ConfigurationType']]]:
        """
        Gets or sets the configuration type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[Union[str, 'ConfigurationType']]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the configuration value.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class WebApplicationDirectoryArgs:
    def __init__(__self__, *,
                 is_editable: Optional[pulumi.Input[bool]] = None,
                 source_paths: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 source_size: Optional[pulumi.Input[str]] = None,
                 storage_profile: Optional[pulumi.Input['TargetStorageProfileArgs']] = None):
        """
        WebApplication directory structure.
        :param pulumi.Input[bool] is_editable: Gets or sets a value indicating whether the directory object is editable.
               True when the directory is added as an optional directory, false when discovery is done
               manually.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] source_paths: Gets or sets the paths of the directory on the source machine.
        :param pulumi.Input[str] source_size: Gets or sets the size of the directory on the source machine.
        :param pulumi.Input['TargetStorageProfileArgs'] storage_profile: Storage profile for the directory on the target container.
        """
        if is_editable is not None:
            pulumi.set(__self__, "is_editable", is_editable)
        if source_paths is not None:
            pulumi.set(__self__, "source_paths", source_paths)
        if source_size is not None:
            pulumi.set(__self__, "source_size", source_size)
        if storage_profile is not None:
            pulumi.set(__self__, "storage_profile", storage_profile)

    @property
    @pulumi.getter(name="isEditable")
    def is_editable(self) -> Optional[pulumi.Input[bool]]:
        """
        Gets or sets a value indicating whether the directory object is editable.
        True when the directory is added as an optional directory, false when discovery is done
        manually.
        """
        return pulumi.get(self, "is_editable")

    @is_editable.setter
    def is_editable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_editable", value)

    @property
    @pulumi.getter(name="sourcePaths")
    def source_paths(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Gets or sets the paths of the directory on the source machine.
        """
        return pulumi.get(self, "source_paths")

    @source_paths.setter
    def source_paths(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "source_paths", value)

    @property
    @pulumi.getter(name="sourceSize")
    def source_size(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the size of the directory on the source machine.
        """
        return pulumi.get(self, "source_size")

    @source_size.setter
    def source_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_size", value)

    @property
    @pulumi.getter(name="storageProfile")
    def storage_profile(self) -> Optional[pulumi.Input['TargetStorageProfileArgs']]:
        """
        Storage profile for the directory on the target container.
        """
        return pulumi.get(self, "storage_profile")

    @storage_profile.setter
    def storage_profile(self, value: Optional[pulumi.Input['TargetStorageProfileArgs']]):
        pulumi.set(self, "storage_profile", value)


@pulumi.input_type
class WebApplicationFrameworkArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        Framework specific data for a web application.
        :param pulumi.Input[str] name: Gets or sets Name of the framework.
        :param pulumi.Input[str] version: Gets or sets Version of the framework.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets Name of the framework.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets Version of the framework.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class WorkloadDeploymentModelPropertiesArgs:
    def __init__(__self__, *,
                 custom_properties: Optional[pulumi.Input[Union['ApacheTomcatAKSWorkloadDeploymentModelCustomPropertiesArgs', 'IISAKSWorkloadDeploymentModelCustomPropertiesArgs']]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 target_platform: Optional[pulumi.Input[Union[str, 'WorkloadDeploymentTarget']]] = None,
                 workload_instance_properties: Optional[pulumi.Input['WorkloadInstanceModelPropertiesArgs']] = None):
        """
        Workload deployment model properties.
        :param pulumi.Input[Union['ApacheTomcatAKSWorkloadDeploymentModelCustomPropertiesArgs', 'IISAKSWorkloadDeploymentModelCustomPropertiesArgs']] custom_properties: Workload deployment model custom properties.
        :param pulumi.Input[str] display_name: Gets or sets the display name.
        :param pulumi.Input[Union[str, 'WorkloadDeploymentTarget']] target_platform: Gets or sets the deployment target platform.
        :param pulumi.Input['WorkloadInstanceModelPropertiesArgs'] workload_instance_properties: Workload instance model properties.
        """
        if custom_properties is not None:
            pulumi.set(__self__, "custom_properties", custom_properties)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if target_platform is not None:
            pulumi.set(__self__, "target_platform", target_platform)
        if workload_instance_properties is not None:
            pulumi.set(__self__, "workload_instance_properties", workload_instance_properties)

    @property
    @pulumi.getter(name="customProperties")
    def custom_properties(self) -> Optional[pulumi.Input[Union['ApacheTomcatAKSWorkloadDeploymentModelCustomPropertiesArgs', 'IISAKSWorkloadDeploymentModelCustomPropertiesArgs']]]:
        """
        Workload deployment model custom properties.
        """
        return pulumi.get(self, "custom_properties")

    @custom_properties.setter
    def custom_properties(self, value: Optional[pulumi.Input[Union['ApacheTomcatAKSWorkloadDeploymentModelCustomPropertiesArgs', 'IISAKSWorkloadDeploymentModelCustomPropertiesArgs']]]):
        pulumi.set(self, "custom_properties", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the display name.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="targetPlatform")
    def target_platform(self) -> Optional[pulumi.Input[Union[str, 'WorkloadDeploymentTarget']]]:
        """
        Gets or sets the deployment target platform.
        """
        return pulumi.get(self, "target_platform")

    @target_platform.setter
    def target_platform(self, value: Optional[pulumi.Input[Union[str, 'WorkloadDeploymentTarget']]]):
        pulumi.set(self, "target_platform", value)

    @property
    @pulumi.getter(name="workloadInstanceProperties")
    def workload_instance_properties(self) -> Optional[pulumi.Input['WorkloadInstanceModelPropertiesArgs']]:
        """
        Workload instance model properties.
        """
        return pulumi.get(self, "workload_instance_properties")

    @workload_instance_properties.setter
    def workload_instance_properties(self, value: Optional[pulumi.Input['WorkloadInstanceModelPropertiesArgs']]):
        pulumi.set(self, "workload_instance_properties", value)


@pulumi.input_type
class WorkloadInstanceModelPropertiesArgs:
    def __init__(__self__, *,
                 custom_properties: Optional[pulumi.Input[Union['ApacheTomcatWorkloadInstanceModelCustomPropertiesArgs', 'IISWorkloadInstanceModelCustomPropertiesArgs']]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 master_site_name: Optional[pulumi.Input[str]] = None,
                 migrate_agent_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 source_name: Optional[pulumi.Input[str]] = None,
                 source_platform: Optional[pulumi.Input[str]] = None):
        """
        Workload instance model properties.
        :param pulumi.Input[Union['ApacheTomcatWorkloadInstanceModelCustomPropertiesArgs', 'IISWorkloadInstanceModelCustomPropertiesArgs']] custom_properties: Workload instance model custom properties.
        :param pulumi.Input[str] display_name: Gets or sets the display name.
        :param pulumi.Input[str] master_site_name: Gets or Sets the master site name.
        :param pulumi.Input[str] migrate_agent_id: Gets or sets the migrate agent id associated with the workload instance.
        :param pulumi.Input[str] name: Gets or sets the workload instance name.
        :param pulumi.Input[str] source_name: Gets or sets the source name.
        :param pulumi.Input[str] source_platform: Gets or sets the source platform.
        """
        if custom_properties is not None:
            pulumi.set(__self__, "custom_properties", custom_properties)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if master_site_name is not None:
            pulumi.set(__self__, "master_site_name", master_site_name)
        if migrate_agent_id is not None:
            pulumi.set(__self__, "migrate_agent_id", migrate_agent_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if source_name is not None:
            pulumi.set(__self__, "source_name", source_name)
        if source_platform is not None:
            pulumi.set(__self__, "source_platform", source_platform)

    @property
    @pulumi.getter(name="customProperties")
    def custom_properties(self) -> Optional[pulumi.Input[Union['ApacheTomcatWorkloadInstanceModelCustomPropertiesArgs', 'IISWorkloadInstanceModelCustomPropertiesArgs']]]:
        """
        Workload instance model custom properties.
        """
        return pulumi.get(self, "custom_properties")

    @custom_properties.setter
    def custom_properties(self, value: Optional[pulumi.Input[Union['ApacheTomcatWorkloadInstanceModelCustomPropertiesArgs', 'IISWorkloadInstanceModelCustomPropertiesArgs']]]):
        pulumi.set(self, "custom_properties", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the display name.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="masterSiteName")
    def master_site_name(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or Sets the master site name.
        """
        return pulumi.get(self, "master_site_name")

    @master_site_name.setter
    def master_site_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "master_site_name", value)

    @property
    @pulumi.getter(name="migrateAgentId")
    def migrate_agent_id(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the migrate agent id associated with the workload instance.
        """
        return pulumi.get(self, "migrate_agent_id")

    @migrate_agent_id.setter
    def migrate_agent_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "migrate_agent_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the workload instance name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="sourceName")
    def source_name(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the source name.
        """
        return pulumi.get(self, "source_name")

    @source_name.setter
    def source_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_name", value)

    @property
    @pulumi.getter(name="sourcePlatform")
    def source_platform(self) -> Optional[pulumi.Input[str]]:
        """
        Gets or sets the source platform.
        """
        return pulumi.get(self, "source_platform")

    @source_platform.setter
    def source_platform(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_platform", value)


