# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'ClusterPropertiesResponseCustomerManagedKeyEncryption',
    'ClusterPropertiesResponseEncryption',
    'ClusterPropertiesResponseKeyEncryptionKeyIdentity',
    'DatabasePropertiesResponseGeoReplication',
    'EnterpriseSkuResponse',
    'LinkedDatabaseResponse',
    'ManagedServiceIdentityResponse',
    'ModuleResponse',
    'PersistenceResponse',
    'PrivateEndpointConnectionResponse',
    'PrivateEndpointResponse',
    'PrivateLinkServiceConnectionStateResponse',
    'SystemDataResponse',
    'UserAssignedIdentityResponse',
]

@pulumi.output_type
class ClusterPropertiesResponseCustomerManagedKeyEncryption(dict):
    """
    All Customer-managed key encryption properties for the resource. Set this to an empty object to use Microsoft-managed key encryption.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyEncryptionKeyIdentity":
            suggest = "key_encryption_key_identity"
        elif key == "keyEncryptionKeyUrl":
            suggest = "key_encryption_key_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterPropertiesResponseCustomerManagedKeyEncryption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterPropertiesResponseCustomerManagedKeyEncryption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterPropertiesResponseCustomerManagedKeyEncryption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_encryption_key_identity: Optional['outputs.ClusterPropertiesResponseKeyEncryptionKeyIdentity'] = None,
                 key_encryption_key_url: Optional[str] = None):
        """
        All Customer-managed key encryption properties for the resource. Set this to an empty object to use Microsoft-managed key encryption.
        :param 'ClusterPropertiesResponseKeyEncryptionKeyIdentity' key_encryption_key_identity: All identity configuration for Customer-managed key settings defining which identity should be used to auth to Key Vault.
        :param str key_encryption_key_url: Key encryption key Url, versioned only. Ex: https://contosovault.vault.azure.net/keys/contosokek/562a4bb76b524a1493a6afe8e536ee78
        """
        if key_encryption_key_identity is not None:
            pulumi.set(__self__, "key_encryption_key_identity", key_encryption_key_identity)
        if key_encryption_key_url is not None:
            pulumi.set(__self__, "key_encryption_key_url", key_encryption_key_url)

    @property
    @pulumi.getter(name="keyEncryptionKeyIdentity")
    def key_encryption_key_identity(self) -> Optional['outputs.ClusterPropertiesResponseKeyEncryptionKeyIdentity']:
        """
        All identity configuration for Customer-managed key settings defining which identity should be used to auth to Key Vault.
        """
        return pulumi.get(self, "key_encryption_key_identity")

    @property
    @pulumi.getter(name="keyEncryptionKeyUrl")
    def key_encryption_key_url(self) -> Optional[str]:
        """
        Key encryption key Url, versioned only. Ex: https://contosovault.vault.azure.net/keys/contosokek/562a4bb76b524a1493a6afe8e536ee78
        """
        return pulumi.get(self, "key_encryption_key_url")


@pulumi.output_type
class ClusterPropertiesResponseEncryption(dict):
    """
    Encryption-at-rest configuration for the cluster.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customerManagedKeyEncryption":
            suggest = "customer_managed_key_encryption"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterPropertiesResponseEncryption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterPropertiesResponseEncryption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterPropertiesResponseEncryption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 customer_managed_key_encryption: Optional['outputs.ClusterPropertiesResponseCustomerManagedKeyEncryption'] = None):
        """
        Encryption-at-rest configuration for the cluster.
        :param 'ClusterPropertiesResponseCustomerManagedKeyEncryption' customer_managed_key_encryption: All Customer-managed key encryption properties for the resource. Set this to an empty object to use Microsoft-managed key encryption.
        """
        if customer_managed_key_encryption is not None:
            pulumi.set(__self__, "customer_managed_key_encryption", customer_managed_key_encryption)

    @property
    @pulumi.getter(name="customerManagedKeyEncryption")
    def customer_managed_key_encryption(self) -> Optional['outputs.ClusterPropertiesResponseCustomerManagedKeyEncryption']:
        """
        All Customer-managed key encryption properties for the resource. Set this to an empty object to use Microsoft-managed key encryption.
        """
        return pulumi.get(self, "customer_managed_key_encryption")


@pulumi.output_type
class ClusterPropertiesResponseKeyEncryptionKeyIdentity(dict):
    """
    All identity configuration for Customer-managed key settings defining which identity should be used to auth to Key Vault.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "identityType":
            suggest = "identity_type"
        elif key == "userAssignedIdentityResourceId":
            suggest = "user_assigned_identity_resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterPropertiesResponseKeyEncryptionKeyIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterPropertiesResponseKeyEncryptionKeyIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterPropertiesResponseKeyEncryptionKeyIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 identity_type: Optional[str] = None,
                 user_assigned_identity_resource_id: Optional[str] = None):
        """
        All identity configuration for Customer-managed key settings defining which identity should be used to auth to Key Vault.
        :param str identity_type: Only userAssignedIdentity is supported in this API version; other types may be supported in the future
        :param str user_assigned_identity_resource_id: User assigned identity to use for accessing key encryption key Url. Ex: /subscriptions/<sub uuid>/resourceGroups/<resource group>/providers/Microsoft.ManagedIdentity/userAssignedIdentities/myId.
        """
        if identity_type is not None:
            pulumi.set(__self__, "identity_type", identity_type)
        if user_assigned_identity_resource_id is not None:
            pulumi.set(__self__, "user_assigned_identity_resource_id", user_assigned_identity_resource_id)

    @property
    @pulumi.getter(name="identityType")
    def identity_type(self) -> Optional[str]:
        """
        Only userAssignedIdentity is supported in this API version; other types may be supported in the future
        """
        return pulumi.get(self, "identity_type")

    @property
    @pulumi.getter(name="userAssignedIdentityResourceId")
    def user_assigned_identity_resource_id(self) -> Optional[str]:
        """
        User assigned identity to use for accessing key encryption key Url. Ex: /subscriptions/<sub uuid>/resourceGroups/<resource group>/providers/Microsoft.ManagedIdentity/userAssignedIdentities/myId.
        """
        return pulumi.get(self, "user_assigned_identity_resource_id")


@pulumi.output_type
class DatabasePropertiesResponseGeoReplication(dict):
    """
    Optional set of properties to configure geo replication for this database.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "groupNickname":
            suggest = "group_nickname"
        elif key == "linkedDatabases":
            suggest = "linked_databases"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabasePropertiesResponseGeoReplication. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabasePropertiesResponseGeoReplication.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabasePropertiesResponseGeoReplication.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 group_nickname: Optional[str] = None,
                 linked_databases: Optional[Sequence['outputs.LinkedDatabaseResponse']] = None):
        """
        Optional set of properties to configure geo replication for this database.
        :param str group_nickname: Name for the group of linked database resources
        :param Sequence['LinkedDatabaseResponse'] linked_databases: List of database resources to link with this database
        """
        if group_nickname is not None:
            pulumi.set(__self__, "group_nickname", group_nickname)
        if linked_databases is not None:
            pulumi.set(__self__, "linked_databases", linked_databases)

    @property
    @pulumi.getter(name="groupNickname")
    def group_nickname(self) -> Optional[str]:
        """
        Name for the group of linked database resources
        """
        return pulumi.get(self, "group_nickname")

    @property
    @pulumi.getter(name="linkedDatabases")
    def linked_databases(self) -> Optional[Sequence['outputs.LinkedDatabaseResponse']]:
        """
        List of database resources to link with this database
        """
        return pulumi.get(self, "linked_databases")


@pulumi.output_type
class EnterpriseSkuResponse(dict):
    """
    SKU parameters supplied to the create RedisEnterprise operation.
    """
    def __init__(__self__, *,
                 name: str,
                 capacity: Optional[int] = None):
        """
        SKU parameters supplied to the create RedisEnterprise operation.
        :param str name: The type of RedisEnterprise cluster to deploy. Possible values: (Enterprise_E10, EnterpriseFlash_F300 etc.)
        :param int capacity: The size of the RedisEnterprise cluster. Defaults to 2 or 3 depending on SKU. Valid values are (2, 4, 6, ...) for Enterprise SKUs and (3, 9, 15, ...) for Flash SKUs.
        """
        pulumi.set(__self__, "name", name)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The type of RedisEnterprise cluster to deploy. Possible values: (Enterprise_E10, EnterpriseFlash_F300 etc.)
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def capacity(self) -> Optional[int]:
        """
        The size of the RedisEnterprise cluster. Defaults to 2 or 3 depending on SKU. Valid values are (2, 4, 6, ...) for Enterprise SKUs and (3, 9, 15, ...) for Flash SKUs.
        """
        return pulumi.get(self, "capacity")


@pulumi.output_type
class LinkedDatabaseResponse(dict):
    """
    Specifies details of a linked database resource.
    """
    def __init__(__self__, *,
                 state: str,
                 id: Optional[str] = None):
        """
        Specifies details of a linked database resource.
        :param str state: State of the link between the database resources.
        :param str id: Resource ID of a database resource to link with this database.
        """
        pulumi.set(__self__, "state", state)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        State of the link between the database resources.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Resource ID of a database resource to link with this database.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class ManagedServiceIdentityResponse(dict):
    """
    Managed service identity (system assigned and/or user assigned identities)
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"
        elif key == "userAssignedIdentities":
            suggest = "user_assigned_identities"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedServiceIdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedServiceIdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedServiceIdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 principal_id: str,
                 tenant_id: str,
                 type: str,
                 user_assigned_identities: Optional[Mapping[str, 'outputs.UserAssignedIdentityResponse']] = None):
        """
        Managed service identity (system assigned and/or user assigned identities)
        :param str principal_id: The service principal ID of the system assigned identity. This property will only be provided for a system assigned identity.
        :param str tenant_id: The tenant ID of the system assigned identity. This property will only be provided for a system assigned identity.
        :param str type: Type of managed service identity (where both SystemAssigned and UserAssigned types are allowed).
        :param Mapping[str, 'UserAssignedIdentityResponse'] user_assigned_identities: The set of user assigned identities associated with the resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}. The dictionary values can be empty objects ({}) in requests.
        """
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        pulumi.set(__self__, "type", type)
        if user_assigned_identities is not None:
            pulumi.set(__self__, "user_assigned_identities", user_assigned_identities)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        The service principal ID of the system assigned identity. This property will only be provided for a system assigned identity.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        The tenant ID of the system assigned identity. This property will only be provided for a system assigned identity.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of managed service identity (where both SystemAssigned and UserAssigned types are allowed).
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="userAssignedIdentities")
    def user_assigned_identities(self) -> Optional[Mapping[str, 'outputs.UserAssignedIdentityResponse']]:
        """
        The set of user assigned identities associated with the resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}. The dictionary values can be empty objects ({}) in requests.
        """
        return pulumi.get(self, "user_assigned_identities")


@pulumi.output_type
class ModuleResponse(dict):
    """
    Specifies configuration of a redis module
    """
    def __init__(__self__, *,
                 name: str,
                 version: str,
                 args: Optional[str] = None):
        """
        Specifies configuration of a redis module
        :param str name: The name of the module, e.g. 'RedisBloom', 'RediSearch', 'RedisTimeSeries'
        :param str version: The version of the module, e.g. '1.0'.
        :param str args: Configuration options for the module, e.g. 'ERROR_RATE 0.01 INITIAL_SIZE 400'.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "version", version)
        if args is not None:
            pulumi.set(__self__, "args", args)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the module, e.g. 'RedisBloom', 'RediSearch', 'RedisTimeSeries'
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        The version of the module, e.g. '1.0'.
        """
        return pulumi.get(self, "version")

    @property
    @pulumi.getter
    def args(self) -> Optional[str]:
        """
        Configuration options for the module, e.g. 'ERROR_RATE 0.01 INITIAL_SIZE 400'.
        """
        return pulumi.get(self, "args")


@pulumi.output_type
class PersistenceResponse(dict):
    """
    Persistence-related configuration for the RedisEnterprise database
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "aofEnabled":
            suggest = "aof_enabled"
        elif key == "aofFrequency":
            suggest = "aof_frequency"
        elif key == "rdbEnabled":
            suggest = "rdb_enabled"
        elif key == "rdbFrequency":
            suggest = "rdb_frequency"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PersistenceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PersistenceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PersistenceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 aof_enabled: Optional[bool] = None,
                 aof_frequency: Optional[str] = None,
                 rdb_enabled: Optional[bool] = None,
                 rdb_frequency: Optional[str] = None):
        """
        Persistence-related configuration for the RedisEnterprise database
        :param bool aof_enabled: Sets whether AOF is enabled.
        :param str aof_frequency: Sets the frequency at which data is written to disk.
        :param bool rdb_enabled: Sets whether RDB is enabled.
        :param str rdb_frequency: Sets the frequency at which a snapshot of the database is created.
        """
        if aof_enabled is not None:
            pulumi.set(__self__, "aof_enabled", aof_enabled)
        if aof_frequency is not None:
            pulumi.set(__self__, "aof_frequency", aof_frequency)
        if rdb_enabled is not None:
            pulumi.set(__self__, "rdb_enabled", rdb_enabled)
        if rdb_frequency is not None:
            pulumi.set(__self__, "rdb_frequency", rdb_frequency)

    @property
    @pulumi.getter(name="aofEnabled")
    def aof_enabled(self) -> Optional[bool]:
        """
        Sets whether AOF is enabled.
        """
        return pulumi.get(self, "aof_enabled")

    @property
    @pulumi.getter(name="aofFrequency")
    def aof_frequency(self) -> Optional[str]:
        """
        Sets the frequency at which data is written to disk.
        """
        return pulumi.get(self, "aof_frequency")

    @property
    @pulumi.getter(name="rdbEnabled")
    def rdb_enabled(self) -> Optional[bool]:
        """
        Sets whether RDB is enabled.
        """
        return pulumi.get(self, "rdb_enabled")

    @property
    @pulumi.getter(name="rdbFrequency")
    def rdb_frequency(self) -> Optional[str]:
        """
        Sets the frequency at which a snapshot of the database is created.
        """
        return pulumi.get(self, "rdb_frequency")


@pulumi.output_type
class PrivateEndpointConnectionResponse(dict):
    """
    The Private Endpoint Connection resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateLinkServiceConnectionState":
            suggest = "private_link_service_connection_state"
        elif key == "provisioningState":
            suggest = "provisioning_state"
        elif key == "systemData":
            suggest = "system_data"
        elif key == "privateEndpoint":
            suggest = "private_endpoint"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateEndpointConnectionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateEndpointConnectionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateEndpointConnectionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 name: str,
                 private_link_service_connection_state: 'outputs.PrivateLinkServiceConnectionStateResponse',
                 provisioning_state: str,
                 system_data: 'outputs.SystemDataResponse',
                 type: str,
                 private_endpoint: Optional['outputs.PrivateEndpointResponse'] = None):
        """
        The Private Endpoint Connection resource.
        :param str id: Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
        :param str name: The name of the resource
        :param 'PrivateLinkServiceConnectionStateResponse' private_link_service_connection_state: A collection of information about the state of the connection between service consumer and provider.
        :param str provisioning_state: The provisioning state of the private endpoint connection resource.
        :param 'SystemDataResponse' system_data: Azure Resource Manager metadata containing createdBy and modifiedBy information.
        :param str type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
        :param 'PrivateEndpointResponse' private_endpoint: The resource of private end point.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "private_link_service_connection_state", private_link_service_connection_state)
        pulumi.set(__self__, "provisioning_state", provisioning_state)
        pulumi.set(__self__, "system_data", system_data)
        pulumi.set(__self__, "type", type)
        if private_endpoint is not None:
            pulumi.set(__self__, "private_endpoint", private_endpoint)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="privateLinkServiceConnectionState")
    def private_link_service_connection_state(self) -> 'outputs.PrivateLinkServiceConnectionStateResponse':
        """
        A collection of information about the state of the connection between service consumer and provider.
        """
        return pulumi.get(self, "private_link_service_connection_state")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> str:
        """
        The provisioning state of the private endpoint connection resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter(name="systemData")
    def system_data(self) -> 'outputs.SystemDataResponse':
        """
        Azure Resource Manager metadata containing createdBy and modifiedBy information.
        """
        return pulumi.get(self, "system_data")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="privateEndpoint")
    def private_endpoint(self) -> Optional['outputs.PrivateEndpointResponse']:
        """
        The resource of private end point.
        """
        return pulumi.get(self, "private_endpoint")


@pulumi.output_type
class PrivateEndpointResponse(dict):
    """
    The Private Endpoint resource.
    """
    def __init__(__self__, *,
                 id: str):
        """
        The Private Endpoint resource.
        :param str id: The ARM identifier for Private Endpoint
        """
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ARM identifier for Private Endpoint
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class PrivateLinkServiceConnectionStateResponse(dict):
    """
    A collection of information about the state of the connection between service consumer and provider.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "actionsRequired":
            suggest = "actions_required"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateLinkServiceConnectionStateResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateLinkServiceConnectionStateResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateLinkServiceConnectionStateResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 actions_required: Optional[str] = None,
                 description: Optional[str] = None,
                 status: Optional[str] = None):
        """
        A collection of information about the state of the connection between service consumer and provider.
        :param str actions_required: A message indicating if changes on the service provider require any updates on the consumer.
        :param str description: The reason for approval/rejection of the connection.
        :param str status: Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
        """
        if actions_required is not None:
            pulumi.set(__self__, "actions_required", actions_required)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="actionsRequired")
    def actions_required(self) -> Optional[str]:
        """
        A message indicating if changes on the service provider require any updates on the consumer.
        """
        return pulumi.get(self, "actions_required")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The reason for approval/rejection of the connection.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class SystemDataResponse(dict):
    """
    Metadata pertaining to creation and last modification of the resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "createdBy":
            suggest = "created_by"
        elif key == "createdByType":
            suggest = "created_by_type"
        elif key == "lastModifiedAt":
            suggest = "last_modified_at"
        elif key == "lastModifiedBy":
            suggest = "last_modified_by"
        elif key == "lastModifiedByType":
            suggest = "last_modified_by_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SystemDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SystemDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: Optional[str] = None,
                 created_by: Optional[str] = None,
                 created_by_type: Optional[str] = None,
                 last_modified_at: Optional[str] = None,
                 last_modified_by: Optional[str] = None,
                 last_modified_by_type: Optional[str] = None):
        """
        Metadata pertaining to creation and last modification of the resource.
        :param str created_at: The timestamp of resource creation (UTC).
        :param str created_by: The identity that created the resource.
        :param str created_by_type: The type of identity that created the resource.
        :param str last_modified_at: The timestamp of resource last modification (UTC)
        :param str last_modified_by: The identity that last modified the resource.
        :param str last_modified_by_type: The type of identity that last modified the resource.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_by_type is not None:
            pulumi.set(__self__, "created_by_type", created_by_type)
        if last_modified_at is not None:
            pulumi.set(__self__, "last_modified_at", last_modified_at)
        if last_modified_by is not None:
            pulumi.set(__self__, "last_modified_by", last_modified_by)
        if last_modified_by_type is not None:
            pulumi.set(__self__, "last_modified_by_type", last_modified_by_type)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The timestamp of resource creation (UTC).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[str]:
        """
        The identity that created the resource.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="createdByType")
    def created_by_type(self) -> Optional[str]:
        """
        The type of identity that created the resource.
        """
        return pulumi.get(self, "created_by_type")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> Optional[str]:
        """
        The timestamp of resource last modification (UTC)
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> Optional[str]:
        """
        The identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by")

    @property
    @pulumi.getter(name="lastModifiedByType")
    def last_modified_by_type(self) -> Optional[str]:
        """
        The type of identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by_type")


@pulumi.output_type
class UserAssignedIdentityResponse(dict):
    """
    User assigned identity properties
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "principalId":
            suggest = "principal_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserAssignedIdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserAssignedIdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserAssignedIdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: str,
                 principal_id: str):
        """
        User assigned identity properties
        :param str client_id: The client ID of the assigned identity.
        :param str principal_id: The principal ID of the assigned identity.
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "principal_id", principal_id)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> str:
        """
        The client ID of the assigned identity.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> str:
        """
        The principal ID of the assigned identity.
        """
        return pulumi.get(self, "principal_id")


