# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = ['ArcSettingArgs', 'ArcSetting']

@pulumi.input_type
class ArcSettingArgs:
    def __init__(__self__, *,
                 cluster_name: pulumi.Input[str],
                 resource_group_name: pulumi.Input[str],
                 arc_application_client_id: Optional[pulumi.Input[str]] = None,
                 arc_application_object_id: Optional[pulumi.Input[str]] = None,
                 arc_application_tenant_id: Optional[pulumi.Input[str]] = None,
                 arc_instance_resource_group: Optional[pulumi.Input[str]] = None,
                 arc_service_principal_object_id: Optional[pulumi.Input[str]] = None,
                 arc_setting_name: Optional[pulumi.Input[str]] = None,
                 created_at: Optional[pulumi.Input[str]] = None,
                 created_by: Optional[pulumi.Input[str]] = None,
                 created_by_type: Optional[pulumi.Input[Union[str, 'CreatedByType']]] = None,
                 last_modified_at: Optional[pulumi.Input[str]] = None,
                 last_modified_by: Optional[pulumi.Input[str]] = None,
                 last_modified_by_type: Optional[pulumi.Input[Union[str, 'CreatedByType']]] = None):
        """
        The set of arguments for constructing a ArcSetting resource.
        :param pulumi.Input[str] cluster_name: The name of the cluster.
        :param pulumi.Input[str] resource_group_name: The name of the resource group. The name is case insensitive.
        :param pulumi.Input[str] arc_application_client_id: App id of arc AAD identity.
        :param pulumi.Input[str] arc_application_object_id: Object id of arc AAD identity.
        :param pulumi.Input[str] arc_application_tenant_id: Tenant id of arc AAD identity.
        :param pulumi.Input[str] arc_instance_resource_group: The resource group that hosts the Arc agents, ie. Hybrid Compute Machine resources.
        :param pulumi.Input[str] arc_service_principal_object_id: Object id of arc AAD service principal.
        :param pulumi.Input[str] arc_setting_name: The name of the proxy resource holding details of HCI ArcSetting information.
        :param pulumi.Input[str] created_at: The timestamp of resource creation (UTC).
        :param pulumi.Input[str] created_by: The identity that created the resource.
        :param pulumi.Input[Union[str, 'CreatedByType']] created_by_type: The type of identity that created the resource.
        :param pulumi.Input[str] last_modified_at: The timestamp of resource last modification (UTC)
        :param pulumi.Input[str] last_modified_by: The identity that last modified the resource.
        :param pulumi.Input[Union[str, 'CreatedByType']] last_modified_by_type: The type of identity that last modified the resource.
        """
        pulumi.set(__self__, "cluster_name", cluster_name)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if arc_application_client_id is not None:
            pulumi.set(__self__, "arc_application_client_id", arc_application_client_id)
        if arc_application_object_id is not None:
            pulumi.set(__self__, "arc_application_object_id", arc_application_object_id)
        if arc_application_tenant_id is not None:
            pulumi.set(__self__, "arc_application_tenant_id", arc_application_tenant_id)
        if arc_instance_resource_group is not None:
            pulumi.set(__self__, "arc_instance_resource_group", arc_instance_resource_group)
        if arc_service_principal_object_id is not None:
            pulumi.set(__self__, "arc_service_principal_object_id", arc_service_principal_object_id)
        if arc_setting_name is not None:
            pulumi.set(__self__, "arc_setting_name", arc_setting_name)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if created_by_type is not None:
            pulumi.set(__self__, "created_by_type", created_by_type)
        if last_modified_at is not None:
            pulumi.set(__self__, "last_modified_at", last_modified_at)
        if last_modified_by is not None:
            pulumi.set(__self__, "last_modified_by", last_modified_by)
        if last_modified_by_type is not None:
            pulumi.set(__self__, "last_modified_by_type", last_modified_by_type)

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> pulumi.Input[str]:
        """
        The name of the cluster.
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "cluster_name", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[str]:
        """
        The name of the resource group. The name is case insensitive.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="arcApplicationClientId")
    def arc_application_client_id(self) -> Optional[pulumi.Input[str]]:
        """
        App id of arc AAD identity.
        """
        return pulumi.get(self, "arc_application_client_id")

    @arc_application_client_id.setter
    def arc_application_client_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arc_application_client_id", value)

    @property
    @pulumi.getter(name="arcApplicationObjectId")
    def arc_application_object_id(self) -> Optional[pulumi.Input[str]]:
        """
        Object id of arc AAD identity.
        """
        return pulumi.get(self, "arc_application_object_id")

    @arc_application_object_id.setter
    def arc_application_object_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arc_application_object_id", value)

    @property
    @pulumi.getter(name="arcApplicationTenantId")
    def arc_application_tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        Tenant id of arc AAD identity.
        """
        return pulumi.get(self, "arc_application_tenant_id")

    @arc_application_tenant_id.setter
    def arc_application_tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arc_application_tenant_id", value)

    @property
    @pulumi.getter(name="arcInstanceResourceGroup")
    def arc_instance_resource_group(self) -> Optional[pulumi.Input[str]]:
        """
        The resource group that hosts the Arc agents, ie. Hybrid Compute Machine resources.
        """
        return pulumi.get(self, "arc_instance_resource_group")

    @arc_instance_resource_group.setter
    def arc_instance_resource_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arc_instance_resource_group", value)

    @property
    @pulumi.getter(name="arcServicePrincipalObjectId")
    def arc_service_principal_object_id(self) -> Optional[pulumi.Input[str]]:
        """
        Object id of arc AAD service principal.
        """
        return pulumi.get(self, "arc_service_principal_object_id")

    @arc_service_principal_object_id.setter
    def arc_service_principal_object_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arc_service_principal_object_id", value)

    @property
    @pulumi.getter(name="arcSettingName")
    def arc_setting_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the proxy resource holding details of HCI ArcSetting information.
        """
        return pulumi.get(self, "arc_setting_name")

    @arc_setting_name.setter
    def arc_setting_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arc_setting_name", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[str]]:
        """
        The timestamp of resource creation (UTC).
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[pulumi.Input[str]]:
        """
        The identity that created the resource.
        """
        return pulumi.get(self, "created_by")

    @created_by.setter
    def created_by(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_by", value)

    @property
    @pulumi.getter(name="createdByType")
    def created_by_type(self) -> Optional[pulumi.Input[Union[str, 'CreatedByType']]]:
        """
        The type of identity that created the resource.
        """
        return pulumi.get(self, "created_by_type")

    @created_by_type.setter
    def created_by_type(self, value: Optional[pulumi.Input[Union[str, 'CreatedByType']]]):
        pulumi.set(self, "created_by_type", value)

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> Optional[pulumi.Input[str]]:
        """
        The timestamp of resource last modification (UTC)
        """
        return pulumi.get(self, "last_modified_at")

    @last_modified_at.setter
    def last_modified_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_modified_at", value)

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> Optional[pulumi.Input[str]]:
        """
        The identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by")

    @last_modified_by.setter
    def last_modified_by(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_modified_by", value)

    @property
    @pulumi.getter(name="lastModifiedByType")
    def last_modified_by_type(self) -> Optional[pulumi.Input[Union[str, 'CreatedByType']]]:
        """
        The type of identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by_type")

    @last_modified_by_type.setter
    def last_modified_by_type(self, value: Optional[pulumi.Input[Union[str, 'CreatedByType']]]):
        pulumi.set(self, "last_modified_by_type", value)


class ArcSetting(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 arc_application_client_id: Optional[pulumi.Input[str]] = None,
                 arc_application_object_id: Optional[pulumi.Input[str]] = None,
                 arc_application_tenant_id: Optional[pulumi.Input[str]] = None,
                 arc_instance_resource_group: Optional[pulumi.Input[str]] = None,
                 arc_service_principal_object_id: Optional[pulumi.Input[str]] = None,
                 arc_setting_name: Optional[pulumi.Input[str]] = None,
                 cluster_name: Optional[pulumi.Input[str]] = None,
                 created_at: Optional[pulumi.Input[str]] = None,
                 created_by: Optional[pulumi.Input[str]] = None,
                 created_by_type: Optional[pulumi.Input[Union[str, 'CreatedByType']]] = None,
                 last_modified_at: Optional[pulumi.Input[str]] = None,
                 last_modified_by: Optional[pulumi.Input[str]] = None,
                 last_modified_by_type: Optional[pulumi.Input[Union[str, 'CreatedByType']]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ArcSetting details.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] arc_application_client_id: App id of arc AAD identity.
        :param pulumi.Input[str] arc_application_object_id: Object id of arc AAD identity.
        :param pulumi.Input[str] arc_application_tenant_id: Tenant id of arc AAD identity.
        :param pulumi.Input[str] arc_instance_resource_group: The resource group that hosts the Arc agents, ie. Hybrid Compute Machine resources.
        :param pulumi.Input[str] arc_service_principal_object_id: Object id of arc AAD service principal.
        :param pulumi.Input[str] arc_setting_name: The name of the proxy resource holding details of HCI ArcSetting information.
        :param pulumi.Input[str] cluster_name: The name of the cluster.
        :param pulumi.Input[str] created_at: The timestamp of resource creation (UTC).
        :param pulumi.Input[str] created_by: The identity that created the resource.
        :param pulumi.Input[Union[str, 'CreatedByType']] created_by_type: The type of identity that created the resource.
        :param pulumi.Input[str] last_modified_at: The timestamp of resource last modification (UTC)
        :param pulumi.Input[str] last_modified_by: The identity that last modified the resource.
        :param pulumi.Input[Union[str, 'CreatedByType']] last_modified_by_type: The type of identity that last modified the resource.
        :param pulumi.Input[str] resource_group_name: The name of the resource group. The name is case insensitive.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ArcSettingArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ArcSetting details.

        :param str resource_name: The name of the resource.
        :param ArcSettingArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ArcSettingArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 arc_application_client_id: Optional[pulumi.Input[str]] = None,
                 arc_application_object_id: Optional[pulumi.Input[str]] = None,
                 arc_application_tenant_id: Optional[pulumi.Input[str]] = None,
                 arc_instance_resource_group: Optional[pulumi.Input[str]] = None,
                 arc_service_principal_object_id: Optional[pulumi.Input[str]] = None,
                 arc_setting_name: Optional[pulumi.Input[str]] = None,
                 cluster_name: Optional[pulumi.Input[str]] = None,
                 created_at: Optional[pulumi.Input[str]] = None,
                 created_by: Optional[pulumi.Input[str]] = None,
                 created_by_type: Optional[pulumi.Input[Union[str, 'CreatedByType']]] = None,
                 last_modified_at: Optional[pulumi.Input[str]] = None,
                 last_modified_by: Optional[pulumi.Input[str]] = None,
                 last_modified_by_type: Optional[pulumi.Input[Union[str, 'CreatedByType']]] = None,
                 resource_group_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ArcSettingArgs.__new__(ArcSettingArgs)

            __props__.__dict__["arc_application_client_id"] = arc_application_client_id
            __props__.__dict__["arc_application_object_id"] = arc_application_object_id
            __props__.__dict__["arc_application_tenant_id"] = arc_application_tenant_id
            __props__.__dict__["arc_instance_resource_group"] = arc_instance_resource_group
            __props__.__dict__["arc_service_principal_object_id"] = arc_service_principal_object_id
            __props__.__dict__["arc_setting_name"] = arc_setting_name
            if cluster_name is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_name'")
            __props__.__dict__["cluster_name"] = cluster_name
            __props__.__dict__["created_at"] = created_at
            __props__.__dict__["created_by"] = created_by
            __props__.__dict__["created_by_type"] = created_by_type
            __props__.__dict__["last_modified_at"] = last_modified_at
            __props__.__dict__["last_modified_by"] = last_modified_by
            __props__.__dict__["last_modified_by_type"] = last_modified_by_type
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["aggregate_state"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["per_node_details"] = None
            __props__.__dict__["provisioning_state"] = None
            __props__.__dict__["type"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="azure-native:azurestackhci:ArcSetting"), pulumi.Alias(type_="azure-native:azurestackhci/v20210101preview:ArcSetting"), pulumi.Alias(type_="azure-native:azurestackhci/v20210901:ArcSetting"), pulumi.Alias(type_="azure-native:azurestackhci/v20210901preview:ArcSetting"), pulumi.Alias(type_="azure-native:azurestackhci/v20220101:ArcSetting"), pulumi.Alias(type_="azure-native:azurestackhci/v20220501:ArcSetting"), pulumi.Alias(type_="azure-native:azurestackhci/v20220901:ArcSetting"), pulumi.Alias(type_="azure-native:azurestackhci/v20221001:ArcSetting"), pulumi.Alias(type_="azure-native:azurestackhci/v20221201:ArcSetting"), pulumi.Alias(type_="azure-native:azurestackhci/v20230201:ArcSetting")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(ArcSetting, __self__).__init__(
            'azure-native:azurestackhci/v20220301:ArcSetting',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'ArcSetting':
        """
        Get an existing ArcSetting resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ArcSettingArgs.__new__(ArcSettingArgs)

        __props__.__dict__["aggregate_state"] = None
        __props__.__dict__["arc_application_client_id"] = None
        __props__.__dict__["arc_application_object_id"] = None
        __props__.__dict__["arc_application_tenant_id"] = None
        __props__.__dict__["arc_instance_resource_group"] = None
        __props__.__dict__["arc_service_principal_object_id"] = None
        __props__.__dict__["created_at"] = None
        __props__.__dict__["created_by"] = None
        __props__.__dict__["created_by_type"] = None
        __props__.__dict__["last_modified_at"] = None
        __props__.__dict__["last_modified_by"] = None
        __props__.__dict__["last_modified_by_type"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["per_node_details"] = None
        __props__.__dict__["provisioning_state"] = None
        __props__.__dict__["type"] = None
        return ArcSetting(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="aggregateState")
    def aggregate_state(self) -> pulumi.Output[str]:
        """
        Aggregate state of Arc agent across the nodes in this HCI cluster.
        """
        return pulumi.get(self, "aggregate_state")

    @property
    @pulumi.getter(name="arcApplicationClientId")
    def arc_application_client_id(self) -> pulumi.Output[Optional[str]]:
        """
        App id of arc AAD identity.
        """
        return pulumi.get(self, "arc_application_client_id")

    @property
    @pulumi.getter(name="arcApplicationObjectId")
    def arc_application_object_id(self) -> pulumi.Output[Optional[str]]:
        """
        Object id of arc AAD identity.
        """
        return pulumi.get(self, "arc_application_object_id")

    @property
    @pulumi.getter(name="arcApplicationTenantId")
    def arc_application_tenant_id(self) -> pulumi.Output[Optional[str]]:
        """
        Tenant id of arc AAD identity.
        """
        return pulumi.get(self, "arc_application_tenant_id")

    @property
    @pulumi.getter(name="arcInstanceResourceGroup")
    def arc_instance_resource_group(self) -> pulumi.Output[Optional[str]]:
        """
        The resource group that hosts the Arc agents, ie. Hybrid Compute Machine resources.
        """
        return pulumi.get(self, "arc_instance_resource_group")

    @property
    @pulumi.getter(name="arcServicePrincipalObjectId")
    def arc_service_principal_object_id(self) -> pulumi.Output[Optional[str]]:
        """
        Object id of arc AAD service principal.
        """
        return pulumi.get(self, "arc_service_principal_object_id")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[Optional[str]]:
        """
        The timestamp of resource creation (UTC).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> pulumi.Output[Optional[str]]:
        """
        The identity that created the resource.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="createdByType")
    def created_by_type(self) -> pulumi.Output[Optional[str]]:
        """
        The type of identity that created the resource.
        """
        return pulumi.get(self, "created_by_type")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> pulumi.Output[Optional[str]]:
        """
        The timestamp of resource last modification (UTC)
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter(name="lastModifiedBy")
    def last_modified_by(self) -> pulumi.Output[Optional[str]]:
        """
        The identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by")

    @property
    @pulumi.getter(name="lastModifiedByType")
    def last_modified_by_type(self) -> pulumi.Output[Optional[str]]:
        """
        The type of identity that last modified the resource.
        """
        return pulumi.get(self, "last_modified_by_type")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="perNodeDetails")
    def per_node_details(self) -> pulumi.Output[Sequence['outputs.PerNodeStateResponse']]:
        """
        State of Arc agent in each of the nodes.
        """
        return pulumi.get(self, "per_node_details")

    @property
    @pulumi.getter(name="provisioningState")
    def provisioning_state(self) -> pulumi.Output[str]:
        """
        Provisioning state of the ArcSetting proxy resource.
        """
        return pulumi.get(self, "provisioning_state")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
        """
        return pulumi.get(self, "type")

